<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| Base Site URL
|--------------------------------------------------------------------------
|
| URL to your CodeIgniter root. Typically this will be your base URL,
| WITH a trailing slash:
|
|	http://example.com/
|
| WARNING: You MUST set this value!
|
| If it is not set, then CodeIgniter will try guess the protocol and path
| your installation, but due to security concerns the hostname will be set
| to $_SERVER['SERVER_ADDR'] if available, or localhost otherwise.
| The auto-detection mechanism exists only for convenience during
| development and MUST NOT be used in production!
|
| If you need to allow multiple domains, remember that this file is still
| a PHP script and you can easily do that on your own.
|
*/
if(isset($_SERVER['HTTP_HOST']))
{
    $config['base_url'] = isset($_SERVER['HTTPS']) && strtolower($_SERVER['HTTPS']) == 'on' ? 'https' : 'http';
    $config['base_url'] .= '://'. $_SERVER['HTTP_HOST'];
    $config['base_url'] .= str_replace(basename($_SERVER['SCRIPT_NAME']), '', $_SERVER['SCRIPT_NAME']);
}
$config['table_prefix'] = 'dcode_';

define('FIELD_PREFIX','field_');
define ( 'DB_PREFIX', 'dcode_');
define('PRESALE_PREFIX','PS');
define('ORDER_PREFIX','D');
define('APPLICATIONCONFIG', 'app_config');

/*
|--------------------------------------------------------------------------
| Index File
|--------------------------------------------------------------------------
|
| Typically this will be your index.php file, unless you've renamed it to
| something else. If you are using mod_rewrite to remove the page set this
| variable so that it is blank.
|
*/
$config['index_page'] = '';

/*
|--------------------------------------------------------------------------
| URI PROTOCOL
|--------------------------------------------------------------------------
|
| This item determines which server global should be used to retrieve the
| URI string.  The default setting of 'REQUEST_URI' works for most servers.
| If your links do not seem to work, try one of the other delicious flavors:
|
| 'REQUEST_URI'    Uses $_SERVER['REQUEST_URI']
| 'QUERY_STRING'   Uses $_SERVER['QUERY_STRING']
| 'PATH_INFO'      Uses $_SERVER['PATH_INFO']
|
| WARNING: If you set this to 'PATH_INFO', URIs will always be URL-decoded!
*/
$config['uri_protocol']	= 'REQUEST_URI';

/*
|--------------------------------------------------------------------------
| URL suffix
|--------------------------------------------------------------------------
|
| This option allows you to add a suffix to all URLs generated by CodeIgniter.
| For more information please see the user guide:
|
| https://codeigniter.com/user_guide/general/urls.html
*/
$config['url_suffix'] = '';

/*
|--------------------------------------------------------------------------
| Default Language
|--------------------------------------------------------------------------
|
| This determines which set of language files should be used. Make sure
| there is an available translation if you intend to use something other
| than english.
|
*/
$config['language']	= 'english';
$config['RESOURCE_LIST'] = array(''=>"select",'University'=>"University",'Police_Station'=>"Police Station",'Board'=>"Board",
                                 'Languages'=>"Languages", 'College'=>"College");
$config['LANGUAGE_LIST'] = array(''=>'Select','english'=>'English','hindi'=>'Hindi');
$config['MASTER_KEY'] = array(''=>"Select",'address_proof_type' => 'Address Proof Type','billing_term' => 'Billing Term','Board'=>"Board",'Check'=>'Check','College'=>"College",'contact_for' => 'Contact for','credit_limit' => 'Credit Limit','department' => 'Department','designation'=>'Designation','Digital On boarding Facilities' => 'Digital On-boarding Facilities','Education' => 'Education','Gender' => 'Gender','groupname' =>'Group Name','Lead Source'=> 'Lead Source','Languages'=>"Languages",'level'=>'Level','limit' => 'Limit','Martial Status' => 'Martial Status','Occupation' => 'Occupation','Per Annum Cost'=>'Per Annum Cost','Police_Station'=>"Police Station",'package'=>'Packages','status'=>'Status','University'=>"University",'Industry'=>'Industry','Revert_reason'=>'Revert Reason','billing_type'=>'Billing Type','expences'=>'Expenses','discrepancy_parameters'=>'Discrepancy Parameters','experience_year'=>'Experience Year','institutions'=>'Institutions','type_of_employees'=>'Type of Employees','vm_revert_reason' => 'Vm Revert Reason');

$config['MASTER_KEY'] = array_merge($config['MASTER_KEY']);
$config['DATAENTRY_BY'] = array(''=>'Select','1'=>'Partial Data Entry','2'=>'Full Data Entry');
$config['Admin_email']= array('arvind@dcoderesearch.com','murali.va@dcoderesearch.com' );
$config['Checkdata_fields']=array('high_court_record' , 'supreme_court_record' ,  'central_bureau' ,  'central_vigilance' ,  'most_wanted' ,  'labour_service' ,  'consumer_protection' ,  'environmental_protection' ,  'arbitration' ,  'direct_taxes' ,  'excise_customs' ,  'company_law' ,  'sales_tax' ,  'securities_exchange' ,  'bombay_stock_exchange' ,  'department_of_company' ,  'indian_prosecuted' ,  'bankruptcy_check' ,  'india_specific_internet' ,  'nature_work' ,  'meeting_obj',  'work_pressure',  'people_skill',  'social_skill',  'comm_skill',  'prof_strength',  'prof_weak',  'person_prob',  'attend_punct',  'job_perform',  'honesty',  'reliability',  'commitment',  'reason_leaving',  'notice_bfr_leave',  'rehire',  'perform_rating' ,  'us_and_canada' ,  'boston_police' ,  'usa_bureau_of_alcohol' ,  'city_of_south_portland' ,  'usa_delaware' ,  'usa_illinois' ,  'usa_drug_enforcement' ,  'fbi_most_wanted' ,  'fbi_usa' ,  'fort_lauderdale_police' ,  'honolulu_police' ,  'international_broadcasting_bureau' ,  'kbi' ,  'new_jersey_division' ,  'usa_massachusetts' ,  'usa_michigan' ,  'usa_mississippi_department' ,  'usa_monterey_county' ,  'usa_montgomery_county' ,  'usa_new_jersey' ,  'usa_office_of_new_york' ,  'usa_oregon_department' ,  'usa_rhode_island' ,  'usa_san_diego' ,  'usa_scarborough' ,  'usa_state_of_minnesota' ,  'usa_tennessee_bureau' ,  'usa_texas' ,  'usa_the_los_angeles' ,  'usa_the_yonkers' ,  'usa_immigration' ,  'usa_secret_service' ,  'usa_ulster_county' ,  'usa_department_of_justice' ,  'usa_marshals_service' ,  'usa_naval_criminal_investigative' ,  'usa_postal_inspection' ,  'usa_virginia_state' ,  'usa_washtenaw_county' ,  'usa_west_virginia' ,  'usa_wichita_police' ,  'usa_winchester' ,  'canada_royal_canadian_mounted' ,  'canada_abbotsford_police' ,  'canada_halifax_regional' ,  'canada_hamilton_police' ,  'canada_waterloo_regional' ,  'canada_ontario_provincial' ,  'canada_the_peel_regional' ,  'europe_central_asia' ,  'international_police_cooperation_greece' ,  'holland_police' ,  'swiss_police' ,  'uk_proscribed_organizations' ,  'uk_scotland_yards' ,  'uk_the_metropolitan_police' ,  'uk_serious_frauds' ,  'uk_national_crime_squad' ,  'russia_ministry_of_interior' ,  'asia_pacific' ,  'criminal_investigation_bureau_taiwan' ,  'taiwan_bureau_of_investigation' ,  'uae_dubai_police' ,  'hong_kong_independent_commission_against_corruption' ,  'new_zealand_police' ,  'philippines_bureau_of_investigation' ,  'philippine_national_police' ,  'singapore_central_narcotics_bureau' ,  'australia_queensland_police_service' ,  'africa_most_wanted_lists' ,  'south_african_police_service' ,  'compliance_databases' ,  'office_of_foreign_assets_control' ,  'united_nations_consolidated_list' ,  'european_union_terrorist_list' ,  'monetary_authority_of_singapore' ,  'hong_kong_monetary_authority' ,  'australian_department_of_foreign_affairs_and_trade' ,  'australian_transaction_reports_and_analysis_centre' ,  'reserve_bank_and_australia' ,  'uae_central_bank' ,  'canada_osfi_consolidated_list' ,  'global' ,  'bureau_of_industry_and_security' ,  'world_bank_debarred_parties' ,  'defense_and_trade_controls' ,  'us_and_canada' ,  'american_stock_exchange' ,  'usa_commodities_and_futures_trading_commission' ,  'usa_excluded_parties_list_system' ,  'usa_federal_deposit_and_insurance_corporation' ,  'usa_federal_reserve_board' ,  'usa_financial_crimes_enforcement_network' ,  'usa_hhs_office_of_inspector_general' ,  'usa_national_association_of_securities_dealers' ,  'usa_national_credit_union_association' ,  'usa_new_york_stock_exchange' ,  'usa_office_comptroller_of_currency' ,  'usa_office_of_thrift_supervision' ,  'usa_oregon_department_of_consumer_business_services' ,  'usa_the_illinois_office_of_banks_and_real_estate' ,  'usa_securities_and_exchange_commission' ,  'canada_alberta_securities_commission' ,  'usa_new_york_state_insurance_department' ,  'canada_british_columbia_securities_commission' ,  'canada_investment_dealers_association_of_canada' ,  'canada_office_of_superintendents_of_financial_institutions' ,  'canada_ontario_securities_commission' ,  'canada_toronto_stock_exchange' ,  'canada_revenue_agency' ,  'us_food_and_drug_administration' ,  'cayman_islands_monetary_authority' ,  'central_bank_of_bahamas' ,  'europe_regulatory_bodies' ,  'uk_companies_house' ,  'uk_financial_services_authority' ,  'uk_lloyds_of_londaon' ,  'uk_financial_services_compensation_scheme' ,  'uk_assets_recovery_agency' ,  'uk_securities_and_futures_authority' ,  'uk_charity_commission_for_england_and_wales' ,  'uk_hm_customs_and_excise' ,  'netherlands_authority_for_the_financial_markets' ,  'ireland_office_of_the_director_of_corporate_enforcement' ,  'the_irish_financial_services_regulatory_authority' ,  'the_financial_supervision_commission_isle_of_man' ,  'jersey_financial_securities_commission' ,  'asia_pacific_regulatory_bodies' ,  'australian_stock_exchang' ,  'hong_kong_securities_and_future_commission' ,  'hong_kong_monetary_authority_warnings' ,  'independent_commission_against_corruption_hong_kong' ,  'securities_exchange_board_of_india' ,  'japan_securities_and_exchange_surveillance_commission' ,  'malaysia_securities_commission' ,  'new_zealand_companies_house' ,  'new_zealand_securities_commission' ,  'new_zealand_serious_fraud_office' ,  'pakistan_securities_exchange_commission' ,  'singapore_stock_exchange' ,  'singapore_monetary_authority_of_singapore_investors' ,  'thailand_securities_and_exchange_commission' ,  'internet_searches' , 'politically_exposed_person_list', 'designation' ,  'exit_formality' ,  'credit_score' ,  'assessment_year' ,  'interpol_most_wanted','denied_persons_list','entity_list','european_union_sanctions','united_nations_sanctions','netherland_national_terrorism_transactions','us_country_sanctions','former_iran_sanctioned_entity','iran_threat_reduction','embargoed_country_aircraft','us_treasury_us_patriot_act','dept_health_humanservice','us_general_service','us_drug_enforcement','public_health_service','us_food_drug_adm','tricare','state_commonwealth_territory','medicare','annexures_attached','verification_details');
/*
|--------------------------------------------------------------------------
| Default Character Set
|--------------------------------------------------------------------------
|
| This determines which character set is used by default in various methods
| that require a character set to be provided.
|
| See http://php.net/htmlspecialchars for a list of supported charsets.
|
*/
$config['charset'] = 'UTF-8';

/*
|--------------------------------------------------------------------------
| Enable/Disable System Hooks
|--------------------------------------------------------------------------
|
| If you would like to use the 'hooks' feature you must enable it by
| setting this variable to TRUE (boolean).  See the user guide for details.
|
*/
$config['enable_hooks'] = FALSE;

/*
|--------------------------------------------------------------------------
| Class Extension Prefix
|--------------------------------------------------------------------------
|
| This item allows you to set the filename/classname prefix when extending
| native libraries.  For more information please see the user guide:
|
| https://codeigniter.com/user_guide/general/core_classes.html
| https://codeigniter.com/user_guide/general/creating_libraries.html
|
*/
$config['subclass_prefix'] = 'MY_';

/*
|--------------------------------------------------------------------------
| Composer auto-loading
|--------------------------------------------------------------------------
|
| Enabling this setting will tell CodeIgniter to look for a Composer
| package auto-loader script in application/vendor/autoload.php.
|
|	$config['composer_autoload'] = TRUE;
|
| Or if you have your vendor/ directory located somewhere else, you
| can opt to set a specific path as well:
|
|	$config['composer_autoload'] = '/path/to/vendor/autoload.php';
|
| For more information about Composer, please visit http://getcomposer.org/
|
| Note: This will NOT disable or override the CodeIgniter-specific
|	autoloading (application/config/autoload.php)
*/
$config['composer_autoload'] = FALSE;

/*
|--------------------------------------------------------------------------
| Allowed URL Characters
|--------------------------------------------------------------------------
|
| This lets you specify which characters are permitted within your URLs.
| When someone tries to submit a URL with disallowed characters they will
| get a warning message.
|
| As a security measure you are STRONGLY encouraged to restrict URLs to
| as few characters as possible.  By default only these are allowed: a-z 0-9~%.:_-
|
| Leave blank to allow all characters -- but only if you are insane.
|
| The configured value is actually a regular expression character group
| and it will be executed as: ! preg_match('/^[<permitted_uri_chars>]+$/i
|
| DO NOT CHANGE THIS UNLESS YOU FULLY UNDERSTAND THE REPERCUSSIONS!!
|
*/
$config['permitted_uri_chars'] = 'a-z 0-9~%.:_\-\=@+';

/*
|--------------------------------------------------------------------------
| Enable Query Strings
|--------------------------------------------------------------------------
|
| By default CodeIgniter uses search-engine friendly segment based URLs:
| example.com/who/what/where/
|
| You can optionally enable standard query string based URLs:
| example.com?who=me&what=something&where=here
|
| Options are: TRUE or FALSE (boolean)
|
| The other items let you set the query string 'words' that will
| invoke your controllers and its functions:
| example.com/index.php?c=controller&m=function
|
| Please note that some of the helpers won't work as expected when
| this feature is enabled, since CodeIgniter is designed primarily to
| use segment based URLs.
|
*/
$config['enable_query_strings'] = FALSE;
$config['controller_trigger'] = 'c';
$config['function_trigger'] = 'm';
$config['directory_trigger'] = 'd';

/*
|--------------------------------------------------------------------------
| Allow $_GET array
|--------------------------------------------------------------------------
|
| By default CodeIgniter enables access to the $_GET array.  If for some
| reason you would like to disable it, set 'allow_get_array' to FALSE.
|
| WARNING: This feature is DEPRECATED and currently available only
|          for backwards compatibility purposes!
|
*/
$config['allow_get_array'] = TRUE;

/*
|--------------------------------------------------------------------------
| Error Logging Threshold
|--------------------------------------------------------------------------
|
| You can enable error logging by setting a threshold over zero. The
| threshold determines what gets logged. Threshold options are:
|
|	0 = Disables logging, Error logging TURNED OFF
|	1 = Error Messages (including PHP errors)
|	2 = Debug Messages
|	3 = Informational Messages
|	4 = All Messages
|
| You can also pass an array with threshold levels to show individual error types
|
| 	array(2) = Debug Messages, without Error Messages
|
| For a live site you'll usually only enable Errors (1) to be logged otherwise
| your log files will fill up very fast.
|
*/
$config['log_threshold'] = 1;

/*
|--------------------------------------------------------------------------
| Error Logging Directory Path
|--------------------------------------------------------------------------
|
| Leave this BLANK unless you would like to set something other than the default
| application/logs/ directory. Use a full server path with trailing slash.
|
*/
$config['log_path'] = '';

/*
|--------------------------------------------------------------------------
| Log File Extension
|--------------------------------------------------------------------------
|
| The default filename extension for log files. The default 'php' allows for
| protecting the log files via basic scripting, when they are to be stored
| under a publicly accessible directory.
|
| Note: Leaving it blank will default to 'php'.
|
*/
$config['log_file_extension'] = '';

/*
|--------------------------------------------------------------------------
| Log File Permissions
|--------------------------------------------------------------------------
|
| The file system permissions to be applied on newly created log files.
|
| IMPORTANT: This MUST be an integer (no quotes) and you MUST use octal
|            integer notation (i.e. 0700, 0644, etc.)
*/
$config['log_file_permissions'] = 0644;

/*
|--------------------------------------------------------------------------
| Date Format for Logs
|--------------------------------------------------------------------------
|
| Each item that is logged has an associated date. You can use PHP date
| codes to set your own date formatting
|
*/
$config['log_date_format'] = 'Y-m-d H:i:s';

/*
|--------------------------------------------------------------------------
| Error Views Directory Path
|--------------------------------------------------------------------------
|
| Leave this BLANK unless you would like to set something other than the default
| application/views/errors/ directory.  Use a full server path with trailing slash.
|
*/
$config['error_views_path'] = '';

/*
|--------------------------------------------------------------------------
| Cache Directory Path
|--------------------------------------------------------------------------
|
| Leave this BLANK unless you would like to set something other than the default
| application/cache/ directory.  Use a full server path with trailing slash.
|
*/
$config['cache_path'] = '';

/*
|--------------------------------------------------------------------------
| Cache Include Query String
|--------------------------------------------------------------------------
|
| Whether to take the URL query string into consideration when generating
| output cache files. Valid options are:
|
|	FALSE      = Disabled
|	TRUE       = Enabled, take all query parameters into account.
|	             Please be aware that this may result in numerous cache
|	             files generated for the same page over and over again.
|	array('q') = Enabled, but only take into account the specified list
|	             of query parameters.
|
*/
$config['cache_query_string'] = FALSE;

/*
|--------------------------------------------------------------------------
| Encryption Key
|--------------------------------------------------------------------------
|
| If you use the Encryption class, you must set an encryption key.
| See the user guide for more info.
|
| https://codeigniter.com/user_guide/libraries/encryption.html
|
*/
$config['encryption_key'] = 'EBGDAE';

/*
|--------------------------------------------------------------------------
| Session Variables
|--------------------------------------------------------------------------
|
| 'sess_driver'
|
|	The storage driver to use: files, database, redis, memcached
|
| 'sess_cookie_name'
|
|	The session cookie name, must contain only [0-9a-z_-] characters
|
| 'sess_expiration'
|
|	The number of SECONDS you want the session to last.
|	Setting to 0 (zero) means expire when the browser is closed.
|
| 'sess_save_path'
|
|	The location to save sessions to, driver dependent.
|
|	For the 'files' driver, it's a path to a writable directory.
|	WARNING: Only absolute paths are supported!
|
|	For the 'database' driver, it's a table name.
|	Please read up the manual for the format with other session drivers.
|
|	IMPORTANT: You are REQUIRED to set a valid save path!
|
| 'sess_match_ip'
|
|	Whether to match the user's IP address when reading the session data.
|
|	WARNING: If you're using the database driver, don't forget to update
|	         your session table's PRIMARY KEY when changing this setting.
|
| 'sess_time_to_update'
|
|	How many seconds between CI regenerating the session ID.
|
| 'sess_regenerate_destroy'
|
|	Whether to destroy session data associated with the old session ID
|	when auto-regenerating the session ID. When set to FALSE, the data
|	will be later deleted by the garbage collector.
|
| Other session cookie settings are shared with the rest of the application,
| except for 'cookie_prefix' and 'cookie_httponly', which are ignored here.
|
*/
$config['sess_driver'] = 'files';
$config['sess_cookie_name'] = 'ci_session';
$config['sess_expiration'] = 1800;
$config['sess_save_path'] = NULL;
$config['sess_match_ip'] = FALSE;
$config['sess_time_to_update'] = 300;
$config['sess_regenerate_destroy'] = FALSE;
/*$config['sess_use_database'] = TRUE;
$config['sess_table_name'] = 'ci_sessions';*/

/*
|--------------------------------------------------------------------------
| Cookie Related Variables
|--------------------------------------------------------------------------
|
| 'cookie_prefix'   = Set a cookie name prefix if you need to avoid collisions
| 'cookie_domain'   = Set to .your-domain.com for site-wide cookies
| 'cookie_path'     = Typically will be a forward slash
| 'cookie_secure'   = Cookie will only be set if a secure HTTPS connection exists.
| 'cookie_httponly' = Cookie will only be accessible via HTTP(S) (no javascript)
|
| Note: These settings (with the exception of 'cookie_prefix' and
|       'cookie_httponly') will also affect sessions.
|
*/
$config['cookie_prefix']	= '';
$config['cookie_domain']	= '';
$config['cookie_path']		= '/';
$config['cookie_secure']	= FALSE;
$config['cookie_httponly'] 	= FALSE;

/*
|--------------------------------------------------------------------------
| Standardize newlines
|--------------------------------------------------------------------------
|
| Determines whether to standardize newline characters in input data,
| meaning to replace \r\n, \r, \n occurrences with the PHP_EOL value.
|
| WARNING: This feature is DEPRECATED and currently available only
|          for backwards compatibility purposes!
|
*/
$config['standardize_newlines'] = FALSE;

/*
|--------------------------------------------------------------------------
| Global XSS Filtering
|--------------------------------------------------------------------------
|
| Determines whether the XSS filter is always active when GET, POST or
| COOKIE data is encountered
|
| WARNING: This feature is DEPRECATED and currently available only
|          for backwards compatibility purposes!
|
*/
$config['global_xss_filtering'] = TRUE;

/*
|--------------------------------------------------------------------------
| Cross Site Request Forgery
|--------------------------------------------------------------------------
| Enables a CSRF cookie token to be set. When set to TRUE, token will be
| checked on a submitted form. If you are accepting user data, it is strongly
| recommended CSRF protection be enabled.
|
| 'csrf_token_name' = The token name
| 'csrf_cookie_name' = The cookie name
| 'csrf_expire' = The number in seconds the token should expire.
| 'csrf_regenerate' = Regenerate token on every submission
| 'csrf_exclude_uris' = Array of URIs which ignore CSRF checks
*/
$config['csrf_protection'] = TRUE;
$config['csrf_token_name'] = 'csrf_research';
$config['csrf_cookie_name'] = 'csrf_cookie_name';
$config['csrf_expire'] = 1800;
$config['csrf_regenerate'] = FALSE;
$config['csrf_exclude_uris'] = array();

/*
|--------------------------------------------------------------------------
| Output Compression
|--------------------------------------------------------------------------
|
| Enables Gzip output compression for faster page loads.  When enabled,
| the output class will test whether your server supports Gzip.
| Even if it does, however, not all browsers support compression
| so enable only if you are reasonably sure your visitors can handle it.
|
| Only used if zlib.output_compression is turned off in your php.ini.
| Please do not use it together with httpd-level output compression.
|
| VERY IMPORTANT:  If you are getting a blank page when compression is enabled it
| means you are prematurely outputting something to your browser. It could
| even be a line of whitespace at the end of one of your scripts.  For
| compression to work, nothing can be sent before the output buffer is called
| by the output class.  Do not 'echo' any values with compression enabled.
|
*/
$config['compress_output'] = FALSE;

/*
|--------------------------------------------------------------------------
| Master Time Reference
|--------------------------------------------------------------------------
|
| Options are 'local' or any PHP supported timezone. This preference tells
| the system whether to use your server's local time as the master 'now'
| reference, or convert it to the configured one timezone. See the 'date
| helper' page of the user guide for information regarding date handling.
|
*/
$config['time_reference'] = 'gmt';

/*
|--------------------------------------------------------------------------
| Rewrite PHP Short Tags
|--------------------------------------------------------------------------
|
| If your PHP installation does not have short tag support enabled CI
| can rewrite the tags on-the-fly, enabling you to utilize that syntax
| in your view files.  Options are TRUE or FALSE (boolean)
|
| Note: You need to have eval() enabled for this to work.
|
*/
$config['rewrite_short_tags'] = FALSE;

/*
|--------------------------------------------------------------------------
| Reverse Proxy IPs
|--------------------------------------------------------------------------
|
| If your server is behind a reverse proxy, you must whitelist the proxy
| IP addresses from which CodeIgniter should trust headers such as
| HTTP_X_FORWARDED_FOR and HTTP_CLIENT_IP in order to properly identify
| the visitor's IP address.
|
| You can use both an array or a comma-separated list of proxy addresses,
| as well as specifying whole subnets. Here are a few examples:
|
| Comma-separated:	'10.0.1.200,192.168.5.0/24'
| Array:		array('10.0.1.200', '192.168.5.0/24')
*/
$config['proxy_ips'] = '';


$config['google_secret_key'] =  '6LdgW7AUAAAAACkRsN7KzT6Wqyae1e2ipiKn1iDo'; // change this to yours
$config['google_site_key'] =    '6LdgW7AUAAAAAIhjJvr49_Tc32ERmacwCw1O4VdN'; // change this to yours


$config['doc_file_size']  = "4000000";
$config['doc_message']  = "4 mb";


$config['photo_size'] = "1000000";
$config['photo_message'] = "1 mb";

$config['email'] = '';
$config['des_email'] = array('','');
$config['default_vsmail'] = '';

$config['superadmin'] = '';
