<?php if (!defined('BASEPATH')) 
{
    exit('No direct script access allowed');
}
require_once ('Common.php');
require_once ('./PHPExcel-1.8/Classes/PHPExcel.php'); // Needed for export to xls to work

class Activity extends Common {
    protected $index_dashboard= 'Index/dashboard';

    //constructor
    function __construct() 
    {
        parent::__construct();
        $this->_check_userlogin();
        $models = array('Activity_model'=>'am','Verification_model'=>'vm');
        foreach ($models as $file => $object_name) {
            $this->load->model($file, $object_name);
        }
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','jquery-ui-1.10.4','highcharts','exporting','jquery.validate','grid.locale-en','jquery.jqGrid.min','jquery-ui-1.8.16.custom.min','commonjs'));
        $this->load->helper('text');
    }

    /*****************
    * Active Sheet page
    * activity_sheet
    ******************/
    function activity_sheet() {
        $fromDate=date('d-m-Y');
        $toDate=date('d-m-Y');
        $data['fromDate']=$fromDate;
        $data['toDate']=$toDate;
        // if verification member has logged in
        if($this->session->userdata['role_id']==5){
            $userId=$this->session->userdata['userid'];
        }

        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Activity Sheet', 'Activity/activity_sheet');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'activity_sheet');
    }

    /*****************
    * VM activity page
    * vm_activity
    ******************/    
     // MN changed some  code on 24th, 25th Aug 2022 and 16th Jan '23
    function vm_activity(){

        $title=base64_decode($this->uri->segment(5)); // MN - Changed from  4 to 5
        if($title=='Initiated'){
            $Newtitle='Initiated';
        }
        else if($title=='Verified'){
            $Newtitle='Verified';
        }
        else if($title=='QCRevertClosed'){
            $Newtitle='QC Revert Closed';
        }
        else if($title=='Reminder'){
            $Newtitle='Reminder Sent';
        }
        else if($title=='DDApplied'){
            $Newtitle='DD Applied';
        }

        else if($title=='RevertedToDEO'){
            $Newtitle='Reverted To DEO';
        }
        else if($title=='ReOpen'){
            $Newtitle='Re-Open Closed'; // Edited on 16th Jan '23
        }
        else if($title=='RequestRaised'){
            $Newtitle='Request Raised';
        }
        else if($title=='TicketReopen'){
            $Newtitle='Ticket Re-Opened';
        }
        else{
            $Newtitle= 'All Activities'; // MN - For all activities
        }


        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push("VM Activity", 'Activity/new');

        $data['new_title']=$Newtitle;
        $data['breadcrumb']=$this->breadcrumbs->show();  
        $this->amodel->pagerender($data, 'vm_activity');

    }

    /****/
    // MN changed code for including  verify status and check status -> 29th Sep - 30th Sep 2022
    // 16th Jan '23, edited to include reopened others and stop  check in status_updates table.
    function get_activityList()
    {
        $model = array('Activity_model'=>'get_newactivity');

        $check_count = ($_REQUEST['check_count']) ? $_REQUEST['check_count'] : '';
        $userId  = ($_REQUEST['userId']) ? $_REQUEST['userId'] : '0';
        $frmDate = ($_REQUEST['frmDate']) ? $_REQUEST['frmDate'] : '';
        $toDate  = ($_REQUEST['toDate']) ? $_REQUEST['toDate'] : '';
        // Added by MN
        $status  = ($_REQUEST['status']);  //  User active or inactive status

        if($userId==0){
            
        }
        else{
            if($this->session->userdata['role_id']==5){
                $condition[]=" a.user_id = ".$this->session->userdata['userid'];
            }else{
                // code changed by MN on 7th Sep 22 to include more than 1 user id
                $condition[]=" a.user_id IN (".$userId . ")";
            }
            
        }

        // Added by MN for checking condition User active or inactive status
        $condition[]="u.status = " . $status;
        
        /**************** Initiated *****************/
        if($check_count == 'Initiated')
        {
            $condition[]=" a.check_status=107 and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') "; 
        }
        
        /**************** Verified *****************/
        else if($check_count == 'Verified'){
            $condition[]=" a.check_status in(111,110,519) and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";
        }
        
        /**************** QCRevertClosed *****************/
        else if($check_count == 'QCRevertClosed'){
                $condition[]=" a.check_status=1002 and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";
        }
        
        /**************** Reminder *****************/
        else if($check_count == 'Reminder'){
            $condition[]=" a.check_status=1005 and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";
        }
        
        /**************** DDApplied *****************/
        else if($check_count == 'DDApplied'){
            $condition[]=" a.check_status=992 and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";
        }
        
        /**************** RevertedToDEO *****************/
        else if($check_count == 'RevertedToDEO'){
            $condition[]=" a.check_status=1001 and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";
        }
        
        // 16th Jan '23, edited a.check_status=1004 to a.check_status in(1004,1110,1519) to include reopened others  and  stop  check  along  with  verified check_status in status_updates table
        /**************** ReOpen Closed *****************/      
        else if($check_count == 'ReOpen'){
            $condition[]=" a.check_status in(1004,1110,1519) and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";
        }
        else if($check_count == 'RequestRaised'){
            $condition[]=" a.check_status=684 and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";
        }
        /**************** TicketReopen *****************/
        else if($check_count == 'TicketReopen'){
            $condition[]=" a.check_status=1006 and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";
        }
        else
        {
            // Added by MN
            // 16th Jan '23, edited to include reopened others  and  stop  check  along  with  verified check_status in status_updates table i.e., 1110 and 1519            
            /**************** All Activities *****************/
            $condition[]=" a.check_status in(107,111,110,519,684,992,1001,1002,1004,1005,1006,1110,1519) and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";

        }   

        if($term)
        {
        //support multiple words
        $search = explode(' ', $term);

        foreach($search as $t) {
        $not        = '';
        $operator    = 'OR';
        if(substr($t,0,1) == '-')
        {
        $not        = 'NOT ';
        $operator    = 'AND';
        //trim the - sign off
        $t        = substr($t,1,strlen($t));
        }
        }
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        if ($result) {
            $checkteam = $this->config->item('CHECKLIST',APPLICATIONCONFIG);
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            $k=1;

            foreach( $result as $i => $row ) {      
                $candidatename=$row['candidatename'];

                if($row['chk']==0){
                    $chkval=$row['checkname'];
                }else{
                    $chkval=$row['checkname'].$row['chk'];
                }

                // Added by MN - to show verified  status like 'Verified-Written-Clear' etc.,
                $verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
                $verification_data=toArray(json_decode($verified_data['fielddata']));

                $status1=$this->vm->get_status($verification_data['status']);
                $status4='';
                $status2=$this->vm->get_status($verification_data['pstatus']);
                $status3=$this->vm->get_status($verification_data['status1']);
                if($verification_data['ostatus']<>'')
                $status4=$this->vm->get_status($verification_data['ostatus']);
                if($verification_data['dstatus']<>'')
                $status4=$this->vm->get_status($verification_data['dstatus']);
                if(!empty($status4))
                $status41='-'.$status4['name'];
                else
                $status41='';

                // Form a string like 'Verified-Written-Clear' etc.,
                if(!empty($status1['name'])){
                    $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
                }else{
                    $stat='';
                }

                // To  show whether Check status is GREEN, RED or ORANGE
                $rpt_status='';
                if($row['checkId'] ==1306) { // ka added on april 25
                    $rpt_status='';
                }// ka added on april 25
                else if($verification_data['status']!=107 && $verification_data['status']!=684 && $verification_data['status']!=992 && !empty($verification_data['status'])) {
                    if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                        $rpt_status="<span style='color:red;'>RED</span>";
                    }
                    /** Aug 24th **/
                    else if($status1['name']=="Others" && $status4['name']=="Not applicable")
                    {
                        $rpt_status="<span style='color:green;'>GREEN</span>";
                    }
                    /** Aug 24th **/
                    // May 24th
                    else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others"  || $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                        $rpt_status="<span style='color:orange;'>ORANGE</span>";
                    }
                    else 
                    {
                        $rpt_status="<span style='color:green;'>GREEN</span>";
                    }
                }

            // 16th Jan '23, edited to include reopened others and stop  check  along  with  verified i.e., 1110 and 1519
            switch($row['status']){
                case 107:
                    $status='Initiated';
                break;
                case 111:
                    $status='Verified';
                break;
                case 110:
                    $status='Stop Check';
                break;
                case 519:
                    $status='Others';
                break;
                case 684:
                    $status='Request Raised';
                break;
                case 992:
                    $status='DD Applied';
                break;
                case 1001:
                    $status='Reverted to DEO';
                break;
                case 1002:
                    $status='QC Revert Closed';
                break;
                // Edited on 16th Jan '23
                case 1004: // Reopen Verified
                case 1110: // Reopen stop check
                case 1519: // Reopen others
                    $status='Re-Open Closed';
                break;
                case 1005:
                    $status='Reminder Sent';
                break;
                case 1006:
                    $status='Tickets Re-Opened';
                break;
                default:
                    $status="";
            }

                
            $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],$candidatename,$row['case_no'],$chkval,$status,$stat, $rpt_status,date('d-m-Y h:i:s',strtotime($row['date'])),$row['role_name'],$row['user_name']);
            
            } 
        }
        echo json_encode($response);
    }

    /********************* get_activitylist()  ends here ****************/

     /***************************************************************************
   * get_Activity_data_datewise -  CALLED FROM activity_sheet.php page/view 
   * Added by MN on 18th Aug 2022
   * MN changed code on 25th Aug  2022
   * MN changed code on 29th Aug '22 to include holidays
   * MN  changed code to include monthly  display
   * MN  changed  code  on 6th  Sep  '22 to  include multiple Verification members
   * Edited on 16th Jan '23 to incorporate different reopened status
   * Edited to include targets and percentage
   **************************************************************************/    
    function get_Activity_data_datewise()
    {
        //  If _POST is not  empty    
        if(!empty($_POST)){
            
            $fromDate=$_POST['fp_fdate']; 
            $toDate=$_POST['fp_tdate'];
            $list =$_POST['viewType'];
            $status=$_POST['status'];

            if(!empty($_POST['vmember'])){
                $vmember_Id=$_POST['vmember'];
                // selected VM ids
                if(is_array($vmember_Id))
                {
                    $u = '';
                    $u = implode(',', $vmember_Id); //  Convert array into string
                }
                else
                {
                    $u = $vmember_Id;  // logged in VM id
                }
            
            }else{
                if($this->session->userdata['role_id']==5){
                    $userId=$this->session->userdata['userid'];
                }else{
                    $userId=0;
                }
                
            }

        }
        else{
            // _POST  IS  empty
            $fromDate=date('d-m-Y');
            $toDate=date('d-m-Y');
            $status=1;
            $list =1;
            $data['fromDate']=$fromDate;
            $data['toDate']=$toDate;
            if($this->session->userdata['role_id']==5){
                $userId=$this->session->userdata['userid'];
            }else{
                $userId=0;
            }

        }

        // initializing for loop variable $i with $toDate
        $i = date_create($toDate); // create a date variable from a string variable
        $toDate = date_create($toDate); // create a date variable from a string variable
        $fromDate = date_create($fromDate);
        
        $colorCode = 'white';
        // Target added on 18th Jan 
        $html =  '<tr>
                    <th style="padding:5px;border:1px solid black;font-weight: bold;">Date</th>
                    <th style="padding:5px;border:1px solid black;font-weight: bold;">Target</th>
                    <th style="padding:5px;border:1px solid black;font-weight: bold;">Actual</th>
                    <th style="padding:5px;border:1px solid black;font-weight: bold;">Act. %</th>
                    <th style="padding:5px;border:1px solid black;font-weight: bold;">Assigned</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">Initiated</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">Verified</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">QC Reverts Closed</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">Reminder Sent</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">DD Applied</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">Reverted To DEO</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">ReOpen Closed</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">Request Raised</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">Tickets Reopened</th>
                </tr>';
        echo  $html;

        $html = '';
        
        $arrayOfTotalOfEachCheckStatus =  array(107 => 0, // Initiated
                                                1002=>0,  // QC Reverts closed
                                                1005=>0,  // Reminders
                                                992 => 0, // DD Applied
                                                1001=> 0, // Reverted  to DEO
                                                1004 => 0, // Reopened
                                                684 => 0, // Request  Raised
                                                1006=> 0, // Tickets Reopened
                                                111 => 0, // Verify
                                                110 => 0, // Stop checks
                                                519 => 0,  // Others
                                                1110 => 0, // Reopened Stop checks //16th Jan 2023
                                                1519 => 0  // Reopened Others //16th Jan 2023
        ); // end of arrayOfTotalOfEachCheckStatus

        $noOfWorkingDays  = 0;
        $holidayCount = 0;
        $totalNewlyAssigned = '';

        /* Showing data in  the form  of  months when 'Monthly' is selected in the drop down box */
        if($list == '2')
        {
            $html  = '';
            
            // if VMs have been selected
            if($u != '')
            {
                $monthWiseActivities = $this->am->getMonthWiseActivities(date_format($fromDate, 'd-m-Y'),date_format($toDate, 'd-m-Y'),$u,  $status);
                $allMemberTargets = $this->am->get_target_member_wise(date_format($fromDate, 'd-m-Y'),date_format($toDate, 'd-m-Y'),$u,  $status);
            }
            else
            {
                // if VMs have not been selected
                $monthWiseActivities = $this->am->getMonthWiseActivities(date_format($fromDate, 'd-m-Y'),date_format($toDate, 'd-m-Y'),$userId=0,  $status);
                $allMemberTargets = $this->am->get_target_member_wise(date_format($fromDate, 'd-m-Y'),date_format($toDate, 'd-m-Y'),$userId=0,  $status);
            }

            //  Loop through selected 'toDate' to 'fromDate'
            for($i=$toDate;  $i>=$fromDate;)
            {
                $monthCnt = '';
                $monthlyTargetCount = '';
                
                $year = intval($i->format('Y'));
                $month = intval($i->format('m'));
                $m = $i->format('m');

                $dt = DateTime::createFromFormat('!m', $month);
                $monthInWords = $dt->format('M');

                $arrayOfCheckStatus = array(107 => 0, // Initiated
                                        'target' => 0, // target added on 23rd Jan
                                        'newlyAssignedCases' => 0, // New or assigned cases to a VM
                                        1002 =>0,  // QC Reverts closed
                                        1005=>0,  // Reminders
                                        992 => 0, // DD Applied
                                        1001=> 0, // Reverted  to DEO
                                        1004 => 0, // Reopened
                                        684 => 0, // Request  Raised
                                        1006=> 0, // Tickets Reopened
                                        111 => 0, // Verify
                                        110 => 0, // Stop checks
                                        519 => 0,  // Others
                                        1110 => 0, // Reopened Stop checks //16th Jan 2023
                                        1519 => 0  // Reopened Others //16th Jan 2023
                ); // end of arrayOfCheckStatus

                // Added on 23rd Jan
                $displayMonYear  = '';
                $displayMonYear  = $monthInWords . '-' . $year;
                /***********              ALL CHECK_STATUS ACTIVITIES - MONTH WISE                  ***********/
                foreach($monthWiseActivities as $allMonthActivity)
                {
                    // taking  each month in the search range individually
                    $individualMonth = $allMonthActivity['month'];

                    // taking  each year in the search range individually
                    $individualYear = $allMonthActivity['year'];


                    //if individual month and year are equal to the  date in the outer FOR loop
                    if($individualMonth == $month && $individualYear == $year)
                    {
                        // $displayMonYear  = $allMonthActivity['month_name'] . '/' . $year;
                        //check_status got  from the db like 111, 107 etc.,
                        $checkStatus = $allMonthActivity['check_status'];
                        
                        // Check if check_status exists as a 'key' in the arrayOfCheckStatus we have defined
                        $keyExists = array_key_exists($checkStatus, $arrayOfCheckStatus);
                        
                        // if the check_status exists in the arrayOfCheckStatus we have defined then fill the array with status which is nothing but count(check_status)
                        if($keyExists)
                        {

                            //example: $arrayOfCheckStatus[107] = 2
                            $arrayOfCheckStatus[$checkStatus]=$allMonthActivity['status']; 

                            // monthCnt consists of all the activities/ check_status for a given month
                            $monthCnt += $allMonthActivity['status'];

                            // Commented on 9th Feb
                            //$monthlyTargetCount += $allMonthActivity['target'];


                            // total count of  each check_status in the given date range
                            // example: $arrayOfTotalOfEachCheckStatus[107] = 5 , 'target=_blank' 
                            $arrayOfTotalOfEachCheckStatus[$checkStatus]  += $allMonthActivity['status'];
                
                        }
                        
                    }

                }


                // // Commented on 9th Feb
                // if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==9){
                    if($u != '')
                        $monthlyTargetCount = $this->monthly_target($allMemberTargets, date_format($i, 'd-m-Y'), $u, 1);
                    else
                    {
                        $users = $this->am->get_all_vmembers($role_id, $userId, $status);
                        $monthlyTargetCount = $this->monthly_target($allMemberTargets, date_format($i, 'd-m-Y'), $users, 0);
                    }
 
                // }

                $totalTarget += $monthlyTargetCount; //added on 23rd Jan for target

                $monthlyTargetCount=($monthlyTargetCount) ? $monthlyTargetCount : '';     

                //monthlyTargetCount 
                $arrayOfCheckStatus[111] += $arrayOfCheckStatus[110] + $arrayOfCheckStatus[519];

                //  16th Jan '23
                $arrayOfCheckStatus[1004] += $arrayOfCheckStatus[1110] + $arrayOfCheckStatus[1519];
                if($u != '')
                {
                    $userId = $u;
                }
            
                // month = month - 1 gives previous month. If month is 1 i.e, January
                // then the previous month has to be 12 i.e., December
                if($month == 1)
                {
                    $year = $year  - 1;
                    $month =  12;
                }
                else
                {
                    $month=$month-1;
                }

                $d=30; // initial  number of days in a motnh

                switch($month)
                {
                    case 1:
                    case 3:
                    case 5:
                    case 7:
                    case 8:
                    case 10:
                    case 12:
                            // 31 days month                        
                            $d=31;

                            $date = new DateTime();
                            $date->setDate($year, $month, $d);

                            $new_i = $date;
                            $strDt = date_format($date,"Y-m-d");
                            $newDate = date_create($strDt);
                            date_add($newDate,date_interval_create_from_date_string("1 day"));  
                            break;
                    case 4:
                    case 6:
                    case 9:
                    case 11:
                            // 30 days month
                            $d = 30;

                            $date = new DateTime();
                            $date->setDate($year, $month, $d);

                            $new_i = $date;
                            $strDt = date_format($date,"Y-m-d");
                            $newDate = date_create($strDt);
                            date_add($newDate,date_interval_create_from_date_string("1 day"));  
                            
                            break;
                    default:
                            //  february, check if the  year is leap
                            if($year%4 == 0)
                            {
                                // year is leap
                                $d = 29;
                                $date = new DateTime();
                                $date->setDate($year, $month, $d);

                                $new_i = $date;
                                $strDt = date_format($date,"Y-m-d");
                                $newDate = date_create($strDt);
                                date_add($newDate,date_interval_create_from_date_string("1 day"));  
                            }
                            else
                            {
                                // year is not leap
                                $d = 28;
                                $date = new DateTime();
                                $date->setDate($year, $month, $d);

                                $new_i = $date;
                                $strDt = date_format($date,"Y-m-d");
                                $newDate = date_create($strDt);
                                date_add($newDate,date_interval_create_from_date_string("1 day"));  
                            }

                           break;
                    
                    }

                    if($u != '')
                    {
                        $new['newCount']=$this->am->get_new_cases_for_activity(date_format($newDate, 'd-m-Y'),date_format($i, 'd-m-Y'), $u, $status);
                    }
                    else
                    {
                        $new['newCount']=$this->am->get_new_cases_for_activity(date_format($newDate, 'd-m-Y'),date_format($i, 'd-m-Y'), $u, $status);
                    }

                
                    $arrayOfCheckStatus['newlyAssignedCases'] =  count($new['newCount']);
                    $totalNewlyAssigned += $arrayOfCheckStatus['newlyAssignedCases'];
                    $arrayOfCheckStatus['newlyAssignedCases']=($arrayOfCheckStatus['newlyAssignedCases']) ? $arrayOfCheckStatus['newlyAssignedCases'] : '';     

                    // Added on  23rd Jan
                    if($monthlyTargetCount == '')
                    {
                        $percentage = '';
                        $colorCode1 = $colorCode;
                    }
                    else
                    {
                        $percentage = $monthCnt/$monthlyTargetCount;
                        $percentage = $percentage * 100;
                        // $percentage = 100;
                        if($percentage  >= 100)
                            $colorCode1 = 'green'; // '#00FF00';
                        else if($percentage  < 80)
                            $colorCode1 = 'red'; // '#FF0000';
                        else if($percentage  > 80 && $percentage < 100)
                            $colorCode1 = 'orange'; // '#FCAE1E';
                        else
                            $colorCode1 = $colorCode;
                    }

            
                    if($percentage == 0)
                        $percentage = '';
                    else
                    {
                        $percentage = round($percentage);
                        $percentage  .= '%';
                    }

                /** table data to print **/ 
                
                $html  = '<tr><td style="padding:5px;border:1px solid black;background-color:'. $colorCode . ';">';
                $html = $html . $displayMonYear ;
                $html = $html . '</td>';
                // Added on 18th Jan for target 
                
                $target = $arrayOfCheckStatus['target'];
                $html  .= '<td style="padding:5px;border:1px solid black; text-align: right;background-color:'. $colorCode . ';">';
                $html = $html . $monthlyTargetCount ;
                $html = $html . '</td>';

                // Added on 23rd Jan
                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
                $html = $html . $colorCode . ';">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("All")."/".base64_encode(date_format($newDate,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $monthCnt  . "</span>", 'target=_blank' ) . "</td>";

                
                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; color:white; font-weight: bold;background-color:';
                $html = $html . $colorCode1 . ';">';
                $html = $html . $percentage .  '</td>';

                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
                $html = $html . $colorCode . ';">';
                $html = $html . anchor("/Activity/vm_new_assigned_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("New")."/".base64_encode(date_format($newDate,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus['newlyAssignedCases'] . "</span>", 'target=_blank' ) . "</td>";
                
                $arrayOfCheckStatus[107]=($arrayOfCheckStatus[107]) ? $arrayOfCheckStatus[107] : '';     
                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
                $html = $html . $colorCode . ';">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("Initiated")."/".base64_encode(date_format($newDate,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[107]  . "</span>", 'target=_blank' ) . "</td>";

                $arrayOfCheckStatus[111]=($arrayOfCheckStatus[111]) ? $arrayOfCheckStatus[111] : '';
                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
                $html = $html . $colorCode . ';">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("Verified")."/".base64_encode(date_format($newDate,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[111]  . "</span>", 'target=_blank' ) . "</td>";

                
                $arrayOfCheckStatus[1002]=($arrayOfCheckStatus[1002]) ? $arrayOfCheckStatus[1002] : '';
                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
                $html = $html . $colorCode . ';">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("QCRevertClosed")."/".base64_encode(date_format($newDate,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[1002]  . "</span>", 'target=_blank' ) . "</td>";

                
                $arrayOfCheckStatus[1005]=($arrayOfCheckStatus[1005]) ? $arrayOfCheckStatus[1005] : '';
                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
                $html = $html . $colorCode . ';">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("Reminder")."/".base64_encode(date_format($newDate,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[1005]  . "</span>", 'target=_blank' ) . "</td>";

                
                $arrayOfCheckStatus[992]=($arrayOfCheckStatus[992]) ? $arrayOfCheckStatus[992] : '';
                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
                $html = $html . $colorCode . ';">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("DDApplied")."/".base64_encode(date_format($newDate,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[992]  . "</span>", 'target=_blank' ) . "</td>";


                $arrayOfCheckStatus[1001]=($arrayOfCheckStatus[1001]) ? $arrayOfCheckStatus[1001] : '';
                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
                $html = $html . $colorCode . ';">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("RevertedToDEO")."/".base64_encode(date_format($newDate,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[1001]  . "</span>", 'target=_blank' ) . "</td>";

                $arrayOfCheckStatus[1004]=($arrayOfCheckStatus[1004]) ? $arrayOfCheckStatus[1004] : '';
                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
                $html = $html . $colorCode . ';">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("ReOpen")."/".base64_encode(date_format($newDate,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[1004]  . "</span>", 'target=_blank' ) . "</td>";


                $arrayOfCheckStatus[684]=($arrayOfCheckStatus[684]) ? $arrayOfCheckStatus[684] : '';
                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
                $html = $html . $colorCode . ';">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("RequestRaised")."/".base64_encode(date_format($newDate,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[684]  . "</span>", 'target=_blank' ) . "</td>";


                $arrayOfCheckStatus[1006]=($arrayOfCheckStatus[1006]) ? $arrayOfCheckStatus[1006] : '';
                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
                $html = $html . $colorCode . ';">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("TicketReopen")."/".base64_encode(date_format($newDate,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[1006]  . "</span>", 'target=_blank' ) . "</td></tr>";

                
                echo $html; 
                
                $i = $new_i; // new date which is the previous month

            }

    }
    /* code for showing data in  the form  of  months ends  here */
    else
    {
        
        /* day wise information */
        // If verification members are selected
        if($u != '')
        {
            $allActivities=$this->am->get_datewise_activitysheet(date_format($fromDate, 'd-m-Y'),date_format($toDate, 'd-m-Y'), $u, $status);
            $allMemberTargets = $this->am->get_target_member_wise(date_format($fromDate, 'd-m-Y'),date_format($toDate, 'd-m-Y'), $u, $status);

        }
        else
        {
            $allActivities=$this->am->get_datewise_activitysheet(date_format($fromDate, 'd-m-Y'),date_format($toDate, 'd-m-Y'), $userId, $status);
            $allMemberTargets = $this->am->get_target_member_wise(date_format($fromDate, 'd-m-Y'),date_format($toDate, 'd-m-Y'), $userId, $status);
            
        }

        /************************* GET HOLIDAYS FOR THIS YEAR FROM  MASTER_HOLIDAYS TABLE ***********************/
        $allHolidays=$this->am->get_masterholidays();

        // added on 18th Jan for target
        $totalTarget =  0;

        // Looping through all the dates given in the SEARCH range in  descending  order
        for(;$i >= $fromDate; date_add($i,date_interval_create_from_date_string("-1 day")))
        {
            // count of all checks in a single day
            $dayCnt ='';            

            $colorCode = 'white';

            $arrayOfCheckStatus = array(107 => 0, // Initiated
                                        'target' => 0, // target of each user
                                        'newlyAssignedCases' => 0, // New or assigned cases to a VM
                                        1002 =>0,  // QC Reverts closed
                                        1005=>0,  // Reminders
                                        992 => 0, // DD Applied
                                        1001=> 0, // Reverted  to DEO
                                        1004 => 0, // Reopened
                                        684 => 0, // Request  Raised
                                        1006=> 0, // Tickets Reopened
                                        111 => 0, // Verify
                                        110 => 0, // Stop checks
                                        519 => 0,  // Others
                                        1110 => 0, // Reopened and Stop check status //  16th Jan'23
                                        1519 => 0  // Reopened and Others status //  16th Jan'23
            ); // end of arrayOfCheckStatus
            
            // 0 = Sunday,  1 = Monday etc.,
            $dayofweek = intval($i->format('w'));
            
            // If the day is Sunday, the  background-color needs  to be  grey
            if($dayofweek == 0)
            {
                $colorCode = '#e9e8e8'; //'#a9a4a4';
            }


            /************ Checking  for Second and Fourth Saturday **************/
            // If the day is either  2nd or 4th Saturday,  the background-color needs tobe  grey
            if($dayofweek == 6)
            {
                $str = date_format($i,"Y-m-d");
                $someDate = date_create($str);
                
                $firstDate = $someDate->modify('first day of this month');
             
                // Returns an integer value from 0  to 6, 0 - Sunday, 1- Monday and so on
                $val = $firstDate->modify('first day of this month')->format('w');
                
                // Calculate  2nd and 4th  Saturdays using  the first day of the month 
                switch($val)
                {
                    case 0: // Sunday
                        $secondSat = date_add($firstDate,date_interval_create_from_date_string("13 days"));
                        if($i == $secondSat)
                        { 
                            $colorCode = '#e9e8e8';
                            break;
                        }
                        $fourthSat = date_add($firstDate,date_interval_create_from_date_string("14 days"));  
                        if($i == $fourthSat)
                        {
                            $colorCode = '#e9e8e8';
                            break;
                        }
                        // If the Saturday is not 2nd or 4th then increment the working days
                        $noOfWorkingDays++;
                        break;  

                    case 1: // Monday
                        $secondSat = date_add($firstDate,date_interval_create_from_date_string("12 days"));
                        if($i == $secondSat)
                        {   
                            $colorCode = '#e9e8e8';
                            break;
                        }
                        $fourthSat = date_add($firstDate,date_interval_create_from_date_string("14 days"));  
                        if($i == $fourthSat)
                        {
                            $colorCode = '#e9e8e8';
                            break;                          
                        }
                        // If the Saturday is not 2nd or 4th then increment the working days
                        $noOfWorkingDays++;
                        break;

                    case 2: //  Tuesday
                        $secondSat = date_add($firstDate,date_interval_create_from_date_string("11 days"));
                        if($i == $secondSat)
                        { 
                            $colorCode = '#e9e8e8';
                            break;
                        }
                        $fourthSat = date_add($firstDate,date_interval_create_from_date_string("14 days"));  
                        if($i == $fourthSat)
                        {
                             $colorCode = '#e9e8e8';
                             break;
                        }
                        // If the Saturday is not 2nd or 4th then increment the working days
                        $noOfWorkingDays++;
                        break;

                    case 3: // Wednesday
                        $secondSat = date_add($firstDate,date_interval_create_from_date_string("10 days"));
                        if($i == $secondSat)
                        { 
                            $colorCode = '#e9e8e8';
                            break;
                        }
                        $fourthSat = date_add($firstDate,date_interval_create_from_date_string("14 days"));  
                        if($i == $fourthSat)
                        {
                            $colorCode = '#e9e8e8';
                            break;
                        }

                        // If the Saturday is not 2nd or 4th then increment the working days
                        $noOfWorkingDays++;
                        break;
                         
                    case 4: // Thursday
                        $secondSat = date_add($firstDate,date_interval_create_from_date_string("09 days"));
                        if($i == $secondSat)
                        { 
                            $colorCode = '#e9e8e8';
                            break;
                        }
                        $fourthSat = date_add($firstDate,date_interval_create_from_date_string("14 days"));  
                        if($i == $fourthSat)
                        {
                            $colorCode = '#e9e8e8';
                            break;
                        }
                         
                        // If the Saturday is not 2nd or 4th then increment the working days
                        $noOfWorkingDays++;
                        break;
             
                    case 5: // Friday
                        $secondSat = date_add($firstDate,date_interval_create_from_date_string("08 days"));
                        if($i == $secondSat)
                        { 
                            $colorCode = '#e9e8e8';
                            break;
                        }
                        $fourthSat = date_add($firstDate,date_interval_create_from_date_string("14 days"));  
                        if($i == $fourthSat)
                        {
                            $colorCode = '#e9e8e8';
                            break;
                        }

                        // If the Saturday is not 2nd or 4th then increment the working days
                        $noOfWorkingDays++;
                        break;
             
                    case 6: // Saturday
                        $secondSat = date_add($firstDate,date_interval_create_from_date_string("07 days"));
                        if($i == $secondSat)
                        { 
                            $colorCode = '#e9e8e8';
                            break;
                        }
                        $fourthSat = date_add($firstDate,date_interval_create_from_date_string("14 days"));  
                        if($i == $fourthSat)
                        {
                            $colorCode = '#e9e8e8';                         
                            break;
                        }
                        // If the Saturday is not 2nd or 4th then increment the working days
                        $noOfWorkingDays++; 
                        break;

                    default:
                        break;
             
                }
                
            }

             /*************** End of Second  and Fourth Saturday code ************/

            
            // check if the given date is a holiday for the company
            foreach($allHolidays as $holiday)
            {               
                $holidayDate = $holiday['holiday_date'];
                
                $holidayDate = date_create($holidayDate);
                
                if($holidayDate == $i)
                {
                    $holidayCount++;
                    $colorCode = '#e9e8e8';
                    // $arrayOfCheckStatus['target'] = '';
                }
            }       
   
            
            //  If Sunday or Saturday
            if($dayofweek == 0 || $dayofweek == 6)
            {
                
            }
            else
            {
                $noOfWorkingDays++; // Increment the working days if day is weekday             
            }

            if($u != '')
            {
                $new['newCount']=$this->am->get_new_cases_for_activity(date_format($i, 'd-m-Y'),date_format($i, 'd-m-Y'), $u, $status);
            }
            else
            {
                $new['newCount']=$this->am->get_new_cases_for_activity(date_format($i, 'd-m-Y'),date_format($i, 'd-m-Y'), $userId, $status);
            }

            /***********              ALL CHECK_STATUS ACTIVITIES                   ***********/
            foreach($allActivities as $allChecksActivity)
            {
                // taking  each date in the search range individually
                $individualDate = date_create($allChecksActivity['updateDate']);

                //if individualDate is equal to the  date in the outer FOR loop
                if($individualDate == $i)
                {
                    //check_status got  from the db like 111, 107 etc.,
                    $checkStatus = $allChecksActivity['check_status'];
                    
                    // Check if check_status exists as a 'key' in the arrayOfCheckStatus we have defined
                    $keyExists = array_key_exists($checkStatus, $arrayOfCheckStatus);
                    
                    // if the check_status exists in the arrayOfCheckStatus we have defined then fill the array
                    // with status which is nothing but count(check_status)
                    if($keyExists)
                    {
                        //example: $arrayOfCheckStatus[107] = 2
                        $arrayOfCheckStatus[$checkStatus]=$allChecksActivity['status']; 

                        // dayCnt consists of all the activities/ check_status for a given date
                        $dayCnt += $allChecksActivity['status'];

                        // total count of  each check_status in the given date range
                        // example: $arrayOfTotalOfEachCheckStatus[107] = 5 , 'target=_blank' 
                        $arrayOfTotalOfEachCheckStatus[$checkStatus]  += $allChecksActivity['status'];

                    }
                    
                }

            }

                if($u != '')
                    $arrayOfCheckStatus['target'] = $this->daily_target($allMemberTargets, $i, $u, 1);
                else
                {
                    // get all users  according active or  inactive  status
                    $users = $this->am->get_all_vmembers($role_id, $userId, $status);
                    $arrayOfCheckStatus['target'] = $this->daily_target($allMemberTargets, $i, $users, 0);
                }
 
            $arrayOfCheckStatus[111] += $arrayOfCheckStatus[110] + $arrayOfCheckStatus[519];

            //Added on 16th Jan  '23
            $arrayOfCheckStatus[1004] += $arrayOfCheckStatus[1110] + $arrayOfCheckStatus[1519];
            $arrayOfCheckStatus['newlyAssignedCases'] =  count($new['newCount']);
            $totalNewlyAssigned += $arrayOfCheckStatus['newlyAssignedCases'];
            

            $arrayOfCheckStatus['newlyAssignedCases']=($arrayOfCheckStatus['newlyAssignedCases']) ? $arrayOfCheckStatus['newlyAssignedCases'] : '';   
            $arrayOfCheckStatus['target'] = ($arrayOfCheckStatus['target']) ? $arrayOfCheckStatus['target'] : '';

            if($u != '')
            {
                $userId = $u;
            }

            /** table data to print **/             

            $html  = '<tr><td style="padding:5px;border:1px solid black;background-color:'. $colorCode . ';">';
            $html = $html . date_format($i,"d-m-Y") ;
            $html = $html . '</td>';

            //added on 23rd Jan for target
            if($dayCnt == '' ||  $dayCnt == 0)
                $arrayOfCheckStatus['target'] = ''; 

            $html  .= '<td style="padding:5px;border:1px solid black;text-align: right;background-color:'. $colorCode . ';">';
            $html = $html . $arrayOfCheckStatus['target'];
            $html = $html . '</td>';

            $totalTarget += $arrayOfCheckStatus['target']; //added on 18th Jan for target

            $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
            $html = $html . $colorCode . ';">';
            $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("All")."/".base64_encode(date_format($i,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $dayCnt  . "</span>", 'target=_blank' ) . "</td>";

            // Added on  23rd Jan
            if($arrayOfCheckStatus['target'] == '')
            {
                $percentage = '';
                $colorCode1 = $colorCode;
            }
            else
            {
                $percentage = $dayCnt/$arrayOfCheckStatus['target'];
                $percentage = $percentage * 100;
                // $percentage = 90;
                if($percentage  >= 100)
                    $colorCode1 = 'green'; // #00FF00';
                else if($percentage  < 80)
                    $colorCode1 = 'red'; // #FF0000';
                else if($percentage  > 80 && $percentage < 100)
                    $colorCode1 = 'orange'; //  #FCAE1E';
                else
                    $colorCode1 = $colorCode;
            }

            if($percentage == 0)
                $percentage = '';
            else
            {
                $percentage = round($percentage);
                $percentage .= '%';
            }
            $html  .= '<td style="padding:5px;border:1px solid black;text-align: right;font-weight: bold;color:  white; background-color:'. $colorCode1 . ';">';
            $html = $html . $percentage;
            $html = $html . '</td>';
          
          
            // Added on 10th Oct
            $html  .= '<td style="padding:5px;border:1px solid black;text-align: right;background-color:'. $colorCode . ';">';
            $html = $html . anchor("/Activity/vm_new_assigned_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("New")."/".base64_encode(date_format($i,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus['newlyAssignedCases'] . "</span>", 'target=_blank' ) . "</td>";
         
            $arrayOfCheckStatus[107]=($arrayOfCheckStatus[107]) ? $arrayOfCheckStatus[107] : '';     
            $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
            $html = $html . $colorCode . ';">';
            $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("Initiated")."/".base64_encode(date_format($i,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[107]  . "</span>", 'target=_blank' ) . "</td>";

            $arrayOfCheckStatus[111]=($arrayOfCheckStatus[111]) ? $arrayOfCheckStatus[111] : '';
            $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
            $html = $html . $colorCode . ';">';
            $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("Verified")."/".base64_encode(date_format($i,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[111]  . "</span>", 'target=_blank' ) . "</td>";

            
            $arrayOfCheckStatus[1002]=($arrayOfCheckStatus[1002]) ? $arrayOfCheckStatus[1002] : '';
            $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
            $html = $html . $colorCode . ';">';
            $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("QCRevertClosed")."/".base64_encode(date_format($i,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[1002]  . "</span>", 'target=_blank' ) . "</td>";

            
            $arrayOfCheckStatus[1005]=($arrayOfCheckStatus[1005]) ? $arrayOfCheckStatus[1005] : '';
            $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
            $html = $html . $colorCode . ';">';
            $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("Reminder")."/".base64_encode(date_format($i,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[1005]  . "</span>", 'target=_blank' ) . "</td>";

            
            $arrayOfCheckStatus[992]=($arrayOfCheckStatus[992]) ? $arrayOfCheckStatus[992] : '';
            $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
            $html = $html . $colorCode . ';">';
            $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("DDApplied")."/".base64_encode(date_format($i,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[992]  . "</span>", 'target=_blank' ) . "</td>";


            $arrayOfCheckStatus[1001]=($arrayOfCheckStatus[1001]) ? $arrayOfCheckStatus[1001] : '';
            $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
            $html = $html . $colorCode . ';">';
            $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("RevertedToDEO")."/".base64_encode(date_format($i,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[1001]  . "</span>", 'target=_blank' ) . "</td>";

            $arrayOfCheckStatus[1004]=($arrayOfCheckStatus[1004]) ? $arrayOfCheckStatus[1004] : '';
            $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
            $html = $html . $colorCode . ';">';
            $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("ReOpen")."/".base64_encode(date_format($i,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[1004]  . "</span>", 'target=_blank' ) . "</td>";


            $arrayOfCheckStatus[684]=($arrayOfCheckStatus[684]) ? $arrayOfCheckStatus[684] : '';
            $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
            $html = $html . $colorCode . ';">';
            $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("RequestRaised")."/".base64_encode(date_format($i,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[684]  . "</span>", 'target=_blank' ) . "</td>";


            $arrayOfCheckStatus[1006]=($arrayOfCheckStatus[1006]) ? $arrayOfCheckStatus[1006] : '';
            $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
            $html = $html . $colorCode . ';">';
            $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("TicketReopen")."/".base64_encode(date_format($i,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[1006]  . "</span>", 'target=_blank' ) . "</td>";

            
            echo $html; 

        }
    }
        $arrayOfTotalOfEachCheckStatus[111] += $arrayOfTotalOfEachCheckStatus[110] + $arrayOfTotalOfEachCheckStatus[519];

        // 16th Jan '23
        //  reopened verified = reopened verified + reopened stop check + reopened others 
        $arrayOfTotalOfEachCheckStatus[1004] += $arrayOfTotalOfEachCheckStatus[1110] + $arrayOfTotalOfEachCheckStatus[1519];
        
        $totalCnt  = $arrayOfTotalOfEachCheckStatus[107] + $arrayOfTotalOfEachCheckStatus[111] +                                     $arrayOfTotalOfEachCheckStatus[1002] + $arrayOfTotalOfEachCheckStatus[1005] + 
                     $arrayOfTotalOfEachCheckStatus[992] + $arrayOfTotalOfEachCheckStatus[1001] +
                     $arrayOfTotalOfEachCheckStatus[1004] + $arrayOfTotalOfEachCheckStatus[684] + 
                     $arrayOfTotalOfEachCheckStatus[1006];

        if($totalCnt == 0)
            $totalCnt = '';
        if($totalTarget == 0)
            $totalTarget = '';

        // Added on  23rd Jan
        if($totalCnt != '' && $totalTarget != '')
        {
            $totalPercentage = $totalCnt/$totalTarget;
            $totalPercentage = $totalPercentage * 100;
            $totalPercentage = round($totalPercentage);
            $totalPercentage .= '%';
        }
        else
            $totalPercentage = '';

        $colorCode = 'white';
        if($totalPercentage == '' ||  $totalPercentage == 0 )
        {
            $colorCode1 = $colorCode;
        }
        else
        {
            if($totalPercentage  >= 100)
                $colorCode1 = 'green'; // '#00FF00';
            else if($totalPercentage  < 80)
                $colorCode1 = 'red' ; // '#FF0000';
            else if($totalPercentage  > 80 && $totalPercentage < 100)
                $colorCode1 = 'orange'; // '#FCAE1E';
            else
                $colorCode1 = $colorCode;
        }

        $html = '';
        $html  = '<tr><td style="padding:5px;border:1px solid black;font-weight: bold;">Total';
        $html = $html . '</td>';        

        // added  on 18th Jan for target
        $html = $html . '<td style="padding:5px;border:1px solid black;text-align: right;font-weight: bold;">';
        $html = $html . $totalTarget  . "</td>";


        $html = $html . '<td style="padding:5px;border:1px solid black;text-align: right;font-weight: bold;">' . $totalCnt . '</td>';

        
        $html = $html . '<td style="padding:5px;border:1px solid black;text-align: right;font-weight: bold; color:white;background-color:';
        $html = $html . $colorCode1 . ';">';
        $html = $html . $totalPercentage . "</td>";


        $html = $html . '<td style="padding:5px;border:1px solid black;text-align: right;font-weight: bold;">';
        $totalNewlyAssigned = ($totalNewlyAssigned) ? $totalNewlyAssigned :'';

        $html = $html . anchor("/Activity/vm_new_assigned_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("New")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $totalNewlyAssigned  . "</span>", 'target=_blank' ) . "</td>";



        $arrayOfTotalOfEachCheckStatus[107]=($arrayOfTotalOfEachCheckStatus[107]) ? $arrayOfTotalOfEachCheckStatus[107] : '';
        $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("Initiated")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[107]  . "</span>", 'target=_blank' ) . "</td>";


        $arrayOfTotalOfEachCheckStatus[111]=($arrayOfTotalOfEachCheckStatus[111]) ? $arrayOfTotalOfEachCheckStatus[111] : '';
        $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("Verified")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[111]  . "</span>", 'target=_blank' ) . "</td>";


        $arrayOfTotalOfEachCheckStatus[1002]=($arrayOfTotalOfEachCheckStatus[1002]) ? $arrayOfTotalOfEachCheckStatus[1002] : '';
        $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("QCRevertClosed")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[1002]  . "</span>", 'target=_blank' ) . "</td>";

        $arrayOfTotalOfEachCheckStatus[1005]=($arrayOfTotalOfEachCheckStatus[1005]) ? $arrayOfTotalOfEachCheckStatus[1005] : '';
        $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("Reminder")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[1005]  . "</span>", 'target=_blank' ) . "</td>";

        $arrayOfTotalOfEachCheckStatus[992]=($arrayOfTotalOfEachCheckStatus[992]) ? $arrayOfTotalOfEachCheckStatus[992] : '';
        $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("DDApplied")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[992]  . "</span>", 'target=_blank' ) . "</td>";


        $arrayOfTotalOfEachCheckStatus[1001]=($arrayOfTotalOfEachCheckStatus[1001]) ? $arrayOfTotalOfEachCheckStatus[1001] : '';
        $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("RevertedToDEO")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[1001]  . "</span>", 'target=_blank' ) . "</td>";


        $arrayOfTotalOfEachCheckStatus[1004]=($arrayOfTotalOfEachCheckStatus[1004]) ? $arrayOfTotalOfEachCheckStatus[1004] : '';
        $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("ReOpen")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[1004]  . "</span>", 'target=_blank' ) . "</td>";


        $arrayOfTotalOfEachCheckStatus[684]=($arrayOfTotalOfEachCheckStatus[684]) ? $arrayOfTotalOfEachCheckStatus[684] : '';$html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("RequestRaised")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[684]  . "</span>", 'target=_blank' ) . "</td>";


        $arrayOfTotalOfEachCheckStatus[1006]=($arrayOfTotalOfEachCheckStatus[1006]) ? $arrayOfTotalOfEachCheckStatus[1006] : '';

        $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("TicketReopen")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[1006]  . "</span>", 'target=_blank' ) . "</td></tr>";


        
        echo $html;

        // Actual number of working days
        $noOfWorkingDays =  $noOfWorkingDays - $holidayCount;

        $totalCnt = $totalCnt/$noOfWorkingDays;
        $averageCnt = round($totalCnt);
        $averageCnt = ($averageCnt) ? $averageCnt : '';

        // If view is monthly, don't show average
        if($list != '2')
        {
            // target added on 18th Jan
            $html =  '<tr>
                        <th style="padding:5px;border:1px solid black;font-weight: bold;">Average (Approx.)</th>
                        <th style="padding:5px;border:1px solid black;font-weight: bold;">Target</th>
                        <th id="results" style="padding:5px;border:1px solid black;text-align: right;font-weight: bold;">' . $averageCnt .  '</th>
                        <th style="padding:5px;border:1px solid black;font-weight: bold;">%</th>
                        <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;"></th>
                        <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;"></th>
                        <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;"></th>
                        <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;"></th>
                        <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;"></th>
                        <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;"></th>
                        <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;"></th>
                        <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;"></th>
                        <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;"></th>
                        <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;"> </th>
                        
                    </tr>';
            // echo  $html;
        }

    }


    /*********************************************************************
     * get_activity_member_wise - CALLED FROM activity_sheet.php page/view
     * Added by MN on 18th Aug 2022
     * MN changed code on 25th Aug  2022
     * Changed code on 05th  Sep 2022, to accomodate multiple selection of VMs
     * Edited on 16th Jan '23 to incorporate different reopened status
     *****************************************************/    
    function get_activity_member_wise()
    {
        
        //  If _POST is not  empty    
        if(!empty($_POST)){
            $fromDate=$_POST['fp_fdate']; 
            $toDate=$_POST['fp_tdate'];
            $fromDate1=$_POST['fp_fdate']; 
            $toDate1=$_POST['fp_tdate'];
            
            $list =1;           
            $vmember_Id=$_POST['vmember'];          
            $status=$_POST['status'];
            
            if(!empty($_POST['vmember'])){
                $vmember_Id=$_POST['vmember'];
            
                // selected VM ids
                if(is_array($vmember_Id))
                {
                    $u = '';
                    $u = implode(',', $vmember_Id); //  Convert array into string
                }
                else
                {
                    $u = $vmember_Id; // logged in VM id
                }

               
            }else{
                if($this->session->userdata['role_id']==5){
                    $userId=$this->session->userdata['userid'];
                }else{
                    $userId=0;
                }
                
            }

        }
        else{
            // _POST  IS  empty
            $fromDate=date('d-m-Y');
            $toDate=date('d-m-Y');
            $status = 1;
            $list = 1;
            $data['fromDate']=$fromDate;
            $data['toDate']=$toDate;
            if($this->session->userdata['role_id']==5){
                $userId=$this->session->userdata['userid'];
            }else{
                $userId=0;
            }

            
            
        }

        if($u != '')
            $users = $this->am->get_all_vmembers($role_id, $u, $status);
        else
            $users = $this->am->get_all_vmembers($role_id, $userId, $status);

        $toDate1 = date_create($toDate1); // create a date variable from a string variable
        $fromDate1 = date_create($fromDate1);
            

        // If verification members have been selected from the multiple select (drop down) box
        if($u != '')
        {
            //  Get member wise activities in between the given dates and active or inactive status
            $allMemberActivities=$this->am->get_member_wise_activitysheet($fromDate,$toDate,$u ,$status);
            $allMemberTargets=$this->am->get_target_member_wise(date_format($fromDate1, 'd-m-Y'),date_format($toDate1, 'd-m-Y'), $u, $status);
            
        }
        else
        {
            //  Get member wise activities in between the given dates and active or inactive status
            $allMemberActivities=$this->am->get_member_wise_activitysheet($fromDate,$toDate,$userId ,$status);
            $allMemberTargets=$this->am->get_target_member_wise(date_format($fromDate1, 'd-m-Y'),date_format($toDate1, 'd-m-Y'), $userId, $status);
            
        }

        $arrayOfCheckStatus = array(107 => 0, // Initiated
                                    1002 =>0,  // QC Reverts closed
                                    1005=>0,  // Reminders
                                    992 => 0, // DD Applied
                                    1001=> 0, // Reverted  to DEO
                                    1004 => 0, // Reopened
                                    684 => 0, // Request  Raised
                                    1006=> 0, // Tickets Reopened
                                    111 => 0, // Verify
                                    110 => 0, // Stop checks
                                    519 => 0,  // Others
                                    1110 => 0, // Reopened and Stop check status // 16th Jan '23
                                    1519 => 0  // Reopened and Others status // 16th Jan '23
        ); // end of arrayOfCheckStatus

        
        $toDate = date_create($toDate); // create a date variable from a string variable
        $fromDate = date_create($fromDate);
  
        $arrayOfTotalOfEachCheckStatus =  array(107 => 0, // Initiated
                                                1002=>0,  // QC Reverts closed
                                                1005=>0,  // Reminders
                                                992 => 0, // DD Applied
                                                1001=> 0, // Reverted  to DEO
                                                1004 => 0, // Reopened
                                                684 => 0, // Request  Raised
                                                1006=> 0, // Tickets Reopened
                                                111 => 0, // Verify
                                                110 => 0, // Stop checks
                                                519 => 0,  // Others
                                                1110 => 0, // Reopened and Stop check status // 16th Jan '23
                                                1519 => 0  // Reopened and Others status // 16th Jan '23
        ); // end of arrayOfTotalOfEachCheckStatus

        // Target added on 18th Jan
        $html =  '<tr>
                    <th style="padding:5px;border:1px solid black;font-weight: bold;">Member Name</th>
                    <th style="padding:5px;border:1px solid black;font-weight: bold;">Target</th>
                    <th style="padding:5px;border:1px solid black;font-weight: bold;">Actual</th>
                    <th style="padding:5px;border:1px solid black;font-weight: bold;">Act. %</th>
                    <th style="padding:5px;border:1px solid black;font-weight: bold;">Assigned</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">Initiated</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">Verified</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">QC Reverts Closed</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">Reminders Sent</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">DD Applied</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">Reverted To DEO</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">ReOpen Closed</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">Request Raised</th>
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">Tickets Reopened</th>
                </tr>';
        
        echo  $html;

        $html = '';

        $totalNewlyAssigned = '';


        // Loop through the array for however many unique users are there in the result array
        foreach($users as $user)
        {
            $name='';
            $user_id = $user['user_id']; // take the unique user id from the result array (table) into a variable
            $name = $user['name'];
            $userID_No = '';
            $total = '';
            $arrayOfMemberData= array(
                                    'name' =>  '', // for name of the vmember
                                    'target' => 0,
                                    'newlyAssignedCases' => 0, // New or assigned cases to a VM
                                    '107' => 0, // Initiated
                                    '1002'=>0,  // QC Reverts closed
                                    '1005'=>0,  // Reminders
                                    '992' => 0, // DD Applied
                                    '1001'=> 0, // Reverted  to DEO
                                    '1004' => 0, // Reopened
                                    '684' => 0, // Request  Raised
                                    '1006'=> 0, // Tickets Reopened
                                    '111' => 0, // Verify
                                    '110' => 0, // Stop checks
                                    '519' => 0,  // Others
                                    '1110' => 0, // Reopened Stop checks  // 16th Jan '23
                                    '1519' => 0  // Reopened Others // 16th Jan '23
            ); // end of arrayOfMemberData

            $new['newCount']  = $this->am->get_new_cases_for_activity($_POST['fp_fdate'], $_POST['fp_tdate'], $user_id, $status);

            foreach($allMemberActivities as  $row)
            {           

                if($user_id == $row['user_id'] )
                {           
                    $userID_No = $row['user_id'];
                    
                    //check_status got  from the db like 111, 107 etc.,
                    $checkStatus = $row['check_status'];
                
                    // Check if check_status exists as a 'key' in the arrayOfCheckStatus we have defined
                    $keyExists = array_key_exists($checkStatus, $arrayOfCheckStatus);
                    
                    // if the check_status exists in the arrayOfCheckStatus we have defined, then fill the array
                    // with status which is nothing but count(check_status)
                    if($keyExists)
                    {
                        //example: $arrayOfCheckStatus[107] = 2
                        $arrayOfMemberData[$checkStatus]=$row['statusActivity']; 
                        $arrayOfTotalOfEachCheckStatus[$checkStatus] += $row['statusActivity']; 
                            
                    }


                    
                }
                                
            }

            if(!empty($_POST))
                {
                    $fromDate2 = date_create($_POST['fp_fdate']);
                    $toDate2 = date_create($_POST['fp_tdate']);
                    $i = date_create($_POST['fp_tdate']);
                }
            else{
                $toDate2 = date_create($data['toDate']); // create a date variable from a string variable
                $fromDate2 = date_create($data['fromDate']);
                $i = date_create($data['toDate']); // create a date variable from a string variable
            }

            for(;$i >= $fromDate2; date_add($i,date_interval_create_from_date_string("-1 day")))
            {
                
                $count = 0;
                foreach($allMemberTargets as  $row)
                {   
                    if($user_id == $row['user_id'] )
                    {
                        $individualDate = date_create($row['updateDate']);
                        $j = date_format($individualDate,"d-m-Y");
                        $k = date_format($i,"d-m-Y");
                        if(strcmp($j,$k) == 0)
                        {
                            $checkStatus = $row['check_status'];
                
                            // Check if check_status exists as a 'key' in the arrayOfCheckStatus we have defined
                            $keyExists = array_key_exists($checkStatus, $arrayOfCheckStatus);
                            
                            // if the check_status exists in the arrayOfCheckStatus we have defined, then increment the target for the particular user_id
                            if($keyExists)
                            {
                                $targetForUser[$user_id] += $row['target'];
                                $count++;
                                break;
                            }


                        }
                    }

                }
                    
            }

            $arrayOfMemberData['target'] = $targetForUser[$user_id];
            $arrayOfMemberData['name'] = $name;

            $arrayOfMemberData['newlyAssignedCases'] =  count($new['newCount']);

            $totalNewlyAssigned += $arrayOfMemberData['newlyAssignedCases'];

            $arrayOfMemberData['newlyAssignedCases']=($arrayOfMemberData['newlyAssignedCases']) ? $arrayOfMemberData['newlyAssignedCases'] : '';   

            // All verified checks  =  verified + open + stop_checks
            $arrayOfMemberData[111] += $arrayOfMemberData[110] + $arrayOfMemberData[519];

            // 16th Jan '23
            // All reopened and verified checks  =  reopened verified + reopened open + reoepned stop_checks
            $arrayOfMemberData[1004] += $arrayOfMemberData[1110] + $arrayOfMemberData[1519];

            $total= $arrayOfMemberData[107] + $arrayOfMemberData[111] + $arrayOfMemberData[1002]
                     + $arrayOfMemberData[1005] +  $arrayOfMemberData[992] + $arrayOfMemberData[1001] +
                     $arrayOfMemberData[1004] + $arrayOfMemberData[684] + $arrayOfMemberData[1006];

            $arrayOfMemberData[107]=($arrayOfMemberData[107]) ? $arrayOfMemberData[107] : '';
            $arrayOfMemberData[111]=($arrayOfMemberData[111]) ? $arrayOfMemberData[111] : '';
            $arrayOfMemberData[1002]=($arrayOfMemberData[1002]) ? $arrayOfMemberData[1002] : '';
            $arrayOfMemberData[1005]=($arrayOfMemberData[1005]) ? $arrayOfMemberData[1005] : '';
            $arrayOfMemberData[992]=($arrayOfMemberData[992]) ? $arrayOfMemberData[992] : '';
            $arrayOfMemberData[1001]=($arrayOfMemberData[1001]) ? $arrayOfMemberData[1001] : '';
            $arrayOfMemberData[1004]=($arrayOfMemberData[1004]) ? $arrayOfMemberData[1004] : '';
            $arrayOfMemberData[684]=($arrayOfMemberData[684]) ? $arrayOfMemberData[684] : '';
            $arrayOfMemberData[1006]=($arrayOfMemberData[1006]) ? $arrayOfMemberData[1006] : '';

            $total=($total) ? $total : '';

            $arrayOfMemberData['target'] = ($arrayOfMemberData['target']) ? $arrayOfMemberData['target'] : '';
            $colorCode = 'white';
            // Added on  26th Jan
            if($total == '' || $total == 0 || $arrayOfMemberData['target'] == '' || $arrayOfMemberData['target'] == 0)
            {
                $percentage = '';
                $colorCode1 = $colorCode;
            }
            else
            {
                $percentage = $total/$arrayOfMemberData['target'];
                $percentage = $percentage * 100;
                // $percentage = 100;
                if($percentage  >= 100)
                    $colorCode1 = 'green'; // '#00FF00';
                else if($percentage  < 80)
                    $colorCode1 = 'red'; // '#FF0000';
                else if($percentage  > 80 && $percentage < 100)
                    $colorCode1 = 'orange'; // '#FCAE1E';
                else
                    $colorCode1 = $colorCode;
            }

            
            if($percentage == 0)
                $percentage = '';
            else
            {
                $percentage = round($percentage);
                $percentage  .= '%';
            }


            /** table data to print **/ 
            
                $html =  '<tr>
                       <td style="padding:5px;border:1px solid black;">'. $arrayOfMemberData['name'] . '</td>';
                // Added on 18th Jan for target
                $html =  $html . '<td style="padding:5px;border:1px solid black;text-align: right;">'. $arrayOfMemberData['target'] . '</td>';

                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userID_No)."/".base64_encode("All")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $total  . "</span>", 'target=_blank' ) . "</td>";

                $html =  $html . '<td style="padding:5px;border:1px solid black;text-align: right;font-weight: bold;color:  white;background-color:';
                $html = $html . $colorCode1 . ';">' . $percentage . '</td>';
                $html =  $html . '<td style="padding:5px;border:1px solid black;text-align: right;">';
                $html = $html . anchor("/Activity/vm_new_assigned_activity/".base64_encode($status)."/".base64_encode($user_id)."/".base64_encode("New")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfMemberData['newlyAssignedCases'] . "</span>", 'target=_blank' ) . "</td>";

                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userID_No)."/".base64_encode("Initiated")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfMemberData[107]  . "</span>", 'target=_blank' ) . "</td>";

                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userID_No)."/".base64_encode("Verified")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfMemberData[111]  . "</span>", 'target=_blank' ) . "</td>";

                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userID_No)."/".base64_encode("QCRevertClosed")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfMemberData[1002]  . "</span>", 'target=_blank' ) . "</td>";

                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userID_No)."/".base64_encode("Reminder")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfMemberData[1005]  . "</span>", 'target=_blank' ) . "</td>";


                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userID_No)."/".base64_encode("DDApplied")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfMemberData[992]  . "</span>", 'target=_blank' ) . "</td>";


                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userID_No)."/".base64_encode("RevertedToDEO")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfMemberData[1001]  . "</span>", 'target=_blank' ) . "</td>";

                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userID_No)."/".base64_encode("ReOpen")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfMemberData[1004]  . "</span>", 'target=_blank' ) . "</td>";

                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userID_No)."/".base64_encode("RequestRaised")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfMemberData[684]  . "</span>", 'target=_blank' ) . "</td>";

                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;">';
                $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userID_No)."/".base64_encode("TicketReopen")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfMemberData[1006]  . "</span>", 'target=_blank' ) . "</td></tr>";

                
                echo  $html;

                $totalTarget += $arrayOfMemberData['target'];
            
        }
        
        
        $arrayOfTotalOfEachCheckStatus[111] += $arrayOfTotalOfEachCheckStatus[110] + $arrayOfTotalOfEachCheckStatus[519];

        //Added on 16th Jan  '23 to include reopen open and reopen stop check as reopen verified checks
        $arrayOfTotalOfEachCheckStatus[1004] += $arrayOfTotalOfEachCheckStatus[1110] + $arrayOfTotalOfEachCheckStatus[1519];
        
        $totalCnt  = $arrayOfTotalOfEachCheckStatus[107] + $arrayOfTotalOfEachCheckStatus[111] +                                     $arrayOfTotalOfEachCheckStatus[1002] + $arrayOfTotalOfEachCheckStatus[1005] + 
                     $arrayOfTotalOfEachCheckStatus[992] + $arrayOfTotalOfEachCheckStatus[1001] +
                     $arrayOfTotalOfEachCheckStatus[1004] + $arrayOfTotalOfEachCheckStatus[684] + 
                     $arrayOfTotalOfEachCheckStatus[1006];
        
        if($totalCnt == 0)
            $totalCnt = '';

        $totalNewlyAssigned  =  ($totalNewlyAssigned) ? $totalNewlyAssigned :  '';
            
        // if verification members have been selected
        if($u != '')
        {
            $userId =  $u;
        }

        if($totalTarget == 0)
            $totalTarget = '';

        $colorCode = 'white';
        // Added on  23rd Jan
        if($totalCnt != '' && $totalTarget != '')
        {
            $totalPercentage = $totalCnt/$totalTarget;
            $totalPercentage = $totalPercentage * 100;
            $totalPercentage = round($totalPercentage);
            $totalPercentage .= '%';
        }
        else
            $totalPercentage = '';

        if($totalPercentage == '' || $totalPercentage == 0)
        {
            $colorCode1 = $colorCode;
        }
        else
        {
            if($totalPercentage  >= 100)
                $colorCode1 = 'green'; // '#00FF00';
            else if($totalPercentage  < 80)
                $colorCode1 = 'red' ; // '#FF0000';
            else if($totalPercentage  > 80 && $totalPercentage < 100)
                $colorCode1 = 'orange'; // '#FCAE1E';
            else
                $colorCode1 = $colorCode;
        }


        $html = '';
        $html  = '<tr><td style="padding:5px;border:1px solid black;font-weight: bold;">Total';
        $html = $html . '</td>';
        // Added on 18th Jan for target
        $html  = $html . '<td style="padding:5px;border:1px solid black;text-align: right; font-weight: bold;">';
        $html = $html . $totalTarget .  '</td>';

        $html = $html . '<td id="results" style="padding:5px;border:1px solid black;text-align: right;font-weight: bold;">' . $totalCnt . '</td>';

        $html = $html . '<td id="results" style="padding:5px;border:1px solid black;text-align: right;font-weight: bold; color:white;background-color:';
        $html = $html . $colorCode1 . ';">' . $totalPercentage . '</td>';

        
        $html = $html . '<td style="padding:5px;border:1px solid black;font-weight: bold; text-align: right;">';
        $html = $html . anchor("/Activity/vm_new_assigned_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("New")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $totalNewlyAssigned  . "</span>", 'target=_blank' ) . "</td>";

        $arrayOfTotalOfEachCheckStatus[107]=($arrayOfTotalOfEachCheckStatus[107]) ? $arrayOfTotalOfEachCheckStatus[107] : '';
        $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("Initiated")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[107]  . "</span>", 'target=_blank' ) . "</td>";


        $arrayOfTotalOfEachCheckStatus[111]=($arrayOfTotalOfEachCheckStatus[111]) ? $arrayOfTotalOfEachCheckStatus[111] : '';
        $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("Verified")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[111]  . "</span>", 'target=_blank' ) . "</td>";


        $arrayOfTotalOfEachCheckStatus[1002]=($arrayOfTotalOfEachCheckStatus[1002]) ? $arrayOfTotalOfEachCheckStatus[1002] : '';
        $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("QCRevertClosed")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[1002]  . "</span>", 'target=_blank' ) . "</td>";

        $arrayOfTotalOfEachCheckStatus[1005]=($arrayOfTotalOfEachCheckStatus[1005]) ? $arrayOfTotalOfEachCheckStatus[1005] : '';
        $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("Reminder")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[1005]  . "</span>", 'target=_blank' ) . "</td>";

        $arrayOfTotalOfEachCheckStatus[992]=($arrayOfTotalOfEachCheckStatus[992]) ? $arrayOfTotalOfEachCheckStatus[992] : '';
        $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("DDApplied")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[992]  . "</span>", 'target=_blank' ) . "</td>";


        $arrayOfTotalOfEachCheckStatus[1001]=($arrayOfTotalOfEachCheckStatus[1001]) ? $arrayOfTotalOfEachCheckStatus[1001] : '';
        $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("RevertedToDEO")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[1001]  . "</span>", 'target=_blank' ) . "</td>";


        $arrayOfTotalOfEachCheckStatus[1004]=($arrayOfTotalOfEachCheckStatus[1004]) ? $arrayOfTotalOfEachCheckStatus[1004] : '';
        $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("ReOpen")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[1004]  . "</span>", 'target=_blank' ) . "</td>";


        $arrayOfTotalOfEachCheckStatus[684]=($arrayOfTotalOfEachCheckStatus[684]) ? $arrayOfTotalOfEachCheckStatus[684] : '';$html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("RequestRaised")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[684]  . "</span>", 'target=_blank' ) . "</td>";


        $arrayOfTotalOfEachCheckStatus[1006]=($arrayOfTotalOfEachCheckStatus[1006]) ? $arrayOfTotalOfEachCheckStatus[1006] : '';

        $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right; font-weight: bold;">' ;
        $html = $html . anchor("/Activity/vm_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("TicketReopen")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $arrayOfTotalOfEachCheckStatus[1006]  . "</span>", 'target=_blank' ) . "</td></tr>";

        
        echo $html;

    }   


    /*********************************************************************
     * vm_new_assigned_activity
     * Added by MN on 07th Oct 2022
     * 
     *****************************************************/    
    function vm_new_assigned_activity()
    {
        $title=base64_decode($this->uri->segment(5));
        if($title=='New'){
            $Newtitle='New';
        }
        else
        {
            $Newtitle= '';
        }


         // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push("Activity - Assigned", 'Activity/new');

        $data['new_title']=$Newtitle;
        $data['breadcrumb']=$this->breadcrumbs->show();  
        
        $this->amodel->pagerender($data, 'vm_new_assigned_activity');

    }


    /*********************************************************************
     * get_vm_assigned_list
     * Added by MN on 07th Oct 2022
     * Modified on 03rd Jan '23 to show the assigned list according to the count in activity sheet
     * 
     *****************************************************/
    function get_vm_assigned_list()
    {
        $model = array('Activity_model'=>'get_vm_assigned_list');

        $check_count = ($_REQUEST['check_count']) ? $_REQUEST['check_count'] : 'New';
        $userId  = ($_REQUEST['userId']) ? $_REQUEST['userId'] : '';
        $frmDate = ($_REQUEST['frmDate']) ? $_REQUEST['frmDate'] : '';
        $toDate  = ($_REQUEST['toDate']) ? $_REQUEST['toDate'] : '';
        // Added by MN
        $status  = ($_REQUEST['status']);  //  User active or inactive status

        
        if($userId==0){
            $condition[]=" a.role_id = 5";
        }
        else{
            if($this->session->userdata['role_id']==5){
                $condition[]=" vs.team_mem_id = ".$this->session->userdata['userid'] . " and a.role_id = 5";
            }else{
                // include more than 1 user id
                $condition[]=" vs.team_mem_id IN (".$userId . ") and a.role_id = 5";
            }
            
        }

        // Added by MN for checking condition User active or inactive status
        $condition[]="u.status = " . $status;
        
        $condition[] = " (DATE_FORMAT(vr.deadline_from ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(vr.deadline_from ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')";

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        if ($result) {
            $checkteam = $this->config->item('CHECKLIST',APPLICATIONCONFIG);
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            $k=1;

            foreach( $result as $i => $row ) {      
                $candidatename=$row['candidatename'];

                if($row['chk']==0){
                    $chkval=$row['checkname'];
                }else{
                    $chkval=$row['checkname'].$row['chk'];
                }

                // Added by MN - to show verified  status like 'Verified-Written-Clear' etc.,
                $verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
                $verification_data=toArray(json_decode($verified_data['fielddata']));

                $status1=$this->vm->get_status($verification_data['status']);
                $status4='';
                $status2=$this->vm->get_status($verification_data['pstatus']);
                $status3=$this->vm->get_status($verification_data['status1']);
                if($verification_data['ostatus']<>'')
                $status4=$this->vm->get_status($verification_data['ostatus']);
                if($verification_data['dstatus']<>'')
                $status4=$this->vm->get_status($verification_data['dstatus']);
                if(!empty($status4))
                $status41='-'.$status4['name'];
                else
                $status41='';

                // Form a string like 'Verified-Written-Clear' etc.,
                if(!empty($status1['name'])){
                    $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
                }else{
                    $stat='';
                }

                // To  show whether Check status is GREEN, RED or ORANGE
                $rpt_status='';
                if($row['checkId']==1306) { // ka added on april 25
                $rpt_status='';
                } // ka added on april 25
                else if($verification_data['status']!=107 && $verification_data['status']!=684 && $verification_data['status']!=992 && !empty($verification_data['status'])) {
                    if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                        $rpt_status="<span style='color:red;'>RED</span>";
                    }
                    // May 24th
                    else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                        $rpt_status="<span style='color:orange;'>ORANGE</span>";
                    }
                    else 
                    {
                        $rpt_status="<span style='color:green;'>GREEN</span>";
                    }
                }


            switch($row['status']){
                case 107:
                    $status='Initiated';
                break;
                case 111:
                    $status='Verified';
                break;
                case 110:
                    $status='Stop Check';
                break;
                case 519:
                    $status='Others';
                break;
                case 684:
                    $status='Request Raised';
                break;
                case 992:
                    $status='DD Applied';
                break;
                case 1001:
                    $status='Reverted to DEO';
                break;
                case 1002:
                    $status='QC Revert Closed';
                break;
                case 1004:
                    $status='Re-Open';
                break;
                case 1005:
                    $status='Reminder Sent';
                break;
                case 1006:
                    $status='Tickets Re-Opened';
                break;
                default:
                    $status='New';
            }

            // build a response 
            $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],$candidatename,$row['case_no'],$chkval,$status,$stat, $rpt_status,date('d-m-Y h:i:s',strtotime($row['date'])),$row['role_name'],$row['user_name']);
          

            }
        }
        echo json_encode($response);
    }

    // calling model function to get all verification members for the dropdown or multiple select box
    function get_vmembers()
    {
        $this->am->get_vmembers();
    }

    // calculate daily target for a given date  and return it
    function daily_target($allMemberTargets, $oneDay, $users,  $origin)
    {
        $targetForADay =  0;
        $arrayOfCheckStatus = array(107 => 0, // Initiated
                                    111 => 0,
                                    1002 =>0,  // QC Reverts closed
                                    1003 =>0,
                                    1005=>0,  // Reminders
                                    992 => 0, // DD Applied
                                    1001=> 0, // Reverted  to DEO
                                    1004 => 0, // Reopened
                                    684 => 0, // Request  Raised
                                    1006=> 0, // Tickets Reopened
                                    111 => 0, // Verify
                                    110 => 0, // Stop checks
                                    519 => 0,  // Others
                                    1110 => 0, // Reopened and Stop check status // 16th Jan '23
                                    1519 => 0,  // Reopened and Others status // 16th Jan '23
                                    1007 => 0
        ); // end of arrayOfCheckStatus

        // if 1  or more verification members are selected
        if($origin <> 0)
        {
            $userArray = explode(',',  $users);
            $count = count($userArray); 
            for($i=0 ; $i < $count; $i++)
            {
                foreach($allMemberTargets as  $row)
                {   
                    $user_id = $row['user_id'];
                    if($user_id  == $userArray[$i])                 
                    {
                        // taking  each date in the search range individually
                        $individualDate = date_create($row['updateDate']);
                        $j = date_format($individualDate,"d-m-Y");
                        $k = date_format($oneDay,"d-m-Y");
                        if($j == $k)
                        {
                            $checkStatus = $row['check_status'];
                
                            // Check if check_status exists as a 'key' in the arrayOfCheckStatus we have defined
                            $keyExists = array_key_exists($checkStatus, $arrayOfCheckStatus);
                            
                            // if the check_status exists in the arrayOfCheckStatus we have defined, then fill the array
                            // with status which is nothing but count(check_status)
                            if($keyExists)
                            {
                                $targetForADay += $row['target'];
                                break;
                            }

                        }
                    }

                }
                    
            }
        }
        else // for all verification members
        {
            foreach($users as $user)
            {
                $id = $user['user_id'];
                foreach($allMemberTargets as  $row)
                {   
                    $user_id = $row['user_id'];
                    if($id  == $user_id)                    
                    {
                        // taking  each date in the search range individually
                        $individualDate = date_create($row['updateDate']);
                        $j = date_format($individualDate,"d-m-Y");
                        $k = date_format($oneDay,"d-m-Y");
                        if($j == $k)
                        {
                            $checkStatus = $row['check_status'];
                
                            // Check if check_status exists as a 'key' in the arrayOfCheckStatus we have defined
                            $keyExists = array_key_exists($checkStatus, $arrayOfCheckStatus);
                            
                            // if the check_status exists in the arrayOfCheckStatus we have defined, then fill the array
                            // with status which is nothing but count(check_status)
                            if($keyExists)
                            {
                                $targetForADay += $row['target'];
                                break;
                            }


                        }
                    }

                }
                    
            }

        }
        return $targetForADay;
    }

    // calculate monthly target for a given date  and return it
    function monthly_target($allMemberTargets, $oneDay, $users,  $origin)
    {
        $targetForAMonth =  0;

        $toDate = date_create($oneDay); // create a date variable from a string variable
        $finalDate = date_create($oneDay);

        //  Year of the sent date
        $year = intval($toDate->format('Y'));

        //  Month of the sent date
        $month = intval($toDate->format('m'));
        $date = new DateTime();
        $date->setDate($year, $month, 1);

        $fromDate = $date;

        $arrayOfCheckStatus = array(107 => 0, // Initiated
                                    1002 =>0,  // QC Reverts closed
                                    1005=>0,  // Reminders
                                    992 => 0, // DD Applied
                                    1001=> 0, // Reverted  to DEO
                                    1004 => 0, // Reopened
                                    684 => 0, // Request  Raised
                                    1006=> 0, // Tickets Reopened
                                    111 => 0, // Verify
                                    110 => 0, // Stop checks
                                    519 => 0,  // Others
                                    1110 => 0, // Reopened and Stop check status // 16th Jan '23
                                    1519 => 0  // Reopened and Others status // 16th Jan '23
        ); // end of arrayOfCheckStatus

        // if verification members are selected
        if($origin <> 0)
        {
            $userArray = explode(',',  $users);
            $count = count($userArray); //echo '<br> oneDay ==> ' ; 
            for($i=0 ; $i < $count; $i++)
            {
                $d = date_create($oneDay);
                $diff=date_diff($fromDate,$d);
            
                for(;$diff->format("%R%a") >= 0;)
                {
                    foreach($allMemberTargets as  $row)
                    {   
                        $user_id = $row['user_id'];
                        $individualDate = date_create($row['updateDate']);
                        $j = date_format($individualDate,"d-m-Y");
                        $k = date_format($d,"d-m-Y");
                        if($j == $k)
                        {
                            if($user_id  == $userArray[$i])                 
                            {
                                $checkStatus = $row['check_status'];
                    
                                // Check if check_status exists as a 'key' in the arrayOfCheckStatus we have defined
                                $keyExists = array_key_exists($checkStatus, $arrayOfCheckStatus);
                                
                                // if the check_status exists in the arrayOfCheckStatus we have defined, then fill the array
                                // with status which is nothing but count(check_status)
                                if($keyExists)
                                {
                                    $targetForAMonth += $row['target'];
                                    break;
                                }

                            }
                        }

                    }

                    date_add($d,date_interval_create_from_date_string("-1 day"));
                    $diff=date_diff($fromDate,$d);
                }

            }
        }
        else
        {
            foreach($users as $user)
            {
                $id = $user['user_id'];
                $d = date_create($oneDay);
                $diff=date_diff($fromDate,$d);
                for(;$diff->format("%R%a") >= 0; )
                {
                    foreach($allMemberTargets as  $row)
                    {   
                        $user_id = $row['user_id'];
                        $individualDate = date_create($row['updateDate']);
                        $j = date_format($individualDate,"d-m-Y");
                        $k = date_format($d,"d-m-Y");
                        if($j == $k)                
                        {
                            if($id  == $user_id)
                            {
                                $checkStatus = $row['check_status'];
                    
                                // Check if check_status exists as a 'key' in the arrayOfCheckStatus we have defined
                                $keyExists = array_key_exists($checkStatus, $arrayOfCheckStatus);
                                
                                // if the check_status exists in the arrayOfCheckStatus we have defined, then fill the array
                                // with status which is nothing but count(check_status)
                                if($keyExists)
                                {
                                    $targetForAMonth += $row['target'];
                                    break;
                                }


                            }
                        }

                    }
                    date_add($d,date_interval_create_from_date_string("-1 day"));
                    $diff=date_diff($fromDate,$d);
                }
            }

        }
        return $targetForAMonth;
    }


     /***************************     export_vm_newList   **********************   
     * Added by MN - for exporting newly assigned checks to verification members shown in Activity sheet
     * Modified on 03rd Jan '23 to export the assigned list according to the  count in activity sheet
    /***************************************************************************/
    function export_vm_newList()
    {  
         // model name and method name
        $model = array('Activity_model'=>'export_vm_newList');
        
        $check_count = ($_REQUEST['exp_check_count']) ? $_REQUEST['exp_check_count'] : ''; // New
        $userId  = ($_REQUEST['exp_userId']) ? $_REQUEST['exp_userId'] : '0';
        $frmDate = ($_REQUEST['exp_frmDate']) ? $_REQUEST['exp_frmDate'] : '';
        $toDate  = ($_REQUEST['exp_toDate']) ? $_REQUEST['exp_toDate'] : '';        
        $status  = ($_REQUEST['exp_status']);  //  User active or inactive status

        if($userId==0){
            $condition[]=" a.role_id = 5";
        }
        else{
            if($this->session->userdata['role_id']==5){
                 // we want only those done by a verification member
                $condition[]=" vs.team_mem_id = ".$this->session->userdata['userid'] . ' and a.role_id=5';
            }else{
                // include more than 1 user id
                $condition[]=" vs.team_mem_id  IN (".$userId . ")  and a.role_id=5";
            }
            
        }

         // checking user active or inactive status
        $condition[]="u.status = " . $status;

        // data  between from and to date
        $condition[] = " (DATE_FORMAT(vr.deadline_from ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(vr.deadline_from ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')";

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); // calling the model method with $manual_cond as argument
        $response = $results[0];  
        $result = $results[1]; 
        
        if ($result) {
             // $checkteam = $this->config->item('CHECKLIST',APPLICATIONCONFIG);
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;

            $objPHPExcel = new PHPExcel(); // Creating an excel object and setting parameters for it.
            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Head Office");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Branch Office");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Sub Office");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Name");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Status");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Verified Status");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "Check Status");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Date");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "Role");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "User");
           
            $ci=2;

            foreach( $result as $i => $row ) {
                $candidatename=$row['candidatename'];
                if($row['chk']==0){
                    $chkval=$row['checkname'];
                }else{
                    $chkval=$row['checkname'].$row['chk'];
                }

                 // Keeping the below code  for uniformity purposes
                 // to show verified  status like 'Verified-Written-Clear' etc., 
                $verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
                $verification_data=toArray(json_decode($verified_data['fielddata']));

                $status1=$this->vm->get_status($verification_data['status']);
                $status4='';
                $status2=$this->vm->get_status($verification_data['pstatus']);
                $status3=$this->vm->get_status($verification_data['status1']);
                if($verification_data['ostatus']<>'')
                $status4=$this->vm->get_status($verification_data['ostatus']);
                if($verification_data['dstatus']<>'')
                $status4=$this->vm->get_status($verification_data['dstatus']);
                if(!empty($status4))
                $status41='-'.$status4['name'];
                else
                $status41='';

                // Form a string like 'Verified-Written-Clear' etc.,
                if(!empty($status1['name'])){
                    $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
                }else{
                    $stat='';
                }

                // To  show whether Check status is GREEN, RED or ORANGE
                $rpt_status='';
                if($row['checkId']==1306) { // ka added on april 25
                    $rpt_status='';
                } // ka added on april 25
                else if($verification_data['status']!=107 && $verification_data['status']!=684 && $verification_data['status']!=992 && !empty($verification_data['status'])) {
                    if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                        $rpt_status="RED";
                    }
                    // May 24th
                    else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                        $rpt_status="ORANGE";
                    }
                    else 
                    {
                        $rpt_status="GREEN";
                    }
                }
                
                $status = 'New';
                $objPHPExcel->getActiveSheet()->getStyle('A1:N1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                                      ->setCellValue('B' . $ci, $row['org_name'])
                                      ->setCellValue('C' . $ci, $row['parent_office'])
                                      ->setCellValue('D' . $ci, $row['office_name'])
                                      ->setCellValue('E' . $ci, $row['sub_office'])
                                      ->setCellValue('F' . $ci, $candidatename)
                                      ->setCellValue('G' . $ci, $row['case_no'])
                                      ->setCellValue('H' . $ci, $chkval)
                                      ->setCellValue('I' . $ci, $status)
                                      ->setCellValue('J' . $ci, $stat)
                                      ->setCellValue('K' . $ci, $rpt_status)
                                      ->setCellValue('L' . $ci, date('d-m-Y h:i:s',strtotime($row['date'])))
                                      ->setCellValue('M' . $ci, $row['role_name'])
                                      ->setCellValue('N' . $ci, $row['user_name']);
                $ci++;                
            } 
            $this->export_excel('A','N','VM_Assigned_List_',$objPHPExcel); // An excel file with abov is created.
            exit; 
        }
        
    }
   

   /****/
    // MN changed code for including  verify status and check status -> 30th Sep 2022
    //  Edited on 16th  Jan '23 to include Reopen Others and Stop Check along with Reopen Verified
   function export_vmactivitylist()
   {  
        $model = array('Activity_model'=>'export_vmactivitylists');
        $check_count = ($_REQUEST['exp_check_count']) ? $_REQUEST['exp_check_count'] : '';
        $userId  = ($_REQUEST['exp_userId']) ? $_REQUEST['exp_userId'] : '0';
        $frmDate = ($_REQUEST['exp_frmDate']) ? $_REQUEST['exp_frmDate'] : '';
        $toDate  = ($_REQUEST['exp_toDate']) ? $_REQUEST['exp_toDate'] : '';
        // Added by MN
        $status  = ($_REQUEST['exp_status']);  //  User active or inactive status

        if($userId==0){
            
        }
        else{
            if($this->session->userdata['role_id']==5){
                $condition[]=" a.user_id = ".$this->session->userdata['userid'];
            }else{
                // code changed by MN on 7th Sep 22 to include more than 1 user id
                $condition[]=" a.user_id IN (".$userId . ")";
            }
            
        }

        // Added by MN for checking condition User active or inactive status
        $condition[]="u.status = " . $status;
        

        if($check_count == 'Initiated')
        {
            $condition[]=" a.check_status=107 and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') "; 
        }
        
        /**************** Verified *****************/
        else if($check_count == 'Verified'){
            $condition[]=" a.check_status in(111,110,519) and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";
        }
        
        /**************** QCRevertClosed *****************/
        else if($check_count == 'QCRevertClosed'){
                $condition[]=" a.check_status=1002 and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";
        }
        
        /**************** Reminder *****************/
        else if($check_count == 'Reminder'){
            $condition[]=" a.check_status=1005 and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";
        }
        
        /**************** DDApplied *****************/
        else if($check_count == 'DDApplied'){
            $condition[]=" a.check_status=992 and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";
        }
        
        /**************** RevertedToDEO *****************/
        else if($check_count == 'RevertedToDEO'){
            $condition[]=" a.check_status=1001 and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";
        }

        //  Edited on 16th  Jan '23 to include Reopen Others and Stop Check  along with Reopen Verified
        /**************** ReOpen *****************/
        else if($check_count == 'ReOpen'){
            $condition[]=" a.check_status in(1004,1110,1519) and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";
        }
        else if($check_count == 'RequestRaised'){
            $condition[]=" a.check_status=684 and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";
        }
        /**************** TicketReopen *****************/
        else if($check_count == 'TicketReopen'){
            $condition[]=" a.check_status=1006 and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";
        }
        else
        {
            // Added by MN
            //  Edited on 16th  Jan '23 to include Reopen Others and Stop Check along with Reopen Verified
            /**************** All Activities *****************/
            $condition[]=" a.check_status in(107,111,110,519,684,992,1001,1002,1004,1005,1006,1110,1519) and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') ";

        }  

        if($term)
        {
        //support multiple words
        $search = explode(' ', $term);

        foreach($search as $t) {
        $not        = '';
        $operator    = 'OR';
        if(substr($t,0,1) == '-')
        {
        $not        = 'NOT ';
        $operator    = 'AND';
        //trim the - sign off
        $t        = substr($t,1,strlen($t));
        }
        }
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        if ($result) {
            $checkteam = $this->config->item('CHECKLIST',APPLICATIONCONFIG);
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            //$k=1;
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);


            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Head Office");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Branch Office");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Sub Office");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Name");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Status");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Verified Status");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "Check Status");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Date");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "Role");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "User");
           
            $ci=2;

        foreach( $result as $i => $row ) {
        
            $candidatename=$row['candidatename'];
        

            if($row['chk']==0){
                $chkval=$row['checkname'];
            }else{
                $chkval=$row['checkname'].$row['chk'];
            }

            // Added by MN - to show verified  status like 'Verified-Written-Clear' etc.,
            $verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
            $verification_data=toArray(json_decode($verified_data['fielddata']));

            $status1=$this->vm->get_status($verification_data['status']);
            $status4='';
            $status2=$this->vm->get_status($verification_data['pstatus']);
            $status3=$this->vm->get_status($verification_data['status1']);
            if($verification_data['ostatus']<>'')
            $status4=$this->vm->get_status($verification_data['ostatus']);
            if($verification_data['dstatus']<>'')
            $status4=$this->vm->get_status($verification_data['dstatus']);
            if(!empty($status4))
            $status41='-'.$status4['name'];
            else
            $status41='';

            // Form a string like 'Verified-Written-Clear' etc.,
            if(!empty($status1['name'])){
                $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
            }else{
                $stat='';
            }

            // To  show whether Check status is GREEN, RED or ORANGE
            $rpt_status='';
            if($row['checkId']==1306) { // ka added on april 25
                $rpt_status='';
            } // ka added on april 25
            else if($verification_data['status']!=107 && $verification_data['status']!=684 && $verification_data['status']!=992 && !empty($verification_data['status'])) {
                if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                    $rpt_status="RED";
                }
                /** Aug 24th **/
                else if($status1['name']=="Others" && $status4['name']=="Not applicable")
                {
                    $rpt_status="GREEN";
                }
                /** Aug 24th **/
                // May 24th
                else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                    $rpt_status="ORANGE";
                }
                else 
                {
                    $rpt_status="GREEN";
                }
            }
            switch($row['status']){
                case 107:
                    $status='Initiated';
                break;
                case 111:
                    $status='Verified';
                break;
                case 110:
                    $status='Stop Check';
                break;
                case 519:
                    $status='Others';
                break;
                case 684:
                    $status='Request Raised';
                break;
                case 992:
                    $status='DD Applied';
                break;
                case 1001:
                    $status='Reverted to DEO';
                break;
                case 1002:
                    $status='QC Revert Closed';
                break;
                // Edited on 16th Jan '23  
                case 1004: // Reopen Verified
                case 1110:  // Reopen Stop check
                case 1519: // Reopen Others
                    $status='Re-Open Closed';
                break;
                case 1005:
                    $status='Reminder Sent';
                break;
                case 1006:
                    $status='Tickets Re-Opened';
                break;
                default:
                    $status="";
            }


           $objPHPExcel->getActiveSheet()->getStyle('A1:N1')->getFont()->setBold(true);
           $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                                      ->setCellValue('B' . $ci, $row['org_name'])
                                      ->setCellValue('C' . $ci, $row['parent_office'])
                                      ->setCellValue('D' . $ci, $row['office_name'])
                                      ->setCellValue('E' . $ci, $row['sub_office'])
                                      ->setCellValue('F' . $ci, $candidatename)
                                      ->setCellValue('G' . $ci, $row['case_no'])
                                      ->setCellValue('H' . $ci, $chkval)
                                      ->setCellValue('I' . $ci, $status)
                                      ->setCellValue('J' . $ci, $stat)
                                      ->setCellValue('K' . $ci, $rpt_status)
                                      ->setCellValue('L' . $ci, date('d-m-Y h:i:s',strtotime($row['date'])))
                                      // ->setCellValue('L' . $ci, $row['candidate_req_id'])
                                      // ->setCellValue('M' . $ci, $row['checkId'])
                                      // ->setCellValue('N' . $ci, $row['level_id']);
                                      ->setCellValue('M' . $ci, $row['role_name'])
                                      ->setCellValue('N' . $ci, $row['user_name']);
            $ci++;
                
            } 
             $this->export_excel('A','N','VMActivity_List_',$objPHPExcel);
        exit; 
        }
        
    }


    /**********************************
     ***** QC2 Activity ***************
     *** function qc2_activity ********
     ******** By Chandan Kp ***********
     **********************************/

    function qc2_activity() {
        $fromDate=date('d-m-Y');
        $toDate=date('d-m-Y');
        $data['fromDate']=$fromDate;
        $data['toDate']=$toDate;
        
        if($this->session->userdata['role_id']==17){
            $userId=$this->session->userdata['userid'];
        }

        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('QC2 Activity Sheet', 'Activity/qc2_activity');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'qc2_activity');
    }

    /**********************************
     ***** QC2 Activity Datewise ***************
     *** function get_qc2Activity_datewise ********
     ******** By Chandan Kp ***********
     **********************************/

    function get_qc2Activity_datewise()
    {
        //  If _POST is not  empty   
        print_r($_POST);
        // exit; 
        if(!empty($_POST)){
            // print_r($_POST);exit;
            $fromDate=$_POST['fp_fdate']; 
            $toDate=$_POST['fp_tdate'];
            $list =$_POST['viewType'];
            $status=$_POST['status'];

            if(!empty($_POST['qc_member'])){
                $qcmember_Id=$_POST['qc_member'];
                
                if(is_array($qcmember_Id))
                {
                    $u = '';
                    $u = implode(',', $qcmember_Id); //  Convert array into string
                }
                else
                {
                    $u = $qcmember_Id;
                }
            
            }else{
                if($this->session->userdata['role_id']==17){
                    $userId=$this->session->userdata['userid'];
                }else{
                    $userId=0;
                }
                
            }

        }
        else{
            // _POST  IS  empty
            $fromDate=date('d-m-Y');
            $toDate=date('d-m-Y');
            $status=1;
            $list =1;
            $data['fromDate']=$fromDate;
            $data['toDate']=$toDate;
            if($this->session->userdata['role_id']==17){
                $userId=$this->session->userdata['userid'];
            }else{
                $userId=0;
            }

        }
        
        // initializing for loop variable $i with $toDate
        $i = date_create($toDate); // create a date variable from a string variable
        $toDate = date_create($toDate); // create a date variable from a string variable
        $fromDate = date_create($fromDate);
        
        $colorCode = 'white';
        // Target added on 18th Jan 
        $html = '<tr style="background-color:#096db3;">
                    <th style="padding:5px;border:1px solid black;font-weight: bold;width:100px;color:white;">Date</th>
                    <th style="padding:5px;border:1px solid black;font-weight: bold;width:90px;color:white;">Target</th>
                    <th style="padding:5px;border:1px solid black;font-weight: bold;width:90px;color:white;">
                        Report Published
                    </th>
                    <th style="padding:5px;border:1px solid black;font-weight: bold;width:90px;color:white;">
                        % Achievment
                    </th>
                    <th style="width:90px;padding:5px;border:1px solid black;font-weight: bold;color:white;">
                        With in TAT
                    </th>
                    <th style="width:90px;padding:5px;border:1px solid black; font-weight: bold;color:white;">
                        % With in TAT
                    </th>
                    <th style="width:90px;padding:5px;border:1px solid black; font-weight: bold;color:white;">
                        Average TAT (in days)
                    </th>
                    <th style="width:90px;padding:5px;border:1px solid black; font-weight: bold;color:white;">
                        Revert To VM
                    </th>
                    <th style="padding:5px;border:1px solid black; font-weight: bold;width:90px;color:white;">
                        Assigned
                    </th>
                </tr>';
        echo $html;

        $html = '';
        
        // $arrayOfTotalOfEachCheckStatus =  array(107 => 0, // Initiated
        //                                         1003=>0,  // Revert To VM
        //                                         1007 => 0
        // ); // end of arrayOfTotalOfEachCheckStatus

        $noOfWorkingDays  = 0;
        $holidayCount = 0;
        $totalNewlyAssigned = '';

        /* Showing data in  the form  of  months when 'Monthly' is selected in the drop down box */
        if($list == '2')
        {
            $html  = '';
        }
        /* code for showing data in  the form  of  months ends  here */
        else
        {
            /* day wise information */
            // If verification members are selected
            if($u != '')
            {
                
                $allActivities=$this->am->get_datewise_qc2activity(date_format($fromDate, 'd-m-Y'),date_format($toDate, 'd-m-Y'), $u, $status);
                // print_r($allActivities);exit;
                $allMemberTargets = $this->am->get_qc2target_memberwise(date_format($fromDate, 'd-m-Y'),date_format($toDate, 'd-m-Y'), $u, $status);
                // print_r($allMemberTargets);exit;
            }
            else
            {
                $allActivities=$this->am->get_datewise_qc2activity(date_format($fromDate, 'd-m-Y'),date_format($toDate, 'd-m-Y'), $userId, $status);
                $allMemberTargets = $this->am->get_qc2target_memberwise(date_format($fromDate, 'd-m-Y'),date_format($toDate, 'd-m-Y'), $userId, $status);
                
            }

            
            /************************* GET HOLIDAYS FOR THIS YEAR FROM  MASTER_HOLIDAYS TABLE ***********************/
            $allHolidays=$this->am->get_masterholidays();

            // added on 18th Jan for target
            $totalTarget =  0;
            $totalTat=0;
            $dailyRecCount=0;
            // Looping through all the dates given in the SEARCH range in  descending  order
            for(;$i >= $fromDate; date_add($i,date_interval_create_from_date_string("-1 day")))
            {
                $dailyTat=0;


                // count of all checks in a single day
                $dayCnt ='';            

                $colorCode = 'white';

                $arrayOfCheckStatus = array(111 => 0, // veryfied
                                            'target' => 0, // target of each user
                                            'tatstatus' => 0,
                                            1003 =>0,  // Revert To Vm
                                            1007 => 0  // QC Publish
                ); // end of arrayOfCheckStatus
                
                // 0 = Sunday,  1 = Monday etc.,
                $dayofweek = intval($i->format('w'));
                
                // If the day is Sunday, the  background-color needs  to be  grey
                if($dayofweek == 0)
                {
                    $colorCode = '#e9e8e8'; //'#a9a4a4';
                }


                /************ Checking  for Second and Fourth Saturday **************/
                // If the day is either  2nd or 4th Saturday,  the background-color needs tobe  grey
                if($dayofweek == 6)
                {
                    $str = date_format($i,"Y-m-d");
                    $someDate = date_create($str);
                    
                    $firstDate = $someDate->modify('first day of this month');
                
                    // Returns an integer value from 0  to 6, 0 - Sunday, 1- Monday and so on
                    $val = $firstDate->modify('first day of this month')->format('w');
                    
                    // Calculate  2nd and 4th  Saturdays using  the first day of the month 
                    switch($val)
                    {
                        case 0: // Sunday
                            $secondSat = date_add($firstDate,date_interval_create_from_date_string("13 days"));
                            if($i == $secondSat)
                            { 
                                $colorCode = '#e9e8e8';
                                break;
                            }
                            $fourthSat = date_add($firstDate,date_interval_create_from_date_string("14 days"));  
                            if($i == $fourthSat)
                            {
                                $colorCode = '#e9e8e8';
                                break;
                            }
                            // If the Saturday is not 2nd or 4th then increment the working days
                            $noOfWorkingDays++;
                            break;  

                        case 1: // Monday
                            $secondSat = date_add($firstDate,date_interval_create_from_date_string("12 days"));
                            if($i == $secondSat)
                            {   
                                $colorCode = '#e9e8e8';
                                break;
                            }
                            $fourthSat = date_add($firstDate,date_interval_create_from_date_string("14 days"));  
                            if($i == $fourthSat)
                            {
                                $colorCode = '#e9e8e8';
                                break;                          
                            }
                            // If the Saturday is not 2nd or 4th then increment the working days
                            $noOfWorkingDays++;
                            break;

                        case 2: //  Tuesday
                            $secondSat = date_add($firstDate,date_interval_create_from_date_string("11 days"));
                            if($i == $secondSat)
                            { 
                                $colorCode = '#e9e8e8';
                                break;
                            }
                            $fourthSat = date_add($firstDate,date_interval_create_from_date_string("14 days"));  
                            if($i == $fourthSat)
                            {
                                $colorCode = '#e9e8e8';
                                break;
                            }
                            // If the Saturday is not 2nd or 4th then increment the working days
                            $noOfWorkingDays++;
                            break;

                        case 3: // Wednesday
                            $secondSat = date_add($firstDate,date_interval_create_from_date_string("10 days"));
                            if($i == $secondSat)
                            { 
                                $colorCode = '#e9e8e8';
                                break;
                            }
                            $fourthSat = date_add($firstDate,date_interval_create_from_date_string("14 days"));  
                            if($i == $fourthSat)
                            {
                                $colorCode = '#e9e8e8';
                                break;
                            }

                            // If the Saturday is not 2nd or 4th then increment the working days
                            $noOfWorkingDays++;
                            break;
                            
                        case 4: // Thursday
                            $secondSat = date_add($firstDate,date_interval_create_from_date_string("09 days"));
                            if($i == $secondSat)
                            { 
                                $colorCode = '#e9e8e8';
                                break;
                            }
                            $fourthSat = date_add($firstDate,date_interval_create_from_date_string("14 days"));  
                            if($i == $fourthSat)
                            {
                                $colorCode = '#e9e8e8';
                                break;
                            }
                            
                            // If the Saturday is not 2nd or 4th then increment the working days
                            $noOfWorkingDays++;
                            break;
                
                        case 5: // Friday
                            $secondSat = date_add($firstDate,date_interval_create_from_date_string("08 days"));
                            if($i == $secondSat)
                            { 
                                $colorCode = '#e9e8e8';
                                break;
                            }
                            $fourthSat = date_add($firstDate,date_interval_create_from_date_string("14 days"));  
                            if($i == $fourthSat)
                            {
                                $colorCode = '#e9e8e8';
                                break;
                            }

                            // If the Saturday is not 2nd or 4th then increment the working days
                            $noOfWorkingDays++;
                            break;
                
                        case 6: // Saturday
                            $secondSat = date_add($firstDate,date_interval_create_from_date_string("07 days"));
                            if($i == $secondSat)
                            { 
                                $colorCode = '#e9e8e8';
                                break;
                            }
                            $fourthSat = date_add($firstDate,date_interval_create_from_date_string("14 days"));  
                            if($i == $fourthSat)
                            {
                                $colorCode = '#e9e8e8';                      
                                break;
                            }
                            // If the Saturday is not 2nd or 4th then increment the working days
                            $noOfWorkingDays++; 
                            break;

                        default:
                            break;
                
                    }
                    
                }

                /*************** End of Second  and Fourth Saturday code ************/

                
                foreach($allHolidays as $holiday)
                {               
                    $holidayDate = $holiday['holiday_date'];
                    
                    $holidayDate = date_create($holidayDate);
                    
                    if($holidayDate == $i)
                    {
                        $holidayCount++;
                        $colorCode = '#e9e8e8';
                        // $arrayOfCheckStatus['target'] = '';
                    }
                }       
    
                
                //  If Sunday or Saturday
                if($dayofweek == 0 || $dayofweek == 6)
                {
                    $arrayOfCheckStatus['target'] = '';
                }
                else
                {
                    $noOfWorkingDays++; // Increment the working days if day is weekday   
                }

                if($u != '')
                {
                    $tat['newtat']=$tatdata=$this->am->get_qc2tat_memberwise(date_format($i, 'd-m-Y'),date_format($i, 'd-m-Y'), $u, $status);
                    
                    $assign['qc2assign']=$qcAssigndata=$this->am->get_qc2assignlist(date_format($i, 'd-m-Y'),date_format($i, 'd-m-Y'));
                }
                else
                {
                    $new['newCount']=$this->am->get_new_cases_for_activity(date_format($i, 'd-m-Y'),date_format($i, 'd-m-Y'), $userId, $status);
                }

                foreach($allActivities as $allChecksActivity)
                {
                    // taking  each date in the search range individually
                    $individualDate = date_create($allChecksActivity['updateDate']);

                    //if individualDate is equal to the  date in the outer FOR loop
                    if($individualDate == $i)
                    {
                        $checkStatus = $allChecksActivity['check_status'];
                    
                        $keyExists = array_key_exists($checkStatus, $arrayOfCheckStatus);
                        
                        if($keyExists)
                        {
                            $arrayOfCheckStatus[$checkStatus]=$allChecksActivity['status']; 
                            
                            $dayCnt += $allChecksActivity['status'];

                            $arrayOfTotalOfEachCheckStatus[$checkStatus]  += $allChecksActivity['status'];

                        }
                        
                    }

                }
            
                // print_r($tatdata);
                $withinTat='';
                $tat1=0;
                $tat3=0;
                $tat4=0;
                $tat5=0;
                foreach ($tatdata as $key => $value) {
                    
                    // echo $value['qc_date'];

                    $deadline_from=isset($value['qc_date'])? date('d-m-Y',strtotime($value['qc_date'])) : '';
                    if($value['qc_date']){
                        $deadline_to=isset($value['qc_date'])? date('d-m-Y',strtotime($value['qc_date']. ' +1 day')) : ''; 
                    }
                    else {
                        $deadline_from=isset($value['v_date'])? date('d-m-Y',strtotime($value['v_date'])) : '';
                        $deadline_to=isset($value['v_date'])? date('d-m-Y',strtotime($value['v_date']. ' +1 day')) : ''; 
                    }

                    $reportPublishDate=date('d-m-Y',strtotime($value['updateDate']));

                    if($reportPublishDate == $deadline_from){
                        
                        $tat1+= 0.5;
                        $withinTat+=1;
                    }
                    else{

                        $startDate= $deadline_from;
                        $endDate= $reportPublishDate;
                    
                        $tat3= $this->am->getNumberOfDays($startDate, $endDate);
                        $tat4 = count($tat3);

                        if($tat4 <= 1){
                            $withinTat += 1;
                        }
                        
                        $tat5 +=$tat4;
                    }

                    $dailyTat=($tat1+$tat5);
                    
                }
                
                $totalTat +=$dailyTat;
                $TotalRecCount += $dailyRecCount;
                $dailyRecCount=count($tatdata);
                $avgTat=($dailyTat / $dailyRecCount);
                $avgTat=(is_nan($avgTat) || is_infinite($avgTat)) ? '' : $avgTat;

                $percentWithinTat=($withinTat / $dailyRecCount) * 100;
                $percentWithinTat=(is_nan($percentWithinTat) || is_infinite($percentWithinTat) || $percentWithinTat==0) ? '' : $percentWithinTat.'%';


                $assignToQC='';
                foreach($qcAssigndata as $qcVal){
                $assignToQC += $qcVal['rep_id'];
                }
                
                $qcNewStatus=($assignToQC == 0) ? '' : $assignToQC;
                


            
                if($u != ''){
                    $arrayOfCheckStatus['target'] = $this->daily_target($allMemberTargets, $i, $u, 1);
                }
                else
                {
                    // get all users  according active or  inactive  status
                    $users = $this->am->get_all_vmembers($role_id, $userId, $status);
                    $arrayOfCheckStatus['target'] = $this->daily_target($allMemberTargets, $i, $users, 0);
                }
                
                $totalavgTat=($avgTat) ? number_format($avgTat, 2) : '';

                if($u != '')
                {
                    $userId = $u;
                }


                if($arrayOfCheckStatus['target']==0){

                    foreach($allMemberTargets as $tarVal){
                        $arrayOfCheckStatus['target']=$tarVal['target'];
                    }
                }

            
                $html  = '<tr><td style="width:50px;padding:5px;border:1px solid black;background-color:'. $colorCode . ';">';
                $html = $html . date_format($i,"d-m-Y") ;
                $html = $html . '</td>';

                // if($dayCnt == '' ||  $dayCnt == 0)
                //     $arrayOfCheckStatus['target'] = ''; 

                if($colorCode == '#e9e8e8')
                    $arrayOfCheckStatus['target'] = '';


                $html  .= '<td style="padding:5px;border:1px solid black;text-align: right;background-color:'. $colorCode . ';">';
                $html = $html . $arrayOfCheckStatus['target'];
                $html = $html . '</td>';

                $totalTarget += $arrayOfCheckStatus['target']; 

                $arrayOfCheckStatus[1007]=($arrayOfCheckStatus[1007]) ? $arrayOfCheckStatus[1007] : '';
                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
                $html = $html . $colorCode . ';">';
                $html = $html . anchor("/Activity/qc2activity_list/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("published")."/".base64_encode(date_format($i,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[1007]  . "</span>", 'target=_blank' ) . "</td>";

                if($arrayOfCheckStatus['target'] == '')
                {
                    $percentage = '';
                    $colorCode1 = $colorCode;
                }
                else
                {
                    $percentage = $arrayOfCheckStatus[1007]/$arrayOfCheckStatus['target'];
                    $percentage = $percentage * 100;
                    
                    if($percentage  >= 100)
                        $colorCode1 = 'green'; // #00FF00';
                    else if($percentage  !=0 && $percentage  < 80)
                        $colorCode1 = 'red'; // #FF0000';
                    else if($percentage  > 80 && $percentage < 100)
                        $colorCode1 = 'orange'; //  #FCAE1E';
                    else
                        $colorCode1 = $colorCode;
                }

                if($percentage == 0)
                    $percentage = '';
                else
                {
                    $percentage = round($percentage);
                    $percentage .= '%';
                }
                $html  .= '<td style="padding:5px;border:1px solid black;text-align: right;font-weight: bold;color:  white; background-color:'. $colorCode1 . ';">';
                $html = $html . $percentage;
                $html = $html . '</td>';
            
            
                // Added on 10th Oct
                $html  .= '<td style="padding:5px;border:1px solid black;text-align: right;background-color:'. $colorCode . ';">';
                $html = $html . anchor("/Activity/qc2activity_list/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("withintat")."/".base64_encode(date_format($i,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $withinTat . "</span>", 'target=_blank' ) . "</td>";
            
                $html = $html . '<td style="width:90px;padding:5px;border:1px solid black;text-align: right;background-color:';
                $html = $html . $colorCode . ';">';
                $html = $html .$percentWithinTat."</td>";

                if($arrayOfCheckStatus['target'] == '')
                {
                    $totalavgTat = '';
                    $colorCode1 = $colorCode;
                }
                else
                {
                    
                    if($totalavgTat  !=0 && $totalavgTat  <= 1)
                        $colorCode1 = 'green'; // #00FF00';
                    else if($totalavgTat  !=0 && $totalavgTat  > 1)
                        $colorCode1 = 'red'; // #FF0000';
                    else
                        $colorCode1 = $colorCode;
                }

                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;font-weight:bold; color: white; background-color:';
                $html = $html . $colorCode1 . ';">';
                $html = $html . $totalavgTat . "</td>";

                
                $arrayOfCheckStatus[1003]=($arrayOfCheckStatus[1003]) ? $arrayOfCheckStatus[1003] : '';
                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
                $html = $html . $colorCode . ';">';
                $html = $html . anchor("/Activity/qc2activity_list/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("reverttovm")."/".base64_encode(date_format($i,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $arrayOfCheckStatus[1003]  . "</span>", 'target=_blank' ) . "</td>";

                $arrayOfCheckStatus['qc2assign']=($arrayOfCheckStatus['qc2assign']) ? $arrayOfCheckStatus['qc2assign'] : '';
                $html = $html . '<td style="width:50px;padding:5px;border:1px solid black;text-align: right;background-color:';
                $html = $html . $colorCode . ';">';
                $html = $html . anchor("/Activity/qc2activity_list/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("new")."/".base64_encode(date_format($i,"d-m-Y"))."/".base64_encode(date_format($i,"d-m-Y")), "<span style='color:black'>" . $qcNewStatus  . "</span>", 'target=_blank' ) . "</td>";

                
                echo $html; 

                $TotalNewStatus +=$qcNewStatus;
                $totalCheckStatus[1007] += $arrayOfCheckStatus[1007];
                $TotalWithinTAT +=$withinTat;
                $totalCheckStatus[1003] += $arrayOfCheckStatus[1003];
            }
        }
        
        

        $html = '';
        $html  = '<tr><td style="padding:5px;border:1px solid black;font-weight: bold;">Total';
        $html = $html . '</td>';        

        $html = $html . '<td style="padding:5px;border:1px solid black;text-align: right;font-weight: bold;">';
        $html = $html . $totalTarget  . "</td>";

        $totaRreportPublish=($totalCheckStatus[1007]) ? $totalCheckStatus[1007] : '';
        $html = $html . '<td style="padding:5px;border:1px solid black;text-align: right;font-weight: bold;">' . $totaRreportPublish . '</td>';

        $tPercentage = ($totaRreportPublish / $totalTarget) * 100; 
        $totalPercentage=(is_nan($tPercentage) || is_infinite($tPercentage) || $tPercentage==0) ? '' : number_format($tPercentage, 2).'%' ; 

        if($totalTarget == '')
        {
                $totalPercentage = '';
                $colorCode1 = $colorCode;
        }
        else
        {
                
            if($totalPercentage  >= 100  )
                $colorCode1 = 'green'; // #00FF00';
            else if($totalPercentage  !=0 && $totalPercentage  < 80)
                $colorCode1 = 'red'; // #FF0000';
            else if($totalPercentage  > 80 && $totalPercentage < 100)
                    $colorCode1 = 'orange'; //  #FCAE1E';
            else
                $colorCode1 = $colorCode;
        
        }

        $html = $html . '<td style="padding:5px;border:1px solid black;text-align: right;font-weight: bold;color:white;background-color:';
        $html = $html . $colorCode1 . ';">';
        $html = $html . $totalPercentage ."</td>";

        $TotalWithinTAT=($TotalWithinTAT) ? $TotalWithinTAT : '';
        $html = $html . '<td style="padding:5px;border:1px solid black;text-align: right;font-weight: bold; ';
        $html = $html . $colorCode1 . ';">';
        $html = $html . $TotalWithinTAT . "</td>";

        $tWithinTat=($TotalWithinTAT / $totaRreportPublish) *100;
        $totalWithinTatPercent=(is_nan($tWithinTat) || is_infinite($tWithinTat) || $tWithinTat==0) ? '' : number_format($tWithinTat, 2).'%' ;
        $html = $html . '<td style="padding:5px;border:1px solid black;text-align: right;font-weight: bold;';
        $html = $html . $colorCode1 . ';">';
        $html = $html . $totalWithinTatPercent . "</td>";

        $totalAvgTat=($totalTat/$TotalRecCount);
        $totalAvgTat=(is_nan($totalAvgTat) || is_infinite($totalAvgTat)) ? '' : $totalAvgTat;

        if($totalTarget == '')
        {
            $totalAvgTat = '';
            $colorCode1 = $colorCode;
        }
        else
        {
            if($totalAvgTat  !=0 && $totalAvgTat  <= 1)
                $colorCode1 = 'green'; // #00FF00';
            else if($totalAvgTat  !=0 && $totalAvgTat  > 1)
                $colorCode1 = 'red'; // #FF0000';
            else
                $colorCode1 = $colorCode;
        }

        $html = $html . '<td style="padding:5px;border:1px solid black;text-align: right;font-weight: bold;color:white;background-color:';
        $html = $html . $colorCode1 . ';">';
        $html = $html . number_format($totalAvgTat, 2) . "</td>";

        $RevertToVM =($totalCheckStatus[1003]) ? $totalCheckStatus[1003] : '';
        $html = $html . '<td style="padding:5px;border:1px solid black;text-align: right;font-weight: bold">';
        $html = $html . anchor("/Activity/vm_new_assigned_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("reverted")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $RevertToVM  . "</span>", 'target=_blank' ) . "</td>";
        

        $html = $html . '<td style="padding:5px;border:1px solid black;text-align: right;font-weight: bold;">';
        
        $TotalqcNewStatus = ($TotalNewStatus) ? $TotalNewStatus : '';
        $html = $html . anchor("/Activity/vm_new_assigned_activity/".base64_encode($status)."/".base64_encode($userId)."/".base64_encode("new")."/".base64_encode(date_format($fromDate,"d-m-Y"))."/".base64_encode(date_format($toDate,"d-m-Y")), "<span style='color:black'>" . $TotalqcNewStatus  . "</span>", 'target=_blank' ) . "</td>";
        $html .="</tr>";
        echo $html;

        

    }

    function qc2activity_list(){

        $title=base64_decode($this->uri->segment(5));
        if($title=='published'){
            $Newtitle='Report Publish';
        }
        else if($title=='withintat'){
            $Newtitle='Within TAT'; 
        }
        else if($title=='reverted'){
            $Newtitle='Revert To VM';
        }
        else if($title=='new'){
            $Newtitle='Assigned';
        }
        else{
            $Newtitle= 'All Activities'; 
        }


        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push("QC2 Activity", 'Activity/qc2activity_list');
        $data['new_title']=$Newtitle;
        $data['breadcrumb']=$this->breadcrumbs->show();  
        $this->amodel->pagerender($data, 'qc2activity_list');

    }

    function get_qc2activityList()    {
            
        $model = array('Activity_model'=>'get_qc2activity');
        $check_count = ($_REQUEST['check_count']) ? $_REQUEST['check_count'] : '';
        $userId  = ($_REQUEST['userId']) ? $_REQUEST['userId'] : '0';
        $frmDate = ($_REQUEST['frmDate']) ? $_REQUEST['frmDate'] : '';
        $toDate  = ($_REQUEST['toDate']) ? $_REQUEST['toDate'] : '';
        $status  = ($_REQUEST['status']);  

        // if($userId==0){
            
        // }
        // else{
        //     if($this->session->userdata['role_id']==5){
        //         $condition[]=" a.user_id = ".$this->session->userdata['userid'];
        //     }else{
        //         $condition[]=" a.user_id IN (".$userId . ")";
        //     }
            
        // }

        $condition[]="t.status = " . $status;

        if($check_count == 'published')
        {
            $condition[]=" (DATE_FORMAT(vl1.qc2_date,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."') and (DATE_FORMAT(vl1.qc2_date,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') "; 
        }
         if($check_count == 'reverttovm')
        {
            $condition[]=" ar.verify_status in (111,110,519) AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id and qc1_verification=1  and  ((ar.qc2_verification = 0 and ar.qc1_verification=1 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 2 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 2  and ar.qc1_assign_revert=1 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 0 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2))) and ((DATE_FORMAT(ar.qc2_revert_date,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."')) and ((DATE_FORMAT(ar.qc2_revert_date,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) ";
        }
        
        /**************** New *****************/
        if($check_count == 'new')
        {
            $condition[]=" ar.verify_status in (111,110,519) AND (ar.qc2_verification = 0 and ar.qc1_verification=1 and ar.qc2_revert_request = 0 and vl1.qc2status!=107) and ((DATE_FORMAT(vl1.qc_date,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."') OR (DATE_FORMAT(vl1.v_date,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($frmDate))."')) and ((DATE_FORMAT(vl1.qc_date,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') OR (DATE_FORMAT(vl1.v_date,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."'))"; 
        }

        $manual_cond=implode(' and ',$condition);
             
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0]; 
        $result = $results[1]; 
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;

            foreach ( $result as $i => $row ) {

                $verified_data=$this->vm->get_verified_data($row['request_id'],$row['level_id'],$row['check_id']);
                $verification_data=toArray(json_decode($verified_data['qc2fielddata']));
                $status4='';
                $status1=$this->vm->get_status($verification_data['status']);
                $status2=$this->vm->get_status($verification_data['pstatus']);
                $status3=$this->vm->get_status($verification_data['status1']);
                if($verification_data['ostatus']<>'')
                $status4=$this->vm->get_status($verification_data['ostatus']);
                if($verification_data['dstatus']<>'')
                $status4=$this->vm->get_status($verification_data['dstatus']);
                if(!empty($status4))
                $status41='-'.$status4['name'];
                else
                $status41='';
                $rpt_status='';


            /************************ PF_Verification *************************/
                if($row['check_id'] ==652 ){
                    if($verification_data['status']!=107 && $verification_data['status']!=684 && !empty($verification_data['status'])) {
                            if($status3['name']=="Multiple Active Records" ||$status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                                $rpt_status="<span style='color:red;'>RED</span>";
                            }
                            // May 24th
                            else if( $status3['name']=="No Records" || $status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                                $rpt_status="<span style='color:orange;'>ORANGE</span>";
                            }
                            else 
                            {
                                $rpt_status="<span style='color:green;'>GREEN</span>";
                            }
                        }       
                       
                }

        /********************* PF_Verification *************************************/
                else{ // Start else { PF Verification
                    if($verification_data['status']!=107 && $verification_data['status']!=684 && !empty($verification_data['status'])){
                        if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                                $rpt_status="<span style='color:red;'>RED</span>";
                        }
                            // May 24th
                        else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others"|| $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                            $rpt_status="<span style='color:orange;'>ORANGE</span>";
                        }
                        else 
                        {
                            $rpt_status="<span style='color:green;'>GREEN</span>";
                        }
                    }

                } //END else } PF_Verification    
           
                $slug=url_title(convert_accented_characters($row['name']), 'underscore', TRUE);

                if($row['check_id']==14)
                $levelnames=$this->vm->get_level_name($row['request_id'],$row['check_id'],$row['level_id'],'education_details');
                else if($row['check_id']==16)
                $levelnames=$this->vm->get_level_name($row['request_id'],$row['check_id'],$row['level_id'],'contact_details','request_id','permanent_address');
                else if($row['check_id']==59)
                $levelnames=$this->vm->get_level_name($row['request_id'],$row['check_id'],$row['level_id'],'employment','req_id','level_id');
                else if($row['check_id']==76 || $row['check_id']==77 || $row['check_id']==75)
                $levelnames=$this->vm->get_level_name($row['request_id'],$row['check_id'],$row['level_id'],$slug,'request_id','level_name');
                else
                $levelnames['level']=$row['name'];
               
                $cname=$row['candidate_name'];
                if($row['status']==1)
                {
                if($row['qc2_verification']==0 && $row['qc1_verification']==1 && $row['qc2status']!=107)
                {
                   
                $statusname=$this->vm->get_status_name($row['request_id'],$row['check_id'],$row['level_id'],'qcstatus');
                $status='New';
                $verfier_details = anchor('/Verification/add_calls/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'Call Details','target="_blank"');
                 $procedure_details = anchor('/Verification/add_procedure/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'Procedure Details','target="_blank"');
                $caller_details = anchor('/Verification/add_verifiercalls/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'Verifier Details','target="_blank"');
           
                if($row['qc_revert_request']==0) {
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                    $action_name=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'View');
                }

                else if($row['qc_revert_request']==1 && $row['qc2_revert_request']==0) {
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                    $action_name=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'View');
                }
                else if($row['qc1_assign_revert']==1  && $row['qc_2_verification']==0 && $row['vm_assigned_qc']==1 && $row['reopen_revert_qc2']==0){
                    $status='Revert Closed';
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                $action_name=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'View');
                }
                else if($row['qc1_assign_revert']==1  && $row['supplementary']==1 && $row['qc_2_verification']==0 && $row['vm_assigned_qc']==1 && $row['reopen_revert_qc2'] == 1){
                    $status='Reopen Closed';
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                $action_name=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'View');
                }
                else if($row['qc1_assign_revert']==1){
                    $status='Revert Closed';
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                $action_name=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'View');
                }

                //  Added on March 17th
                else if($row['qc2_revert_request']==1 && $row['reopen_revert_qc2']== 1 && $row['supplementary']==1  && $row['qc2_report_publish']==2)
                {
                    if($row['revertedBy'] == 17)
                    {
                        $status='Revert Raised';
                    }
                    else
                    {
                        $status='Reopened'; 
                    }
                }

                else if($row['qc2_revert_request']==1 && $row['reopen_revert_qc2']== 1 && $row['supplementary']==1  && $row['qc2_report_publish']==1)
                {
                    if($row['revertedBy'] == 17)
                    {
                        $status='Revert Raised';
                    }
                    else
                    {
                        $status='Reopened'; 
                    }
                } // March 17th 

                else if($row['qc2_revert_request']==1 && $row['reopen_revert_qc2']== 1 && $row['supplementary']==1)
                {
                $status='Revert Raised';
                $cname=$row['candidate_name'];
                $action_name='View';
                }

                // March 17th
                // else if($row['qc2_revert_request']==1 && $row['supplementary']==1)
                else if($row['qc2_revert_request']==1 && $row['supplementary']==1 && $row['vm_assigned_qc']==1)
                {
                $status='Reopened';
                $cname=$row['candidate_name'];
                $action_name='View';
                }
                else if($row['qc2_revert_request']==1)
                {
                $status='Revert Raised';
                $cname=$row['candidate_name'];
                $action_name='View';
                }
               
                }
                else
                {
                $statusname=$this->vm->get_status_name($row['request_id'],$row['check_id'],$row['level_id'],'qc2status');
                if($statusname['name']=='Clear'){
                    $status='QC2 Approved';
                    $verfier_details = anchor('/Verification/add_calls/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'Call Details','target="_blank"');
                    $procedure_details = anchor('/Verification/add_procedure/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'Procedure Details','target="_blank"');
                    $caller_details = anchor('/Verification/add_verifiercalls/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'Verifier Details','target="_blank"');
                }else if($statusname['name']=='Verified'){
                    $status='QC2 Approved';
                    $verfier_details = anchor('/Verification/add_calls/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'Call Details','target="_blank"');
                    $procedure_details = anchor('/Verification/add_procedure/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'Procedure Details','target="_blank"');
                    $caller_details = anchor('/Verification/add_verifiercalls/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'Verifier Details','target="_blank"');
                } else if($row['qc2_verification']==0 && $row['qc1_verification']==1 && $row['qc2status']==107){
                    $status='Initiated';
            }else{       
                $status='QC2 Approved';
                $verfier_details = anchor('/Verification/add_calls/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'Call Details','target="_blank"');
                  $procedure_details = anchor('/Verification/add_procedure/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'Procedure Details','target="_blank"');
                $caller_details = anchor('/Verification/add_verifiercalls/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'Verifier Details','target="_blank"');
            }
            if($row['qc_2_verification']==1 && $row['qc2_report_publish']==0)
                {
                    if($row['qc1_assign_revert']==1){
                        $status='QC2 Approved';
                    }else if($row['qc2_revert_request']==1){
                        $status='Revert Raised';
                    }
               
                $cname=anchor('/Verification/qc2_publish/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                $action_name=anchor('/Verification/qc2_publish/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'View');
                }

                elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==1 && $row['supplementary']==1)
                {
                $status='Reopen assigned';
                $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                $action_name=anchor('/Verification/qc2_verified/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'View');
                }
                elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==1)
                {
                $status='Report Published';
                $cname=anchor('/Verification/qc2_verified/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                $action_name=anchor('/Verification/qc2_verified/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'View');
                }
                elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==1 && $row['supplementary']==1)
                {
                $status='Reopen';
                $cname=anchor('/Verification/qc2_verified/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                $action_name=anchor('/Verification/qc2_verified/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'View');
                }
                elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==2 && $row['qc2_revert_request']==0)
                {
                $status='Report Reopen';
                $cname=anchor('/Verification/qc2_publish/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                $action_name=anchor('/Verification/qc2_publish/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'Reopen');
                }elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==2 && $row['qc2_revert_request']==1 && $row['qc1_assign_revert']==0)
                {
                $status='Revert Raised';
                $cname=$row['candidate_name'];
                $action_name='View';
                }
                 // March 17th
                elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==1  && $row['qc1_assign_revert']==1 && $row['vm_assigned_qc']==0)
                {
                    $status='Revert Raised'; 
                } // March 17th

                elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==2  && $row['qc1_assign_revert']==1)
                {
                $status='Revert Raised';
                $cname=anchor('/Verification/qc2_publish/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                $action_name=anchor('/Verification/qc2_publish/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'View');
                }
                //revert status for qc submit qc2 publish reverted
                elseif($row['qc1_assign_revert']==1 && $row['qc_2_verification']==0){
                    $status='Revert Closed';
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                    $action_name=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'View');
                }
                else if($row['qc2_verification']==0 && $row['qc1_verification']==1 && $row['qc2status']==107){
                    $status='Initiated';
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                    $action_name=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'View');
            }
                else{
                $cname=anchor('/Verification/qc2_verified/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                $action_name=anchor('/Verification/qc2_verified/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'View');
                }
                }
                }
                else
                $status='Verification Pending';
            $supplement='';
                if($row['supplementary']==1 && $row['vm_assigned_qc']==1 && $row['qc1_assign_revert']==1 && $row['qc_2_verification']==0)
                {
                    $supplement='Reopen';
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                }
                if($row['supplementary']==1 && $row['vm_assigned_qc']==1 && $row['qc1_assign_revert']==0 && $row['qc_2_verification']==1)
                {
                    $supplement='Reopen';
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                }

                // March 17th
                if($row['supplementary']==1 && $row['vm_assigned_qc']==0 && $row['qc1_assign_revert']==0 && $row['qc_2_verification']==0)
                {
                    $supplement='Reopen';                   
                }

                elseif($row['supplementary']==1 && $row['vm_assigned_qc']==0 && $row['qc1_assign_revert']==0 && $row['qc_2_verification']==1)
                {
                    $supplement='Reopen';
                    $cname=$row['candidate_name'];
                }
                elseif ($row['supplementary']==2 && $row['qc2_verification']==1 && $row['qc2_revert_request']==0 && $row['qc_2_verification']==1) {
                    $supplement='Reopen';
                    $cname=anchor('/Verification/qc2_publish/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                }
                elseif ($row['supplementary']==2 && $row['qc2_verification']==0 && $row['qc2_revert_request']==1 && $row['qc_2_verification']==0) {
                    $supplement='Reopen';
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                }
                elseif($row['supplementary']==3){
                    $supplement='Reopen-Completed';
                }

                if($row['chk']==0){
                $chkval=$row['name'];
            }else{
                $chkval=$row['name'].$row['chk'];
            }
            if(!empty($status1['name'])){
                $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
            }else{
                $stat='';
            }
               
            $deadline_from=isset($row['qc_date'])? date('d-m-Y',strtotime($row['qc_date'])) : '';
            if($row['qc_date']){
                $deadline_to=isset($row['qc_date'])? date('d-m-Y',strtotime($row['qc_date']. ' +1 day')) : ''; 
            }
            else {
                $deadline_from=isset($row['v_date'])? date('d-m-Y',strtotime($row['v_date'])) : '';
                $deadline_to=isset($row['v_date'])? date('d-m-Y',strtotime($row['v_date']. ' +1 day')) : ''; 
            } 
            
            if($row['qc2_date']){
                $rep_PublishedDate=date('d-m-Y',strtotime($row['qc2_date']));
            }else{
                $rep_PublishedDate='';
            }

            if($row['qc2_revert_date']){
                $revert_date=date('d-m-Y',strtotime($row['qc2_revert_date']));
            }else{
                $revert_date='';
            }
            
                
                $response->rows [] ['cell'] = array ( $i+$count+1,  $row['org_name'],$row['parent_office'],$row['office_name'], $cname,$row['case_no'],$chkval,$status,$row['vmname'],$row['qc2name'],$deadline_from,$rep_PublishedDate,$revert_date);
            }
           }
               
          echo json_encode($response);
        }










}

?>
