<?php if (!defined('BASEPATH')) 
{
    exit('No direct script access allowed');
}
require_once ('Common.php');
class Associate extends Common {
    protected static $associate_model = 'Associate_model';
    protected static $education_details_table = 'education_details';
    protected static $contact_details_table = 'contact_details';
    protected static $employment_table = 'employment';
    protected $data_request_id = 'request_id';
    protected $data_check_id = 'check_id';
    protected $data_level_id = 'level_id';
    protected $data_pack_id = 'pack_id';
    protected $data_checks_result = 'checks_result';
    protected $data_revertdetails = 'revertdetails';
    protected $data_candidate_req_id = 'candidate_req_id';
    protected $data_checkid = 'checkid';
    protected $request_id = '';
    protected $check_id = '';
    protected $level_id = '';
    protected $slug = '';
    protected $associate_listrequest = 'Associate/listrequest';
    protected $user_details ='';
    protected $candidate_name ='candidate_name';
    protected $checkname ='checkname';
    protected $users = 'users';
    protected $src_status = 'status';
    protected $rstatus = 'rstatus';
    protected $verify_status = 'verify_status';
    protected $ass_status = 'ass_status';
    protected $vrequest = 'vrequest';
    protected $page_bold = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">';
    protected $associate_users = 'Associate/users';
    function __construct() 
    {
        parent::__construct();
        $this->_check_userlogin ();
        $models = array('Notification_model' => 'nm','Verification_model' => 'vm','Management_model'=>'mm',self::$associate_model=>'am');
        foreach ($models as $file => $object_name) {
            $this->load->model($file, $object_name);
    }
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','jquery-ui-1.10.4','highcharts','exporting','jquery.validate','grid.locale-en','jquery.jqGrid.min','jquery-ui-1.8.16.custom.min','commonjs'));
        $this->load->helper('text');
        }
    
        function request_associate()
        {
                $data[$this->data_request_id]= base64_decode($this->uri->segment(3));       
                $data[$this->data_check_id]= base64_decode($this->uri->segment(5));
                $data[$this->data_level_id] = base64_decode($this->uri->segment(4)); 
                $data[$this->data_checks_result] = $this->vm->get_userlist($data[$this->data_request_id]);
                $data[$this->candidate_name]=$data['checks_result'][0][$this->candidate_name];
                if($this->check_id==14){
                    $data[$this->data_revertdetails]=$this->nm->get_full_details($data[$this->data_request_id],$data[$this->data_check_id],$data[$this->data_level_id],self::$education_details_table,$this->data_request_id,'degree'); 
                }
                if($this->check_id==16){
                    $data[$this->data_revertdetails]=$this->nm->get_full_details($data[$this->data_request_id],$data[$this->data_check_id],$data[$this->data_level_id],self::$contact_details_table,$this->data_request_id,$this->data_level_id); 
                }
                if($this->check_id==59){
                    $data[$this->data_revertdetails]=$this->nm->get_full_details($data[$this->data_request_id],$data[$this->data_check_id],$data[$this->data_level_id],self::$employment_table,'req_id',$this->data_level_id); 
                }
                $this->amodel->pagerender($data, 'request_associative');
        }
        function updaterequest()
        {
            $formData=$_POST;
            $this->nm->update_associate($formData);
            $this->nm->update_logassociate($formData);
            redirect('Verification/allotted_list');
        }
        function listrequest()
        {
            $assignee_list = $this->vm->get_assignee_list_name(); 
            $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list,array('assignee_id','name'));
            $data['breadcrumb']=$this->breadcrumbs->show();
            $this->amodel->pagerender($data, 'request_associative');
        }
        function get_requestlist() { 
        $model = array(self::$associate_model => 'get_requestlist');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
        $a_status = ($_REQUEST[$this->src_status]) ? $_REQUEST[$this->src_status] : '';
        $team = $this->uri->segment(3);
        if($office){
        $condition[]=" a.id = ".$office;
        }
        if($name){
        $condition[]=" b.candidate_name like '%".$name."%'";
        }
        if($a_status==1){
        $condition[]=" a.verify_status =111";
        }
        if($a_status==2){
        $condition[]=" a.verify_status !=111";
        }
        if($team){
                $condition[] = " a.team = ".$team;
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1];  
        $role=$this->session->userdata('role_id');
        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows;
        $checkteam = $this->config->item('CHECKLIST',APPLICATIONCONFIG);
        foreach ( $result as $i => $row ) {
        $checkstatus = $this->vm->getstatus_of_can($row[$this->data_candidate_req_id],$row[$this->data_checkid]);
         if($row[$this->rstatus]==108){
            $vst='Inputs Required';
            }
            else if($row[$this->rstatus]==110){
            $vst='Stop Check';
            }
            else if($row[$this->rstatus]==109){
            $vst='Awaiting Authorisation';
            }
            else{
            $vst='Initiated';
            }
        if($row[$this->verify_status]==111 && $row[$this->ass_status]==1 &&  $row[$this->vrequest]==0 && $row['ass_request']==1 )
        { 
            $check=$i+$count+1;
            if($role==11){
            $verifyurl = $this->page_bold.'Completed</p>';
            }
            else{
            $verifyurl = $this->page_bold.'Verified</p>';
            }
        }
        else if($row[$this->verify_status]<>111  && $row[$this->ass_status]==1  && $row['ass_request']==1 )
        {
            $check=$i+$count+1;
            if($role==11){
            $verifyurl = $this->page_bold.'Assigned</p>';
            }
            else if($row[$this->vrequest]<>0){
            $verifyurl = $this->page_bold.$vst.'</p>';
            }
            else{
            $verifyurl = anchor('/Verification/level_detailsview/'.base64_encode($row[$this->data_candidate_req_id]).'/'.base64_encode($row[$this->data_level_id]).'/'.base64_encode($row[$this->data_checkid]).'/'.base64_encode($row[$this->data_pack_id]),'Verify');
            }
        }
        else if($row[$this->verify_status]=111  && $row['qc_revert_status']==134  && $row['qc_revert_request']==1){
            $check=$i+$count+1;
            if($role==11){
            $verifyurl = $this->page_bold.'Request Assigned</p>';
            }
            else if($row[$this->vrequest]<>0){
            $verifyurl = $this->page_bold.$vst.'</p>';
            }
            else{
            $verifyurl = anchor('/Verification/level_detailsview/'.base64_encode($row[$this->data_candidate_req_id]).'/'.base64_encode($row[$this->data_level_id]).'/'.base64_encode($row[$this->data_checkid]).'/'.base64_encode($row[$this->data_pack_id]),'Verify');
            }
        }
        else
        {
            $check='<input type="checkbox" name="candidate_req_id[]" value="'.($row[$this->data_candidate_req_id]).'" />';
            if($role==11){
            $verifyurl = anchor('/Associate/assign_associate/'.base64_encode($row[$this->data_candidate_req_id]).'/'.base64_encode($row[$this->data_level_id]).'/'.base64_encode($row[$this->data_checkid]).'/'.base64_encode($row[$this->data_pack_id]),'Verify');
            }
            else{
            $verifyurl = $this->page_bold.$vst.'</p>';
            }
        }
        if($row[$this->data_checkid]==14){
            $levelnames=$this->vm->get_level_name($row[$this->data_candidate_req_id],$row[$this->data_checkid],$row[$this->data_level_id],self::$education_details_table);
        }
        if($row[$this->data_checkid]==16){
            $levelnames=$this->vm->get_level_name($row[$this->data_candidate_req_id],$row[$this->data_checkid],$row[$this->data_level_id],self::$contact_details_table,$this->data_request_id,'permanent_address');
        }
        if($row[$this->data_checkid]==59){
            $levelnames=$this->vm->get_level_name($row[$this->data_candidate_req_id],$row[$this->data_checkid],$row[$this->data_level_id],self::$employment_table,'req_id',$this->data_level_id);
        }
        $response->rows [$i] ['cell'] = array ( $check,$row['candidatename'],$row[$this->checkname],$levelnames['level'],$levelnames['details'],$verifyurl,$row[$this->src_status]);
        } 
        }
        echo json_encode($response);
        }
       
        function create()
        {
         /*post action*/
        $id = base64_decode($this->uri->segment(3));
        $title = "Create";
         $this->user_details = $this->amodel->getDetails(DB_PREFIX . "user", array('*'), array('id' => $id)); 
        $user_contact_details = $this->amodel->getDetails(DB_PREFIX . "user_contact_details", array('*'), array('user_id' => $id)); 
        $sql = " Select a.*,b.parentoffice_id from ".DB_PREFIX . "user a
                join  ".DB_PREFIX . "office b on b.id = a.office_id where a.id = ?" ;
        $this->user_details = $this->db->query( $sql, array($id) )->result_array();
        if ($this->user_details) {
            $this->_check_featureauth ( $this->users, 'edit' ); 
            $subtitle = "Modify";
        } else {
            $this->_check_featureauth ( $this->users, 'add' ); 
            $subtitle = "Create";
        } 
        $auth_link = array(     array($this->users,'search','Search','Management/users','') );
        $this->mm->userdml($id);
        /*get url parameters */
        $mess = base64_decode($this->uri->segment(4));
        $formElement = $this->mm->user_formelement($id,$this->user_details);
        $contact_fromelement = $this->mm->user_contact_formelement($id,$user_contact_details);
        $data['formelements'] = create_form($formElement, $this->user_details, $id);
        $data['contact_fromelement'] = create_form($contact_fromelement, $user_contact_details, $id);
        $data['user_details'] = $this->user_details; 
        /*render the views */
        $data['table'] = form($data['formelements'], $formElement, 'user', $this->associate_users, $subtitle, $auth_link, '', base_url());
        $data['contact'] = form($data['contact_fromelement'],$contact_fromelement,'',$this->associate_users,self::$contact_details_table,'','', base_url());
        if($mess) {
            $data['message'] = $mess;
        } 
        else {
            $data['message'] = '';
        }
        /*render the views detail*/
        $this->amodel->pagerender($data, 'user');
        }
        function assign_associate()
        {
            $data[$this->data_request_id]=$this->request_id = base64_decode($this->uri->segment(3));       
            $data[$this->data_check_id]=$this->check_id = base64_decode($this->uri->segment(5));
            $data[$this->data_level_id]=$this->level_id = base64_decode($this->uri->segment(4)); 
            $data[$this->data_pack_id]=$pack_id = base64_decode($this->uri->segment(6));
            $data[$this->data_checks_result] = $this->vm->get_userlist($this->request_id);
            $data[$this->candidate_name]=$data[$this->data_checks_result][0][$this->candidate_name];
            $this->db->select('name');
            $data[$this->checkname]=$this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=> $this->check_id ))->row_array();
            $this->slug=url_title(convert_accented_characters($data[$this->checkname]['name']), 'underscore', TRUE);
            if($pack_id>94){
            $data['chk_Details']=$this->nm->getchkDetails($this->request_id,$pack_id,$this->level_id,$this->slug,$this->check_id);
            }
            else{
            $data['chk_Details']=$this->nm->getchkDetails($this->request_id,$this->check_id,$this->level_id,$this->slug,$this->check_id);
            }
            $data[$this->data_revertdetails]=$this->nm->revertdetails($this->request_id,$this->check_id,$this->level_id); 
            $data['details']=$this->am->get_details($this->request_id,$this->check_id,$this->level_id,$this->slug); 
            $data['title'] = 'New Associate Request'; 
            $this->amodel->pagerender($data, 'new_request');
        }
        function updatestatus()
        {
            $where=array($this->data_candidate_req_id=>$_POST[$this->data_request_id],$this->data_check_id=>$_POST[$this->data_check_id],$this->data_level_id=>$_POST[$this->data_level_id],$this->data_pack_id=>$_POST[$this->data_pack_id]);
            if(empty($where)){
            redirect($this->associate_listrequest);
            }
            $this->db->set($this->ass_status,1);
            $this->db->set('associate_id',$_POST['assignee_id_'.$_POST[$this->data_check_id]]);
            $this->db->where($where);
            $this->db->update(DB_PREFIX.'ver_assign_rep');
            $inslog_data['action']='Allotted to Associate';
            $inslog_data['updated_by'] = $this->user_id;
            $inslog_data['updated_on'] = date ( 'Y-m-d H:i:s' );
            $this->db->where($this->data_request_id,$_POST[$this->data_request_id]);
            $this->db->update ( DB_PREFIX .'loghistory', $inslog_data );
            redirect($this->associate_listrequest);
        }
        function p_newrequest_bulk()
        {
            if(empty($_POST[$this->data_candidate_req_id])){
            redirect($this->associate_listrequest);
            }
            $postData=$_POST;
            if($postData)
            {
                $assignee_id = $this->input->post ( 'assignee_id');
                foreach($postData[$this->data_candidate_req_id] as $key=>$candidate_req_id) {
                if($assignee_id){ 
                    $upd_data = array();
                    $upd_data['associate_id'] = $assignee_id;
                    $upd_data[$this->ass_status]= 1;
                    $this->db->where($this->data_candidate_req_id,$candidate_req_id);
                    $this->db->update ( DB_PREFIX .'ver_assign_rep', $upd_data );
                }
                $inslog_data['action']='Allotted to Associate';
                $inslog_data['updated_by'] = $this->user_id;
                $inslog_data['updated_on'] = date ( 'Y-m-d H:i:s' );
                $this->db->where($this->data_request_id,$candidate_req_id);
                $this->db->update ( DB_PREFIX .'loghistory', $inslog_data );
                }
                redirect ( base_url($this->associate_listrequest), 'refresh' );
            }
            else {
                redirect('Dadmin/dadminsearch');
            }
        }
        
    
}
