 <?php if (!defined('BASEPATH'))  
{
    exit('No direct script access allowed');
} 
require_once ('Common.php');
require_once ('./PHPExcel-1.8/Classes/PHPExcel.php');

class Billing extends Common {
    function __construct() 
    {
    parent::__construct();
    $this->_check_userlogin ();
    // $this->load->model('Billing_model','bm');
    $models = array('Billing_model'=>'bm','Verification_model' => 'vm','Dadmin_model'=>'dm','Dataentry_model'=>'dem','Reports_model'=>'rm','Client_model'=>'cm','Verification_report_model'=>'vrm','Qualityverification_model'=>'qc', 'Candidate_model'=>'cam', 'Management_model' => 'mm');
        foreach ($models as $file => $object_name) {
            $this->load->model($file, $object_name);
        }

    $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
    $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','jquery-ui-1.10.4','highcharts','exporting','jquery.validate','grid.locale-en','jquery.jqGrid.min','jquery-ui-1.8.16.custom.min','commonjs','jquery.datepick','multipleclone'));
    $this->load->helper('text');
    $this->load->helper('cloneform');
    }
    function create()
    {
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Billing', 'Billing/create');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'create');
    }
    function get_offlineusers( $office_id = 0 ){ 
        $model = array('Billing_model'=>'get_userlistoff');
        $office = $this->uri->segment(3); 
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $billing_type = ($_REQUEST['billing_type']) ? $_REQUEST['billing_type'] : '';
        if($office){
            $condition[]=" a.office = ".$office;
        }
        if($parent_office){
            $condition[]=" a.parent_office = ".$parent_office;
        }
        if($sub_office){
            $condition[]=" a.sub_office = ".$sub_office;
        }
        if($org_id){
            $condition[]=" a.organisation = ".$org_id;
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0]; 
        $result = $results[1]; 
        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows;
        foreach ( $result as $i => $row ) {
            if($row['on_date']){
                $row['on_date']=date('d-m-Y',strtotime($row['on_date']));
            } 
            if($row['created_on']) {
                $row['created_on']=date('d-m-Y',strtotime($row['created_on']));
            }
            $billing_type='';
            if($row['billing_type']==515){
                $billing_type='Against Profile Submission';
            }
            else if($row['billing_type']==516){
                $billing_type='Against Final Report';
            }
            $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], $billing_type,anchor('/Billing/addcheck/'.base64_encode($row['request_id']), $row['candidate_name']), $row['created_on']);
            }
        }
        echo json_encode($response);
    }
    function against_profile() {
        $this->_check_featureauth ( 'meeting', 'search' );
        $order_id = ($this->uri->segment(4) == 'xy') ? 0 :base64_decode($this->uri->segment(3)) ;
        $billing_id = $data['billing_id']= ($this->uri->segment(4) == 'xy') ? base64_decode($this->uri->segment(3)) : '';
        $pay=array( 0 => 'No', 1 => 'Yes');
        $data['order_details'] = $order_details = $this->amodel->getDetails(DB_PREFIX . "order", array('*'), array('id' => $order_id));
        $meeting_details = $this->amodel->getDetails(DB_PREFIX . "billing", array('*'), array('id' => $billing_id));
        $all_emailid = $this->amodel->getDetails(DB_PREFIX . "user",array('id','email'));
        $data['org_id'] =  $meeting_details[0]['client_id'];
        if ($order_details) { 
        $this->_check_featureauth ( 'billing', 'edit' ); // Check if user is allowed for action
        $subtitle = "Modify";
        $office = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id','office_name'),array('id' => $order_details[0]['parent']));
        $parent = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id','office_name'),array('id' => $order_details[0]['parent_office']));
        $level = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id','office_name'),array('id' => $order_details[0]['level']));
        $contact = $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id','name'),array('id' => $order_details[0]['contact_for']));
        $user=$this->amodel->fetchDropdowndetails(DB_PREFIX . "user", array('id','first_name'),array('id' => $order_details[0]['contact_person']));

        } else {

        $this->_check_featureauth ( 'offline', 'add' ); // Check if user is allowed for action
        $subtitle = "Create";
        $contact = $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id', 'name'),array('key' => 'contact_for'));
        } 

        $formElement = array(array( 'order_name' => array('text', 'order_name', 'R|Z', 'R|Z','','RF','' ), 'organisation' => array('dropdown', 'organisation', 'R|Y', 'R|Y|MC|DIS',$this->amodel->fetchDropdowndetails(DB_PREFIX . "organisation", array('id','org_name'),array('user_type'=>2)),'RF','N' ),'parent_office'=>array('dropdown','parent_office', 'R|Y', 'Y|DIS', $parent, 'RF', ''),'office' => array('dropdown', 'office_name', 'Y', 'Y|DIS', $office, 'RF', ''),'sub_office'=>array('dropdown','sub_office', 'Y', 'Y|DIS', $level, '', ''),'billing_term' => array('dropdown', 'billing_term', 'R|Y', 'R|Y', $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'billing_term')), 'RF', ''),'billing_term' => array('dropdown', 'billing_term', 'R|Y', 'R|Y', $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'billing_term')), 'RF', ''),'billing_type' => array('dropdown', 'billing_type', 'R|Y', 'R|Y', $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'Billing_type')), 'RF', '') ));
        $data['table'] = form(create_form($formElement,$order_details,$order_id,@$billing_id), $formElement, 'order_add', 'Meeting/orderadd',$subtitle,$auth_link, '', base_url());
        $this->bm->orderdml($order_id,$billing_id);    
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Billing', 'Billing/create');
        $this->breadcrumbs->push('Add Against Profile', 'Billing/against_profile');
        $data['breadcrumb']=$this->breadcrumbs->show();            
        $this->amodel->pagerender($data, 'against_profile');
           
    }  
            
    function addcheck() {
        $this->_check_featureauth ( 'meeting', 'search' );
        $order_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $met_id=$data['meeting_id'] =$this->amodel->getDetails(DB_PREFIX . "order", array('meeting_id'), array('id'=> $order_id));
        $meeting = base64_encode($met_id[0]['meeting_id']); 
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $pagetitle = "order_checks";
        $nchecks = $this->db->query("select a.id,a.name,m.Rs,n.no_checks,n.request_id from ". DB_PREFIX ."master_masterdata a 
        LEFT JOIN " . DB_PREFIX . "add_check m on m.types_of_check = a.id
        LEFT JOIN " . DB_PREFIX . "client_request c on c.order_id = m.order_id
        LEFT JOIN " . DB_PREFIX . "request_check n on n.request_id = c.request_id
        where n.request_id =". $order_id . " AND a.parent=0 AND a.`key` IN ('Check') AND a.id IN(SELECT b.check_id FROM ".DB_PREFIX."request_check b WHERE b.request_id =". $order_id . ")" )->result_array(); 

        $data['sum']=$this->db->query("select SUM(m.Rs*n.no_checks ) AS total from ". DB_PREFIX ."master_masterdata a 
        LEFT JOIN " . DB_PREFIX . "add_check m on m.types_of_check = a.id
        LEFT JOIN " . DB_PREFIX . "client_request c on c.order_id = m.order_id
        LEFT JOIN " . DB_PREFIX . "request_check n on n.request_id = c.request_id
        where n.request_id =". $order_id . " AND parent=0 AND `key` IN ('Check') AND id IN(SELECT b.check_id FROM ".DB_PREFIX."request_check b WHERE b.request_id =". $order_id . ")" )->result_array(); 
        foreach($nchecks as $ky=>$val){
        $check[$val['id']]=$val['name'];
        }                            
        $subtitle = "ADD";
        $title = "Create";
        $pay = array( 1 => 'Yes',0 => 'No');
        $check_details = $this->amodel->getDetails(DB_PREFIX . "add_check", array('*'), array('check_id' => $check_id));
        if ($check_details) {
        $this->_check_featureauth ( 'meeting', 'edit' ); 
        $subtitle = "Modify";
        $auth_link = array(     array('meeting','search','Search','Meeting/ordercommonview/'. $this->uri->segment(3). '/'. $this->uri->segment(4) )) ;
        $level = $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('ref_id' => $check_details[0]['types_of_check'],'key'=>'level'));
        $unit_limit = $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('ref_id' => $check_details[0]['types_of_check'],'key'=>'limit'));
        } else {
        $subtitle = "Create";
        $level = '';
        $unit_limit = '';
        }
        $data['nchecks'] = $nchecks;
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Billing', 'Billing/create');
        $this->breadcrumbs->push('Add Against Profile', 'Billing/addcheck/'.$this->uri->segment(3));
        $this->breadcrumbs->push('Add/Edit Checks', 'Billing/addcheck');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data,'order_checks');

    } 
    function against_profile_submission() {
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Add Against Profile', 'Billing/against_profile_submission');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data,'billing_check');
     }
    function get_billingusers( $office_id = 0 ) { 
        $model = array('Billing_model'=>'get_billinglistoff');
        $office = $this->uri->segment(3); 
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $billing_type = ($_REQUEST['billing_type']) ? $_REQUEST['billing_type'] : '';
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
        if($office){
            $condition[]=" b.office_name = ".$office;
        }
        if($parent_office){
            $condition[]=" d.office_name = ".$parent_office;
        }
        if($sub_office){
            $condition[]=" o.office_name = ".$sub_office;
        }
        if($org_id){
            $condition[]=" c.org_name = ".$org_id;
        }
        if($term)
        {
            $search = explode(' ', $term);
            foreach($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if(substr($t,0,1) == '-')
                {
                $not        = 'NOT ';
                $operator    = 'AND';
                $t        = substr($t,1,strlen($t));
                }
                $like    = '';
                $like    .= "( c.org_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." a.candidate_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." b.office_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." d.office_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." a.assainee_status ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." e.billing_type ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." f.first_name ".$not."LIKE '%".$t."%' ) " ;
                $condition[]=$like;
            }
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0]; 
        $result = $results[1]; 
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            foreach ( $result as $i => $row ) {
                if($row['on_date']) {
                    $row['on_date']=date('d-m-Y',strtotime($row['on_date']));
                }
                if($row['created_on']) {
                    $row['created_on']=date('d-m-Y',strtotime($row['created_on']));
                }
                $billing_type='';
                if($row['billing_type']==515){
                    $billing_type='Against Profile Submission';
                }
                else if($row['billing_type']==516){
                    $billing_type='Against Final Report';
                }
                $response->rows [$i] ['cell'] = array ( $i+$count+1,
                $row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],$billing_type,anchor('/Billing/profile_submission/'.base64_encode($row['order_id']), 'view')
                );
            }
        }
        echo json_encode($response);
    }
    function against_report_submission(){
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Add Against Report', 'Billing/against_report_submission');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data,'billing_check');
    } 
    function get_reportbillingusers( $office_id = 0 ){ 
        $model = array('Billing_model'=>'get_reportbillinglistoff');
        $office = $this->uri->segment(3); 
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $billing_type = ($_REQUEST['billing_type']) ? $_REQUEST['billing_type'] : '';
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
        if($office){
            $condition[]=" a.office = ".$office;
        }
        if($parent_office){
            $condition[]=" a.parent_office = ".$parent_office;
        }
        if($sub_office){
            $condition[]=" o.sub_office = ".$sub_office;
        }
        if($org_id){
            $condition[]=" a.organisation = ".$org_id;
        }
        if($term)
        {
            $search = explode(' ', $term);
            foreach($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if(substr($t,0,1) == '-')
                {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    $t        = substr($t,1,strlen($t));
                }
                $like    = '';
                $like    .= "( c.org_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." a.candidate_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." c.org_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." b.office_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." d.office_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." a.assainee_status ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." f.first_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." a.dataentry_by ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." e.order_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." e.billing_type ".$not."LIKE '%".$t."%' ) " ;
                $condition[]=$like;
            }
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0]; 
        $result = $results[1]; 
        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows;
        foreach ( $result as $i => $row ) {
            if($row['on_date']) {
                $row['on_date']=date('d-m-Y',strtotime($row['on_date']));
            }
            if($row['created_on']) {
                $row['created_on']=date('d-m-Y',strtotime($row['created_on']));
            }
            $billing_type='';
            if($row['billing_type']==515){
                $billing_type='Against Profile Submission';
            }
            else if($row['billing_type']==516){
                $billing_type='Against Final Report';
            }
            $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],$billing_type,anchor('/Billing/report_submission/'.base64_encode($row['order_id']), 'view'));
            }
        }
        echo json_encode($response);
    }
    function profile_submission() {
        $order_id = $data['order_id'] = base64_decode($this->uri->segment(3));
        $nchecks_pr = $this->db->query("select group_concat(p.check_id) as check_id,a.order_id,a.amount,a.case_no,c.org_name,b.office_name,b.address1,b.address2,b.address3,b.locality,b.pincode,d.office_name as parent_office,o.office_name as sub_office,a.id,a.candidate_name, p.no_checks from ". DB_PREFIX ."billing a 
        LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
        LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
        LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
        LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
        LEFT JOIN " . DB_PREFIX . "request_check p ON p.request_id=a.request_id
        where a.order_id =". $order_id . " and a.billing_type=515 and a.created_on BETWEEN (CURRENT_DATE() - INTERVAL 1 MONTH) AND CURRENT_DATE() group by a.id" )->result_array(); 
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Billing', 'Billing/create');
        $this->breadcrumbs->push('Add Against Profile', 'Billing/addcheck/'.$this->uri->segment(3));
        $this->breadcrumbs->push('Add/Edit Checks', 'Billing/addcheck');
        $data['breadcrumb']=$this->breadcrumbs->show();
        $data['nchecks_profile'] = $nchecks_pr;
        $this->amodel->pagerender($data,'profile_checks');
     }
    function report_submission() {
        $order_id = $data['order_id'] = base64_decode($this->uri->segment(3));
        $nchecks_pr = $this->db->query("select group_concat(p.check_id) as check_id,a.amount,a.case_no,c.org_name,b.office_name,b.address1,b.address2,b.address3,b.locality,b.pincode,d.office_name as parent_office,o.office_name as sub_office,a.id,a.candidate_name, p.no_checks from ". DB_PREFIX ."billing a 
        LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
        LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
        LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
        LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
        LEFT JOIN " . DB_PREFIX . "request_check p ON p.request_id=a.request_id

        where a.order_id =". $order_id . " and a.billing_type=516 and a.created_on BETWEEN (CURRENT_DATE() - INTERVAL 1 MONTH) AND CURRENT_DATE() group by a.id" )->result_array(); 
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Add Against Report', 'Billing/against_report_submission');
        $this->breadcrumbs->push('Add/Edit Checks', 'Billing/addcheck');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $data['nchecks_profile'] = $nchecks_pr;
        $this->amodel->pagerender($data,'report_submission');
    } 
    function vmexpenses(){
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('VM Expenses Profile', 'Billing/against_profile_submission');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data,'vm_check');
    } 
    function get_vmexpenses($office_id = 0){ 
        $model = array('Billing_model'=>'get_vmexpenseslistoff');
        $office = $this->uri->segment(3); 
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $billing_type = ($_REQUEST['billing_type']) ? $_REQUEST['billing_type'] : '';
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
        if($office){
            $condition[]=" a.office = ".$office;
        }
        if($parent_office){
            $condition[]=" a.parent_office = ".$parent_office;
        }
        if($sub_office){
            $condition[]=" o.sub_office = ".$sub_office;
        }
        if($org_id){
            $condition[]=" a.organisation = ".$org_id;
        }
        if($term)
        {
            $search = explode(' ', $term);
            foreach($search as $t) {
            $not        = '';
            $operator    = 'OR';
            if(substr($t,0,1) == '-')
            {
                $not        = 'NOT ';
                $operator    = 'AND';
                $t        = substr($t,1,strlen($t));
            }
            $like    = '';
            $like    .= "( c.org_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." a.candidate_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." c.org_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." b.office_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." d.office_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." f.first_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." a.dataentry_by ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." e.order_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." e.billing_type ".$not."LIKE '%".$t."%' ) " ;
            $condition[]=$like;
            }
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            foreach ( $result as $i => $row ) {
            if($row['on_date']) {
                $row['on_date']=date('d-m-Y',strtotime($row['on_date']));
            }
            if($row['created_on']) {
                $row['created_on']=date('d-m-Y',strtotime($row['created_on']));
            }
            $billing_type='';
            if($row['billing_type']==515){
                $billing_type='Against Profile Submission';
            }
            else if($row['billing_type']==516){
                $billing_type='Against Final Report';
            }
            $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],$billing_type,anchor('/Billing/vm_submission/'.base64_encode($row['order_id']), 'view'));
            }
        }
        echo json_encode($response);
    }
    function vm_submission() {
        $order_id = $data['order_id'] = base64_decode($this->uri->segment(3));
        $nchecks_pr = $this->db->query("select p.check_id,a.vm_amount,a.vm_expences,a.vm_reference,a.case_no,c.org_name,b.office_name,b.address1,b.address2,b.address3,b.locality,b.pincode,d.office_name as parent_office,o.office_name as sub_office,a.id,a.candidate_name, p.no_checks from ". DB_PREFIX ."billing a 
        LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
        LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
        LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
        LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
        LEFT JOIN " . DB_PREFIX . "request_check p ON p.request_id=a.request_id
        where a.order_id =". $order_id . " and a.billing_type=517 and a.created_on BETWEEN (CURRENT_DATE() - INTERVAL 1 MONTH) AND CURRENT_DATE() group by a.id" )->result_array(); 
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Add Against Report', 'Billing/against_report_submission');
        $this->breadcrumbs->push('Add/Edit Checks', 'Billing/addcheck');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $data['nchecks_profile'] = $nchecks_pr;
        $this->amodel->pagerender($data,'report_submission');
     } 
    function package(){
                $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
                $this->breadcrumbs->push('Package', 'Billing/package');
                $data['breadcrumb']=$this->breadcrumbs->show(); 
                $this->amodel->pagerender($data,'packageg_check');
     }
    function get_package($office_id = 0){ 
        $model = array('Billing_model'=>'get_packagelistoff');
        $office = $this->uri->segment(3); 
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $billing_type = ($_REQUEST['billing_type']) ? $_REQUEST['billing_type'] : '';
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
        if($office){
            $condition[]=" a.office = ".$office;
        }
        if($parent_office){
            $condition[]=" a.parent_office = ".$parent_office;
        }
        if($sub_office){
            $condition[]=" o.sub_office = ".$sub_office;
        }
        if($org_id){
            $condition[]=" a.organisation = ".$org_id;
        }
        if($term)
        {
            $search = explode(' ', $term);
            foreach($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if(substr($t,0,1) == '-')
                {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    $t        = substr($t,1,strlen($t));
                }
                $like    = '';
                $like    .= "( c.org_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." a.candidate_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." c.org_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." b.office_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." d.office_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." f.first_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." a.dataentry_by ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." e.order_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." e.billing_type ".$not."LIKE '%".$t."%' ) " ;
                $condition[]=$like;
            }
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            foreach ( $result as $i => $row ) {
                if($row['on_date']) {
                    $row['on_date']=date('d-m-Y',strtotime($row['on_date']));
                }
                if($row['created_on']) {
                    $row['created_on']=date('d-m-Y',strtotime($row['created_on']));
                }
                $billing_type='';
                if($row['billing_type']==515){
                    $billing_type='Against Profile Submission';
                }
                else if($row['billing_type']==516){
                    $billing_type='Against Final Report';
                }
                $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],$billing_type,anchor('/Billing/package_check_submission/'.base64_encode($row['order_id']), 'view')
                );
            }
        }
        echo json_encode($response);
    }
    function package_check_submission() {
        $order_id = $data['order_id'] = base64_decode($this->uri->segment(3));
        $nchecks_pr = $this->db->query("select group_concat(p.check_id) as check_id,a.order_id,a.pack_id,a.package_amount,a.amount,a.case_no,c.org_name,b.office_name,b.address1,b.address2,b.address3,b.locality,b.pincode,d.office_name as parent_office,o.office_name as sub_office,a.id,a.candidate_name, p.no_checks from ". DB_PREFIX ."billing a 
        LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
        LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
        LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
        LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
        LEFT JOIN " . DB_PREFIX . "request_check p ON p.request_id=a.request_id
        where a.pack_id IS NOT NULL and a.order_id =". $order_id . " and a.created_on BETWEEN (CURRENT_DATE() - INTERVAL 1 MONTH) AND CURRENT_DATE() group by a.id" )->result_array(); 
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Billing', 'Billing/create');
        $this->breadcrumbs->push('Add Against Profile', 'Billing/addcheck/'.$this->uri->segment(3));
        $this->breadcrumbs->push('Add/Edit Checks', 'Billing/addcheck');
        $data['breadcrumb']=$this->breadcrumbs->show();
        $data['nchecks_profile'] = $nchecks_pr;
        $this->amodel->pagerender($data,'profile_checks');
    }
    function get_ordered_checks() { 
        $chk = $_POST;
        $order_id = $data['id'] = base64_decode($this->uri->segment(3));
        $met_id=$data['billing_id'] =$this->amodel->getDetails(DB_PREFIX . "billing", array('billing_id'), array('id'=> $order_id));
        $meeting = base64_encode($met_id[0]['billing_id']); 
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $this->bm->addcheckdml($check_id,$order_id);
        $this->amodel->pagerender('','order_checks');
    } 


    /*****************
    * Service Charge page
    * service_charge
    ******************/
    function service_charge() { 

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Service Charge', 'Billing/service_charge');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'service_charge');
    }

    function save_servicecharge(){

        $from_date=$_POST['c_date'];
        $to_date=$_POST['t_date'];

        $reportdata=$this->bm->get_finalreport_data($from_date,$to_date);
        // echo '<pre>';print_r($reportdata);
       
        $intChk=array();
        $organisationId=0;
        foreach($reportdata as $repData){

            $checkWithCount=$this->vm->get_checkwithcount($repData['request_id'],$repData['order_id']);

            $intChk = array("644", "645","646","647","651","653","654");
            $organisationId=$repData['organisation'];
            $caseAcceptedDate=$repData['case_accepted_date'];
            $endToEndData=$this->bm->get_endtoenddetails($organisationId,$caseAcceptedDate);

            $existingRequest=$this->vm->get_existing_requestid($repData['request_id']);
            // echo '<pre>';print_r($checkWithCount); 
            $endToend=$endToEndData[0]['ee_domestic_charge'];
            
            $totalChkCost=0;
            $chkCost=0;
            $pkgCost=0;
            $Scharge_Check=0;
            $overSeas_charge=0;
            $CheckCost=0;
            $int_chk_cost=0;
            $packageID=0;
            $currency='';
            $endToend=0;
            $err_msg='';
            foreach($checkWithCount as $checkVal){

                if($checkVal['package_id']==0){

                    if (in_array($checkVal['check_id'], $intChk)){
                        $chkCost=$checkVal['amount_rupees'];
                        $int_chk_cost+=$checkVal['amount_rupees'];

                        if(!empty($int_chk_cost)){
                            $currency.=$checkVal['currency'].' '.$checkVal['amount'].',';
                        }

                        if(empty($checkVal['int_checkID'])){
                            $err_msg .=$checkVal['check_id'].',';
                        }

                    }else{

                        if($checkVal['outside_india']==0){
                            $chkCost=$checkVal['Rs'];
                            $Scharge_Check+= $checkVal['Rs'];
                        }else{
                            if($checkVal['overseas_charge'] > 0){
                                $chkCost=($checkVal['Rs']+$checkVal['overseas_charge']);
                                $overSeas_charge+=$checkVal['overseas_charge'];
                            }else{
                                $chkCost=($checkVal['Rs']+500);
                                $Scharge_Check+= $checkVal['Rs'];
                                $overSeas_charge+=500;
                            }

                        }
                            $CheckCost +=$chkCost;
                    }
                        

                      
                }
                else
                {

                        $packageID=$checkVal['package_id'];

                    if($checkVal['Rs']==0){

                        $packagewithchk=$this->vm->get_packagecheck($repData['request_id'],$repData['order_id'], $checkVal['check_id']);
                        // echo '<pre>';print_r($packagewithchk);
                        // echo $checkVal['level_id'].'<br>';
                        if (in_array($checkVal['check_id'], $intChk)){
                            $chkCost=$checkVal['amount_rupees'];
                            $int_chk_cost+=$checkVal['amount_rupees'];

                            if(!empty($int_chk_cost)){
                                $currency=$checkVal['currency'].' '.$checkVal['amount'].',';
                            }

                            if(empty($checkVal['int_checkID'])){
                                $err_msg .=$checkVal['check_id'].',';
                            }

                        }else{

                            $chkoutsideDetail=$this->vm->get_outsideindia($repData['request_id'], $checkVal['check_id'], $checkVal['level_id']);
                            // echo '<pre>';print_r($chkoutsideDetail);
                            if(empty($packagewithchk['types_of_check'])){
                                $err_msg .=$checkVal['check_id'].',';
                            }

                            if($chkoutsideDetail['outside_india']==0){
                                $chkCost=$packagewithchk['Rs'];
                                $Scharge_Check+= $packagewithchk['Rs'];
                            }else{
                                if($packagewithchk['overseas_charge'] > 0){
                                    $chkCost=($packagewithchk['Rs']+$packagewithchk['overseas_charge']);
                                    $overSeas_charge+=$packagewithchk['overseas_charge'];
                                }else{
                                    $chkCost=($packagewithchk['Rs']+500);
                                    $Scharge_Check+= $packagewithchk['Rs'];
                                    echo $overSeas_charge+=500;
                                }
                            }
                                $CheckCost +=$chkCost;

                        }
                            
                    }else{

                        if($pkgCost==0){
                            $pkgCost=$checkVal['Rs'];
                        }

                        if (in_array($checkVal['check_id'], $intChk)){
                            $chkCost =$checkVal['amount_rupees'];
                            $int_chk_cost+=$checkVal['amount_rupees'];

                            if(!empty($int_chk_cost)){
                                $currency=$checkVal['currency'].' '.$checkVal['amount'].',';
                            }

                            if(empty($checkVal['int_checkID'])){
                                $err_msg .=$checkVal['check_id'].',';
                            }

                        }else{
                            if($checkVal['outside_india']==1){
                                
                                if($checkVal['overseas_charge'] > 0){
                                    $CheckCost +=$checkVal['overseas_charge'];
                                    $overSeas_charge+=$checkVal['overseas_charge'];
                                }else{
                                    $CheckCost+=500;
                                    $overSeas_charge+=500;
                                }
                            }
                        }

                    }

                        
                    
                }

                
                if(!empty($endToEndData)){
                    //Check current_stay_flag is =1 { Overseas Charge}else{ Domestic Charge }
                    if($repData['current_stay_flag'] == 1){
                        $endToend=$endToEndData[0]['ee_overseas_charge'];
                    }else{
                        $endToend=$endToEndData[0]['ee_domestic_charge'];
                    }
                }else{
                    $endToend =0;
                }

                $totalChkCost =($CheckCost + $pkgCost + $int_chk_cost + $endToend);
            }
            
            // exit;
            if(!empty($existingRequest)){
                // echo  $existingRequest['request_id'];exit;
                // $this->db->set('br_status',0);
                // $this->db->where('request_id',$existingRequest['request_id']);
                // $this->db->update(DB_PREFIX.'bill_receipts');

                $upd_data['charges_services']=$totalChkCost;
                $upd_data['charges_services_checks']=$Scharge_Check;
                $upd_data['charges_services_package']=$pkgCost;
                $upd_data['charges_services_overseas']=$overSeas_charge;
                $upd_data['br_status']=1;
                $upd_data['charges_services_international']=$int_chk_cost;
                $upd_data['charges_services_int_txt']=$currency;
                $upd_data['charges_services_endtoend']=$endToend;
                $upd_data['rate_error']=$err_msg;
                $upd_data['creation_date']=date('Y-m-d H:i:s');
                $this->db->where('request_id',$existingRequest['request_id']);
                $this->db->update ( DB_PREFIX .'bill_receipts', $upd_data );

            }else{

                $billSave['case_no']=$repData['case_no'];
                $billSave['request_id']=$repData['request_id'];
                $billSave['org_id']=$repData['organisation'];
                $billSave['package_id']=$packageID;
                $billSave['report_type']=1;
                $billSave['report_date']=$repData['final_report_published_date'];
                $billSave['charges_services']=$totalChkCost;
                $billSave['charges_services_checks']=$Scharge_Check;
                $billSave['charges_services_package']=$pkgCost;
                $billSave['charges_services_overseas']=$overSeas_charge;
                $billSave['br_status']=1;
                $billSave['charges_services_international']=$int_chk_cost;
                $billSave['charges_services_int_txt']=$currency;
                $billSave['charges_services_endtoend']=$endToend;
                $billSave['rate_error']=$err_msg;
                $billSave['creation_date']=date('Y-m-d H:i:s');

                $billSave = $this->security->xss_clean($billSave);
                $this->db->insert( DB_PREFIX .'bill_receipts', $billSave );
            }
            
        }
        
        // exit;
            echo '<script language="javascript" type="text/javascript"> 
                        alert("Service charges generated successfully!");
                        window.location = "service_charge";
                </script>';

            // redirect(base_url('Billing/service_charge'));
        
    }


    /*****************
    * Payment Request List page
    * Function payment_requestlist
    ******************/
    function payment_requestlist() { 

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Payment Request', 'Billing/payment_requestlist');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'payment_requestlist');
    }



    /*****************
    * Payment Request list 
    * get_paymentrequest_list
    ******************/
    function get_paymentrequest_list($office_id = 0){ 

        $model = array('Billing_model'=>'get_paymentrequest_list');
        
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $temp_id = ($_REQUEST['template_id']) ? $_REQUEST['template_id'] : '';
        $case_number = ($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
        $requested_by = ($_REQUEST['requested_by']) ? $_REQUEST['requested_by'] : '';
        $payment_status = ($_REQUEST['payment_status']) ? $_REQUEST['payment_status'] : '';
        $payment_mode = ($_REQUEST['payment_mode']) ? $_REQUEST['payment_mode'] : '';
        $payment_reason = ($_REQUEST['payment_reason']) ? $_REQUEST['payment_reason'] : '';
        $c_date = ($_REQUEST['fp_fdate']) ? $_REQUEST['fp_fdate'] : '';
        $t_date = ($_REQUEST['fp_tdate']) ? $_REQUEST['fp_tdate'] : ''; 

        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';


        
        if($org_id){
            $condition[]=" pr.org_id = ".$org_id;
        }
        if($temp_id==2){
            $bankName='SBI';
            $condition[]=" pr.bank_name like '%".$bankName."%'";
        }
        if($temp_id==3){
            $bankName='Kotak';
            $condition[]=" pr.bank_name like '%".$bankName."%'";
        }
        if($case_number){
            $condition[]=" pr.case_no like '%".$case_number."%'";
        }
        if($requested_by){
            $condition[]=" f.first_name like '%".$requested_by."%'";
        }
        if($payment_status){
            $condition[]=" pr.payment_status =".$payment_status;
        }
        if($payment_mode){
            $condition[]=" pr.payment_mode =".$payment_mode;
        }
        if($payment_reason){
            $condition[]=" pr.reason_payment =".$payment_reason;
        }
        if(!empty($c_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }


        if($term)
        {
            $search = explode(' ', $term);
            foreach($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if(substr($t,0,1) == '-')
                {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    $t        = substr($t,1,strlen($t));
                }
                $like    = '';
                $like    .= "( c.org_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." a.candidate_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." c.org_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." b.office_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." d.office_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." f.first_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." a.dataentry_by ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." e.order_name ".$not."LIKE '%".$t."%' " ;
                $like    .= $operator." e.billing_type ".$not."LIKE '%".$t."%' ) " ;
                $condition[]=$like;
            }
        }

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        // echo '<pre>';print_r($result);exit;
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;

            foreach ( $result as $i => $row ) {
                $pr_id=$row['pr_id'];
                $request_id= $row['request_id'];
                $check_id= $row['check_id'];
                $level_id= $row['level_id'];
                $pack_id=0;

                $requested_date='';
                $approved_date='';
                $paid_date='';
                
                switch($row['payment_mode']){
                    case 22:
                        $file='<a href="'.base_url().'uploads/prposaldetails/'.$row['chln_file'].'" target="_blank" >'.$row['chln_file'].'</a>';
                        $attachment=($row['chln_file']) ? $file : '';
                        break;
                    case 23:
                        $file='<a href="'.base_url().'uploads/prposaldetails/'.$row['cr_card_file'].'" target="_blank" >'.$row['cr_card_file'].'</a>';
                        $attachment=($row['cr_card_file']) ? $file : '';
                        break;
                    case 24:
                        $file='<a href="'.base_url().'uploads/prposaldetails/'.$row['dd_file'].'" target="_blank" >'.$row['dd_file'].'</a>';
                        $attachment=($row['dd_file']) ? $file : '';
                        break;
                    case 25:
                        $file='<a href="'.base_url().'uploads/prposaldetails/'.$row['neft_file'].'" target="_blank" >'.$row['neft_file'].'</a>';
                        $attachment=($row['neft_file']) ? $file : '';
                        break;
                    case 26:
                        $file='<a href="'.base_url().'uploads/prposaldetails/'.$row['op_online_file'].'" target="_blank" >'.$row['op_online_file'].'</a>';
                        $attachment=($row['op_online_file']) ? $file : '';
                        break;
                    default:
                        $attachment=''; 
                }
               
                if($row['requested_date']) {
                    $requested_date=date('d-m-Y',strtotime($row['requested_date']));
                }
                if($row['approved_date'] != '0000-00-00 00:00:00') {
                    $approved_date=date('d-m-Y',strtotime($row['approved_date']));
                }
                if($row['paid_date'] != '0000-00-00 00:00:00') {
                    $paid_date=date('d-m-Y',strtotime($row['paid_date']));
                }

                $startDate = date('Y-m-d',strtotime($row['requested_date']));
                $endDate = date('Y-m-d');
                $holidays = array();
                $dayCount='';

                if($row['count_of_chk']==0){
                    $chkCount='';
                }else{
                    $chkCount=$row['count_of_chk'];
                }

                $Iniated_Date=(!empty($row['initiated_on'])) ? date('d-m-Y',strtotime($row['initiated_on'])) : '';

                $Completed_Date=(!empty($row['completed_on'])) ? date('d-m-Y',strtotime($row['completed_on'])) : '';
                
                if(!empty($Completed_Date)){
                    $NoOfday= $this->getWorkingDays($requested_date,$Completed_Date,$holidays);
                    if(($NoOfday-1) ==0){
                       $dayCount=1; 
                    }else{
                        $dayCount=$NoOfday-1;
                    }
                }else{
                    $dayCount='';
                }


                $pRequest_no='PR-'.$row['pr_id'];
                
                if(($this->session->userdata('role_id')==5 ) && ($row['payment_status']==31 || $row['payment_status']==33)){
                    $edit= anchor('/Verification/payment_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"Edit",'style="color:blue; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"View",'style="color:orange; font-weight:bold"');   
                }
                else if(($this->session->userdata('role_id')==9) && ($row['payment_status']==31 || $row['payment_status']==33)){
                    $edit= anchor('/Verification/payment_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"Edit",'style="color:blue; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"View",'style="color:orange; font-weight:bold"');   
                }
                else if(($this->session->userdata('role_id')==26 || $this->session->userdata('role_id')==27) && $row['payment_status']==32 && $row['payment_mode']!=25)
                {
                    $edit= anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"View",'style="color:orange; font-weight:bold"');
                }
                else if(($this->session->userdata('role_id')==26 || $this->session->userdata('role_id')==27) && ($row['payment_status']==34 || $row['payment_status']==35))
                {
                    $edit= anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"View",'style="color:orange; font-weight:bold"');
                }
                else if(($this->session->userdata('role_id')==26 || $this->session->userdata('role_id')==27) && $row['payment_mode']==25){
                    $edit= anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"View",'style="color:orange; font-weight:bold"');
                }
                else{
                    $edit= anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"View",'target="_blank" style="color:orange; font-weight:bold"');
                }

                $response->rows [$i] ['cell'] = array ( $i+$count+1,$edit,$pRequest_no,$row['case_no'],$row['candidate_name'],$row['check_name'].$chkCount,$row['beneficiary_name'],$row['beneficiary_location'],$row['pm_name'],$row['amount'],$row['paymode'],$row['paystatus'],$requested_date,$Iniated_Date,$Completed_Date,$dayCount,$row['dd_txn_no'],$row['branchcode'],$approved_date,$paid_date,$row['reason'],$row['payto'],$row['comments'],$row['requested_by'],$row['approved_by'],$row['org_name'],$attachment,$edit);
            }
        }
        echo json_encode($response);
    }


    /****************************
    * Kotak DD List page
    * Function kotak_dd
    ***************************/
    function kotak_dd() { 

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Kotak DD', 'Billing/kotak_dd');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'kotak_dd');
    }

    /*****************
    * Kotak DD list 
    * get_kotakdd_list
    ******************/
    function get_kotakdd_list($office_id = 0){ 
        // print_r($_REQUEST);exit;
        $model = array('Billing_model'=>'get_kotak_payment_list');
        
        // $DD = ($_REQUEST['DD']) ? $_REQUEST['DD'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $temp_id = ($_REQUEST['template_id']) ? $_REQUEST['template_id'] : '';
        $case_number = ($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
        $requested_by = ($_REQUEST['requested_by']) ? $_REQUEST['requested_by'] : '';
        $payment_status = ($_REQUEST['payment_status']) ? $_REQUEST['payment_status'] : '';
        // $payment_mode = ($_REQUEST['payment_mode']) ? $_REQUEST['payment_mode'] : '';
        $payment_reason = ($_REQUEST['payment_reason']) ? $_REQUEST['payment_reason'] : '';
        $c_date = ($_REQUEST['fp_fdate']) ? $_REQUEST['fp_fdate'] : '';
        $t_date = ($_REQUEST['fp_tdate']) ? $_REQUEST['fp_tdate'] : ''; 

        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';


        
        if($org_id){
            $condition[]=" pr.org_id = ".$org_id;
        }
        
        if($case_number){
            $condition[]=" pr.case_no like '%".$case_number."%'";
        }
        if($requested_by){
            $condition[]=" f.first_name like '%".$requested_by."%'";
        }
        if($payment_status){
            $condition[]=" pr.payment_status =".$payment_status;
        }
        if($payment_reason){
            $condition[]=" pr.reason_payment =".$payment_reason;
        }
        if(!empty($c_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        // echo '<pre>';print_r($result);exit;
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;

            foreach ( $result as $i => $row ) {
                $pr_id=$row['pr_id'];
                $request_id= $row['request_id'];
                $check_id= $row['check_id'];
                $level_id= $row['level_id'];
                $pack_id=0;

                $requested_date='';
                $approved_date='';
                $paid_date='';

                if($row['requested_date']) {
                    $requested_date=date('d-m-Y',strtotime($row['requested_date']));
                }
                if($row['approved_date'] != '0000-00-00 00:00:00') {
                    $approved_date=date('d-m-Y',strtotime($row['approved_date']));
                }
                if($row['paid_date'] != '0000-00-00 00:00:00') {
                    $paid_date=date('d-m-Y',strtotime($row['paid_date']));
                }

                $holidays = array();
                $dayCount='';

                $DD_Date=(!empty($row['dd_date']) && $row['dd_date'] !='0000-00-00') ? date('d-m-Y',strtotime($row['dd_date'])) : '';
                $CHK_Date=(!empty($row['chk_date']) && $row['chk_date'] !='0000-00-00') ? date('d-m-Y',strtotime($row['chk_date'])) : '';

                
                $Iniated_Date=(!empty($row['initiated_on'])) ? date('d-m-Y',strtotime($row['initiated_on'])) : '';

                $Completed_Date=(!empty($row['completed_on'])) ? date('d-m-Y',strtotime($row['completed_on'])) : '';
                
                if(!empty($Completed_Date)){
                    $NoOfday= $this->getWorkingDays($requested_date,$Completed_Date,$holidays);
                    if(($NoOfday-1) ==0){
                       $dayCount=1; 
                    }else{
                        $dayCount=$NoOfday-1;
                    }
                }else{
                    $dayCount='';
                }

                if($row['count_of_chk']==0){
                    $chkCount='';
                }else{
                    $chkCount=$row['count_of_chk'];
                }
                
                $DDcharge=($row['dd_charges'] > 0) ? $row['dd_charges'] : '';


                $file='<a href="'.base_url().'uploads/prposaldetails/'.$row['dd_file'].'" target="_blank" >'.$row['dd_file'].'</a>';
                $attachment=($row['dd_file']) ? $file : '';

                $pRequest_no='PR-'.$row['pr_id'];
                $roleid= $this->session->userdata('role_id');

                if($roleid==5  && ($row['payment_status']==31 || $row['payment_status']==33)){
                    $edit= anchor('/Verification/payment_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"Edit",'style="color:blue; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"View",'style="color:orange; font-weight:bold"');   
                }else if($roleid==9 && ($row['payment_status']==31 || $row['payment_status']==33)){
                    $edit= anchor('/Verification/payment_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"Edit",'style="color:blue; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"View",'style="color:orange; font-weight:bold"');   
                }else if(($roleid==26 || $roleid==27) && ($row['payment_status']==32 || $row['payment_status']==38))
                {
                    $edit= anchor('/Billing/fc_initiated_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(2),"Edit", 'style="color:blue; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"View",'style="color:orange; font-weight:bold"');
                }
                else if(($roleid==26 || $roleid==27) && $row['payment_status']==34 )
                {
                    $edit= anchor('/Billing/fc_payment_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(2),"Edit",'style="color:blue; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"View",'style="color:orange; font-weight:bold"');;
                }
                else if(($roleid==26 || $roleid==27) && $row['payment_status']==35){
                    $edit= anchor('/Billing/dd_cancel_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(2),"Cancel",'style="color:red; font-weight:bold"').' / '.anchor('/Billing/kotak_completedview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(2),"View",'style="color:orange; font-weight:bold"');
                }
                else{
                    $edit= anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"View",'style="color:orange; font-weight:bold"');
                }

                if( $roleid==26 && ($row['payment_status']==32 || $row['payment_status']==38)){
                    $check='<input type="checkbox" name="pr_id[]" value="'.($row['pr_id']).'" class="pay_req" />';
                }else{
                   $check= $i+$count+1;
                }
                
                $response->rows [$i] ['cell'] = array ($check,$edit ,$row['case_no'],$row['candidate_name'],$row['check_name'].$chkCount,$row['beneficiary_name'],$row['beneficiary_location'],$row['amount'],$row['paystatus'],$requested_date,$Iniated_Date,$Completed_Date,$dayCount,$row['dd_txn_no'],$DD_Date,$DDcharge,$row['chk_number'],$CHK_Date,$row['bank_name'],$row['requested_by'],$attachment,$edit); 
            
            
            }
        }
        echo json_encode($response);
    }



    function sbi_dd() { 

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('SBI DD', 'Billing/sbi_dd');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'sbi_dd');
    }

    /*****************
    * SBI DD list 
    * get_sbidd_list
    ******************/
    function get_sbidd_list($office_id = 0){ 
        
        $model = array('Billing_model'=>'get_sbi_payment_list');
        
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $temp_id = ($_REQUEST['template_id']) ? $_REQUEST['template_id'] : '';
        $case_number = ($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
        $requested_by = ($_REQUEST['requested_by']) ? $_REQUEST['requested_by'] : '';
        $payment_status = ($_REQUEST['payment_status']) ? $_REQUEST['payment_status'] : '';
        $payment_reason = ($_REQUEST['payment_reason']) ? $_REQUEST['payment_reason'] : '';
        $c_date = ($_REQUEST['fp_fdate']) ? $_REQUEST['fp_fdate'] : '';
        $t_date = ($_REQUEST['fp_tdate']) ? $_REQUEST['fp_tdate'] : ''; 

        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';


        
        if($org_id){
            $condition[]=" pr.org_id = ".$org_id;
        }
        
        if($case_number){
            $condition[]=" pr.case_no like '%".$case_number."%'";
        }
        if($requested_by){
            $condition[]=" f.first_name like '%".$requested_by."%'";
        }
        if($payment_status){
            $condition[]=" pr.payment_status =".$payment_status;
        }
        if($payment_reason){
            $condition[]=" pr.reason_payment =".$payment_reason;
        }
        if(!empty($c_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        // print_r($result);exit;
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;

            foreach ( $result as $i => $row ) {
                $pr_id=$row['pr_id'];
                $request_id= $row['request_id'];
                $check_id= $row['check_id'];
                $level_id= $row['level_id'];
                $pack_id=0;

                $requested_date='';
                if($row['requested_date']) {
                    $requested_date=date('d-m-Y',strtotime($row['requested_date']));
                }

                $DD_Date=(!empty($row['dd_date']) && $row['dd_date'] !='0000-00-00') ? date('d-m-Y',strtotime($row['dd_date'])) : '';
                

                $CHK_Date=(!empty($row['chk_date']) && $row['chk_date'] !='0000-00-00') ? date('d-m-Y',strtotime($row['chk_date'])) : '';

                $Iniated_Date=(!empty($row['initiated_on'])) ? date('d-m-Y',strtotime($row['initiated_on'])) : '';

                $Completed_Date=(!empty($row['completed_on'])) ? date('d-m-Y',strtotime($row['completed_on'])) : '';
                
                if(!empty($Completed_Date)){
                    $NoOfday= $this->getWorkingDays($requested_date,$Completed_Date,$holidays);
                    if(($NoOfday-1) ==0){
                       $dayCount=1; 
                    }else{
                        $dayCount=$NoOfday-1;
                    }
                }else{
                    $dayCount='';
                }
                
                $DDcharge=($row['dd_charges'] > 0) ? $row['dd_charges'] : '';

                if($row['count_of_chk']==0){
                    $chkCount='';
                }else{
                    $chkCount=$row['count_of_chk'];
                }

                $file='<a href="'.base_url().'uploads/prposaldetails/'.$row['dd_file'].'" target="_blank" >'.$row['dd_file'].'</a>';
                $attachment=($row['dd_file']) ? $file : '';

                $pRequest_no='PR-'.$row['pr_id'];
                // echo $row['paystatus'];
                $roleid= $this->session->userdata('role_id');

                if($roleid==5  && ($row['payment_status']==31 || $row['payment_status']==33)){
                    $edit= anchor('/Verification/payment_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"Edit",'style="color:blue; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"View",'style="color:orange; font-weight:bold"');   
                }
                else if(($this->session->userdata('role_id')==26 || $this->session->userdata('role_id')==27) && $row['payment_status']==32)
                {
                    $edit= anchor('/Billing/fc_initiated_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(3),"Edit", 'style="color:blue; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode('sbi_dd').'/'.base64_encode('Reject'),"Reject",'style="color:red; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(3),"View",'style="color:orange; font-weight:bold"');
                }
                else if(($this->session->userdata('role_id')==26 || $this->session->userdata('role_id')==27) && ($row['payment_status']==34))
                {
                    $edit= anchor('/Billing/fc_payment_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(3),"Edit",'style="color:blue; font-weight:bold"');
                }
                else if(($this->session->userdata('role_id')==26 || $this->session->userdata('role_id')==27) && $row['payment_status']==35){
                    $edit= anchor('/Billing/dd_cancel_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(3),"Cancel",'style="color:red; font-weight:bold"').' / '.anchor('/Billing/kotak_completedview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(3),"View",'style="color:orange; font-weight:bold"');
                }
                else{
                    $edit= anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(3),"View",'style="color:orange; font-weight:bold"');
                }        
                    // $check='<input type="checkbox" name="pr_id[]" value="'.($row['pr_id']).'" class="pay_req" />';
                
                $response->rows [$i] ['cell'] = array ($i+$count+1,$edit,$row['case_no'],$row['candidate_name'],$row['check_name'].$chkCount,$row['beneficiary_name'],$row['beneficiary_location'],$row['amount'],$row['paystatus'],$requested_date,$Iniated_Date,$Completed_Date,$dayCount,$row['dd_txn_no'],$DD_Date,$DDcharge,$row['chk_number'],$CHK_Date,$row['branchcode'],$row['bank_name'],$row['requested_by'],$row['org_name'],$attachment,$edit); 
            
            
            }
        }
        echo json_encode($response);
    }


    function neft() { 

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('NEFT', 'Billing/neft');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'neft');
    }

    /*****************
    * NEFT list 
    * get_neft_list
    ******************/
    function get_neft_list($office_id = 0){ 
        
        $model = array('Billing_model'=>'get_neft_payment_list');
        
        // $DD = ($_REQUEST['DD']) ? $_REQUEST['DD'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $temp_id = ($_REQUEST['template_id']) ? $_REQUEST['template_id'] : '';
        $case_number = ($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
        $requested_by = ($_REQUEST['requested_by']) ? $_REQUEST['requested_by'] : '';
        $payment_status = ($_REQUEST['payment_status']) ? $_REQUEST['payment_status'] : '';
        // $payment_mode = ($_REQUEST['payment_mode']) ? $_REQUEST['payment_mode'] : '';
        $payment_reason = ($_REQUEST['payment_reason']) ? $_REQUEST['payment_reason'] : '';
        $c_date = ($_REQUEST['fp_fdate']) ? $_REQUEST['fp_fdate'] : '';
        $t_date = ($_REQUEST['fp_tdate']) ? $_REQUEST['fp_tdate'] : '';
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';

        if($org_id){
            $condition[]=" pr.org_id = ".$org_id;
        }
        
        if($case_number){
            $condition[]=" pr.case_no like '%".$case_number."%'";
        }
        if($requested_by){
            $condition[]=" f.first_name like '%".$requested_by."%'";
        }
        if($payment_status){
            $condition[]=" pr.payment_status =".$payment_status;
        }
        if($payment_reason){
            $condition[]=" pr.reason_payment =".$payment_reason;
        }
        if(!empty($c_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        // print_r($result);exit;
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;

            foreach ( $result as $i => $row ) {
                $pr_id=$row['pr_id'];
                $request_id= $row['request_id'];
                $check_id= $row['check_id'];
                $level_id= $row['level_id'];
                $pack_id=0;

                $requested_date='';
                $approved_date='';
                $paid_date='';
                $payment_date='';

                if($row['requested_date']) {
                    $requested_date=date('d-m-Y',strtotime($row['requested_date']));
                }
                if($row['neft_payment_date'] != '0000-00-00 00:00:00') {
                    $payment_date=date('d-m-Y',strtotime($row['neft_payment_date']));
                }

                $Completed_Date=(!empty($row['completed_on'])) ? date('d-m-Y',strtotime($row['completed_on'])) : '';
                
                if(!empty($Completed_Date)){
                    $NoOfday= $this->getWorkingDays($requested_date,$Completed_Date,$holidays);
                    if(($NoOfday-1) ==0){
                       $dayCount=1; 
                    }else{
                        $dayCount=$NoOfday-1;
                    }
                }else{
                    $dayCount='';
                }
                
                if($row['count_of_chk']==0){
                    $chkCount='';
                }else{
                    $chkCount=$row['count_of_chk'];
                }

                $Transcharge=($row['neft_trans_charge'] > 0) ? $row['neft_trans_charge'] : '';

                $file='<a href="'.base_url().'uploads/prposaldetails/'.$row['neft_file'].'" target="_blank" >'.$row['neft_file'].'</a>';
                $attachment=($row['neft_file']) ? $file : '';

                // $pRequest_no='PR-'.$row['pr_id'];
                // echo $row['paystatus'];
                $roleID=$this->session->userdata('role_id');
                if($roleID==5  && ($row['payment_status']==31 || $row['payment_status']==33)){
                    $edit= anchor('/Verification/payment_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"Edit",'style="color:blue; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"View",'style="color:orange; font-weight:bold"');   
                }
                else if(($roleID==26 || $roleID==27) && $row['payment_status']==32)
                {
                    $edit= anchor('/Billing/fc_neft_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(4),"Edit", 'style="color:blue; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode('neft').'/'.base64_encode('Reject'),"Reject",'style="color:red; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(3),"View",'style="color:orange; font-weight:bold"');
                }
                else if(($roleID==26 || $roleID==27) && $row['payment_status']==35){
                    $edit= anchor('/Billing/neft_completeview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(4),"View",'style="color:orange; font-weight:bold"');
                }
                else{
                    $edit= anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(4),"View",'style="color:orange; font-weight:bold"');
                }
                
                $response->rows [$i] ['cell'] = array ($i+$count+1,$edit,$row['case_no'],$row['candidate_name'],$row['check_name'].$chkCount,$row['beneficiary_name'],$row['beneficiary_location'],$row['amount'],$row['paystatus'],$requested_date,$Completed_Date,$dayCount,$row['neft_reference_no'],$payment_date,$Transcharge,$row['branchcode'],$row['neft_bank_name'],$row['requested_by'],$row['org_name'],$attachment,$edit); 
            
            
            }
        }
        echo json_encode($response);
    }




    /************* Payment Request View Page ***********
     * ****** function payment_requestview *************
     * *************************************************/
    function payment_requestview(){

        $data['request_id']=$request_id = base64_decode($this->uri->segment(3)); 
        $data['level_id']=$level_id = base64_decode($this->uri->segment(4)); 
        $data['check_id']=$check_id = base64_decode($this->uri->segment(5)); 
        $data['pack_id']=$pack_id = base64_decode($this->uri->segment(6));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(7));
        $data['menu']=base64_decode($this->uri->segment(8));
        $data['action'] = base64_decode($this->uri->segment(9));


        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();
        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        $data['payment_details']=$this->vm->get_payment_request_details($pr_id);

        $this->db->select('*');
        $data['neftDetails']=$this->db->get_where('dcode_payment_request_neft',array('pr_id'=> $pr_id ))->row_array();

        $this->db->select('*');
        $data['challanDetails']=$this->db->get_where('dcode_payment_request_challan',array('pr_id'=> $pr_id ))->row_array();

        $this->db->select('*');
        $data['cardDetails']=$this->db->get_where('dcode_payment_request_card',array('pr_id'=> $pr_id ))->row_array();

        $this->db->select('*');
        $data['onlineDetails']=$this->db->get_where('dcode_payment_request_online',array('pr_id'=> $pr_id ))->row_array();

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];


        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Payment Request', 'Billing/payment_requestlist');
        $this->breadcrumbs->push('Payment Request View', 'Billing/payment_requestview');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'payment_requestview');
    }


    function p_request_process(){
        
        $roleID=$this->session->userdata('role_id');
        $userID=$this->session->userdata['userid'];
        // echo print_r($_POST);exit;
        try{
            $postData=$_POST;
            // echo '<pre>';print_r($postData);exit;
            $submitVal=$postData['Submit'];
            $chk_number=$postData['chk_number'];
            $chk_date= date('Y-m-d', strtotime($postData['chk_date']));

            if(!empty($postData['pr_id'])){ 
                // echo '<pre>';print_r($postData);exit;
                
                foreach($postData['pr_id'] as $key=>$value) {
                    
                    $PR_ID= $value;
                    $this->db->select('request_id,check_id,level_id,case_no');
                    $PR_DATA=$this->db->get_where('dcode_payment_request',array('pr_id'=> $PR_ID ))->row_array();
                    // print_r($PR_DATA);exit;

                    $ins_data['request_id'] = $PR_DATA['request_id'];
                    $ins_data['case_no']= $PR_DATA['case_no'];
                    $ins_data['check_id'] = $PR_DATA['check_id'];
                    $ins_data['level_id'] = $PR_DATA['level_id'];
                    if($submitVal=='Processing'){
                        $ins_data['payment_status'] = 38;
                    }else{
                        $ins_data['payment_status'] = 34;   
                    }
                    
                    $ins_data['date_of_update'] = date ( 'Y-m-d H:i:s' );
                    $ins_data['role_id'] = $roleID;
                    $ins_data['user_id'] = $userID;                

                    $ins_data = $this->security->xss_clean($ins_data);
                    $this->db->insert ( DB_PREFIX .'payment_status_updates', $ins_data );


                    $where = '(pr_id="'.$PR_ID.'")';
                    $initiated_on=date ( 'Y-m-d H:i:s' );

                    if($submitVal=='Processing'){
                        $this->db->set('payment_status',38);
                    }else{
                        $this->db->set('payment_status',34);   
                    }
                    
                    $this->db->set('initiated_on',$initiated_on);
                    $this->db->where($where);
                    $res=$this->db->update(DB_PREFIX.'payment_request');

                    if($submitVal=='Initiated'){

                        $data = array('chk_number'=> $chk_number,'chk_date'=>$chk_date);
                        $this->db->set($data);
                        $this->db->where($where);
                        $res=$this->db->update(DB_PREFIX.'payment_request_dd');
                    }
                }

            }
            // exit;
            redirect('Billing/kotak_dd');
        }
        catch(ErrorException $e){
        echo $e->getMessage(); 
        $this->load->view('Index/error_500');
        }

    }



    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function fc_payment_request *************
     * *************************************************/
    function fc_payment_request(){

        $data['request_id']=$request_id = base64_decode($this->uri->segment(3)); 
        $data['level_id']=$level_id = base64_decode($this->uri->segment(4)); 
        $data['check_id']=$check_id = base64_decode($this->uri->segment(5)); 
        $data['pack_id']=$pack_id = base64_decode($this->uri->segment(6));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(7));
        $data['template']=$template = base64_decode($this->uri->segment(8));

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();

        $this->db->select('*');
        $data['ddDetails']=$this->db->get_where('dcode_payment_request_dd',array('pr_id'=> $pr_id ))->row_array();

        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        $data['payment_details']=$this->vm->get_payment_request_details($pr_id);

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        if($template==2){
            $listpage='Kotak DD';
            $link='Billing/kotak_dd';
        }else if($template==3){
            $listpage='SBI DD';
            $link='Billing/sbi_dd';
        }else{
            $listpage='Payment Request';
            $link='Billing/payment_requestlist';
        }
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push($listpage, $link);
        $this->breadcrumbs->push('Payment Request', 'Billing/payment_requestlist');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'fc_payment_request');
    }

    function save_fcpayment(){

        // print_r($_POST);exit;
        $config['allowed_types'] = '*';
        $config['encrypt_name'] = false;
        $config['remove_spaces'] = false;
        $config['upload_path'] = 'uploads/prposaldetails/';
        $this->load->library('upload', $config);  
        $this->upload->initialize($config); 

        $fileName = $_FILES['dd_file']['name'];

        if ($this->upload->do_upload('dd_file'))
        {
            $documents[]  = $this->upload->data();
        }
        // else
        // {
        //  echo ($documents['payment_file'] = $this->upload->display_errors());
        // }

        $pr_id=$_POST['pr_id'];
        $ddNo=$_POST['dd_or_pay'];
        $ddDate= date('Y-m-d', strtotime($_POST['dd_or_paydate'])); 
        $ddCharge=$_POST['dd_or_trans'];
        $dd_file=$fileName;
        
        $where = '(pr_id="'.$pr_id.'")';
        $data = array('dd_no'=> $ddNo, 'dd_date'=>$ddDate, 'dd_charges'=>$ddCharge, 'dd_file'=>$dd_file);
        $this->db->set($data);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request_dd');

        $roleID=$this->session->userdata('role_id');
        $userID=$this->session->userdata['userid'];

        $ins_data['request_id'] = $_POST['request_id'];
        $ins_data['case_no']= $_POST['case_no'];
        $ins_data['check_id'] = $_POST['check_id'];
        $ins_data['level_id'] = $_POST['level_id'];
        $ins_data['payment_status'] = 35;
        $ins_data['date_of_update'] = date ( 'Y-m-d H:i:s' );
        $ins_data['role_id'] = $roleID;
        $ins_data['user_id'] = $userID;                

        $ins_data = $this->security->xss_clean($ins_data);
        $this->db->insert ( DB_PREFIX .'payment_status_updates', $ins_data );


        $where = '(pr_id="'.$pr_id.'" )';
        $completed_on=date ( 'Y-m-d H:i:s' );
        $this->db->set('payment_status',35);
        $this->db->set('completed_on',$completed_on);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request');

        if($_POST['template']==2){
            redirect('Billing/kotak_dd');
        }else if($_POST['template']==3){
            redirect('Billing/sbi_dd');
        }else{
            redirect('Billing/payment_requestlist');
        }
    }



    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function fc_initiated_request *************
     * *************************************************/
    function fc_initiated_request(){

        $data['request_id']=$request_id = base64_decode($this->uri->segment(3)); 
        $data['level_id']=$level_id = base64_decode($this->uri->segment(4)); 
        $data['check_id']=$check_id = base64_decode($this->uri->segment(5)); 
        $data['pack_id']=$pack_id = base64_decode($this->uri->segment(6));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(7));
        $data['template']=$template = base64_decode($this->uri->segment(8));

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();
        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        $data['payment_details']=$this->vm->get_payment_request_details($pr_id);

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        if($template==2){
            $listpage='Kotak DD';
            $link='Billing/kotak_dd';
        }else if($template==3){
            $listpage='SBI DD';
            $link='Billing/sbi_dd';
        }else{
            $listpage='Payment Request';
            $link='Billing/payment_requestlist';
        }
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push($listpage, $link);
        $this->breadcrumbs->push('Payment Request', 'Billing/fc_initiated_request');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'fc_initiated_request');
    }


    function save_fcinitiated(){
        // print_r($_POST);exit;
        $roleID=$this->session->userdata('role_id');
        $userID=$this->session->userdata['userid'];
        $PR_ID= $_POST['pr_id'];
        $chkNumber=$_POST['chk_number'];
        $chkDate= date('Y-m-d', strtotime($_POST['chk_date']));
        $chkAmount=$_POST['chk_amount'];
        
        $ins_data['request_id'] = $_POST['request_id'];
        $ins_data['case_no']= $_POST['case_no'];
        $ins_data['check_id'] = $_POST['check_id'];
        $ins_data['level_id'] = $_POST['level_id'];
        if($_POST['Submit']=='Initiated'){
            $ins_data['payment_status'] = 34;  
        }else{
            $ins_data['payment_status'] = 38;
        }
        
        $ins_data['date_of_update'] = date ( 'Y-m-d H:i:s' );
        $ins_data['role_id'] = $roleID;
        $ins_data['user_id'] = $userID;                

        $ins_data = $this->security->xss_clean($ins_data);
        $this->db->insert ( DB_PREFIX .'payment_status_updates', $ins_data );


        $where = '(pr_id="'.$PR_ID.'")';
        $initiated_on=date ( 'Y-m-d H:i:s' );
        if($_POST['Submit']=='Initiated'){
            $this->db->set('payment_status',34);
        }else{
            $this->db->set('payment_status',38);
        }
        
        $this->db->set('initiated_on',$initiated_on);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request');

        // $where = '(pr_id="'.$PR_ID.'")';
        if($_POST['Submit']=='Initiated'){
            $data = array('chk_number'=> $chkNumber,'chk_date'=>$chkDate,'chk_amount'=>$chkAmount);
            $this->db->set($data);
            $this->db->where($where);
            $res=$this->db->update(DB_PREFIX.'payment_request_dd');
        }

        if($_POST['template']==2){
            redirect('Billing/kotak_dd');
        }else if($_POST['template']==3){
            redirect('Billing/sbi_dd');
        }else{
            redirect('Billing/payment_requestlist');
        }

    }


    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function fc_initiated_edit *************
     * *************************************************/
    function fc_initiated_edit(){

        $data['prd_id']=$prd_id = base64_decode($this->uri->segment(3));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(4)); 
        $data['template']=$template = base64_decode($this->uri->segment(5));

        $data['fccheck_details']=$fccheck_details=$this->bm->get_fccheck_details($prd_id);
        $data['payment_details']=$payment_details=$this->vm->get_payment_request_details($pr_id);

        $request_id=$payment_details['request_id'];
        $check_id=$payment_details['check_id'];
        $level_id=$payment_details['level_id'];
        $pack_id=$payment_details['pack_id'];

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();
        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        if($template==2){
            $listpage='Kotak DD';
            $link='Billing/kotak_dd';
        }else if($template==3){
            $listpage='SBI DD';
            $link='Billing/sbi_dd';
        }else{
            $listpage='Payment Request';
            $link='Billing/payment_requestlist';
        }
                
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push($listpage, $link);
        $this->breadcrumbs->push('Payment Request', 'Billing/payment_requestlist');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'fc_initiated_edit');
    }
    

    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function kotak_completedview *************
     * *************************************************/
    function kotak_completedview(){

        $data['request_id']=$request_id = base64_decode($this->uri->segment(3)); 
        $data['level_id']=$level_id = base64_decode($this->uri->segment(4)); 
        $data['check_id']=$check_id = base64_decode($this->uri->segment(5)); 
        $data['pack_id']=$pack_id = base64_decode($this->uri->segment(6));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(7));
        $data['template']=$template = base64_decode($this->uri->segment(8));

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();

        $this->db->select('*');
        $data['ddDetails']=$this->db->get_where('dcode_payment_request_dd',array('pr_id'=> $pr_id ))->row_array();

        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        $data['payment_details']=$this->vm->get_payment_request_details($pr_id);

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        if($template==2){
            $listpage='Kotak DD';
            $link='Billing/kotak_dd';
        }else if($template==3){
            $listpage='SBI DD';
            $link='Billing/sbi_dd';
        }else{
            $listpage='Payment Request';
            $link='Billing/payment_requestlist';
        }
        
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push($listpage, $link);
        $this->breadcrumbs->push('Payment Request', 'Billing/payment_requestlist');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'kotak_completedview');
    }


    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function neft_completedview *************
     * *************************************************/
    function neft_completeview(){

        $data['request_id']=$request_id = base64_decode($this->uri->segment(3)); 
        $data['level_id']=$level_id = base64_decode($this->uri->segment(4)); 
        $data['check_id']=$check_id = base64_decode($this->uri->segment(5)); 
        $data['pack_id']=$pack_id = base64_decode($this->uri->segment(6));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(7));
        $data['template']=$template = base64_decode($this->uri->segment(8));

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();

        $this->db->select('*');
        $data['neftDetails']=$this->db->get_where('dcode_payment_request_neft',array('pr_id'=> $pr_id ))->row_array();

        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        $data['payment_details']=$this->vm->get_payment_request_details($pr_id);

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('NEFT', 'Billing/neft');
        $this->breadcrumbs->push('NEFT Details', 'Billing/neft');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'neft_completeview');
    }



    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function fc_completed_edit *************
     * *************************************************/
    function fc_completed_edit(){

        $data['prd_id']=$prd_id = base64_decode($this->uri->segment(3));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(4));
        $data['template']=$template = base64_decode($this->uri->segment(5)); 

        $data['fccheck_details']=$fccheck_details=$this->bm->get_fccheck_details($prd_id);
        $data['payment_details']=$payment_details=$this->vm->get_payment_request_details($pr_id);

        $request_id=$payment_details['request_id'];
        $check_id=$payment_details['check_id'];
        $level_id=$payment_details['level_id'];
        $pack_id=$payment_details['pack_id'];

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();
        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        if($template==2){
            $listpage='Kotak DD';
            $link='Billing/kotak_dd';
        }else if($template==3){
            $listpage='SBI DD';
            $link='Billing/sbi_dd';
        }else{
            $listpage='Payment Request';
            $link='Billing/payment_requestlist';
        }
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push($listpage, $link);
        $this->breadcrumbs->push('DD Details', 'Billing/fc_completed_edit');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'fc_completed_edit');
    }


    function update_fccompleted(){
        // print_r($_POST);exit;
        $prdId=$_POST['prd_id'];
        $dd_number=$_POST['dd_number'];
        $dd_date=date('Y-m-d',strtotime($_POST['dd_date']));
        $dd_charges=$_POST['dd_charges'];
        $template=$_POST['template'];

        $config['allowed_types'] = '*';
        $config['encrypt_name'] = false;
        $config['remove_spaces'] = false;
        $config['upload_path'] = 'uploads/prposaldetails/';
        $this->load->library('upload', $config);  
        $this->upload->initialize($config); 

        $fileName = $_FILES['dd_file']['name'];
        
        if(empty($fileName)){
            $this->db->select('dd_file');
            $this->db->where('prd_id',$prdId);
            $attachment=$this->db->get(DB_PREFIX.'payment_request_dd')->row_array();
                
            $DDFile=$attachment['dd_file'];
        }else{
            $DDFile=$fileName;
        }
        // print_r($_POST);exit;
        $where = '(prd_id="'.$prdId.'")';
        $data = array('dd_no'=> $dd_number,'dd_date'=>$dd_date,'dd_charges'=>$dd_charges,'dd_file'=>$DDFile);
        $this->db->set($data);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request_dd');
        
        if($template==2){
            redirect('' . base_url('Billing/kotak_dd'));
        }else if($template==3){
            redirect('' . base_url('Billing/sbi_dd'));
        }else{
            redirect('' . base_url('Billing/payment_requestlist'));
        }
    }
    

    function update_fcinitiated(){
        // print_r($_POST);exit;
        $prdId=$_POST['prd_id'];
        $chk_number=$_POST['chk_number'];
        $chk_date=date('Y-m-d',strtotime($_POST['chk_date']));
        $template=$_POST['template'];
        
        $where = '(prd_id="'.$prdId.'")';
        $data = array('chk_number'=> $chk_number,'chk_date'=>$chk_date);
        $this->db->set($data);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request_dd');

        if($template==2){
            redirect('' . base_url('Billing/kotak_dd'));
        }else if($template==3){
            redirect('' . base_url('Billing/sbi_dd'));
        }else{
            redirect('' . base_url('Billing/payment_requestlist'));
        }
        
    }


    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function fc_neft_request *************
     * *************************************************/
    function fc_neft_request(){

        $data['request_id']=$request_id = base64_decode($this->uri->segment(3)); 
        $data['level_id']=$level_id = base64_decode($this->uri->segment(4)); 
        $data['check_id']=$check_id = base64_decode($this->uri->segment(5)); 
        $data['pack_id']=$pack_id = base64_decode($this->uri->segment(6));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(7));
        $data['template']=$template = base64_decode($this->uri->segment(8));

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();

        $this->db->select('*');
        $data['ddDetails']=$this->db->get_where('dcode_payment_request_dd',array('pr_id'=> $pr_id ))->row_array();

        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        $data['payment_details']=$this->vm->get_payment_request_details($pr_id);

        $this->db->select('*');
        $data['neftDetails']=$this->db->get_where('dcode_payment_request_neft',array('pr_id'=> $pr_id ))->row_array();

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('NEFT', 'Billing/neft');
        $this->breadcrumbs->push('Neft Details', 'Billing/neft');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'fc_neft_request');
    }


    function save_neft_payment(){

        // print_r($_POST);exit;
        $config['allowed_types'] = '*';
        $config['encrypt_name'] = false;
        $config['remove_spaces'] = false;
        $config['upload_path'] = 'uploads/prposaldetails/';
        $this->load->library('upload', $config);  
        $this->upload->initialize($config); 

        $fileName = $_FILES['neft_file']['name'];

        if ($this->upload->do_upload('neft_file'))
        {
            $documents[]  = $this->upload->data();
        }
        // else
        // {
        //  echo ($documents['payment_file'] = $this->upload->display_errors());
        // }

        $pr_id=$_POST['pr_id'];
        $refNo=$_POST['neft_reference_no'];
        $paymentDate= date('Y-m-d', strtotime($_POST['neft_payment_date'])); 
        $transCharge=$_POST['neft_trans_charge'];
        $neftFile=$fileName;
        $updDate=date('Y-m-d H:i:s');
        
        $where = '(pr_id="'.$pr_id.'")';
        $data = array('neft_reference_no'=> $refNo, 'neft_payment_date'=>$paymentDate, 'neft_trans_charge'=>$transCharge, 'neft_file'=>$neftFile,'neft_last_updated_date'=>$updDate);
        $this->db->set($data);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request_neft');

        $roleID=$this->session->userdata('role_id');
        $userID=$this->session->userdata['userid'];

        $ins_data['request_id'] = $_POST['request_id'];
        $ins_data['case_no']= $_POST['case_no'];
        $ins_data['check_id'] = $_POST['check_id'];
        $ins_data['level_id'] = $_POST['level_id'];
        $ins_data['payment_status'] = 35;
        $ins_data['date_of_update'] = date ( 'Y-m-d H:i:s' );
        $ins_data['role_id'] = $roleID;
        $ins_data['user_id'] = $userID;                

        $ins_data = $this->security->xss_clean($ins_data);
        $this->db->insert ( DB_PREFIX .'payment_status_updates', $ins_data );


        $where = '(pr_id="'.$pr_id.'" )';
        $completed_on=date ( 'Y-m-d H:i:s' );
        $this->db->set('payment_status',35);
        $this->db->set('completed_on',$completed_on);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request');

        redirect('Billing/neft');
        
    }


    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function neft_completed_edit *************
     * *************************************************/
    function neft_completed_edit(){

        $data['neft_id']=$neft_id = base64_decode($this->uri->segment(3));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(4)); 

        $data['neft_details']=$neft_details=$this->bm->get_neft_details($neft_id);
        $data['payment_details']=$payment_details=$this->vm->get_payment_request_details($pr_id);

        $request_id=$payment_details['request_id'];
        $check_id=$payment_details['check_id'];
        $level_id=$payment_details['level_id'];
        $pack_id=$payment_details['pack_id'];

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();
        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('NEFT', 'Billing/neft');
        $this->breadcrumbs->push('NEFT Details', 'Billing/neft_completed_edit');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'neft_completed_edit');
    }


    function update_neftcompleted(){
        // print_r($_POST);exit;
        $neftId=$_POST['neft_id'];
        $ref_number=$_POST['neft_reference_no'];
        $payment_date=date('Y-m-d',strtotime($_POST['neft_payment_date']));
        $trans_charges=$_POST['neft_trans_charge'];

        $config['allowed_types'] = '*';
        $config['encrypt_name'] = false;
        $config['remove_spaces'] = false;
        $config['upload_path'] = 'uploads/prposaldetails/';
        $this->load->library('upload', $config);  
        $this->upload->initialize($config); 

        $fileName = $_FILES['neft_file']['name'];
        
        if(empty($fileName)){
            $this->db->select('neft_file');
            $this->db->where('neft_id',$neftId);
            $attachment=$this->db->get(DB_PREFIX.'payment_request_neft')->row_array();
                
            $neftFile=$attachment['neft_file'];
        }else{
            $neftFile=$fileName;
        }
        // print_r($_POST);exit;
        $updated_on=date ( 'Y-m-d H:i:s' );
        $where = '(neft_id="'.$neftId.'")';
        $data = array('neft_reference_no'=> $ref_number,'neft_payment_date'=>$payment_date,'neft_trans_charge'=>$trans_charges,'neft_file'=>$neftFile,'neft_last_updated_date'=>$updated_on);
        $this->db->set($data);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request_neft');
        redirect('' . base_url('Billing/neft'));
        
    }


    /********************************
     * Payment Request for Challan **
     ****** function challan ********/

    function challan() { 

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Challan', 'Billing/challan');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'challan');
    }

    /*****************
    * CHALLAN list 
    * get_challan_list
    ******************/
    function get_challan_list($office_id = 0){ 
        
        $model = array('Billing_model'=>'get_challan_payment_list');
        
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $temp_id = ($_REQUEST['template_id']) ? $_REQUEST['template_id'] : '';
        $case_number = ($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
        $requested_by = ($_REQUEST['requested_by']) ? $_REQUEST['requested_by'] : '';
        $payment_status = ($_REQUEST['payment_status']) ? $_REQUEST['payment_status'] : '';
        $payment_reason = ($_REQUEST['payment_reason']) ? $_REQUEST['payment_reason'] : '';
        $c_date = ($_REQUEST['fp_fdate']) ? $_REQUEST['fp_fdate'] : '';
        $t_date = ($_REQUEST['fp_tdate']) ? $_REQUEST['fp_tdate'] : '';
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';

        if($org_id){
            $condition[]=" pr.org_id = ".$org_id;
        }
        
        if($case_number){
            $condition[]=" pr.case_no like '%".$case_number."%'";
        }
        if($requested_by){
            $condition[]=" f.first_name like '%".$requested_by."%'";
        }
        if($payment_status){
            $condition[]=" pr.payment_status =".$payment_status;
        }
        if($payment_reason){
            $condition[]=" pr.reason_payment =".$payment_reason;
        }
        if(!empty($c_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        // echo '<pre>';print_r($result);exit;
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;

            foreach ( $result as $i => $row ) {
                $pr_id=$row['p_rid'];
                $request_id= $row['request_id'];
                $check_id= $row['check_id'];
                $level_id= $row['level_id'];
                $pack_id=0;

                $requested_date='';
                $approved_date='';
                $paid_date='';

                if($row['requested_date']) {
                    $requested_date=date('d-m-Y',strtotime($row['requested_date']));
                }
                if($row['chln_date'] != '0000-00-00') {
                    $challan_date=date('d-m-Y',strtotime($row['chln_date']));
                }

                $Completed_Date=(!empty($row['completed_on'])) ? date('d-m-Y',strtotime($row['completed_on'])) : '';
                
                if(!empty($Completed_Date)){
                    $NoOfday= $this->getWorkingDays($requested_date,$Completed_Date,$holidays);
                    if(($NoOfday-1) ==0){
                       $dayCount=1; 
                    }else{
                        $dayCount=$NoOfday-1;
                    }
                }else{
                    $dayCount='';
                }

                if($row['count_of_chk']==0){
                    $chkCount='';
                }else{
                    $chkCount=$row['count_of_chk'];
                }
                
                $Transcharge=($row['chln_charges'] > 0) ? $row['chln_charges'] : '';
                $file='<a href="'.base_url().'uploads/prposaldetails/'.$row['chln_file'].'" target="_blank" >'.$row['chln_file'].'</a>';
                $attachment=($row['chln_file']) ? $file : '';

                $roleID=$this->session->userdata('role_id');

                if(($roleID==5 || $roleID=26)  && ($row['payment_status']==31 || $row['payment_status']==33)){
                    $edit= anchor('/Verification/payment_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"Edit",'style="color:blue; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"View",'style="color:orange; font-weight:bold"');   
                }
                else if(($roleID==26 || $roleID==27) && $row['payment_status']==32)
                {
                    $edit= anchor('/Billing/fc_challan_initiated/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(5),"Edit", 'style="color:blue; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode('challan').'/'.base64_encode('Reject'),"Reject",'style="color:red; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(5),"View",'style="color:orange; font-weight:bold"');
                }
                else if(($roleID==26 || $roleID==27) && $row['payment_status']==34)
                {
                    $edit= anchor('/Billing/fc_challan_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(5),"Edit", 'style="color:blue; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(5),"View",'style="color:orange; font-weight:bold"');
                }
                else if(($roleID==26 || $roleID==27) && $row['payment_status']==35)
                {
                    $edit= anchor('/Billing/challan_completeview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(5),"View",'style="color:orange; font-weight:bold"');
                }
                else{
                    $edit= anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(5),"View",'style="color:orange; font-weight:bold"');
                }
                
                $response->rows [$i] ['cell'] = array ($i+$count+1,$edit,$row['case_no'],$row['candidate_name'],$row['check_name'].$chkCount,$row['beneficiary_name'],$row['beneficiary_location'],$row['amount'],$row['paystatus'],$requested_date,$Completed_Date,$dayCount,$row['chln_journal_no'],$challan_date,$Transcharge,$row['chln_bank'],$row['requested_by'],$row['org_name'],$attachment,$edit); 
            
            
            }
        }
        echo json_encode($response);
    }


    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function fc_challan_request *************
     * *************************************************/
    function fc_challan_request(){

        $data['request_id']=$request_id = base64_decode($this->uri->segment(3)); 
        $data['level_id']=$level_id = base64_decode($this->uri->segment(4)); 
        $data['check_id']=$check_id = base64_decode($this->uri->segment(5)); 
        $data['pack_id']=$pack_id = base64_decode($this->uri->segment(6));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(7));

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();

        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        $data['payment_details']=$this->vm->get_payment_request_details($pr_id);
        $this->db->select('*');
        $data['challanDetails']=$this->db->get_where('dcode_payment_request_challan',array('pr_id'=> $pr_id ))->row_array();

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Challan', 'Billing/challan');
        $this->breadcrumbs->push('Challan Details', 'Billing/fc_challan_request');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'fc_neft_request');
    }

    function save_challan_payment(){

        // print_r($_POST);exit;
        $config['allowed_types'] = '*';
        $config['encrypt_name'] = false;
        $config['remove_spaces'] = false;
        $config['upload_path'] = 'uploads/prposaldetails/';
        $this->load->library('upload', $config);  
        $this->upload->initialize($config); 

        $fileName = $_FILES['chln_file']['name'];

        if ($this->upload->do_upload('chln_file'))
        {
            $documents[]  = $this->upload->data();
        }
        // else
        // {
        //  echo ($documents['payment_file'] = $this->upload->display_errors());
        // }

        $pr_id=$_POST['pr_id'];
        $chln_journal_no=$_POST['chln_journal_no'];
        $chln_date= date('Y-m-d', strtotime($_POST['chln_date'])); 
        $chln_charges=$_POST['chln_charges'];
        $challanFile=$fileName;
        $updDate=date('Y-m-d H:i:s');
        
        $where = '(pr_id="'.$pr_id.'")';
        $data = array('chln_journal_no'=> $chln_journal_no, 'chln_date'=>$chln_date, 'chln_charges'=>$chln_charges, 'chln_file'=>$challanFile,'updated_on'=>$updDate);
        $this->db->set($data);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request_challan');

        $roleID=$this->session->userdata('role_id');
        $userID=$this->session->userdata['userid'];
        $ins_data['request_id'] = $_POST['request_id'];
        $ins_data['case_no']= $_POST['case_no'];
        $ins_data['check_id'] = $_POST['check_id'];
        $ins_data['level_id'] = $_POST['level_id'];
        $ins_data['payment_status'] = 35;
        $ins_data['date_of_update'] = date ( 'Y-m-d H:i:s' );
        $ins_data['role_id'] = $roleID;
        $ins_data['user_id'] = $userID;                

        $ins_data = $this->security->xss_clean($ins_data);
        $this->db->insert ( DB_PREFIX .'payment_status_updates', $ins_data );


        $where = '(pr_id="'.$pr_id.'" )';
        $completed_on=date ( 'Y-m-d H:i:s' );
        $this->db->set('payment_status',35);
        $this->db->set('completed_on',$completed_on);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request');

        redirect('Billing/challan');
        
    }

    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function challan_completeview *************
     * *************************************************/
    function challan_completeview(){

        $data['request_id']=$request_id = base64_decode($this->uri->segment(3)); 
        $data['level_id']=$level_id = base64_decode($this->uri->segment(4)); 
        $data['check_id']=$check_id = base64_decode($this->uri->segment(5)); 
        $data['pack_id']=$pack_id = base64_decode($this->uri->segment(6));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(7));
        

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();

        $this->db->select('*');
        $data['challanDetails']=$this->db->get_where('dcode_payment_request_challan',array('pr_id'=> $pr_id ))->row_array();

        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        $data['payment_details']=$this->vm->get_payment_request_details($pr_id);

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Challan', 'Billing/challan');
        $this->breadcrumbs->push('Challan Details', 'Billing/challan_completeview');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'challan_completeview');
    }

    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function challan_completed_edit *************
     * *************************************************/
    function challan_completed_edit(){

        $data['chln_id']=$chln_id = base64_decode($this->uri->segment(3));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(4)); 

        $data['challan_details']=$challan_details=$this->bm->get_challan_details($chln_id);
        $data['payment_details']=$payment_details=$this->vm->get_payment_request_details($pr_id);

        $request_id=$payment_details['request_id'];
        $check_id=$payment_details['check_id'];
        $level_id=$payment_details['level_id'];
        $pack_id=$payment_details['pack_id'];

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();
        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Challan', 'Billing/challan');
        $this->breadcrumbs->push('Challan Details', 'Billing/challan_completed_edit');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'challan_completed_edit');
    }

    function update_challan_completed(){
        // print_r($_POST);exit;
        $chln_id=$_POST['chln_id'];
        $chln_journal_no=$_POST['chln_journal_no'];
        $chln_date=date('Y-m-d',strtotime($_POST['chln_date']));
        $chln_charges=$_POST['chln_charges'];

        $config['allowed_types'] = '*';
        $config['encrypt_name'] = false;
        $config['remove_spaces'] = false;
        $config['upload_path'] = 'uploads/prposaldetails/';
        $this->load->library('upload', $config);  
        $this->upload->initialize($config); 

        $fileName = $_FILES['chln_file']['name'];
        
        if(empty($fileName)){
            $this->db->select('chln_file');
            $this->db->where('chln_id',$chln_id);
            $attachment=$this->db->get(DB_PREFIX.'payment_request_challan')->row_array();
                
            $chln_file=$attachment['chln_file'];
        }else{
            $chln_file=$fileName;
        }
        // print_r($_POST);exit;
        $updated_on=date ( 'Y-m-d H:i:s' );
        $where = '(chln_id="'.$chln_id.'")';
        $data = array('chln_journal_no'=> $chln_journal_no,'chln_date'=>$chln_date,'chln_charges'=>$chln_charges,'chln_file'=>$chln_file,'updated_on'=>$updated_on);
        $this->db->set($data);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request_challan');
        redirect('' . base_url('Billing/challan'));
        
    }

    function checkwise_payment() { 

        $data['request_id']=$request_id = base64_decode($this->uri->segment(3)); 
        $data['check_id']=$check_id = base64_decode($this->uri->segment(4));
        $data['level_id']=$level_id = base64_decode($this->uri->segment(5));  

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Payment Request', 'Billing/get_paymentrequest_list');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'checkwise_payment');
    }

    /*****************
    * Payment Request list 
    * get_individualchk_list
    ******************/
    function get_individualchk_list(){ 

        $model = array('Billing_model'=>'get_individualchk_list');
        
        $request_id = ($_REQUEST['request_id']) ? $_REQUEST['request_id'] : '';
        $check_id = ($_REQUEST['check_id']) ? $_REQUEST['check_id'] : '';
        $level_id = ($_REQUEST['level_id']) ? $_REQUEST['level_id'] : '';
        
        if($request_id){
            $condition[]=" pr.request_id = ".$request_id;
        }
        if($check_id){
            $condition[]=" pr.check_id = ".$check_id;
        }
        if($level_id){
            $condition[]=" pr.level_id = ".$level_id;
        }       

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        // print_r($result);exit;
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;

            foreach ( $result as $i => $row ) {
                $pr_id=$row['pr_id'];
                $request_id= $row['request_id'];
                $check_id= $row['check_id'];
                $level_id= $row['level_id'];
                $pack_id=0;

                $requested_date='';
                $approved_date='';
                $paid_date='';

                if($row['requested_date']) {
                    $requested_date=date('d-m-Y',strtotime($row['requested_date']));
                }
                if($row['approved_date'] != '0000-00-00 00:00:00') {
                    $approved_date=date('d-m-Y',strtotime($row['approved_date']));
                }
                if($row['paid_date'] != '0000-00-00 00:00:00') {
                    $paid_date=date('d-m-Y',strtotime($row['paid_date']));
                }

                $startDate = date('Y-m-d',strtotime($row['requested_date']));
                $endDate = date('Y-m-d');
                $holidays = array();
                $dayCount='';

                if($row['count_of_chk']==0){
                    $chkCount='';
                }else{
                    $chkCount=$row['count_of_chk'];
                }

                
                $Iniated_Date=(!empty($row['initiated_on'])) ? date('d-m-Y',strtotime($row['initiated_on'])) : '';

                $Completed_Date=(!empty($row['completed_on'])) ? date('d-m-Y',strtotime($row['completed_on'])) : '';
                
                if(!empty($Completed_Date)){
                    $NoOfday= $this->getWorkingDays($requested_date,$Completed_Date,$holidays);
                    if(($NoOfday-1) ==0){
                       $dayCount=1; 
                    }else{
                        $dayCount=$NoOfday-1;
                    }
                }else{
                    $dayCount='';
                }


                $attachment='<a href="'.base_url().'uploads/prposaldetails/'.$row['attachment'].'" target="_blank" style="font-size:12px;" >"'.$row['attachment'].'"</a>';

                $pRequest_no='PR-'.$row['pr_id'];
                // echo $row['paystatus'];
                
                
                $edit= anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"View",'target="_blank"');
                
                $response->rows [$i] ['cell'] = array ( $i+$count+1,$pRequest_no,$row['case_no'],$row['candidate_name'],$row['check_name'].$chkCount,$row['beneficiary_name'],$row['beneficiary_location'],$row['pm_name'],$row['amount'],$row['paymode'],$row['paystatus'],$requested_date,$Iniated_Date,$Completed_Date,$dayCount,$row['dd_txn_no'],$row['branchcode'],$approved_date,$paid_date,$row['reason'],$row['payto'],$row['comments'],$row['requested_by'],$row['approved_by'],$row['org_name'],$edit);
            }
        }
        echo json_encode($response);
    }

    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function fc_challan_initiated *************
     * *************************************************/
    function fc_challan_initiated(){

        $data['request_id']=$request_id = base64_decode($this->uri->segment(3)); 
        $data['level_id']=$level_id = base64_decode($this->uri->segment(4)); 
        $data['check_id']=$check_id = base64_decode($this->uri->segment(5)); 
        $data['pack_id']=$pack_id = base64_decode($this->uri->segment(6));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(7));
        $data['template']=$template = base64_decode($this->uri->segment(8));

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();
        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];
        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);
        $data['payment_details']=$this->vm->get_payment_request_details($pr_id);

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Challan', 'Billing/challan');
        $this->breadcrumbs->push('Challan Request', 'Billing/fc_challan_initiated');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'fc_challan_initiated');
    }

    function save_challan_initiated(){
        // print_r($_POST);exit;

        $roleID=$this->session->userdata('role_id');
        $userID=$this->session->userdata['userid'];
        $PR_ID= $_POST['pr_id'];
        $ref_Number=$_POST['ref_number'];
        $refDate= date('Y-m-d', strtotime($_POST['ref_date']));
        // $chkAmount=$_POST['chk_amount'];
        
        $ins_data['request_id'] = $_POST['request_id'];
        $ins_data['case_no']= $_POST['case_no'];
        $ins_data['check_id'] = $_POST['check_id'];
        $ins_data['level_id'] = $_POST['level_id'];
        $ins_data['payment_status'] = 34;  
        
        
        $ins_data['date_of_update'] = date ( 'Y-m-d H:i:s' );
        $ins_data['role_id'] = $roleID;
        $ins_data['user_id'] = $userID;                

        $ins_data = $this->security->xss_clean($ins_data);
        $this->db->insert ( DB_PREFIX .'payment_status_updates', $ins_data );


        $where = '(pr_id="'.$PR_ID.'")';
        $initiated_on=date ( 'Y-m-d H:i:s' );

        $this->db->set('payment_status',34);
        $this->db->set('initiated_on',$initiated_on);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request');

        // $where = '(pr_id="'.$PR_ID.'")';
        // $data = array('chln_ref_number'=> $ref_Number,'chln_ref_date'=>$refDate);
        $this->db->set('chln_ref_number',$ref_Number);
        $this->db->set('chln_ref_date',$refDate);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request_challan');

            redirect('Billing/challan');    
    }


    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function fc_initiated_edit *************
     * *************************************************/
    function challan_initiated_edit(){

        $data['chln_id']=$chln_id = base64_decode($this->uri->segment(3));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(4)); 
        
        $data['challan_details']=$fccheck_details=$this->bm->get_challan_details($chln_id);
        $data['payment_details']=$payment_details=$this->vm->get_payment_request_details($pr_id);

        $request_id=$payment_details['request_id'];
        $check_id=$payment_details['check_id'];
        $level_id=$payment_details['level_id'];
        $pack_id=$payment_details['pack_id'];

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();
        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];
                
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Challan','Billing/challan');
        $this->breadcrumbs->push('Challan Request', 'Billing/fc_challan_request');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'challan_initiated_edit');
    }


    function update_challan_initiated(){
        // print_r($_POST);exit;
        $chln_id=$_POST['chln_id'];
        $ref_number=$_POST['ref_number'];
        $chln_date=date('Y-m-d',strtotime($_POST['chln_date']));
        
        $where = '(chln_id="'.$chln_id.'")';
        $data = array('chln_ref_number'=> $ref_number,'chln_ref_date'=>$chln_date);
        $this->db->set($data);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request_challan');

        redirect('' . base_url('Billing/challan'));        
    }


    /********************************
     * Payment Request for Card **
     ****** function card ********/

    function card() { 

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Card Payment', 'Billing/card');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'card');
    }

    /*****************
    * Card list 
    * get_card_list
    ******************/
    function get_card_list(){

        $model = array('Billing_model'=>'get_card_payment_list');
        
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $temp_id = ($_REQUEST['template_id']) ? $_REQUEST['template_id'] : '';
        $case_number = ($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
        $requested_by = ($_REQUEST['requested_by']) ? $_REQUEST['requested_by'] : '';
        $payment_status = ($_REQUEST['payment_status']) ? $_REQUEST['payment_status'] : '';
        $payment_reason = ($_REQUEST['payment_reason']) ? $_REQUEST['payment_reason'] : '';
        $c_date = ($_REQUEST['fp_fdate']) ? $_REQUEST['fp_fdate'] : '';
        $t_date = ($_REQUEST['fp_tdate']) ? $_REQUEST['fp_tdate'] : '';
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';

        if($org_id){
            $condition[]=" pr.org_id = ".$org_id;
        }
        
        if($case_number){
            $condition[]=" pr.case_no like '%".$case_number."%'";
        }
        if($requested_by){
            $condition[]=" f.first_name like '%".$requested_by."%'";
        }
        if($payment_status){
            $condition[]=" pr.payment_status =".$payment_status;
        }
        if($payment_reason){
            $condition[]=" pr.reason_payment =".$payment_reason;
        }
        if(!empty($c_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        // print_r($result);exit;
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;

            foreach ( $result as $i => $row ) {
                $pr_id=$row['pr_id'];
                $request_id= $row['request_id'];
                $check_id= $row['check_id'];
                $level_id= $row['level_id'];
                $pack_id=0;

                $requested_date='';
                $approved_date='';
                $paid_date='';
                $transaction_date='';

                if($row['requested_date']) {
                    $requested_date=date('d-m-Y',strtotime($row['requested_date']));
                }
                if($row['cr_transaction_date'] != '0000-00-00 00:00:00') {
                    $transaction_date=date('d-m-Y',strtotime($row['cr_transaction_date']));
                }

                $Completed_Date=(!empty($row['completed_on'])) ? date('d-m-Y',strtotime($row['completed_on'])) : '';
                
                if(!empty($Completed_Date)){
                    $NoOfday= $this->getWorkingDays($requested_date,$Completed_Date,$holidays);
                    if(($NoOfday-1) ==0){
                       $dayCount=1; 
                    }else{
                        $dayCount=$NoOfday-1;
                    }
                }else{
                    $dayCount='';
                }
                
                $Transcharge=($row['cr_transaction_charge'] > 0) ? $row['cr_transaction_charge'] : '';
                if($row['count_of_chk']==0){
                    $chkCount='';
                }else{
                    $chkCount=$row['count_of_chk'];
                }
                
                $pRequest_no='PR-'.$row['pr_id'];

                $file='<a href="'.base_url().'uploads/prposaldetails/'.$row['cr_card_file'].'" target="_blank" >'.$row['cr_card_file'].'</a>';
                $attachment=($row['cr_card_file']) ? $file : '';

                $roleid= $this->session->userdata('role_id');

                if($roleid==5  && ($row['payment_status']==31 || $row['payment_status']==33)){
                    $edit= anchor('/Verification/payment_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"Edit",'style="color:blue; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"View",'style="color:orange; font-weight:bold"');   
                }
                else if(($roleid==26 || $roleid==27) && $row['payment_status']==32)
                {
                    $edit= anchor('/Billing/fc_card_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(6),"Edit", 'style="color:blue; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode('card').'/'.base64_encode('Reject'),"Reject",'style="color:red; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(6),"View",'style="color:orange; font-weight:bold"');
                }
                else if(($roleid==26 || $roleid==27) && $row['payment_status']==35){
                    $edit= anchor('/Billing/card_completeview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(7),"View",'style="color:orange; font-weight:bold"');
                }else{
                    $edit= anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(7),"View",'style="color:orange; font-weight:bold"');
                }
                
                $response->rows [$i] ['cell'] = array ($i+$count+1,$edit,$row['case_no'],$row['candidate_name'],$row['check_name'].$chkCount,$row['beneficiary_name'],$row['beneficiary_location'],$row['amount'],$row['paystatus'],$requested_date,$Completed_Date,$dayCount,$row['cr_transaction_no'],$transaction_date,$Transcharge,$row['cr_card_type'],$row['requested_by'],$row['org_name'],$attachment,$edit);
            }
        }
        echo json_encode($response);
    }


    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function fc_card_request *************
     * *************************************************/
    function fc_card_request(){

        $data['request_id']=$request_id = base64_decode($this->uri->segment(3)); 
        $data['level_id']=$level_id = base64_decode($this->uri->segment(4)); 
        $data['check_id']=$check_id = base64_decode($this->uri->segment(5)); 
        $data['pack_id']=$pack_id = base64_decode($this->uri->segment(6));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(7));

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();

        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        $data['payment_details']=$this->vm->get_payment_request_details($pr_id);
        $this->db->select('*');
        $data['cardDetails']=$this->db->get_where('dcode_payment_request_card',array('pr_id'=> $pr_id ))->row_array();

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Card Payment', 'Billing/card');
        $this->breadcrumbs->push('Card Details', 'Billing/fc_card_request');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'fc_card_request');
    }

    function save_card_payment(){

        // print_r($_POST);exit;
        $config['allowed_types'] = '*';
        $config['encrypt_name'] = false;
        $config['remove_spaces'] = false;
        $config['upload_path'] = 'uploads/prposaldetails/';
        $this->load->library('upload', $config);  
        $this->upload->initialize($config); 

        $fileName = $_FILES['card_file']['name'];

        if ($this->upload->do_upload('card_file'))
        {
            $documents[]  = $this->upload->data();
        }
        // else
        // {
        //  echo ($documents['payment_file'] = $this->upload->display_errors());
        // }

        $pr_id=$_POST['pr_id'];
        $transaction_no=$_POST['transaction_no'];
        $transaction_date= date('Y-m-d', strtotime($_POST['transaction_date'])); 
        $transaction_charge=$_POST['transaction_charge'];
        $cardFile=$fileName;
        $updDate=date('Y-m-d H:i:s');
        
        $where = '(pr_id="'.$pr_id.'")';
        $data = array('cr_transaction_no'=> $transaction_no, 'cr_transaction_date'=>$transaction_date, 'cr_transaction_charge'=>$transaction_charge, 'cr_card_file'=>$cardFile,'cr_updated_on'=>$updDate);
        $this->db->set($data);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request_card');

        $roleID=$this->session->userdata('role_id');
        $userID=$this->session->userdata['userid'];
        $ins_data['request_id'] = $_POST['request_id'];
        $ins_data['case_no']= $_POST['case_no'];
        $ins_data['check_id'] = $_POST['check_id'];
        $ins_data['level_id'] = $_POST['level_id'];
        $ins_data['payment_status'] = 35;
        $ins_data['date_of_update'] = date ( 'Y-m-d H:i:s' );
        $ins_data['role_id'] = $roleID;
        $ins_data['user_id'] = $userID;                

        $ins_data = $this->security->xss_clean($ins_data);
        $this->db->insert ( DB_PREFIX .'payment_status_updates', $ins_data );


        $where = '(pr_id="'.$pr_id.'" )';
        $completed_on=date ( 'Y-m-d H:i:s' );
        $this->db->set('payment_status',35);
        $this->db->set('completed_on',$completed_on);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request');

        redirect('Billing/card');
        
    }

    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function card_completeview *************
     * *************************************************/
    function card_completeview(){

        $data['request_id']=$request_id = base64_decode($this->uri->segment(3)); 
        $data['level_id']=$level_id = base64_decode($this->uri->segment(4)); 
        $data['check_id']=$check_id = base64_decode($this->uri->segment(5)); 
        $data['pack_id']=$pack_id = base64_decode($this->uri->segment(6));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(7));
        

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();

        $this->db->select('*');
        $data['cardDetails']=$this->db->get_where('dcode_payment_request_card',array('pr_id'=> $pr_id ))->row_array();

        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        $data['payment_details']=$this->vm->get_payment_request_details($pr_id);

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Card Payment', 'Billing/card');
        $this->breadcrumbs->push('Card Details', 'Billing/card_completeview');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'card_completeview');
    }

    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function card_completed_edit *************
     * *************************************************/
    function card_completed_edit(){

        $data['cr_id']=$cr_id = base64_decode($this->uri->segment(3));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(4)); 

        $data['card_details']=$challan_details=$this->bm->get_card_details($cr_id);
        $data['payment_details']=$payment_details=$this->vm->get_payment_request_details($pr_id);

        $request_id=$payment_details['request_id'];
        $check_id=$payment_details['check_id'];
        $level_id=$payment_details['level_id'];
        $pack_id=$payment_details['pack_id'];

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();
        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Card Payment', 'Billing/card');
        $this->breadcrumbs->push('Card Details', 'Billing/card_completed_edit');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'card_completed_edit');
    }

    function update_card_completed(){
        // print_r($_POST);exit;
        $cr_id=$_POST['cr_id'];
        $transaction_no=$_POST['transaction_no'];
        $transaction_date=date('Y-m-d',strtotime($_POST['transaction_date']));
        $transaction_charge=$_POST['transaction_charge'];

        $config['allowed_types'] = '*';
        $config['encrypt_name'] = false;
        $config['remove_spaces'] = false;
        $config['upload_path'] = 'uploads/prposaldetails/';
        $this->load->library('upload', $config);  
        $this->upload->initialize($config); 

        $fileName = $_FILES['card_file']['name'];
        
        if(empty($fileName)){
            $this->db->select('cr_card_file');
            $this->db->where('cr_id',$cr_id);
            $attachment=$this->db->get(DB_PREFIX.'payment_request_card')->row_array();
                
            $card_file=$attachment['cr_card_file'];
        }else{
            $card_file=$fileName;
        }
        // print_r($_POST);exit;
        $updated_on=date ( 'Y-m-d H:i:s' );
        $where = '(cr_id="'.$cr_id.'")';
        $data = array('cr_transaction_no'=> $transaction_no,'cr_transaction_date'=>$transaction_date,'cr_transaction_charge'=>$transaction_charge,'cr_card_file'=>$card_file,'cr_updated_on'=>$updated_on);
        $this->db->set($data);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request_card');
        redirect('' . base_url('Billing/card'));
        
    }


    /********************************
     * Payment Request for Online Payment **
     ****** function online ********/

    function online() { 

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Online Payment', 'Billing/online');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'card');
    }

    /*****************
    * Online Payment list 
    * get_online_list
    ******************/
    function get_online_list(){ 
        
        $model = array('Billing_model'=>'get_online_payment_list');
        
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $temp_id = ($_REQUEST['template_id']) ? $_REQUEST['template_id'] : '';
        $case_number = ($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
        $requested_by = ($_REQUEST['requested_by']) ? $_REQUEST['requested_by'] : '';
        $payment_status = ($_REQUEST['payment_status']) ? $_REQUEST['payment_status'] : '';
        $payment_reason = ($_REQUEST['payment_reason']) ? $_REQUEST['payment_reason'] : '';
        $c_date = ($_REQUEST['fp_fdate']) ? $_REQUEST['fp_fdate'] : '';
        $t_date = ($_REQUEST['fp_tdate']) ? $_REQUEST['fp_tdate'] : '';
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';

        if($org_id){
            $condition[]=" pr.org_id = ".$org_id;
        }
        
        if($case_number){
            $condition[]=" pr.case_no like '%".$case_number."%'";
        }
        if($requested_by){
            $condition[]=" f.first_name like '%".$requested_by."%'";
        }
        if($payment_status){
            $condition[]=" pr.payment_status =".$payment_status;
        }
        if($payment_reason){
            $condition[]=" pr.reason_payment =".$payment_reason;
        }
        if(!empty($c_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;

            foreach ( $result as $i => $row ) {
                $pr_id=$row['pr_id'];
                $request_id= $row['request_id'];
                $check_id= $row['check_id'];
                $level_id= $row['level_id'];
                $pack_id=0;

                $requested_date='';
                $transaction_date='';

                if($row['requested_date']) {
                    $requested_date=date('d-m-Y',strtotime($row['requested_date']));
                }

                if($row['op_transaction_date'] != '0000-00-00 00:00:00') {
                    $transaction_date=date('d-m-Y',strtotime($row['op_transaction_date']));
                }

                $Completed_Date=(!empty($row['completed_on'])) ? date('d-m-Y',strtotime($row['completed_on'])) : '';
                
                if(!empty($Completed_Date)){
                    $NoOfday= $this->getWorkingDays($requested_date,$Completed_Date,$holidays);
                    if(($NoOfday-1) ==0){
                       $dayCount=1; 
                    }else{
                        $dayCount=$NoOfday-1;
                    }
                }else{
                    $dayCount='';
                }
                
                $Transcharge=($row['op_transaction_charge'] > 0) ? $row['op_transaction_charge'] : '';

                if(!empty($row['op_mobile_no'])){
                    $mobile=$this->encryption->decrypt($row['op_mobile_no']);        
                }else{
                    $mobile='';
                }
                
                if($row['count_of_chk']==0){
                    $chkCount='';
                }else{
                    $chkCount=$row['count_of_chk'];
                }

                $file='<a href="'.base_url().'uploads/prposaldetails/'.$row['op_online_file'].'" target="_blank" >'.$row['op_online_file'].'</a>';
                $attachment=($row['op_online_file']) ? $file : '';

                $roleid= $this->session->userdata('role_id');

                if($roleid==5  && ($row['payment_status']==31 || $row['payment_status']==33)){
                    $edit= anchor('/Verification/payment_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"Edit",'style="color:blue; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id),"View",'style="color:orange; font-weight:bold"');   
                }
                else if(($this->session->userdata('role_id')==26 || $this->session->userdata('role_id')==27) && $row['payment_status']==32)
                {
                    $edit= anchor('/Billing/fc_online_request/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(6),"Edit", 'style="color:blue; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode('online').'/'.base64_encode('Reject'),"Reject",'style="color:red; font-weight:bold"').' / '.anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(7),"View",'style="color:orange; font-weight:bold"');
                }
                else if(($this->session->userdata('role_id')==27 || $this->session->userdata('role_id')==26) && $row['payment_status']==35)
                {
                    $edit= anchor('/Billing/online_completeview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(7),"View",'style="color:orange; font-weight:bold"');
                }else{
                    $edit= anchor('/Billing/payment_requestview/'.base64_encode($request_id).'/'.base64_encode($level_id).'/'.base64_encode($check_id).'/'.base64_encode($pack_id).'/'.base64_encode($pr_id).'/'.base64_encode(6),"View",'style="color:orange; font-weight:bold"');
                }
                
                $response->rows [$i] ['cell'] = array ($i+$count+1,$edit,$row['case_no'],$row['candidate_name'],$row['check_name'].$chkCount,$row['beneficiary_name'],$row['beneficiary_location'],$row['amount'],$row['paystatus'],$requested_date,$Completed_Date,$dayCount,$row['op_transaction_no'],$transaction_date,$Transcharge,$mobile,$row['requested_by'],$row['org_name'],$attachment,$edit);
            }
        }
        echo json_encode($response);
    }


    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function fc_online_request *************
     * *************************************************/
    function fc_online_request(){

        $data['request_id']=$request_id = base64_decode($this->uri->segment(3)); 
        $data['level_id']=$level_id = base64_decode($this->uri->segment(4)); 
        $data['check_id']=$check_id = base64_decode($this->uri->segment(5)); 
        $data['pack_id']=$pack_id = base64_decode($this->uri->segment(6));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(7));

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();

        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        $data['payment_details']=$this->vm->get_payment_request_details($pr_id);
        $this->db->select('*');
        $data['onlineDetails']=$this->db->get_where('dcode_payment_request_online',array('pr_id'=> $pr_id ))->row_array();

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Online Payment', 'Billing/online');
        $this->breadcrumbs->push('Online Details', 'Billing/fc_online_request');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'fc_online_request');
    }

    function save_online_payment(){

        // print_r($_POST);exit;
        $config['allowed_types'] = '*';
        $config['encrypt_name'] = false;
        $config['remove_spaces'] = false;
        $config['upload_path'] = 'uploads/prposaldetails/';
        $this->load->library('upload', $config);  
        $this->upload->initialize($config); 

        $fileName = $_FILES['online_file']['name'];

        if ($this->upload->do_upload('online_file'))
        {
            $documents[]  = $this->upload->data();
        }
        // else
        // {
        //  echo ($documents['payment_file'] = $this->upload->display_errors());
        // }

        $pr_id=$_POST['pr_id'];
        $transaction_no=$_POST['transaction_no'];
        $transaction_date= date('Y-m-d', strtotime($_POST['transaction_date'])); 
        $transaction_charge=$_POST['transaction_charge'];
        $onlineFile=$fileName;
        $updDate=date('Y-m-d H:i:s');
        
        $where = '(pr_id="'.$pr_id.'")';
        $data = array('op_transaction_no'=> $transaction_no, 'op_transaction_date'=>$transaction_date, 'op_transaction_charge'=>$transaction_charge, 'op_online_file'=>$onlineFile,'op_updated_on'=>$updDate);
        $this->db->set($data);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request_online');

        $roleID=$this->session->userdata('role_id');
        $userID=$this->session->userdata['userid'];
        $ins_data['request_id'] = $_POST['request_id'];
        $ins_data['case_no']= $_POST['case_no'];
        $ins_data['check_id'] = $_POST['check_id'];
        $ins_data['level_id'] = $_POST['level_id'];
        $ins_data['payment_status'] = 35;
        $ins_data['date_of_update'] = date ( 'Y-m-d H:i:s' );
        $ins_data['role_id'] = $roleID;
        $ins_data['user_id'] = $userID;                

        $ins_data = $this->security->xss_clean($ins_data);
        $this->db->insert ( DB_PREFIX .'payment_status_updates', $ins_data );


        $where = '(pr_id="'.$pr_id.'" )';
        $completed_on=date ( 'Y-m-d H:i:s' );
        $this->db->set('payment_status',35);
        $this->db->set('requested_amount',$_POST['amount']);
        $this->db->set('completed_on',$completed_on);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request');

        redirect('Billing/online');
        
    }

    /************* Finance Executive Payment Request View Page ***********
     * ****** function online_completeview *************
     * *************************************************/
    function online_completeview(){

        $data['request_id']=$request_id = base64_decode($this->uri->segment(3)); 
        $data['level_id']=$level_id = base64_decode($this->uri->segment(4)); 
        $data['check_id']=$check_id = base64_decode($this->uri->segment(5)); 
        $data['pack_id']=$pack_id = base64_decode($this->uri->segment(6));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(7));
        

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();

        $this->db->select('*');
        $data['onlineDetails']=$this->db->get_where('dcode_payment_request_online',array('pr_id'=> $pr_id ))->row_array();

        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        $data['payment_details']=$this->vm->get_payment_request_details($pr_id);

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Online Payment', 'Billing/online');
        $this->breadcrumbs->push('Online Details', 'Billing/online_completeview');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'card_completeview');
    }

    /************* Finance Executive Payment Request Edit Page ***********
     * ****** function card_completed_edit *************
     * *************************************************/
    function online_completed_edit(){

        $data['op_id']=$op_id = base64_decode($this->uri->segment(3));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(4)); 

        $data['online_details']=$challan_details=$this->bm->get_online_details($op_id);
        $data['payment_details']=$payment_details=$this->vm->get_payment_request_details($pr_id);

        $request_id=$payment_details['request_id'];
        $check_id=$payment_details['check_id'];
        $level_id=$payment_details['level_id'];
        $pack_id=$payment_details['pack_id'];

        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();
        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];

        
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Online Payment', 'Billing/online');
        $this->breadcrumbs->push('Onlne Details', 'Billing/online_completed_edit');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'online_completed_edit');
    }


    function update_online_completed(){
        // print_r($_POST);exit;
        $op_id=$_POST['op_id'];
        $pr_id=$_POST['pr_id']; 
        $transaction_no=$_POST['transaction_no'];
        $transaction_date=date('Y-m-d',strtotime($_POST['transaction_date']));
        $transaction_charge=$_POST['transaction_charge'];

        $config['allowed_types'] = '*';
        $config['encrypt_name'] = false;
        $config['remove_spaces'] = false;
        $config['upload_path'] = 'uploads/prposaldetails/';
        $this->load->library('upload', $config);  
        $this->upload->initialize($config); 

        $fileName = $_FILES['online_file']['name'];
        
        if(empty($fileName)){
            $this->db->select('op_online_file');
            $this->db->where('op_id',$op_id);
            $attachment=$this->db->get(DB_PREFIX.'payment_request_online')->row_array();
                
            $online_file=$attachment['op_online_file'];
        }else{
            $online_file=$fileName;
        }
        // print_r($_POST);exit;
        $updated_on=date ( 'Y-m-d H:i:s' );
        $where = '(op_id="'.$op_id.'")';
        $data = array('op_transaction_no'=> $transaction_no,'op_transaction_date'=>$transaction_date,'op_transaction_charge'=>$transaction_charge,'op_online_file'=>$online_file,'op_updated_on'=>$updated_on);
        $this->db->set($data);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request_online');

        $where = '(pr_id="'.$pr_id.'" )';
        $this->db->set('requested_amount',$_POST['amount']);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request');

        redirect('' . base_url('Billing/online'));
        
    }

    /*************************************************
     Listing of New Report
    *************************************************/
    function new_report()
    {
        $this->breadcrumbs->push($this->dashboard, $this->index_dashboard);
        $this->breadcrumbs->push('New Report', 'Billing/new_report');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'new_report');
    }


    function get_newreport(){
        
        $model = array('Billing_model'=>'get_newcheckstatus');
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $case_number=($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
        $a_status = ($_REQUEST['a_status']) ? $_REQUEST['a_status'] : '';
        //echo $a_status; exit;
        $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : ''; 
        $chk_rpt_status = ($_REQUEST['chk_rpt_status']) ? $_REQUEST['chk_rpt_status'] : '';
        $interim = ($_REQUEST['interim']) ? $_REQUEST['interim'] : '';
        

        if($parent_office){
        $condition[]=" d.parent_office = ".$parent_office;
        }
        if($office){
        $condition[]=" d.office = ".$office;
        }
        if($org_id){
        $condition[]=" d.organisation = ".$org_id;
        }
        if($sub_office){
        $condition[]=" d.sub_office = ".$sub_office;
        }
        if($name){
        $condition[]=" d.candidate_name like '%".$name."%'";
        }
        //17/01/2024
        $case_number = trim($case_number);
        if($case_number){
        $condition[]=" d.case_no like '%".$case_number."'";
        }
        
        if(!empty($c_date) && $a_status==4){
        $condition[]="DATE_FORMAT(vl1.qc2_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date) && $a_status==4){
        $condition[]="DATE_FORMAT(vl1.qc2_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        if(!empty($c_date) && $a_status==5){
        $condition[]="DATE_FORMAT(d.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date) && $a_status==5){
        $condition[]="DATE_FORMAT(d.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }

        if(!empty($c_date) && $a_status==11){
        $condition[]="(DATE_FORMAT(d.case_accepted_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and s.client_status=1 and case when d.dataentry_by=3 Then DATE_FORMAT(d.case_recieved_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' else 1 end) ";
        }
        if(!empty($t_date) && $a_status==11){
        $condition[]="(DATE_FORMAT(d.case_accepted_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and s.client_status=1 and case when d.dataentry_by=3 Then DATE_FORMAT(d.case_recieved_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' else 1 end) ";
        }
        
        if($a_status==4){
        $condition[]="   a.qc2_verification=1 and a.qc2_report_publish=1" ;
        }
        if($a_status==12){
          $condition[]="a.qc2_report_publish != 1 ";
        }
    
        if($chk_rpt_status==1){
        $condition[]=" vl1.qc2_dis in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701) ";
        }
        if($chk_rpt_status==2){
        $condition[]=" ((vl1.qc2_dis in (120,131,137,143,713,119,130,136,142,1005)) or (vl1.qc2status in (519,110)))";
        }
        if($chk_rpt_status==3){
        $condition[]=" vl1.qc2_dis in (116,127,134,140,630,121,125,658,662,660,789) ";
        }

        if($interim ==1){
            $condition[]=" a.qc2_report_publish = 1 and a.qc2_verification=1 ";
        }
        if($interim ==2){
            $condition[]=" a.qc2_report_publish = 1 and d.final_report=1 ";
        }
        if($interim ==3){
            $condition[]=" ca.request_id IS NOT NULL ";
        }
        if($interim ==4){
            $condition[]=" vl1.supplementary =3 ";
        }

        $manual_cond=implode(' and ',$condition);  
        $manual_condition2=$manual_cond;
        $results = $this->_jqgrid_search($model,$manual_condition2);
        $response = $results[0];  
        $result = $results[1];

        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows;
        // echo '<pre>';print_r($result);exit;
        foreach ( $result as $i => $row ) {

            $checkadminstatus = $this->vm->get_currentstatus($row['candidate_req_id']);
            /* VM Status Start */
            $verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['check_id']);
            $verification_data=toArray(json_decode($verified_data['fielddata']));
            $qc2_data=toArray(json_decode($verified_data['qc2fielddata']));

            $status1=$this->vm->get_status($verification_data['status']);
            $status4='';
            $status2=$this->vm->get_status($verification_data['pstatus']);
            $status3=$this->vm->get_status($verification_data['status1']);
            if($verification_data['ostatus']<>''){
            $status4=$this->vm->get_status($verification_data['ostatus']);
            }
            if($verification_data['dstatus']<>''){
            $status4=$this->vm->get_status($verification_data['dstatus']);
            }
            if(!empty($status4)){
                $status41='-'.$status4['name'];
            }
            else{
                $status41='';
            }

            $stat='';
            $verifyurl='';
            if(!empty($status1['name'])){
                $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
            }
            else if($row['verify_status']<>'111' && $row['vrequest']==1 && $row['rstatus']==107){
                $stat='Initiated';
            }
            else{
                $stat='New';
            }
            if($row['qc_revert_request']==1){
                if($row['vm_assigned_qc']==1 && $row['verify_status']<>107){
                    $verifyurl=$stat;
                }
                 // March 27th
                else if($row['vm_assigned_qc']==0 && $row['ass_request']==0 && $row['reopen_revert_qc2']==1)
                {
                    $verifyurl = 'Reopen Assigned';
                }  // March 27th

                else{
                $verifyurl = 'Revert Assigned';
                }
            }elseif($row['vm_revert_option_status']==1 && $row['vm_revert_to']==2){
            $verifyurl = 'Revert Raised to DEO';
            }elseif($row['vm_revert_option_status']==2){
            $verifyurl = 'Revert Raised to cadmin';
            }elseif($row['vm_revert_to']==3 && $row['vm_revert_supervisor']==1){
            $verifyurl = 'Revert Raised to DES';
            }
            else if($row['vm_revert_option_status']==4 && $row['operator_submited_by']==12 || $row['vm_revert_option_status']==4 && $checkadminstatus['role_id']==13){
            $verifyurl = 'Revert Closed'; 
            }
            else if($row['vm_revert_to']==2 ){
            $verifyurl = 'Revert Closed'; 
            }
            else if($row['verify_status']<>'111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0)
            {
            $verifyurl = $stat;  
            }
            else if($row['verify_status']=='111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0)
            {
            $verifyurl = $stat; 
            }
            else if($row['ass_request']==1)
            { 
            $verifyurl='Request Raised';
            }
            else
            { 
            $verifyurl = $stat;
            }
            /* VM Status End */
                   
            
            /* qc2 Status Start */
            $qc2verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['check_id']);
            $qc2verification_data=toArray(json_decode($qc2verified_data['qc2fielddata']));
            
            $qc2status4='';
            $qc2status1=$this->vm->get_status($qc2verification_data['status']);
            // $qc2status2=$this->vm->get_status($qc2verification_data['pstatus']);
            $qc2status3=$this->vm->get_status($qc2verification_data['status1']);

            $qc2remark='';

            if($qc2verification_data['ostatus']<>''){
            $qc2status4=$this->vm->get_status($qc2verification_data['ostatus']);
            }
            if($qc2verification_data['dstatus']<>''){
            $qc2status4=$this->vm->get_status($qc2verification_data['dstatus']);
            }
            
            if(!empty($qc2status1['name']) && $row['qc2_report_publish']==1){
                // // March 27th
                if($row['qc_2_verification']==1 && $row['supplementary']==1)
                    {
                        $qc2stat='Reopen Assigned';
                    }
                else // March 27th
                    $qc2stat='Report Published';
            }else if(!empty($qc2status1['name']) && $row['qc2_verification']==1 && $row['qc2_report_publish']==0){
                $qc2stat='QC2 Approved';
            }
            else
            {
            $qc2stat='';
            }
            $qc2status='';
            $rpt_status='';

            if($qc2verification_data['status']!=107 && $qc2verification_data['status']!=684 && !empty($qc2verification_data['status'])) {
            if($qc2status3['name']=="Discrepant" || $qc2status3['name']=="Possible Discrepant" || $qc2status3['name']=="Record Found" || $qc2status3['name']=="Positive" || $qc2status3['name']=="No Records" || $qc2status3['name']=="Invalid" || $qc2status3['name']=="Not Completed" || $qc2status3['name']=="High Risk"){
                $rpt_status="<span style='color:red;'>RED</span>";
                $qc2remark=$qc2verification_data['other_comment'].$qc2_data['discrapancy_text'];
            }
            /** Aug 24th **/
            else if($qc2status1['name']=="Others" && (strtoupper($qc2status4['name']) == "NOT APPLICABLE")) // Dec 15th
            {
                $rpt_status="<span style='color:green;'>GREEN</span>";
            }
            /** Aug 24th **/
            else if($qc2status1['name']=="Stop Check" || $qc2status3['name']=="Stop Check" || $qc2status3['name']=="Others" || $qc2status3['name']=="Possible Match" || $qc2status3['name']=="Partial Match" || $qc2status1['name']=="Others" && (strtoupper($qc2status4['name']) != "NOT APPLICABLE")) // Dec 15th
            {
                $rpt_status="<span style='color:orange;'>ORANGE</span>";
                $qc2remark=$qc2verification_data['other_comment'].$qc2_data['discrapancy_text'];
            }
            else 
            {
                $rpt_status="<span style='color:green;'>GREEN</span>";
            }
            }  

            if($row['vmstatus']==1)
            {
            if($row['qc2_verification']==0 && $row['qc1_verification']==1 )
            {
                $qc2status='New';
                if($row['qc1_assign_revert']==1  && $row['qc_2_verification']==0 && $row['vm_assigned_qc']==1 && $row['reopen_revert_qc2']==0){
                    $qc2status='Revert Closed';

                }

                else if($row['qc1_assign_revert']==1  && $row['supplementary']==1 && $row['qc_2_verification']==0 && $row['vm_assigned_qc']==1 && $row['reopen_revert_qc2'] == 1){
                    $qc2status='Reopen Closed';
                }

                else if($row['qc2_revert_request']==1 && $row['reopen_revert_qc2']== 1 && $row['supplementary']==1  && $row['qc2_report_publish']==2)
                {
                    if($row['revertedBy'] == 17)
                    {
                        $qc2status='Revert Raised';
                    }
                    else
                    {
                        $qc2status='Reopened'; 
                    }
                }

                else if($row['qc2_revert_request']==1 && $row['reopen_revert_qc2']== 1 && $row['supplementary']==1  && $row['qc2_report_publish']==1)
                {
                    if($row['revertedBy'] == 17)
                    {
                        $qc2status='Revert Raised';
                    }
                    else
                    {
                        $qc2status='Reopened'; 
                    }
                } 

                else if($row['qc2_revert_request']==1 && $row['supplementary']==1 && $row['vm_assigned_qc']==1)
                {
                    $qc2status='Reopened';
                
                } 
                else if($row['qc2_revert_request']==1 && $row['reopen_revert_qc2']== 1 && $row['supplementary']==1)
                {
                    $qc2status='Revert Raised';
                }

                else if($row['qc2_revert_request']==1)
                {
                    $qc2status='Revert Raised';
                }         // March  27th

            }
            elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==2 && $row['qc2_revert_request']==0)
            {
            $qc2status='Report Reopen';
            }
            else
            {
                $qc2status=$qc2stat;
            }    
            }
            else
            {
                $qc2status='';
            }
           
            $qc2_date='';
            $qc2_month='';
            $qc2_year='';

            if($row['qc2_date']!='' && $row['qc2_report_publish']==1)
            {
                $qc2_date=date('d-m-Y', strtotime($row['qc2_date']));
                $qc2_month=date('m', strtotime($row['qc2_date']));
                $qc2_year=date('Y', strtotime($row['qc2_date']));
            }

            $finalReport=$this->vm->get_repfinal($row['candidate_req_id']);
            $supplementaryRep=$this->vm->get_repsuppl($row['candidate_req_id']);

            $tat_data=$this->vm->get_tatchk_details($row['candidate_req_id'],$row['level_id'],$row['check_id']);

            $tat = $tat_data['tat_overall']-$tat_data['wait_ticket'];
            if($tat <= 0){
                $tat = 1;
            }
            $wait=($tat_data['wait_ticket'] ==0) ? '' : $tat_data['wait_ticket'];


            if(!empty($finalReport) && empty($supplementaryRep)){
                $reportType='Final';
            }else if(!empty($supplementaryRep)){
                $reportType='Supplementary';
                $tat='';
                $wait='';
            }else{
                $reportType='Interim';
            }

            if($row['ticket_status']==1){
                $tkt_ststus='Open';  
            }else if($row['ticket_status']==2){
                $tkt_ststus='Requested';  
            }else if($row['ticket_status']==3){
                $tkt_ststus='revert';  
            }else if($row['ticket_status']==4){
                $tkt_ststus='Re-requested';  
            }else if($row['ticket_status']==101){
                $tkt_ststus='Closed';  
            }else{
                $tkt_ststus='';
            }

            $chk_count='';
            $chk_count=($row['count_of_chk'] != 0)?$row['count_of_chk']:'';
            
            if($row['dataentry_by']!=3 && $row['case_accepted_date']!="0000-00-00 00:00:00" && !empty($row['case_accepted_date']))
            {
                $case_accepted_date=date('d-m-Y',strtotime($row['case_accepted_date']));
                $caMonth=date('m',strtotime($row['case_accepted_date']));
                $caYear=date('Y',strtotime($row['case_accepted_date']));
            }  
            else if($row['dataentry_by']==3 && $row['case_recieved_date']!="0000-00-00" && !empty($row['case_recieved_date']))
            {
                $case_accepted_date=date('d-m-Y',strtotime($row['case_recieved_date']));
                $caMonth=date('m',strtotime($row['case_recieved_date']));
                $caYear=date('Y',strtotime($row['case_recieved_date']));
            }else{
                $case_accepted_date='';
                $caMonth='';
                $caYear='';
            }
           /* qc2Status End */

           $insufDetail='';
           if($row['ticket_status']==2 || $row['ticket_status']==4)
           {
                $insufDetail=$row['ticket_details'];
           }

            $holidays=[];
            $currentDate=date('d-m-Y');
            if(!empty($qc2_date)){
                $NoOfday= $this->getWorkingDays($case_accepted_date,$qc2_date,$holidays);
                if($NoOfday==0){
                   $SLA=1; 
                }else{
                    $SLA=$NoOfday-1;
                }   
            }else{
                $NoOfday= $this->getWorkingDays($case_accepted_date,$currentDate,$holidays);
                $SLA='';
                $tat=$NoOfday;
            }
            
            if(!empty($tat_data['reopen_date']))
            {
                $reopenDate=date('d-m-Y',strtotime($tat_data['reopen_date']));    
            }else{
                $reopenDate='';
            }
               

            $joinerData=$this->vm->get_joiners($row['case_no']);
            if(!empty($joinerData['jd_case_no'])){
                $joinerList='Yes';
            }else{
                $joinerList='';   
            }

            $joinDate='';
            $emailDate='';
            if($joinerData['jd_joining_date'] !="0000-00-00" && !empty($joinerData['jd_joining_date']))
            {
                $joinDate=date('d-m-Y',strtotime($joinerData['jd_joining_date']));    
            }

            if($joinerData['jd_email_date'] !="0000-00-00" && !empty($joinerData['jd_email_date']))
            {
                $emailDate=date('d-m-Y',strtotime($joinerData['jd_email_date']));    
            }

            $college_name='';
            $university_name='';
            if($row['check_id']==14){
                $clg_cmpny_name=$row['degree'];
                $college_name = $row['collegename_add'];
                $university_name = $row['affliated'];
            }
            else if($row['check_id']==59){
                $clg_cmpny_name=$row['company_name'];
            }
            else if($row['check_id']==68){
                $clg_cmpny_name=$row['pcompany_name'];
            }
            else{
                $clg_cmpny_name='';
            }

            $source=$college_name.' '.$university_name.' '.$clg_cmpny_name;
            
            $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['candidatename'],$row['case_no'],$row['checkname'].' '.$chk_count,$source,$verifyurl,$tkt_ststus,$reportType,$rpt_status,$insufDetail,$qc2remark,$qc2status,$qc2_date,$qc2_month,$qc2_year,$case_accepted_date,$caMonth,$caYear,$SLA,$tat,$wait,$reopenDate,$joinerList,$row['email'],$emailDate,$joinDate,$joinerData['jd_country']);

            }
        }
        echo json_encode($response);
    }


    function reject_payment(){

        // print_r($_POST);exit;
        $roleID=$this->session->userdata('role_id');
        $userID=$this->session->userdata['userid'];

        $PR_ID=$_POST['pr_id'];
        $reject_reason=$_POST['reject_reason'];
        $r_url=$_POST['menu'];

        $ins_data['request_id'] = $_POST['request_id'];
        $ins_data['case_no']= $_POST['case_no'];
        $ins_data['check_id'] = $_POST['check_id'];
        $ins_data['level_id'] = $_POST['level_id'];
        $ins_data['payment_status'] = 33;
        $ins_data['date_of_update'] = date ( 'Y-m-d H:i:s' );
        $ins_data['role_id'] = $roleID;
        $ins_data['user_id'] = $userID;                

        $ins_data = $this->security->xss_clean($ins_data);
        $this->db->insert ( DB_PREFIX .'payment_status_updates', $ins_data );


        $where = '(pr_id="'.$PR_ID.'")';
        $data = array('payment_status'=> 33,'reject_reason'=>$reject_reason);
        $this->db->set($data);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request');

        redirect('' . base_url('Billing/'.$r_url));
    }

    function save_bankdetails(){

        $bankName=$_POST['bank_name'];
        $location=$_POST['Location'];
        $pr_id=$_POST['pr_id'];
        $template=$_POST['template'];

        $where = '(pr_id="'.$pr_id.'")';
        $data = array('beneficiary_location'=>$location,'bank_name'=> $bankName,);
        $this->db->set($data);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request');

        if($template==2){
            redirect('' . base_url('Billing/kotak_dd'));
        }else if($template==3){
            redirect('' . base_url('Billing/sbi_dd'));
        }else{
            redirect('' . base_url('Billing/payment_requestlist'));
        }

    }


    /************* DD Cancel View Page ***********
     * ****** function dd_cancel_request *************
     * *************************************************/
    function dd_cancel_request(){

        $data['request_id']=$request_id = base64_decode($this->uri->segment(3)); 
        $data['level_id']=$level_id = base64_decode($this->uri->segment(4)); 
        $data['check_id']=$check_id = base64_decode($this->uri->segment(5)); 
        $data['pack_id']=$pack_id = base64_decode($this->uri->segment(6));
        $data['pr_id']=$pr_id = base64_decode($this->uri->segment(7));
        $data['menu']=base64_decode($this->uri->segment(8));
        // $data['action'] = base64_decode($this->uri->segment(9));


        $this->db->select('order_id,organisation');
        $order=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();
        $orderID=$order['order_id'];
        $organization=$order['organisation'];
        $blanket_approval=$this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit']=$blanket_approval['blanket_approval_limit'];        
        
        $data['contsofcheck']=$check_details=$this->vm->countsofchk($request_id,$check_id,$level_id);
        $data['data_details']=$check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$check_id ))->row_array();
        $data['slug']= $slug=url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        $data['payment_details']=$this->vm->get_payment_request_details($pr_id);

        $this->db->select('*');
        $data['neftDetails']=$this->db->get_where('dcode_payment_request_neft',array('pr_id'=> $pr_id ))->row_array();

        $this->db->select('*');
        $data['challanDetails']=$this->db->get_where('dcode_payment_request_challan',array('pr_id'=> $pr_id ))->row_array();

        $this->db->select('*');
        $data['cardDetails']=$this->db->get_where('dcode_payment_request_card',array('pr_id'=> $pr_id ))->row_array();

        $this->db->select('*');
        $data['onlineDetails']=$this->db->get_where('dcode_payment_request_online',array('pr_id'=> $pr_id ))->row_array();

        if($pack_id>94){

            $level_details=$this->dm->$slug($request_id,$pack_id,$level_id);
        }
        else{
            $level_details=$this->dm->$slug($request_id,$check_id,$level_id);        
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college']=$level_details[0]['collegename_add'];
        $data['university']=$level_details[0]['affliated'];


        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Payment Request Cancel', 'Billing/dd_cancel_request');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'dd_cancel_request');
    }

    function dd_cancel(){

        // print_r($_POST);exit;
        $roleID=$this->session->userdata('role_id');
        $userID=$this->session->userdata['userid'];

        $PR_ID=$_POST['pr_id'];
        $reject_reason=$_POST['reject_reason'];
        $menu=$_POST['menu'];

        $ins_data['request_id'] = $_POST['request_id'];
        $ins_data['case_no']= $_POST['case_no'];
        $ins_data['check_id'] = $_POST['check_id'];
        $ins_data['level_id'] = $_POST['level_id'];
        $ins_data['payment_status'] = 36;
        $ins_data['date_of_update'] = date ( 'Y-m-d H:i:s' );
        $ins_data['role_id'] = $roleID;
        $ins_data['user_id'] = $userID;                

        $ins_data = $this->security->xss_clean($ins_data);
        $this->db->insert ( DB_PREFIX .'payment_status_updates', $ins_data );


        $where = '(pr_id="'.$PR_ID.'")';
        $data = array('payment_status'=> 36,'reject_reason'=>$reject_reason);
        $this->db->set($data);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'payment_request');

        if($menu == 2){
            $r_url='kotak_dd';
        }else{
            $r_url='sbi_dd';
        }
        redirect('' . base_url('Billing/'.$r_url));
    }

    /****** Bulk Invite*************
     * ****Created by KP ***********
     ******* function bulk_inite****/
    function bulk_invite()
    {
        // Check if user is allowed for action
        $this->_check_featureauth('candidate', 'search');
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Candidate', 'Management/bulk_inite');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'candidate');
    }

    function candidate_invite(){
        
        $file_path =  $_FILES["bulk"]['tmp_name'];
        include 'Classes/PHPExcel/IOFactory.php';
        $inputFileName = $file_path;
        $objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
        $allDataInSheet = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
        // echo '<pre>';print_r($allDataInSheet);

        $arrayCount = count($allDataInSheet);  // Here get total count of row in that Excel sheet
        $data = array();
        $j=0;
        for($i=2;$i<=$arrayCount;$i++)
        {                   
            $data[$j]['Organization']=$allDataInSheet[$i]["B"];
            $data[$j]['Head Office']=$allDataInSheet[$i]["C"];
            $data[$j]['Branch Office']=$allDataInSheet[$i]["D"];
            $data[$j]['Sub Office']=$allDataInSheet[$i]["E"];
            $data[$j]['First Name']=$allDataInSheet[$i]["F"];
            $data[$j]['Middle Name']=$allDataInSheet[$i]["G"];
            $data[$j]['Last Name']=$allDataInSheet[$i]["H"];
            $data[$j]['Gender']=$allDataInSheet[$i]["I"];
            $data[$j]['Email Id']=$allDataInSheet[$i]["J"];
            $data[$j]['Package Name']=$allDataInSheet[$i]["K"];
            $data[$j]['Client Admin / HR']=$allDataInSheet[$i]["L"];
            $j++;
            
        }

        $first_name='First Name';
        $last_name='Last Name';
        $email='Email Id';
        $orgnization='Organization';
        $hoffice='Head Office';
        $gender='Gender';
        $package_name='Package Name';
        // echo '<pre>';print_r($data);
        foreach($data as $val)
        {
            $orgId=$this->bm->get_orgid($val['Organization']);
            $org_id=$orgId['id'];
            
            $hoId=$this->bm->get_hoffice_id($val['Head Office'],$org_id);
            $ho_id=$hoId['id'];

            $brId=$this->bm->get_branchoffice_id($val['Branch Office'],$org_id);
            $br_id=$brId['id'];

            $soId=$this->bm->get_suboffice_id($val['Sub Office'],$org_id);
            $so_id=$soId['id'];

            if (empty($val['Organization'])){
                echo "<h2 align='center'>ERROR</h2>";
                echo "<label style='color:red;'>" .$orgnization. ' is required</label><br>';
                echo "Please go back by clicking on <a href='" . base_url('/Billing/bulk_invite') . "'><input type='button' value='Back'></a>";
                exit;
            }

            if (empty($val['Head Office'])){
                echo "<h2 align='center'>ERROR</h2>";
                echo "<label style='color:red;'>" .$hoffice. ' is required</label><br>';
                echo "Please go back by clicking on <a href='" . base_url('/Billing/bulk_invite') . "'><input type='button' value='Back'></a>";
                exit;
            }

            if (empty($val['First Name'])){
                echo "<h2 align='center'>ERROR</h2>";
                echo "<label style='color:red;'>" .$first_name. ' is required</label><br>';
                echo "Please go back by clicking on <a href='" . base_url('/Billing/bulk_invite') . "'><input type='button' value='Back'></a>";
                exit;
            }

            if (empty($val['Last Name'])){
                echo "<h2 align='center'>ERROR</h2>";
                echo "<label style='color:red;'>" .$last_name. ' is required</label><br>';
                echo "Please go back by clicking on <a href='" . base_url('/Billing/bulk_invite') . "'><input type='button' value='Back'></a>";
                exit;
            }

            if (empty($val['Email Id'])){
                echo "<h2 align='center'>ERROR</h2>";
                echo "<label style='color:red;'>" .$email. ' is required</label><br>';
                echo "Please go back by clicking on <a href='" . base_url('/Billing/bulk_invite') . "'><input type='button' value='Back'></a>";
                exit;
            }else{
                if (!filter_var($val['Email Id'], FILTER_VALIDATE_EMAIL)) {
                    echo "<h2 align='center'>ERROR</h2>";
                    echo "<label style='color:red;'>Invalid email address</label><br>";
                    echo "Please go back by clicking on <a href='" . base_url('/Billing/bulk_invite') . "'><input type='button' value='Back'></a>";
                    exit;
                }
            }

            if (empty($val['Gender'])){
                echo "<h2 align='center'>ERROR</h2>";
                echo "<label style='color:red;'>" .$gender. ' is required</label><br>';
                echo "Please go back by clicking on <a href='" . base_url('/Billing/bulk_invite') . "'><input type='button' value='Back'></a>";
                exit;
            }

            if (empty($val['Package Name'])){
                echo "<h2 align='center'>ERROR</h2>";
                echo "<label style='color:red;'>" .$package_name. ' is required</label><br>';
                echo "Please go back by clicking on <a href='" . base_url('/Billing/bulk_invite') . "'><input type='button' value='Back'></a>";
                exit;
            }else{
                
                $packId=$this->bm->get_package_id($val['Package Name'],$org_id);
                $pack_id=$packId['package_id'];
                
                if(empty($pack_id)){

                    echo "<h2 align='center'>ERROR</h2>";
                    echo "<label style='color:red;'>" .$val['Package Name']. ' does not exist. please provide correct package name.</label><br><br>';
                    echo "Please go back by clicking on <a href='" . base_url('/Billing/bulk_invite') . "'><input type='button' value='Back'></a>";
                    exit;
                }
            }
            
            $cand_email = $this->amodel->getDetails(DB_PREFIX . "user", array('email'), array('email' => $val['Email Id'], 'parent_office' => $ho_id, 'active_status!=' => 3));

            if(!empty($cand_email[0]['email']) ){
                echo "<h2 align='center'>ERROR</h2>";
                echo "<label style='color:red;'>" .$cand_email[0]['email']. ' is already exist. please try with diffent email address</label><br><br>';
                echo "Please go back by clicking on <a href='" . base_url('/Billing/bulk_invite') . "'><input type='button' value='Back'></a>";
                exit;
            }
            
        }
        
        $id=0;
        $this->bm->bulkdml($data, $id);
        redirect('Billing/bulk_invite');
        
    }

    function get_bulk_invite()
    {
        $model = array('Billing_model' => 'get_bulk_invitelist');

        if ($_REQUEST['name']) {
            $condition[] = " a.org_name like '%" . $_REQUEST['name'] . "%'";
        }
        

        $manual_cond = implode(' and ', (array)$condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            // print_r($result);exit;
            foreach ($result as $i => $row) {
                
                $candidateName=$row['first_name'].' '.$row['middle_name'].' '.$row['last_name'];
                $response->rows[]['cell'] = array(
                    $i + $count + 1,$row['organization'], $row['head_office'],$row['branch_office'],$row['sub_office'],$candidateName,$row['gender'],$row['email_id'],$row['package_name'],$row['user_name'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'));
            }
        }
        echo json_encode($response);
    }

    /***************************
     **** Masking PDF **********
     * function mask_pdf ********
     * By Kp Chandan ************/
    function mask_pdf(){

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Mask File', 'Verification/mask_pdf');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'Mask File');

    }

    function mask_file(){

        $config['allowed_types'] = '*';
        $config['encrypt_name'] = false;
        $config['remove_spaces'] = false;
        $config['upload_path'] = 'uploads/candidate/';
        $this->load->library('upload', $config);  
        $this->upload->initialize($config); 

        $fileName = $_FILES['mask']['name'];

        // echo $fileName;

        if ($this->upload->do_upload('mask'))
        {
            $documents[]  = $this->upload->data();
        }else{
            echo "Error";
        }
        // print_r($documents);
        // exit;
        $output = shell_exec("/home/chandan/Downloads/masker/temp/process.sh /var/www/html/dcode_web/uploads/candidate/".$fileName);
        echo $output;

    }
    


















}
