<?php 
if (!defined('BASEPATH')) {
        exit('No direct script access allowed');
}
require_once ('Common.php');
require_once ('./PHPExcel-1.8/Classes/PHPExcel.php');
class Charges extends Common {
   protected $request_orgid ='org_id';
    protected $request_office ='office';
    protected $request_parent_office ='parent_office';
    protected $request_sub_office ='sub_office';

     function __construct() 
     {
        parent::__construct();
        $this->_check_userlogin ();
       $models = array('Verification_model' => 'vm','Dadmin_model'=>'dm','Dataentry_model'=>'dem','Reports_model'=>'rm','Client_model'=>'cm','Verification_report_model'=>'vrm','Qualityverification_model'=>'qc', 'Candidate_model'=>'cam','Charges_model'=>'chm');
        $this->lang->load('Dataentry');
        foreach ($models as $file => $object_name) {
            $this->load->model($file, $object_name);
        }
         $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','jquery-ui-1.10.4','highcharts','exporting','jquery.validate','grid.locale-en','jquery.jqGrid.min','jquery-ui-1.8.16.custom.min','autocomplete','multipleclone','jquery.datepick'));
        $this->load->helper('text');
    }



 
   function view_charges(){
      
      $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min','commonjs','jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
                $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
                $this->breadcrumbs->push('Charges', 'Charges/view_charges');
               
                // unshift crumb

                // output
       $data['breadcrumb']=$this->breadcrumbs->show();
         ///$data ="hiii";

        $this->amodel->pagerender($data,'view_charges');
    }




    function get_chargelist() {
        
        $model = array('Charges_model'=>'get_chargelist');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
        
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : ''; 
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $case_no=($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $check_name=($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $company_name=($_REQUEST['company_name']) ? $_REQUEST['company_name'] : '';
        $college_name=($_REQUEST['college_name']) ? $_REQUEST['college_name'] : '';
        $university_name=($_REQUEST['university_name']) ? $_REQUEST['university_name'] : '';
        $verifier_name=($_REQUEST['verifier_name']) ? $_REQUEST['verifier_name'] : '';
        $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : ''; 
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : ''; 
        $chk_status = ($_REQUEST['chk_status']) ? $_REQUEST['chk_status'] : ''; 
        
            if($org_id)
            $condition[]=" o.id = ".$org_id;
            if($office)
            $condition[]=" br.id = ".$office;
            if($parent_office)
            $condition[]=" p.id = ".$parent_office;
            if($sub_office)
            $condition[]=" su.id = ".$sub_office;       
            if($name)
            $condition[]="b.firstname like '%".$name."%' ";
            if($check_name)
            $condition[]="c.name like '%".$check_name."%' ";
            if($company_name)
            $condition[]="em.company_name like '%".$company_name."%'";    
            if($college_name)
            $condition[]="ed.collegename_add like '%".$college_name."%'";
            if($university_name)
            $condition[]="ed.affliated like '%".$university_name."%'"; 
            //17/01/2024
            $case_no = trim($case_no);     
            if($case_no)
            $condition[]="d.case_no like '%".$case_no."' ";
            if($verifier_name)
         $condition[]="(concat_ws(' ',us.first_name,us.last_name) like '%".$verifier_name."%') ";
            
            if(!empty($c_date)){
               $condition[]="DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
            }
            if(!empty($t_date)){
               $condition[]="DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
            }

            if($chk_status==1){
            $condition[]=" (vl1.vm_discrepency in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701)) ";
            }
            if($chk_status==2){
            $condition[]=" ((vl1.vm_discrepency in (120,131,137,143,713,119,130,136,142)) or (a.verify_status in (519,110))  or (vl1.vm_discrepency in (1005)))";
            }
            if($chk_status==3){
            $condition[]=" (vl1.vm_discrepency in (116,127,134,140,630,121,125,658,662,660,789)) ";
            }     
            
            
            

      if($term)
      {
      //support multiple words
      $search = explode(' ', $term);

      foreach($search as $t) {
      $not        = '';
      $operator    = 'OR';
      if(substr($t,0,1) == '-')
      {
      $not        = 'NOT ';
      $operator    = 'AND';
      //trim the - sign off
      $t        = substr($t,1,strlen($t));
       
      }

      $like    = '';
      $like    .= "( b.firstname ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." b.lastname ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." f.order_name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." vs.name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." d.candidate_name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." o.org_name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." p.office_name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." su.office_name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." br.office_name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." d.case_no ".$not."LIKE '%".$t."%' " ;
        
      $like    .= $operator." ed.collegename_add ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." ed.affliated ".$not."LIKE '%".$t."%' " ;

      $like    .= $operator." em.company_name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." pr.company_name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." vr.deadline_from ".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
      $like    .= $operator." vr.deadline_to ".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
       $like    .= $operator." vl1.reqstatus ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." c.name ".$not."LIKE '%".$t."%' " ;
     // $like    .= $operator." verify_status ".$not."LIKE '%".$t."%' " ;
      
      $like    .= $operator." a.vm_revert_status ".$not."LIKE '%".$t."%' ) " ;
        
      $condition[]=$like;
      }
      }
      $manual_cond=implode(' and ',$condition);
      $results = $this->_jqgrid_search($model,$manual_cond); 
      $response = $results[0];  
      $result = $results[1];
      if ($result) {
         $checkteam = $this->config->item('CHECKLIST',APPLICATIONCONFIG);
         $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
         $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
         $page=$page - 1;
         $count=$page * $rows;
         $k=1;

   foreach( $result as $i => $row ) {
       
      $company_details=$this->vm->get_verifiedcompany_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
      $education_details=$this->vm->get_verifiedcollege_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
      $professional_details=$this->vm->get_verifiedprofessional_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
 
      $verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);

      $verification_data=toArray(json_decode($verified_data['fielddata']));
      $vm_expenses=toArray(json_decode($verified_data['vmexpenses']));
      $qc2verification_data=toArray(json_decode($verified_data['qc2fielddata']));
       
   

      $status1=$this->vm->get_status($verification_data['status']);
      $status4='';
        $status2=$this->vm->get_status($verification_data['pstatus']);
        $status3=$this->vm->get_status($verification_data['status1']);
        if($verification_data['ostatus']<>'')
        $status4=$this->vm->get_status($verification_data['ostatus']);
        if($verification_data['dstatus']<>'')
        $status4=$this->vm->get_status($verification_data['dstatus']);
      if(!empty($status4))
        $status41='-'.$status4['name'];
        else
        $status41='';

     
      
     
         if($verification_data['status']!=107 && $verification_data['status']!=684 && $verification_data['status']!=992 && !empty($verification_data['status'])) {
            if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
               $rpt_status="<span style='color:red;'>RED</span>";
            }
            else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Partial Match"){
               $rpt_status="<span style='color:orange;'>ORANGE</span>";
            }
            else 
            {
               $rpt_status="<span style='color:green;'>GREEN</span>";
            }
         }
            
            $checkstatus = $this->vm->getstatus_of_can($row['candidate_req_id'],$row['checkId']);
            $checkadminstatus = $this->vm->get_currentstatus($row['candidate_req_id']);
            $verfier_details = anchor('/Verification/add_calls/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),'Call Details','target="_blank"');

            $procedure_details = anchor('/Verification/add_procedure/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),'Procedure Details','target="_blank"');
                             $candidatename=$row['candidatename'];
                if($row['vm_revert_option_status']==1 && $row['vm_revert_to']==2){
               $verifyurl = 'Revert Raised to DEO';
            }             
            else if($row['qc_revert_request']==1 ){
               if($row['vm_assigned_qc']==1 && $row['verify_status']<>107 && $row['verify_status']<>684 && $row['verify_status']<>992 ) {
                 
                  $verifyurl = 'Revert Rectified';
               }
               else if($row['vm_assigned_qc']==0 && $row['ass_request']==0 && $row['supplementary']==1 && $row['qc_revert_request']==1 && $row['reopen_revert_qc']==0 && $row['reopen_revert_qc2']==1 ){
               $verifyurl = 'Reopen Assigned';
               }

               else if($row['vm_assigned_qc']==0 && $row['ass_request']==0 && $row['supplementary']==1 && $row['qc_revert_request']==1 && $row['reopen_revert_qc']==1 && $row['reopen_revert_qc2']==1 ){
               $verifyurl = 'Reopen Assigned';
               }
               else{
                  
                     $verifyurl = 'Revert Assigned';
               
            }
            
            }
            
            elseif($row['verify_status']==111 && $row['vrequest']==0 && $row['ass_request']==0 )
            {
                                        $verifyurl = 'Verified';
                                        
                                       
                                       $candidatename= anchor('/Verification/vm_verified/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),$row['candidatename'],'target="_blank"');
                                        
            }
            else if($row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==3 && $row['vm_revert_to']==2)
            {
                                        $verifyurl = 'Verified';
                                       
                                       
                                       $candidatename= anchor('/Verification/vm_verified/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),$row['candidatename'],'target="_blank"');
                                        
            }

            else if($row['vm_revert_option_status']==3 && $row['vm_revert_to']==2){
               $verifyurl = anchor('/Verification/level_detailsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),'Revert Closed','target="_blank"');
            }
            
            else if($row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==4 && $row['operator_submited_by']==12 || $row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==4 && $checkadminstatus['role_id']==13)
            {
                                        $verifyurl = 'Verified';
                                        
                                       
                                       $candidatename= anchor('/Verification/vm_verified/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),$row['candidatename'],'target="_blank"');
                                        
            }

            else if($row['vm_revert_option_status']==4 && $row['operator_submited_by']==12 || $row['vm_revert_option_status']==4 && $checkadminstatus['role_id']==13){
               $verifyurl = 'Revert Closed';
            }
            
            else if($row['vm_revert_to']==3 && $row['vm_revert_supervisor']==0){
               $verifyurl = 'Revert Closed';
            }

            else if($row['verify_status']<>'111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0 )
            {
                                        if($row['rstatus']==108)
                                        $vst='Inputs Required';
                                        else if($row['rstatus']==110)
                                        $vst='Stop Check';
                                        else if($row['rstatus']==109)
                                        $vst='Awaiting Authorisation';
                                        else if($row['rstatus']==107)
                                        $vst='Initiated';
                                       else if($row['rstatus']==519)
                                        $vst='Others';
                                        else if($row['rstatus']==684)
                                        $vst='Request Raised';
                                        else if($row['rstatus']==992)
                                        $vst='DD applied';
            
                              if($row['rstatus']==110 || $row['rstatus']==519){
                                 $verifyurl = 'Verified';
                              }else{
                                  $verifyurl = $vst;
                              }
                                      
                                        
            }

            
            

            else if($row['verify_status']=='111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0)
            {
                                        if($row['rstatus']==108)
                                        $vst='Inputs Required';
                                        else if($row['rstatus']==110)
                                        $vst='Stop Check';
                                        else if($row['rstatus']==109)
                                        $vst='Awaiting Authorisation';
                                       else if($row['rstatus']==107 && $row['verify_status']=='111')
                                        $vst='Verified';
                                        else if($row['rstatus']==107)
                                        $vst='Initiated';
                              else 
                                        $vst='Verified';
            
                                        $verifyurl = $vst;
                                        
            }
            else if($row['ass_request']==1)
            {
            $verifyurl='Request Raised';
            
            }
            
            
            else
            {
                                        $save['request_id']=$row['candidate_req_id'];
                                        $save['check_id']=$row['checkId'];
                                        $save['level_id']=$row['level_id'];
                                        $this->db->select('count(*) as cnt');
                                        $this->db->where($save);
                                        $countnoti=$this->db->get(DB_PREFIX.'notification_emails')->row_array();

                                        if($countnoti['cnt'] >=1 )
                                        $vtext='Sent Mail to Resource';
                                        else
                                        $vtext='New';
            
            
            
            
                                        $verifyurl = $vtext;
                                        $vst=$row['status'];
                                        $requesttoass ='';
                                }
                                $slug=url_title(convert_accented_characters($row['checkname']), 'underscore', TRUE);


            if($row['checkid']==14)
            $levelnames=$this->vm->get_level_name($row['candidate_req_id'],$row['checkid'],$row['level_id'],'education_details');
            else if($row['checkid']==16)
            $levelnames=$this->vm->get_level_name($row['candidate_req_id'],$row['checkid'],$row['level_id'],'contact_details','request_id','permanent_address');
            else if($row['checkid']==59)
            $levelnames=$this->vm->get_level_name($row['candidate_req_id'],$row['checkid'],$row['level_id'],'employment','req_id','level_id');
            else if($row['checkid']==76 || $row['checkid']==77 || $row['checkid']==75)
            $levelnames=$this->vm->get_level_name($row['candidate_req_id'],$row['checkid'],$row['level_id'],$slug,'request_id','level_name');
            else
            $levelnames['level']=$row['checkname'];
            
            if($row['status']=='Initiated')
            $rowstatus='Assigned in VM';
            else
            $rowstatus=$row['status'];
         if($row['chk']==0){
            $chkval=$row['checkname'];
         }else{
            $chkval=$row['checkname'].$row['chk'];
         }
         if(!empty($status1['name'])){
            $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
         }else{
            $stat='';
         }
         if($row['checkid']==14){
         $clgname=$education_details['collegename_add'];
         $uniname=$education_details['affliated']; 
         }else{
            $clgname='';
            $uniname='';
         }
         
         
         if($row['checkid']==59){
            $cmpnyname=$company_details['company_name'];
         }else if($row['checkid']==68){
         $cmpnyname=$professional_details['company_name'];
         }else{
            $cmpnyname='';
         }
         
            
            
            $v_date=isset($row['v_date'])? date('d-m-Y',strtotime($row['v_date'])) : '';
            $req_raise_date=isset($row['vm_request_raised_date'])? date('d-m-Y',strtotime($row['vm_request_raised_date'])) : '';

             $dd_recived =    $verification_data['dd_recevied_form'];
                
               
                 if($dd_recived == 1){
                       $dd_status = 'University';
                 }
                 elseif($dd_recived == 2){
                       $dd_status = 'College';
                 }
                 elseif($dd_recived == 3){
                       $dd_status = 'Company';
                 }
                 elseif($dd_recived == 4){
                       $dd_status = 'University and College';
                 }
                 else
                 {
                   $dd_status = '';
                 }
                                                       
               $verification_from = $verification_data['verification_received'];
                
                
                
                
                 if($verification_from == 'College'){
                       $verify_from = 'College';
                 }
                 elseif($verification_from == 'University'){
                       $verify_from = 'University';
                 }
                 
                 else
                 {
                   $verify_from = '';
                 }

                 $veri_received = $verification_data['veri_received_dropdown'];
                 //$veri_received =   $qc2verification_data['veri_received_dropdown'];
                
                 if($veri_received == 1){
                  $verification_received  = "Recevied";
                 }
                 elseif($veri_received == 2)
                 {
                    $verification_received  = "Not received";
                 }
                 else
                 {
                  $veri_received_data = '';
                 }

                 
                 if($row['ticket_status']==1){
                  $tktStatus='Open';
                 }
                 else if($row['ticket_status']==2){
                  $tktStatus='Requested';
                 }
                 else if($row['ticket_status']==3){
                  $tktStatus='Revert';
                 }
                 else if($row['ticket_status']==4){
                  $tktStatus='Re-Requested';
                 }
                 else if($row['ticket_status']==5){
                  $tktStatus='Re-Open';
                 }
                 else if($row['ticket_status']==101){
                  $tktStatus='Closed';
                 }else{
                  $tktStatus='';
                 }

                $startDate=date('Y-m-d',strtotime($row['requested_date']));
              $endDate=date('Y-m-d');
              $workingDays = $this->number_of_working_days($startDate, $endDate);
                
                if(($row['ticket_status']==2 && $workingDays > 7) || ($row['ticket_status']==4 && $workingDays > 7) || ($row['ticket_status']==3 || $row['ticket_status']==101) && $row['rstatus']==684){
                  $tktStatus="<span style='background-color:yellow;'>".$tktStatus."</span>";
                }
                else if(($row['ticket_status']==2 && $workingDays > 7) || ($row['ticket_status']==4 && $workingDays > 7) || ($row['ticket_status']==3 || $row['ticket_status']==101) && ($row['qc_revert_request']==1 && $row['verify_status']==684) ){
                  $tktStatus="<span style='background-color:yellow;'>".$tktStatus."</span>";
                }
                else if($row['rstatus'] !=684){
                  $tktStatus='';
                }else if($row['qc_revert_request'] !=1 && $row['verify_status'] !=684){
                  $tktStatus='';
                }
                else{
                  $tktStatus=$tktStatus;
                }
            
      //....Payment and charges......//
      
     if($vm_expenses<>null){
        // initialise the array
        $d_amount         = array();
        $reference_no     = array();
        $reference_number = array();
        $payment_date     = array();
        $pay_date         = array();
        $payment_dates    = array();


        //amount and reference and payment dates
                    foreach($vm_expenses as $key => $dd_exprenses) {
                                $d_amount[]=$dd_exprenses['amount'];
                                 $reference_no[]=$dd_exprenses['reference'];    
                        }
                       
                    $dd_am=implode('<br>',$d_amount);
                    $dd_amount="<span style='padding:2px'>".$dd_am."</span>";
                    $reference_number = implode('<br>',$reference_no);
                    $reference  ="<span style='padding:2px'>".$reference_number."</span>";
          
                    foreach($vm_expenses as $key => $payment) {
                        if($payment['payment_date']!= '')   
                            $payment_date[] = date("d-m-Y",strtotime($payment['payment_date']));   
                        else
                            $payment_date[]='';

                            
                    }
                    if(!empty($payment_date)){
                          $pay_d = implode('<br>',$payment_date); 

                           if($pay_d == '01-01-1970'){
                            $pay_date = "";
                          }
                      
                   
                    }  
                    $pay_date="<span style='padding:2px'>".$pay_d."</span>";
       
    }

    else{
         $dd_amount = '';
         $reference = '';
      }
   //payment to   
    if($vm_expenses<>null){
        $payment_to = array();
        $pay_status = array();

                   foreach($vm_expenses as $key => $pay_to) {
                        $payment_to[]=$pay_to['payment_to'];   
                            
                   }
                 
                    $payment =array();
                    $paymentto =array();  
                    $payment_status= array();    
                    

                    foreach($payment_to as  $paymentto ){
                             
                             if($paymentto ==1){
                                   $pay_status[]= 'University';
                             }
                             elseif($paymentto ==2){
                                   $pay_status[]= 'College';
                             }
                             elseif($paymentto ==3){
                                   $pay_status[]= 'Company'; 
                             }
                             elseif($paymentto ==4){
                                   $pay_status[]= 'University and College';
                             }
                           
                             else
                             {
                               $pay_status[]= '';

                             } 
                 
                     }
            
  
        }

         else{
            $pay_status[]= '';
        }

    $payment_status1 = implode('<br>',$pay_status);  
    $payment_status = "<span style='padding:2px'>".$payment_status1."</span>"; 

//expences
    if($vm_expenses<>null){
        $paymode = array();

                foreach($vm_expenses as $val){
                    $expen= $this->vm->expensedetails($val['expences']);
                    $paymode[] = $expen['name'];
                   
                }
            $payment_m = implode('<br>',$paymode);
            $payment_mode= "<span style='padding:2px'>".$payment_m ."</span>";
    }

   else{
      $payment_mode ='';
   } 

//currency 
if($vm_expenses<>null){

        $currency_id = array();
        $countvalue= count($vm_expenses);
            
                foreach($vm_expenses as $key => $vm_curency_id) {
                  $currency_id[]=$vm_curency_id['ddcurrency']; 
                }     
            
            $c_id =array();
            $currencyname= array();
            $currency_name=array();
                
                foreach($currency_id as $key=> $c_id){
                $currency_name[] = $this->amodel->getDetails(DB_PREFIX ."master_masterdata", array('id', 'name'), array('key' => 'currencykey', 'id' => $c_id));
   
                }
 
            $currency=array();
                
             for($j=0;$j<$countvalue;$j++){
                    $currencyname[] = $currency_name[$j][0]['name'];
             }
                  if(!empty($currencyname)) 
                    $curr=implode('<br>',$currencyname);
                 else{
                      $curr = '';
                 }
                $currency= "<span style='padding:2px'>".$curr."</span>";  
                 }
    
else{
    $currency = '';
 } 


     // End Payment and charges           



    // Rti ref.number and rti dates

            $rti_reference_no =$verification_data['rti_reference_no'];
            $rti_reference_date=$verification_data['rti_reference_date'];
                
            $v_date=isset($row['v_date'])?date('d-m-Y',strtotime($row['v_date'])):''; 
            $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['checkId']),$candidatename),$row['case_no'],$chkval,$verifyurl,$tktStatus,$stat,$rpt_status,$cmpnyname,$clgname,$uniname,$verification_received,$verify_from,$dd_status,$currency,$dd_amount,$payment_mode,$reference,$pay_date,$payment_status,$rti_reference_no,$rti_reference_date,$v_date,$row['vname']);
            
               
                  
              } 
              
             echo json_encode($response);

        
        }
       
    }


// EXPORT TO XLS FOR CHARGES AND PAYMENT 


function export_Charges(){
         
        $model = array('Charges_model'=>'export_chargesmodel');
        $office = ($_POST['exp_office_id']) ? $_POST['exp_office_id'] : '';
        $name = ($_POST['exp_name']) ? $_POST['exp_name'] : ''; 
        $a_status = ($_POST['exp_a_status']) ? $_POST['exp_a_status'] : '';
        
        $org_id = ($_POST['exp_parentoffice_id']) ? $_POST['exp_parentoffice_id'] : '';
        $parent_office = ($_POST['exp_parent_office']) ? $_POST['exp_parent_office'] : '';
        $sub_office = ($_POST['exp_sub_office']) ? $_POST['exp_sub_office'] : ''; 
        $term=($_POST['exp_search_term']) ? $_POST['exp_search_term'] : '';
        $case_no=($_POST['exp_case_no']) ? $_POST['exp_case_no'] : '';
        $check_name=($_POST['exp_check_name']) ? $_POST['exp_check_name'] : '';
        $company_name=($_POST['exp_company_name']) ? $_POST['exp_company_name'] : '';
        $college_name=($_POST['exp_college_name']) ? $_POST['exp_college_name'] : '';
        $university_name=($_POST['exp_university_name']) ? $_POST['exp_university_name'] : '';
        $verifier_name=($_POST['exp_verifier_name']) ? $_POST['exp_verifier_name'] : '';
        $c_date = ($_POST['exp_c_date']) ? $_POST['exp_c_date'] : '';
        $t_date = ($_POST['exp_t_date']) ? $_POST['exp_t_date'] : ''; 
        $request_status = ($_POST['exp_request_status']) ? $_POST['exp_request_status'] : ''; 
        $chk_status = ($_POST['exp_chk_status']) ? $_POST['exp_chk_status'] : ''; 
       
        
        $check_count = ($_POST['exp_check_count']) ? $_POST['exp_check_count'] : '';
        
        $ticket_status=($_POST['exp_ticket_status']) ? $_POST['exp_ticket_status'] : '';
        
        $verified_status  = ($_REQUEST['exp_verified_status']) ? $_REQUEST['exp_verified_status'] : '';
        
        $userId  = ($_POST['exp_userId']) ? $_POST['exp_userId'] : ''; 

         if(!empty($ticket_status)){
            $condition[]=" td.ticket_status =".$ticket_status ;


        }
      if($org_id)
      $condition[]=" o.id = ".$org_id;
      if($office)
      $condition[]=" br.id = ".$office;
      if($parent_office)
      $condition[]=" p.id = ".$parent_office;
      if($sub_office)
      $condition[]=" su.id = ".$sub_office;       
      if($name)
      $condition[]="b.firstname like '%".$name."%' ";
      if($check_name)
      $condition[]="c.name like '%".$check_name."%' ";
      if($company_name)
      $condition[]="em.company_name like '%".$company_name."%'";    
      if($college_name)
      $condition[]="ed.collegename_add like '%".$college_name."%'";
      if($university_name)
      $condition[]="ed.affliated like '%".$university_name."%'";      

      //17/01/2024
      $case_no = trim($case_no);
      if($case_no)
      $condition[]="d.case_no like '%".$case_no."' ";
      
     
      if($c_date){
         $condition[]="DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
      }
      if($t_date){
         $condition[]="DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
      }

   

      if($term)
      {
      //support multiple words
      $search = explode(' ', $term);

      foreach($search as $t) {
      $not        = '';
      $operator    = 'OR';
      if(substr($t,0,1) == '-')
      {
      $not        = 'NOT ';
      $operator    = 'AND';
      //trim the - sign off
      $t        = substr($t,1,strlen($t));
       
      }

      $like    = '';
      $like    .= "( b.firstname ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." b.lastname ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." f.order_name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." vs.name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." d.candidate_name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." o.org_name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." p.office_name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." su.office_name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." br.office_name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." d.case_no ".$not."LIKE '%".$t."%' " ;
        
      $like    .= $operator." ed.collegename_add ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." ed.affliated ".$not."LIKE '%".$t."%' " ;

      $like    .= $operator." em.company_name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." pr.company_name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." vr.deadline_from ".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
      $like    .= $operator." vr.deadline_to ".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
       $like    .= $operator." vl1.reqstatus ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." c.name ".$not."LIKE '%".$t."%' " ;
      $like    .= $operator." verify_status ".$not."LIKE '%".$t."%' " ;
      
      $like    .= $operator." a.vm_revert_status ".$not."LIKE '%".$t."%' ) " ;
        
      $condition[]=$like;
      }
      }
      $manual_cond=implode(' and ',$condition);
      $results = $this->_jqgrid_search($model,$manual_cond); 
      $response = $results[0];  
      $result = $results[1]; 
      if ($result) {
        $checkteam = $this->config->item('CHECKLIST',APPLICATIONCONFIG);
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows;
        $k=1;
       $objPHPExcel = new PHPExcel();
       $objPHPExcel->setActiveSheetIndex(0);
       $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
       $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
       $objPHPExcel->getActiveSheet()->setCellValue('C1', "Head Office");
       $objPHPExcel->getActiveSheet()->setCellValue('D1', "Branch Office");
       $objPHPExcel->getActiveSheet()->setCellValue('E1', "Sub Office");
       $objPHPExcel->getActiveSheet()->setCellValue('F1', "Name");
       $objPHPExcel->getActiveSheet()->setCellValue('G1', "Case Number");
       $objPHPExcel->getActiveSheet()->setCellValue('H1', "Check Name");
       $objPHPExcel->getActiveSheet()->setCellValue('I1', "Status");
       $objPHPExcel->getActiveSheet()->setCellValue('J1', "Ticket Status");
       $objPHPExcel->getActiveSheet()->setCellValue('K1', "Verified Status");
       $objPHPExcel->getActiveSheet()->setCellValue('L1', "Check Status");
       $objPHPExcel->getActiveSheet()->setCellValue('M1', "Company Name");
       $objPHPExcel->getActiveSheet()->setCellValue('N1', "College Name");
       $objPHPExcel->getActiveSheet()->setCellValue('O1', "University Name");
       $objPHPExcel->getActiveSheet()->setCellValue('P1', "Verification Received / Not");
       $objPHPExcel->getActiveSheet()->setCellValue('Q1', "Verification Recevied Form");
       $objPHPExcel->getActiveSheet()->setCellValue('R1', "Amount Paid To");
       $objPHPExcel->getActiveSheet()->setCellValue('S1', "Currency");    
       $objPHPExcel->getActiveSheet()->setCellValue('T1', "Amount");
       $objPHPExcel->getActiveSheet()->setCellValue('U1', "Payment Mode");
       $objPHPExcel->getActiveSheet()->setCellValue('V1', "Payment Reference Number");
       $objPHPExcel->getActiveSheet()->setCellValue('W1', "Payment Date");
       $objPHPExcel->getActiveSheet()->setCellValue('X1', "Pament To");
       $objPHPExcel->getActiveSheet()->setCellValue('Y1', "RTI Reference Number");
       $objPHPExcel->getActiveSheet()->setCellValue('Z1', "RTI Reference Date");
       $objPHPExcel->getActiveSheet()->setCellValue('AA1', "VM Completed Date");
       $objPHPExcel->getActiveSheet()->setCellValue('AB1', "Verifier Name");
           
            $ci=2;    
        foreach( $result as $i => $row ) {
      $company_details=$this->vm->get_verifiedcompany_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
      $education_details=$this->vm->get_verifiedcollege_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
      $professional_details=$this->vm->get_verifiedprofessional_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);

      $verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);

      $verification_data=toArray(json_decode($verified_data['fielddata']));
      $vm_expenses=toArray(json_decode($verified_data['vmexpenses']));
      $qc2verification_data=toArray(json_decode($verified_data['qc2fielddata']));          
      

      $status1=$this->vm->get_status($verification_data['status']);
      $status4='';
        $status2=$this->vm->get_status($verification_data['pstatus']);
        $status3=$this->vm->get_status($verification_data['status1']);
        if($verification_data['ostatus']<>'')
        $status4=$this->vm->get_status($verification_data['ostatus']);
        if($verification_data['dstatus']<>'')
        $status4=$this->vm->get_status($verification_data['dstatus']);
      if(!empty($status4))
        $status41='-'.$status4['name'];
        else
        $status41='';

     
      
     
         if($verification_data['status']!=107 && $verification_data['status']!=684 && $verification_data['status']!=992 && !empty($verification_data['status'])) {
            if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
               $rpt_status="RED";
            }
            else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Partial Match"){
               $rpt_status="ORANGE";
            }
            else 
            {
               $rpt_status="GREEN";
            }
         }
            
            $checkstatus = $this->vm->getstatus_of_can($row['candidate_req_id'],$row['checkId']);
            $checkadminstatus = $this->vm->get_currentstatus($row['candidate_req_id']);
            $verfier_details ='Call Details';

            $procedure_details = 'Procedure Details';
                             $candidatename=$row['candidatename'];
                if($row['vm_revert_option_status']==1 && $row['vm_revert_to']==2){
               $verifyurl = 'Revert Raised to DEO';
            }             
            else if($row['qc_revert_request']==1 ){
               if($row['vm_assigned_qc']==1 && $row['verify_status']<>107 && $row['verify_status']<>684 && $row['verify_status']<>992 ) {
                 
                  $verifyurl = 'Revert Rectified';
               }
               else if($row['vm_assigned_qc']==0 && $row['ass_request']==0 && $row['supplementary']==1 && $row['qc_revert_request']==1 && $row['reopen_revert_qc']==0 && $row['reopen_revert_qc2']==1 ){
               $verifyurl = 'Reopen Assigned';
               }

               else if($row['vm_assigned_qc']==0 && $row['ass_request']==0 && $row['supplementary']==1 && $row['qc_revert_request']==1 && $row['reopen_revert_qc']==1 && $row['reopen_revert_qc2']==1 ){
               $verifyurl = 'Reopen Assigned';
               }
               else{
                  
                     $verifyurl = 'Revert Assigned';
               
            }
            
            }
            
            elseif($row['verify_status']==111 && $row['vrequest']==0 && $row['ass_request']==0 )
            {
                                        $verifyurl = 'Verified';
                                        
                                       
                                       
                                        
            }
            else if($row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==3 && $row['vm_revert_to']==2)
            {
                                        $verifyurl = 'Verified';
                                        
                                       
                                       
                                        
            }

            else if($row['vm_revert_option_status']==3 && $row['vm_revert_to']==2){
               $verifyurl = 'Revert Closed';
            }
            
            else if($row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==4 && $row['operator_submited_by']==12 || $row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==4 && $checkadminstatus['role_id']==13)
            {
                                        $verifyurl = 'Verified';
                                        
                                       
                                       
                                        
            }

            else if($row['vm_revert_option_status']==4 && $row['operator_submited_by']==12 || $row['vm_revert_option_status']==4 && $checkadminstatus['role_id']==13){
               $verifyurl = 'Revert Closed';
            }
            
                                       
                                        
            
            else if($row['vm_revert_to']==3 && $row['vm_revert_supervisor']==0){
               $verifyurl = 'Revert Closed';
            }

            else if($row['verify_status']<>'111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0 )
            {
                                        if($row['rstatus']==108)
                                        $vst='Inputs Required';
                                        else if($row['rstatus']==110)
                                        $vst='Stop Check';
                                        else if($row['rstatus']==109)
                                        $vst='Awaiting Authorisation';
                                        else if($row['rstatus']==107)
                                        $vst='Initiated';
                                       else if($row['rstatus']==519)
                                        $vst='Others';
                                        else if($row['rstatus']==684)
                                        $vst='Request Raised';
                                        else if($row['rstatus']==992)
                                        $vst='DD applied';
            
                              if($row['rstatus']==110 || $row['rstatus']==519){
                                 $verifyurl = 'Verified';
                              }else{
                                  $verifyurl = $vst;
                              }
                                      
                                        
            }

            
            

            else if($row['verify_status']=='111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0)
            {
                                        if($row['rstatus']==108)
                                        $vst='Inputs Required';
                                        else if($row['rstatus']==110)
                                        $vst='Stop Check';
                                        else if($row['rstatus']==109)
                                        $vst='Awaiting Authorisation';
                                       else if($row['rstatus']==107 && $row['verify_status']=='111')
                                        $vst='Verified';
                                        else if($row['rstatus']==107)
                                        $vst='Initiated';
                              else 
                                        $vst='Verified';
            
                                        $verifyurl = $vst;
                                        
            }
            else if($row['ass_request']==1)
            {
            $verifyurl='Request Raised';
            
            }
            
            
            else
            {
                                        $save['request_id']=$row['candidate_req_id'];
                                        $save['check_id']=$row['checkId'];
                                        $save['level_id']=$row['level_id'];
                                        $this->db->select('count(*) as cnt');
                                        $this->db->where($save);
                                        $countnoti=$this->db->get(DB_PREFIX.'notification_emails')->row_array();

                                        if($countnoti['cnt'] >=1 )
                                        $vtext='Sent Mail to Resource';
                                        else
                                        $vtext='New';
                                        $verifyurl = $vtext;
                                        $vst=$row['status'];
                                        $requesttoass ='';
                                }
                                $slug=url_title(convert_accented_characters($row['checkname']), 'underscore', TRUE);


            if($row['checkid']==14)
            $levelnames=$this->vm->get_level_name($row['candidate_req_id'],$row['checkid'],$row['level_id'],'education_details');
            else if($row['checkid']==16)
            $levelnames=$this->vm->get_level_name($row['candidate_req_id'],$row['checkid'],$row['level_id'],'contact_details','request_id','permanent_address');
            else if($row['checkid']==59)
            $levelnames=$this->vm->get_level_name($row['candidate_req_id'],$row['checkid'],$row['level_id'],'employment','req_id','level_id');
            else if($row['checkid']==76 || $row['checkid']==77 || $row['checkid']==75)
            $levelnames=$this->vm->get_level_name($row['candidate_req_id'],$row['checkid'],$row['level_id'],$slug,'request_id','level_name');
            else
            $levelnames['level']=$row['checkname'];
            
            if($row['status']=='Initiated')
            $rowstatus='Assigned in VM';
            else
            $rowstatus=$row['status'];
         if($row['chk']==0){
            $chkvals=$row['checkname'];
         }else{
            $chkvals=$row['checkname'].$row['chk'];
         }
         if(!empty($status1['name'])){
            $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
         }else{
            $stat='';
         }
         if($row['checkid']==14){
         $clgnames=$education_details['collegename_add'];
         $uniname=$education_details['affliated']; 
         }else{
            $clgnames='';
            $uniname='';
         }
         
         
         if($row['checkid']==59){
            $cmpnyname=$company_details['company_name'];
         }else if($row['checkid']==68){
         $cmpnyname=$professional_details['company_name'];
         }else{
            $cmpnyname='';
         }
         
            $deadline_from=isset($row['deadline_from'])? date('d-m-Y',strtotime($row['deadline_from'])) : '';
            $deadline_to=isset($row['deadline_to'])? date('d-m-Y',strtotime($row['deadline_to'])) : '';
            
            $v_date=isset($row['v_date'])? date('d-m-Y',strtotime($row['v_date'])) : '';
            $req_raise_date=isset($row['vm_request_raised_date'])? date('d-m-Y',strtotime($row['vm_request_raised_date'])) : '';

             $dd_recived =    $verification_data['dd_recevied_form'];
                //09/06/2023
                if($dd_recived == 1){
                       $dd_status = 'University';
                 }
                 elseif($dd_recived == 2){
                       $dd_status = 'College';
                 }
                 elseif($dd_recived == 3){
                       $dd_status = 'Company';
                 }
                 elseif($dd_recived == 4){
                       $dd_status = 'University and College';
                 }
                 else
                 {
                   $dd_status = '';
                 }
                                                       
               $verification_from = $verification_data['verification_received'];

                
                 if($verification_from == 'College'){
                       $verify_from = 'College';
                 }
                 elseif($verification_from == 'University'){
                       $verify_from = 'University';
                 }
                 
                 else
                 {
                   $verify_from = '';
                 }

                 $veri_received = $verification_data['veri_received_dropdown'];
                 
                
                 if($veri_received == 1){
                  $verification_received  = "Recevied";
                 }
                 elseif($veri_received == 2)
                 {
                    $verification_received  = "Not received";
                 }
                 else
                 {
                  $veri_received_data = '';
                 }

                 
                 if($row['ticket_status']==1){
                  $tktStatus='Open';
                 }
                 else if($row['ticket_status']==2){
                  $tktStatus='Requested';
                 }
                 else if($row['ticket_status']==3){
                  $tktStatus='Revert';
                 }
                 else if($row['ticket_status']==4){
                  $tktStatus='Re-Requested';
                 }
                 else if($row['ticket_status']==5){
                  $tktStatus='Re-Open';
                 }
                 else if($row['ticket_status']==101){
                  $tktStatus='Closed';
                 }else{
                  $tktStatus='';
                 }

                $startDate=date('Y-m-d',strtotime($row['requested_date']));
              $endDate=date('Y-m-d');
              $workingDays = $this->number_of_working_days($startDate, $endDate);
                
                if(($row['ticket_status']==2 && $workingDays > 7) || ($row['ticket_status']==4 && $workingDays > 7) || ($row['ticket_status']==3 || $row['ticket_status']==101) && $row['rstatus']==684){
                  $tktStatus=$tktStatus;
                }
                else if(($row['ticket_status']==2 && $workingDays > 7) || ($row['ticket_status']==4 && $workingDays > 7) || ($row['ticket_status']==3 || $row['ticket_status']==101) && ($row['qc_revert_request']==1 && $row['verify_status']==684) ){
                  $tktStatus=$tktStatus;
                }
                else if($row['rstatus'] !=684){
                  $tktStatus='';
                }else if($row['qc_revert_request'] !=1 && $row['verify_status'] !=684){
                  $tktStatus='';
                }
                else{
                  $tktStatus=$tktStatus;
                }



                //....Payment and charges......//
         $reference_no = array();
     if($vm_expenses<>null){
        $d_amount         = array();
        $payment_date     = array();
        $pay_date         = array();
        $payment_dates    = array();


        //amount ,referencenumber and payment dates
                    foreach($vm_expenses as $key => $dd_exprenses) {
                                $d_amount[]=$dd_exprenses['amount'];
                                 $reference_no[]=$dd_exprenses['reference'];    
                        }
                       
                    $dd_am=implode(',',$d_amount);
                    $dd_amount=$dd_am;
                    $reference_number = implode(',',$reference_no);
                   $reference  =$reference_number;
          
                    foreach($vm_expenses as $key => $payment) {
                        if($payment['payment_date']!= '')   
                            $payment_date[] = date("d-m-Y",strtotime($payment['payment_date']));   
                        else
                            $payment_date[]='';

                            
                    }
                    if(!empty($payment_date)){
                          $pay_d = implode(',',$payment_date); 

                           if($pay_d == '01-01-1970'){
                            $pay_date = "";
                          }
                      
                   
                    }  
                    $pay_date=$pay_d;
       
    }

    else{
         $dd_amount = '';
         $reference = '';
      }
   //payment to   
    if($vm_expenses<>null){
        $payment_to = array();
        $pay_status = array();

                   foreach($vm_expenses as $key => $pay_to) {
                        $payment_to[]=$pay_to['payment_to'];   
                            
                   }
                 
                    $payment =array();
                    $paymentto =array();  
                    $payment_status= array();    
                    

                    foreach($payment_to as  $paymentto ){
                             
                             if($paymentto ==1){
                                   $pay_status[]= 'University';
                             }
                             elseif($paymentto ==2){
                                   $pay_status[]= 'College';
                             }
                             elseif($paymentto ==3){
                                   $pay_status[]= 'Company'; 
                             }
                             elseif($paymentto ==4){
                                   $pay_status[]= 'University and College';
                             }
                           
                             else
                             {
                               $pay_status[]= '';

                             } 
                 
                     }
            
  
        }

         else{
            $pay_status[]= '';
        }

    $payment_status1 = implode(',',$pay_status);  
    $payment_status = $payment_status1; 

//expences
    if($vm_expenses<>null){
        $paymode = array();

                foreach($vm_expenses as $val){
                    $expen= $this->vm->expensedetails($val['expences']);
                    $paymode[] = $expen['name'];
                   
                }
            $payment_m = implode(',',$paymode);
            $payment_mode= $payment_m;
    }

   else{
      $payment_mode ='';
   } 

//currency 
if($vm_expenses<>null){

        $currency_id = array();
        $countvalue= count($vm_expenses);
            
                foreach($vm_expenses as $key => $vm_curency_id) {
                  $currency_id[]=$vm_curency_id['ddcurrency']; 
                }     
            
            $c_id =array();
            $currencyname= array();
            $currency_name=array();
                
                foreach($currency_id as $key=> $c_id){
                $currency_name[] = $this->amodel->getDetails(DB_PREFIX ."master_masterdata", array('id', 'name'), array('key' => 'currencykey', 'id' => $c_id));
   
                }
 
            $currency=array();
                
             for($j=0;$j<$countvalue;$j++){
                    $currencyname[] = $currency_name[$j][0]['name'];
             }
                  if(!empty($currencyname)) 
                    $curr=implode(',',$currencyname);
                 else{
                      $curr = '';
                 }
                $currency= $curr;  
                 }
    
else{
    $currency = '';
 } 

    

     // End Payment and charges           



    // Rti ref.number and rti dates    
            
            $rti_reference_no =$verification_data['rti_reference_no'];
            $rti_reference_date=$verification_data['rti_reference_date'];
                
          
    $objPHPExcel->getActiveSheet()->getStyle('A1:AD1')->getFont()->setBold(true);
    $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                                  ->setCellValue('B' . $ci, $row['org_name'])
                                  ->setCellValue('C' . $ci, $row['parent_office'])
                                  ->setCellValue('D' . $ci, $row['office_name'])
                                  ->setCellValue('E' . $ci, $row['sub_office'])
                                  ->setCellValue('F' . $ci, $row['candidatename'])
                                  ->setCellValue('G' . $ci, $row['case_no'])
                                  ->setCellValue('H' . $ci, $chkvals)
                                  ->setCellValue('I' . $ci, $verifyurl)
                                  ->setCellValue('J' . $ci, $tktStatus)
                                  ->setCellValue('K' . $ci, $stat)
                                  ->setCellValue('L' . $ci, $rpt_status)
                                  ->setCellValue('M' . $ci, $cmpnyname)
                                  ->setCellValue('N' . $ci, $clgnames)
                                  ->setCellValue('O' . $ci, $uniname)
                                  ->setCellValue('P' . $ci, $verification_received)
                                  ->setCellValue('Q' . $ci, $verify_from)
                                  ->setCellValue('R' . $ci, $dd_status)
                                  ->setCellValue('S' . $ci, $currency)
                                  ->setCellValue('T' . $ci, $dd_amount)
                                  ->setCellValue('U' . $ci, $payment_mode)
                                  ->setCellValue('V' . $ci, $reference)
                                  ->setCellValue('W' . $ci, $pay_date)
                                  ->setCellValue('X' . $ci, $payment_status)
                                  ->setCellValue('Y' . $ci, $rti_reference_no)
                                  ->setCellValue('Z' . $ci, $rti_reference_date)
                                  ->setCellValue('AA' . $ci, $v_date)
                                  ->setCellValue('AB' . $ci, $row['vname']);
                                
    $ci++;
    }
    $this->export_excel('A','AD','Charges_And_Payment_List_',$objPHPExcel);
      exit; 
           }


 }

   /** From here 16th OCt **/
   function final_supplementary_charges()
   {
      $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
      $this->breadcrumbs->push('Reimbursement Charges', 'Charges/final_supplementary_charges');
      $data['breadcrumb']=$this->breadcrumbs->show();
      $data['organization'] = $organization=$this->amodel->getDetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('id !=' => 1,'org_status'=>1),  "org_name"); // Dec 15th 2023  

      $this->amodel->pagerender($data,'final_supplementary_charges');

   }


   function get_reimbursementlist()
   {
      $model = array('Charges_model'=>'get_reimbursementlist_model');  
      $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
      $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
      $date_filter = ($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
      $org_id =($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';  // Dec 15th
      $case_number =($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';  // Nov 30th
      $cmp_name = ($_REQUEST['cmp_name']) ? $_REQUEST['cmp_name'] : '';  // Jan 22nd 2024
      $coll_name = ($_REQUEST['coll_name']) ? $_REQUEST['coll_name'] : '';  // Jan 22nd 2024
      $univ_name = ($_REQUEST['univ_name']) ? $_REQUEST['univ_name'] : ''; ; // Jan 22nd 2024

      // If case number(s) filter is used instead of date filter // Nov 30th
      if(!empty($case_number))
      {
         $case_number = trim($case_number);
         $case_no = explode(',',$case_number);
         //print_r($case_no); 
         $arraycase_no = ''; 
          
         // convert PR101-316,PO80-482,PO61-193,PO205-532 into 'PR101-316','PO80-482','PO61-193','PO205-532' 
         for($i=0; $i < count($case_no);$i++)
         {
            if($i == (count($case_no)-1))
               $arraycase_no  .= "'" . $case_no[$i] . "'";
            else
               $arraycase_no .= "'" . $case_no[$i] . "',";

         }
         $condition[]="d.case_no IN (".$arraycase_no.")";
      } // Nov 30th
   
      // If date radio button is clicked/ selected and organization is selected.  // Dec 15th
      if(!empty($org_id))
      {
         $condition[]=" d.organisation = ".$org_id;
      } // Dec 15th

      // FINAL REPORT PUBLISHED DATE
      if(!empty($date_filter) && $date_filter == 2)
      {
         if(!empty($c_date)){
            $condition[]="DATE_FORMAT(d.final_report_published_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
         }
         if(!empty($t_date)){
            $condition[]="DATE_FORMAT(d.final_report_published_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
         }
         $condition[]="DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= DATE_FORMAT(d.final_report_published_date ,'%Y-%m-%d')";

      }

      // SUPPLEMENTARY PUBLISHED DATE
      if(!empty($date_filter) && $date_filter == 7)
      {
         if(!empty($c_date)){
            $condition[]="DATE_FORMAT(d.supplement_report_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
         }
         if(!empty($t_date)){
            $condition[]="DATE_FORMAT(d.supplement_report_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
         }
         // Dec 4th
         $condition[] = " (CASE WHEN (d.final_report_published_date IS NOT NULL) THEN 
                         DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') > DATE_FORMAT(d.final_report_published_date ,'%Y-%m-%d') AND DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= DATE_FORMAT(d.supplement_report_date ,'%Y-%m-%d') ELSE 
                        DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= DATE_FORMAT(d.supplement_report_date ,'%Y-%m-%d')
                           END )";
         // Dec 4th
         // $condition[]="DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') > DATE_FORMAT(d.final_report_published_date ,'%Y-%m-%d')";
         // $condition[]="DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= DATE_FORMAT(d.supplement_report_date ,'%Y-%m-%d')";
      }

      /** Jan 22nd 2024 **/
      if(!empty($date_filter))
      {
         if(!empty($cmp_name)){
            $condition[] = " em.company_name like '" . $cmp_name . "%'";
         }

         if(!empty($coll_name)){
            $condition[] = " ed.collegename_add  like '" . $coll_name . "%'";
         }

         if(!empty($univ_name)){
            $condition[] = " ed.affliated  like '" . $univ_name . "%'";
         }
      }
      /** Jan 22nd

       2024 **/

      $manual_cond=implode(' and ',$condition);
      $results = $this->_jqgrid_search($model,$manual_cond); 
      $response = $results[0];  
      $result = $results[1];
      if ($result) {
         $checkteam = $this->config->item('CHECKLIST',APPLICATIONCONFIG);
         $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
         $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
         $page=$page - 1;
         $count=$page * $rows;
         $k=1;

         foreach( $result as $i => $row ) {
       
            $company_details=$this->vm->get_verifiedcompany_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
            $education_details=$this->vm->get_verifiedcollege_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
            $professional_details=$this->vm->get_verifiedprofessional_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
       
            $verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);

            $verification_data=toArray(json_decode($verified_data['fielddata']));
            $vm_expenses=toArray(json_decode($verified_data['vmexpenses']));
            $qc2verification_data=toArray(json_decode($verified_data['qc2fielddata']));
        
            $status1=$this->vm->get_status($qc2verification_data['status']);
            $status4='';
            $status2=$this->vm->get_status($qc2verification_data['pstatus']);
            $status3=$this->vm->get_status($qc2verification_data['status1']);
            if($verification_data['ostatus']<>'')
               $status4=$this->vm->get_status($qc2verification_data['ostatus']);
            if($verification_data['dstatus']<>'')
               $status4=$this->vm->get_status($qc2verification_data['dstatus']);
            if(!empty($status4))
               $status41='-'.$status4['name'];
            else
               $status41='';

     
            if($verification_data['status']!=107 && $verification_data['status']!=684 && $verification_data['status']!=992 && !empty($verification_data['status'])) {
                  if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                     $rpt_status="<span style='color:red;'>RED</span>";
                  }
                  else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Partial Match"){
                     $rpt_status="<span style='color:orange;'>ORANGE</span>";
                  }
                  else 
                  {
                     $rpt_status="<span style='color:green;'>GREEN</span>";
                  }
            }
            
            

            if($row['chk']==0){
               $chkval=$row['checkname'];
            }else{
               $chkval=$row['checkname'].$row['chk'];
            }
            if(!empty($status1['name'])){
               $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
            }else{
               $stat='';
            }
            if($row['checkid']==14){
               $clgname=$education_details['collegename_add'];
               $uniname=$education_details['affliated']; 
            }else{
               $clgname='';
               $uniname='';
            }
            
         
            if($row['checkid']==59){
               $cmpnyname=$company_details['company_name'];
            }else if($row['checkid']==68){
               $cmpnyname=$professional_details['company_name'];
            }else{
               $cmpnyname='';
            }
         
            $v_date=isset($row['v_date'])? date('d-m-Y',strtotime($row['v_date'])) : '';
             $final_report_published_date = isset($row['final_report_published_date'])? date('d-m-Y',strtotime($row['final_report_published_date'])) : '';
            $supplement_report_date = isset($row['supplement_report_date'])? date('d-m-Y',strtotime($row['supplement_report_date'])) : '';

            $req_raise_date=isset($row['vm_request_raised_date'])? date('d-m-Y',strtotime($row['vm_request_raised_date'])) : '';

            $dd_recived =    $verification_data['dd_recevied_form'];
                   
               
            if($dd_recived == 1){
              $dd_status = 'University';
            }
            elseif($dd_recived == 2){
              $dd_status = 'College';
            }
            elseif($dd_recived == 3){
               $dd_status = 'Company';
            }
            elseif($dd_recived == 4){
               $dd_status = 'University and College';
            }
            else
            {
               $dd_status = '';
            }
                                              
            $verification_from = $verification_data['verification_received'];
                
            if($verification_from == 'College'){
               $verify_from = 'College';
            }
            elseif($verification_from == 'University'){
               $verify_from = 'University';
            }          
            else
            {
               $verify_from = '';
            }

            $veri_received = $verification_data['veri_received_dropdown'];
            //$veri_received =   $qc2verification_data['veri_received_dropdown'];
       
            if($veri_received == 1){
               $verification_received  = "Received";
            }
            elseif($veri_received == 2)
            {
               $verification_received  = "Not received";
            }
            else
            {
               $veri_received_data = '';
            }

            
            //....Payment and charges......//
      
            if($vm_expenses<>null){
              // initialise the array
              $d_amount         = array();
              $reference_no     = array();
              $reference_number = array();
              $payment_date     = array();
              $pay_date         = array();
              $payment_dates    = array();


               //amount and reference and payment dates
               foreach($vm_expenses as $key => $dd_exprenses) {
                  $amount = rtrim($dd_exprenses['amount'], ',"/- ');
                  $d_amount[]=$amount;
                  $reference_no[]=$dd_exprenses['reference'];    
               }
               $dd_am = implode('<br>',$d_amount);
                 
               $dd_amount="<span style='padding:2px'>".$dd_am."</span>";
               $reference_number = implode('<br>',$reference_no);
               $reference  ="<span style='padding:2px'>".$reference_number."</span>";
    
               foreach($vm_expenses as $key => $payment) {
                  if($payment['payment_date']!= '')   
                      $payment_date[] = date("d-m-Y",strtotime($payment['payment_date']));   
                  else
                      $payment_date[]='';                            
               }
               if(!empty($payment_date)){
                    $pay_d = implode('<br>',$payment_date); 

                     if($pay_d == '01-01-1970'){
                        $pay_date = "";
                    }
               }  
               $pay_date="<span style='padding:2px'>".$pay_d."</span>";
       
            }
            else{
               $dd_amount = '';
               $reference = '';
            }
            //payment to   
            if($vm_expenses<>null){
               $payment_to = array();
               $pay_status = array();

               foreach($vm_expenses as $key => $pay_to) {
                  $payment_to[]=$pay_to['payment_to'];   
               }
                 
               $payment =array();
               $paymentto =array();  
               $payment_status= array(); 

               foreach($payment_to as  $paymentto ){
                       
                  if($paymentto ==1){
                     $pay_status[]= 'University';
                  }
                  elseif($paymentto ==2){
                     $pay_status[]= 'College';
                  }
                  elseif($paymentto ==3){
                     $pay_status[]= 'Company'; 
                  }
                  elseif($paymentto ==4){
                     $pay_status[]= 'University and College';
                  }               
                  else
                  {
                     $pay_status[]= '';
                  }           
               }            
            }
            else{
               $pay_status[]= '';
            }

            $payment_status1 = implode('<br>',$pay_status);  
            $payment_status = "<span style='padding:2px'>".$payment_status1."</span>"; 

            //expences
            if($vm_expenses<>null){
               $paymode = array();

               foreach($vm_expenses as $val){
                  $expen= $this->vm->expensedetails($val['expences']);
                  $paymode[] = $expen['name'];                   
                }
               $payment_m = implode('<br>',$paymode);
               $payment_mode= "<span style='padding:2px'>".$payment_m ."</span>";
            }
            else{
               $payment_mode ='';
            } 

            //currency 
            if($vm_expenses<>null){
               $currency_id = array();
               $countvalue= count($vm_expenses);
            
               foreach($vm_expenses as $key => $vm_curency_id) {
                  $currency_id[]=$vm_curency_id['ddcurrency']; 
               }     
            
               $c_id =array();
               $currencyname= array();
               $currency_name=array();
                   
               foreach($currency_id as $key=> $c_id){
                  $currency_name[] = $this->amodel->getDetails(DB_PREFIX ."master_masterdata", array('id', 'name'), array('key' => 'currencykey', 'id' => $c_id));
               }
    
               $currency=array();
                   
               for($j=0;$j<$countvalue;$j++){
                  $currencyname[] = $currency_name[$j][0]['name'];
               }
               if(!empty($currencyname)) 
                  $curr=implode('<br>',$currencyname);
               else{
                  $curr = '';
               }
               $currency= "<span style='padding:2px'>".$curr."</span>";  
            }

            else{
               $currency = '';
            } 

            // End Payment and charges           

            // Rti ref.number and rti dates

            $rti_reference_no =$verification_data['rti_reference_no'];
            $rti_reference_date=$verification_data['rti_reference_date'];
                
            $v_date=isset($row['v_date'])?date('d-m-Y',strtotime($row['v_date'])):''; 
            $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'], $row['candidatename'],$row['case_no'],$chkval,$rpt_status,$cmpnyname,$clgname,$uniname,$verification_received,$verify_from,$dd_status,$currency,$dd_amount,$payment_mode,$reference,$pay_date,$payment_status,$rti_reference_no,$rti_reference_date,$v_date,$final_report_published_date, $supplement_report_date, $row['vname']);
                  
            } 
              
            echo json_encode($response);

        
      }

   }  // end of get_reimbursementlist

   function export_reimbursement()
   {
      $model = array('Charges_model'=>'export_reimbursementlist_model');  
      $c_date = ($_POST['exp_c_date']) ? $_POST['exp_c_date'] : '';
      $t_date = ($_POST['exp_t_date']) ? $_POST['exp_t_date'] : '';
      $date_filter = ($_POST['exp_date_filter']) ? $_POST['exp_date_filter'] : '';
      $org_id =($_POST['exp_org_id']) ? $_POST['exp_org_id'] : '';  // Dec 15th
      $case_number =($_POST['exp_case_number']) ? $_POST['exp_case_number'] : '';  // Nov 30th
      $cmp_name = ($_POST['exp_cmp_name']) ? $_POST['exp_cmp_name'] : '';  // Jan 22nd 2024
      $coll_name = ($_POST['exp_coll_name']) ? $_POST['exp_coll_name'] : '';  // Jan 22nd 2024
      $univ_name = ($_POST['exp_univ_name']) ? $_POST['exp_univ_name'] : ''; ; // Jan 22nd 2024

      // If case number(s) filter is used instead of date filter // Nov 30th
      if(!empty($case_number))
      {
         $case_number = trim($case_number);
         $case_no = explode(',',$case_number);
         //print_r($case_no); 
         $arraycase_no = ''; 
          
         // convert PR101-316,PO80-482,PO61-193,PO205-532 into 'PR101-316','PO80-482','PO61-193','PO205-532' 
         for($i=0; $i < count($case_no);$i++)
         {
            if($i == (count($case_no)-1))
               $arraycase_no  .= "'" . $case_no[$i] . "'";
            else
               $arraycase_no .= "'" . $case_no[$i] . "',";

         }
         $condition[]="d.case_no IN (".$arraycase_no.")";
      } // Nov 30th
   
      // If date radio button is clicked/ selected and organization is selected.  // Dec 15th
      if(!empty($org_id))
      {
         $condition[]=" d.organisation = ".$org_id;
      }  // Dec 15th

      // FINAL REPORT PUBLISHED DATE
      if(!empty($date_filter) && $date_filter == 2)
      {
         if(!empty($c_date)){
            $condition[]="DATE_FORMAT(d.final_report_published_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
         }
         if(!empty($t_date)){
            $condition[]="DATE_FORMAT(d.final_report_published_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
         }
         $condition[]="DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= DATE_FORMAT(d.final_report_published_date ,'%Y-%m-%d')";
      }

      // SUPPLEMENTARY PUBLISHED DATE
      if(!empty($date_filter) && $date_filter == 7)
      {
         if(!empty($c_date)){
            $condition[]="DATE_FORMAT(d.supplement_report_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
         }
         if(!empty($t_date)){
            $condition[]="DATE_FORMAT(d.supplement_report_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
         }
         // Dec 4th
         $condition[] = " (CASE WHEN (d.final_report_published_date IS NOT NULL) THEN 
                         DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') > DATE_FORMAT(d.final_report_published_date ,'%Y-%m-%d') AND DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= DATE_FORMAT(d.supplement_report_date ,'%Y-%m-%d') ELSE 
                        DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= DATE_FORMAT(d.supplement_report_date ,'%Y-%m-%d')
                           END )";
         // Dec 4th
         // $condition[]="DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') > DATE_FORMAT(d.final_report_published_date ,'%Y-%m-%d')";
         // $condition[]="DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= DATE_FORMAT(d.supplement_report_date ,'%Y-%m-%d')";
      }


      /** Jan 22nd 2024 **/
      if(!empty($date_filter))
      {
         if(!empty($cmp_name)){
            $condition[] = " em.company_name like '" . $cmp_name . "%'";
         }

         if(!empty($coll_name)){
            $condition[] = " ed.collegename_add  like '" . $coll_name . "%'";
         }

         if(!empty($univ_name)){
            $condition[] = " ed.affliated  like '" . $univ_name . "%'";
         }
      }
      /** Jan 22nd 2024 **/

      $manual_cond=implode(' and ',$condition);
      $results = $this->_jqgrid_search($model,$manual_cond);
      $response = $results[0];  
      $result = $results[1];
      if ($result) 
      {
         $checkteam = $this->config->item('CHECKLIST',APPLICATIONCONFIG);
         $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
         $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
         $page=$page - 1;
         $count=$page * $rows;
         $k=1;
         $objPHPExcel = new PHPExcel();
         $objPHPExcel->setActiveSheetIndex(0);
         $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
         $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
         $objPHPExcel->getActiveSheet()->setCellValue('C1', "Head Office");
         $objPHPExcel->getActiveSheet()->setCellValue('D1', "Branch Office");
         $objPHPExcel->getActiveSheet()->setCellValue('E1', "Sub Office");
         $objPHPExcel->getActiveSheet()->setCellValue('F1', "Name");
         $objPHPExcel->getActiveSheet()->setCellValue('G1', "Case Number");
         $objPHPExcel->getActiveSheet()->setCellValue('H1', "Check Name");
         $objPHPExcel->getActiveSheet()->setCellValue('I1', "Check Status");
         $objPHPExcel->getActiveSheet()->setCellValue('J1', "Company Name");
         $objPHPExcel->getActiveSheet()->setCellValue('K1', "College Name");
         $objPHPExcel->getActiveSheet()->setCellValue('L1', "University Name");
         $objPHPExcel->getActiveSheet()->setCellValue('M1', "Verification Received / Not");
         $objPHPExcel->getActiveSheet()->setCellValue('N1', "Verification Received Form");
         $objPHPExcel->getActiveSheet()->setCellValue('O1', "Amount Paid To");
         $objPHPExcel->getActiveSheet()->setCellValue('P1', "Currency");    
         $objPHPExcel->getActiveSheet()->setCellValue('Q1', "Amount");
         $objPHPExcel->getActiveSheet()->setCellValue('R1', "Payment Mode");
         $objPHPExcel->getActiveSheet()->setCellValue('S1', "Payment Reference Number");
         $objPHPExcel->getActiveSheet()->setCellValue('T1', "Payment Date");
         $objPHPExcel->getActiveSheet()->setCellValue('U1', "Pament To");
         $objPHPExcel->getActiveSheet()->setCellValue('V1', "RTI Reference Number");
         $objPHPExcel->getActiveSheet()->setCellValue('W1', "RTI Reference Date");
         $objPHPExcel->getActiveSheet()->setCellValue('X1', "VM Completed Date");
         $objPHPExcel->getActiveSheet()->setCellValue('Y1', "Final Report Date");
         $objPHPExcel->getActiveSheet()->setCellValue('Z1', "Supplementary Report Date");
         $objPHPExcel->getActiveSheet()->setCellValue('AA1', "Verifier Name");
           
         $ci=2;
         foreach( $result as $i => $row ) {
       
            $company_details=$this->vm->get_verifiedcompany_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
            $education_details=$this->vm->get_verifiedcollege_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
            $professional_details=$this->vm->get_verifiedprofessional_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
       
            $verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);

            $verification_data=toArray(json_decode($verified_data['fielddata']));
            $vm_expenses=toArray(json_decode($verified_data['vmexpenses']));
            $qc2verification_data=toArray(json_decode($verified_data['qc2fielddata']));
       

            $status1=$this->vm->get_status($qc2verification_data['status']);
            $status4='';
            $status2=$this->vm->get_status($qc2verification_data['pstatus']);
            $status3=$this->vm->get_status($qc2verification_data['status1']);
            if($verification_data['ostatus']<>'')
               $status4=$this->vm->get_status($qc2verification_data['ostatus']);
               if($verification_data['dstatus']<>'')
                  $status4=$this->vm->get_status($qc2verification_data['dstatus']);
               if(!empty($status4))
                  $status41='-'.$status4['name'];
               else
                  $status41='';

     
            if($verification_data['status']!=107 && $verification_data['status']!=684 && $verification_data['status']!=992 && !empty($verification_data['status'])) {
               if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                  $rpt_status="RED";
               }
               else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Partial Match"){
                  $rpt_status="ORANGE";
               }
               else 
               {
                  $rpt_status="GREEN";
               }
            }
            

            if($row['chk']==0){
               $chkval=$row['checkname'];
            }else{
               $chkval=$row['checkname'].$row['chk'];
            }
            if(!empty($status1['name'])){
               $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
            }else{
               $stat='';
            }
            if($row['checkid']==14){
               $clgname=$education_details['collegename_add'];
               $uniname=$education_details['affliated']; 
            }else{
               $clgname='';
               $uniname='';
            }            
         
            if($row['checkid']==59){
               $cmpnyname=$company_details['company_name'];
            }else if($row['checkid']==68){
               $cmpnyname=$professional_details['company_name'];
            }else{
               $cmpnyname='';
            }
            
            $v_date=isset($row['v_date'])? date('d-m-Y',strtotime($row['v_date'])) : '';
            $final_report_published_date = isset($row['final_report_published_date'])? date('d-m-Y',strtotime($row['final_report_published_date'])) : '';
            $supplement_report_date = isset($row['supplement_report_date'])? date('d-m-Y',strtotime($row['supplement_report_date'])) : '';

            $req_raise_date=isset($row['vm_request_raised_date'])? date('d-m-Y',strtotime($row['vm_request_raised_date'])) : '';

            $dd_recived =    $verification_data['dd_recevied_form'];
               
            if($dd_recived == 1){
               $dd_status = 'University';
            }
            elseif($dd_recived == 2){
               $dd_status = 'College';
            }
            elseif($dd_recived == 3){
               $dd_status = 'Company';
            }
            elseif($dd_recived == 4){
               $dd_status = 'University and College';
            }
            else
            {
               $dd_status = '';
            }
                                                 
            $verification_from = $verification_data['verification_received'];
            
            if($verification_from == 'College'){
               $verify_from = 'College';
            }
            elseif($verification_from == 'University'){
               $verify_from = 'University';
            }           
            else
            {
               $verify_from = '';
            }

            $veri_received = $verification_data['veri_received_dropdown'];
            //$veri_received =   $qc2verification_data['veri_received_dropdown'];
          
            if($veri_received == 1){
               $verification_received  = "Received";
            }
            elseif($veri_received == 2)
            {
               $verification_received  = "Not received";
            }
            else
            {
               $veri_received_data = '';
            }

            //....Payment and charges......//
            $reference_no = array();
            if($vm_expenses<>null){
               $d_amount         = array();
               $payment_date     = array();
               $pay_date         = array();
               $payment_dates    = array();


               //amount ,referencenumber and payment dates
               foreach($vm_expenses as $key => $dd_exprenses) {
                  $d_amount[]=$dd_exprenses['amount'];
                  $reference_no[]=$dd_exprenses['reference'];    
               }
               $dd_am = implode(',',$d_amount);
               $dd_amount=$dd_am;
               $reference_number = implode(',',$reference_no);
               $reference  =$reference_number;
    
               foreach($vm_expenses as $key => $payment) {
                  if($payment['payment_date']!= '')   
                      $payment_date[] = date("d-m-Y",strtotime($payment['payment_date']));   
                  else
                      $payment_date[]='';
             
               }
               if(!empty($payment_date)){
                  $pay_d = implode(',',$payment_date); 

                  if($pay_d == '01-01-1970'){
                   $pay_date = "";
                  }
               }  
               $pay_date=$pay_d;       
            }
            else{
               $dd_amount = '';
               $reference = '';
            }
            //payment to   
            if($vm_expenses<>null){
               $payment_to = array();
               $pay_status = array();

               foreach($vm_expenses as $key => $pay_to) {
                     $payment_to[]=$pay_to['payment_to'];                      
               }
                 
               $payment =array();
               $paymentto =array();  
               $payment_status= array();  

               foreach($payment_to as  $paymentto ){
                       
                  if($paymentto ==1){
                     $pay_status[]= 'University';
                  }
                  elseif($paymentto ==2){
                     $pay_status[]= 'College';
                  }
                  elseif($paymentto ==3){
                     $pay_status[]= 'Company'; 
                  }
                  elseif($paymentto ==4){
                     $pay_status[]= 'University and College';
                  }            
                  else
                  {
                     $pay_status[]= '';
                  } 
     
               }
        
            }
            else{
               $pay_status[]= '';
            }

            $payment_status1 = implode(',',$pay_status);  
            $payment_status = $payment_status1; 

            //expences
            if($vm_expenses<>null){
               $paymode = array();

               foreach($vm_expenses as $val){
                  $expen= $this->vm->expensedetails($val['expences']);
                  $paymode[] = $expen['name'];                
               }
               $payment_m = implode(',',$paymode);
               $payment_mode= $payment_m;
            }
            else{
               $payment_mode ='';
            } 

            //currency 
            if($vm_expenses<>null){

               $currency_id = array();
               $countvalue= count($vm_expenses);
                  
               foreach($vm_expenses as $key => $vm_curency_id) {
                  $currency_id[]=$vm_curency_id['ddcurrency']; 
               }     
               
               $c_id =array();
               $currencyname= array();
               $currency_name=array();
                   
               foreach($currency_id as $key=> $c_id){
                  $currency_name[] = $this->amodel->getDetails(DB_PREFIX ."master_masterdata", array('id', 'name'), array('key' => 'currencykey', 'id' => $c_id));
                  }
    
               $currency=array();
                   
               for($j=0;$j<$countvalue;$j++){
                       $currencyname[] = $currency_name[$j][0]['name'];
               }
               if(!empty($currencyname)) 
                 $curr=implode(',',$currencyname);
               else{
                   $curr = '';
               }
               $currency= $curr;  
            }    
            else{
               $currency = '';
            } 
            // End Payment and charges           

            // Rti ref.number and rti dates
            $rti_reference_no =$verification_data['rti_reference_no'];
            $rti_reference_date=$verification_data['rti_reference_date'];
                   
            $objPHPExcel->getActiveSheet()->getStyle('A1:AA1')->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                                  ->setCellValue('B' . $ci, $row['org_name'])
                                  ->setCellValue('C' . $ci, $row['parent_office'])
                                  ->setCellValue('D' . $ci, $row['office_name'])
                                  ->setCellValue('E' . $ci, $row['sub_office'])
                                  ->setCellValue('F' . $ci, $row['candidatename'])
                                  ->setCellValue('G' . $ci, $row['case_no'])
                                  ->setCellValue('H' . $ci, $chkval)
                                  ->setCellValue('I' . $ci, $rpt_status)
                                  ->setCellValue('J' . $ci, $cmpnyname)
                                  ->setCellValue('K' . $ci, $clgname)
                                  ->setCellValue('L' . $ci, $uniname)
                                  ->setCellValue('M' . $ci, $verification_received)
                                  ->setCellValue('N' . $ci, $verify_from)
                                  ->setCellValue('O' . $ci, $dd_status)
                                  ->setCellValue('P' . $ci, $currency)
                                  ->setCellValue('Q' . $ci, $dd_amount)
                                  ->setCellValue('R' . $ci, $payment_mode)
                                  ->setCellValue('S' . $ci, $reference)
                                  ->setCellValue('T' . $ci, $pay_date)
                                  ->setCellValue('U' . $ci, $payment_status)
                                  ->setCellValue('V' . $ci, $rti_reference_no)
                                  ->setCellValue('W' . $ci, $rti_reference_date)
                                  ->setCellValue('X' . $ci, $v_date)
                                  ->setCellValue('Y' . $ci, $final_report_published_date)
                                  ->setCellValue('Z' . $ci, $supplement_report_date)
                                  ->setCellValue('AA' . $ci, $row['vname']);
                                
            $ci++;
         }
         // Nov 30th
         if(!empty($case_number) && count($case_no) == 1)
         {
            // if a single case number has been entered download the excel file with that case number in the file name
            $this->export_excel('A','AA','Reimbursement_List_'.trim($case_number) . '_',$objPHPExcel);
         }
         else
         {
            $this->export_excel('A','AA','Reimbursement_List_',$objPHPExcel);
         } // Nov 30th
         exit; 
      }

   } //  end of export_reimbursement

   /** 18th October **/
   function service_charges()
    {
      $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
      $this->breadcrumbs->push('Service Charges', 'Charges/service_charges');
      $data['breadcrumb']=$this->breadcrumbs->show();
      $data['organization'] = $organization=$this->amodel->getDetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('id !=' => 1,'org_status'=>1),  "org_name"); // Dec 15th 2023     

      $this->amodel->pagerender($data,'service_charges');

   }

   function get_service_charges_list()
   {
      $model = array('Charges_model'=>'get_service_charges_list_model');  
      $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
      $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
      $org_id =($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';  // Dec 15th
   
      // Organisation id  // Dec 15th
      if(!empty($org_id))
      {
         $condition[]=" bi.org_id = ".$org_id;
      }

      // FINAL REPORT PUBLISHED DATE     
      if(!empty($c_date)){
         $condition[]="DATE_FORMAT(bi.report_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date)) . "'";
      }
      if(!empty($t_date)){
         $condition[]="DATE_FORMAT(bi.report_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date)) . "'";
      }
     
      $manual_cond=implode(' and ',$condition);
      $results = $this->_jqgrid_search($model,$manual_cond); 
      $response = $results[0];  
      $result = $results[1];
      
      if ($result) {
         $checkteam = $this->config->item('CHECKLIST',APPLICATIONCONFIG);
         $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
         $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
         $page=$page - 1;
         $count=$page * $rows;
         $k=1;

         foreach( $result as $i => $row ) {

            $req_id = $row['request_id'];
            $package_id = $row['package_id'];

            // to  get submitted checks of a given  package  id. 
            $submitted_checks_arr = $this->chm->get_checks_for_pack_id($req_id, $package_id);

            
            if(!empty($submitted_checks_arr))
            {
               $sub_chk_arr[] = array(
                                  'noOfChks' => 0, // count of each check
                                  'check_name' => 0 //  name of each check
                                 ); // array of submitted checks
               $c = 0;
               foreach($submitted_checks_arr as $sub_chk)
               {
                  $sub_chk_arr[$c]['noOfChks'] = $sub_chk['no_checks'];
                  $sub_chk_arr[$c]['check_name'] = $sub_chk['checkname'];
                  $c++;
               }
            }
            
            $submittedChks = '';
            $count_sc = count($sub_chk_arr);
            $m = 0;

            if(!empty($sub_chk_arr))
            {
               foreach($sub_chk_arr as $element)
               {
                  $submittedChks .= $element['noOfChks'] . ' '  .  $element['check_name'];
                  $m++;
                  if($m < $count_sc)
                     $submittedChks .= ' + ';
               }
            }

            $additionalChks = ''; // Dec 29th
            if($row['package_label'] !=  '') // Dec 29th
            {
               $package_id = 0; // package_id will be 0  for additional checks

               // to get additional checks if any. 
               $additional_checks_arr = $this->chm->get_checks_for_pack_id($req_id, $package_id);

               
               if(!empty($additional_checks_arr))
               {
                  $additional_chk_arr[] = array(
                                     'noOfChks' => 0, // count of each check
                                     'check_name' => 0 //  name of each check
                                    ); // array of additional checks
                  $j = 0;
                  foreach($additional_checks_arr as $additional_chk)
                  {
                     $additional_chk_arr[$j]['noOfChks'] = $additional_chk['no_checks'];
                     $additional_chk_arr[$j]['check_name'] = $additional_chk['checkname'];
                     $j++;
                  }
               }

               // $additionalChks = ''; // Dec 29th
               $count_add_chk = count($additional_chk_arr);
               $n = 0;
               foreach($additional_chk_arr as $value)
               {
                  $additionalChks .= $value['noOfChks'] . ' '  .  $value['check_name'] . ' ';
                  $n++;
                  if($n < $count_add_chk)
                     $additionalChks .= ' + ';
               }
            } // Dec 29th

            // empty all arrays
            unset($submitted_checks_arr);
            unset($sub_chk_arr);
            unset($additional_checks_arr);
            unset($additional_chk_arr);

            $final_report_date=isset($row['final_report_date'])?date('d-m-Y',strtotime($row['final_report_date'])):''; 
            $charges_services = ($row['charges_services'])? $row['charges_services']: '';
            $charges_services_package = ($row['charges_services_package'])? $row['charges_services_package']: '';
            $charges_services_overseas = ($row['charges_services_overseas'])? $row['charges_services_overseas']: '';
            $charges_services_checks = ($row['charges_services_checks'])? $row['charges_services_checks']: '';
            $charges_services_international = ($row['charges_services_international'])? $row['charges_services_international']: '';
            $charges_services_endtoend = ($row['charges_services_endtoend']) ? $row['charges_services_endtoend']: ''; 

            $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'], $row['candidatename'],$row['case_no'],$final_report_date,$row['package_label'], $submittedChks, $additionalChks,$charges_services,$charges_services_package,$charges_services_checks,$charges_services_overseas,$charges_services_international,$charges_services_endtoend,$row['charges_services_int_txt'],$row['rate_error']); // Dec 29th
         }

          echo json_encode($response);
      }

     
   } //  end of get_service_charges_list


   function export_service_charges()
   {
      $model = array('Charges_model'=>'export_service_charges_list_model');  
      $c_date = ($_POST['exp_c_date']) ? $_POST['exp_c_date'] : ''; // Nov 7th
      $t_date = ($_POST['exp_t_date']) ? $_POST['exp_t_date'] : '';
      $org_id =($_POST['exp_org_id']) ? $_POST['exp_org_id'] : '';  // Dec 15th

      // Organisation id  // Dec 15th
      if(!empty($org_id))
      {
         $condition[]=" bi.org_id = ".$org_id;
      }
      
      // FINAL REPORT PUBLISHED DATE     
      if(!empty($c_date)){
         $condition[]="DATE_FORMAT(bi.report_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date)) . "'";
      }
      if(!empty($t_date)){
         $condition[]="DATE_FORMAT(bi.report_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date)) . "'";
      }
     
      $manual_cond=implode(' and ',$condition);
      $results = $this->_jqgrid_search($model,$manual_cond); 
      $response = $results[0];  
      $result = $results[1];
      // print_r($result);
      if ($result) {
         $checkteam = $this->config->item('CHECKLIST',APPLICATIONCONFIG);
         $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
         $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
         $page=$page - 1;
         $count=$page * $rows;
         $k=1;

         $objPHPExcel = new PHPExcel();
         $objPHPExcel->setActiveSheetIndex(0);
         $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
         $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
         $objPHPExcel->getActiveSheet()->setCellValue('C1', "Head Office");
         $objPHPExcel->getActiveSheet()->setCellValue('D1', "Branch Office");
         $objPHPExcel->getActiveSheet()->setCellValue('E1', "Sub Office");
         $objPHPExcel->getActiveSheet()->setCellValue('F1', "Name");
         $objPHPExcel->getActiveSheet()->setCellValue('G1', "Case Number");
         $objPHPExcel->getActiveSheet()->setCellValue('H1', "Final Report Date");
         // $objPHPExcel->getActiveSheet()->setCellValue('I1', "Package Name");
         $objPHPExcel->getActiveSheet()->setCellValue('I1', "Package Label"); // Dec 29th
         $objPHPExcel->getActiveSheet()->setCellValue('J1', "Submitted Checks");  // Dec 29th
         $objPHPExcel->getActiveSheet()->setCellValue('K1', "Additional Checks"); // Dec 29th
         $objPHPExcel->getActiveSheet()->setCellValue('L1', "Package Charges"); // Dec 29th
         $objPHPExcel->getActiveSheet()->setCellValue('M1', "Check Charges"); // Dec 29th
         $objPHPExcel->getActiveSheet()->setCellValue('N1', "Overseas Charges"); // Dec 29th
         $objPHPExcel->getActiveSheet()->setCellValue('O1', "Intl. Charges"); // Dec 29th
         $objPHPExcel->getActiveSheet()->setCellValue('P1', "End to End Charges"); // Dec 29th
         $objPHPExcel->getActiveSheet()->setCellValue('Q1', "Total Charges"); // Dec 29th          
         $objPHPExcel->getActiveSheet()->setCellValue('R1', "Intl. Charges and Currencies"); // Dec 29th
         $objPHPExcel->getActiveSheet()->setCellValue('S1', "Missing Rates"); // Dec 29th
         
         $ci=2;

         foreach( $result as $i => $row ) {

            $req_id = $row['request_id'];
            $package_id = $row['package_id'];

            // to  get submitted checks of a given  package  id. 
            $submitted_checks_arr = $this->chm->get_checks_for_pack_id($req_id, $package_id);

            
            if(!empty($submitted_checks_arr))
            {
               $sub_chk_arr[] = array(
                                  'noOfChks' => 0, // count of each check
                                  'check_name' => 0 //  name of each check
                                 ); // array of submitted checks
               $c = 0;
               foreach($submitted_checks_arr as $sub_chk)
               {
                  $sub_chk_arr[$c]['noOfChks'] = $sub_chk['no_checks'];
                  $sub_chk_arr[$c]['check_name'] = $sub_chk['checkname'];
                  $c++;
               }
            }
            // print_r($sub_chk_arr);
            $submittedChks = '';
            $count_sc = count($sub_chk_arr);
            $m = 0;

            if(!empty($sub_chk_arr))
            {
               foreach($sub_chk_arr as $element)
               {
                  $submittedChks .= $element['noOfChks'] . ' '  .  $element['check_name'];
                  $m++;
                  if($m < $count_sc)
                     $submittedChks .= ' + ';
               }
            }

            $additionalChks = ''; // Dec 29th
            if($row['package_label'] !=  '') // Dec 29th
            {
               $package_id = 0; // package_id will be 0  for additional checks

               // to get additional checks if any. 
               $additional_checks_arr = $this->chm->get_checks_for_pack_id($req_id, $package_id);

               
               if(!empty($additional_checks_arr))
               {
                  $additional_chk_arr[] = array(
                                     'noOfChks' => 0, // count of each check
                                     'check_name' => 0 //  name of each check
                                    ); // array of additional checks
                  $j = 0;
                  foreach($additional_checks_arr as $additional_chk)
                  {
                     $additional_chk_arr[$j]['noOfChks'] = $additional_chk['no_checks'];
                     $additional_chk_arr[$j]['check_name'] = $additional_chk['checkname'];
                     $j++;
                  }
               }

               // $additionalChks = ''; // Dec 29th
               $count_add_chk = count($additional_chk_arr);
               $n = 0;
               foreach($additional_chk_arr as $value)
               {
                  $additionalChks .= $value['noOfChks'] . ' '  .  $value['check_name'] . ' ';
                  $n++;
                  if($n < $count_add_chk)
                     $additionalChks .= ' + ';
               }
            } // Dec 29th

            // empty all arrays
            unset($submitted_checks_arr);
            unset($sub_chk_arr);
            unset($additional_checks_arr);
            unset($additional_chk_arr);

            $final_report_date=isset($row['final_report_date'])?date('d-m-Y',strtotime($row['final_report_date'])):''; 

            $objPHPExcel->getActiveSheet()->getStyle('A1:S1')->getFont()->setBold(true); // Dec 29th
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                                  ->setCellValue('B' . $ci, $row['org_name'])
                                  ->setCellValue('C' . $ci, $row['parent_office'])
                                  ->setCellValue('D' . $ci, $row['office_name'])
                                  ->setCellValue('E' . $ci, $row['sub_office'])
                                  ->setCellValue('F' . $ci, $row['candidatename'])
                                  ->setCellValue('G' . $ci, $row['case_no'])
                                  ->setCellValue('H' . $ci, $final_report_date)
                                  // ->setCellValue('I' . $ci, $row['package_name'])
                                  ->setCellValue('I' . $ci, $row['package_label']) // Dec 29th
                                  ->setCellValue('J' . $ci, $submittedChks) // Dec 29th
                                  ->setCellValue('K' . $ci, $additionalChks) // Dec 29th
                                  ->setCellValue('L' . $ci, $row['charges_services_package']) // Dec 29th
                                  ->setCellValue('M' . $ci, $row['charges_services_checks']) // Dec 29th
                                  ->setCellValue('N' . $ci, $row['charges_services_overseas']) // Dec 29th
                                  ->setCellValue('O' . $ci, $row['charges_services_international']) // Dec 29th
                                  ->setCellValue('P' . $ci, $row['charges_services_endtoend']) // Dec 29th
                                  ->setCellValue('Q' . $ci, $row['charges_services']) // Oct 20th
                                  ->setCellValue('R' . $ci, $row['charges_services_int_txt']) // Dec 29th
                                  ->setCellValue('S' . $ci, $row['rate_error']); // Dec 29th
            $ci++;

         }

         $this->export_excel('A','S','Service_Charges_List_',$objPHPExcel); // Dec 29th
         exit; 

      }

   } // end of export_service_charges



   function reimbursement_pr()
   {
      $data['organization'] = $organization=$this->amodel->getDetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('id !=' => 1,'org_status'=>1),  "org_name");

      $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
      $this->breadcrumbs->push('Reimbursement Charges - (PR)', 'Charges/reimbursement_pr');
      $data['breadcrumb']=$this->breadcrumbs->show();

      $this->amodel->pagerender($data,'reimbursement_pr');

   }


   function get_reimbursementlist_pr()
   {
      $model = array('Charges_model' => 'get_reimbursementlist_pr');
      $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
      $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
      $date_filter = ($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
      $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';  
      $case_number = ($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';  
      $cmp_name = ($_REQUEST['cmp_name']) ? $_REQUEST['cmp_name'] : '';  
      $coll_name = ($_REQUEST['coll_name']) ? $_REQUEST['coll_name'] : '';  
      $univ_name = ($_REQUEST['univ_name']) ? $_REQUEST['univ_name'] : '';; 
// print_r($_REQUEST);exit;
      if (!empty($case_number)) {
         $case_number = trim($case_number);
         $case_no = explode(',', $case_number);
         $arraycase_no = '';

         for ($i = 0; $i < count($case_no); $i++) {
            if ($i == (count($case_no) - 1))
               $arraycase_no  .= "'" . $case_no[$i] . "'";
            else
               $arraycase_no .= "'" . $case_no[$i] . "',";
         }
         $condition[] = "cr.case_no IN (" . $arraycase_no . ")";
      } 

      if (!empty($org_id)) {
         $condition[] = " cr.organisation = " . $org_id;
      } 
      if (!empty($date_filter) && $date_filter == 2) {
         if (!empty($c_date)) {
            $condition[] = "DATE_FORMAT(cr.final_report_published_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "'";
         }
         if (!empty($t_date)) {
            $condition[] = "DATE_FORMAT(cr.final_report_published_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
         }
         $condition[] = "DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= DATE_FORMAT(cr.final_report_published_date ,'%Y-%m-%d')";
      }

      if(!empty($date_filter) && $date_filter == 7)
      {
         if(!empty($c_date)){
            $condition[]="DATE_FORMAT(cr.supplement_report_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
         }
         if(!empty($t_date)){
            $condition[]="DATE_FORMAT(cr.supplement_report_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
         }
         $condition[] = " (CASE WHEN (cr.final_report_published_date IS NOT NULL) THEN 
                         DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') > DATE_FORMAT(cr.final_report_published_date ,'%Y-%m-%d') AND DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= DATE_FORMAT(cr.supplement_report_date ,'%Y-%m-%d') ELSE 
                        DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= DATE_FORMAT(cr.supplement_report_date ,'%Y-%m-%d')
                           END )";
         
      }

      
      if (!empty($date_filter)) {
         if (!empty($cmp_name)) {
            $condition[] = " em.company_name like '" . $cmp_name . "%'";
         }

         if (!empty($coll_name)) {
            $condition[] = " ed.collegename_add  like '" . $coll_name . "%'";
         }

         if (!empty($univ_name)) {
            $condition[] = " ed.affliated  like '" . $univ_name . "%'";
         }
      }

      $manual_cond = implode(' and ', $condition);
      $results = $this->_jqgrid_search($model, $manual_cond);
      $response = $results[0];
      $result = $results[1];
      // echo '<pre>';print_r($result);
      if ($result) {
         $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
         $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
         $page = $page - 1;
         $count = $page * $rows;
         $k = 1;

         foreach ($result as $i => $row) {

            $company_details = $this->vm->get_verifiedcompany_data($row['request_id'], $row['level_id'], $row['check_id']);
            $education_details = $this->vm->get_verifiedcollege_data($row['request_id'], $row['level_id'], $row['check_id']);
            $professional_details = $this->vm->get_verifiedprofessional_data($row['request_id'], $row['level_id'], $row['check_id']);

            $verified_data=$this->vm->get_verified_data($row['request_id'],$row['level_id'],$row['check_id']);

            $verification_data=toArray(json_decode($verified_data['fielddata']));
            $qc2verification_data=toArray(json_decode($verified_data['qc2fielddata']));
            $status1=$this->vm->get_status($qc2verification_data['status']);
            $status3=$this->vm->get_status($qc2verification_data['status1']);

            if($verification_data['status']!=107 && $verification_data['status']!=684 && $verification_data['status']!=992 && !empty($verification_data['status'])) {
               if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                  $rpt_status="<span style='color:red;'>RED</span>";
               }
               else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Partial Match"){
                  $rpt_status="<span style='color:orange;'>ORANGE</span>";
               }
               else 
               {
                  $rpt_status="<span style='color:green;'>GREEN</span>";
               }
            }

            if($row['check_id']==14){
               $clgname=$education_details['collegename_add'];
               $uniname=$education_details['affliated']; 
            }else{
               $clgname='';
               $uniname='';
            }
            
         
            if($row['checkid']==59){
               $cmpnyname=$company_details['company_name'];
            }else if($row['checkid']==68){
               $cmpnyname=$professional_details['company_name'];
            }else{
               $cmpnyname='';
            }

            if($row['count_of_chk'] > 0){
               $chkcount=$row['count_of_chk'];
            }else{
               $chkcount='';
            }

            $veri_received = $verification_data['veri_received_dropdown'];
       
            if($veri_received == 1){
               $verification_received  = "Received";
            }
            elseif($veri_received == 2)
            {
               $verification_received  = "Not received";
            }
            else
            {
               $verification_received = '';
            }
            
            $verification_from = $verification_data['verification_received'];
            if($verification_from == 'College'){
               $verify_from = 'College';
            }
            elseif($verification_from == 'University'){
               $verify_from = 'University';
            }          
            else
            {
               $verify_from = '';
            }

            $dd_recived =    $verification_data['dd_recevied_form'];
                   
               
            if($dd_recived == 1){
              $dd_status = 'University';
            }
            elseif($dd_recived == 2){
              $dd_status = 'College';
            }
            elseif($dd_recived == 3){
               $dd_status = 'Company';
            }
            elseif($dd_recived == 4){
               $dd_status = 'University and College';
            }
            else
            {
               $dd_status = '';
            }

            switch($row['payment_mode']){
               case 22:
                  $payRefNo=$row['chln_ref_number'];
                  break;
               case 23:
                  $payRefNo=$row['cr_transaction_no'];
                  break;
               case 24:
                  $payRefNo=$row['dd_txn_no'];
                  break;
               case 25:
                  $payRefNo=$row['neft_reference_no'];
                  break;
               case 26:
                  $payRefNo=$row['op_transaction_no'];
                  break;
               default:
                  $payRefNo='';
                  break;
            }

            $v_date=isset($row['v_date'])?date('d-m-Y',strtotime($row['v_date'])):''; 
            $f_date = isset($row['final_report_published_date']) ? date('d-m-Y', strtotime($row['final_report_published_date'])) : '';

            $sup_date = isset($row['supplement_report_date']) ? date('d-m-Y', strtotime($row['supplement_report_date'])) : '';
            $pay_date = isset($row['requested_date']) ? date('d-m-Y', strtotime($row['requested_date'])) : '';

            $response->rows[$i]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], $row['candidate_name'], $row['case_no'], $row['check_name'].$chkcount, $rpt_status, $cmpnyname, $clgname, $uniname, $verification_received, $verify_from, $dd_status, $row['pm_name'], $row['amount'], $row['paymode'], $payRefNo, $pay_date, $row['payto'], '', '', $v_date, $f_date, $sup_date, $row['requested_by']);
         }

         echo json_encode($response);
      }
   }


   function export_reimbursement_pr()
   {
      $model = array('Charges_model'=>'export_reimbursementlist_pr');  
      $c_date = ($_POST['exp_c_date']) ? $_POST['exp_c_date'] : '';
      $t_date = ($_POST['exp_t_date']) ? $_POST['exp_t_date'] : '';
      $date_filter = ($_POST['exp_date_filter']) ? $_POST['exp_date_filter'] : '';
      $org_id =($_POST['exp_org_id']) ? $_POST['exp_org_id'] : '';  
      $case_number =($_POST['exp_case_number']) ? $_POST['exp_case_number'] : '';  
      $cmp_name = ($_POST['exp_cmp_name']) ? $_POST['exp_cmp_name'] : '';  
      $coll_name = ($_POST['exp_coll_name']) ? $_POST['exp_coll_name'] : '';  
      $univ_name = ($_POST['exp_univ_name']) ? $_POST['exp_univ_name'] : ''; ; 
     
      if (!empty($case_number)) {
         $case_number = trim($case_number);
         $case_no = explode(',', $case_number);
         $arraycase_no = '';

         for ($i = 0; $i < count($case_no); $i++) {
            if ($i == (count($case_no) - 1))
               $arraycase_no  .= "'" . $case_no[$i] . "'";
            else
               $arraycase_no .= "'" . $case_no[$i] . "',";
         }
         $condition[] = "cr.case_no IN (" . $arraycase_no . ")";
      } 

      if (!empty($org_id)) {
         $condition[] = " cr.organisation = " . $org_id;
      } 
      if (!empty($date_filter) && $date_filter == 2) {
         if (!empty($c_date)) {
            $condition[] = "DATE_FORMAT(cr.final_report_published_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "'";
         }
         if (!empty($t_date)) {
            $condition[] = "DATE_FORMAT(cr.final_report_published_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
         }
         $condition[] = "DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= DATE_FORMAT(cr.final_report_published_date ,'%Y-%m-%d')";
      }

      if(!empty($date_filter) && $date_filter == 7)
      {
         if(!empty($c_date)){
            $condition[]="DATE_FORMAT(cr.supplement_report_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
         }
         if(!empty($t_date)){
            $condition[]="DATE_FORMAT(cr.supplement_report_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
         }
         $condition[] = " (CASE WHEN (cr.final_report_published_date IS NOT NULL) THEN 
                         DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') > DATE_FORMAT(cr.final_report_published_date ,'%Y-%m-%d') AND DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= DATE_FORMAT(cr.supplement_report_date ,'%Y-%m-%d') ELSE 
                        DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= DATE_FORMAT(cr.supplement_report_date ,'%Y-%m-%d')
                           END )";
         
      }

      
      if (!empty($date_filter)) {
         if (!empty($cmp_name)) {
            $condition[] = " em.company_name like '" . $cmp_name . "%'";
         }

         if (!empty($coll_name)) {
            $condition[] = " ed.collegename_add  like '" . $coll_name . "%'";
         }

         if (!empty($univ_name)) {
            $condition[] = " ed.affliated  like '" . $univ_name . "%'";
         }
      }
      
      $manual_cond=implode(' and ',$condition);
      
      $results = $this->_jqgrid_search($model,$manual_cond);
      
      $response = $results[0];  
      $result = $results[1];
      
      if ($result) 
      {
         // $checkteam = $this->config->item('CHECKLIST',APPLICATIONCONFIG);
         $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
         $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
         $page=$page - 1;
         $count=$page * $rows;
         $k=1;
         $objPHPExcel = new PHPExcel();
         $objPHPExcel->setActiveSheetIndex(0);
         $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
         $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
         $objPHPExcel->getActiveSheet()->setCellValue('C1', "Head Office");
         $objPHPExcel->getActiveSheet()->setCellValue('D1', "Branch Office");
         $objPHPExcel->getActiveSheet()->setCellValue('E1', "Sub Office");
         $objPHPExcel->getActiveSheet()->setCellValue('F1', "Name");
         $objPHPExcel->getActiveSheet()->setCellValue('G1', "Case Number");
         $objPHPExcel->getActiveSheet()->setCellValue('H1', "Check Name");
         $objPHPExcel->getActiveSheet()->setCellValue('I1', "Check Status");
         $objPHPExcel->getActiveSheet()->setCellValue('J1', "Company Name");
         $objPHPExcel->getActiveSheet()->setCellValue('K1', "College Name");
         $objPHPExcel->getActiveSheet()->setCellValue('L1', "University Name");
         $objPHPExcel->getActiveSheet()->setCellValue('M1', "Verification Received / Not");
         $objPHPExcel->getActiveSheet()->setCellValue('N1', "Verification Received Form");
         $objPHPExcel->getActiveSheet()->setCellValue('O1', "Amount Paid To");
         $objPHPExcel->getActiveSheet()->setCellValue('P1', "Currency");    
         $objPHPExcel->getActiveSheet()->setCellValue('Q1', "Amount");
         $objPHPExcel->getActiveSheet()->setCellValue('R1', "Payment Mode");
         $objPHPExcel->getActiveSheet()->setCellValue('S1', "Payment Reference Number");
         $objPHPExcel->getActiveSheet()->setCellValue('T1', "Payment Date");
         $objPHPExcel->getActiveSheet()->setCellValue('U1', "Pament To");
         $objPHPExcel->getActiveSheet()->setCellValue('V1', "RTI Reference Number");
         $objPHPExcel->getActiveSheet()->setCellValue('W1', "RTI Reference Date");
         $objPHPExcel->getActiveSheet()->setCellValue('X1', "VM Completed Date");
         $objPHPExcel->getActiveSheet()->setCellValue('Y1', "Final Report Date");
         $objPHPExcel->getActiveSheet()->setCellValue('Z1', "Supplementary Report Date");
         $objPHPExcel->getActiveSheet()->setCellValue('AA1', "Verifier Name");
           
         $ci=2;
         foreach( $result as $i => $row ) {
       
            $company_details = $this->vm->get_verifiedcompany_data($row['request_id'], $row['level_id'], $row['check_id']);
            $education_details = $this->vm->get_verifiedcollege_data($row['request_id'], $row['level_id'], $row['check_id']);
            $professional_details = $this->vm->get_verifiedprofessional_data($row['request_id'], $row['level_id'], $row['check_id']);

            $verified_data=$this->vm->get_verified_data($row['request_id'],$row['level_id'],$row['check_id']);

            $verification_data=toArray(json_decode($verified_data['fielddata']));
            $qc2verification_data=toArray(json_decode($verified_data['qc2fielddata']));
            $status1=$this->vm->get_status($qc2verification_data['status']);
            $status3=$this->vm->get_status($qc2verification_data['status1']);

            if($verification_data['status']!=107 && $verification_data['status']!=684 && $verification_data['status']!=992 && !empty($verification_data['status'])) {
               if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                  $rpt_status="RED";
               }
               else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Partial Match"){
                  $rpt_status="ORANGE";
               }
               else 
               {
                  $rpt_status="GREEN";
               }
            }

            if($row['check_id']==14){
               $clgname=$education_details['collegename_add'];
               $uniname=$education_details['affliated']; 
            }else{
               $clgname='';
               $uniname='';
            }
            
         
            if($row['checkid']==59){
               $cmpnyname=$company_details['company_name'];
            }else if($row['checkid']==68){
               $cmpnyname=$professional_details['company_name'];
            }else{
               $cmpnyname='';
            }

            if($row['count_of_chk'] > 0){
               $chkcount=$row['count_of_chk'];
            }else{
               $chkcount='';
            }

            $veri_received = $verification_data['veri_received_dropdown'];
       
            if($veri_received == 1){
               $verification_received  = "Received";
            }
            elseif($veri_received == 2)
            {
               $verification_received  = "Not received";
            }
            else
            {
               $verification_received = '';
            }
            
            $verification_from = $verification_data['verification_received'];
            if($verification_from == 'College'){
               $verify_from = 'College';
            }
            elseif($verification_from == 'University'){
               $verify_from = 'University';
            }          
            else
            {
               $verify_from = '';
            }

            $dd_recived =    $verification_data['dd_recevied_form'];
                   
               
            if($dd_recived == 1){
              $dd_status = 'University';
            }
            elseif($dd_recived == 2){
              $dd_status = 'College';
            }
            elseif($dd_recived == 3){
               $dd_status = 'Company';
            }
            elseif($dd_recived == 4){
               $dd_status = 'University and College';
            }
            else
            {
               $dd_status = '';
            }

            switch($row['payment_mode']){
               case 22:
                  $payRefNo=$row['chln_ref_number'];
                  break;
               case 23:
                  $payRefNo=$row['cr_transaction_no'];
                  break;
               case 24:
                  $payRefNo=$row['dd_txn_no'];
                  break;
               case 25:
                  $payRefNo=$row['neft_reference_no'];
                  break;
               case 26:
                  $payRefNo=$row['op_transaction_no'];
                  break;
               default:
                  $payRefNo='';
                  break;
            }

            $v_date=isset($row['v_date'])?date('d-m-Y',strtotime($row['v_date'])):''; 
            $f_date = isset($row['final_report_published_date']) ? date('d-m-Y', strtotime($row['final_report_published_date'])) : '';

            $sup_date = isset($row['supplement_report_date']) ? date('d-m-Y', strtotime($row['supplement_report_date'])) : '';
            $pay_date = isset($row['requested_date']) ? date('d-m-Y', strtotime($row['requested_date'])) : '';
                   
            $objPHPExcel->getActiveSheet()->getStyle('A1:AA1')->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                                  ->setCellValue('B' . $ci, $row['org_name'])
                                  ->setCellValue('C' . $ci, $row['parent_office'])
                                  ->setCellValue('D' . $ci, $row['office_name'])
                                  ->setCellValue('E' . $ci, $row['sub_office'])
                                  ->setCellValue('F' . $ci, $row['candidate_name'])
                                  ->setCellValue('G' . $ci, $row['case_no'])
                                  ->setCellValue('H' . $ci, $row['check_name'].$chkcount)
                                  ->setCellValue('I' . $ci, $rpt_status)
                                  ->setCellValue('J' . $ci, $cmpnyname)
                                  ->setCellValue('K' . $ci, $clgname)
                                  ->setCellValue('L' . $ci, $uniname)
                                  ->setCellValue('M' . $ci, $verification_received)
                                  ->setCellValue('N' . $ci, $verify_from)
                                  ->setCellValue('O' . $ci, $dd_status)
                                  ->setCellValue('P' . $ci, $row['pm_name'])
                                  ->setCellValue('Q' . $ci, $row['amount'])
                                  ->setCellValue('R' . $ci, $row['paymode'])
                                  ->setCellValue('S' . $ci, $payRefNo)
                                  ->setCellValue('T' . $ci, $pay_date)
                                  ->setCellValue('U' . $ci, $row['payto'])
                                  ->setCellValue('V' . $ci, '')
                                  ->setCellValue('W' . $ci, '')
                                  ->setCellValue('X' . $ci, $v_date)
                                  ->setCellValue('Y' . $ci, $f_date)
                                  ->setCellValue('Z' . $ci, $sup_date)
                                  ->setCellValue('AA' . $ci, $row['requested_by']);
                                
            $ci++;
         }
         
         if(!empty($case_number) && count($case_no) == 1)
         {
            $this->export_excel('A','AA','Reimbursement_PR_List_'.trim($case_number) . '_',$objPHPExcel);
         }
         else
         {
            $this->export_excel('A','AA','Reimbursement_PR_List_',$objPHPExcel);
         } 
         exit; 
      }
         redirect('Billing/reimbursement_pr');
   } //  end of export_reimbursement_pr





}