 <?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require_once('Common.php');
require_once ('./PHPExcel-1.8/Classes/PHPExcel.php');
class Client extends Common {
    protected static $client_model = 'Client_model';
    protected $index_dashboard = 'Index/dashboard';
    protected $client_cli_search = 'Client/clientsearch';
    protected $client_clientofflinesearch = 'Client/clientofflinesearch/';
    protected $client_caselist = 'Client/client_caselist';
    protected $role_id_text = 'role_id';
    protected $userid_text = 'userid';
    protected $request_orgid ='org_id';
    protected $request_office ='office';
    protected $request_parent_office ='parent_office';
    protected $request_sub_office ='sub_office';
    protected $request_raisedlist = 'Client/request_raisedlist';
  
    function __construct() 
    {
        parent::__construct();
        $this->_check_userlogin ();
    $models = array(self::$client_model => 'cm','Dadmin_model' => 'dm','Management_model' => 'mm','Verification_model'=>'vm','Reports_model'=>'rm');
    foreach ($models as $file => $object_name) {
        $this->load->model($file, $object_name);
    }
    $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
    $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','jquery-ui-1.10.4','highcharts','exporting','jquery.validate','grid.locale-en','jquery.jqGrid.min','jquery-ui-1.8.16.custom.min','commonjs','jquery.datepick','multipleclone'));
    $this->load->helper('text');
    $this->load->helper('cloneform');
    $this->load->helper('security');
    }
    /********************************
     * candidate list view page  
     * clientsearch
     *******************************/
    function clientsearch() { 
        $roleid=$this->session->userdata($this->role_id_text); 
        if($roleid==16) {
            $userid=$this->session->userdata($this->userid_text);
            $data['casedetails']= $this->cm->get_case($userid);
            $check= $this->cm->check_submission_new($userid);
            if($check['cnt']==0)
            {
                redirect('Client/profilerequest');
            }
        }
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Profile Submission', $this->client_cli_search);
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'new_requirement');
    }
/*****************
* Listing candidate users
*  get_users
 ******************/
    function get_users( $usertype_id = '' ){ 
        $model = array(self::$client_model=>'get_candidate_onlinelist');
        $userType =  $this->session->userdata['userType'];
        $role_id =  $this->session->userdata[$this->role_id_text];
        $org_id = ($_REQUEST[$this->request_orgid]) ? $_REQUEST[$this->request_orgid] : '';
        $office = ($_REQUEST[$this->request_office]) ? $_REQUEST[$this->request_office] : '';
        $parent_office = ($_REQUEST[$this->request_parent_office]) ? $_REQUEST[$this->request_parent_office] : '';
        $sub_office = ($_REQUEST[$this->request_sub_office]) ? $_REQUEST[$this->request_sub_office] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
        $client_ref_number=($_REQUEST['client_ref_number']) ? $_REQUEST['client_ref_number'] : '';
        $case_number=($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
        $case_status=($_REQUEST['case_status']) ? $_REQUEST['case_status'] : '';
        $from_date=($_REQUEST['from_date']) ? $_REQUEST['from_date'] : '';
        $to_date=($_REQUEST['to_date']) ? $_REQUEST['to_date'] : '';
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';

        if($org_id){
            $condition[]=" a.organization = ".$org_id;
        }
        if($parent_office){
            $condition[]=" a.parent_office = ".$parent_office;
        }
        if($office){
            $condition[]=" a.office_id = ".$office;
        }
        if($sub_office){
            $condition[]=" a.sub_office = ".$sub_office;
        }
        if($name){
            $condition[]=" ( a.first_name like '%".$name."%' OR  a.last_name like '%".$name."%') ";
        }
        if($client_ref_number){
            $condition[]=" h.client_ref_number like '%".$client_ref_number."%'";
        }
        //22/01/2023
        $case_number = trim($case_number);
        if($case_number){
            $condition[]=" h.case_no like '%".$case_number."'";
        }
        if($case_status ==1){
        $condition[]="(h.dataentry_by NOT IN(0,3) && h.assignee_id=0 && h.assainee_status=0 && h.entry_status=0 && cv.client_status is NULL )";
        }
        if($case_status ==2 ){
        $condition[]="(h.dataentry_by=0 && cv.client_status is NULL)";
        }
        if($case_status ==3 ){
        $condition[]="(h.dataentry_by=0 && cv.status=1 && h.entry_status=0 && cv.client_status=0  )";
        }
        if($case_status ==4){
        $condition[]="((cv.client_status=1 && (cv.operator_status=1 || cv.operator_status=0) && cv.verification_status=0 && h.revert_status=0 && cv.reverted_by=0))";
        }
        if($case_status ==5 ){
        $condition[]="(cv.verification_status=1 && h.final_report=0 )";
        }
        if($case_status ==6){
        $condition[]="(cv.verification_status=1 && h.final_report=1 )";
        }
        if($case_status ==7){
        $condition[]="(cv.reverted_by!=0)";
        }
        if($case_status ==8){
        $condition[]="( cv.status=0 && h.dataentry_by=0 && cv.candidate_status=0 && cv.client_verified=2)";
        }
        if($case_status ==9){
        $condition[]="( cv.status=1 && h.dataentry_by=0 && cv.candidate_status=0 && cv.client_verified=3)";
        } 
        if($caseStatus=='submited_case'){
        $condition[]="((cv.client_status=1 && (cv.operator_status=1 || cv.operator_status=0) && cv.verification_status=0 && h.revert_status=0 && cv.reverted_by=0)) && (DATE_FORMAT(h.created_on, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 1 MONTH) AND CURRENT_DATE())";
        }
         
        if(!empty($from_date)){
        $condition[]=" ((DATE_FORMAT(h.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."') OR (DATE_FORMAT(h.final_report_published_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."'))";
        }
        if(!empty($to_date)){
        $condition[]=" ((DATE_FORMAT(h.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."') OR (DATE_FORMAT(h.final_report_published_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."'))";
        }
            if($term)
            {
            $search = explode(' ', $term);
            foreach($search as $t) {
            $not        = '';
            $operator    = 'OR';
            if(substr($t,0,1) == '-')
            {
                $not        = 'NOT ';
                $operator    = 'AND';
                $t        = substr($t,1,strlen($t));
            }
            $like    = '';
            $like    .= "( e.role_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." a.first_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." a.middle_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." a.last_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." h.client_ref_number ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." h.case_no ".$not."LIKE '%".$t."%' " ;

            $like    .= $operator." d.name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." a.username ".$not."LIKE '%".$t."%' " ;

            $like    .= $operator." g.office_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." h.check_status ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." f.org_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." r.office_name ".$not."LIKE '%".$t."%' ) " ;
            $condition[]=$like;
            }
        }
        $manual_cond=implode(' and ',$condition); 
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows;
        foreach ( $result as $i => $row ) {
            $checkstatus = $this->cm->get_currentstatus($row['request_id']);
            if($role_id==16){
                if($checkstatus['verification_status']==1 && $checkstatus['team_mem_id'] ==''){
                    $status='WIP';
                }
                else if($checkstatus['verification_status']==1 && $checkstatus['team_mem_id'] <>''){
                    $status='WIP';
                }
                else if($checkstatus['verification_status']==0 && $checkstatus['operator_status']==1 && $checkstatus['assignee_id']<>0){
                    $status='Submitted to Client';
                }
                else if($checkstatus['client_status']==1 && $checkstatus['operator_status']==0 && $checkstatus['assignee_id']<>0){
                    $status='Submitted to Client';
                }
                else if($checkstatus['client_status']==1 && $checkstatus['operator_status']==1 && $checkstatus['assignee_id']==0  && $checkstatus['reverted_by']==0){
                    $status='Submitted to Client';
                }
                else if(!empty($checkstatus['reason']) && $checkstatus['status']==0){
                    $status='Revert assigned';
                }
                else if(!empty($checkstatus['reason']) && $checkstatus['status']==1){
                    $status='Revert Rectified';
                }
                else if($checkstatus['status']==1){
                    $status='ID log out';
                }
                else {
                    $status = 'Profile Submission'; 
                }
            } 
            else if($checkstatus['verification_status']==1 && $checkstatus['team_mem_id'] ==''){
            $status='WIP';
            } 
            else if($checkstatus['verification_status']==1 && $checkstatus['team_mem_id'] <>''){
                $status='WIP';
            }
            else if($checkstatus['verification_status']==0 && $checkstatus['operator_status']==1 && $checkstatus['assignee_id']<>0){
                $status='Submitted to Dcode';
            }
            else if($checkstatus['client_status']==1 && $checkstatus['operator_status']==0 && $checkstatus['assignee_id']<>0){
                $status='Submitted to Dcode';
            }
            else if(($role_id==12 || $role_id==13 || $role_id==14) && !empty($checkstatus['reverted_reason']) && $checkstatus['reverted_by']!=0 && $checkstatus['status']==1){
                $status='Reject Assigned';
            }
            else if($checkstatus['client_status']==1 && $checkstatus['operator_status']==1 && $checkstatus['assignee_id']==0 && $checkstatus['reverted_by']==0 && !empty($checkstatus['reverted_reason'])){
                $status='Reject Rectified';
            }
            else if($checkstatus['client_status']==1 && $checkstatus['operator_status']==1 && $checkstatus['assignee_id']==0 && $checkstatus['reverted_by']==0){
                $status='Submitted to Dcode';
            }
            else if(!empty($checkstatus['reason']) && $checkstatus['status']==0){
                $status='Revert Raised';
            }
            else if(!empty($checkstatus['reason']) && $checkstatus['status']==1){
                $status='Revert Closed';
            }
            else if($checkstatus['status']==1){
                $status='Candidate Profile Submitted';
            }
            else {
                $status = 'Pending';
            }
            if($row['final_report']==1){
                $status='Report Published';
            } 

            if($checkstatus['status']==1){
                $download=anchor('/Dadmin/genPdf/'.base64_encode($row['request_id']),'Forms', "style='color:#08c;'").' / '.anchor('/Dadmin/exportdoc_pdf/'.base64_encode($row['request_id']),'Docs', "style='color:#08c;'");
            }else{
                $download='';
            }  
            $profilestatus= $this->getprofilestatus($row['request_id']);
            $created_date=isset($row['created_on']) ? date('d-m-Y',strtotime($row['created_on'])):'';
            $final_report_published_date=isset($row['final_report_published_date']) ? date('d-m-Y',strtotime($row['final_report_published_date'])):'';
            if($userType==2 && $role_id==16)
            {
            $response->rows [] ['cell'] = array ( $i+$count+1,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['name']),$status,$profilestatus,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'));
            }
            else{
            $response->rows [] ['cell'] = array ( $i+$count+1,$row['org_name'],$row[$this->request_parent_office],$row['office_name'],$row[$this->request_sub_office],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['name']),$row['case_no'],$row['client_ref_number'],$status,$profilestatus,$created_date,$final_report_published_date,$download,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'));
            }
        }
        }
        echo json_encode($response);
    }
    /*****************
 * candidate delete option
 * delete_option
 ******************/
    function delete_option(){
        $id = base64_decode($this->uri->segment(3));    
        $sql =$this->db->query( 'delete from '.DB_PREFIX .'user where id = "' . $id . '"');
        redirect('Client/clientsearch/'. base64_encode($id));
    }
    /*****************
   *  assigning newrequest to DEO
   * newrequest
 ******************/
    function newrequest($userid = '') {
        $user_id = base64_decode($userid);
        $result = $this->cm->get_organisation_checks($user_id);  
        $data ['checks_det'] = $result [0];
        $data['order_result'] = $this->cm->get_order_details($user_id); 
        $data ['title'] = 'New Request'; 
        $this->amodel->pagerender($data, 'new_request');
    }
/*****************
 *  getorderlist in order
 * getorderlist
 ******************/
    function getorderlist(){       
            $order_id = $this->uri->segment(3);
            $order_details = $this->cm->orderdetails($order_id);
            $table = '<table border="1">';
            if($order_details){
            $table .= "<tr class='s-usebrd' height='35'><td colspan='4'><h3>Checks and Levels</h3></td></tr>";
            $table .= "<tr class='at_tr' height='35'>
            <th class='at_th'>Check Name</th>
            <th class='at_th'>Level</th>
            <th class='at_th'>Charges per checks @ Rs</th>
            <th class='at_th'>Max Attempts</th>
            </tr>";
            foreach($order_details as $key => $value ) {
                $check_details = $this->cm->get_order_checks($value['types_of_check'],$order_id);
                foreach($check_details as $orderkey => $ordervalue){
                $table .= "<tr class='at_tr' height='35'>";
                $table .= "<td  class='at_td'><input type='checkbox' name = 'level_id[]' value = '".$ordervalue['check_id']."' />".ucwords($value['checks'])."</td>";
                $table .= "<td  class='at_td'>".ucwords($ordervalue['level'])."</td>";
                $table .= "<td  class='at_td'>".ucwords($ordervalue['charges_percheck'])."</td>";
                $table .= "<td  class='at_td'>".ucwords($ordervalue['max_attempt'])."</td>";
                $table .= "</tr>";
                } 
            }
                $table .= "<tr class='s-usebrd' height='35'><td colspan='4'><input class='button' style='float:right;' type='submit' value='Submit'></td></tr>";
            } else {
                $table .= "<tr class='at_tr' height='35'>
                <th class='at_th' colspan='4'> No Checks and Levels Available </th>
                </tr>";
            }
            echo $table .= "</table>";
        }
    /*****************
    * updation order in client case
    * p_newrequest
    ******************/
    function p_newrequest() {
        $order_id = $this->input->post ( 'order_id' );
        $user_id = $this->input->post ( 'user_id' );
        $deadline_from = $this->input->post ( 'date_from' );
        $deadline_to = $this->input->post ( 'date_to' );
        $order_details = $this->cm->orderdetails1($order_id);
        $request_id = base64_decode($this->uri->segment(3)); 
        $check_requestexist = "";
        if($_POST){ 
            $this->db->where ( 'user_id',$request_id );
            $check_requestexist = $this->db->get ( DB_PREFIX .'client_request' )->row();
            $this->db->where ( 'id',$request_id );
            $candidate_det = $this->db->get(DB_PREFIX .'user')->row(); 
            if($check_requestexist){  
            $client_data = array();
            $client_data['user_id'] = $user_id;
            $client_data[$this->request_office] = $candidate_det->office_id;
            $client_data['order_id'] = $order_id;
            $client_data['deadline_from'] = ($deadline_from) ? date("Y-m-d", strtotime($deadline_from)) : '';
            $client_data['deadline_to'] = ($deadline_to) ? date("Y-m-d", strtotime($deadline_to)) : '';
            $client_data['created_on'] = date ( 'Y-m-d H:i:s' );
            $client_data['check_status'] = 1;
            $client_data['created_by'] = $this->user_id;
            $this->db->where('user_id',$user_id);
            $this->db->update ( DB_PREFIX .'client_request', $client_data );
            $client_request_id = $this->amodel->getDetails('dcode_client_request',array('request_id'),array('user_id'=>$user_id));
        }
        $levels = $_POST['level_id'];
        if($client_request_id)  {
            $sql = $this->db->query ( 'delete from '.DB_PREFIX .'profile_level_status where client_request_id = "' . $client_request_id[0]['request_id'] . '"');
            foreach($levels as $key => $value ) {
                $ins_data = array();
                $ins_data['client_request_id'] = $client_request_id[0]['request_id'];
                $ins_data['check_level_id'] = $levels[$key];
                $ins_data['level_status'] = 1;
                $ins_data['created_on'] = date ( 'Y-m-d H:i:s' );
                $ins_data['created_by'] = $this->user_id;
                $this->db->insert ( DB_PREFIX .'profile_level_status', $ins_data );
            }
        }
        $data['first_name']=$candidate_det->first_name;
        $data['order_details']=$order_details;
        $this->send_email_common('order_details','Order Details', @$candidate_det->email, $data);
        }
        redirect ( base_url($this->client_cli_search), 'refresh' );
    }
    /*****************
    * candidate offline entry and allotment to operator
    * clientofflinesearch
    ******************/
    function clientofflinesearch() {   
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Data Entry', $this->client_clientofflinesearch);
        $data['breadcrumb']=$this->breadcrumbs->show();  
        $assignee_list = $this->dm->get_assignee_list();   
        $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list,array('assignee_id','name'));
        $this->amodel->pagerender($data, 'offline');
    }
     /*****************
    * get the candidates from partial,full or offline entry
    * get_offlineusers
    ******************/
    function get_offlineusers($dataentry_by =null,$office_id = 0 ){  
        $dataentry_by = ($_REQUEST['dataentry_by']) ? $_REQUEST['dataentry_by'] : '';
        if($dataentry_by == 1){
            $model = array(self::$client_model=>'get_userlistoff_partial');
        }
        if($dataentry_by == 2){
            $model = array(self::$client_model=>'get_userlistoff_full');
        }
        if($dataentry_by == 3) {
            $model = array(self::$client_model=>'get_userlistoff'); 
        }
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $created_on = ($_REQUEST['created_on']) ? $_REQUEST['created_on'] : '';
        $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : ''; 
        $createdby = ($_REQUEST['createdby']) ? $_REQUEST['createdby'] : ''; 
        $org_id = ($_REQUEST[$this->request_orgid]) ? $_REQUEST[$this->request_orgid] : '';
        $office = ($_REQUEST[$this->request_office]) ? $_REQUEST[$this->request_office] : '';
        $parent_office = ($_REQUEST[$this->request_parent_office]) ? $_REQUEST[$this->request_parent_office] : '';
        $sub_office = ($_REQUEST[$this->request_sub_office]) ? $_REQUEST[$this->request_sub_office] : '';
        $client_ref_number=($_REQUEST['client_ref_number']) ? $_REQUEST['client_ref_number'] : '';
        $case_number=($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $date_filter=($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
        $billing_type=($_REQUEST['billing_type']) ? $_REQUEST['billing_type'] : '';
        $aadhaar_number=($_REQUEST['aadhaar_number']) ? $_REQUEST['aadhaar_number'] : '';
        if($parent_office){
            $condition[]=" d.id = ".$parent_office;
        }
        if($office){
            $condition[]=" b.id = ".$office;
        }
        if($org_id){
            $condition[]=" c.id = ".$org_id;
        }
        if($sub_office){
            $condition[]=" o.id = ".$sub_office;
        }
        if($office){
            $condition[]=" b.id = ".$office;
        }
        if($name){
            $condition[]=" a.candidate_name like '%".$name."%'";
        }
        if($client_ref_number){
            $condition[]=" a.client_ref_number like '%".$client_ref_number."%'";
        }
        //23/01/2024
        $case_number = trim($case_number);
        if($case_number){
            $condition[]=" a.case_no like '%".$case_number."%'";
        }
        if($createdby){
            $condition[]=" f.first_name like '%".$createdby."%'";
        }
        if($created_on){
            $condition[]=" DATE_FORMAT(a.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($created_on))."'";
        }
        if(!empty($c_date) && $date_filter==1){
            $condition[]=" DATE_FORMAT(a.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date) && $date_filter==1){
            $condition[]=" DATE_FORMAT(a.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        if(!empty($c_date) && $date_filter==2){
            $condition[]=" DATE_FORMAT(a.case_recieved_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date) && $date_filter==2){
            $condition[]=" DATE_FORMAT(a.case_recieved_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        if($a_status==1){
            $condition[]=" a.assainee_status =1" ;
        }
        if($a_status==2){
            $condition[]=" a.assainee_status !=1" ;
        }
        if($billing_type==1){
            $condition[]=" a.case_no like '%PR%'";
        }
        if($billing_type==2){
            $condition[]=" a.case_no like '%PO%'";
        }
        if($aadhaar_number){
            $condition[]=" a.aadhaar_number =".$aadhaar_number;
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];  
        $result = $results[1]; 
        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows;
        foreach ( $result as $i => $row ) {
            $checkstatus = $this->cm->get_currentstatus($row['request_id']);
            if($checkstatus['verification_status']==1 && $checkstatus['team_mem_id'] =='' && $row['dataentry_by']<>3){
                $status='WIP';
            }
            else if($checkstatus['verification_status']==1 && $checkstatus['team_mem_id'] <>'' && $checkstatus['vm_revert_to']==0 && $checkstatus['vm_revert_option_status']!=2 && $checkstatus['vm_revert_option_status']!=4 && $row['dataentry_by']<>3){
                $status='WIP';
            }
            else if($checkstatus['verification_status']==0 && $checkstatus['operator_status']==1 && $checkstatus['vm_revert_option_status']==0 && $row['dataentry_by']<>3){
                $status='Submitted to Dcode';
            }
            else if($checkstatus['verification_status']==0 && $checkstatus['operator_status']==2){
                $status='Revert';
            }
            else if($checkstatus['revert_status']==0 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus[$this->role_id_text]==13 && $checkstatus['assainee_status']==0){
                $status='Revert Closed';
            }
            else if($checkstatus['revert_status']==1 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus[$this->role_id_text]==13){
                $status='Revert Assigned';
            }
            else if($checkstatus['revert_status']==0 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus[$this->role_id_text]==12 && $checkstatus['assainee_status']==0){
                $status='Revert Closed';
            }
            else if($checkstatus['revert_status']==1 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus[$this->role_id_text]==12){
                $status='Revert Assigned';
            }
            else if($checkstatus['reverted_by']==0 && !empty($checkstatus['reverted_reason']) && $checkstatus['assainee_status']==1 && $row['dataentry_by']<>3){
                $status='Submitted to Dcode';
            }
            else if($checkstatus['reverted_by']!=0 && !empty($checkstatus['reverted_reason'])){
                $status='Reject Assigned';
            }
            else if($checkstatus['reverted_by']==0 && !empty($checkstatus['reverted_reason'])){
                $status='Reject Rectified';
            }
            else if($checkstatus['vm_revert_to']==3 && $checkstatus['vm_revert_by']==5 && $checkstatus['vm_revert_supervisor']==1){
                $status='Revert Assigned';
            }
            else if($checkstatus['vm_revert_option_status']==2){
                $status='Revert Assigned';
            }
            else if($checkstatus['vm_revert_option_status']==4){
                $status='Revert Closed';
            }
            else if($checkstatus['operator_status']==0 && $checkstatus['revert_status']==2){
                $status='Revert Admin';
            }
            else if($checkstatus['client_status']==1 && $checkstatus['revert_status']==1 && $row['dataentry_by']<>3){
                $status='Submitted to Dcode';
            }
            else if($checkstatus['client_status']==1 && $checkstatus['operator_status']==0 && ($checkstatus['assignee_id']==0 || $checkstatus['assignee_id']<>0)&& $row['dataentry_by']<>3){
                $status='Submitted to Dcode';
            }
            else if($checkstatus['client_status']==1 && $checkstatus['operator_status']==0 && $checkstatus['assignee_id']<>0 && $row['dataentry_by']==3){
                $status='Allotted to DEO';
            }
            else if($checkstatus['client_status']==1 && $checkstatus['operator_status']==0 && $checkstatus['assignee_id']==0 && $row['dataentry_by']==3){
                $status='Allotted to DES';
            }
            else{
                $status = 'New';
            }
            $request_status = 'New';
            if($row['assainee_status']==1){
                $request_status = 'Assigned';
            }
            else if($row['dataentry_by']==1){
                $request_status= 'New';
                if($status=='Submitted to Dcode'){
                    $request_status= 'Assigned';
                }
                else if($status=='Allotted to DES'){
                    $request_status= 'Assigned';
                }
                else if($status=='Revert Closed'){
                    $request_status= 'Assigned';
                }
                else{
                    $request_status = anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'New');
                }
            } 
            else if($row['dataentry_by']==2){
                if($status=='Revert Closed'){
                    $request_status= 'Assigned';
                }
            }
            else {
            if($this->session->userdata['user_type'] == 2 ) {
                $request_status= anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'New');
                if($status=='Allotted to DES'){
                    $request_status= 'Assigned';
                }
                else{
                    $request_status= anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'New');
                }
            }
            else{
                if($status=='Revert DES'){
                $request_status= anchor('/Dadmin/newrevertrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Revert Raised');  
                }
                else{
                    $request_status= anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'New');
                }
            }
            }
            if($status=='Revert Assigned' && $row['dataentry_by']==3){
            $request_status= anchor('/Dadmin/newsupervisorrevertrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Revert Raised');  
            }
            if($status=='Revert Assigned' && $row['dataentry_by']==1 || $status=='Revert Assigned' && $row['dataentry_by']==2){
            $request_status= anchor('/Dadmin/newcadminrevertrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Revert Raised');  
            }
            if($status=='Reject Assigned'){
            $request_status= anchor('/Dadmin/newcadminrejectrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Reject');  
            }
            if($status=='Reject Rectified'){
            $request_status= 'Assigned';  
            }
            $type='';
            if($row['dataentry_by']==1){
                $type='Partial Entry';
            }
            else if($row['dataentry_by']==2){
                $type='Full Entry';
            }
            else if($row['dataentry_by']==3){
                $type='Offline Entry';
            }
            if($status=='Revert to DES' && $row['revert_status']==1 && $row['assainee_status']==1){
                $request_status= 'Assigned';
            }
            else if($row['revert_status']==1 && $row['assainee_status']==1){
                $request_status= 'Revert Closed';
            }
            if($row['dataentry_by']==1 && $status=='New'){
                $assign=(anchor('/Client/partial/'.base64_encode($row['request_id']),'submit').'/ '.anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),"Edit"));
            }
            else if($row['dataentry_by']==2){
                $assign=anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),"View");
            }
            else {
                $assign=anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),"View");
            }
            if($row['created_on']){
                $created_on=date('d-m-Y',strtotime($row['created_on']));
            }
            $case_recieved_date='';
            if(!empty($row['case_recieved_date']) && $row['case_recieved_date']!="0000-00-00"){
                $case_recieved_date=date('d-m-Y ',strtotime($row['case_recieved_date']));
            }
            if($row['final_report']==1 && $row['dataentry_by']<>3)
            {
                $status='Report Published';
            }    
            if($row['dataentry_by'] == 3){ 
            if($row['assainee_status']==1){
            $check=$i+$count+1;
            }else{
            $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id']).'" />';
            }
            
            $response->rows [$i] ['cell'] = array ($check ,$row['org_name'],$row[$this->request_parent_office],$row['office_name'],$row[$this->request_sub_office],$row['candidate_name'],$row['case_no'],$row['client_ref_number'],$request_status,$type,$status,$row['first_name'],$case_recieved_date, $created_on,$assign); 

            }
            else if($row['dataentry_by']==2){
                $response->rows [$i] ['cell'] = array ( $i+$count+1, $row['org_name'],$row[$this->request_parent_office],$row['office_name'],$row[$this->request_sub_office],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'],$row['client_ref_number'],$row['aadhaar_number'],$request_status,$type,$status,$row['first_name'], $created_on,$assign); 
            }
            else{
              $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row[$this->request_parent_office],$row['office_name'],$row[$this->request_sub_office],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'],$row['client_ref_number'],$request_status,$type,$status,$row['first_name'], $created_on,$assign);   
            }
            }
        }
        echo json_encode($response);
        }
    /*****************
    * client case list page
    * client_caselist
    ******************/
    function client_caselist() { 
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Data Entry', $this->client_caselist);
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'client_caselist');
    }
      /*****************
    * client case listing of records ,status and reports 
    * get_caselist
    ******************/ 
    function get_caselist($office_id = 0 ){    
 
        $model = array('client_model'=>'get_caselist');
        $dataentry = ($_REQUEST['dataentry']) ? $_REQUEST['dataentry'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $date_filter = ($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
        $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : ''; 
        $createdby = ($_REQUEST['createdby']) ? $_REQUEST['createdby'] : ''; 
        $org_id = ($_REQUEST[$this->request_orgid]) ? $_REQUEST[$this->request_orgid] : '';
        $office = ($_REQUEST[$this->request_office]) ? $_REQUEST[$this->request_office] : '';
        $parent_office = ($_REQUEST[$this->request_parent_office]) ? $_REQUEST[$this->request_parent_office] : '';
        $sub_office = ($_REQUEST[$this->request_sub_office]) ? $_REQUEST[$this->request_sub_office] : '';
        $client_ref_number=($_REQUEST['client_ref_number']) ? $_REQUEST['client_ref_number'] : '';
        $case_number=($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $interim=($_REQUEST['interim']) ? $_REQUEST['interim'] : '';
        $rpstatus=($_REQUEST['rpstatus']) ? $_REQUEST['rpstatus'] : ''; 
        $case_status=($_REQUEST['case_status']) ? $_REQUEST['case_status'] : '';
        $frp_fdate=($_REQUEST['fp_fdate']) ? $_REQUEST['fp_fdate'] : '';
        $frp_tdate=($_REQUEST['fp_tdate']) ? $_REQUEST['fp_tdate'] : '';
        $reopen_status=($_REQUEST['reopen_status']) ? $_REQUEST['reopen_status'] : '';
        $typeofemp=($_REQUEST['typeofemp']) ? $_REQUEST['typeofemp'] : '';
        $payment_status =($_REQUEST['payment_status']) ? $_REQUEST['payment_status'] : '';

        $caseStatus = ($_REQUEST['caseStatus']) ? $_REQUEST['caseStatus'] : '';
        $fromDate = ($_REQUEST['fromDate']) ? $_REQUEST['fromDate'] : '';
        $toDate = ($_REQUEST['toDate']) ? $_REQUEST['toDate'] : '';
         //20/02/2023
        //print_r($_POST['email']);exit;
         $email = ($_REQUEST['email']) ? $_REQUEST['email'] : '';   
       
        if($dataentry !=0 && $dataentry !=4 ){
            $condition[]=" a.dataentry_by = ".$dataentry;
        }
        if($dataentry ==4){
            $condition[]=" a.dataentry_by = 0";
        }
        if($parent_office){
            $condition[]=" d.id = ".$parent_office;
        }
        if($office){
            $condition[]=" b.id = ".$office;
        }
        if($org_id){
            $condition[]=" c.id = ".$org_id;
        }
        if($sub_office){
            $condition[]=" o.id = ".$sub_office;
        }
        if($name){
            $condition[]=" a.candidate_name like '%".$name."%'";
        }
       if($createdby){
            $condition[]=" (concat_ws(' ',f.first_name,f.last_name) like '%".$createdby."%') ";
       }
        if($client_ref_number){
            $condition[]=" a.client_ref_number like '%".$client_ref_number."%'";
        }
        if($interim ==1){
            $condition[]=" ar.qc2_report_publish = 1 and ar.qc2_verification=1 ";
        }
        if($interim ==2){
            $condition[]=" ar.qc2_report_publish = 1 and a.final_report=1 ";
        }
        if($interim ==3){
            $condition[]=" ca.request_id IS NOT NULL ";
        }
        if($interim ==4){
            $condition[]=" a.supplement_report = 1 ";
        }
        if($case_number){
            // edited by amritha on 23/06/2023 
            $case_number =trim($case_number);
            $condition[]=" a.case_no like '%".$case_number."'";
        }
        if($typeofemp){
            $condition[]=" t.type_of_employees like '%".$typeofemp."'";
        }
        if(!empty($c_date) && $date_filter==1){
            $condition[]="DATE_FORMAT(a.case_accepted_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and cv.client_status=1 and case when a.dataentry_by=3 Then DATE_FORMAT(a.case_recieved_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' else 1 end ";
        }
        if(!empty($t_date) && $date_filter==1){
            $condition[]="DATE_FORMAT(a.case_accepted_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and cv.client_status=1 and case when a.dataentry_by=3 Then DATE_FORMAT(a.case_recieved_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' else 1 end ";
        }
        if(!empty($c_date) && $date_filter==2){
            $condition[]="DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and a.final_report=1 ";
        }
        if(!empty($t_date) && $date_filter==2){
            $condition[]="DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and a.final_report=1 ";
        }
        if(!empty($c_date) && $date_filter==3){
            $condition[]="DATE_FORMAT(a.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date) && $date_filter==3){
            $condition[]="DATE_FORMAT(a.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        if(!empty($c_date) && $date_filter==4){
            $condition[]="DATE_FORMAT(cv.candidate_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and a.dataentry_by=0 ";
        }
        if(!empty($t_date) && $date_filter==4){
            $condition[]="DATE_FORMAT(cv.candidate_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and a.dataentry_by =0 ";
        }
        if(!empty($c_date) && $date_filter==5){
            $condition[]="DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and a.dataentry_by != 3 ";
        }
        if(!empty($t_date) && $date_filter==5){
            $condition[]="DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and a.dataentry_by != 3 ";
        }
        if(!empty($c_date) && $date_filter==6){
            $condition[]="DATE_FORMAT(cv.des_rejected_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date) && $date_filter==6){
            $condition[]="DATE_FORMAT(cv.des_rejected_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        if(!empty($c_date) && $date_filter==7){
            $condition[]="DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date) && $date_filter==7){
            $condition[]="DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
         if(!empty($c_date) && $date_filter==8){
            $condition[]="DATE_FORMAT(vl.qc2_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and ar.qc2_report_publish=1 ";
        }
        if(!empty($t_date) && $date_filter==8){
            $condition[]="DATE_FORMAT(vl.qc2_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and ar.qc2_report_publish=1 ";
        }
        if($a_status==1){
            $condition[]=" a.assainee_status =1" ;
        }
        if($a_status==2){
            $condition[]=" a.assainee_status !=1";
        }
        if( (empty($fromDate) || empty($toDate)) && $caseStatus =='accept_case'){
            $condition[]=" (a.assainee_status = 1 and cv.reverted_by=0) and DATE_FORMAT(cv.client_submit_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 2 WEEK) AND CURRENT_DATE()" ;
        }
        if( (!empty($fromDate) || !empty($toDate)) && ($caseStatus =='accept_case') ){
            
            $condition[]=" ((DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) and (a.assainee_status = 1 and cv.reverted_by=0)";
        }

        if( (empty($fromDate) || empty($toDate)) && $caseStatus =='reject_case'){
            $condition[]=" cv.reverted_by!=0 and (DATE_FORMAT(cv.des_rejected_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 2 WEEK) AND CURRENT_DATE())" ;
        }
        if( (!empty($fromDate) || !empty($toDate)) && $caseStatus =='reject_case' ){
            $condition[]=" ((DATE_FORMAT(cv.des_rejected_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(cv.des_rejected_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) and (cv.reverted_by!=0)";
        }

        if($rpstatus==1){
            $condition[]="a.report_status like '%RED%'";
        }
        if($rpstatus==2){
            $condition[]="a.report_status like '%ORANGE%'";
        }
        if($rpstatus==3){
            $condition[]="a.report_status like '%GREEN%'";
        }
        if($case_status ==1){
         $condition[]="(a.dataentry_by NOT IN(0,3) && a.assignee_id=0 && a.assainee_status=0 && a.entry_status=0 && cv.client_status is NULL )";
        }
        if($case_status ==2 || $caseStatus=='pending_cand'){
            $condition[]="(a.dataentry_by=0 && cv.client_status is NULL and t.status=1)";
        }
        if($case_status ==3 || $caseStatus=='profile_comp'){
        $condition[]="(a.dataentry_by=0 && cv.status=1 && a.entry_status=0 && cv.client_status=0 )";
        }
        if($case_status ==4 ){
        $condition[]="((cv.client_status=1 && (cv.operator_status=1 || cv.operator_status=0) && cv.verification_status=0 && (a.revert_status=0 || a.revert_status=3) && cv.reverted_by=0 && cv.client_verified=0))";
        }

        
        if($case_status ==5 || $caseStatus=='initiated'){
        $condition[]="(cv.verification_status=1 and a.final_report=0 and ar.qc2_report_publish = 0)";
        }
        if($case_status ==11){
        $condition[]="(ar.verify_status = 684 )";
        }
        if($case_status ==6){
        $condition[]="(cv.verification_status=1 and a.final_report=1 )";
        }
        if($case_status ==7){
        $condition[]="(cv.reverted_by!=0)";
        }

        if($case_status ==8){
        $condition[]="( cv.status=0 && a.dataentry_by=0 && cv.candidate_status=0 && cv.client_verified=2)";
        }
        if($case_status ==9){
        $condition[]="( cv.status=1 && a.dataentry_by=0 && cv.candidate_status=0 && cv.client_verified=3)";
        }
        if($case_status ==10){
            $condition[]=" ( a.dataentry_by=0 and cv.client_status is NULL and t.status=0 ) ";
        }
        if($case_status ==12){
            $condition[]=" ( a.dataentry_by=0 and t.status=2 ) ";
        } 
        if($reopen_status==1 || $caseStatus=='reopen_pending'){
            $condition[]=" a.supplement_report=2 ";
        }   
        if($reopen_status==2){
            $condition[]=" a.supplement_report=1 ";
        } 
        if($payment_status){
            $condition[]="a.payment_status=".$payment_status;
        }

        if( (empty($fromDate) || empty($toDate)) && $caseStatus=='submited_dcode'){
        $condition[]=" (a.assainee_status = 1 and (cv.reverted_by=0 or cv.reverted_by!=0)) and DATE_FORMAT(cv.client_submit_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 1 MONTH) AND CURRENT_DATE()" ;
        }

        if( (!empty($fromDate) || !empty($toDate)) && $caseStatus=='submited_dcode'){
        $condition[]=" ((DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) and (a.assainee_status = 1 and (cv.reverted_by=0 or cv.reverted_by!=0)) ";
        }
        if( (empty($fromDate) || empty($toDate)) && $caseStatus=='fGreen'){
            $condition[]="(ar.qc2_report_publish = 1 and a.final_report=1 and a.report_status like '%GREEN%') and (DATE_FORMAT(a.final_report_published_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 2 WEEK) AND CURRENT_DATE())";
        }
        if( (!empty($fromDate) || !empty($toDate)) && $caseStatus=='fGreen'){
            $condition[]=" (ar.qc2_report_publish = 1 and a.final_report=1 and a.report_status like '%GREEN%') and ((DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) ";
        }

        if( (empty($fromDate) || empty($toDate)) && $caseStatus=='fOrange'){
            $condition[]="(ar.qc2_report_publish = 1 and a.final_report=1 and a.report_status like '%ORANGE%') and (DATE_FORMAT(a.final_report_published_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 2 WEEK) AND CURRENT_DATE())";
        }
        if( (!empty($fromDate) || !empty($toDate)) && $caseStatus=='fOrange'){
            $condition[]=" (ar.qc2_report_publish = 1 and a.final_report=1 and a.report_status like '%ORANGE%') and ((DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) ";
        }

        if( (empty($fromDate) || empty($toDate)) && $caseStatus=='fRed'){
            $condition[]="(ar.qc2_report_publish = 1 and a.final_report=1 and a.report_status like '%RED%') and (DATE_FORMAT(a.final_report_published_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 2 WEEK) AND CURRENT_DATE())";
        }
        if( (!empty($fromDate) || !empty($toDate)) && $caseStatus=='fRed'){
            $condition[]=" (ar.qc2_report_publish = 1 and a.final_report=1 and a.report_status like '%RED%') and ((DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) ";
        }
        if( (empty($fromDate) || empty($toDate)) && $caseStatus=='supGreen'){
            $condition[]="(a.supplement_report = 1 and a.report_status like '%GREEN%') and (DATE_FORMAT(a.supplement_report_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 2 WEEK) AND CURRENT_DATE())";
        }
        if( (!empty($fromDate) || !empty($toDate)) && $caseStatus=='supGreen'){
            $condition[]=" (a.supplement_report = 1 and a.report_status like '%GREEN%') and ((DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) ";
        }

        if( (empty($fromDate) || empty($toDate)) && $caseStatus=='supOrange'){
            $condition[]="(a.supplement_report = 1 and a.report_status like '%ORANGE%') and (DATE_FORMAT(a.supplement_report_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 2 WEEK) AND CURRENT_DATE())";
        }
        if( (!empty($fromDate) || !empty($toDate)) && $caseStatus=='supOrange'){
            $condition[]=" (a.supplement_report = 1 and a.report_status like '%ORANGE%') and ((DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) ";
        }

        if( (empty($fromDate) || empty($toDate)) && $caseStatus=='supRed'){
            $condition[]="(a.supplement_report = 1 and a.report_status like '%RED%') and (DATE_FORMAT(a.supplement_report_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 2 WEEK) AND CURRENT_DATE())";
        }
        if( (!empty($fromDate) || !empty($toDate)) && $caseStatus=='supRed'){
            $condition[]=" (a.supplement_report = 1 and a.report_status like '%RED%') and ((DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) ";
        }

       //20/02/2023
        if($email){
            $condition[]=" t.email like '%".$email."%'";

        }
        
        if($term)
        {    
        //support multiple words
        $search = explode(' ', $term);
        foreach($search as $t) {
        $not        = '';
        $operator    = 'OR';

        if(substr($t,0,1) == '-')
        {
        $not        = 'NOT ';
        $operator    = 'AND';
        //trim the - sign off
        $t        = substr($t,1,strlen($t));
        }


        $like    = '';
        $like    .= " ( a.candidate_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." c.org_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." b.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." d.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.client_ref_number ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.report_status ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.final_report_published_date".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
        $like    .= $operator." a.case_accepted_date ".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
        $like    .= $operator." a.case_recieved_date ".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
        $like    .= $operator." a.created_on".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
        $like    .= $operator." cv.candidate_submit_date".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
         $like    .= $operator." cv.client_submit_date".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
         $like    .= $operator." cv.des_rejected_date".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
         $like    .= $operator." a.supplement_report_date ".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
        $like    .= $operator." f.first_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.reason ".$not."LIKE '%".$t."%' " ;
        //20/02/2023
        $like    .= $operator." t.email ".$not."LIKE '%".$t."%' " ;
        if($t == 'final' OR $t == 'interim' OR $t == 'supplementary')
        {

        }
        else
        {
             $like    .= $operator." a.case_no ".$not."LIKE '%".$t."%' )" ;
        }

         $t = strtolower($t);
        if($t == 'final')
        {
            $t = 1;
                    $like    .= $operator." a.final_report ".$not."LIKE '%".$t."%' )" ;
        }
       else if($t == 'interim'){
              $t = 1;
             $like    .= $operator."  ar.qc2_report_publish = 1 and ar.qc2_verification=1 )";
        }
       else if($t == 'supplementary')
        {
             $t = 1;
             $like    .= $operator." a.supplement_report ".$not."LIKE '%".$t."%')" ;
        }

       

        $condition[]=$like;
        }
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0]; 
        $result = $results[1]; 
        if ($result) {
           
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows; 
        //echo '<pre>';print_r($result);exit;
        foreach ( $result as $i => $row ) {

         $role=$this->session->userdata('user_type');
         $payment_status =  $row['payment_status'];
            
        $checkstatus = $this->cm->get_currentstatus($row['request_id']); 
        $verifiedlevelstatus = $this->cm->get_verifiedlevelstatus($row['request_id']);
        if(in_array("684",explode(',', $checkstatus['vmstatus'])))
        {
            $status='Initiated (Request raised)';    
        }
        else if($checkstatus['verification_status']==1 && $checkstatus['team_mem_id'] ==''){
            $status='Initiated';
        }
        else if($checkstatus['verification_status']==1 && $checkstatus['team_mem_id'] <>'' && $checkstatus['vm_revert_option_status']!=2 && $checkstatus['vm_revert_option_status']!=4){
            $status='Initiated';
        }
        else if(!empty($checkstatus['reason']) && $checkstatus['status']==0 && $row['dataentry_by']==0 && $row['client_verified']==2){
            $status='Revert Raised';
        }
        else if($checkstatus['status']==1 && $row['dataentry_by']==0 && $row['client_verified']==3){
            $status='Revert Closed';
        }
        else if($checkstatus['verification_status']==0 && $checkstatus['client_status']==1 && $checkstatus['vm_revert_option_status']==0 && $checkstatus['reverted_by']==0){
            $status='Submitted to Dcode';
        }
        else if($checkstatus['verification_status']==0 && $checkstatus['operator_status']==2){
            $status='Revert';
        }
        else if($checkstatus['revert_status']==0 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus[$this->role_id_text]==13 && $checkstatus['assainee_status']==0){
            $status='Revert Closed';
        }
        else if($checkstatus['revert_status']==1 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus[$this->role_id_text]==13){
            $status='Revert Assigned';
        }
        else if($checkstatus['revert_status']==0 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus[$this->role_id_text]==12 && $checkstatus['assainee_status']==0){
            $status='Revert Closed';
        }
        else if($checkstatus['revert_status']==1 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus[$this->role_id_text]==12 ){
            $status='Revert Assigned';
        }
        else if($checkstatus['reverted_by']==0 && !empty($checkstatus['reverted_reason']) && $checkstatus['assainee_status']==1){
            $status='Submitted to Dcode';
        }
        else if($checkstatus['reverted_by']!=0 && !empty($checkstatus['reverted_reason'])){
            $status='Reject Assigned';
        }
        else if($checkstatus['reverted_by']==0 && !empty($checkstatus['reverted_reason'])){
            $status='Reject Rectified';
        }
        else if($checkstatus['verification_status']==0 && $checkstatus['operator_status']==1 && $checkstatus['vm_revert_option_status']==0 && $row['dataentry_by']!=0){
            $status='Submitted to Dcode';
        }
        else if($row['dataentry_by']==0 && $checkstatus['status']!=1 && $row['status']==1){
            $status = 'Pending';
        }
        else if($row['dataentry_by']==0 && empty($checkstatus['status']) && $row['status']==0 ){
            $status = 'Deactivated';
        }
        else if($row['dataentry_by']==0  && $row['status']==2 ){
            $status = 'NOT TO BE SUBMITTED TO DCODE';
        }
        else if($checkstatus['status']==1 && $row['dataentry_by']==0 ){
            $status = 'Candidate Profile  Completed';
        }
        else if($checkstatus['client_status']==1 && $checkstatus['operator_status']==0 && $checkstatus['assignee_id']<>0 && $row['dataentry_by']==0){
            $status = 'Submitted to Dcode';
        }
        else if($checkstatus['client_status']==1 && $checkstatus['operator_status']==0 && $checkstatus['assignee_id']==0 && $row['dataentry_by']==0){
            $status='Submitted to Dcode';
        }
        else {
            $status = 'New';
        }
        $request_status = 'New';
        if($row['assainee_status']==1){
            $request_status = 'Assigned';
        } 
        else if($row['dataentry_by']==1){
            $request_status= 'New';
        if($status=='Allotted to DES'){
            $request_status= 'Assigned';
        }
        else if($status=='Revert Closed'){
            $request_status= 'Assigned';
        }else
            $request_status = $request_status= anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'New');
        }
        else if($row['dataentry_by']==2){
        if($status=='Revert Closed'){
            $request_status= 'Assigned';
        }
        }
        else {
        if($this->session->userdata['user_type'] == 2 ) {
            $request_status= anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'New');
        if($status=='Allotted to DES'){
        $request_status= 'Assigned';
        }
        else{
            $request_status= anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'New');
        }
        }
        else{
        if($status=='Revert DES'){
        $request_status= anchor('/Dadmin/newrevertrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Revert Raised');  
        }
        else{
            $request_status= anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'New');
        }
        }
        }
        if($status=='Revert Assigned' && $row['dataentry_by']==3){
        $request_status= anchor('/Dadmin/newsupervisorrevertrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Revert Raised');  
        }
        if($status=='Revert Assigned' && $row['dataentry_by']==1 || $status=='Revert Assigned' && $row['dataentry_by']==2){
        $request_status= anchor('/Dadmin/newcadminrevertrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Revert Raised');  
        }
        if($status=='Reject Assigned'){
        $request_status= anchor('/Dadmin/newcadminrejectrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Reject');  
        }
        if($status=='Reject Rectified'){
        $request_status= 'Assigned';  
        }
        $type='';
        if($row['dataentry_by']==1){
            $type='Partial Entry';
        }
        else if($row['dataentry_by']==2){
            $type='Full Entry';
        }
        else if($row['dataentry_by']==3){
            $type='Offline Entry';
        }
        else if($row['dataentry_by']==0){
            $type='Candidate Entry';
        }
        if($status=='Revert to DES' && $row['revert_status']==1 && $row['assainee_status']==1){
            $request_status= 'DEC';
        }
        else if($row['revert_status']==1 && $row['assainee_status']==1){
        $request_status= 'Revert Closed';
        }
        //$assign=anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),"View");
         if($this->session->userdata['role_id']==13 || $this->session->userdata['role_id']==12 || $this->session->userdata['role_id']==21 || $this->session->userdata['role_id']==24 || $this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==9)
            $pri_add= ' / ' .anchor('/Dadmin/add_priority/'.base64_encode($row['request_id']),"Priority");
    $assign=anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),"View").$pri_add;


        if($row['parent']==0){
        $officevalue=$row[$this->request_parent_office];
        $branchofficevalue=$row['office_name'];

        }else if($row['parent']!=0){
            $officevalue=$row['office_name'];
            $branchofficevalue=$row[$this->request_parent_office];
        }
        $created_on='';
        if($row['dataentry_by']!=3 && $row['case_accepted_date']!="0000-00-00 00:00:00" && !empty($row['case_accepted_date']))
        {
            $created_on=date('d-m-Y',strtotime($row['case_accepted_date']));
        }  
        else if($row['dataentry_by']==3 && $row['case_recieved_date']!="0000-00-00" && !empty($row['case_recieved_date']))
        {
            $created_on=date('d-m-Y ',strtotime($row['case_recieved_date']));
        }
        $frp_date='';
        if($row['final_report_published_date']){
            $frp_date=date('d-m-Y',strtotime($row['final_report_published_date']));
        }    
        if($row['dataentry_by']==3)
        {
            $cname='Dcode';
        }
        else
        {
        $cname=$row['first_name'];
        }
        $pending_chkint = $this->rm->getchecksintverify($row['request_id']);
        $cntck=count($pending_chkint);
        $interim='';
        foreach($pending_chkint as $chks){ 
        if($chks['qc2_report_publish']==1){   
              if($role <> 1 && $payment_status == 948){ 
               $interim = '<a href="#" onclick="myFunction(); return false;"> Interim </a>';


              }else
              {
                 $interim=anchor('/Client/interimreport/'.base64_encode($row['request_id']),"Interim");

              }

        }
        }
        $pending_checksa = $this->rm->getchecksverify($row['request_id']);
        $finalreport_checksa = $this->rm->getcountcheck($row['request_id']);
        $count_pending_checksa = $this->rm->getcountchecksverify($row['request_id']);
        $count_date_checksa = $this->rm->getfinalupdateedate($row['request_id']);
         /*********** Changes Done by Kp 09-Aug-2023************/
        $count_f_rep_date= $this->rm->getfinalreportdate($row['request_id']);

        // echo $row['request_id'];
        // print_r($count_f_rep_date);exit;
        $namw=count($finalreport_checksa);
        $sum=0;
        foreach($count_pending_checksa as $count_pending_val){
        $sum+=$count_pending_val['no_checks'];
        }
        if(!empty($verifiedlevelstatus['qc2fielddata'])){
        if($sum<=$namw){
        $status='Report Published';
        if($role <> 1 && $payment_status == 948 ){
            $final = '<a href="#" onclick="myFunction(); return false;"> Final </a>';
        }else
        {
           $final=anchor('/Reports/candidate_reports_view/'.base64_encode($row['request_id']).'/'.base64_encode(1).'/'.base64_encode(2).'/'.base64_encode(3).'/'.base64_encode($count_date_checksa['created_date']),"Final",'target=_blank');
        }

       
        }
        else{
        $final='';
        }
        }else{
        $final='';
        }
        /* supplementary report */
        $supplement='';
        if($row['supplement_report']==1){
        $freport=$this->db->query("select report_name from ". DB_PREFIX ."finalreportpublished 
        where request_id=".$row['request_id']." AND status=1 LIMIT 1 ")->row_array();

        $file_path ="uploads/finalreport/".$freport['report_name'];


        if($role <> 1 && $payment_status == 948){ 

           $final = '<a href="#" onclick="myFunction(); return false;"> Final </a>';
           $supplement = '<a href="#" onclick="myFunction(); return false;"> Supplement </a>';
  
         }
         else
         {
            
            if(!empty($freport['report_name']) && file_exists($file_path)){
                
                $final=anchor(('/Uploads/returnFile?file=' .$freport['report_name']),"Final",'target=_blank'); // May 24th
            }else{

                /*********** Changes Done by Kp 09-Aug-2023************/
                $final=anchor('/Reports/candidate_reports_view/'.base64_encode($row['request_id']).'/'.base64_encode(1).'/'.base64_encode(2).'/'.base64_encode(3).'/'.base64_encode($count_f_rep_date['qc2_date']),"Final",'target=_blank');
            }
            // $final=anchor(('/uploads/finalreport/'.$freport['report_name']),"Final",'target=_blank');
            
            $supplement=anchor('/Reports/candidate_reports_view/'.base64_encode($row['request_id']).'/'.base64_encode(1).'/'.base64_encode(2).'/'.base64_encode(3).'/'.base64_encode($count_date_checksa['created_date']),"Supplement",'target=_blank');
            
         }
        
        }
        if($row['supplement_report']==2){
        $freport=$this->db->query("select report_name from ". DB_PREFIX ."finalreportpublished 
        where request_id=".$row['request_id']."  LIMIT  1 ")->row_array();

        $file_path ="uploads/finalreport/".$freport['report_name'];
        
         if($role <> 1 && $payment_status == 948){ 
           $final = '<a href="#" onclick="myFunction(); return false;"> Final </a>';

         }
         else if($sum<=$namw)
         {
            if(file_exists($file_path)){
                $final=anchor(('/Uploads/returnFile?file=' .$freport['report_name']),"Final",'target=_blank'); // May 24th
            }else{

                /*********** Changes Done by Kp 09-Aug-2023************/
                $final=anchor('/Reports/candidate_reports_view/'.base64_encode($row['request_id']).'/'.base64_encode(1).'/'.base64_encode(2).'/'.base64_encode(3).'/'.base64_encode($count_f_rep_date['qc2_date']),"Final",'target=_blank');
            }
            // $final=anchor(('/uploads/finalreport/'.$freport['report_name']),"Final",'target=_blank');
            // $final=anchor(('/Uploads/returnFile?file=' .$freport['report_name']),"Final",'target=_blank'); // May 24th
         }

        $supplement='';
        }
        /*completed percentage*/
        $personaldetails=$this->dm->personaldetails($row['request_id']);
        $decleration_details = $this->dm->declerationdetails($row['request_id']);
        $other_details = $this->dm->otherdetails($row['request_id']);
        $checklevels=$this->dm->checklevels($row['request_id']);
        $count_checks=$this->dm->count_checks($row['request_id']);

        if($count_checks[0]['checksum1']){
            $checksum1=$count_checks[0]['checksum1'];
        }else{
            
            $count_checks=$this->dm->get_packageID($row['request_id']);
            $checksum1=0;
        }

        $anycount=$this->dm->get_anyCount($count_checks[0]['package_id']);
        if($anycount[0]['anycount']){
            $anycount1=$anycount[0]['anycount'];
        }else{
            $anycount1=0;
        }
        
        $checkCount=$this->dm->get_checkCount($row['request_id']);
        $checksum2=$checkCount[0]['checksum2'];

        $total_check =0; 
        foreach ($checklevels as  $clevels) 
        {   
        $slug = url_title(convert_accented_characters($clevels['name']), 'underscore', TRUE);
        if($clevels['id']<95 || $clevels['id']>330){
        $form_details=$this->dm->$slug($row['request_id'],$clevels['id']);
        }
        $total_check = $total_check +count($form_details);
        }

        $count1 = count($personaldetails)+count($decleration_details)+count($other_details)+$total_check;

        $totalcheck=$checksum1 + $anycount1 + $checksum2;
        //$count2 = $count_checks['chk_count']+3;
        $count2 = $totalcheck+3;
        //echo $count2;exit;
        

        $prog = round(($count1/$count2)*100,2);
        if($prog > 100)
        {  
            $progress = '100%';
        }
        else 
        {
            $progress = $prog.'%';
        }
        /* report status*/
        $rep_status=$this->cm->get_verified_data_with_checkid($row['request_id']);
        $report_status='';
        $publish_status=''; 
        $rstatus1=[];
        
        if($rep_status){
            $orange_check = 0;

            foreach($rep_status as $k => $rps)
            {     
                $rid=$row['request_id'];  
                if(!empty($rps['qc2fielddata'])){    
                    $qc2_data=toArray(json_decode($rps['qc2fielddata']));   
                    if($qc2_data['status']){
                        $pstatus[$rid][]=$this->vm->get_status($qc2_data['status']);
                        if($rps['check_id'] != 1306){ //if not gap check April 15th
                            if($qc2_data['status'] == "519" || $qc2_data['status1'] == "120") //others
                            {
                                $ostatus[] = $this->vm->get_status($qc2_data['ostatus']); 
                                $orange_check++;
                            }
                            if($qc2_data['status'] == 110) // stop check
                            {
                                $orange_check++;
                            }
                        } // i have added on 29
                    }
                    if($qc2_data['status1']){
                        $pstatus[$rid][]=$this->vm->get_status($qc2_data['status1']);
                        $status1[]=$this->vm->get_status($qc2_data['status1']); // Dec 13th
                    }
                }
            } 
        
        /*** Dec 13th ***/
        if(!empty($ostatus))
            $count_others_orange = 0;
        else
            $count_others_orange = -1;

        foreach($status1 as $sp) // status of 3rd drop down // Dec  13th
        {
            if($sp['name'] == "Others")
            {
                $count_others_orange = 1; 
            }
        }
        /*** Dec 13th ***/
        foreach($pstatus[$rid] as $rp)
        {
        $rstatus1[]=$rp['name'];
        }
        /** Aug 24th **/
        // foreach($ostatus as $orp)
        // {
        //     $orstatus[]=$orp['name'];
        // }   
        /** Aug 24th **/
        

        /**
         * In dcode_master_masterdata table
         * 699 -  Not Applicable
         * 750 - Not applicable  
         */
        foreach($ostatus as $orp) // For Others - Not Applicable -  Only this check in Others is to  be GREEN
        {
            $orstatus[]=$orp['name'];
            $others_id  = $orp['id']; // Dec 13th 
            if($others_id != 699 && $others_id != 750)  // Dec 13th
                $count_others_orange++;  // Count of  orange others checks 

        }
        /*** Dec 13th ***/ 
        if (in_array("Discrepant", $rstatus1) || in_array("Possible Discrepant" , $rstatus1) || in_array("Record Found" , $rstatus1) || in_array("Positive" , $rstatus1) || in_array("No Records" , $rstatus1) || in_array("High Risk" , $rstatus1) || in_array("Invalid" , $rstatus1) || in_array("Not Completed" , $rstatus1) || in_array("Multiple Active Records" , $rstatus1))
        { 
            $report_status ="<span style='color:red;'>RED</span>";
        }
        // Pasted here on April 15th
        else if ((in_array("Stop Check" , $rstatus1) &&  $orange_check>0) || (in_array("Others" , $rstatus1) && ($count_others_orange > 0) &&  $orange_check>0)  || (in_array("Others" , $rstatus1) && ($count_others_orange == -1) &&  $orange_check>0) || in_array("Possible Match" , $rstatus1) || in_array("Record Not Found" , $rstatus1) || in_array("Partial Match" , $rstatus1) || in_array("Record not complete" , $rstatus1)) {
            $report_status ="<span style='color:orange;'>ORANGE</span>";
        } 
        else if(in_array("Others" , $rstatus1) && (in_array("Not applicable" , $orstatus) || in_array("Not Applicable" , $orstatus)) && ($count_others_orange == 0))
        {
            $report_status ="<span style='color:green;'>GREEN</span>";

        }
        /** Feb 23rd **/
        
        else
        {
            $report_status ="<span style='color:green;'>GREEN</span>";
        }
            $publish_status=$report_status;
        }
        $updated_reports='';
        $supplement_date='';
        $updated_reports=$this->amodel->getDetails(DB_PREFIX . "clientadditional_report", array('*'), array('request_id' => $row['request_id'],'status'=>'1'));
        $manual_reports=(!empty($updated_reports[0]))? anchor('/uploads/additionalreport/'.$updated_reports[0]['document_name'],"Report",'target="_blank"')  : '';
        $created_date=isset($row['created_on']) ? date('d-m-Y',strtotime($row['created_on'])):'';
        $cand_submit_date=(isset($row['candidate_submit_date']) && ($row['dataentry_by']==0)) ? date('d-m-Y',strtotime($row['candidate_submit_date'])):'';
        $client_submit_date=(isset($row['client_submit_date']) && ($row['dataentry_by']!=3)) ? date('d-m-Y',strtotime($row['client_submit_date'])):'';
        $des_rejected_date=(isset($row['des_rejected_date']) && ($row['dataentry_by']!=3)) ? date('d-m-Y',strtotime($row['des_rejected_date'])):'';
        $supplement_date=(isset($row['supplement_report_date'])) ? date('d-m-Y',strtotime($row['supplement_report_date'])):'';
        $cand_submit_date=(isset($row['candidate_submit_date']) && ($row['dataentry_by']==0)) ? date('d-m-Y',strtotime($row['candidate_submit_date'])):'';
                $publish_date=(isset($row['qc2_date'])) ? date('d-m-Y',strtotime($row['qc2_date'])):'';

        $reopen_stat='';
        // if($row['supplement_report']==2)
        // {
        // $reopen_stat='Reopen';
        // }
        // elseif($row['supplement_report']==1){
        // $reopen_stat='Reopen-Completed';
        // }

        // April 28th - Code added to handle single shot reopen-revert
        $supp_count = $this->rm->get_supplementarycount($row['request_id']);           
        $supplementary_open_count = $supp_count['sup_cnt'];

        $supp_closed_count = $this->rm->get_supplementary_closed_count($row['request_id']);           
        $supplementary_closed_count = $supp_closed_count['sup_cnt'];
       
        if($row['supplement_report']==2  || $supplementary_open_count <> 0)
        {
        $reopen_stat='Reopen';
        }
        elseif($row['supplement_report']==1){ 
        $reopen_stat='Reopen-Completed';
        }
        elseif($supplementary_closed_count <> 0 && $supplementary_open_count == 0){ 
        $reopen_stat='Reopen-Completed';
        } // April 28th

        if($row['type_of_employees'] == 769){
            $typeofemp = 'Blue collared';
        }
        else if($row['type_of_employees'] == 770){
             $typeofemp = 'White collared';
        }
        else
        {
            $typeofemp='';
        }
          $paystatus =  $row['paym_status'];
          if($paystatus){
          $payment_statuss =  substr($paystatus,0,16);

          }else
          {
              $payment_statuss =  '';

          }
          if($this->session->userdata('role_id')==12)
          {
        $Modify_candidate=anchor('/Management/candidatedit/'.base64_encode($row['user_id']),"Edit").' / ';
        }

        $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$officevalue,$branchofficevalue,$row[$this->request_sub_office],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'],$row['client_ref_number'],$typeofemp,$request_status,$type,$status,$progress,$publish_status,$interim,$final,$supplement,$manual_reports,$reopen_stat,$frp_date,$supplement_date,$cname,$created_on,$created_date,$cand_submit_date,$client_submit_date,$des_rejected_date,$row['email'],$Modify_candidate.$assign); 
        }
        }
        echo json_encode($response);
    }
    /********************
    * Interim Report view page
    * interimreport
    ******************************/
    function interimreport(){
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('All Case List', $this->client_caselist);
        $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['breadcrumb']=$this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'reports');
    }
    /***************************
    * Get the list of intrim reports
    * get_interimreport
    ********************/
    function get_interimreport()    {
        $model = array(self::$client_model=>'get_interimreport');
        $office = ($_REQUEST[$this->request_office]) ? $_REQUEST[$this->request_office] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $org_id = ($_REQUEST[$this->request_orgid]) ? $_REQUEST[$this->request_orgid] : '';
        $parent_office = ($_REQUEST[$this->request_parent_office]) ? $_REQUEST[$this->request_parent_office] : '';
        $sub_office = ($_REQUEST[$this->request_sub_office]) ? $_REQUEST[$this->request_sub_office] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : ''; 
        $request_id=($_REQUEST['request_id']) ? $_REQUEST['request_id'] : '';
        $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : ''; 
        $date_filter=($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';

        if($org_id){
            $condition[]=" o.id = ".$org_id;
        }
        if($office){
        $condition[]=" c.id = ".$office;
        }
        if($parent_office){
        $condition[]=" c.parent_office = ".$parent_office;
        }
        if($request_id){
        $condition[]=" a.request_id = ".$request_id;
        }
        if($sub_office){
        $condition[]=" cr.sub_office = ".$sub_office;
        }
        if($name){
        $condition[]=" cr.candidate_name like '%".$name."%'";
        }
        if($case_no){
        $condition[]=" cr.case_no like '%".$case_no."'";
        }
        if(!empty($c_date) && $date_filter==1){
            $condition[]="DATE_FORMAT(vl1.qc2_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and ar.qc2_report_publish=1 ";
        }
        if(!empty($t_date) && $date_filter==1){
            $condition[]="DATE_FORMAT(vl1.qc2_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and ar.qc2_report_publish=1 ";
        }

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows;
        foreach ( $result as $i => $row ) {
        $interim=$this->vm->get_interim($row['request_id'],$row['check_id'],$row['level_id'],$row['pack_id']);
        $slug=url_title(convert_accented_characters($row['checkname']), 'underscore', TRUE);
        if($row['check_id']==14){
        $levelnames=$this->cm->get_level_name($row['request_id'],$row['check_id'],$row['level_id'],'education_details');
        }
        else if($row['check_id']==16){
        $levelnames=$this->cm->get_level_name($row['request_id'],$row['check_id'],$row['level_id'],'contact_details','request_id','permanent_address');
        }
        else if($row['check_id']==59){
        $levelnames=$this->cm->get_level_name($row['request_id'],$row['check_id'],$row['level_id'],'employment','req_id','level_id');
        }
        else if($row['check_id']==76 || $row['check_id']==77 || $row['check_id']==75){
        $levelnames=$this->cm->get_level_name($row['request_id'],$row['check_id'],$row['level_id'],$slug,'request_id','level_name');
        }
        else {
        $levelnames['level']=$row['checkname'];
        }
        $cname=anchor('/Reports/interim_reports_view/'.base64_encode($interim['request_id']).'/'.base64_encode($interim['level_id']).'/'.base64_encode($interim['check_id']).'/'.base64_encode($interim['pack_id']).'/'.base64_encode($row['qc2_date']),$row['candidate_name'],'target=_blank');
        $verified_data=$this->vm->get_verified_data($row['request_id'],$row['level_id'],$row['check_id']);
        $verification_data=toArray(json_decode($verified_data['qc2fielddata']));
        $status4='';
        $status1=$this->vm->get_status($verification_data['status']);
        $status2=$this->vm->get_status($verification_data['pstatus']);
        $status3=$this->vm->get_status($verification_data['status1']);
        if($verification_data['ostatus']<>''){
        $status4=$this->vm->get_status($verification_data['ostatus']);
        }
        if($verification_data['dstatus']<>''){
        $status4=$this->vm->get_status($verification_data['dstatus']);
        }
        if(!empty($status4)){
        $status41='-'.$status4['name'];
        }
        else {
        $status41='';
        }
        if(!empty($status1['name'])){
        $status=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
        }else{
        $status='';
        }
        if($row['chk']==0){
        $chkval=$row['checkname'];
        }else{
        $chkval=$row['checkname'].$row['chk'];
        }
        $qc2_date=isset($row['qc2_date'])?date('d-m-Y',strtotime($row['qc2_date'])) : '';  
        $reopen_status='';
        if($row['supplementary']==1 || $row['supplementary']==2){
        $reopen_status='Reopen';
        }elseif($row['supplementary']==3){
        $reopen_status='Reopen Completed';
        }    
        $response->rows [] ['cell'] = array ( $i+$count+1, $row['org_name'],$row[$this->request_parent_office],$row['office_name'],$row[$this->request_sub_office], $cname,$row['case_no'],$chkval,$status,$qc2_date,anchor('/Reports/interim_reports_view/'.base64_encode($interim['request_id']).'/'.base64_encode($interim['level_id']).'/'.base64_encode($interim['check_id']).'/'.base64_encode($interim['pack_id']).'/'.base64_encode($row['qc2_date']),'View'),$reopen_status);
        }
        }
        echo json_encode($response);
    }
    /*************************
    * Finla report view page
    * finalreport
    *************************/
    function finalreport(){
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('All Case List', $this->client_caselist);
        $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['breadcrumb']=$this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'finalreport');
    }
    /**************************
    * get the list of final report
    * get_finalreport
    *******************************/
    function get_finalreport()    {
        $model = array(self::$client_model=>'get_interimreport');
        $office = ($_REQUEST[$this->request_office]) ? $_REQUEST[$this->request_office] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $org_id = ($_REQUEST[$this->request_orgid]) ? $_REQUEST[$this->request_orgid] : '';
        $parent_office = ($_REQUEST[$this->request_parent_office]) ? $_REQUEST[$this->request_parent_office] : '';
        $sub_office = ($_REQUEST[$this->request_sub_office]) ? $_REQUEST[$this->request_sub_office] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : ''; 
        $request_id=($_REQUEST['request_id']) ? $_REQUEST['request_id'] : '';
        if($org_id){
        $condition[]=" o.id = ".$org_id;
        }
        if($office){
        $condition[]=" c.id = ".$office;
        }
        if($parent_office){
        $condition[]=" c.parent_office = ".$parent_office;
        }
        if($request_id){
        $condition[]=" a.request_id = ".$request_id;
        }
        if($sub_office){
        $condition[]=" cr.sub_office = ".$sub_office;
        }
        if($name){
        $condition[]=" cr.candidate_name like '%".$name."%'";
        }
        if($case_no){
        $condition[]=" cr.case_no like '%".$case_no."'";
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows;
        foreach ( $result as $i => $row ) {
        $slug=url_title(convert_accented_characters($row['checkname']), 'underscore', TRUE);
        if($row['check_id']==14){
        $levelnames=$this->cm->get_level_name($row['request_id'],$row['check_id'],$row['level_id'],'education_details');
        }
        else if($row['check_id']==16){
        $levelnames=$this->cm->get_level_name($row['request_id'],$row['check_id'],$row['level_id'],'contact_details','request_id','permanent_address');
        }
        else if($row['check_id']==59){
        $levelnames=$this->cm->get_level_name($row['request_id'],$row['check_id'],$row['level_id'],'employment','req_id','level_id');
        }
        else if($row['check_id']==76 || $row['check_id']==77 || $row['check_id']==75){
        $levelnames=$this->cm->get_level_name($row['request_id'],$row['check_id'],$row['level_id'],$slug,'request_id','level_name');
        }
        else{
        $levelnames['level']=$row['checkname'];
        }
        $cname=anchor('/Client/candidate_reports_view/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name'],'target=_blank');
        $status=$row['status'];
        $response->rows [] ['cell'] = array ( $i+$count+1, $row['case_no'], $cname,$row['org_name'],$row[$this->request_parent_office],$row['office_name'],$row[$this->request_sub_office],$row['checkname'],$status,$row['qc2_date'],anchor('/Client/candidate_reports_view/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'View'));
        }
        }
        echo json_encode($response);
    }
    /********************
    * Partial entry view page
    * partial
    ************************/
    function partial() {
            $request_id = base64_decode($this->uri->segment(3));
            $save['request_id']=$request_id;
            $save['client_verified']=0;
            $save['client_status']=1;
            $save['client_submit_date']=date('Y-m-d H:i:s');
            $save['client_submited_by']=$this->session->userdata($this->userid_text);
            $this->dm->submittodcode($save);
            redirect($this->client_clientofflinesearch);
    }
   /*****************************
   * Submitting case in partial entry to DES
   * newofflinerequest
   *********************************/ 
    function newofflinerequest() {
        $url=$this->uri->segment(3);
        if($url <> 2) {
        $skillsadd_clones = array(array('document_name' => array('text', 'document_name', 'R', 'R','', 'RF', ''),'multipleupload' => array('upload', 'multipleupload', 'R', 'R','', '', '') ));
        $data['skills_file_clone'] = create_cloneform($skillsadd_clones,'', $user_id );
        $data['upload_file'] =formclonecreation($skillsadd_clones,$data['skills_file_clone'],1,'Add Document',"Multiple Document");
        }
        else
        {
        $skillsadd_clones = array(array('document_name' => array('text', 'document_name', '', '','', 'RF', ''),'multipleupload' => array('upload', 'multipleupload', '', '','', '', '') ));
        $data['skills_file_clone'] = create_cloneform($skillsadd_clones,'', $user_id );
        $data['upload_file'] =formclonecreation($skillsadd_clones,$data['skills_file_clone'],1,'Add Document',"Multiple Document"); 
        }
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Data Entry', $this->client_clientofflinesearch);
        $this->breadcrumbs->push('Add Data Entry', 'Client/newofflinerequest');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'new_requirement');
    }
    /*****************************
    * client order list
    * client_getorderlist
    ********************************/
    function client_getorderlist() {
        $office_id = $this->uri->segment(3);
        $parentoffice = $this->cm->clientorderdetails($office_id);
        $out = '<option value="">Select</option>';
        foreach ($parentoffice as $parentoff) {
        $out.= '<option value="' . $parentoff['id'] . '">' . $parentoff['order_code'] . '</option> ';
        }
        echo $out;
    }
    /***********************************
    * Create partial,offline and full entry cases 
    * addofflinereq
    *************************************/
    function addofflinereq()   { 
    try {     
            $cand_email = $this->amodel->getDetails(DB_PREFIX . "user", array('email'), array('email' => $_POST['candidate_email'],'parent_office' => $_POST['parent_office'],'active_status!='=>3)); 
            if(!empty($cand_email[0]['email'])){
                 echo "<script>alert('This email already exists!');</script>"; 
             redirect ( base_url($this->client_clientofflinesearch. $this->uri->segment(3)), 'refresh' );   
             exit;
            }
            $order_id = $this->input->post ('order_id' );
            $url=$this->uri->segment(3);
            $organization = $this->amodel->getDetails(DB_PREFIX . "organisation", array('org_name','id'), array('id' => $_POST['parentoffice_id']));
            $ins['organisation'] = $_POST['parentoffice_id'];
            $ins[$this->request_office] = $_POST[$this->request_parent_office];
            $this->db->select('MAX(request_id) as id');
            $this->db->where('organisation',$ins['organisation']);
            $lastcase=$this->db->get(DB_PREFIX .'client_request')->row_array();
            $this->db->select('case_no');
            $this->db->where('request_id',$lastcase['id']);
            $this->db->where('organisation',$ins['organisation']);
            $lastcase=$this->db->get(DB_PREFIX .'client_request')->row_array();
            $current=date('dm');
            if(empty($lastcase['case_no']) || $casenumber=='0104'){
                $caseno=1;
            }
            else
            {
            $explode=explode('-',$lastcase['case_no']);
            $caseno=$explode[1] + 1;
            }
            $this->load->library('csvreader');
            $result =   $this->csvreader->parse_file($_FILES['upload']['tmp_name']); 
            if(!$result) { 
        if($_POST) {
                    $this->db->trans_begin();
                        $order = $this->amodel->getDetails(DB_PREFIX . "order", array('id','billing_type'), array($this->request_parent_office => $_POST[$this->request_parent_office],$this->request_office => $_POST['office_id'],$this->request_sub_office => $_POST[$this->request_sub_office],'status'=>1)); 
                        if(empty($order)) {
                        $order = $this->amodel->getDetails(DB_PREFIX . "order", array('id','billing_type'), array($this->request_parent_office => $_POST[$this->request_parent_office],$this->request_office => $_POST['office_id'],'status'=>1));
                        } 
                        if(empty($order)) {
                        $order = $this->amodel->getDetails(DB_PREFIX . "order", array('id','billing_type'), array($this->request_parent_office => $_POST[$this->request_parent_office],'status'=>1)); 
                        }

                         $billingtype='';
                         if($order[0]['billing_type'] == 515)
                         {
                            $billingtype="PR";
                         }
                         elseif($order[0]['billing_type'] == 516)
                         {
                            $billingtype="PO";
                         }
                         $casenumber= $billingtype.$organization[0]['id'].'-'.$caseno;
                
                        $formData[$this->role_id_text] = 16;
                        $formData['user_type'] = 2; 
                        $formData['submit_date'] = date('Y-m-d H:i:s',strtotime("5 weekdays")); 
                        $new_password = $this->randomString(10);
                        $formData['password'] =  md5( $new_password );
                        $formData[$this->request_parent_office] = $_POST[$this->request_parent_office];
                        $formData['organization'] = $_POST['parentoffice_id'];
                        $formData[$this->request_sub_office] = $_POST[$this->request_sub_office];
                        $formData['office_id'] = $_POST['office_id'];
                        $formData['username'] = $_POST['candidate_name'];
                        $formData['first_name'] = $_POST['candidate_name'];
                        $formData['last_name'] = '';
                        $formData['email'] = $_POST['candidate_email'];
                        $formData['status'] = 1;
                        $insertData = elements(array('office_id',$this->role_id_text,'user_type','organization', 'first_name','last_name','username', 'password',$this->request_sub_office, $this->request_parent_office,'submit_date','email','status'), $formData);

                        $return_id = $this->amodel->dmlfunction(DB_PREFIX . "user", array('id' => $id), $insertData, $id);
                        $ins_data = array();
                        $ins_data['candidate_name'] = $_POST['candidate_name'];
                        $ins_data['dataentry_by'] = ($this->session->userdata['user_type'] == 1 ) ? 3 : $this->uri->segment(3);
                        $ins_data['organisation'] = $_POST['parentoffice_id'];
                        $ins_data[$this->request_parent_office] = $_POST[$this->request_parent_office];
                        $ins_data[$this->request_office] = $_POST['office_id'];
                        $ins_data[$this->request_sub_office] = $_POST[$this->request_sub_office];
                        $ins_data['order_id'] = $order[0]['id'];
                        $ins_data['status_of_candidate'] = 2;
                        $ins_data['user_id']=$return_id;
                        $ins_data['deadline_from'] = date('Y-m-d'); 
                        $ins_data['deadline_to'] = date('Y-m-d',strtotime("5 weekdays")); 
                        $ins_data['created_on'] = date ( 'Y-m-d H:i:s' );
                        $ins_data['created_by'] = $this->user_id;
                        if($ins_data['dataentry_by']==1){
                            $ins_data['assainee_status']=2;
                        }
                        $ins_data['case_no'] = $casenumber;
                        $ins_data['client_ref_number'] = $_POST['client_ref_number'];
                        $ins_data['case_recieved_date'] = ($_POST['case_recieved_date']) ? date('Y-m-d',strtotime($_POST['case_recieved_date'])) : NULL; 
                        $ins_data['aadhaar_number'] = $_POST['aadhaar_number'];
                        $ins_data = $this->security->xss_clean($ins_data);
                        $this->db->insert ( DB_PREFIX .'client_request', $ins_data );
                        $client_request_id = $this->db->insert_id ();
                        $this->db->insert('dcode_profile_status',array('candidate_request_id'=>$client_request_id));
                        $levels = $_POST['level_id'];
                        $no_of_checks=$_POST['no_of_checks'];
                        $description=$_POST['description'];
                        $levelname='';
                         $levelar='';
                        $levelar=json_encode($_POST['level_id']); 
                        $inslog_data['order_id'] = $order[0]['id'];
                        $inslog_data['user_id']=$return_id;
                        $inslog_data['request_id']=$client_request_id;
                        $inslog_data['check_id']=$levels[0];
                        $inslog_data['action']=$levelar;
                        $inslog_data['updated_by'] = $this->user_id;
                        $inslog_data['updated_on'] = date ( 'Y-m-d H:i:s' );
                        $this->db->insert ( DB_PREFIX .'loghistory', $inslog_data );
                       foreach($_POST['level_id'] as $key=>$value){ // here i have added the gap analysis check id 1306
                        if($value<95 || $value== 1306 || ($value>630 && $value <=655)) {
                            //02/01/2024
                       if(isset($_POST[$value.'_descriptionm']) && !empty($_POST[$value.'_descriptionm'])){
                        if($value==75){
                            $levelname="DRUG ".implode(',',$_POST[$value.'_descriptionm']);
                        }
                        else
                        {
                          $levelname=implode(',',$_POST[$value.'_descriptionm']);
                        }
                       }
                       else{
                        $levelname=$_POST[$value.'_description'];
                       }
                        $request_check_insert[]=array('check_id'=>$value,
                        'no_checks'=>$_POST[$value.'_no_of_checks'],
                        'description'=>$levelname,
                        'request_id'=>$client_request_id,
                        'package_id'=>0,
                        'information'=>$_POST[$value.'_information']);
                        }
                        /****Packages*****/
                         if($value >650)
                         {
                            $this->db->select('*');
                            $this->db->where_in('package_id',$value);
                            $package_details = $this->db->get(DB_PREFIX."packages")->result_array();

                            foreach($package_details as $key=>$pval)
                            {
                              $check_id=$pval['check_id'];
                              
                              if($pval['group_id']== GROUPID_IDPROOF)
                              {
                                $no_ofchek=($pval['mandatory']== 'Yes') ? 1 : 0 ;
                              }
                              else{
                                $no_ofchek=($pval['no_ofcheck']) ? $pval['no_ofcheck'] : 1 ;
                              }
                              
                            if($check_id==75){
                              $levelname="DRUG ".$pval['acceptable_limit'];
                            }else{
                              $levelname=$pval['acceptable_limit'];
                            }

                            $request_check_insert[]=array('check_id'=>$check_id,
                                                            'no_checks'=>$no_ofchek,
                                                            'description'=>$levelname,
                                                            'request_id'=>$client_request_id,
                                                            'package_id'=>$pval['package_id'],
                                                            'information'=>$_POST[$check_id.'_informations']);
                            
                            }
                         }
                        // else
                        // {
                        //     if($value==95){
                        //         $manualchecks=array('14'=>2,'59'=>0,'68'=>1);
                        //     }
                        //     else if($value==96){
                        //         $manualchecks=array('14'=>1,'59'=>0,'68'=>1);
                        //     }
                        //     else if($value==97){
                        //         $manualchecks=array('14'=>1,'59'=>2,'68'=>1);
                        //     }
                        //     else if($value==98){
                        //         $manualchecks=array('59'=>0,'68'=>1);
                        //     }
                        //     else if($value==99){
                        //         $manualchecks=array('14'=>1,'59'=>1,'68'=>1);
                        //     }
                        //     else if($value==100){
                        //         $manualchecks=array('59'=>0);
                        //     }
                        //     else if($value==101){
                        //         $manualchecks=array('14'=>1,'59'=>1);
                        //     }
                        //     else if($value==102){
                        //         $manualchecks=array('59'=>1,'68'=>1);
                        //     }
                        //     else if($value==103){
                        //         $manualchecks=array('14'=>1);
                        //     }
                        //      else if($value==105){
                        //         $manualchecks=array('631'=>2,'632'=>2,'633'=>2,'634'=>2,'635'=>2);
                        //     }
                        //     foreach($manualchecks as $key=>$cvalue) {
                        //     $request_check_insert[]=array('check_id'=>$value,
                        //     'no_checks'=>$cvalue,
                        //     'description'=>$key,
                        //     'request_id'=>$client_request_id);
                        //     }
                        // }
                        
                       } //echo '<pre>';print_r($request_check_insert);exit;
                        if($request_check_insert) {   
                        $this->db->insert_batch(DB_PREFIX.'request_check',$request_check_insert);
                        }
                        foreach($_POST['level_id'] as $values){ // here i have added gap analyis check id 1306
                        if($values<95 || $values == 1306 || ($values>630 && $values <=655)) {
                            //02/01/2024
                        $value_l95[] =$values;
                        }
                        if($values>=95 && $values >650 ){
                        $value_g95[] =$values;
                        }
                        }
                        $insbill_data['check_id']=implode(',', $value_l95);
                        $insbill_data['pack_id']=implode(',', $value_g95);
                        $this->db->select('billing_type');
                        $billingtype=$this->db->get_where(DB_PREFIX .'order',array('id'=> $order[0]['id'] ))->row_array();
                        $ncheck=$this->db->query("select SUM(m.Rs*a.no_checks) AS total_value
                        from ". DB_PREFIX ."request_check a
                        JOIN ". DB_PREFIX ."add_check m ON m.types_of_check = a.check_id
                        where a.request_id =  ". $client_request_id." AND (a.check_id < 95 OR (a.check_id >630 AND a.check_id <=655))
                        AND m.order_id =".$order[0]['id']."")->row_array();
                         //02/10/2024
                        // $ncheckvalue=$this->db->query("select SUM(m.Rs*a.no_checks) AS total_package
                        // from ". DB_PREFIX ."request_check a
                        // JOIN ". DB_PREFIX ."add_check m ON m.types_of_check = a.check_id
                        // where a.request_id =  ". $client_request_id." AND a.check_id >= 95 
                        // AND m.order_id =".$order[0]['id']."")->row_array();

                        $ncheckvalue= $this->db->query("select sum(Rs) as total_package from ". DB_PREFIX ."add_check where  `types_of_check` IN(SELECT package_id FROM ".DB_PREFIX."request_check WHERE request_id =". $client_request_id . " AND order_id =".$order[0]['id']." ) " )->row_array();
                                                
                        $insbill_data[$this->request_parent_office] = $_POST[$this->request_parent_office];
                        $insbill_data['organisation'] = $_POST['parentoffice_id'];
                        $insbill_data[$this->request_sub_office] = $_POST[$this->request_sub_office];
                        $insbill_data[$this->request_office] = $_POST['office_id'];
                        $insbill_data['candidate_name'] = $_POST['candidate_name'];
                        $insbill_data['order_id'] = $order[0]['id'];
                        $insbill_data['amount'] = $ncheck['total_value'];
                        $insbill_data['package_amount'] = $ncheckvalue['total_package'];
                        $insbill_data['user_id']=$return_id;
                        $insbill_data['request_id']=$client_request_id;
                        $insbill_data['case_no'] = $casenumber;
                        $insbill_data['created_on'] = date('Y-m-d');
                        $insbill_data['billing_type'] = $billingtype['billing_type'];
                        $this->db->insert ( DB_PREFIX .'billing', $insbill_data );
                        if($client_request_id)  {
                        $upload_elements =array('document_name','multipleupload');
                        $this->insertmultipleupload($_POST['count1'],$upload_elements,$client_request_id,DB_PREFIX.'partial_upload_document',0,'request_id');
                        $sql = $this->db->query ( 'delete from '.DB_PREFIX .'profile_level_status where client_request_id = "' . $client_request_id . '"');
                        foreach($levels as $key => $value ) {
                        $ins_data = array();
                        $ins_data['client_request_id'] = $client_request_id;
                        $ins_data['check_level_id'] = $levels[$key];
                        $ins_data['level_status'] = 1;
                        $ins_data['created_on'] = date ( 'Y-m-d H:i:s' );
                        $ins_data['created_by'] = $this->user_id;
                        $this->db->insert ( DB_PREFIX .'profile_level_status', $ins_data );
                        }
                        }
                        if($this->uri->segment(3)==1 || $this->uri->segment(3)=='3'){
                        $save['request_id']=$client_request_id;
                        $save['client_verified']=0;
                        $save['client_status']=1;
                        $save['client_submit_date']=date('Y-m-d H:i:s');
                        $save['client_submited_by']=$this->session->userdata($this->userid_text);
                        $this->dm->submittodcode($save);
                        }
                       echo "<script>alert('Candidate has been created successfully');</script>"; 
                        if ($this->db->trans_status() === FALSE)
                        {
                        $this->db->trans_rollback();
                        }
                        else
                        {
                        $this->db->trans_commit();
                        }
                       
            } 
    }
    else {
               $this->db->trans_begin();        
                $order = $this->amodel->getDetails(DB_PREFIX . "order", array('id'), array($this->request_office => $_POST['office_id']));
        if($result){
            foreach($result as $res) {
                        $ins_data = array();
                        $ins_data['candidate_name'] = $res['candidate_name'];
                        if(!isset($_POST['dataentry_by'])){
                            $ins_data['dataentry_by']=1;
                        }
                        else{
                            $ins_data['dataentry_by'] = ($this->session->userdata['user_type'] == 1 ) ? 3 : $_POST['dataentry_by'];
                        }
                        if(empty($_POST['office_id'])){
                            $ins_data[$this->request_office] = $_POST[$this->request_parent_office];
                        }
                        else{
                            $ins_data[$this->request_office] = $_POST['office_id'];
                        } 
                        $ins_data['order_id'] = $order[0]['id'];
                        $ins_data['status_of_candidate'] = 2;
                        $ins_data['created_on'] = date ( 'Y-m-d H:i:s' );
                        $ins_data['created_by'] = $this->user_id;
                        if($ins_data['dataentry_by']==1){
                            $ins_data['assainee_status']=2;
                        }
                        $this->db->insert ( DB_PREFIX .'client_request', $ins_data );
                        $client_request_id = $this->db->insert_id ();
                        $levels = $_POST['level_id'];
                if($client_request_id)  {
                $sql = $this->db->query ( 'delete from '.DB_PREFIX .'profile_level_status where client_request_id = "' . $client_request_id . '"');
                foreach($levels as $key => $value ) {
                        $ins_data = array();
                        $ins_data['client_request_id'] = $client_request_id;
                        $ins_data['check_level_id'] = $levels[$key];
                        $ins_data['level_status'] = 1;
                        $ins_data['created_on'] = date ( 'Y-m-d H:i:s' );
                        $ins_data['created_by'] = $this->user_id;
                        $this->db->insert ( DB_PREFIX .'profile_level_status', $ins_data );
                        }
                   }
                   //for offline entry
                   if( $this->uri->segment(3)=='3'){
                $save['request_id']=$client_request_id;
                $save['client_verified']=0;
                $save['client_status']=1;
                $save['client_submit_date']=date('Y-m-d H:i:s');
                $save['client_submited_by']=$this->session->userdata($this->userid_text);
                $this->dm->submittodcode($save);
                }
            }
         }  
        echo "<script>alert('Candidate has been created successfully');</script>";
        if ($this->db->trans_status() === FALSE)
        {
            $this->db->trans_rollback();
        }
        else
        {
            $this->db->trans_commit();
        } 

        }
    }
       catch(ErrorException $e) {
            echo $e->getMessage(); 
            $this->load->view('index/error_500');
        }
        redirect ( base_url($this->client_clientofflinesearch. $this->uri->segment(3)), 'refresh' );
    }
    /*************************************
    * insertmultipleupload function
    * insertmultipleupload
    *************************************/
    function insertmultipleupload($clonecount=0,$insertValue = '',$marketId = '',$tablename = '',$editId = '',$fieldname = '')
    {
    $insertsales = array();
      $bulksave = array();
      if($clonecount != 0) {
        for($i=1;$i<=$clonecount;$i++) { 
            $j = $i;
        if($i == 1)
        {
            $j = '';
        }
        if($_POST[$insertValue[0].$j]) {
        foreach($insertValue as $value) { 
          switch($value)
          {
            case 'multipleupload':
                $config['allowed_types'] = '*';                               
                $config['upload_path'] = 'uploads/particaldocument/';
                $config['encrypt_name'] = true;
                $config['remove_spaces'] = true; 
                $this->load->library('upload');
                if (!empty($_FILES['multipleupload'.$j.$j]['name'])) {  
                 $uploadfilename = $config['file_name'] = md5($_FILES['multipleupload'.$j.$j]['name'].date('Y-m-d H:i:s')); 
                  $this->upload->initialize($config);
                  if ($this->upload->do_upload('multipleupload'.$j.$j)) {
                  $data = $this->upload->data();
                  $imagefile['original']=$config['upload_path'].''.$data['file_name']; 
                  $ext = pathinfo($_FILES['multipleupload'.$j.$j]['name'],PATHINFO_EXTENSION);
                  $insertsales['multipleupload'] = $imagefile['original'];
                  }
                }
                break;
            default:
              $insertsales[$value] = $_POST[$value.$j];
                break;
          }
          }
        $insertsales[$fieldname] = $marketId;
        $insertsales['status'] = 1 ;
        $bulksave[] = $insertsales;   
        }
      }
      if($bulksave){
          $this->db->insert_batch($tablename,$bulksave);
      }

      }
    }
    /**************************
    * Profilerequest
    * view page of candidate entry
    ************************/
    function profilerequest()
    {
            $userid=$this->session->userdata($this->userid_text);
           $check=$this->cm->checkprofilesubmit($userid);
            $checkcnt=$this->cm->checkprofilesubmitcnt($userid);
           $checksubmit=$this->cm->check_submission_new($userid);
           if($checksubmit['cnt']<>0){
                redirect($this->client_cli_search);
           }
            $data['check']=$check;
            $data['checkcnt']=$checkcnt;
            $data['checksubmit']=$checksubmit;
            $this->amodel->pagerender($data, 'profilerequest');
    }
    /********************************
    * submitrequest
    * candidate submit to client
    *************************/
    function submitrequest()
    {
             $userid=$this->session->userdata($this->userid_text);
            $check=$this->cm->checkprofilesubmit($userid);
            $checkcnt=$this->cm->checkprofilesubmitcnt($userid);
            $checksubmit=$this->cm->check_submission_new($userid);
            if(($checksubmit['cnt']<>0) || ($checksubmit['cnt']==0 && $checkcnt['cnt']>1)){
                redirect($this->client_cli_search);
            }
            $data=$checkcnt;
            $check=$this->cm->insertprofilesubmit($userid,$checkcnt['cnt']);
            $this->amodel->pagerender($data, 'submitrequest');
    }
    /***************************************
    * Check details in candidate entry page
    * getprofilestatus
    *************************************/    
    function getprofilestatus($rid =null)
    {
        $checklevels = $this->dm->checklevels($rid);
        foreach($checklevels as $level){
        if($level['id']<95){
        $levels[]=$level['id'];
        }
        else{
        $levels[]=$level['description'];
        }
        }
        $order_details = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id','name'), array('key' => 'Check,package','parent'=>0));
        $profile_status = $this->amodel->getDetails(DB_PREFIX . "profile_status", '', array('candidate_request_id' => $rid));
        $profileStatus = "<table class='removetitle'><tr>";
        foreach($order_details as $order){
        if(in_array($order['id'],$levels))
        $profileStatus .="<th>".anchor('/Dadmin/dadminview/'.base64_encode($rid).'/'.base64_encode($order['id']),$order['name'])."</th> ";
        }
        $profileStatus .="</tr>";
        $profileStatus="<table class='removetitle'><tr>";
        foreach($order_details as $order){
        $checkname=substr(strtolower($order['name']),0,3);
        $namecheck=strtolower($order['name']);
        if(in_array($order['id'],$levels))
        {
        $data['slug']   =$slug= url_title(convert_accented_characters($order['name']), 'underscore', TRUE);
        if($order['id']==14){
            $getstatus= $this->cm->getprofilestatus('education_details','request_id',$rid);
        }
        else if($order['id']==15){
            $getstatus= $this->cm->getprofilestatus('permanent_contact_details','request_id',$rid);
        }
        else if($order['id']==16){
            $getstatus= $this->cm->getprofilestatus('contact_details','request_id',$rid);
        }
        else if($order['id']==59){
            $getstatus= $this->cm->getprofilestatus('employment','req_id',$rid);
        }
        else {
            $getstatus= $this->cm->getprofilestatus($slug,'request_id',$rid);
        }
        $profileStatus .="<td> ".anchor('/Dadmin/dadminview/'.base64_encode($rid).'/'.base64_encode($order['id']),$order['name'].'<br />'.$getstatus['cnt'])."</td>";
        }
        }
        $profileStatus .="</tr>
        </table>";
        return  $profileStatus;
    }
    /**********************************
    * Loading checks based upon clientwise.
    * load_checklist
    **************************************/
    function load_checklist()
    {             
        $office_id=$_POST['office_id'];
        $office=$_POST;
        //print_r($office); 
        if(empty( $office)){
        die();
        }
        $order_details=$this->cm->load_order_by_client($office); 

        if(empty($order_details))
        {
        echo '';
        die();
        }

        $table = "<table border='1' align='center' style='width:923px;' id='table'>";
        $table .= "<tr class='s-usebrd' height='35'><td colspan='4'><h3>Checks and Levels</h3></td></tr>";
        if(strtolower($order_details[0]['key'])=='check')
        {
        $table .= "<tr class='at_tr' height='35'>
        <th class='at_th' style='width:450px;' >Check Name</th>
        <th class='at_th'>No.of Checks</th>
        <th class='at_th'>Sub Check Name </th> 
        <th class='at_th'>Description </th>               
        </tr>";
       }
        $cn=1;
        foreach($order_details as $orderkey => $ordervalue ) { 

        $childrecordsnew=$this->cm->load_order_by_client_new($office,$ordervalue['id']);
        
        $childrecords_data = $this->amodel->fetchDropdowndetails( DB_PREFIX."master_masterdata", array('name','name'),array('key' => 'Check','parent'=>$ordervalue['id']) );
        if(strtolower($ordervalue['key'])=='check') {
        $table .= "<tr class='at_tr' height='35' >";
        $table .= "<td  class='at_td'><input type='checkbox'  id='".$ordervalue['id']."_level_id' class='de_check required chk_checked'  name = 'level_id[]' value = '".$ordervalue['id']."' />".(ucwords($ordervalue['name'])=='Professional Reference'?ucwords($ordervalue['name']).' - Reporting Manager':ucwords($ordervalue['name']))."</td>";

        $table .= "<td  class='text_box'><input type='text'  class='de_text required numbervalue' min='1' max='10' autocomplete='off' id ='".$ordervalue['id']."_no_of_checks' disabled  name ='".$ordervalue['id']."_no_of_checks' value = '' /></td>"; 
        if(!empty($childrecordsnew))
        {   
        $table .= "<td  class='text_box'>".form_multiselect($ordervalue['id'].'_descriptionm[]', $childrecords_data,set_value('descriptionm[]',''), 'class="s-inpt required s-option" disabled="true" id='.$ordervalue['id'].'_descriptionm')."<small>Select multiple items holding ctrl button</small><label  id='".$ordervalue['id']."'  class='error' style='display: none;'>Please select options by number of checks</label></td>";
        }
        else{
        $table .= "<td  class='text_box'></td>";
        }
        $table .= "<td  class='text_box'><input type='text'  class='de_text dec_txt".$ordervalue['id']."' autocomplete='off' id ='".$ordervalue['id']."_information' disabled  name ='".$ordervalue['id']."_information' value = '' /></td>"; 
        $table .= "</tr>";
        }
        
        else if(strtolower($ordervalue['key'])=='package')
        {
        if($cn==1) {
        $table .= "<tr class='at_tr' height='35' >";
        $table .= " <td   colspan='4'><table border='1'  style='width:100%' align='center'  id='table'> <tr class='at_tr' height='35'>
        <th  class='text_box at_th' style='width:141px' > Package</th>
       
        <th class='at_th' style='width:324px'>Checks</th>
        <th class='at_th' style='width:200px'>Description </th>              
        </tr> </table></td></tr>";
        }
        if(!empty($ordervalue['level']))
        {
            $ordervalue_name=$ordervalue['level'];
        }else{
            $ordervalue_name=$ordervalue['name'];
        }
       
        $table .= "<tr class='at_tr' height='35' >";
        $table .= " <td   colspan='4'><table  style='width:100%' border='1' align='center'  id='table'><tr class='at_tr' height='35'>";

        $table .= "<td  class='at_td'style='width:138px'><input type='checkbox'  id='".$ordervalue['id']."_level_id' class='de_check required package_chk'  name = 'level_id[]' value = '".$ordervalue['id']."' />".ucwords($ordervalue_name)."</td>";

        /* Check List*/
    //if($ordervalue['key']='package'){
        $this->db->select('p.group_id,p.check_id,p.no_ofcheck,p.checknotes,m.name,m.id,p.mandatory,p.anycount,p.noof_year');
        $this->db->where('package_id',$ordervalue['id']);
        $this->db->join(DB_PREFIX.'master_masterdata m','m.id=p.check_id','left');
        $check_list = $this->db->get(DB_PREFIX."packages p")->result_array();

        $counter=0;
        foreach($check_list as $key=>$chkValue)
        {
            if(!empty($chkValue['mandatory'])) {
            $counter += 1;
            }
        }
        

        $chknotes='' || $chknotes= [];
        $checkName='' || $checkName= [];
        $input_Field='' || $input_Field= [];
        
        $j=1;
        foreach($check_list as $key=>$chkValue)
        {
         

            if($chkValue['group_id']==1){

                $any=($counter > 0) ? $chkValue['anycount']-$counter : '';
                $anyCnt=' Any '.$any;
                $mandatory=($chkValue['mandatory']=='Yes') ? ' (Mandatory)' : ' (Optional)'.$anyCnt;   
            }else{
                $mandatory='' || $mandatory= [];
            }
            
            $noof_year=$chkValue['noof_year'];

            if($chkValue['check_id'] == 59){
                  if(!empty($chkValue['no_ofcheck']) && $chkValue['no_ofcheck'] < UNLIMITED && (!empty($noof_year) && $noof_year < UNLIMITED)){
                    $no_ofcheck= " - Add {$chkValue['no_ofcheck']} Employment details for last {$noof_year} Years of service";
                  }
                  else if(!empty($chkValue['no_ofcheck']) && $chkValue['no_ofcheck'] == UNLIMITED && (!empty($noof_year) && $noof_year < UNLIMITED)){
                    $no_ofcheck= " - Add all Employment details for last {$noof_year} Years of service ";
                  } 
                  else if(!empty($chkValue['no_ofcheck']) && $chkValue['no_ofcheck'] < UNLIMITED && (!empty($noof_year) && $noof_year == UNLIMITED)){
                    $no_ofcheck= " - Add last {$chkValue['no_ofcheck']} Employment details";
                  } 
                  else if(!empty($chkValue['no_ofcheck']) && $chkValue['no_ofcheck'] == UNLIMITED && (!empty($noof_year) && $noof_year == UNLIMITED)){
                    $no_ofcheck= " - Add all Employment details";
                  }else{
                    $no_ofcheck= '' || $no_ofcheck= [];
                  }
              }else if($chkValue['check_id'] == 640){
                    if(!empty($chkValue['no_ofcheck']) && $chkValue['no_ofcheck'] < UNLIMITED && (!empty($noof_year) && $noof_year < UNLIMITED)){
                        $no_ofcheck= " - Add {$chkValue['no_ofcheck']} address details for last {$noof_year} Years";
                      }
                      else if(!empty($chkValue['no_ofcheck']) && $chkValue['no_ofcheck'] == UNLIMITED && (!empty($noof_year) && $noof_year < UNLIMITED)){
                        $no_ofcheck= " - Add address details for last {$noof_year} Years";
                      } 
                      else if(!empty($chkValue['no_ofcheck']) && $chkValue['no_ofcheck'] < UNLIMITED && (!empty($noof_year) && $noof_year == UNLIMITED)){
                        $no_ofcheck= " - Add {$chkValue['no_ofcheck']} address details";
                      } 
                      else if(!empty($chkValue['no_ofcheck']) && $chkValue['no_ofcheck'] == UNLIMITED && (!empty($noof_year) && $noof_year == UNLIMITED)){
                        $no_ofcheck= " - Add address details";
                      }else{
                        $no_ofcheck= '' || $no_ofcheck= [];
                      }
              }else{
                $no_ofcheck=($chkValue['no_ofcheck']) ? ' - '.$chkValue['no_ofcheck'] : ' - 1';
              }

            
              
            $chknotes=(empty($chkValue['checknotes'])) ? '' :' - '.$chkValue['checknotes'];

            $checkName[]='<br><span class="checksnotes" >&nbsp;'.$j.'. '.$chkValue['name'].$no_ofcheck.$mandatory.$chknotes.'<input type="hidden" class="pkgId'.$ordervalue['id'].'" value="'.$chkValue['check_id'].'"></span><br>';

            $input_Field[]="<div style='padding:5px;' class='pkgdes pkgRow".$ordervalue['id']."' id='".$ordervalue['id']."'><input type='text'  class='de_text' autocomplete='off' id ='".$chkValue['id']."_information' disabled  name ='".$chkValue['id']."_informations' value = '' /></div>";

            $j++;
        }
        
        $chkname=implode(" ", $checkName);
        $description=implode(" ", $input_Field);

        $Button='<span id="'.$ordervalue['id'].'" class=" desc_add" value="'.$ordervalue['id'].'">[+Add]<span class="tooltiptext">Add Description</span></span><br>';

        
        $table .= "<td class='' style='width:320px;' id='".$ordervalue['id']."'>".$chkname."</td>";
        $table .="<td class='description".$ordervalue['id']."' style='width:200px;position: relative;' id='".$ordervalue['id']."'>".$Button.$description."</td>";
    //}
        /*
        if($ordervalue['id']==95){
            $table .= "<td  class='text_box at_td_e '> Any Two Degree </td> <td  class='text_box at_td_em'> Any Number of Employments (in the last 7yrs) </td><td  class='text_box at_td_l'>Last Employment</td>";
        }
        if($ordervalue['id']==96){
            $table .= "<td  class='text_box at_td_e'> One Degree </td> <td  class='text_box at_td_em'> Any Number of Employments (in the last 7yrs) </td><td  class='text_box at_td_l'>Last Employment</td>";
        }
        if($ordervalue['id']==97){
            $table .= "<td  class='text_box at_td_e'> One Degree </td> <td  class='text_box at_td_em'> Two Employement </td><td  class='text_box at_td_l'>Last Employment</td>";
        }
        if($ordervalue['id']==98){
            $table .= "<td  class='text_box at_td_e'> N/A </td> <td  class='text_box at_td_em'> Any Number of Employments (in the last 7yrs) </td><td  class='text_box at_td_l'>Last Employment</td>";
        }
        if($ordervalue['id']==99){
            $table .= "<td  class='text_box at_td_e'> One Degree </td> <td  class='text_box at_td_em'> Last Employment </td><td  class='text_box at_td_l'>Last Employment</td>";
        }
        if($ordervalue['id']==100){
            $table .= "<td  class='text_box at_td_e'> N/A </td> <td  class='text_box at_td_em'> Any Number of Employments (in the last 7yrs) </td><td  class='text_box at_td_l'>N/A</td>";
        }
        if($ordervalue['id']==101){
            $table .= "<td  class='text_box at_td_e'> One Degree </td> <td  class='text_box at_td_em'> Last Employment </td><td  class='text_box at_td_l'>N/A</td>";
        }
        if($ordervalue['id']==102){
            $table .= "<td  class='text_box at_td_e'> N/A </td> <td  class='text_box at_td_em'> Last Employment </td><td  class='text_box at_td_l'>Last Employment</td>";
        }
        if($ordervalue['id']==103){
            $table .= "<td  class='text_box at_td_e'> One Degree </td> <td  class='text_box at_td_em'> N/A </td><td  class='text_box at_td_l'>N/A</td>";
        } */
        $table .= "</tr>";  
        $table .= "</table></td></tr>";
        $cn++;
        }
        }
        // echo  $table .= "<tr  height='35' ><td colspan='4' style='border-bottom: none;' >&nbsp;</td></tr><tr  height='35' ><td colspan='4' style='border-top: none;border-bottom: none;' ><input class='button' id='subtn' style='float:right;margin-right: 125px;' type='submit' value='Submit'></td></tr><tr  height='35' ><td colspan='4' style='border-top: none;' >&nbsp;</td></tr></table>";
        echo  $table;
    } 
/**********************************
* candidate_reports_view page
* candidate_reports_view
*************************************/
    function candidate_reports_view()
    {  
        $this->_check_userlogin ();
        $request_id = base64_decode($this->uri->segment(3));
        $candidate_info = $this->rm->get_candidateionfo($request_id);
        $data['candidate_info'] = $candidate_info;
        $checks=$this->rm->getcheck($request_id);  
        $verification_data = $this->rm->getchecks($request_id); 
        $data['checkdata']=$verification_data;
        foreach($verification_data as $key => $ci)
        {
        if($ci['check_id']>94){
            $checknames[$ci['pack_id'].''.$ci['check_id']]=$ci['name'];
        }
        else{
            $checknames[$ci['check_id']]=$ci['name'];
        }
        $chk=implode(' + ',$checknames);
        $data['check_type']=$chk;
        }
        $qccheck="qc2";
        $data['result']=$this->generate_pdf($request_id,$qccheck);
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Candidaie Reports', 'reports/candidate_report');
        $data['breadcrumb']=$this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'candidate_reports_view');
    }
/********************************************
* Export all cases list
* export_allcaselist
********************************/ 
  function export_allcaselist($office_id = 0 ){   
     $model = array(self::$client_model=>'get_export_allcaselist');
        $dataentry = ($_POST['exp_a_type']) ? $_POST['exp_a_type'] : '';
        $name = ($_POST['exp_name']) ? $_POST['exp_name'] : ''; 
        $a_status = ($_POST['exp_a_status']) ? $_POST['exp_a_status'] : '';
        $date_filter = ($_POST['exp_date_filter']) ? $_POST['exp_date_filter'] : '';
        $c_date = ($_POST['exp_c_date']) ? $_POST['exp_c_date'] : '';
        $t_date = ($_POST['exp_t_date']) ? $_POST['exp_t_date'] : ''; 
        $createdby = ($_POST['exp_createdby']) ? $_POST['exp_createdby'] : ''; 
        $org_id = ($_POST['exp_org_id']) ? $_POST['exp_org_id'] : '';
        $office = ($_POST['exp_office_id']) ? $_POST['exp_office_id'] : '';
        $parent_office = ($_POST['exp_parent_office']) ? $_POST['exp_parent_office'] : '';
        $sub_office = ($_POST['exp_sub_office']) ? $_POST['exp_sub_office'] : '';
        $client_ref_number=($_POST['exp_client_ref_number']) ? $_POST['exp_client_ref_number'] : '';
        $case_number=($_POST['exp_case_number']) ? $_POST['exp_case_number'] : '';
        $term=($_POST['exp_search_term']) ? $_POST['exp_search_term'] : '';
        $interim=($_POST['exp_interim']) ? $_POST['exp_interim'] : '';
        $rpstatus=($_POST['exp_rpstatus']) ? $_POST['exp_rpstatus'] : '';
        $case_status=($_POST['exp_case_status']) ? $_POST['exp_case_status'] : '';
        $frp_fdate=($_POST['exp_fp_fdate']) ? $_POST['exp_fp_fdate'] : '';
        $frp_tdate=($_POST['exp_fp_tdate']) ? $_POST['exp_fp_tdate'] : '';
        $reopen_status=($_POST['exp_reopen_status']) ? $_POST['exp_reopen_status'] : '';        
        $typeofemp=($_POST['exp_typeofemp']) ? $_POST['exp_typeofemp'] : '';        
        $payment_status=($_POST['exp_payment_status']) ? $_POST['exp_payment_status'] : '';
        //20/02/2023
        $email = ($_POST['exp_email']) ? $_POST['exp_email'] : '';   
        //23/06/2023 edited by amrita
       $caseStatus=($_POST['exp_caseStatus']) ? $_POST['exp_caseStatus'] : ''; 
        if($dataentry !=0 && $dataentry !=4 ){
            $condition[]=" a.dataentry_by = ".$dataentry;
        }
        if($dataentry ==4){
            $condition[]=" a.dataentry_by = 0";
        }
        if($parent_office){
            $condition[]=" d.id = ".$parent_office;
        }
        if($office){
            $condition[]=" b.id = ".$office;
        }
        if($org_id){
            $condition[]=" c.id = ".$org_id;
        }
        if($sub_office){
            $condition[]=" o.id = ".$sub_office;
        }
        if($name){
            $condition[]=" a.candidate_name like '%".$name."%'";
        }
       if($createdby){
            $condition[]=" (concat_ws(' ',f.first_name,f.last_name) like '%".$createdby."%') ";
       }
        if($client_ref_number){
            $condition[]=" a.client_ref_number like '%".$client_ref_number."%'";
        }
        if($interim ==1){
            $condition[]=" ar.qc2_report_publish = 1 and ar.qc2_verification=1";
        }
        if($interim ==2){
            $condition[]="ar.qc2_report_publish = 1 and a.final_report=1";
        }
       if($interim ==3){
            $condition[]="ca.request_id IS NOT NULL";
       }
        if($interim ==4){
            $condition[]=" a.supplement_report = 1 ";
        }
        if($case_number){
            //edited by amritha on 23/06/2023
            $case_number =trim($case_number);
            $condition[]=" a.case_no like '%".$case_number."'";
        }
         if($typeofemp){
            $condition[]=" t.type_of_employees like '%".$typeofemp."'";
        }
        if(!empty($c_date) && $date_filter==1){
            $condition[]="DATE_FORMAT(a.case_accepted_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and cv.client_status=1 and case when a.dataentry_by=3 Then DATE_FORMAT(a.case_recieved_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' else 1 end ";
        }
        if(!empty($t_date) && $date_filter==1){
            $condition[]="DATE_FORMAT(a.case_accepted_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and cv.client_status=1 and case when a.dataentry_by=3 Then DATE_FORMAT(a.case_recieved_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' else 1 end ";
        }
        if(!empty($c_date) && $date_filter==2){
            $condition[]="DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and a.final_report=1 ";
        }
        if(!empty($t_date) && $date_filter==2){
            $condition[]="DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and a.final_report=1 ";
        }
        if(!empty($c_date) && $date_filter==3){
            $condition[]="DATE_FORMAT(a.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date) && $date_filter==3){
            $condition[]="DATE_FORMAT(a.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        if(!empty($c_date) && $date_filter==4){
            $condition[]="DATE_FORMAT(cv.candidate_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and a.dataentry_by=0 ";
        }
        if(!empty($t_date) && $date_filter==4){
            $condition[]="DATE_FORMAT(cv.candidate_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and a.dataentry_by =0 ";
        }
        if(!empty($c_date) && $date_filter==5){
            $condition[]="DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and a.dataentry_by != 3 ";
        }
        if(!empty($t_date) && $date_filter==5){
            $condition[]="DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and a.dataentry_by != 3 ";
        }
        if(!empty($c_date) && $date_filter==6){
            $condition[]="DATE_FORMAT(cv.des_rejected_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date) && $date_filter==6){
            $condition[]="DATE_FORMAT(cv.des_rejected_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        if(!empty($c_date) && $date_filter==7){
            $condition[]="DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date) && $date_filter==7){
            $condition[]="DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
          if(!empty($c_date) && $date_filter==8){
            $condition[]="DATE_FORMAT(vl.qc2_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and ar.qc2_report_publish=1 ";
        }
        if(!empty($t_date) && $date_filter==8){
            $condition[]="DATE_FORMAT(vl.qc2_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and ar.qc2_report_publish=1 ";
        }
        if($a_status==1){
            $condition[]=" a.assainee_status =1" ;
        }
        if($a_status==2){
            $condition[]=" a.assainee_status !=1" ;
        }
        if($rpstatus==1){
            $condition[]="a.report_status like '%RED%'";
        }
        if($rpstatus==2){
            $condition[]="a.report_status like '%ORANGE%'";
        }
        if($rpstatus==3){
            $condition[]="a.report_status like '%GREEN%'";

        }

   if( (empty($fromDate) || empty($toDate)) && $caseStatus =='accept_case'){
            $condition[]=" (a.assainee_status = 1 and cv.reverted_by=0) and DATE_FORMAT(cv.client_submit_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 2 WEEK) AND CURRENT_DATE()" ;
        }
        
        if( (!empty($fromDate) || !empty($toDate)) && ($caseStatus =='accept_case') ){
            
            $condition[]=" ((DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) and (a.assainee_status = 1 and cv.reverted_by=0)";
        }

        if( (empty($fromDate) || empty($toDate)) && $caseStatus =='reject_case'){
            $condition[]=" cv.reverted_by!=0 and (DATE_FORMAT(cv.des_rejected_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 2 WEEK) AND CURRENT_DATE())" ;
        }
        if( (!empty($fromDate) || !empty($toDate)) && $caseStatus =='reject_case' ){
            $condition[]=" ((DATE_FORMAT(cv.des_rejected_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(cv.des_rejected_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) and (cv.reverted_by!=0)";
        }

        
        if($case_status ==1){
            $condition[]="(a.dataentry_by NOT IN(0,3) && a.assignee_id=0 && a.assainee_status=0 && a.entry_status=0 && cv.client_status is NULL )";
        }
        if($case_status ==2 || $caseStatus=='pending_cand'){
            $condition[]="(a.dataentry_by=0 && cv.client_status is NULL and t.status=1)";
        }
        if($case_status ==3 || $caseStatus=='profile_comp'){
        $condition[]="(a.dataentry_by=0 && cv.status=1 && a.entry_status=0 && cv.client_status=0 )";
        }
        if($case_status ==4 ){
        $condition[]="((cv.client_status=1 && (cv.operator_status=1 || cv.operator_status=0) && cv.verification_status=0 && (a.revert_status=0 || a.revert_status=3) && cv.reverted_by=0 && cv.client_verified=0))";
        }

        
        if($case_status ==5 || $caseStatus=='initiated'){
        $condition[]="(cv.verification_status=1 and a.final_report=0 and ar.qc2_report_publish = 0)";
        }
        if($case_status ==11){
        $condition[]="(ar.verify_status = 684 )";
        }
        if($case_status ==6){
        $condition[]="(cv.verification_status=1 and a.final_report=1 )";
        }
        if($case_status ==7){
        $condition[]="(cv.reverted_by!=0)";
        }

        if($case_status ==8){
        $condition[]="( cv.status=0 && a.dataentry_by=0 && cv.candidate_status=0 && cv.client_verified=2)";
        }
        if($case_status ==9){
        $condition[]="( cv.status=1 && a.dataentry_by=0 && cv.candidate_status=0 && cv.client_verified=3)";
        }
        if($case_status ==10){
            $condition[]=" ( a.dataentry_by=0 and cv.client_status is NULL and t.status=0 ) ";
        }
        if($case_status ==12){
            $condition[]=" ( a.dataentry_by=0 and t.status=2 ) ";
        } 
        if($reopen_status==1 || $caseStatus=='reopen_pending'){
            $condition[]=" a.supplement_report=2 ";
        }   
        if($reopen_status==2){
            $condition[]=" a.supplement_report=1 ";
        } 
        if($payment_status){
            $condition[]="a.payment_status=".$payment_status;
        }

        if( (empty($fromDate) || empty($toDate)) && $caseStatus=='submited_dcode'){
        $condition[]=" (a.assainee_status = 1 and (cv.reverted_by=0 or cv.reverted_by!=0)) and DATE_FORMAT(cv.client_submit_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 1 MONTH) AND CURRENT_DATE()" ;
        }

        if( (!empty($fromDate) || !empty($toDate)) && $caseStatus=='submited_dcode'){
        $condition[]=" ((DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) and (a.assainee_status = 1 and (cv.reverted_by=0 or cv.reverted_by!=0)) ";
        }
        if( (empty($fromDate) || empty($toDate)) && $caseStatus=='fGreen'){
            $condition[]="(ar.qc2_report_publish = 1 and a.final_report=1 and a.report_status like '%GREEN%') and (DATE_FORMAT(a.final_report_published_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 2 WEEK) AND CURRENT_DATE())";
        }
        if( (!empty($fromDate) || !empty($toDate)) && $caseStatus=='fGreen'){
            $condition[]=" (ar.qc2_report_publish = 1 and a.final_report=1 and a.report_status like '%GREEN%') and ((DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) ";
        }

        if( (empty($fromDate) || empty($toDate)) && $caseStatus=='fOrange'){
            $condition[]="(ar.qc2_report_publish = 1 and a.final_report=1 and a.report_status like '%ORANGE%') and (DATE_FORMAT(a.final_report_published_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 2 WEEK) AND CURRENT_DATE())";
        }
        if( (!empty($fromDate) || !empty($toDate)) && $caseStatus=='fOrange'){
            $condition[]=" (ar.qc2_report_publish = 1 and a.final_report=1 and a.report_status like '%ORANGE%') and ((DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) ";
        }

        if( (empty($fromDate) || empty($toDate)) && $caseStatus=='fRed'){
            $condition[]="(ar.qc2_report_publish = 1 and a.final_report=1 and a.report_status like '%RED%') and (DATE_FORMAT(a.final_report_published_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 2 WEEK) AND CURRENT_DATE())";
        }
        if( (!empty($fromDate) || !empty($toDate)) && $caseStatus=='fRed'){
            $condition[]=" (ar.qc2_report_publish = 1 and a.final_report=1 and a.report_status like '%RED%') and ((DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) ";
        }
        if( (empty($fromDate) || empty($toDate)) && $caseStatus=='supGreen'){
            $condition[]="(a.supplement_report = 1 and a.report_status like '%GREEN%') and (DATE_FORMAT(a.supplement_report_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 2 WEEK) AND CURRENT_DATE())";
        }
        if( (!empty($fromDate) || !empty($toDate)) && $caseStatus=='supGreen'){
            $condition[]=" (a.supplement_report = 1 and a.report_status like '%GREEN%') and ((DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) ";
        }

        if( (empty($fromDate) || empty($toDate)) && $caseStatus=='supOrange'){
            $condition[]="(a.supplement_report = 1 and a.report_status like '%ORANGE%') and (DATE_FORMAT(a.supplement_report_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 2 WEEK) AND CURRENT_DATE())";
        }
        if( (!empty($fromDate) || !empty($toDate)) && $caseStatus=='supOrange'){
            $condition[]=" (a.supplement_report = 1 and a.report_status like '%ORANGE%') and ((DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) ";
        }

        if( (empty($fromDate) || empty($toDate)) && $caseStatus=='supRed'){
            $condition[]="(a.supplement_report = 1 and a.report_status like '%RED%') and (DATE_FORMAT(a.supplement_report_date, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 2 WEEK) AND CURRENT_DATE())";
        }
        if( (!empty($fromDate) || !empty($toDate)) && $caseStatus=='supRed'){
            $condition[]=" (a.supplement_report = 1 and a.report_status like '%RED%') and ((DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') and  (DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')) ";
        }

       //20/02/2023
        if($email){
            $condition[]=" t.email like '%".$email."%'";

        }
  
        if($term)
        {
    //support multiple words
    $search = explode(' ', $term);

    foreach($search as $t) {
        $not        = '';
        $operator    = 'OR';
        if(substr($t,0,1) == '-')
        {
        $not        = 'NOT ';
        $operator    = 'AND';
        //trim the - sign off
        $t        = substr($t,1,strlen($t));
        }
        $like    = '';
        $like    .= " ( a.candidate_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." c.org_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." b.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." d.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.client_ref_number ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.report_status ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.final_report_published_date".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
        $like    .= $operator." a.case_accepted_date ".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
        $like    .= $operator." a.case_recieved_date ".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
        $like    .= $operator." a.created_on".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
        $like    .= $operator." cv.candidate_submit_date".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
         $like    .= $operator." cv.client_submit_date".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
         $like    .= $operator." cv.des_rejected_date".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
         $like    .= $operator." a.supplement_report_date ".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
        $like    .= $operator." f.first_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.reason ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.case_no ".$not."LIKE '%".$t."%' ) " ;
        //20/02/2023
        $like    .= $operator." t.email ".$not."LIKE '%".$t."%' " ;

        $condition[]=$like;
               
            }
        }
        $manual_cond=implode(' and ',$condition);

        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];  
        $result = $results[1]; 
         
        if ($result) {
           $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;

             $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Head Office");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Branch Office");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Sub Office");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Reference Number");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Type of Employee");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Request Status");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "Type of Entry");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Case Status");

            $objPHPExcel->getActiveSheet()->setCellValue('M1', "Candidate Profile Submitted");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "Report Status");
            $objPHPExcel->getActiveSheet()->setCellValue('O1', "Interim Report");
            $objPHPExcel->getActiveSheet()->setCellValue('P1', "Final Report");
            $objPHPExcel->getActiveSheet()->setCellValue('Q1', "Supplementary Report");
            $objPHPExcel->getActiveSheet()->setCellValue('R1', "Updated Reports");
            $objPHPExcel->getActiveSheet()->setCellValue('S1', "Reopen Status");
            $objPHPExcel->getActiveSheet()->setCellValue('T1', "Final Report Published Date");
            $objPHPExcel->getActiveSheet()->setCellValue('U1', "Supplementary Published Date");
            $objPHPExcel->getActiveSheet()->setCellValue('V1', "Created By");
            $objPHPExcel->getActiveSheet()->setCellValue('W1', "Case Accepted / Recieved Date");
            $objPHPExcel->getActiveSheet()->setCellValue('X1', "Creation Date");
            $objPHPExcel->getActiveSheet()->setCellValue('Y1', "Candidate profile Submitted Date");
            $objPHPExcel->getActiveSheet()->setCellValue('Z1', "Submitted to Dcode Date");
            $objPHPExcel->getActiveSheet()->setCellValue('AA1', "Rejected by Dcode Date");
            $objPHPExcel->getActiveSheet()->setCellValue('AB1', "email");
            

            $ci=2; 
            foreach ( $result as $i => $row ) {
             
             $checkstatus = $this->cm->get_currentstatus($row['request_id']);
               $verifiedlevelstatus = $this->cm->get_verifiedlevelstatus($row['request_id']);
            if(in_array("684",explode(',', $checkstatus['vmstatus'])))
            {
               $status='Initiated (Request raised)';    
            }
            else if($checkstatus['verification_status']==1 && $checkstatus['team_mem_id'] ==''){
                $status='Initiated';
            }
            else if($checkstatus['verification_status']==1 && $checkstatus['team_mem_id'] <>'' && $checkstatus['vm_revert_to']==0 && $checkstatus['vm_revert_option_status']!=2 && $checkstatus['vm_revert_option_status']!=4){
                $status='Initiated';
            }
            else if(!empty($checkstatus['reason']) && $checkstatus['status']==0 && $row['dataentry_by']==0 && $row['client_verified']==2){
                $status='Revert Raised';
            }
            else if($checkstatus['status']==1 && $row['dataentry_by']==0 && $row['client_verified']==3){
                $status='Revert Closed';
            }
            else if($checkstatus['verification_status']==0 && $checkstatus['client_status']==1 && $checkstatus['vm_revert_option_status']==0 && $checkstatus['reverted_by']==0){
                $status='Submitted to Dcode';
            }
            else if($checkstatus['verification_status']==0 && $checkstatus['operator_status']==2){
                $status='Revert';
            }
            else if($checkstatus['revert_status']==0 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus[$this->role_id_text]==13 && $checkstatus['assainee_status']==0){
                $status='Revert Closed';
            }
            else if($checkstatus['revert_status']==1 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus[$this->role_id_text]==13){
                $status='Revert Assigned';
            }
            else if($checkstatus['revert_status']==0 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus[$this->role_id_text]==12 && $checkstatus['assainee_status']==0){
                $status='Revert Closed';
            }
            else if($checkstatus['revert_status']==1 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus[$this->role_id_text]==12){
                $status='Revert Assigned';
            }
            else if($checkstatus['reverted_by']==0 && !empty($checkstatus['reverted_reason']) && $checkstatus['assainee_status']==1){
                $status='Submitted to Dcode';
            }
            else if($checkstatus['reverted_by']!=0 && !empty($checkstatus['reverted_reason'])){
                $status='Reject Assigned';
            }
            else if($checkstatus['reverted_by']==0 && !empty($checkstatus['reverted_reason'])){
                $status='Reject Rectified';
            }
            else if($checkstatus['vm_revert_to']==3 && $checkstatus['vm_revert_by']==5 && $checkstatus['vm_revert_supervisor']==1){
                $status='Revert Assigned';
            }
            else if($checkstatus['vm_revert_option_status']==2){
                $status='Revert Assigned';
            }
            else if($checkstatus['vm_revert_option_status']==4){
                $status='Revert Closed';
            }
            else if($checkstatus['operator_status']==0 && $checkstatus['revert_status']==2){
                $status='Revert Admin';
            }
            else if($checkstatus['client_status']==1 && $checkstatus['revert_status']==1){
                $status='Revert DES';
            }
            else if($checkstatus['verification_status']==0 && $checkstatus['operator_status']==1 && $checkstatus['vm_revert_option_status']==0 && $row['dataentry_by']!=0){
                $status='Submitted to Dcode';
            }
            else if($row['dataentry_by']==0 && $checkstatus['status']!=1 && $row['status']==1){
                $status = 'Pending';
            }
            else if($row['dataentry_by']==0 && empty($checkstatus['status']) && $row['status']==0 ){
                $status = 'Deactivated';
            }
            else if($row['dataentry_by']==0  && $row['status']==2 ){
                $status = 'NOT TO BE SUBMITTED TO DCODE';
            }
            else if($checkstatus['status']==1 && $row['dataentry_by']==0 ){
                $status = 'Candidate Profile  Completed';
            }
            else if($checkstatus['client_status']==1 && $checkstatus['operator_status']==0 && $checkstatus['assignee_id']<>0 && $row['dataentry_by']==0){
                $status = 'Submitted to Dcode';
            }
            else if($checkstatus['client_status']==1 && $checkstatus['operator_status']==0 && $checkstatus['assignee_id']==0 && $row['dataentry_by']==0){
                $status='Submitted to Dcode';
            }
            else{
                $status = 'New';
            }
             $request_status = 'New';
            if($row['assainee_status']==1){
                $request_status = 'Assigned';
            } 
            else if($row['dataentry_by']==1){
                $request_status= 'New';
            if($status=='Allotted to DES'){
                $request_status= 'Assigned';
            }
            else if($status=='Revert Closed'){
                $request_status= 'Assigned';
            }
            else {
                $request_status = 'New';
               
            }
            } 
            else if($row['dataentry_by']==2){
                if($status=='Revert Closed'){
                    $request_status= 'Assigned';
                }
            }
            else {
                    if($this->session->userdata['user_type'] == 2 ) {
                    $request_status= 'New';
                   
                            if($status=='Allotted to DES'){
                            $request_status= 'Assigned';
                            }
                            else{
                             $request_status = 'New';
                             
                            }
                    }
                    else{
                        if($status=='Revert DES'){
                          $request_status ='Revert Raised';
                          
                        }
                        else{
                            $request_status= 'New';
                          
                        }
                    }
            }
            if($status=='Revert Assigned' && $row['dataentry_by']==3){
                          $request_status= 'Revert Raised';
                        
                        }
            if($status=='Revert Assigned' && $row['dataentry_by']==1 || $status=='Revert Assigned' && $row['dataentry_by']==2){
                          $request_status= 'Revert Raised';
                          
                        }
            if($status=='Reject Assigned'){
                          $request_status= 'Reject';
                         
                        }
            if($status=='Reject Rectified'){
                          $request_status= 'Assigned';  
                        }
            $type='';
            if($row['dataentry_by']==1){
                $type='Partial Entry';
            }
            else if($row['dataentry_by']==2){
                $type='Full Entry';
            }
            else if($row['dataentry_by']==3){
                $type='Offline Entry';
            }
            else if($row['dataentry_by']==0){
                $type='Candidate Entry';
            }
            if($status=='Revert to DES' && $row['revert_status']==1 && $row['assainee_status']==1){
                $request_status= 'DEC';
            }
            else if($row['revert_status']==1 && $row['assainee_status']==1){
                $request_status= 'Revert Closed';
            }
            if($row['parent']==0){
                $officevalue=$row[$this->request_parent_office];
                $branchofficevalue=$row['office_name'];
            }else if($row['parent']!=0){
                $officevalue=$row['office_name'];
                $branchofficevalue=$row[$this->request_parent_office];
            }
   $created_on='';
   if($row['dataentry_by']!=3 && $row['case_accepted_date']!="0000-00-00 00:00:00" && !empty($row['case_accepted_date']))
        {
            $created_on=date('d-m-Y',strtotime($row['case_accepted_date']));
        } 
        else if($row['dataentry_by']==3 && $row['case_recieved_date']!="0000-00-00" && !empty($row['case_recieved_date']))
        {
            $created_on=date('d-m-Y',strtotime($row['case_recieved_date']));
        }
        $frp_date='';
         if($row['final_report_published_date']){
            $frp_date=date('d-m-Y',strtotime($row['final_report_published_date']));
        }
        if($row['dataentry_by']==3)
        {
            $cname='Dcode';
        }
        else
        {
            $cname=$row['first_name'];
        }
 
$pending_chkint = $this->rm->getchecksintverify($row['request_id']);
$cntck=count($pending_chkint);
        $interim='';
        foreach($pending_chkint as $chks){ 
        if($chks['qc2_report_publish']==1){   
        $interim='Interim';
    }
    }
    $pending_checksa = $this->rm->getchecksverify($row['request_id']);
    $finalreport_checksa = $this->rm->getcountcheck($row['request_id']);
    $count_pending_checksa = $this->rm->getcountchecksverify($row['request_id']);
    $count_date_checksa = $this->rm->getfinalupdateedate($row['request_id']);
    $namw=count($finalreport_checksa);
    $sum=0;
    foreach($count_pending_checksa as $count_pending_val){
    $sum+=$count_pending_val['no_checks'];
    }
    if(!empty($verifiedlevelstatus['qc2fielddata'])){
    if($sum<=$namw){
         $status='Report Published';
    $final='Final';
   
    }
    else{
        $final='';
    }
    }else{
    $final='';
    }
 /*completed percentage*/
    $personaldetails=$this->dm->personaldetails($row['request_id']);
    $decleration_details = $this->dm->declerationdetails($row['request_id']);
    $other_details = $this->dm->otherdetails($row['request_id']);
    $checklevels=$this->dm->checklevels($row['request_id']);
    $count_checks=$this->dm->count_checks($row['request_id']);
    $total_check =0;
    foreach ($checklevels as  $clevels) 
    {
    $slug = url_title(convert_accented_characters($clevels['name']), 'underscore', TRUE);
    if($clevels['id']<95 || $clevels['id']>330){
    $form_details=$this->dm->$slug($row['request_id'],$clevels['id']);
    }
    $total_check = $total_check +count($form_details);

    }
    $count1 = count($personaldetails)+count($decleration_details)+count($other_details)+$total_check;
    $count2 = $count_checks['chk_count']+3;
    $prog = round(($count1/$count2)*100,2);
    if($prog > 100)
    {  
        $progress = '100%';
    }
    else 
    {
        $progress = $prog.'%';
    }
    /* report status*/
    $rep_status=$this->cm->get_verified_data_with_checkid($row['request_id']);
    $report_status='';
    $publish_status=''; 
    $rstatus1=[];
    if($rep_status){
        $orange_check = 0; //  Apr 16th
        foreach($rep_status as $k => $rps)
        {     
            $rid=$row['request_id'];  
            if(!empty($rps['qc2fielddata'])){    
                $qc2_data=toArray(json_decode($rps['qc2fielddata']));   
                if($qc2_data['status']){
                    $pstatus[$rid][]=$this->vm->get_status($qc2_data['status']); 
                    if($rps['check_id'] != 1306){ //if not gap check April 16th
                        if($qc2_data['status'] == "519") //others
                        {
                            $ostatus[] = $this->vm->get_status($qc2_data['ostatus']); 
                            $orange_check++;
                        }
                        if($qc2_data['status'] == 110) // stop check
                        {
                            $orange_check++;
                        }
                    } // Apr 16th
                }
                if($qc2_data['status1']){
                    $pstatus[$rid][]=$this->vm->get_status($qc2_data['status1']);                
                }
             }
        }  
        foreach($pstatus[$rid] as $rp)
        {
        $rstatus1[]=$rp['name'];
        }
         /** Aug 24th **/
        // foreach($ostatus as $orp)
        // {
        //     $orstatus[]=$orp['name'];
        // }   
        /** Aug 24th **/  
        /*** Dec 13th ***/
        if(!empty($ostatus))
            $count_others_orange = 0;
        else
            $count_others_orange = -1;
        /**
         * In dcode_master_masterdata table
         * 699 -  Not Applicable
         * 750 - Not applicable  
         */
        foreach($ostatus as $orp) // For Others - Not Applicable -  Only this check in Others is to  be GREEN
        {
            $orstatus[]=$orp['name'];
            $others_id  = $orp['id']; // Dec 13th 
            if($others_id != 699 && $others_id != 750)  // Dec 13th
                $count_others_orange++;  // Count of  orange others checks 

        }
        
        /*** Dec 13th ***/
        if (in_array("Discrepant", $rstatus1) || in_array("Possible Discrepant" , $rstatus1) || in_array("Record Found" , $rstatus1) || in_array("Positive" , $rstatus1) || in_array("No Records" , $rstatus1) || in_array("High Risk" , $rstatus1) || in_array("Invalid" , $rstatus1) || in_array("Not Completed" , $rstatus1))
        { 
            $report_status ="RED";
        }
        // Pasted here on April 15th
        else if ((in_array("Stop Check" , $rstatus1) &&  $orange_check>0) || (in_array("Others" , $rstatus1) && ($count_others_orange > 0) &&  $orange_check>0)  || (in_array("Others" , $rstatus1) && ($count_others_orange == -1) &&  $orange_check>0) || in_array("Possible Match" , $rstatus1) || in_array("Record Not Found" , $rstatus1) || in_array("Partial Match" , $rstatus1) || in_array("Record not complete" , $rstatus1)) {
            $report_status ="ORANGE";
        }
        /** Pasted here on Apr 16th **/
        else if(in_array("Others" , $rstatus1) && (in_array("Not applicable" , $orstatus) || in_array("Not Applicable" , $orstatus)) && ($count_others_orange == 0) ) 
        {
             $report_status ="GREEN";
        }
        /** Pasted here on Apr 16th **/
        else
        {
            $report_status ="GREEN";
        }
        $publish_status=$report_status;
        }
        /* supplementary report */
        $supplement='';
        if($row['supplement_report']==1){
        $supplement='Supplement';
        }
        $created_date=isset($row['created_on']) ? date('d-m-Y',strtotime($row['created_on'])):'';
        $cand_submit_date=(isset($row['candidate_submit_date']) && ($row['dataentry_by']==0)) ? date('d-m-Y',strtotime($row['candidate_submit_date'])):'';
        $client_submit_date=(isset($row['client_submit_date']) && ($row['dataentry_by']!=3)) ? date('d-m-Y',strtotime($row['client_submit_date'])):'';
        $des_rejected_date=(isset($row['des_rejected_date']) && ($row['dataentry_by']!=3)) ? date('d-m-Y',strtotime($row['des_rejected_date'])):'';
        $supplement_date=(isset($row['supplement_report_date'])) ? date('d-m-Y',strtotime($row['supplement_report_date'])):'';
        $reopen_stat='';
        if($row['supplement_report']==2)
        {
        $reopen_stat='Reopen';
        }
        elseif($row['supplement_report']==1){
        $reopen_stat='Reopen-Completed';
        }
         if($row['type_of_employees'] == 769){
            $typeofemp = 'Blue collared';
        }
        else if($row['type_of_employees'] == 770){
             $typeofemp = 'White collared';
        }
        else
        {
            $typeofemp='';
        }
        
   $objPHPExcel->getActiveSheet()->getStyle('A1:AB1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                                ->setCellValue('B' . $ci, $row['org_name'])
                                ->setCellValue('C' . $ci, $officevalue)
                                ->setCellValue('D' . $ci, $branchofficevalue)
                                ->setCellValue('E' . $ci, $row[$this->request_sub_office])
                                ->setCellValue('F' . $ci, $row['candidate_name'])
                                ->setCellValue('G' . $ci, $row['case_no'])
                                ->setCellValue('H' . $ci, $row['client_ref_number'])
                                ->setCellValue('I' . $ci, $typeofemp)
                                ->setCellValue('J' . $ci, $request_status)
                                ->setCellValue('K' . $ci, $type)
                                ->setCellValue('L' . $ci, $status)
                                ->setCellValue('M' . $ci, $progress)
                                ->setCellValue('N' . $ci, $publish_status)
                                ->setCellValue('O' . $ci, $interim)
                                ->setCellValue('P' . $ci, $final)
                                ->setCellValue('Q' . $ci, $supplement)
                                ->setCellValue('R' . $ci, $row['updated_reports'])
                                ->setCellValue('S' . $ci, $reopen_stat)
                                ->setCellValue('T' . $ci, $frp_date)
                                ->setCellValue('U' . $ci, $supplement_date)
                                ->setCellValue('V' . $ci, $cname)
                                ->setCellValue('W' . $ci, $created_on)
                                ->setCellValue('X' . $ci, $created_date)
                                ->setCellValue('Y' . $ci, $cand_submit_date)
                                ->setCellValue('Z' . $ci, $client_submit_date)
                               ->setCellValue('AA' . $ci, $des_rejected_date)
                               ->setCellValue('AB' . $ci, $row['email']);
                                $ci++;

                        } 
            $this->export_excel('A','AB','All_Case_List_details',$objPHPExcel);
            exit;        
                        }
          redirect('Client/client_caselist');


    }

    /*****************
    * Request Raised list page
    * request_raisedlist
    ******************/
    function request_raisedlist() { 
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Request Raised List', $this->request_raisedlist);
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'request_raisedlist');
    } 


    /*****************
    * Request raised listing of records ,status and history 
    * get_ticketlist
    ******************/
    function get_ticketlist($office_id = 0 ){  

        $model = array('client_model'=>'get_ticketlist');

        $ticket_no = ($_REQUEST['ticket_no']) ? $_REQUEST['ticket_no'] : ''; 
        $case_number=($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
        $email=($_REQUEST['email']) ? $_REQUEST['email'] : '';
        //$telephone=($_REQUEST['telephone']) ? $_REQUEST['telephone'] : '';
        $username = ($_REQUEST['username']) ? $_REQUEST['username'] : '';
        $ticket_status = ($_REQUEST['ticket_status']) ? $_REQUEST['ticket_status'] : ''; 
        $closed_by = ($_REQUEST['closed_by']) ? $_REQUEST['closed_by'] : '';
        $org_id = ($_REQUEST[$this->request_orgid]) ? $_REQUEST[$this->request_orgid] : '';
        $office = ($_REQUEST[$this->request_office]) ? $_REQUEST[$this->request_office] : '';
        $parent_office = ($_REQUEST[$this->request_parent_office]) ? $_REQUEST[$this->request_parent_office] : '';
        $sub_office = ($_REQUEST[$this->request_sub_office]) ? $_REQUEST[$this->request_sub_office] : '';
        $fp_fdate = ($_REQUEST['fp_fdate']) ? $_REQUEST['fp_fdate'] : ''; 
        $fp_tdate = ($_REQUEST['fp_tdate']) ? $_REQUEST['fp_tdate'] : '';
        // 25/04/2023 edited by amritha 

       $request_reason = ($_REQUEST['request_reason']) ? $_REQUEST['request_reason'] : ''; 

       
       if($request_reason){
            $condition[]=" rm.name like '%".$request_reason."'";
            
            
        }
        $tkt=explode('TKT-', $ticket_no);
        $tkt_no= $tkt[1];

        if($tkt_no){
            $condition[]=" td.ticket_no =".$tkt_no;
        }
        
        if($parent_office){
            $condition[]=" d.id = ".$parent_office;
        }
        if($office){
            $condition[]=" b.id = ".$office;
        }
        if($org_id){
            $condition[]=" c.id = ".$org_id;
        }
        if($sub_office){
            $condition[]=" o.id = ".$sub_office;
        }
        
        //22/01/2023
        $case_number = trim($case_number);
        if($case_number){
            $condition[]=" a.case_no like '%".$case_number."'";
        }

        if($email){
            $condition[]=" f.email like '%".$email."'";
        }
        // if($telephone){
        //     $condition[]=" pr.mobile like '%".$telephone."'";
        // }
  
        if(!empty($ticket_status)){
            $condition[]=" td.ticket_status =".$ticket_status ;
        }
        if(!empty($closed_by) && $ticket_status==101){
            $condition[]=" td.role_id =".$closed_by ;
        }

        if(!empty($fp_fdate) && $ticket_status==2){
            $condition[]="DATE_FORMAT(td.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fp_fdate))."' ";
        }
        if(!empty($fp_tdate) && $ticket_status==2){
            $condition[]="DATE_FORMAT(td.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($fp_tdate))."' ";
        }

        if(!empty($fp_fdate) && $ticket_status==4){
            $condition[]="DATE_FORMAT(td.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fp_fdate))."' ";
        }
        if(!empty($fp_tdate) && $ticket_status==4){
            $condition[]="DATE_FORMAT(td.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($fp_tdate))."' ";
        }

        if(!empty($fp_fdate) && $ticket_status==101){
            $condition[]="DATE_FORMAT(td.close_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fp_fdate))."' ";
        }
        if(!empty($fp_tdate) && $ticket_status==101){
            $condition[]="DATE_FORMAT(td.close_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($fp_tdate))."' ";
        }

        // if($reopen_status==2){
        //     $condition[]=" a.supplement_report=1 ";
        // } 
         
        if($term)
        {
        //support multiple words
        $search = explode(' ', $term);
        foreach($search as $t) {
        $not        = '';
        $operator    = 'OR';

        if(substr($t,0,1) == '-')
        {
        $not        = 'NOT ';
        $operator    = 'AND';
        //trim the - sign off
        $t        = substr($t,1,strlen($t));
        }

        $like    = '';
        $like    .= " ( a.candidate_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." c.org_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." b.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." d.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.client_ref_number ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.report_status ".$not."LIKE '%".$t."%' " ;        
        $like    .= $operator." f.first_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.reason ".$not."LIKE '%".$t."%' " ; 
        $like    .= $operator." rm.name ".$not."LIKE '%".$t."%' " ;      

        $condition[]=$like;
        }
        }

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0]; 
        $result = $results[1]; 
        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows; //echo '<pre>';print_r($result);exit;
        foreach ( $result as $i => $row ) {
         
        $type='';
        if($row['dataentry_by']==1){
            $type='Partial Entry';
        }
        else if($row['dataentry_by']==2){
            $type='Full Entry';
        }
        else if($row['dataentry_by']==3){
            $type='Offline Entry';
        }
        else if($row['dataentry_by']==0){
            $type='Candidate Entry';
        }


        if($row['parent']==0){
        $officevalue=$row[$this->request_parent_office];
        $branchofficevalue=$row['office_name'];

        }else if($row['parent']!=0){
            $officevalue=$row['office_name'];
            $branchofficevalue=$row[$this->request_parent_office];
        }

        if($row['chk']==0){
            $chkval=$row['name'];
        }else{
            $chkval=$row['name'].$row['chk'];
        }

        
        

        $roleid= $this->session->userdata('role_id'); 
        $usertype= $this->session->userdata('user_type');

        $ticket_noO='TKT-'.$row['ticket_no'];

        $employer="";

        if($row['check_id'] == 14){
            $this->db->select("affliated");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("request_id=",$row['request_id']);
            $ResRow=$this->db->get(DB_PREFIX.'education_details')->row_array();
            $employer=$ResRow['affliated'];
        }
        
        if($row['check_id'] == 15){
            $this->db->select("permanent_address");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("request_id=",$row['request_id']);
            $ResRow1=$this->db->get(DB_PREFIX.'permanent_contact_details')->row_array();
            $employer=$ResRow1['permanent_address'];
        }

        if($row['check_id'] == 16){
            $this->db->select("current_address");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("request_id=",$row['request_id']);
            $ResRow1=$this->db->get(DB_PREFIX.'contact_details')->row_array();
            $employer=$ResRow1['current_address'];
        }

        if($row['check_id'] == 59){
            $this->db->select("company_name");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("req_id=",$row['request_id']);
            $ResRow1=$this->db->get(DB_PREFIX.'employment')->row_array();
            $employer=$ResRow1['company_name'];
        }

        if($row['check_id'] == 68){
            $this->db->select("company_name");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("request_id=",$row['request_id']);
            $ResRow1=$this->db->get(DB_PREFIX.'professional_reference')->row_array();
            $employer=$ResRow1['company_name'];
        }
        if($row['check_id'] == 649){
            $this->db->select("company_name");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("request_id=",$row['request_id']);
            $ResRow1=$this->db->get(DB_PREFIX.'professional_reference_check_colleague')->row_array();
            $employer=$ResRow1['company_name'];
        }

        $openDate=date('d-m-Y h:i',strtotime($row['action_date']));

        $Modify='';
        $tstatus='';
        $ticketStatus="";
        if($row['ticket_status'] == 1){
            $tstatus='Open';
            $Modify=anchor('/Client/ticketmodify/'.base64_encode($row['request_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['level_id']),"<span style='color:green;'>Modify</span>");
        }

        if($row['ticket_status'] == 5){
            $tstatus='Re-Open';
            if($usertype != 2 && $roleid !=12 ){
                $Modify=anchor('/Client/ticketmodify/'.base64_encode($row['request_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['level_id']),"<span style='color:green;'>Modify</span>");
            }
        }

        $startDate=date('Y-m-d',strtotime($row['action_date']));
        $endDate=date('Y-m-d');
        $workingDays = $this->number_of_working_days($startDate, $endDate);

        if(($row['ticket_status'] == 1 || $row['ticket_status'] ==5) && $workingDays > 1)
        {
            $ticket_no="<span style='background-color:yellow;'>".$ticket_noO."</span>";
            $ticketStatus="<span style='background-color:yellow;'>".$tstatus."</span>";
        }else{
            $ticket_no=$ticket_noO;
            $ticketStatus=$tstatus;
        }

        if($usertype == 2 && ($roleid==12 || $roleid==13 || $roleid==14) )
        {
            if($row['ticket_status'] == 2 || $row['ticket_status'] == 4){
                $Modify=anchor('/Client/client_ticketmodify/'.base64_encode($row['request_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['level_id']),"<span style='color:green;'>Modify</span>");
            }else{
                $Modify='';
            }
            
        }

        $requestedDate='';
        if($row['ticket_status'] == 2 || $row['ticket_status'] == 101){
            $ticketStatus='Requested';
            if($row['requested_date'] !='0000-00-00 00:00:00'){
                $requestedDate=date('d-m-Y h:i',strtotime($row['requested_date']));
            }
        }

        $revertedDate='';
        if($row['ticket_status'] == 3){
            $ticketStatus='Revert';
            if($row['revert_date'] !='0000-00-00 00:00:00'){
                $revertedDate=date('d-m-Y h:i',strtotime($row['revert_date']));
            }
        }
        $repstatus='';
        $closeDate='';
        if($row['ticket_status'] == 101){
            $ticketStatus='Closed';
            if($row['close_date'] !='0000-00-00 00:00:00'){
                $closeDate=date('d-m-Y h:i',strtotime($row['close_date']));
            }

            if(in_array($row['qc2_dis'], array(117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701))){
                $repstatus="<label style='color:red'>RED</label>";
            }
            if(in_array($row['qc2_dis'], array(116,127,134,140,630,121,125,658,662,660,789))){
                $repstatus="<label style='color:green'>GREEN</label>";
            }
            if(in_array($row['qc2_dis'], array(120,131,137,143,713,119,130,136,142,1005)) || in_array($row['qc2status'], array(519,110))){
                $repstatus="<label style='color:orange'>ORANGE</label>";
            }
        }


        if($row['ticket_status'] == 4){
            $ticketStatus='Re-Requested';
            if($row['requested_date'] !='0000-00-00 00:00:00'){
                $requestedDate=date('d-m-Y h:i',strtotime($row['requested_date']));
            }
        }
            
             $telephone=  $this->encryption->decrypt($row['mobile']);
        
        
            $response->rows [$i] ['cell'] = array ( $i+$count+1,$ticket_no,$row['case_no'],$row['candidate_name'],$chkval,$employer,$ticketStatus,$row['ticket_details'],anchor('/Client/client_ticketview/'.base64_encode($row['request_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['level_id']),"<span style='color:#10a1d3;'>View</span>"),$Modify,$repstatus,$row['req_name'],$row['org_name'],$officevalue,$branchofficevalue,$row[$this->request_sub_office],$requestedDate,$closeDate,$row['email'],$telephone);

         
        }
      }
        echo json_encode($response);
    }


    /*****************
    * Request raised listing of records ,status and history 
    * get_scrmticketlist
    ******************/
    function get_scrmticketlist($office_id = 0 ){  

        $model = array('client_model'=>'get_scrmticketlist');

        $ticket_no = ($_REQUEST['ticket_no']) ? $_REQUEST['ticket_no'] : ''; 
        $case_number=($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
        $username = ($_REQUEST['username']) ? $_REQUEST['username'] : '';
        $ticket_status = ($_REQUEST['ticket_status']) ? $_REQUEST['ticket_status'] : '';
        // $closed_by = ($_REQUEST['closed_by']) ? $_REQUEST['closed_by'] : ''; 
        $org_id = ($_REQUEST[$this->request_orgid]) ? $_REQUEST[$this->request_orgid] : '';
        $office = ($_REQUEST[$this->request_office]) ? $_REQUEST[$this->request_office] : '';
        $parent_office = ($_REQUEST[$this->request_parent_office]) ? $_REQUEST[$this->request_parent_office] : '';
        $sub_office = ($_REQUEST[$this->request_sub_office]) ? $_REQUEST[$this->request_sub_office] : '';
        $fp_fdate = ($_REQUEST['fp_fdate']) ? $_REQUEST['fp_fdate'] : ''; 
        $fp_tdate = ($_REQUEST['fp_tdate']) ? $_REQUEST['fp_tdate'] : '';
        
        $tkt=explode('TKT-', $ticket_no);
        $tkt_no= $tkt[1];

        if($tkt_no){
            $condition[]=" td.ticket_no = ".$tkt_no;
        }
        
        if($parent_office){
            $condition[]=" d.id = ".$parent_office;
        }
        if($office){
            $condition[]=" b.id = ".$office;
        }
        if($org_id){
            $condition[]=" c.id = ".$org_id;
        }
        if($sub_office){
            $condition[]=" o.id = ".$sub_office;
        }
        // if($username){
        //     $condition[]=" (concat_ws(' ',us.first_name,us.middle_name,us.last_name) like '%".$username."%') ";
        // }
       if($username){
            $condition[]=" (concat_ws(' ',us.first_name,us.last_name) like '%".$username."%') ";
       }
        
        if($case_number){
            $condition[]=" a.case_no like '%".$case_number."'";
        }
  
        if(!empty($ticket_status)){
            $condition[]=" td.ticket_status =".$ticket_status ;
        }
        // if(!empty($closed_by)){
        //     $condition[]=" td.role_id =".$closed_by ;
        // }

        if(!empty($fp_fdate) && ($ticket_status==1 || $ticket_status==5)){
            $condition[]="DATE_FORMAT(td.action_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fp_fdate))."' ";
        }
        if(!empty($fp_tdate) && ($ticket_status==1 || $ticket_status==5)){
            $condition[]="DATE_FORMAT(td.action_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($fp_tdate))."' ";
        }

        if(!empty($fp_fdate) && ($ticket_status==2 || $ticket_status==4)){
            $condition[]="DATE_FORMAT(td.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fp_fdate))."' ";
        }
        if(!empty($fp_tdate) && $ticket_status==2){
            $condition[]="DATE_FORMAT(td.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($fp_tdate))."' ";
        }

        if(!empty($fp_fdate) && $ticket_status==3){
            $condition[]="DATE_FORMAT(td.revert_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fp_fdate))."' ";
        }
        if(!empty($fp_tdate) && $ticket_status==3){
            $condition[]="DATE_FORMAT(td.revert_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($fp_tdate))."' ";
        }

        if(!empty($fp_fdate) && $ticket_status==101){
            $condition[]="DATE_FORMAT(td.close_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fp_fdate))."' ";
        }
        if(!empty($fp_tdate) && $ticket_status==101){
            $condition[]="DATE_FORMAT(td.close_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($fp_tdate))."' ";
        } 
         
        if($term)
        {
        //support multiple words
        $search = explode(' ', $term);
        foreach($search as $t) {
        $not        = '';
        $operator    = 'OR';

        if(substr($t,0,1) == '-')
        {
        $not        = 'NOT ';
        $operator    = 'AND';
        //trim the - sign off
        $t        = substr($t,1,strlen($t));
        }

        $like    = '';
        $like    .= " ( a.candidate_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." c.org_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." b.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." d.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.client_ref_number ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.report_status ".$not."LIKE '%".$t."%' " ;        
        $like    .= $operator." f.first_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.reason ".$not."LIKE '%".$t."%' " ;      

        $condition[]=$like;
        }
        }

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0]; 
        $result = $results[1]; 
        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows; //echo '<pre>';print_r($result);exit;
        foreach ( $result as $i => $row ) {

        $type='';
        if($row['dataentry_by']==1){
            $type='Partial Entry';
        }
        else if($row['dataentry_by']==2){
            $type='Full Entry';
        }
        else if($row['dataentry_by']==3){
            $type='Offline Entry';
        }
        else if($row['dataentry_by']==0){
            $type='Candidate Entry';
        }


        if($row['parent']==0){
        $officevalue=$row[$this->request_parent_office];
        $branchofficevalue=$row['office_name'];

        }else if($row['parent']!=0){
            $officevalue=$row['office_name'];
            $branchofficevalue=$row[$this->request_parent_office];
        }

        if($row['chk']==0){
            $chkval=$row['name'];
        }else{
            $chkval=$row['name'].$row['chk'];
        }
        

        $roleid= $this->session->userdata('role_id'); 
        $usertype= $this->session->userdata('user_type');

        $ticket_noO='TKT-'.$row['ticket_no'];

        $employer="";

        if($row['check_id'] == 14){
            $this->db->select("affliated");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("request_id=",$row['request_id']);
            $ResRow=$this->db->get(DB_PREFIX.'education_details')->row_array();
            $employer=$ResRow['affliated'];
        }
        
        if($row['check_id'] == 15){
            $this->db->select("permanent_address");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("request_id=",$row['request_id']);
            $ResRow1=$this->db->get(DB_PREFIX.'permanent_contact_details')->row_array();
            $employer=$ResRow1['permanent_address'];
        }

        if($row['check_id'] == 16){
            $this->db->select("current_address");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("request_id=",$row['request_id']);
            $ResRow1=$this->db->get(DB_PREFIX.'contact_details')->row_array();
            $employer=$ResRow1['current_address'];
        }

        if($row['check_id'] == 59){
            $this->db->select("company_name");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("req_id=",$row['request_id']);
            $ResRow1=$this->db->get(DB_PREFIX.'employment')->row_array();
            $employer=$ResRow1['company_name'];
        }

        if($row['check_id'] == 68){
            $this->db->select("company_name");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("request_id=",$row['request_id']);
            $ResRow1=$this->db->get(DB_PREFIX.'professional_reference')->row_array();
            $employer=$ResRow1['company_name'];
        }
        if($row['check_id'] == 649){
            $this->db->select("company_name");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("request_id=",$row['request_id']);
            $ResRow1=$this->db->get(DB_PREFIX.'professional_reference_check_colleague')->row_array();
            $employer=$ResRow1['company_name'];
        }

        $openDate=date('d-m-Y h:i',strtotime($row['action_date']));

        $Modify='';
        $tstatus='';
        $ticketStatus="";
        if($row['ticket_status'] == 1){
            $tstatus='Open';
            $Modify=anchor('/Client/ticketmodify/'.base64_encode($row['request_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['level_id']),"<span style='color:green;'>Modify</span>");
        }

        if($row['ticket_status'] == 5){
            $tstatus='Re-Open';
            if($usertype != 2 && $roleid !=12 ){
                $Modify=anchor('/Client/ticketmodify/'.base64_encode($row['request_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['level_id']),"<span style='color:green;'>Modify</span>");
            }
        }

        $startDate=date('Y-m-d',strtotime($row['action_date']));
        $endDate=date('Y-m-d');
        $workingDays = $this->number_of_working_days($startDate, $endDate);

        if(($row['ticket_status'] == 1 || $row['ticket_status'] ==5) && $workingDays > 1)
        {
            $ticket_no="<span style='background-color:yellow;'>".$ticket_noO."</span>";
            $ticketStatus="<span style='background-color:yellow;'>".$tstatus."</span>";
        }else{
            $ticket_no=$ticket_noO;
            $ticketStatus=$tstatus;
        }

        $requestedDate='';
        if($row['ticket_status'] == 2 || $row['ticket_status'] == 101){
            $ticketStatus='Requested';
            if($row['requested_date'] !='0000-00-00 00:00:00'){
                $requestedDate=date('d-m-Y h:i',strtotime($row['requested_date']));
            }
        }

        $revertedDate='';
        if($row['ticket_status'] == 3){
            $ticketStatus='Revert';
            if($row['revert_date'] !='0000-00-00 00:00:00'){
                $revertedDate=date('d-m-Y h:i',strtotime($row['revert_date']));
            }
        }

        $closeDate='';
        if($row['ticket_status'] == 101){
            $ticketStatus='Closed';
            if($row['close_date'] !='0000-00-00 00:00:00'){
                $closeDate=date('d-m-Y h:i',strtotime($row['close_date']));
            }

            if(in_array($row['qc2_dis'], array(117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701))){
                $repstatus="<label style='color:red'>RED</label>";
            }
            if(in_array($row['qc2_dis'], array(116,127,134,140,630,121,125,658,662,660,789))){
                $repstatus="<label style='color:green'>GREEN</label>";
            }
            if(in_array($row['qc2_dis'], array(120,131,137,143,713,119,130,136,142,1005)) || in_array($row['qc2status'], array(519,110))){
                $repstatus="<label style='color:orange'>ORANGE</label>";
            }
        }


        if($row['ticket_status'] == 4){
            $ticketStatus='Re-Requested';
            if($row['requested_date'] !='0000-00-00 00:00:00'){
                $requestedDate=date('d-m-Y h:i',strtotime($row['requested_date']));
            }
        }
        
        
            $response->rows [$i] ['cell'] = array ( $i+$count+1,$ticket_no,$row['case_no'],$row['candidate_name'],$chkval,$employer,$ticketStatus,$row['req_name'],$row['ticket_details'],anchor('/Client/ticketview/'.base64_encode($row['request_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['level_id']),"<span style='color:#10a1d3;'>View</span>"),$Modify,$repstatus,$row['org_name'],$officevalue,$branchofficevalue,$row[$this->request_sub_office],$row['username'],$openDate,$requestedDate,$revertedDate,$closeDate,$row['email']);
        

         
        }
      }
        echo json_encode($response);
    }

    /*******************************
    ******* Ticket Detail View *****
    ***** function ticketview*******/
    function ticketview(){

        $data['request_id']=$request_id=base64_decode($this->uri->segment(3));
        $data['check_id']=$check_id=base64_decode($this->uri->segment(4));
        $data['level_id']=$level_id=base64_decode($this->uri->segment(5));

        $ticketdetails = $this->cm->get_ticketdetail($request_id,$check_id,$level_id);
        $data['ticket'] = $ticketdetails;
                
        $req_additional_doc=$this->cm->get_requested_doc($request_id,$check_id,$level_id);
        $data['requested_doc']=$req_additional_doc;

        // $data['auth_link'] = array(array('candidate','search','Search','Client/request_raisedlist','')
        // );
        
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Ticket', 'Client/request_raisedlist');
        $this->breadcrumbs->push('View Ticket', 'Client/ticketview');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'ticketview');
    }

     /*******************************
    ******* Ticket Detail View *****
    ***** function ticketview*******/
    function ticketmodify(){

        $data['request_id']=$request_id=base64_decode($this->uri->segment(3));
        $data['check_id']=$check_id=base64_decode($this->uri->segment(4));
        $data['level_id']=$level_id=base64_decode($this->uri->segment(5));

        $ticketdetails = $this->cm->get_ticket_modifydetail($request_id,$check_id,$level_id); 

        $data['ticket'] = $ticketdetails;
        
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Ticket', 'Client/request_raisedlist');
        $this->breadcrumbs->push('Modify Ticket', 'Client/ticketmodify');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'ticketmodify');
    }

    function addticket(){
        //print_r($_POST);exit;
        $userid=$this->session->userdata['userid'];
        $role_id=$this->session->userdata['role_id'];
        $formData=$_POST;
        if($formData){

            if($formData['current_status']== 1){
                $this->db->set('current_status', 0);    
                $this->db->where('request_id',$formData['request_id']);
                $this->db->where('check_id',$formData['check_id']);
                $this->db->where('level_id',$formData['level_id']);
                $this->db->update(DB_PREFIX.'ticket_details');
            }

            if ($formData['submit']=='Submit to Client') {
                if($formData['ticket_status']==5){
                    $req_save['ticket_status']=4;  
                }else{
                    $req_save['ticket_status']=2;
                }
                $requested_date=date('y-m-d H:i:s');
            }else{
                $req_save['ticket_status']=3;
                $revert_date=date('y-m-d H:i:s');
            }

        $req_save['request_id']=$formData['request_id'];
        $req_save['ticket_no']=$formData['ticket_no'];
        $req_save['ticket_serial_no']=$formData['ticket_serial_no'];
        $req_save['case_no']=$formData['case_no'];
        $req_save['level_id']=$formData['level_id'];
        $req_save['check_id']=$formData['check_id'];
        $req_save['action_date']=$formData['action_date'];
        $req_save['requested_date']=$requested_date;
        $req_save['revert_date']=$revert_date;
        $req_save['role_id']=$role_id;
        $req_save['user_id']=$userid;
        $req_save['request_reason_id']=$formData['request_reason_id'];
        $req_save['ticket_details']=$formData['ticket_details'];
        $req_save['current_status']=1;

        $req_save = $this->security->xss_clean($req_save);
        $this->db->insert(DB_PREFIX.'ticket_details',$req_save);

        }

        redirect('Client/request_raisedlist');
    }

    /*******************************
    ******* Ticket Detail View *****
    ***** function ticketview*******/
    function client_ticketview(){

        $data['request_id']=$request_id=base64_decode($this->uri->segment(3));
        $data['check_id']=$check_id=base64_decode($this->uri->segment(4));
        $data['level_id']=$level_id=base64_decode($this->uri->segment(5));

        $ticketdetails = $this->cm->get_ticketdetail($request_id,$check_id,$level_id);
        $data['ticket'] = $ticketdetails;
                
        $req_additional_doc=$this->cm->get_requested_doc($request_id,$check_id,$level_id);
        $data['requested_doc']=$req_additional_doc;

        // $data['auth_link'] = array(array('candidate','search','Search','Client/request_raisedlist','')
        // );
        
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Ticket', 'Client/request_raisedlist');
        $this->breadcrumbs->push('View Ticket', 'Client/client_ticketview');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'ticketview');
    }

    /*******************************
    ******* Ticket Detail View *****
    ***** function client_ticketmodify*******/
    function client_ticketmodify(){

        $data['request_id']=$request_id=base64_decode($this->uri->segment(3));
        $data['check_id']=$check_id=base64_decode($this->uri->segment(4));
        $data['level_id']=$level_id=base64_decode($this->uri->segment(5));

        $ticketdetails = $this->cm->get_ticket_modifydetail($request_id,$check_id,$level_id); 
        $data['ticket'] = $ticketdetails;

        $data['decleration_details'] = $this->dm->declerationdetails($request_id);
        // $data['decleration_details']=$this->db->query("select company_decl_doc from ". DB_PREFIX ."declaration_details where user_id=".$request_id)->row_array();

        $data['checklevels']=$checklevels=$this->dm->checklevels($request_id,$check_id);
        $slug = url_title(convert_accented_characters($checklevels[0]['name']), 'underscore', TRUE);
        $data['form_details']=$this->dm->$slug($request_id,$checklevels[0]['id'],$level_id);

        if($check_id==648){
            $data['tds_doc'] = $this->amodel->getDetails(DB_PREFIX . "tds_doc a", array('*'), array('a.request_id'=>$request_id));
        }

        $data['additionalDoc']= $this->amodel->getDetails(DB_PREFIX . "personal_additional_doc a", array('a.*'), array('a.check_id' => $check_id,'a.request_id' => $request_id,'a.ref_id' => $level_id));


        $skillsadd_clones = array(array('document_name' => array('text', 'document_name', '', '','', '', ''),'additional_doc' => array('upload', 'additional_doc', '', '','', '', '') ));
        $data['skills_file_clone'] = create_cloneform($skillsadd_clones,'', $user_id );
        $data['upload_file'] =formclonecreation($skillsadd_clones,$data['skills_file_clone'],1,'Add Document',"Additional Document");
        
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Ticket', 'Client/request_raisedlist');
        $this->breadcrumbs->push('Modify Ticket', 'Client/client_ticketmodify');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'client_ticketmodify');
    }

    function client_addticket(){
        // print_r($_POST);exit;
        $userid=$this->session->userdata['userid'];
        $role_id=$this->session->userdata['role_id'];
        $formData=$_POST;
        if($formData){

            $request_id=$formData['request_id'];
            $check_id=$formData['check_id'];
            $level_id=$formData['level_id'];

            if($formData['current_status']== 1){
                $this->db->set('current_status', 0);    
                $this->db->where('request_id',$request_id);
                $this->db->where('check_id',$check_id);
                $this->db->where('level_id',$level_id);
                $this->db->update(DB_PREFIX.'ticket_details');
            }

            if ($formData['submit']='Close Ticke') {
                $req_save['ticket_status']=101;
                // $requested_date=date('y-m-d H:i:s');
            }
            // else{
            //     $req_save['ticket_status']=3;
            //     $revert_date=date('y-m-d H:i:s');
            // }

            $req_save['request_id']=$request_id;
            $req_save['ticket_no']=$formData['ticket_no'];
            $req_save['ticket_serial_no']=$formData['ticket_serial_no'];
            $req_save['case_no']=$formData['case_no'];
            $req_save['level_id']=$level_id;
            $req_save['check_id']=$check_id;
            $req_save['action_date']=$formData['action_date'];;
            $req_save['requested_date']=$formData['requested_date'];
            $req_save['close_date']=date('y-m-d H:i:s');
            $req_save['role_id']=$role_id;
            $req_save['user_id']=$userid;
            $req_save['request_reason_id']=$formData['request_reason_id'];
            $req_save['ticket_details']=$formData['ticket_details'];
            $req_save['current_status']=1;

        /**************** Save Files ***********/
            $documnets=array();
            $config['allowed_types'] = '*';
            if(isset($formData['Authorisation']) ){
                $config['upload_path'] = 'uploads/prposaldetails/'; 
            }else{
                $config['upload_path'] = 'uploads/candidate/document';
            }
            // $config['upload_path'] = 'uploads/candidate/document';
            $config['encrypt_name'] = true;
            $config['remove_spaces'] = true;

            $this->load->library('upload', $config);
            $count = count($_FILES['document']['size']);
            $s=0; foreach($_FILES as $key=>$value){

            $_FILES['userfile']['name']=$value['name'];
            $_FILES['userfile']['type']    = $value['type'];
            $_FILES['userfile']['tmp_name'] = $value['tmp_name'];
            $_FILES['userfile']['error']       = $value['error'];
            $_FILES['userfile']['size']    = $value['size'];   

            if ( $this->upload->do_upload())
            {
                $documnets[$key]  = $this->upload->data();
            }
            $s++;}
// print_r($documnets);exit;
            if(!empty($documnets['auth_document'])){
                $where=array('user_id'=>$request_id);
                if($documnets['file_name']<>''){
                    $this->db->set('company_decl_doc',$documnets['auth_document']['file_name']);
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'declaration_details');

                    $req_save['company_decl_doc']=$documnets['auth_document']['file_name'];
                }
            }

            if($check_id == 14){
                $where=array('id'=>$level_id,'request_id'=>$request_id,'checkid'=>$check_id);
                if(!empty($documnets['document'])){
                    
                    $this->db->set('document_file',$documnets['document']['file_name']);
                    $this->db->set('docustatus',1);
                    $this->db->set('document_remarks','');
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'education_details');

                    $req_save['document_file']=$documnets['document']['file_name'];
                }
                
                if(!empty($documnets['gdocument'])){
                    
                    $this->db->set('gdocument',$documnets['gdocument']['file_name']);
                    $this->db->set('grade_status',1);
                    $this->db->set('grade_remarks','');
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'education_details');

                    $req_save['gdocument']=$documnets['gdocument']['file_name'];
                }

                if(!empty($documnets['pdocument'])){
                    
                    $this->db->set('pdocument',$documnets['pdocument']['file_name']);
                    $this->db->set('provisional_status',1);
                    $this->db->set('provisional_remarks','');
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'education_details');

                    $req_save['pdocument']=$documnets['pdocument']['file_name'];
                }
                if(!empty($documnets['consolidate_doc'])){

                    $this->db->set('consolidate_doc',$documnets['consolidate_doc']['file_name']);
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'education_details');

                    $req_save['consolidate_doc']=$documnets['consolidate_doc']['file_name'];
                }
            }

            if($check_id == 59){
                $where=array('id'=>$level_id,'req_id'=>$request_id,'checkid'=>$check_id);
                if(!empty($documnets['document']['file_name'])){
                    $this->db->set('employement_file',$documnets['document']['file_name']);
                    $this->db->set('edocustatus',1);
                    $this->db->set('edocument_remarks','');
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'employment');

                    $req_save['employement_file']=$documnets['document']['file_name'];
                }
                if(!empty($documnets['relieve_document']['file_name'])){
                    $this->db->set('relieve_document',$documnets['relieve_document']['file_name']);
                    $this->db->set('relieve_status',1);
                    $this->db->set('relieve_remarks','');
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'employment');

                    $req_save['relieve_document']=$documnets['relieve_document']['file_name'];
                }
                if(!empty($documnets['service_document']['file_name'])){
                    $this->db->set('service_document',$documnets['service_document']['file_name']);
                    $this->db->set('service_status',1);
                    $this->db->set('service_remarks','');
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'employment');

                    $req_save['service_document']=$documnets['service_document']['file_name'];
                }
            }

            if($check_id == 15){
                $where=array('id'=>$level_id,'request_id'=>$request_id,'checkid'=>$check_id);
                if($documnets['file_name']<>''){
                    $this->db->set('address_proof',$documnets['file_name']);
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'permanent_contact_details');

                    $req_save['address_proof']=$documnets['file_name'];
                }
            }

            if($check_id == 16){
                $where=array('id'=>$level_id,'request_id'=>$request_id,'checkid'=>$check_id);
                if($documnets['file_name']<>''){
                    $this->db->set('address_proof',$documnets['file_name']);
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'contact_details');

                    $req_save['address_proof']=$documnets['file_name'];
                }
            }
            if($check_id == 631){
                $where=array('id'=>$level_id,'request_id'=>$request_id,'checkid'=>$check_id);
                if($documnets['file_name']<>''){
                    $this->db->set('address_proof',$documnets['file_name']);
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'aadhaar_card_verification');

                    $req_save['address_proof']=$documnets['file_name'];
                }
            }
            if($check_id == 632){
                $where=array('id'=>$level_id,'request_id'=>$request_id,'checkid'=>$check_id);
                if($documnets['file_name']<>''){
                    $this->db->set('address_proof',$documnets['file_name']);
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'pan_card_verification');

                    $req_save['address_proof']=$documnets['file_name'];
                }
            }

            if($check_id == 633){
                $where=array('id'=>$level_id,'request_id'=>$request_id,'checkid'=>$check_id);
                if($documnets['file_name']<>''){
                    $this->db->set('address_proof',$documnets['file_name']);
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'voter_id_verification');

                    $req_save['address_proof']=$documnets['file_name'];
                }
            }
            if($check_id == 634){
                $where=array('id'=>$level_id,'request_id'=>$request_id,'checkid'=>$check_id);
                if($documnets['file_name']<>''){
                    $this->db->set('address_proof',$documnets['file_name']);
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'passport_verification');

                    $req_save['address_proof']=$documnets['file_name'];
                }
            }
            if($check_id == 635){
                $where=array('id'=>$level_id,'request_id'=>$request_id,'checkid'=>$check_id);
                if($documnets['file_name']<>''){
                    $this->db->set('address_proof',$documnets['file_name']);
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'driving_licence_verification');

                    $req_save['address_proof']=$documnets['file_name'];
                }
            }
            if($check_id == 636){
                $where=array('id'=>$level_id,'request_id'=>$request_id,'checkid'=>$check_id);
                if($documnets['file_name']<>''){
                    $this->db->set('address_proof',$documnets['file_name']);
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'cibil_check');

                    $req_save['address_proof']=$documnets['file_name'];
                }
            }
            if($check_id == 637){
                $where=array('id'=>$level_id,'request_id'=>$request_id,'checkid'=>$check_id);
                if($documnets['file_name']<>''){
                    $this->db->set('address_proof',$documnets['file_name']);
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'form_16_verification');

                    $req_save['address_proof']=$documnets['file_name'];
                }
            }/*
            if($check_id == 648){
                
                $upload_files =array('tan_of_deductor','source_of_income','tds_amount_deducted','tds_proof'); 
                $status= $this->insertTDSDetails($_POST['count'],$upload_files,$return_id,'tds_doc',$user_id,'','','');
            }*/
            if($check_id == 70){
                $where=array('id'=>$level_id,'request_id'=>$request_id,'checkid'=>$check_id);
                if($documnets['file_name']<>''){
                    $this->db->set('address_proof',$documnets['file_name']);
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'police_permanent_address_verification');

                    $req_save['address_proof']=$documnets['file_name'];
                }
            }

            if($check_id == 645){
                $where=array('id'=>$level_id,'request_id'=>$request_id,'checkid'=>$check_id);
                if($documnets['file_name']<>''){
                    $this->db->set('address_proof',$documnets['file_name']);
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'international_address_check_current_address');

                    $req_save['address_proof']=$documnets['file_name'];
                }
            }
            if($check_id == 646){
                $where=array('id'=>$level_id,'request_id'=>$request_id,'checkid'=>$check_id);
                if($documnets['file_name']<>''){
                    $this->db->set('address_proof',$documnets['file_name']);
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX.'international_address_check_permanent_address');

                    $req_save['address_proof']=$documnets['file_name'];
                }
            }

            $req_save = $this->security->xss_clean($req_save);
            $this->db->insert(DB_PREFIX.'ticket_details',$req_save);

            
            $upload_files =array('document_name','additional_doc'); 
            $status=$this->insertcloneDetails1($_POST['count1'],$upload_files,$return_id,'personal_additional_doc',$request_id,$check_id,$level_id,'');

            $status1=$this->insertcloneDetails1($_POST['count1'],$upload_files,$return_id,'requested_additional_doc',$request_id,$check_id,$level_id,'');
        }
        $req_raised_pending=$formData['req_raised_pending'];
        redirect('Client/request_raisedlist/'.$req_raised_pending);
    }

    /*******************************
    *  insertcloneDetails page
    *  insertcloneDetails
    *******************************/ 
    function insertcloneDetails1($clonecount=0,$insertValue = '',$marketId = '',$tablename = '',$editId = '',$fId = '',$cId = '',$lId = '')
    { 
          if($editId != 0)
          {
          $marketId = $editId;

          }

          $insertsales = array();
          $bulksave = array();  
          if(!empty($_FILES['additional_doc']['name'])){
          if($clonecount != 0) {
          for($i=1;$i<=$clonecount;$i++) { 
          $j = $i;
          if($i == 1)
          {
          $j = '';
          }

          foreach($insertValue as $value) {
          switch($value)
          {
          case 'additional_doc':
          case '':  
          //upload files
          $this->load->library('Upload');
          $config['allowed_types'] = 'jpg|png|jpeg|pdf';                               
          $config['upload_path'] = 'uploads/candidate/document/';
          $config['encrypt_name'] =true;
          $config['remove_spaces'] = true;
          $this->load->library('upload', $config);
          if (!empty($_FILES['additional_doc'.$j.$j]['name'])) {  
          $this->upload->initialize($config);    
          if($this->upload->do_upload('additional_doc'.$j.$j))
          {

          $upload_data = $this->upload->data();
          $image['original']=$config['upload_path'].''.$upload_data['file_name'];    
          $config['source_image']= getcwd().'/uploads/candidate/document/'.$upload_data['file_name'];
          $insertsales['additional_doc'] = $image['original'];
          }
          }
          if($this->upload->display_errors() != '')
          {

          return $this->upload->display_errors();
          }

          $insertsales[$value] = $image['original'];
          break;

          default:
          $insertsales[$value] = $_POST[$value.$j];
          break;
          }

          }

          $insertsales['request_id'] = $editId;
          $insertsales['check_id'] = $fId;
          $insertsales['ref_id'] = $cId;
          $insertsales['status'] = '1';
          $insertsales['created_date'] =date('Y-m-d H:i:s');
          
          $bulksave[] = $insertsales;
          }
          $this->db->insert_batch($this->config->item('table_prefix').$tablename,$bulksave);
          }
          }
          return 1;
    }


    /* export Request Raised Ticket report */
    function export_clientticketlist(){ 
        $model = array('client_model'=>'export_get_clientticket');
        // $model = array('client_model'=>'export_get_clientticket');

        $ticket_no = ($_REQUEST['exp_ticket_no']) ? $_REQUEST['exp_ticket_no'] : ''; 
        $case_number=($_REQUEST['exp_case_number']) ? $_REQUEST['exp_case_number'] : '';
        $email=($_REQUEST['exp_email']) ? $_REQUEST['exp_email'] : '';
        $telephone=($_REQUEST['exp_telephone']) ? $_REQUEST['exp_telephone'] : '';
        $username = ($_REQUEST['exp_username']) ? $_REQUEST['exp_username'] : '';
        $ticket_status = ($_REQUEST['exp_ticket_status']) ? $_REQUEST['exp_ticket_status'] : '';
        $closed_by = ($_REQUEST['exp_closed_by']) ? $_REQUEST['exp_closed_by'] : ''; 
        $org_id = ($_REQUEST[$this->request_orgid]) ? $_REQUEST[$this->request_orgid] : '';
        $office = ($_REQUEST['exp_office_id']) ? $_REQUEST['exp_office_id'] : '';
        $parent_office = ($_REQUEST['exp_parent_office']) ? $_REQUEST['exp_parent_office'] : '';
        $sub_office = ($_REQUEST['exp_sub_office']) ? $_REQUEST['exp_sub_office'] : '';
        $fp_fdate = ($_REQUEST['exp_fp_fdate']) ? $_REQUEST['exp_fp_fdate'] : ''; 
        $fp_tdate = ($_REQUEST['exp_fp_tdate']) ? $_REQUEST['exp_fp_tdate'] : '';
        $request_reason = ($_REQUEST['exp_request_reason']) ? $_REQUEST['exp_request_reason'] : ''; 
         
        if($request_reason){

            $condition[]=" rm.name  like '%".$request_reason."'";
        }

        $tkt=explode('TKT-', $ticket_no);
        $tkt_no= $tkt[1];

        if($tkt_no){
            $condition[]=" td.ticket_no =".$tkt_no;
        }
        
        if($parent_office){
            $condition[]=" d.id = ".$parent_office;
        }
        if($office){
            $condition[]=" b.id = ".$office;
        }
        if($org_id){
            $condition[]=" c.id = ".$org_id;
        }
        if($sub_office){
            $condition[]=" o.id = ".$sub_office;
        }
        // if($username){
        //     $condition[]=" (concat_ws(' ',us.first_name,us.middle_name,us.last_name) like '%".$username."%') ";
        // }
       // if($username){
       //      $condition[]=" (concat_ws(' ',us.first_name,us.last_name) like '%".$username."%') ";
       // }
        




        //22/01/2023
        $case_number = trim($case_number);
        if($case_number){
            $condition[]=" a.case_no like '%".$case_number."'";
        }
        if($email){
            $condition[]=" f.email like '%".$email."'";
        }
        if($telephone){
            $condition[]=" uc.telephone like '%".$telephone."'";
        }
  
        if(!empty($ticket_status)){
            $condition[]=" td.ticket_status =".$ticket_status ;
        }
        if(!empty($closed_by)){
            $condition[]=" td.role_id =".$closed_by ;
        }

        if(!empty($fp_fdate) && $ticket_status==2){
            $condition[]="DATE_FORMAT(td.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fp_fdate))."' ";
        }
        if(!empty($fp_tdate) && $ticket_status==2){
            $condition[]="DATE_FORMAT(td.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($fp_tdate))."' ";
        }

        if(!empty($fp_fdate) && $ticket_status==4){
            $condition[]="DATE_FORMAT(td.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fp_fdate))."' ";
        }
        if(!empty($fp_tdate) && $ticket_status==4){
            $condition[]="DATE_FORMAT(td.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($fp_tdate))."' ";
        }

        if(!empty($fp_fdate) && $ticket_status==101){
            $condition[]="DATE_FORMAT(td.close_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fp_fdate['fp_fdate']))."' ";
        }
        if(!empty($fp_tdate) && $ticket_status==101){
            $condition[]="DATE_FORMAT(td.close_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($fp_tdate))."' ";
        }

        if($reopen_status==2){
            $condition[]=" a.supplement_report=1 ";
        } 
         
        if($term)
        {
        //support multiple words
        $search = explode(' ', $term);
        foreach($search as $t) {
        $not        = '';
        $operator    = 'OR';

        if(substr($t,0,1) == '-')
        {
        $not        = 'NOT ';
        $operator    = 'AND';
        //trim the - sign off
        $t        = substr($t,1,strlen($t));
        }

        $like    = '';
        $like    .= " ( a.candidate_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." c.org_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." b.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." d.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.client_ref_number ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.report_status ".$not."LIKE '%".$t."%' " ;        
        $like    .= $operator." f.first_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.reason ".$not."LIKE '%".$t."%' " ;      

        $condition[]=$like;
        }
        }

         $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];  $result = $results[1];
        if ($result) {
           $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
      $k=1;
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
        $objPHPExcel->getActiveSheet()->setCellValue('B1', "Ticket No.");
        $objPHPExcel->getActiveSheet()->setCellValue('C1', "Organization");
        $objPHPExcel->getActiveSheet()->setCellValue('D1', "Head Office");
        $objPHPExcel->getActiveSheet()->setCellValue('E1', "Branch Office");
        $objPHPExcel->getActiveSheet()->setCellValue('F1', "Sub Office");
        $objPHPExcel->getActiveSheet()->setCellValue('G1', "Candidate Name");
        $objPHPExcel->getActiveSheet()->setCellValue('H1', "Case Number");
        $objPHPExcel->getActiveSheet()->setCellValue('I1', "Employer / University / Addres");
        $objPHPExcel->getActiveSheet()->setCellValue('J1', "Check Name");
        $objPHPExcel->getActiveSheet()->setCellValue('K1', "Ticket Status");
        $objPHPExcel->getActiveSheet()->setCellValue('L1', "Ticket Details / Comment");
        $objPHPExcel->getActiveSheet()->setCellValue('M1', "Check Report Status");
        $objPHPExcel->getActiveSheet()->setCellValue('N1', "Request raised reason");
        $objPHPExcel->getActiveSheet()->setCellValue('O1', "Requested / Re-Requested Date");
        $objPHPExcel->getActiveSheet()->setCellValue('P1', "Ticket Closed Date");
        $objPHPExcel->getActiveSheet()->setCellValue('Q1', "Candidate Email");
        $objPHPExcel->getActiveSheet()->setCellValue('R1', "Contact No");
        $ci=2;    

        foreach ( $result as $i => $row ) {
            $type='';
            if($row['dataentry_by']==1){
                $type='Partial Entry';
            }
            else if($row['dataentry_by']==2){
                $type='Full Entry';
            }
            else if($row['dataentry_by']==3){
                $type='Offline Entry';
            }
            else if($row['dataentry_by']==0){
                $type='Candidate Entry';
            }


            if($row['parent']==0){
            $officevalue=$row[$this->request_parent_office];
            $branchofficevalue=$row['office_name'];

            }else if($row['parent']!=0){
                $officevalue=$row['office_name'];
                $branchofficevalue=$row[$this->request_parent_office];
            }

            if($row['chk']==0){
                $chkval=$row['name'];
            }else{
                $chkval=$row['name'].$row['chk'];
            }

            $roleid= $this->session->userdata('role_id'); 
            $usertype= $this->session->userdata('user_type');

            $ticket_noO='TKT-'.$row['ticket_no'];

            $employer="";

            if($row['check_id'] == 14){
                $this->db->select("affliated");
                $this->db->where("id=",$row['level_id']);
                $this->db->where("checkid=",$row['check_id']);
                $this->db->where("request_id=",$row['request_id']);
                $ResRow=$this->db->get(DB_PREFIX.'education_details')->row_array();
                $employer=$ResRow['affliated'];
            }
            
            if($row['check_id'] == 15){
                $this->db->select("permanent_address");
                $this->db->where("id=",$row['level_id']);
                $this->db->where("checkid=",$row['check_id']);
                $this->db->where("request_id=",$row['request_id']);
                $ResRow1=$this->db->get(DB_PREFIX.'permanent_contact_details')->row_array();
                $employer=$ResRow1['permanent_address'];
            }

            if($row['check_id'] == 16){
                $this->db->select("current_address");
                $this->db->where("id=",$row['level_id']);
                $this->db->where("checkid=",$row['check_id']);
                $this->db->where("request_id=",$row['request_id']);
                $ResRow1=$this->db->get(DB_PREFIX.'contact_details')->row_array();
                $employer=$ResRow1['current_address'];
            }

            if($row['check_id'] == 59){
                $this->db->select("company_name");
                $this->db->where("id=",$row['level_id']);
                $this->db->where("checkid=",$row['check_id']);
                $this->db->where("req_id=",$row['request_id']);
                $ResRow1=$this->db->get(DB_PREFIX.'employment')->row_array();
                $employer=$ResRow1['company_name'];
            }
            if($row['check_id'] == 68){
            $this->db->select("company_name");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("request_id=",$row['request_id']);
            $ResRow1=$this->db->get(DB_PREFIX.'professional_reference')->row_array();
            $employer=$ResRow1['company_name'];
            }
            if($row['check_id'] == 649){
                $this->db->select("company_name");
                $this->db->where("id=",$row['level_id']);
                $this->db->where("checkid=",$row['check_id']);
                $this->db->where("request_id=",$row['request_id']);
                $ResRow1=$this->db->get(DB_PREFIX.'professional_reference_check_colleague')->row_array();
                $employer=$ResRow1['company_name'];
            }

            $openDate=date('d-m-Y h:i',strtotime($row['action_date']));

            $Modify='';
            $tstatus='';
            $ticketStatus="";
            if($row['ticket_status'] == 1){
                $tstatus='Open';
                $Modify=anchor('/Client/ticketmodify/'.base64_encode($row['request_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['level_id']),"<span style='color:green;'>Modify</span>");
            }

            if($row['ticket_status'] == 5){
                $tstatus='Re-Open';
                if($usertype != 2 && $roleid !=12 ){
                    $Modify=anchor('/Client/ticketmodify/'.base64_encode($row['request_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['level_id']),"<span style='color:green;'>Modify</span>");
                }
            }

            $startDate=date('Y-m-d',strtotime($row['action_date']));
            $endDate=date('Y-m-d');
            $workingDays = $this->number_of_working_days($startDate, $endDate);

            if(($row['ticket_status'] == 1 || $row['ticket_status'] ==5) && $workingDays > 1)
            {
                $ticket_no=$ticket_noO;
                $ticketStatus=$tstatus;
            }else{
                $ticket_no=$ticket_noO;
                $ticketStatus=$tstatus;
            }

            if($usertype == 2 && $roleid==12 )
            {
                if($row['ticket_status'] == 2 || $row['ticket_status'] == 4){
                    $Modify=anchor('/Client/client_ticketmodify/'.base64_encode($row['request_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['level_id']),"<span style='color:green;'>Modify</span>");
                }else{
                    $Modify='';
                }
                
            }

            $requestedDate='';
            if($row['ticket_status'] == 2 || $row['ticket_status'] == 101){
                $ticketStatus='Requested';
                if($row['requested_date'] !='0000-00-00 00:00:00'){
                    $requestedDate=date('d-m-Y h:i',strtotime($row['requested_date']));
                }
            }

            $revertedDate='';
            if($row['ticket_status'] == 3){
                $ticketStatus='Revert';
                if($row['revert_date'] !='0000-00-00 00:00:00'){
                    $revertedDate=date('d-m-Y h:i',strtotime($row['revert_date']));
                }
            }

            $closeDate='';
            if($row['ticket_status'] == 101){
                $ticketStatus='Closed';
                if($row['close_date'] !='0000-00-00 00:00:00'){
                    $closeDate=date('d-m-Y h:i',strtotime($row['close_date']));
                }
            }


            if($row['ticket_status'] == 4){
                $ticketStatus='Re-Requested';
                if($row['requested_date'] !='0000-00-00 00:00:00'){
                    $requestedDate=date('d-m-Y h:i',strtotime($row['requested_date']));
                }
            }
            $telephone=  $this->encryption->decrypt($row['mobile']);
              
              //28/11/2023 check report status

            $repstatus='';
        $closeDate='';
        if($row['ticket_status'] == 101){
            $ticketStatus='Closed';
            if($row['close_date'] !='0000-00-00 00:00:00'){
                $closeDate=date('d-m-Y h:i',strtotime($row['close_date']));
            }

            if(in_array($row['qc2_dis'], array(117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701))){
                $repstatus="RED";
            }
            if(in_array($row['qc2_dis'], array(116,127,134,140,630,121,125,658,662,660,789))){
                $repstatus="GREEN";
            }
            if(in_array($row['qc2_dis'], array(120,131,137,143,713,119,130,136,142,1005)) || in_array($row['qc2status'], array(519,110))){
                $repstatus="ORANGE";
            }
        }    

            $objPHPExcel->getActiveSheet()->getStyle('A1:R1')->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                        ->setCellValue('B' . $ci, $ticket_no)
                        ->setCellValue('C' . $ci, $row['org_name'])
                        ->setCellValue('D' . $ci, $officevalue)
                        ->setCellValue('E' . $ci, $branchofficevalue)
                        ->setCellValue('F' . $ci, $row[$this->request_sub_office])
                        ->setCellValue('G' . $ci, $row['candidate_name'])
                        ->setCellValue('H' . $ci, $row['case_no'])
                        ->setCellValue('I' . $ci, $employer)
                        ->setCellValue('J' . $ci, $chkval)
                        ->setCellValue('K' . $ci, $ticketStatus)
                        ->setCellValue('L' . $ci, $row['ticket_details'])
                        ->setCellValue('M' . $ci, $repstatus)
                        ->setCellValue('N' . $ci, $row['req_name']) 
                        ->setCellValue('O' . $ci, $requestedDate)
                        ->setCellValue('P' . $ci, $closeDate)
                        ->setCellValue('Q' . $ci, $row['email'])
                        ->setCellValue('R' . $ci, $telephone);
            $ci++;
        }
            $this->export_excel('A','R','Ticket_Details_',$objPHPExcel);
            exit; 
        }
            redirect('Client/request_raisedlist');
    }


    /*****************
    * Request raised listing of records ,status and history 
    * export_scrmticketlist
    ******************/
    function export_scrmticketlist($office_id = 0 ){  

        $model = array('client_model'=>'export_scrmticketlist');

        $ticket_no = ($_REQUEST['exp_ticket_no']) ? $_REQUEST['exp_ticket_no'] : ''; 
        $case_number=($_REQUEST['exp_case_number']) ? $_REQUEST['exp_case_number'] : '';
        $username = ($_REQUEST['exp_username']) ? $_REQUEST['exp_username'] : '';
        $ticket_status = ($_REQUEST['exp_ticket_status']) ? $_REQUEST['exp_ticket_status'] : ''; 
        $org_id = ($_REQUEST['exp_parentoffice_id']) ? $_REQUEST['exp_parentoffice_id'] : '';
        $office = ($_REQUEST['exp_office_id']) ? $_REQUEST['exp_office_id'] : '';
        $parent_office = ($_REQUEST['exp_parent_office']) ? $_REQUEST['exp_parent_office'] : '';
        $sub_office = ($_REQUEST['exp_sub_office']) ? $_REQUEST['exp_sub_office'] : '';
        $fp_fdate = ($_REQUEST['exp_fp_fdate']) ? $_REQUEST['exp_fp_fdate'] : ''; 
        $fp_tdate = ($_REQUEST['exp_fp_tdate']) ? $_REQUEST['exp_fp_tdate'] : '';

        $tkt=explode('TKT-', $ticket_no);
        $tkt_no= $tkt[1];

        if($tkt_no){
            $condition[]=" td.ticket_no = ".$tkt_no;
        }
        
        if($parent_office){
            $condition[]=" d.id = ".$parent_office;
        }
        if($office){
            $condition[]=" b.id = ".$office;
        }
        if($org_id){
            $condition[]=" c.id = ".$org_id;
        }
        if($sub_office){
            $condition[]=" o.id = ".$sub_office;
        }
        // if($username){
        //     $condition[]=" (concat_ws(' ',us.first_name,us.middle_name,us.last_name) like '%".$username."%') ";
        // }
       if($username){
            $condition[]=" (concat_ws(' ',us.first_name,us.last_name) like '%".$username."%') ";
       }
        
        if($case_number){
            $condition[]=" a.case_no like '%".$case_number."'";
        }
  
        if(!empty($ticket_status)){
            $condition[]=" td.ticket_status =".$ticket_status ;
        }


        if(!empty($fp_fdate) && ($ticket_status==1 || $ticket_status==5)){
            $condition[]="DATE_FORMAT(td.action_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fp_fdate))."' ";
        }
        if(!empty($fp_tdate) && ($ticket_status==1 || $ticket_status==5)){
            $condition[]="DATE_FORMAT(td.action_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($fp_tdate))."' ";
        }

        if(!empty($fp_fdate) && ($ticket_status==2 || $ticket_status==4)){
            $condition[]="DATE_FORMAT(td.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fp_fdate))."' ";
        }
        if(!empty($fp_tdate) && $ticket_status==2){
            $condition[]="DATE_FORMAT(td.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($fp_tdate))."' ";
        }

        if(!empty($fp_fdate) && $ticket_status==3){
            $condition[]="DATE_FORMAT(td.revert_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fp_fdate))."' ";
        }
        if(!empty($fp_tdate) && $ticket_status==3){
            $condition[]="DATE_FORMAT(td.revert_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($fp_tdate))."' ";
        }

        if(!empty($fp_fdate) && $ticket_status==101){
            $condition[]="DATE_FORMAT(td.close_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fp_fdate))."' ";
        }
        if(!empty($fp_tdate) && $ticket_status==101){
            $condition[]="DATE_FORMAT(td.close_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($fp_tdate))."' ";
        } 
         
        if($term)
        {
        //support multiple words
        $search = explode(' ', $term);
        foreach($search as $t) {
        $not        = '';
        $operator    = 'OR';

        if(substr($t,0,1) == '-')
        {
        $not        = 'NOT ';
        $operator    = 'AND';
        //trim the - sign off
        $t        = substr($t,1,strlen($t));
        }

        $like    = '';
        $like    .= " ( a.candidate_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." c.org_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." b.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." d.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.client_ref_number ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.report_status ".$not."LIKE '%".$t."%' " ;        
        $like    .= $operator." f.first_name ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." a.reason ".$not."LIKE '%".$t."%' " ;      

        $condition[]=$like;
        }
        }

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0]; 
        $result = $results[1]; 
        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows; //echo '<pre>';print_r($result);exit;

        $k=1;
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
        $objPHPExcel->getActiveSheet()->setCellValue('B1', "Ticket No.");
        $objPHPExcel->getActiveSheet()->setCellValue('C1', "Organization");
        $objPHPExcel->getActiveSheet()->setCellValue('D1', "Head Office");
        $objPHPExcel->getActiveSheet()->setCellValue('E1', "Branch Office");
        $objPHPExcel->getActiveSheet()->setCellValue('F1', "Sub Office");
        $objPHPExcel->getActiveSheet()->setCellValue('G1', "Candidate Name");
        $objPHPExcel->getActiveSheet()->setCellValue('H1', "Case Number");
        $objPHPExcel->getActiveSheet()->setCellValue('I1', "Employer / University / Addres");
        $objPHPExcel->getActiveSheet()->setCellValue('J1', "Check Name");
        $objPHPExcel->getActiveSheet()->setCellValue('K1', "User");
        $objPHPExcel->getActiveSheet()->setCellValue('L1', "Request raised reason");
        $objPHPExcel->getActiveSheet()->setCellValue('M1', "Ticket Status");
        $objPHPExcel->getActiveSheet()->setCellValue('N1', "Ticket Details / Comment");
        $objPHPExcel->getActiveSheet()->setCellValue('O1', "Open / Re-Open Date");
        $objPHPExcel->getActiveSheet()->setCellValue('P1', "Requested / Re-Requested Date");
        $objPHPExcel->getActiveSheet()->setCellValue('Q1', "Reverted Date");
        $objPHPExcel->getActiveSheet()->setCellValue('R1', "Ticket Closed Date");
        $objPHPExcel->getActiveSheet()->setCellValue('S1', "Candidate Email");
        $ci=2;

        foreach ( $result as $i => $row ) {

        $type='';
        if($row['dataentry_by']==1){
            $type='Partial Entry';
        }
        else if($row['dataentry_by']==2){
            $type='Full Entry';
        }
        else if($row['dataentry_by']==3){
            $type='Offline Entry';
        }
        else if($row['dataentry_by']==0){
            $type='Candidate Entry';
        }


        if($row['parent']==0){
        $officevalue=$row[$this->request_parent_office];
        $branchofficevalue=$row['office_name'];

        }else if($row['parent']!=0){
            $officevalue=$row['office_name'];
            $branchofficevalue=$row[$this->request_parent_office];
        }

        if($row['chk']==0){
            $chkval=$row['name'];
        }else{
            $chkval=$row['name'].$row['chk'];
        }
        

        $roleid= $this->session->userdata('role_id'); 
        $usertype= $this->session->userdata('user_type');

        $ticket_noO='TKT-'.$row['ticket_no'];

        $employer="";

        if($row['check_id'] == 14){
            $this->db->select("affliated");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("request_id=",$row['request_id']);
            $ResRow=$this->db->get(DB_PREFIX.'education_details')->row_array();
            $employer=$ResRow['affliated'];
        }
        
        if($row['check_id'] == 15){
            $this->db->select("permanent_address");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("request_id=",$row['request_id']);
            $ResRow1=$this->db->get(DB_PREFIX.'permanent_contact_details')->row_array();
            $employer=$ResRow1['permanent_address'];
        }

        if($row['check_id'] == 16){
            $this->db->select("current_address");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("request_id=",$row['request_id']);
            $ResRow1=$this->db->get(DB_PREFIX.'contact_details')->row_array();
            $employer=$ResRow1['current_address'];
        }

        if($row['check_id'] == 59){
            $this->db->select("company_name");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("req_id=",$row['request_id']);
            $ResRow1=$this->db->get(DB_PREFIX.'employment')->row_array();
            $employer=$ResRow1['company_name'];
        }

        if($row['check_id'] == 68){
            $this->db->select("company_name");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("request_id=",$row['request_id']);
            $ResRow1=$this->db->get(DB_PREFIX.'professional_reference')->row_array();
            $employer=$ResRow1['company_name'];
        }
        if($row['check_id'] == 649){
            $this->db->select("company_name");
            $this->db->where("id=",$row['level_id']);
            $this->db->where("checkid=",$row['check_id']);
            $this->db->where("request_id=",$row['request_id']);
            $ResRow1=$this->db->get(DB_PREFIX.'professional_reference_check_colleague')->row_array();
            $employer=$ResRow1['company_name'];
        }

        $openDate=date('d-m-Y h:i',strtotime($row['action_date']));

        $Modify='';
        $tstatus='';
        $ticketStatus="";
        if($row['ticket_status'] == 1){
            $tstatus='Open';
            $Modify=anchor('/Client/ticketmodify/'.base64_encode($row['request_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['level_id']),"<span style='color:green;'>Modify</span>");
        }

        if($row['ticket_status'] == 5){
            $tstatus='Re-Open';
            if($usertype != 2 && $roleid !=12 ){
                $Modify=anchor('/Client/ticketmodify/'.base64_encode($row['request_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['level_id']),"<span style='color:green;'>Modify</span>");
            }
        }

        $startDate=date('Y-m-d',strtotime($row['action_date']));
        $endDate=date('Y-m-d');
        $workingDays = $this->number_of_working_days($startDate, $endDate);

        if(($row['ticket_status'] == 1 || $row['ticket_status'] ==5) && $workingDays > 1)
        {
            $ticket_no=$ticket_noO;
            $ticketStatus=$tstatus;
        }else{
            $ticket_no=$ticket_noO;
            $ticketStatus=$tstatus;
        }

        $requestedDate='';
        if($row['ticket_status'] == 2 || $row['ticket_status'] == 101){
            $ticketStatus='Requested';
            if($row['requested_date'] !='0000-00-00 00:00:00'){
                $requestedDate=date('d-m-Y h:i',strtotime($row['requested_date']));
            }
        }

        $revertedDate='';
        if($row['ticket_status'] == 3){
            $ticketStatus='Revert';
            if($row['revert_date'] !='0000-00-00 00:00:00'){
                $revertedDate=date('d-m-Y h:i',strtotime($row['revert_date']));
            }
        }

        $closeDate='';
        if($row['ticket_status'] == 101){
            $ticketStatus='Closed';
            if($row['close_date'] !='0000-00-00 00:00:00'){
                $closeDate=date('d-m-Y h:i',strtotime($row['close_date']));
            }
        }


        if($row['ticket_status'] == 4){
            $ticketStatus='Re-Requested';
            if($row['requested_date'] !='0000-00-00 00:00:00'){
                $requestedDate=date('d-m-Y h:i',strtotime($row['requested_date']));
            }
        }
        
            $objPHPExcel->getActiveSheet()->getStyle('A1:S1')->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                        ->setCellValue('B' . $ci, $ticket_no)
                        ->setCellValue('C' . $ci, $row['org_name'])
                        ->setCellValue('D' . $ci, $officevalue)
                        ->setCellValue('E' . $ci, $branchofficevalue)
                        ->setCellValue('F' . $ci, $row[$this->request_sub_office])
                        ->setCellValue('G' . $ci, $row['candidate_name'])
                        ->setCellValue('H' . $ci, $row['case_no'])
                        ->setCellValue('I' . $ci, $employer)
                        ->setCellValue('J' . $ci, $chkval)
                        ->setCellValue('K' . $ci, $row['username'])
                        ->setCellValue('L' . $ci, $row['req_name'])
                        ->setCellValue('M' . $ci, $ticketStatus)
                        ->setCellValue('N' . $ci, $row['ticket_details'])
                        ->setCellValue('O' . $ci, $openDate)
                        ->setCellValue('P' . $ci, $requestedDate)
                        ->setCellValue('Q' . $ci, $revertedDate)
                        ->setCellValue('R' . $ci, $closeDate)
                        ->setCellValue('S' . $ci, $row['email']);
            $ci++;
        }
            $this->export_excel('A','S','Ticket_Details_',$objPHPExcel);
            exit; 
        }
            redirect('Client/request_raisedlist');
    }



    function export_payment_request($office_id = 0)
    {
         
        $model = array(self::$client_model=>'get_payment_requestlist');
        
        $org_id = ($_REQUEST['exp_parentoffice_id']) ? $_REQUEST['exp_parentoffice_id'] : '';
        $template_id = ($_REQUEST['exp_template_id']) ? $_REQUEST['exp_template_id'] : '';
        $case_number = ($_REQUEST['exp_case_number']) ? $_REQUEST['exp_case_number'] : '';
        $requested_by = ($_REQUEST['exp_requested_by']) ? $_REQUEST['exp_requested_by'] : '';
        $payment_status = ($_REQUEST['exp_payment_status']) ? $_REQUEST['exp_payment_status'] : '';
        $payment_mode = ($_REQUEST['exp_payment_mode']) ? $_REQUEST['exp_payment_mode'] : '';
        $payment_reason = ($_REQUEST['exp_payment_reason']) ? $_REQUEST['exp_payment_reason'] : '';
        $c_date = ($_REQUEST['exp_fp_fdate']) ? $_REQUEST['exp_fp_fdate'] : '';
        $t_date = ($_REQUEST['exp_fp_tdate']) ? $_REQUEST['exp_fp_tdate'] : ''; 

                
        if($org_id){
            $condition[]=" pr.org_id = ".$org_id;
        }
        if($case_number){
            $condition[]=" pr.case_no like '%".$case_number."%'";
        }
        if($requested_by){
            $condition[]=" f.first_name like '%".$requested_by."%'";
        }
        if($payment_status){
            $condition[]=" pr.payment_status =".$payment_status;
        }
        if($payment_mode){
            $condition[]=" pr.payment_mode =".$payment_mode;
        }
        if($payment_reason){
            $condition[]=" pr.reason_payment =".$payment_reason;
        }
        if(!empty($c_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }


        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1];
        // print_r($result);exit;

        if (!empty($result)) {

            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
                $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
                $objPHPExcel->getActiveSheet()->setCellValue('B1', "Payment Request No.");
                $objPHPExcel->getActiveSheet()->setCellValue('C1', "Case Number");
                $objPHPExcel->getActiveSheet()->setCellValue('D1', "Candidate Name");
                $objPHPExcel->getActiveSheet()->setCellValue('E1', "Check Name");
                $objPHPExcel->getActiveSheet()->setCellValue('F1', "Beneficiary Name");
                $objPHPExcel->getActiveSheet()->setCellValue('G1', "Location");
                $objPHPExcel->getActiveSheet()->setCellValue('H1', "Currency");
                $objPHPExcel->getActiveSheet()->setCellValue('I1', "Amount");
                $objPHPExcel->getActiveSheet()->setCellValue('J1', "Payment Mode");
                $objPHPExcel->getActiveSheet()->setCellValue('K1', "Payment Status");
                $objPHPExcel->getActiveSheet()->setCellValue('L1', "Requested date");
                $objPHPExcel->getActiveSheet()->setCellValue('M1', "Initiated Date");
                $objPHPExcel->getActiveSheet()->setCellValue('N1', "Completed Date");
                $objPHPExcel->getActiveSheet()->setCellValue('O1', "No. of days");
                $objPHPExcel->getActiveSheet()->setCellValue('P1', "DD / Transaction No.");
                $objPHPExcel->getActiveSheet()->setCellValue('Q1', "IFSC Code");
                $objPHPExcel->getActiveSheet()->setCellValue('R1', "Approved date");
                $objPHPExcel->getActiveSheet()->setCellValue('S1', "Reason for Payment");
                $objPHPExcel->getActiveSheet()->setCellValue('T1', "Payment To");
                $objPHPExcel->getActiveSheet()->setCellValue('U1', "Comments");
                $objPHPExcel->getActiveSheet()->setCellValue('V1', "Requested By");
                $objPHPExcel->getActiveSheet()->setCellValue('W1', "Approved By");
                $objPHPExcel->getActiveSheet()->setCellValue('X1', "Organization");
                
                $ci=2;
            
            // echo '<pre>';print_r($result);
            // exit;
            foreach ( $result as $i => $row ){

                $pr_id=$row['pr_id'];
                $request_id= $row['request_id'];
                $check_id= $row['check_id'];
                $level_id= $row['level_id'];
                $pack_id=0;

                $requested_date='';
                $approved_date='';
                $paid_date='';

                if($row['requested_date']) {
                    $requested_date=date('d-m-Y',strtotime($row['requested_date']));
                }
                if($row['approved_date'] != '0000-00-00 00:00:00') {
                    $approved_date=date('d-m-Y',strtotime($row['approved_date']));
                }
                if($row['paid_date'] != '0000-00-00 00:00:00') {
                    $paid_date=date('d-m-Y',strtotime($row['paid_date']));
                }

                $startDate = date('Y-m-d',strtotime($row['requested_date']));
                $endDate = date('Y-m-d');
                $holidays = array();
                $dayCount='';

                if($row['count_of_chk']==0){
                    $chkCount='';
                }else{
                    $chkCount=$row['count_of_chk'];
                }

                // if($row['payment_status']==37){
                //     $getWorkingDays = $this->getWorkingDays($startDate,$paid_date,$holidays);
                //     $dayCount= $getWorkingDays;
                // }else{
                //     $getWorkingDays = $this->getWorkingDays($startDate,$endDate,$holidays);
                //     $dayCount= $getWorkingDays;
                // }

                $Iniated_Date=(!empty($row['initiated_on'])) ? date('d-m-Y',strtotime($row['initiated_on'])) : '';

                $Completed_Date=(!empty($row['completed_on'])) ? date('d-m-Y',strtotime($row['completed_on'])) : '';
                
                if(!empty($Completed_Date)){
                    $NoOfday= $this->getWorkingDays($requested_date,$Completed_Date,$holidays);
                    if(($NoOfday-1) ==0){
                       $dayCount=1; 
                    }else{
                        $dayCount=$NoOfday-1;
                    }
                }else{
                    $dayCount='';
                }


                $attachment='<a href="'.base_url().'uploads/prposaldetails/'.$row['attachment'].'" target="_blank" style="font-size:12px;" >"'.$row['attachment'].'"</a>';

                $pRequest_no='PR-'.$row['pr_id'];

                    $objPHPExcel->getActiveSheet()->getStyle('A1:X1')->getFont()->setBold(true);
                    $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                    ->setCellValue('B' . $ci, $pRequest_no)
                    ->setCellValue('C' . $ci, $row['case_no'])
                    ->setCellValue('D' . $ci, $row['candidate_name'])
                    ->setCellValue('E' . $ci, $row['check_name'].$chkCount)
                    ->setCellValue('F' . $ci, $row['beneficiary_name'])
                    ->setCellValue('G' . $ci, $row['beneficiary_location'])
                    ->setCellValue('H' . $ci, $row['pm_name']) 
                    ->setCellValue('I' . $ci, $row['amount'])
                    ->setCellValue('J' . $ci, $row['paymode'])
                    ->setCellValue('K' . $ci, $row['paystatus'])
                    ->setCellValue('L' . $ci, $requested_date)
                    ->setCellValue('M' . $ci, $Iniated_Date)
                    ->setCellValue('N' . $ci, $Completed_Date)
                    ->setCellValue('O' . $ci, $dayCount)
                    ->setCellValue('P' . $ci, $row['dd_txn_no'])
                    ->setCellValue('Q' . $ci, $row['branchcode'])
                    ->setCellValue('R' . $ci, $approved_date)
                    ->setCellValue('S' . $ci, $row['reason'])
                    ->setCellValue('T' . $ci, $row['payto'])
                    ->setCellValue('U' . $ci, $row['comments'])
                    ->setCellValue('V' . $ci, $row['requested_by'])
                    ->setCellValue('W' . $ci, $row['approved_by'])
                    ->setCellValue('X' . $ci, $row['org_name']);
                
                $ci++;
            }
            $this->export_excel('A','W','Payment Request List',$objPHPExcel);
            exit; 

        }
          redirect('Billing/payment_requestlist');
    }



    /*****************
    * Kotak DD list 
    * export_kotakdd_list
    ******************/
    function export_kotakdd_list($office_id = 0){ 
        // print_r($_REQUEST);exit;
        $model = array(self::$client_model=>'export_kotakdd_list');
        
        $org_id = ($_REQUEST['exp_parentoffice_id']) ? $_REQUEST['exp_parentoffice_id'] : '';
        $template_id = ($_REQUEST['exp_template_id']) ? $_REQUEST['exp_template_id'] : '';
        $case_number = ($_REQUEST['exp_case_number']) ? $_REQUEST['exp_case_number'] : '';
        $requested_by = ($_REQUEST['exp_requested_by']) ? $_REQUEST['exp_requested_by'] : '';
        $payment_status = ($_REQUEST['exp_payment_status']) ? $_REQUEST['exp_payment_status'] : '';
        $payment_mode = ($_REQUEST['exp_payment_mode']) ? $_REQUEST['exp_payment_mode'] : '';
        $payment_reason = ($_REQUEST['exp_payment_reason']) ? $_REQUEST['exp_payment_reason'] : '';
        $c_date = ($_REQUEST['exp_fp_fdate']) ? $_REQUEST['exp_fp_fdate'] : '';
        $t_date = ($_REQUEST['exp_fp_tdate']) ? $_REQUEST['exp_fp_tdate'] : ''; 

               
        if($org_id){
            $condition[]=" pr.org_id = ".$org_id;
        }
        if($case_number){
            $condition[]=" pr.case_no like '%".$case_number."%'";
        }
        if($requested_by){
            $condition[]=" f.first_name like '%".$requested_by."%'";
        }
        if($payment_status){
            $condition[]=" pr.payment_status =".$payment_status;
        }
        if($payment_mode){
            $condition[]=" pr.payment_mode =".$payment_mode;
        }
        if($payment_reason){
            $condition[]=" pr.reason_payment =".$payment_reason;
        }
        if(!empty($c_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }


        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1];
        // print_r($result);exit;

        if (!empty($result)) {

            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Payment Request No.");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Beneficiary Name");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Location");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Amount");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Payment Status");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Requested Date");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "Initiated Date");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Completed Date");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "#Days");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "DD Number");
            $objPHPExcel->getActiveSheet()->setCellValue('O1', "DD Date");
            $objPHPExcel->getActiveSheet()->setCellValue('P1', "DD Charges");
            $objPHPExcel->getActiveSheet()->setCellValue('Q1', "Cheque No");
            $objPHPExcel->getActiveSheet()->setCellValue('R1', "Chaque Date");
            $objPHPExcel->getActiveSheet()->setCellValue('S1', "Bank Name");
            $objPHPExcel->getActiveSheet()->setCellValue('T1', "Requested By");
            
            $ci=2;
            
            // echo '<pre>';print_r($result);
            // exit;
            foreach ( $result as $i => $row ){

                $requested_date='';
                $approved_date='';
                $paid_date='';

                if($row['requested_date']) {
                    $requested_date=date('d-m-Y',strtotime($row['requested_date']));
                }
                if($row['approved_date'] != '0000-00-00 00:00:00') {
                    $approved_date=date('d-m-Y',strtotime($row['approved_date']));
                }
                if($row['paid_date'] != '0000-00-00 00:00:00') {
                    $paid_date=date('d-m-Y',strtotime($row['paid_date']));
                }

                $holidays = array();
                $dayCount='';

                $DD_Date=(!empty($row['dd_date']) && $row['dd_date'] !='0000-00-00') ? date('d-m-Y',strtotime($row['dd_date'])) : '';
                $CHK_Date=(!empty($row['chk_date']) && $row['chk_date'] !='0000-00-00') ? date('d-m-Y',strtotime($row['chk_date'])) : '';

                
                $Iniated_Date=(!empty($row['initiated_on'])) ? date('d-m-Y',strtotime($row['initiated_on'])) : '';

                $Completed_Date=(!empty($row['completed_on'])) ? date('d-m-Y',strtotime($row['completed_on'])) : '';
                
                if(!empty($Completed_Date)){
                    $NoOfday= $this->getWorkingDays($requested_date,$Completed_Date,$holidays);
                    if(($NoOfday-1) ==0){
                       $dayCount=1; 
                    }else{
                        $dayCount=$NoOfday-1;
                    }
                }else{
                    $dayCount='';
                }

                if($row['count_of_chk']==0){
                    $chkCount='';
                }else{
                    $chkCount=$row['count_of_chk'];
                }
                
                $DDcharge=($row['dd_charges'] > 0) ? $row['dd_charges'] : '';

                $pRequest_no='PR-'.$row['pr_id'];
                
                $objPHPExcel->getActiveSheet()->getStyle('A1:T1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                ->setCellValue('B' . $ci, $pRequest_no)
                ->setCellValue('C' . $ci, $row['case_no'])
                ->setCellValue('D' . $ci, $row['candidate_name'])
                ->setCellValue('E' . $ci, $row['check_name'].$chkCount)
                ->setCellValue('F' . $ci, $row['beneficiary_name'])
                ->setCellValue('G' . $ci, $row['beneficiary_location'])
                ->setCellValue('H' . $ci, $row['amount']) 
                ->setCellValue('I' . $ci, $row['paystatus'])
                ->setCellValue('J' . $ci, $requested_date)
                ->setCellValue('K' . $ci, $Iniated_Date)
                ->setCellValue('L' . $ci, $Completed_Date)
                ->setCellValue('M' . $ci, $dayCount)
                ->setCellValue('N' . $ci, $row['dd_txn_no'])
                ->setCellValue('O' . $ci, $DD_Date)
                ->setCellValue('P' . $ci, $DDcharge)
                ->setCellValue('Q' . $ci, $row['chk_number'])
                ->setCellValue('R' . $ci, $CHK_Date)
                ->setCellValue('S' . $ci, $row['bank_name'])
                ->setCellValue('T' . $ci, $row['requested_by']);
                
                $ci++;
            }
                $this->export_excel('A','T','Kotak DD List',$objPHPExcel);
                exit; 

        }
          redirect('Billing/kotak_dd');
    }



    /*****************
    * DBI DD list 
    * export_sbidd_list
    ******************/
    function export_sbidd_list($office_id = 0){ 
        // print_r($_REQUEST);exit;
        $model = array(self::$client_model=>'export_sbidd_list');
        
        $org_id = ($_REQUEST['exp_parentoffice_id']) ? $_REQUEST['exp_parentoffice_id'] : '';
        $template_id = ($_REQUEST['exp_template_id']) ? $_REQUEST['exp_template_id'] : '';
        $case_number = ($_REQUEST['exp_case_number']) ? $_REQUEST['exp_case_number'] : '';
        $requested_by = ($_REQUEST['exp_requested_by']) ? $_REQUEST['exp_requested_by'] : '';
        $payment_status = ($_REQUEST['exp_payment_status']) ? $_REQUEST['exp_payment_status'] : '';
        $payment_mode = ($_REQUEST['exp_payment_mode']) ? $_REQUEST['exp_payment_mode'] : '';
        $payment_reason = ($_REQUEST['exp_payment_reason']) ? $_REQUEST['exp_payment_reason'] : '';
        $c_date = ($_REQUEST['exp_fp_fdate']) ? $_REQUEST['exp_fp_fdate'] : '';
        $t_date = ($_REQUEST['exp_fp_tdate']) ? $_REQUEST['exp_fp_tdate'] : ''; 

               
        if($org_id){
            $condition[]=" pr.org_id = ".$org_id;
        }
        if($case_number){
            $condition[]=" pr.case_no like '%".$case_number."%'";
        }
        if($requested_by){
            $condition[]=" f.first_name like '%".$requested_by."%'";
        }
        if($payment_status){
            $condition[]=" pr.payment_status =".$payment_status;
        }
        if($payment_mode){
            $condition[]=" pr.payment_mode =".$payment_mode;
        }
        if($payment_reason){
            $condition[]=" pr.reason_payment =".$payment_reason;
        }
        if(!empty($c_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }


        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1];
        // print_r($result);exit;

        if (!empty($result)) {

            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Payment Request No.");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Beneficiary Name");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Location");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Amount");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Payment Status");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Requested Date");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "Initiated Date");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Completed Date");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "#Days");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "DD Number");
            $objPHPExcel->getActiveSheet()->setCellValue('O1', "DD Date");
            $objPHPExcel->getActiveSheet()->setCellValue('P1', "DD Charges");
            $objPHPExcel->getActiveSheet()->setCellValue('Q1', "Cheque No");
            $objPHPExcel->getActiveSheet()->setCellValue('R1', "Chaque Date");
            $objPHPExcel->getActiveSheet()->setCellValue('S1', "IFSC Code");
            $objPHPExcel->getActiveSheet()->setCellValue('T1', "Bank Name");
            $objPHPExcel->getActiveSheet()->setCellValue('U1', "Requested By");
            $objPHPExcel->getActiveSheet()->setCellValue('V1', "Organization ");
            
            $ci=2;
            
            // echo '<pre>';print_r($result);
            // exit;
            foreach ( $result as $i => $row ){

                $requested_date='';
                if($row['requested_date']) {
                    $requested_date=date('d-m-Y',strtotime($row['requested_date']));
                }

                $DD_Date=(!empty($row['dd_date']) && $row['dd_date'] !='0000-00-00') ? date('d-m-Y',strtotime($row['dd_date'])) : '';
                

                $CHK_Date=(!empty($row['chk_date']) && $row['chk_date'] !='0000-00-00') ? date('d-m-Y',strtotime($row['chk_date'])) : '';

                $Iniated_Date=(!empty($row['initiated_on'])) ? date('d-m-Y',strtotime($row['initiated_on'])) : '';

                $Completed_Date=(!empty($row['completed_on'])) ? date('d-m-Y',strtotime($row['completed_on'])) : '';
                
                if(!empty($Completed_Date)){
                    $NoOfday= $this->getWorkingDays($requested_date,$Completed_Date,$holidays);
                    if(($NoOfday-1) ==0){
                       $dayCount=1; 
                    }else{
                        $dayCount=$NoOfday-1;
                    }
                }else{
                    $dayCount='';
                }
                
                $DDcharge=($row['dd_charges'] > 0) ? $row['dd_charges'] : '';

                if($row['count_of_chk']==0){
                    $chkCount='';
                }else{
                    $chkCount=$row['count_of_chk'];
                }

                $pRequest_no='PR-'.$row['pr_id'];
                
                $objPHPExcel->getActiveSheet()->getStyle('A1:V1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                ->setCellValue('B' . $ci, $pRequest_no)
                ->setCellValue('C' . $ci, $row['case_no'])
                ->setCellValue('D' . $ci, $row['candidate_name'])
                ->setCellValue('E' . $ci, $row['check_name'].$chkCount)
                ->setCellValue('F' . $ci, $row['beneficiary_name'])
                ->setCellValue('G' . $ci, $row['beneficiary_location'])
                ->setCellValue('H' . $ci, $row['amount']) 
                ->setCellValue('I' . $ci, $row['paystatus'])
                ->setCellValue('J' . $ci, $requested_date)
                ->setCellValue('K' . $ci, $Iniated_Date)
                ->setCellValue('L' . $ci, $Completed_Date)
                ->setCellValue('M' . $ci, $dayCount)
                ->setCellValue('N' . $ci, $row['dd_txn_no'])
                ->setCellValue('O' . $ci, $DD_Date)
                ->setCellValue('P' . $ci, $DDcharge)
                ->setCellValue('Q' . $ci, $row['chk_number'])
                ->setCellValue('R' . $ci, $CHK_Date)
                ->setCellValue('S' . $ci, $row['branchcode'])
                ->setCellValue('T' . $ci, $row['bank_name'])
                ->setCellValue('U' . $ci, $row['requested_by'])
                ->setCellValue('V' . $ci, $row['org_name']);
                
                $ci++;
            }
                $this->export_excel('A','V','SBI DD List',$objPHPExcel);
                exit; 

        }
          redirect('Billing/sbi_dd');
    }


    /**********************
    * Neft Request list 
    * export_neft_request
    **********************/
    function export_neft_request($office_id = 0){ 
        // print_r($_REQUEST);exit;
        $model = array(self::$client_model=>'export_neft_request');
        
        $org_id = ($_REQUEST['exp_parentoffice_id']) ? $_REQUEST['exp_parentoffice_id'] : '';
        $template_id = ($_REQUEST['exp_template_id']) ? $_REQUEST['exp_template_id'] : '';
        $case_number = ($_REQUEST['exp_case_number']) ? $_REQUEST['exp_case_number'] : '';
        $requested_by = ($_REQUEST['exp_requested_by']) ? $_REQUEST['exp_requested_by'] : '';
        $payment_status = ($_REQUEST['exp_payment_status']) ? $_REQUEST['exp_payment_status'] : '';
        $payment_mode = ($_REQUEST['exp_payment_mode']) ? $_REQUEST['exp_payment_mode'] : '';
        $payment_reason = ($_REQUEST['exp_payment_reason']) ? $_REQUEST['exp_payment_reason'] : '';
        $c_date = ($_REQUEST['exp_fp_fdate']) ? $_REQUEST['exp_fp_fdate'] : '';
        $t_date = ($_REQUEST['exp_fp_tdate']) ? $_REQUEST['exp_fp_tdate'] : ''; 

               
        if($org_id){
            $condition[]=" pr.org_id = ".$org_id;
        }
        if($case_number){
            $condition[]=" pr.case_no like '%".$case_number."%'";
        }
        if($requested_by){
            $condition[]=" f.first_name like '%".$requested_by."%'";
        }
        if($payment_status){
            $condition[]=" pr.payment_status =".$payment_status;
        }
        if($payment_mode){
            $condition[]=" pr.payment_mode =".$payment_mode;
        }
        if($payment_reason){
            $condition[]=" pr.reason_payment =".$payment_reason;
        }
        if(!empty($c_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }


        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1];
        // print_r($result);exit;

        if (!empty($result)) {

            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Beneficiary Name");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Location");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Amount");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Payment Status");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Requested Date");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Completed Date");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "#Days");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Reference No.");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "Payment Date");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "Transaction Charges");
            $objPHPExcel->getActiveSheet()->setCellValue('O1', "IFSC Code");
            $objPHPExcel->getActiveSheet()->setCellValue('P1', "Bank Name");
            $objPHPExcel->getActiveSheet()->setCellValue('Q1', "Requested By");
            $objPHPExcel->getActiveSheet()->setCellValue('R1', "Organization");

            $ci=2;
            
            // echo '<pre>';print_r($result);
            // exit;
            foreach ( $result as $i => $row ){

                $requested_date='';
                $approved_date='';
                $paid_date='';
                $payment_date='';
                
                if($row['requested_date']) {
                    $requested_date=date('d-m-Y',strtotime($row['requested_date']));
                }
                if($row['neft_payment_date'] != '0000-00-00 00:00:00') {
                    $payment_date=date('d-m-Y',strtotime($row['neft_payment_date']));
                }

                $Completed_Date=(!empty($row['completed_on'])) ? date('d-m-Y',strtotime($row['completed_on'])) : '';
                
                if(!empty($Completed_Date)){
                    $NoOfday= $this->getWorkingDays($requested_date,$Completed_Date,$holidays);
                    if(($NoOfday-1) ==0){
                       $dayCount=1; 
                    }else{
                        $dayCount=$NoOfday-1;
                    }
                }else{
                    $dayCount='';
                }
                
                if($row['count_of_chk']==0){
                    $chkCount='';
                }else{
                    $chkCount=$row['count_of_chk'];
                }

                $Transcharge=($row['neft_trans_charge'] > 0) ? $row['neft_trans_charge'] : '';
                $pRequest_no='PR-'.$row['pr_id'];
                
                $objPHPExcel->getActiveSheet()->getStyle('A1:R1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                ->setCellValue('B' . $ci, $row['case_no'])
                ->setCellValue('C' . $ci, $row['candidate_name'])
                ->setCellValue('D' . $ci, $row['check_name'].$chkCount)
                ->setCellValue('E' . $ci, $row['beneficiary_name'])
                ->setCellValue('F' . $ci, $row['beneficiary_location'])
                ->setCellValue('G' . $ci, $row['amount'])
                ->setCellValue('H' . $ci, $row['paystatus']) 
                ->setCellValue('I' . $ci, $requested_date)
                ->setCellValue('J' . $ci, $Completed_Date)
                ->setCellValue('K' . $ci, $dayCount)
                ->setCellValue('L' . $ci, $row['neft_reference_no'])
                ->setCellValue('M' . $ci, $payment_date)
                ->setCellValue('N' . $ci, $Transcharge)
                ->setCellValue('O' . $ci, $row['branchcode'])
                ->setCellValue('P' . $ci, $row['neft_bank_name'])
                ->setCellValue('Q' . $ci, $row['requested_by'])
                ->setCellValue('R' . $ci, $row['org_name']);
                
                $ci++;
            }
                $this->export_excel('A','R','NEFT Request List',$objPHPExcel);
                exit; 

        }
          redirect('Billing/neft');
    }



    /**********************
    * Challan Request list 
    * export_neft_request
    **********************/
    function export_challan_request($office_id = 0){ 
        // print_r($_REQUEST);exit;
        $model = array(self::$client_model=>'export_challan_request');
        
        $org_id = ($_REQUEST['exp_parentoffice_id']) ? $_REQUEST['exp_parentoffice_id'] : '';
        $template_id = ($_REQUEST['exp_template_id']) ? $_REQUEST['exp_template_id'] : '';
        $case_number = ($_REQUEST['exp_case_number']) ? $_REQUEST['exp_case_number'] : '';
        $requested_by = ($_REQUEST['exp_requested_by']) ? $_REQUEST['exp_requested_by'] : '';
        $payment_status = ($_REQUEST['exp_payment_status']) ? $_REQUEST['exp_payment_status'] : '';
        $payment_mode = ($_REQUEST['exp_payment_mode']) ? $_REQUEST['exp_payment_mode'] : '';
        $payment_reason = ($_REQUEST['exp_payment_reason']) ? $_REQUEST['exp_payment_reason'] : '';
        $c_date = ($_REQUEST['exp_fp_fdate']) ? $_REQUEST['exp_fp_fdate'] : '';
        $t_date = ($_REQUEST['exp_fp_tdate']) ? $_REQUEST['exp_fp_tdate'] : ''; 

               
        if($org_id){
            $condition[]=" pr.org_id = ".$org_id;
        }
        if($case_number){
            $condition[]=" pr.case_no like '%".$case_number."%'";
        }
        if($requested_by){
            $condition[]=" f.first_name like '%".$requested_by."%'";
        }
        if($payment_status){
            $condition[]=" pr.payment_status =".$payment_status;
        }
        if($payment_mode){
            $condition[]=" pr.payment_mode =".$payment_mode;
        }
        if($payment_reason){
            $condition[]=" pr.reason_payment =".$payment_reason;
        }
        if(!empty($c_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }


        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1];
        // print_r($result);exit;

        if (!empty($result)) {

            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Beneficiary Name");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Location");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Amount");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Payment Status");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Requested Date");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Completed Date");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "#Days");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Journal No.");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "Challan Date");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "Charges");
            $objPHPExcel->getActiveSheet()->setCellValue('O1', "Bank Name");
            $objPHPExcel->getActiveSheet()->setCellValue('P1', "Requested By");
            $objPHPExcel->getActiveSheet()->setCellValue('Q1', "Organization");
            $ci=2;
            
            // echo '<pre>';print_r($result);
            // exit;
            foreach ( $result as $i => $row ){

                $requested_date='';
                $approved_date='';
                $paid_date='';

                if($row['requested_date']) {
                    $requested_date=date('d-m-Y',strtotime($row['requested_date']));
                }
                if($row['chln_date'] != '0000-00-00') {
                    $challan_date=date('d-m-Y',strtotime($row['chln_date']));
                }

                $Completed_Date=(!empty($row['completed_on'])) ? date('d-m-Y',strtotime($row['completed_on'])) : '';
                
                if(!empty($Completed_Date)){
                    $NoOfday= $this->getWorkingDays($requested_date,$Completed_Date,$holidays);
                    if(($NoOfday-1) ==0){
                       $dayCount=1; 
                    }else{
                        $dayCount=$NoOfday-1;
                    }
                }else{
                    $dayCount='';
                }

                if($row['count_of_chk']==0){
                    $chkCount='';
                }else{
                    $chkCount=$row['count_of_chk'];
                }
                
                $Transcharge=($row['chln_charges'] > 0) ? $row['chln_charges'] : '';

                $pRequest_no='PR-'.$row['pr_id'];
                
                $objPHPExcel->getActiveSheet()->getStyle('A1:Q1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                ->setCellValue('B' . $ci, $row['case_no'])
                ->setCellValue('C' . $ci, $row['candidate_name'])
                ->setCellValue('D' . $ci, $row['check_name'].$chkCount)
                ->setCellValue('E' . $ci, $row['beneficiary_name'])
                ->setCellValue('F' . $ci, $row['beneficiary_location'])
                ->setCellValue('G' . $ci, $row['amount'])
                ->setCellValue('H' . $ci, $row['paystatus']) 
                ->setCellValue('I' . $ci, $requested_date)
                ->setCellValue('J' . $ci, $Completed_Date)
                ->setCellValue('K' . $ci, $dayCount)
                ->setCellValue('L' . $ci, $row['chln_journal_no'])
                ->setCellValue('M' . $ci, $challan_date)
                ->setCellValue('N' . $ci, $Transcharge)
                ->setCellValue('O' . $ci, $row['chln_bank'])
                ->setCellValue('P' . $ci, $row['requested_by'])
                ->setCellValue('Q' . $ci, $row['org_name']);
                
                $ci++;
            }
                $this->export_excel('A','Q','Challan Request List',$objPHPExcel);
                exit; 

        }
          redirect('Billing/challan');
    }


    /**********************
    * Card Request list 
    * export_card_request
    **********************/
    function export_card_request($office_id = 0){ 

        $model = array(self::$client_model=>'export_card_request');
        
        $org_id = ($_REQUEST['exp_parentoffice_id']) ? $_REQUEST['exp_parentoffice_id'] : '';
        $template_id = ($_REQUEST['exp_template_id']) ? $_REQUEST['exp_template_id'] : '';
        $case_number = ($_REQUEST['exp_case_number']) ? $_REQUEST['exp_case_number'] : '';
        $requested_by = ($_REQUEST['exp_requested_by']) ? $_REQUEST['exp_requested_by'] : '';
        $payment_status = ($_REQUEST['exp_payment_status']) ? $_REQUEST['exp_payment_status'] : '';
        $payment_mode = ($_REQUEST['exp_payment_mode']) ? $_REQUEST['exp_payment_mode'] : '';
        $payment_reason = ($_REQUEST['exp_payment_reason']) ? $_REQUEST['exp_payment_reason'] : '';
        $c_date = ($_REQUEST['exp_fp_fdate']) ? $_REQUEST['exp_fp_fdate'] : '';
        $t_date = ($_REQUEST['exp_fp_tdate']) ? $_REQUEST['exp_fp_tdate'] : ''; 

               
        if($org_id){
            $condition[]=" pr.org_id = ".$org_id;
        }
        if($case_number){
            $condition[]=" pr.case_no like '%".$case_number."%'";
        }
        if($requested_by){
            $condition[]=" f.first_name like '%".$requested_by."%'";
        }
        if($payment_status){
            $condition[]=" pr.payment_status =".$payment_status;
        }
        if($payment_mode){
            $condition[]=" pr.payment_mode =".$payment_mode;
        }
        if($payment_reason){
            $condition[]=" pr.reason_payment =".$payment_reason;
        }
        if(!empty($c_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }


        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1];
        // print_r($result);exit;

        if (!empty($result)) {

            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Beneficiary Name");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Location");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Amount");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Payment Status");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Requested Date");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Completed Date");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "#Days");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Transaction No.");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "Transaction Date");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "Transaction Charges");
            $objPHPExcel->getActiveSheet()->setCellValue('O1', "Card Type");
            $objPHPExcel->getActiveSheet()->setCellValue('P1', "Requested By");
            $objPHPExcel->getActiveSheet()->setCellValue('Q1', "Organization");
            $ci=2;

            foreach ( $result as $i => $row ){

                $requested_date='';
                $approved_date='';
                $paid_date='';
                $transaction_date='';

                if($row['requested_date']) {
                    $requested_date=date('d-m-Y',strtotime($row['requested_date']));
                }
                if($row['cr_transaction_date'] != '0000-00-00 00:00:00') {
                    $transaction_date=date('d-m-Y',strtotime($row['cr_transaction_date']));
                }

                $Completed_Date=(!empty($row['completed_on'])) ? date('d-m-Y',strtotime($row['completed_on'])) : '';
                
                if(!empty($Completed_Date)){
                    $NoOfday= $this->getWorkingDays($requested_date,$Completed_Date,$holidays);
                    if(($NoOfday-1) ==0){
                       $dayCount=1; 
                    }else{
                        $dayCount=$NoOfday-1;
                    }
                }else{
                    $dayCount='';
                }
                
                $Transcharge=($row['cr_transaction_charge'] > 0) ? $row['cr_transaction_charge'] : '';

                if($row['count_of_chk']==0){
                    $chkCount='';
                }else{
                    $chkCount=$row['count_of_chk'];
                }
                
                $pRequest_no='PR-'.$row['pr_id'];
                
                $objPHPExcel->getActiveSheet()->getStyle('A1:Q1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                ->setCellValue('B' . $ci, $row['case_no'])
                ->setCellValue('C' . $ci, $row['candidate_name'])
                ->setCellValue('D' . $ci, $row['check_name'].$chkCount)
                ->setCellValue('E' . $ci, $row['beneficiary_name'])
                ->setCellValue('F' . $ci, $row['beneficiary_location'])
                ->setCellValue('G' . $ci, $row['amount'])
                ->setCellValue('H' . $ci, $row['paystatus']) 
                ->setCellValue('I' . $ci, $requested_date)
                ->setCellValue('J' . $ci, $Completed_Date)
                ->setCellValue('K' . $ci, $dayCount)
                ->setCellValue('L' . $ci, $row['cr_transaction_no'])
                ->setCellValue('M' . $ci, $transaction_date)
                ->setCellValue('N' . $ci, $Transcharge)
                ->setCellValue('O' . $ci, $row['cr_card_type'])
                ->setCellValue('P' . $ci, $row['requested_by'])
                ->setCellValue('Q' . $ci, $row['org_name']);
                
                $ci++;
            }
                $this->export_excel('A','Q','Card Request List',$objPHPExcel);
                exit;
        }
            redirect('Billing/card');
    }

    /**********************
    * Online Request list 
    * export_online_request
    **********************/
    function export_online_request($office_id = 0){ 

        $model = array(self::$client_model=>'export_online_request');
        
        $org_id = ($_REQUEST['exp_parentoffice_id']) ? $_REQUEST['exp_parentoffice_id'] : '';
        $template_id = ($_REQUEST['exp_template_id']) ? $_REQUEST['exp_template_id'] : '';
        $case_number = ($_REQUEST['exp_case_number']) ? $_REQUEST['exp_case_number'] : '';
        $requested_by = ($_REQUEST['exp_requested_by']) ? $_REQUEST['exp_requested_by'] : '';
        $payment_status = ($_REQUEST['exp_payment_status']) ? $_REQUEST['exp_payment_status'] : '';
        $payment_mode = ($_REQUEST['exp_payment_mode']) ? $_REQUEST['exp_payment_mode'] : '';
        $payment_reason = ($_REQUEST['exp_payment_reason']) ? $_REQUEST['exp_payment_reason'] : '';
        $c_date = ($_REQUEST['exp_fp_fdate']) ? $_REQUEST['exp_fp_fdate'] : '';
        $t_date = ($_REQUEST['exp_fp_tdate']) ? $_REQUEST['exp_fp_tdate'] : ''; 

               
        if($org_id){
            $condition[]=" pr.org_id = ".$org_id;
        }
        if($case_number){
            $condition[]=" pr.case_no like '%".$case_number."%'";
        }
        if($requested_by){
            $condition[]=" f.first_name like '%".$requested_by."%'";
        }
        if($payment_status){
            $condition[]=" pr.payment_status =".$payment_status;
        }
        if($payment_mode){
            $condition[]=" pr.payment_mode =".$payment_mode;
        }
        if($payment_reason){
            $condition[]=" pr.reason_payment =".$payment_reason;
        }
        if(!empty($c_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if(!empty($t_date)){
            $condition[]=" DATE_FORMAT(pr.requested_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }


        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1];
        // print_r($result);exit;

        if (!empty($result)) {

            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Beneficiary Name");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Location");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Amount");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Payment Status");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Requested Date");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Completed Date");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "#Days");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Transaction No.");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "Transaction Date");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "Transaction Charges");
            $objPHPExcel->getActiveSheet()->setCellValue('O1', "Mobile No");
            $objPHPExcel->getActiveSheet()->setCellValue('P1', "Requested By");
            $objPHPExcel->getActiveSheet()->setCellValue('Q1', "Organization");
            $ci=2;

            foreach ( $result as $i => $row ){

                $requested_date='';
                $approved_date='';
                $paid_date='';
                $transaction_date='';
                $Completed_Date='';
                
                if($row['requested_date']) {
                    $requested_date=date('d-m-Y',strtotime($row['requested_date']));
                }

                if($row['op_transaction_date'] != '0000-00-00 00:00:00') {
                    $transaction_date=date('d-m-Y',strtotime($row['op_transaction_date']));
                }

                $Completed_Date=(!empty($row['completed_on'])) ? date('d-m-Y',strtotime($row['completed_on'])) : '';
                
                if(!empty($Completed_Date)){
                    $NoOfday= $this->getWorkingDays($requested_date,$Completed_Date,$holidays);
                    if(($NoOfday-1) ==0){
                       $dayCount=1; 
                    }else{
                        $dayCount=$NoOfday-1;
                    }
                }else{
                    $dayCount='';
                }
                
                $Transcharge=($row['op_transaction_charge'] > 0) ? $row['op_transaction_charge'] : '';

                if(!empty($row['op_mobile_no'])){
                    $mobile=$this->encryption->decrypt($row['op_mobile_no']);        
                }else{
                    $mobile='';
                }

                if($row['count_of_chk']==0){
                    $chkCount='';
                }else{
                    $chkCount=$row['count_of_chk'];
                }
                
                $pRequest_no='PR-'.$row['pr_id'];
                
                $objPHPExcel->getActiveSheet()->getStyle('A1:Q1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                ->setCellValue('B' . $ci, $row['case_no'])
                ->setCellValue('C' . $ci, $row['candidate_name'])
                ->setCellValue('D' . $ci, $row['check_name'].$chkCount)
                ->setCellValue('E' . $ci, $row['beneficiary_name'])
                ->setCellValue('F' . $ci, $row['beneficiary_location'])
                ->setCellValue('G' . $ci, $row['amount'])
                ->setCellValue('H' . $ci, $row['paystatus']) 
                ->setCellValue('I' . $ci, $requested_date)
                ->setCellValue('J' . $ci, $Completed_Date)
                ->setCellValue('K' . $ci, $dayCount)
                ->setCellValue('L' . $ci, $row['op_transaction_no'])
                ->setCellValue('M' . $ci, $transaction_date)
                ->setCellValue('N' . $ci, $Transcharge)
                ->setCellValue('O' . $ci, $mobile)
                ->setCellValue('P' . $ci, $row['requested_by'])
                ->setCellValue('Q' . $ci, $row['org_name']);
                
                $ci++;
            }
                $this->export_excel('A','Q','Online Request List',$objPHPExcel);
                exit;
        }
            redirect('Billing/online');
    }









}



