<?php if (!defined('BASEPATH')) 
    {
        exit('No direct script access allowed');
    }
class Common extends CI_Controller {
    protected $landline='';
    protected $international='';
    protected $data_landline = 'landline';
    protected $data_international = 'international';
    protected $data_value = '" value="';
    
    function __construct() 
    {
        parent::__construct();
        $this->load->helper(array('currency', 'date', 'url', 'pagination', 'table', 'add', 'translate', 'textform', 'form', 'array', 'convertdate', 'view','password','auth'));
        $models = array('Dashboard_model' => 'dmodel', 'Adm_model' => 'amodel', 'Dateconverter_model' => 'datemodel',  'General_model' => 'gm');
       
        $this->load->config(APPLICATIONCONFIG, TRUE);
        foreach ($models as $file => $object_name) {
            $this->load->model($file, $object_name);
        }
         
        $this->load->model('Common_model');
        $this->load->library('curl');
        $this->load->helper('dcode_helper');
        $this->load->library('encryption');
        $this->amodel->loadcssScript(array('reset-min', 'style'));
        date_default_timezone_set("Asia/Kolkata"); 
        header("Connection: Keep-alive");
    }
    /*************************************
    * _login_session function
    * _login_session
    *************************************/
    function _login_session($username, $password,$role_id) {
        $data['query'] = $this->Dashboard_model->adminlogin($username, $password, $role_id);
        if ($data['query'] != NULL) {
            $user = array('userid' => $data['query'][0]->id, 'name' => $data['query'][0]->name, 'role_id' => $data['query'][0]->role_id, 'username' => $data['query'][0]->username, 'password' => $data['query'][0]->password);
            $this->session->set_userdata($user);
            return true;
        }
        return false;
    }
     /*************************************
    * pagination function
    * pagination
    *************************************/
    function pagination($perpage, $uri, $url, $total_rows) {
        $config['base_url'] = $url;
        $config['total_rows'] = $total_rows;
        $config['per_page'] = $perpage;
        $config['num_links'] = 20;
        $config['full_tag_open'] = '<div id="pagination">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = $uri;
        $this->pagination->initialize($config);
    }
     /*************************************
    * getdistrict function
    * getdistrict
    *************************************/
    function getdistrict() {
        $stateid = $this->uri->segment(3);
        $results = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'District', 'ref_id' => $stateid));
        echo $this->amodel->filterDropdown($results, array('id', 'name'));
    }
     /*************************************
    * gethobli function
    * gethobli
    *************************************/
    function gethobli() {
        $talukId = $this->uri->segment(3);
        $results = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'Hobli', 'ref_id' => $talukId));
        echo $this->amodel->filterDropdown($results, array('id', 'name'));
    }
     /*************************************
    * checkmemberavailable function
    * checkmemberavailable
    *************************************/
    function checkmemberavailable() {
        $lastname = urldecode($this->uri->segment(3));
        $middlename = urldecode($this->uri->segment(4));
        $membername = urldecode($this->uri->segment(5));
        $villageId = $this->uri->segment(6);
        $results = $this->amodel->getDetails(DB_PREFIX . "member", array('id', 'name'), array('name' => $membername, 'middlename' => $lastname, 'surname' => $middlename, 'mohalla' => $villageId));
        if ($results) {
            echo 1;
        } else {
            echo 2;
        }
    }
     /*************************************
    * getgpvillage function
    * getgpvillage
    *************************************/
    function getgpvillage() {
        $gptid = $this->uri->segment(3);
        $results = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'GPvillage', 'ref_id' => $gptid));
        echo $this->amodel->filterDropdown($results, array('id', 'name'));
    }
     /*************************************
    * getgpgroupvillagelist function
    * getgpgroupvillagelist
    *************************************/
    function getgpgroupvillagelist() {
        $gptid = $this->uri->segment(3);
        $villlist = $this->mmodel->grpget($gptid);
        echo $this->amodel->filterDropdown($villlist, array('id', 'name'));
    }
     /*************************************
    * gettaluk function
    * gettaluk
    *************************************/
    function gettaluk() {
        $districtid = $this->uri->segment(3);
        $results = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'Taluk', 'ref_id' => $districtid));
        echo $this->amodel->filterDropdown($results, array('id', 'name'));
    }
     /*************************************
    * getvillage function
    * getvillage
    *************************************/
    function getvillage() {
        $districtid = $this->uri->segment(3);
        $results = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'Villages', 'ref_id' => $districtid));
        echo $this->amodel->filterDropdown($results, array('id', 'name'));
    }
     /*************************************
    * getlevel function
    * getlevel
    *************************************/
    function getlevel() {
       $levelid = $this->uri->segment(3);
        $order_id =$this->uri->segment(4); 
                  
        $results = $this->amodel->getlevels($levelid,$order_id);
    
        echo $this->amodel->filterDropdown($results, array('id', 'name'));
    }
     /*************************************
    * get_resourcedetails function
    * get_resourcedetails
    *************************************/
    function get_resourcedetails() {
       $key = $this->uri->segment(3);
        $select = "a.id,a.name";
        $from = "   FROM " . DB_PREFIX . "master_masterdata a 
                    where a.key = '". $key ."'";
        $sql = "SELECT " . $select . "" . $from;
        $results = $this->db->query($sql)->result_array();

       echo $this->amodel->filterDropdown($results, array('id', 'name'));
    }
     /*************************************
    * getorgname function
    * getorgname
    *************************************/
    function getorgname() {
       $presale_id = $this->uri->segment(3);
        $sql = "SELECT a.id,a.organisation from " . DB_PREFIX . "presale a 
                where a.id= ? ";
      $results = $this->db->query($sql,$presale_id)->result_array();
       echo $results[0]['organisation'];   
    }
     /*************************************
    * getmeettime function
    * getmeettime
    *************************************/
    function getmeettime()
    {
       $presale_id = $this->uri->segment(3);
       $results = $this->amodel->gettime($presale_id);
        echo $results[0]['time']; 
    }
     /*************************************
    * getlimit function
    * getlimit
    *************************************/
    function getlimit() {
        $checkid = $this->uri->segment(3); 
        $results = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'limit', 'ref_id' => $checkid));
    
        echo $this->amodel->filterDropdown($results, array('id', 'name'));
    }
     /*************************************
    * getoffice function
    * getoffice
    *************************************/
    function getoffice()
    {
        $checkid = $this->uri->segment(3); 
            $results = $this->amodel->getuser($checkid);
               echo json_encode($results);
    }
     /*************************************
    * getskill function
    * getskill
    *************************************/
    function getskill() {
        $checkid = $this->uri->segment(3); 
        $results = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('ref_id' =>$checkid ));
        echo $this->amodel->filterDropdown($results, array('id', 'name'));
    }
     /*************************************
    * getdesig function
    * getdesig
    *************************************/
    function getdesig() {
        $checkid = $this->uri->segment(3); 
        $results = $this->db->query("select b.id, b.name from ". DB_PREFIX ."master_masterdata b JOIN " . DB_PREFIX . "user a ON b.id=a.designation where a.id=".$checkid)->row_array();
        echo $this->amodel->filterDropdown($results, array('id', 'name'));
    }
     /*************************************
    * getofc function
    * getofc
    *************************************/
    function getofc() {
        $checkid = $this->uri->segment(3); 
        $results = $this->db->query("select b.id, b.office_name from ". DB_PREFIX ."office b JOIN " . DB_PREFIX . "organisation a ON b.parentoffice_id=a.id where a.id=".$checkid)->row_array();
     if($results)
     {
                echo $this->amodel->filterDropdown($results, array('id', 'office_name'));
         }
         else
         {
                $results1 = $this->amodel->getDetails(DB_PREFIX ."organisation", array('id', 'org_name'), array('id' => $checkid));
                 echo $this->amodel->filterDropdown($results1, array('id', 'org_name'));
         }
    }
     /*************************************
    * getemail function
    * getemail
    *************************************/
    function getemail() {
        $org_id = $this->uri->segment(3); 
        $results = $this->db->query("select a.id, a.email from ". DB_PREFIX ."user a JOIN " . DB_PREFIX . "office b ON b.id = a.office_id JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id where c.id=".$org_id)->row_array();
     
    foreach($results as $result)
    if($result['email']<>'')
    $newresult[]=$result;
        echo $this->amodel->filterDropdown($newresult, array('id', 'email'));
    }
     /*************************************
    * getusr function
    * getusr
    *************************************/
    function getusr() {
        $checkid = $this->uri->segment(3); 
        $results = $this->amodel->getDetails(DB_PREFIX . "user b", array('b.id', 'b.first_name'), array('b.contact_for' => $checkid));
        echo $this->amodel->filterDropdown($results, array('id', 'first_name'));
    }

  /*************************************
    * getstate function
    * getstate
    *************************************/   
function getstate() {
        $checkid = $this->uri->segment(3); 
        $results = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'state', 'ref_id' => $checkid));
    
        echo $this->amodel->filterDropdown($results, array('id', 'name'));
    }
  /*************************************
    * getcity function
    * getcity
    *************************************/   
function getcity() {
        $checkid = $this->uri->segment(3); 
        $results = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'city', 'ref_id' => $checkid));
    
        echo $this->amodel->filterDropdown($results, array('id', 'name'));
    }
  /*************************************
    * getteam_mem function
    * getteam_mem
    *************************************/   
function getteam_mem() {
    $key = $this->uri->segment(3);
        $select = "a.user_id,concat_ws(' ',b.first_name,b.middle_name,b.last_name) as membername";
        $from = "   FROM " . DB_PREFIX . "team a 
            join  " . DB_PREFIX . "user b on a.user_id=b.id
                    where a.team = '". $key ."'";
        $sql = "SELECT " . $select . "" . $from;
        $results = $this->db->query($sql)->result_array();

       echo $this->amodel->filterDropdown($results, array('user_id', 'membername'));
    }

  /*************************************
    * getaddress function
    * getaddress
    *************************************/   
    function getaddress() {
        $villageid = $this->uri->segment(3);
        $villageDetails = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name', 'ref_id', 'ref_id2'), array('key' => 'Villages', 'id' => $villageid));
        $talukDetails = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name', 'key'), array('key' => 'Taluk', 'id' => $villageDetails[0]['ref_id']));
        $districtDetails = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name', 'key', 'ref_id'), array('key' => 'District', 'id' => $villageDetails[0]['ref_id2']));
        $stateDetails = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name', 'key'), array('key' => 'State', 'id' => $districtDetails[0]['ref_id']));
        echo $talukDetails[0]['id'] . "_,_" . $talukDetails[0]['name'] . "_,_" . $districtDetails[0]['id'] . "_,_" . $districtDetails[0]['name'] . '_,_' . $stateDetails[0]['id'] . "_,_" . $stateDetails[0]['name'];
    }
   /*************************************
    * getgpaddress function
    * getgpaddress
    *************************************/  
    function getgpaddress() {
        $gpid = $this->uri->segment(3);
        $villageDetails = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name', 'ref_id', 'ref_id2'), array('key' => 'Grama Panchayat', 'id' => $gpid));
        $hobliDetails = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name', 'key', 'ref_id'), array('key' => 'Hobli', 'id' => $villageDetails[0]['ref_id']));
        $talukDetails = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name', 'key', 'ref_id'), array('key' => 'Taluk', 'id' => $hobliDetails[0]['ref_id']));
        $districtDetails = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name', 'key', 'ref_id'), array('key' => 'District', 'id' => $talukDetails[0]['ref_id']));
        $stateDetails = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name', 'key'), array('key' => 'State', 'id' => $districtDetails[0]['ref_id']));
        echo $hobliDetails[0]['id'] . "_,_" . $hobliDetails[0]['name'] . "_,_" . $districtDetails[0]['id'] . "_,_" . $districtDetails[0]['name'] . '_,_' . $stateDetails[0]['id'] . "_,_" . $stateDetails[0]['name'] . "_,_" . $talukDetails[0]['id'] . "_,_" . $talukDetails[0]['name'];
    }
     /*************************************
    * _get_loggedinuser function
    * _get_loggedinuser
    *************************************/
    
    function _get_loggedinuser($param = '') { 
        $user_det = $this->session->userdata; 
        return $user_det [$param];
    }
   /*************************************
    * _check_userlogin function
    * _check_userlogin
    *************************************/  
    function _check_userlogin() {
        if ($this->session->userdata ( 'userid' )) {
            $this->user_id = $this->_get_loggedinuser ( 'userid' ); 
            return TRUE;
        } else {
            
                    redirect ( 'Index/logout', 'refresh' );
           
        }
    }
 /*************************************
    * _check_featureauth function
    * _check_featureauth
    *************************************/
    function _check_featureauth($ref_name = '', $action = '', $return = FALSE, $show_status = 0) {
        $this->load->library( 'FeatureAuth' ); 
        $fa_config = array ();

        $fa_config ['logged_in_user'] = $this->user_id; 

        $fa_config ['user_role_id'] = $this->_get_loggedinuser ( 'role_id' );
        
        $this->featureauth->_init ( $fa_config );
        $status = $this->featureauth->_check_valid_action ( $ref_name, $action, $return );
        
        if ($status == FALSE && $this->featureauth->error_string) {
            if ($show_status) {
                return $status;

            }
            return $this->featureauth->error_string;
        } else {
            return $status;
        }
    }
    
   /*************************************
    * _jqgrid_search function
    * _jqgrid_search
    *************************************/  
    function _jqgrid_search( $model = '',$manual_cond = '' ) {

        foreach($model as $key => $value){
                $this->load->model( $key , 'grid_model' );
        }

        $page = $_REQUEST ['page']; 
        $limit = $_REQUEST ['rows']; 
        $sidx = $_REQUEST ['sidx']; 
        $sord = ($_REQUEST ['sord']) ? $_REQUEST ['sord'] : 'desc'; 
        $searchField = (isset ( $_REQUEST ['searchField'] ) ? $_REQUEST ['searchField'] : "");
        $searchOper = (isset ( $_REQUEST ['searchOper'] ) ? $_REQUEST ['searchOper'] : "");
        $searchString = (isset ( $_REQUEST ['searchString'] ) ? $_REQUEST ['searchString'] : "");

        if (! $sidx)
            $sidx = '1'; 

        $searchCond = '';
        if ($searchOper == 'eq') {
            $searchCond = $searchField . ' = "' . $searchString . '"';
        } else if ($searchOper == 'ne') {
            $searchCond = $searchField . ' <> "' . $searchString . '"';
        } else if ($searchOper == 'nn') {
            $searchCond = $searchField . ' is not null';
        } else if ($searchOper == 'bw') {
            $searchCond = $searchField . ' like "' . $searchString . '%"';
        } else if ($searchOper == 'bn') {
            $searchCond = $searchField . ' not like "' . $searchString . '%"';
        } else if ($searchOper == 'in') {
            $searchCond = $searchField . ' in(' . $searchString . ')';
        } else if ($searchOper == 'ni') {
            $searchCond = $searchField . ' not in(' . $searchString . ')';
        } else if ($searchOper == 'ew') {
            $searchCond = $searchField . ' like "%' . $searchString . '"';
        } else if ($searchOper == 'en') {
            $searchCond = $searchField . ' not like "%' . $searchString . '"';
        } else if ($searchOper == 'cn') {
            $searchCond = $searchField . ' like "%' . $searchString . '%"';
        } else if ($searchOper == 'nc') {
            $searchCond = $searchField . ' not like "%' . $searchString . '%"';
        } else if ($searchOper == 'nu') {
            $searchCond = $searchField . ' is null';
        }
                if($manual_cond){
                        $searchCond .= ($searchCond) ? " and ".$manual_cond : $manual_cond;
                }
        // get total vendors 
        $count_result = $this->grid_model->$value ( 0, 10, $sidx, $sord, $searchCond, 'count' ); 
        $count = ($count_result) ? $count_result[0]['count'] : '';
        if ($count > 0) {
            $total_pages = ceil ( $count / $limit );
        } else {
            $total_pages = 0;
        }
        if ($page > $total_pages)
            $page = $total_pages;
        $start = $limit * $page - $limit;
        
        // do not put  $limit*($page - 1) 
        $result = $this->grid_model->$value ( $start, $limit, $sidx, $sord, $searchCond );
        $response='' || $response=[];
        $response->page = $page;
        $response->total = $total_pages;
        $response->records = $count;
        $r_index = ($page - 1) * $limit;
    /*   echo "<pre>";
        print_r($result);exit();*/
        
        return array($response,$result);
       

    }
   /*************************************
    * check_availability function
    * check_availability
    *************************************/      
    function check_availability() {
            $user_name=$this->uri->segment(3); 
                $user_id = ($this->uri->segment(4)) ? $this->uri->segment(4):'' ;
            $result=$this->amodel->getDetails(DB_PREFIX . "user", array('id'), array('lower(username)' => strtolower($user_name),'id !='=> $user_id));
            echo ($result) ?   1 : 0;
      
    }
 /*************************************
    * check_org function
    * check_org
    *************************************/
        function check_org() {
            $org_name=$this->uri->segment(3); 
                $org_id = ($this->uri->segment(4)) ? $this->uri->segment(4):'' ;
        $result=$this->amodel->getDetails(DB_PREFIX . "organisation", array('id'), array('org_name' => urldecode(trim($org_name) ),'id !='=> $org_id));
            echo ($result) ?   1 : 0;
      
    }
 /*************************************
    * preorg_preoffice function
    * preorg_preoffice
    *************************************/
        function preorg_preoffice() {
            $preorg = $this->uri->segment(3); 
                $preoffice = $this->uri->segment(4);
                $presale_id = ($this->uri->segment(5)) ? $this->uri->segment(5):'' ;
        $result=$this->amodel->getDetails(DB_PREFIX . "presale", array('id'), array('organisation' => urldecode(trim($preorg) ),'id !='=> $presale_id,'office' =>$preoffice));
            echo ($result) ?   1 : 0;
      
    }
 /*************************************
    * check_boffice function
    * check_boffice
    *************************************/
        function check_boffice() {
            $office_name=$this->uri->segment(3);
                $office_id = ($this->uri->segment(4)) ? $this->uri->segment(4):'' ; 
                $result=$this->amodel->getDetails(DB_PREFIX . "office", array('id'), array('office_name' => urldecode(trim($office_name) ), 'id !='=> $office_id) );
            echo ($result) ?   1 : 0;
      
    }
 /*************************************
    * check_ocode function
    * check_ocode
    *************************************/
       function check_ocode() {
            $short_name =$this->uri->segment(3); 
                $office_id = ($this->uri->segment(4)) ? $this->uri->segment(4):'0' ;
$result=$this->amodel->getDetails(DB_PREFIX . "office",array('id'), array('short_name'=>$short_name, 'id !='=> $office_id ));
            echo ($result) ?   1 : 0;
      
    }
     /*************************************
    * check_email function
    * check_email
    *************************************/
    function check_email() {
            $povalue=$_POST['selval'];
            $email=$_POST['email']; 
            //  $user_id = ($this->uri->segment(4)) ? $this->uri->segment(4):'' ;
            $user_id = ($_POST['user_id']) ? $_POST['user_id']:'' ;
            $result=$this->amodel->getDetails(DB_PREFIX . "user", array('id'), array('email' => $email,'id !='=> $user_id,'parent_office'=>$povalue,'active_status !='=>3));
            echo ($result) ?   1 : 0;
      
    }
   /*************************************
    * check_name function
    * check_name
    *************************************/  
     function check_name() {
            $poval=$_GET['selval'];
            $fname=$_GET['fname']; 
            $lname=($_GET['lname']) ? $_GET['lname']:'' ; 
           $user_id = ($this->uri->segment(4)) ? $this->uri->segment(4):'' ;
            $user_id = ($_GET['user_id']) ? $_GET['user_id']:'' ;
            $name= str_replace(' ', '',$fname." ".$lname);

           $result=0;
            $res=$this->amodel->getDetails(DB_PREFIX . "client_request", array('user_id','parent_office'), array("REPLACE(candidate_name, ' ', '')=" => $name, 'parent_office'=> $poval));
     
            if(!empty($res)){
                $result=$this->amodel->getDetails(DB_PREFIX . "user", array('id'), array('id ='=> $res[0]['user_id'],'parent_office'=> $res[0]['parent_office'],'active_status !='=>3));
            }
            echo ($result) ?   1 : 0;
      
    }
  /*************************************
    * getdesign function
    * getdesign
    *************************************/   
    function getdesign()
    {
            $term = $this->input->post('term',TRUE);

            if (strlen($term) < 2) return false;
                 $this->db->like('designation',$term);
            $rows = $this->db->get(DB_PREFIX."master_designation")->result();         
            $json_array = array();
            foreach ($rows as $row)
                 array_push($json_array, $row->designation);
                
            echo json_encode($json_array);
    }
   /*************************************
    * randomString function
    * randomString
    *************************************/  
        function randomString($length)   { 
          $str = "";  $characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));  $max = count($characters) - 1; 
                 for ($i = 0; $i < $length; $i++)
                {   
                        $rand = mt_rand(0, $max); 
                        $str .= $characters[$rand]; 
                } 
                return $str; 
         }  
      /*************************************
    * send_email_common function
    * send_email_common
    *************************************/
         function send_email_common($type,$subject, $email,$ordermail, &$data)
        {

               $this->load->library('email');
               $email_config['protocol']    = 'smtp';
                $email_config['smtp_host']    = 'ssl://smtp.gmail.com';
                $email_config['smtp_port']    = '465';
                $email_config['smtp_user']    = EMAIL_BGV;
                $email_config['smtp_pass']    = PASS_BGV;
                $email_config['mailtype'] = 'html';
                $this->email->initialize($email_config);
                $this->email->set_newline("\r\n");
                $this->email->from('info@dcoderesearch.com','Dcode');
                if(empty($email)){
                    
                    foreach($ordermail as $key => $nameevalue){
                    $valuees=explode(",",$nameevalue);
                    } 
                    $this->email->to($valuees);
                }else
                {
                    $this->email->to($email);
                    foreach($ordermail as $key => $nameevalue){
                    $valuees=explode(",",$nameevalue);
                    } 
                    $this->email->cc($valuees);
                }
               
                $this->email->subject(sprintf($subject));
                $this->email->message($this->load->view('Email/'.$type.'_mail', $data, TRUE));
                if($this->email->send()==true){
                    echo "<script>alert('Mail has been successfully sent to the given id');</script>";
                }else{
                    echo "<script>alert('Please Try Again');</script>";
                }
        }
     /*************************************
    * send_email_changepasswordcommon function
    * send_email_changepasswordcommon
    *************************************/    
        function send_email_changepasswordcommon($type,$subject, $email, &$data)
        {

               $this->load->library('email');
               $email_config['protocol']    = 'smtp';
                $email_config['smtp_host']    = 'ssl://smtp.gmail.com';
                $email_config['smtp_port']    = '465';
                $email_config['smtp_user']    = EMAIL_BGV;
                $email_config['smtp_pass']    = PASS_BGV;
                $email_config['mailtype'] = 'html';
                $this->email->initialize($email_config);
                $this->email->set_newline("\r\n");
                $this->email->from('info@dcode.com','Dcode');
                $this->email->to($email);
                $this->email->subject(sprintf($subject));
                $this->email->message($this->load->view('Email/'.$type.'_mail', $data, TRUE));
                if($this->email->send()==true){
                    echo "<script>alert('Mail has been successfully sent to the given id');</script>";
                }else{
                    echo "<script>alert('Please Try Again');</script>";
                }
        }
      /*************************************
    * send_email_common_discrepency function
    * send_email_common_discrepency
    *************************************/
        function send_email_common_discrepency($type,$subject, $email, &$data)
        {
                $admin_email=implode(' , ',$this->config->item('Admin_email'));
               $this->load->library('email');
               $disemail_config['protocol']    = 'smtp';
                $disemail_config['smtp_host']    = 'ssl://smtp.gmail.com';
                $disemail_config['smtp_port']    = '465';
                $disemail_config['smtp_user']    = EMAIL_BGV;
                $disemail_config['smtp_pass']    = PASS_BGV;
                $disemail_config['mailtype'] = 'html';
                $this->email->initialize($disemail_config);
                $this->email->set_newline("\r\n");
                $this->email->from('info@dcoderesearch.com','Dcode');
                $this->email->to($email);
                $this->email->bcc($admin_email);
                $this->email->subject(sprintf($subject));
                $this->email->message($this->load->view('Email/'.$type.'_mail', $data, TRUE));
                if($this->email->send()==true){
                    echo "<script>alert('Mail has been successfully sent to the given id');</script>";
                }else{
                    echo "<script>alert('Please Try Again');</script>";
                }
        }
       /*************************************
    * send_change_password_email_common function
    * send_change_password_email_common
    *************************************/ 
        function send_change_password_email_common($type,$subject, $email,&$data)
        {
            
               $this->load->library('email');
               $email_config['protocol']    = 'smtp';
                $email_config['smtp_host']    = 'ssl://smtp.gmail.com';
                $email_config['smtp_port']    = '465';
                $email_config['smtp_user']    = EMAIL_BGV;
                $email_config['smtp_pass']    = PASS_BGV;
                $email_config['mailtype'] = 'html';
                $this->email->initialize($email_config);
                $this->email->set_newline("\r\n");
                $this->email->from('info@dcoderesearch.com','Dcode');
                $this->email->to($email);
                $this->email->subject(sprintf($subject));
                $this->email->message($this->load->view('Email/'.$type.'_mail', $data, TRUE));
                if($this->email->send()==true){
                    echo "<script>alert('Mail has been successfully sent to the given id');</script>";
                }else{
                    echo "<script>alert('Please Try Again');</script>";
                }
        }
     /*************************************
    * send_email_common_proposal function
    * send_email_common_proposal
    *************************************/    
        function send_email_common_proposal($type,$subject, $email,$ordermail, &$data)
        {
              
                $this->load->library('email');
                $email_config['protocol']    = 'smtp';
                $email_config['smtp_host']    = 'ssl://smtp.gmail.com';
                $email_config['smtp_port']    = '465';
                $email_config['smtp_user']    = EMAIL_BGV;
                $email_config['smtp_pass']    = PASS_BGV;
                $email_config['mailtype'] = 'html';
                $this->email->initialize($email_config);
                $this->email->set_newline("\r\n");
                $this->email->from('info@dcoderesearch.com','Dcode');
                $this->email->to($ordermail);
                $this->email->subject(sprintf($subject));
                $this->email->message($this->load->view('Email/'.$type.'_mail', $data, TRUE));
               if($this->email->send()==true){
                    //echo "<script>alert('Mail has been successfully sent to the given id');</script>";
                }else{
                    echo "<script>alert('Please Try Again');</script>";
                } 
        }
     /*************************************
    * send_email_common_revert function
    * send_email_common_revert
    *************************************/    
        function send_email_common_revert($type,$subject,$email, &$data){
           $this->load->library('email');
               $email_config['protocol']    = 'smtp';
                $email_config['smtp_host']    = 'ssl://smtp.gmail.com';
                $email_config['smtp_port']    = '465';
                $email_config['smtp_user']    = EMAIL_BGV;
                $email_config['smtp_pass']    = PASS_BGV;
                $email_config['mailtype'] = 'html';
                $this->email->initialize($email_config);
                $this->email->set_newline("\r\n");
                $this->email->from('info@dcoderesearch.com','Dcode');
                $this->email->to($email);
                $this->email->subject(sprintf($subject));
                $this->email->message($this->load->view('Email/'.$type.'_mail', $data, TRUE));
                if($this->email->send()==true){
                    echo "<script>alert('Mail has been successfully sent to HR');</script>";
                }else{
                    echo "<script>alert('Please Try Again');</script>";
                }
        }

    
         function send_email_common_notification($type,$subject, $email,$ordermail, &$data,$cc)
        {
                $this->load->library('email');
                $email_config['protocol']    = 'smtp';
                $email_config['smtp_host']    = 'ssl://smtp.gmail.com';
                $email_config['smtp_port']    = '465';
                $email_config['smtp_user']    = EMAIL_BGV;
                $email_config['smtp_pass']    = PASS_BGV;
                $email_config['mailtype'] = 'html';
                $this->email->initialize($email_config);
                $this->email->set_newline("\r\n");
                $this->email->from('info@dcoderesearch.com','Dcode');
                $this->email->to($ordermail);
                $this->email->cc($cc); 
                $this->email->subject(sprintf($subject));
                $this->email->message($this->load->view('Email/'.$type.'_mail', $data, TRUE));
               if($this->email->send()==true){
                    echo "<script>alert('Mail has been successfully sent to the given id');</script>";
                }else{
                    echo "<script>alert('Please Try Again');</script>";
                } 
        }
      /*************************************
    * load_state_by_country function
    * load_state_by_country
    *************************************/
        function load_state_by_country(){
                $countryid=$_POST['country_id'];
                if(isset($countryid)&&$countryid<>''){
                        $checkstates=$this->Common_model->check_states_by_country($countryid);
                        if($checkstates<>0){
                                $formatted=$this->Common_model->get_states_by_country($countryid);
                                $options='<option value="">Select</option>';
                                        foreach($formatted as $state){
                                        $options.='<option value="'.format_output($state->adminCode1).'" >'.format_output($state->name).'</option>';
                                }
                        }else{
                        $json = $this->curl->simple_get("http://ws.geonames.org/searchJSON?country=".$countryid."&featureClass=P&username=venkatesan");
                                $json = utf8_encode($json);
                                $city_suggest = json_decode($json, true);
                                $unformatted=array();
                                foreach($city_suggest['geonames'] as $city){
                                        if($city['adminName1']<>'')
                                        $unformatted[$city['adminCode1']]=$city['adminName1'];
                                }
                                $formatted=array_unique($unformatted);
                                natsort($formatted);
                                if(count($formatted) >0) 
                                foreach($formatted as $code=>$state){
                                $country_id=$this->Common_model->get_country_by_id($countryid);
                                $this->Common_model->insert_state_by_country($countryid,format_output($code),slug(format_output($state)),$country_id->id);
                                }
                                $options='<option value="">Select</option>';
                                foreach($formatted as $code=>$state){
                                $options.='<option value="'.format_output($code).'" >'.format_output($state).'</option>';
                                }
                        }
                echo $options;
                }
        }
 /*************************************
    * load_city_by_state function
    * load_city_by_state
    *************************************/
        function load_city_by_state(){       
                if(isset($_POST['state_id'])&&$_POST['state_id']<>''){
                $checkcities=$this->Common_model->check_cities_by_state($_POST['country_id'],$_POST['state_id']);
                if($checkcities<>0){
                        $formatted=$this->Common_model->get_cities_by_state($_POST['country_id'],$_POST['state_id']);
                        $options='<option value="">Select</option>';
                        foreach($formatted as $city){
                        $options.='<option value="'.format_output($city->id).'" >'.format_output($city->city).'</option>';
                        }
                }else{
                $json = $this->curl->simple_get("http://ws.geonames.org/searchJSON?country=".$_POST['country_id']."&adminCode1=".$_POST['state_id']."&featureClass=P&username=venkatesan");
                        $json = utf8_encode($json);
                        $city_suggest = json_decode($json, true);
                        $unformatted=array();
                        foreach($city_suggest['geonames'] as $city){
                        if($city['name']<>'')
                        $unformatted[$city['name']]=$city['name'];
                        }

                        $formatted=array_unique($unformatted);
                        natsort($formatted);

                        foreach($formatted as $code=>$city){
                        $state=$this->Common_model->get_state_by_id($_POST['country_id'],$_POST['state_id']);
                        $this->Common_model->insert_city_by_state($_POST['country_id'],$_POST['state_id'],slug(format_output($city)),$state->sid);
                        }
                        $formatted1=$this->Common_model->get_cities_by_state($_POST['country_id'],$_POST['state_id']);
                        $options='<option value="">Select</option>';
                        foreach($formatted1 as $city){
                        $options.='<option value="'.$city->id.'" >'.format_output($city->city).'</option>';
                        }

                }  
                echo $options; 
                }
        }
     /*************************************
    * getcollege function
    * getcollege
    *************************************/
        function getcollege()
        {
            $term = $_GET['term'];
            if (strlen($term) < 2){
                return false;
            } 
            $this->db->like('name',$term);
            $this->db->select('name');
            $rows = $this->db->get(DB_PREFIX."institutions")->result_array();         
            $json_array = array();
            foreach ($rows as $row)
            {
                $explode=explode(',',$row['name']);
                array_push($json_array, trim($explode[0]));
            }

            echo json_encode($json_array);
        }
     /*************************************
    * load_office function
    * load_office
    *************************************/   
        function load_office()
        {
                 $this->db->select('office_name,id,parent');
                 $this->db->where_in('parent_office',$_POST['parent_id']);
                 if(isset($_POST['organization'])){
                 $this->db->where('parent',0);
                 }
                 else{
                 $this->db->where('parent !=',0);
                 }
            $rows = $this->db->get(DB_PREFIX."office")->result_array();  
            $option='<option value="">Select</option>';
            foreach($rows as $row){
                $option .='<option id="'.$row['parent'].$this->data_value.$row['id'].'">'.$row['office_name'].'</option>';
            }
            echo $option;
            
        }
     /*************************************
    * load_branchoffice function
    * load_branchoffice
    *************************************/    
         function load_branchoffice()
        { 
                 $this->db->select('office_name,id,parent,level');
                 $this->db->where_in('parent_office',$_POST['parent_id']); 
                 if(isset($_POST['organization'])){
                 $this->db->where('level',0);
                 $this->db->where('parent !=',0);
                 }
                 else{
                    $this->db->where('level !=',0);
                 }
            $rows = $this->db->get(DB_PREFIX."office")->result_array();  
            $option='<option value="">Select</option>';
            foreach($rows as $row){
                $option .='<option id="'.$row['parent'].$this->data_value.$row['id'].'">'.$row['office_name'].'</option>';
            }
            echo $option;
            
        }
     /*************************************
    * load_selectedbranchoffice function
    * load_selectedbranchoffice
    *************************************/    
        function load_selectedbranchoffice()
        {
                 $this->db->select('office_name,id,parent,level');
                 $this->db->where_in('parent_office',$_POST['parent_id']);
                 $branchoffice=$this->session->userdata('boffice');
                
                 if(isset($_POST['organization'])){
                    
                if($branchoffice[0]==0){
                    $this->db->where('level',0);
                    $this->db->where('parent !=',0);
             }elseif($this->session->userdata('userid')==1 || $this->session->userdata('userType')==1){
                    $this->db->where('level',0);
                    $this->db->where('parent !=',0);
                }else{
                $this->db->where('level',0);
                $this->db->where('parent !=',0);
                 $this->db->where_in('id',$branchoffice);
             }
                 } else{
                 $this->db->where('level !=',0);
                }
                
            $rows = $this->db->get(DB_PREFIX."office")->result_array();  
            $option='<option value="">Select</option>';
            foreach($rows as $row){
                $option .='<option id="'.$row['parent'].$this->data_value.$row['id'].'">'.$row['office_name'].'</option>';
            }
            
            echo $option;
            
        }
     /*************************************
    * load_suboffice function
    * load_suboffice
    *************************************/    
        function load_suboffice()
        {
                 $this->db->select('office_name,id,parent,level');
                 $this->db->where_in('level',$_POST['parent_id']);
                 if(isset($_POST['organization'])){
                    $this->db->where('level',0);
                 }
                 else{
                    $this->db->where('level !=',0);
                 }
            $rows = $this->db->get(DB_PREFIX."office")->result_array();  
            $option='<option value="">Select</option>';
            foreach($rows as $row){
                $option .='<option id="'.$row['parent'].$this->data_value.$row['id'].'">'.$row['office_name'].'</option>';
            }
            echo $option;
            
        } 
     /*************************************
    * load_selectedsuboffice function
    * load_selectedsuboffice
    *************************************/    
        function load_selectedsuboffice()
        {

                 $this->db->select('office_name,id,parent,level');
                 $this->db->where_in('level',$_POST['parent_id']);
                 $suboffice=$this->session->userdata('soffice');
                if(isset($_POST['organization'])){
                 $this->db->where('level',0);
                    }
                    else if($suboffice[0]==0){
                 $this->db->where('level !=',0);
                }
                else if($this->session->userdata('userid')==1 || $this->session->userdata('userType')==1){
                   $this->db->where('level !=',0);
               }
               else{
                $this->db->where('level !=',0);
                 $this->db->where_in('id',$suboffice); 
               
                }
            $rows = $this->db->get(DB_PREFIX."office")->result_array();  
            $option='<option value="">Select</option>';
            foreach($rows as $row){
                $option .='<option id="'.$row['parent'].$this->data_value.$row['id'].'">'.$row['office_name'].'</option>';
            }
            echo $option;
        } 
      /*************************************
    * logout function
    * logout
    *************************************/
        function logout()
    {
        $secure_cookie = (bool) config_item('cookie_secure');
        setcookie('csrf_cookie_name',$this->security->get_csrf_hash(),01,config_item('cookie_path'),config_item('cookie_domain'),
        $secure_cookie,config_item('cookie_httponly'));
         
         $this->session->sess_destroy();
         redirect('Index/login');
    }
     /*************************************
    * load_email function
    * load_email
    *************************************/
    function load_email($id,$parent=false)
    {
        $this->db->select('email,id');
        $this->db->where('organization',$_POST['organization']);
        if(isset($_POST['parent_office']) && $_POST['parent_office']<>''){
            $this->db->where('parent_office',$_POST['parent_office']);
        }
        if(isset($_POST['office_id']) && $_POST['office_id']<>''){
            $this->db->where('office_id',$_POST['office_id']);
        }
        $this->db->where('role_id !=',16);
        $rows = $this->db->get(DB_PREFIX."user")->result_array();  
        $option='';
        foreach($rows as $row){
            if($row['email']<>''){
                $option .='<option value="'.$row['id'].'" >'.$row['email'].'</option>';
            }
        }

        echo $option;
            
    }
    /*************************************
    * export_excel function
    * export_excel
    *************************************/
    function export_excel($a,$b,$fname,$objPHPExcel){
        foreach(range($a, $b) as $columnID) {
        $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
        }
        $objPHPExcel->setActiveSheetIndex(0); 
        $filename = $fname.date('d-m-Y H:i:s').".xls";
        header('Content-Type: application/vnd.ms-excel');
        header("Content-Disposition: attachment;filename=\"$filename\"");
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); 
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); 
        header ('Cache-Control: cache, must-revalidate'); 
        header ('Pragma: public'); 
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        ob_end_clean();
        ob_start();    
        $objWriter->save('php://output');      
    }

       function load_state(){       

                if(isset($_POST['country_id'])&&$_POST['country_id']<>''){

                $checkcities=$this->Common_model->check_country($_POST['country_id']);
                if($checkcities<>0){
                        $formatted=$this->Common_model->get_state($_POST['country_id']);
                        $options='<option value="">Select</option>';
                        foreach($formatted as $city){
                        $options.='<option value="'.format_output($city->id).'" >'.format_output($city->name).'</option>';
                        }
                }
              
                echo $options; 
                }
        }

         function load_city(){     
              

                if(isset($_POST['state_id'])&&$_POST['state_id']<>''){

                $checkcities=$this->Common_model->check_country($_POST['country_id']);
                if($checkcities<>0){
                        $formatted=$this->Common_model->get_city($_POST['state_id']);
                        $options='<option value="">Select</option>';
                        foreach($formatted as $city){
                        $options.='<option value="'.format_output($city->id).'" >'.format_output($city->name).'</option>';
                        }
                }
              
                echo $options; 
                }
        }

        
    function send_email_reminder($type,$subject, $email, &$data){
                
                $this->load->library('email');
                $email_config['protocol']    = 'smtp';
                $email_config['smtp_host']    = 'ssl://smtp.gmail.com';
                $email_config['smtp_port']    = '465';
                $email_config['smtp_user']    = EMAIL_BGV;
                $email_config['smtp_pass']    = PASS_BGV;
                $email_config['mailtype'] = 'html';
                $this->email->initialize($email_config);
                $this->email->set_newline("\r\n");
                $this->email->from('info@dcoderesearch.com','Dcode');
                $this->email->to($email);
                $this->email->subject(sprintf($subject));
                $data['resultab']=$data[0];
                $this->email->message($this->load->view('Email/'.$type, $data, TRUE));
                $this->email->send();
    }

    function Is_email($user)
    {
        //If the username input string is an e-mail, return true
        if(filter_var($user, FILTER_VALIDATE_EMAIL)) {
            return true;
        } else {
            return false;
        }
    }

    function Log_attempt($userName)
    {
        $check_email = $this->Is_email($userName);
        if($check_email){ 
            $this->db-> select('login_attempt, username')->from(DB_PREFIX .'user')->where("(email = '$userName' AND status = 1)");
            $num =$this->db->get()->result_array();
            }else{
            $this->db->select('login_attempt, username')->from(DB_PREFIX . 'user ')->where("(username = '$userName' AND status = 1)");
            $num =$this->db->get()->result_array();
            }
            //return $num[0]['login_attempt'];
            return $num;
    }

    /* 
    * load_selected check function
    * load_selectedchecks
    */
    function load_selectedcheck()
    {

            $this->db->select('name,id');
            $this->db->where_in('ref_id',$_POST['package_id']);
            $this->db->where_not_in('id',$_POST['checkval']);
            $this->db->where('key','check');
            $this->db->order_by('seqid');
            $rows = $this->db->get(DB_PREFIX."master_masterdata ")->result_array(); 
            $count=count($rows);
            
            $option ='<option value="">Select Check</option>';
            foreach($rows as $row){
                $option .='<option id="'.$row['id'].$this->data_value.$row['id'].'" title="'.$row['name'].'">'.$row['name'].'</option>';
            }
            //$option .='<input type="hidden" name="group" value="'.$_POST['package_id'].'" class="chkcount" >';
            echo $option;
           
        }

        /* 
    * load_discrepancy  function
    * load_discrepancy
    */
    function load_discrepancy()
    {
            $this->db->select('name,id');
            $this->db->where_in('ref_id',$_POST['check_id']);
            $this->db->where('key','discrepancy_parameters');
            $this->db->order_by('seqid');
            $rows = $this->db->get(DB_PREFIX."master_masterdata")->result_array(); 

            if($_POST['check_id'] == 68 || $_POST['check_id'] == 69 || $_POST['check_id'] == 649){
                
                $checks = '<input type="text" class="de_text numbervalue multisele'.$_POST['check_id'].' required " id = "acceptable_limit'.$_POST['check_id'].'"  name =" acceptable_limit'.$_POST['check_id'].'[]" value = "" autocomplete="off" style="width:196px;"/>';
            }else{

            $checks .= '<input type="checkbox" class="de_text select_all" id="acceptable_limit'.$_POST['check_id'].'" name="select_all'.$_POST['check_id'].'[]" value="" > Select all</br>';
            
            foreach($rows as $row){
                $checks .= '<input type="checkbox" class="de_text numbervalues multisele'.$_POST['check_id'].' required" id ="acceptable_limit" name =" acceptable_limit'.$_POST['check_id'].'[]" value = "'.$row['name'].'" autocomplete="off">'.$row['name'].'<br>';
            }
            }
            echo $checks;
        }


        /*************************************
    * check_package function
    * check_package
    *************************************/
    function check_package() {
            
            $pkgname=$_POST['pkg_name']; 
            
            $result=$this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id'), array('name' => $pkgname,'key='=> 'package'));
            echo ($result) ?   1 : 0;
      
    }

    /* 
    * load_package function
    * load_package
    */
    function load_package()
    {
        if(!empty($_POST['org_id'])){
            
            $this->db->select('DISTINCT(package_id) as id,package_name as name');
            $this->db->where('org_id',$_POST['org_id']);
            $rows = $this->db->get(DB_PREFIX."packages ")->result_array(); 
            $count=count($rows);
        }else{
            $rows = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name'),array('key'=>'package'));
        }

            
            $option ='<option value="">Select Package</option>';
            foreach($rows as $row){
                $option .='<option id="'.$row['id'].$this->data_value.$row['id'].'" title="'.$row['name'].'">'.$row['name'].'</option>';
            }
            $option .='</select>';
            echo $option;
           
        }


    /*********** Get Standard Checks 
        function load_ncheck 
        ***************************/
    function load_ncheck()
    {
        $sql = " Select * from ".DB_PREFIX . "group order by seq_id" ;
        $group_details = $this->db->query( $sql )->result_array();

        foreach ($group_details as $grouprow) {
            //print_r($grouprow);
            $html .='<tr><td style="margin:10px;width:200px;"><h2 >'.$grouprow['group_name'].':<span class="checkbtn spnid"  style="color:black;font-weight:normal;cursor:pointer;font-size: 12px;"></span></h2></td></tr>';

            $this->db->select('name,id');
            $this->db->where_in('ref_id',$grouprow['group_id']);
            $this->db->where('key','check');
            $this->db->order_by('seqid');
            $rows = $this->db->get(DB_PREFIX."master_masterdata ")->result_array(); 
            
            
            
            foreach($rows as $row){

                $html .='<tr class="s-usebrd" height="35"><td class="s-usetxt" style="width:300px;"><label >'.$row['name'].'</label><input type="hidden" name="check_id[]" value="'.$row['id'].'"></td><td class="s-usetxt" style="width:80px;"><input type="number" name="check_tat'.$row['id'].'" value="" min="1" max="100" class="s-input tatdays totaltat'.$row['id'].'" id="'.$row['id'].'" style="width: 80px; margin-left: 50px; float: left;"></td><td class="s-usetxt" style="width:80px;"><input type="number" name="dataentry_tat'.$row['id'].'" value="" min="1" max="100" class="s-input de_tat detat'.$row['id'].'" id="'.$row['id'].'" readonly style="width: 80px; margin-left: 50px; float: left;"></td><td class="s-usetxt" style="width:80px;"><input type="number" name="verification_tat'.$row['id'].'" value="" min="1" max="100" class="s-input ver_tat vertat'.$row['id'].'" id="'.$row['id'].'" readonly style="width: 80px; margin-left: 50px; float: left;"></td><td class="s-usetxt" style="width:80px;"><input type="number" name="qc_tat'.$row['id'].'" value="" min="1" max="100" class="s-input qc_tat qctat'.$row['id'].'" id="'.$row['id'].'" readonly style="width: 80px; margin-left: 50px; float: left;"></td></tr><br />';
            }
        }
            
            echo $html;
           
    }

    /*********** Get Custom Checks **********
        function getcustom_check 
    *****************************************/
    function getcustom_check()
    {
        /***** Query to check Standard TAT *************/
        $sql="SELECT * FROM ".DB_PREFIX ."customer_tat";
        $sql .=" WHERE (org_id=0)";
        $Resrow= $this->db->query($sql);
        $Standard= $Resrow->result_array();
// print_r($Standard);exit;
    /************* Query Start for organization wise order created check and packages *********/

            $this->db->select('id');
            $this->db->where('organisation',$_POST['organisation']);
            $this->db->where('status',1);
            $rows = $this->db->get(DB_PREFIX."order ")->result_array(); 
            

            $newArr=array();

            foreach ($rows as $key => $value) {

                $orderId=$value['id'];

                $sql="SELECT ac.order_id,md.id,md.name FROM ".DB_PREFIX ."master_masterdata md 
                LEFT JOIN ".DB_PREFIX."add_check ac ON ac.types_of_check=md.id
                LEFT JOIN ".DB_PREFIX."order o ON o.id=ac.order_id and o.status=1";
                $sql .=" WHERE (o.id='".$value['id']."' ) ORDER BY md.seqid";
                $result= $this->db->query($sql);
                $ncheck= $result->result_array();
                
                $newArr=array_merge($newArr, $ncheck);
                
            }
                        
            
            $packageArr=array();
            $checkArr=array();
            foreach($newArr as $row){

                
                if($row['id'] > 650){
                    $row['name']='';

                    $sql="SELECT md.id FROM ".DB_PREFIX ."master_masterdata md 
                    LEFT JOIN ".DB_PREFIX."packages p ON p.check_id=md.id";

                    $sql .=" WHERE (p.package_id='".$row['id']."')";
                    $result= $this->db->query($sql);
                    $rows= $result->result_array();
                    
                    $packageArr=array_merge($packageArr, $rows);
                                        
                }else{

                    $sql="SELECT md.id FROM ".DB_PREFIX ."master_masterdata md ";
                    $sql .=" WHERE (md.id='".$row['id']."')";
                    $result1= $this->db->query($sql);
                    $rows1= $result1->result_array();
                    
                    $checkArr=array_merge($checkArr, $rows1);
                    
                }

                $merge=array_merge($packageArr, $checkArr);
            }
            
            $ids = array_column($merge, 'id');
            $ids = array_unique($ids);
            $merge_array = array_filter($merge, function ($key, $value) use ($ids) {
                return in_array($value, array_keys($ids));
            }, ARRAY_FILTER_USE_BOTH);
            

            $sql = " Select * from ".DB_PREFIX . "group order by seq_id" ;
            $group_details = $this->db->query( $sql )->result_array();

            foreach ($group_details as $grouprow) {

                $html .='<tr><td style="margin:10px;width:200px;"><h2 >'.$grouprow['group_name'].':<span class="checkbtn spnid"  style="color:black;font-weight:normal;cursor:pointer;font-size: 12px;"></span></h2></td></tr>';

                foreach ($merge_array as $mval) {

                    if(!empty($Standard))
                    {
                        $sql="SELECT m.id,m.name,c.check_tat, c.dataentry_tat, c.verification_tat, c.qc_tat FROM ".DB_PREFIX ."master_masterdata m
                        LEFT JOIN ".DB_PREFIX."customer_tat c ON c.check_id=m.id";
                        $sql .=" WHERE (m.id='".$mval['id']."' AND m.ref_id='".$grouprow['group_id']."' AND c.org_id=0) ORDER BY seqid";
                        $results= $this->db->query($sql);
                        $resRow= $results->result_array();
                    }
                    else
                    {
                        $sql="SELECT id,name FROM ".DB_PREFIX ."master_masterdata ";
                        $sql .=" WHERE (id='".$mval['id']."' AND ref_id='".$grouprow['group_id']."') ORDER BY seqid";
                        $results= $this->db->query($sql);
                        $resRow= $results->result_array();
                    }
                    

                    foreach ($resRow as $row) {
                           
                            $html .='<tr class="s-usebrd" height="35"><td class="s-usetxt" style="width:300px;"><label >'.$row['name'].'</label><input type="hidden" name="check_id[]" value="'.$row['id'].'"></td><td class="s-usetxt" style="width:80px;"><input type="number" name="check_tat'.$row['id'].'" value="'.$row['check_tat'].'" min="1" max="100" class="s-input tatdays totaltat'.$row['id'].'" id="'.$row['id'].'" style="width: 80px; margin-left: 50px; float: left; text-align:right"></td><td class="s-usetxt" style="width:80px;"><input type="number" name="dataentry_tat'.$row['id'].'" value="'.$row['dataentry_tat'].'" min="1" max="100" class="s-input de_tat detat'.$row['id'].'" id="'.$row['id'].'"  style="width: 80px; margin-left: 50px; float: left; text-align:right"></td><td class="s-usetxt" style="width:80px;"><input type="number" name="verification_tat'.$row['id'].'" value="'.$row['verification_tat'].'" min="1" max="100" class="s-input ver_tat vertat'.$row['id'].'" id="'.$row['id'].'"  style="width: 80px; margin-left: 50px; float: left; text-align:right"></td><td class="s-usetxt" style="width:80px;"><input type="number" name="qc_tat'.$row['id'].'" value="'.$row['qc_tat'].'" min="1" max="100" class="s-input qc_tat qctat'.$row['id'].'" id="'.$row['id'].'"  style="width: 80px; margin-left: 50px; float: left; text-align:right"></td></tr><br />';

                    }
                }

                    
            }
                echo $html;
                      
    }

    /************Load Date of organization**
    ****** Function load_date() ************
    ****************************************/
    function load_date()
    {
        $this->db->select('created_on');
        $this->db->where('id',$_POST['organisation']);
        $this->db->where('org_status','1');
        $rows = $this->db->get(DB_PREFIX."organisation ")->result_array();
        foreach ($rows as $key => $value) {
            $c_date= date('d-m-Y', strtotime($value['created_on']));
            $html='<input type="text" name="effective_from_date" value="'.$c_date.'" id="Effective " class="s-inpt Effective" placeholder="DD-MM-YYYY" readonly="readonly">';
        }
        echo $html;
    }

    /*********************************
    *******Calculate Working Days*****
    **********************************/
    function number_of_working_days($startDate, $endDate)
    {
        $workingDays = 0;
        $startTimestamp = strtotime($startDate);
        $endTimestamp = strtotime($endDate);
        for ($i = $startTimestamp; $i <= $endTimestamp; $i = $i + (60 * 60 * 24)) {
            if (date("N", $i) <= 5) $workingDays = $workingDays + 1;
        }
        return $workingDays;
    }


    function get_vmemberdata(){

        //print_r($_POST);exit;
        
        $userid=$_POST['user_id'];
        $role=$this->dmodel->getroles($userid);
        // echo $userid;
        $role_id=$role[0]['role_id'];

        $newcheck = $this->dmodel->get_vmcheck_bystatus('new',$role_id,$userid);
        $initiatedcheck = $this->dmodel->get_vmcheck_bystatus('initiated',$role_id,$userid);
        $RevertAssigned = $this->dmodel->get_vmcheck_bystatus('revertassigned',$role_id,$userid);
        $RevertRaised = $this->dmodel->get_vmcheck_bystatus('revertraised',$role_id,$userid);
        $RevertClosed = $this->dmodel->get_vmcheck_bystatus('revertclosed',$role_id,$userid);
        $RequestRaised = $this->dmodel->get_vmcheck_bystatus('requestraised',$role_id,$userid);
        $DDapplied = $this->dmodel->get_vmcheck_bystatus('DDapplied',$role_id,$userid);
        $ReopenAssigned = $this->dmodel->get_vmcheck_bystatus('reopenassigned',$role_id,$userid);

        
        $totalNewchecks=count($newcheck);
        $totalInitiated=count($initiatedcheck);
        $totalRevertAssigned=count($RevertAssigned);
        $totalRevertRaised=count($RevertRaised);
        $totalRevertClosed=count($RevertClosed);
        $totalRequestRaised=count($RequestRaised);
        $totalDDapplied=count($DDapplied);
        $totalReopenAssigned=count($ReopenAssigned);


    $html='<div class="right-mem-bx" style="margin-left:0px;border:none;padding-bottom:0px;">
                <div class="mem-bg">
                    <h2 align="center">Dashboard</h2>
                </div>
                <div class="tableFixHead s-fombx">
                    <table border align="center">
                        <thead>
                         <tr class="at_tr" height="35" >
                            <th class="at_th" style="width:300px;""><h2 style="color:black;">Check Status</h2></th>               
                            <th class="at_th" style="width:100px;"><h2 style="color:black;">No of Checks</h2></th>
                            <th class="at_th" style="width:100px;"><h2 style="color:black;">Checks Overdue</h2></th>
                            <th class="at_th" style="width:100px;"><h2 style="color:black;">Checks Due Today</h2></th>
                            <th class="at_th" style="width:100px;"><h2 style="color:black;">Checks Due in Next 5 Days</h2></th>
                            <th class="at_th" style="width:100px;"><h2 style="color:black;">Checks Due in Next 6+ Days</h2></th>
                        </tr>
                        </thead>
                        <tbody>';
                    $html.="<tr class='' height='25'>
                                <td  class='at_td' style='color:#022151;width:300px;height: 25px;'><label style='margin-left: 10px;'>New</label></td>
                                <td  class='at_td' style='width:100px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>";
                                $html.=$totalNewchecks == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('New').'/'.base64_encode($userid),"<span style='color:black'>".$totalNewchecks."</span>",'target=""');           
                        $html.="</td>";

                            $chkOverdue=array(); 
                                $new=1; 
                                $chkDueToday=array();
                                $chkDueNextFivedays=array();
                                $chkDueSixPlusdays=array();

                                foreach ($newcheck as $value) 
                                {
                                    $tdays=$value['Days'];
                                    if($tdays > $value['verification_tat'])
                                    { 
                                       $chkOverdue[]=$new;   
                                    } 

                                    if($tdays == $value['verification_tat'])
                                    { 
                                       $chkDueToday[]=$new;   
                                    }

                                    if($tdays < $value['verification_tat'] && $tdays > ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueNextFivedays[]=$new;   
                                    }

                                    if($tdays <= ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueSixPlusdays[]=$new;   
                                    }
                                     
                                 $new++;
                                }

                            $html.="<td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px; background-color: red;'>";
                                    
                                    $check_overdue=count($chkOverdue);
                                    $html.= $check_overdue == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('NewOverdue').'/'.base64_encode($userid),"<span style='color:black'>".$check_overdue."</span>",'target=""');
                            $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: #f89406;'>";
                                    
                                    $check_duetoday=count($chkDueToday);
                                    $html.= $check_duetoday == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('NewDueTday').'/'.base64_encode($userid),"<span style='color:black'>".$check_duetoday."</span>",'target=""');    
                            $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                    $check_dueNextFivDays=count($chkDueNextFivedays);
                                    $html.= $check_dueNextFivDays == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('NewDueNext5day').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueNextFivDays."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                     
                                    $check_dueSixPlusDays= count($chkDueSixPlusdays);
                                    $html.=$check_dueSixPlusDays == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('NewDueNext6dayPlus').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueSixPlusDays."</span>",'target=""');
                                    
                            $html.="</td>
                            </tr>
                            <tr class='' height='25' >
                                <td  class='at_td' style='color:#022151;width:300px;height: 25px;'><label style='margin-left: 10px;'>Initiated</label></td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                
                                $html.= $totalInitiated == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('Initiated').'/'.base64_encode($userid),"<span style='color:black'>".$totalInitiated."</span>",'target=""'); 

                                /*************** Initiated ***************/
                                $chkOverdue1=array(); 
                                $initiated=1; 
                                $chkDueToday1=array();
                                $chkDueNextFivedays1=array();
                                $chkDueSixPlusdays1=array();
                                foreach ($initiatedcheck as $value) 
                                {
                                    $tdays=$value['Days'];
                                    
                                    if($tdays > $value['verification_tat'])
                                    { 
                                       $chkOverdue1[]=$initiated;   
                                    } 

                                    if($tdays == $value['verification_tat'])
                                    { 
                                       $chkDueToday1[]=$initiated;   
                                    }

                                    if($tdays < $value['verification_tat'] && $tdays > ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueNextFivedays1[]=$initiated;   
                                    }

                                    if($tdays <= ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueSixPlusdays1[]=$initiated;   
                                    }
                                     
                                 $initiated++;
                                }
                                            
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: red;'>";
                                    
                                    $check_overdue1=count($chkOverdue1);
                                    $html.= $check_overdue1 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('InitiatedOverdue').'/'.base64_encode($userid),"<span style='color:black'>".$check_overdue1."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: #f89406;'>";
                                    
                                    $check_duetoday1=count($chkDueToday1);
                                    $html.= $check_duetoday1==0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('InitiatedDueTday').'/'.base64_encode($userid),"<span style='color:black'>".$check_duetoday1."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                    $check_dueNextFivDays1=count($chkDueNextFivedays1);
                                    $html.=$check_dueNextFivDays1 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('InitiateDueNext5day').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueNextFivDays1."</span>",'target=""');
                                    
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                     
                                    $check_dueSixPlusDays1= count($chkDueSixPlusdays1);
                                    $html.= $check_dueSixPlusDays1 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('InitiateDueNext6dayPlus').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueSixPlusDays1."</span>",'target=""');
                                    
                                $html.="</td>
                                </tr>
                                <tr class='' height='25' >
                                <td  class='at_td' style='color:#022151;width:300px;height: 25px;'><label style='margin-left: 10px;'>Revert Assigned</label></td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                     
                                $html.= $totalRevertAssigned == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertAssigned').'/'.base64_encode($userid),"<span style='color:black'>".$totalRevertAssigned."</span>",'target=""');
                                $html.="</td>";

                                /*************** Revert Assigned ***************/
                                $chkOverdue2=array(); 
                                $revertAssigned=1; 
                                $chkDueToday2=array();
                                $chkDueNextFivedays2=array();
                                $chkDueSixPlusdays2=array();
                                foreach ($RevertAssigned as $value) 
                                {
                                    $tdays=$value['Days'];
                                    
                                    if($tdays > $value['verification_tat'])
                                    { 
                                       $chkOverdue2[]=$revertAssigned;   
                                    } 

                                    if($tdays == $value['verification_tat'])
                                    { 
                                       $chkDueToday2[]=$revertAssigned;   
                                    }

                                    if($tdays < $value['verification_tat'] && $tdays > ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueNextFivedays2[]=$revertAssigned;   
                                    }

                                    if($tdays <= ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueSixPlusdays2[]=$revertAssigned;   
                                    }
                                     
                                 $revertAssigned++;
                                }

                                $html.="<td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: red;'>";
                                    
                                    $check_overdue2=count($chkOverdue2);
                                    $html.= $check_overdue2 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertAssignedOverdue').'/'.base64_encode($userid),"<span style='color:black'>".$check_overdue2."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: #f89406;'>";
                                    
                                    $check_duetoday2=count($chkDueToday2);
                                    $html.= $check_duetoday2==0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertAssignedDueTday').'/'.base64_encode($userid),"<span style='color:black'>".$check_duetoday2."</span>",'target=""');
                                
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                    $check_dueNextFivDays2=count($chkDueNextFivedays2);
                                    $html.= $check_dueNextFivDays2 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertAssignedDueNext5day').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueNextFivDays2."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                    $check_dueSixPlusDays2= count($chkDueSixPlusdays2);
                                    $html.= $check_dueSixPlusDays2 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertAssignedDueNext6dayPlus').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueSixPlusDays2."</span>",'target=""');
                                $html.="</td>
                            </tr>
                            <tr class='' height='25' >
                                <td  class='at_td' style='color:#022151;width:300px;height: 25px;'><label style='margin-left: 10px;'>Revert Raised</label></td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                      
                                $html.= $totalRevertRaised == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertRaised').'/'.base64_encode($userid),"<span style='color:black'>".$totalRevertRaised."</span>",'target=""');
                                    
                                $html.="</td>";
                                /*************** Revert Raised ***************/
                                $chkOverdue3=array(); 
                                $revertRaised=1; 
                                $chkDueToday3=array();
                                $chkDueNextFivedays3=array();
                                $chkDueSixPlusdays3=array();
                                foreach ($RevertRaised as $value) 
                                {
                                    $tdays=$value['Days'];
                                    
                                    if($tdays > $value['verification_tat'])
                                    { 
                                       $chkOverdue3[]=$revertRaised;   
                                    } 

                                    if($tdays == $value['verification_tat'])
                                    { 
                                       $chkDueToday3[]=$revertRaised;   
                                    }

                                    if($tdays < $value['verification_tat'] && $tdays > ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueNextFivedays3[]=$revertRaised;   
                                    }

                                    if($tdays <= ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueSixPlusdays3[]=$revertRaised;   
                                    }
                                     
                                 $revertRaised++;
                                }

                                $html.="<td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: red;'>";
                                    
                                    $check_overdue3=count($chkOverdue3);
                                    $html.= $check_overdue3 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertRaisedOverdue').'/'.base64_encode($userid),"<span style='color:black'>".$check_overdue3."</span>",'target=""');    
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: #f89406;'>";
                                    
                                    $check_duetoday3=count($chkDueToday3);
                                    $html.= $check_duetoday3==0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertRaisedDueTday').'/'.base64_encode($userid),"<span style='color:black'>".$check_duetoday3."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                    $check_dueNextFivDays3=count($chkDueNextFivedays3);
                                    $html.= $check_dueNextFivDays3 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertRaisedDueNext5day').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueNextFivDays3."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                    
                                    $check_dueSixPlusDays3= count($chkDueSixPlusdays3);
                                    $html.= $check_dueSixPlusDays3 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertRaisedDueNext6dayPlus').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueSixPlusDays3."</span>",'target=""');
                                $html.="</td>
                            </tr>
                            <tr class='' height='25' >
                                <td  class='at_td' style='color:#022151;width:300px;height: 25px;'><label style='margin-left: 10px;'>Revert Closed</label></td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                     
                                    $html.= $totalRevertClosed == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertClosed').'/'.base64_encode($userid),"<span style='color:black'>".$totalRevertClosed."</span>",'target=""');
                                $html.="</td> ";
                                /*************** Revert Closed ***************/
                                $chkOverdue4=array(); 
                                $revertClosed=1; 
                                $chkDueToday4=array();
                                $chkDueNextFivedays4=array();
                                $chkDueSixPlusdays4=array();
                                foreach ($RevertClosed as $value) 
                                {
                                    $tdays=$value['Days'];
                                    
                                    if($tdays > $value['verification_tat'])
                                    { 
                                       $chkOverdue4[]=$revertClosed;   
                                    } 

                                    if($tdays == $value['verification_tat'])
                                    { 
                                       $chkDueToday4[]=$revertClosed;   
                                    }

                                    if($tdays < $value['verification_tat'] && $tdays > ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueNextFivedays4[]=$revertClosed;   
                                    }

                                    if($tdays <= ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueSixPlusdays4[]=$revertClosed;   
                                    }
                                     
                                 $revertClosed++;
                                }

                                $html.="<td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: red;'>";
                                    
                                    $check_overdue4=count($chkOverdue4);
                                    $html.= $check_overdue4 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertClosedOverdue').'/'.base64_encode($userid),"<span style='color:black'>".$check_overdue4."</span>",'target=""');
                                $html.="</td>

                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: #f89406;'>";
                                    
                                    $check_duetoday4=count($chkDueToday4);
                                    $html.= $check_duetoday4==0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertClosedDueTday').'/'.base64_encode($userid),"<span style='color:black'>".$check_duetoday4."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                    $check_dueNextFivDays4=count($chkDueNextFivedays4);
                                    $html.= $check_dueNextFivDays4 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertClosedDueNext5day').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueNextFivDays4."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                   
                                    $check_dueSixPlusDays4= count($chkDueSixPlusdays4);
                                    $html.= $check_dueSixPlusDays4 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertClosedDueNext6dayPlus').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueSixPlusDays4."</span>",'target=""');
                                $html.="</td>
                            </tr>
                            <tr class='' height='25' >
                                <td  class='at_td' style='color:#022151;width:300px;height: 25px;'><label style='margin-left: 10px;'>Request Raised</label></td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                     
                                    $html.= $totalRequestRaised == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RequestRaised').'/'.base64_encode($userid),"<span style='color:black'>".$totalRequestRaised."</span>",'target=""');
                                $html.="</td> ";
                                /*************** Request Raised ***************/
                                $chkOverdue5=array(); 
                                $requestRaised=1; 
                                $chkDueToday5=array();
                                $chkDueNextFivedays5=array();
                                $chkDueSixPlusdays5=array();
                                foreach ($RequestRaised as $value) 
                                {
                                    $tdays=$value['Days'];
                                                                        
                                    if($tdays > $value['verification_tat'])
                                    { 
                                       $chkOverdue5[]=$requestRaised;   
                                    } 

                                    if($tdays == $value['verification_tat'])
                                    { 
                                       $chkDueToday5[]=$requestRaised;   
                                    }

                                    if($tdays < $value['verification_tat'] && $tdays > ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueNextFivedays5[]=$requestRaised;   
                                    }

                                    if($tdays <= ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueSixPlusdays5[]=$requestRaised;   
                                    }
                                     
                                 $requestRaised++;
                                }

                                $html.="<td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: red;'>";
                                    
                                        $check_overdue5=count($chkOverdue5);
                                        $html.= $check_overdue5 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RequestRaisedOverdue').'/'.base64_encode($userid),"<span style='color:black'>".$check_overdue5."</span>",'target=""');
                                $html.="</td>

                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: #f89406;'>";
                                    
                                        $check_duetoday5=count($chkDueToday5);
                                        $html.= $check_duetoday5==0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RequestRaisedDueTday').'/'.base64_encode($userid),"<span style='color:black'>".$check_duetoday5."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                        $check_dueNextFivDays5=count($chkDueNextFivedays5);
                                        $html.= $check_dueNextFivDays5 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RequestRaisedDueNext5day').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueNextFivDays5."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                   
                                    $check_dueSixPlusDays5= count($chkDueSixPlusdays5);
                                    $html.= $check_dueSixPlusDays5 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RequestRaisedDueNext6dayPlus').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueSixPlusDays5."</span>",'target=""');
                                $html.="</td>
                            </tr>
                            <tr class='' height='25' >
                                <td  class='at_td' style='color:#022151;width:300px;height: 25px;'><label style='margin-left: 10px;'>DD applied</label></td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                     
                                    $html.= $totalDDapplied == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('DDApplied').'/'.base64_encode($userid),"<span style='color:black'>".$totalDDapplied."</span>",'target=""'); 
                                $html.="</td>";
                                /*************** DD Applied ***************/
                                $chkOverdue6=array(); 
                                $ddApplied=1; 
                                $chkDueToday6=array();
                                $chkDueNextFivedays6=array();
                                $chkDueSixPlusdays6=array();
                                foreach ($DDapplied as $value) 
                                {
                                    $tdays=$value['Days'];
                                    
                                    if($tdays > $value['verification_tat'])
                                    { 
                                       $chkOverdue6[]=$ddApplied;   
                                    } 

                                    if($tdays == $value['verification_tat'])
                                    { 
                                       $chkDueToday6[]=$ddApplied;   
                                    }

                                    if($tdays < $value['verification_tat'] && $tdays > ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueNextFivedays6[]=$ddApplied;   
                                    }

                                    if($tdays <= ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueSixPlusdays6[]=$ddApplied;   
                                    }
                                     
                                 $ddApplied++;
                                }

                                $html.="
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: red;'>";
                                    
                                        $check_overdue6=count($chkOverdue6);
                                        $html.= $check_overdue6 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('DDAppliedOverdue').'/'.base64_encode($userid),"<span style='color:black'>".$check_overdue6."</span>",'target=""');
                                $html.="</td>

                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: #f89406;'>";
                                    
                                        $check_duetoday6=count($chkDueToday6);
                                        $html.= $check_duetoday6==0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('DDAppliedDueTday').'/'.base64_encode($userid),"<span style='color:black'>".$check_duetoday6."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                        $check_dueNextFivDays6=count($chkDueNextFivedays6);
                                        $html.= $check_dueNextFivDays6 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('DDAppliedDueNext5day').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueNextFivDays6."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                     
                                    $check_dueSixPlusDays6= count($chkDueSixPlusdays6);
                                    $html.= $check_dueSixPlusDays6 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('DDAppliedDueNext6dayPlus').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueSixPlusDays6."</span>",'target=""');
                                $html.="</td>
                            </tr>
                            <tr class='' height='25' >
                                <td  class='at_td' style='color:#022151;width:300px;height: 25px;'><label style='margin-left: 10px;'>Reopen Assigned</label></td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                      
                                    $html.= $totalReopenAssigned == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('ReopenAssigned').'/'.base64_encode($userid),"<span style='color:black'>".$totalReopenAssigned."</span>",'target=""');
                                $html.="</td>";
                                /*************** Revert Assigned ***************/
                                $chkOverdue7=array(); 
                                $reopenAssigned=1; 
                                $chkDueToday7=array();
                                $chkDueNextFivedays7=array();
                                $chkDueSixPlusdays7=array();
                                foreach ($ReopenAssigned as $value) 
                                {
                                    $tdays=$value['Days'];
                                    
                                    if($tdays > $value['verification_tat'])
                                    { 
                                       $chkOverdue7[]=$reopenAssigned;   
                                    } 

                                    if($tdays == $value['verification_tat'])
                                    { 
                                       $chkDueToday7[]=$reopenAssigned;   
                                    }

                                    if($tdays < $value['verification_tat'] && $tdays > ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueNextFivedays7[]=$reopenAssigned;   
                                    }

                                    if($tdays <= ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueSixPlusdays7[]=$reopenAssigned;   
                                    }
                                     
                                 $reopenAssigned++;
                                }

                                $html.="<td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: red;'>";
                                    
                                        $check_overdue7=count($chkOverdue7);
                                        $html.= $check_overdue7 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('ReopenAssignedOverdue').'/'.base64_encode($userid),"<span style='color:black'>".$check_overdue7."</span>",'target=""');
                                $html.="</td>

                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: #f89406;'>";

                                        $check_duetoday7=count($chkDueToday7);
                                        $html.= $check_duetoday7==0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('ReopenAssignedDueTday').'/'.base64_encode($userid),"<span style='color:black'>".$check_duetoday7."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                        $check_dueNextFivDays7=count($chkDueNextFivedays7);
                                        $html.= $check_dueNextFivDays7 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('ReopenAssignedDueNext5day').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueNextFivDays7."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                     
                                    $check_dueSixPlusDays7= count($chkDueSixPlusdays7);
                                    $html.= $check_dueSixPlusDays7 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('ReopenAssignedDueNext6dayPlus').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueSixPlusDays7."</span>",'target=""');
                                $html.="</td>
                            </tr>";
                            $totalChecks=$totalNewchecks+$totalInitiated+$totalRevertAssigned+$totalRevertRaised+$totalRevertClosed+$totalRequestRaised+$totalDDapplied+$totalReopenAssigned;

                            $totalOverDue=$check_overdue+$check_overdue1+$check_overdue2+$check_overdue3+$check_overdue4+$check_overdue5+$check_overdue6+$check_overdue7;

                            $totalDueToday=$check_duetoday+$check_duetoday1+$check_duetoday2+$check_duetoday3+$check_duetoday4+$check_duetoday5+$check_duetoday6+$check_duetoday7;

                            $totalDueInNext5Days=$check_dueNextFivDays+$check_dueNextFivDays1+$check_dueNextFivDays2+$check_dueNextFivDays3+$check_dueNextFivDays4+$check_dueNextFivDays5+$check_dueNextFivDays6+$check_dueNextFivDays7;

                            $totalDueIn6DaysPlus=$check_dueSixPlusDays+$check_dueSixPlusDays1+$check_dueSixPlusDays2+$check_dueSixPlusDays3+$check_dueSixPlusDays4+$check_dueSixPlusDays5+$check_dueSixPlusDays6+$check_dueSixPlusDays7;

                            $html.="<tr class='at_tr' height='35'>
                                <td  class='at_td' style='color:black;width:300px;background-color: #d7d8d5'><strong style='margin-left: 10px;''>Total </strong></td>
                                <td  class='at_td' style='width:100px;font-weight:bold;text-align:right;padding-right: 10px;background-color: #d7d8d5;color:black;'>";
                                     
                                    $html.= $totalChecks==0 ? '' : $totalChecks;
                                    // echo $totalChecks==0 ? '' : anchor('/Verification/status_checklist/'.base64_encode('AllChecks'),"<span style='color:black'>".$totalChecks."</span>",'target=""'); 
                                    
                                $html.="</td>
                                <td  class='at_td' style='width:100px;font-weight:bold;text-align:right;padding-right: 10px;background-color: red;color:black;'>";
                                    
                                    $html.= $totalOverDue==0 ? '' : $totalOverDue; 
                                    
                                $html.="</td>
                                <td  class='at_td' style='width:100px;font-weight:bold;text-align:right;padding-right: 10px;background-color: #f89406;color:black;'>";
                                    
                                    $html.= $totalDueToday==0 ? '' : $totalDueToday;
                                    
                                $html.="</td>
                                <td  class='at_td' style='width:100px;font-weight:bold;text-align:right;padding-right: 10px;background-color: #d7d8d5;color:black;'>";
                                    
                                    $html.= $totalDueInNext5Days==0 ? '' : $totalDueInNext5Days;
                                    
                                $html.="</td>
                                <td  class='at_td' style='width:100px;font-weight:bold;text-align:right;padding-right: 10px;background-color: #d7d8d5;color:black;'>";
                                     
                                    $html.= $totalDueIn6DaysPlus==0 ? '' : $totalDueIn6DaysPlus;
                                    
                                $html.="</td>
                            </tr>";

                        $html.='</tbody>
                    </table>    
                </div>
            </div>';


            echo $html;





    }


    /*******************************************/

    function get_v_memberdata(){
        
        $userid=$_POST['user_id'];
        $role=$this->dmodel->getroles($userid);
        $role_id=$role[0]['role_id'];
// exit;
        $newcheck = $this->dmodel->get_vmcheck_bystatus('new',$role_id,$userid);
        $initiatedcheck = $this->dmodel->get_vmcheck_bystatus('initiated',$role_id,$userid);
        $RevertAssigned = $this->dmodel->get_vmcheck_bystatus('revertassigned',$role_id,$userid);
        $RevertRaised = $this->dmodel->get_vmcheck_bystatus('revertraised',$role_id,$userid);
        $RevertClosed = $this->dmodel->get_vmcheck_bystatus('revertclosed',$role_id,$userid);
        $RequestRaised = $this->dmodel->get_vmcheck_bystatus('requestraised',$role_id,$userid);
        $DDapplied = $this->dmodel->get_vmcheck_bystatus('DDapplied',$role_id,$userid);
        $ReopenAssigned = $this->dmodel->get_vmcheck_bystatus('reopenassigned',$role_id,$userid);

        
        $totalNewchecks=count($newcheck);
        $totalInitiated=count($initiatedcheck);
        $totalRevertAssigned=count($RevertAssigned);
        $totalRevertRaised=count($RevertRaised);
        $totalRevertClosed=count($RevertClosed);
        $totalRequestRaised=count($RequestRaised);
        $totalDDapplied=count($DDapplied);
        $totalReopenAssigned=count($ReopenAssigned);


    $html='<div class="right-mem-bx" style="margin-left:0px;border:none;padding-bottom:0px;">
                <div class="mem-bg">
                    <h2 align="center">Dashboard</h2>
                </div>
                <div class="tableFixHead s-fombx">
                    <table border align="center">
                        <thead>
                         <tr class="at_tr" height="35" >
                            <th class="at_th" style="width:300px;""><h2 style="color:black;">Check Status</h2></th>               
                            <th class="at_th" style="width:100px;"><h2 style="color:black;">No of Checks</h2></th>
                            <th class="at_th" style="width:100px;"><h2 style="color:black;">Checks Overdue</h2></th>
                            <th class="at_th" style="width:100px;"><h2 style="color:black;">Checks Due Today</h2></th>
                            <th class="at_th" style="width:100px;"><h2 style="color:black;">Checks Due in Next 5 Days</h2></th>
                            <th class="at_th" style="width:100px;"><h2 style="color:black;">Checks Due in Next 6+ Days</h2></th>
                        </tr>
                        </thead>
                        <tbody>';
                    $html.="<tr class='' height='25'>
                                <td  class='at_td' style='color:#022151;width:300px;height: 25px;'><label style='margin-left: 10px;'>New</label></td>
                                <td  class='at_td' style='width:100px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>";
                                $html.=$totalNewchecks == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('New').'/'.base64_encode($userid),"<span style='color:black'>".$totalNewchecks."</span>",'target=""');           
                        $html.="</td>";

                            $chkOverdue=array(); 
                                $new=1; 
                                $chkDueToday=array();
                                $chkDueNextFivedays=array();
                                $chkDueSixPlusdays=array();

                                foreach ($newcheck as $value) 
                                {
                                    $tdays=$value['Days'];
                                    if($tdays > $value['verification_tat'])
                                    { 
                                       $chkOverdue[]=$new;   
                                    } 

                                    if($tdays == $value['verification_tat'])
                                    { 
                                       $chkDueToday[]=$new;   
                                    }

                                    if($tdays < $value['verification_tat'] && $tdays > ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueNextFivedays[]=$new;   
                                    }

                                    if($tdays <= ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueSixPlusdays[]=$new;   
                                    }
                                     
                                 $new++;
                                }

                            $html.="<td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px; background-color: red;'>";
                                    
                                    $check_overdue=count($chkOverdue);
                                    $html.= $check_overdue == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('NewOverdue').'/'.base64_encode($userid),"<span style='color:black'>".$check_overdue."</span>",'target=""');
                            $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: #f89406;'>";
                                    
                                    $check_duetoday=count($chkDueToday);
                                    $html.= $check_duetoday == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('NewDueTday').'/'.base64_encode($userid),"<span style='color:black'>".$check_duetoday."</span>",'target=""');    
                            $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                    $check_dueNextFivDays=count($chkDueNextFivedays);
                                    $html.= $check_dueNextFivDays == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('NewDueNext5day').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueNextFivDays."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                     
                                    $check_dueSixPlusDays= count($chkDueSixPlusdays);
                                    $html.=$check_dueSixPlusDays == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('NewDueNext6dayPlus').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueSixPlusDays."</span>",'target=""');
                                    
                            $html.="</td>
                            </tr>
                            <tr class='' height='25' >
                                <td  class='at_td' style='color:#022151;width:300px;height: 25px;'><label style='margin-left: 10px;'>Initiated</label></td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                
                                $html.= $totalInitiated == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('Initiated').'/'.base64_encode($userid),"<span style='color:black'>".$totalInitiated."</span>",'target=""'); 

                                /*************** Initiated ***************/
                                $chkOverdue1=array(); 
                                $initiated=1; 
                                $chkDueToday1=array();
                                $chkDueNextFivedays1=array();
                                $chkDueSixPlusdays1=array();
                                foreach ($initiatedcheck as $value) 
                                {
                                    $tdays=$value['Days'];
                                    
                                    if($tdays > $value['verification_tat'])
                                    { 
                                       $chkOverdue1[]=$initiated;   
                                    } 

                                    if($tdays == $value['verification_tat'])
                                    { 
                                       $chkDueToday1[]=$initiated;   
                                    }

                                    if($tdays < $value['verification_tat'] && $tdays > ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueNextFivedays1[]=$initiated;   
                                    }

                                    if($tdays <= ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueSixPlusdays1[]=$initiated;   
                                    }
                                     
                                 $initiated++;
                                }
                                            
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: red;'>";
                                    
                                    $check_overdue1=count($chkOverdue1);
                                    $html.= $check_overdue1 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('InitiatedOverdue').'/'.base64_encode($userid),"<span style='color:black'>".$check_overdue1."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: #f89406;'>";
                                    
                                    $check_duetoday1=count($chkDueToday1);
                                    $html.= $check_duetoday1==0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('InitiatedDueTday').'/'.base64_encode($userid),"<span style='color:black'>".$check_duetoday1."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                    $check_dueNextFivDays1=count($chkDueNextFivedays1);
                                    $html.=$check_dueNextFivDays1 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('InitiateDueNext5day').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueNextFivDays1."</span>",'target=""');
                                    
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                     
                                    $check_dueSixPlusDays1= count($chkDueSixPlusdays1);
                                    $html.= $check_dueSixPlusDays1 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('InitiateDueNext6dayPlus').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueSixPlusDays1."</span>",'target=""');
                                    
                                $html.="</td>
                                </tr>
                                <tr class='' height='25' >
                                <td  class='at_td' style='color:#022151;width:300px;height: 25px;'><label style='margin-left: 10px;'>Revert Assigned</label></td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                     
                                $html.= $totalRevertAssigned == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertAssigned').'/'.base64_encode($userid),"<span style='color:black'>".$totalRevertAssigned."</span>",'target=""');
                                $html.="</td>";

                                /*************** Revert Assigned ***************/
                                $chkOverdue2=array(); 
                                $revertAssigned=1; 
                                $chkDueToday2=array();
                                $chkDueNextFivedays2=array();
                                $chkDueSixPlusdays2=array();
                                foreach ($RevertAssigned as $value) 
                                {
                                    $tdays=$value['Days'];
                                    
                                    if($tdays > $value['verification_tat'])
                                    { 
                                       $chkOverdue2[]=$revertAssigned;   
                                    } 

                                    if($tdays == $value['verification_tat'])
                                    { 
                                       $chkDueToday2[]=$revertAssigned;   
                                    }

                                    if($tdays < $value['verification_tat'] && $tdays > ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueNextFivedays2[]=$revertAssigned;   
                                    }

                                    if($tdays <= ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueSixPlusdays2[]=$revertAssigned;   
                                    }
                                     
                                 $revertAssigned++;
                                }

                                $html.="<td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: red;'>";
                                    
                                    $check_overdue2=count($chkOverdue2);
                                    $html.= $check_overdue2 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertAssignedOverdue').'/'.base64_encode($userid),"<span style='color:black'>".$check_overdue2."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: #f89406;'>";
                                    
                                    $check_duetoday2=count($chkDueToday2);
                                    $html.= $check_duetoday2==0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertAssignedDueTday').'/'.base64_encode($userid),"<span style='color:black'>".$check_duetoday2."</span>",'target=""');
                                
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                    $check_dueNextFivDays2=count($chkDueNextFivedays2);
                                    $html.= $check_dueNextFivDays2 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertAssignedDueNext5day').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueNextFivDays2."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                    $check_dueSixPlusDays2= count($chkDueSixPlusdays2);
                                    $html.= $check_dueSixPlusDays2 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertAssignedDueNext6dayPlus').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueSixPlusDays2."</span>",'target=""');
                                $html.="</td>
                            </tr>
                            <tr class='' height='25' >
                                <td  class='at_td' style='color:#022151;width:300px;height: 25px;'><label style='margin-left: 10px;'>Revert Raised</label></td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                      
                                $html.= $totalRevertRaised == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertRaised').'/'.base64_encode($userid),"<span style='color:black'>".$totalRevertRaised."</span>",'target=""');
                                    
                                $html.="</td>";
                                /*************** Revert Raised ***************/
                                $chkOverdue3=array(); 
                                $revertRaised=1; 
                                $chkDueToday3=array();
                                $chkDueNextFivedays3=array();
                                $chkDueSixPlusdays3=array();
                                foreach ($RevertRaised as $value) 
                                {
                                    $tdays=$value['Days'];
                                    
                                    if($tdays > $value['verification_tat'])
                                    { 
                                       $chkOverdue3[]=$revertRaised;   
                                    } 

                                    if($tdays == $value['verification_tat'])
                                    { 
                                       $chkDueToday3[]=$revertRaised;   
                                    }

                                    if($tdays < $value['verification_tat'] && $tdays > ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueNextFivedays3[]=$revertRaised;   
                                    }

                                    if($tdays <= ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueSixPlusdays3[]=$revertRaised;   
                                    }
                                     
                                 $revertRaised++;
                                }

                                $html.="<td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: red;'>";
                                    
                                    $check_overdue3=count($chkOverdue3);
                                    $html.= $check_overdue3 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertRaisedOverdue').'/'.base64_encode($userid),"<span style='color:black'>".$check_overdue3."</span>",'target=""');    
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: #f89406;'>";
                                    
                                    $check_duetoday3=count($chkDueToday3);
                                    $html.= $check_duetoday3==0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertRaisedDueTday').'/'.base64_encode($userid),"<span style='color:black'>".$check_duetoday3."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                    $check_dueNextFivDays3=count($chkDueNextFivedays3);
                                    $html.= $check_dueNextFivDays3 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertRaisedDueNext5day').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueNextFivDays3."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                    
                                    $check_dueSixPlusDays3= count($chkDueSixPlusdays3);
                                    $html.= $check_dueSixPlusDays3 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertRaisedDueNext6dayPlus').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueSixPlusDays3."</span>",'target=""');
                                $html.="</td>
                            </tr>
                            <tr class='' height='25' >
                                <td  class='at_td' style='color:#022151;width:300px;height: 25px;'><label style='margin-left: 10px;'>Revert Closed</label></td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                     
                                    $html.= $totalRevertClosed == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertClosed').'/'.base64_encode($userid),"<span style='color:black'>".$totalRevertClosed."</span>",'target=""');
                                $html.="</td> ";
                                /*************** Revert Closed ***************/
                                $chkOverdue4=array(); 
                                $revertClosed=1; 
                                $chkDueToday4=array();
                                $chkDueNextFivedays4=array();
                                $chkDueSixPlusdays4=array();
                                foreach ($RevertClosed as $value) 
                                {
                                    $tdays=$value['Days'];
                                    
                                    if($tdays > $value['verification_tat'])
                                    { 
                                       $chkOverdue4[]=$revertClosed;   
                                    } 

                                    if($tdays == $value['verification_tat'])
                                    { 
                                       $chkDueToday4[]=$revertClosed;   
                                    }

                                    if($tdays < $value['verification_tat'] && $tdays > ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueNextFivedays4[]=$revertClosed;   
                                    }

                                    if($tdays <= ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueSixPlusdays4[]=$revertClosed;   
                                    }
                                     
                                 $revertClosed++;
                                }

                                $html.="<td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: red;'>";
                                    
                                    $check_overdue4=count($chkOverdue4);
                                    $html.= $check_overdue4 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertClosedOverdue').'/'.base64_encode($userid),"<span style='color:black'>".$check_overdue4."</span>",'target=""');
                                $html.="</td>

                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: #f89406;'>";
                                    
                                    $check_duetoday4=count($chkDueToday4);
                                    $html.= $check_duetoday4==0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertClosedDueTday').'/'.base64_encode($userid),"<span style='color:black'>".$check_duetoday4."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                    $check_dueNextFivDays4=count($chkDueNextFivedays4);
                                    $html.= $check_dueNextFivDays4 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertClosedDueNext5day').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueNextFivDays4."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                   
                                    $check_dueSixPlusDays4= count($chkDueSixPlusdays4);
                                    $html.= $check_dueSixPlusDays4 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RevertClosedDueNext6dayPlus').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueSixPlusDays4."</span>",'target=""');
                                $html.="</td>
                            </tr>
                            <tr class='' height='25' >
                                <td  class='at_td' style='color:#022151;width:300px;height: 25px;'><label style='margin-left: 10px;'>Request Raised</label></td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                     
                                    $html.= $totalRequestRaised == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RequestRaised').'/'.base64_encode($userid),"<span style='color:black'>".$totalRequestRaised."</span>",'target=""');
                                $html.="</td> ";
                                /*************** Request Raised ***************/
                                $chkOverdue5=array(); 
                                $requestRaised=1; 
                                $chkDueToday5=array();
                                $chkDueNextFivedays5=array();
                                $chkDueSixPlusdays5=array();
                                foreach ($RequestRaised as $value) 
                                {
                                    $tdays=$value['Days'];
                                                                        
                                    if($tdays > $value['verification_tat'])
                                    { 
                                       $chkOverdue5[]=$requestRaised;   
                                    } 

                                    if($tdays == $value['verification_tat'])
                                    { 
                                       $chkDueToday5[]=$requestRaised;   
                                    }

                                    if($tdays < $value['verification_tat'] && $tdays > ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueNextFivedays5[]=$requestRaised;   
                                    }

                                    if($tdays <= ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueSixPlusdays5[]=$requestRaised;   
                                    }
                                     
                                 $requestRaised++;
                                }

                                $html.="<td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: red;'>";
                                    
                                        $check_overdue5=count($chkOverdue5);
                                        $html.= $check_overdue5 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RequestRaisedOverdue').'/'.base64_encode($userid),"<span style='color:black'>".$check_overdue5."</span>",'target=""');
                                $html.="</td>

                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: #f89406;'>";
                                    
                                        $check_duetoday5=count($chkDueToday5);
                                        $html.= $check_duetoday5==0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RequestRaisedDueTday').'/'.base64_encode($userid),"<span style='color:black'>".$check_duetoday5."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                        $check_dueNextFivDays5=count($chkDueNextFivedays5);
                                        $html.= $check_dueNextFivDays5 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RequestRaisedDueNext5day').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueNextFivDays5."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                   
                                    $check_dueSixPlusDays5= count($chkDueSixPlusdays5);
                                    $html.= $check_dueSixPlusDays5 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('RequestRaisedDueNext6dayPlus').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueSixPlusDays5."</span>",'target=""');
                                $html.="</td>
                            </tr>
                            <tr class='' height='25' >
                                <td  class='at_td' style='color:#022151;width:300px;height: 25px;'><label style='margin-left: 10px;'>DD applied</label></td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                     
                                    $html.= $totalDDapplied == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('DDApplied').'/'.base64_encode($userid),"<span style='color:black'>".$totalDDapplied."</span>",'target=""'); 
                                $html.="</td>";
                                /*************** DD Applied ***************/
                                $chkOverdue6=array(); 
                                $ddApplied=1; 
                                $chkDueToday6=array();
                                $chkDueNextFivedays6=array();
                                $chkDueSixPlusdays6=array();
                                foreach ($DDapplied as $value) 
                                {
                                    $tdays=$value['Days'];
                                    
                                    if($tdays > $value['verification_tat'])
                                    { 
                                       $chkOverdue6[]=$ddApplied;   
                                    } 

                                    if($tdays == $value['verification_tat'])
                                    { 
                                       $chkDueToday6[]=$ddApplied;   
                                    }

                                    if($tdays < $value['verification_tat'] && $tdays > ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueNextFivedays6[]=$ddApplied;   
                                    }

                                    if($tdays <= ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueSixPlusdays6[]=$ddApplied;   
                                    }
                                     
                                 $ddApplied++;
                                }

                                $html.="
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: red;'>";
                                    
                                        $check_overdue6=count($chkOverdue6);
                                        $html.= $check_overdue6 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('DDAppliedOverdue').'/'.base64_encode($userid),"<span style='color:black'>".$check_overdue6."</span>",'target=""');
                                $html.="</td>

                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: #f89406;'>";
                                    
                                        $check_duetoday6=count($chkDueToday6);
                                        $html.= $check_duetoday6==0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('DDAppliedDueTday').'/'.base64_encode($userid),"<span style='color:black'>".$check_duetoday6."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                        $check_dueNextFivDays6=count($chkDueNextFivedays6);
                                        $html.= $check_dueNextFivDays6 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('DDAppliedDueNext5day').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueNextFivDays6."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                     
                                    $check_dueSixPlusDays6= count($chkDueSixPlusdays6);
                                    $html.= $check_dueSixPlusDays6 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('DDAppliedDueNext6dayPlus').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueSixPlusDays6."</span>",'target=""');
                                $html.="</td>
                            </tr>
                            <tr class='' height='25' >
                                <td  class='at_td' style='color:#022151;width:300px;height: 25px;'><label style='margin-left: 10px;'>Reopen Assigned</label></td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                      
                                    $html.= $totalReopenAssigned == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('ReopenAssigned').'/'.base64_encode($userid),"<span style='color:black'>".$totalReopenAssigned."</span>",'target=""');
                                $html.="</td>";
                                /*************** Revert Assigned ***************/
                                $chkOverdue7=array(); 
                                $reopenAssigned=1; 
                                $chkDueToday7=array();
                                $chkDueNextFivedays7=array();
                                $chkDueSixPlusdays7=array();
                                foreach ($ReopenAssigned as $value) 
                                {
                                    $tdays=$value['Days'];
                                    
                                    if($tdays > $value['verification_tat'])
                                    { 
                                       $chkOverdue7[]=$reopenAssigned;   
                                    } 

                                    if($tdays == $value['verification_tat'])
                                    { 
                                       $chkDueToday7[]=$reopenAssigned;   
                                    }

                                    if($tdays < $value['verification_tat'] && $tdays > ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueNextFivedays7[]=$reopenAssigned;   
                                    }

                                    if($tdays <= ($value['verification_tat'] - 5))
                                    { 
                                       $chkDueSixPlusdays7[]=$reopenAssigned;   
                                    }
                                     
                                 $reopenAssigned++;
                                }

                                $html.="<td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: red;'>";
                                    
                                        $check_overdue7=count($chkOverdue7);
                                        $html.= $check_overdue7 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('ReopenAssignedOverdue').'/'.base64_encode($userid),"<span style='color:black'>".$check_overdue7."</span>",'target=""');
                                $html.="</td>

                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;background-color: #f89406;'>";

                                        $check_duetoday7=count($chkDueToday7);
                                        $html.= $check_duetoday7==0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('ReopenAssignedDueTday').'/'.base64_encode($userid),"<span style='color:black'>".$check_duetoday7."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                    
                                        $check_dueNextFivDays7=count($chkDueNextFivedays7);
                                        $html.= $check_dueNextFivDays7 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('ReopenAssignedDueNext5day').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueNextFivDays7."</span>",'target=""');
                                $html.="</td>
                                <td  class='at_td' style='width:100px;height: 25px;font-size:14px;text-align:right;padding-right: 10px;'>";
                                     
                                    $check_dueSixPlusDays7= count($chkDueSixPlusdays7);
                                    $html.= $check_dueSixPlusDays7 == 0 ? '' : anchor('/Verification/vm_newcaselist/'.base64_encode('ReopenAssignedDueNext6dayPlus').'/'.base64_encode($userid),"<span style='color:black'>".$check_dueSixPlusDays7."</span>",'target=""');
                                $html.="</td>
                            </tr>";
                            $totalChecks=$totalNewchecks+$totalInitiated+$totalRevertAssigned+$totalRevertRaised+$totalRevertClosed+$totalRequestRaised+$totalDDapplied+$totalReopenAssigned;

                            $totalOverDue=$check_overdue+$check_overdue1+$check_overdue2+$check_overdue3+$check_overdue4+$check_overdue5+$check_overdue6+$check_overdue7;

                            $totalDueToday=$check_duetoday+$check_duetoday1+$check_duetoday2+$check_duetoday3+$check_duetoday4+$check_duetoday5+$check_duetoday6+$check_duetoday7;

                            $totalDueInNext5Days=$check_dueNextFivDays+$check_dueNextFivDays1+$check_dueNextFivDays2+$check_dueNextFivDays3+$check_dueNextFivDays4+$check_dueNextFivDays5+$check_dueNextFivDays6+$check_dueNextFivDays7;

                            $totalDueIn6DaysPlus=$check_dueSixPlusDays+$check_dueSixPlusDays1+$check_dueSixPlusDays2+$check_dueSixPlusDays3+$check_dueSixPlusDays4+$check_dueSixPlusDays5+$check_dueSixPlusDays6+$check_dueSixPlusDays7;

                            $html.="<tr class='at_tr' height='35'>
                                <td  class='at_td' style='color:black;width:300px;background-color: #d7d8d5'><strong style='margin-left: 10px;''>Total </strong></td>
                                <td  class='at_td' style='width:100px;font-weight:bold;text-align:right;padding-right: 10px;background-color: #d7d8d5;color:black;'>";
                                     
                                    $html.= $totalChecks==0 ? '' : $totalChecks;
                                    // echo $totalChecks==0 ? '' : anchor('/Verification/status_checklist/'.base64_encode('AllChecks'),"<span style='color:black'>".$totalChecks."</span>",'target=""'); 
                                    
                                $html.="</td>
                                <td  class='at_td' style='width:100px;font-weight:bold;text-align:right;padding-right: 10px;background-color: red;color:black;'>";
                                    
                                    $html.= $totalOverDue==0 ? '' : $totalOverDue; 
                                    
                                $html.="</td>
                                <td  class='at_td' style='width:100px;font-weight:bold;text-align:right;padding-right: 10px;background-color: #f89406;color:black;'>";
                                    
                                    $html.= $totalDueToday==0 ? '' : $totalDueToday;
                                    
                                $html.="</td>
                                <td  class='at_td' style='width:100px;font-weight:bold;text-align:right;padding-right: 10px;background-color: #d7d8d5;color:black;'>";
                                    
                                    $html.= $totalDueInNext5Days==0 ? '' : $totalDueInNext5Days;
                                    
                                $html.="</td>
                                <td  class='at_td' style='width:100px;font-weight:bold;text-align:right;padding-right: 10px;background-color: #d7d8d5;color:black;'>";
                                     
                                    $html.= $totalDueIn6DaysPlus==0 ? '' : $totalDueIn6DaysPlus;
                                    
                                $html.="</td>
                            </tr>";

                        $html.='</tbody>
                    </table>    
                </div>
            </div>';


            echo $html;





    }


    /************* Get Working Day Excludig weekend ***********
    ************** Created By Chandan Kp **********************
    ************** Function getWorkingDays ********************/

    function getWorkingDays($startDate,$endDate,$holidays)
    {
        // do strtotime calculations just once
        $endDate = strtotime($endDate);
        $startDate = strtotime($startDate);

        //The total number of days between the two dates. We compute the no. of seconds and divide it to 60*60*24
        //We add one to inlude both dates in the interval.
        $days = ($endDate - $startDate) / 86400 + 1;

        $no_full_weeks = floor($days / 7);
        $no_remaining_days = fmod($days, 7);

        //It will return 1 if it's Monday,.. ,7 for Sunday
        $the_first_day_of_week = date("N", $startDate);
        $the_last_day_of_week = date("N", $endDate);

        //---->The two can be equal in leap years when february has 29 days, the equal sign is added here
        //In the first case the whole interval is within a week, in the second case the interval falls in two weeks.
        if ($the_first_day_of_week <= $the_last_day_of_week) {
        if ($the_first_day_of_week <= 6 && 6 <= $the_last_day_of_week) $no_remaining_days--;
        if ($the_first_day_of_week <= 7 && 7 <= $the_last_day_of_week)
        $no_remaining_days--;
        }else {
        // (edit by Tokes to fix an edge case where the start day was a Sunday
        // and the end day was NOT a Saturday)         
        // the day of the week for start is later than the day of the week for end         
        if ($the_first_day_of_week == 7) {             
        // if the start date is a Sunday, then we definitely subtract 1 day
        $no_remaining_days--;
        if ($the_last_day_of_week == 6) {
        // if the end date is a Saturday, then we subtract another day
        $no_remaining_days--;
        }
        }
        else {
        // the start date was a Saturday (or earlier), and the end date was (Mon..Fri)
        // so we skip an entire weekend and subtract 2 days
        $no_remaining_days -= 2;
        }
        }
        //The no. of business days is: (number of weeks between the two dates) * (5 working days) + the remainder //---->february in none leap years gave a remainder of 0 but still calculated weekends between first and last day, this is one way to fix it
        $workingDays = $no_full_weeks * 5;
        if ($no_remaining_days > 0 )
        {
        $workingDays += $no_remaining_days;
        }
            
        //We subtract the holidays
        foreach($holidays as $holiday){
        $time_stamp = strtotime($holiday);
        //If the holiday doesn't fall in weekend
        if ($startDate <= $time_stamp && $time_stamp <= $endDate && date("N",$time_stamp) != 6 && date("N",$time_stamp) != 7)
        $workingDays--;
        }

        return $workingDays;
    }


   
  
}

