<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('Common.php');
class Complaints extends Common {
        function __construct() 
        {
                parent::__construct();
                $this->_check_userlogin ();
                $this->load->model('Complaints_model');
                $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
                $this->amodel->loadjsscript(array( 'jquery.validate','jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min','jquery-ui-1.8.16.custom.min'));
        }
     /*************************************
    * index function
    * index
    *************************************/
        function index() 
        {
                $this->_check_featureauth ( 'complaints', 'view' );
                // add breadcrumbs
                $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
                $this->breadcrumbs->push('Complaints List', 'Complaints/index');
              
                // unshift crumb
                // output
                $data['breadcrumb']=$this->breadcrumbs->show();
                $this->amodel->pagerender($data, 'complaints_list');
                
                $this->db->set('read_status',1);
                $this->db->where('user_to',$this->session->userdata['userid']);
                $this->db->update(DB_PREFIX.'complaints');
        }
     /*************************************
    * get_complaints function
    * get_complaints
    *************************************/    
        function get_complaints($office_id=0 ) { 
            $model = array('Complaints_model'=>'get_complaints'); 
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $role_id=$this->session->userdata('role_id');
        $user_from = ($_REQUEST['user_from']) ? $_REQUEST['user_from'] : ''; 
        $user_to = ($_REQUEST['user_to']) ? $_REQUEST['user_to'] : ''; 
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $complaint=($_REQUEST['complaint']) ? $_REQUEST['complaint'] : '';
        $a_date=($_REQUEST['a_date']) ? $_REQUEST['a_date'] : '';
        $t_date=($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        if($user_from){
            $condition[]=" user_to =".$this->session->userdata['userid'];
        }
        if($user_to){
            $condition[]=" user_from =".$this->session->userdata['userid'];
        }
        if($name){
            $condition[]=" (u.first_name like '%".$name."%' OR subject like '%".$name."%' )";
        }
        if($complaint){
            $condition[]=" (u.first_name like '%".$complaint."%' AND u.last_name like '%".$complaint."%' )";
        }
        if($a_date){
            $condition[]="DATE_FORMAT(c.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($a_date))."'";
        }
        if($t_date){
            $condition[]="DATE_FORMAT(a.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        if($a_status){
            $condition[]=" type =".$a_status;
        }
        if($term)
        {
                //support multiple words
                $search = explode(' ', $term);

                foreach($search as $t) {
                    $not        = '';
                    $operator    = 'OR';
                    if(substr($t,0,1) == '-')
                    {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t,1,strlen($t));
                    }

                    $like    = '';
                    $like    .= "( u.first_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." u.last_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." c.subject ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." c.message ".$not."LIKE '%".$t."%' ) " ;
            $condition[]=$like;
               
            }
        }
            $manual_cond=implode(' and ',$condition);
            $results = $this->_jqgrid_search($model,$manual_cond);
            $response = $results[0];  
            $result = $results[1]; 
              if ($result) {
              $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
                foreach ( $result as $i => $row ) {
                if($row['created_on']) {
                    $row['created_on']=date('d-m-Y',strtotime($row['created_on']));
                }
                
                if($row['type']==1){
                    $type='Complaint';
                }
                else if($row['type']==2){
                    $type='Feedback';
                }
                else if($row['type']==3){
                    $type='Task';
                }
             if($user_from)
             {
             $from=base64_encode('from');
             $update='update';
             }
             if($user_to)
             {
             $from=base64_encode('to');
             $update='create';
             }
                                         
            $response->rows [$i] ['cell'] = array ( $i+$count+1,
            anchor('/Complaints/'.$update.'/'.base64_encode($row['id']).'/'.$from, $row['subject']),$row['first_name'].' '.$row['last_name'],$row['created_on'],$type);
                
                }
            }
            echo json_encode($response);

        }
     /*************************************
    * create function
    * create
    *************************************/    
        function create($id =null,$from=false)
        {
                $this->_check_featureauth ( 'complaints', 'add' ); // Check if user is allowed for action
                $id = base64_decode($this->uri->segment(3));
                $from = base64_decode($this->uri->segment(4));
                //commonview layout 
                $data['id']=$id;
                $cond='';
                if($from=='from')
                $cond=" AND user_to=".$this->session->userdata('userid');
                if($from=='to')
                $cond=" AND user_from=".$this->session->userdata('userid');
                
                if($cond){
               $data['complaint_details'] = $complaint_details =  $this->db->query("select * from ". DB_PREFIX ."complaints where id=".$id." ".$cond)->row_array(); 
                        //for displaying name on title
                foreach($complaint_details as $key=>$value)
                {
                        if(validateDate($value, 'Y-m-d'))
                        $data[$key.'_edit']=date('d-m-Y',strtotime($value));
                        else if($value=='0000-00-00')
                        $data[$key.'_edit']='';
                        else
                        $data[$key.'_edit']=$value;
                }
               }
                $data['dcodeemails']=$this->Complaints_model->get_emails();
                 // add breadcrumbs
                $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
                $this->breadcrumbs->push('Complaints List', 'Complaints/index');
                $this->breadcrumbs->push('Add Complaints Details', 'Complaints/create');
                // unshift crumb

                // output
                $data['breadcrumb']=$this->breadcrumbs->show();
                $this->amodel->pagerender($data);
        }
     /*************************************
    * update function
    * update
    *************************************/    
        function update($id =null,$from=false)
        {
                $this->_check_featureauth ( 'complaints', 'edit' ); // Check if user is allowed for action
                $id = base64_decode($this->uri->segment(3));
                $from = base64_decode($this->uri->segment(4));
                //commonview layout 
                $data['id']=$id;
                $cond='';
                if($from=='from'){
                    $cond=" AND user_to=".$this->session->userdata('userid');
                }
                if($from=='to'){
                    $cond=" AND user_from=".$this->session->userdata('userid');
                }
                if($cond){
               $data['complaint_details'] = $complaint_details =  $this->db->query("select * from ". DB_PREFIX ."complaints where id=".$id." ".$cond)->row_array(); 
                        //for displaying name on title
                        foreach($complaint_details as $key=>$value)
                        {
                                if(validateDate($value, 'Y-m-d'))
                                $data[$key.'_edit']=date('d-m-Y',strtotime($value));
                                else if($value=='0000-00-00')
                                $data[$key.'_edit']='';
                                else
                                $data[$key.'_edit']=$value;
                        }
                        }
                        
                        
                $data['dcodeemails']=$this->Complaints_model->get_emails();

                $this->amodel->pagerender($data);
        }
    /*************************************
    * save_complaints function
    * save_complaints
    *************************************/     
        function save_complaints()
        {
                $emails= $this->Complaints_model->get_emails(1,$_POST['user_to']);
                $save['id']=$_POST['id'];
                $save['type']=$_POST['type'];
                $save['user_from']=$this->session->userdata('userid');
                $save['user_to']=$_POST['user_to'];
                $save['subject']=$_POST['subject'];
                $save['message']=$_POST['message'];
                 $email['email']=$emails['email'];
                 $email['first_name']=$emails['first_name'];
                 $email['last_name']=$emails['last_name'];
                 $save = $this->security->xss_clean($save);
                 $this->Complaints_model->save($save,$email);
                 redirect('Complaints/listcomplaints');
                
        }
     /*************************************
    * update_complaints function
    * update_complaints
    *************************************/    
        function update_complaints()
        {
                $save['id']=$_POST['id'];
                $save['comments']=$_POST['comments'];
                 $this->Complaints_model->save($save,$email);
                 redirect('Complaints/index');
                
        }
     /*************************************
    * listcomplaints function
    * listcomplaints
    *************************************/    
         function listcomplaints()  
        {
        $this->_check_featureauth ( 'complaints', 'view' );
                 // add breadcrumbs
                $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
                $this->breadcrumbs->push('Complaints List', 'Complaints/listcomplaints');
                // unshift crumb
                // output
                $data['breadcrumb']=$this->breadcrumbs->show();
                $this->amodel->pagerender($data, 'complaints_list');
        }

}