<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('Common.php');
class Cron extends Common {
    function __construct() 
    {
        parent::__construct();
        $this->load->model('Cron_model');
        $this->load->model('Dadmin_model','dm');
        $this->load->model('Verification_model','vm');
        $this->load->helper('Text');
    }
        /****************************** 
        * candidate deactivation function
        * candidate_deactivate
        ****************************************/
       function candidate_deactivate()
        {
            $day=1;
            $currentdate=date('Y-m-d', strtotime("-".$day." days")); 
            $this->db->select(" a.id,concat_ws(' ',a.first_name,a.middle_name,a.last_name) as cand_name,a.status,o.org_name,c.request_id,a.email as cand_email,u.email as cli_email,concat_ws(' ',u.first_name,u.middle_name,u.last_name) as cli_name ");
            $this->db->join(DB_PREFIX.'client_request c', 'c.user_id = a.id', 'left');
            $this->db->join(DB_PREFIX.'organisation o', 'o.id = c.organisation', 'left');
            $this->db->join(DB_PREFIX.'user u', 'u.id = c.created_by', 'left');
            $this->db->where("DATE_FORMAT(a.submit_date,'%Y-%m-%d')=",$currentdate);
            $this->db->where("a.status=",1);
            $this->db->where("c.dataentry_by=",0);
            $users=$this->db->get(DB_PREFIX.'user a')->result();

            $ci=& get_instance();           
            $ci->load->library('email');
            $email_config['protocol'] = 'smtp';
            $email_config['smtp_host'] = 'ssl://smtp.googlemail.com';
            $email_config['smtp_port'] = '465';
            $email_config['smtp_user'] = EMAIL_BGV;
            $email_config['smtp_pass'] = PASS_BGV;
            $email_config['mailtype'] = 'html'; 
            if($users){ 
                foreach ($users as $key => $val) {
                    
                $this->db->select("status");
                $this->db->where("request_id=",$val->request_id);
                $candRes=$this->db->get(DB_PREFIX.'submit_cv')->result();
                if(empty($candRes)){

                // $status=array('status'=> 0); 
                // $this->db->update(DB_PREFIX.'user',$status, array('id' => $val->id));

                $where=array('id'=> $val->id);
                $this->db->set('status',0);
                $this->db->where($where);
                $this->db->update(DB_PREFIX.'user');

                $ci->email->initialize($email_config);
                $ci->email->set_newline("\r\n");
                $ci->email->from($val->cli_email,$val->org_name);
                $ci->email->to($val->cand_email);
                $ci->email->cc($val->cli_email);
                $ci->email->subject(sprintf('Background Verification Login Deactivated @'.$val->org_name.'!'));
                $ci->email->message($this->load->view('Email/candidate_deactivate_mail', $val, TRUE));
                $ci->email->send();
                    }
                } 
            }
        }
        /****************************** 
         * candidate notification email
         * candidate_notify_email
         ******************************/
        function candidate_notify_email(){
                $sql = "SELECT a.id, concat_ws(' ',a.first_name,a.middle_name,a.last_name) as name,p.office_name as parent_office,b.office_name as office_name,s.office_name as sub_office,a.email,o.org_name,c.email as cemail,DATEDIFF(a.submit_date, NOW() ) as datediff,concat_ws(' ',c.first_name,c.last_name) as client_name,a.submit_date as expiry_date
                                FROM " . DB_PREFIX . "user a 
                JOIN " . DB_PREFIX . "client_request r ON a.id=r.user_id
                LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=r.organisation
                LEFT JOIN " . DB_PREFIX . "office p ON p.id=a.parent_office
                LEFT JOIN " . DB_PREFIX . "office b ON b.id=a.office_id
                LEFT JOIN " . DB_PREFIX . "office s ON s.id=a.sub_office
                LEFT JOIN " . DB_PREFIX . "user c ON c.id=r.created_by
                LEFT JOIN " . DB_PREFIX . "submit_cv cv ON r.request_id=cv.request_id
               
                              WHERE r.dataentry_by=0 and a.status=1 and (cv.status is null or cv.status != 1) and DATEDIFF(a.submit_date, NOW() )>=0";
        $candidate = $this->db->query($sql)->result();
                $ci=& get_instance();           
                $ci->load->library('email');
               
                $email_config['protocol'] = 'smtp';
                $email_config['smtp_host'] = 'ssl://smtp.googlemail.com';
                $email_config['smtp_port'] = '465';
                $email_config['smtp_user'] = EMAIL_BGV;
                $email_config['smtp_pass'] = PASS_BGV;
                $email_config['mailtype'] = 'html'; 
                if($candidate){
                    foreach ($candidate as $key => $cand) {
                        $ci->email->initialize($email_config);
                        $ci->email->set_newline("\r\n");
                        $ci->email->from($cand->cemail,$cand->org_name);
                        $ci->email->to($cand->email);
                        $ci->email->subject(sprintf('Reminder mail to complete your credentials @'.$cand->org_name));
                        $ci->email->message($this->load->view('Email/candidate_notify_email', $cand, TRUE));
                        $ci->email->send();
                    }
                    
            }
                
        
        }
     /*****************************
     * send insufficiency function
     * send_insufficiency
     ***********************************/  
function send_insufficiency()
    {
    
        $results=$this->Cron_model->get_insufficiency();
        foreach($results as $result)
        {
          
                $data['candidate_name']=$result['candidate_name'];
                $data['request_id']=$result['request_id'];
                $data['parent_office']=$result['parent_office'];
                $data['org_name']=$result['org_name'];
                $data['office_name']=$result['office_name'];
                $data['sub_office']=$result['sub_office'];
                $data['order_name']=$result['order_name'];
                $data['case_no']=$result['case_no'];
                $data['emp_code']=$result['emp_code'];
                $data['insufficiency_report']=$result['insufficiency_report'];
            $name[]=$data;
            
        }
$this->send_email_insufficiency('insufficiency','Insufficiency Report',$result['email'],$name);
        
 }
/*****************************
     * send send_email_insufficiency function
     * send_email_insufficiency
     ***********************************/ 
function send_email_insufficiency($type,$subject, $email, &$data)
        {
            
                $this->load->library('email');
                $email_config['protocol']    = 'smtp';
                $email_config['smtp_host']    = 'ssl://smtp.gmail.com';
                $email_config['smtp_port']    = '465';
                $email_config['smtp_user']    = EMAIL_BGV;
                $email_config['smtp_pass']    = PASS_BGV;
                $email_config['mailtype'] = 'html';

                $this->email->initialize($email_config);
                $this->email->set_newline("\r\n");
                $this->email->from('info@dcoderesearch.com','Dcode');
                $this->email->to($email);
                $list='bgv@dcoderesearch.com';
                $this->email->subject(sprintf($subject));
                $data['resultab']=$data;
                $this->email->message($this->load->view('Email/insufficiency_mail', $data, TRUE));
                $this->email->send();
        } 
  /****************************** 
   * Dially email to client  for creation of candidates created 
   * client_admin_mails_dially
   *******************************************/      
function client_admin_mails_dially(){
    $valcmail=$this->Cron_model->get_clientemail(1);
    foreach($valcmail as $val){
        if($val['cmail']){
            $results[]=$this->Cron_model->get_clientadmin_dially($val['organisation'],$val['parent_office'],$val['office'],$val['sub_office'],$val['cid']);
        }
    }
    foreach($results as $key => $result)
        { 
             if($result[0]['cmail']){
                $result['num_days']='Day';
                $this->send_email_common('client_admin_mails',"Creation of candidate user id's",$result[0]['cmail'],$result);
            }
        }
          
    }
      /****************************************************
      *  Weekly email to client  for creation of candidates created
      *  client_admin_mails_week
       **************************************************** */ 
     function client_admin_mails_week(){
        $valcmail=$this->Cron_model->get_clientemail(7);
        foreach($valcmail as $val){
            if($val['cmail']){
            $results[]=$this->Cron_model->get_clientadmin_week($val['organisation'],$val['parent_office'],$val['office'],$val['sub_office'],$val['cid']);
            }
        }
    foreach($results as $key => $result)
            { 
              if($result[0]['cmail']){   
               $result['num_days']='Week';
              $this->send_email_common('client_admin_mails',"Creation of candidate user id's",$result[0]['cmail'],$result);
               }
        }
              
     }
  /****************************** 
    *   Weekly email to client  for deactive of candidates created but he not submited to client 
    * client_deactive_mails_week
       ****************************************/ 

     function client_deactive_mails_week(){
        $valcmail=$this->Cron_model->get_clientdeactiveemail(7);
        foreach($valcmail as $val){
            if($val['cmail']){
            $results[]=$this->Cron_model->get_clientdeactive_week($val['organisation'],$val['parent_office'],$val['office'],$val['sub_office'],$val['cid']);
            }
        }
     //  echo "<pre>";print_r($results);exit();
    foreach($results as $key => $result)
            { 
              if($result[0]['cmail']){   
               $result['num_days']='Week';
              $this->send_email_common('client_deactivate_mails',"Details of Deactivated candidate's",$result[0]['cmail'],$result);
               }
        }
              
     }
      /****************************** 
    *   Monthly email to client  for creation of candidates created 
    * client_admin_mails_month
       ****************************************/ 
     function client_admin_mails_month(){
        $valcmail=$this->Cron_model->get_clientemail(30);
        foreach($valcmail as $val){
            if($val['cmail']){
         $results[]=$this->Cron_model->get_clientadmin_month($val['organisation'],$val['parent_office'],$val['office'],$val['sub_office'],$val['cid']);
        }
    }
    foreach($results as $key => $result)
            { 
                if($result[0]['cmail']){              
                    $result['num_days']='Month';
                    $this->send_email_common('client_admin_mails',"Creation of candidate user id's",$result[0]['cmail'],$result);
                }
        }
              
     }
    
    /**************************************
   *  Dially/Weekly/Monthly Interim/Final / Supplementary Report published email
   * published_report_mails
    ***************************************/
    function published_report_mails(){
        $num_day=$this->uri->segment(3);
        // $num_day=7;
        $reports=$this->Cron_model->get_published_reports($num_day);
        foreach ($reports as $value1) {
            $rpt_status[$value1['client_id']]['org_name']=$value1['org_name'];
            $rpt_status[$value1['client_id']]['parent_office']=$value1['parent_office'];
            $rpt_status[$value1['client_id']]['client_id']=$value1['client_id'];
            $rpt_status[$value1['client_id']]['hr_name']=$value1['hr_name'];
            $rpt_status[$value1['client_id']]['email']=$value1['email'];
            $rpt_status[$value1['client_id']]['case_no']=$value1['case_no'];
            
        }
        // echo '<pre>';print_r($rpt_status);exit;
        Switch($num_day){
            case 1:
            $num_days_mail='day';
            break;
            case 7:
            $num_days_mail='Week';
            break;
            case 30:
            $num_days_mail='Month';
            break;
            default:
            $num_days_mail='';
            break;
        }
        if(!empty($rpt_status)){ 
            foreach ($rpt_status as $cid => $cvalue) { 
                $data=$cvalue;  
                $data['num_days_mail']=$num_days_mail;
                $data['num_days']=$num_day;
                $data['reports'] =  $reportss =$this->Cron_model->get_fullpublished_reports($num_day,$cvalue['email']);
                
                $data['Record']=$rpt_status;
                $this->send_email_common('report_published_mail',"Interim/Final/Supplementary Report published by Dcode Research",$cvalue['email'],$data);  
            } 
        }
    }
    /*****************************************
    * send_email_common function
    * send_email_common
    **********************************************/
    function send_email_common($type =null,$subject =null, $email =null, &$data =null,$cc =null){
                
                $this->load->library('email');
                $email_config['protocol']    = 'smtp';
                $email_config['smtp_host']    = 'ssl://smtp.gmail.com';
                $email_config['smtp_port']    = '465';
                $email_config['smtp_user']    = EMAIL_BGV;
                $email_config['smtp_pass']    = PASS_BGV;
                $email_config['mailtype'] = 'html';
                $this->email->initialize($email_config);
                $this->email->set_newline("\r\n");
                $this->email->from('info@dcoderesearch.com','Dcode');
                $this->email->to($email);
                if($cc){
                    $cc_email = implode(',' , $cc);
                    $this->email->cc($cc_email);
                }
                $this->email->subject(sprintf($subject));
                $data['resultab']=$data;
                $this->email->message($this->load->view('Email/'.$type, $data, TRUE));
                $this->email->send();
    }
     /*****************************************
    * send qc revert case function
    * send_email_common
    **********************************************/

    function vm_revertcaselist(){

         $valcmail =  $this->Cron_model->vm_list();

        foreach($valcmail as $val){
            if($val['vm_email']){
            $results[]=$this->Cron_model->vm_revertlistcase($val['assignee_id']);
            }
        }
       foreach($results as $key => $result)
            { 
              if($result[0]['vm_email']){   
               $result['num_days']='Week';
             $this->send_email_common('qcto_vm_reverted_check',"Reverted checks",$result[0]['vm_email'],$result);
             }
        }

        $resultss = $this->Cron_model->vm_revertlistcase();
        $new = array();
        $vsassignee_list = $this->dm->get_assignee_vslist();

        foreach ($vsassignee_list as $key => $vs) {
            
                array_push($new,$vs['email']);
            }
        $qcassignee_list = $this->vm->get_qc2assignee_list(); 
        foreach ($qcassignee_list as $key => $qc) {
            
                array_push($new,$qc['email']);             
            }
            
        $mail_id = $this->config->item('superadmin');
        $this->send_email_common('qcto_vm_reverted_check',"Reverted checks",$mail_id,$resultss,$new);

    }


    /**************************************
   *  Dially Reuest Raised email
   * request_raised_mails
    ***************************************/
    function request_raised_mails(){

        $reqList=$this->Cron_model->get_reuested_checklist();
        foreach ($reqList as $value1) {
            $rpt_status[$value1['client_id']]['org_id']=$value1['org_id'];
            $rpt_status[$value1['client_id']]['org_name']=$value1['org_name'];
            $rpt_status[$value1['client_id']]['mail_to_admin']=$value1['mail_to_admin'];
            $rpt_status[$value1['client_id']]['client_id']=$value1['client_id'];
            $rpt_status[$value1['client_id']]['hr_name']=$value1['hr_name'];
            $rpt_status[$value1['client_id']]['email']=$value1['email'];
            $rpt_status[$value1['client_id']]['request_id']=$value1['request_id'];    
        }
        // echo '<pre>';print_r($reqList);exit;
        if(!empty($rpt_status)){ 
            foreach ($rpt_status as $cid => $cvalue){ 
                $data=$cvalue;
                $data['reports']=$repots=$this->Cron_model->get_reuest_raisedlist($cvalue['email']);
                
                $this->send_email_common('request_raised_mails',"Request raised list for ".date('d-m-Y'),$cvalue['email'],$data);
                // echo '<pre>';print_r($repots);
                if($cvalue['mail_to_admin'] ==1){
                    
                    // $userMap=$this->Cron_model->get_user_map($cvalue['client_id']);
                    foreach($repots as $repVal){

                        $userMap=$this->Cron_model->get_user_map1($cvalue['client_id'],$repVal['case_no']);
                        foreach($userMap as $userVal){
                            
                            $cAdmails=$this->Cron_model->get_orgwisemail($cvalue['org_id'],$cvalue['client_id'],$userVal['parent_office'],$userVal['office'],$userVal['sub_office'],$userVal['user_type'],$userVal['role_id']);

                            foreach($cAdmails as $mailVal){
                                $data=$mailVal;
                                if($mailVal['clientEmail']!=$cvalue['email']){

                                    $this->send_email_common('request_raised_mails',"Request raised list for ".date('d-m-Y'),$mailVal['clientEmail'],$data);
                                }
                                
                            }

                        }
                    }
                }     
            } //exit;
        }
    }




    
}