<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);
require_once ('Common.php');
class Dadmin extends Common {
    protected static $dadmin_model = 'Dadmin_model';
    protected static $client_model = 'Client_model';
    protected $index_dashboard = 'Index/dashboard';
    protected $dadmin_dadminsearch = 'Dadmin/dadminsearch';
    function __construct() 
    {
        parent::__construct();
        $this->_check_userlogin ();
        $this->load->library('pdfexport');
    $models = array(self::$dadmin_model => 'dm','Notification_model' => 'nm',self::$client_model=>'cm','Verification_model'=>'vm','Reports_model'=>'rm','Management_model'=>'mm','Dataentry_model' => 'dem');
    foreach ($models as $file => $object_name) {
        $this->load->model($file, $object_name);
    }
    $this->lang->load('Verification');
    $this->load->helper('list_search_filter_helper');
    $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
    $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','jquery-ui-1.10.4','highcharts','exporting','jquery.validate','grid.locale-en','jquery.jqGrid.min','jquery-ui-1.8.16.custom.min','commonjs','jquery.datepick','multipleclone'));
    $this->load->helper('text');
    $this->load->helper('cloneform');
    $this->load->helper('url');
    $this->load->library('zip');
    ini_set('memory_limit', '-1');
    }
    /************************************
     * CASE ALLOTMENT TO DEO list  view page 
     * dadminsearch function
     **********************************/
    function dadminsearch() { 
        $assignee_list = $this->dm->get_assignee_list(); 
        $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list,array('assignee_id','name'));
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Case Allotment to DEO', $this->dadmin_dadminsearch);
        $data['breadcrumb']=$this->breadcrumbs->show();  
        $this->amodel->pagerender($data, 'user_allotment');
    }
    /***********************************************
     * CASE ALLOTMENT TO DEO list 
     * get_users function
     **************************************/
    function get_users( $office_id = 0  ){ 
        $model = array(self::$client_model=>'get_userlistoffsuper');
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $dataentry = ($_REQUEST['entry']=='') ? '' : $_REQUEST['entry'];
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $a_date=($_REQUEST['a_date']) ? $_REQUEST['a_date'] : '';
        $t_date=($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $case_no=($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $billing_type=($_REQUEST['billing_type']) ? $_REQUEST['billing_type'] : '';
        if($org_id){
            $condition[]=" c.id = ".$org_id;
        }
        if($office){
            $condition[]=" b.id = ".$office;
        }
        if($parent_office){
            $condition[]=" d.id = ".$parent_office;
        }
        if($name){
            $condition[]=" a.candidate_name like '%".$name."%'";
        }
        if($sub_office){
            $condition[]=" e.sub_office = ".$sub_office;
        }
        if($a_status==1){
            $condition[]=" a.assainee_status =1";
        }
        if($a_status==2){
            $condition[]=" a.assainee_status !=1 and cv.reverted_by = 0";
        }
        if($a_status==3){
            $condition[]="  cv.reverted_by != 0 and a.assainee_status !=1 ";
        }
        if($a_status==4){
            $condition[]="cv.reverted_by = 0 and  a.assainee_status =0 and cv.reverted_reason<>'' ";
        }
        if($dataentry !=0 && $dataentry !=4 ){
            $condition[]=" a.dataentry_by = ".$dataentry;
        }
        if($dataentry ==4){
            $condition[]=" a.dataentry_by = 0";
        }
        if($a_date){
            $condition[]="DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($a_date))."'";
        }
        if($t_date){
            $condition[]="DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }

        //22/01/2023
        $case_no = trim($case_no);
        if($case_no){
            $condition[]=" a.case_no like '%".$case_no."'";
        }
        if($billing_type==1){
            $condition[]=" a.case_no like '%PR%'";
        }
        if($billing_type==2){
            $condition[]=" a.case_no like '%PO%'";
        }
        if($term)
        {
            //support multiple words
            $search = explode(' ', $term);
            foreach($search as $t) {
            $not        = '';
            $operator    = 'OR';
            if(substr($t,0,1) == '-')
            {
            $not        = 'NOT ';
            $operator    = 'AND';
            //trim the - sign off
            $t        = substr($t,1,strlen($t));
            }
            $like    = '';
            $like    .= "( a.candidate_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." c.org_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." b.office_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." d.office_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." e.order_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." a.assainee_status ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." f.first_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." c.dedicated_operator ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." dataentry_by ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." a.case_no ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' ) " ;
            $condition[]=$like;
            }
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];  
        $result = $results[1];
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            foreach ( $result as $i => $row ) {
            $reject_reason='';
            $deadline_to = ($row['client_submit_date']) ? date('d-m-Y',strtotime($row['client_submit_date'])) : '';
            if($row['assainee_status']==1){
                $check=$i+$count+1;
                $request_status=  'Assigned';
                $reject_status='Accepted';
            } 
            else if($row['assainee_status']==2 && $row['reverted_by']!=0 && !empty($row['reverted_reason'])) {
                $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id'] ).'"/>';
                $request_status=  anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Partial Entry Requested');
                $reject_status='Reject Raised'; 
                $reject_reason=$row['reverted_reason'];
            } 
            else if($row['assainee_status']==2 && $row['reverted_by']==0 && !empty($row['reverted_reason'])) {
                $check=$i+$count+1;
                $request_status=  'Reject Closed'; 
                $reject_reason=$row['reverted_reason'];
                $reject_status=(anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:green'>Accept</span>").' / '.anchor('/Dadmin/rejectcase/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:red'>Reject</span>")); 
            } 
            else if($row['assainee_status']==2){
                $check=$i+$count+1;
                $request_status=  anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Partial Entry Requested');
                $reject_status=(anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:green'>Accept</span>").'   -  '.anchor('/Dadmin/rejectcase/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:red'>Reject</span>")); 
            }
            else if($row['reverted_by']==0 && empty($row['reverted_reason'])){
                $request_status= anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'New');
                $reject_status=( anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:green'>Accept</span>").' / '.anchor('/Dadmin/rejectcase/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:red'>Reject</span>")); 

            }
             else if($row['reverted_by']!=0 && !empty($row['reverted_reason'])){
                $request_status= 'Reject Raised';
                $reject_status='Reject Raised'; 
                $reject_reason=$row['reverted_reason'];
            }
            else if($row['reverted_by']==0 && !empty($row['reverted_reason'])){
                $request_status= anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Reject Closed');
                $reject_reason=$row['reverted_reason'];
                $reject_status=( anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:green'>Accept</span>").' / '.anchor('/Dadmin/rejectcase/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:red'>Reject</span>")); 
            }
            else { 
                $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id'] ).'" />';
                $request_status= anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'New');
                $reject_status='Accepted'; 
            }
            if($row['dataentry_by']==0){
                $dstatus='Candidate Entry';
            }
            else if($row['dataentry_by']==1){
                $dstatus='Partial Entry';
            }
            else if($row['dataentry_by']==2){
                $dstatus='Full Entry';
            }
            else if($row['dataentry_by']==3){
                $dstatus='Offline Entry';
            }
            else {
                $dstatus='';
            }
              

            if($request_status=='Assigned'){
            $response->rows [$i] ['cell'] = array ( $check,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'], anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']), $row['case_no'],$row['order_name'],$request_status,$reject_reason,$dstatus,$row['first_name'],$reject_status, $deadline_to,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View') );
            }else {
            if($reject_status=='Reject Raised'){
                $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id']).'" disabled/>';
            }
            else{
                $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id']).'" />';
            }
            $response->rows [$i] ['cell'] = array ( $check,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'], anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']), $row['case_no'],$row['order_name'],$request_status,$reject_reason,$dstatus,$row['first_name'], $reject_status, $deadline_to,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View') );

            }
            }
        }
        echo json_encode($response);
    }
    /*************************** 
    * Rejecting case to client admin 
    * rejectcase
    *****************************/
    function rejectcase($request_id){ 
        $this->load->helper('text');
        $subtitle="DataEntry View";
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Case Allotment Details', $this->dadmin_dadminsearch);
        $data['request_id']=$request_id = $this->uri->segment(3);
        $operator_id = base64_decode($this->uri->segment(4)); 
        $candidate_name=$data['checks_result'] = $this->dm->get_userlistoffsuper(base64_decode($request_id));
        $data['candidate_name']=$candidate_name[0]['candidate_name'];
        $data['ref_number']=$candidate_name[0]['client_ref_number'];
        $data['case_no']=$candidate_name[0]['case_no'];
        $data['opt_id']=$operator_id;
        $assignee_list = $this->dm->get_assignee_list();
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data,$data['title'],$data['subtitle']);
    }
    /*************************** 
    * supervisor revert to operator 
    * srevertcase
     ************************** */
    function srevertcase($request_id){  
        $this->load->helper('text');
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $data['request_id']=$request_id = $this->uri->segment(3);
        $operator_id = base64_decode($this->uri->segment(4)); 
        $candidate_name=$data['checks_result'] = $this->dm->get_userlistoffsuper(base64_decode($request_id));
        $data['candidate_name']=$candidate_name[0]['candidate_name'];
        $data['opt_id']=$operator_id;
        $assignee_list = $this->dm->get_assignee_list(); 
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data,'srevertcase');
    }  
    /*************************** 
    * New Request function
    * newrequest
    ************************** */
    function newrequest($request_id) {  
        $data['request_id']=$request_id = $this->uri->segment(3);
        $operator_id = base64_decode($this->uri->segment(4)); 
        $candidate_name=$data['checks_result'] = $this->dm->get_userlistoffsuper(base64_decode($request_id));
        $data['candidate_name']=$candidate_name[0]['candidate_name'];
        $data['opt_id']=$operator_id;
        $data['ref_number']=$candidate_name[0]['client_ref_number'];
        $data['case_no']=$candidate_name[0]['case_no'];
        $assignee_list = $this->dm->get_assignee_list(); 
        if($operator_id==0){
            $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list,array('assignee_id','name'));
        }
        else
        {
            $operator_name = $this->cm->getopername($operator_id);
            $data['operator_list']=$operator_name[0];
        }
        $this->db->select('dataentry_by');
        $this->db->where('request_id',base64_decode($request_id));
        $data['dataentry']=$dataentry=  $this->db->get(DB_PREFIX.'client_request')->row_array();
        $this->db->where('request_id',base64_decode($request_id));
        $data['partial_coduments']=$partial_coduments=  $this->db->where('request_id',base64_decode($request_id))->get(DB_PREFIX.'partial_upload_document')->result_array();
        if(($dataentry['dataentry_by']==1 || $dataentry['dataentry_by']==3 ) && empty($partial_coduments)) {
            $data ['title'] = 'New Request'; 
            $upload_file_clones = array(array('file_name' => array('text', 'file_name', '', '','', '', ''),'upload_file' => array('upload', 'upload_file', '', '','', '', '')));
            $data['upload_file_clone'] = create_cloneform($upload_file_clones,'', $id);
            $data['upload_file'] =formclonecreation($upload_file_clones,$data['upload_file_clone'],1,'Add Document',"Upload Candidate Documents");
        }
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Data Entry', 'Client/clientofflinesearch');
        $this->breadcrumbs->push('New Request', 'Dadmin/newrequest');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'new_request');
    }
    /*************************** 
    * Alloting to Vsupervisor 
    * v_supervisoralort
     ************************** */
    function v_supervisoralort($request_id){
        $data['request_id']=$request_id = $this->uri->segment(3);
        $operator_id = base64_decode($this->uri->segment(4)); 
        $candidate_name=$data['checks_result'] = $this->dm->get_userlistoffsuper(base64_decode($request_id));
        $data['candidate_name']=$candidate_name[0]['candidate_name'];
        $data['opt_id']=$operator_id;
        $assignee_list = $this->dm->get_assignes_list(); 
        $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list,array('assignee_id','name'));
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Data Entry', 'Client/clientofflinesearch');
        $this->breadcrumbs->push('New Request', 'Dadmin/newrequest');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'new_request');
    }
    /*************************** 
    * newrevertrequest function
    * newrevertrequest
    ***************************/
    function newrevertrequest($request_id) {  
        $data['request_id']=$request_id = $this->uri->segment(3);
        $operator_id = base64_decode($this->uri->segment(4)); 
        $candidate_name=$data['checks_result'] = $this->dm->get_userlistoffsuper(base64_decode($request_id));
        $revertreason=$data['revertreason'] = $this->dm->get_revertlistofsuper(base64_decode($request_id));
        $data['revertreason']=$revertreason[0]['reason'];
        $data['candidate_name']=$candidate_name[0]['candidate_name'];
        $data['opt_id']=$operator_id;
        $assignee_list = $this->dm->get_assignee_list(); 
        if($operator_id==0){
                $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list,array('assignee_id','name'));
        }
        else
        {
            $operator_name = $this->cm->getopername($operator_id);
            $data['operator_list']=$operator_name[0];
        }
        $this->db->select('dataentry_by');
        $this->db->where('request_id',base64_decode($request_id));
        $data['dataentry']=$dataentry=  $this->db->get(DB_PREFIX.'client_request')->row_array();
        $this->db->where('request_id',base64_decode($request_id));
        $data['partial_coduments']=$partial_coduments=  $this->db->where('request_id',base64_decode($request_id))->get(DB_PREFIX.'partial_upload_document')->result_array();
        if(($dataentry['dataentry_by']==1 || $dataentry['dataentry_by']==3 ) && empty($partial_coduments)) {
            $data ['title'] = 'New Request'; 
            $upload_file_clones = array(array('file_name' => array('text', 'file_name', '', '','', '', ''),'upload_file' => array('upload', 'upload_file', '', '','', '', '')));
            $data['upload_file_clone'] = create_cloneform($upload_file_clones,'', $id);
            $data['upload_file'] =formclonecreation($upload_file_clones,$data['upload_file_clone'],1,'Add Upload Files',"Upload Candidate Documents");
        }
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Data Entry', 'Client/clientofflinesearch');
        $this->breadcrumbs->push('New Request', 'Dadmin/newrequest');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'new_request');
    }
     /*************************** 
    * newsupervisorrevertrequest function
    * newsupervisorrevertrequest
    ***************************/
    function newsupervisorrevertrequest($request_id) {  
        $data['request_id']=$request_id = $this->uri->segment(3);
        $operator_id = base64_decode($this->uri->segment(4)); 
        $candidate_name=$data['checks_result'] = $this->dm->get_userlistoffsuper(base64_decode($request_id));
        $revertreason=$data['revertreason'] = $this->dm->get_revertlistofsuper(base64_decode($request_id));
        $data['revertreason']=$revertreason[0]['reason'];
        $data['candidate_name']=$candidate_name[0]['candidate_name'];
        $data['opt_id']=$operator_id;
        $assignee_list = $this->dm->get_assignee_list(); 
        if($operator_id==0){
            $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list,array('assignee_id','name'));
        }
        else
        {
            $operator_name = $this->cm->getopername($operator_id);
            $data['operator_list']=$operator_name[0];
        }
        $this->db->select('dataentry_by');
        $this->db->where('request_id',base64_decode($request_id));
        $data['dataentry']=$dataentry=  $this->db->get(DB_PREFIX.'client_request')->row_array();
        $this->db->where('request_id',base64_decode($request_id));
        $data['partial_coduments']=$partial_coduments=  $this->db->where('request_id',base64_decode($request_id))->get(DB_PREFIX.'partial_upload_document')->result_array();
        if(($dataentry['dataentry_by']==1 || $dataentry['dataentry_by']==3 ) && empty($partial_coduments)) {
            $data ['title'] = 'New Request'; 
            $upload_file_clones = array(array('file_name' => array('text', 'file_name', '', '','', '', ''),'upload_file' => array('upload', 'upload_file', '', '','', '', '')));
            $data['upload_file_clone'] = create_cloneform($upload_file_clones,'', $id);
            $data['upload_file'] =formclonecreation($upload_file_clones,$data['upload_file_clone'],1,'Add Upload Files',"Upload Candidate Documents");
        }
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Data Entry', 'Client/clientofflinesearch');
        $this->breadcrumbs->push('New Request', 'Dadmin/newrequest');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'new_request');
    }
    /******************************
   *  newcadminrevertrequest function
   * newcadminrevertrequest
    **************************/
    function newcadminrevertrequest($request_id) {  
        $data['request_id']=$request_id = $this->uri->segment(3);
        $operator_id = base64_decode($this->uri->segment(4)); 
        $candidate_name=$data['checks_result'] = $this->dm->get_userlistoffsuper(base64_decode($request_id));
        $revertreason=$data['revertreason'] = $this->dm->get_revertlistofsuper(base64_decode($request_id));
        
        $data['revertreason']=$revertreason[0]['reason'];
        $data['candidate_name']=$candidate_name[0]['candidate_name'];
        $data['opt_id']=$operator_id;
        $assignee_list = $this->dm->get_assignee_list(); 
        if($operator_id==0){
            $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list,array('assignee_id','name'));
        }
        else
        {
            $operator_name = $this->cm->getopername($operator_id);
            $data['operator_list']=$operator_name[0];
        }
        $this->db->select('dataentry_by');
        $this->db->where('request_id',base64_decode($request_id));
        $data['dataentry']=$dataentry=  $this->db->get(DB_PREFIX.'client_request')->row_array();
        $this->db->where('request_id',base64_decode($request_id));
        $data['partial_coduments']=$partial_coduments=  $this->db->where('request_id',base64_decode($request_id))->get(DB_PREFIX.'partial_upload_document')->result_array();
        $data ['title'] = 'New Request'; 
        if($dataentry['dataentry_by']==1){
        $upload_file_clones = array(array('document_name' => array('text', 'document_name', '', '','', '', ''),'upload_file' => array('upload', 'upload_file', '', '','', '', '')));
        }
        else if($dataentry['dataentry_by']==2){
        $upload_file_clones = array(array('document_name' => array('text', 'document_name', '', '','', '', ''),'upload_file' => array('upload', 'upload_file', '', '','', '', '')));
        }else {
        $upload_file_clones = array(array('file_name' => array('text', 'file_name', '', '','', '', ''),'upload_file' => array('upload', 'upload_file', '', '','', '', '')));
        }
        $data['upload_file_clone'] = create_cloneform($upload_file_clones,'', $id);
        $data['upload_file'] =formclonecreation($upload_file_clones,$data['upload_file_clone'],1,'Add Upload Files',"Upload Candidate Documents");
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Data Entry', 'Client/clientofflinesearch');
        $this->breadcrumbs->push('New Request', 'Dadmin/newrequest');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'new_request');
    }
     /******************************
    * newcadminrejectrequest function
    * newcadminrejectrequest
    **************************/
    function newcadminrejectrequest($request_id) {  
        $data['request_id']=$request_id = $this->uri->segment(3);
        $operator_id = base64_decode($this->uri->segment(4)); 
        $candidate_name=$data['checks_result'] = $this->dm->get_userlistoffsuper(base64_decode($request_id));
        $revertreason=$data['revertreason'] = $this->dm->get_rejectlistofsuper(base64_decode($request_id));
        $data['revertreason']=$revertreason[0]['reverted_reason'];
        $data['candidate_name']=$candidate_name[0]['candidate_name'];
        $data['opt_id']=$operator_id;
        $assignee_list = $this->dm->get_assignee_list(); 
        if($operator_id==0){
                $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list,array('assignee_id','name'));
        }
        else
        {
            $operator_name = $this->cm->getopername($operator_id);
            $data['operator_list']=$operator_name[0];
        }
        $this->db->select('dataentry_by');
        $this->db->where('request_id',base64_decode($request_id));
        $data['dataentry']=$dataentry=  $this->db->get(DB_PREFIX.'client_request')->row_array();
        $this->db->where('request_id',base64_decode($request_id));
        $data['partial_coduments']=$partial_coduments=  $this->db->where('request_id',base64_decode($request_id))->get(DB_PREFIX.'partial_upload_document')->result_array();
        $data ['title'] = 'New Request'; 
        if($dataentry['dataentry_by']==1){
            $upload_file_clones = array(array('document_name' => array('text', 'document_name', '', '','', '', ''),'upload_file' => array('upload', 'upload_file', '', '','', '', '')));
            }else if($dataentry['dataentry_by']==2){
            $upload_file_clones = array(array('document_name' => array('text', 'document_name', '', '','', '', ''),'upload_file' => array('upload', 'upload_file', '', '','', '', '')));
            }else if($dataentry['dataentry_by']==0){
            $upload_file_clones = array(array('document_name' => array('text', 'document_name', '', '','', '', ''),'upload_file' => array('upload', 'upload_file', '', '','', '', '')));
            }else {
        $upload_file_clones = array(array('file_name' => array('text', 'file_name', '', '','', '', ''),'upload_file' => array('upload', 'upload_file', '', '','', '', '')));
    }
        $data['upload_file_clone'] = create_cloneform($upload_file_clones,'', $id);
        $data['upload_file'] =formclonecreation($upload_file_clones,$data['upload_file_clone'],1,'Add Upload Files',"Upload Candidate Documents");
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Data Entry', 'Client/clientofflinesearch');
        $this->breadcrumbs->push('New Request', 'Dadmin/newrequest');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'new_request');
    }
     /******************************
    * dadminsearch_reject function
    * dadminsearch_reject
    **************************/
    function dadminsearch_reject(){
            $assignee_id = 12;
            $user_id = $this->session->userdata('userid');
            $request_id = base64_decode($this->input->post( 'request_id' )); 
            $hr_name= $this->dm->get_hrlist($request_id); 
            if($assignee_id==12){ 
            $upd_data = array();
            $upd_data['reverted_reason'] =$_POST['reason'];
            $upd_data['reverted_by']= $user_id;
            $upd_data['des_rejected_date']=date("Y-m-d H:i:s");
            $upd_data['operator_status'] =0;
            $upd_data['candidate_status'] =0;
            $this->db->where('request_id',$request_id);
            $this->db->update ( DB_PREFIX .'submit_cv', $upd_data );
            $client = array();
            $client['assainee_status']=0;
            $client['assignee_id']=0;
            $this->db->where('request_id',$request_id);
            $this->db->update ( DB_PREFIX .'client_request', $client );
            $data['hr_name']=$hr_name['first_name'];
            $data['org_name']=$hr_name['org_name'];
            $data['case_no']=$_POST['case_num'];
            $data['ref_num']=$_POST['ref_num'];
            $data['can_name']=$_POST['can_name'];
            $data['reason']=$_POST['reason'];
            $this->send_email_common_revert('reject_case','Case rejected by Dcode Research',$hr_name['email'],$data);
            redirect ( base_url($this->dadmin_dadminsearch), 'refresh' );    
            }
            else
            {
                $this->session->set_userdata('error',$status);
                redirect('Dadmin/newrequest/'.base64_encode($request_id).'/'.base64_encode($_POST['opt_id']));
            }
                
            
        }
        /***************************
        * p_newrequest function
        * p_newrequest
        ****************************/
        function p_newrequest() { 
            try{
                $assignee_id = $this->input->post ( 'assignee_id' );
                $date_from = date('Y-m-d');
                $date_to = $this->input->post ( 'date_to' );
                $user_id = $this->input->post ( 'user_id' );
                $request_id = base64_decode($this->input->post( 'request_id' )); 
                $upload_files =array('file_name','upload_file');
                $hraccept_name= $this->dm->get_hrlist($request_id);
                $status= $this->insertcloneDetails($_POST['count1'],$upload_files,$return_id,DB_PREFIX.'candidate_upload_files',$request_id,'req_id');

                $role_id= $this->session->userdata('role_id');
                $userId= $this->session->userdata('userid');

                if($assignee_id && $status==1){ 

                // $this->db->select('c.request_id,c.case_no,c.user_id as candidate_id,s.client_submit_date');
                // $this->db->where('c.request_id',$request_id);
                // $this->db->join(DB_PREFIX.'submit_cv s','s.request_id=c.request_id','left');
                // $resultdata=$this->db->get(DB_PREFIX."client_request c")->row_array();
    
                // $time = new DateTime($resultdata['client_submit_date']);
                // $diff = $time->diff(new DateTime());
                // $minutes = ($diff->days * 24 * 60) + ($diff->h * 60) + $diff->i;

                // echo $hours = floor($minutes / 60);
                // echo  $Hminutes = $minutes % 60;
                
                // $save_data['request_id']=$resultdata['request_id'];
                // $save_data['case_no'] = $resultdata['case_no'];
                // $save_data['check_id'] = '';
                // $save_data['level_id'] = '';
                // $save_data['candidate_id']=$resultdata['candidate_id'];
                // $save_data['role_id'] = $role_id;
                // $save_data['user_id'] = $userId;
                // $save_data['process_id'] = 'Alloted to DEO';
                // $save_data['report_status'] = '';
                // $save_data['tat_process_net'] = $minutes;
                // $save_data['tat_overall_net'] = '';
                // $save_data['wait_rr'] = '';
                // $save_data['wait_revert'] = '';
                // $save_data['within_tat'] = '';
                // $save_data['from_date'] = $resultdata['client_submit_date'];
                // $save_data['created_date'] = date ( 'Y-m-d H:i:s' );
                // $this->db->insert ( DB_PREFIX .'tat_checks', $save_data );
                
                $upd_data = array();
                $upd_data['assignee_id'] = $assignee_id;
                $upd_data['assainee_status']= 1;
                $upd_data['case_accepted_date'] = date("Y-m-d H:i:s");
                $upd_data['deadline_from'] = date("Y-m-d");
                $upd_data['deadline_to'] = date("Y-m-d", strtotime($date_to));
                $upd_data['updated_on'] = date ( 'Y-m-d H:i:s' );
                $upd_data['updated_by'] = $this->user_id;
                $upd_data = $this->security->xss_clean($upd_data);
                $this->db->where('request_id',$request_id);
                $this->db->update ( DB_PREFIX .'client_request', $upd_data );
                echo "<script>alert('Candidate profile has been accepted successfully');</script>";
                $data['hr_name']=$hraccept_name['first_name'];
                $data['org_name']=$hraccept_name['org_name'];
                $data['case_no']=$_POST['case_no'];
                $data['ref_num']=$_POST['ref_number'];
                $data['can_name']=$_POST['can_name'];
                if($_POST['dataentry']!=3){
                $this->send_email_common_revert('accept_case','Case accepted by Dcode Research',$hraccept_name['email'],$data);
                }
               
                if($_POST['dataentry']==3){
                    redirect('Client/clientofflinesearch/3');
                }
                else{
                    redirect ( base_url($this->dadmin_dadminsearch), 'refresh' );    
                }
                }
                 else
                {
                    $this->session->set_userdata('error',$status);
                    redirect('Dadmin/newrequest/'.base64_encode($request_id).'/'.base64_encode($_POST['opt_id']));
                }
               }
                catch(ErrorException $e) {
            echo $e->getMessage(); 
            $this->load->view('Index/error_500');
        }
        }
        /***********************************
        * p_newrevertrequest function
        * p_newrevertrequest
        ********************************/
        function p_newrevertrequest() {
                $assignee_id = $this->input->post ( 'assignee_id' );
                $date_from = date('Y-m-d');
                $date_to = $this->input->post ( 'date_to' );
                $user_id = $this->input->post ( 'user_id' );
                $request_id = base64_decode($this->input->post( 'request_id' )); 
                $upload_files =array('file_name','upload_file');
               $status= $this->insertnewrequestcloneDetails($_POST['count1'],$upload_files,$return_id,DB_PREFIX.'candidate_upload_files',$request_id,'req_id');
                if($assignee_id && $status==1){ 
                $upd_data = array();
                $upd_data['assignee_id'] = $assignee_id;
                $upd_data['assainee_status']= 1;
                $upd_data['deadline_from'] = date("Y-m-d");
                $upd_data['deadline_to'] = date("Y-m-d", strtotime($date_to));
                $upd_data['updated_on'] = date ( 'Y-m-d H:i:s' );
                $upd_data['updated_by'] = $this->user_id;
                $this->db->where('request_id',$request_id);
                $this->db->update ( DB_PREFIX .'client_request', $upd_data );
                if($_POST['dataentry']==3){
                    redirect('Client/clientofflinesearch/3');
                }
                else{
                    redirect ( base_url($this->dadmin_dadminsearch), 'refresh' );    
                }
                }
                else
                {
                    $this->session->set_userdata('error',$status);
                    redirect('Dadmin/newrequest/'.base64_encode($request_id).'/'.base64_encode($_POST['opt_id']));
                }
        }
        /*****************************
       *  p_newsupervisorrevertrequest function
       * p_newsupervisorrevertrequest
        *******************************/
        function p_newsupervisorrevertrequest() {
            $assignee_id = $this->input->post ( 'assignee_id' );
            $date_from = date('Y-m-d');
            $date_to = $this->input->post ( 'date_to' );
            $user_id = $this->input->post ( 'user_id' );
            $request_id = base64_decode($this->input->post( 'request_id' )); 
            $upload_files =array('file_name','upload_file');
            $status= $this->insertclonerevertDetails($_POST['count1'],$upload_files,$return_id,DB_PREFIX.'candidate_upload_files',$request_id,'req_id');
            if($assignee_id && $status==1){ 
            $upd_data = array();
            $upd_data['assignee_id'] = $assignee_id;
            $upd_data['assainee_status']= 1;
            $upd_data['vm_revert_supervisor']= 0;
            $upd_data['deadline_from'] = date("Y-m-d");
            $upd_data['deadline_to'] = date("Y-m-d", strtotime($date_to));
            $upd_data['updated_on'] = date ( 'Y-m-d H:i:s' );
            $upd_data['updated_by'] = $this->user_id;
            $this->db->where('request_id',$request_id);
            $this->db->update ( DB_PREFIX .'client_request', $upd_data );
            if($_POST['dataentry']==3){
                redirect('Client/clientofflinesearch/3');
            }
            else{
                redirect ( base_url($this->dadmin_dadminsearch), 'refresh' );    
            }
            }
            else
            {
                $this->session->set_userdata('error',$status);
                redirect('dadmin/newrequest/'.base64_encode($request_id).'/'.base64_encode($_POST['opt_id']));
            }
        }
        /******************************************
       *  p_newcadminrejectrequest function
       * p_newcadminrejectrequest
        **************************************/
        function p_newcadminrejectrequest(){
            if($_POST['dataentry']==3){
                $assignee_id = $this->input->post ( 'assignee_id' );
                $date_from = date('Y-m-d');
                $date_to = $this->input->post ( 'date_to' );
                $user_id = $this->input->post ( 'user_id' );
                $request_id = base64_decode($this->input->post( 'request_id' )); 
                $upload_files =array('file_name','upload_file');
                $status= $this->insertclonerevertDetails($_POST['count1'],$upload_files,$return_id,DB_PREFIX.'candidate_upload_files',$request_id,'req_id');
                $upd_data = array();
                $upd_data['vm_revert_option_status']= 4;
                $upd_data['operator_submited_by'] = $this->user_id;
                $this->db->where('request_id',$request_id);
                $this->db->update ( DB_PREFIX .'submit_cv', $upd_data );
                redirect('client/clientofflinesearch/3');
                } 
                else if($_POST['dataentry']==1 || $_POST['dataentry']==2 || $_POST['dataentry']==0){
                $request_id = base64_decode($this->input->post( 'request_id' ));    
                $documents= $this->amodel->getDetails(DB_PREFIX . "partial_upload_document", array('*'), array('request_id' => $request_id,'status'=>'1'));
                $doc=count($documents);
                $uploaded_docs=$_POST['multipleupload'];
                for($i=0; $i<$doc; $i++) {
                    $docse=$documents[$i]['multipleupload'];
                    if(in_array(trim($documents[$i]['multipleupload']), $uploaded_docs))
                    {
                        $this->db->set('status',1);
                        $this->db->where('multipleupload',$docse);
                        $this->db->update(DB_PREFIX.'partial_upload_document');
                    }
                    else {
                        $this->db->set('status',0);
                        $this->db->where('multipleupload',$docse);
                        $this->db->update(DB_PREFIX.'partial_upload_document');
                    }
                }   
                $assignee_id = $this->input->post ( 'assignee_id' );
                $date_from = date('Y-m-d');
                $date_to = $this->input->post ( 'date_to' );
                $user_id = $this->input->post ( 'user_id' );
                $upload_files =array('document_name','multipleupload');
                $status= $this->insertclonecadaminrevertDetails($_POST['count1'],$upload_files,$return_id,DB_PREFIX.'partial_upload_document',$request_id,'request_id');
                $upd_datas = array();
                $upd_datas['revert_status']= 0;
                $this->db->where('request_id',$request_id);
                $this->db->update ( DB_PREFIX .'client_request', $upd_datas );
                $rej_datas = array();
                $rej_datas['reverted_by']= 0;
                $this->db->where('request_id',$request_id);
                $this->db->update ( DB_PREFIX .'submit_cv', $rej_datas );
                }
                redirect ( base_url('Client/client_caselist'), 'refresh' );    
        }
         /******************************************
       * p_newcadminrevertrequest function
       * p_newcadminrevertrequest
        **************************************/
        function p_newcadminrevertrequest() {
            if($_POST['dataentry']==3){
            $assignee_id = $this->input->post ( 'assignee_id' );
            $date_from = date('Y-m-d');
            $date_to = $this->input->post ( 'date_to' );
            $user_id = $this->input->post ( 'user_id' );
            $request_id = base64_decode($this->input->post( 'request_id' )); 
            $upload_files =array('file_name','upload_file');
           $status= $this->insertclonerevertDetails($_POST['count1'],$upload_files,$return_id,DB_PREFIX.'candidate_upload_files',$request_id,'req_id');
            $upd_data = array();
            $upd_data['vm_revert_option_status']= 4;
            $upd_data['operator_submited_by'] = $this->user_id;
            $this->db->where('request_id',$request_id);
            $this->db->update ( DB_PREFIX .'submit_cv', $upd_data );
            redirect('client/clientofflinesearch/3');
            } 
            else if($_POST['dataentry']==1 || $_POST['dataentry']==2){
            $assignee_id = $this->input->post ( 'assignee_id' );
            $date_from = date('Y-m-d');
            $date_to = $this->input->post ( 'date_to' );
            $user_id = $this->input->post ( 'user_id' );
            $request_id = base64_decode($this->input->post( 'request_id' )); 
            $upload_files =array('document_name','multipleupload');
            $status= $this->insertclonecadaminrevertDetails($_POST['count1'],$upload_files,$return_id,DB_PREFIX.'partial_upload_document',$request_id,'request_id');
            $upd_datas = array();
            $upd_datas['revert_status']= 0;
            $this->db->where('request_id',$request_id);
            $this->db->update ( DB_PREFIX .'client_request', $upd_datas );
            }
            redirect ( base_url('Client/clientofflinesearch/1'), 'refresh' );    
        }
        /*******************************
       * p_newrequest_bulk function
       * p_newrequest_bulk
        *******************************/
        function p_newrequest_bulk()
        {

            ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


            if(empty($_POST['request_id']))
            redirect($this->dadmin_dadminsearch);
            $postData=$_POST;
            $payment_status = $_POST['payment_status'];

            $role_id= $this->session->userdata('role_id');
            $userId= $this->session->userdata('userid');

            if($postData)
            {
                $assignee_id = $this->input->post ( 'assignee_id' );
                $date_from = date('Y-m-d');
                $date_to = $this->input->post ( 'date_to' );
                foreach($postData['request_id'] as $key=>$request_id) {
                if($assignee_id){ 

                    // $this->db->select('c.request_id,c.case_no,c.user_id as candidate_id,s.client_submit_date');
                    // $this->db->where('c.request_id',$request_id);
                    // $this->db->join(DB_PREFIX.'submit_cv s','s.request_id=c.request_id','left');
                    // $resultdata=$this->db->get(DB_PREFIX."client_request c")->row_array();

                    // $resultdata=$this->dm->getTatchecks($request_id);

                    // $fromDate = $resultdata['client_submit_date'];
                    // $toDate = date('Y-m-d H:i:s');
                    // $fromDate='2023-02-01 09:00:00';
                    // $toDate='2023-02-06 11:30:00';
                    // $numberOfDays= $this->dm->some_func_name($fromDate, $toDate);
                    // echo '<pre>'; print_r($numberOfDays);
                    
                    // date_default_timezone_set('Asia/Kolkata');
                    // $start = new DateTime($fromDate);
                    // echo $end = new DateTime($toDate);
                    // exit;
                    // otherwise the  end date is excluded (bug?)
                    // $end->modify('+1 day');

                    // $interval = $end->diff($start);

                    // total days
                    // $days = $interval->days;
                    // $days_inMin = ($interval->d*24*60) + ($interval->h*60) + $interval->i;

                    // create an iterateable period of date (P1D equates to 1 day)
                    // $period = new DatePeriod($start, new DateInterval('P1D'), $end);

                    // best stored as array, so you can add more than one
                    // $holidays = array('2014-03-07');

                    // foreach($period as $dt) {
                    //     $curr = $dt->format('D');

                    //     // for the updated question
                    //     if (in_array($dt->format('Y-m-d'), $holidays)) {
                    //        $days--;
                    //        $days_inMin -= (24*60);
                    //     }

                    //     // substract if Saturday or Sunday
                    //     if ($curr == 'Sat' || $curr == 'Sun') {
                    //         $days--;
                    //         $days_inMin -= (24*60);
                    //     }
                    // }

                    // echo 'Days: ' . $days; 
                    // echo '<br>Days in Minutes: ' . $days_inMin . ' min = ' . $days_inMin/(24*60) . ' days';
                    // echo $office_hrs_min = $days_inMin - ($days * (16.0*60));

                // print_r($numberOfDays);
                // exit;

                    // $time = new DateTime($resultdata['client_submit_date']);
                    // $diff = $time->diff(new DateTime());
                    // $minutes = ($diff->days * 24 * 60) + ($diff->h * 60) + $diff->i;

                    // echo $hours = floor($minutes / 60);
                    // echo  $Hminutes = $minutes % 60;
                
                    // $save_data['request_id']=$resultdata['request_id'];
                    // $save_data['case_no'] = $resultdata['case_no'];
                    // $save_data['check_id'] = '';
                    // $save_data['level_id'] = '';
                    // $save_data['candidate_id']=$resultdata['candidate_id'];
                    // $save_data['role_id'] = $role_id;
                    // $save_data['user_id'] = $userId;
                    // $save_data['process_id'] = 'Alloted to DEO';
                    // $save_data['report_status'] = '';
                    // $save_data['tat_process_net'] = $minutes;
                    // $save_data['tat_overall_net'] = '';
                    // $save_data['wait_rr'] = '';
                    // $save_data['wait_revert'] = '';
                    // $save_data['within_tat'] = '';
                    // $save_data['from_date'] = $resultdata['client_submit_date'];
                    // $save_data['created_date'] = date ( 'Y-m-d H:i:s' );
                    // $this->db->insert ( DB_PREFIX .'tat_checks', $save_data );
                    
                $upd_data = array();
                $upd_data['assignee_id'] = $assignee_id;
                $upd_data['assainee_status']= 1;
                $upd_data['case_accepted_date'] = date("Y-m-d H:i:s");
                $upd_data['deadline_from'] = date("Y-m-d");
                $upd_data['deadline_to'] = date("Y-m-d", strtotime($date_to));
                $upd_data['updated_on'] = date ( 'Y-m-d H:i:s' );
                $upd_data['updated_by'] = $this->user_id;
                $upd_data['payment_status'] = $payment_status;
                $this->db->where('request_id',$request_id);
                $this->db->update ( DB_PREFIX .'client_request', $upd_data );
                $inslog_data['action']='Assigned to operator';
                $inslog_data['updated_by'] = $this->user_id;
                $inslog_data['updated_on'] = date ( 'Y-m-d H:i:s' );
                $this->db->where('request_id',$request_id);
                $this->db->update ( DB_PREFIX .'loghistory', $inslog_data );
                }
                }
                redirect ( base_url($this->dadmin_dadminsearch), 'refresh' );
            }
            else{
                redirect($this->dadmin_dadminsearch);
            }
        }
         /*******************************
       * p_newrevert_bulk function
       * p_newrevert_bulk
        *******************************/
        function p_newrevert_bulk()
        {
            if(empty($_POST['request_id'])){
                redirect($this->dadmin_dadminsearch);
            }
            $postData=$_POST;
            if($postData)
            {
                $assignee_id = $this->input->post ( 'assignee_id' );
                $date_from = date('Y-m-d');
                $date_to = $this->input->post ( 'date_to' );
                foreach($postData['request_id'] as $key=>$request_id) {
                if($assignee_id){ 
                $upd_data = array();
                $upd_data['assignee_id'] = $assignee_id;
                $upd_data['assainee_status']= 0;
                $upd_data['revert_status']= 2;
                $upd_data['deadline_from'] = date("Y-m-d");
                $upd_data['deadline_to'] = date("Y-m-d", strtotime($date_to));
                $upd_data['updated_on'] = date ( 'Y-m-d H:i:s' );
                $upd_data['updated_by'] = $this->user_id;
                $this->db->where('request_id',$request_id);
                $this->db->update ( DB_PREFIX .'client_request', $upd_data );
                $upd_datas['revert_option_status']= 0;
                $this->db->where('request_id',$request_id);
                $this->db->update ( DB_PREFIX .'submit_cv', $upd_datas );
                }
                }
                redirect ( base_url('Dadmin/allotmentlist'), 'refresh' );
            }
            else{
                redirect($this->dadmin_dadminsearch);
            }
        }
         /*******************************
       *  allotmentlist function
       * allotmentlist
        *******************************/
        function allotmentlist() {
            $assignee_list = $this->dm->get_revert_list(); 
            $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list,array('assignee_id','name'));
            $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
            $this->breadcrumbs->push('Allotment List', 'Dadmin/allotmentlist');
            $data['breadcrumb']=$this->breadcrumbs->show();  
            $this->amodel->pagerender($data, 'user_allotmentlist');
        }
        /*******************************
       *  get_alottedlist function
       * get_alottedlist
        *******************************/
        function get_alottedlist($office_id=0){ 
            $model = array(self::$dadmin_model=>'get_allotted_list');
            $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
            $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
            $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
            $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
            $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
            $a_revert= ($_REQUEST['revert_status']) ? $_REQUEST['revert_status'] : '';
            $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
            $order_no=($_REQUEST['order_no']) ? $_REQUEST['order_no'] : '';
            $case_no=($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
            $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
            $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
            $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
            $case_type = ($_REQUEST['a_type']) ? $_REQUEST['a_type'] : '';
            $date_filter = ($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
            $billing_type = ($_REQUEST['billing_type']) ? $_REQUEST['billing_type'] : '';
            $payment_status = ($_REQUEST['payment_status']) ? $_REQUEST['payment_status'] : '';

            if($office){
                $condition[]=" b.id = ".$office;
            }
            if($org_id){
                $condition[]=" c.id = ".$org_id;
            }
            if($parent_office){
                $condition[]=" d.id = ".$parent_office;
            }
            if($name){
                $condition[]=" a.candidate_name like '%".$name."%'";
            }
            if($sub_office){
                $condition[]=" a.sub_office = ".$sub_office;
            }
            if($a_status==1){
                $condition[]=" cv.operator_status = 1  and cv.vm_revert_option_status=0";
            }
            if($a_status==2){
                $condition[]=" (a.entry_status !=1 and cv.operator_status != 1) ";
            }
            if($a_status== 3){
                $condition[]=" ((a.revert_status in (1,3) and cv.vm_revert_option_status in (1,3)) or (a.revert_status in (1,3) and cv.operator_status != 1 and a.entry_status=1 and (cv.candidate_status =1 and a.revert_status=3 ) )) ";
            }
            if($a_status== 4){
                $condition[]="((cv.operator_status=1 and cv.vm_revert_option_status=3 ) || (a.revert_status=1 and a.assainee_status=1 and a.revert_status!=1 and cv.operator_status !=1 and a.entry_status=1))";
            }
            if($a_revert==1){
                $condition[]=" cv.revert_option_status =1";
            }
            if($order_no){
                $condition[]=" e.order_name like '%".$order_no."%'";
            }
            //22/01/2023
            $case_no = trim($case_no);
            if($case_no){
                $condition[]=" a.case_no like '%".$case_no."'";
            }
            if($case_type !=0 && $case_type !=4 ){
                $condition[]=" a.dataentry_by = ".$case_type;
            }
            if($case_type ==4){
                $condition[]=" a.dataentry_by = 0";
            }
            if(!empty($c_date) && $date_filter==1){
                $condition[]="DATE_FORMAT(a.deadline_from ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
            }
            if(!empty($t_date) && $date_filter==1){
                $condition[]="DATE_FORMAT(a.deadline_from ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
            }
            if(!empty($c_date) && $date_filter==2){
                $condition[]="DATE_FORMAT(a.deadline_to ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
            }
            if(!empty($t_date) && $date_filter==2){
                $condition[]="DATE_FORMAT(a.deadline_to ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
            }
            if(!empty($c_date) && $date_filter==3){
                $condition[]="DATE_FORMAT(cv.operator_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
            }
            if(!empty($t_date) && $date_filter==3){
                $condition[]="DATE_FORMAT(cv.operator_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
            }
            if($billing_type==1){
                $condition[]=" a.case_no like '%PR%'";
            }
            if($billing_type==2){
                $condition[]=" a.case_no like '%PO%'";
            }
             if($payment_status){
                $condition[]=" mr.id =" . $payment_status;
            }
            if($term)
            {
                //support multiple words
                $search = explode(' ', $term);

                foreach($search as $t) {
                    $not        = '';
                    $operator    = 'OR';
                    if(substr($t,0,1) == '-')
                    {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t,1,strlen($t));
                    }

                    $like    = '';
                    $like    .= "( a.candidate_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." c.org_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." b.office_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." d.parent ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." d.office_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." e.order_name ".$not."LIKE '%".$t."%' " ;
                    
                    $like    .= $operator." a.assainee_status ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." f.first_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." c.dedicated_operator ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." a.case_no ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' ) " ;
                    $condition[]=$like;
            }
        }

        $manual_cond=implode(' and ',(array) $condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];  
        $result = $results[1]; 
        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows;
        foreach ( $result as $i => $row ) {
        $assignstatus=$this->dm->getassignstatus($row['request_id']);
        if($assignstatus){
        $assignstat=anchor('/Dadmin/deo_assignee/'.base64_encode($row['request_id']),'Reassign');
        }else{
        $assignstat='Not Yet Assign';
        }    
        if($row['parent']==0){
        $officevalue=$row['parent_office'];
        $branchofficevalue=$row['office_name'];
        }
        $deadline_from = ($row['deadline_from']) ? date('d-m-Y',strtotime($row['deadline_from'])) : '';
         $deadline_to = ($row['deadline_to']) ? date('d-m-Y',strtotime($row['deadline_to'])) : '';
         $operator_submit_date = ($row['operator_submit_date']) ? date('d-m-Y',strtotime($row['operator_submit_date'])) : '';
        if($this->session->userdata['role_id']==3 || $this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==2){
            $additional_doc=anchor('/Dadmin/upload_document/'.base64_encode($row['request_id']),'Add');
        }
        $casetype='';
        if($row['dataentry_by']==1){
            $casetype='Partial Entry';
        }
        else if($row['dataentry_by']==2)
        {
            $casetype='Full Entry';
        }
        else if($row['dataentry_by']==3)
        {
            $casetype='Offline Entry';
        }
        else
        {
            $casetype='Candidate Entry';
        }
        $pay_sattus =   $row['payment_status'];
         $role=$this->session->userdata('role_id');
             if($pay_sattus == 948  && ($role == 1 || $role == 3))
             {
              $changestatus = anchor('/Dadmin/payment_verification/'.base64_encode($row['request_id']),'payment status'); 
             }
             else
             {
              $changestatus = '';  
             }
        if($row['final_report'] != 1) {
          $modify_office=anchor('/Dsupervisor/cand_office/'.base64_encode($row['request_id']),'Modify_office');  
        }
            if($row['entry_status']!=1 ) {
            $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$officevalue,$branchofficevalue,$row['sub_office'], anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']), $row['case_no'],$row['client_ref_number'],$row['order_name'],$casetype,$row['assignee'],'New',      $row['pay_status'],'New',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
                
                }else {
               $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$officevalue,$branchofficevalue,$row['sub_office'], anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'],   $row['client_ref_number'],$row['order_name'],$casetype,$row['assignee'],'Completed',$row['pay_status'],'DEC',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
               
                }
              if($row['revert_status']==1 && $row['assainee_status']==1){
            $checks=$i+$count+1;
             $checks='<input type="checkbox" name="request_id[]" value="'.($row['request_id']).'" />';
             $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'], $row['client_ref_number'],$row['order_name'],$casetype,$row['assignee'],'Revert Rectified',$row['pay_status'],'Rectified',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
            }
            if($row['revert_status']==0 && $row['assainee_status']==1 && !empty($row['service']) && !empty($row['reason'])){
            $checks=$i+$count+1;
             $checks='<input type="checkbox" name="request_id[]" value="'.($row['request_id']).'" />';
             $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'], $row['client_ref_number'] ,$row['order_name'],$casetype,$row['assignee'],'Revert Rectified',$row['pay_status'],'Rectified',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
            }
            else if($row['revert_status']==1){
            $checks=$i+$count+1;
             $checks='<input type="checkbox" name="request_id[]" value="'.($row['request_id']).'" />';
             $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'], $row['client_ref_number'] ,$row['order_name'],$casetype,$row['assignee'],'Revert Assigned',$row['pay_status'],'Revert',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
            }
             else if($row['revert_status']==3 && $row['assainee_status']==1 && $row['candidate_status']==1){
             $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'], $row['client_ref_number'] ,$row['order_name'],$casetype,$row['assignee'],'Revert',$row['pay_status'],'Revert Assigned',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
            }
            else if($row['revert_status']==2){
             $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'], $row['client_ref_number'] , $row['client_ref_number'],$row['order_name'],$casetype,$row['assignee'],'Revert',$row['pay_status'],'Revert Raised',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
            }
            else if($row['revert_status']==3 && $row['assainee_status']!=1){
             $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'],$row['client_ref_number'] ,$row['order_name'],$casetype,$row['assignee'],'Revert Assigned',$row['pay_status'],'Revert',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
            }
           if($row['operator_status']==1 && $row['vm_revert_option_status']==3 ) {
                $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'], $row['client_ref_number'],$row['order_name'],$casetype,$row['assignee'],'Revert Rectified',$row['pay_status'],'Rectified',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
                } 
                else if($row['operator_status']==1 && $row['vm_revert_option_status']==1){
           $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'],$row['client_ref_number'] ,$row['order_name'],$casetype,$row['assignee'],'Revert Assigned',$row['pay_status'],'Revert',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']).'/'.base64_encode($row['check_id']),'View'),$additional_doc,$assignstat,$modify_office);
            }
        else if($row['operator_status']==1) {
                $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'],$row['client_ref_number'] ,$row['order_name'],$casetype,$row['assignee'],'Completed',$row['pay_status'],'DEC',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
                }
            }
        }
        echo json_encode($response);
        }
        /*******************************
        * candidate_dataentry function
        * candidate_dataentry
        *******************************/
        function candidate_dataentry(){
            if($this->session->userdata['userType'] == 2){
            $candidate_id = $this->session->userdata['userid'];
            $this->db->select('*');
            $cand_result =$this->db->get_where(DB_PREFIX .'client_request',array('user_id'=> $candidate_id ))->row(); 
            $request_id = $cand_result->request_id;
            if($request_id){
                redirect('' . base_url('Dadmin/dadminview/'. base64_encode($request_id)));
            } else {
            echo "You are not authorised";
            }
            } 
        }
        /*******************************
        * dadminview page
        * dadminview
        *******************************/ 
        function dadminview() {   
            $subtitle="DataEntry View";
            
            $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
            $data['check_id'] = $check_id = base64_decode($this->uri->segment(4));
            $url = base_url() . $this->dadmin_dadminsearch;
            $auth_link = array( array('users','search','Search','Meeting/meetingsearch',''),
            array('Candidate','delete','Delete','Management/candidatedelete/'.$this->uri->segment(3),''));
            $data['status']=$this->amodel->getDetails(DB_PREFIX.'submit_cv','status as entry_status,client_status,operator_status,candidate_status,vm_revert_option_status,verification_status,reverted_reason,reverted_by,reverted_reason',array('request_id'=>$request_id));
            $data['status_revert']= $revertstatus =$this->dm->vm_revertstatus($request_id);
                $revert_id =   $revertstatus[0]['service'];
                    $revert_name = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$revert_id ))->row_array();

                 $data['vmrevert_name']  =   $revert_name['name'];
            $data['vm_revert_operator']=$this->amodel->getDetails(DB_PREFIX.'ver_assign_rep','vm_revert_request,vm_revert_to,vm_revert_by',array('candidate_req_id'=>$request_id,'check_id'=>$check_id));
            $data['devices']=$this->dm->all_devices();
            $data['dataentry']=$orderid = $this->db->query("select order_id,candidate_name, deadline_from, deadline_to,dataentry_by,assainee_status,status_of_candidate,o.office_name,b.office_name as branch_office,s.office_name as sub_office ,org_name,revert_status , u.submit_date
            from ". DB_PREFIX ."client_request as c LEFT JOIN ". DB_PREFIX ."office as o ON o.id=c.parent_office
            LEFT JOIN ". DB_PREFIX ."office as b ON b.id=c.office
            LEFT JOIN ". DB_PREFIX ."office as s ON s.id=c.sub_office
            LEFT JOIN ". DB_PREFIX ."organisation as org ON org.id=o.parentoffice_id
            LEFT JOIN ". DB_PREFIX ."user as u ON u.id = c.user_id
            where request_id=". @$request_id)->row(); 
            $now = date('Y-m-d');
            $data['cand_name'] = $orderid->candidate_name;
            $submitstatus=$this->vm->getchkstatus($request_id);
            if($this->session->userdata['user_type'] == 1) { 
                if( ($orderid->deadline_from <= $now && $orderid->deadline_to >= $now ) &&  $orderid->assainee_status == 1  ) { 
                    $data['duration'] = 1; 
                }
            } 
            
            else  if($this->session->userdata['user_type'] == 2 ) { 
                if( ($orderid->dataentry_by == 1 || $orderid->dataentry_by == 2) && $orderid->assainee_status <> 1 ){ 
                    $data['duration'] = 1; 
                }
            }
            $data['duration'] = 1;
            $levels=array();       
            if(isset($orderid->sub_office)){
            $data['candidate_name'] = ($orderid->candidate_name) ? ($orderid->candidate_name.' ( '.$orderid->org_name.', '.$orderid->sub_office.' )') : '';
            }
            elseif(isset($orderid->branch_office)){
               $data['candidate_name'] = ($orderid->candidate_name) ? ($orderid->candidate_name.' ( '.$orderid->org_name.', '.$orderid->branch_office.' )') : ''; 
            }
            else
            {
                $data['candidate_name'] = ($orderid->candidate_name) ? ($orderid->candidate_name.' ( '.$orderid->org_name.', '.$orderid->office_name.' )') : '';
            }
            $data['org_checks'] = $orderid;
            $level_data = $this->dm->getleveldetails($request_id,$check_id);
            $data['level_data'] = $level_data; 
            $data['checklevels']=$checklevels = $this->dm->checklevels($request_id,$check_id);
            foreach($checklevels as $level){
                // if($level['id']>94 && ($level['id']<530 && $level['id']>550)){
                //     $levels[]=$level['description'];
                // }
                // else if($level['id']>94 && ($level['id']<530)){
                //     $levels[]=$level['description'];
                // }
                if($level['id']>1023 && $level['id'] != 1306 ){  //kavya added on 5th april
                    $levels[]=$level['description'];
                }
                else{
                    $levels[]=$level['id'];
                }
                  
            }
            $data['clevels']=$levels;
            $personal_details=$this->dm->personaldetails($request_id);
            //25/11/2023
             if($personal_details[0]['current_stay_flag'] != '')

            if(($personal_details[0]['current_stay_flag'])== '0')
            {
                $personal_details[0]['current_stay_flag']='Yes';
            }
            else
            {
                $personal_details[0]['current_stay_flag']='No';
            }
            $data['personal_details'] = $personal_details;
            $decleration_details = $this->dm->declerationdetails($request_id); 
            $data['decleration_details']=$decleration_details;
            $other_details = $this->dm->otherdetails($request_id);
            $data['other_details'] = $other_details;
            $data_entry_status[] = ($personal_details) ? 0 : 1 ; 
            $data_entry_status[] = ($other_details) ? 0 : 1 ; 
            $data_entry_status[] = ($decleration_details) ? 0 : 1 ; 
            $data_entry_status[] = ($submitstatus==0) ? 0 : 1 ;
            $this->db->where('status',1);
            $this->db->where('request_id',$request_id);
            $partial_coduments=  $this->db->get(DB_PREFIX.'partial_upload_document')->result_array();
            $this->db->where('status',1);
            $this->db->where('req_id',$request_id);
            $this->db->select('upload_file as multipleupload,file_name as document_name');
            $offline_coduments=  $this->db->get(DB_PREFIX.'candidate_upload_files')->result_array();
            $this->db->select('*');
            $deo_upload_doc=$this->db->get_where(DB_PREFIX .'client_request',array
            ('request_id'=> $request_id ))->result_array(); 
            $data['deo_upload_documents']=$deo_upload_doc;
            $data['partial_coduments']=array_merge($partial_coduments,$offline_coduments);
            $data['title']="data_entry";
            $data['subtitle']="view";
            $data['documents'] = $this->dm->documentsup($request_id);
            $data['entry_status']= $data_entry_status;
              $role=$this->session->userdata('role_id');
              if($role <> 16){
                $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
                 $this->breadcrumbs->push('Candidate Details', 'Dadmin/dadminview');
              }
            $data['breadcrumb']=$this->breadcrumbs->show(); 
            $this->amodel->pagerender($data,$data['title'],$data['subtitle']);
        }
         /*******************************
        * submittoclient page
        * submittoclient
        *******************************/ 
        function submittoclient()
        {
            $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
            $data['check_id'] = $check_id = base64_decode($this->uri->segment(4));
            $this->dm->insufficiencyreport($request_id,$check_id); 
            $rolesid=$this->session->userdata('role_id');
            if($rolesid==16){
                $emailforclient=$this->db->query("SELECT a.case_no,a.client_ref_number,a.candidate_name,b.first_name,b.email,c.email as mail FROM dcode_client_request a 
                LEFT JOIN dcode_user b ON b.id=a.created_by and b.status = 1
                LEFT JOIN dcode_user c ON c.id=a.user_id
                WHERE a.request_id=".$request_id)->row_array();
                $this->db->select('a.status,a.service,a.reason');
                $submitcv=$this->db->get_where('dcode_submit_cv a',array
                ('a.request_id'=> $request_id ))->row_array(); 
                $data['hr_name']=$emailforclient['first_name'];
                $data['candidate_name']=$emailforclient['candidate_name'];
                $data['user_id']=$emailforclient['mail'];
                if($submitcv['status']==0 && $submitcv['service']!='' && $submitcv['reason']!=''){
                $this->send_email_common_revert('revertbackground_verification','Revert updated successfully!',$emailforclient['email'],$data);
                }else{
                $this->send_email_common_revert('background_verification','Background Verification form uploaded successfully',$emailforclient['email'],$data);
                }
            }
            $request_id = base64_decode($this->uri->segment(3));
            $this->dm->submitlogadmin($request_id);
            $this->dm->submittoclient($request_id);
        }
         /*******************************
        * submittoclients page
        * submittoclients
        *******************************/ 
        function submittoclients()
        {
            $request_id = base64_decode($this->uri->segment(3));
            $this->dm->submittoclients($request_id);
        }
         /*******************************
        ** reverttoadmin page
        * reverttoadmin
        *******************************/ 
        function reverttoadmin()
        {
            $request_id = base64_decode($this->uri->segment(3));
            $service = $_POST['service'];
            $reason = $_POST['reason'];
            $this->dm->reverttoadmin($request_id,$service,$reason);
            $this->dm->reverttologadmin($request_id);
        }
         /*******************************
       *  supervisor page
       * supervisor
        *******************************/ 
        function supervisor()  {
            $request_id = base64_decode($this->uri->segment(3));
            $this->db->update(DB_PREFIX.'client_request',array('assainee_status'=>2,'entry_status'=>1),array('request_id'=>$request_id));
            $this->db->insert ( DB_PREFIX.'verification_request', array('request_id'=>$request_id,'assignee_status'=>1) );
            redirect('' . base_url( 'Dadmin/dadminview/'.base64_encode( $request_id ) ));
        }
         /*******************************
        * getorderlist page
        * getorderlist
        *******************************/ 
        function getorderlist(){       
                $order_id = $this->uri->segment(3);
                $order_details = $this->cm->orderdetails($order_id);
                $table = "<table>";
                if($order_details){
                $table .= "<tr class='s-usebrd' height='35'><td colspan='4'><h3>Checks and Levels</h3></td></tr>";
                foreach($order_details as $key => $value ) { 
                $table .= "<tr class='s-usebrd' height='35'><td colspan='4'><strong>".ucwords($value['name'])."</strong></td></tr>";
                $check_details = $this->cm->get_order_checks($value['types_of_check'],$order_id);
                $table .= "<tr class='s-usebrd' height='35'>";
                foreach($check_details as $orderkey => $ordervalue){
                        $okey = $orderkey+1;
                        if( ($okey % 5)==0) {
                             $table .= "</tr><tr class='s-usebrd' height='35'>";
                         }
                        $table .= "<td class='s-usetxt'>".ucwords($ordervalue['name'])."</td>";
                }
                $table .= "</td>";
                }
        
                } else {
                $table .= "<tr class='s-usebrd' height='35'><td colspan='4'><strong>No Checks and Levels Available</strong></td></tr>";
                }
                echo $table .= "</table>";
        }
         /*******************************
       *  onlineallotmentlist page
       * onlineallotmentlist
        *******************************/ 
        function onlineallotmentlist()    {
                 $this->amodel->pagerender('', 'user_allotmentlist');
        }
         /*******************************
        * get_online_alottedlist page
        * get_online_alottedlist
        *******************************/ 
        function get_online_alottedlist( $usertype_id = '' ) { 
            $model = array(self::$client_model=>'get_onlineuserlistoffsuper');
            $results = $this->_jqgrid_search($model); 
            $response = $results[0];  
            $result = $results[1];
            if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            foreach ( $result as $i => $row ) {
            if($row['entry_status']!=1){ 
            $response->rows [$i] ['cell'] = array ( $i+$count+1,  anchor('/Dadmin/dadminonlineview/'.base64_encode($row['request_id']),$row['first_name']),"New");
            } else {
            $response->rows [$i] ['cell'] = array ( $i+$count+1, anchor('/Dadmin/dadminonlineview/'.base64_encode($row['request_id']),$row['first_name']),"Completed");
            }
            }
            }
            echo json_encode($response);
        }
         /*******************************
       *  dadminonlineview page
       * dadminonlineview
        *******************************/ 
        function dadminonlineview()  {
            $subtitle="DataEntry View";
            $request_id = base64_decode($this->uri->segment(3));
            $url = base_url() . $this->dadmin_dadminsearch;
            $auth_link = array(array('users','search','Search','Meeting/meetingsearch',''),
            array('users','delete','Delete','Meeting/meetingdelete/'.$this->uri->segment(3),''));
            $data['status']=$this->dm->getstatus($request_id);
            $this->db->select('order_id');
            $orderid=$this->db->get_where(DB_PREFIX .'client_request',array('request_id'=> $request_id ))->result_array(); 
            $data['org_checks'] = $orderid;
            $level_data = $this->dm->getleveldetails($request_id);
            $data['level_data'] = $level_data; 
            foreach($level_data as $ld)
            {
                if($ld['check_name']=='Education')
                {
                $level_details = $this->dm->leveldetails($ld['check_level_id']);
                $data['level_details'] = $level_details;
                }
                else if($ld['check_name']=='Address')
                {
                $contact_details=$this->dm->contactdetails($ld['check_level_id']);
                $data['contact_details'] = $contact_details;
                }
            }
            $personal_details=$this->dm->personaldetails($request_id);
            $data['personal_details'] = $personal_details;
            $decleration_details=$this->dm->declerationdetails($request_id);
            $data['decleration_details']=$decleration_details;
            $other_details=$this->dm->otherdetails($request_id);
            $data['other_details']=$other_details;
            $data['title']="data_entry";
            $data['subtitle']="view";
            $this->amodel->pagerender($data,$data['title'],$data['subtitle']);
        }
         /*******************************
       *  insertcloneDetails page
       *  insertcloneDetails
        *******************************/ 
        function insertcloneDetails($clonecount=0,$insertValue = '',$marketId = '',$tablename = '',$editId = '',$fId = '')
        {
            if($editId != 0)
            {
                $marketId = $editId;
            }
            $insertsales = array();
            $bulksave = array();
            if($clonecount != 0) {
            for($i=1;$i<=$clonecount;$i++) { 
            $j = $i;
            if($i == 1)
            {
            $j = '';
            }
            foreach($insertValue as $value) {
            switch($value)
            {
            case 'upload_file':
            //upload files
            $config['allowed_types'] = 'doc|pdf|zip|jpg|png|jpeg';                               
            $config['upload_path'] = 'uploads/candidate/files/';
            $config['encrypt_name'] = true;
            $config['remove_spaces'] = true;        
            $this->load->library('upload', $config);
            if (!empty($_FILES['upload_file'.$j.$j]['name'])) { 
            $uploadfilename = $config['file_name'] = md5($_FILES['upload_file'.$j.$j]['name'].date('Y-m-d H:i:s'));
            $this->upload->initialize($config);
            if ($this->upload->do_upload('upload_file'.$j.$j)) {    
            $upload_data = $this->upload->data();
            $image['original']=$config['upload_path'].''.$upload_data['file_name'];    
            $config['source_image']= getcwd().'/uploads/candidate/files/'.$upload_data['file_name'];
            $insertsales[$value] = $image['original'];
            }
            }
            break;
            default:
            $insertsales[$value] = $_POST[$value.$j];
            break;
            }
            }
            $insertsales[$fId] = $marketId;
            $insertsales['status'] = 1 ;
            $bulksave[] = $insertsales;
            }
            $this->db->insert_batch($tablename,$bulksave);
            }
            return 1;
        }
         /*******************************
       *  insertcloneDetails page
       * insertnewrequestcloneDetails
        *******************************/ 
        function insertnewrequestcloneDetails($clonecount=0,$insertValue = '',$marketId = '',$tablename = '',$editId = '',$fId = '')
        {
            if($editId != 0)
            {
                $marketId = $editId;
            }
            $insertsales = array();
            $bulksave = array();
            if($clonecount != 0) {
            for($i=1;$i<=$clonecount;$i++) { 
            $j = $i;
            if($i == 1)
            {
            $j = '';
            }
            foreach($insertValue as $value) {
            switch($value)
            {
            case 'upload_file':
            $config['allowed_types'] = 'doc|pdf|zip|jpg|png';
            $config['upload_path'] = 'uploads/candidate/files/';
            $config['encrypt_name'] = true;
            $config['remove_spaces'] = true;        
            $this->load->library('upload', $config);
            if (!empty($_FILES['upload_file'.$j.$j]['name'])) {  
            $uploadfilename = $config['file_name'] = md5($_FILES['upload_file'.$j.$j]['name'].date('Y-m-d H:i:s'));
            $this->upload->initialize($config);
            if ($this->upload->do_upload('upload_file'.$j.$j)) {    
            $upload_data = $this->upload->data();
            $image['original']=$config['upload_path'].''.$upload_data['file_name'];    
            $config['source_image']= getcwd().'/uploads/candidate/files/'.$upload_data['file_name'];
            $insertsales[$value] = $image['original'];
            }
            }
            break;
            default:
            $insertsales[$value] = $_POST[$value.$j];
            break;
            }
            }
            $insertsales[$fId] = $marketId;
            $insertsales['status'] = 1 ;
            $bulksave[] = $insertsales;
            }
            $this->db->insert_batch($tablename,$bulksave);
            }
            return 1;
        } 
         /*******************************
       *  insertcloneDetails page
       * insertclonecadaminrevertDetails
        *******************************/ 
        function insertclonecadaminrevertDetails($clonecount=0,$insertValue = '',$marketId = '',$tablename = '',$editId = '',$fId = '')
        {
            if($editId != 0)
            {
            $marketId = $editId;
            }
            $insertsales = array();
            $bulksave = array();
            if($clonecount != 0) {
            for($i=1;$i<=$clonecount;$i++) { 
            $j = $i;
            if($i == 1)
            {
            $j = '';
            }
            foreach($insertValue as $value) {
            switch($value)
            {
            case 'multipleupload':
            $config['allowed_types'] = 'doc|pdf|zip|jpg|png|jpeg';                               
            $config['upload_path'] = 'uploads/candidate/files/';
            $config['encrypt_name'] = true;
            $config['remove_spaces'] = true;        
            $this->load->library('upload', $config);
            if (!empty($_FILES['upload_file'.$j.$j]['name'])) {  
            $uploadfilename = $config['file_name'] = md5($_FILES['upload_file'.$j.$j]['name'].date('Y-m-d H:i:s'));
            $this->upload->initialize($config);
            if ($this->upload->do_upload('upload_file'.$j.$j)) {    
            $upload_data = $this->upload->data();
            $image['original']=$config['upload_path'].''.$upload_data['file_name'];    
            $config['source_image']= getcwd().'/uploads/candidate/files/'.$upload_data['file_name'];
            $insertsales[$value] = $image['original'];
            }
            }
            break;
            default:
            $insertsales[$value] = $_POST[$value.$j];
            break;
            }
            }
            $insertsales[$fId] = $marketId;
            $insertsales['status'] = 1 ;
            $bulksave[] = $insertsales;
            }
            $this->db->insert_batch($tablename,$bulksave);
            }
            return 1;
        }
         /*******************************
       *  insertcloneDetails page
       * insertclonerevertDetails
        *******************************/ 
        function insertclonerevertDetails($clonecount=0,$insertValue = '',$marketId = '',$tablename = '',$editId = '',$fId = '')
        {
            if($editId != 0)
            {
                $marketId = $editId;
            }
            $insertsales = array();
            $bulksave = array();
            if($clonecount != 0) {
                for($i=1;$i<=$clonecount;$i++) { 
                $j = $i;
                if($i == 1)
                {
                    $j = '';
                }
                foreach($insertValue as $value) {
                switch($value)
                {
                case 'upload_file':
                $config['allowed_types'] = 'doc|pdf|zip|jpg|png';                               
                $config['upload_path'] = 'uploads/candidate/files/';
                $config['encrypt_name'] = true;
                $config['remove_spaces'] = true;        
                $this->load->library('upload', $config);
                if (!empty($_FILES['upload_file'.$j.$j]['name'])) {  
                $uploadfilename = $config['file_name'] = md5($_FILES['upload_file'.$j.$j]['name'].date('Y-m-d H:i:s'));
                $this->upload->initialize($config);
                if ($this->upload->do_upload('upload_file'.$j.$j)) {    
                $upload_data = $this->upload->data();
                $image['original']=$config['upload_path'].''.$upload_data['file_name'];    
                $config['source_image']= getcwd().'/uploads/candidate/files/'.$upload_data['file_name'];
                $insertsales[$value] = $image['original'];
                }
                }
                break;
                default:
                $insertsales[$value] = $_POST[$value.$j];
                break;
                }
                }
                $insertsales[$fId] = $marketId;
                $insertsales['status'] = 1 ;
                $bulksave[] = $insertsales;
                }
                $this->db->insert_batch($tablename,$bulksave);
            }
            return 1;
        }
        /*******************************
        * verifedsubmit page
        * verifedsubmit
        *******************************/ 
        function verifedsubmit()
        {
            $request_id = base64_decode($this->uri->segment(3));
            $save['request_id']=$request_id;
            $save['client_verified']=1;
            $save['client_status']=1;
            $save['operator_status']=1;
            $save['client_submit_date']=date('Y-m-d H:i:s');
            $save['client_submited_by']=$this->session->userdata('userid');
            $this->db->where('request_id',$request_id);
            $this->db->select('dataentry_by,status_of_candidate');
            $result= $this->db->get(DB_PREFIX ."client_request")->row_array();
            if($result['dataentry_by']==0)
            {
                $save['operator_status']=1;
                $save['vm_revert_option_status']= 4;
                if($this->session->userdata('role_id')==2){
                $save['operator_submit_date']=date('Y-m-d H:i:s');
                $save['operator_submited_by']=$this->session->userdata('userid');
                }
            }
            $this->dm->submittodcode($save);
            $inslog_data['action']='Allotted to DES';
            $inslog_data['updated_by'] = $this->session->userdata('userid');
            $inslog_data['updated_on'] = date ( 'Y-m-d H:i:s' );
            $this->db->where('request_id',$request_id);
            $this->db->update( DB_PREFIX .'loghistory', $inslog_data );
            redirect('Dadmin/dadminview/'.base64_encode($request_id));        
        }
        /*******************************
       * submit page
       * submit
        *******************************/ 
        function submit()
        {
            $request_id = base64_decode($this->uri->segment(3));
            $save['request_id']=$request_id;
            $save['client_verified']=0;
            $save['client_status']=1;
            $save['client_submit_date']=date('Y-m-d H:i:s');
            $save['client_submited_by']=$this->session->userdata('userid');
            $this->db->where('request_id',$request_id);
            $this->db->select('dataentry_by,status_of_candidate');
            $result= $this->db->get(DB_PREFIX ."client_request")->row_array();
            $save['reverted_by']=0;
            if($result['dataentry_by']==0)
            {
                if($this->session->userdata('role_id')==2){
                $save['operator_status']=1;    
                $save['operator_submit_date']=date('Y-m-d H:i:s');
                $save['operator_submited_by']=$this->session->userdata('userid');
                }
            }
            $this->dm->submittodcode($save);
            $inslog_data['action']='Allotted to DES';
            $inslog_data['updated_by'] = $this->session->userdata('userid');
            $inslog_data['updated_on'] = date ( 'Y-m-d H:i:s' );
            $this->db->where('request_id',$request_id);
            $this->db->update( DB_PREFIX .'loghistory', $inslog_data );
            echo "<script>alert('Case submitted successfully to Dcode');</script>"; 
             redirect ( base_url('Dadmin/dadminview/'. $this->uri->segment(3)), 'refresh' );   
        }
        /*******************************
        * submitcandi page
        * submitcandi
        *******************************/ 
        function submitcandi(){
            $request_id = base64_decode($this->uri->segment(3));
            $save['request_id']=$request_id;
            $save['client_verified']=0;
            $save['client_status']=1;
            $save['client_submit_date']=date('Y-m-d H:i:s');
            $save['client_submited_by']=$this->session->userdata('userid');
            $this->db->where('request_id',$request_id);
            $this->db->select('dataentry_by,status_of_candidate');
            $result= $this->db->get(DB_PREFIX ."client_request")->row_array();
            if($result['dataentry_by']==0)
            {
                $save['operator_status']=2;
                if($this->session->userdata('role_id')==2){
                $save['operator_submit_date']=date('Y-m-d H:i:s');
                $save['operator_submited_by']=$this->session->userdata('userid');
                }
            }
            $this->dm->submittodcode($save);
            $inslog_data['action']='Allotted to DES';
            $inslog_data['updated_by'] = $this->session->userdata('userid');
            $inslog_data['updated_on'] = date ( 'Y-m-d H:i:s' );
            $this->db->where('request_id',$request_id);
            $this->db->update( DB_PREFIX .'loghistory', $inslog_data );
            redirect('Dadmin/dadminview/'.base64_encode($request_id));
        }
        /*******************************
       *  checklist page
       * checklist
        *******************************/ 
        function checklist()
        {
                $data['checklists']=array('education','employment','address','personaldetails','otherdetails','declaration');
                  $data['education']=$this->dm->get_checklist('Education','education_details');
                $data['employment']=$this->dm->get_checklist('Employment','employment','req_id');
                $data['address']=$this->dm->get_checklist('Address','contact_details');
                $data['personaldetails']=$this->dm->get_checklist('','personal_details','user_id');
                $data['otherdetails']=$this->dm->get_checklist('','other_details','user_id');
                $data['declaration']=$this->dm->get_checklist('','declaration_details','user_id');
                $data['assignee']=$this->dm->get_assignee();
                $this->amodel->pagerender($data, 'checklist_allotment');
        }
        /*******************************
        * savechecklist page
        * savechecklist
        *******************************/ 
        function savechecklist()
        {
            $datas=$_POST;
            $save_batch=array();
            $cnt=0;
            $save=array();
            foreach($datas['user_id'] as $key=>$data)
            {
                $this->db->where('user_id',$data);
                $this->db->where('request_id',$datas['request_id'][$cnt]);
                $this->db->where('check_id',$datas['check_id'][$cnt]);
                $this->db->delete(DB_PREFIX.'checklist_assignee');
                $save['user_id']=$data;
                $save['request_id']=$datas['request_id'][$cnt];
                $save['check_id']=$datas['check_id'][$cnt];
                $save['assignee_id']=$datas['assignee'][$cnt];
                $save['assignee_status']=1;
                $save['assigned_date']=date('Y-m-d H:i:s');
                $save['assigned_by']=$this->session->userdata('userid');
                $save_batch[]=$save;
            }
            $this->db->insert_batch(DB_PREFIX.'checklist_assignee',$save_batch);
           redirect('Dadmin/checklist');
        }
        /*******************************
        * submittodes page
        * submittodes
        *******************************/ 
        function submittodes()
        { 

          $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
           $data['check_id'] = $check_id = base64_decode($this->uri->segment(4));

             $this->db->trans_begin();
       if($this->session->userdata('role_id')==2) {

            $chk_details=$this->db->query("select a.check_id,m.name as chkname from dcode_request_check a join dcode_master_masterdata m ON a.check_id=m.id where a.request_id=".$request_id)->result_array();
             //print_r($chk_details); exit;
            foreach ($chk_details as $ckey => $check) {
                # code...
                    $slug=url_title(convert_accented_characters($check['chkname']), 'underscore', TRUE); 

                     switch($check['check_id'])
                     { 
                            case 14: 
                            $levels=$this->dm->getchkcounts($request_id,'education_details','request_id',$check['check_id']);
                            break;
                            case 15:
                            $levels=$this->dm->getchkcounts($request_id,'permanent_contact_details','request_id',$check['check_id']);
                            break;
                            case 16:
                            $levels=$this->dm->getchkcounts($request_id,'contact_details','request_id',$check['check_id']);
                            break;
                            case 59:
                            $levels=$this->dm->getchkcounts($request_id,'employment','req_id',$check['check_id']); 
                            break;
                            default:

                            $levels=$this->dm->getchkcounts($request_id,$slug,'request_id',$check['check_id']);

                     } 

                }  
            } 



            $this->dm->insufficiencyreport($request_id,$check_id);


                 $this->load->library('Upload');
                 if( !empty($_FILES['details']['name'])) { 
                    $i=0;
                          $temp = array();
                         foreach ($_FILES["details"]["name"] as $key => $error) {
                       $tmp_name =$_FILES["details"]["tmp_name"][$key];
                          $name = $_FILES["details"]["name"][$key];
                          $px = $name;
                          $px = preg_replace('/\s+/','_', $px);
                          $px = str_replace('&', 'and', $px);
                          $target = './uploads/candidate/document/';                              
                          $u = $target . $px;
                          move_uploaded_file($tmp_name, $u);
                          $temp[] = $px;
                          $i++;  
                          }

} $x = implode($temp,",");
$this->db->update(DB_PREFIX . "client_request", array('deo_uploaded_doc' => $x), array('request_id' => $request_id));

                $save['request_id']=$request_id;
                $save['operator_status']=1;
                $save['candidate_status']=1;
                $save['verification_status']=0;
                $save['operator_submit_date']=date('Y-m-d H:i:s');
                $save['operator_submited_by']=$this->session->userdata('userid');
                $save['deo_status']=$_POST['deo_status'];
                $save['deo_remarks']=$_POST['deo_remarks'];
                $this->dm->submittodcode($save);
               $savelog['request_id']=$request_id;
                $savelog['updated_on']=date('Y-m-d H:i:s');
                $savelog['action']='Data Entry Completed';
                $savelog['updated_by']=$this->session->userdata('userid');
                $this->dm->submittolog($savelog);
                if ($this->db->trans_status() === FALSE)
                {
                $this->db->trans_rollback();
                }
                else
                {
                $this->db->trans_commit();
                }
                redirect('Dadmin/dadminview/'.base64_encode($request_id));
        }
        /*******************************
        * revertcadminsubmittodes page
        * revertcadminsubmittodes
        *******************************/ 
        function revertcadminsubmittodes()
        {
            $request_id = base64_decode($this->uri->segment(3));
            $this->load->library('Upload');
            if( !empty($_FILES['details']['name'])) { 
            $i=0;
            $temp = array();
            foreach ($_FILES["details"]["name"] as $key => $error) {
            $tmp_name =$_FILES["details"]["tmp_name"][$key];
            $name = $_FILES["details"]["name"][$key];
            $px = $name;
            $px = preg_replace('/\s+/','_', $px);
            $px = str_replace('&', 'and', $px);
            $target = './uploads/candidate/document/';                              
            $u = $target . $px;
            move_uploaded_file($tmp_name, $u);
            $temp[] = $px;
            $i++;  
            }
            } 
            $x = implode($temp,",");
            $this->db->update(DB_PREFIX . "client_request", array('deo_uploaded_doc' => $x), array('request_id' => $request_id));
            $save['request_id']=$request_id;
            $save['operator_status']=1;
            $save['verification_status']=0;
            $save['vm_revert_option_status']=4;
            $save['operator_submit_date']=date('Y-m-d H:i:s');
            $save['operator_submited_by']=$this->session->userdata('userid');
            $this->dm->submittodcode($save);
            $savelog['request_id']=$request_id;
            $savelog['updated_on']=date('Y-m-d H:i:s');
            $savelog['action']='Data Entry Completed';
            $savelog['updated_by']=$this->session->userdata('userid');
            $this->dm->submittolog($savelog);
            redirect('Dadmin/dadminview/'.base64_encode($request_id));
        }
        /*******************************
        * revertsubmittodes page
        * revertsubmittodes
        *******************************/ 
        function revertsubmittodes()
        {
            $request_id = base64_decode($this->uri->segment(3));
            $check_id = base64_decode($this->uri->segment(4));
            $level_id = base64_decode($this->uri->segment(5));
            $save['request_id']=$request_id;
            $save['operator_status']=1;
            $save['verification_status']=1;
            $save['vm_revert_option_status']=3;
          //  $save['operator_submit_date']=date('Y-m-d H:i:s');
            $save['operator_submited_by']=$this->session->userdata('userid');
            $this->dm->submittodcode($save);
            $savelog['request_id']=$request_id;
            $savelog['updated_on']=date('Y-m-d H:i:s');
            $savelog['action']='Data Entry Completed';
            $savelog['updated_by']=$this->session->userdata('userid');
            $this->dm->submittolog($savelog);
            redirect('Dadmin/dadminview/'.base64_encode($request_id));
        }
        /*******************************
       *  revertadminsubmittodes page
       * revertadminsubmittodes
        *******************************/ 
        function revertadminsubmittodes()
        {
            $request_id = base64_decode($this->uri->segment(3));
            $saveadmin['request_id']=$request_id;
            $saveadmin['revert_status']=0;
            $saveadmin['assainee_status']=1;
            $saveadmin['updated_on']=date('Y-m-d H:i:s');
            $saveadmin['updated_by']=$this->session->userdata('userid');
            $this->dm->adminsubmittodes($saveadmin);
            redirect('Dadmin/dadminview/'.base64_encode($request_id));
        }
        /*******************************
        * submitrevert page
        * submitrevert
        *******************************/ 
        function submitrevert()
        {
            $request_id = base64_decode($this->uri->segment(3));
            $saves['request_id']=$request_id;
            $saves['assainee_status']=0;
            $saves['revert_status']=1;
            $saves['entry_status']=1;
            $saves['created_on']=date('Y-m-d H:i:s');
            $saves['updated_by']=$this->session->userdata('userid');
            $service = $_POST['service'];
            $reason = $_POST['reason'];
            $this->dm->submittorevert($saves,$service,$reason);
            $saves_req['request_id']=$request_id;
            $saves_req['assignee_status']=1;
            $saves_req['deadline_from']=date('Y-m-d');
            $saves_req['deadline_to']=date('Y-m-d');
            $this->dm->submittorevertrequest($saves_req);
            $save_submit['request_id']=$request_id;
            $save_submit['client_status']=1;
            $this->dm->submittorevertdcode($save_submit);
            $savelog['request_id']=$request_id;
            $savelog['updated_on']=date('Y-m-d H:i:s');
            $savelog['action']='Data Entry Reverted';
            $savelog['updated_by']=$this->session->userdata('userid');
            $this->dm->submittolog($savelog);
            redirect('Dadmin/allotmentlist');
        }
        /*******************************
        * submitpartialrevert page
        * submitpartialrevert
        *******************************/ 
        function submitpartialrevert(){
            $request_id = base64_decode($this->uri->segment(3));
            $saves['request_id']=$request_id;
            $saves['assainee_status']=0;
            $saves['revert_status']=1;
            $saves['entry_status']=1;
            $saves['created_on']=date('Y-m-d H:i:s');
            $saves['updated_by']=$this->session->userdata('userid');
            $service = $_POST['service'];
            $reason = $_POST['reason'];
            $this->dm->submittorevert($saves,$service,$reason);
            $saves_req['request_id']=$request_id;
            $saves_req['assignee_status']=1;
            $saves_req['deadline_from']=date('Y-m-d');
            $saves_req['deadline_to']=date('Y-m-d');
            $this->dm->submittorevertrequest($saves_req);
            $save_submit['request_id']=$request_id;
            $save_submit['client_status']=1;
            $this->dm->submittorevertdcode($save_submit);
            $savelog['request_id']=$request_id;
            $savelog['updated_on']=date('Y-m-d H:i:s');
            $savelog['action']='Data Entry Reverted';
            $savelog['updated_by']=$this->session->userdata('userid');
            $this->dm->submittolog($savelog);
            redirect('Dadmin/allotmentlist');
        }
        /*******************************
        * deosubmitrevert page
        * deosubmitrevert
        *******************************/ 
       function deosubmitrevert(){
            $request_id = base64_decode($this->uri->segment(3));
            $email_id = $this->dm->get_contactemail($request_id);
            $savedeo['request_id']=$request_id;
            $savedeo['operator_status']=0;
            $savedeo['operator_submit_date']=date('Y-m-d H:i:s');
            $savedeo['operator_submited_by']=$this->session->userdata('userid');
            $this->dm->submittodcodedeo($savedeo);
            $savesdeo['request_id']=$request_id;
            $savesdeo['assainee_status']=1;
            $savesdeo['revert_status']=3;
            $savesdeo['created_on']=date('Y-m-d H:i:s');
            $savesdeo['updated_by']=$this->session->userdata('userid');
            $service = $_POST['service'];
            $reason = $_POST['reason'];
            $this->dm->submittorevertdeo($savesdeo,$service,$reason);
            foreach($email_id  as $email_order)
                $order_emails[]=$email_order['email']; 
            $this->send_email_common_revert('revert_order','Revert Order',$order_emails[0]);
              redirect('Dadmin/caselisttovs');
        }
        /*******************************
        * caselisttovs page
        * caselisttovs
        *******************************/ 
        function caselisttovs() { 
            $assignee_list = $this->dm->get_assignee_vslist();
            $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list,array('assignee_id','name'));
            $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
            $this->breadcrumbs->push('Case Allotment', 'Dadmin/caselisttovs');
            $data['breadcrumb']=$this->breadcrumbs->show(); 
            $this->amodel->pagerender( $data, 'case_allotment');
        }
        /*******************************
       *  get_verified_users page
       * get_verified_users
        *******************************/ 
       function get_verified_users( $office_id = 0  ){ 
        $model = array('client_model'=>'get_verified_users');
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';    
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';    
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $dataentry = ($_REQUEST['entry']=='') ? '' : $_REQUEST['entry'];
        $a_date = ($_REQUEST['a_date']=='') ? '' : $_REQUEST['a_date'];
        $t_date = ($_REQUEST['t_date']=='') ? '' : $_REQUEST['t_date'];
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $billing_type = ($_REQUEST['billing_type']) ? $_REQUEST['billing_type'] : '';
        $deo_status = ($_REQUEST['deo_status']) ? $_REQUEST['deo_status'] : '';
        if($org_id){
            $condition[]=" c.id = ".$org_id;
        }
        if($parent_office){
            $condition[]=" p.id = ".$parent_office;
        }
        if($office){
            $condition[]=" b.id = ".$office;
        }
        if($name){
            $condition[]=" a.candidate_name like '%".$name."%'";
        }
        if($sub_office){
            $condition[]=" e.sub_office = ".$sub_office;
        }
        if($a_status==1){
            $condition[]=" cv.verification_status =1";
        }
        if($a_status==2){
            $condition[]=" cv.verification_status =0 and cv.reverted_by = 0 and cv.reverted_reason = '' ";
        }
        if($a_status==3){
            $condition[]=" cv.verification_status =0 and cv.reverted_by != 0 and cv.reverted_reason != '' ";
        }
        if($a_status==4){
            $condition[]=" cv.verification_status =0 and cv.reverted_by = 0 and cv.reverted_reason != '' and a.dataentry_by != 3 ";
        }
        if($a_date){
            $condition[]="DATE_FORMAT(a.deadline_to ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($a_date))."'";
        }
        if($t_date){
            $condition[]="DATE_FORMAT(a.deadline_to ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        //22/01/2023
        $case_no = trim($case_no);
        if($case_no){
            $condition[]=" a.case_no like '%".$case_no."'";
        }
        if($dataentry<>''){
            $condition[]=" a.dataentry_by=".$dataentry;
        }
        if($billing_type==1){
            $condition[]=" a.case_no like '%PR%'";
        }
        if($billing_type==2){
            $condition[]=" a.case_no like '%PO%'";
        }
        if($deo_status){
            $condition[]=" cv.deo_status = ".$deo_status;
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];  
        $result = $results[1];
           if ($result) {
           $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            foreach ( $result as $i => $row ) {
              $deadline_to = ($row['deadline_to']) ? date('d-m-Y',strtotime($row['deadline_to'])) : '';
             if($row['verification_status']==1){
                    $request_status=  'Assigned'; 
            }
             else if($row['verification_status']==2){
                    $request_status=  anchor('/Dadmin/v_supervisor/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Partial Entry Requested'); 
            } else if($row['first_name']=='Verification Supervisor'){ 
                     $request_status=  'Assigned';
            } else { 
                    $request_status= anchor('/Dadmin/v_supervisoralort/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'New');
            }
            if($row['dataentry_by']==0){
                $dstatus='Candidate Entry';
            }
            else if($row['dataentry_by']==1){
                $dstatus='Partial Entry';
            }
            else if($row['dataentry_by']==2){
                $dstatus='Full Entry';
            }
            else if($row['dataentry_by']==3){
                $dstatus='Offline Entry';
            }
            else {
                $dstatus='';
            }
            if($row['reverted_by']<>0 && !empty($row['reverted_reason']) && $row['verification_status']==0 && $row['dataentry_by']!=3){
                    $request_status=  'Reject Raised';
                    $check='';
                    $reject_status='Reject Raised';
            }            
            else if($row['reverted_by']==0 && $row['verification_status']==0 && !empty($row['reverted_reason']) && $row['dataentry_by']!=3 ){
                    $request_status=  'Reject Closed';
                    $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id'] ).'" />';
                     $reject_status=(anchor('/Dadmin/v_supervisoralort/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:green'>Accept</span>").' / '.anchor('/Dadmin/srevertcase/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:red'>Revert</span>").' / '.anchor('/Dadmin/rejectcase/'.base64_encode($row['request_id']),"<span style='color:orange'>Reject</span>"));
            }
            else if($row['verification_status']==1){
                $check=$i+$count+1;
                $reject_status='Accepted';
            } 
            else if($dstatus=='Offline Entry'){
                $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id'] ).'" />';
                $reject_status=(anchor('/Dadmin/v_supervisoralort/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:green'>Accept</span>").' / '.anchor('/Dadmin/srevertcase/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:red'>Revert</span>"));
            }
            else if($row['verification_status']==2){
                $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id'] ).'" />';
                $reject_status=(anchor('/Dadmin/v_supervisoralort/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:green'>Accept</span>").'/'.anchor('/Dadmin/srevertcase/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:red'>Revert</span>"));
            }else if($row['verification_status']==3){
                $reject_status= anchor('/Dadmin/srevertcase/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:red'>Revert</span>"); 
            }else if($row['first_name']=='Verification Supervisor'){
                $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id'] ).'" />';
                $reject_status=(anchor('/Dadmin/v_supervisoralort/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:green'>Accept</span>"));
            }
            else{
                $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id'] ).'" />';
                $reject_status=(anchor('/Dadmin/v_supervisoralort/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:green'>Accept</span>").' / '.anchor('/Dadmin/srevertcase/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:red'>Revert</span>").' / '.anchor('/Dadmin/rejectcase/'.base64_encode($row['request_id']),"<span style='color:orange'>Reject</span>"));
            }
            if($row['deo_status']==1){
                $opt_status='Accept';
            }
            elseif($row['deo_status']==2){
                $opt_status='Reject';
            }
            else{
                $opt_status='';
            }
            $response->rows [$i] ['cell'] = array ( $check,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'], anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'],$row['order_name'],$request_status,$opt_status,$row['deo_remarks'],$dstatus,$row['first_name'].' '.$row['last_name'], $deadline_to, $reject_status,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'));
            }
        }
        echo json_encode($response);
    }
    /*******************************
      *  insufficiency page
      * insufficiency
        *******************************/ 
    function insufficiency() { 
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Insufficiency', 'Dadmin/insufficiency');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender( $data, 'case_allotment');
    }
    /*******************************
      *  get_insufficiency page
      * get_insufficiency
        *******************************/ 
    function get_insufficiency( $office_id = 0  ){ 
        $model = array(self::$dadmin_model=>'get_insufficiency_users');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $emp_code = ($_REQUEST['emp_code']=='') ? '' : $_REQUEST['emp_code'];
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
        $case_no = ($_REQUEST['case_no']=='') ? '' : $_REQUEST['case_no'];
        $insufficiency = ($_REQUEST['insufficiency']=='') ? '' : $_REQUEST['insufficiency'];
        $created_on = ($_REQUEST['created_on']) ? $_REQUEST['created_on'] : '';
        $created_to = ($_REQUEST['created_to']) ? $_REQUEST['created_to'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        if($office){
            $condition[]=" b.id = ".$office;
        }
        if($org_id){
            $condition[]=" c.id = ".$org_id;
        }
        if($parent_office){
            $condition[]=" p.id = ".$parent_office;
        }
        if($sub_office){
            $condition[]=" e.sub_office = ".$sub_office;
        }
        if($emp_code){
            $condition[]=" cv.emp_code like '%".$emp_code."%'";
        }
        if($name){
            $condition[]=" a.candidate_name like '%".$name."%'";
        }

        //22/01/2023
        $case_no = trim($case_no);
        if($case_no){
            $condition[]=" a.case_no like '%".$case_no."'";
        }
        if($insufficiency){
            $condition[]=" cv.insufficiency_report like '%".$insufficiency."%'";
        }
        if($created_on){
            $condition[]="DATE_FORMAT(cv.created_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($created_on))."'";
        }
        if($created_to){
            $condition[]="DATE_FORMAT(cv.created_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($created_to))."'";
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];  
        $result = $results[1];
        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows;
        foreach ( $result as $i => $row ) {
        $created_date=date('d-m-Y',strtotime($row['created_date']));
        $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],$row['candidate_name'],$row['case_no'],$row['emp_code'],$row['insufficiency_report'],$created_date);
        }
        }
        echo json_encode($response);
    }
    /*******************************
      *   v_supervisor page
      * v_supervisor
        *******************************/ 
   function v_supervisor()  
    {
        $request_id = base64_decode($this->uri->segment(3));
        $save['request_id']=$request_id;
        $save['verification_status']=1;
        $save['verification_date']=date('Y-m-d H:i:s');
        $save['verification_by']=$this->session->userdata('userid');
        $save['assignee_id']=5;
        $this->dm->submittodcode($save);
        $this->db->update(DB_PREFIX.'client_request',array('assainee_status'=>1,'entry_status'=>1),array('request_id'=>$request_id));
        $this->db->insert ( DB_PREFIX.'verification_request', array('request_id'=>$request_id,'assignee_status'=>1) );
        $inslog_data['action']='Allotted to VS';
        $inslog_data['updated_by'] = $this->session->userdata('userid');
        $inslog_data['updated_on'] = date ( 'Y-m-d H:i:s' );
        $this->db->where ('request_id',$request_id);
        $this->db->update ( DB_PREFIX .'loghistory', $inslog_data );
        redirect('' . base_url( 'Dadmin/caselisttovs/'.base64_encode( $request_id ) ));
    }
    /*******************************
     *   v_supervisorassign page
     * v_supervisorassign
        *******************************/ 
    function v_supervisorassign()  
    {
        $request_id = base64_decode($this->uri->segment(3));
        $save['request_id']=$request_id;
        $save['verification_status']=1;
        $save['verification_date']=date('Y-m-d H:i:s');
        $save['verification_by']=$this->session->userdata('userid');
        $save['assignee_id']=$_POST['assignee_id'];
        $this->dm->submittodcode($save);
        $this->db->update(DB_PREFIX.'client_request',array('assainee_status'=>1,'entry_status'=>1),array('request_id'=>$request_id));
        $this->db->insert ( DB_PREFIX.'verification_request', array('request_id'=>$request_id,'assignee_status'=>1) );
        $inslog_data['action']='Allotted to VS';
        $inslog_data['updated_by'] = $this->session->userdata('userid');
        $inslog_data['updated_on'] = date ( 'Y-m-d H:i:s' );
        $this->db->where ('request_id',$request_id);
        $this->db->update ( DB_PREFIX .'loghistory', $inslog_data );
        redirect('' . base_url( 'Dadmin/caselisttovs/'.base64_encode( $request_id ) ));
    }
    /*******************************
     *   v_supervisor_reject page
     * v_supervisor_reject
        *******************************/ 
    function v_supervisor_reject()  
    {
        $request_id = base64_decode($this->uri->segment(3));
        $save['request_id']=$request_id;
        $save['verification_status']=3;
        $save['operator_status']=0;
        $save['verification_date']=date('Y-m-d H:i:s');
        $save['verification_by']=$this->session->userdata('userid');
        $save['assignee_id']=0;
        $this->dm->submittodcode($save);
        $this->db->update(DB_PREFIX.'client_request',array('assainee_status'=>1,'entry_status'=>1,'revert_status'=>2),array('request_id'=>$request_id));
        $this->db->insert ( DB_PREFIX.'verification_request', array('request_id'=>$request_id,'assignee_status'=>1) );
        redirect('' . base_url( 'Dadmin/caselisttovs/'.base64_encode( $request_id ) ));
    }
    /*******************************
     *   v_supervisor_revert page
     * v_supervisor_revert
        *******************************/ 
    function v_supervisor_revert()  
    {
        $request_id = base64_decode($this->input->post('request_id'));
        $save['request_id']=$request_id;
        $save['operator_status']=0;
        $save['verification_date']=date('Y-m-d H:i:s');
        $save['verification_by']=$this->session->userdata('userid');
        $reason=$this->input->post('reason');
        $this->dm->submittodcode($save);
        $this->db->update(DB_PREFIX.'client_request',array('entry_status'=>1,'revert_status'=>3,'reason'=>$reason),array('request_id'=>$request_id));
        redirect('' . base_url( 'Dadmin/caselisttovs/'.base64_encode( $request_id ) ));
    }
    /*******************************
     *   verificationreq page
     *  verificationreq
        *******************************/ 
    function verificationreq()
    {
        $data['request_id']=$request_id = $this->uri->segment(3);
        $candidate_name=$data['checks_result'] = $this->dm->get_userlistoffsuper(base64_decode($request_id));
        $data['candidate_name']=$candidate_name[0]['candidate_name'];
        $assignee_list = $this->dm->get_assignee_list(9); 
        $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list,array('assignee_id','name'));
        $data ['title'] = 'New Request'; 
        $upload_file_clones = array(array('file_name' => array('text', 'file_name', '', '','', '', ''),'upload_file' => array('upload', 'upload_file', '', '','', '', '')));
        $data['upload_file_clone'] = create_cloneform($upload_file_clones,'', $id);
        $this->amodel->pagerender($data, 'new_request');
    }
    /*******************************
      *   submittorevertoption page
      * submittorevertoption
        *******************************/ 
    function submittorevertoption()
    {
        $request_id = base64_decode($this->uri->segment(3));
        $save_revert['request_id']=$request_id;
        $save_revert['assainee_status']=2;
        $save_revert['assignee_id']=0;
        $save_revert['revert_status']=0;
        $this->dm->submittorevertoption($save_revert);
        $this->db->update(DB_PREFIX.'submit_cv',array('revert_option_status'=>0),array('request_id'=>$request_id));
        redirect('' . base_url( 'Client/clientofflinesearch/'.base64_encode( $request_id ) ));
    }
    /*******************************
      *  upload_document page
      * upload_document
        *******************************/ 
    function upload_document($request_id) {  
        $data['request_id']=$request_id = $this->uri->segment(3);
        $data['req_id']=base64_decode($this->uri->segment(3));
        $result=$data['checks_result'] = $this->dm->get_userlistoffsuper(base64_decode($request_id));
        $data['candidate_name']=$result[0]['candidate_name'];
        $data['partial_coduments']=$partial_coduments=  $this->db->where(array('request_id' => base64_decode($request_id),'status'=>'1'))->get(DB_PREFIX.'partial_upload_document')->result_array();
        $data['candidate_coduments']=$candidate_coduments=  $this->db->where(array('req_id' => base64_decode($request_id),'status'=>'1'))->get(DB_PREFIX.'candidate_upload_files')->result_array();
        $data ['title'] = 'Additional Documents'; 
        if($result[0]['dataentry_by']==3){
        $upload_file_clones = array(array('file_name' => array('text', 'file_name', '', '','', '', ''),'upload_file' => array('upload', 'upload_file', '', '','', '', '')));
        } else {
        $upload_file_clones = array(array('document_name' => array('text', 'document_name', '', '','', '', ''),'upload_file' => array('upload', 'upload_file', '', '','', '', '')));
        }
        $data['upload_file_clone'] = create_cloneform($upload_file_clones,'', $id);
        $data['upload_file'] =formclonecreation($upload_file_clones,$data['upload_file_clone'],1,'Add Upload Files',"Upload Candidate Documents");
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Data Entry', 'Client/clientofflinesearch');
        $this->breadcrumbs->push('New Request', 'Dadmin/newrequest');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'upload_document');
    }
    /*******************************
      *   add_document function
      * add_document
        *******************************/ 
    function  add_document() {
        if($_POST['document_name'] || $_POST['file_name']){
                $user_id = $this->input->post ( 'user_id' );
                $request_id = base64_decode($this->input->post( 'request_id' ));
                /* Edit Document */
                $documents= $this->amodel->getDetails(DB_PREFIX . "candidate_upload_files", array('*'), array('req_id' => $request_id,'status'=>'1'));
                $doc=count($documents);
                $uploaded_docs1=$_POST['upload_file'];
            for($i=0; $i<$doc; $i++) {
            $docse=$documents[$i]['upload_file'];
            if(in_array(trim($documents[$i]['upload_file']), $uploaded_docs1))
            {
                $this->db->set('status',1);
                $this->db->where('upload_file',$docse);
                $this->db->update(DB_PREFIX.'candidate_upload_files');
            }
            else {
                $this->db->set('status',0);
                $this->db->where('upload_file',$docse);
                $this->db->update(DB_PREFIX.'candidate_upload_files');
            }
            }
            /* Edit Document End */
                $upload_files =array('file_name','upload_file');
                $status= $this->insertcloneDetails($_POST['count1'],$upload_files,$return_id,DB_PREFIX.'candidate_upload_files',$request_id,'req_id');
              
    }
    if($_POST['document_name'] || $_POST['file_name']){
            $user_id = $this->input->post ( 'user_id' );
                $request_id = base64_decode($this->input->post( 'request_id' ));
/* Edit Document */
                $documents= $this->amodel->getDetails(DB_PREFIX . "partial_upload_document", array('*'), array('request_id' => $request_id,'status'=>'1'));
                $doc=count($documents);
                $uploaded_docs=$_POST['multipleupload'];
        for($i=0; $i<$doc; $i++) {
            $docse=$documents[$i]['multipleupload'];
            if(in_array(trim($documents[$i]['multipleupload']), $uploaded_docs))
            {
                $this->db->set('status',1);
                $this->db->where('multipleupload',$docse);
                $this->db->update(DB_PREFIX.'partial_upload_document');
            }
            else {
                $this->db->set('status',0);
                $this->db->where('multipleupload',$docse);
                $this->db->update(DB_PREFIX.'partial_upload_document');
            }
        }
        /* Edit Document End */
        $upload_files =array('document_name','multipleupload');

        $status= $this->insertclonecadaminrevertDetails($_POST['count1'],$upload_files,$return_id,DB_PREFIX.'partial_upload_document',$request_id,'request_id');
        }
        /* sending email for VM,VS and DES for adding document */
        $addition_doc_emails=$this->dm->additiondoc_emails(base64_decode($this->input->post( 'request_id' ))); 
        if(!empty($addition_doc_emails)){
        $data['notify_additionaldoc']=$notify_additionaldoc=$addition_doc_emails[0];
        $counts=$_POST['count1'];
        if($_POST['file_name']){
        for($i=1; $i<=$counts; $i++) {
        $doc_name[]=$_POST['file_name'.$j];
        $j=$i+1;
        }
        $data['type_document']=implode(' , ',$doc_name);
        }
        if($_POST['document_name']){
        for($i=1; $i<=$counts; $i++) {
        $doc_name[]=$_POST['document_name'.$j];
        $j=$i+1;
        }
        $data['type_document']=implode(' , ',$doc_name);
        }
        $doc_names['additional_docs'] = $data['type_document'];
        $this->db->where('candidate_req_id',$request_id);
        $this->db->update(DB_PREFIX.'ver_assign_rep',$doc_names);   
        if(!empty($notify_additionaldoc['ds_email'])){
        $data['name']=$notify_additionaldoc['dsname'];
        $this->send_email_common_proposal('notify_additionaldoc','Additional documents uploaded','',$notify_additionaldoc['ds_email'],$data);
        }
        if(!empty($notify_additionaldoc['vs_email'])){
        $data['name']=$notify_additionaldoc['vsname'];
        $this->send_email_common_proposal('notify_additionaldoc','Additional documents uploaded','',$notify_additionaldoc['vs_email'],$data);
        }
        if(!empty($notify_additionaldoc['vm_email'])){
        foreach ($addition_doc_emails as $key => $vname) {
        $data['name']=$vname['vmname'];
        $this->send_email_common_proposal('notify_additionaldoc','Additional documents uploaded','',$vname['vm_email'],$data);
        }   
        }
        echo "<script> alert('Mail has been successfully sent to the given id')</script>";
        }
        redirect ( base_url('Dadmin/allotmentlist'), 'refresh' );         
    } 
    /***************************
   *  allocating multiple cases to vsupervisor
   * p_newrequest_vsbulk
     ***************************************/      
    function p_newrequest_vsbulk()
    {
        if(empty($_POST['request_id'])){
            redirect('Dadmin/caselisttovs');
        }
        $postData=$_POST;
        if($postData)
        {
             $alldata = array();
        $assignee_id = $this->input->post ( 'assignee_id' );
        foreach($postData['request_id'] as $key=>$request_id) {
        if($assignee_id){
        $upd_data = array();

/*        
        $this->db->select('c.user_id as candidate_id,c.case_no, r.request_id,r.check_id, r.package_id,r.no_checks');
        $this->db->where('c.request_id',$request_id);
        $this->db->join(DB_PREFIX.'request_check r','r.request_id=c.request_id','left');
        $resultdata=$this->db->get(DB_PREFIX."client_request c")->result_array();
        
        echo '<pre>'; print_r($resultdata);exit;
        $save_data['request_id']=$resultdata['request_id'];
        $save_data['check_id'] = $resultdata['check_id'];
        $save_data['candidate_id']=$resultdata['candidate_id'];
        $save_data['updated_by'] = '';
        $save_data['updated_on'] = date ( 'Y-m-d H:i:s' );
        $this->db->insert ( DB_PREFIX .'tat_checks', $save_data );
*/
        $upd_data['request_id']=$request_id;
        $upd_data['verification_status']= 1;
        $upd_data['verification_date'] = date ( 'Y-m-d H:i:s' );
        $upd_data['verification_by']=$this->session->userdata('userid');
        $upd_data['assignee_id']=$_POST['assignee_id'];
        $this->dm->submittodcode($upd_data);
        $this->db->update(DB_PREFIX.'client_request',array('assainee_status'=>1,'entry_status'=>1),array('request_id'=>$request_id));
        $this->db->insert ( DB_PREFIX.'verification_request', array('request_id'=>$request_id,'assignee_status'=>1) );
        $inslog_data['action']='Allotted to VS';
        $inslog_data['updated_by'] = $this->user_id;
        $inslog_data['updated_on'] = date ( 'Y-m-d H:i:s' );
        $this->db->where('request_id',$request_id);
        $this->db->update ( DB_PREFIX .'loghistory', $inslog_data );
           $addition_doc_emails=$this->dm->additiondoc_emails($request_id); 
          $alloted_list =  $addition_doc_emails[0];

        $data['name']=$alloted_list['vsname'];

        $email =   $alloted_list['vs_email'] ;        
              array_push($alldata, $alloted_list);
        }
        }
        $data['alloted_list'] =  $alldata ;

         $cc =implode(' , ',$this->config->item('des_email'));
          
          if(!empty($email))
          {
             $this->send_email_common_notification('allotmented_list_vs','New cases allotted to VS','',$email,$data,$cc);
          }
          else
          {
            $default_mail = $this->config->item('default_vsmail') ;
             $this->send_email_common_notification('allotmented_list_vs','New cases allotted to VS','',$default_mail,$data,$cc);
          }
        
 

        redirect ( base_url('Dadmin/caselisttovs'), 'refresh' );
        }
        else{
            redirect('Dadmin/caselisttovs');
        }
    }  
    /****************************************
    *  deo_assignee function
    * deo_assignee
     ********************************/
    function deo_assignee(){
        $data['request_id']=$request_id = $this->uri->segment(3);
        $candidate_name=$data['checks_result'] = $this->dm->get_userlistoffsuper(base64_decode($request_id));
        $data['candidate_name']=$candidate_name[0]['candidate_name'];
        $assignee_list = $this->dm->get_assignee_list();
        $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list,array('assignee_id','name'));
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Data Entry', 'Dadmin/allotmentlist');
        $this->breadcrumbs->push('Assign Status', 'Dadmin/deo_assignee');
        $data['breadcrumb']=$this->breadcrumbs->show();   
        $this->amodel->pagerender($data, 'deo_assignee');
    }  
    /*****************************
    * p_newdeoreassign function
    * p_newdeoreassign
    *********************************/
    function p_newdeoreassign() {
        $assignee_id = $this->input->post ('assignee_id');
        $date_from = date('Y-m-d');
        $date_to = $this->input->post ( 'date_to' );
        $user_id = $this->input->post ( 'user_id' );
        $request_id = base64_decode($this->input->post( 'request_id' ));
        if($assignee_id){
        $upd_data = array();
        $upd_data['assignee_id'] = $assignee_id;
        $upd_data['deadline_to'] = date("Y-m-d", strtotime($date_to));
        $upd_data['updated_on'] = date ( 'Y-m-d H:i:s' );
        $upd_data['updated_by'] = $this->user_id;
        $this->db->where('request_id',$request_id);
        $this->db->update ( DB_PREFIX .'client_request', $upd_data );
        redirect ( base_url('Dadmin/allotmentlist'), 'refresh' );   
        }
    }
     /*****************************
   * checks_levels function
   * checks_levels
    *********************************/
    function checks_levels() { 
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Checks & levels', 'Dadmin/checks_levels');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'checks_levels');
    }
     /*****************************
    * get_check_levels function
    * get_check_levels
    *********************************/
    function get_check_levels($office_id = 0 ){   
        $model = array('client_model'=>'get_caselist');
        $condition=list_search_filter($_REQUEST);
        
        if($_REQUEST['email']){
            $condition[]=" t.email like '".$_REQUEST['email']."'";
        }
        if($_REQUEST['telephone']){
            $condition[]=" uc.telephone = ".$_REQUEST['telephone'];
        }
        if($_REQUEST['billed_type']){
            $condition[]=" a.billed like '".$_REQUEST['billed_type']."'";
        }
        
        if(!empty($_REQUEST['fp_fdate']) && $_REQUEST['date_filter']==2){
            $condition[]="DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($_REQUEST['fp_fdate']))."' and a.final_report=1 ";
        }
        if(!empty($_REQUEST['fp_tdate']) && $_REQUEST['date_filter']==2){
            $condition[]="DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($_REQUEST['fp_tdate']))."' and a.final_report=1 ";
        }
        if(!empty($_REQUEST['fp_fdate']) && $_REQUEST['date_filter']==7){
            $condition[]="DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($_REQUEST['fp_fdate']))."'";
        }
        if(!empty($_REQUEST['fp_tdate']) && $_REQUEST['date_filter']==7){
            $condition[]="DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($_REQUEST['fp_tdate']))."'";
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];  
        $result = $results[1]; 
        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows;
        foreach ( $result as $i => $row ) {
        $checkstatus = $this->cm->get_currentstatus($row['request_id']);
        $verifiedlevelstatus = $this->cm->get_verifiedlevelstatus($row['request_id']);
        if($checkstatus['verification_status']==1 && $checkstatus['team_mem_id'] ==''){
            $status='Initiated';
        }
        else if($checkstatus['verification_status']==1 && $checkstatus['team_mem_id'] <>'' && $checkstatus['vm_revert_option_status']!=2 && $checkstatus['vm_revert_option_status']!=4){
            $status='Initiated';
        }
        else if(!empty($checkstatus['reason']) && $checkstatus['status']==0 && $row['dataentry_by']==0 && $row['client_verified']==2){
            $status='Revert Raised';
        }
        else if($checkstatus['status']==1 && $row['dataentry_by']==0 && $row['client_verified']==3){
            $status='Revert Closed';
        }
        else if($checkstatus['verification_status']==0 && $checkstatus['client_status']==1 && $checkstatus['vm_revert_option_status']==0 && $checkstatus['reverted_by']==0){
            $status='Submitted to Dcode';
        }
        else if($checkstatus['verification_status']==0 && $checkstatus['operator_status']==2){
            $status='Revert';
        }
        else if($checkstatus['revert_status']==0 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus['role_id']==13 && $checkstatus['assainee_status']==0){
            $status='Revert Closed';
        }
        else if($checkstatus['revert_status']==1 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus['role_id']==13){
            $status='Revert Assigned';
        }
        else if($checkstatus['revert_status']==0 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus['role_id']==12 && $checkstatus['assainee_status']==0){
            $status='Revert Closed';
        }
        else if($checkstatus['revert_status']==1 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus['role_id']==12 ){
            $status='Revert Assigned';
        }
        else if($checkstatus['reverted_by']==0 && !empty($checkstatus['reverted_reason']) && $checkstatus['assainee_status']==1){
            $status='Submitted to Dcode';
        }
        else if($checkstatus['reverted_by']!=0 && !empty($checkstatus['reverted_reason'])){
            $status='Reject Assigned';
        }
        else if($checkstatus['reverted_by']==0 && !empty($checkstatus['reverted_reason'])){
            $status='Reject Rectified';
        }
        else if($checkstatus['verification_status']==0 && $checkstatus['operator_status']==1 && $checkstatus['vm_revert_option_status']==0 && $row['dataentry_by']!=0){
            $status='Submitted to Dcode';
        }
        else if($row['dataentry_by']==0 && $checkstatus['status']!=1){
            $status = 'Pending';
        }
        else if($checkstatus['status']==1 && $row['dataentry_by']==0 ){
            $status = 'Candidate Profile  Completed';
        }
        else if($checkstatus['client_status']==1 && $checkstatus['operator_status']==0 && $checkstatus['assignee_id']<>0 && $row['dataentry_by']==0){
            $status = 'Submitted to Dcode';
        }
        else if($checkstatus['client_status']==1 && $checkstatus['operator_status']==0 && $checkstatus['assignee_id']==0 && $row['dataentry_by']==0){
            $status='Submitted to Dcode';
        }
        else{
            $status = 'New';
        }
        $request_status = 'New';
        if($row['assainee_status']==1){
            $request_status = 'Assigned';
        } else if($row['dataentry_by']==1){
            $request_status= 'New';
        if($status=='Allotted to DES'){
            $request_status= 'Assigned';
        }
        else if($status=='Revert Closed'){
            $request_status= 'Assigned';
        }else{
            $request_status = $request_status= anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'New');;
        }
        } else if($row['dataentry_by']==2){
        if($status=='Revert Closed'){
            $request_status= 'Assigned';
        }
        }
        else {
        if($this->session->userdata['user_type'] == 2 ) {
            $request_status= anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'New');
        if($status=='Allotted to DES'){
            $request_status= 'Assigned';
        }
        else{
            $request_status= anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'New');
        }
        }
        else{
        if($status=='Revert DES'){
            $request_status= anchor('/Dadmin/newrevertrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Revert Raised');  
        }
        else{
            $request_status= anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'New');
        }
        }
        }
        if($status=='Revert Assigned' && $row['dataentry_by']==3){
            $request_status= anchor('/Dadmin/newsupervisorrevertrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Revert Raised');  
        }
        if($status=='Revert Assigned' && $row['dataentry_by']==1 || $status=='Revert Assigned' && $row['dataentry_by']==2){
            $request_status= anchor('/Dadmin/newcadminrevertrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Revert Raised');  
        }
        if($status=='Reject Assigned'){
            $request_status= anchor('/Dadmin/newcadminrejectrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Reject');  
        }
        if($status=='Reject Rectified'){
            $request_status= 'Assigned';  
        }
        $type='';
        if($row['dataentry_by']==1){
            $type='Partial Entry';
        }
        else if($row['dataentry_by']==2){
            $type='Full Entry';
        }
        else if($row['dataentry_by']==3){
            $type='Offline Entry';
        }
        else if($row['dataentry_by']==0){
            $type='Candidate Entry';
        }
        if($status=='Revert to DES' && $row['revert_status']==1 && $row['assainee_status']==1){
            $request_status= 'DEC';
        }
        else if($row['revert_status']==1 && $row['assainee_status']==1){
            $request_status= 'Revert Closed';
        }
        $assign=anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),"View");
        if($row['parent']==0){
            $officevalue=$row['parent_office'];
            $branchofficevalue=$row['office_name'];
        }else if($row['parent']!=0){
            $officevalue=$row['office_name'];
            $branchofficevalue=$row['parent_office'];
        }
        $created_on='';
        if($row['dataentry_by']!=3 && $row['case_accepted_date']!="0000-00-00 00:00:00" && !empty($row['case_accepted_date']))
        {
            $created_on=date('d-m-Y',strtotime($row['case_accepted_date']));
        }  
        else if($row['dataentry_by']==3 && $row['case_recieved_date']!="0000-00-00 00:00:00" && !empty($row['case_recieved_date']))
        {
            $created_on=date('d-m-Y ',strtotime($row['case_recieved_date']));
        }
        $frp_date='';
        if($row['final_report_published_date']){
            $frp_date=date('d-m-Y',strtotime($row['final_report_published_date']));
        }  
        $supplement_date='';
        $supplement_date=(isset($row['supplement_report_date'])) ? date('d-m-Y',strtotime($row['supplement_report_date'])):'';   
        if($row['dataentry_by']==3)
        {
            $cname='Dcode';
        }
        else
        {
            $cname=$row['first_name'];
        }
        $pending_chkint = $this->rm->getchecksintverify($row['request_id']);
        $cntck=count($pending_chkint);
        $interim='';
        foreach($pending_chkint as $chks){ 
        if($chks['qc2_report_publish']==1){   
            $interim=anchor('/Client/interimreport/'.base64_encode($row['request_id']),"Interim");
        }
        }
        $pending_checksa = $this->rm->getchecksverify($row['request_id']);
        $finalreport_checksa = $this->rm->getcountcheck($row['request_id']);
        $count_pending_checksa = $this->rm->getcountchecksverify($row['request_id']);
        $count_date_checksa = $this->rm->getfinalupdateedate($row['request_id']);
        $namw=count($finalreport_checksa);
        $sum=0;
        foreach($count_pending_checksa as $count_pending_val){
            $sum+=$count_pending_val['no_checks'];
        }
        if(!empty($verifiedlevelstatus['qc2fielddata'])){
        if($sum<=$namw){
        $status='Report Published';
        $final=anchor('/Reports/candidate_reports_view/'.base64_encode($row['request_id']).'/'.base64_encode(1).'/'.base64_encode(2).'/'.base64_encode(3).'/'.base64_encode($count_date_checksa['created_date']),"Final",'target=_blank');
        }
        else{
        $final='';
        }
        }else{
        $final='';
        }
        /* supplementary report */
        $supplement='';
        if($row['supplement_report']==1){
        $freport=$this->db->query("select report_name from ". DB_PREFIX ."finalreportpublished 
        where request_id=".$row['request_id']." LIMIT 1 ")->row_array();
        // $final=anchor(('/uploads/finalreport/'.$freport['report_name']),"Final",'target=_blank');
        $final=anchor(('/Uploads/returnFile?file=' .$freport['report_name']),"Final",'target=_blank'); // May 24th
        $supplement=anchor('/Reports/candidate_reports_view/'.base64_encode($row['request_id']).'/'.base64_encode(1).'/'.base64_encode(2).'/'.base64_encode(3).'/'.base64_encode($count_date_checksa['created_date']),"Supplement",'target=_blank');
        }
        if($row['supplement_report']==2){
        $freport=$this->db->query("select report_name from ". DB_PREFIX ."finalreportpublished 
        where request_id=".$row['request_id']." LIMIT 1 ")->row_array();
        // $final=anchor(('/uploads/finalreport/'.$freport['report_name']),"Final",'target=_blank');
        $final=anchor(('/Uploads/returnFile?file=' .$freport['report_name']),"Final",'target=_blank'); // May 24th
        $supplement='';
        }
        /* report status*/
        $rep_status=$this->cm->get_verified_data_with_checkid($row['request_id']);
        $report_status='';
        $publish_status=''; 
        $rstatus1=[];
        if($rep_status){
            $orange_check = 0; // ka added on april 26
        foreach($rep_status as $k => $rps)
        {     
        $rid=$row['request_id'];  
        if(!empty($rps['qc2fielddata'])){    
            $qc2_data=toArray(json_decode($rps['qc2fielddata']));   
        if($qc2_data['status']){
            $pstatus[$rid][]=$this->vm->get_status($qc2_data['status']); 
             if($rps['check_id'] != 1306){ //if not gap check ka added on april 26
                            if($qc2_data['status'] == "519") //others
                            {
                                $ostatus[] = $this->vm->get_status($qc2_data['ostatus']); 
                                $orange_check++;
                            }
                            if($qc2_data['status'] == 110) // stop check
                            {
                                $orange_check++;
                            }
                        } // ka have added on 29
            /** Aug 24th **/
            // if($qc2_data['status'] == "519") //others
            // {
            //     $ostatus[] = $this->vm->get_status($qc2_data['ostatus']); 
            // }
            /** Aug 24th **/
        }
        if($qc2_data['status1']){
            $pstatus[$rid][]=$this->vm->get_status($qc2_data['status1']);
            $status1[]=$this->vm->get_status($qc2_data['status1']); // Dec 14th
        }
        }
        }  
        foreach($pstatus[$rid] as $rp)
        {
        $rstatus1[]=$rp['name'];
        }  

        /*** Dec 14th ***/
        if(!empty($ostatus))
            $count_others_orange = 0;
        else
            $count_others_orange = -1;
        foreach($status1 as $sp) // status of 3rd drop down // Dec  13th
        {
            if($sp['name'] == "Others")
            {
                $count_others_orange = 1; 
            }
        }
        /*** Dec 14th ***/  
        
        /**
         * In dcode_master_masterdata table
         * 699 -  Not Applicable
         * 750 - Not applicable  
         */
        foreach($ostatus as $orp) // For Others - Not Applicable -  Only this check in Others is to  be GREEN
        {
            $orstatus[]=$orp['name'];
            $others_id  = $orp['id']; // Dec 11th 
            if($others_id != 699 && $others_id != 750)  // Dec 11th
                $count_others_orange++;  // Count of  orange others checks 

        }
        /*** Dec 13th ***/
        if (in_array("Discrepant", $rstatus1) || in_array("Possible Discrepant" , $rstatus1) || in_array("Record Found" , $rstatus1) || in_array("Positive" , $rstatus1) || in_array("No Records" , $rstatus1) || in_array("High Risk" , $rstatus1) || in_array("Invalid" , $rstatus1) || in_array("Not Completed" , $rstatus1))
        { 
        $report_status ="<span style='color:red;'>RED</span>";
        }
        else if ((in_array("Stop Check" , $rstatus1) &&  $orange_check>0) || (in_array("Others" , $rstatus1) && ($count_others_orange > 0)&&  $orange_check>0) || (in_array("Others" , $rstatus1) && ($count_others_orange == -1)&&  $orange_check>0) || in_array("Possible Match" , $rstatus1) || in_array("Record Not Found" , $rstatus1) || in_array("Partial Match" , $rstatus1)&&  $orange_check>0) {
        $report_status ="<span style='color:orange;'>ORANGE</span>";
        } 
        /** Dec 13th **/
        else if(in_array("Others" , $rstatus1) && (in_array("Not applicable" , $orstatus) || in_array("Not Applicable" , $orstatus)) && ($count_others_orange == 0) )
        {
            $report_status ="<span style='color:green;'>GREEN</span>";
        }
        /** Dec 13th **/
        // else if (in_array("Stop Check" , $rstatus1) || (in_array("Others" , $rstatus1) && ($count_others_orange > 0)) || (in_array("Others" , $rstatus1) && ($count_others_orange == -1)) || in_array("Possible Match" , $rstatus1) || in_array("Record Not Found" , $rstatus1) || in_array("Partial Match" , $rstatus1)) {
        // $report_status ="<span style='color:orange;'>ORANGE</span>";
        // }
        else
        {
        $report_status ="<span style='color:green;'>GREEN</span>";
        }
        $publish_status=$report_status;

        }
        $check_type=''; 
        $total_chk='';
        $checknames='' || [];
        $total_chk=$this->mm->getchecks($row['request_id']); 
        foreach($total_chk as $key => $ci){ // here i have added my check id on 7th feb that is 1306
        if($ci['check_id']>94 && $ci['check_id'] != 1306 && ($ci['check_id']<630 && $ci['check_id']>655))
            $checknames[$ci['pack_id'].''.$ci['check_id']]=$ci['name'];
        else
        {
        if($ci['chk_count']>0){
            $checknames[$ci['check_id']]=$ci['chk_count'].' '.$ci['name'];
        }
        else
        {
            $checknames[$ci['check_id']]=$ci['name']; 
        } 
        }
        }   
        $chk=implode(' + ',$checknames);


        $package_name=$total_chk[0]['level'];
       
        $chkbox='<input type="checkbox" name="requests[]" value="'.($row['request_id']).'" />';
       
        $response->rows [$i] ['cell'] = array ( $chkbox,$row['org_name'],$officevalue,$branchofficevalue,$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'],$row['client_ref_number'],$row['email'],$row['telephone'],$package_name,$chk,$type,$status,$publish_status,$final,$supplement,$frp_date,$supplement_date,$row['billed'],$assign); 

        }
        }
        echo json_encode($response);
    }
     /*****************************
    * assign_bills function
    * assign_bills
    *********************************/
    function assign_bills(){
        $form_data=$_POST;
        if(!empty($form_data['requests'])){ 
            $this->db->where_in('request_id', $form_data['requests']);
           $query= $this->db->update(DB_PREFIX .'client_request',array('billed'=>$form_data['billed']));
        }
        redirect( base_url('Dadmin/checks_levels'), 'refresh' ); 
    }
    /****************************
    *  bulk allotment in offline entry
    * p_bulkofflineallotment
     ********************************** */
    function p_bulkofflineallotment() {
        try{
            $postData=$_POST;
        $assignee_id = $this->input->post( 'assignee_id' );
        $date_from = date('Y-m-d');
        $date_to = $this->input->post ( 'date_to' );
        $user_id = $this->session->userdata('userid');
        $payment_status =  $this->input->post( 'payment_status' );

        $upd_data = array();
   
    

        if($assignee_id && !empty($postData['request_id'])){ 
        foreach($postData['request_id'] as $key=>$request_id) {
        $upd_data['assignee_id'] = $assignee_id;
        $upd_data['assainee_status']= 1;
        $upd_data['case_accepted_date'] = date("Y-m-d H:i:s");
        $upd_data['deadline_from'] = date("Y-m-d");
        $upd_data['deadline_to'] = date("Y-m-d", strtotime($date_to));
        $upd_data['updated_on'] = date ( 'Y-m-d H:i:s' );
        $upd_data['updated_by'] = $user_id;
        $upd_data['payment_status'] = $payment_status;
        $upd_data = $this->security->xss_clean($upd_data);
        $this->db->where('request_id',$request_id);
        $this->db->update ( DB_PREFIX .'client_request', $upd_data );
        }
        }
      
        redirect('Client/clientofflinesearch/3');
        }
        catch(ErrorException $e) {
        echo $e->getMessage(); 
        $this->load->view('Index/error_500');
        }
        }
          function get_desusers( $office_id = 0  ){ 
        $model = array(self::$client_model=>'get_userrevertlistdes');
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $dataentry = ($_REQUEST['entry']=='') ? '' : $_REQUEST['entry'];
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $a_date=($_REQUEST['a_date']) ? $_REQUEST['a_date'] : '';
        $t_date=($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $case_no=($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $billing_type=($_REQUEST['billing_type']) ? $_REQUEST['billing_type'] : '';
        if($org_id){
            $condition[]=" c.id = ".$org_id;
        }
        if($office){
            $condition[]=" b.id = ".$office;
        }
        if($parent_office){
            $condition[]=" d.id = ".$parent_office;
        }
        if($name){
            $condition[]=" a.candidate_name like '%".$name."%'";
        }
        if($sub_office){
            $condition[]=" e.sub_office = ".$sub_office;
        }
        if($a_status==1){
            $condition[]=" a.assainee_status =1";
        }
        if($a_status==2){
            $condition[]=" a.assainee_status !=1 and cv.reverted_by = 0";
        }
        if($a_status==3){
            $condition[]="  cv.reverted_by != 0 and a.assainee_status !=1 ";
        }
        if($dataentry !=0 && $dataentry !=4 ){
            $condition[]=" a.dataentry_by = ".$dataentry;
        }
        if($dataentry ==4){
            $condition[]=" a.dataentry_by = 0";
        }
        if($a_date){
            $condition[]="DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($a_date))."'";
        }
        if($t_date){
            $condition[]="DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        //22/01/2023
        $case_no = trim($case_no);
        if($case_no){
            $condition[]=" a.case_no like '%".$case_no."'";
        }
        if($billing_type==1){
            $condition[]=" a.case_no like '%PR%'";
        }
        if($billing_type==2){
            $condition[]=" a.case_no like '%PO%'";
        }
        if($term)
        {
            //support multiple words
            $search = explode(' ', $term);
            foreach($search as $t) {
            $not        = '';
            $operator    = 'OR';
            if(substr($t,0,1) == '-')
            {
            $not        = 'NOT ';
            $operator    = 'AND';
            //trim the - sign off
            $t        = substr($t,1,strlen($t));
            }
            $like    = '';
            $like    .= "( a.candidate_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." c.org_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." b.office_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." d.office_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." e.order_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." a.assainee_status ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." f.first_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." c.dedicated_operator ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." dataentry_by ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." a.case_no ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' ) " ;
            $condition[]=$like;
            }
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];  
        $result = $results[1];
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            foreach ( $result as $i => $row ) {
            $reject_reason='';
            $deadline_to = ($row['client_submit_date']) ? date('d-m-Y',strtotime($row['client_submit_date'])) : '';
            if($row['assainee_status']==1){
                $check=$i+$count+1;
                $request_status=  'Assigned';
                $reject_status='Accepted';
            } 
            else if($row['assainee_status']==2 && $row['reverted_by']!=0 && !empty($row['reverted_reason'])) {
                $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id'] ).'"/>';
                $request_status=  anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Partial Entry Requested');
                $reject_status='Reject Raised'; 
                $reject_reason=$row['reverted_reason'];
            } 
            else if($row['assainee_status']==2 && $row['reverted_by']==0 && !empty($row['reverted_reason'])) {
                $check=$i+$count+1;
                $request_status=  'Reject Closed'; 
                $reject_reason=$row['reverted_reason'];
                $reject_status=(anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:green'>Accept</span>").' / '.anchor('/Dadmin/rejectcase/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:red'>Reject</span>")); 
            } 
            else if($row['assainee_status']==2){
                $check=$i+$count+1;
                $request_status=  anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Partial Entry Requested');
                $reject_status=(anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:green'>Accept</span>").'   -  '.anchor('/Dadmin/rejectcase/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:red'>Reject</span>")); 
            }
            else if($row['reverted_by']==0 && empty($row['reverted_reason'])){
                $request_status= anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'New');
                $reject_status=( anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:green'>Accept</span>").' / '.anchor('/Dadmin/rejectcase/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:red'>Reject</span>")); 

            }
             else if($row['reverted_by']!=0 && !empty($row['reverted_reason'])){
                $request_status= 'Reject Raised';
                $reject_status='Reject Raised'; 
                $reject_reason=$row['reverted_reason'];
            }
            else if($row['reverted_by']==0 && !empty($row['reverted_reason'])){
                $request_status= anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Reject Closed');
                $reject_reason=$row['reverted_reason'];
                $reject_status=( anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:green'>Accept</span>").' / '.anchor('/Dadmin/rejectcase/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:red'>Reject</span>")); 
            }
            else { 
                $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id'] ).'" />';
                $request_status= anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'New');
                $reject_status='Accepted'; 
            }
            if($row['dataentry_by']==0){
                $dstatus='Candidate Entry';
            }
            else if($row['dataentry_by']==1){
                $dstatus='Partial Entry';
            }
            else if($row['dataentry_by']==2){
                $dstatus='Full Entry';
            }
            else if($row['dataentry_by']==3){
                $dstatus='Offline Entry';
            }
            else {
                $dstatus='';
            }
            if($request_status=='Assigned'){
            $response->rows [$i] ['cell'] = array ( $check,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'], anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']), $row['case_no'],$row['order_name'],$request_status,$reject_reason,$dstatus,$row['first_name'],$reject_status, $deadline_to,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View') );
            }else {
            if($reject_status=='Reject Raised'){
                $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id']).'" disabled/>';
            }
            else{
                $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id']).'" />';
            }
            $response->rows [$i] ['cell'] = array ( $check,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'], anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']), $row['case_no'],$row['order_name'],$request_status,$reject_reason,$dstatus,$row['first_name'], $reject_status, $deadline_to,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View') );

            }
            }
        }
        echo json_encode($response);
    }

      function desrevert_raised_checks(){
         
           $assignee_list = $this->dm->get_assignee_list(); 
           $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list,array('assignee_id','name'));

        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('DES Revert Raised checks List', 'Verification/desrevert_raised_checks');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'desrevert_raised_checks');
       }

       function payment_verification(){

           $this->amodel->loadcssScript(array( 'jquery-ui-1.10.4'));
                $this->amodel->loadjsscript(array( 'jquery.validate','jquery.dropdownPlain','jquery-ui-1.8.16.custom.min'));
                $data['request_id']=$request_id = base64_decode($this->uri->segment(3));       
                
                $candidate_name=$data['checks_result'] = $this->vm->get_userlist($request_id);
                $data['candidate_name']=$candidate_name[0]['candidate_name'];

        
        $this->amodel->pagerender($data, 'payment_verification');
       }

       function payment_allotment(){

     
            $request_id = $_POST['request_id'];
            $payment_status =  $_POST['payment_status'];
            if(!empty($payment_status)){
             
                   $upd_data['payment_status'] =  $payment_status;

                  $this->db->where('request_id', $request_id);
                  $this->db->update ( DB_PREFIX .'client_request', $upd_data );

            }
            
            redirect('Dadmin/allotmentlist');
            
       }

       /********* updateunlimited *********
       **** function updateunlimited******
       ************************************/
       function updateunlimited(){
         //print_r($_POST);exit;

        $request_id=$_POST['request_id'];
        $check_id=$_POST['check_id'];
        $no_check=$_POST['check_no']+1;
        //$no_check=99;
       $package_id=$_POST['package_id'];

       if($package_id==0){
            $where = '(request_id="'.$request_id.'" AND check_id = "'.$check_id.'" AND package_id=0)';

            $data = array(
            'no_checks'=> 0,
            'full_info'=>99 
            );
            $this->db->set('no_checks',0);
            $this->db->set($data);
            $this->db->where($where);
            $res=$this->db->update(DB_PREFIX.'request_check');
       }

        $where = '(request_id="'.$request_id.'" AND check_id = "'.$check_id.'" AND package_id > 0)';

        $data = array(
        'no_checks'=> $no_check,
        'full_info'=>99 
        );
        $this->db->set('no_checks',$no_check);
        $this->db->set($data);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'request_check');
        print_r($res);

       }

       /********* Update update_idproofNocheck**********
       ******** finction update_idproofNocheck() *******
       *****************************************/
       function update_idproofNocheck()
       {
        //print_r($_POST);exit;
        $request_id=$_POST['request_id'];
        $check_id=$_POST['check_id'];
        $no_check=$_POST['no_checks'];
        //$no_check=99;
        $where = '(request_id="'.$request_id.'" AND check_id = "'.$check_id.'")';

        //$this->db->set('no_checks',$no_check);
        $this->db->set('no_checks',$no_check);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'request_check');
        print_r($res);
       }


 /********* DEO New Case Lists ************
        ******* function vm_newcaselist *********
        *****************************************/
        function deo_newcaselist(){
            $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
            $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));

            $title=base64_decode($this->uri->segment(3));
            if($title=='New'){
                $Newtitle='New';
            }
            else if($title=='NewOverdue'){
                $Newtitle='Overdue';
            }
            else if($title=='NewDueToday'){
                $Newtitle='Due Today';
            }

            else if($title=='RevertAssigned'){
                $Newtitle='Revert Assigned';
            }
            else if($title=='RevertAssignedOverdue'){
                $Newtitle='Overdue';
            }
            else if($title=='RevertAssignedDueToday'){
                $Newtitle='Due Today';
            }
            

            else{
                $Newtitle= '';
            }

            // add breadcrumbs
            $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
            $this->breadcrumbs->push("DEO ".$Newtitle." List", 'Dadmin/new');
            $data['new_title']=$Newtitle;
            $data['breadcrumb']=$this->breadcrumbs->show();  
            $this->amodel->pagerender($data, 'deo_newcaselist');
        }       

     function get_newdeolist() {   
        $model = array('Dashboard_model'=>'get_newuserlistdeo');
            $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
            $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
            $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
            $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
            $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
            $a_revert= ($_REQUEST['revert_status']) ? $_REQUEST['revert_status'] : '';
            $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
            $order_no=($_REQUEST['order_no']) ? $_REQUEST['order_no'] : '';
            $case_no=($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
            $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
            $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
            $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
            $case_type = ($_REQUEST['a_type']) ? $_REQUEST['a_type'] : '';
            $check_count = ($_REQUEST['check_count']) ? $_REQUEST['check_count'] : '';
            $date_filter = ($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
            $billing_type = ($_REQUEST['billing_type']) ? $_REQUEST['billing_type'] : '';
            $payment_status = ($_REQUEST['payment_status']) ? $_REQUEST['payment_status'] : '';

            if($office){
                $condition[]=" b.id = ".$office;
            }
            if($org_id){
                $condition[]=" c.id = ".$org_id;
            }
            if($parent_office){
                $condition[]=" d.id = ".$parent_office;
            }
            if($name){
                $condition[]=" a.candidate_name like '%".$name."%'";
            }
            if($sub_office){
                $condition[]=" a.sub_office = ".$sub_office;
            }
            if($a_status==1){
                $condition[]=" cv.operator_status = 1  and cv.vm_revert_option_status=0";
            }
            if($a_status==2){
                $condition[]=" (a.entry_status !=1 and cv.operator_status != 1) ";
            }
            if($a_status== 3){
                $condition[]=" ((a.revert_status in (1,3) and cv.vm_revert_option_status in (1,3)) or (a.revert_status in (1,3) and cv.operator_status != 1 and a.entry_status=1 and (cv.candidate_status =1 and a.revert_status=3 ) )) ";
            }
            if($a_status== 4){
                $condition[]="((cv.operator_status=1 and cv.vm_revert_option_status=3 ) || (a.revert_status=1 and a.assainee_status=1 and a.revert_status!=1 and cv.operator_status !=1 and a.entry_status=1))";
            }
            if($a_revert==1){
                $condition[]=" cv.revert_option_status =1";
            }

            if($order_no){
                $condition[]=" e.order_name like '%".$order_no."%'";
            }
            //22/01/2023
            $case_no = trim($case_no);
            if($case_no){
                $condition[]=" a.case_no like '%".$case_no."'";
            }
            if($case_type !=0 && $case_type !=4 ){
                $condition[]=" a.dataentry_by = ".$case_type;
            }
            if($case_type ==4){
                $condition[]=" a.dataentry_by = 0";
            }
            if(!empty($c_date) && $date_filter==1){
                $condition[]="DATE_FORMAT(a.deadline_from ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
            }
            if(!empty($t_date) && $date_filter==1){
                $condition[]="DATE_FORMAT(a.deadline_from ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
            }
            if(!empty($c_date) && $date_filter==2){
                $condition[]="DATE_FORMAT(a.deadline_to ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
            }
            if(!empty($t_date) && $date_filter==2){
                $condition[]="DATE_FORMAT(a.deadline_to ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
            }
            if(!empty($c_date) && $date_filter==3){
                $condition[]="DATE_FORMAT(cv.operator_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
            }
            if(!empty($t_date) && $date_filter==3){
                $condition[]="DATE_FORMAT(cv.operator_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
            }
            if($billing_type==1){
                $condition[]=" a.case_no like '%PR%'";
            }
            if($billing_type==2){
                $condition[]=" a.case_no like '%PO%'";
            }
             if($payment_status){
                $condition[]=" mr.id =" . $payment_status;
            }
            if($term)
            {
                //support multiple words
                $search = explode(' ', $term);

                foreach($search as $t) {
                    $not        = '';
                    $operator    = 'OR';
                    if(substr($t,0,1) == '-')
                    {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t,1,strlen($t));
                    }

                    $like    = '';
                    $like    .= "( a.candidate_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." c.org_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." b.office_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." d.parent ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." d.office_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." e.order_name ".$not."LIKE '%".$t."%' " ;
                    
                    $like    .= $operator." a.assainee_status ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." f.first_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." c.dedicated_operator ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." a.case_no ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' ) " ;
                    $condition[]=$like;
            }
        }

    /**************** New *****************/
    $dateDiff=date('Y-m-d');
        if($check_count == 'New')
    {
        
        $condition[]="(a.entry_status !=1 and cv.operator_status != 1) "; 
    }
    else if($check_count == 'NewOverdue'){
            $condition[]="a.entry_status !=1 and cv.operator_status != 1 and DATE_FORMAT(a.deadline_from, '%Y-%m-%d') < '".date('Y-m-d',strtotime($dateDiff))."'";
    }
    else if($check_count == 'NewDueToday'){
            $condition[]=" a.entry_status !=1 and cv.operator_status != 1  and DATE_FORMAT(a.deadline_from, '%Y-%m-%d') >= '".date('Y-m-d',strtotime($dateDiff))."'";
    }
    /**************** RevertAssigned *****************/
    else if($check_count == 'RevertAssigned'){
            $condition[]="((a.revert_status in (1,3) and cv.vm_revert_option_status in (1,3)) or (a.revert_status in (1,3) and cv.operator_status != 1 and a.entry_status=1 and (cv.candidate_status =1 and a.revert_status=3 ) ))";
    }
    else if($check_count == 'RevertAssignedOverdue'){
            $condition[]="a.revert_status in (1,3) and cv.vm_revert_option_status in (1,3) or a.revert_status in (1,3) and cv.operator_status != 1 and a.entry_status=1 and cv.candidate_status =1 and a.revert_status=3  and DATE_FORMAT(a.deadline_from, '%Y-%m-%d') < '".date('Y-m-d',strtotime($dateDiff))."'";
    }
    else if($check_count == 'RevertAssignedDueToday'){
            $condition[]="a.revert_status in (1,3) and cv.vm_revert_option_status in (1,3) or a.revert_status in (1,3) and cv.operator_status != 1 and a.entry_status=1 and cv.candidate_status =1 and a.revert_status=3  and DATE_FORMAT(a.deadline_from, '%Y-%m-%d') >= '".date('Y-m-d',strtotime($dateDiff))."'";
    }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];  
        $result = $results[1]; 
        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows;
        foreach ( $result as $i => $row ) {
        $assignstatus=$this->dm->getassignstatus($row['request_id']);
        if($assignstatus){
        $assignstat=anchor('/Dadmin/deo_assignee/'.base64_encode($row['request_id']),'Reassign');
        }else{
        $assignstat='Not Yet Assign';
        }    
        if($row['parent']==0){
        $officevalue=$row['parent_office'];
        $branchofficevalue=$row['office_name'];
        }
        $deadline_from = ($row['deadline_from']) ? date('d-m-Y',strtotime($row['deadline_from'])) : '';
         $deadline_to = ($row['deadline_to']) ? date('d-m-Y',strtotime($row['deadline_to'])) : '';
         $operator_submit_date = ($row['operator_submit_date']) ? date('d-m-Y',strtotime($row['operator_submit_date'])) : '';
        if($this->session->userdata['role_id']==3 || $this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==2){
            $additional_doc=anchor('/Dadmin/upload_document/'.base64_encode($row['request_id']),'Add');
        }
        $casetype='';
        if($row['dataentry_by']==1){
            $casetype='Partial Entry';
        }
        else if($row['dataentry_by']==2)
        {
            $casetype='Full Entry';
        }
        else if($row['dataentry_by']==3)
        {
            $casetype='Offline Entry';
        }
        else
        {
            $casetype='Candidate Entry';
        }
        $pay_sattus =   $row['payment_status'];
         $role=$this->session->userdata('role_id');
             if($pay_sattus == 948  && ($role == 1 || $role == 3))
             {
              $changestatus = anchor('/Dadmin/payment_verification/'.base64_encode($row['request_id']),'payment status'); 
             }
             else
             {
              $changestatus = '';  
             }
        if($row['final_report'] != 1) {
          $modify_office=anchor('/Dsupervisor/cand_office/'.base64_encode($row['request_id']),'Modify_office');  
        }
            if($row['entry_status']!=1 ) {
            $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$officevalue,$branchofficevalue,$row['sub_office'], anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']), $row['case_no'],$row['client_ref_number'],$row['order_name'],$casetype,$row['assignee'],'New',      $row['pay_status'],'New',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
                
                }else {
               $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$officevalue,$branchofficevalue,$row['sub_office'], anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'],   $row['client_ref_number'],$row['order_name'],$casetype,$row['assignee'],'Completed',$row['pay_status'],'DEC',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
               
                }
              if($row['revert_status']==1 && $row['assainee_status']==1){
            $checks=$i+$count+1;
             $checks='<input type="checkbox" name="request_id[]" value="'.($row['request_id']).'" />';
             $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'], $row['client_ref_number'],$row['order_name'],$casetype,$row['assignee'],'Revert Rectified',$row['pay_status'],'Rectified',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
            }
            if($row['revert_status']==0 && $row['assainee_status']==1 && !empty($row['service']) && !empty($row['reason'])){
            $checks=$i+$count+1;
             $checks='<input type="checkbox" name="request_id[]" value="'.($row['request_id']).'" />';
             $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'], $row['client_ref_number'] ,$row['order_name'],$casetype,$row['assignee'],'Revert Rectified',$row['pay_status'],'Rectified',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
            }
            else if($row['revert_status']==1){
            $checks=$i+$count+1;
             $checks='<input type="checkbox" name="request_id[]" value="'.($row['request_id']).'" />';
             $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'], $row['client_ref_number'] ,$row['order_name'],$casetype,$row['assignee'],'Revert Assigned',$row['pay_status'],'Revert',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
            }
             else if($row['revert_status']==3 && $row['assainee_status']==1 && $row['candidate_status']==1){
             $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'], $row['client_ref_number'] ,$row['order_name'],$casetype,$row['assignee'],'Revert',$row['pay_status'],'Revert Assigned',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
            }
            else if($row['revert_status']==2){
             $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'], $row['client_ref_number'] , $row['client_ref_number'],$row['order_name'],$casetype,$row['assignee'],'Revert',$row['pay_status'],'Revert Raised',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
            }
            else if($row['revert_status']==3 && $row['assainee_status']!=1){
             $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'],$row['client_ref_number'] ,$row['order_name'],$casetype,$row['assignee'],'Revert Assigned',$row['pay_status'],'Revert',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
            }
           if($row['operator_status']==1 && $row['vm_revert_option_status']==3 ) {
                $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'], $row['client_ref_number'],$row['order_name'],$casetype,$row['assignee'],'Revert Rectified',$row['pay_status'],'Rectified',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
                } 
                else if($row['operator_status']==1 && $row['vm_revert_option_status']==1){
           $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'],$row['client_ref_number'] ,$row['order_name'],$casetype,$row['assignee'],'Revert Assigned',$row['pay_status'],'Revert',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']).'/'.base64_encode($row['check_id']),'View'),$additional_doc,$assignstat,$modify_office);
            }
        else if($row['operator_status']==1) {
                $response->rows [$i] ['cell'] = array ( $i+$count+1,$changestatus,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'],$row['client_ref_number'] ,$row['order_name'],$casetype,$row['assignee'],'Completed',$row['pay_status'],'DEC',$deadline_from,$deadline_to,$operator_submit_date,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View'),$additional_doc,$assignstat,$modify_office);
                }
            }
        }
        echo json_encode($response);
        }  


/********* DES New Case Lists ************
        ******* function vm_newcaselist *********
        *****************************************/
        function des_newcaselist(){
            $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
            $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));

            $title=base64_decode($this->uri->segment(3));
            if($title=='Newpo'){
                $Newtitle='Newpo';
            }
            else if($title=='NewOverduepo'){
                $Newtitle='Overduepo';
            }
            else if($title=='NewDueTodaypo'){
                $Newtitle='Due Todaypo';
            }
            if($title=='Newpr'){
                $Newtitle='Newpr';
            }
            else if($title=='NewOverduepr'){
                $Newtitle='Overduepr';
            }
            else if($title=='NewDueToday'){
                $Newtitle='Due Todaypr';
            }
            else if($title=='Rejectclosed'){
                $Newtitle='Reject closed';
            }
            else if($title=='RejectclosedOverdue'){
                $Newtitle='Overdue';
            }
            else if($title=='RejectclosedDueToday'){
                $Newtitle='Due Today';
            }

            else{
                $Newtitle= '';
            }

            
            // add breadcrumbs
            $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
            $this->breadcrumbs->push("DES ".$Newtitle." List", 'Dadmin/new');
            $data['new_title']=$Newtitle;
            $data['breadcrumb']=$this->breadcrumbs->show();  
            $this->amodel->pagerender($data, 'des_newcaselist');
        }       

     function get_newdeslist() {   
        $model = array('Dashboard_model'=>'get_newuserlistdes');
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $dataentry = ($_REQUEST['entry']=='') ? '' : $_REQUEST['entry'];
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $a_date=($_REQUEST['a_date']) ? $_REQUEST['a_date'] : '';
        $t_date=($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $case_no=($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $billing_type=($_REQUEST['billing_type']) ? $_REQUEST['billing_type'] : '';
        $check_count = ($_REQUEST['check_count']) ? $_REQUEST['check_count'] : '';
        if($org_id){
            $condition[]=" c.id = ".$org_id;
        }
        if($office){
            $condition[]=" b.id = ".$office;
        }
        if($parent_office){
            $condition[]=" d.id = ".$parent_office;
        }
        if($name){
            $condition[]=" a.candidate_name like '%".$name."%'";
        }
        if($sub_office){
            $condition[]=" e.sub_office = ".$sub_office;
        }
        if($a_status==1){
            $condition[]=" a.assainee_status =1";
        }
        if($a_status==2){
            $condition[]=" a.assainee_status !=1 and cv.reverted_by = 0";
        }
        if($a_status==3){
            $condition[]="  cv.reverted_by != 0 and a.assainee_status !=1 ";
        }
        if($a_status==4){
            $condition[]="cv.reverted_by = 0 and  a.assainee_status =0 and cv.reverted_reason<>'' ";
        }
        if($dataentry !=0 && $dataentry !=4 ){
            $condition[]=" a.dataentry_by = ".$dataentry;
        }
        if($dataentry ==4){
            $condition[]=" a.dataentry_by = 0";
        }
        if($a_date){
            $condition[]="DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($a_date))."'";
        }
        if($t_date){
            $condition[]="DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        if($case_no){
            $condition[]=" a.case_no like '%".$case_no."'";
        }
        if($billing_type==1){
            $condition[]=" a.case_no like '%PR%'";
        }
        if($billing_type==2){
            $condition[]=" a.case_no like '%PO%'";
        }
        if($term)
        {
            //support multiple words
            $search = explode(' ', $term);
            foreach($search as $t) {
            $not        = '';
            $operator    = 'OR';
            if(substr($t,0,1) == '-')
            {
            $not        = 'NOT ';
            $operator    = 'AND';
            //trim the - sign off
            $t        = substr($t,1,strlen($t));
            }
            $like    = '';
            $like    .= "( a.candidate_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." c.org_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." b.office_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." d.office_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." e.order_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." a.assainee_status ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." f.first_name ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." c.dedicated_operator ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." dataentry_by ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." a.case_no ".$not."LIKE '%".$t."%' " ;
            $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' ) " ;
            $condition[]=$like;
            }
        }
    /**************** New *****************/
    $dateDiff=(date('Y-m-d'));
        if($check_count == 'Newpo')
    {
        
        $condition[]="a.assainee_status !=1 and cv.reverted_by = 0 and a.case_no like '%PO%' "; 
    }
    else if($check_count == 'NewOverduepo'){
            $condition[]=" a.assainee_status !=1 and cv.reverted_by = 0 and a.case_no like '%PO%' and DATE_FORMAT(cv.client_submit_date, '%Y-%m-%d') < '".date('Y-m-d',strtotime($dateDiff))."'";
    }
    else if($check_count == 'NewDueTodaypo'){
            $condition[]=" a.assainee_status !=1 and cv.reverted_by = 0 and a.case_no like '%PO%' and DATE_FORMAT(cv.client_submit_date, '%Y-%m-%d') >= '".date('Y-m-d',strtotime($dateDiff))."'";
    }

    if($check_count == 'Newpr')
    {
        
        $condition[]="a.assainee_status !=1 and cv.reverted_by = 0 and a.case_no like '%PR%' "; 
    }
    else if($check_count == 'NewOverduepr'){
            $condition[]=" a.assainee_status !=1 and cv.reverted_by = 0 and a.case_no like '%PR%' and DATE_FORMAT(cv.client_submit_date, '%Y-%m-%d') < '".date('Y-m-d',strtotime($dateDiff))."'";
    }
    else if($check_count == 'NewDueTodaypr'){
            $condition[]=" a.assainee_status !=1 and cv.reverted_by = 0 and a.case_no like '%PR%' and DATE_FORMAT(cv.client_submit_date, '%Y-%m-%d') >= '".date('Y-m-d',strtotime($dateDiff))."'";
    }
    /**************** Reject closed *****************/
    else if($check_count == 'Rejectclosed'){
            $condition[]="cv.reverted_by = 0 and  a.assainee_status =0 and cv.reverted_reason<>'' ";
    }
    else if($check_count == 'RejectclosedOverdue'){
            $condition[]="cv.reverted_by = 0 and  a.assainee_status =0 and cv.reverted_reason<>''  and DATE_FORMAT(cv.client_submit_date, '%Y-%m-%d') < '".date('Y-m-d',strtotime($dateDiff))."'";
    }
    else if($check_count == 'RejectclosedDueToday'){
            $condition[]="cv.reverted_by = 0 and  a.assainee_status =0 and cv.reverted_reason<>''  and DATE_FORMAT(cv.client_submit_date, '%Y-%m-%d') >= '".date('Y-m-d',strtotime($dateDiff))."'";
    }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];  
        $result = $results[1];
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            foreach ( $result as $i => $row ) {
            $reject_reason='';
            $deadline_to = ($row['client_submit_date']) ? date('d-m-Y',strtotime($row['client_submit_date'])) : '';
            if($row['assainee_status']==1){
                $check=$i+$count+1;
                $request_status=  'Assigned';
                $reject_status='Accepted';
            } 
            else if($row['assainee_status']==2 && $row['reverted_by']!=0 && !empty($row['reverted_reason'])) {
                $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id'] ).'"/>';
                $request_status=  anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Partial Entry Requested');
                $reject_status='Reject Raised'; 
                $reject_reason=$row['reverted_reason'];
            } 
            else if($row['assainee_status']==2 && $row['reverted_by']==0 && !empty($row['reverted_reason'])) {
                $check=$i+$count+1;
                $request_status=  'Reject Closed'; 
                $reject_reason=$row['reverted_reason'];
                $reject_status=(anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:green'>Accept</span>").' / '.anchor('/Dadmin/rejectcase/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:red'>Reject</span>")); 
            } 
            else if($row['assainee_status']==2){
                $check=$i+$count+1;
                $request_status=  anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Partial Entry Requested');
                $reject_status=(anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:green'>Accept</span>").'   -  '.anchor('/Dadmin/rejectcase/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:red'>Reject</span>")); 
            }
            else if($row['reverted_by']==0 && empty($row['reverted_reason'])){
                $request_status= anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'New');
                $reject_status=( anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:green'>Accept</span>").' / '.anchor('/Dadmin/rejectcase/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:red'>Reject</span>")); 

            }
             else if($row['reverted_by']!=0 && !empty($row['reverted_reason'])){
                $request_status= 'Reject Raised';
                $reject_status='Reject Raised'; 
                $reject_reason=$row['reverted_reason'];
            }
            else if($row['reverted_by']==0 && !empty($row['reverted_reason'])){
                $request_status= anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'Reject Closed');
                $reject_reason=$row['reverted_reason'];
                $reject_status=( anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:green'>Accept</span>").' / '.anchor('/Dadmin/rejectcase/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),"<span style='color:red'>Reject</span>")); 
            }
            else { 
                $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id'] ).'" />';
                $request_status= anchor('/Dadmin/newrequest/'.base64_encode($row['request_id']).'/'.base64_encode($row['oprid']),'New');
                $reject_status='Accepted'; 
            }
            if($row['dataentry_by']==0){
                $dstatus='Candidate Entry';
            }
            else if($row['dataentry_by']==1){
                $dstatus='Partial Entry';
            }
            else if($row['dataentry_by']==2){
                $dstatus='Full Entry';
            }
            else if($row['dataentry_by']==3){
                $dstatus='Offline Entry';
            }
            else {
                $dstatus='';
            }
              

            if($request_status=='Assigned'){
            $response->rows [$i] ['cell'] = array ( $check,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'], anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']), $row['case_no'],$row['order_name'],$request_status,$reject_reason,$dstatus,$row['first_name'],$reject_status, $deadline_to,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View') );
            }else {
            if($reject_status=='Reject Raised'){
                $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id']).'" disabled/>';
            }
            else{
                $check='<input type="checkbox" name="request_id[]" value="'.($row['request_id']).'" />';
            }
            $response->rows [$i] ['cell'] = array ( $check,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'], anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']), $row['case_no'],$row['order_name'],$request_status,$reject_reason,$dstatus,$row['first_name'], $reject_status, $deadline_to,anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),'View') );

            }
            }
        }
        echo json_encode($response);
        }




        /********* updateunlimited *********
       **** function updateunlimited******
       ************************************/
       function completeunlimited(){
         // print_r($_POST);exit;

        $request_id=$_POST['request_id'];
        $check_id=$_POST['check_id'];
        // $no_check=$_POST['check_no'];
        $package_id=$_POST['package_id'];

        if($check_id==59){
            $where1 = '(req_id="'.$request_id.'")';
            $this->db->select('count(*) as empcount');
            $this->db->where($where1);
            $empCnt=$this->db->get(DB_PREFIX.'employment')->row_array();
            $count=$empCnt['empcount'];
        }
        if($check_id==640){
            $where1 = '(request_id="'.$request_id.'")';
            $this->db->select('count(*) as courtRcount');
            $this->db->where($where1);
            $empCnt=$this->db->get(DB_PREFIX.'court_record_check')->row_array();
            $count=$empCnt['courtRcount'];
        }

        $where = '(request_id="'.$request_id.'" AND check_id = "'.$check_id.'" AND package_id > 0)';

        $data = array(
        'no_checks'=> $count,
        'full_info'=>99 
        );
        $this->db->set($data);
        $this->db->where($where);
        $res=$this->db->update(DB_PREFIX.'request_check');       
        
       }



     /*********************************
     ***** exportForm_pdf ************
     * *******************************/
    function exportForm_pdf($pdfresult, $cand_name)
    {
        $request_id = base64_decode($this->uri->segment(3));
        // $candidate_info = $this->rm->get_candidateionfo($request_id);
        // $candidate_info['candidate_name'] = rtrim(($candidate_info['candidate_name']), '.');
        //echo $pdfresult['html'];exit;
        
        require_once("./dom_pdf/dompdf_config.inc.php");
        $html=mb_convert_encoding($pdfresult['html'], 'HTML-ENTITIES', 'UTF-8'); 
        $pdf = (object)$html;
        
        $dompdf = new DOMPDF();
        $dompdf->load_html($html);
        $dompdf->render();
        $canvas = $dompdf->get_canvas();
        $font = Font_Metrics::get_font("Times New Roman", "oblique");
        $canvas->page_text(500, 780, "Confidential {PAGE_NUM} / {PAGE_COUNT}",
                   $font, 10, array(0,0,0));
        $filename=$cand_name."_".date('d_m_Y_H_i_s').".pdf";
         $output1 = $dompdf->output($filename);

        $output = $dompdf->stream($filename);

    }

    function genPdf(){

        $request_id = base64_decode($this->uri->segment(3));
        echo $chekuri=$this->uri->segment(4);

        $check_id=$chekuri=$this->uri->segment(4);
        $role_id=$this->session->userdata('role_id');
        
        $orderid = $this->db->query("select order_id,candidate_name, deadline_from, deadline_to,dataentry_by,assainee_status,status_of_candidate,o.office_name,b.office_name as branch_office,s.office_name as sub_office ,org_name,revert_status , u.submit_date
            from ". DB_PREFIX ."client_request as c LEFT JOIN ". DB_PREFIX ."office as o ON o.id=c.parent_office
            LEFT JOIN ". DB_PREFIX ."office as b ON b.id=c.office
            LEFT JOIN ". DB_PREFIX ."office as s ON s.id=c.sub_office
            LEFT JOIN ". DB_PREFIX ."organisation as org ON org.id=o.parentoffice_id
            LEFT JOIN ". DB_PREFIX ."user as u ON u.id = c.user_id
            where request_id=". $request_id)->row(); 
            $now = date('Y-m-d');
            
            if($this->session->userdata['user_type'] == 1) { 
                if( ($orderid->deadline_from <= $now && $orderid->deadline_to >= $now ) &&  $orderid->assainee_status == 1  ) { 
                    $duration = 1; 
                }
            } 
            else  if($this->session->userdata['user_type'] == 2 ) { 
                if( ($orderid->dataentry_by == 1 || $orderid->dataentry_by == 2) && $orderid->assainee_status <> 1 ){ 
                    $duration = 1; 
                }
            }
            $duration = 1;
            $org_checks=$orderid;

            if(isset($orderid->sub_office)){
            $candidate_name = ($orderid->candidate_name) ? ($orderid->candidate_name.' ( '.$orderid->org_name.', '.$orderid->sub_office.' )') : '';
            }
            elseif(isset($orderid->branch_office)){
               $candidate_name = ($orderid->candidate_name) ? ($orderid->candidate_name.' ( '.$orderid->org_name.', '.$orderid->branch_office.' )') : ''; 
            }
            else
            {
                $candidate_name = ($orderid->candidate_name) ? ($orderid->candidate_name.' ( '.$orderid->org_name.', '.$orderid->office_name.' )') : '';
            }

            $cand_name = $orderid->candidate_name;
            
        $status=$this->amodel->getDetails(DB_PREFIX.'submit_cv','status as entry_status,client_status,operator_status,candidate_status,vm_revert_option_status,verification_status,reverted_reason,reverted_by',array('request_id'=>$request_id));
        //print_r($status);exit;
        $checklevels = $this->dm->checklevels($request_id,$check_id);

        foreach($checklevels as $level){
        
            if($level['id']>1023 && $level['id'] !=1306 ){
                $levels[]=$level['description'];
            }
            else{
                $levels[]=$level['id'];
            }
        }
        $clevels=$levels;
        
        $pdfresult=$this->pdfexport->generateForm_pdf($request_id,$chekuri,$checklevels,$clevels,$status,$duration,$org_checks,$role_id, $candidate_name);
        $pdfFile=$this->exportForm_pdf($pdfresult, $cand_name);

        return $pdfFile;
    }



    function exportdoc_pdf()
    {
        $request_id = base64_decode($this->uri->segment(3));

        $orderid = $this->db->query("select order_id,candidate_name, deadline_from, deadline_to,dataentry_by,assainee_status,status_of_candidate,o.office_name,b.office_name as branch_office,s.office_name as sub_office ,org_name,revert_status , u.submit_date
            from ". DB_PREFIX ."client_request as c 
            LEFT JOIN ". DB_PREFIX ."office as o ON o.id=c.parent_office
            LEFT JOIN ". DB_PREFIX ."office as b ON b.id=c.office
            LEFT JOIN ". DB_PREFIX ."office as s ON s.id=c.sub_office
            LEFT JOIN ". DB_PREFIX ."organisation as org ON org.id=o.parentoffice_id
            LEFT JOIN ". DB_PREFIX ."user as u ON u.id = c.user_id
            where request_id=". $request_id)->row(); 

        $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('id','concat_ws(" ",firstname,middlename,lastname) as firstname','user_image'), array('user_id' => $request_id));
        
        $filename = $orderid->candidate_name;

            if(!empty($personal_details)){
                
                $temp= explode('.',$personal_details[0]['user_image']);
                $extension = end($temp);
                
                $document_file='uploads/verified_user_photo/thumb/'.$personal_details[0]['user_image'];
                $address_proof='Personal Details/User Photo.'.$extension; 
                $this->zip->read_file($document_file,$address_proof);

                $additional_documents = $this->amodel->getDetails(DB_PREFIX . "personal_additional_doc", array('additional_doc'), array('request_id' => $request_id,'status'=>'1','check_id'=>'0','ref_id'=>'0'));
                $extension='';
                foreach($additional_documents as $keyy=>$Additem)
                {   
                    $temp= explode('.',$Additem['additional_doc']);
                    $extension = end($temp);                     
                    $additional_doc=$Additem['additional_doc'];
                    $nameAdd='Personal Details/Personal_additional_doc'.($keyy+1).'.'.$extension; 
                    $this->zip->read_file($additional_doc,$nameAdd);  
                }
            }

        
            $this->db->select('check_id');
            $resultdata =$this->db->get_where(DB_PREFIX .'request_check',array('request_id'=> $request_id ))->result_array();

        foreach($resultdata as $Value)
        {
            $checkId=$Value['check_id'];

            $this->db->select('*');
            $checkRes =$this->db->get_where(DB_PREFIX .'document_download',array('check_id'=> $checkId ))->result_array();

            if(!empty($checkRes))
            {   
                foreach($checkRes as $checkVal)
                {
                    $select=$checkVal['doc_fields'];

                    if($checkVal['check_id']==59){
                        $where="req_id =".$request_id;    
                    }else{
                        $where="request_id =".$request_id;
                    }
                        
                    $table=$checkVal['table_name'];
                    if($checkVal['check_id']){
                        $Check_data=$this->amodel->getDoc_Details($select,$where,$table);
                    }    
                        
                }                
                $key='';
                $doc_extension='';
                $gdoc_extension='';
                $pdoc_extension='';
                $cons_extension='';
                $emp_extension='';
                $rel_extension='';
                $ser_extension='';
                $adrPextension='';
                foreach($Check_data as $key=>$item)
                {
                    $id=$item['id'];

                    if(!empty($item['document_file'])){
                        $temp= explode('.',$item['document_file']);
                        $doc_extension = end($temp);    
                    }
                    if(!empty($item['gdocument'])){
                        $temp= explode('.',$item['gdocument']);
                        $gdoc_extension = end($temp);    
                    }
                    if(!empty($item['pdocument'])){
                        $temp= explode('.',$item['pdocument']);
                        $pdoc_extension = end($temp);    
                    }
                    if(!empty($item['consolidate_doc'])){
                        $temp= explode('.',$item['consolidate_doc']);
                        $cons_extension = end($temp);   
                    }
                    
                    if($item['checkid']==14){
                        $degree=$item['degree'];
                        if($item['docustatus']==1){
                            $document_file='uploads/candidate/document/'.$item['document_file'];
                            $Consolidated='Education/'.$degree.'_Consolidated marks'.($key+1).'.'.$doc_extension;
                            $this->zip->read_file($document_file,$Consolidated);     
                        }
                        if($item['grade_status']==1){
                            $gdocument='uploads/candidate/document/'.$item['gdocument']; 
                            $Degree='Education/'.$degree.'_Degree Certificate '.($key+1).'.'.$gdoc_extension; 
                            $this->zip->read_file($gdocument,$Degree);
                        }
                        if($item['provisional_status']==1){
                            $pdocument='uploads/candidate/document/'.$item['pdocument'];
                            $Provisional='Education/'.$degree.'_Provisional Degree Certificate'.($key+1).'.'.$pdoc_extension;
                            $this->zip->read_file($pdocument,$Provisional);
                        }
                        if(!empty($item['consolidate_doc'])){
                            $consolidate_doc='uploads/candidate/document/'.$item['consolidate_doc'];
                            $all_years_marks='Education/'.$degree.'_Photocopy of all years marks cards'.($key+1).'.'.$cons_extension;
                            $this->zip->read_file($consolidate_doc,$all_years_marks);
                        }
                        

                        $additional_upload_documents = $this->amodel->getDetails(DB_PREFIX . "personal_additional_doc", array('additional_doc'), array('request_id' => $request_id,'status'=>'1','ref_id'=>$id));

                            $adddoc_extension='';
                            foreach($additional_upload_documents as $keyy=>$Additem)
                            {
                                $temp= explode('.',$Additem['additional_doc']);
                                $adddoc_extension = end($temp);                        
                                $additional_doc=$Additem['additional_doc'];
                                $nameAdd='Education/'.$degree.'_additional_doc'.($keyy+1).'.'.$adddoc_extension; 
                                $this->zip->read_file($additional_doc,$nameAdd);  
                            }
                    }

                    if(!empty($item['employement_file'])){
                        $temp= explode('.',$item['employement_file']);
                        $emp_extension = end($temp);   
                    }
                    if(!empty($item['relieve_document'])){
                        $temp= explode('.',$item['relieve_document']);
                        $rel_extension = end($temp);   
                    }
                    if(!empty($item['service_document'])){
                        $temp= explode('.',$item['service_document']);
                        $ser_extension = end($temp);   
                    }
                     
                    if($item['checkid']==59){
                        $company=$item['company_name'];
                    
                        // if($item['edocustatus']==1){
                            $employement_file=($item['edocustatus']==1) ? 'uploads/candidate/document/'.$item['employement_file'] : '';
                            $nameEmp='Employment/'.$company.'_employement_file'.($key+1).'.'.$emp_extension;
                            $this->zip->read_file($employement_file,$nameEmp);
                        // }
                        //if($item['relieve_status']==1){
                            $relieve_document=($item['relieve_status']==1) ? 'uploads/candidate/document/'.$item['relieve_document'] : '';
                            $nameRel='Employment/'.$company.'_relieve_document'.($key+1).'.'.$rel_extension;
                            $this->zip->read_file($relieve_document,$nameRel);
                        //}
                        //if($item['relieve_status']==1){
                            $service_document=($item['service_status']==1) ? 'uploads/candidate/document/'.$item['service_document'] : '';
                            $nameServ='Employment/'.$company.'_service_document'.($key+1).'.'.$ser_extension; 
                            $this->zip->read_file($service_document,$nameServ);   
                        //}

                            $additional_upload_documents = $this->amodel->getDetails(DB_PREFIX . "personal_additional_doc", array('document_name','additional_doc'), array('request_id' => $request_id,'status'=>'1','ref_id'=>$id));
                            $additional_doc='';
                            foreach($additional_upload_documents as $keyy=>$Additem)
                            {
                                $temp= explode('.',$Additem['additional_doc']);
                                $adddoc_extension = end($temp);                        
                                $additional_doc=$Additem['additional_doc'];
                                $nameAdd='Employment/'.$company.'_additional_doc'.($keyy+1).'.'.$adddoc_extension; 
                                $this->zip->read_file($additional_doc,$nameAdd);  
                            }        
                    }

                        if(!empty($item['address_proof'])){
                            $temp= explode('.',$item['address_proof']);
                            $adrPextension = end($temp);   
                        }

                        if($item['checkid']==15){
                            // $degree=$item['degree'];
                            $document_file='uploads/candidate/document/'.$item['address_proof'];
                            $address_proof='Permanent Address/Permanent_Address Proof'.($key+1).'.'.$adrPextension;
                            if(!empty($item['address_proof'])){
                                $this->zip->read_file($document_file,$address_proof);
                            }
                        }

                        if($item['checkid']==16){
                            $document_file='uploads/candidate/document/'.$item['address_proof'];
                            $address_proof='Current Address/Current_Address Proof'.($key+1).'.'.$adrPextension;
                            if(!empty($item['address_proof'])){
                                $this->zip->read_file($document_file,$address_proof);
                            }    
                        }

                        if($item['checkid']==70){
                            $document_file='uploads/candidate/document/'.$item['address_proof'];
                            $address_proof='Police Permanent Address/Police Permanent_Address Proof'.($key+1).'.'.$adrPextension;
                            if(!empty($item['address_proof'])){
                                $this->zip->read_file($document_file,$address_proof);
                            }
                             
                        }

                        if($item['checkid']==631){
                            $document_file='uploads/candidate/document/'.$item['address_proof'];
                            $address_proof='Aadhar Card/Aadhar_Address Proof'.($key+1).'.'.$adrPextension;
                            if(!empty($item['address_proof'])){
                                $this->zip->read_file($document_file,$address_proof);
                            }
                              
                        }

                        if($item['checkid']==632){
                            $document_file='uploads/candidate/document/'.$item['address_proof'];
                            $address_proof='PAN Card/PAN_Address Proof'.($key+1).'.'.$adrPextension;
                            if(!empty($item['address_proof'])){
                                $this->zip->read_file($document_file,$address_proof);
                            }
                             
                        }

                        if($item['checkid']==633){
                            $document_file='uploads/candidate/document/'.$item['address_proof'];
                            $address_proof='Voter ID/VoterID_Address Proof'.($key+1).'.'.$adrPextension;
                            if(!empty($item['address_proof'])){
                                $this->zip->read_file($document_file,$address_proof);
                            }
                             
                        }

                        if($item['checkid']==634){
                            $document_file='uploads/candidate/document/'.$item['address_proof'];
                            $address_proof='Passport/Passport_Address Proof'.($key+1).'.'.$adrPextension;
                            if(!empty($item['address_proof'])){
                                $this->zip->read_file($document_file,$address_proof);
                            }
                             
                        }
                        if($item['checkid']==635){
                            $document_file='uploads/candidate/document/'.$item['address_proof'];
                            $address_proof='Driving Licence/DrivingLicence_Address Proof'.($key+1).'.'.$adrPextension;
                            if(!empty($item['address_proof'])){
                                $this->zip->read_file($document_file,$address_proof); 
                            }
                            
                        }
                        if($item['checkid']==636){
                            $document_file='uploads/candidate/document/'.$item['address_proof'];
                            $address_proof='Cibil/Cibil_Address Proof'.($key+1).'.'.$adrPextension;
                            if(!empty($item['address_proof'])){
                                $this->zip->read_file($document_file,$address_proof);
                            }
                             
                        }
                        if($item['checkid']==637){
                            $document_file='uploads/candidate/document/'.$item['address_proof'];
                            $address_proof='Form 16/Form16_Address Proof'.($key+1).'.'.$adrPextension;
                            if(!empty($item['address_proof'])){
                                $this->zip->read_file($document_file,$address_proof);
                            }
                             
                        }
                        if($item['checkid']==638){
                            $document_file='uploads/candidate/document/'.$item['address_proof'];
                            $address_proof='Police Current Address/Police Current_Address Proof'.($key+1).'.'.$adrPextension;
                            if(!empty($item['address_proof'])){
                                $this->zip->read_file($document_file,$address_proof);
                            }
                             
                        }
                        if($item['checkid']==641){
                            $document_file='uploads/candidate/document/'.$item['address_proof'];
                            $address_proof='OFAC/OFAC_Address Proof'.($key+1).'.'.$adrPextension;
                            if(!empty($item['address_proof'])){
                                $this->zip->read_file($document_file,$address_proof); 
                            }
                        }
                        if($item['checkid']==642){
                            $document_file='uploads/candidate/document/'.$item['address_proof'];
                            $address_proof='US Travel/US Travel_Address Proof'.($key+1).'.'.$adrPextension;
                            if(!empty($item['address_proof'])){
                                $this->zip->read_file($document_file,$address_proof); 
                            }
                        }
                        if($item['checkid']==645){
                            $document_file='uploads/candidate/document/'.$item['address_proof'];
                            $address_proof='International Current Address/International Current_Address Proof'.($key+1).'.'.$adrPextension;
                            if(!empty($item['address_proof'])){
                                $this->zip->read_file($document_file,$address_proof); 
                            }
                        }
                        if($item['checkid']==646){
                            $document_file='uploads/candidate/document/'.$item['address_proof'];
                            $address_proof='International Permanent Address/International Permanent_Address Proof'.($key+1).'.'.$adrPextension;
                            if(!empty($item['address_proof'])){
                                $this->zip->read_file($document_file,$address_proof); 
                            }
                        }
                        if($item['checkid']==648){

                            $tds_documents = $this->amodel->getDetails(DB_PREFIX . "tds_doc", array('tds_proof'), array('request_id' => $request_id,'status'=>'1'));
                            $tdsextension='';
                            foreach($tds_documents as $keyy=>$Tdsitem)
                            { 
                                if(!empty($Tdsitem['tds_proof'])){
                                    $temp= explode('.',$Tdsitem['tds_proof']);
                                    $tdsextension = end($temp);   
                                }                       
                                $additional_doc=$Tdsitem['tds_proof'];
                                $nameAdd='Form 26AS/TDS Document'.($keyy+1).'.'.$tdsextension; 
                                if(!empty($Tdsitem['tds_proof'])){
                                    $this->zip->read_file($additional_doc,$nameAdd);  
                                }
                            } 
                        }
                        
                }
            }
            // *********************************** Document download for gap check ********************
            if($Value['check_id'] ==1306){
                       
                $additional_upload_documents = $this->amodel->getDetails(DB_PREFIX . "personal_additional_doc", array('additional_doc'), array('request_id' => $request_id,'status'=>'1','ref_id'=>$id));
                // print_r($additional_upload_documents);
                // echo $id;
                    

                    $adddoc_extension='';
                    
                    foreach($additional_upload_documents as $keyy=>$Additem)
                    {
                        $temp= explode('.',$Additem['additional_doc']);
                        $adddoc_extension = end($temp);                        
                        $additional_doc=$Additem['additional_doc'];
                        $nameAdd='Gap_Check/'.$gap.'_additional_doc'.($keyy+1).'.'.$adddoc_extension; 
                        // echo '<pre>';
                        // print_r($nameAdd);
                        $this->zip->read_file($additional_doc,$nameAdd);  
                    }
                    
            }
            // **************************************** end *******************************************        
        }

                $decleration_details = $this->dm->declerationdetails($request_id);

                if($decleration_details){


                    if($decleration_details[0]['doc_type'] == 1)
                    {
                        if(!empty($decleration_details[0]['user_decl_doc'])) {

                            $temp= explode('.',$decleration_details[0]['user_decl_doc']);
                            $extension = end($temp);
                            $extension;

                            //User Declaration
                            $document_file='uploads/prposaldetails/'.$decleration_details[0]['user_decl_doc'];
                            $address_proof='Declaration/User Declaration.'.$extension;
                            $this->zip->read_file($document_file,$address_proof); 
                        }

                        if(!empty($decleration_details[0]['company_decl_doc']))
                        {
                            $temp= explode('.',$decleration_details[0]['company_decl_doc']);
                            $extension = end($temp);
                            $extension;
                            $document_file='uploads/prposaldetails/'.$decleration_details[0]['company_decl_doc'];
                            $address_proof='Declaration/Authorization Letter.'.$extension;
                            $this->zip->read_file($document_file,$address_proof); 
                        }
                        
                    }
                    else
                    {

                        if(!empty($decleration_details[0]['user_declaration']))
                        {
                            $temp= explode('.',$decleration_details[0]['user_declaration']);
                            $extension = end($temp);
                            $extension;
                            $document_file='uploads/prposaldetails/'.$decleration_details[0]['user_declaration'];
                            $address_proof='Declaration/User Declaration.'.$extension;
                            $this->zip->read_file($document_file,$address_proof); 
                        }

                        if(!empty($decleration_details[0]['company_decl_doc']))
                        {
                            $temp= explode('.',$decleration_details[0]['company_decl_doc']);
                            $extension = end($temp);
                            $extension;

                            $document_file='uploads/prposaldetails/'.$decleration_details[0]['company_decl_doc'];
                            $address_proof='Declaration/Authorization Letter.'.$extension;
                            $this->zip->read_file($document_file,$address_proof); 
                        }
                              
                    }
                }
               

                $this->zip->download($filename);

    }
   
/*.......Priority .........*/

function add_priority(){

        $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));

        $data ['title'] = 'Add Priority';
        $data['subtitle']="add priority";
       
        
       
        $result=$data['checks_result']=$this->dm->getpriority($request_id); 
     //print_r($result); exit;
        $data['candidate_name']=$result[0]['candidate_name'];
        $data['user_id']= $result[0]['user_id'];
        $data['role_id']=$result[0]['role_id'];
        $data['case_no']=$result[0]['case_no'];
        //$data['date_ofupdate']=$result[0]['date_ofset'];
       // print_r($data);exit;
       $update_data = $data['cnt']= $this->dm->check_priority($data['request_id']);
       //print_r($update_data); exit;
            if($data['cnt']==0){ 

                $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        
       $this->breadcrumbs->push('Add Priority', 'Dadmin/add_priority');
       $data['breadcrumb']=$this->breadcrumbs->show(); 
       $data['priority']= 1;
        $this->amodel->pagerender($data, 'add_priority');
        //print_r($update_data); exit;
       } else{
                    $data['comments']= $update_data['comments'];
                    $data['priority']= $update_data['priority'];
                    $data['date_ofupdate']= $update_data['date_ofset'];
        // print_r($data);exit;
       $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        
       $this->breadcrumbs->push('Add Priority', 'Dadmin/add_priority');
       $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'add_priority');
      }
}




  function set_priority()
   {
        $data['request_id']=$_POST['request_id'];
        $data['case_no']=$_POST['case_no'];
        $data['user_id']=$_POST['user_id'];
        $data['comments']=$_POST['comments'];
        $data['date_ofset']=date('Y-m-d');
        $data['date_ofupdate']=date('Y-m-d');
        $data['priority'] =$_POST['priority'];
        $data['role_id']=$_POST['role_id'];
        $data['role_id']=$this->session->userdata('role_id');
      // print_r($rolesid);exit;
       //print_r($data);exit;
        $this->dm->insert_priority($data);
    //   


   }
    







   }

