<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require_once('Common.php');
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
class Dataentry extends Common
{
    function __construct()
    {
        parent::__construct();
        $this->_check_userlogin();

        $models = array('Dataentry_model' => 'dm', 'Notification_model' => 'nm', 'Dadmin_model' => 'dm');
        foreach ($models as $file => $object_name) {
            $this->load->model($file, $object_name);
        }
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid', 'timePicker'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'highcharts', 'exporting', 'jquery.validate', 'grid.locale-en', 'jquery.jqGrid.min', 'jquery-ui-1.8.16.custom.min', 'commonjs', 'jquery.datepick', 'multipleclone', 'autocomplete', 'jquery.timePicker'));
        $this->load->helper('text');
        $this->load->helper('cloneform');
    }
    /***************************************
     * personal_detailsadd
     * Personal details dataentry
     **************************************/
    function personal_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        //25/11/2023
        $data['current_stay_flag'] = $personal_details[0]['current_stay_flag'];
        /*****Displaying candidate name in personal details for full entry***/
        $candidate_data = $this->amodel->getDetails(DB_PREFIX . "client_request", array('user_id', 'dataentry_by', 'candidate_name'), array('request_id' => $request_id));
        if ($candidate_data[0]['dataentry_by'] == 2 && empty($personal_details)) {
            $personal_data =  $this->amodel->getDetails(DB_PREFIX . "user", array('first_name', 'last_name', 'email'),     array('id' => $candidate_data[0]['user_id']));
            $name =    explode(" ", $candidate_data[0]['candidate_name'], 2);
            $data['firstname_edit'] =  $name[0];
            $data['lastname_edit']  =  $name[1];
            $data['email_id_edit'] =  $personal_data[0]['email'];
        }


        //for displaying name on title
        $this->db->select('organisation,order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';
        //get Organozation
        $this->db->select('name_as');
        $org_text = $this->db->get_where(DB_PREFIX . 'organisation', array('id' => $orderid[0]['organisation']))->result_array();
        $data['name_as'] = ($org_text[0]['name_as']) ? $org_text[0]['name_as'] : '';

        $skillsadd_clones = array(array('document_name' => array('text', 'document_name', '', '', '', '', ''), 'additional_doc' => array('upload', 'additional_doc', '', '', '', '', '')));
        $data['skills_file_clone'] = create_cloneform($skillsadd_clones, '', $user_id);
        $data['upload_file'] = formclonecreation($skillsadd_clones, $data['skills_file_clone'], 1, 'Add Document', "Personal Document");
        $personal_details = $personal_details[0];
        foreach ($personal_details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $current_tel_no = explode('-', $personal_details['current_tel_no']);
        $data['current_country'] = $current_tel_no[0];
        $data['current_city'] = $current_tel_no[1];
        $data['current_no'] = $current_tel_no[2];
        $permanent_tel_no = explode('-', $personal_details['permanent_tel_no']);
        $data['permanent_country'] = $permanent_tel_no[0];
        $data['permanent_city'] = $permanent_tel_no[1];
        $data['permanent_no'] = $permanent_tel_no[2];
        $office_tel_no = explode('-', $personal_details['office_tel_no']);
        $data['office_country'] = $office_tel_no[0];
        $data['office_city'] = $office_tel_no[1];
        $data['office_no'] = $office_tel_no[2];
        $this->amodel->pagerender($data, 'add_personal_details');
    }
    /***************************************
     * current_address_detailsadd
     * Current Address details of dataentry
     **************************************/
    function current_address_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['contact_details'] = $contact_details = $this->amodel->getDetails(DB_PREFIX . "contact_details", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($contact_details)) {
            $details = $personal_details[0];
        } else {
            $details = $contact_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $current_tel_no = explode('-', $details['current_tel_no']);
        $data['current_country'] = $current_tel_no[0];
        $data['current_city'] = $current_tel_no[1];
        $data['current_no'] = $current_tel_no[2];
        $permanent_tel_no = explode('-', $details['permanent_tel_no']);
        $data['permanent_country'] = $permanent_tel_no[0];
        $data['permanent_city'] = $permanent_tel_no[1];
        $data['permanent_no'] = $permanent_tel_no[2];
        if (empty($contact_details)) {
            $office_tel_no = explode('-', $details['office_tel_no']);
            $data['coffice_country'] = $office_tel_no[0];
            $data['coffice_city'] = $office_tel_no[1];
            $data['coffice_no'] = $office_tel_no[2];
            $data['cmobile_edit'] = $details['mobile'];
        } else {
            $coffice_tel_no = explode('-', $details['coffice_tel_no']);
            $data['coffice_country'] = $coffice_tel_no[0];
            $data['coffice_city'] = $coffice_tel_no[1];
            $data['coffice_no'] = $coffice_tel_no[2];
        }
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'add_contact_details');
    }
    /*********************************************
     * addpersonal
     * Add personal details
     **********************************************/
    function addpersonal($id = null)
    {
        $this->dm->personaldml($id, $user_id);
    }
    /******************************************
     * addcontact
     * Add Contact details
     **********************************************/
    function addcontact($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->contactdml($id);
    }
    /********************************************
     * permanent_address_detailsadd
     * Permanent Address details of Dataentry
     **********************************************/
    function permanent_address_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['contact_details'] = $contact_details = $this->amodel->getDetails(DB_PREFIX . "permanent_contact_details", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($contact_details)) {
            $details = $personal_details[0];
        } else {
            $details = $contact_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $current_tel_no = explode('-', $details['current_tel_no']);
        $data['current_country'] = $current_tel_no[0];
        $data['current_city'] = $current_tel_no[1];
        $data['current_no'] = $current_tel_no[2];
        $permanent_tel_no = explode('-', $details['permanent_tel_no']);
        $data['permanent_country'] = $permanent_tel_no[0];
        $data['permanent_city'] = $permanent_tel_no[1];
        $data['permanent_no'] = $permanent_tel_no[2];
        $office_tel_no = explode('-', $details['office_tel_no']);
        $data['office_country'] = $office_tel_no[0];
        $data['office_city'] = $office_tel_no[1];
        $data['office_no'] = $office_tel_no[2];
        $coffice_tel_no = explode('-', $details['coffice_tel_no']);
        $data['coffice_country'] = $coffice_tel_no[0];
        $data['coffice_city'] = $coffice_tel_no[1];
        $data['coffice_no'] = $coffice_tel_no[2];
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'add_contact_details');
    }
    /****************************************
     * addpermanentcontact
     * Add permanent address details
     *****************************************/
    function addpermanentcontact($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->permanentcontactdml($id);
    }
    /****************************************
     * other_detailsadd
     * Other details of detaentry
     *****************************************/
    function other_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        //for displaying name on title
        $this->db->select('order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';
        $other_details = $this->amodel->getDetails(DB_PREFIX . "other_details", array('*'), array('user_id' => $request_id));
        $data['other_details'] = $other_details[0];
        $this->amodel->pagerender($data, 'add_other_details');
    }
    /****************************************
     * addother
     * Add Other details of detaentry
     *****************************************/
    function addother($id = null)
    {
        $this->dm->otherdml($id, $user_id);
    }
    /****************************************
     * education_detailsadd
     * Education details of detaentry
     *****************************************/
    function education_detailsadd()
    {
        $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(4));
        $data['education_id'] = $education_id = base64_decode($this->uri->segment(5));
        $data['check_level'] = $checkda = $this->dm->getcheck($request_id);
        $skillsadd_clones = array(array('document_name' => array('text', 'document_name', '', '', '', '', ''), 'additional_doc' => array('upload', 'additional_doc', '', '', '', '', '')));
        $data['skills_file_clone'] = create_cloneform($skillsadd_clones, '', $user_id);
        $data['upload_file'] = formclonecreation($skillsadd_clones, $data['skills_file_clone'], 1, 'Add Document', "Educational Document");
        /* foreach($checkda as $cd){*/
        $data['edu_details'] = $edu_details = $this->dm->educationdetails($request_id, $education_id);
        $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        $data['personal_details'] = $personal_details[0];
        $data['edu_levels'] = $edu_levels = $this->dm->getedulevels($request_id);
        /* }*/

        //for displaying name on title
        $this->db->select('order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->row();
        $data['candidate_name'] = ($orderid->candidate_name) ? '( ' . $orderid->candidate_name . ' )' : '';
        $this->amodel->pagerender($data, 'add_education_details');
    }
    /****************************************
     * addeducation
     * Add Education details of detaentry
     *****************************************/
    function addeducation()
    {
        $this->dm->educationdml();
    }
    /****************************************
     * declaration_detailsadd
     * Declaration details of detaentry
     *****************************************/
    function declaration_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        //for displaying name on title

        $this->db->select('order_id,candidate_name,revert_status');
        $data['orderid'] = $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->row();
        $data['candidate_name'] = ($orderid->candidate_name) ? '( ' . $orderid->candidate_name . ' )' : '';
        $poffice = $this->session->userdata('parent_office');
        $declaration = $this->dm->declarationdata($request_id);
        $data['declaration_data'] = $declaration; //print_r($declaration);exit;
        $other_details = $this->amodel->getDetails(DB_PREFIX . "declaration_details", array('*'), array('user_id' => $request_id));
        $data['declar_details'] = $other_details[0];
        $this->amodel->pagerender($data, 'add_declaration_details');
    }
    /****************************************
     * adddeclaration
     * Add Declaration details of detaentry
     *****************************************/
    function adddeclaration($id = null, $check_level = null)
    {
        //echo '<pre>';print_r($_POST);exit;

        if ($_POST['doc_type'] == 1) {
            $decl_content = $_POST['decl_letter'];

            $temp = array();
            $config['allowed_types'] = 'jpg|png|jpeg';
            $config['upload_path'] = 'uploads/prposaldetails/';
            $config['encrypt_name'] = true;
            $config['remove_spaces'] = true;

            $this->load->library('upload', $config);
            $count = count($_FILES['signature']['size']);
            foreach ($_FILES as $key => $value) {
                $_FILES['company_declr']['name'] = $value['name'] . date('d_m_Y_H_i_s');
                $_FILES['company_declr']['type']    = $value['type'];
                $_FILES['company_declr']['tmp_name'] = $value['tmp_name'];
                $_FILES['company_declr']['error']       = $value['error'];
                $_FILES['company_declr']['size']    = $value['size'];
                if ($this->upload->do_upload('signature')) {
                    $documents[$key]  = $this->upload->data();
                }
                // else
                // {
                //   echo ($documents['upload_error'] = $this->upload->display_errors());
                // } 
            }
            $signImg = $documents['signature']['file_name'];
            chmod(getcwd() . "/uploads/prposaldetails/" . $signImg, 0777);

            if (!empty($_POST['user_id']) && !empty($signImg)) {
                $this->db->update(DB_PREFIX . "declaration_details", array('user_decl_doc' => ''), array('user_id' => $_POST['user_id']));
            }

            if (!empty($_POST['user_id']) && empty($signImg)) {
                $this->db->select('signature');
                $editdoc = $this->db->get_where('dcode_declaration_details ', array('user_id' => $_POST['user_id']))->row_array();
                $signImg = $editdoc['signature'];
            }

            $date = date('d-m-Y');


            $signImg_path = base_url('/uploads/prposaldetails/' . $signImg);
            $candidate = strtoupper($_POST['cand_name']);

            $pdf_file_path1 = $this->content_manager($_POST['auth_letter'], $signImg_path, $candidate, $date, "auth_letter");
        }

        $check_level = $data['check_level'] = $this->dm->getcheck($id);
        $this->dm->declarationdml($id, $pdf_file_path1, $signImg);
    }
    /****************************************
     * employment_detailsadd
     * Employment details of detaentry
     *****************************************/
    function employment_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));

        $data['check_id'] = $check_id = base64_decode($this->uri->segment(4));
        $levelId = $data['employement_id'] = base64_decode($this->uri->segment(5));
        $employement_details = $this->amodel->getDetails(DB_PREFIX . "employment", array('*'), array('req_id' => $request_id, 'id' => $levelId));

        $data['emp_record'] = $this->amodel->getDetails(DB_PREFIX . "employment", array('*'), array('req_id' => $request_id));

        $data['check_level'] = $checkda = $this->dm->getcheck($request_id);
        $skillsadd_clones = array(array('document_name' => array('text', 'document_name', '', '', '', '', ''), 'additional_doc' => array('upload', 'additional_doc', '', '', '', '', '')));
        $data['skills_file_clone'] = create_cloneform($skillsadd_clones, '', $user_id);
        $data['upload_file'] = formclonecreation($skillsadd_clones, $data['skills_file_clone'], 1, 'Add Document', "Employment Document");
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('id', 'user_id', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', 'primary_skill', 'experience', 'experience_month', 'passport', 'passport_expire', 'place_of_issue', 'date_of_issue', 'license_no', 'valid_up_to', 'nationality', 'date_of_birth', 'gender', 'marital', 'SSN', 'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'current_tel_no', 'permanent_tel_no', 'office_tel_no', 'mobile', 'alter_email_id', 'user_image', 'upload_doc', 'created_by', 'created_on', 'updated_by'), array('user_id' => $request_id));
        //for checking education details  
        $data['edu_levels'] = $edu_levels = $this->dm->getedulevels($request_id);
        $data['emp_levels'] = $emp_levels = $this->dm->getemplevels($request_id, $levelId);
        $employement_details = $employement_details[0];
        $personal_details = $personal_details[0];
        if (empty($employement_details)) {
            $details = $personal_details;
        } else {
            $details = $employement_details;
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $data['dstatus'] = $details['edocustatus'];
        $data['remarks'] = $details['edocument_remarks'];
        $data['document'] = $details['employement_file'];
        $data['service_document'] = $details['service_document'];
        $data['relieve_document'] = $details['relieve_document'];
        $data['relieve_status'] = $details['relieve_status'];
        $data['service_status'] = $details['service_status'];
        $data['relieve_remarks'] = $details['relieve_remarks'];
        $data['service_remarks'] = $details['service_remarks'];
        $data['currently_working'] = $details['currently_working'];
        $data['reference_taken'] = $details['reference_taken'];
        $data['user_image_edit'] = $personal_details['user_image'];
        $data['document_edit'] = $personal_details['upload_doc'];
        $this->amodel->pagerender($data, 'employment_detailsadd');
    }
    /****************************************
     * addemployement
     * Add Employment details of detaentry
     *****************************************/
    function addemployement()
    {
        $this->dm->employmentdml();
    }
    /****************************************
     *  professional_reference_detailsadd
     * Porfessional reference check details of detaentry
     *****************************************/
    function professional_reference_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['checkid'] = $check_id = base64_decode($this->uri->segment(4));
        $checkid = $data['check_id'] = base64_decode($this->uri->segment(5));
        $data['check_level'] = $checkda = $this->dm->getcheck($request_id);
        $professional_details = $this->amodel->getDetails(DB_PREFIX . "professional_reference", array('*'), array('request_id' => $request_id, 'id' => $checkid));
        $employement_details = $this->amodel->getDetails(DB_PREFIX . "employment", array('*'), array('req_id' => $request_id), " check_type");
        $employement_details = $employement_details[0];
        $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('title', 'firstname', 'middlename', 'lastname'), array('user_id' => $request_id));
        $personal_details = $personal_details[0];
        $prof_details = $this->amodel->getDetails(DB_PREFIX . "professional_reference", array('*'), array('request_id' => $request_id));
        $prof_count = count($prof_details);
        if (empty($professional_details) && !empty($employement_details) && $prof_count == 0) {
            $details = $employement_details;
            $data['period_of_profref_edit'] = $details['period_of_employment'];
            $data['period_others_edit'] = $details['period_others_emp'];
            $details['check_status_reason'] = '';
        } else if (empty($professional_details) && empty($employement_details) && $prof_count == 0) {
            $details = $personal_details;
        } else if (empty($professional_details) && $prof_count >= 1) {
            $details = $personal_details;
        } else {
            $details = $professional_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $data['user_image_edit'] = $personal_details['user_image'];
        $this->amodel->pagerender($data, 'professional_reference_detailsadd');
    }
    /****************************************
     * add_professional
     * Add Porfessional reference check details of detaentry
     *****************************************/
    function add_professional()
    {
        //$formData=$_POST;
        $this->dm->save_professional();
    }
    /****************************************
     * personal_reference_detailsadd
     * Personal reference check details of detaentry
     *****************************************/
    function personal_reference_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['checkid'] = $check_id = base64_decode($this->uri->segment(4));
        $checkid = $data['check_id'] = base64_decode($this->uri->segment(5));
        $personal_reference_details = $this->amodel->getDetails(DB_PREFIX . "personal_reference", array('*'), array('request_id' => $request_id, 'id' => $checkid));
        $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        $personal_details = $personal_details[0];
        if (empty($personal_reference_details)) {
            $details = $personal_details;
        } else {
            $details = $personal_reference_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $data['user_image_edit'] = $personal_details['user_image'];
        $this->amodel->pagerender($data, 'personal_reference_detailsadd');
    }
    /****************************************
     * save_personal_reference
     * Add Personal reference check details of detaentry
     *****************************************/
    function save_personal_reference()
    {
        $formData = $_POST;
        $this->dm->save_personal_reference($formData);
    }
    /****************************************
     * police_permanent_address_verification_detailsadd
     * Police permanent address check details of detaentry
     *****************************************/
    function police_permanent_address_verification_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['checkid'] = $check_id = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['police_verification_details'] = $police_verification_details = $this->amodel->getDetails(DB_PREFIX . "police_permanent_address_verification", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        $data['contact_details'] = $contact_details = $this->amodel->getDetails(DB_PREFIX . "contact_details", array('*'), array('request_id' => $request_id));
        $data['permanent_contact_details'] = $permanent_contact_details = $this->amodel->getDetails(DB_PREFIX . "permanent_contact_details", array('*'), array('request_id' => $request_id));
        if (empty($police_verification_details) && empty($contact_details[0])) {
            $details = $personal_details[0];
        } else if (empty($police_verification_details) && !empty($contact_details[0]) && !empty($permanent_contact_details[0])) {
            $details = $personal_details[0];
        } else {
            $details = $police_verification_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $current_tel_no = explode('-', $details['current_tel_no']);
        $data['current_country'] = $current_tel_no[0];
        $data['current_city'] = $current_tel_no[1];
        $data['current_no'] = $current_tel_no[2];
        $permanent_tel_no = explode('-', $details['permanent_tel_no']);
        $data['permanent_country'] = $permanent_tel_no[0];
        $data['permanent_city'] = $permanent_tel_no[1];
        $data['permanent_no'] = $permanent_tel_no[2];
        $office_tel_no = explode('-', $details['office_tel_no']);
        $data['office_country'] = $office_tel_no[0];
        $data['office_city'] = $office_tel_no[1];
        $data['office_no'] = $office_tel_no[2];
        if (empty($police_verification_details)) {
            $office_tel_no = explode('-', $details['office_tel_no']);
            $data['coffice_country'] = $office_tel_no[0];
            $data['coffice_city'] = $office_tel_no[1];
            $data['coffice_no'] = $office_tel_no[2];
        } else {
            $coffice_tel_no = explode('-', $details['coffice_tel_no']);
            $data['coffice_country'] = $coffice_tel_no[0];
            $data['coffice_city'] = $coffice_tel_no[1];
            $data['coffice_no'] = $coffice_tel_no[2];
        }
        $data['address_proof'] = $details['address_proof'];
        $data['user_image_edit'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'police_permanent_address_verification_detailsadd');
    }
    /****************************************
     * save_police_permanent_address_verificaion
     * Add Police permanent address check details of detaentry
     *****************************************/
    function save_police_permanent_address_verificaion($id = null)
    {
        $Mobile = $this->encryption->encrypt($_POST['mobile']);
        $formData = $_POST;
        $formData['mobile'] = $Mobile;
        $id = base64_decode($id);
        $this->dm->save_police_permanent_address_verificaion($formData, $id);
    }
    /****************************************
     * court_record_check_india_detailsadd
     * Court Record check India details of detaentry
     *****************************************/
    function court_record_check_india_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['checkid'] = $check_id = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['court_record_check_details'] = $court_record_check_details = $this->amodel->getDetails(DB_PREFIX . "court_record_check_india", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('title', 'firstname', 'middlename', 'lastname', 'date_of_birth', 'husband_name', 'father_name'), array('user_id' => $request_id));
        if (!empty($data['personal_details'])) {
            if (empty($court_record_check_details)) {
                $details = $personal_details[0];
            } else {
                $details = $court_record_check_details[0];
            }
            foreach ($details as $key => $value) {
                if (validateDate($value, 'Y-m-d')) {
                    $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
                } else if ($value == '0000-00-00') {
                    $data[$key . '_edit'] = '';
                } else {
                    $data[$key . '_edit'] = $value;
                }
            }
        }
        $data['user_image_edit'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'court_record_check_india_detailsadd');
    }
    /***********************************************************
     * save_court_record_india_check
     * Add court record check details of dataentry
     ***********************************************************/
    function save_court_record_india_check($id = null)
    {
        $formData = $_POST;
        $id = base64_decode($id);
        $this->dm->save_common_record_check('court_record_check_india', $formData, $id);
    }
    /***********************************************************
     * india_specific_database_check_detailsadd
     * India specific database check detail of dataentry
     ***********************************************************/
    function india_specific_database_check_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['checkid'] = $check_id = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['india_specific_database_check_details'] = $india_specific_database_check_details = $this->amodel->getDetails(DB_PREFIX . "india_specific_database_check", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($india_specific_database_check_details)) {
            $details = $personal_details[0];
        } else {
            $details = $india_specific_database_check_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'india_specific_database_check');
    }
    /***********************************************************
     * save_india_specific_database_check
     * Add India specific database check details of dataentry
     ***********************************************************/
    function save_india_specific_database_check($id = null)
    {
        $formData = $_POST;
        $id = base64_decode($id);
        $this->dm->save_common_database_check('india_specific_database_check', $formData, $id);
    }
    /***********************************************************
     * international_database_check_detailsadd
     * International database check details of dataentry
     ***********************************************************/
    function international_database_check_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['checkid'] = $check_id = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['international_database_check_details'] = $international_database_check_details = $this->amodel->getDetails(DB_PREFIX . "international_database_check", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        $data['contact_details'] = $contact_details = $this->amodel->getDetails(DB_PREFIX . "contact_details", array('*'), array('request_id' => $request_id));
        $data['permenant_contact_details'] = $permenant_contact_details = $this->amodel->getDetails(DB_PREFIX . "permanent_contact_details", array('permanent_address', 'period_of_stay'), array('request_id' => $request_id));
        if (!empty($data['personal_details'])) {
            if (empty($international_database_check_details)) {
                $details = $personal_details[0];
            } else {
                $details = $international_database_check_details[0];
            }
            foreach ($details as $key => $value) {
                if (validateDate($value, 'Y-m-d')) {
                    $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
                } else if ($value == '0000-00-00') {
                    $data[$key . '_edit'] = '';
                } else {
                    $data[$key . '_edit'] = $value;
                }
            }
        }
        $data['user_image_edit'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'international_database_check');
    }
    /***********************************************************
     * save_international_database_check
     * Add International database check details of dataentry
     ***********************************************************/
    function save_international_database_check($id = null)
    {
        $formData = $_POST;
        $id = base64_decode($id);
        $this->dm->save_common_database_check('international_database_check', $formData, $id);
    }
    /***********************************************************
     * international_database_check_II_detailsadd
     * International database check details of dataentry
     ***********************************************************/
    function international_database_check_II_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['checkid'] = $check_id = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['international_database_check_details'] = $international_database_check_details = $this->amodel->getDetails(DB_PREFIX . "international_database_check_ii", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        $data['contact_details'] = $contact_details = $this->amodel->getDetails(DB_PREFIX . "contact_details", array('*'), array('request_id' => $request_id));
        $data['permenant_contact_details'] = $permenant_contact_details = $this->amodel->getDetails(DB_PREFIX . "permanent_contact_details", array('permanent_address', 'period_of_stay'), array('request_id' => $request_id));
        if (!empty($data['personal_details'])) {
            if (empty($international_database_check_details)) {
                $details = $personal_details[0];
            } else {
                $details = $international_database_check_details[0];
            }
            foreach ($details as $key => $value) {
                if (validateDate($value, 'Y-m-d')) {
                    $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
                } else if ($value == '0000-00-00') {
                    $data[$key . '_edit'] = '';
                } else {
                    $data[$key . '_edit'] = $value;
                }
            }
        }
        $data['user_image_edit'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'international_database_check');
    }
    /***********************************************************
     * save_internationaldbcheck
     *Add International database check details of dataentry
     ***********************************************************/
    function save_internationaldbcheck($id = null)
    {
        $formData = $_POST;
        $id = base64_decode($id);
        $this->dm->save_common_database_check('international_database_check_ii', $formData, $id);
    }
    /***********************************************************
     * exit_interview_detailsadd
     * Exit interview check details of dataentry
     ***********************************************************/
    function exit_interview_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['checkid'] = $check_id = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['exit_interview_details'] = $exit_interview_details = $this->amodel->getDetails(DB_PREFIX . "exit_interview", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($exit_interview_details)) {
            $details = $personal_details[0];
        } else {
            $details = $exit_interview_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $data['user_image_edit'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'exit_interview_detailsadd');
    }
    /***********************************************************
     *  save_exit_interview
     *  Add Exit interview check details of dataentry
     ***********************************************************/
    function save_exit_interview($id = null)
    {
        $formData = $_POST;
        $id = base64_decode($id);
        $this->dm->save_exit_interview($formData, $id);
    }
    /***********************************************************
     * drug_tests_detailsadd
     * Drug test check details of dataentry
     ***********************************************************/
    function drug_tests_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['checkid'] = $check_id = base64_decode($this->uri->segment(4));
        $checkid = $data['check_id'] = base64_decode($this->uri->segment(5));
        $drug_tests_details = $this->amodel->getDetails(DB_PREFIX . "drug_tests", array('*'), array('request_id' => $request_id, 'id' => $checkid));
        $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        $personal_details = $personal_details[0];
        $drug_details = $this->amodel->getDetails(DB_PREFIX . "drug_tests", array('*'), array('request_id' => $request_id));
        $check_details = $this->amodel->getDetails(DB_PREFIX . "request_check", array('*'), array('request_id' => $request_id, 'check_id' => 75));
        $check_details = $check_details[0];
        $next = count($drug_details);
        $levelname = explode(',', $check_details['description']);
        $data['level_name_edit'] = $levelname[$next];
        if (empty($drug_tests_details)) {
            $details = $personal_details;
        } else {
            $details = $drug_tests_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        if ($details['level_name'] <> '') {
            $data['level_name_edit'] = $details['level_name'];
        }
        $data['user_image_edit'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'drug_tests_detailsadd');
    }
    /***********************************************************
     * save_drug_tests
     * aDD Drug test check details of dataentry
     ***********************************************************/
    function save_drug_tests()
    {
        $Mobile = $this->encryption->encrypt($_POST['mobile']);
        $EmailId = $this->encryption->encrypt($_POST['email_id']);
        $ContactNumber = $this->encryption->encrypt($_POST['contact_number']);

        $formData = $_POST;
        $formData['mobile'] = $Mobile;
        $formData['email_id'] = $EmailId;
        $formData['contact_number'] = $ContactNumber;
        $this->dm->save_drug_tests($formData);
    }
    /***********************************************************
     * tenant_verification_detailsadd
     * Tennant verification check details of dataentry
     ***********************************************************/
    function tenant_verification_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['checkid'] = $check_id = base64_decode($this->uri->segment(4));
        $checkid = $data['check_id'] = base64_decode($this->uri->segment(5));
        $tenant_verification_details = $this->amodel->getDetails(DB_PREFIX . "tenant_verification", array('*'), array('request_id' => $request_id, 'id' => $checkid));
        $check_details = $this->amodel->getDetails(DB_PREFIX . "request_check", array('*'), array('request_id' => $request_id, 'check_id' => 76));
        $tenant_details = $this->amodel->getDetails(DB_PREFIX . "tenant_verification", array('level_name'), array('request_id' => $request_id));
        $employement_details = $this->amodel->getDetails(DB_PREFIX . "employment", array('*'), array('req_id' => $request_id));
        $employement_details = $employement_details[0];
        $contact_details = $this->amodel->getDetails(DB_PREFIX . "contact_details", array('*'), array('request_id' => $request_id));
        $contact_details = $contact_details[0];
        $personal_reference_details = $this->amodel->getDetails(DB_PREFIX . "personal_reference", array('*'), array('request_id' => $request_id));
        $personal_reference_details = $personal_reference_details[0];
        foreach ($tenant_details as $t) {
            $tarray[] = $t['level_name'];
        }
        $check_details = $check_details[0];
        $next = count($tenant_details);
        $levelname = explode(',', $check_details['description']);
        $array = array_merge($tarray, $levelname);
        $nextcheck = array_unique($array);
        if (empty($tenant_details)) {
            $nextcheck = $levelname;
        }
        foreach ($nextcheck as $key => $sort) {
            $nxtcheck[] = $sort;
            $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
            $personal_details = $personal_details[0];
            $data['level_name_edit'] = $nxtcheck[$next];
            $data['permenant_contact_details'] = $permenant_contact_details = $this->amodel->getDetails(DB_PREFIX . "permanent_contact_details", array('permanent_address', 'period_of_stay', 'pincode', ''), array('request_id' => $request_id));
            if (empty($tenant_verification_details)  && strtolower($data['level_name_edit']) == 'business verification') {
                $details = $personal_details;
            } else if (empty($tenant_verification_details) && !empty($contact_details) && strtolower($data['level_name_edit']) == 'permanent address verification') {
                $details = $contact_details;
            } else if (empty($tenant_verification_details) && !empty($employement_details) && strtolower($data['level_name_edit']) == 'hr verification') {
                $details = $employement_details;
            } else if (empty($tenant_verification_details) && !empty($personal_reference_details) && strtolower($data['level_name_edit']) == 'tenant reference check') {
                $details = $personal_reference_details;
            } else if (!empty($tenant_verification_details)) {
                $details = $tenant_verification_details[0];
            } else {
                $details = $personal_details;
            }
            foreach ($details as $key => $value) {
                if (validateDate($value, 'Y-m-d')) {
                    $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
                } else if ($value == '0000-00-00') {
                    $data[$key . '_edit'] = '';
                } else {
                    $data[$key . '_edit'] = $value;
                }
            }
            if ($details['level_name']) {
                $data['level_name_edit'] = $details['level_name'];
            }
            if (empty($details['plandmark'])) {
                $data['plandmark_edit'] = $details['landmark'];
            }
            if (empty($tenant_verification_details) && strtolower($data['level_name_edit']) == 'permanent address verification') {
                $permanent_tel_no = explode('-', $personal_details['permanent_tel_no']);
                $data['permanent_country_edit'] = $permanent_tel_no[0];
                $data['permanent_city_edit'] = $permanent_tel_no[1];
                $data['permanent_no_edit'] = $permanent_tel_no[2];
                $data['permanent_address_edit'] = $permenant_contact_details[0]['permanent_address'];
                $data['period_of_stay_edit'] = $permenant_contact_details[0]['period_of_stay'];
                $data['pincode_edit'] = $permenant_contact_details[0]['pincode'];
                $office_tel_no = explode('-', $personal_details['office_tel_no']);
                $data['office_country_edit'] = $office_tel_no[0];
                $data['office_city_edit'] = $office_tel_no[1];
                $data['office_no_edit'] = $office_tel_no[2];
            } else {
                $permanent_tel_no = explode('-', $details['permanent_tel_no']);
                $data['permanent_country_edit'] = $permanent_tel_no[0];
                $data['permanent_city_edit'] = $permanent_tel_no[1];
                $data['permanent_no_edit'] = $permanent_tel_no[2];
                $data['permanent_address_edit'] = $permenant_contact_details[0]['permanent_address'];
                $data['period_of_stay_edit'] = $permenant_contact_details[0]['period_of_stay'];
                $data['pincode_edit'] = $permenant_contact_details[0]['pincode'];
                $office_tel_no = explode('-', $details['office_tel_no']);
                $data['office_country_edit'] = $office_tel_no[0];
                $data['office_city_edit'] = $office_tel_no[1];
                $data['office_no_edit'] = $office_tel_no[2];
            }
            $data['dstatus'] = $details['edocustatus'];
            $data['remarks'] = $details['edocument_remarks'];
            $data['document'] = $details['employement_file'];
            $data['service_document'] = $details['service_document'];
            $data['relieve_document'] = $details['relieve_document'];
            $data['relieve_status'] = $details['relieve_status'];
            $data['service_status'] = $details['service_status'];
            $data['relieve_remarks'] = $details['relieve_remarks'];
            $data['service_remarks'] = $details['service_remarks'];
            $data['optional_document'] = $details['optional_document'];
            $data['user_image_edit'] = $personal_details['user_image'];
            $data['slug']   = $slug = url_title(convert_accented_characters($data['level_name_edit']), 'underscore', TRUE);
            if ($slug == 'business_verification') {
                $data['clone'] = $clone = toArray(json_decode($details['business_branch_address']));
                $skillsadd_clones = array(array('branch_address[]' => array('textarea', 'branch_address', 'R', 'R', '', '', '')));
                $skills_file_clone = create_cloneform($skillsadd_clones, '', $clone);
                $data['address_clone'] = formclonecreation($skillsadd_clones, $skills_file_clone, 1, 'Add Address', "Address of the Branches if any");
            }
        }
        $this->amodel->pagerender($data, 'tenant_verification_detailsadd');
    }
    /***********************************************************
     * save_hr_verification
     * Add HR verification check details of dataentry
     ***********************************************************/
    function save_hr_verification()
    {
        $formData = $_POST;
        $this->dm->save_hr_verification($formData);
    }
    /***********************************************************
     * save_bussiness_verification
     * Add Bussiness verification check details of dataentry
     ***********************************************************/
    function save_bussiness_verification()
    {
        $formData = $_POST;
        $this->dm->save_bussiness_verification($formData, 'tenant_verification', 'tenant');
    }
    /***********************************************************
     * save_permanent_address
     * Add Permanent address verification check details of dataentry
     ***********************************************************/
    function save_permanent_address()
    {
        $formData = $_POST;
        $this->dm->save_permanent_address($formData, 'tenant_verification', 'tenant');
    }
    /***********************************************************
     * save_landlord_reference
     * Add Landlord reference check details of dataentry
     ***********************************************************/
    function save_landlord_reference()
    {
        $formData = $_POST;
        $this->dm->save_landlord_reference($formData);
    }
    /***********************************************************
     * save_reference_check
     * Add Reference check verification check details of dataentry
     ***********************************************************/
    function save_reference_check()
    {
        $formData = $_POST;
        $this->dm->save_reference_check($formData);
    }
    /***********************************************************
     * vendor_verification_detailsadd
     * Vendoe verification check details of dataentry
     ***********************************************************/
    function vendor_verification_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['checkid'] = $check_id = base64_decode($this->uri->segment(4));
        $checkid = $data['check_id'] = base64_decode($this->uri->segment(5));
        $vendor_verification_details = $this->amodel->getDetails(DB_PREFIX . "vendor_verification", array('*'), array('request_id' => $request_id, 'id' => $checkid));
        $check_details = $this->amodel->getDetails(DB_PREFIX . "request_check", array('*'), array('request_id' => $request_id, 'check_id' => 77));
        $vendor_details = $this->amodel->getDetails(DB_PREFIX . "vendor_verification", array('level_name'), array('request_id' => $request_id));
        $check_details = $check_details[0];
        foreach ($vendor_details as $t) {
            $tarray[] = $t['level_name'];
        }
        $next = count($vendor_details);
        $levelname = explode(',', $check_details['description']);
        $array = array_merge($tarray, $levelname);
        $nextcheck = array_unique($array);
        if (empty($vendor_details)) {
            $nextcheck = $levelname;
        }
        foreach ($nextcheck as $key => $sort) {
            $nxtcheck[] = $sort;
        }
        $next = count($vendor_details);
        $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        $personal_details = $personal_details[0];
        $contact_details = $this->amodel->getDetails(DB_PREFIX . "permanent_contact_details", array('*'), array('request_id' => $request_id));
        $contact_details = $contact_details[0];
        $data['level_name_edit'] = $nxtcheck[$next];
        $data['user_image'] = $personal_details['user_image'];
        if (empty($vendor_verification_details) && empty($contact_details)) {
            $details = $personal_details;
        } else if (empty($vendor_verification_details) && !empty($contact_details)) {
            $details = $contact_details;
        } else {
            $details = $vendor_verification_details[0];
        }
        if ($details['level_name']) {
            $data['level_name_edit'] = $details['level_name'];
        }
        foreach ($details as $key => $value) {
            $data[$key . '_edit'] = $value;
        }
        if (empty($details['plandmark'])) {
            $data['plandmark_edit'] = $details['landmark'];
        }
        $permanent_tel_no = explode('-', $details['permanent_tel_no']);
        $data['permanent_country_edit'] = $permanent_tel_no[0];
        $data['permanent_city_edit'] = $permanent_tel_no[1];
        $data['permanent_no_edit'] = $permanent_tel_no[2];
        $office_tel_no = explode('-', $details['office_tel_no']);
        $data['office_country_edit'] = $office_tel_no[0];
        $data['office_city_edit'] = $office_tel_no[1];
        $data['office_no_edit'] = $office_tel_no[2];
        $data['user_image_edit'] = $personal_details['user_image'];
        $data['slug']  = $slug = url_title(convert_accented_characters($data['level_name_edit']), 'underscore', TRUE);
        if ($slug == 'business_verification') {
            $data['clone'] = $clone = toArray(json_decode($details['business_branch_address']));
            $skillsadd_clones = array(array('branch_address[]' => array('textarea', 'branch_address', 'R', 'R', '', '', '')));
            $skills_file_clone = create_cloneform($skillsadd_clones, '', $clone);
            $data['address_clone'] = formclonecreation($skillsadd_clones, $skills_file_clone, 1, 'Add Address', "Address of the Branches if any");
        }
        $this->amodel->pagerender($data, 'vendor_verification_detailsadd');
    }
    /***********************************************************
     * save_vendor_bussiness_verification
     * Add Vendor business verification check details of dataentry
     ***********************************************************/
    function save_vendor_bussiness_verification()
    {
        $formData = $_POST;
        $this->dm->save_bussiness_verification($formData, 'vendor_verification', 'vendor');
    }
    /***********************************************************
     * save_vendor_permanent_address
     * Add Vendor permanent verification check details of dataentry
     ***********************************************************/
    function save_vendor_permanent_address()
    {
        $formData = $_POST;
        $this->dm->save_permanent_address($formData, 'vendor_verification', 'vendor');
    }
    /***********************************************************
     * save_vendor_referecnce_check
     * Add Vendor reference verification check details of dataentry
     ***********************************************************/
    function save_vendor_referecnce_check()
    {
        $formData = $_POST;
        $this->dm->save_vendor_referecnce_check($formData);
    }
    /***********************************************************
     * resave
     * Resave of institutions details of dataentry
     ***********************************************************/
    function resave($offset = 0, $limit)
    {
        $rows = $this->db->get(DB_PREFIX . "institutions")->result_array();
        foreach ($rows as $row) {
            foreach ($row as $key => $value) {
                if ($key <> 'id') {
                    $newrow[$key] = $value;
                }
            }
            $new[] = $newrow;
        }
    }
    /***********************************************************
     *    submit_to_verification
     * Submit to verification details
     ***********************************************************/
    function  submit_to_verification()
    {
        $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(4));
        $data['education_id'] = $level_id = base64_decode($this->uri->segment(5));
        $checkrevert = $this->nm->checkrevert($request_id, $check_id, $level_id);
        if (empty($checkrevert)) {
            redirect('Dadmin/dadminview/' . $this->uri->segment(3));
        }
        $where = array('candidate_req_id' => $request_id, 'check_id' => $check_id, 'level_id' => $level_id);
        $this->db->set('client_revert_status', 1);
        $this->db->where($where);
        $this->db->update(DB_PREFIX . 'ver_assign_rep');
        redirect('Dadmin/dadminview/' . $this->uri->segment(3));
    }
    /***********************************************************
     * aadhaar_card_verification_detailsadd
     * Aadhaar card verification details of dataentry
     ***********************************************************/
    function aadhaar_card_verification_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['aadhaar_details'] = $aadhaar_details = $this->amodel->getDetails(DB_PREFIX . "aadhaar_card_verification", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($aadhaar_details)) {
            $details = $personal_details[0];
        } else {
            $details = $aadhaar_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'aadhaar_card_verification_detailsadd');
    }
    /***********************************************************
     * addaadhaarcheck
     * Add Aadhaar card verification details of dataentry
     ***********************************************************/
    function addaadhaarcheck($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->aadhaarcheckkdml($id);
    }
    /***********************************************************
     * pan_card_verification_detailsadd
     * pan_card_verification_detailsadd details of dataentry
     ***********************************************************/
    function pan_card_verification_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['pan_details'] = $pan_details = $this->amodel->getDetails(DB_PREFIX . "pan_card_verification", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($pan_details)) {
            $details = $personal_details[0];
        } else {
            $details = $pan_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'pan_card_verification_detailsadd');
    }
    /***********************************************************
     * pancheck
     * Add pan_card_verification_detailsadd details of dataentry
     ***********************************************************/
    function pancheck($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->pancheckdml($id);
    }
    /***********************************************************
     * passport_verification_detailsadd
     * passport_verification_detailsadd details of dataentry
     ***********************************************************/
    function passport_verification_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['passport_details'] = $passport_details = $this->amodel->getDetails(DB_PREFIX . "passport_verification", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($passport_details)) {
            $details = $personal_details[0];
            $details['date_of_issue'] = '';
        } else {
            $details = $passport_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'passport_verification_detailsadd');
    }
    /***********************************************************
     * passportcheck
     * Add passportcheck details of dataentry
     ***********************************************************/
    function passportcheck($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->passportcheckdml($id);
    }
    /***********************************************************
     * voter_id_verification_detailsadd
     *   voter_id_verification_detailsadd details of dataentry
     ***********************************************************/
    function voter_id_verification_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['voterid_details'] = $voterid_details = $this->amodel->getDetails(DB_PREFIX . "voter_id_verification", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($voterid_details)) {
            $details = $personal_details[0];
        } else {
            $details = $voterid_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'voter_id_verification_detailsadd');
    }
    /***********************************************************
     * votercheck
     *  Add voter_id_verification_detailsadd details of dataentry
     ***********************************************************/
    function votercheck($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->votercheckdml($id);
    }
    /***********************************************************
     *   driving_licence_verification_detailsadd details of dataentry
     *
     * driving_licence_verification_detailsadd verification
     ***********************************************************/
    function driving_licence_verification_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['drivinglicence_details'] = $drivinglicence_details = $this->amodel->getDetails(DB_PREFIX . "driving_licence_verification", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));

        if (empty($drivinglicence_details)) {
            $details = $personal_details[0];
        } else {
            $details = $drivinglicence_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'driving_licence_verification_detailsadd');
    }
    /***********************************************************
     *   Add drivinglicencecheck details of dataentry
     * drivinglicencecheck
     ***********************************************************/
    function drivinglicencecheck($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->drivinglicencecheckdml($id);
    }
    /***********************************************************
     *  cibil_check_detailsadd details of dataentry
     * cibil_check_detailsadd
     ***********************************************************/
    function cibil_check_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['cibil_details'] = $cibil_details = $this->amodel->getDetails(DB_PREFIX . "cibil_check", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($cibil_details)) {
            $details = $personal_details[0];
        } else {
            $details = $cibil_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'cibil_check_detailsadd');
    }
    /***********************************************************
     *  Add cibilcheck details of dataentry
     * cibilcheck
     ***********************************************************/
    function cibilcheck($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->cibilcheckdml($id);
    }
    /***********************************************************
     * form_16_verification_detailsadd details of dataentry
     * form_16_verification_detailsadd
     ***********************************************************/
    function form_16_verification_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['form_16_details'] = $form_16_details = $this->amodel->getDetails(DB_PREFIX . "form_16_verification", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($form_16_details)) {
            $details = $personal_details[0];
        } else {
            $details = $form_16_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'form_16_verification_detailsadd');
    }
    /***********************************************************
     * Add form16check details of dataentry
     * form16check
     ***********************************************************/
    function form16check($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->form16checkdml($id);
    }
    /***********************************************************
     * court_record_check_lf_detailsadd details of dataentry
     * court_record_check_lf_detailsadd
     ***********************************************************/
    function court_record_check_lf_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['court_record_check_lf_details'] = $court_record_check_lf_details = $this->amodel->getDetails(DB_PREFIX . "court_record_check_lf", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($court_record_check_lf_details)) {
            $details = $personal_details[0];
        } else {
            $details = $court_record_check_lf_details[0];
        }

        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'court_record_check_lf_detailsadd');
    }
    /***********************************************************
     *  Add save_court_record_lf_check details of dataentry
     * save_court_record_lf_check
     ***********************************************************/
    function save_court_record_lf_check($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->save_court_record_lf_checkdml($id);
    }
    /***********************************************************
     *  court_record_check_detailsadd_check details of dataentry
     * court_record_check_detailsadd
     ***********************************************************/
    function court_record_check_detailsadd()
    {

        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $checkid = $data['checkid'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['court_record_check_details'] = $court_record_check_details = $this->amodel->getDetails(DB_PREFIX . "court_record_check", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('title', 'firstname', 'middlename', 'lastname', 'date_of_birth', 'husband_name', 'father_name',    'gender', 'marital'), array('user_id' => $request_id));
        $court_details = $this->amodel->getDetails(DB_PREFIX . "court_record_check", array('*'), array('request_id' => $request_id));
        $check_details = $this->amodel->getDetails(DB_PREFIX . "request_check", array('*'), array('request_id' => $request_id, 'check_id' => 640));
        $check_details = $check_details[0];
        $next = count($court_details);
        $levelname = explode(',', $check_details['description']);
        $data['level_name_edit'] = $levelname[$next];
        if (empty($court_record_check_details)) {
            $details = $personal_details[0];
        } else {
            $details = $court_record_check_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        if ($details['level_name'] <> '') {
            $data['level_name_edit'] = $details['level_name'];
        }
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'court_record_check_detailsadd');
    }
    /***********************************************************
     *  Add save_court_record_check details of dataentry
     * save_court_record_check
     ***********************************************************/
    function save_court_record_check($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->save_court_record_checkdml($id);
    }
    /***********************************************************
     *  ofac_detailsadd details of dataentry
     * ofac_detailsadd
     ***********************************************************/
    function ofac_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['ofac_details'] = $ofac_details = $this->amodel->getDetails(DB_PREFIX . "ofac", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($ofac_details)) {
            $details = $personal_details[0];
        } else {
            $details = $ofac_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'ofac_detailsadd');
    }
    /***********************************************************
     *  Add ofac_detailsadd details of dataentry
     * ofaccheck
     ***********************************************************/
    function ofaccheck($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->ofaccheckdml($id);
    }
    /***********************************************************
     *    us_travel_verification_detailsadd details of dataentry
     * us_travel_verification_detailsadd
     ***********************************************************/
    function us_travel_verification_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['us_travel_verification_details'] = $us_travel_verification_details = $this->amodel->getDetails(DB_PREFIX . "us_travel_verification", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($us_travel_verification_details)) {
            $details = $personal_details[0];
        } else {
            $details = $us_travel_verification_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'us_travel_verification_detailsadd');
    }
    /***********************************************************
     *   Add us_travel_verification_detailsadd details of dataentry
     * ustravelcheck
     ***********************************************************/
    function ustravelcheck($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->ustravelcheckdml($id);
    }
    /***********************************************************
     *   police_current_address_verification_detailsadd details of dataentry
     * police_current_address_verification_detailsadd
     ***********************************************************/
    function police_current_address_verification_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['checkid'] = $check_id = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['police_current_address_verification'] = $police_current_address_verification = $this->amodel->getDetails(DB_PREFIX . "police_current_address_verification", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        $data['contact_details'] = $contact_details = $this->amodel->getDetails(DB_PREFIX . "contact_details", array('*'), array('request_id' => $request_id));
        $data['permanent_contact_details'] = $permanent_contact_details = $this->amodel->getDetails(DB_PREFIX . "permanent_contact_details", array('*'), array('request_id' => $request_id));
        if (empty($police_current_address_verification) && empty($contact_details[0])) {
            $details = $personal_details[0];
        } else if (empty($police_current_address_verification) && !empty($contact_details[0]) && !empty($permanent_contact_details[0])) {
            $details = $personal_details[0];
        } else {
            $details = $police_current_address_verification[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $current_tel_no = explode('-', $details['current_tel_no']);
        $data['current_country'] = $current_tel_no[0];
        $data['current_city'] = $current_tel_no[1];
        $data['current_no'] = $current_tel_no[2];
        $permanent_tel_no = explode('-', $details['permanent_tel_no']);
        $data['permanent_country'] = $permanent_tel_no[0];
        $data['permanent_city'] = $permanent_tel_no[1];
        $data['permanent_no'] = $permanent_tel_no[2];
        $office_tel_no = explode('-', $details['office_tel_no']);
        $data['office_country'] = $office_tel_no[0];
        $data['office_city'] = $office_tel_no[1];
        $data['office_no'] = $office_tel_no[2];
        if (empty($police_current_address_verification)) {
            $office_tel_no = explode('-', $details['office_tel_no']);
            $data['coffice_country'] = $office_tel_no[0];
            $data['coffice_city'] = $office_tel_no[1];
            $data['coffice_no'] = $office_tel_no[2];
        } else {
            $coffice_tel_no = explode('-', $details['coffice_tel_no']);
            $data['coffice_country'] = $coffice_tel_no[0];
            $data['coffice_city'] = $coffice_tel_no[1];
            $data['coffice_no'] = $coffice_tel_no[2];
        }
        $data['address_proof'] = $details['address_proof'];
        $data['user_image_edit'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'police_current_address_verification_detailsadd');
    }
    /***********************************************************
     *   Add  police_current_address_verification_detailsadd details of dataentry
     *
     * save_police_current_address_verificaion
     ***********************************************************/
    function save_police_current_address_verificaion($id = null)
    {
        $cMobile = $this->encryption->encrypt($_POST['cmobile']);
        $formData = $_POST;
        $formData['cmobile'] = $cMobile;
        $id = base64_decode($id);
        $this->dm->save_police_current_address_verificaion($formData, $id);
    }

    function international_criminal_check_detailsadd()
    {

        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));

        $data['international_criminal_check'] = $international_criminal_check = $this->amodel->getDetails(DB_PREFIX . "international_criminal_check", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));

        if (empty($international_criminal_check)) {
            $details = $personal_details[0];
        } else {
            $details = $international_criminal_check[0];
        }

        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $current_tel_no = explode('-', $details['current_tel_no']);
        $data['current_country'] = $current_tel_no[0];
        $data['current_city'] = $current_tel_no[1];
        $data['current_no'] = $current_tel_no[2];
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'international_criminal_check_detailsadd');
    }
    function save_international_criminal_check($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->save_international_criminal_checkdml($id);
    }

    //international current address
    function international_address_check_current_address_detailsadd()
    {

        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['contact_details'] = $int_currentaddress = $this->amodel->getDetails(DB_PREFIX . "international_address_check_current_address", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($int_currentaddress)) {
            $details = $personal_details[0];
        } else {
            $details = $int_currentaddress[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $current_tel_no = explode('-', $details['current_tel_no']);
        $data['current_country'] = $current_tel_no[0];
        $data['current_city'] = $current_tel_no[1];
        $data['current_no'] = $current_tel_no[2];
        $permanent_tel_no = explode('-', $details['permanent_tel_no']);
        $data['permanent_country'] = $permanent_tel_no[0];
        $data['permanent_city'] = $permanent_tel_no[1];
        $data['permanent_no'] = $permanent_tel_no[2];
        if (empty($int_currentaddress)) {
            $office_tel_no = explode('-', $details['office_tel_no']);
            $data['coffice_country'] = $office_tel_no[0];
            $data['coffice_city'] = $office_tel_no[1];
            $data['coffice_no'] = $office_tel_no[2];
            $data['cmobile_edit'] = $details['mobile'];
        } else {
            $coffice_tel_no = explode('-', $details['coffice_tel_no']);
            $data['coffice_country'] = $coffice_tel_no[0];
            $data['coffice_city'] = $coffice_tel_no[1];
            $data['coffice_no'] = $coffice_tel_no[2];
        }
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'international_address_check_current_detailsadd');
    }
    //international current address
    function addinternational_address_check($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->international_address_checkdml($id);
    }
    function international_address_check_permanent_address_detailsadd()
    {

        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['contact_details'] = $int_addpermanent = $this->amodel->getDetails(DB_PREFIX . "international_address_check_permanent_address", array('*'), array('request_id' => $request_id, 'id' => $data['id']));

        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($int_addpermanent)) {
            $details = $personal_details[0];
        } else {
            $details = $int_addpermanent[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }

        $current_tel_no = explode('-', $details['current_tel_no']);
        $data['current_country'] = $current_tel_no[0];
        $data['current_city'] = $current_tel_no[1];
        $data['current_no'] = $current_tel_no[2];
        $permanent_tel_no = explode('-', $details['permanent_tel_no']);
        $data['permanent_country'] = $permanent_tel_no[0];
        $data['permanent_city'] = $permanent_tel_no[1];
        $data['permanent_no'] = $permanent_tel_no[2];
        $office_tel_no = explode('-', $details['office_tel_no']);
        $data['office_country'] = $office_tel_no[0];
        $data['office_city'] = $office_tel_no[1];
        $data['office_no'] = $office_tel_no[2];
        $coffice_tel_no = explode('-', $details['coffice_tel_no']);
        $data['coffice_country'] = $coffice_tel_no[0];
        $data['coffice_city'] = $coffice_tel_no[1];
        $data['coffice_no'] = $coffice_tel_no[2];
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'international_address_check_permanent_detailsadd');
    }
    function addintpermanentdetails($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->intaddresspermanentdml($id);
    }
    function international_bankruptcy_check_individual_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));

        $data['bankruptcy_details'] = $bankruptcy = $this->amodel->getDetails(DB_PREFIX . "international_bankruptcy_check_individual", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));

        if (empty($bankruptcy)) {
            $details = $personal_details[0];
        } else {
            $details = $bankruptcy[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $data['user_image_edit'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'international_bankruptcy_check_individual_detailsadd');
    }

    function add_bankruptcy($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->bankruptcycheckdml($id);
    }

    function delete_additional_doc()
    {
        $req_id =  base64_decode($this->uri->segment(3));
        $request_id = $this->uri->segment(4);
        $sql = $this->db->query('delete from ' . DB_PREFIX . 'personal_additional_doc where id = "' . $req_id . '"');
        redirect('Dadmin/dadminview/' . $request_id);
    }

    function form_26as_detailsadd()
    {

        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['form_26as_details'] = $form_26as_details = $this->amodel->getDetails(DB_PREFIX . "form_26as", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($form_26as_details)) {
            $details = $personal_details[0];
        } else {
            $details = $form_26as_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        // $data['address_proof']=$details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'form_26as_detailsadd');
    }

    function form26ascheck($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->form26ascheckdml($id);
    }


    function professional_reference_check_colleague_detailsadd()
    {

        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['collegue_details'] = $collegue_details = $this->amodel->getDetails(DB_PREFIX . "professional_reference_check_colleague", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($collegue_details)) {
            $details = $personal_details[0];
        } else {
            $details = $collegue_details[0];
        }
        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        // $data['address_proof']=$details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'professional_reference_check_colleague_detailsadd');
    }

    function prc_collegue($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->prc_colleguecheckdml($id);
    }

    /***********************************************************
     * aadhaar_card_verification_detailsdelete
     * Aadhaar card verification details of dataentry
     ***********************************************************/
    function aadhaar_card_verification_detailsdelete()
    {
        $request_id = base64_decode($this->uri->segment(3));
        $check_id = base64_decode($this->uri->segment(4));
        $id = base64_decode($this->uri->segment(5));
        //echo $request_id.'==='.$check_id.'==='.$id;exit;

        $this->db->where('id', $id);
        $this->db->where('request_id', $request_id);
        $this->db->where('checkid', $check_id);
        $this->db->delete(DB_PREFIX . 'aadhaar_card_verification');

        $where = '(request_id="' . $request_id . '" AND check_id = "' . $check_id . '")';
        $this->db->set('no_checks', 0);
        $this->db->where($where);
        $this->db->update(DB_PREFIX . 'request_check');

        redirect('Dadmin/dadminview/' . base64_encode($request_id));
    }

    /***********************************************************
     * pan_card_verification_detailsdelete
     * PAN card verification details of dataentry
     ***********************************************************/
    function pan_card_verification_detailsdelete()
    {
        $request_id = base64_decode($this->uri->segment(3));
        $check_id = base64_decode($this->uri->segment(4));
        $id = base64_decode($this->uri->segment(5));
        //echo $request_id.'==='.$check_id.'==='.$id;exit;

        $this->db->where('id', $id);
        $this->db->where('request_id', $request_id);
        $this->db->where('checkid', $check_id);
        $this->db->delete(DB_PREFIX . 'pan_card_verification');

        $where = '(request_id="' . $request_id . '" AND check_id = "' . $check_id . '")';
        $this->db->set('no_checks', $no_check);
        $this->db->where($where);
        $this->db->update(DB_PREFIX . 'request_check');

        redirect('Dadmin/dadminview/' . base64_encode($request_id));
    }

    /***********************************************************
     * voter_id_verification_detailsdelete
     * Voter ID verification details of dataentry
     ***********************************************************/
    function voter_id_verification_detailsdelete()
    {
        $request_id = base64_decode($this->uri->segment(3));
        $check_id = base64_decode($this->uri->segment(4));
        $id = base64_decode($this->uri->segment(5));
        //echo $request_id.'==='.$check_id.'==='.$id;exit;

        $this->db->where('id', $id);
        $this->db->where('request_id', $request_id);
        $this->db->where('checkid', $check_id);
        $this->db->delete(DB_PREFIX . 'voter_id_verification');

        $where = '(request_id="' . $request_id . '" AND check_id = "' . $check_id . '")';
        $this->db->set('no_checks', $no_check);
        $this->db->where($where);
        $this->db->update(DB_PREFIX . 'request_check');

        redirect('Dadmin/dadminview/' . base64_encode($request_id));
    }

    /***********************************************************
     * passport_verification_detailsdelete
     * Passport verification details of dataentry
     ***********************************************************/
    function passport_verification_detailsdelete()
    {
        $request_id = base64_decode($this->uri->segment(3));
        $check_id = base64_decode($this->uri->segment(4));
        $id = base64_decode($this->uri->segment(5));
        //echo $request_id.'==='.$check_id.'==='.$id;exit;

        $this->db->where('id', $id);
        $this->db->where('request_id', $request_id);
        $this->db->where('checkid', $check_id);
        $this->db->delete(DB_PREFIX . 'passport_verification');


        $where = '(request_id="' . $request_id . '" AND check_id = "' . $check_id . '")';
        $this->db->set('no_checks', $no_check);
        $this->db->where($where);
        $this->db->update(DB_PREFIX . 'request_check');

        redirect('Dadmin/dadminview/' . base64_encode($request_id));
    }

    /***********************************************************
     * driving_licence_verification_detailsdelete
     * Driving Licence verification details of dataentry
     ***********************************************************/
    function driving_licence_verification_detailsdelete()
    {
        $request_id = base64_decode($this->uri->segment(3));
        $check_id = base64_decode($this->uri->segment(4));
        $id = base64_decode($this->uri->segment(5));
        //echo $request_id.'==='.$check_id.'==='.$id;exit;

        $this->db->where('id', $id);
        $this->db->where('request_id', $request_id);
        $this->db->where('checkid', $check_id);
        $this->db->delete(DB_PREFIX . 'driving_licence_verification');

        $where = '(request_id="' . $request_id . '" AND check_id = "' . $check_id . '")';
        $this->db->set('no_checks', $no_check);
        $this->db->where($where);
        $this->db->update(DB_PREFIX . 'request_check');

        redirect('Dadmin/dadminview/' . base64_encode($request_id));
    }


    /***********************************************************
     *  FACIS_detailsadd details of dataentry
     * facis_detailsadd
     ***********************************************************/
    function facis_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['checkid'] = $check_id = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));
        $data['facis_details'] = $facis_details = $this->amodel->getDetails(DB_PREFIX . "facis", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        $data['contact_details'] = $contact_details = $this->amodel->getDetails(DB_PREFIX . "contact_details", array('*'), array('request_id' => $request_id));
        $data['permenant_contact_details'] = $permenant_contact_details = $this->amodel->getDetails(DB_PREFIX . "permanent_contact_details", array('permanent_address', 'period_of_stay'), array('request_id' => $request_id));
        if (!empty($data['personal_details'])) {
            if (empty($facis_details)) {
                $details = $personal_details[0];
            } else {
                $details = $facis_details[0];
            }
            foreach ($details as $key => $value) {
                if (validateDate($value, 'Y-m-d')) {
                    $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
                } else if ($value == '0000-00-00') {
                    $data[$key . '_edit'] = '';
                } else {
                    $data[$key . '_edit'] = $value;
                }
            }
        }
        $data['user_image_edit'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'facis_details');
    }
    /***********************************************************
     * save_facis
     * Add facis details of dataentry
     ***********************************************************/
    function facischeck($id = null)
    {
        $formData = $_POST;
        $id = base64_decode($id);
        $this->dm->facischeckdml('facis', $formData, $id);
    }


    /***********************************************************
     *  International Credit Check details of dataentry
     * international_credit_check_detailsadd
     ***********************************************************/
    // function international_credit_check_detailsadd()    {
    //     $request_id=$data['request_id']=base64_decode($this->uri->segment(3)); 
    //     $data['checkid'] = $check_id = base64_decode($this->uri->segment(4));
    //     $data['id']= $id = base64_decode($this->uri->segment(5));
    //     $data['international_credit_check_details']=$international_credit_check_details = $this->amodel->getDetails(DB_PREFIX . "international_credit_check", array('*'), array('request_id' => $request_id,'id'=>$data['id'])); 
    //     $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
    //     $data['icc_contact_details'] = $icc_contact_details = $this->amodel->getDetails(DB_PREFIX . "icc_doc", array('*'), array('request_id' => $request_id,'check_id' => $check_id ));

    //     if(!empty($data['personal_details'])){
    //         if(empty($international_credit_check_details)){
    //             $details=$personal_details[0];
    //         }
    //         else{
    //             $details=$international_credit_check_details[0];
    //         }
    //         foreach($details as $key=>$value)
    //         {
    //             if(validateDate($value, 'Y-m-d')){
    //                 $data[$key.'_edit']=date('d-m-Y',strtotime($value));
    //             }
    //             else if($value=='0000-00-00'){
    //                 $data[$key.'_edit']='';
    //             }
    //             else{
    //                 $data[$key.'_edit']=$value;
    //             }
    //         }
    //     }
    //     $data['user_image_edit'] = $personal_details[0]['user_image'];
    //     $this->amodel->pagerender($data, 'international_credit_check_details');
    // }
    // /***********************************************************
    // * save_credit_check
    // * Add international credit check details of dataentry
    // ***********************************************************/
    function add_intcreditcheck($id = null)
    {
        $formData = $_POST;
        $id = base64_decode($id);
        $this->dm->intcreditcheckdml('international_credit_check', $formData, $id);
    }


    function create_pdf($html, $file_type, $candidate_name)
    {
        require("./dom_pdf/dompdf_config.inc.php");
        $dompdf = new DOMPDF();
        $html = mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8');
        $dompdf->load_html($html);
        $dompdf->render();
        $canvas = $dompdf->get_canvas();
        $font = Font_Metrics::get_font("Times New Roman", "oblique");
        $canvas->page_text(
            500,
            780,
            "Confidential {PAGE_NUM} / {PAGE_COUNT}",
            $font,
            10,
            array(0, 0, 0)
        );
        $filename = $file_type . base64_encode($candidate_name . "_" . date('d_m_Y_H_i_s')) . ".pdf";
        //$dompdf->stream($filename, array("Attachment"=>0));
        $output1 = $dompdf->output($filename);
        file_put_contents(getcwd() . "/uploads/prposaldetails/" . $filename, $output1);

        chmod(getcwd() . "/uploads/prposaldetails/" . $filename, 0777);
        return $filename;
    }

    function content_manager($replace_content, $image_path, $candidate_name, $date, $file_type)
    {
        $html = "<style>.decltr{margin-top: 100px;}label{color: #564650;padding: 0 5px 0 5px;width: 200px;font-size: 16px;font-weight: bold;}.dec_content{padding: 10px;margin-bottom: 20px;margin-top: 10px; width:750px;}#dispimg{margin-left: auto;margin-right: auto;width: 250px;height: 70px;}.fimage{width:750px; height:70px;margin-top:50px;display: inline-block;align-items:center;}h3{text-align:center;}</style><div class='decltr'> <h3> To whom it may concern </h3> <div class='dec_content'> <article style=''>{{content}}</article> </div><div class='fimage'> <label style='line-height:50px;'>Sign: </label> <img src='{{sign_imge}}' id='dispimg'/> </div><div style='margin-top: 20px;'> <label>Name in BLOCK (Capital) Letter: </label> <u>{{candidate_name}}</u> </div><div style='margin-top: 20px;'> <label>Date: </label>{{date}}</div></div>";
        $html = str_replace("{{content}}", $replace_content, $html);
        $html = str_replace("{{sign_imge}}", $image_path, $html);
        $html = str_replace("{{candidate_name}}", $candidate_name, $html);
        $html = str_replace("{{date}}", $date, $html);

        $pdf_path = $this->create_pdf($html, $file_type, $candidate_name);
        return $pdf_path;
    }

    function user_decldoc()
    {

        $request_id = $_POST['request_id'];
        $candidate_name = $_POST['cand_name'];
        $date = date('d-m-Y', strtotime($_POST['created_on']));

        $decleration_details = $this->dm->declerationtext($request_id);

        $decl_letter = $decleration_details[0]['declaration_text'];
        $signImg_path = base_url('/uploads/prposaldetails/' . $decleration_details[0]['signature']);
        $candidate = strtoupper($candidate_name);

        $pdf_file_path2 = $this->content_manager($decl_letter, $signImg_path, $candidate, $date, "declaration_letter");

        if ($pdf_file_path2) {
            $this->db->update(DB_PREFIX . "declaration_details", array('user_decl_doc' => $pdf_file_path2), array('user_id' => $request_id));
        }
        echo $pdf_path = base_url('/uploads/prposaldetails/' . $pdf_file_path2);
    }

    /******************************************************************************************/
    /* PF_verification
    * PF_verification details of dataentry
    Edited By : Amritha P P
    ***********************************************************/
    function pf_verification_detailsadd()
    {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));

        $data['pf_details'] = $pf_details = $this->amodel->getDetails(DB_PREFIX . "pf_verification", array('*'), array('request_id' => $request_id, 'id' => $data['id']));

        foreach ($pf_details as $key => $values) {

            $data['UAN_number']   =   $values['UAN_number'];
            $data['PF_number']   =   $values['PF_number'];
        }

        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));
        if (empty($pf_details)) {
            $details = $personal_details[0];
        } else {
            $details = $pf_details[0];
        }
        foreach ($details as $key => $value) {

            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }

        $this->amodel->pagerender($data, 'pf_verification_detailsadd');
    }

    /***********************************************************************************
     * pfcheck
     * Add PF_verification_detailsadd details of dataentry
     ***********************************************************/
    function pfcheck($id = 0)
    {

        $id = base64_decode($this->uri->segment(3));
        //print_r($id);exit;
        $this->dm->pfdml($id);
    }


    /***********************************************************************************
     * international_civil_check_
     * Add international_civil_check_ details of dataentry
     ***********************************************************/
    function international_civil_check_detailsadd()
    {

        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $data['id'] = base64_decode($this->uri->segment(5));

        $data['international_civil_check'] = $international_civil_check = $this->amodel->getDetails(DB_PREFIX . "international_civil_check", array('*'), array('request_id' => $request_id, 'id' => $data['id']));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));

        if (empty($international_civil_check)) {
            $details = $personal_details[0];
        } else {
            $details = $international_civil_check[0];
        }

        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $current_tel_no = explode('-', $details['current_tel_no']);
        $data['current_country'] = $current_tel_no[0];
        $data['current_city'] = $current_tel_no[1];
        $data['current_no'] = $current_tel_no[2];
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'international_civil_check_detailsadd');
    }
    function save_international_civil_check($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->save_international_civil_checkdml($id);
    }

    function international_corruption_record_check_detailsadd()
    {

        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $level_id = $data['id'] = base64_decode($this->uri->segment(5));

        $data['international_corruption_record_check'] = $international_corruption_record_check = $this->amodel->getDetails(DB_PREFIX . "international_corruption_record_check", array('*'), array('request_id' => $request_id, 'id' => $level_id));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));

        if (empty($international_corruption_record_check)) {
            $details = $personal_details[0];
        } else {
            $details = $international_corruption_record_check[0];
        }

        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $current_tel_no = explode('-', $details['current_tel_no']);
        $data['current_country'] = $current_tel_no[0];
        $data['current_city'] = $current_tel_no[1];
        $data['current_no'] = $current_tel_no[2];
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'international_corruption_record_check_detailsadd');
    }
    function save_international_corruption_record_check($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->save_international_corruption_record_checkdml($id);
    }

    function international_credit_check_detailsadd()
    {

        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $level_id = $data['id'] = base64_decode($this->uri->segment(5));

        $data['international_credit_check'] = $international_credit_check = $this->amodel->getDetails(DB_PREFIX . "international_credit_check", array('*'), array('request_id' => $request_id, 'id' => $level_id));
        $data['personal_details'] = $personal_details = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('*'), array('user_id' => $request_id));

        if (empty($international_credit_check)) {
            $details = $personal_details[0];
        } else {
            $details = $international_credit_check[0];
        }

        foreach ($details as $key => $value) {
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } else if ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }
        $current_tel_no = explode('-', $details['current_tel_no']);
        $data['current_country'] = $current_tel_no[0];
        $data['current_city'] = $current_tel_no[1];
        $data['current_no'] = $current_tel_no[2];
        $data['address_proof'] = $details['address_proof'];
        $data['user_image'] = $personal_details[0]['user_image'];
        $this->amodel->pagerender($data, 'international_credit_check_detailsadd');
    }
    function save_international_credit_check($id = null)
    {
        $id = base64_decode($this->uri->segment(3));
        $this->dm->save_international_credit_checkdml($id);
    }

    /******************************************************************************************/
    /* gap_analysis
    * gap_analysis details of dataentry
    added by kavya on 8th feb tomarrow refer from this page
***********************************************************/
    function calculate_calendar_days_gap($date1, $date2)
    {
        $previous_relieving_date = new DateTime($date1);
        $next_join_date = new DateTime($date2);

        // swap dates if $date1 is greater than $date2
        if ($previous_relieving_date > $next_join_date) {
            $temp = $previous_relieving_date;
            $previous_relieving_date = $next_join_date;
            $next_join_date = $temp;
        }

        $interval = $previous_relieving_date->diff($next_join_date);
        $days = (int) $interval->format('%r%a');
        if ($days > 1) {
            $days--;
        }

        return ($temp === $next_join_date) ? -$days : $days; // ??
    }

    // function call_compute_working_days() {
    //     $from = '2022-1-1';
    //     $to =  '2021-10-17';
    //     echo $work_days = $this->compute_working_days($from, $to) . ' work days<br>';
    //     echo $calendar_days = $this->calculate_calendar_days_gap($from, $to) . ' calendar days<br>';
    // }

    function compute_working_days($previous_relieving_date, $next_join_date)
    {
        $workingDays = [1, 2, 3, 4, 5]; // Monday to Friday
        $from = new DateTime($previous_relieving_date);
        $from->modify('+1 day');

        // $to = (new DateTime($current_from_date))->modify('-1 day'); // Exclude the end date
        $to = new DateTime($next_join_date);

        // if previous relieving date is greater than next_join_date
        if ($from > $to) {
            return -1; // go back to the calling function 
        }

        // Initialize the days counter
        $days = 0;
        $interval = new DateInterval('P1D');
        $periods = new DatePeriod($from, $interval, $to);
        foreach ($periods as $period) {
            if (!in_array($period->format('N'), $workingDays)) continue;

            $days++;
        }

        return $days;
    }

    function gap_analysis_check_detailsadd() {
        $request_id = $data['request_id'] = base64_decode($this->uri->segment(3));
        $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
        $levelId = $data['id'] = base64_decode($this->uri->segment(5));
    
        $employment_records = $this->amodel->getEmploymentRecords($request_id);
        $formatted_employment_records = [];
        $tosave_gap_records = [];
        foreach ($employment_records as $index => $emp) {
            $record1 = $emp;
            $record2 = isset($employment_records[$index + 1]) ? $employment_records[$index + 1] : null;
    
            if ($record2) {
                $work_days = $this->compute_working_days($record1['period_to'], $record2['period_from']); // April 22nd
                $gap_days = $work_days; // April 22nd
    
                // April 22nd
                if($work_days <> 0) 
                {
                    $gap_days = $this->calculate_calendar_days_gap($record1['period_to'], $record2['period_from']);
                } // April 22nd
                $gap_days = ($gap_days) ? $gap_days : '';
                $formatted_employment_records[] = [
                    '#' => $index + 1,
                    'company_name' => $record1['company_name'],
                    'from_to_dates' => date('d-m-Y', strtotime($record1['period_from'])) . ' to ' . date('d-m-Y', strtotime($record1['period_to'])),
                    'next_company_name' => isset($record2['company_name']) ? $record2['company_name'] : '',
                    'next_from_to_dates' => isset($record2['period_from']) ? date('d-m-Y', strtotime($record2['period_from'])) . ' to ' . date('d-m-Y', strtotime($record2['period_to'])) : '',
                    'gap_days' => $gap_days < 0 ? '-' . abs($gap_days) : $gap_days,
                    //'reason' => ''
                    'gap_reason_emp' => $record1['gap_reason_emp'],
                ];
                $tosave_gap_records[] = [
                'request_id' => $request_id,
                'checkid' => $check_id,
                'previous_org' => $record1['company_name'],
                'previous_join_date' => $record1['period_from'],
                'previous_exit_date' => $record1['period_to'],
                'next_org' => $record2['company_name'],
                'next_join_date' => $record2['period_from'],
                'next_exit_date' => $record2['period_to'],
                'gap_duration' => $gap_days,
                'gap_reason_emp' => $record1['gap_reason_emp'],
                'created_by' => $this->session->userdata['userid'],
                'created_on' => date('Y-m-d H:i:s'),
                ];
            }
            //print_r($tosave_gap_records); exit();
    
            if (!$record2) { 
                $gap_days = 0;
                $gap_days = ($gap_days) ? $gap_days : ''; 
                $formatted_employment_records[] = [
                    '#' => $index + 1,
                    'company_name' => $record1['company_name'],
                    'from_to_dates' => date('d-m-Y', strtotime($record1['period_from'])) . ' to ' . date('d-m-Y', strtotime($record1['period_to'])),
                    'next_company_name' => isset($record2['company_name']) ? $record2['company_name'] : '',
                    'next_from_to_dates' => '',
                     'gap_days' => $gap_days,
                     'gap_reason_emp' => $record1['gap_reason_emp'],
                ];
    
                
                $tosave_gap_records[] = [
                    'request_id' => $request_id,
                    'checkid' => $check_id,
                    'previous_org' => $record1['company_name'],
                    'previous_join_date' => $record1['period_from'],
                    'previous_exit_date' => $record1['period_to'],
                    'next_org' => '',
                    'next_join_date' => '',
                    'next_exit_date' => '',
                    'gap_duration' => $gap_days,
                    'gap_reason_emp' => $record1['gap_reason_emp'],
                    'created_by' => $this->session->userdata['userid'],
                    'created_on' => date('Y-m-d H:i:s'),
                        ];
         
            }
            // print_r($tosave_gap_records); exit();
        }
    
        // ***********************Gaps between education and employment ************
        //ka added on june 18
        $employment_records = $this->amodel->getEmploymentRecords($request_id);
        $education_records = $this->amodel->getEducationRecords($request_id);
        $formatted_records = [];
        $tosave_gap_records_employment = [];
        $tosave_gap_records_education = [];
        $combined_records = array_merge($employment_records, $education_records);
            usort($combined_records, function($a, $b) {
                    return strtotime($a['period_from']) - strtotime($b['period_from']);
            });
            foreach ($combined_records as $index => $record) {
            $record1 = $record;
            $record2 = isset($combined_records[$index + 1]) ? $combined_records[$index + 1] : null;
            $is_employment_record = in_array($record, $employment_records);
            if ($record2) {
                $work_days = $this->compute_working_days($record1['period_to'], $record2['period_from']);
                $gap_days = $work_days;
                if ($work_days <> 0) {
                    $gap_days = $this->calculate_calendar_days_gap($record1['period_to'], $record2['period_from']);
                }
                $qualification = $is_employment_record ? '' : $record1['degree'];
                $from_to_dates_edu = $is_employment_record ? '' : date('d-m-Y', strtotime($record1['period_from'])) . ' to ' . date('d-m-Y', strtotime($record1['period_to']));
                $company_name = $is_employment_record ? $record1['company_name'] : '';
                $from_to_dates_emp = $is_employment_record ? date('d-m-Y', strtotime($record1['period_from'])) . ' to ' . date('d-m-Y', strtotime($record1['period_to'])) : '';
                $gap_reason_edu = $record1['gap_reason_edu'];// now added
                $gap_days = ($gap_days) ? $gap_days : '';
                $formatted_records[] = [
                    '#' => $index + 1,
                    'qualification' => $qualification,
                    'from_to_dates_edu' => $from_to_dates_edu,
                    
                    'company_name' => $company_name,
                    'from_to_dates_emp' => $from_to_dates_emp,
                    
                    'gap_days' => $gap_days < 0 ? '-' . abs($gap_days) : $gap_days,
                    'gap_reason_edu' => $record1['gap_reason_edu'],
                    
                ];
                $tosave_gap_records_education[] = [
                    'request_id' => $request_id,
                    'checkid' => $check_id,
                    'qualification' => $record1['degree'],
                    'previous_join_date_edu' => $record1['period_from'], 
                    'previous_exit_date_edu' => $record1['period_to'], 
                    'previous_org_edu' => isset($record2['company_name']) ? $record2['company_name'] : '',
                    
                    'previous_join_date' => isset($record2['period_from']) ? $record2['period_from'] : '',
    
                    'previous_join_date' => $record2['period_from'],
                    'previous_exit_date' => isset($record2['period_to']) ? $record2['period_to'] : '',
                    'gap_duration_edu' => $gap_days,
                    'gap_reason_edu' => $record1['gap_reason_edu'],
                    'created_by' => $this->session->userdata['userid'],
                    'created_on' => date('Y-m-d H:i:s'),
                ];
            } 
            }
            //print_r($tosave_gap_records_education);

        // *************************Gaps between education and employment*****************************
        //ka added on july 17

        $employment_records = $this->amodel->getEmploymentRecords($request_id);
        $education_records = $this->amodel->getEducationRecords($request_id);
        $formatted_records = [];
        $tosave_gap_records_employment =[];
        $tosave_gap_records_education = [];
        $combined_records = array_merge($employment_records, $education_records);
        usort($combined_records, function ($a, $b) {
            return strtotime($a['period_from']) - strtotime($b['period_from']);
        });
        foreach ($combined_records as $index => $record) {
            $record1 = $record;
            $record2 = isset($combined_records[$index + 1]) ? $combined_records[$index + 1] : null;
            $is_employment_record = in_array($record, $employment_records);
            if ($record2) {
                $work_days = $this->compute_working_days($record1['period_to'], $record2['period_from']);
                $gap_days = $work_days;
                if ($work_days <> 0) {
                    $gap_days = $this->calculate_calendar_days_gap($record1['period_to'], $record2['period_from']);
                }
                $qualification = $is_employment_record ? '' : $record1['degree'];
                $from_to_dates_edu = $is_employment_record ? '' : date('d-m-Y', strtotime($record1['period_from'])) . ' to ' . date('d-m-Y', strtotime($record1['period_to']));
                $company_name = $is_employment_record ? $record1['company_name'] : '';
                $from_to_dates_emp = $is_employment_record ? date('d-m-Y', strtotime($record1['period_from'])) . ' to ' . date('d-m-Y', strtotime($record1['period_to'])) : '';
                $gap_reason_edu = $record1['gap_reason_edu']; // now added
                $gap_days = ($gap_days) ? $gap_days : '';
                $formatted_records[] = [
                    '#' => $index + 1,
                    'qualification' => $qualification,
                    'from_to_dates_edu' => $from_to_dates_edu,

                    'company_name' => $company_name,
                    'from_to_dates_emp' => $from_to_dates_emp,

                    'gap_days' => $gap_days < 0 ? '-' . abs($gap_days) : $gap_days,
                    'gap_reason_edu' => $record1['gap_reason_edu'],

                ];
                $tosave_gap_records_education[] = [
                    'request_id' => $request_id,
                    'checkid' => $check_id,
                    'qualification' => $record1['degree'],
                    'previous_join_date_edu' => $record1['period_from'],
                    'previous_exit_date_edu' => $record1['period_to'],
                    'previous_org_edu' => isset($record2['company_name']) ? $record2['company_name'] : '',

                    'previous_join_date' => isset($record2['period_from']) ? $record2['period_from'] : '',

                    'previous_join_date' => $record2['period_from'],
                    'previous_exit_date' => isset($record2['period_to']) ? $record2['period_to'] : '',
                    'gap_duration_edu' => $gap_days,
                    'gap_reason_edu' => $record1['gap_reason_edu'],
                    'created_by' => $this->session->userdata['userid'],
                    'created_on' => date('Y-m-d H:i:s'),
                ];
            }
        }
        //print_r($tosave_gap_records_education);

        // ****************** end gaps between education and employment end *********************  

        if (isset($levelId)) {
            $this->fetchGapAnalysisDetailsForEditing($levelId, $tosave_gap_records);
        }

        //ka added on july 17
        if (isset($levelId)) {
            $this->fetchGapAnalysisDetailsForEditing_edu($levelId, $tosave_gap_records_education);
        }


        foreach ($tosave_gap_records as $record) {
            $this->amodel->updateEmploymentGapReason($record['previous_org'], $record['previous_join_date'], $record['gap_reason_emp']);
        }

        foreach ($tosave_gap_records_education as $record) {
            $this->amodel->updateEducationGapReason($record['qualification'], $record['previous_exit_date_edu'], $record['gap_reason_edu']);
        }
        //ka added on july 17


        $data['employment_records'] = $formatted_employment_records;
        //print_r( $data['employment_records'] ); exit();
        $data['tosave_gap_records'] = $tosave_gap_records;
        $data['education_records'] = $formatted_records; //ka added on july 17
        $data['tosave_gap_records_education'] = $tosave_gap_records_education; //ka added on july 17
        $data['check_level'] = $this->dm->getcheck($request_id);
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(4));

        $employement_details = $this->amodel->getDetails(DB_PREFIX . "gap_analysis_check", array('*'), array('request_id' => $request_id, 'id' => $levelId));


        $data['check_level'] = $checkda = $this->dm->getcheck($request_id);
        $skillsadd_clones = array(array('document_name' => array('text', 'document_name', '', '', '', '', ''), 'additional_doc' => array('upload', 'additional_doc', '', '', '', '', '')));
        $data['skills_file_clone'] = create_cloneform($skillsadd_clones, '', $user_id);
        $data['upload_file'] = formclonecreation($skillsadd_clones, $data['skills_file_clone'], 1, 'Add Document', "Attached Document");

        $data['personal_details'] = $this->amodel->getDetails(DB_PREFIX . "personal_details", array('id', 'user_id', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', 'primary_skill', 'experience', 'experience_month', 'passport', 'passport_expire', 'place_of_issue', 'date_of_issue', 'license_no', 'valid_up_to', 'nationality', 'date_of_birth', 'gender', 'marital', 'SSN', 'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'current_tel_no', 'permanent_tel_no', 'office_tel_no', 'mobile', 'alter_email_id', 'user_image', 'upload_doc', 'created_by', 'created_on', 'updated_by'), array('user_id' => $request_id));

        $details = array_merge((array)$employement_details[0], (array)$data['personal_details'][0]);

        foreach ($details as $key => $value) {
            //print_r($details); exit();
            if (validateDate($value, 'Y-m-d')) {
                $data[$key . '_edit'] = date('d-m-Y', strtotime($value));
            } elseif ($value == '0000-00-00') {
                $data[$key . '_edit'] = '';
            } else {
                $data[$key . '_edit'] = $value;
            }
        }


        $this->amodel->pagerender($data, 'gap_analysis_check_detailsadd');
    }

    function fetchGapAnalysisDetailsForEditing($levelId, &$tosave_gap_records)
    {
        $gap_analysis_record = $this->amodel->getDetails(DB_PREFIX . "gap_analysis_check", array('gapdata'), array('id' => $levelId));
        //print_r($gap_analysis_record); exit();
        if (!empty($gap_analysis_record)) {
            $gapdata = json_decode($gap_analysis_record[0]['gapdata'], true);
            if ($gapdata !== null) {
                foreach ($tosave_gap_records as &$record) {
                    $matching_record = array_filter($gapdata, function ($item) use ($record) {

                        return $item['previous_org'] == $record['previous_org']
                            && $item['previous_join_date'] == $record['previous_join_date']
                            && $item['next_org'] == $record['next_org'];
                    });
                    //using gap reason from employment table
                    $record['gap_reason_emp'] = $record['gap_reason_emp']; //ka added on july 17
                    if (!empty($matching_record)) {
                        $record['gap_reason_emp'] = reset($matching_record)['gap_reason_emp']; //code modified on july 17
                    }
                }
            }
        }
    }
    
    // ******************************* edit logic for education and employment gap ******************
    //ka added on july 17

    function fetchGapAnalysisDetailsForEditing_edu($levelId, &$tosave_gap_records_education)
    { //code modified on july 3
        $gap_analysis_record_edu = $this->amodel->getDetails(DB_PREFIX . "gap_analysis_check", array('gap_edu'), array('id' => $levelId));
        if (!empty($gap_analysis_record_edu)) {
            $gap_edu = json_decode($gap_analysis_record_edu[0]['gap_edu'], true);
            if ($gap_edu !== null) {
                foreach ($tosave_gap_records_education as &$record) {
                    $matching_record1 = array_filter($gap_edu, function ($item) use ($record) {
                        return $item['qualification'] == $record['qualification']
                            && $item['previous_exit_date_edu'] == $record['previous_exit_date_edu']
                            && $item['previous_org'] == $record['previous_org'];
                    });
                    // reason taking from the education table
                    $record['gap_reason_edu'] = $record['gap_reason_edu'];
                    if (!empty($matching_record)) {
                        $record['gap_reason_edu'] = reset($matching_record)['gap_reason_edu'];
                    }
                }
            }
        }
    }
    //ka added on july 17
    //  ************************************************** end ***************************************

    //adding on feb 22

    function addgapanalysis()
    {
        //print_r($_POST); exit();
        //$data= $_POST;
        $id =  $_POST['id'];
        // print_r($id);
        $this->dm->addgapanalysisdml($id);
    }
} // End of Dataentry controller
