<?php if (!defined('BASEPATH')) 
{
    exit('No direct script access allowed');
}
require_once ('Common.php');
require_once ('./PHPExcel-1.8/Classes/PHPExcel.php');
class DeleteRequest extends Common {
    protected $index_dashboard= 'Index/dashboard';

    //constructor
    function __construct() 
    {
        parent::__construct();
        $this->_check_userlogin();

        $files_found = 0; // variable for count of files found in folder
        $files_not_found = 0; // variable for count of files not found in folder
      
        $models = array('Delete_request_model'=>'drm','Reports_model'=>'rm', 'MissingFiles_model'=>'m');
        foreach ($models as $file => $object_name) {
            $this->load->model($file, $object_name);
        }
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','jquery-ui-1.10.4','highcharts','exporting','jquery.validate','grid.locale-en','jquery.jqGrid.min','jquery-ui-1.8.16.custom.min','commonjs','jquery.datepick','multipleclone'));
        $this->load->helper('text');
        $this->load->helper('cloneform');
        $this->load->helper('security');
    }

    /*****************************************************************************************************************************
    * hard_delete
    * Displays the view page to select either organisation or entering case numbers for deleting files(here we are just renaming 
    * files with a prefix)
    ******************************************************************************************************************************/
    function hard_delete() {
        
        if($this->session->userdata['userid']==1){
            $userId=$this->session->userdata['userid'];
        }

        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Hard Delete', 'DeleteRequest/hard_delete');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'hard_delete');
    }

    /************************************************************
     * display_filters_selected
     * Shows details like organization selected etc., for delete
     ************************************************************/
    function display_filters_selected()
    {
        // print_r($_REQUEST);exit;
        // Get all filters selected like organization etc.,
        $org_id = ($_REQUEST['parentoffice_id']) ? $_REQUEST['parentoffice_id'] : '';
        $office = ($_REQUEST['office_id']) ? $_REQUEST['office_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : ''; 
        $user_type = ($_REQUEST['user_type']) ? $_REQUEST['user_type'] : '';

        // Get oragnization name, head office name etc., for displaying
        $org_res_arr = $this->drm->get_organization_name($org_id);
        $org_name = $org_res_arr['org_name'];
        if($parent_office <> "")
        {
            $head_off_res_arr = $this->drm->get_head_office_name($org_id, $parent_office);
            $data['head_off_name']=$head_off_res_arr['office_name'];
        }
        
        if($office <> "")
        {
            // get_branch_office_name($org_id, $parent_office, $office) 
            $branch_off_res_arr = $this->drm->get_branch_office_name($org_id, $parent_office, $office);
            $data['branch_off_name']=$branch_off_res_arr['office_name'];
        }
        
        if($sub_office <> "")
        {
            $sub_off_res_arr = $this->drm->get_sub_office_name($sub_office);
            $data['sub_office']=$sub_off_res_arr['office_name']; 

        }
        $data['org_name']=$org_name;
        $data['c_date']=$c_date; 
        $data['t_date']=$t_date; 

        $data['org_id'] = $org_id;
        $data['office_id'] = $office;
        $data['head_office_id'] = $parent_office;
        $data['sub_office_id'] = $sub_office;
        $data['userType'] = $user_type;
        
        if($user_type==1)
            $data['user_type']='Deleted'; 

        // If organization, head office etc., filters are selected form a search condition[]
        if($org_id){
            $condition[]=" cr.organisation = ".$org_id;
        }
        if($parent_office){
            $condition[]=" cr.parent_office = ".$parent_office;
        }
        if($office){
            $condition[]=" cr.office = ".$office;
        }
        if($sub_office){
            $condition[]=" cr.sub_office = ".$sub_office;
        }
        if($c_date){
            if($t_date){
                 $condition[]=" (DATE_FORMAT(cr.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and DATE_FORMAT(cr.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."') ";
           }
        }
        
        if($user_type){
            $condition[]=" u.active_status = 3 ";
        }

        $manual_cond=implode(' and ',$condition);
        // get relevant information depending on the filters selected
        $user_result = $this->drm->get_no_of_users_for_delete($manual_cond);
        $case_number='';
        foreach($user_result as $row)
        {
            $case_number.= $row['case_no']. ',';
        }
        // Remove comma from last string.
        $case_number = rtrim($case_number,',');

        $data['case_nos'] = $case_number;
        
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Hard Delete', 'DeleteRequest/hard_delete');
        $this->breadcrumbs->push('Filters selected', 'DeleteRequest/display_filters_selected');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'display_filters_selected');

    }


    function listby_filter_search(){

        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $office = ($_REQUEST['branch_office_id']) ? $_REQUEST['branch_office_id'] : '';
        $parent_office = ($_REQUEST['head_office_id']) ? $_REQUEST['head_office_id'] : '';
        $sub_office = ($_REQUEST['sub_office_id']) ? $_REQUEST['sub_office_id'] : '';
        $c_date = ($_REQUEST['from_date']) ? $_REQUEST['from_date'] : '';
        $t_date = ($_REQUEST['to_date']) ? $_REQUEST['to_date'] : ''; 
        $user_type = ($_REQUEST['user_type']) ? $_REQUEST['user_type'] : '';

        $model = array('Delete_request_model' => 'get_filtersearch_data');

        if($org_id){
            $condition[]=" a.organisation = ".$org_id;
        }
        if($parent_office){
            $condition[]=" a.parent_office = ".$parent_office;
        }
        if($office){
            $condition[]=" a.office = ".$office;
        }
        if($sub_office){
            $condition[]=" a.sub_office = ".$sub_office;
        }
        if(!empty($c_date) && !empty($t_date)){
            
            $condition[]=" (DATE_FORMAT(a.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and DATE_FORMAT(a.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."') ";
           
        }

        $manual_cond = implode(' and ', (array)$condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            
            foreach ($result as $i => $row) {
                
                $createdOn=($row['created_on']) ? date('d-m-Y',strtotime($row['created_on'])) : '';
                $finalDate=($row['final_date']) ? date('d-m-Y',strtotime($row['final_date'])) : '';

                $response->rows[]['cell'] = array(
                    $i + $count + 1,$row['org_name'], $row['parent_office'],$row['office_name'],$row['sub_office'],$row['candidate_name'],$row['case_no'],$row['name'],$createdOn,$finalDate);
            }
        }
        echo json_encode($response);

    }


    /***********************************************
     * display_filters_selected_cases
     * Shows details of case_nos entered for delete
     ***********************************************/
    function display_filters_selected_cases()
    {
        // check if case_nos are entered
        $case_nos = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '0';
        $data['case_nos']=$case_nos;
        // If case_nos are entered then get data according to given case_nos
        
        if($case_nos != '0')
        {
            $c_n = explode(',', $case_nos);
            // check if all  case_nos entered belong to 1 organization
            $org_res_arr = $this->drm->is_organization_unique($c_n);
            $no_of_org = $org_res_arr['noOfOrg'];
            
            // If all cases_nos belong to 1  organization then get their information
            if($no_of_org == 0)
            {
                $data['message'] = "The cases entered are not there in our system. Please enter cases belonging to one organization. Click on cancel button to enter cases belonging to only 1 organization";
                $data['back']=1;
            }
            else if($no_of_org == 1)
            {
                $noOfUsers =  $org_res_arr['noOfCases'];;
                $records_result = $this->drm->get_info_for_delete_for_case_nos($c_n);
                
                // $records_result = $this->drm->()
                $noOfRecords =  count($records_result);
                $data['back']=0;
            }
            // If case_nos belong to more than 1 organization then show a message
            else
            {
                $data['message'] = "The cases entered seem to be from more than  1 organization. Please enter cases belonging to one organization. Click on cancel button to enter cases belonging to only 1 organization";
                $data['back']=1;
            }
        }

        $data['org_no']=$no_of_org;
        $data['noOfUsers'] = $noOfUsers;   
        $data['noOfRecords'] = $noOfRecords;
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Hard Delete', 'DeleteRequest/hard_delete');
        if($case_nos != '0')
        {
            $this->breadcrumbs->push('Delete Cases', 'DeleteRequest/display_filters_selected_cases');
        }

        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'display_filters_selected_cases');
        
        
    }

    /**************** Listing Case Filter********
     * **** function display_case_filter ********
     **************** By CK *********************/
    function display_case_filter()
    {
       
        $case_nos = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '0';
        $c_n = explode(',', $case_nos);
        $model = array('Delete_request_model' => 'get_bulkdelete_data');
        foreach($c_n as $case_no)
        {
            $condition[] = " a.case_no = '" . $case_no . "'";
        }

        $manual_cond = implode(' or ', (array)$condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {
                
                $createdOn=($row['created_on']) ? date('d-m-Y',strtotime($row['created_on'])) : '';
                $finalDate=($row['final_date']) ? date('d-m-Y',strtotime($row['final_date'])) : '';

                $response->rows[]['cell'] = array(
                    $i + $count + 1,$row['org_name'], $row['parent_office'],$row['office_name'],$row['sub_office'],$row['candidate_name'],$row['case_no'],$row['name'],$createdOn,$finalDate);
            }
        }
            echo json_encode($response);
        
    }
    
   
            // $delete_log = array(
            //     'delete_id' => NULL,                
            //     'org_id' => $org_id, 
            //     'head_office_id' => $parent_office_id,
            //     'branch_office_id' => $branch_office_id, 
            //     'sub_office_id' => $sub_office_id,
            //     'date_of_delete' => date('Y-m-d H:i:s'),
            //     'user_id' => $this->session->userdata['userid'],
            //     'role_id' => $this->session->userdata['role_id'],
            //     'input_parameters' => '',
            //     'case_nos_deleted' => '',
            //     'no_of_cases_deleted' => 0,
            //     'no_of_docs_deleted' => 0,
            //     'no_of_db_records_deleted' => '',
            //     'storage_space_released' =>  0    
            // );
   
    
    /**********************************************************************************
    * delete_files_folders
    ***********************************************************************************/
    function delete_files_folders()
    {
        // print_r($_POST);exit;
        // if case_nos have been entered
        $case_nos = ($_POST['case_no']) ? $_POST['case_no'] : '0';
        if($case_nos != '0')
        {
            $c_n = explode(',', $case_nos);
            // get information according to the case_nos  entered
            $result = $this->drm->get_info_for_delete_for_case_nos($c_n);

            $result1 = $this->drm->get_no_of_users_for_delete_for_case_nos($c_n);

        }
        

        if ($result) {
            
            $docArr = array(); // declare a multi-dimensional associative array to hold all files
            $deletedFilesArr = array(); // declare a multi-dimensional associative array to hold deleted files
            $arr_count = 0; // count of all file_names in the document array

            foreach( $result as $i => $row ) {      
               
                /************/
                $check_id = $row['check_id']; 
                $req_id =  $row['request_id'];
                $case_no = $row['case_no']; // Added on 8th Aug

                // documents for that particular request_id and check_id is taken
                // for example:-  if check_id is 14, data is taken from db table
                // dcode_education_details
                $documents_arr = $this->m->get_docs_for_finding_files_for_request_id($req_id, $check_id);
                $filepath = '';
                $doc_name ='';

                $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, $check_id);                
                $vm_name = $vm_name_arr['vm_name'];
                
                // get qc2_name
                $qc2_name_arr = $this->m->get_qc2_name_for_req_id($req_id);                
                $qc2_name = $qc2_name_arr['qc2_name'];
                //  if files or documents found, populate the $docs array
                if(!empty($documents_arr))
                {   
                    foreach($documents_arr as $record)
                    {
                        if(!empty($record['document_file']))
                        {
                            $filepath = $record['file_path'];
                            $doc_name = $record['doc_name'];
                           
                            $level_id = $record['level_id'];
                            $chk_count = $record['count_of_chk'];
                            $chk_count =  ($chk_count > 0) ? $chk_count : '';
                            

                            if($check_id == 14)
                            {
                                switch($doc_name)
                                {
                                    case 'document_file': $doc_name = 'Consolidated Marks';
                                        break;
                                    case 'gdocument': $doc_name = 'Degree Certificate';
                                        break;
                                    case 'consolidate_doc': $doc_name = 'Marks Card';
                                        break;
                                    case 'pdocument': $doc_name = 'Provisional Degree';
                                        break;
                                    default:
                                        break;
                                }

                            }
                            
                            if($check_id == 59)
                            {
                                switch($doc_name)
                                {
                                    case 'relieve_document': $doc_name = 'Relieving Document';
                                        break;
                                    case 'service_document': $doc_name = 'Service Document';
                                        break;
                                    case 'employement_file': $doc_name = 'Pay Slip Document';
                                        break;                                   
                                    default:
                                        break;
                                }

                            }
                            $docArr[$arr_count] = array('req_id' => $req_id,
                                                    'org_name' => $row['org_name'],
                                                    'check_id' => $check_id,
                                                    'check_name' => $row['name'],
                                                    'level_id' => $level_id, /** Aug 30th **/
                                                    'chk_count' => $chk_count, /** Aug 30th **/
                                                    'candidate_name' => $row['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'vm_name'  => $vm_name,
                                                    'qc2_name' => $qc2_name,
                                                    'created_on' => $row['created_on'],
                                                    'case_accepted_date' => $row['case_accepted_date'],
                                                    'case_recieved_date' => $row['case_recieved_date'],
                                                    'final_report_published_date' => $row['final_report_published_date'],
                                                    'supplement_report_date' => $row['supplement_report_date'],
                                                    'filename' => $record['document_file'],
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                            $arr_count++; // increment the index count of the $docs and $docArr arrays
                        }
                    }
                }

                // files or documents found in fielddata and qc2fielddata columns of dcode_verified_level db table
                $res_arr = $this->m->get_verified_documents($req_id, $check_id);
      
                foreach($res_arr as $row1)
                {
                    $verification_data=toArray(json_decode($row1['fielddata']));

                    // take all filenames in details portion of the json
                    $ver_doc_arr = $verification_data['details'];
                    
                    $level_id = $row1['level_id'];
                    $chk_count = $row1['count_of_chk'];
                    $chk_count =  ($chk_count > 0) ? $chk_count : '';
                    

                    if(!empty($ver_doc_arr))
                    {   
                        /*** will be helpful later if we need file_path ***/
                        $filepath = 'uploads/qcreferencedetails/'; 

                        $doc_name ='qcreferencedetails';

                        $arr  = explode(',',$ver_doc_arr); 
                        if(!empty($arr))
                        {
                            for($k=0; $k < count($arr);  $k++)
                            {
                                //  if files or documents found, populate the $docs array
                                if(!empty($arr[$k]))
                                {   
                                    // $docs[$arr_count] = $arr[$k];

                                    $docArr[$arr_count] = array('req_id' => $req_id,
                                                    'org_name' => $row['org_name'],
                                                    'check_id' => $check_id,
                                                    'check_name' => $row['name'],
                                                    'level_id' => $level_id, /** Aug 30th **/
                                                    'chk_count' => $chk_count, /** Aug 30th **/
                                                    'candidate_name' => $row['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'vm_name'  => $vm_name,
                                                    'qc2_name' => $qc2_name,
                                                    'created_on' => $row['created_on'],
                                                    'case_accepted_date' => $row['case_accepted_date'],
                                                    'case_recieved_date' => $row['case_recieved_date'],
                                                    'final_report_published_date' => $row['final_report_published_date'],
                                                    'supplement_report_date' => $row['supplement_report_date'],
                                                    'filename' => $arr[$k],
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                                    $arr_count++;  // increment the index count of the $docs array
                                }
                            }
                        }
                    }

                }
                 
            
            }
        }

        if(!empty($result1))
        {   
            // This has only request_ids and corresponding user_ids
            foreach($result1 as $row2)
            {
                // files or documents found in common db tables like personal_details etc.,
                $dummy_check_id = 0 ; // for common files check_id is considered as 0
                
                $req_id =  $row2['request_id'];
                $case_no = $row2['case_no']; 
                
                $doc_arr = $this->m->get_docs_for_finding_files_for_request_id($req_id, $dummy_check_id);
      
                $filepath = '';
                $doc_name ='';
                $check_name = 'common'; 

                $vm_name = '';
                // get qc2_name
                $qc2_name_arr = $this->m->get_qc2_name_for_req_id($req_id);                                
                $qc2_name = $qc2_name_arr['qc2_name'];

                //  if files or documents found, populate the $docs array
                if(!empty($doc_arr))
                {   
                    foreach($doc_arr as $m)
                    {  
                        
                        $dummy_check_id = 0 ;
                        $chk_count = 0; 
                        $chk_count =  ($chk_count > 0) ? $chk_count : '';
                        $check_name = 'common';
                        
                        if(!empty($m['document_file']))
                        {
                            // $docs[$arr_count] = $m['document_file'];
                            $filepath = $m['file_path'];
                            $tablename = $m['table_name'];
                            $filename = $m['document_file'];
                            $doc_name = $m['doc_name'];
                            
                            
                            if($doc_name == "report_name")
                            {
                                $vm_name  = '';
                                if($tablename == 'dcode_finalreportpublished')
                                {
                                    $doc_name = 'Final Report';
                                }
                                else
                                {
                                    $doc_name = 'Manual Report';
                                }
                            }
                            
                            if($doc_name == "authenticate_doc")
                            {
                                $check_id_doc_name_arr = $this->m->get_check_id_and_documentname_for_req_id_and_filename($req_id, $m['document_file']);
                                
                                if($check_id_doc_name_arr['status'] == 0)
                                {
                                    continue;
                                }
                                
                                $dummy_check_id = $check_id_doc_name_arr['check_id'];
                                $check_name = $check_id_doc_name_arr['name'];
                                $doc_name = $check_id_doc_name_arr['document_name'];
                                $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, $dummy_check_id);
                
                                $vm_name = $vm_name_arr['vm_name']; 

                            }
                            
                            
                            if($tablename == 'dcode_personal_details' && $doc_name == 'user_image')
                            {
                                // get vm name of employment i.e., check id 59 if present
                                $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, 59);
                                if(!empty($vm_name_arr))
                                    {
                                        $vm_name = $vm_name_arr['vm_name'];
                                    }
                            }
                            if($tablename == 'dcode_billing_doc' && $doc_name == 'bill_proof')
                            {
                                $bill_arr = $this->m->get_count_of_chk_for_bill_proof($req_id, $m['document_file']);
                                $dummy_check_id = $bill_arr['check_id'];
                                $check_name = $bill_arr['name'];
                                $chk_count = $bill_arr['count_of_chk'];
                                $level_id = $bill_arr['level_id'];
                    
                                $chk_count =  ($chk_count > 0) ? $chk_count : '';

                                // get vm name of employment i.e., check id 59 if present
                                $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, $dummy_check_id);
                                if(!empty($vm_name_arr))
                                    {
                                        $vm_name = $vm_name_arr['vm_name'];
                                        
                                    }
                            }
                            
                            if($tablename == 'dcode_contact_details' && $doc_name == 'additional_doc')
                            {
                                $doc_name = 'contact_details_additional_doc';
                            }
                            if($tablename == 'dcode_personal_additional_doc' && $doc_name == 'additional_doc')
                            {
                                $check_id_doc_name_arr_personal = $this->m->get_doc_name_from_personal_additional_doc($req_id, $filename);
                                $dummy_check_id = $check_id_doc_name_arr_personal['check_id'];
                                $doc_name = $check_id_doc_name_arr_personal['document_name'];
                                $check_name = $check_id_doc_name_arr_personal['name'];
                                
                                if($dummy_check_id != 0)
                                {
                                    // get vm_name
                                    $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, $dummy_check_id);
                                    $vm_name = $vm_name_arr['vm_name'];
                                }
                               
                                if($dummy_check_id == 0)
                                    $check_name = 'common';                               
                                $level_id = $check_id_doc_name_arr_personal['level_id'];
                                $chk_count = 0;
                                $chk_count = $check_id_doc_name_arr_personal['count_of_chk'];
                                $chk_count =  ($chk_count > 0) ? $chk_count : '';
                               
                                if($doc_name == '')
                                    $doc_name = 'personal_additional_doc';
                            }
                            if($tablename == 'dcode_requested_additional_doc' && $doc_name == 'additional_doc')
                                {
                                    $check_id_doc_name_arr_requested = $this->m->get_doc_name_from_requested_additional_doc($req_id, $filename);
                                    $dummy_check_id = $check_id_doc_name_arr_requested['check_id'];
                                    $doc_name = $check_id_doc_name_arr_requested['document_name'];
                                    $check_name = $check_id_doc_name_arr_requested['name'];
                                    
                                    if($dummy_check_id != 0)
                                    {
                                        // get vm_name
                                        $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, $dummy_check_id);
                                        $vm_name = $vm_name_arr['vm_name'];
                                    }
                                    
                                    if($dummy_check_id == 0)
                                        $check_name = 'common';                                    
                                    $level_id = $check_id_doc_name_arr_requested['level_id'];
                                    $chk_count = 0;
                                    $chk_count = $check_id_doc_name_arr_requested['count_of_chk'];
                                    $chk_count =  ($chk_count > 0) ? $chk_count : '';
                                    
                                    if($doc_name == '')
                                        $doc_name = 'requested_additional_doc';
                                }
                            
                            if($tablename == 'dcode_partial_upload_document')
                            {
                                $doc_name_arr = $this->m->get_doc_name_from_partial_upload_document($req_id, $filename);
                                
                                if($doc_name_arr['status'] == 0)
                                {
                                    continue;
                                }
                               $doc_name = $doc_name_arr['document_name'];
                            }
                            $docArr[$arr_count] = array('req_id' => $req_id,
                                        'org_name' => $row2['org_name'],
                                                    'check_id' => $dummy_check_id,
                                                    'check_name' => $check_name, 
                                                    'level_id' => $level_id, 
                                                    'chk_count' => $chk_count, 
                                                    'candidate_name' => $row2['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'vm_name'  => $vm_name,
                                                    'qc2_name' => $qc2_name,
                                                    'created_on' => $row2['created_on'],
                                                    'case_accepted_date' => $row2['case_accepted_date'],
                                                    'case_recieved_date' => $row2['case_recieved_date'],
                                                    'final_report_published_date' => $row2['final_report_published_date'],
                                                    'supplement_report_date' => $row2['supplement_report_date'],
                                                    'filename' => $filename,
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                            $arr_count++; // increment the index count of the $docs array
                        }

                    }
                }
                
                // files or documents found in dcode_user table
                $dummy_check_id = 999; // check_id is considered as 999 for files in dcode_user table
                $user_id =  $row2['user_id'];

                $user_arr = $this->m->get_docs_for_finding_files_for_request_id($user_id, $dummy_check_id);

                $filepath = '';
                $doc_name ='';

                if(!empty($user_arr))
                {   
                    foreach($user_arr as $u)
                    {
                        //  if files or documents found, populate the $docs array
                        if(!empty($u['document_file']))
                        {
                            $filepath = $u['file_path'];
                            
                            $level_id = $u['level_id'];
                            $chk_count = $u['count_of_chk'];
                            $chk_count =  ($chk_count > 0) ? $chk_count : '';
                            
                            $docArr[$arr_count] = array('req_id' => $req_id,
                                        'org_name' => $row2['org_name'],
                                                    'check_id' => $dummy_check_id,
                                                    'check_name' => 'user',
                                                    'level_id' => $level_id, 
                                                    'chk_count' => $chk_count, 
                                                    'candidate_name' => $row2['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'vm_name'  => $vm_name,
                                                    'qc2_name' => $qc2_name,
                                                    'created_on' => $row2['created_on'],
                                                    'case_accepted_date' => $row2['case_accepted_date'],
                                                    'case_recieved_date' => $row2['case_recieved_date'],
                                                    'final_report_published_date' => $row2['final_report_published_date'],
                                                    'supplement_report_date' => $row2['supplement_report_date'],
                                                    'filename' => $u['document_file'],
                                                    'document_name' => $u['doc_name'],
                                                    'filepath' => $filepath
                                                );
                            $arr_count++;
                        }

                    }
                }
                    
            }
        }

        // echo '<pre>'; print_r($result);
        $user_id=$this->session->userdata['userid'];
        foreach($c_n as $insVal){
            $caseNumber=$insVal;
            $insRecord=$this->drm->get_candidate_info($caseNumber);

            $ins_data['request_id'] = $insRecord[0]['request_id'];
            $ins_data['organization'] = $insRecord[0]['organisation'];
            $ins_data['head_office'] = $insRecord[0]['h_office'];
            $ins_data['branch_office'] = $insRecord[0]['b_office'];
            $ins_data['sub_office'] = $insRecord[0]['sub_office'];
            $ins_data['candidate_name'] = $insRecord[0]['candidate_name'];
            $ins_data['case_no'] = $caseNumber;
            $ins_data['deleted_by'] = $user_id;
            $ins_data['deleted_on'] = date ( 'Y-m-d H:i:s' );
            
            $ins_data = $this->security->xss_clean($ins_data);
            $this->db->insert ( DB_PREFIX .'hard_delete_log', $ins_data );

            /************ Soft Delete ************/
            $cand_id=$insRecord[0]['user_id'];
            $this->drm->mark_user_for_delete($cand_id);

        }
        // print_r($docArr);exit();
        if(!empty($docArr))
        {
            foreach ($docArr as $fileArr) 
            {
                $fileName=$fileArr['filename'];
                $filename = basename($fileName);
                $this->drm->renameFileName($filename, $fileArr['filepath']);
                
            }
        }
        else
        {
            echo 'No files found';
        }
        echo '<script type="text/javascript">window.parent.hndl_del_roleresp("Case has been deleted successfully.!2")</script>';
	    
        redirect(base_url('DeleteRequest/marked_deleted_list'),'refresh');
        // $this->load->view('DeleteRequest/marked_deleted_list');
    
  } // end of function delete_files_folders
  
  

    function call_rename_func()
    {
        echo 'Hi';
        $file_name = 'noimage.jpg';
        $file_path  = 'uploads/user_photo/';
        echo  $this->renameFileName($file_name,  $file_path);
    }

    function display_case_nos() {
        
        if($this->session->userdata['userid']==1){
            $userId=$this->session->userdata['userid'];
        }

        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Hard Delete', 'DeleteRequest/hard_delete');
        $this->breadcrumbs->push('Case Nos selected', 'DeleteRequest/display_case_nos');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'display_case_nos');
    }

    function get_selected_cases()
    {
        $model = array('Delete_request_model'=>'get_info_for_grid_delete_for_case_nos');
        $case_nos = ($_REQUEST['case_nos']) ? $_REQUEST['case_nos'] : '';
        // print_r($case_nos);exit();
        $results = $this->_jqgrid_search($model,$case_nos); 
        $response = $results[0];  
        $result = $results[1]; 
        
        if ($result) {
            
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            $k=1;
            
            // echo '<pre> Result  ==>'; print_r($result);exit();
            foreach( $result as $i => $row ) { 
                $reopen_status = ''; 
                // Code added to handle single shot reopen-revert
                $supp_count = $this->rm->get_supplementarycount($row['request_id']);           
                $supplementary_open_count = $supp_count['sup_cnt'];

                $supp_closed_count = $this->rm->get_supplementary_closed_count($row['request_id']);           
                $supplementary_closed_count = $supp_closed_count['sup_cnt'];
            
                if($row['supplement_report']==2  || $supplementary_open_count <> 0)
                {
                    $reopen_status='Reopen';
                }
                elseif($row['supplement_report']==1){ 
                    $reopen_status='Reopen-Completed';
                }
                elseif($supplementary_closed_count <> 0 && $supplementary_open_count == 0){ 
                    $reopen_status='Reopen-Completed';
                } 
                $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['head_office'],$row['branch_office'],$row['sub_office'],$row['candidate_name'],$row['case_no'],$row['created_on'],$row['final_report_published_date'],$reopen_status);
            }
            echo json_encode($response);
        }

    }

    function display_organization_details() {
        
        if($this->session->userdata['userid']==1){
            $userId=$this->session->userdata['userid'];
        }
        $data = $_POST;

        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Hard Delete', 'DeleteRequest/hard_delete');
        $this->breadcrumbs->push('Case Nos selected', 'DeleteRequest/display_organization_details');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'display_organization_details');
    }


    /**** Candidate Hard Delete ****
     **** function cand_hard_delete *
     ****** By CK ******************/
    function cand_hard_delete(){

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Hard Delete', 'DeleteRequest/cand_hard_delete');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'Hard Delete');
    }

    /********* Function to perform delete operation*****
     * ******* function delete_hard() ******************
     ***************************************************/
    function delete_hard(){
        
        $candInfo=$this->drm->get_requestid($_POST['case_no']);
        $request_id=$candInfo[0]['request_id'];
        $checkInfo=$this->drm->get_checks($request_id);
        // print_r($checkInfo);

        foreach($checkInfo as $chkval){

            $check_id=$chkval['check_id'];
            $nos_check=$chkval['no_checks'];
            $table=$this->drm->get_tablename($check_id);
            $table_name=$table[0]['table_name'];
            $columns=$this->drm->get_columns($check_id);
            $tableName=mb_substr($table_name, 6);

            $levelInfo=$this->drm->get_level($tableName, $request_id, $check_id);

            foreach($columns as $colval){
                $colName=$colval['column_name'];
                $filePath=$colval['file_path'];
                // echo $check_id.'<br>';

                foreach($levelInfo as $levelval){
                    $level_id=$levelval['level_id'];
                    $fileInfo=$this->drm->get_file_name($tableName, $request_id, $colName, $check_id, $level_id);
                    // print_r($fileInfo);
                    $filename=$fileInfo[0][$colName];

                    if(!empty($filename) && file_exists($filePath.$filename)){
                        // unlink($filePath.$filename);
                        // echo $filename.'<br>';
                    }
                }
            }    
        }
        
        // Get tables and columns without check id 
        $chk_id=0;
        $tables=$this->drm->get_tablename($chk_id);
        
        $tableName=$table[0]['table_name'];
        $table_Name=mb_substr($table_name, 6);
        $columns=$this->drm->get_columns($chk_id);
        echo '<pre>';print_r($columns);

    }


    function get_selected_org_details()
    {
        $model = array('Delete_request_model'=>'get_info_for_grid_delete_for_organization');
        $case_nos = ($_REQUEST['case_nos']) ? $_REQUEST['case_nos'] : '';
       
        // Get all filters selected like organization etc.,
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $office = ($_REQUEST['branch_office_id']) ? $_REQUEST['branch_office_id'] : '';
        $parent_office = ($_REQUEST['head_office_id']) ? $_REQUEST['head_office_id'] : '';
        $sub_office = ($_REQUEST['sub_office_id']) ? $_REQUEST['sub_office_id'] : '';
        $c_date = ($_REQUEST['from_date']) ? $_REQUEST['from_date'] : '';
        $t_date = ($_REQUEST['to_date']) ? $_REQUEST['to_date'] : ''; 
        $user_type = ($_REQUEST['user_type']) ? $_REQUEST['user_type'] : '';
        
        if($user_type==1)
            $data['user_type']='Deleted'; 


        // If organization, head office etc., filters are selected form a search condition[]
        if($org_id){
            $condition[]=" cr.organisation = ".$org_id;
        }
        if($parent_office){
            $condition[]=" cr.parent_office = ".$parent_office;
        }
        if($office){
            $condition[]=" cr.office = ".$office;
        }
        if($sub_office){
            $condition[]=" cr.sub_office = ".$sub_office;
        }
        if($c_date){
            if($t_date){
                 $condition[]=" (DATE_FORMAT(cr.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and DATE_FORMAT(cr.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."') ";
           }
        }
        
        if($user_type){
            $condition[]=" u.active_status = 3 ";
        }

        $manual_cond=implode(' and ',$condition);


        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
    
        if ($result) {
            
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            $k=1;
            
            foreach( $result as $i => $row ) {
                $reopen_status = ''; 
                // Code added to handle single shot reopen-revert
                $supp_count = $this->rm->get_supplementarycount($row['request_id']);           
                $supplementary_open_count = $supp_count['sup_cnt'];

                $supp_closed_count = $this->rm->get_supplementary_closed_count($row['request_id']);           
                $supplementary_closed_count = $supp_closed_count['sup_cnt'];
            
                if($row['supplement_report']==2  || $supplementary_open_count <> 0)
                {
                    $reopen_status='Reopen';
                }
                elseif($row['supplement_report']==1){ 
                    $reopen_status='Reopen-Completed';
                }
                elseif($supplementary_closed_count <> 0 && $supplementary_open_count == 0){ 
                    $reopen_status='Reopen-Completed';
                } 
                $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['head_office'],$row['branch_office'],$row['sub_office'],$row['candidate_name'],$row['case_no'],$row['created_on'],$row['final_report_published_date'],$reopen_status);
            }
            echo json_encode($response);
        }

    }

    /****************************
    **** Marked Deleted List ****
    * Function kotak_dd
    *********By ck**************/
    function marked_deleted_list() { 
        
        $this->_check_featureauth('users', 'view');
        $data['auth_link'] = array(
            array('users', 'search', 'Back', 'DeleteRequest/hard_delete', ''),
            );

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Bulk Delete', 'DeleteRequest/marked_deleted_list');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'marked_deleted_list');
    }


    /**************** Listing  Marked Deleted record ********
     * **** function display_marked_deleted_record ********
     **************** By CK *********************/
    function display_marked_deleted_record()
    {
        // print_r($_REQUEST);exit;
        $model = array('Delete_request_model' => 'get_markeddeleted_data');

        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $case_number=($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
	    $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
        
        if($parent_office){
            $condition[]=" d.id = ".$parent_office;
        }
        if($office){
            $condition[]=" b.id = ".$office;
        }
        if($org_id){
            $condition[]=" c.id = ".$org_id;
        }
        if($sub_office){
            $condition[]=" o.id = ".$sub_office;
        }
        echo $$case_number;
        if($name){
            $condition[]=" a.candidate_name like '%".$name."%'";
        }
        if($case_number){
            $case_number =trim($case_number);
            $condition[]=" a.case_no like '%".$case_number."'";
        }

        
        $manual_cond = implode(' and ', (array)$condition);
        // print_r($manual_cond);exit();
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        // print_r($result);exit();
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {
                
                $deletedOn=($row['deleted_on']) ? date('d-m-Y',strtotime($row['deleted_on'])) : '';
                
                $response->rows[]['cell'] = array(
                    $i + $count + 1,$row['org_name'], $row['h_office'],$row['b_office'],$row['sub_office'],$row['candidate_name'],$row['case_no'],$row['deleted_by'],$deletedOn);
            }
        }
            echo json_encode($response);
        
    }

    /************ Export Marked Deleted Lists **************
     * ******* function export_marked_deleted_list ********
     *************** By CK *******************************/
    function export_marked_deleted_record(){

        $model = array('Delete_request_model' => 'get_export_marked_deleted_data');
        $name = ($_POST['exp_name']) ? $_POST['exp_name'] : '';
        $org_id = ($_POST['exp_org_id']) ? $_POST['exp_org_id'] : '';
        $office = ($_POST['exp_office_id']) ? $_POST['exp_office_id'] : '';
        $parent_office = ($_POST['exp_parent_office']) ? $_POST['exp_parent_office'] : '';
        $sub_office = ($_POST['exp_sub_office']) ? $_POST['exp_sub_office'] : '';
        $case_number=($_POST['exp_case_number']) ? $_POST['exp_case_number'] : '';

        if($parent_office){
            $condition[]=" d.id = ".$parent_office;
        }
        if($office){
            $condition[]=" b.id = ".$office;
        }
        if($org_id){
            $condition[]=" c.id = ".$org_id;
        }
        if($sub_office){
            $condition[]=" o.id = ".$sub_office;
        }
        if($name){
            $condition[]=" a.candidate_name like '%".$name."%'";
        }
        if($case_number){
            $case_number =trim($case_number);
            $condition[]=" a.case_no like '%".$case_number."'";
        }

        $manual_cond=implode(' and ',$condition);

        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];  
        $result = $results[1];
        
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
             $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
             $page=$page - 1;
             $count=$page * $rows;

            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Head Office");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Branch Office");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Sub Office");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Deleted By");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Deleted On");

            $ci=2; 
            foreach ( $result as $i => $row ) {

                $deleted_date=($row['deleted_on']) ? date('d-m-Y h:i:s',strtotime($row['deleted_on'])) : '';
                $objPHPExcel->getActiveSheet()->getStyle('A1:I1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                    ->setCellValue('B' . $ci, $row['org_name'])
                    ->setCellValue('C' . $ci, $row['h_office'])
                    ->setCellValue('D' . $ci, $row['b_office'])
                    ->setCellValue('E' . $ci, $row['sub_office'])
                    ->setCellValue('F' . $ci, $row['candidate_name'])
                    ->setCellValue('G' . $ci, $row['case_no'])
                    ->setCellValue('H' . $ci, $row['deleted_by'])
                    ->setCellValue('I' . $ci, $deleted_date);
                    $ci++;
            }
            $this->export_excel('A','I','Marked_Deleted_records_details',$objPHPExcel);
            exit;
        }
        redirect('DeleteRequest/marked_deleted_list');
        
    }
     

    /****************************************
     * ***** check Case No ******************
     ******* function check_case_numbers ****/

     function check_case_numbers(){
        // print_r($_POST);
        $case_nos = ($_POST['case_no']) ? $_POST['case_no'] : '0';
        $c_n = explode(',', $case_nos);
        foreach($c_n as $caseVal){
            $case_no=$caseVal;
            
            $result=$this->drm->get_candidate_info($case_no);
            if(empty($result)){
               echo ($case_no) ? $case_no.',' : '';
            }
        }
    }


    /****************************************
     * ***** check Organization ******************
     ******* function check_orgwise_case ****/

     function check_orgwise_case(){
        // print_r($_POST);
        $case_nos = ($_POST['case_no']) ? $_POST['case_no'] : '0';
        $c_n = explode(',', $case_nos);

        $organization=$this->drm->is_organization_unique($c_n);
        $no_of_org = $organization['noOfOrg'];
        echo $no_of_org;
    }












} // End of controller