<?php if (!defined('BASEPATH')) {
 exit('No direct script access allowed');
}
require_once('Common.php');
require_once('./PHPExcel-1.8/Classes/PHPExcel.php');

class Drugtest extends Common
{
 protected $request_orgid = 'org_id';
 protected $request_office = 'office';
 protected $request_parent_office = 'parent_office';
 protected $request_sub_office = 'sub_office';

 function __construct()
 {
 parent::__construct();
 $this->_check_userlogin();
 $models = array('Drugtest_model' => 'drm', 'Verification_model' => 'vm', 'Dadmin_model' => 'dm', 'Dataentry_model' => 'dem', 'Reports_model' => 'rm', 'Client_model' => 'cm', 'Verification_report_model' => 'vrm', 'Qualityverification_model' => 'qc', 'Candidate_model' => 'cam'); // MN Jul
 $this->lang->load('Dataentry');
 foreach ($models as $file => $object_name) {
 $this->load->model($file, $object_name);
 }
 $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
 $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'jquery-ui-1.10.4', 'highcharts', 'exporting', 'jquery.validate', 'grid.locale-en', 'jquery.jqGrid.min', 'jquery-ui-1.8.16.custom.min', 'autocomplete', 'multipleclone', 'jquery.datepick'));
 $this->load->helper('text');
 }

 function drug_exportnew()
 {

 $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
 $this->breadcrumbs->push('Export Details', 'Drugtest/drug_exportnew');
 $data['breadcrumb'] = $this->breadcrumbs->show();
 $this->amodel->pagerender($data, 'drug_exportnew');
 }

 function get_newdrugrecordlist()
 {

 $model = array('Drugtest_model' => 'get_newdrugrecordlist');
 $office = ($_REQUEST['office_id']) ? $_REQUEST['office_id'] : ''; // Nov 6th
 $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
 $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
 $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
 $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';

 $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
 $check_count = ($_REQUEST['check_count']) ? $_REQUEST['check_count'] : '';

 $userId = ($_REQUEST['userId']) ? $_REQUEST['userId'] : '';

 if ($org_id)
 $condition[] = " o.id = " . $org_id;
 if ($office)
 $condition[] = " br.id = " . $office;
 if ($parent_office)
 $condition[] = " p.id = " . $parent_office;
 if ($sub_office)
 $condition[] = " su.id = " . $sub_office;
 // if ($name) {
 // $condition[] = "((concat_ws(' ',cr.firstname,cr.middlename,cr.lastname) like '%" . $name . "%'))";
 // }
 if ($name) {
 $nameParts = explode(' ', $name);
 $nameConditions = array();
 foreach ($nameParts as $part) {
 $nameConditions[] = "(cr.firstname LIKE '%" . $part . "%' OR cr.middlename LIKE '%" . $part . "%' OR cr.lastname LIKE '%" . $part . "%')";
 }
 $condition[] = "(" . implode(' AND ', $nameConditions) . ")";
 }

 if ($case_no)
 $condition[] = "d.case_no like '%" . $case_no . "%' ";

 if ($check_count == 'New') {
 $condition[] = "a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0 ";
 }
 $manual_cond = implode(' and ', $condition);
 $results = $this->_jqgrid_search($model, $manual_cond);
 $response = $results[0];
 $result = $results[1];

 if ($result) {
 $checkteam = $this->config->item('CHECKLIST', APPLICATIONCONFIG);
 $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
 $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
 $page = $page - 1;
 $count = $page * $rows;
 $k = 1;


 foreach ($result as $i => $row) {
 if ($row['checkId'] == 75) {

 $mb = isset($row['crmob']) ? $this->encryption->decrypt($row['crmob']) : '-';
 $package = $row['crlevelname'];
 $candidatename = $row['crfirstname'] . " " . $row['crmidname'] . " " . $row['crlastname'];
 }

 $dob = date("d-m-Y", strtotime($row['bdob']));
 $gender = $row['mgender'];
 $address = $row['baddress'];
 $level = $row['crlevelname'];

 $vtext = 'New';

//  $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $vtext, 'target="_blank"');
 $response->rows[$i]['cell'] = array($i + $count + 1, $row['case_no'], $row['org_name'], $candidatename, $dob, $gender, $mb, $address, $level, $row['parent_office'], $row['office_name'], $row['sub_office'], $vtext, anchor('/Dadmin/dadminview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['checkId']), 'View'));
 }
 
 echo json_encode($response);
 }
 }


 // export xls for drug test

 function export_drugrecordlist()
 {
 
 $model = array('Drugtest_model' => 'export_drugrecordlist');
 $office = ($_REQUEST['exp_office_id']) ? $_REQUEST['exp_office_id'] : ''; // Nov 6th
 $name = ($_REQUEST['exp_name']) ? $_REQUEST['exp_name'] : '';
 $org_id = ($_REQUEST['exp_org_id']) ? $_REQUEST['exp_org_id'] : '';
 $parent_office = ($_REQUEST['exp_parent_office']) ? $_REQUEST['exp_parent_office'] : '';
 $sub_office = ($_REQUEST['exp_sub_office']) ? $_REQUEST['exp_sub_office'] : '';
 $case_no = ($_REQUEST['exp_case_no']) ? $_REQUEST['exp_case_no'] : '';
 $check_count = ($_REQUEST['exp_check_count']) ? $_REQUEST['exp_check_count'] : '';

 if ($org_id)
 $condition[] = " o.id = " . $org_id;
 if ($office)
 $condition[] = " br.id = " . $office;
 if ($parent_office)
 $condition[] = " p.id = " . $parent_office;
 if ($sub_office)
 $condition[] = " su.id = " . $sub_office;
 // if ($name) {
 // $condition[] = "((concat_ws(' ',cr.firstname,cr.middlename,cr.lastname) like '%" . $name . "%'))";
 // }
 if ($name) {
 $nameParts = explode(' ', $name);
 $nameConditions = array();
 foreach ($nameParts as $part) {
 $nameConditions[] = "(cr.firstname LIKE '%" . $part . "%' OR cr.middlename LIKE '%" . $part . "%' OR cr.lastname LIKE '%" . $part . "%')";
 }
 $condition[] = "(" . implode(' AND ', $nameConditions) . ")";
 }

 if ($case_no)
 $condition[] = "d.case_no like '%" . $case_no . "%' ";

 if ($check_count == 'New') {
 $condition[] = "a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0 ";
 }

 $manual_cond = implode(' and ', $condition);
 $results = $this->_jqgrid_search($model, $manual_cond);
 // exit();
 $response = $results[0];
 $result = $results[1];
 if ($result) {
 $checkteam = $this->config->item('CHECKLIST', APPLICATIONCONFIG);
 $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
 $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
 $page = $page - 1;
 $count = $page * $rows;
 $k = 1;
 $objPHPExcel = new PHPExcel();
 $objPHPExcel->setActiveSheetIndex(0);
 $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
 $objPHPExcel->getActiveSheet()->setCellValue('B1', "Case Number");
 $objPHPExcel->getActiveSheet()->setCellValue('C1', "Client Name");
 $objPHPExcel->getActiveSheet()->setCellValue('D1', "Candidate Name");
 $objPHPExcel->getActiveSheet()->setCellValue('E1', "Date of birth");
 $objPHPExcel->getActiveSheet()->setCellValue('F1', "Gender");
 $objPHPExcel->getActiveSheet()->setCellValue('G1', "Mobile No");
 $objPHPExcel->getActiveSheet()->setCellValue('H1', "Current Address");
 $objPHPExcel->getActiveSheet()->setCellValue('I1', "Panel");
 $objPHPExcel->getActiveSheet()->setCellValue('J1', "Head Office");
 $objPHPExcel->getActiveSheet()->setCellValue('K1', "Branch Office");
 $objPHPExcel->getActiveSheet()->setCellValue('L1', "Sub Office");



 $ci = 2;
 foreach ($result as $i => $row) {
 if ($row['checkId'] == 75) {
 $mb = isset($row['crmob']) ? $this->encryption->decrypt($row['crmob']) : '-';
 $candidatename = $row['crfirstname'] . " " . $row['crmidname'] . " " . $row['crlastname'];
 }
 $dob = date("d-m-Y", strtotime($row['bdob']));
 $gender = $row['mgender'];
 $address = $row['baddress'];
 $level = $row['crlevelname'];




 $objPHPExcel->getActiveSheet()->getStyle('A1:L1')->getFont()->setBold(true);
 $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i + $count + 1))
 ->setCellValue('B' . $ci, $row['case_no'])
 ->setCellValue('C' . $ci, $row['org_name'])
 ->setCellValue('D' . $ci, $candidatename)
 ->setCellValue('E' . $ci, $dob)
 ->setCellValue('F' . $ci, $gender)

 ->setCellValue('G' . $ci, $mb)

 ->setCellValue('H' . $ci, $address)
 ->setCellValue('I' . $ci, $level)

 ->setCellValue('J' . $ci, $row['parent_office'])
 ->setCellValue('K' . $ci, $row['office_name'])
 ->setCellValue('L' . $ci, $row['sub_office']);

 $ci++;
 }
 $this->export_excel('A', 'L', 'New_drugrecord_Export_List_', $objPHPExcel);
 exit;
 }
 
 }
}