<?php if ( ! defined('BASEPATH'))
{
    exit('No direct script access allowed');
} 
require_once('Common.php');
Class Index extends Common {

    protected static $dashboard_model = 'Dashboard_model';
    protected $query = 'query';
    protected $index_login = 'Index/login';
    protected $rstatus='';
        function __construct() 
        {
        parent::__construct();
        $this->load->model('Dashboard_model','dmodel');
        $this->load->model('Adm_model','amodel');
        $this->load->model('Client_model','cm');
        $this->load->model('Verification_model','vm');
        $this->load->helper(array('form','add','translate','roles'));
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','jquery-ui-1.10.4','highcharts','exporting','jquery.validate','grid.locale-en','jquery.jqGrid.min','jquery-ui-1.8.16.custom.min'));

        }
        

        function password_policy(){
    
        echo '<div class="acn-txt2" style="text-align: right;margin: 0px 10px 30px 10px;">
                <a onclick="history.back();"><h2 style="margin-right: 50px;">Back</h2></a>
            </div>
            <div class="loan-cntbx" style="margin: 30px 10px 30px 10px;">
                <div class="sn-txt">

            P/W policy:        
    <ul>
     
        <li>
            Contain both upper and lower case characters (e.g.,a-z, A-Z, )
        </li>
        <li>
            Having digits and punctuation characters as well as letters 
        </li>
        (e.g.,0-9, !@#$%^&&*()_+|~-=\`{}[]:;<>,./)
        <li>
            Are at least 12 alphanumeric characters long including special characters
        </li>
        <li>
            Password should never be written down or stored on-line.
        </li>
        

    </ul>
                    
                    
<pre>
P/W lockout policy:

    1) Account lockout threshold - 20 mins
    2) Password attempts - 5 times.

</pre>
                    
                </div>
            </div>';

        }

         /*Set up user data in session*/
        function _login_session($username,$password,$logintype = '')    
        {
                $default_data=$this->dmodel->default_user($username,$password);
                $defaultRole=$default_data['default_role_id'];

                if($defaultRole == 0){
                    $data[$this->query] = $this->dmodel->adminlogin($username,$password);
                }else{
                    $data[$this->query] = $this->dmodel->default_adminlogin($username,$password);
                }

                if(!empty($data[$this->query][0]->roles)) {
                    $role=explode(',', $data[$this->query][0]->roles);
                    
                    if($defaultRole == 0){
                        $roles=$role[0];
                    }else{
                        $roles=$defaultRole;
                    }
                    $role_name=$data[$this->query][0]->role_name;
                }
                else
                {
                    $roles=$data[$this->query][0]->role_id;
                    $role_name=$data[$this->query][0]->user_rolename;
                }
            if($data[$this->query] != NULL)    {
                    $user = array('userid' => $data[$this->query][0]->id,            
                    'name'=> $data[$this->query][0]->name,
                    'parentoffice_id'=> $data[$this->query][0]->parentoffice_id,
                    'org_name'=> $data[$this->query][0]->org_name,
                    'organization'=> $data[$this->query][0]->organization,
                    'parent_office'=> $data[$this->query][0]->parent_office,
                    'parent_office_name'=> $data[$this->query][0]->parent_office_name,
                    'office_name'=> $data[$this->query][0]->office_name,
                    'email'=> $data[$this->query][0]->email,
                    'status'=> $data[$this->query][0]->status,
                    'office_id'=> $data[$this->query][0]->office_id,
                    'sub_office'=> $data[$this->query][0]->sub_office,
                    'user_type'=> $data[$this->query][0]->user_type,
                    'role_id' => $roles,
                    'role_name'=> $role_name,
                    'username'=> $data[$this->query][0]->username,
                    'designation'=> $data[$this->query][0]->designation,
                    'logo'=> $data[$this->query][0]->logo,
                    'user_image'=> $data[$this->query][0]->original,
                    'userType'=>$data[$this->query][0]->user_type,
                    'password'=>$data[$this->query][0]->password,
                    'created_on'=>$data[$this->query][0]->created_on,
                    'prefix' => 'dcode_',
                    'roles' => explode(',', $data[$this->query][0]->roles),
                    'poffice'=> explode(',', $data[$this->query][0]->poffice),
                    'boffice'=> explode(',', $data[$this->query][0]->boffice),
                    'soffice'=> explode(',', $data[$this->query][0]->soffice),
                    'currency' => 'INR',
                    'is_logged_in' => TRUE); 
                       $this->session->sess_expiration = '14400';
                        $this->session->set_userdata($user);
                        return true;
                }
        }
        
        /*login Form */
        function login()
        { 
            $max_attempts = 5;
            $userName=$_POST['username'];
            $data='' || $data= [];
            $this->form_validation->set_rules('username', 'username', 'trim|required');
            $this->form_validation->set_rules('password', 'password', 'trim|required');
            //$this->form_validation->set_rules('g-recaptcha-response', 'g-recaptcha-response', 'callback_captcha_validation');
            $this->form_validation->set_rules('g-recaptcha-response', 'recaptcha validation', 'required|callback_validate_captcha');
            $this->form_validation->set_message('validate_captcha', 'Please check the the captcha form');

            if($this->form_validation->run() == TRUE) {
                
            $session_op = $this->_login_session($_POST['username'],$_POST['password'],$_POST['logintype']); 

            /********* Check Email *********/
            // $check_email = $this->Is_email($userName);
            // if($check_email){ 
            //     $this->db-> select('login_attempt')->from(DB_PREFIX .'user')->where("(email = '$userName' AND status = 1)");
            //     $num =$this->db->get()->result_array();
            // }else{
            //     $this->db->select('login_attempt')->from(DB_PREFIX . 'user ')->where("(username = '$userName' AND status = 1)");
            //     $num =$this->db->get()->result_array();
            // }

            $Res= $this->Log_attempt($userName); 
            $countAtmpt=$Res[0]['login_attempt'];
            $usrName=$Res[0]['username'];
            //print_r($usrName);exit;
             
            if( ($countAtmpt < $max_attempts) && $session_op)
            { 
                if($check_email){
                $this->db->update(DB_PREFIX . "user", array('login_attempt'=>0), array('email' => $userName));
                }
                else{
                $this->db->update(DB_PREFIX . "user", array('login_attempt'=>0), array('username' => $userName));
                }

            if($this->session->userdata('status')==0 || $this->session->userdata('status')==2)
            {
            $this->session->set_userdata('message','Your Account has Suspended...');
            $this->amodel->pagerender_login($data,'Login');
            }
            else
            {
            if($this->session->userdata('role_id')==16)
            {
                $userid=$this->session->userdata('userid');
                $casedetails= $this->cm->get_case($userid);
                redirect('Dadmin/dadminview/'.base64_encode($casedetails['request_id']));
            }
            if($this->session->userdata['organization']==102){

                redirect('Client/client_caselist');
            }
            else
            {
            if(!empty($this->session->userdata('userid'))) {
            $cur_date['last_activity']=date('Y-m-d H:i:s');
            $this->db->where('id',$this->session->userdata('userid'));
            $this->db->update( DB_PREFIX .'user', $cur_date );
            }    
            redirect('Index/dashboard');
            }
            }
            }


        else {
                if($this->login_attempt_count($userName, $countAtmpt) < $max_attempts)
                { 
                    $data['logcnt']=($max_attempts - ($countAtmpt+1));
                    $data['usrname']=$usrName;
                    $data['message']="1";
                    $this->amodel->pagerender_login($data,'Login');
                }
                else{
                    $this->session->set_userdata('message','<font color="red">Your Account has been blocked. Please reset your password clicking on Forgot your password Option.</font>');
                     redirect($this->index_login);
                }

            }
       
            } 

            else {  
            if($this->uri->segment(1)=="index")
            {
            redirect($this->index_login);
            }
            $this->amodel->pagerender_login($data,'Login'); 
            }
        }



    /*************************************
    *
    * Login Attempt Function
    *
    **************************************/
    function login_attempt_count($userName, $countAtmpt) 
    {
        
        $check_email = $this->Is_email($userName);
        if($check_email){

            $login_attempt['login_attempt'] = $countAtmpt+1;
            $this->db->where("(email = '$userName' AND status = 1)");
            $this->db->update ( DB_PREFIX .'user', $login_attempt );
        }else{

            $login_attempt['login_attempt'] = $countAtmpt+1;
            //print_r($login_attempt); exit;
            $this->db->where("(username = '$userName' AND status = 1)");
            $this->db->update ( DB_PREFIX .'user', $login_attempt );
        }
        
        

            if($check_email){
                $this -> db -> select('login_attempt') -> from(DB_PREFIX . 'user ')->where("(email = '$userName' AND status = 1)");
                $num = $this -> db -> get() -> result_array();
            }else{
                $this -> db -> select('login_attempt') -> from(DB_PREFIX . 'user ')->where("(username = '$userName' AND status = 1)");
                $num = $this -> db -> get() -> result_array();
            }
                $countAtmpt= $num[0]['login_attempt'];
                return $countAtmpt;
    
        }

        /*******************************
        * Function Captcha Validation
        *******************************/

        // function captcha_validation()
        // {
        //     $key = config_item('google_secret_key');
        //     $secret_key = $key; // change this to yours
        //     $url = 'https://www.google.com/recaptcha/api/siteverify?secret=' . $secret_key . '&response='.$_POST['captcha-response'];
        //     $response = @file_get_contents($url);

        //     $data = json_decode($response, true); 
        //     if($data['success'])
        //     {
        //         return true;
        //     }
        //     else
        //     {
        //         $this->form_validation->set_message('captcha_validation', 'Please confirm you are human');
        //         return false;
        //     }
        // }

        function validate_captcha() {
        $key = config_item('google_site_key');
        $captcha = $this->input->post('g-recaptcha-response');
         $response = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=".$key. "&response=" . $captcha . "&remoteip=" . $_SERVER['REMOTE_ADDR']);
        if ($response . 'success' == false) {
            return FALSE;
        } else {
            return TRUE;
        }
    }

        /*set roles using session*/
        function changerolesession()
        {  
            $role_id=$_POST['role_id'];
            if(!empty($role_id))
            {
            $this->db->select('role_name');
            $roles= $this->db->get_where(DB_PREFIX.'role_types',array('id'=> $role_id))->row();
            $this->session->set_userdata(array('role_id'=> $role_id,'role_name'=>$roles->role_name));
            }
            redirect('Index/dashboard');
        }
        /*User Dashboard.. Displaying Case, Check details*/
        function dashboard()
        {

  
        $this->_check_userlogin ();

        $role_id=$this->session->userdata['role_id'];
        $user_type=$this->session->userdata['user_type'];

        $organization=$this->session->userdata['organization'];
        $parent=$this->session->userdata['parent_office'];
        $bOffice=$this->session->userdata['office_id'];
                
        $data['organization']=$organization;
        $data['parent_office']=$parent;
        $data['office_id']=$bOffice;
        
        $this->db->select('r.*,t.role_name');
        $this->db->where($data);    
        $this->db->where ( 'role_id', $role_id );
        $this->db->join(DB_PREFIX ."role_types t",'role_id=t.id','left');
        $role_det = $this->db->get ( DB_PREFIX ."role_permissions r" )->result_array();
        
        $selected_ids = explode(',',$role_det[0]['menu_ids']);
        $menu_list = $this->gm->get_config_menubyparentid(0,$user_type);
       
        foreach($menu_list as $menu){
            
            if(in_array($menu['menu_id'],$selected_ids)){

                $selectedMenuId[]=$menu['menu_id'];

                if(!in_array(1,$selectedMenuId) && ($role_id==12 || $role_id==13 || $role_id==14)){

                    if($menu['menu_id']==17){
                        redirect('Client/client_caselist');
                    } 
                     
                    if($menu['menu_id']==2){
                        redirect('Management/candidate');
                    }
                }
            } 
        }

            if(!empty($_POST)){
                $data['date_search']=$post=$_POST; 
            }

        //$data['organisation_count']=$this->dmodel->organisation_cnt();
        //$data['office_count']=$this->dmodel->office_cnt();
        $userid=$this->session->userdata['userid'];
        $data['roles']=$this->dmodel->getroles($userid); 
        $role_id=$this->session->userdata['role_id'];
        // $country_clent_count=$this->dmodel->country_clent_cnt(); 
        // $data['country'] = $country_clent_count[0];
        //$data['country_count'] = $country_clent_count[1]; 
        // $data['sta'] = $country_clent_count[2];
        // $state_offices=$this->dmodel->state_ofc_cnt();
        // $data['state'] = $state_offices[0];
        // $data['state_count'] = $state_offices[1]; 
        //$data['call_count'] = $this->dmodel->calls_cnt();
        //$data['meet_count'] = $this->dmodel->meet_cnt();
        //$data['pendingcal_count'] = $this->dmodel->pendincal_cnt(); 


        if($role_id==1)
        {
            $data['vmembers'] = $this->dmodel->vmembers(); 
            // $data['qc_cases_intiated'] = $this->dmodel->cases_intiate('init',4,$userid);
            //$data['qc_cases_pending'] = $this->dmodel->cases_intiate('pending',4,$userid);
            $data['qc_cases_yet_intiated'] = $this->dmodel->cases_intiate('notinit',4,$userid);
            // $data['qc_completed_ver_cases'] = $this->dmodel->cases_intiate('completed',4,$userid);
            //$data['qc2_cases_intiated'] = $this->dmodel->cases_intiate('init',17,$userid);
            //$data['qc2_cases_pending'] = $this->dmodel->cases_intiate('pending',17,$userid);
            $data['qc2_cases_yet_intiated'] = $this->dmodel->cases_intiate('notinit',17,$userid);
            $data['scrmcheck'] = $this->dmodel->get_scrmcheckstatus($role_id,$userid); 
            //$data['qc2_completed_ver_cases'] = $this->dmodel->cases_intiate('completed',17,$userid);
            $data['U_member'] = $this->dmodel->get_members($role_id);
        }
        
        if($this->session->userdata['user_type']==2){

        /*****************Dashboard for Luxsoft ***********************/

            // if($this->session->userdata['organization']==102){

            //     redirect('Client/client_caselist');
            // }
        /*****************Dashboard for Luxsoft ***********************/

        // $data['accept_case'] = $this->dmodel->count_allcases('accept_case',$post); 
        // $data['reject_case'] = $this->dmodel->count_allcases('reject_case',$post);  

        //$data['all_case'] = $this->dmodel->count_allcases('all_case',$post);
       
            $data['all_case'] = $this->dmodel->get_count_allcasest('all_case',$post);
            $data['deactivated_users'] = $this->dmodel->get_count_allcasest('deactivated_users',$post);
            $data['not_submitted'] = $this->dmodel->get_count_allcasest('not_submitted',$post);
            $data['pending_cand'] = $this->dmodel->get_clientcaselist('pending_cand',$post);
            $data['profile_completed'] = $this->dmodel->get_clientcaselist('profile_completed',$post); 
         
            $data['submited_dcode'] = $this->dmodel->get_clientcaselist('submited_dcode',$post);
            $data['accept_case'] = $this->dmodel->get_clientcaselist('accept_case',$post); 
            $data['reject_case'] = $this->dmodel->get_clientcaselist('reject_case',$post);
            // $data['wip'] = $this->dmodel->get_clientcaselist('initiated',$post);
            $data['reopen_pending'] = $this->dmodel->get_clientcaselist('reopen_pending',$post);
            $data['req_raised_pending'] = $this->dmodel->get_req_raisedpending('req_raised_pending',$post);
            $data['req_raised_byDcode'] = $this->dmodel->get_req_raisedpending('req_raised_byDcode',$post);
            $data['req_closed_self'] = $this->dmodel->get_req_raisedpending('req_closed_self',$post);
            
            

            $data['fGreen'] = $this->dmodel->get_clientcaselist('fGreen',$post);
            $data['fOrange'] = $this->dmodel->get_clientcaselist('fOrange',$post);
            $data['fRed'] = $this->dmodel->get_clientcaselist('fRed',$post);

            $data['supGreen'] = $this->dmodel->get_clientcaselist('supGreen',$post);
            $data['supOrange'] = $this->dmodel->get_clientcaselist('supOrange',$post);
            $data['supRed'] = $this->dmodel->get_clientcaselist('supRed',$post);
       

            // $data['pending_report'] = $this->dmodel->count_allcases('pendinig_report',$post); 
            // $data['final_report'] = $this->dmodel->count_allcases('final_report',$post); 
            //$data['pending_cand'] = $this->dmodel->count_allcases('pending_cand',$post); 
            //$data['profile_completed'] = $this->dmodel->count_allcases('profile_completed',$post); 
            //$data['deactivated_users'] = $this->dmodel->count_allcases('deactivated_users',$post);
            // $data['active_users'] = $this->dmodel->count_allcases('active_users',$post);
            //$data['not_submitted'] = $this->dmodel->count_allcases('not_submitted',$post);
                /*
            $checks_reports = $this->dmodel->casestatusreport_count($type='',$post);
            $type='count';
            $cases_publish= $this->dmodel->casestatusreport_count($type,$post);
            $report_status= '' || $report_status= [];
            foreach ($cases_publish as $p) {
            $rid=$p['rid'];
            foreach($checks_reports as $rep)
            {      
            if($rid==$rep['request_id']){
            if($rep['qc2fielddata']){  
            $qc2_data=toArray(json_decode($rep['qc2fielddata'])); 
            if($qc2_data['status']){
            $pstatus[$rid][]=$this->vm->get_status($qc2_data['status']); 
            }
            if($qc2_data['status1']){
            $pstatus[$rid][]=$this->vm->get_status($qc2_data['status1']);
            }
            } 
            }
            }
            $this->rstatus= '' || $this->rstatus= [];
            foreach($pstatus[$rid] as $rp)
            {
            $this->rstatus[]=$rp['name'];
            }    
            if (in_array("Discrepant", $this->rstatus) || in_array("Possible Discrepant" , $this->rstatus) || in_array("Record Found" , $this->rstatus) || in_array("Positive" , $this->rstatus) || in_array("No Records" , $this->rstatus) || in_array("High Risk" , $this->rstatus) || in_array("Invalid" , $this->rstatus) || in_array("Not Completed" , $this->rstatus))
            { 
            $report_status[] ="RED";
            }
            else if (in_array("Stop Check" , $this->rstatus) || in_array("Others" , $this->rstatus)) {
            $report_status[] ="ORANGE";
            }
            else
            {
            $report_status[] ="GREEN";
            }
            }
            $data['casereport_status'] = $report_status; 
            */
            //$data['interimreport'] = $this->dmodel->publishreport_types($report='',$post);
            //$data['finalreport'] = $this->dmodel->publishreport_types($report="publish",$post);
            // $data['reqraised'] = $this->dmodel->insufficiency_report($request='',$post);
            // $data['reqclosed'] = $this->dmodel->insufficiency_report($request="closed",$post);


            $data['interimp_tat'] = $this->dmodel->casestatus_tat($tat ='',$post);
            $data['finalp_tat'] = $this->dmodel->casestatus_tat($tat ='finaltat',$post);
            $checkstatus_tat = $this->dmodel->checkstatus_tat($post);
            foreach ($checkstatus_tat as $ckey => $cvalue) {
            $i=1;
            $totalchecks[$cvalue['check_id']]['total'] += $cvalue['intdatediff'];
            $totalchecks[$cvalue['check_id']]['count'] +=$i;
            $totalchecks[$cvalue['check_id']]['name'] = $cvalue['checkname'];
            }
            $data['checkstatus_tat'] = $totalchecks;
           

        }

        if($role_id==5 || $role_id==10){
            /****************** VM DASHBOARD START *******************/

            $data['newcheck'] = $this->dmodel->get_vmcheck_bystatus('new',$role_id,$userid);
            $data['initiatedcheck'] = $this->dmodel->get_vmcheck_bystatus('initiated',$role_id,$userid);
            $data['RevertAssigned'] = $this->dmodel->get_vmcheck_bystatus('revertassigned',$role_id,$userid);
            $data['RevertRaised'] = $this->dmodel->get_vmcheck_bystatus('revertraised',$role_id,$userid);
            $data['RevertClosed'] = $this->dmodel->get_vmcheck_bystatus('revertclosed',$role_id,$userid);
            $data['RequestRaised'] = $this->dmodel->get_vmcheck_bystatus('requestraised',$role_id,$userid);
            $data['DDapplied'] = $this->dmodel->get_vmcheck_bystatus('DDapplied',$role_id,$userid);
            $data['ReopenAssigned'] = $this->dmodel->get_vmcheck_bystatus('reopenassigned',$role_id,$userid);
             /****************** VM DASHBOARD END *******************/
        }

        if($role_id==9){
            /****************** VS DASHBOARD START *******************/
            $data['U_member'] = $this->dmodel->get_members($role_id);
            // print_r($data['U_member']);exit;

            /****************** VS DASHBOARD END *******************/
        }

        if($role_id==4 || $role_id==17){
            $data['cases_intiated'] = $this->dmodel->cases_intiate('init',$role_id,$userid);
            $data['completed_ver_cases'] = $this->dmodel->cases_intiate('completed',$role_id,$userid);
            $data['cases_pending'] = $this->dmodel->cases_intiate('pending',$role_id,$userid);
            $data['suggested_discip'] = $this->dmodel->suggested_discrip();
        }

        if($role_id==24 || $role_id==21){
            /****************** SCRM DASHBOARD START *******************/
            $data['scrmcheck'] = $this->dmodel->get_scrmcheckstatus($role_id,$userid);
        }

        // if($role_id==9 || $role_id==11) {
        // $data['vmembers'] = $this->dmodel->vmembers(); 
        //     $data['checkwise_init'] = $this->dmodel->checkwise_count('init',$role_id,$userid);
        //     $data['checkwise_completed'] = $this->dmodel->checkwise_count('completed',$role_id,$userid);
        //     $data['checkwise_pending'] = $this->dmodel->checkwise_count('pending',$role_id,$userid);
        // }

        if($role_id==2){
             /****************** DEO DASHBOARD START *******************/
            $data['deonewcheck'] = $this->dmodel->get_deocheck_bystatus('new',$role_id,$userid);
            $data['deoRevertAssigned'] = $this->dmodel->get_deocheck_bystatus('revertassigned',$role_id,$userid);
            /****************** DEO DASHBOARD END *******************/
        }
        if($role_id==3){
            /****************** DES DASHBOARD START *******************/
            $data['desnewcheckpo'] = $this->dmodel->get_descheck_bystatus('newpo',$role_id,$userid);
            $data['desnewcheckpr'] = $this->dmodel->get_descheck_bystatus('newpr',$role_id,$userid);
            $data['desRejectclosed'] = $this->dmodel->get_descheck_bystatus('rejectclosed',$role_id,$userid);
            /****************** DES DASHBOARD END *******************/
        }
                     
            // $data['order_details'] = $this->dmodel->order_details();
            // $data['cases_yet_intiated'] = $this->dmodel->cases_intiate('notinit',$role_id,$userid);
        
        // $data['qc1_ref'] = $this->dmodel->qc1_refd();
        // $data['qc2_ref'] = $this->dmodel->qc2_refd();
        // $data['qc_com'] = $this->dmodel->qc_comd(); 

        $data['role_id'] = $role_id;
        // $office_name = $this->dmodel->officenm();
        // $data['office_name'] = $office_name[0]['office_name'];
        // $data['no_of_cases'] = $this->dmodel->no_of_cases();
        // $data['client_verified'] = $this->dmodel->client_verified_case();
        //$data['client_new_cases'] = $this->dmodel->client_new_cases();
        //$data['client_reports'] = $this->dmodel->client_report_recived();
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $data['breadcrumb']=$this->breadcrumbs->show();
        $this->amodel->pagerender($data,'Dashboard');
    }

    function get_initiated(){
        $init_arr=$this->dmodel->get_clientcaselist('initiated',$post);
        echo $init_count = ( $init_arr['cases'] ) ? $init_arr['cases']: '0';
    }

/**************** Request Raised Static *****************************/
/*
    function Req_raisedReason(){

        $userid=$this->session->userdata['userid'];
        $role_id=$this->session->userdata['role_id'];

        $currentEmpAuth = $this->dmodel->get_vmcheck_bystatus('currentEmpAuth',$role_id,$userid);
        $DDAuth = $this->dmodel->get_vmcheck_bystatus('DDAuth',$role_id,$userid);
        $NeedPin = $this->dmodel->get_vmcheck_bystatus('NeedPin',$role_id,$userid);
        $CompPermanentAddr = $this->dmodel->get_vmcheck_bystatus('CompPermanentAddr',$role_id,$userid);
        $CompCurrententAddr = $this->dmodel->get_vmcheck_bystatus('CompCurrententAddr',$role_id,$userid);
        $FatherName = $this->dmodel->get_vmcheck_bystatus('FatherName',$role_id,$userid);
        $ContactNo = $this->dmodel->get_vmcheck_bystatus('ContactNo',$role_id,$userid);
        $CompleteAddr = $this->dmodel->get_vmcheck_bystatus('CompleteAddr',$role_id,$userid);
        $NeedDOB = $this->dmodel->get_vmcheck_bystatus('TotNeedDOB',$role_id,$userid);
        $Aadhar = $this->dmodel->get_vmcheck_bystatus('Aadhar',$role_id,$userid);
        $PermanentAddWithPIN = $this->dmodel->get_vmcheck_bystatus('PermanentAddWithPIN',$role_id,$userid);
        $PAN_no = $this->dmodel->get_vmcheck_bystatus('PAN_no',$role_id,$userid);
        // $data['PAN_Card'] = $this->dmodel->get_vmcheck_bystatus('PAN_Card',$role_id,$userid);
        // $data['Passport'] = $this->dmodel->get_vmcheck_bystatus('Passport',$role_id,$userid);
        // $data['DL'] = $this->dmodel->get_vmcheck_bystatus('DL',$role_id,$userid);
        // $data['CurrentAddrWithPin'] = $this->dmodel->get_vmcheck_bystatus('CurrentAddrWithPin',$role_id,$userid);
        // $data['AppliedDD'] = $this->dmodel->get_vmcheck_bystatus('AppliedDD',$role_id,$userid);
        // $data['NeedVoterID'] = $this->dmodel->get_vmcheck_bystatus('NeedVoterID',$role_id,$userid);
        // $data['Form_16'] = $this->dmodel->get_vmcheck_bystatus('Form_16',$role_id,$userid);
        // $data['Other'] = $this->dmodel->get_vmcheck_bystatus('Other',$role_id,$userid);
        // $data['AdditionalDDAuth'] = $this->dmodel->get_vmcheck_bystatus('AdditionalDDAuth',$role_id,$userid);
        // $data['AdditionalDOC'] = $this->dmodel->get_vmcheck_bystatus('AdditionalDOC',$role_id,$userid);
        // $data['AdditionalInfo'] = $this->dmodel->get_vmcheck_bystatus('AdditionalInfo',$role_id,$userid);
        // $data['AdditionalCharge'] = $this->dmodel->get_vmcheck_bystatus('AdditionalCharge',$role_id,$userid);
        // $data['ClientNameDiscloser'] = $this->dmodel->get_vmcheck_bystatus('ClientNameDiscloser',$role_id,$userid);
        // $data['ShareOLA'] = $this->dmodel->get_vmcheck_bystatus('ShareOLA',$role_id,$userid);
        // $data['NeedClarification'] = $this->dmodel->get_vmcheck_bystatus('NeedClarification',$role_id,$userid);
;
        $html.='<thead>
                <tr class="at_tr" height="35" >
                    <th class="at_th" style="width:350px;">
                        <h2 style="color:black;">Request Raised Reason</h2>
                    </th>
                    <th class="at_th" style="width:140px;">
                   DASHBOARD     <h2 style="color:black;">No. of Checks</h2>
                    </th>
                </tr>
                </thead>
                <tbody>';
                $totalcurrentEmpAuth=count($currentEmpAuth);
                if($totalcurrentEmpAuth >0){
        $html.='<tr class="at_tr" height="35">
                    <td  class="at_td" style="width:300px;font-size:15px;padding-right: 10px;color:black;"> Current employment authorisation
                    </td>
                    <td  class="at_td" style="width:100px;font-size:14px;text-align:right;padding-right: 10px;">'.
                     anchor('/Verification/allotted_list/'.base64_encode('currentEmpAuth'),"<span style='color:black'>".$totalcurrentEmpAuth."</span>",'target=""') .'
                    
                    </td>  
                </tr>';
                }

                $totalDDAuth=count($DDAuth);
                if($totalDDAuth >0){
        $html.='<tr class="at_tr" height="35">
                    <td  class="at_td" style="width:300px;font-size:15px;padding-right: 10px;color:black;">  DD authorisation
                    </td>
                    <td  class="at_td" style="width:100px;font-size:14px;text-align:right;padding-right: 10px;">'.
                     anchor('/Verification/allotted_list/'.base64_encode('DDAuth'),"<span style='color:black'>".$totalDDAuth."</span>",'target=""') .'
                    
                    </td>  
                </tr>';
                }
                $totalNeedPin=count($NeedPin);
                if($totalNeedPin >0){
        $html.='<tr class="at_tr" height="35">
                    <td  class="at_td" style="width:300px;font-size:15px;padding-right: 10px;color:black;">  Need Pincode
                    </td>
                    <td  class="at_td" style="width:100px;font-size:14px;text-align:right;padding-right: 10px;">'.
                     anchor('/Verification/allotted_list/'.base64_encode('NeedPin'),"<span style='color:black'>".$totalNeedPin."</span>",'target=""') .'
                    
                    </td>  
                </tr>';
                }

                $TotCompPermanentAddr=count($CompPermanentAddr);
                if($TotCompPermanentAddr >0){
        $html.='<tr class="at_tr" height="35">
                    <td  class="at_td" style="width:300px;font-size:15px;padding-right: 10px;color:black;"> Need Complete Permanent Address
                    </td>
                    <td  class="at_td" style="width:100px;font-size:14px;text-align:right;padding-right: 10px;">'.
                     anchor('/Verification/allotted_list/'.base64_encode('CompPermanentAddr'),"<span style='color:black'>".$TotCompPermanentAddr."</span>",'target=""') .'
                    
                    </td>  
                </tr>';
                }
                $TotCompCurrententAddr=count($CompCurrententAddr);
                if($TotCompCurrententAddr >0){
        $html.='<tr class="at_tr" height="35">
                    <td  class="at_td" style="width:300px;font-size:15px;padding-right: 10px;color:black;"> Need Complete Current Address
                    </td>
                    <td  class="at_td" style="width:100px;font-size:14px;text-align:right;padding-right: 10px;">'.
                     anchor('/Verification/allotted_list/'.base64_encode('CompCurrententAddr'),"<span style='color:black'>".$TotCompCurrententAddr."</span>",'target=""') .'
                    
                    </td>  
                </tr>';
                }
                $TotFatherName=count($FatherName);
                if($TotFatherName >0){
        $html.='<tr class="at_tr" height="35">
                    <td  class="at_td" style="width:300px;font-size:15px;padding-right: 10px;color:black;"> Need Father Name
                    </td>
                    <td  class="at_td" style="width:100px;font-size:14px;text-align:right;padding-right: 10px;">'.
                     anchor('/Verification/allotted_list/'.base64_encode('FatherName'),"<span style='color:black'>".$TotFatherName."</span>",'target=""') .'
                    
                    </td>  
                </tr>';
                }
                $TotContactNo=count($ContactNo);
                if($TotContactNo >0){
        $html.='<tr class="at_tr" height="35">
                    <td  class="at_td" style="width:300px;font-size:15px;padding-right: 10px;color:black;"> Need Contact Number
                    </td>
                    <td  class="at_td" style="width:100px;font-size:14px;text-align:right;padding-right: 10px;">'.
                     anchor('/Verification/allotted_list/'.base64_encode('ContactNo'),"<span style='color:black'>".$TotContactNo."</span>",'target=""') .'
                    
                    </td>  
                </tr>';
                }
                $TotCompleteAddr=count($CompleteAddr);
                if($TotCompleteAddr >0){
        $html.='<tr class="at_tr" height="35">
                    <td  class="at_td" style="width:300px;font-size:15px;padding-right: 10px;color:black;"> Need Complete Address
                    </td>
                    <td  class="at_td" style="width:100px;font-size:14px;text-align:right;padding-right: 10px;">'.
                     anchor('/Verification/allotted_list/'.base64_encode('CompleteAddr'),"<span style='color:black'>".$TotCompleteAddr."</span>",'target=""') .'
                    
                    </td>  
                </tr>';
                }
                $TotNeedDOB=count($NeedDOB);
                if($TotNeedDOB >0){
        $html.='<tr class="at_tr" height="35">
                    <td  class="at_td" style="width:300px;font-size:15px;padding-right: 10px;color:black;"> Need D.O.B
                    </td>
                    <td  class="at_td" style="width:100px;font-size:14px;text-align:right;padding-right: 10px;">'.
                     anchor('/Verification/allotted_list/'.base64_encode('NeedDOB'),"<span style='color:black'>".$TotNeedDOB."</span>",'target=""') .'
                    
                    </td>  
                </tr>';
                }
                $TotAadhar=count($Aadhar);
                if($TotAadhar >0){
        $html.='<tr class="at_tr" height="35">
                    <td  class="at_td" style="width:300px;font-size:15px;padding-right: 10px;color:black;"> Need Aadhaar Card
                    </td>
                    <td  class="at_td" style="width:100px;font-size:14px;text-align:right;padding-right: 10px;">'.
                     anchor('/Verification/allotted_list/'.base64_encode('Aadhar'),"<span style='color:black'>".$TotAadhar."</span>",'target=""') .'
                    
                    </td>  
                </tr>';
                }
                $TotPermanentAddWithPIN=count($PermanentAddWithPIN);
                if($TotPermanentAddWithPIN >0){
        $html.='<tr class="at_tr" height="35">
                    <td  class="at_td" style="width:300px;font-size:15px;padding-right: 10px;color:black;"> Need Complete Permanent Address with pincode
                    </td>
                    <td  class="at_td" style="width:100px;font-size:14px;text-align:right;padding-right: 10px;">'.
                     anchor('/Verification/allotted_list/'.base64_encode('PermanentAddWithPIN'),"<span style='color:black'>".$TotPermanentAddWithPIN."</span>",'target=""') .'
                    
                    </td>  
                </tr>';
                }
                $TotPAN_no=count($PAN_no);
                if($TotPAN_no >0){
        $html.='<tr class="at_tr" height="35">
                    <td  class="at_td" style="width:300px;font-size:15px;padding-right: 10px;color:black;"> Need Pan Number
                    </td>
                    <td  class="at_td" style="width:100px;font-size:14px;text-align:right;padding-right: 10px;">'.
                     anchor('/Verification/allotted_list/'.base64_encode('PAN_no'),"<span style='color:black'>".$TotPAN_no."</span>",'target=""') .'
                    
                    </td>  
                </tr>';
                }

        $html.='</tbody>';
                
                echo $html;
               

    }
    */
/**************** Request Raised Static End *****************************/
    /* case analysis tat details */
        function caseanalysisdet()
        {
            $this->_check_userlogin ();
            $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
            $this->breadcrumbs->push('Case Analysis tat details', 'Index/caseanalysisdet');
            $data['breadcrumb']=$this->breadcrumbs->show();
            $this->amodel->pagerender($data, 'caseanalysisdet');  
        }
        function get_caseanalysislist()
        {
            $model = array(self::$dashboard_model=>'get_caseanalysislist');
            $from_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
            $to_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
            $date_filter = ($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
            $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
            $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
            $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
            $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
            $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
            $candidate_name = ($_REQUEST['candidate_name']) ? $_REQUEST['candidate_name'] : '';
            if(!empty($from_date) && $date_filter==1){
                $condition[]=" DATE_FORMAT(a.deadline_from ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."'";
            }
             if(!empty($to_date) && $date_filter==1){
                $condition[]=" DATE_FORMAT(a.deadline_from ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."'"; 
             }
             if(!empty($from_date) && $date_filter==2){
                $condition[]=" DATE_FORMAT(vl.qc2_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."' and ar.qc2_report_publish=1 ";
             }
             if(!empty($to_date) && $date_filter==2){
                $condition[]=" DATE_FORMAT(vl.qc2_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."' and ar.qc2_report_publish=1 "; 
             }
             if(!empty($from_date) && $date_filter==3){
                $condition[]=" DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."'  ";
             }
             if(!empty($to_date) && $date_filter==3){
                $condition[]=" DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."'  ";
             }
            if($org_id){
            $condition[]=" c.id = ".$org_id;
            }
            if($parent_office){
            $condition[]=" d.id = ".$parent_office;
            }
            if($office){
            $condition[]=" b.id = ".$office;
            }
            if($sub_office){
            $condition[]=" o.id = ".$sub_office; 
            }
            if($case_no){
            $condition[]=" a.case_no like '%".$case_no."'";                 
            }
            if($candidate_name){
            $condition[]=" a.candidate_name like '%".$candidate_name."%'";               
            }
            $manual_cond=implode(' and ',$condition);  
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
           if ($result[0]['request_id']) {
           $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows; 
            $total_interim=0;
            $total_final=0;
            $count1=0;
            $fcount1=0;
            $startdate='';
            $intpublishdate='';
            foreach ( $result as $i => $row ) { 
                $startdate=(date('d-m-Y',strtotime($row['startdate']))) ? date('d-m-Y',strtotime($row['startdate'])) : '';
                $intpublishdate=(date('d-m-Y',strtotime($row['intpublishdate']))) ? date('d-m-Y',strtotime($row['intpublishdate'])) : '';
                $finalpublishdate=(date('d-m-Y',strtotime($row['finalpubdate']))) ? date('d-m-Y',strtotime($row['finalpubdate'])) : '';
            if($row['final_report']==1){
                $response->rows [] ['cell'] = array ( $i+$count+1, $row['case_no'],$row['candidate_name'],$startdate,$intpublishdate,$finalpublishdate,$row['intdatediff'],$row['finaldatetat'],$row['org_name'],$row['parent_office'],$row['branch_office'],$row['sub_office']);
                $total_final += $row['finaldatetat'];
                $fcount1 = $fcount1+1;
            }
            else
            {
                $response->rows [] ['cell'] = array ( $i+$count+1,$row['case_no'],$row['candidate_name'],$startdate,$intpublishdate," ",$row['intdatediff'],"0",$row['org_name'],$row['parent_office'],$row['branch_office'],$row['sub_office']);
            }
            $total_interim += $row['intdatediff']; 
            $count1 = $count1+1;
            }
           }
          echo json_encode($response);
        }
         /* checkwise analysis tat */
    function checkanalysisdet() {
            $this->_check_userlogin ();
            $poffice=implode(",", $this->session->userdata['poffice'] );
            $boffice=implode(",", $this->session->userdata['boffice'] );
            $soffice=implode(",", $this->session->userdata['soffice'] );

            $orderdetails=$this->dmodel->get_orderdetails($poffice,$boffice,$soffice);
            foreach ($orderdetails as $ckey => $cvalue) {
            if(!empty($cvalue['chkname'])){
            $chkdetails[$cvalue['chkid']]=$cvalue['chkname'];
            }
            }
            $data['chkdetails']=$chkdetails;
            $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
            $this->breadcrumbs->push('Check Analysis tat details', 'Index/checkanalysisdet');
            $data['breadcrumb']=$this->breadcrumbs->show();
            $this->amodel->pagerender($data, 'checkanalysisdet'); 
        }
        /* checkwise analysis tat details*/
    function get_checkanalysislist()
    {
        $model = array(self::$dashboard_model=>'get_checkanalysislist');
        $from_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $to_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $chk_name = ($_REQUEST['chk_name']) ? $_REQUEST['chk_name'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $date_filter = ($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
        $candidate_name = ($_REQUEST['candidate_name']) ? $_REQUEST['candidate_name'] : '';
         if(!empty($from_date) && $date_filter==1)
         {
        $condition[]="DATE_FORMAT(a.deadline_from ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."'";
         }
         if(!empty($to_date) && $date_filter==1){
        $condition[]="DATE_FORMAT(a.deadline_from ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."'";  
         }
         if(!empty($from_date) && $date_filter==2){
        $condition[]="DATE_FORMAT(vl.qc2_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."'";
         }
         if(!empty($to_date) && $date_filter==2)
        {
        $condition[]="DATE_FORMAT(vl.qc2_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."'"; 
        }       
        if($chk_name)
        {
        $condition[]=" ar.check_id = ".$chk_name;
        }    
        if($org_id){
        $condition[]=" c.id = ".$org_id;
        }
        if($parent_office){
        $condition[]=" d.id = ".$parent_office;
        }
        if($office){
        $condition[]=" b.id = ".$office;
        }
        if($sub_office){
        $condition[]=" o.id = ".$sub_office; 
        }
        if($case_no){
        $condition[]=" a.case_no like '%".$case_no."'";    
        }
        if($candidate_name){
        $condition[]=" a.candidate_name like '%".$candidate_name."%'";    
        }
        $manual_cond=implode(' and ',$condition);  
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1];  
           if ($result) {
           $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            $total_interim=0;
            $count1=0;
            foreach ( $result as $i => $row ) {
            $startdate=(date('d-m-Y',strtotime($row['startdate']))) ? date('d-m-Y',strtotime($row['startdate'])) : '';
            $intpublishdate=(date('d-m-Y',strtotime($row['intpublishdate']))) ? date('d-m-Y',strtotime($row['intpublishdate'])) : '';
            $finalpublishdate=(date('d-m-Y',strtotime($row['intpublishdate']))) ? date('d-m-Y',strtotime($row['intpublishdate'])) : '';
            if($row['chknum']==0){
            $chknum=1;
            }
            else
            {
            $chknum=$row['chknum'];
            }
            if($this->session->userdata('userType')==1) {
            $response->rows [] ['cell'] = array ( $i+$count+1,  $row['case_no'],$row['candidate_name'],$row['checkname'].' '.$chknum,$startdate,$intpublishdate,$row['finaldatetat'],$row['org_name'],$row['parent_office'],$row['branch_office'],$row['sub_office'] );
            }
            else{
            $response->rows [] ['cell'] = array ( $i+$count+1,  $row['case_no'],$row['candidate_name'],$row['checkname'].' '.$chknum,$startdate,$intpublishdate,$row['finaldatetat'],$row['parent_office'],$row['branch_office'],$row['sub_office'] );
            }
            $count1=$count1+1;
            $total_interim += $row['finaldatetat'];
            }
           }
          echo json_encode($response);
        }
    /* listing officewise details*/    
    function officewisecases()
    {
         $this->_check_userlogin ();
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Officewise case details', 'Index/officewisecases');
        $data['breadcrumb']=$this->breadcrumbs->show();
        $data['details']=$this->dmodel->get_officewisecases();
        $this->amodel->pagerender($data, 'checkanalysisdet'); 
    }
    /* to get officewise case details*/
    function get_officewisecases()
    {
        $model = array(self::$dashboard_model=>'get_officewisecases');
        $from_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $to_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        if($from_date)
        {
        $condition[]="DATE_FORMAT(a.deadline_from ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."'";
        }
        if($to_date){
        $condition[]="DATE_FORMAT(a.deadline_from ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."'";  
        }
        $manual_cond=implode(' and ',$condition);  
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
           if ($result) {
           $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows; 
            $office='';
            $count1=0;
            foreach ( $result as $i => $row ) {
           if(!empty($row['branch_office']) && !empty($row['sub_office']))
           {
                $office=$row['sub_office'];
           }
           elseif (!empty($row['branch_office']) && empty($row['sub_office'])) 
           {
                  $office=$row['branch_office'];    
            }   
           else{
                $office=$row['parent_office'];
           }
           if($row['user_type']==1){
            $hr_name='Offline Entry';
           }
           else
           {
            $hr_name=$row['hr_name'];
           }         
                $response->rows [] ['cell'] = array ( $i+$count+1,  $office,$hr_name,$row['accepted_cases'],$row['accepted_cases'],$row['accepted_cases']-$row['interim_report'],$row['interim_report']-$row['final_report'],$row['final_report'],' ' );
            }
           }
          echo json_encode($response);
    }
    function export_officecases($from_date='',$to_date='')
    {
        $model = array(self::$dashboard_model=>'get_officewisecases');
           $from_date=$_POST['c_date'];
            $to_date=$_POST['t_date'];
        if($from_date){
        $condition[]="DATE_FORMAT(a.deadline_from ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."'";
        }
        if($to_date){
        $condition[]="DATE_FORMAT(a.deadline_from ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."'";  
        }
        $manual_cond=implode(' and ',$condition);  
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
           if ($result) {
           $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            $office='';
            $accept=0; $wipcount=0; $interimcount=0; $finalcount=0;
             $out='<table><thead><th>SlNo</th><th>Office Name</th>
                        <th >HR Details</th><th>Accepted Cases</th><th>Work in Progress</th><th>Interim</th><th>Final</th></thead>';
                     $out .='<tbody>';   
            foreach ( $result as $i => $row ) {
           if(!empty($row['branch_office']) && !empty($row['sub_office']))
           {
                $office=$row['sub_office'];
           }
           elseif (!empty($row['branch_office']) && empty($row['sub_office'])) 
           {
                  $office=$row['branch_office'];    
            }   
           else{
                $office=$row['parent_office'];
           } 
           if($row['user_type']==1){
            $hr_name='Offline Entry';
           }
           else
           {
            $hr_name=$row['hr_name'];
           }           
                $interim=$row['interim_report']-$row['final_report'];
                $wip=$row['accepted_cases']-$row['interim_report'];
                $out .='<tr><td>'.($i+$count+1).'</td><td >'.$office.'</td><td>'.$hr_name.'</td><td style="width: 15cm;">' .$row['accepted_cases']. '</td><td>'.$wip.'</td><td>'.$interim.'</td><td>'.$row['final_report'].'<td>';
               $accept += $row['accepted_cases'];
               $wipcount +=  $wip;
               $interimcount += $interim;
               $finalcount += $row['final_report']; 
            }
            $out .='<tr><td>Total</td><td ></td><td></td><td ">' .$accept. '</td><td>'.$wipcount.'</td><td>'.$interimcount.'</td><td>'.$finalcount.'<td></tr>';
        }
               $out .='</tbody><table>'; 
                $filename="Officewise_Case_Details_On_".date('d-m-Y H:i:s').".xls";
                header("Content-Type:   application/vnd.ms-excel; charset=utf-8");
                header("Content-Disposition: attachment; filename=\"$filename\"");  //File name extension was wrong
                header("Expires: 0");
                header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
                header("Cache-Control: private",false);
                echo $out;
   } 
   /* export of casewise analysis tats*/
   function export_caseanalysis(){
        $model = array(self::$dashboard_model=>'get_caseanalysislist');
        $from_date=$_POST['c_date'];
        $to_date=$_POST['t_date'];
        $date_filter = ($_POST['exp_date_filter']) ? $_POST['exp_date_filter'] : '';
        $org_id = ($_REQUEST['exp_org_id']) ? $_REQUEST['exp_org_id'] : '';
        $parent_office = ($_REQUEST['exp_parent_office']) ? $_REQUEST['exp_parent_office'] : '';
        $office = ($_REQUEST['exp_office']) ? $_REQUEST['exp_office'] : '';
        $sub_office = ($_REQUEST['exp_sub_office']) ? $_REQUEST['exp_sub_office'] : '';
        $case_no = ($_REQUEST['exp_case_no']) ? $_REQUEST['exp_case_no'] : '';
        $candidate_name = ($_REQUEST['exp_candidate_name']) ? $_REQUEST['exp_candidate_name'] : '';
        if(!empty($from_date) && $date_filter==1){
        $condition[]=" DATE_FORMAT(a.deadline_from ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."'";
        }
        if(!empty($to_date) && $date_filter==1){
        $condition[]=" DATE_FORMAT(a.deadline_from ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."'"; 
        }
        if(!empty($from_date) && $date_filter==2){
        $condition[]=" DATE_FORMAT(vl.qc2_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."' and ar.qc2_report_publish=1 ";
        }
        if(!empty($to_date) && $date_filter==2){
        $condition[]=" DATE_FORMAT(vl.qc2_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."' and ar.qc2_report_publish=1 "; 
        }
        if(!empty($from_date) && $date_filter==3){
        $condition[]=" DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."'  ";
        }
        if(!empty($to_date) && $date_filter==3){
        $condition[]=" DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."' ";     
        }
        if($org_id){
        $condition[]=" c.id = ".$org_id;
        }
        if($parent_office){
        $condition[]=" d.id = ".$parent_office;
        }
        if($office){
        $condition[]=" b.id = ".$office;
        }
        if($sub_office){
        $condition[]=" o.id = ".$sub_office; 
        }
        if($case_no){
        $condition[]=" a.case_no like '%".$case_no."'";      
        }
        if($candidate_name){
        $condition[]=" a.candidate_name like '%".$candidate_name."%'";      
        }
        $manual_cond=implode(' and ',$condition);  

        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
           if ($result[0]['request_id']) {
           $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows; 
            $total_interim=0;
            $total_final=0;
            $count1=0;
            $fcount1=0;
            $finaltats=0;
            if($this->session->userdata('user_type')==1){
                $out='<table><thead><th>SlNo</th><th>Case Number</th><th>Candidate Name</th><th><p>Case Accepted Date</p></th><th>Published Date - Interim</th><th>Published Date - Final</th><th>Interim - TAT</th><th>Final - TAT</th><th>Organization</th><th>Head Office</th><th>Branch Office</th><th>Sub Office</th></thead>';
            }
            else{
                $out='<table><thead><th>SlNo</th><th>Case Number</th><th>Candidate Name</th><th><p>Case Accepted Date</p></th><th>Published Date - Interim</th><th>Published Date - Final</th><th>Interim - TAT</th><th>Final - TAT</th></thead>';
            }
            $out .='<tbody>';  
            foreach ( $result as $i => $row ) { 
                $startdate=(date('d-m-Y',strtotime($row['startdate']))) ? date('d-m-Y',strtotime($row['startdate'])) : '';
                $intpublishdate=(date('d-m-Y',strtotime($row['intpublishdate']))) ? date('d-m-Y',strtotime($row['intpublishdate'])) : '';
                $finalpublishdate=(date('d-m-Y',strtotime($row['finalpubdate']))) ? date('d-m-Y',strtotime($row['finalpubdate'])) : '';
            if($row['final_report']==1){
                $finaltats = $row['finaldatetat'];
                $total_final += $row['finaldatetat'];
                $fcount1 = $fcount1+1;
            }
            else
            {
                $finaltats=0;
                $finalpublishdate='';
            }
             if($this->session->userdata('user_type')==1){
            $out .='<tr><td>'.($i+$count+1).'</td><td >'.$row['case_no'].'</td><td >'.$row['candidate_name'].'</td><td>'.$startdate.'</td><td style="width: 15cm;">' .$intpublishdate. '</td><td>'.$finalpublishdate.'</td><td>'.$row['intdatediff'].'</td><td>'.$finaltats.'</td><td>'.$row['org_name'].'</td><td>'.$row['parent_office'].'</td><td>'.$row['branch_office'].'</td><td>'.$row['sub_office'].'</td></tr>';
            }
            else
          {
            $out .='<tr><td>'.($i+$count+1).'</td><td >'.$row['case_no'].'</td><td >'.$row['candidate_name'].'</td><td>'.$startdate.'</td><td style="width: 15cm;">' .$intpublishdate. '</td><td>'.$finalpublishdate.'</td><td>'.$row['intdatediff'].'</td><td>'.$finaltats.'</td></tr>';
          }  
            $total_interim += $row['intdatediff']; 
            $count1 = $count1+1;
            }
             $out .='<tr><td>Total</td><td ></td><td ></td><td></td><td></td><td></td><td>'.$total_interim.'</td><td>'.$total_final.'<td></tr>
             <tr><td>Average</td><td ></td><td ></td><td></td><td></td><td></td><td>'.round($total_interim/$count1,2).'</td><td>'.round($total_final/$fcount1,2).'<td></tr>';
           $out .='</tbody><table>'; 
           }
        $filename="Casewise_analysis_tat_details".date('d-m-Y H:i:s').".xls";
        header("Content-Type:   application/vnd.ms-excel;  charset=utf-8");
        header("Content-Disposition: attachment; filename=\"$filename\"");  
        header("Expires: 0");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("Cache-Control: private",false);
        echo $out;
   }
    /* export of casewise analysis tats*/
   function export_checkanalysis(){
    $model = array(self::$dashboard_model=>'export_checkanalysislist');
    $from_date=$_POST['c_date'];
    $to_date=$_POST['t_date'];
    $chk_name=$_POST['chk_name'];   
    $org_id = ($_POST['exp_org_id']) ? $_POST['exp_org_id'] : '';
    $parent_office = ($_POST['exp_parent_office']) ? $_POST['exp_parent_office'] : '';
    $office = ($_POST['exp_office']) ? $_POST['exp_office'] : '';
    $sub_office = ($_POST['exp_sub_office']) ? $_POST['exp_sub_office'] : '';
    $case_no = ($_POST['exp_case_no']) ? $_POST['exp_case_no'] : '';
    $date_filter = ($_POST['exp_date_filter']) ? $_POST['exp_date_filter'] : '';
    $candidate_name = ($_REQUEST['exp_candidate_name']) ? $_REQUEST['exp_candidate_name'] : '';
       if(!empty($from_date) && $date_filter==1){
    $condition[]="DATE_FORMAT(a.deadline_from ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."'";
       }
     if(!empty($to_date) && $date_filter==1){
    $condition[]="DATE_FORMAT(a.deadline_from ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."'";  
     }
     if(!empty($from_date) && $date_filter==2){
    $condition[]="DATE_FORMAT(vl.qc2_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."'";
     }
     if(!empty($to_date) && $date_filter==2){
    $condition[]="DATE_FORMAT(vl.qc2_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."'";
     }
     if($chk_name)
     {
        $condition[]=" ar.check_id = ".$chk_name; 
     }
    if($org_id)
    {
    $condition[]=" c.id = ".$org_id;
    }
    if($parent_office){
    $condition[]=" d.id = ".$parent_office;
    }
    if($office){
    $condition[]=" b.id = ".$office;
    }
    if($sub_office){
    $condition[]=" o.id = ".$sub_office; 
    }
    if($case_no){
    $condition[]=" a.case_no like '%".$case_no."'";  
    }
    if($candidate_name){
    $condition[]=" a.candidate_name like '%".$candidate_name."%'";  
    }
    $manual_cond=implode(' and ',$condition);  
    $results = $this->_jqgrid_search($model,$manual_cond); 
    $response = $results[0];  
    $result = $results[1]; 
       if ($result) {
       $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows; 
        $total_interim=0;
        $total_final=0;
        $count1=0;
        $fcount1=0;
        $finaltats=0;
            if($this->session->userdata('userType')==1){
           $out='<table><thead><th>SlNo</th><th>Case Number</th><th>Candidate Name</th><th>Check Name</th><th><p>Case Accepted Date</p></th><th>Published check wise date</th><th>TAT days</th><th>Organization</th><th>Head Office</th><th>Branch Office</th><th>Sub Office</th></thead>';
            }
            else{
                 $out='<table><thead><th>SlNo</th><th>Case Number</th><th>Candidate Name</th><th>Check Name</th><th><p>Case Accepted Date</p></th><th>Published check wise date</th><th>TAT days</th><th>Head Office</th><th>Branch Office</th><th>Sub Office</th></thead>';
            }
                     $out .='<tbody>';  
            foreach ( $result as $i => $row ) { 
                $startdate=(date('d-m-Y',strtotime($row['startdate']))) ? date('d-m-Y',strtotime($row['startdate'])) : '';
                $intpublishdate=(date('d-m-Y',strtotime($row['intpublishdate']))) ? date('d-m-Y',strtotime($row['intpublishdate'])) : '';
                $finalpublishdate=(date('d-m-Y',strtotime($row['finalpubdate']))) ? date('d-m-Y',strtotime($row['finalpubdate'])) : '';
               if($row['chknum']==0){
                $chknum=1;
               }
               else
               {
                $chknum=$row['chknum'];
               }
            if($this->session->userdata('userType')==1){
            $out .='<tr><td>'.($i+$count+1).'</td><td >'.$row['case_no'].'</td><td >'.$row['candidate_name'].'</td><td >'.$row['checkname'].' '.$chknum.'</td><td>'.$startdate.'</td><td >' .$intpublishdate. '</td><td>'.$row['finaldatetat'].'</td><td>'.$row['org_name'].'</td><td>'.$row['parent_office'].'</td><td>'.$row['branch_office'].'</td><td>'.$row['sub_office'].'</td>';
            $count1=$count1+1;
                $total_interim += $row['finaldatetat'];
                }
                else{
                    $out .='<tr><td>'.($i+$count+1).'</td><td >'.$row['case_no'].'</td><td >'.$row['candidate_name'].'</td><td >'.$row['checkname'].' '.$chknum.'</td><td>'.$startdate.'</td><td >' .$intpublishdate. '</td><td>'.$row['finaldatetat'].'</td><td>'.$row['parent_office'].'</td><td>'.$row['branch_office'].'</td><td>'.$row['sub_office'].'</td>';
            $count1=$count1+1;
                $total_interim += $row['finaldatetat'];
                }
            }
             $out .='<tr><td>Total</td><td></td><td></td><td></td><td></td><td></td><td>'.$total_interim.'</td><td></td><td></td><td></td></tr>
             <tr><td>Average</td><td ></td><td></td><td></td><td></td><td></td><td>'.round($total_interim/$count1,2).'</td><td></td><td></td><td></td></tr>';
           }
           $out .='</tbody><table>'; 
                $filename="Checkwise_analysis_tat_details".date('d-m-Y H:i:s').".xls";
                header("Content-Type:   application/vnd.ms-excel; charset=utf-8");
                header("Content-Disposition: attachment; filename=\"$filename\"");  
                header("Expires: 0");
                header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
                header("Cache-Control: private",false);
                echo $out;
   }
    /*order details for des*/
        function orderdetails($order) {
        $checks = $data['check_details'] = $this->dmodel->check_details($order);
        return $checks;
        }
    /*user can Chage password*/
    function changepassword() {
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('New Password', 'Index/changepassword');
        $data['breadcrumb']=$this->breadcrumbs->show();

        $this->_check_userlogin ();
        $this->amodel->pagerender($data, 'changepassword');     
        }

        function resetpassword() {
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('New Password', 'Index/changepassword');
        $data['breadcrumb']=$this->breadcrumbs->show();
        $uri=explode('@', $this->uri->segment(3));  
        $cand_user_id=base64_decode($uri[0]);
        $ctoken=base64_decode($uri[1]);
        $user_details = $this->amodel->getDetails(DB_PREFIX . "user", array('*'), array('id' => $cand_user_id,'password'=>md5($ctoken)));
        
        if(empty($user_details)){
            redirect ( $this->index_login, 'refresh' );
        }
        else{
            $this->session->set_userdata('token', $this->uri->segment(3));
        }
      
        $this->template->write_view('content','Index/resetpassword'  , TRUE);
        $this->template->write_view('footer', 'footer', TRUE);
        return $this->template->render();
       // $this->load->view('Index/resetpassword',$data);  
        } 


        function save_resetpasswd(){  
         //echo "<pre>";
        //print_r($_POST);exit();
         $formData=$this->security->xss_clean($_POST);
        // if(trim($_POST['user_code']) != trim(md5(date('y-m-d').$_POST['captcha']))) { 
        //         $this->session->set_flashdata('error','Invalid captcha');
        //         redirect ( base_url("Index/resetpassword/").$this->session->userdata("token"), 'refresh' ); 
        //         exit;
        //        }
       
        $this->form_validation->set_rules('new_password', 'New Password','trim|required|min_length[6]|max_length[30]');
        $this->form_validation->set_rules('retype_password', 'Password Confirmation','trim|required|min_length[6]|max_length[30]'); 
        $this->form_validation->set_rules('g-recaptcha-response', 'recaptcha validation', 'required|callback_validate_captcha');
      $this->form_validation->set_message('validate_captcha', 'Please check the the captcha form');

        if ($this->form_validation->run() == FALSE) {
      $this->session->set_flashdata('error', validation_errors());
      redirect ( base_url("Index/resetpassword/").$this->session->userdata("token"), 'refresh' ); 
      exit;
      } 
      else if($formData['new_password'] != $formData['retype_password']){
        $this->session->set_flashdata('error', "The new password is not matches with confirm password.");
      redirect ( base_url("Index/resetpassword/").$this->session->userdata("token"), 'refresh' ); 
      exit;
      } 
      $user=explode('@',$this->session->userdata("token")); //print_r(md5($formData['new_password']));exit;
      $this->db->update(DB_PREFIX . "user", array('password' => md5($formData['new_password']),'login_attempt'=>0), array('id' => base64_decode($user[0])));
        session_destroy();
        redirect($this->index_login);
    }

        /*List user paswwords that admin can change */
    function changepasswords()
    {
        $data['user_list'] = $this->dmodel->list_of_dusers();
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('New Password', 'Index/changepasswords');
        $data['breadcrumb']=$this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'changepasswords');
    }
        /*Callback function for check the passwords*/
    function checkpassword()       {
    $password=$this->session->userdata['password'];
    $old_pass = md5($_POST['old_password']); 
    $new_pass = md5($_POST['new_password']);
    $retype_pass = md5($_POST['retype_password']);
    if(md5($_POST['old_password']) != $this->session->userdata['password']) {
        echo "<script>alert('Password does not match with existing');</script>"; 
             redirect ( base_url('Index/changepassword'), 'refresh' );   
             exit;
    }

    $this->dmodel->passwordupdate($new_pass);
    $cmpny_name=$this->dmodel->company_name($this->session->userdata('email'));
    $exist=$this->dmodel->ckeck_emails($this->session->userdata('email'));
    if($exist->role_id==16){
    $data['username']=$exist->email;
    $data['company_name']=$cmpny_name->org_name;
    $data['new_password']=$_POST['new_password'];
    $data['first_name']=$exist->first_name;
    }else{
    $data['new_password']=$_POST['new_password'];
    $data['first_name']=$exist->first_name;
    $data['username']=$exist->email;
    $data['company_name']='Dcode Research';
    }
    $this->send_change_password_email_common('change_mypassword','Password Change', @$exist->email, $data);
    $this->session->set_userdata('message','New password has been sent to '.@$exist->email.' mail ID');
    if(!isset($_SESSION['username']) && !isset($_SESSION['password'])){
    redirect($this->index_login);
    exit;
    }
    else{
    session_destroy();
    redirect($this->index_login);
    }
    }
        /*admin can change user password*/
    function checkpasswords()
    {
        $data['user_id'] = $this->uri->segment(3);      
        $this->amodel->pagerender($data, 'checkpasswords');
    }
    /* Update new password */
    function changeduserpass()
    {   
        $user_id=base64_decode($this->uri->segment(3));
        $new_passw = md5($_POST['new_password']);
        $retype_pass = md5($_POST['retype_password']);
        $this->dmodel->dpasswordupdate($_POST['new_password'],$user_id);
        $query1=$this->db->query("SELECT a.id,a.email,concat_ws(' ',a.first_name,a.middle_name,last_name) as name,a.username FROM ". DB_PREFIX ."user a where a.id='". $user_id . "'");
        $result = $query1->row();
        $data['new_password']=$_POST['new_password'];
        $data['username']=$result->email;
        $data['email']=$result->email;
        $this->send_email_changepasswordcommon('change_password','New Login Password', @$result->email, $data);
        redirect(('Index/changepasswords'));
    }
        /*forget passowrd*/
    function password_recovery() {
        $this->amodel->pagerender_login($data,'Password Recovery');
        if(isset($_POST['user_mail'])) {
        $email=$_POST['user_mail'];
        $exist=$this->dmodel->ckeck_emails($email);
        if($exist)  {
        $length=6;
        $new_password = $this->randomString($length);
        $cmpny_name=$this->dmodel->company_name($this->session->userdata('email'));
        $this->dmodel->passupdate($exist->id,$new_password); 
        if($exist->role_id==16){
        $data['username']=$exist->email;
        $data['company_name']=$cmpny_name->org_name;
        $data['new_password']=$new_password;
        $data['first_name']=$exist->first_name;
        $data['cand_user_id']=base64_encode($exist->id);
        }else{
        $data['new_password']=$new_password;
        $data['first_name']=$exist->first_name;
        $data['username']=$exist->email;
        $data['company_name']='Dcode Research';
        $data['cand_user_id']=base64_encode($exist->id);
        } 
        $this->send_email_changepasswordcommon('change_password','New Login Password', @$exist->email, $data);
        $this->session->set_userdata('message','New password has been sent to'.@$exist->email.' this mail ID');
        redirect($this->index_login);
        }
        }
        }
        /*Callback Function for Checking user email*/
    function check_email()    { 
        $email=$_POST['emails'];
        $exist=$this->dmodel->ckeck_emails($email);

        if($exist)  
        echo true;
        else 
        echo 'false';
        }
        /*Callback Function for Checking user old password*/
    function check_old($pwd='')
        {
            $old_password=md5(base64_decode($this->uri->segment(3)));
            $password=$this->session->userdata['password'];
            if($old_password==$password)
            echo "1"; 
            else
            echo '0';
        }   
        //logout     
    function logout()
       {
        $secure_cookie = (bool) config_item('cookie_secure');
        setcookie('csrf_cookie_name',$this->security->get_csrf_hash(),01,config_item('cookie_path'),config_item('cookie_domain'),
        $secure_cookie,config_item('cookie_httponly'));
        if(!isset($_SESSION['username']) && !isset($_SESSION['password'])){
       redirect($this->index_login);
        exit;
        }
        else{
        session_destroy();
        }
        }
    function logged_inas($ids){ 
        $uid=base64_decode($this->uri->segment(3));
        $userdata=$this->dmodel->checkuserlogin($uid);
         if($this->session->userdata('role_id')==1){
            $temp_user_id=$this->session->userdata('userid');
         } 
       if($userdata != NULL)    {
        if(!empty($userdata[0]->roles)) {
            $role=explode(',', $userdata[0]->roles);
            $roles=$role[0];
            $role_name=$userdata[0]->role_name;
        }
        else
        {
            $roles=$userdata[0]->role_id;
            $role_name=$userdata[0]->user_rolename;
        }
            $user = array('userid' => $userdata[0]->id,            
            'name'=> $userdata[0]->name,
            'parentoffice_id'=> $userdata[0]->parentoffice_id,
            'org_name'=> $userdata[0]->org_name,
            'organization'=> $userdata[0]->organization,
            'parent_office'=> $userdata[0]->parent_office,
            'parent_office_name'=> $userdata[0]->parent_office_name,
            'office_name'=> $userdata[0]->office_name,
            'email'=> $userdata[0]->email,
            'status'=> $userdata[0]->status,
            'office_id'=> $userdata[0]->office_id,
            'sub_office'=> $userdata[0]->sub_office,
            'user_type'=> $userdata[0]->user_type,
            'role_id' => $roles,
            'role_name'=> $role_name,
            'username'=> $userdata[0]->username,
            'designation'=> $userdata[0]->designation,
            'logo'=> $userdata[0]->logo,
            'user_image'=> $userdata[0]->original,
            'userType'=>$userdata[0]->user_type,
            'password'=>$userdata[0]->password,
            'prefix' => 'dcode_',
            'roles' => explode(',', $userdata[0]->roles),
            'poffice'=> explode(',', $userdata[0]->poffice),
            'boffice'=> explode(',', $userdata[0]->boffice),
            'soffice'=> explode(',', $userdata[0]->soffice),
            'currency' => 'INR',
            'is_logged_in' => TRUE,
            'temp_user_id'=>$temp_user_id); 
                $this->session->set_userdata($user);
               redirect('Index/dashboard');
        }
     }  


    function get_vmember(){
        
        $role_id=$_POST['role_id'];
        $status=$_POST['status'];

        $select = " distinct(us.id) as userID, concat_ws(' ',us.first_name,us.middle_name,us.last_name) as vname";
        $from = "  from ".DB_PREFIX ."ver_assign_rep a
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id =a.candidate_req_id
        LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id
        JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3 ";
        
        if( $role_id==9 || $role_id==1) {
             $from .= " WHERE 1=1 and us.status=".$status;
        }   
        
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        $U_member= $query->result_array();

            $html='<option value="">Select Member</option>';
            foreach($U_member as $members) {
                $html.="<option name='vmember' value=".$members['userID'].">".$members['vname']."
            </option>";
            }
            echo $html; 

    }

    function get_vmembers(){
        
        $role_id=$_POST['role_id'];
        $status=$_POST['status'];

        $select = " distinct(us.id) as userID, concat_ws(' ',us.first_name,us.middle_name,us.last_name) as vname";
        $from = "  from ".DB_PREFIX ."ver_assign_rep a
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id =a.candidate_req_id
        LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id
        JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3 ";
        
        if( $role_id==9 || $role_id==1) {
             $from .= " WHERE 1=1 and us.status=".$status." ORDER BY us.first_name";
        }   
        
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        $U_member= $query->result_array();

            $html='<option value="">Select Verifier</option>';
            foreach($U_member as $members) {
                $html.="<option name='vmember' value=".$members['userID'].">".$members['vname']."
            </option>";
            }
            echo $html; 

    }





}
