<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Controller for CodeIgniter frontend language files editor.
 *
 * Idea:
 * Keys stored in database only as an information and simple way to communicate between files.
 * Edit translation for existing keys, Add new keys, Same keys for every language.
 *
 * Tested for CodeIgniter 2.x
 * @author      Eliza Witkowska (http://codebusters.pl/en/)
 * @version     2.1
 * @license     MIT License
 * @link    http://blog.codebusters.pl/en/entry/codeigniter-frontend-language-files-editor/
 * @link https://github.com/kokers/Codeigniter-Frontend-Language-Files-Editor
 */
require_once ('Common.php');
class Language extends Common {
    function __construct() 
    {
        parent::__construct();
        $this->load->helper(array('url', 'file', 'language', 'form')); //load this helpers if youre not doing it in autoload
        $this->load->model(array('model_language'));
        $this->load->model(array('Adm_model', 'amodel'));
        $this->load->library(array('session')); //load session if youre not doing it in autoload
        $this->load->database(); //load database if youre not doing it in autoload
        $this->load->language('language', 'english'); //you can delete it if you have translation for you language
        $this->config->load('language_editor');
        $this->amodel->loadjsscriont(array('jquery-latest.min'));
    }
    function index() {
        $this->load->view('header');
        $this->lang_list();
        $this->load->view('footer');
    }
    /**
     * Get language list based on directories or files in it.
     *
     * @return void
     */
    function lang_list($dir = FALSE) {
        $this->load->helper('form');
        $data['message'] = $this->session->flashdata('message');
        $data['page_title'] = lang('manage_language_files');
        //        // add breadcrumbs
       if ($dir === FALSE) {
            $data['dir'] = $this->model_language->get_languages();
            $this->load->view('/language/dir_list', $data);
        } else {
            $data['sel_dir'] = $dir;
            $data['dir'] = $this->model_language->get_languages();
            $data['files'] = $this->model_language->get_list_lfiles($dir);
            $this->load->view('/language/file_list', $data);
        }
    }
    /**
     * Get list of keys and translations from file.
     * Check if all keys from file are in database and show new keys available for translate.
     * If there is new keys file must should be saved - until then they are not existing in file.
     *
     * @return void
     */
    function lang_file($l = FALSE, $file = FALSE) {
        $this->load->helper('form');
        // add breadcrumbs
        if ($l !== FALSE && $file !== FALSE && is_dir(APPPATH . "language/$l/") && file_exists(APPPATH . "language/$l/$file")) {
            require (APPPATH . "language/$l/$file");
            $data = array('lang' => $lang, 'language' => $l, 'file' => $file);
            $data['message'] = $this->session->flashdata('message');
            $data['page_title'] = lang('manage_language_files');
            $data['keys'] = $lang; /// get keys for this file
            if ($this->config->item('comments') == 1) {
                $data['comments'] = $this->model_language->get_comments_from_db($file);
            }
            if ($data['keys'] !== FALSE) {
                $data['extra_keys'] = array_diff(array_keys($lang), $data['keys']); ///get keys that are in file but not in database
                
            }
            $data['dir'] = $this->model_language->get_languages();
            if ($this->config->item('language_pattern') == 1 && $l != $this->config->item('language_pattern_lang') && file_exists(APPPATH . "language/{$this->config->item('language_pattern_lang') }/$file")) {
                require (APPPATH . "language/{$this->config->item('language_pattern_lang') }/$file");
                $data['pattern'] = $lang;
            }
            $this->load->view('/language/edit_lang_file', $data);
        } else {
            $this->session->set_flashdata('error', $this->lang->line('language_error_dir_not_exist'));
            redirect('/language');
        }
    }
    /**
     * Update language file.
     * If new keys were added, add them to database so they could be available for another language
     *
     * @return void
     */
    function save_language_file() {
        if ($this->input->post('change')) { //check if form was submitted
            $l = $this->prepare_str($this->input->post('language'));
            $file = $this->input->post('filename');
            if (!empty($l) && !empty($file) && is_dir(APPPATH . "language/$l/") && file_exists(APPPATH . "language/$l/$file")) {
                $f = '<?php  ' . "\n\n"; /// begin file with standard line
                $keys = $this->model_language->get_keys_from_db($file);
                if (empty($keys) || !is_array($keys)) {
                    $keys = FALSE;
                }
                $langinertData = $this->amodel->unsetarray(array('filename', 'language', 'change'));
                foreach ($langinertData as $key => $value) { /// create new array_diff
                    $langkey = "'" . $key . "'";
                    $f.= '$lang[' . $langkey . '] = "' . $value . '";' . "\n";
                }
                $f.= '/* End of file ' . $file . ' */'; ///closing tags
                file_put_contents(APPPATH . "language/$l/$file", $f, LOCK_EX); ///save language fi
                ;
                redirect('' . base_url("/language/lang_file/$l/$file"));
            } else {
                $this->session->set_flashdata('error', $this->lang->line('language_error_dir_not_exist'));
                redirect('/language');
            }
        } else {
            $this->session->set_flashdata('error', $this->lang->line('language_error_no_direct_access'));
            redirect('/language');
        }
    }
    /**
     * Prepare string by removing unwanted signs
     *
     * @param string
     * @return string0tring
     */
    function prepare_str($string) {
        $from = array('ą', 'ć', 'ę', 'ł', 'ó', 'ń', 'ś', 'ż', 'ź', ' '); ///polish signs
        $to = array('a', 'c', 'e', 'l', 'o', 'n', 's', 'z', 'z', '_'); ///signs to replace
        $out = preg_replace('/[^a-zA-Z0-9-_]*/', '', str_ireplace($from, $to, strtolower($string))); ///prepare, remove spaces, replace
        return strtolower($out);
    }
}