<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once('Common.php');
require_once('./PHPExcel-1.8/Classes/PHPExcel.php');
class Management extends Common
{

    protected $request_orgid = 'org_id';
    protected $request_office = 'office';
    protected $request_parent_office = 'parent_office';
    protected $request_sub_office = 'sub_office';

    function __construct()
    {
        parent::__construct();
        $this->_check_userlogin();
        $models = array('Management_model' => 'mm', 'Verification_model' => 'vm', 'Reports_model' => 'rm', 'Client_model' => 'cm', 'Dadmin_model' => 'dm', 'Delete_request_model' => 'drm');
        foreach ($models as $file => $object_name) {
            $this->load->model($file, $object_name);
        }
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'jquery-ui-1.10.4', 'highcharts', 'exporting', 'jquery.validate', 'grid.locale-en', 'jquery.jqGrid.min', 'jquery-ui-1.8.16.custom.min', 'autocomplete', 'multipleclone', 'commonjs', 'jquery.datepick'));
        $this->load->helper('text');
        $this->load->helper('cloneform');
        $this->load->library('pdfexport');
        $this->load->helper('file');
        $this->load->helper('url');
        $this->load->library('zip');
        ini_set('memory_limit', '-1');
    }
    //****** Listing of Users view page *******/
    function users()
    {
        $this->_check_featureauth('users', 'search');
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Users', 'Management/users');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'user');
    }
    //****** Listing of Users *******/
    function get_users()
    {

        $this->_check_featureauth('users', 'search');
        $model = array('Management_model' => 'get_userlist');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $uname = ($_REQUEST['uname']) ? $_REQUEST['uname'] : '';
        $role = ($_REQUEST['role']) ? $_REQUEST['role'] : '';
        $organization = ($_REQUEST['organization']) ? $_REQUEST['organization'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $user_type = ($_REQUEST['user_type']) ? $_REQUEST['user_type'] : '';
        $created_on = ($_REQUEST['created_on']) ? $_REQUEST['created_on'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $f_date = ($_REQUEST['f_date']) ? $_REQUEST['f_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $date_filter = ($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
        $status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        if ($office) {
            $condition[] = " bo.branch_office = " . $office;
        }
        if ($organization) {
            $condition[] = " a.organization = " . $organization;
        }
        if ($parent_office) {
            $condition[] = " ho.parent_office = " . $parent_office;
        }
        if ($name) {
            $condition[] = " ( a.first_name like '%" . $name . "%' OR  a.last_name like '%" . $name . "%') ";
        }

        if ($uname) {
            $condition[] = " a.username like '%" . $uname . "%'";
        }

        if ($role) {
            $condition[] = " e.role_name like '%" . $role . "%'";
        }
        if ($user_type) {
            $condition[] = " e.user_type = " . $user_type;
        }
        if ($f_date && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(a.created_on ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($f_date)) . "'";
        }
        if ($t_date && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(a.created_on ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }
        if ($f_date && $date_filter == 2) {
            $condition[] = "DATE_FORMAT(a.last_activity ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($f_date)) . "'";
        }
        if ($t_date && $date_filter == 2) {
            $condition[] = "DATE_FORMAT(a.last_activity ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }
        if ($sub_office) {
            $condition[] = " so.sub_office = " . $sub_office;
        }
        if ($status == 1) {
            $condition[] = " a.status = 1";
        }
        if ($status == 2) {
            $condition[] = " a.status = 0";
        }
        //$manual_cond=implode(' and ',$condition);
        $manual_cond = implode(' and ', (array)$condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if (!empty($result[0]['id'])) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {
                if (empty($row['parent_office'])) {
                    $poffice = $row['office_name'];
                    $office = '';
                } else {
                    $poffice = $row['parent_office'];
                    $office = $row['office_name'];
                }
                if ($row['created_on']) {
                    $row['created_on'] = date('d-m-Y H:i:s', strtotime($row['created_on']));
                }
                if ($row['last_activity']) {
                    $row['last_activity'] = date('d-m-Y H:i:s', strtotime($row['last_activity']));
                }
                $status = ($row['status'] == 1) ? 'Active' : 'Deactive';
                $logged_inas = '';
                if ($this->session->userdata('role_id') == 1) {
                    $logged_inas = ' / ' . anchor('/Index/logged_inas/' . base64_encode($row['id']), 'Login As ', ' onclick="return confirm(\'Are you want to login as ' . $row['name'] . ' ?\'); "');
                }
                $response->rows[$i]['cell'] = array(
                    $i + $count + 1,
                    $row['org_name'],
                    $poffice,
                    $office,
                    $row['sub_office'],
                    anchor('/Management/userscommonview/' . base64_encode($row['id']), $row['name']),
                    $row['role_name'],
                    $row['username'],
                    $row['email'],
                    $row['mobile'],
                    $row['created_on'],
                    $row['last_activity'],
                    $status,
                    (anchor('/Management/usersadd/' . base64_encode($row['id']), "Edit") . '/' . anchor('/Management/userscommonview/' . base64_encode($row['id']), 'View') . $logged_inas)
                );
            }
        }
        echo json_encode($response);
    }
    //****** User Creation Form *****/
    function usersadd()
    {
        $id = base64_decode($this->uri->segment(3));
        $data['id'] = $id;
        $title = "Create";
        $user_details = $this->amodel->getDetails(DB_PREFIX . "user", array('*'), array('id' => $id));
        $data['user_details'] = $user_details;
        $user_roles = $this->amodel->getDetails(DB_PREFIX . "users_roles", array('*'), array('user_id' => $id));
        $offices = $this->db->query("SELECT p.parent_office,b.branch_office,s.sub_office,o.office_name as poffice,br.office_name as boffice,su.office_name as soffice 
        FROM " . DB_PREFIX . "user a 
        LEFT JOIN " . DB_PREFIX . "user_headoffices p ON p.user_id=a.id
        LEFT JOIN " . DB_PREFIX . "user_branchoffices b ON b.user_id=a.id
        LEFT JOIN " . DB_PREFIX . "user_suboffices s ON s.user_id=a.id
        LEFT JOIN " . DB_PREFIX . "office o ON p.parent_office=o.id
        LEFT JOIN " . DB_PREFIX . "office br ON b.branch_office=br.id
        LEFT JOIN " . DB_PREFIX . "office su ON s.sub_office=su.id
        WHERE a.id = '$id'")->result_array();
        $user_contact_details = $this->amodel->getDetails(DB_PREFIX . "user_contact_details", array('*'), array('user_id' => $id));
        $sql = " Select * from " . DB_PREFIX . "user a where a.id = ?";
        $user_details = $this->db->query($sql, array($id))->result_array();
        $postvalue = $this->session->userdata('postvalue');
        if ($user_details && $id) {
            $this->_check_featureauth('users', 'edit');
            $subtitle = "Modify";
        } else {
            $this->_check_featureauth('users', 'add');
            $subtitle = "Create";
        }
        $auth_link = array(array('users', 'search', 'Search', 'Management/users', ''));
        $this->mm->userdml($id);
        $mess = base64_decode($this->uri->segment(4));
        // echo "<pre>"; print_r($user_roles); exit;
        if ($id != 0) {
            foreach ($offices as $key => $parent) {
                if ($parent['poffice'] != 0 || isset($parent['poffice'])) {
                    $poffice[$parent['parent_office']] = $parent['parent_office'];
                }
                if ($parent['boffice'] != 0 || isset($parent['boffice'])) {
                    $boffice[$parent['branch_office']] = $parent['branch_office'];
                }
                if ($parent['soffice'] != 0 || isset($parent['soffice'])) {
                    $soffice[$parent['sub_office']] = $parent['sub_office'];
                }
            }
            foreach ($user_roles as $key => $roles) {
                $c_role[$key] = $roles['role_id'];
            }
            $user_details[0]['parent_office'] = $poffice;
            $user_details[0]['office_id'] = $boffice;
            $user_details[0]['sub_office'] = $soffice;
            $user_details[0]['role_id'] = $c_role;
        }

        $formElement = $this->mm->user_formelement($id, $user_details, $user_roles, $offices);
        $contact_fromelement = $this->mm->user_contact_formelement($id, $user_contact_details);
        $data['formelements'] = create_form($formElement, $user_details, $id);
        $data['contact_fromelement'] = create_form($contact_fromelement, $user_contact_details, $id);
        $data['user_details'] = $user_details;
        $data['table'] = form($data['formelements'], $formElement, 'user', 'Management/users', $subtitle, $auth_link, '', base_url());
        $data['contact'] = form($data['contact_fromelement'], $contact_fromelement, '', 'Management/users', 'user_contact_details', '', '', base_url());
        if ($mess) {
            $data['message'] = $mess;
        } else {
            $data['message'] = '';
        }
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Users', 'Management/users');
        $this->breadcrumbs->push('Add User', 'Management/usersadd');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'user');
    }
    //************ User view Page ************/   
    function userscommonview()
    {
        $this->_check_featureauth('users', 'view');
        $id = base64_decode($this->uri->segment(3));
        $userDetails = $this->mm->getuserdetails($id);
        $usercontacts = $this->mm->getcontactdetails($id);
        $user_skills = $this->mm->getskilldetails($id);

        $userRole = $userDetails[0]['role_id'];
        if ($userRole == 17) {
            $data['target'] = $this->mm->get_qctarget($id);
        } else {
            $data['target'] = $this->mm->check_target($id);
        }

        $data['usercontact'] = $userDetails[0];
        $data['contact_details'] = $usercontacts[0];
        $data['skill_details'] = $user_skills;

        $data['auth_link'] = array(
            array('users', 'search', 'Search', 'Management/users', ''),
            array('users', 'edit', 'Modify', 'Management/usersadd/' . $this->uri->segment(3), ''),
            array('users', 'delete', 'Delete', 'Management/usersdelete/' . $this->uri->segment(3), '')
        );
        $data['title'] = "user";
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Users', 'Management/users');
        $this->breadcrumbs->push('User', 'Management/userscommonview');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, $data['title']);
    }
    //************ User Delete Page ************/   
    public function usersdelete()
    {
        $this->_check_featureauth('users', 'delete');
        $data['id'] = $id = base64_decode($this->uri->segment(3));
        $pagetitle = "office_delete";
        $formElement = array(array('confirm' => array('textarea', 'sure_msg', 'R|row:5|col:20|W')));
        $subtitle = "Delete";
        $data['formelements'] = create_form($formElement);
        $auth_link = array(array('users', 'search', 'Search', 'Management/users', ''));
        $data['user_deleteform'] = form($data['formelements'], $formElement, 'user', 'Management/users', $subtitle, $auth_link, 'delete');
        $this->mm->users_delete($id);
        $this->amodel->pagerender($data, 'user');
    }

    //********************* USER SKILL***********************/
    function skillsadd()
    {
        $this->load->helper('cloneform');
        $key = $this->amodel->fetchreportDropdown('dcode_master_masterdata', array('id', 'name'), array('key' => 'Check'), 'Select');
        $user_id = base64_decode($this->uri->segment(3));
        $data['user_det'] = $this->db->query("select concat_ws(' ', first_name,last_name) as user from " . DB_PREFIX . "user where id = " . $user_id)->row();
        $data['auth_link'] = array(array('users', 'search', 'Search', 'Management/users'));
        $skillsadd_clones = array(array('key' => array('dropdown', 'key', 'R|MC-getskills', 'R|MC-getskills', $key, 'RF', ''), 'skills' => array('dropdown', 'skills', 'R', 'R', '', '', '')));
        $data['skills_file_clone'] = create_cloneform($skillsadd_clones, '', $user_id);
        $data['upload_file'] = formclonecreation($skillsadd_clones, $data['skills_file_clone'], 1, 'Add Skills', "Add Skills");
        $this->amodel->pagerender($data, 'skillsadd');
    }
    //********************* USER Add SKILLS***********************/
    function addskills()
    {
        $user_id = base64_decode($this->uri->segment(3));
        $id = base64_decode($this->uri->segment(4));
        $this->mm->skillsdml($id, $user_id);
    }
    ///**************** CANDIDATE  List View Page ***************/
    function candidate()
    {
        // Check if user is allowed for action
        $this->_check_featureauth('candidate', 'search');
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Candidate', 'Management/candidate');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'candidate');
    }
    //************** Listing of Candidates *********************/
    function get_candidate($usertype_id = '')
    {
        $this->_check_featureauth('candidate', 'search');
        $model = array('Management_model' => 'get_candidatelist');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $uname = ($_REQUEST['uname']) ? $_REQUEST['uname'] : '';
        $organization = ($_REQUEST['organization']) ? $_REQUEST['organization'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $client_ref_number = ($_REQUEST['client_ref_number']) ? $_REQUEST['client_ref_number'] : '';
        $case_number = ($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
        $email_id = ($_REQUEST['email_id']) ? $_REQUEST['email_id'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $type_of_employees = ($_REQUEST['type_of_employees']) ? $_REQUEST['type_of_employees'] : '';

        $caseStatus = ($_REQUEST['case_status']) ? $_REQUEST['case_status'] : '';
        $fromDate = ($_REQUEST['fromDate']) ? $_REQUEST['fromDate'] : '';
        $toDate = ($_REQUEST['toDate']) ? $_REQUEST['toDate'] : '';

        if ($office) {
            $condition[] = " a.office_id = " . $office;
        }
        if ($organization) {
            $condition[] = " a.organization = " . $organization;
        }
        if ($parent_office) {
            $condition[] = " a.parent_office = " . $parent_office;
        }
        if ($name) {
            $condition[] = " ( a.first_name like '%" . $name . "%' OR  a.last_name like '%" . $name . "%') ";
        }
        if ($uname) {
            $condition[] = " a.username like '%" . $uname . "%'";
        }
        if ($client_ref_number) {
            $condition[] = " h.client_ref_number like '%" . $client_ref_number . "%'";
        }
        //17/01/2024
        $case_number = trim($case_number);
        if ($case_number) {
            $condition[] = " h.case_no like '%" . $case_number . "'";
        }
        if ($sub_office) {
            $condition[] = " a.sub_office like '%" . $sub_office . "%'";
        }
        if ($email_id) {
            $condition[] = " a.email like '%" . $email_id . "%'";
        }
        if ($status == 1) {
            $condition[] = " a.status =1 ";
        }
        if ($status == 2) {
            $condition[] = " h.dataentry_by=0 and cv.client_status is NULL and a.status =0 ";
        }
        if ($status == 3 || $caseStatus == 'not_submitted') {
            $condition[] = " a.status =2 ";
        }
        if ($caseStatus == 'deactiveCases') {
            $condition[] = " h.dataentry_by=0 and cv.client_status is NULL and a.status =0 ";
        }
        if (empty($fromDate) && empty($toDate) && $caseStatus == 'totalCases') {
            $condition[] = " (DATE_FORMAT(h.created_on, '%Y-%m-%d') BETWEEN (CURRENT_DATE() - INTERVAL 1 MONTH) AND CURRENT_DATE()) ";
        }
        if ($caseStatus == 'totalCases' && !empty($fromDate) || !empty($toDate)) {
            $condition[] = " ((DATE_FORMAT(h.created_on ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($fromDate)) . "') and  (DATE_FORMAT(h.created_on ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($toDate)) . "')) ";
        }
        if ($type_of_employees) {
            $condition[] = " a.type_of_employees = " . $type_of_employees;
        }
        if ($term) {
            $search = explode(' ', $term);
            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    $t        = substr($t, 1, strlen($t));
                }
                $like    = '';
                $like    .= "( a.middle_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.last_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " h.client_ref_number " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " h.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.username " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " h.check_status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " f.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " g.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " uc.telephone " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.email " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " s.office_name " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }
        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {
                if (empty($row['parent_office'])) {
                    $poffice = $row['office_name'];
                    $office = '';
                } else {
                    $poffice = $row['parent_office'];
                    $office = $row['office_name'];
                }
                $check_type = '';
                $total_chk = '';
                $checknames = '';
                $total_chk = $this->mm->getchecks($row['request_id']);
                foreach ($total_chk as $key => $ci) {
                    if ($ci['check_id'] > 94 && ($ci['check_id'] < 630 && $ci['check_id'] > 654)) {
                        $checknames[$ci['pack_id'] . '' . $ci['check_id']] = $ci['name'];
                    } else {
                        $checknames[$ci['check_id']] = $ci['chk_count'] . ' ' . $ci['name'];
                    }
                }
                $chk = implode(' + ', $checknames);
                $package_name = $total_chk[0]['level'];

                $status = (($row['status'] == 2)) ? 'NOT TO BE SUBMITTED TO DCODE' : (($row['status'] == 1) ? 'Active' : 'Deactive');
                if ($this->session->userdata('user_type') == 2) {
                    $org_details = $this->amodel->getDetails(DB_PREFIX . "organisation", array('type_of_employ_candidate'), array('id' => $this->session->userdata('organization')));
                }
                $type_of_employees = '';
                if ($org_details[0]['type_of_employ_candidate'] == 1 || $this->session->userdata('user_type') == 1) {
                    $type_of_employees = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('name'), array('id' => $row['type_of_employees']));
                    $view = $type_of_employees[0]['name'];
                    $view2 = anchor('/Management/candidateview/' . base64_encode($row['id']), 'View');
                } else {
                    $view = anchor('/Management/candidateview/' . base64_encode($row['id']), 'View');
                }

                if ($row['status'] == 2) {
                    $checkbox = '';
                } else {
                    $checkbox = '<input type="checkbox" class="req required" name="request_id[]" value="' . ($row['id']) . '" />';
                }



                $response->rows[$i]['cell'] = array(
                    $checkbox,
                    $i + $count + 1,
                    $row['org_name'],
                    $poffice,
                    $office,
                    $row['sub_office'],
                    anchor('/Management/candidateview/' . base64_encode($row['id']), $row['name']),
                    $row['case_no'],
                    $row['client_ref_number'],
                    $row['username'],
                    $row['email'],
                    $row['telephone'],
                    $package_name,
                    $chk,
                    $status,
                    $view,
                    $view2
                );
            }
        }
        echo json_encode($response);
    }
    //********** Checking Type of Employee **************/
    function checktype_employee()
    {
        $this->db->select('type_of_employ_candidate');
        $this->db->where('id', $_POST['parent_id']);
        $results = $this->db->get(DB_PREFIX . "organisation")->row_array();
        echo ($results['type_of_employ_candidate'] == 1) ?   1 : 0;
    }
    //********** Candidate Creation Form ********************/
    function candidateadd()
    {
        $this->load->helper('cloneform');
        $id = base64_decode($this->uri->segment(3));
        $title = "Create";
        $candidate_details = $this->amodel->getDetails(DB_PREFIX . "user", array('*'), array('id' => $id));

        if ($candidate_details) {
            $this->_check_featureauth('candidate', 'edit');
            $subtitle = "Modify";
        } else {

            $this->_check_featureauth('candidate', 'add');
            $subtitle = "Create";
        }


        $cand = $this->amodel->getDetails(DB_PREFIX . "user_contact_details", array('telephone', 'cand_status_reason'), array('user_id' => $id));
        $cand_userdetais = $this->amodel->getDetails(DB_PREFIX . "client_request", array('client_ref_number', 'request_id'), array('user_id' => $id));
        $candidate_details[0]['client_ref_number'] = $cand_userdetais[0]['client_ref_number'];
        $candidate_details[0]['telephone'] = $cand[0]['telephone'];
        $candidate_details[0]['cand_status_reason'] = $cand[0]['cand_status_reason'];
        if ($this->session->userdata('user_type') == 2) {
            $org_id = ($candidate_details[0]['organization']) ? $candidate_details[0]['organization'] : $this->session->userdata('organization');
        } else {
            $org_id = ($candidate_details[0]['organization']) ? $candidate_details[0]['organization'] : '';
        }
        $org_details = $this->amodel->getDetails(DB_PREFIX . "organisation", array('type_of_employ_candidate'), array('id' => $org_id));
        $candidate_details[0]['type_of_employ'] = $org_details[0]['type_of_employ_candidate'];
        $reqID = $cand_userdetais[0]['request_id'];

        $this->mm->candidatedml($id, $reqID);

        //01/03/2023

        $user_assigned = $this->mm->get_candidate_assigneestatus($reqID);
        //print_r( $user_assigned); exit;
        $data['assainee_status'] = $user_assigned['assainee_status'];
        $data['case_accepted_date'] = $user_assigned['case_accepted_date'];

        // ********************************************************///

        $candidatecheklist = $this->mm->get_candidatecheck($id);
        $mess = base64_decode($this->uri->segment(4));
        $formElement = $this->mm->candidate_formelement($id, $candidate_details);
        $data['formelements'] = create_form($formElement, $candidate_details, $id);
        $data['candidate_details'] = $candidate_details;
        $data['table'] = form($data['formelements'], $formElement, '', 'Management/candidate', $subtitle, $auth_link, '', base_url());
        if ($mess) {
            $data['message'] = $mess;
        } else {
            $data['message'] = '';
        }
        $data['request_id'] = $cand_userdetais[0]['request_id'];
        $data['id'] = $id;
        $data['type_of_employees'] = $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'type_of_employees'));
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Candidate', 'Management/candidate');
        $this->breadcrumbs->push('Add Candidate', 'Management/candidateadd');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, '');
    }

    function validate_captcha()
    {
        $key = config_item('google_site_key');
        $captcha = $this->input->post('g-recaptcha-response');
        $response = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=" . $key . "&response=" . $captcha . "&remoteip=" . $_SERVER['REMOTE_ADDR']);
        if ($response . 'success' == false) {
            return FALSE;
        } else {
            return TRUE;
        }
    }

    //************ Candidate View Page **************/
    function candidateview()
    {
        $id = base64_decode($this->uri->segment(3));
        $candidatedetails = $this->mm->getcandidatedetails($id);

        $data['candidatecontact'] = $candidatedetails[0];
        $data['candidate_documents'] = $this->mm->getcandidatedoc($id);
        $modify = ($candidatedetails) ? (array('users', 'edit', 'Modify', 'Management/candidateadd/' . $this->uri->segment(3), '')) : array();
        $data['auth_link'] = array(
            array('candidate', 'search', 'Search', 'Management/candidate', ''),
            $modify
        );
        $data['title'] = "candidate";
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Candidate', 'Management/candidate');
        $this->breadcrumbs->push('View Candidate', 'Management/candidateview');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, $data['title']);
    }
    ///*********** CANDIDATE PROFILE ENDS ************/
    function importmultiple()
    {
        $this->mm->candidatemul($_POST);
    }
    //************** Organization View Page ************/
    function organisation()
    {
        $this->_check_featureauth('organisation', 'search');
        $formElement = array(array('cn-org_name' => array('text', 'org_name', 'L|max:25|min:1|Z', '', '', ''), 'eq-user_type' => array('dropdown', 'user_type', 'max:25|min:1|Z', '', $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_usertype", array('id', 'name'), array('key' => 'user_types')), '')));
        $data['formelements'] = create_searchform($formElement);
        $auth_link = array(array('organisation', 'add', 'Create', 'Management/organisationadd', ''));
        $data['table'] = form($data['formelements'], $formElement, 'Organisation', 'Management/organisation', 'Search', $auth_link, '', base_url());
        $header_name = array('org_name' => 'org_name', 'user_type' => 'user_type');
        $values = pagination($this->mm->getorganisationList('', 'count', array('user_type')), uri_string());
        $data['pages'] = $pages = $values[1];
        $data['table_header'] = table_view($header_name, $this->mm->getorganisationList($values[0], '', $header_name), base_url() . 'Management/organisation', '');
        $data['org_data'] = $this->mm->getorganisationListed();
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Organization', 'Management/organisation');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'Organisation');
    }
    //*************** Listing of Organization **********************/
    function get_verificationlist()
    {
        $model = array('Management_model' => 'getorganisationListed');
        if ($_REQUEST['name']) {
            $condition[] = " a.org_name like '%" . $_REQUEST['name'] . "%'";
        }
        if ($_REQUEST['created_by']) {
            $condition[] = " d.first_name like '%" . $_REQUEST['created_by'] . "%'";
        }
        if ($_REQUEST['a_date']) {
            $condition[] = "DATE_FORMAT(a.created_on ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($_REQUEST['a_date'])) . "'";
        }
        if ($_REQUEST['t_date']) {
            $condition[] = "DATE_FORMAT(a.created_on ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($_REQUEST['t_date'])) . "'";
        }
        if ($_REQUEST['org_status']) {
            $condition[] = " a.org_status like '%" . $_REQUEST['org_status'] . "%'";
        }
        if ($_REQUEST['industry_type']) {
            $condition[] = " i.industry_id  in( " . $_REQUEST['industry_type'] . ")";
        }

        $manual_cond = implode(' and ', (array)$condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {
                if ($row['created_on']) {
                    $created_date = date('d-m-Y', strtotime($row['created_on']));

                    if ($row['billing_type'] == 515) {
                        $billing_type = 'Against Profile Submission';
                    } else if ($row['billing_type'] == 516) {
                        $billing_type = 'Against Final Report';
                    }
                }

                $id =   $row['id'];

                $sql = "SELECT  GROUP_CONCAT(b.name , '+' ) as name
                        
                         FROM " . DB_PREFIX . "industry_types a 
                                LEFT JOIN " . DB_PREFIX . "master_masterdata b ON a.industry_id= b.id
                      WHERE a.org_id = '$id' GROUP BY a.org_id;";
                $data =  $this->db->query($sql)->row_array();



                $org_status = ($row['org_status'] == 1) ? 'Active' : 'Deactive';
                $response->rows[]['cell'] = array(
                    $i + $count + 1,
                    anchor('Management/organisationcommonview/' . base64_encode($row['id']), $row['org_name']),
                    $org_status,
                    $data['name'],
                    $created_date,
                    $billing_type,
                    $row['first_name']
                );
            }
        }
        echo json_encode($response);
    }
    //********* export organization list *********************/  
    function export_organization()
    {
        $model = array('Management_model' => 'getorganisationListed');
        $org_name = ($_POST['exp_name']) ? $_POST['exp_name'] : '';
        $created_by = ($_POST['exp_created_by']) ? $_POST['exp_created_by'] : '';
        $a_date = ($_POST['exp_a_date']) ? $_POST['exp_a_date'] : '';
        $t_date = ($_POST['exp_t_date']) ? $_POST['exp_t_date'] : '';
        if ($org_name) {
            $condition[] = " a.org_name like '%" . $org_name . "%'";
        }
        if ($created_by) {
            $condition[] = " d.first_name like '%" . $created_by . "%'";
        }
        if ($a_date) {
            $condition[] = "DATE_FORMAT(a.created_on ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($a_date)) . "'";
        }
        if ($t_date) {
            $condition[] = "DATE_FORMAT(a.created_on ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }
        if ($_POST['exp_org_status']) {
            $condition[] = " a.org_status like '%" . $_REQUEST['exp_org_status'] . "%'";
        }


        /*   if($_REQUEST['exp_industry_type']){
            $condition[]=" i.industry_id  in( ".$_REQUEST['exp_industry_type'].")";
        }*/


        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Organization Status");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Created On");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Created By");
            $ci = 2;
            foreach ($result as $i => $row) {
                $org_status = ($row['org_status'] == 1) ? 'Active' : 'Deactive';
                $objPHPExcel->getActiveSheet()->getStyle('A1:E1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i + $count + 1))
                    ->setCellValue('B' . $ci, $row['org_name'])
                    ->setCellValue('C' . $ci, $org_status)
                    ->setCellValue('D' . $ci, date('d-m-Y', strtotime($row['created_on'])))
                    ->setCellValue('E' . $ci, $row['first_name']);
                $ci++;
            }
            $this->export_excel('A', 'E', 'Organization_List_', $objPHPExcel);
            exit;
        }
        redirect('Management/organisation');
    }
    //************* Organization Creation ***************************/
    function organisationadd()
    {


        $id = base64_decode($this->uri->segment(3));
        $this->mm->organisationdml($id);
        $editDetails = $this->amodel->getDetails(DB_PREFIX . "organisation", array('*'), array('id' => $id));
        $industry_type = $this->amodel->getDetails(DB_PREFIX . "industry_types", array('*'), array('org_id' => $id));


        $dataentry = array('45' => 'Full Entry', '44' => 'Partial Entry', '25' => 'Candidate Entry');
        $crm_users = $this->mm->get_rolecrmusers();
        $crm_user = array('' => 'Select');
        foreach ($crm_users as $key => $value) {
            $crm_user[$value['id']] = $value['crm_name'];
        }
        $data['crm_user'] = $crm_user;
        $dataentrye = array();
        if ($editDetails) {
            $dataentrys = $this->mm->getdataentry($id);
            if (!empty($dataentrys)) {
                foreach ($dataentrys as $key => $entry) {
                    $dataentrye[$entry['entry']] = $entry['entry'];
                }
            }
            if (!empty($editDetails[0]['dedicated_qc'])) {
                $qualitycheck = explode(',', $editDetails[0]['dedicated_qc']);
                foreach ($qualitycheck as $key => $qcheck) {
                    $default_qc[$qcheck] = $qcheck;
                }
            }
            if (!empty($industry_type)) {


                foreach ($industry_type as $key => $industry_id) {
                    $ind_id[$key] = $industry_id['industry_id'];
                }
            }
            $this->_check_featureauth('organisation', 'edit');
            $subtitle = "Modify";
            $editDetails[0]['dataentry'] = $dataentrye;
            $editDetails[0]['dedicated_qc'] = $default_qc;
            $editDetails[0]['industry_type'] = $ind_id;
            $auth_link = array(
                array('organisation', 'search', 'Search', 'Management/organisationcommonview/' . base64_encode($id), '')
            );
        } else {
            $this->_check_featureauth('organisation', 'add');
            $subtitle = "Create";
            $auth_link = array(
                array('organisation', 'search', 'Search', 'Management/organisation', '')
            );
        }
        $totoffice = $this->mm->gettotoffice();
        if ($totoffice) {
            $hierarchy = $totoffice[0]['totaloffice'] + 1;
        } else {
            $hierarchy = 1;
        }
        $dedicated_qc = array('' => 'Select', '4' => 'QC1 & QC2', '17' => 'QC2');
        $formElement = array(array('org_name' => array('text', 'org_name', 'R|Z|MC-testorg', 'R|Z|MC-testorg', '', 'RF', '', ''), 'logo' => array('upload1', 'logo', 'R|Z|MC-checkphoto', 'Z|MC-checkphoto', '', 'RF', '', ''), 'dataentry' => array('multiselect', 'dataentry', 'R|Z|Y', 'R|Z|Y', $dataentry, 'RF'), 'dedicated_qc' => array('dropdown', 'dedicated_qc', 'R|Y', 'R|Y', $dedicated_qc, 'RF', '')));
        $data['formelements'] = create_form($formElement, $editDetails, $id);
        $data['organisation_addform'] = form($data['formelements'], $formElement, 'Organisation', 'Management/organisation', $subtitle, $auth_link, '', base_url());
        $data['edit_details'] = $editDetails;
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Organization', 'Management/organisation');
        $this->breadcrumbs->push('Add Organization', 'Management/organisationadd');
        $data['breadcrumb'] = $this->breadcrumbs->show();

        $this->amodel->pagerender($data, 'Organisation');
    }
    //************* Organization View Page ***************************/
    function organisationcommonview()
    {
        // Check if user is allowed for action
        $this->_check_featureauth('organisation', 'view');
        $id = $data['id'] = base64_decode($this->uri->segment(3));
        $organisation = $this->mm->gethierarchydetails($id);
        $data['organisation_viewform'] = $organisation[0];
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Organization', 'Management/organisation');
        $this->breadcrumbs->push('Organization Details', 'Management/organisationcommonview/' . $id);
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data);
    }
    //***************** OFFICE View Page ****************************/
    function office()
    {
        $this->_check_featureauth('office', 'search');
        $this->amodel->pagerender('', 'branch_office');
    }
    //***************************** List of Offices ********************************/
    function get_office($org_id = '', $office_name = '')
    {
        $this->_check_featureauth('office', 'search');
        $model = array('Management_model' => 'getOfficeList');
        $organization = ($_REQUEST['organization']) ? $_REQUEST['organization'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $role = ($_REQUEST['role']) ? $_REQUEST['role'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $a_date = ($_REQUEST['a_date']) ? $_REQUEST['a_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        if ($organization) {
            $condition[] = "g.id=" . $organization;
        }
        if ($sub_office) {
            $condition[] = "a.id=" . $sub_office;
        } elseif ($office) {
            $condition[] = "a.id=" . $office . " OR a.level=" . $office;
        } elseif ($parent_office) {
            $condition[] = "a.parent=" . $parent_office . " OR a.id=" . $parent_office;
        }
        if ($a_date) {
            $condition[] = "DATE_FORMAT(a.created_on ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($a_date)) . "'";
        }
        if ($t_date) {
            $condition[] = "DATE_FORMAT(a.created_on ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }
        if ($role) {
            $condition[] = "d.user_type=" . $role;
        }
        if ($term) {
            $search = explode(' ', $term);
            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    $t = substr($t, 1, strlen($t));
                }
                $like    = '';
                $like    .= "( c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " g.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.created_on" . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";
                $like    .= $operator . " d.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " f.office_name " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }
        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {
                if ($row['parent'] == 0 && $row['level'] == 0) {
                    $parent_office = $row['office_name'];
                    $office = '';
                    $sub_office = '';
                } else if ($row['level'] == 0) {
                    $parent_office = $row['parent_office'];
                    $office = $row['office_name'];
                    $sub_office = '';
                } else {
                    $parent_office = $row['parent_office'];
                    $office = $row['suboffice'];
                    $sub_office = $row['office_name'];
                }
                if ($row['created_on']) {
                    $row['created_on'] = date('d-m-Y H:i:s', strtotime($row['created_on']));
                }
                $response->rows[$i]['cell'] = array($i + $count + 1, anchor(
                    '/Management/officecommonview/' . base64_encode($row['id']),
                    $row['org_name']
                ), $parent_office, $office, $sub_office, $row['created_on'], $row['created_by'], anchor('/Management/officeadd/' . base64_encode($row['parentoffice_id']) . '/' . base64_encode($row['id']), "Edit"));
            }
        }
        echo json_encode($response);
    }
    //******************* Office Creation Form **********************************/            
    function officeadd()
    {
        $org_id = base64_decode($this->uri->segment(3));
        $oid = $this->uri->segment(4);
        $id = base64_decode($this->uri->segment(4));
        $editDetails = $this->amodel->getDetails(DB_PREFIX . "office", array('*'), array('id' => $id));
        if ($editDetails) {
            $this->_check_featureauth('office', 'edit');
            $subtitle = "Modify";
            $auth_link = array(array('office', 'search', 'Search', 'Management/organisationcommonview/' . $this->uri->segment(3), ''));
        } else {
            $this->_check_featureauth('office', 'add');
            $subtitle = "Create";
            $auth_link = array(array('office', 'search', 'Search', 'Management/organisationcommonview/' . $this->uri->segment(3), ''));
        }
        $formElement = $this->mm->loadofficeelement($id, $editDetails, $org_id, $oid);
        $data['office_id'] = $id;
        $data['org_id'] = $org_id;
        $data['formelements'] = create_form($formElement, $editDetails, $id);
        $data['editDetails'] = $editDetails;
        $data['office_addform'] = form($data['formelements'], $formElement, 'office', 'Management/organisationcommonview/' . $oid . '/' . $this->uri->segment(4), $subtitle, $auth_link, '', base_url());
        $this->mm->officedml($id, $org_id);
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Organisation', 'Management/organisation');
        $this->breadcrumbs->push('Add Office', 'Management/officeadd');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'branch_office');
    }
    //*********************** Office View Page *****************************/
    function officecommonview()
    {
        $this->_check_featureauth('office', 'view');
        $id = base64_decode($this->uri->segment(3));
        $editDetails = $this->amodel->getDetails(DB_PREFIX . "office", array('*'), array('id' => $id));
        $org_id =  base64_encode($editDetails[0]['parentoffice_id']);
        $officedetails = $this->mm->getofficedetails($id);
        if (empty($officedetails[0]['parent_office']) && empty($officedetails[0]['branch_office'])) {
            $new = array('office_name' => 'parent_office');
        } else if (empty($officedetails[0]['branch_office'])) {
            $new = array('parent_office' => 'parent_office', 'office_name' => 'branch_office');
        } else {
            $new = array('parent_office' => 'parent_office', 'branch_office' => 'branch_office', 'office_name' => 'sub_office');
        }
        $header_name = array('org_name' => 'org_name');
        $header_name1 = array('address1' => 'address1', 'address2' => 'address2', 'address3' => 'address3',  'country' => 'country', 'state' => 'state', 'pincode' => 'pincode', 'telephone1' => 'telephone1', 'telephone2' => 'telephone2', 'fax' => 'fax', 'office_code' => 'office_code');
        $header_name = array(array_merge($header_name, $new, $header_name1));
        $auth_link = array(
            array('office', 'search', 'Search', 'Management/organisationcommonview/' . $org_id, ''),
            array('office', 'edit', 'Modify', 'Management/officeadd/' . $org_id . '/' . $this->uri->segment(3), '')
        );
        $data['office_viewform'] = commonview($officedetails, $header_name, 'Office_View', base_url() . "Management/office", $auth_link);
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Organisation', 'Management/organisation');
        $this->breadcrumbs->push('Organisation Details', 'Management/organisationcommonview/' . $org_id);
        $this->breadcrumbs->push(' Office', 'Management/officeview');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'office');
    }
    //********************* Office Delete Form ********************************/
    public function officedelete()
    {
        $this->_check_featureauth('office', 'delete');
        $id = base64_decode($this->uri->segment(3));
        $pagetitle = "office_delete";
        $subtitle = "Delete";
        $formElement = array(array('confirm' => array('textarea', 'sure_msg', 'R|row:5|col:20|W')));
        $data['formelements'] = create_form($formElement);
        $auth_link = array(array('office', 'search', 'Search', 'Management/office', ''));
        $data['office_deleteform'] = form($data['formelements'], $formElement, 'office', 'Management/office', $subtitle, $auth_link, 'delete');
        $data['id'] = $id;
        $this->amodel->pagerender($data, 'office');
    }
    //************************ Get Insurance Type ********************************/  
    function getinstype()
    {
        $getDetails = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('ref_id' => $id, 'key' => 'Insurance Type'));
        $id = $this->uri->segment(3);
        $dropDownvalues = $this->amodel->filterDropdown($getDetails, array('id', 'name'));
        echo $dropDownvalues;
    }
    //************************ Get Offices ********************************/ 
    public function getoffice()
    {
        $id = $this->uri->segment(4);
        $getoffices = $this->amodel->getDetails(DB_PREFIX . "office", array('id', 'office_name'), array('parentoffice_id' => $id));
        $dropDownvalues = $this->amodel->filterDropdown($getoffices, array('id', 'office_name'));
        echo $dropDownvalues;
    }
    //************************ Get Roles ********************************/ 
    public function getrole()
    {
        $id = $this->uri->segment(4);
        if ($id == 1) {
            $type = 1;
        } else {
            $type = 2;
        }
        $getoffices = $this->amodel->getDetails(DB_PREFIX . "role_types", array('id', 'role_name'), array('user_type' => $type));
        $dropDownvalues = $this->amodel->filterDropdown($getoffices, array('id', 'role_name'));
        echo $dropDownvalues;
    }
    //************************ Get Organization ********************************/ 
    public function getorg()
    {
        $user_typeid = $this->uri->segment(4);
        $getoffices = $this->amodel->getDetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('user_type' => $user_typeid, 'org_status' => 1));
        $dropDownvalues = $this->amodel->filterDropdown($getoffices, array('id', 'org_name'));
        echo $dropDownvalues;
    }
    //************************ Get Parentoffice ********************************/   
    function parentoffice()
    {
        $officetype_id = $this->uri->segment(3);
        $parentoffice = $this->mm->getParentOfficetype($officetype_id);
        $out = '<option value="0">Select</option>';
        foreach ($parentoffice as $parentoff) {
            $out .= '<option value="' . $parentoff->id . '">' . $parentoff->type . '</option> ';
        }
        echo $out;
    }
    //************************ Listing Organization ********************************/   
    function get_org($type = 'json')
    {
        $this->_check_featureauth('organisation', 'search');
        $model = array('Management_model' => 'get_orglist');
        $results = $this->_jqgrid_search($model);
        $response = $result[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {
                $response->rows[$i]['cell'] = array(
                    $i + $count + 1,
                    anchor('/Management/organisationcommonview/' . base64_encode($row['id']), $row['org_name']),
                    $row['created_on'],
                    $row['created_by']
                );
            }
        }
        echo json_encode($response);
    }
    function officestructure()
    {
        $officetype_id = $this->uri->segment(3);
        $treelist = $this->mm->officestructure($officetype_id);
        $data["tree"] = $treelist;
        $this->amodel->pagerender($data, 'officestructure');
    }
    //**************Team management List *****************/
    function team_manage()
    {
        $assignee_list = $this->mm->get_assignee_list();
        $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list, array('assignee_id', 'name'));
        $data['checks'] = $this->mm->get_check_list();
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Manage Teams', 'Management/team_manage');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'team_manage');
    }
    //**************Team management Creation Formm *****************/
    function team_add()
    {
        $formData = $_POST;
        $this->mm->team_add($formData);
    }
    //**************** Loading checks ************************/
    function load_check()
    {

        $this->load->model('Client_model', 'cm');
        $office_id = $_POST['office_id'];
        $office = $_POST;
        $id = $_POST['id'];
        if (empty($office)) {
            die();
        }
        $order_details = $this->cm->load_order_by_client($office);
        if (empty($order_details)) {
            echo 'No Resutls';
            die();
        }
        $candidatecheklist = $this->mm->get_candidatecheck($id);
        $lists = array();
        $lists['ids'] = array();
        foreach ($candidatecheklist as $list) {
            $lists['ids'][] = $list['check_id'];
            $lists[$list['check_id']] = $list;
        }

        $candidatepackglist = $this->mm->get_candidatepackage($id);

        $lists1 = array();
        $lists1['ids'] = array();
        foreach ($candidatepackglist as $list1) {
            $lists1['ids'][] = $list1['package_id'];
            $lists1[$list1['package_id']] = $list1;
        }

        $table = "<table border='1' align='center' style='width:923px;' id='table'>";
        $table .= "<tr class='s-usebrd' height='35'><td colspan='4'><h3>Checks and Levels</h3></td></tr>";
        $table .= "<tr class='at_tr' height='35'>
        <th class='at_th' style='width:450px;' >Check Name</th>
        <th class='at_th'>No.of Checks</th>
        <th class='at_th'>Sub Check Name </th> 
        <th class='at_th'>Description </th>             
        </tr>";
        $checked = "";
        $cn = 1;
        foreach ($order_details as $orderkey => $ordervalue) {
            $childrecords = $this->cm->load_order_by_client($office, $ordervalue['id']);
            $childrecordsnew = $this->cm->load_order_by_client_new($office, $ordervalue['id']);
            $childrecords_data = $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('name', 'name'), array('key' => 'Check', 'parent' => $ordervalue['id']));
            if (in_array($ordervalue['id'], $lists['ids'])) {
                $no_checks = $lists[$ordervalue['id']]['no_checks'];
                $description = $lists[$ordervalue['id']]['description'];
                $information = $lists[$ordervalue['id']]['information'];
                $checked = "checked";
                if ($ordervalue['id'] == 75 || $ordervalue['id'] == 76 || $ordervalue['id'] == 77) {
                    $description = explode(',', $lists[$ordervalue['id']]['description']);
                }
            } else {
                $checked = "";
                $no_checks = '';
                $description = '';
                $information = '';
            }
            if (strtolower($ordervalue['key']) == 'check') {
                $table .= "<tr class='at_tr' height='35' >";
                if (!empty($childrecords)) {
                    $table .= "<td  class='at_td'><b>" . ucwords($ordervalue['name']) . "</b></td>";
                } else {
                    $table .= "<td  class='at_td'><input type='checkbox'  id='" . $ordervalue['id'] . "_level_id' autocomplete='off' class='de_check required chk_checked'  name = 'level_id[]' " . $checked . " value = '" . $ordervalue['id'] . "' />" . ucwords($ordervalue['name']) . "</td>";
                }
                $table .= "<td  class='text_box'><input type='text'  class='de_text required numbervalue' min='1' max='10' id ='" . $ordervalue['id'] . "_no_of_checks' disabled  name ='" . $ordervalue['id'] . "_no_of_checks' value = '" . $no_checks . "' autocomplete='off' /></td>";
                if (!empty($childrecordsnew)) {
                    $table .= "<td  class='text_box'>" . form_multiselect($ordervalue['id'] . '_descriptionm[]', $childrecords_data, set_value('descriptionm[]', $description), 'class="s-inpt required s-option" disabled="true" id=' . $ordervalue['id'] . '_descriptionm') . "<label  id='" . $ordervalue['id'] . "'  class='error' style='display: none;'>Please select options by number of checks</label></td>";
                } else {
                    $table .= "<td  class='text_box'></td>";
                }
                $table .= "<td  class='text_box'><input type='text'  class='de_text dec_txt" . $ordervalue['id'] . "' autocomplete='off' id ='" . $ordervalue['id'] . "_information' disabled  name ='" . $ordervalue['id'] . "_information' value = '" . $information . "' /></td>";
                $table .= "</tr>";
            } else if (strtolower($ordervalue['key']) == 'package') {

                if (in_array($ordervalue['id'], $lists1['ids'])) {
                    $checked = "checked";
                    $disabled = "disabled";
                } else {
                    $checked = "" || $checked = [];
                    $disabled = "" || $disabled = [];
                }


                if ($cn == 1) {
                    $table .= "<tr class='at_tr' height='35' >";
                    $table .= " <td   colspan='4'><table border='1'  style='width:100%' align='center'  id='table'> <tr class='at_tr' height='35'>
                    <th  class='text_box at_th' style='width:141px' > Package</th>
                   
                    <th class='at_th' style='width:324px'>Checks</th>
                    <th class='at_th' style='width:200px'>Description </th>              
                    </tr> </table></td></tr>";
                }
                if (!empty($ordervalue['level'])) {
                    $ordervalue_name = $ordervalue['level'];
                } else {
                    $ordervalue_name = $ordervalue['name'];
                }

                $table .= "<tr class='at_tr' height='35' >";
                $table .= " <td   colspan='4'><table  style='width:100%' border='1' align='center'  id='table'><tr class='at_tr' height='35'>";

                $table .= "<td  class='at_td'style='width:138px'><input type='checkbox'  id='" . $ordervalue['id'] . "_level_id' class='de_check required package_chk' " . $checked . " name = 'level_id[]' value = '" . $ordervalue['id'] . "' />" . ucwords($ordervalue_name) . "</td>";


                $this->db->select('p.group_id,p.check_id,p.no_ofcheck,p.checknotes,m.name,m.id,p.mandatory,p.anycount,p.noof_year');
                $this->db->where('package_id', $ordervalue['id']);
                $this->db->join(DB_PREFIX . 'master_masterdata m', 'm.id=p.check_id', 'left');
                $check_list = $this->db->get(DB_PREFIX . "packages p")->result_array();

                $counter = 0;
                foreach ($check_list as $key => $chkValue) {
                    if (!empty($chkValue['mandatory'])) {
                        $counter += 1;
                    }
                }

                $chknotes = '' || $chknotes = [];
                $checkName = '' || $checkName = [];
                $input_Field = '' || $input_Field = [];

                $j = 1;
                foreach ($check_list as $key => $chkValue) {
                    $checkId = $chkValue['check_id'];

                    if ($chkValue['group_id'] == GROUPID_IDPROOF) {

                        $any = ($counter > 0) ? $chkValue['anycount'] - $counter : '';
                        $anyCnt = ' Any ' . $any;
                        $mandatory = ($chkValue['mandatory'] == 'Yes') ? ' (Mandatory)' : ' (Optional)' . $anyCnt;
                    } else {
                        $mandatory = '' || $mandatory = [];
                    }

                    $noof_year = $chkValue['noof_year'];

                    if ($chkValue['check_id'] == 59) {
                        if (!empty($chkValue['no_ofcheck']) && $chkValue['no_ofcheck'] < UNLIMITED && (!empty($noof_year) && $noof_year < UNLIMITED)) {
                            $no_ofcheck = " - Add {$chkValue['no_ofcheck']} Employment details for last {$noof_year} Years of service";
                        } else if (!empty($chkValue['no_ofcheck']) && $chkValue['no_ofcheck'] == UNLIMITED && (!empty($noof_year) && $noof_year < UNLIMITED)) {
                            $no_ofcheck = " - Add all Employment details for last {$noof_year} Years of service ";
                        } else if (!empty($chkValue['no_ofcheck']) && $chkValue['no_ofcheck'] < UNLIMITED && (!empty($noof_year) && $noof_year == UNLIMITED)) {
                            $no_ofcheck = " - Add last {$chkValue['no_ofcheck']} Employment details";
                        } else if (!empty($chkValue['no_ofcheck']) && $chkValue['no_ofcheck'] == UNLIMITED && (!empty($noof_year) && $noof_year == UNLIMITED)) {
                            $no_ofcheck = " - Add all Employment details";
                        } else {
                            $no_ofcheck = '' || $no_ofcheck = [];
                        }
                    } else if ($chkValue['check_id'] == 640) {
                        if (!empty($chkValue['no_ofcheck']) && $chkValue['no_ofcheck'] < UNLIMITED && (!empty($noof_year) && $noof_year < UNLIMITED)) {
                            $no_ofcheck = " - Add {$chkValue['no_ofcheck']} address details for last {$noof_year} Years";
                        } else if (!empty($chkValue['no_ofcheck']) && $chkValue['no_ofcheck'] == UNLIMITED && (!empty($noof_year) && $noof_year < UNLIMITED)) {
                            $no_ofcheck = " - Add address details for last {$noof_year} Years";
                        } else if (!empty($chkValue['no_ofcheck']) && $chkValue['no_ofcheck'] < UNLIMITED && (!empty($noof_year) && $noof_year == UNLIMITED)) {
                            $no_ofcheck = " - Add {$chkValue['no_ofcheck']} address details";
                        } else if (!empty($chkValue['no_ofcheck']) && $chkValue['no_ofcheck'] == UNLIMITED && (!empty($noof_year) && $noof_year == UNLIMITED)) {
                            $no_ofcheck = " - Add address details";
                        } else {
                            $no_ofcheck = '' || $no_ofcheck = [];
                        }
                    } else {
                        $no_ofcheck = ($chkValue['no_ofcheck']) ? ' - ' . $chkValue['no_ofcheck'] : ' - 1';
                    }



                    $chknotes = (empty($chkValue['checknotes'])) ? '' : ' - ' . $chkValue['checknotes'];

                    $checkName[] = '<br><span class="checksnotes">&nbsp;' . $j . '. ' . $chkValue['name'] . $no_ofcheck . $mandatory . $chknotes . '</span><br>';

                    if (!empty($checked)) {
                        $input_Field[] = "<div style='padding:5px;' class='pkgRow" . $ordervalue['id'] . "' id='" . $ordervalue['id'] . "'><input type='text'  class='de_text' autocomplete='off' id ='" . $chkValue['id'] . "_information' disabled  name ='" . $chkValue['id'] . "_informations' value = '" . $candidatepackglist[$key]['information'] . "' /></div>";
                    } else {
                        $input_Field[] = "<div style='padding:5px;' class='pkgdes pkgRow" . $ordervalue['id'] . "' id='" . $ordervalue['id'] . "'><input type='text'  class='de_text' autocomplete='off' id ='" . $chkValue['id'] . "_information' disabled  name ='" . $chkValue['id'] . "_informations' value = '' /></div>";
                    }

                    $j++;
                }

                $chkname = implode(" ", $checkName);
                $description = implode(" ", $input_Field);

                $Button = '<span id="' . $ordervalue['id'] . '" class=" desc_add" value="' . $ordervalue['id'] . '">[+Add]<span class="tooltiptext">Add Description</span></span><br>';


                $table .= "<td class='' style='width:320px;' id='" . $ordervalue['id'] . "'>" . $chkname . "</td>";
                $table .= "<td class='description" . $ordervalue['id'] . "' style='width:200px;position: relative;' id='" . $ordervalue['id'] . "'>" . $Button . $description . "</td>";



                // if($ordervalue['id']==95){
                //     $table .= "<td  class='text_box at_td_e '> Any Two Degree </td> <td  class='text_box at_td_em'> Any Number of Employments (in the last 7yrs) </td><td  class='text_box at_td_l'>Last Employment</td>";
                // }
                // if($ordervalue['id']==96){
                //     $table .= "<td  class='text_box at_td_e'> One Degree </td> <td  class='text_box at_td_em'> Any Number of Employments (in the last 7yrs) </td><td  class='text_box at_td_l'>Last Employment</td>";
                // }
                // if($ordervalue['id']==97){
                //     $table .= "<td  class='text_box at_td_e'> One Degree </td> <td  class='text_box at_td_em'> Two Employement </td><td  class='text_box at_td_l'>Last Employment</td>";
                // }
                // if($ordervalue['id']==98){
                //     $table .= "<td  class='text_box at_td_e'> N/A </td> <td  class='text_box at_td_em'> Any Number of Employments (in the last 7yrs) </td><td  class='text_box at_td_l'>Last Employment</td>";
                // }
                // if($ordervalue['id']==99){
                //     $table .= "<td  class='text_box at_td_e'> One Degree </td> <td  class='text_box at_td_em'> Last Employment </td><td  class='text_box at_td_l'>Last Employment</td>";
                // }
                // if($ordervalue['id']==100){
                //     $table .= "<td  class='text_box at_td_e'> N/A </td> <td  class='text_box at_td_em'> Any Number of Employments (in the last 7yrs) </td><td  class='text_box at_td_l'>N/A</td>";
                // }
                // if($ordervalue['id']==101){
                //     $table .= "<td  class='text_box at_td_e'> One Degree </td> <td  class='text_box at_td_em'> Last Employment </td><td  class='text_box at_td_l'>N/A</td>";
                // }
                // if($ordervalue['id']==102){
                //     $table .= "<td  class='text_box at_td_e'> N/A </td> <td  class='text_box at_td_em'> Last Employment </td><td  class='text_box at_td_l'>Last Employment</td>";
                // }
                // if($ordervalue['id']==103){
                //     $table .= "<td  class='text_box at_td_e'> One Degree </td> <td  class='text_box at_td_em'> N/A </td><td  class='text_box at_td_l'>N/A</td>";
                // }
                $table .= "</tr>";
                $table .= "</table></td></tr>";
                $cn++;
            }
        }
        echo  $table;
        //echo  $table .= "<tr  height='35' ><td colspan='4' style='border-bottom: none;' >&nbsp;</td></tr><tr  height='35' ><td colspan='4' style='border-top: none;border-bottom: none;' ><input class='button' style='float:right;margin-right: 125px;' id='subtn' type='submit' value='Submit'></td></tr><tr  height='35' ><td colspan='4' style='border-top: none;' >&nbsp;</td></tr></table>";
    }
    //******************** Address Creation Form ****************************/
    function addressadd($officeid = 0, $id = 0)
    {
        $data['officeid'] = $officeid = base64_decode($officeid);
        $data['id'] = $id = ($id) ? base64_decode($id) : '0';
        $office_billing_address = $this->amodel->getDetails(DB_PREFIX . "office_billing_address", array('*'), array('organization' => $officeid, 'id' => $id));
        if (isset($_POST) && !empty($_POST)) {
            $this->mm->add_address($officeid, $id, $_POST);
        }
        $address_fromelement = $this->mm->user_address_formelement($id, $office_billing_address, $officeid);
        $data['address'] = create_form($address_fromelement, $office_billing_address, $id);
        $data['address_addform'] = form($data['address'], $address_fromelement, '', 'Management/users', 'office_address_details', '', '', base_url());
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Organisation', 'Management/organisation');
        $this->breadcrumbs->push('View Organisation', 'Management/organisationcommonview/MTA=');
        $this->breadcrumbs->push('Add Office Billing Address ', 'Management/addressadd');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'address');
    }
    //********************** get address list ***********************************/
    function get_address($org_id = '', $office_name = '')
    {
        $this->_check_featureauth('office', 'search');
        $model = array('Management_model' => 'getaddress');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        if ($office) {
            $condition[] = "c.office_name like '%" . urldecode(trim($office)) . "%' OR d.office_name like '%" . urldecode(trim($office)) . "%'";
        }
        if ($org_id) {
            $condition[] = "ad.organization = " . $org_id;
        }
        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {
                if (empty($row['parent_office'])) {
                    $poffice = $row['office_name'];
                    $office = '';
                } else {
                    $poffice = $row['parent_office'];
                    $office = $row['office_name'];
                }
                $response->rows[$i]['cell'] = array(
                    $i + $count + 1,
                    $row['org_name'],
                    anchor('/Management/officecommonview/' . base64_encode($row['id']), $poffice),
                    $office,
                    anchor('/Management/addressadd/' . base64_encode($this->uri->segment(3)) . '/' . base64_encode($row['id']), "Edit")
                );
            }
        }
        echo json_encode($response);
    }
    //******************** Candidate Deletion Form ********************/
    function candidatedelete()
    {
        $this->_check_featureauth('Candidate', 'delete');
        $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['candidate_details'] = $candidate = $this->mm->get_candidate($request_id);
        $this->amodel->pagerender($data, 'Candidatedelete');
    }
    //******************** Candidate Deletion function ********************/
    function cand_delete()
    {
        $id = $_POST['cid'];
        $reason = $_POST['reason'];
        $this->mm->cand_delete($id, $reason);
    }
    //*************** export of candidates for super admin and client admin ******************/
    function export_candidate()
    {

        $model = array('Management_model' => 'export_candidatelist');
        $office = ($_POST['exp_office_id']) ? $_POST['exp_office_id'] : '';
        $name = ($_POST['exp_name']) ? $_POST['exp_name'] : '';
        $uname = ($_POST['exp_uname']) ? $_POST['exp_uname'] : '';
        $organization = ($_POST['exp_org_id']) ? $_POST['exp_org_id'] : '';
        $parent_office = ($_POST['exp_parent_office']) ? $_POST['exp_parent_office'] : '';
        $sub_office = ($_POST['exp_sub_office']) ? $_POST['exp_sub_office'] : '';
        $client_ref_number = ($_POST['exp_client_ref_number']) ? $_POST['exp_client_ref_number'] : '';
        $case_number = ($_POST['exp_case_number']) ? $_POST['exp_case_number'] : '';
        $email_id = ($_POST['exp_email_id']) ? $_POST['exp_email_id'] : '';
        $term = ($_POST['exp_search_term']) ? $_POST['exp_search_term'] : '';
        $status = ($_POST['exp_status']) ? $_POST['exp_status'] : '';
        $type_of_employees = ($_POST['exp_type_of_employees']) ? $_POST['exp_type_of_employees'] : '';
        if ($office) {
            $condition[] = " a.office_id = " . $office;
        }
        if ($organization) {
            $condition[] = " a.organization = " . $organization;
        }
        if ($parent_office) {
            $condition[] = " a.parent_office = " . $parent_office;
        }
        if ($name) {
            $condition[] = " ( a.first_name like '%" . $name . "%' OR  a.last_name like '%" . $name . "%') ";
        }
        if ($uname) {
            $condition[] = " a.username like '%" . $uname . "%'";
        }
        if ($client_ref_number) {
            $condition[] = " h.client_ref_number like '%" . $client_ref_number . "%'";
        }
        //17/01/2024
        $case_number = trim($case_number);
        if ($case_number) {
            $condition[] = " h.case_no like '%" . $case_number . "'";
        }
        if ($sub_office) {
            $condition[] = " a.sub_office like '%" . $sub_office . "%'";
        }
        /* if($email_id){
            $condition[]=" a.email like '%".$email_id."%'";
        }*/
        if ($status == 1) {
            $condition[] = " a.status =1 ";
        }
        if ($status == 2) {
            $condition[] = " h.dataentry_by=0 and cv.client_status is NULL and a.status =0 ";
        }
        if ($status == 3 || $caseStatus == 'not_submitted') {
            $condition[] = " a.status =2 ";
        }
        if ($type_of_employees) {
            $condition[] = " a.type_of_employees = " . $type_of_employees;
        }
        if ($term) {
            $search = explode(' ', $term);
            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    $t        = substr($t, 1, strlen($t));
                }
                $like    = '';
                $like    .= "( a.middle_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.last_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " h.client_ref_number " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " h.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.username " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " h.check_status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " f.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " g.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " uc.telephone " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.email " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " s.office_name " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }
        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            if ($this->session->userdata('user_type') == 2) {
                $org_details = $this->amodel->getDetails(DB_PREFIX . "organisation", array('type_of_employ_candidate'), array('id' => $this->session->userdata('organization')));
            }
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Head Office");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Branch Office");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Sub Office");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Name");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Reference Number");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "User Name");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Email");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "Telephone");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Checks & Levels");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "Active / Deactive");
            if ($org_details[0]['type_of_employ_candidate'] == 1 || $this->session->userdata('user_type') == 1) {
                $objPHPExcel->getActiveSheet()->setCellValue('N1', "Type of Employees");
            }
            $cj = 2;
            foreach ($result as $i => $row) {
                if (empty($row['parent_office'])) {
                    $poffice = $row['office_name'];
                    $office = '';
                } else {
                    $poffice = $row['parent_office'];
                    $office = $row['office_name'];
                }
                $check_type = '';
                $total_chk = '';
                $checknames = '';
                $total_chk = $this->mm->getchecks($row['request_id']);
                foreach ($total_chk as $key => $ci) {
                    if ($ci['check_id'] > 94 && ($ci['check_id'] < 630 && $ci['check_id'] > 654))
                        $checknames[$ci['pack_id'] . '' . $ci['check_id']] = $ci['name'];
                    else {
                        $checknames[$ci['check_id']] = $ci['chk_count'] . ' ' . $ci['name'];
                    }
                }
                $chk = implode(' + ', $checknames);
                //$status=($row['status']==1)?'Active':'Deactive';  
                $status = (($row['status'] == 2)) ? 'NOT TO BE SUBMITTED TO DCODE' : (($row['status'] == 1) ? 'Active' : 'Deactive');
                $type_of_employees = '';
                $type_of_employees = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('name'), array('id' => $row['type_of_employees']));
                $objPHPExcel->getActiveSheet()->getStyle('A1:N1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $cj, ($i + $count + 1))
                    ->setCellValue('B' . $cj, $row['org_name'])
                    ->setCellValue('C' . $cj, $poffice)
                    ->setCellValue('D' . $cj, $office)
                    ->setCellValue('E' . $cj, $row['sub_office'])
                    ->setCellValue('F' . $cj, $row['name'])
                    ->setCellValue('G' . $cj, $row['case_no'])
                    ->setCellValue('H' . $cj, $row['client_ref_number'])
                    ->setCellValue('I' . $cj, $row['username'])
                    ->setCellValue('J' . $cj, $row['email'])
                    ->setCellValue('K' . $cj, $row['telephone'])
                    ->setCellValue('L' . $cj, $chk)
                    ->setCellValue('M' . $cj, $status);
                if ($org_details[0]['type_of_employ_candidate'] == 1 || $this->session->userdata('user_type') == 1) {
                    $objPHPExcel->getActiveSheet()->setCellValue('N' . $cj, $type_of_employees[0]['name']);
                }
                $cj++;
            }
            $this->export_excel('A', 'N', 'Candidate_List_', $objPHPExcel);
            exit;
        }
        redirect('Management/candidate');
    }
    //*********************** Candidate Edit Form ****************************/
    function editcandidate()
    {
        // print_r($_POST);exit;
        $this->load->helper('cloneform');
        $id = base64_decode($this->uri->segment(3));
        $title = "Create";
        $candidate_details = $this->amodel->getDetails(DB_PREFIX . "user", array('*'), array('id' => $id));
        $candidate_reqid = $this->amodel->getDetails(DB_PREFIX . "client_request", array('request_id', 'client_ref_number'), array('user_id' => $id));
        $cand_telephone = $this->amodel->getDetails(DB_PREFIX . "user_contact_details", array('telephone'), array('user_id' => $id));
        $candidate_details[0]['telephone'] = $cand_telephone[0]['telephone'];
        $candidate_details[0]['client_ref_number'] = $candidate_reqid[0]['client_ref_number'];
        $subtitle = "Modify";
        $this->mm->candidate_editdml($id);
        $candidatecheklist = $this->mm->get_candidatecheck($id);
        $formElement = $this->mm->candidate_editformelement($id, $candidate_details);
        $data['formelements'] = create_form($formElement, $candidate_details, $id);
        $data['candidate_details'] = $candidate_details;
        $data['table'] = form($data['formelements'], $formElement, '', 'Management/editcandidate', $subtitle, $auth_link, '', base_url());
        $data['message'] = '';
        $data['id'] = $id;
        $data['request_id'] = $candidate_reqid[0]['request_id'];
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Edit Candidate', 'Management/editcandidate');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'editcandidate');
    }

    function export_all_user()
    {


        $model = array('Management_model' => 'get_userlist');
        $office = ($_REQUEST['exp_office']) ? $_REQUEST['exp_office'] : '';
        $name = ($_REQUEST['exp_name']) ? $_REQUEST['exp_name'] : '';
        $uname = ($_REQUEST['exp_uname']) ? $_REQUEST['exp_uname'] : '';
        $role = ($_REQUEST['exp_role']) ? $_REQUEST['exp_role'] : '';
        $organization = ($_REQUEST['exp_org']) ? $_REQUEST['exp_org'] : '';
        $parent_office = ($_REQUEST['exp_parent_office']) ? $_REQUEST['exp_parent_office'] : '';
        $user_type = ($_REQUEST['exp_utype']) ? $_REQUEST['exp_utype'] : '';
        $created_on = ($_REQUEST['created_on']) ? $_REQUEST['created_on'] : '';
        $sub_office = ($_REQUEST['exp_sub_office']) ? $_REQUEST['exp_sub_office'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $f_date = ($_REQUEST['exp_f_date']) ? $_REQUEST['exp_f_date'] : '';
        $t_date = ($_REQUEST['exp_t_date']) ? $_REQUEST['exp_t_date'] : '';
        $date_filter = ($_REQUEST['exp_date_filter']) ? $_REQUEST['exp_date_filter'] : '';
        $status = ($_REQUEST['exp_status']) ? $_REQUEST['exp_status'] : '';
        if ($office) {
            $condition[] = " bo.branch_office = " . $office;
        }
        if ($organization) {
            $condition[] = " a.organization = " . $organization;
        }
        if ($parent_office) {
            $condition[] = " ho.parent_office = " . $parent_office;
        }
        if ($name) {
            $condition[] = " ( a.first_name like '%" . $name . "%' OR  a.last_name like '%" . $name . "%') ";
        }

        if ($uname) {
            $condition[] = " a.username like '%" . $uname . "%'";
        }
        if ($role) {
            $condition[] = " e.role_name like '%" . $role . "%'";
        }
        if ($user_type) {
            $condition[] = " e.user_type = " . $user_type;
        }
        if ($f_date && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(a.created_on ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($f_date)) . "'";
        }
        if ($t_date && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(a.created_on ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }
        if ($f_date && $date_filter == 2) {
            $condition[] = "DATE_FORMAT(a.last_activity ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($f_date)) . "'";
        }
        if ($t_date && $date_filter == 2) {
            $condition[] = "DATE_FORMAT(a.last_activity ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }
        if ($sub_office) {
            $condition[] = " so.sub_office = " . $sub_office;
        }
        if ($status == 1) {
            $condition[] = " a.status = 1";
        }
        if ($status == 2) {
            $condition[] = " a.status = 0";
        }
        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];


        if (!empty($result[0]['id'])) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;

            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Head Office");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Branch Office");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Sub Office");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Name");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Role");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "User Name");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Email");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Mobile");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "Created On");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Last Login Date");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "status");

            $ci = 2;
            foreach ($result as $i => $row) {
                if (empty($row['parent_office'])) {
                    $poffice = $row['office_name'];
                    $office = '';
                } else {
                    $poffice = $row['parent_office'];
                    $office = $row['office_name'];
                }
                if ($row['created_on']) {
                    $row['created_on'] = date('d-m-Y H:i:s', strtotime($row['created_on']));
                }
                if ($row['last_activity']) {
                    $row['last_activity'] = date('d-m-Y H:i:s', strtotime($row['last_activity']));
                }
                $status = ($row['status'] == 1) ? 'Active' : 'Deactive';
                $logged_inas = '';

                $objPHPExcel->getActiveSheet()->getStyle('A1:M1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i + $count + 1))
                    ->setCellValue('B' . $ci, $row['org_name'])
                    ->setCellValue('C' . $ci, $row['parent_office'])
                    ->setCellValue('D' . $ci, $row['office_name'])
                    ->setCellValue('E' . $ci, $row['sub_office'])
                    ->setCellValue('F' . $ci, $row['name'])
                    ->setCellValue('G' . $ci, $row['role_name'])
                    ->setCellValue('H' . $ci, $row['username'])
                    ->setCellValue('I' . $ci, $row['email'])
                    ->setCellValue('J' . $ci, $row['mobile'])
                    ->setCellValue('K' . $ci, $row['created_on'])
                    ->setCellValue('L' . $ci, $row['last_activity'])
                    ->setCellValue('M' . $ci, $status);

                $ci++;
            }
            $this->export_excel('A', 'M', 'User List', $objPHPExcel);
            exit;
        }
        redirect('Management/users');
    }

    function p_activateblukcandidate()
    {

        $id = $_POST['request_id'];
        $candidate_status =     $_POST['deo_status'];

        foreach ($id as  $value) {



            $ord_data = $this->amodel->getDetails(DB_PREFIX . "user", array('email', 'first_name', 'status'), array('id' => $value));



            $organization_data =        $ord_data[0];



            $cand_details = $this->amodel->getDetails(DB_PREFIX . "client_request", array('organisation', 'created_by'), array('user_id' => $value));


            $org = $this->amodel->getDetails(DB_PREFIX . "organisation", array('org_name', 'id', 'num_days_submit', 'logo'), array('id' => $cand_details[0]['organisation']));

            $num_days = isset($org[0]['num_days_submit']) ? $org[0]['num_days_submit'] : '5';
            $logo = isset($org[0]['logo']) ? $org[0]['logo'] : '';

            $data = array();
            $new_password = $this->randomString(10);

            $pwd =   md5($new_password);

            $data['new_password'] = $new_password;
            $data['first_name'] = $organization_data['first_name'];
            $data['email'] = $organization_data['email'];
            $data['org_name'] = $org[0]['org_name'];
            $client = $this->amodel->getDetails(DB_PREFIX . "user", array("email,CONCAT(first_name,' ',last_name) AS name"), array('id' => $cand_details[0]['created_by']));
            $data['cemail'] = $client[0]['email'];
            $data['cname'] = $client[0]['name'];
            $data['num_days'] = $num_days;
            $data['logo'] = $logo;



            $this->db->set(array('status' => $candidate_status, 'password' => $pwd));
            $this->db->where('id', $value);
            $this->db->update(DB_PREFIX . 'user');

            if ($organization_data['status'] == 0  && $candidate_status == 1) {

                send_email_candidateadd('candidate_reactive', 'Background Verification Login Reactivation @' . $data['org_name'], @$organization_data['email'], @$client[0], $data);
            }
        }
        redirect('Management/candidate');
    }

    function candidatedit()
    {
        $this->load->helper('cloneform');
        $id = base64_decode($this->uri->segment(3));
        $subtitle = "Modify";
        $candidate_details = $this->amodel->getDetails(DB_PREFIX . "user", array('*'), array('id' => $id));

        $formElement = $this->mm->candidate_editform($id, $candidate_details);
        $data['formelements'] = create_form($formElement, $candidate_details, $id);
        $data['candidate_details'] = $candidate_details;
        $data['table'] = form($data['formelements'], $formElement, '', 'Management/candidate', $subtitle, $auth_link, '', base_url());
        if ($mess) {
            $data['message'] = $mess;
        } else {
            $data['message'] = '';
        }
        $data['request_id'] = $cand_userdetais[0]['request_id'];
        $data['id'] = $id;
        $data['type_of_employees'] = $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'type_of_employees'));
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Candidate', 'Management/candidate');
        $this->breadcrumbs->push('Modify Candidate', 'Management/candidatedit');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, '');
    }

    function editonlinereq()
    {
        $formData = $this->security->xss_clean($_POST);
        $rolesid = $this->session->userdata('role_id');

        $user_id = $formData['user_id'];
        $cand_data['first_name'] = $formData['first_name'];
        $cand_data['middle_name'] = $formData['middle_name'];
        $cand_data['last_name'] = $formData['last_name'];
        $cand_data['updated_by'] = $this->session->userdata['userid'];
        $cand_data['updated_on'] = date('Y-m-d H:i:s');

        $this->db->where('id', $user_id);
        $this->db->update(DB_PREFIX . 'user', $cand_data);

        $client_data['candidate_name'] = $formData['first_name'] . ' ' . $formData['middle_name'] . ' ' . $formData['last_name'];
        $client_data['updated_by'] = $this->session->userdata['userid'];
        $client_data['updated_on'] = date('Y-m-d H:i:s');

        $this->db->where('user_id', $user_id);
        $this->db->update(DB_PREFIX . 'client_request', $client_data);
        if ($rolesid == 3) {
            redirect('Vsupervisor/case_status');
        } else {
            redirect('Client/client_caselist');
        }
    }


    //****** Listing of Package view page *******/
    function packages()
    {
        $this->_check_featureauth('users', 'search');
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Packages', 'Management/packages');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'package');
    }

    function creatpkg()
    {

        $sql = " Select * from " . DB_PREFIX . "group order by seq_id";
        $group_details = $this->db->query($sql)->result_array();
        $data['group'] = $group_details;

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Packages', 'Management/packages');
        $this->breadcrumbs->push('Add Package', 'Management/addpkg');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'package');
    }

    /******* Function addpackages*******
     ***********************************/
    function addpackages()
    {

        $loguser = $this->_check_featureauth('users', 'search');
        $formData = $_POST; //print_r($_POST);exit;
        if ($formData && !empty($formData['types_of_check'])) {

            $insert_package["parent"] = "0";
            $insert_package["seqid"] = "41";
            $insert_package["name"] = $_POST['package_name'];
            $insert_package["key"] = "package";
            $insert_package["ref_id"] = "0";
            $insert_package["function_name"] = "";
            $insert_package["status"] = "1";
            $insert_package["service"] = "0";
            $insert_package["level_details"] = "";
            $insert_package["short_name"] = "";
            $insert_package["created_by"] = $loguser;
            $insert_package["created_on"] = date('Y-m-d H:i:s');
            $insert_package["updated_by"] = $loguser;
            $insert_package["updated_on"] = date('Y-m-d H:i:s');

            $insert_package = $this->security->xss_clean($insert_package);
            $this->db->insert(DB_PREFIX . 'master_masterdata', $insert_package);
            $package_id = $this->db->insert_id();

            foreach ($formData['types_of_check'] as  $key => $chk) {
                $value = implode(',', $formData['acceptable_limit' . $chk]);

                if ($_POST['group' . $chk] == GROUPID_IDPROOF) {
                    $anycount = $_POST['anycount'];
                } else {
                    $anycount = 0;
                }

                $insert_array[] = array("group_id" => $_POST['group' . $chk], "package_id" => $package_id, "package_name" => $_POST['package_name'], "org_id" => $_POST['parentoffice_id'], "check_id" => $chk, "max_attempt" => $_POST['max_attempt' . $chk], "no_ofcheck" => $_POST['no_ofcheck' . $chk], "noof_year" => $_POST['noof_year' . $chk], "acceptable_limit" => $value, "checknotes" => $_POST['checknotes' . $chk], "pkg_cost" => $_POST['pkg_cost'], "pkg_notes" => $_POST['pkg_notes'], "mandatory" => $_POST['mandatory' . $chk], "anycount" => $anycount);
            }

            $this->db->insert_batch(DB_PREFIX . "packages", $insert_array);

            redirect('Management/packages');
        } else {
            //redirect('Management/creatpkg');  
            echo "<script type='text/javascript'>
            alert('Please select at least one check!');
            window.location.href='creatpkg';
            </script>";
        }
    }



    function get_package($office_id = 0)
    {
        $model = array('Management_model' => 'get_packagelistoff');

        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $package_name = ($_REQUEST['package_name']) ? $_REQUEST['package_name'] : '';

        if ($package_name) {
            $condition[] = " p.package_id =" . $package_name;
        }

        if ($org_id) {
            $condition[] = " p.org_id = " . $org_id;
        }

        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {

                $this->db->select('m.name,p.no_ofcheck');
                $this->db->where('package_id', $row['package_id']);
                $this->db->join(DB_PREFIX . 'packages p', 'm.id=p.check_id', 'left');
                $check_list = $this->db->get(DB_PREFIX . "master_masterdata m")->result_array();

                $this->db->select('level');
                $this->db->where('types_of_check', $row['package_id']);
                $packageId = $this->db->get(DB_PREFIX . "add_check")->result_array();
                //print_r($packageId);exit;
                if (empty($packageId)) {
                    $edit = ' / ' . anchor('/Management/editpackage/' . base64_encode($row['package_id']), "Edit", "style='color:green;'");
                    $Del = ' / ' . anchor('/Management/deletepackage/' . base64_encode($row['package_id']), "Delete", "style='color:red;'");
                } else {
                    $edit = ' / ' . anchor('/Management/copypackage/' . base64_encode($row['package_id']), "Copy", "style='color:#ff7e00;'");
                    $Del = '';
                }

                $checkname = '' || $checkname = [];
                $j = 1;
                foreach ($check_list as $cval) {
                    $checkname[] = '<div style="padding:3px;">' . $j . '. ' . $cval['name'] . $no_ofcheck . '</div>';
                    $j++;
                }
                $check_list = implode(" ", $checkname);

                $response->rows[$i]['cell'] = array(
                    $i + $count + 1,
                    $row['org_name'],
                    $row['package_name'],
                    $check_list,
                    $row['pkg_cost'],
                    $row['pkg_notes'],
                    anchor('/Management/packageview/' . base64_encode($row['package_id']), "View", "style='color:#08c;'") . $edit . $Del
                );
            }
        }
        echo json_encode($response);
    }

    //************ Candidate View Page **************/
    function packageview()
    {
        $id = base64_decode($this->uri->segment(3));

        $packagedetails = $this->mm->getpackage($id);
        $data['package'] = $packagedetails;

        $data['auth_link'] = array(
            array('candidate', 'search', 'Search', 'Management/packages', '')
        );
        $data['title'] = "packages";
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Package', 'Management/packages');
        $this->breadcrumbs->push('View Package', 'Management/packageview');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, $data['title']);
    }

    /******* Edit Package ******
     ****editpackage function****/

    function editpackage()
    {

        $id = base64_decode($this->uri->segment(3));

        $package = $this->mm->getpackage($id);
        $data['package'] = $package;

        $packagedetails = $this->mm->getpackagedetails($id);
        $data['package_details'] = $packagedetails;

        $data['title'] = "Modify";
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Packages', 'Management/packages');
        $this->breadcrumbs->push('Modify Package', 'Management/editpackage');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, $data['title']);
    }

    /****** Delete Pacjkage ****
     ****remove_Package function*
     *****************************/
    function remove_Package()
    {
        $id = $_POST['check_id'];
        $sql = $this->db->query('delete from ' . DB_PREFIX . 'packages where id = "' . $id . '"');

        echo $id;
    }

    /******* Update Package*******
     ***** function updatepackage***
     *******************************/

    function updatepackage($id)
    {
        $package_id = base64_decode($id);

        $formData = $_POST;  //print_r($formData);exit;

        if (!empty($formData)) {

            $this->db->set('name', $_POST['package_name']);
            $this->db->where('id', $package_id);
            $this->db->update(DB_PREFIX . 'master_masterdata');

            $this->db->where('package_id', $package_id);
            $this->db->delete(DB_PREFIX . 'packages');

            foreach ($formData['types_of_check'] as  $chk) {
                $value = implode(',', $formData['acceptable_limit' . $chk]);

                if ($chk == 631 || $chk == 632 || $chk == 633 || $chk == 634 || $chk == 635) {
                    $anycount = $_POST['anycount'];
                } else {
                    $anycount = 0;
                }

                $insert_array[] = array("group_id" => $_POST['group' . $chk], "package_id" => $package_id, "package_name" => $_POST['package_name'], "org_id" => $_POST['parentoffice_id'], "check_id" => $chk, "max_attempt" => $_POST['max_attempt' . $chk], "no_ofcheck" => $_POST['no_ofcheck' . $chk], "noof_year" => $_POST['noof_year' . $chk], "acceptable_limit" => $value, "checknotes" => $_POST['checknotes' . $chk], "pkg_cost" => $_POST['pkg_cost'], "pkg_notes" => $_POST['pkg_notes'], "mandatory" => $_POST['mandatory' . $chk], "anycount" => $anycount);
            }

            $this->db->insert_batch(DB_PREFIX . "packages", $insert_array);
        }
        redirect('Management/packages');
    }

    /******* Copy Package ******
     ****copypackage function****/

    function copypackage()
    {

        $id = base64_decode($this->uri->segment(3));

        $packagedetails = $this->mm->getpackagecopy($id);
        $data['package_details'] = $packagedetails;

        $data['title'] = "Duplicate";
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Packages', 'Management/packages');
        $this->breadcrumbs->push('Duplicate Package', 'Management/copypackage');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, $data['title']);
    }


    /**********************
     ***** Delete Package **
    function deletepackage */

    function deletepackage()
    {

        $pid = base64_decode($this->uri->segment(3));

        $sql = $this->db->query('delete from ' . DB_PREFIX . 'packages where package_id = "' . $pid . '"');
        $sql = $this->db->query('delete from ' . DB_PREFIX . 'master_masterdata where id = "' . $pid . '"');
        redirect('Management/packages');
    }


    //****** Listing of TAT view page *******/
    function tats()
    {
        $this->_check_featureauth('users', 'search');

        $getoffices = $this->db->query("select id,org_name from " . DB_PREFIX . "organisation where org_status=1 order by org_name asc")->result_array();
        $data['getoffices'] = $getoffices;

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('TAT', 'Management/tats');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'tats');
    }


    //****** Creation of TATS page *******/
    function create_tat()
    {

        $getoffices = $this->db->query("select id,org_name from " . DB_PREFIX . "organisation where org_status=1 AND id NOT IN(SELECT DISTINCT(org_id) as org_id FROM " . DB_PREFIX . "customer_tat ) order by org_name asc")->result_array();
        $data['getoffices'] = $getoffices;

        $tat_details = $this->amodel->getDetails(DB_PREFIX . "customer_tat", array('DISTINCT(org_id) org_id', 'tat_type'), array('tat_type' => 1));
        $data['tat_details'] = $tat_details;

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('TAT', 'Management/tats');
        $this->breadcrumbs->push('ADD TAT', 'Management/create_tat');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'tats');
    }


    /*********ADD TAT *******
    Function add_tat
     *************************/
    function add_tat()
    {

        $loguser = $this->_check_featureauth('users', 'search');
        $formData = $_POST;
        //echo '<pre>';print_r($formData);exit;
        if (!empty($formData['parentoffice_id'])) {

            $effective_from_date = date('Y-m-d', strtotime($formData['effective_from_date']));
            $tat_type = 2;
        } else {
            $effective_from_date = date('Y-m-d', strtotime('01-06-2017'));
            $tat_type = 1;
        }

        $effective_to_date = TAT_ETD;

        if ($formData) {

            foreach ($formData['check_id'] as  $key => $chk) {

                $insert_array[] = array("org_id" => $formData['parentoffice_id'], "check_id" => $chk, "check_tat" => $formData['check_tat' . $chk], "dataentry_tat" => $formData['dataentry_tat' . $chk], "verification_tat" => $formData['verification_tat' . $chk], "qc_tat" => $formData['qc_tat' . $chk], "effective_from_date" => $effective_from_date, "effective_to_date" => $effective_to_date, "tat_status" => '1', "tat_type" => $tat_type);
            }

            $this->db->insert_batch(DB_PREFIX . "customer_tat", $insert_array);
            redirect('Management/tats');
        }
    }



    /*************Get TAT List *********
     ***** function 
     *************************************/
    function get_tat($office_id = 0)
    {
        $model = array('Management_model' => 'get_tatlist');

        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $tat_type = ($_REQUEST['tat_type']) ? $_REQUEST['tat_type'] : '';

        if ($tat_type == 1) {
            $condition[] = " c.tat_type =" . $tat_type;
        }

        if ($org_id) {
            $condition[] = " c.org_id = " . $org_id;
        }

        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1]; //print_r($result);exit;
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {

                if ($row['org_id'] == 0) {
                    $organization = "Standard";
                } else {
                    $organization = $row['org_name'];
                }

                $response->rows[$i]['cell'] = array($i + $count + 1, $organization, anchor('/Management/tatview/' . base64_encode($row['org_id']), "View ") . '/ ' . anchor('/Management/tatedit/' . base64_encode($row['org_id']), "Edit"));
            }
        }
        echo json_encode($response);
    }

    //************ Tat View Page **************/
    function tatview()
    {

        $data['auth_link'] = array(
            array('candidate', 'search', 'Search', 'Management/tats', '')
        );

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('TAT', 'Management/tats');
        $this->breadcrumbs->push('View TAT', 'Management/tatview');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data);
    }

    /********** Tat Viewpage Filter*******
     ******* function tatviewlist *********
     *************************************/
    function tatviewlist()
    {

        $org_id = $_POST['org_id'];
        $tat_status = $_POST['tat_status'];

        $tatdetails = $this->mm->gettats($org_id, $tat_status);
        $i = 1;
        foreach ($tatdetails as $taValue) {
            $tat_status = $taValue['tat_status'] == 1 ? 'Active' : 'Inactive';

            $html .= '<tr class="at_tr" height="35">
                    <td  class="at_td" style="color:#022151;width:600px;">' . $i . ". " . $taValue["name"] . '</td>
                    <td  class="at_td" style="width:50px;">' . date("d-m-Y", strtotime($taValue["effective_from_date"])) . '</td>
                    <td  class="at_td" style="width:50px;">' . date("d-m-Y", strtotime($taValue["effective_to_date"])) . '</td>
                    <td  class="at_td" style="width:50px;text-align:right;padding: 5px;">' . $taValue["check_tat"] . '</td>
                    <td  class="at_td" style="width:50px;text-align:right;padding: 5px;">' . $taValue["dataentry_tat"] . '</td>
                    <td  class="at_td" style="width:50px;text-align:right;padding: 5px;">' . $taValue["verification_tat"] . '</td>
                    <td  class="at_td" style="width:50px;text-align:right;padding: 5px;">' . $taValue["qc_tat"] . '</td>
                    <td  class="at_td" style="width:50px;">' . $tat_status . '</td>
                </tr>';
            $i++;
        }
        echo $html;
    }


    /******* Edit TAT ******
     ****tatedit function****/

    function tatedit()
    {

        $data['id'] = $id = base64_decode($this->uri->segment(3));

        $tatdetails = $this->mm->getorgazation($id);
        $data['tat_details'] = $tatdetails;

        $ordercheck = $this->mm->get_ordercheck($id);

        if (!empty($ordercheck)) {
            $this->db->select('created_on');
            $this->db->where('id', $id);
            $this->db->where('org_status', '1');
            $resdate = $this->db->get(DB_PREFIX . "organisation ")->result_array();
            $EFD = $resdate[0]['created_on'];

            $effective_from_date = date('Y-m-d', strtotime($EFD));
            $effective_to_date = TAT_ETD;
            $tat_type = 2;

            foreach ($ordercheck as $row) {
                $checkId = $row['id'];
                $insert_array[] = array("org_id" => $id, "check_id" => $checkId, "check_tat" => '', "effective_from_date" => $effective_from_date, "effective_to_date" => $effective_to_date, "tat_status" => '1', "tat_type" => $tat_type);
            }
            $this->db->insert_batch(DB_PREFIX . "customer_tat", $insert_array);
        }

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('TAT', 'Management/tats');
        $this->breadcrumbs->push('Modify TAT', 'Management/tatedit');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data);
    }


    /*********Update TAT *******
    Function update_tat
     *************************/
    function update_tat()
    {

        $loguser = $this->_check_featureauth('users', 'search');
        $formData = $_POST; //echo '<pre>';print_r($formData);exit;
        $org_id = $formData['parentoffice_id'];

        if (!empty($formData['parentoffice_id'])) {
            $tat_type = 2;
        } else {
            $tat_type = 1;
        }

        $sql = $this->db->query('delete from ' . DB_PREFIX . 'customer_tat where org_id = "' . $org_id . '" AND check_tat=0 ');

        $effectivetodate = TAT_ETD;

        if ($formData) {

            foreach ($formData['check_id'] as  $key => $chk) {
                if (!empty($_POST['effective_from_date' . $chk])) {
                    $effective_to_date = date('Y-m-d', strtotime($formData['effective_from_date' . $chk] . ' - 1 day'));
                    $effective_from_date = date('Y-m-d', strtotime($formData['effective_from_date' . $chk]));

                    $where = '(org_id="' . $formData['parentoffice_id'] . '" AND check_id = "' . $chk . '" AND tat_status=1)';
                    $this->db->set('effective_to_date', $effective_to_date);
                    $this->db->set('tat_status', 0);
                    $this->db->where($where);
                    $this->db->update(DB_PREFIX . 'customer_tat');

                    $insert_array[] = array("org_id" => $formData['parentoffice_id'], "check_id" => $chk, "check_tat" => $formData['check_tat' . $chk], "dataentry_tat" => $formData['dataentry_tat' . $chk], "verification_tat" => $formData['verification_tat' . $chk], "qc_tat" => $formData['qc_tat' . $chk], "effective_from_date" => $effective_from_date, "effective_to_date" => $effectivetodate, "tat_status" => '1', "tat_type" => $tat_type);
                }
            }

            $this->db->insert_batch(DB_PREFIX . "customer_tat", $insert_array);
            redirect('Management/tats');
        }
    }

    //********* export organization list *********************/  
    function export_inactive_organization()
    {
        $model = array('Management_model' => 'getinactive_organization');
        if ($_REQUEST['exp_a_date']) {

            // $condition[]="DATE_FORMAT(b.case_recieved_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($_REQUEST['exp_a_date']))."' AND DATE_FORMAT(b.case_accepted_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($_REQUEST['exp_a_date']))."' AND DATE_FORMAT(b.max_created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($_REQUEST['exp_a_date']))."'";

            $condition[] = "a.id NOT IN (SELECT organisation FROM dcode_client_request WHERE DATE_FORMAT(b.max_created_on ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($_REQUEST['exp_a_date'])) . "')";
        }
        if ($_REQUEST['exp_org_status']) {
            $condition[] = " a.org_status like '%" . $_REQUEST['exp_org_status'] . "%'";
        }

        $manual_cond = implode(' and ', (array)$condition);
        // echo "hi";
        $results = $this->_jqgrid_search($model, $manual_cond);

        $response = $results[0];

        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Organization Status");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Last Created Date");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "First Case Received Date");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "First Case Accepted Date");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Last Case Received Date");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Last Case Accepted Date");
            $ci = 2;

            foreach ($result as $i => $row) {

                $org_status = ($row['org_status'] == 1) ? 'Active' : 'Deactive';

                $MinAcceptedDate = '';
                $MinReceivedDate = '';
                if ($row['dataentry_by'] == 3 && $row['mincase_recieved_date'] != "0000-00-00" && !empty($row['mincase_recieved_date'])) {
                    $MinReceivedDate = date('d-m-Y ', strtotime($row['mincase_recieved_date']));
                } else if ($row['dataentry_by'] != 3 && $row['mincase_accepted_date'] != "0000-00-00 00:00:00" && !empty($row['mincase_accepted_date'])) {
                    $MinAcceptedDate = date('d-m-Y', strtotime($row['mincase_accepted_date']));
                }

                $AcceptedDate = '';
                $ReceivedDate = '';
                if ($row['dataentry_by'] == 3 && $row['case_recieved_date'] != "0000-00-00" && !empty($row['case_recieved_date'])) {
                    $case_recieved_date = date('d-m-Y ', strtotime($row['case_recieved_date']));
                    $created_on = date('d-m-Y ', strtotime($row['created_on']));

                    $lastcasereceived_date =  ($case_recieved_date > $created_on) ? $case_recieved_date :  $created_on;

                    $ReceivedDate = $lastcasereceived_date;
                } else if ($row['dataentry_by'] != 3 && $row['case_accepted_date'] != "0000-00-00 00:00:00" && !empty($row['case_accepted_date'])) {
                    $AcceptedDate = date('d-m-Y', strtotime($row['case_accepted_date']));
                }
                if ($row['max_created_on']) {
                    $createdOn = date('d-m-Y', strtotime($row['max_created_on']));
                } else {
                    $createdOn = '';
                }
                $objPHPExcel->getActiveSheet()->getStyle('A1:H1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i + $count + 1))
                    ->setCellValue('B' . $ci, $row['org_name'])
                    ->setCellValue('C' . $ci, $org_status)
                    ->setCellValue('D' . $ci, $createdOn)
                    ->setCellValue('E' . $ci, $MinReceivedDate)
                    ->setCellValue('F' . $ci, $MinAcceptedDate)
                    ->setCellValue('G' . $ci, $ReceivedDate)
                    ->setCellValue('H' . $ci, $AcceptedDate);
                $ci++;
            }
            $this->export_excel('A', 'H', 'NotActiveOrganization_List_', $objPHPExcel);
            exit;
        }
        redirect('Management/organisation');
    }



    /**************************VIEW PAGE**********************************

Target Add By Amritha 
          ON :20/01/2023      */

    function addTarget()
    {
        $formData = $_POST;
        $user_id = base64_decode($this->uri->segment(3));
        $formData['user_id'] = $user_id;
        $this->mm->target_add($formData);
    }



    //********************* ADD AND EDIT TARGET***********************/
    function target_add()
    {
        $this->load->helper('cloneform');
        $key = $this->amodel->fetchreportDropdown('dcode_master_masterdata', array('id', 'name'), array('key' => 'Check'), 'Select');
        $user_id = base64_decode($this->uri->segment(3));
        $data['user_det'] = $this->db->query("select concat_ws(' ', first_name,last_name) as user from " . DB_PREFIX . "user where id = " . $user_id)->row();

        $data['auth_link'] = array(array('users', 'search', 'Search', 'Management/users'));


        $data['get_target'] = $this->mm->check_target($user_id);

        if ($data['get_target']) {
            $data['upload_file'] = "Update Target";
        } else {
            $data['upload_file'] = "Add Target";
        }

        $this->amodel->pagerender($data, 'target_add');
    }
    //********************* END TARGET***********************/


    /*****************
     * Bulk Download list page
     * bulk_download Case List
     ******************/
    function bulk_download()
    {
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Bulk Download', $this->bulk_download);
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'bulk_download');
    }


    /*****************
     * client bulk listing.
     * get_bulklist
     ******************/
    function get_bulklist()
    {
        // print_r($_REQUEST);exit;

        $model = array('Management_model' => 'get_bulklist');

        $org_id = ($_REQUEST[$this->request_orgid]) ? $_REQUEST[$this->request_orgid] : '';
        $office = ($_REQUEST[$this->request_office]) ? $_REQUEST[$this->request_office] : '';
        $parent_office = ($_REQUEST[$this->request_parent_office]) ? $_REQUEST[$this->request_parent_office] : '';
        $sub_office = ($_REQUEST[$this->request_sub_office]) ? $_REQUEST[$this->request_sub_office] : '';
        $date_filter = ($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
        $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';



        if ($parent_office) {
            $condition[] = " d.id = " . $parent_office;
        }
        if ($office) {
            $condition[] = " b.id = " . $office;
        }
        if ($org_id) {
            $condition[] = " c.id = " . $org_id;
        }
        if ($sub_office) {
            $condition[] = " o.id = " . $sub_office;
        }

        if (!empty($c_date) && $date_filter == 1) {
            $condition[] = " case when a.dataentry_by=3 Then DATE_FORMAT(a.case_recieved_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "' else DATE_FORMAT(a.case_accepted_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "' end ";
        }
        if (!empty($t_date) && $date_filter == 1) {
            $condition[] = " case when a.dataentry_by=3 Then DATE_FORMAT(a.case_recieved_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "' else DATE_FORMAT(a.case_accepted_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "' end ";
        }

        if (!empty($c_date) && !empty($t_date) && $date_filter == 2) {
            $condition[] = "((((DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "' and a.final_report=1)  and (DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "' and a.final_report=1) and a.supplement_report <>1)) OR (DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "' and a.supplement_report=1)  and (DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "' and a.supplement_report=1)) and cv.verification_status=1 ";
        }

        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {

            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            // echo '<pre>';print_r($result);exit;
            foreach ($result as $i => $row) {

                $role = $this->session->userdata('user_type');
                $payment_status =  $row['payment_status'];
                // $checkstatus = $this->cm->get_currentstatus($row['request_id']); 
                $verifiedlevelstatus = $this->cm->get_verifiedlevelstatus($row['request_id']);

                if ($row['parent'] == 0) {
                    $officevalue = $row[$this->request_parent_office];
                    $branchofficevalue = $row['office_name'];
                } else if ($row['parent'] != 0) {
                    $officevalue = $row['office_name'];
                    $branchofficevalue = $row[$this->request_parent_office];
                }


                // $pending_checksa = $this->rm->getchecksverify($row['request_id']);
                $finalreport_checksa = $this->rm->getcountcheck($row['request_id']);
                $count_pending_checksa = $this->rm->getcountchecksverify($row['request_id']);
                $count_date_checksa = $this->rm->getfinalupdateedate($row['request_id']);

                $namw = count($finalreport_checksa);
                $sum = 0;
                foreach ($count_pending_checksa as $count_pending_val) {
                    $sum += $count_pending_val['no_checks'];
                }
                $report = '';
                if (!empty($verifiedlevelstatus['qc2fielddata'])) {
                    if ($sum <= $namw) {
                        $status = 'Report Published';
                        if ($role <> 1 && $payment_status == 948 && $row['final_report'] == 1 && $row['supplement_report'] != 1) {
                            $report = '<a href="#" onclick="myFunction(); return false;"> Final </a>';
                        } else {
                            if ($row['final_report'] == 1 && $row['supplement_report'] != 1) {
                                $report = anchor('/Reports/candidate_reports_view/' . base64_encode($row['request_id']) . '/' . base64_encode(1) . '/' . base64_encode(2) . '/' . base64_encode(3) . '/' . base64_encode($count_date_checksa['created_date']), "Final", 'target=_blank');
                            }
                        }
                    } else {
                        $report = '';
                    }
                } else {
                    $report = '';
                }
                /* supplementary report */

                if ($row['supplement_report'] == 1) {
                    $freport = $this->db->query("select report_name from " . DB_PREFIX . "finalreportpublished 
            where request_id=" . $row['request_id'] . " LIMIT 1 ")->row_array();
                    if ($role <> 1 && $payment_status == 948) {

                        if ($row['final_report'] == 1 && $row['supplement_report'] == 1) {
                            $report = '<a href="#" onclick="myFunction(); return false;"> Supplement </a>';
                        } else {
                            $report = '<a href="#" onclick="myFunction(); return false;"> Final </a>';
                        }
                    } else {
                        if ($row['final_report'] == 1 && $row['supplement_report'] == 1) {
                            $report = anchor('/Reports/candidate_reports_view/' . base64_encode($row['request_id']) . '/' . base64_encode(1) . '/' . base64_encode(2) . '/' . base64_encode(3) . '/' . base64_encode($count_date_checksa['created_date']), "Supplement", 'target=_blank');
                        } else if ($row['supplement_report'] == 1) {
                            $report = anchor('/Reports/candidate_reports_view/' . base64_encode($row['request_id']) . '/' . base64_encode(1) . '/' . base64_encode(2) . '/' . base64_encode(3) . '/' . base64_encode($count_date_checksa['created_date']), "Supplement", 'target=_blank');
                        } else {
                            $report = anchor(('/uploads/finalreport/' . $freport['report_name']), "Final", 'target=_blank');
                        }
                    }
                }
                if ($row['supplement_report'] == 2) {
                    $freport = $this->db->query("select report_name from " . DB_PREFIX . "finalreportpublished 
        where request_id=" . $row['request_id'] . "  LIMIT  1 ")->row_array();
                    if ($role <> 1 && $payment_status == 948) {
                        $report = '<a href="#" onclick="myFunction(); return false;"> Final </a>';
                    } else if ($sum <= $namw) {
                        $report = anchor(('/uploads/finalreport/' . $freport['report_name']), "Final", 'target=_blank');
                    }

                    $$report = '';
                }
                $finalPublishDate = ($row['final_report_published_date']) ? date('d-m-Y', strtotime($row['final_report_published_date'])) : '';
                $supplementDate = ($row['supplement_report_date']) ? date('d-m-Y', strtotime($row['supplement_report_date'])) : '';

                if ($row['dataentry_by'] != 3 && $row['case_accepted_date'] != "0000-00-00 00:00:00" && !empty($row['case_accepted_date'])) {
                    $Accepted_on = date('d-m-Y', strtotime($row['case_accepted_date']));
                } else if ($row['dataentry_by'] == 3 && $row['case_recieved_date'] != "0000-00-00" && !empty($row['case_recieved_date'])) {
                    $Accepted_on = date('d-m-Y', strtotime($row['case_recieved_date']));
                } else {
                    $Accepted_on = '';
                }

                $response->rows[$i]['cell'] = array($i + $count + 1, $row['org_name'], $officevalue, $branchofficevalue, $row[$this->request_sub_office], anchor('/Dadmin/dadminview/' . base64_encode($row['request_id']), $row['candidate_name']), $row['case_no'], $report, $Accepted_on, $finalPublishDate, $supplementDate, $row['email']);
            }
        }
        echo json_encode($response);
    }

    /****************************************
     ******** Download Bulk List *************
     ****** function download_bulklist *******
     *****************************************/
    function download_bulklist()
    {
        // print_r($_POST);
        $model = array('Management_model' => 'get_download_bulklist');

        $date_filter = ($_REQUEST['bd_date_filter']) ? $_REQUEST['bd_date_filter'] : '';
        $c_date = ($_POST['bd_c_date']) ? $_POST['bd_c_date'] : '';
        $t_date = ($_POST['bd_t_date']) ? $_POST['bd_t_date'] : '';
        $office = ($_POST['bd_office_id']) ? $_POST['bd_office_id'] : '';
        $parent_office = ($_POST['bd_parent_office']) ? $_POST['bd_parent_office'] : '';
        $sub_office = ($_POST['bd_sub_office']) ? $_POST['bd_sub_office'] : '';

        if ($parent_office) {
            $condition[] = " d.id = " . $parent_office;
        }
        if ($office) {
            $condition[] = " b.id = " . $office;
        }
        if ($org_id) {
            $condition[] = " c.id = " . $org_id;
        }
        if ($sub_office) {
            $condition[] = " o.id = " . $sub_office;
        }

        if (!empty($c_date) && $date_filter == 1) {
            $condition[] = " case when a.dataentry_by=3 Then DATE_FORMAT(a.case_recieved_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "' else DATE_FORMAT(a.case_accepted_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "' end ";
        }
        if (!empty($t_date) && $date_filter == 1) {
            $condition[] = " case when a.dataentry_by=3 Then DATE_FORMAT(a.case_recieved_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "' else DATE_FORMAT(a.case_accepted_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "' end ";
        }

        if (!empty($c_date) && !empty($t_date) && $date_filter == 2) {
            $condition[] = "((((DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "' and a.final_report=1)  and (DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "' and a.final_report=1) and a.supplement_report <>1)) OR (DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "' and a.supplement_report=1)  and (DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "' and a.supplement_report=1)) and cv.verification_status=1 ";
        }


        $manual_cond = implode(' and ', $condition);

        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];

        // echo '<pre>'; print_r($result); exit;

        $i = 0;
        foreach ($result as $row) {
            $i++;

            $requestId = $row['request_id'];

            $count_date_checksa = $this->rm->getfinalupdateedate($requestId);
            $createdDate = $count_date_checksa['created_date'];
            $interim = base64_encode($createdDate);
            $qccheck = "client";

            $pdfresult = $this->pdfexport->generate_pdf($requestId, $interim, $qccheck, 'export');
            $candidate_info = $this->rm->get_candidateionfo($requestId);
            $candidate_info['candidate_name'] = rtrim(($candidate_info['candidate_name']), '.');


            $html = $pdfresult['html'];
            $pdf = (object)$html;
            require_once("./dom_pdf/dompdf_config.inc.php");
            $dompdf = new DOMPDF();
            $dompdf->load_html($html);
            $dompdf->render();
            $canvas = $dompdf->get_canvas();

            $font = Font_Metrics::get_font("Times New Roman", "oblique");

            $canvas->page_text(
                500,
                780,
                "Confidential {PAGE_NUM} / {PAGE_COUNT}",
                $font,
                10,
                array(0, 0, 0)
            );
            $client_ref_number = ($candidate_info['client_ref_number']) ? "_" . $candidate_info['client_ref_number'] : '';
            $filename = $candidate_info['candidate_name'] . "_" . date('d_m_Y ', strtotime(base64_decode($interim))) . "_" . $candidate_info['case_no'] . $client_ref_number . '_' . $i . ".pdf";


            $output1 = $dompdf->output($filename);
            file_put_contents(getcwd() . "/uploads/reports_pdf/" . $filename, $output1);
            chmod($filename, 755);

        }

        if (empty($result)) {
            echo "<script type='text/javascript'>alert('No published records to download')</script>";
        }

        ob_start();
        $zip = new ZipArchive;
        $zip_name = "uploads/reports_pdf/Bulk_Download.zip";
        $zip->open($zip_name,  ZipArchive::CREATE);

        $srcDir = "uploads//reports_pdf//"; //location of the directory
        $files = scandir($srcDir);
        unset($files[0], $files[1]);

        foreach ($files as $file) {
            $path = "uploads/reports_pdf/" . $file;

            if (file_exists($path)) {

                if (strpos($file, "OLD_") !== 0) {

                    $pathforFile = "uploads/reports_pdf/" . $file;
                    $zip->addFromString(basename($path), file_get_contents($pathforFile));
                    rename("uploads/reports_pdf/" . $file, "uploads/reports_pdf/" . "OLD_" . $file);
                }
            } else {
                echo "file does not exist";
            }
        }
        // exit;
        $zip->close();

        if (headers_sent()) {
            echo 'HTTP header already sent';
        } else {

            header($_SERVER['SERVER_PROTOCOL'] . ' 200 OK');
            header("Content-Type: application/zip");
            header("Content-Length: " . filesize($zip_name));
            header("Content-Disposition: attachment; filename=" . basename($zip_name));
            while (ob_get_level()) {
                ob_end_clean();
            }
            readfile($zip_name);
            rename("uploads/reports_pdf/Bulk_Download.zip", "uploads/reports_pdf/OLD_Bulk_Download.zip");
        }

        redirect('Management/bulk_download');
    }


    /*****************
     * add_qctarget page
     ******************/
    function add_qctarget()
    {

        $user_id = base64_decode($this->uri->segment(3));
        $data['user_details'] = $this->db->query("select concat_ws(' ', first_name,last_name) as user from " . DB_PREFIX . "user where id = " . $user_id)->row();

        $data['auth_link'] = array(array('users', 'search', 'Search', 'Management/users'));
        $data['get_target'] = $this->mm->get_qctarget($user_id);

        if ($data['get_target']) {
            $data['usertarget'] = "Update Target";
        } else {
            $data['usertarget'] = "Add Target";
        }

        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Add Target', $this->bulk_download);
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'add_qctarget');
    }

    function addqcTarget()
    {

        $formData = $_POST;
        $user_id = base64_decode($this->uri->segment(3));
        $role_id = base64_decode($this->uri->segment(4));

        $where = '(user_id="' . $user_id . '" AND role_id = "' . $role_id . '")';
        $this->db->select('id');
        $this->db->where($where);
        $this->db->order_by('id', 'desc');
        $lastRow = $this->db->get(DB_PREFIX . 'user_target_dynamic')->row_array();

        if (!empty($lastRow)) {
            $curDate = date('Y-m-d');
            $prev_date = date('Y-m-d', strtotime($curDate . ' -1 day'));
            $this->db->set('status', 0);
            $this->db->set('to_date', $prev_date);
            $this->db->set('last_update_date', $curDate);
            $this->db->where('id', $lastRow['id']);
            $this->db->update(DB_PREFIX . 'user_target_dynamic');
        }

        $insert['user_id'] = $user_id;
        $insert['role_id'] = $role_id;
        $insert['target'] = $formData['target'];
        $insert['from_date'] = date('Y-m-d H:i:s');
        $insert['created_by'] = $this->session->userdata['userid'];
        $insert['created_on'] = date('Y-m-d');
        $insert['status'] = 1;
        $this->db->insert(DB_PREFIX . 'user_target_dynamic', $insert);
        redirect(base_url('Management/userscommonview/' . $this->uri->segment(3)), 'refresh');
    }


    //************ File Attachment Page **************/
    function file_attachment()
    {

        $data['auth_link'] = array(
            array('candidate', 'search', 'Search', 'Management/file_attachment', '')
        );

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('File Attachment', 'Management/file_attachment');
        $this->breadcrumbs->push('File Attachment', 'Management/file_attachment');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data);
    }

    function get_missing_data()
    {

        $case_no = $_POST['case_no'];
        $case_number = trim($case_no);
        $candidateInfo = $this->mm->get_candidateinfo($case_number);

        if ($candidateInfo['created_on']) {
            $createdDate = date('d-m-Y', strtotime($candidateInfo['created_on']));
        } else {
            $createdDate = '';
        }

        if ($candidateInfo['final_report_published_date']) {
            $finalDate = date('d-m-Y', strtotime($candidateInfo['final_report_published_date']));
        } else {
            $finalDate = '';
        }

        if ($candidateInfo['supplement_report_date']) {
            $supplDate = date('d-m-Y', strtotime($candidateInfo['supplement_report_date']));
        } else {
            $supplDate = '';
        }

        $html = "<table>
                    <tr class='s-usebrd' height='35'>
                        <td class='s-usetxt'><label> Organization: </label></td>
                        <td>" . $candidateInfo['org_name'] . "</td>
                        <input type='hidden' name='request_id' value='" . $candidateInfo['request_id'] . "' />
                        <input type='hidden' name='case_no' value='" . $case_no . "' />
                        <input type='hidden' name='org_name' value='" . $candidateInfo['org_name'] . "' />
                    </tr>

                    <tr>
                        <td class='s-usetxt'>Candidate Name: </td>
                        <td>" . $candidateInfo['candidate_name'] . "</td>
                        <input type='hidden' name='cand_name' value='" . $candidateInfo['candidate_name'] . "' />
                    </tr>

                    <tr>
                        <td class='s-usetxt'>&nbsp;</td>
                    </tr>

                    <tr>
                        
                        <td class='s-usetxt'>Creation Date: </td>
                        <td>" . $createdDate . "</td>
                        <input type='hidden' name='created_date' value='" . $createdDate . "' />
                        
                        <td class='s-usetxt'>Final Report Date: </td>
                        <td>" . $finalDate . "</td>

                        

                        <td class='s-usetxt'>Supplementary Report Date: </td>
                        <td>" . $supplDate . "</td>
                    </tr>

                </table>";

        $html .= "<table border='' align='center' style='width:900px;margin-top:30px;'>
                    
                    
                    <thead style='position: sticky;top: 0;'>
                        <tr class='at_tr' height='35' >

                            <th class='at_th' style='width:50px;padding-left:0px;'>
                            <h2 style='color:black;'>Sl No. </h2>
                            </th>
                            <th class='at_th' style='width:150px;'>
                            <h2 style='color:black;'>Check Name</h2>
                            </th>               
                            <th class='at_th' style='width:150px;'>
                            <h2 style='color:black;margin-right:5px;'>Document Name</h2>
                            </th>

                            </th>
                            <th class='at_th' style='width:300px;'>
                            <h2 style='color:black;margin-right:5px;'>Status </h2>
                            </th>

                            <th class='at_th' style='width:300px;'>
                            <h2 style='color:black;margin-right:5px;'>Comments </h2>
                            </th>

                            <th class='at_th' style='width:300px;'>
                            <h2 style='color:black;margin-right:5px;'>Attach File</h2>
                            </th>

                            <th class='at_th' style='width:300px;'>
                            <h2 style='color:black;margin-right:5px;'>Attached Document</h2>
                            </th>

                            <th class='at_th' style='width:250px;'>
                            <h2 style='color:black;margin-right:5px;'>File Name</h2>
                            </th>
                            
                        </tr>
                    </thead>";
        $html .= "<tbody>";

        $checkDetails = $this->mm->get_checkdetail($candidateInfo['request_id']);

        $docDetails = array();
        foreach ($checkDetails as $chkVal) {
            $reqId = $chkVal['request_id'];
            $checkId = $chkVal['check_id'];

            $docDetails[] = $this->mm->get_docsdetails($reqId, $checkId);
            $docDetails[] = $this->mm->getverified_documents($reqId, $checkId);
        }

        $docDetails[] = $this->mm->get_docsdetailscommon($reqId, 0);
        $docDetails[] = $this->mm->get_docsdetailscommon($reqId, 999);



        // echo '<pre>';print_r($docDetails);
        // exit;

        foreach ($docDetails as $checkVAlue) {

            $checkIdss[] = $checkVAlue[0]['check_id'];
            $uniqueId = array_unique($checkIdss);
            $checkValue = array_filter($uniqueId);
        }

        foreach ($checkValue as $checks) {
            $myChkId[] = $checks;
        }
        // echo $chkCount=count($myChkId);
        // print_r($myChkId); 

        $fileCount = 0;
        $jj = 0;

        foreach ($docDetails as $key => $docVal) {

            foreach ($docVal as $key1 => $resValue) {

                if (!empty($resValue['fielddata'])) {

                    $verification_data = toArray(json_decode($resValue['fielddata']));
                    $docs_arr = $verification_data['details'];

                    if ($docs_arr) {
                        $filepath = 'uploads/qcreferencedetails/';
                    }
                } else {

                    if ($resValue['table_name'] == 'dcode_partial_upload_document') {
                        $filepath = $this->mm->removeFilename($resValue['document_file']);
                    } else {
                        $filepath = $resValue['file_path'];
                    }
                }


                if (!empty($filepath)) {

                    $srcDir = $filepath; //location of the directory

                    if ($resValue['table_name'] == 'dcode_personal_additional_doc' || $resValue['table_name'] == 'dcode_requested_additional_doc' || $resValue['table_name'] == 'dcode_tds_doc' || $resValue['table_name'] == 'dcode_billing_doc' || $resValue['table_name'] == 'dcode_candidate_upload_files' || $resValue['table_name'] == 'dcode_vm_upload_files' || $resValue['table_name'] == 'dcode_partial_upload_document') {

                        $split = explode("/", $resValue['document_file']);
                        $FileName = $split[count($split) - 1];
                        $path = $srcDir . $FileName;
                    } else if ($resValue['doc_name'] == 'authenticate_doc' || $resValue['doc_name'] == 'multipleupload') {

                        $split = explode("/", $resValue['document_file']);
                        $FileName = $split[count($split) - 1];
                        $path = $srcDir . $FileName;
                    } else {
                        $path = $srcDir . $resValue['document_file'];
                    }

                    if (!empty($resValue['fielddata']) && !empty($docs_arr)) {

                        $RequestId = $resValue['request_id'];
                        $checkId = $resValue['check_id'];
                        $level_id = $resValue['level_id'];
                        $chk_cnt = $resValue['check_cnt'];

                        $filepath = 'uploads/qcreferencedetails/';
                        $doc_name = 'qcreferencedetails';
                        $arr  = explode(',', $docs_arr);


                        for ($k = 0; $k < count($arr); $k++) {

                            if (!file_exists($filepath . $arr[$k])) {

                                $fileCount++;
                                $fileNotExist[] = $arr[$k];
                                $fileNotExistPath[] = $filepath;
                                $fileNotExistDocName[] = $doc_name;
                                $chk_count[] = $resValue['check_cnt'];
                                $fileNotExistCheckId[] = $checkId;
                                $fileNotExistName[] = '';
                                $tableName[] = '';
                            } else {
                                // $chk_count[]=0;
                            }
                        }
                    } else {

                        if (!file_exists($path)) {

                            for ($ch = 0; $ch < count($myChkId); $ch++) {
                                if ($resValue['check_id'] == 0) {
                                    $checkIds = $myChkId[$ch];
                                }

                                switch ($resValue['table_name']) {


                                    case 'dcode_vm_upload_files':
                                        $VMDoc = $this->mm->get_VMUpload_file($resValue['request_id'], $checkIds, $resValue['document_file']);

                                        if (!empty($VMDoc)) {
                                            $fileCount++;
                                            $fileNotExistDocName[] = $VMDoc['doc_name'];
                                            $fileNotExistCheckId[] = $VMDoc['check_id'];
                                            $fileNotExistName[] = $VMDoc['vmupload'];
                                            $chk_count[] = $VMDoc['count_of_chk'];
                                            $fileNotExist[] = $VMDoc['document_file'];
                                            $fileNotExistPath[] = $resValue['file_path'];
                                            $tableName[] = 'dcode_vm_upload_files';
                                        }
                                        break;

                                    case 'dcode_personal_additional_doc':

                                        $personalAddDoc = $this->mm->get_personaladd_docfile($resValue['request_id'], $checkIds, $resValue['document_file']);

                                        if (!empty($personalAddDoc)) {
                                            $fileCount++;
                                            $fileNotExistDocName[] = $personalAddDoc['doc_name'];
                                            $fileNotExistCheckId[] = $personalAddDoc['check_id'];
                                            $fileNotExistName[] = '';
                                            $chk_count[] = $personalAddDoc['count_of_chk'];
                                            $fileNotExist[] = $personalAddDoc['document_file'];
                                            $fileNotExistPath[] = $resValue['file_path'];
                                            $tableName[] = 'dcode_personal_additional_doc';
                                        }
                                        break;

                                    case 'dcode_requested_additional_doc':

                                        $requestAddDoc = $this->mm->get_reqadd_docfile($resValue['request_id'], $checkIds, $resValue['document_file']);

                                        if (!empty($requestAddDoc)) {
                                            $fileCount++;
                                            $fileNotExistDocName[] = $requestAddDoc['doc_name'];
                                            $fileNotExistCheckId[] = $requestAddDoc['check_id'];
                                            $fileNotExistName[] = '';
                                            $chk_count[] = $requestAddDoc['count_of_chk'];
                                            $fileNotExist[] = $requestAddDoc['document_file'];
                                            $fileNotExistPath[] = $resValue['file_path'];
                                            $tableName[] = 'dcode_requested_additional_doc';
                                        }
                                        break;

                                    case 'dcode_contact_details':

                                        $contactDoc = $this->mm->get_contact_docfile($resValue['request_id'], $checkIds, $resValue['document_file']);
                                        // print_r($contactDoc);
                                        if (!empty($contactDoc)) {
                                            $fileCount++;
                                            $fileNotExistDocName[] = 'Address Proof';
                                            $fileNotExistCheckId[] = $contactDoc['checkid'];
                                            $fileNotExistName[] = '';
                                            $chk_count[] = 0;
                                            $fileNotExist[] = $contactDoc['document_file'];
                                            $fileNotExistPath[] = $resValue['file_path'];
                                            $tableName[] = 'dcode_contact_details';
                                        }
                                        break;

                                    case 'dcode_billing_doc':

                                        $billingDoc = $this->mm->get_billing_docfile($resValue['request_id'], $checkIds, $resValue['document_file']);

                                        if (!empty($billingDoc)) {
                                            // $filePaths=$this->mm->removeFilename($resValue['document_file']);
                                            $fileCount++;
                                            $fileNotExistDocName[] = 'Billing Document';
                                            $fileNotExistCheckId[] = $billingDoc['check_id'];
                                            $fileNotExistName[] = '';
                                            $chk_count[] = $billingDoc['count_of_chk'];
                                            $fileNotExist[] = $billingDoc['document_file'];
                                            $fileNotExistPath[] = $resValue['file_path'];
                                            $tableName[] = 'dcode_billing_doc';
                                        }
                                        break;

                                    case 'dcode_composedoc':

                                        $composeDoc = $this->mm->get_compose_docfile($resValue['request_id'], $checkIds, $resValue['document_file']);

                                        if (!empty($composeDoc)) {
                                            // $filePaths=$this->mm->removeFilename($resValue['document_file']);
                                            $fileCount++;
                                            $fileNotExistDocName[] = $composeDoc['doc_name'];
                                            $fileNotExistCheckId[] = $composeDoc['check_id'];
                                            $fileNotExistName[] = '';
                                            $chk_count[] = $composeDoc['count_of_chk'];
                                            $fileNotExist[] = $composeDoc['document_file'];
                                            $fileNotExistPath[] = $resValue['file_path'];
                                            $tableName[] = 'dcode_composedoc';
                                        }
                                        break;

                                    default:

                                        // if($resValue['check_id'] == 0 && ($resValue['table_name'] !='dcode_declaration_details' && $resValue['table_name'] !='dcode_personal_details')){
                                        //     $fileCount++;
                                        //     $fileNotExistDocName[]=$resValue['doc_name'];
                                        //     $fileNotExistCheckId[]=$resValue['check_id'];
                                        //     $fileNotExistName[]='';
                                        //     $chk_count[]= $resValue['count_of_chk'];
                                        //     $fileNotExist[]=$resValue['document_file'];
                                        //     $fileNotExistPath[]=$resValue['file_path'];
                                        //     $tableName[]=$resValue['table_name'];

                                        // } 
                                        break;
                                }
                            }

                            if ($resValue['table_name'] == 'dcode_partial_upload_document') {
                                $partialDoc = $this->mm->get_partial_docfile($resValue['request_id'], $resValue['document_file']);

                                if (!empty($partialDoc)) {
                                    $filePaths = $this->mm->removeFilename($resValue['document_file']);
                                    $fileCount++;
                                    $fileNotExistDocName[] = $partialDoc['doc_name'];
                                    $fileNotExistCheckId[] = 0;
                                    $fileNotExistName[] = '';
                                    $chk_count[] = 0;
                                    $fileNotExist[] = $partialDoc['document_file'];
                                    $fileNotExistPath[] = $filePaths;
                                    $tableName[] = 'dcode_partial_upload_document';
                                }
                            }

                            if ($resValue['table_name'] == 'dcode_declaration_details' || $resValue['table_name'] == 'dcode_personal_details' || $resValue['table_name'] == 'dcode_candidate_upload_files' || $resValue['table_name'] == 'dcode_clientadditional_report' || $resValue['table_name'] == 'dcode_client_request' || $resValue['table_name'] == 'dcode_finalreportpublished' || $resValue['table_name'] == 'dcode_tds_doc') {
                                $fileCount++;
                                $fileNotExistDocName[] = $resValue['doc_name'];
                                $fileNotExistCheckId[] = $resValue['check_id'];
                                $fileNotExistName[] = '';
                                $chk_count[] = $resValue['count_of_chk'];
                                $fileNotExist[] = $resValue['document_file'];
                                $fileNotExistPath[] = $resValue['file_path'];
                                $tableName[] = $resValue['table_name'];
                            }

                            if ($resValue['check_id'] > 0) {
                                $fileCount++;
                                $fileNotExistDocName[] = $resValue['doc_name'];
                                $fileNotExistCheckId[] = $resValue['check_id'];
                                $fileNotExistName[] = '';
                                $chk_count[] = $resValue['count_of_chk'];
                                $fileNotExist[] = $resValue['document_file'];
                                $fileNotExistPath[] = $resValue['file_path'];
                                $tableName[] = $resValue['table_name'];
                            }

                            // $fileNotExistName[]=$VMDoc['document_name'];
                            // $fileNotExist[]=$resValue['document_file'];
                            // $fileNotExistPath[]=$resValue['file_path'];
                            // $fileNotExistDocName[]=$resValue['doc_name'];
                            // $tableName[]=$resValue['table_name'];
                            // $chk_count[]= $resValue['count_of_chk'];
                        }
                    }
                }
            }

        }
        // echo ($fileCount);
        // echo '<pre>';print_r($fileNotExistDocName);
        // echo '<pre>';print_r($fileNotExist);
        // echo '<pre>';print_r($fileNotExistPath);
        // echo '<pre>';print_r($fileNotExistCheckId);
        // echo '<pre>';print_r($tableName);
        // exit;

        $loopCount = 0;
        $i = 1;
        while ($loopCount < ($fileCount)) {

            $checkName = $this->mm->get_CheckName($fileNotExistCheckId[$loopCount]);

            if ($fileNotExistCheckId[$loopCount] != 0) {
                $check_name = $checkName['name'];
            } else {
                $check_name = "Common";
            }

            if ($chk_count[$loopCount] > 0 && $fileNotExistCheckId[$loopCount] != 0) {
                $countChk = $chk_count[$loopCount];
            } else {
                $countChk = '';
            }

            $filePathValue = $fileNotExistPath[$loopCount];

            if ($fileNotExistCheckId[$loopCount] == 14) {

                switch ($fileNotExistDocName[$loopCount]) {
                    case 'document_file':
                        $fileNotExistDocName[$loopCount] = 'Consolidated Marks';
                        break;
                    case 'gdocument':
                        $fileNotExistDocName[$loopCount] = 'Degree Certificate';
                        break;
                    case 'consolidate_doc':
                        $fileNotExistDocName[$loopCount] = 'Marks Card';
                        break;
                    case 'pdocument':
                        $fileNotExistDocName[$loopCount] = 'Provisional Degree';
                        break;
                    default:
                        break;
                }
            }

            if ($fileNotExistCheckId[$loopCount] == 59) {

                switch ($fileNotExistDocName[$loopCount]) {
                    case 'relieve_document':
                        $fileNotExistDocName[$loopCount] = 'Relieving Document';
                        break;
                    case 'service_document':
                        $fileNotExistDocName[$loopCount] = 'Service Document';
                        break;
                    case 'employement_file':
                        $fileNotExistDocName[$loopCount] = 'Pay Slip Document';
                        break;
                        // case 'pdocument': $fileNotExistDocName[$loopCount] = 'provisional degree';
                        // break;
                    default:
                        break;
                }
            }

            if ($tableName[$loopCount] == 'dcode_personal_additional_doc') {
                $split = explode("/", $fileNotExist[$loopCount]);
                $fileNotExist[$loopCount] = $split[count($split) - 1];
            }
            // else{
            //     $fileNotExist[$loopCount] = str_replace(',', ',<br />', $fileNotExist[$loopCount]);
            // }

            if ($tableName[$loopCount] == 'dcode_requested_additional_doc') {
                $split = explode("/", $fileNotExist[$loopCount]);
                $fileNotExist[$loopCount] = $split[count($split) - 1];
            }

            if ($tableName[$loopCount] == 'dcode_tds_doc') {
                $split = explode("/", $fileNotExist[$loopCount]);
                $fileNotExist[$loopCount] = $split[count($split) - 1];
            }


            if ($fileNotExistDocName[$loopCount] == 'company_decl_doc') {
                $fileNotExistDocName[$loopCount] = 'Authorization Letter';
            }

            if ($fileNotExistDocName[$loopCount] == 'authenticate_doc') {
                $split = explode("/", $fileNotExist[$loopCount]);
                $fileNotExist[$loopCount] = $split[count($split) - 1];

                $fileNotExistDocName[$loopCount] = $fileNotExistName[$loopCount];
            }

            if ($fileNotExistName[$loopCount] == 'vmupload') {
                $split = explode("/", $fileNotExist[$loopCount]);
                $fileNotExist[$loopCount] = $split[count($split) - 1];

                $fileNotExistDocName[$loopCount] = $fileNotExistDocName[$loopCount];
            }

            if ($fileNotExistDocName[$loopCount] == 'multipleupload') {
                $split = explode("/", $fileNotExist[$loopCount]);
                $fileNotExist[$loopCount] = $split[count($split) - 1];
            }

            if ($fileNotExistDocName[$loopCount] == 'Billing Document') {
                $split = explode("/", $fileNotExist[$loopCount]);
                $fileNotExist[$loopCount] = $split[count($split) - 1];
            }

            if ($fileNotExistDocName[$loopCount] == 'authenticate_doc') {
                $split = explode("/", $fileNotExist[$loopCount]);
                $fileNotExist[$loopCount] = $split[count($split) - 1];
            }

            if ($tableName[$loopCount] == 'dcode_candidate_upload_files' || $tableName[$loopCount] == 'dcode_vm_upload_files' || $tableName[$loopCount] == 'dcode_partial_upload_document') {
                $split = explode("/", $fileNotExist[$loopCount]);
                $fileNotExist[$loopCount] = $split[count($split) - 1];
            }

            $mUpdFile = $this->mm->get_missing_uploaded_files($candidateInfo['request_id'], $fileNotExistCheckId[$loopCount], $fileNotExist[$loopCount]);

            if (!empty($mUpdFile['nameof_file']) && $mUpdFile['file_status'] == 2) {

                $status = 'Reverted';
                $attachedName = $mUpdFile['user_file_name'];
                $fileId = $mUpdFile['id'];
            } else if (!empty($mUpdFile['nameof_file']) && $mUpdFile['file_status'] == 0) {

                $status = 'Pending';
                $attachedName = $mUpdFile['user_file_name'];
                $fileId = 0;
            } else {
                $status = '';
                $attachedName = '';
                $fileId = 0;
            }

            if (!empty($mUpdFile['comments'])) {
                $comments = $mUpdFile['comments'];
            } else {
                $comments = '';
            }


            $html .= "<tr class='' height='25'>
                            <td  class='at_td' style='color:black;width:50px;height: 25px;text-align:right;padding-right: 10px;'>
                                " . $i . "
                            </td>
                            <td  class='at_td' style='color:#022151;width:150px;height: 25px;'>
                                <label>
                                " . $check_name . ' ' . $countChk . "
                                </label>
                                <input type='hidden' name='check_name[]' value='" . $check_name . "' />
                                <input type='hidden' name='check_count[]' value='" . $countChk . "' />
                                <input type='hidden' name='check_id[]' value='" . $fileNotExistCheckId[$loopCount] . "' />    
                            </td>

                            <td  class='at_td' style='color:#1c1b1b;width:150px;font-size:14px;text-align:left;padding-right: 10px;height: 25px;'>" . $fileNotExistDocName[$loopCount] . " 
                                <input type='hidden' name='doc_name[]' value='" . $fileNotExistDocName[$loopCount] . "' />
                            </td>

                            <td  class='at_td' style='color:#1c1b1b;width:150px;font-size:14px;text-align:left;padding-right: 10px;height: 25px;color:#ff7e00;'>" . $status . " 
                                
                            </td>

                            <td  class='at_td' style='color:#1c1b1b;width:150px;font-size:14px;text-align:left;padding-right: 10px;height: 25px;'>" . $comments . " 
                                
                            </td>

                            
                            <td  class='at_td' style='color:#1c1b1b;width:250px;font-size:14px;padding-right: 10px;height: 25px;'>";

            if (!empty($mUpdFile['nameof_file']) && $mUpdFile['file_status'] != 2) {
                $html .= "<label style='margin-left:5px;font-size:12px;font-weight:bold;color:green;'>Attached </label>";
            } else {
                $html .= "<input type='file' name='doc_file" . $loopCount . "' class='s-inpt req required selfile' id='" . $loopCount . "' />
                                <input type='hidden' name='doc_file_id" . $loopCount . "' value='" . $fileId . "' />
                                <input type='hidden' name='attchedName[]' value='" . $attachedName . "' />";
            }

            $html .= "</td>

                            <td  class='at_td' style='color:#1c1b1b;width:150px;font-size:14px;text-align:left;padding-right: 10px;height: 25px;'> 
                                <a href='" . base_url() . "uploads/missing_files/" . $fileNotExist[$loopCount] . "' target='_blank'>" . $attachedName . "</a>
                            </td>

                            <td  class='at_td' style='color:#1c1b1b;width:300px;font-size:14px;text-align:left;padding-right: 10px;height: 25px;'>" . $fileNotExist[$loopCount] . "
                                <input type='hidden' name='mfile_name[]' value='" . $fileNotExist[$loopCount] . "' id='oldFname" . $loopCount . "' />
                                <input type='hidden' name='file_path[]' value='" . $filePathValue . "' />
                            </td>

                        </tr>";

            $i++;
            $loopCount++;
        }

        $html .= "<input type='hidden' name='count' value='" . $loopCount . "' />
                        </body>
                        </table>";
        echo $html;
    }


    function save_missingdata()
    {
        // echo '<pre>';print_r($_POST);
        // echo '<pre>';print_r($_FILES);
        // exit;

        $roleid = $this->session->userdata('role_id');
        $userId = $this->session->userdata["userid"];

        date_default_timezone_set('Asia/Kolkata');
        $insertion_date = date("Y-m-d H:i:s");
        $count = $_POST['count'];

        $config['allowed_types'] = '*';
        $config['encrypt_name'] = false;
        $config['remove_spaces'] = true;
        $config['upload_path'] = 'uploads/missing_files/';
        $this->load->library('upload', $config);
        $this->upload->initialize($config);

        $formData = array();
        $upd_data = array();
        for ($i = 0; $i < $count; $i++) {

            $OldfileName = str_replace(" ", "_", $_FILES['doc_file' . $i]['name']);
            // $OldfileName =preg_replace('/[^A-Za-z0-9.]/', '', $_FILES['doc_file'.$i]['name']);

            $NewfileName = $_POST['mfile_name'][$i];


            $formData['request_id'] =  $_POST['request_id'];
            $formData['check_id'] = $_POST['check_id'][$i];
            $formData['count_of_chk'] = $_POST['check_count'][$i];
            $formData['case_no'] = $_POST['case_no'];
            $formData['doc_name '] = $_POST['doc_name'][$i];
            $fId = $_POST['doc_file_id' . $i];
            $formData['nameof_file'] = $_POST['mfile_name'][$i];
            $formData['pathof_file'] = $_POST['file_path'][$i];
            $formData['role_id'] = $roleid;
            $formData['user_id'] = $userId;
            $formData['user_file_name'] = $OldfileName;
            $formData['qc_role_id'] = '';
            $formData['qc_user_id'] = '';
            $formData['file_status'] = 0;
            $formData['comments'] = '';
            $formData['qc_updation_date'] = '';
            $formData['insertion_date'] = $insertion_date;

            if ($this->upload->do_upload('doc_file' . $i)) {
                $documents[$i]  = $this->upload->data();
            }
            // else
            // {
            //     echo $i. ($documents['doc_file'] = $this->upload->display_errors());
            // }

            rename("uploads/missing_files/" . $OldfileName, "uploads/missing_files/" . $_POST['mfile_name'][$i]);


            if ($fId != 0 && $_FILES['doc_file' . $i]['size'] != 0) {

                $upd_data['role_id'] = $roleid;
                $upd_data['user_id'] = $userId;
                $upd_data['user_file_name'] = $OldfileName;
                $upd_data['file_status'] = 0;
                // $upd_data['comments'] = '';
                $upd_data['insertion_date'] = $insertion_date;
                $this->db->where('id', $fId);
                $this->db->update(DB_PREFIX . 'missingfiles', $upd_data);
            } else {

                if ($_FILES['doc_file' . $i]['size'] != 0) {
                    $this->db->insert(DB_PREFIX . 'missingfiles', $formData);
                }
            }
        }

        redirect('' . base_url('Management/file_attachment'));
    }


    //************ File Review Page *************
    function file_review()
    {

        $data['auth_link'] = array(
            array('candidate', 'search', 'Search', 'Management/file_review', '')
        );

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('File Review', 'Management/file_review');
        $this->breadcrumbs->push('File Review', 'Management/file_review');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data);
    }

    function get_review_data()
    {

        $case_no = $_POST['case_no'];
        $case_number = trim($case_no);
        $candidateInfo = $this->mm->get_candidateinfo($case_number);

        $reportInfo  = $this->mm->show_report($candidateInfo['request_id']); // Sep 22nd

        if ($candidateInfo['created_on']) {
            $createdDate = date('d-m-Y', strtotime($candidateInfo['created_on']));
        } else {
            $createdDate = '';
        }

        if ($candidateInfo['final_report_published_date']) {
            $finalDate = date('d-m-Y', strtotime($candidateInfo['final_report_published_date']));
        } else {
            $finalDate = '';
        }

        if ($candidateInfo['supplement_report_date']) {
            $supplDate = date('d-m-Y', strtotime($candidateInfo['supplement_report_date']));
        } else {
            $supplDate = '';
        }

        $html = "<table>
                    <tr class='s-usebrd' height='35'>
                        <td class='s-usetxt'><label> Organization: </label></td>
                        <td>" . $candidateInfo['org_name'] . "</td>
                        <input type='hidden' name='request_id' value='" . $candidateInfo['request_id'] . "' />
                        <input type='hidden' name='case_no' value='" . $case_number . "' />
                        <input type='hidden' name='org_name' value='" . $candidateInfo['org_name'] . "' />
                    </tr>

                    <tr>
                        <td class='s-usetxt'>Candidate Name: </td>
                        <td>";

        $html = $html . anchor("/Dadmin/dadminview/" . base64_encode($candidateInfo['request_id']), "<span style='color:blue'>" . $candidateInfo['candidate_name']  . "</span>", 'target=_blank') . "</td>
                       
                        <td class='s-usetxt'>&nbsp;</td>"; // Sep 22nd

        // Sep 22nd
        if (!empty($reportInfo)) {
            $check_id = $reportInfo['check_id'];
            $level_id = $reportInfo['level_id'];
            $pack_id = $reportInfo['pack_id'];
            $qc2_date = $reportInfo['qc2_date'];
            $html = $html . "<td>" . anchor("Reports/candidate_reports_view/" . base64_encode($candidateInfo['request_id']) . "/" . base64_encode($level_id) . "/" . base64_encode($check_id) . "/" . base64_encode($pack_id) . "/" . base64_encode($qc2_date), "<span style='color:blue'>" . "View Report"  . "</span>", 'target=_blank') . "</td>";
        } // Sep 22nd



        $html = $html . "<input type='hidden' name='cand_name' value='" . $candidateInfo['candidate_name'] . "' />
                    </tr>

                    <tr>
                        <td class='s-usetxt'>&nbsp;</td>
                    </tr>

                    <tr>
                        
                        <td class='s-usetxt'>Creation Date: </td>
                        <td style='width:170px;'>" . $createdDate . "</td>
                        <input type='hidden' name='created_date' value='" . $createdDate . "' />
                        
                        <td class='s-usetxt'>Final Report Date: </td>
                        <td>" . $finalDate . "</td>

                        

                        <td class='s-usetxt'>Supplementary Report Date: </td>
                        <td>" . $supplDate . "</td>
                    </tr>

                </table>";

        $html .= "<table border='' align='center' style='width:900px;margin-top:30px;'>
                    
                    
                    <thead style='position: sticky;top: 0;'>
                        <tr class='at_tr' height='35' >

                            <th class='at_th' style='width:50px;padding-left:0px;'>
                            <h2 style='color:black;'>Sl No. </h2>
                            </th>
                            <th class='at_th' style='width:150px;'>
                            <h2 style='color:black;'>Check Name</h2>
                            </th>               
                            <th class='at_th' style='width:150px;'>
                            <h2 style='color:black;margin-right:5px;'>Document Name</h2>
                            </th>

                            </th>
                            <th class='at_th' style='width:300px;'>
                            <h2 style='color:black;margin-right:5px;'>Status </h2>
                            </th>
                            <th class='at_th' style='width:300px;'>
                            <h2 style='color:black;margin-right:5px;'>Comments </h2>
                            </th>

                            <th class='at_th' style='width:300px;'>
                            <h2 style='color:black;margin-right:5px;'>Attached File </h2>
                            
                            <th class='at_th' style='width:250px;'>
                            <h2 style='color:black;margin-right:5px;'>File Name</h2>
                            </th>
                            
                        </tr>
                    </thead>";
        $html .= "<tbody>";

        $role_id =     $this->session->userdata('role_id');
        $fileDetails = $this->mm->get_fileattached($candidateInfo['request_id'], $role_id);
        // echo '<pre>';print_r($fileDetails);exit;

        $i = 1;
        foreach ($fileDetails as $key => $chkVal) {
            $reqId = $chkVal['request_id'];
            $checkId = $chkVal['check_id'];

            $checkName = $this->mm->get_CheckName($checkId);

            if ($chkVal['count_of_chk'] != 0) {
                $chkCount = $chkVal['count_of_chk'];
            } else {
                $chkCount = '';
            }

            if ($chkVal['check_id'] != 0) {
                $check_name = $checkName['name'];
            } else {
                $check_name = "Common";
            }

            if ($chkVal['comments'] != '') {
                $comments = $chkVal['comments'];
            } else {
                $comments = "";
            }


            $html .= "<tr class='' height='25'>
                            <td  class='at_td' style='color:black;width:50px;height: 25px;text-align:right;padding-right: 10px;'>
                                " . $i . "
                            </td>
                            <td  class='at_td' style='color:#022151;width:150px;height: 25px;'>
                                <label>
                                " . $check_name . $chkCount . "
                                </label> 
                                <input type='hidden' name='file_id[]' value='" . $chkVal['id'] . "'>
                            </td>";
            /*** Sep 26th ***/
            if ($chkVal['doc_name'] == 'qcreferencedetails') {
                $qcref_Info  = $this->mm->get_qcref_details($reqId, $checkId, $chkVal['count_of_chk']);
                $req_id = $qcref_Info['candidate_req_id'];
                $check_id = $qcref_Info['check_id'];
                $level_id  = $qcref_Info['level_id'];
                $pack_id = $qcref_Info['pack_id'];

                $html = $html . "<td>" . anchor("/Verification/qc2_verified/" . base64_encode($req_id) . "/" . base64_encode($level_id) . "/" . base64_encode($check_id) . "/" . base64_encode($pack_id), "<span style='color:blue'>" . $chkVal['doc_name']  . "</span>", 'target=_blank') . "</td>";
            } else {
                $html = $html . " <td  class='at_td' style='color:#1c1b1b;width:150px;font-size:14px;text-align:left;padding-right: 10px;height: 25px;'>" .  $chkVal['doc_name'] . "</td>";
            }

            /*** Sep 26th ***/

            $html = $html . "<input type='hidden' name='doc_name[]' value='" . $chkVal['doc_name'] . "'>
                            <td  class='at_td' style='color:#1c1b1b;width:150px;font-size:14px;text-align:left;padding-right: 10px;height: 25px;color:#ff7e00;'>
                                <select name='status[]'>
                                    <option value=''>Select</option>
                                    <option value='1'>Verified</option>
                                    <option value='2'>Revert</option>
                                </select>
                            </td>

                            <td  class='at_td' style='color:#1c1b1b;width:150px;font-size:14px;text-align:left;padding-right: 10px;height: 25px;'>
                                <textarea name='comments[]' cols='20'>" . $comments . "</textarea>
                            </td>

                            
                            <td  class='at_td' style='color:#1c1b1b;width:250px;font-size:14px;padding-right: 10px;height: 25px; ' >
                                <a href='" . base_url() . "uploads/missing_files/" . $chkVal['nameof_file'] . "' style='color:green;' target='_blank'> Attached</a>                         
                            </td>

                            <td  class='at_td' style='color:#1c1b1b;width:300px;font-size:14px;text-align:left;padding-right: 10px;height: 25px;'>" . $chkVal['nameof_file'] . "
                                
                                <input type='hidden' name='mfile_name[]' value='" . $chkVal['nameof_file'] . "' />
                                <input type='hidden' name='file_path[]' value='" . $chkVal['pathof_file'] . "' />
                                
                            </td>

                        </tr>";

            $i++;
        }

        $html .= "<input type='hidden' name='count' value='" . $i . "' />
                        </body>
                        </table>";
        echo $html;
    }


    //****** Save Review Data *******//

    function save_reviewdata()
    {
        // echo '<pre>';print_r($_POST);
        // exit;
        $count = count($_POST['status']);
        $roleid = $this->session->userdata('role_id');
        $userId = $this->session->userdata["userid"];

        date_default_timezone_set('Asia/Kolkata');
        $updationDate = date("Y-m-d H:i:s");

        $upd_data = array();
        for ($i = 0; $i < $count; $i++) {

            $status = $_POST['status'][$i];

            if ($status != '') {
                $QCupdationDate = $updationDate;
            } else {
                $QCupdationDate = '';
            }

            if ($status == 1) {

                $source = 'uploads/missing_files/' . $_POST['mfile_name'][$i];

                if ($_POST['doc_name'][$i] == 'thumbnail') {
                    $destination = 'uploads/user_photo/thumb/' . $_POST['mfile_name'][$i];
                } else {
                    $destination = $_POST['file_path'][$i] . $_POST['mfile_name'][$i];
                }

                $srcDir = $_POST['file_path'][$i];
                $path = $srcDir . $_POST['mfile_name'][$i];

                if (!file_exists($path)) {

                    copy($source, $destination);

                    if ($_POST['doc_name'][$i] == 'user_image' || $_POST['doc_name'][$i] == 'thumbnail') {

                        if ($_POST['doc_name'][$i] == 'user_image') {
                            $DestinationPath = 'uploads/verified_user_photo/thumb/' . $_POST['mfile_name'][$i];
                        } else {
                            $DestinationPath = 'uploads/user_photo/thumb/' . $_POST['mfile_name'][$i];
                        }

                        copy($source, $DestinationPath);

                        $config['image_library'] = 'gd2';
                        $config['source_image'] = $DestinationPath;
                        $config['overwrite'] = TRUE;
                        $config['maintain_ratio'] = TRUE;
                        $config['width'] = 54;
                        $config['height'] = 46;

                        $this->load->library('image_lib', $config);
                        $this->image_lib->resize();
                    }

                    $copyValue = 0;
                } else {
                    $copyValue = 1;
                }

                $upd_data['qc_role_id'] = $roleid;
                $upd_data['qc_user_id'] = $userId;
                $upd_data['file_status'] = $status;
                $upd_data['comments'] = $_POST['comments'][$i];
                $upd_data['copy_error'] = $copyValue;
                $upd_data['qc_updation_date'] = $QCupdationDate;

                $this->db->where('id', $_POST['file_id'][$i]);
                $this->db->update(DB_PREFIX . 'missingfiles', $upd_data);
            } else {

                $upd_data['qc_role_id'] = $roleid;
                $upd_data['qc_user_id'] = $userId;
                $upd_data['file_status'] = $status;
                $upd_data['comments'] = $_POST['comments'][$i];
                $upd_data['qc_updation_date'] = $QCupdationDate;

                $this->db->where('id', $_POST['file_id'][$i]);
                $this->db->update(DB_PREFIX . 'missingfiles', $upd_data);
            }
        }

        redirect('' . base_url('Management/file_review'));
    }


    //*************** export Bulk Downloas ******************/
    function export_bulk_download()
    {

        $model = array('Management_model' => 'export_bulklist');
        // print_r($_POST);exit;
        $parent_office = ($_POST['exp_parent_office']) ? $_POST['exp_parent_office'] : '';
        $office = ($_POST['exp_office_id']) ? $_POST['exp_office_id'] : '';
        $sub_office = ($_POST['exp_sub_office']) ? $_POST['exp_sub_office'] : '';
        $date_filter = ($_POST['exp_date_filter']) ? $_POST['exp_date_filter'] : '';
        $c_date = ($_POST['exp_c_date']) ? $_POST['exp_c_date'] : '';
        $t_date = ($_POST['exp_t_date']) ? $_POST['exp_t_date'] : '';

        if ($parent_office) {
            $condition[] = " d.id = " . $parent_office;
        }
        if ($office) {
            $condition[] = " b.id = " . $office;
        }
        // if($org_id){
        //     $condition[]=" c.id = ".$org_id;
        // }
        if ($sub_office) {
            $condition[] = " o.id = " . $sub_office;
        }

        if (!empty($c_date) && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(a.case_accepted_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "' and case when a.dataentry_by=3 Then DATE_FORMAT(a.case_recieved_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "' else 1 end";
        }
        if (!empty($t_date) && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(a.case_accepted_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "' and case when a.dataentry_by=3 Then DATE_FORMAT(a.case_recieved_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "' else 1 end ";
        }

        if (!empty($c_date) && !empty($t_date) && $date_filter == 2) {
            $condition[] = "((((DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "' and a.final_report=1)  and (DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "' and a.final_report=1) and a.supplement_report <>1)) OR (DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "' and a.supplement_report=1)  and (DATE_FORMAT(a.supplement_report_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "' and a.supplement_report=1)) and cv.verification_status=1 ";
        }


        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];

        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;

            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Head Office");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Branch Office");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Sub Office");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Report");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Case Accepted / Recieved Date");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Final Report Published Date");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "Supplementary Report published Date");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Email");

            $cj = 2;

            foreach ($result as $i => $row) {

                $role = $this->session->userdata('user_type');
                $payment_status =  $row['payment_status'];
                // $checkstatus = $this->cm->get_currentstatus($row['request_id']); 
                $verifiedlevelstatus = $this->cm->get_verifiedlevelstatus($row['request_id']);

                if ($row['parent'] == 0) {
                    $officevalue = $row[$this->request_parent_office];
                    $branchofficevalue = $row['office_name'];
                } else if ($row['parent'] != 0) {
                    $officevalue = $row['office_name'];
                    $branchofficevalue = $row[$this->request_parent_office];
                }


                // $pending_checksa = $this->rm->getchecksverify($row['request_id']);
                $finalreport_checksa = $this->rm->getcountcheck($row['request_id']);
                $count_pending_checksa = $this->rm->getcountchecksverify($row['request_id']);
                $count_date_checksa = $this->rm->getfinalupdateedate($row['request_id']);

                $namw = count($finalreport_checksa);
                $sum = 0;
                foreach ($count_pending_checksa as $count_pending_val) {
                    $sum += $count_pending_val['no_checks'];
                }
                $report = '';
                if (!empty($verifiedlevelstatus['qc2fielddata'])) {
                    if ($sum <= $namw) {
                        $status = 'Report Published';
                        if ($role <> 1 && $payment_status == 948 && $row['final_report'] == 1 && $row['supplement_report'] != 1) {
                            $report = 'Final';
                        } else {
                            if ($row['final_report'] == 1 && $row['supplement_report'] != 1) {
                                $report = "Final";
                            }
                        }
                    } else {
                        $report = '';
                    }
                } else {
                    $report = '';
                }
                /* supplementary report */

                if ($row['supplement_report'] == 1) {
                    $freport = $this->db->query("select report_name from " . DB_PREFIX . "finalreportpublished 
                where request_id=" . $row['request_id'] . " LIMIT 1 ")->row_array();
                    if ($role <> 1 && $payment_status == 948) {

                        if ($row['final_report'] == 1 && $row['supplement_report'] == 1) {
                            $report = 'Supplement';
                        } else {
                            $report = 'Final';
                        }
                    } else {
                        if ($row['final_report'] == 1 && $row['supplement_report'] == 1) {
                            $report = "Supplement";
                        } else if ($row['supplement_report'] == 1) {
                            $report = "Supplement";
                        } else {
                            $report = "Final";
                        }
                    }
                }
                if ($row['supplement_report'] == 2) {
                    $freport = $this->db->query("select report_name from " . DB_PREFIX . "finalreportpublished 
            where request_id=" . $row['request_id'] . "  LIMIT  1 ")->row_array();
                    if ($role <> 1 && $payment_status == 948) {
                        $report = 'Final';
                    } else if ($sum <= $namw) {
                        $report = "Final";
                    }

                    $$report = '';
                }


                if ($row['dataentry_by'] != 3 && $row['case_accepted_date'] != "0000-00-00 00:00:00" && !empty($row['case_accepted_date'])) {
                    $Accepted_on = date('d-m-Y', strtotime($row['case_accepted_date']));
                } else if ($row['dataentry_by'] == 3 && $row['case_recieved_date'] != "0000-00-00" && !empty($row['case_recieved_date'])) {
                    $Accepted_on = date('d-m-Y', strtotime($row['case_recieved_date']));
                } else {
                    $Accepted_on = '';
                }

                $finalPublishDate = ($row['final_report_published_date']) ? date('d-m-Y', strtotime($row['final_report_published_date'])) : '';
                $supplementDate = ($row['supplement_report_date']) ? date('d-m-Y', strtotime($row['supplement_report_date'])) : '';

                $objPHPExcel->getActiveSheet()->getStyle('A1:L1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $cj, ($i + $count + 1))
                    ->setCellValue('B' . $cj, $row['org_name'])
                    ->setCellValue('C' . $cj, $officevalue)
                    ->setCellValue('D' . $cj, $branchofficevalue)
                    ->setCellValue('E' . $cj, $row[$this->request_sub_office])
                    ->setCellValue('F' . $cj, $row['candidate_name'])
                    ->setCellValue('G' . $cj, $row['case_no'])
                    ->setCellValue('H' . $cj, $report)
                    ->setCellValue('I' . $cj, $Accepted_on)
                    ->setCellValue('J' . $cj, $finalPublishDate)
                    ->setCellValue('K' . $cj, $supplementDate)
                    ->setCellValue('L' . $cj, $row['email']);

                $cj++;
            }
            $this->export_excel('A', 'L', 'Bulk_List_', $objPHPExcel);
            exit;
        }
        redirect('Management/bulk_download');
    }

    //  ********************************* joiners list ********ka added on sep 4 ***********

    function joinersadd()
    {
       
        $this->load->helper('cloneform');
        $jd_id = base64_decode($this->uri->segment(3));
        $title = "Create";
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Joiners List', 'Management/joiners');
        $this->breadcrumbs->push('Add Joinerslist', 'Management/joinersadd');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, '');

        $this->form_validation->set_rules('jd_case_no', 'Case Number', 'required');
        // $this->form_validation->set_rules('jd_joining_date', 'Joining Date', 'required');
        // $this->form_validation->set_rules('jd_email_date', 'Email Date', 'required');

        if ($this->form_validation->run() == false) {
        } else {
            $case_no = $this->input->post('jd_case_no');
            $existing_case = $this->mm->check_CaseNumber_Exists($case_no);
            log_message('debug', 'Case number check: ' . ($existing_case ? 'Exists' : 'Does not exist'));

            if ($existing_case) {
                $this->session->set_flashdata('error', 'Case number already exists in the joiners list .');
                redirect(base_url('Management/joinersadd'));
            } else {
                $jd_joining_date = date('Y-m-d', strtotime($_POST['jd_joining_date']));
                $jd_email_date = date('Y-m-d', strtotime($_POST['jd_email_date']));
                $formArray['jd_case_no'] =   $case_no;
                $formArray['jd_joining_date'] =   $jd_joining_date;
                $formArray['jd_email_date'] =   $jd_email_date;
                $formArray['jd_country'] =   $_POST['jd_country'];
                
                if ($this->mm->joinersadd($formArray)) {
                    $this->session->set_flashdata('success', 'Record added successfully!');
                    redirect(base_url('Management/joiners'));
                } else {
                    $this->session->set_flashdata('error', 'Invalid case number.');
                    redirect(base_url('Management/joinersadd'));
                }
            }
        }
    }

    // ===================== candidate name display =========================================

    function get_candidate_name_by_case_no()
    {
        $case_no = $this->input->post('case_no');
        $candidate_name = $this->mm->get_candidate_name_by_case_no($case_no);

        if ($candidate_name) {
            echo json_encode(array('status' => 'success', 'candidate_name' => $candidate_name));
        } else {
            echo json_encode(array('status' => 'error', 'message' => 'Case number not found'));
        }
    }

    function joiners()
    {
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('joiners list', 'Management/joiners');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'joiners');
    }


    function get_joiners($jd_id = '')
    {
        $model = array('Management_model' => 'get_joinerslist');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $date_filter = ($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
        $from_date = ($_REQUEST['from_date']) ? $_REQUEST['from_date'] : '';
        $to_date = ($_REQUEST['to_date']) ? $_REQUEST['to_date'] : '';
        $country = ($_REQUEST['jd_country']) ? $_REQUEST['jd_country'] : '';


        if(empty($from_date ) && empty($to_date ))
        {
            $to_date  = date('d-m-Y');
            $from_date = date('d-m-Y',strtotime('-30 days'));
           
        }
        if ($office) {
            $condition[] = " h.office = " . $office;

        }

        if ($parent_office) {
            $condition[] = " h.parent_office = " . $parent_office;
        }

        if ($sub_office) {
            $condition[] = " h.sub_office like '%" . $sub_office . "%'";
        }

        if ($country) {
            $condition[] = " a.jd_country like '%".$country."%'";
        }
       
        if (!empty($from_date) && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(a.jd_joining_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($from_date)) . "'";
        }
        if (!empty($to_date) && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(a.jd_joining_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($to_date)) . "'";
        }
        if (!empty($from_date) && $date_filter == 2) {
            $condition[] = "DATE_FORMAT(a.jd_email_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($from_date)) . "'";
        }
        if (!empty($to_date) && $date_filter == 2) {
            $condition[] = "DATE_FORMAT(a.jd_email_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($to_date)) . "'";
        }
        $manual_cond = implode(' AND ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
      
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = $_REQUEST['page'] ?? 1;
            $rows = $_REQUEST['rows'] ?? 1;
            $page = $page - 1;
            $count = $page * $rows;

            foreach ($result as $i => $row) {
                $poffice = empty($row['parent_office']) ? $row['office_name'] : $row['parent_office'];
                $office = empty($row['parent_office']) ? '' : $row['office_name'];
                $from_date = ($row['jd_joining_date']) ? date('d-m-Y', strtotime($row['jd_joining_date'])) : '';
                $to_date = ($row['jd_email_date']) ? date('d-m-Y', strtotime($row['jd_email_date'])) : '';
                $view = anchor('/Management/joinersview/' . base64_encode($row['jd_id']), 'View');
                $edit =  anchor('/Management/joiners_edit/' . base64_encode($row['jd_id']), "Edit");
                $response->rows[$i]['cell'] = [

                    $i + $count + 1,
                    $row['org_name'],
                    $poffice,
                    $office,
                    $row['sub_office'],
                    anchor('/Management/joinersview/' . base64_encode($row['jd_id']), $row['candidate_name']),
                    $row['case_no'],

                    date('d-m-Y', strtotime($row['jd_joining_date'])),
                    date('d-m-Y', strtotime($row['jd_email_date'])),
                    $row['jd_country'],
                    $view . ' / ' . $edit
                ];
            }
        }
        echo json_encode($response);
    }
    // ************************* exporting joiners list *************************************

    function export_joiners()
    {
        $model = array('Management_model' => 'export_joinerslist');
        $office = ($_POST['exp_office']) ? $_POST['exp_office'] : '';
        $name = ($_POST['exp_name']) ? $_POST['exp_name'] : '';
        $organization = ($_POST['exp_org_id']) ? $_POST['exp_org_id'] : '';
        $parent_office = ($_POST['exp_parent_office']) ? $_POST['exp_parent_office'] : '';
        $sub_office = ($_POST['exp_sub_office']) ? $_POST['exp_sub_office'] : '';
        $case_number = ($_POST['exp_case_number']) ? trim($_POST['exp_case_number']) : '';
        $from_date = ($_POST['exp_jd_joining_date']) ? $_POST['exp_jd_joining_date'] : '';
        $to_date = ($_POST['exp_jd_email_date']) ? $_POST['exp_jd_email_date'] : '';
        $date_filter = ($_POST['exp_date_filter']) ? $_POST['exp_date_filter'] : '';

        if(empty($from_date ) && empty($to_date ))
        {
            $to_date  = date('d-m-Y');
            $from_date = date('d-m-Y',strtotime('-30 days'));
           
        }

        if(empty($date_filter))
        {
            $date_filter =1;
        }
        if ($office) {
            $condition[] = " h.office = " . $office;
        }

        if ($parent_office) {
            $condition[] = " h.parent_office = " . $parent_office;
        }

        if ($sub_office) {
            $condition[] = " h.sub_office like '%" . $sub_office . "%'";
        }
   
        if (!empty($from_date) && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(a.jd_joining_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($from_date)) . "'";
        }
        if (!empty($to_date) && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(a.jd_joining_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($to_date)) . "'";
        }
        if (!empty($from_date) && $date_filter == 2) {
            $condition[] = "DATE_FORMAT(a.jd_email_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($from_date)) . "'";
        }
        if (!empty($to_date) && $date_filter == 2) {
            $condition[] = "DATE_FORMAT(a.jd_email_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($to_date)) . "'";
        }


        $manual_cond = (!empty($condition)) ? implode(' AND ', $condition) : '';
        $results = $this->_jqgrid_search($model, $manual_cond);
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Head Office");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Branch Office");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Sub Office");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Name");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Case Number");

            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Joining Date");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Email Date");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Country");


            $cj = 2;
            foreach ($result as $i => $row) {
                $poffice = empty($row['parent_office']) ? $row['office_name'] : $row['parent_office'];
                $office = empty($row['parent_office']) ? '' : $row['office_name'];
                $jd_joining_date = isset($row['jd_joining_date']) ? date('d-m-Y', strtotime($row['jd_joining_date'])) : '';
                $jd_email_date = isset($row['jd_email_date']) ? date('d-m-Y', strtotime($row['jd_email_date'])) : '';

                $objPHPExcel->getActiveSheet()->getStyle('A1:J1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()
                    ->setCellValue('A' . $cj, ($i + $count + 1))
                    ->setCellValue('B' . $cj, $row['org_name'])
                    ->setCellValue('C' . $cj, $poffice)
                    ->setCellValue('D' . $cj, $office)
                    ->setCellValue('E' . $cj, $row['sub_office'])
                    ->setCellValue('F' . $cj, $row['candidate_name'])
                    ->setCellValue('G' . $cj, $row['case_no'])
                    ->setCellValue('H' . $cj, $jd_joining_date)  
                    ->setCellValue('I' . $cj, $jd_email_date)
                    ->setCellValue('J' . $cj, $row['jd_country']);

                $cj++;
            }

            $this->export_excel('A', 'J', 'Joiners_List_', $objPHPExcel);
            exit;
        }


        redirect('Management/joiners');
    }
    // ************************************ joiners view page ************************
    function joinersview()
    {
        $jd_id = base64_decode($this->uri->segment(3));
        $joinersdetails = $this->mm->getjoinersdetails($jd_id);
        $data['joinerscontact'] = $joinersdetails[0];
        $modify = ($joinersdetails) ? (array('joiners', 'edit', 'Modify', 'Management/joinersadd/' . $this->uri->segment(3), '')) : array();

        $data['title'] = "joiners";
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Joiners', 'Management/joiners');
        $this->breadcrumbs->push('View Joiners', 'Management/joinersview');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, $data['title']);
    }
    
    function joiners_edit()
    {

        $jd_id = base64_decode($this->uri->segment(3));
        $joinersdetails = $this->mm->getjoinersdetails($jd_id);
        $data['joinerscontact'] = $joinersdetails[0];
        $subtitle = "Modify";
        $joiners_details = $this->amodel->getDetails(DB_PREFIX . "joiners_data", array('*'), array('jd_id' => $jd_id));
        $formElement = $this->mm->joiners_editform($jd_id, $joiners_details);
        $data['formelements'] = create_form($formElement, $joiners_details, $jd_id);
        $data['joiners_details'] = $joiners_details;
        $data['table'] = form($data['formelements'], $formElement, '', 'Management/modify_joiners', $subtitle, $auth_link, '', base_url());
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Joiners', 'Management/joiners');
        $this->breadcrumbs->push('Modify Joiners', 'Management/joiners_edit');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, '');
    }
    
    function modify_joiners() 
    {
        $formData = $this->security->xss_clean($this->input->post());
        $jd_id = $formData['jd_id'];
        $jd_case_no = $formData['jd_case_no'];
        $jd_country = $formData['jd_country'];
        if (!$this->mm->validate_case_no_in_client_request($jd_case_no)) {
            $this->session->set_flashdata('error', 'Case number does not exist in joiners list.');
            redirect('Management/joiners_edit/' . base64_encode($jd_id));
            return;
        }
        if ($this->mm->is_case_no_duplicate($jd_case_no, $jd_id)) {
            $this->session->set_flashdata('error', 'Case number already exists in another record.');
            redirect('Management/joiners_edit/' . base64_encode($jd_id));
            return;
        }
        $jd_joining_date = date('Y-m-d', strtotime($formData['jd_joining_date']));
        $jd_email_date = date('Y-m-d', strtotime($formData['jd_email_date']));
        $formArray['jd_case_no'] =   $jd_case_no;
        $formArray['jd_joining_date'] =   $jd_joining_date;
        $formArray['jd_email_date'] =   $jd_email_date;
        $formArray['jd_country'] =   $jd_country;
        $this->db->where('jd_id', $jd_id);
        $this->db->update(DB_PREFIX . 'joiners_data', $formArray);
        $this->session->set_flashdata('success', 'Joiner details updated successfully.');
        redirect('Management/joiners');
    }
    // ***************************** end*** joiners Code ******* ka added on sep 4**************

}


