<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require_once ('Common.php');
require_once ('./PHPExcel-1.8/Classes/PHPExcel.php');
class Meeting extends Common {
    protected static $meetings_model = 'Meetings_model';  
    protected $breadcrumb = 'breadcrumb'; 
    protected $meeting_presale = 'Meeting/presale';
    protected $index_dashboard = 'Index/dashboard';
    protected $meeting_meetingcommonview = 'Meeting/meetingcommonview/';
    protected $meeting_feature = 'meeting'; 
    protected $search_feature = 'search'; 
    protected $date_format_created_frm = "DATE_FORMAT(a.created_on ,'%Y-%m-%d') >= '";
    protected $date_format_created_to = "DATE_FORMAT(a.created_on ,'%Y-%m-%d') <= '";
    protected $flt_first_name = " c.first_name ";
    protected $flt_last_name = " c.last_name ";
    protected $active = "Active";
    protected $deactive = "Deactive";
    protected $meeting_ordercommonview = "/Meeting/ordercommonview/";
    protected $order_status='';
    protected $per_annum_cost='';

    function __construct() 
    {
    parent::__construct();
    $this->_check_userlogin ();
    $this->load->model(self::$meetings_model,'mm');
    $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
    $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','jquery-ui-1.10.4','highcharts','exporting','jquery.validate','grid.locale-en','jquery.jqGrid.min','jquery-ui-1.8.16.custom.min', 'commonjs','jquery.timePicker','autocomplete'));
    }
       ////************************** PRESALE*********** */
        function presale()  {
                $this->_check_featureauth ( $this->meeting_feature,$this->search_feature ); 
                $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
                $this->breadcrumbs->push('Presale', $this->meeting_presale);
                $data[$this->breadcrumb]=$this->breadcrumbs->show();
                $this->amodel->pagerender($data, $this->meeting_feature);
        }
        function get_presalelists() {
                $model = array(self::$meetings_model=>'get_presalelisted');
                $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
                $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
                $a_status = ($_REQUEST['a_status']) ? $_REQUEST['a_status'] : '';
                $contact_person = ($_REQUEST['contact_person']) ? $_REQUEST['contact_person'] : '';
                $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
                $a_date=($_REQUEST['a_date']) ? $_REQUEST['a_date'] : '';
                $t_date=($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
                $mf_date=($_REQUEST['mf_date']) ? $_REQUEST['mf_date'] : '';
                $mt_date=($_REQUEST['mt_date']) ? $_REQUEST['mt_date'] : '';
                $nextf_date=($_REQUEST['nextf_date']) ? $_REQUEST['nextf_date'] : '';
                $nextt_date=($_REQUEST['nextt_date']) ? $_REQUEST['nextt_date'] : '';
                if($name){
                $condition[]=" a.organisation like '%".$name."%'";
                }
                if($office){
                $condition[]=" a.office like '%".$office."%'";
                }
                if($contact_person){
                $condition[]=" a.contact_person like '%".$contact_person."%'";
                }
                if($a_date){
                $condition[]="DATE_FORMAT(a.date_of_call ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($a_date))."'";
                }
                if($a_status==1){
                $condition[]=" a.status = 1";
                }
                if($a_status==2){
                $condition[]=" a.status = 2";
                }
                if($a_status==3){
                $condition[]=" a.status = 3";
                }
            if($t_date){
                $condition[]="DATE_FORMAT(a.date_of_call ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
            }
            if($mf_date){
                $condition[]="DATE_FORMAT(a.meeting_schedul_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($mf_date))."'";
            }
            if($mt_date){
                $condition[]="DATE_FORMAT(a.meeting_schedul_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($mt_date))."'";
            }
             if($nextf_date){
                $condition[]="DATE_FORMAT(a.next_call ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($nextf_date))."'";
            }
            if($nextt_date){
                $condition[]="DATE_FORMAT(a.next_call ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($nextt_date))."'";
            }
                if($term)
        {
                $search = explode(' ', $term);
                foreach($search as $t) {
                    $not        = '';
                    $operator    = 'OR';
                    if(substr($t,0,1) == '-')
                    {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    $t        = substr($t,1,strlen($t));
                    }
                    $like    = '';
                    $like    .= "( a.office ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." a.organisation ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." a.contact_person ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." a.status ".$not."LIKE '%".$t."%' ) " ;
                    $condition[]=$like;
            }
        }
            $manual_cond=implode(' and ',$condition);
                if($a_status){
            if(empty($manual_cond)){
                $manual_condition2=" a.status = ".$a_status;
               }
                else{
                $manual_condition2=" a.status = ".$a_status." and ".$manual_cond;
                }
                }
                else{
                $manual_condition2=$manual_cond;
                }
            $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0]; 
        $result = $results[1];
            if ($result) {   
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows; 
            foreach ( $result as $i => $row ) {
                    if($row['meeting_schedul_on'] == "0000-00-00")
                    {
                        $timeofmeeting='';
                        
                    }else{
                    $timeofmeeting=date('d-m-Y',strtotime($row['meeting_schedul_on']));
                    }
                    if($row['date_of_call'] ){
                            $row['date_of_call']=date('d-m-Y',strtotime($row['date_of_call']));
                    }
                    if($row['status']=='1'){
                        $prestatus='Hot';
                    }else if($row['status']=='2'){
                         $prestatus='Lukeworm';
                    }else if($row['status']=='3'){
                         $prestatus='Cold';
                    }
                    if($row['next_call'] == '0000-00-00'){
                        $next_call_date = '';
                    }
                    else
                    {
                       $next_call_date =date('d-m-Y',strtotime($row['next_call']))  ;
                    }
                    if($row['time'] == '00:00:00'){
                        $time = '';
                    }
                    else
                    {
                      $time = $row['time'];
                    }
                    
                    $next_call_date = $next_call_date . '  ' . $time;
                                       
                $response->rows [$i] ['cell'] = array ( $i+$count+1,
                $row['org_name'],$row['parent_office'],$row['date_of_call'],$row['contact_person'],$prestatus,$timeofmeeting,$next_call_date,(anchor('/Meeting/presaleview/'.base64_encode($row['id']), "View"). '/' .anchor('/Meeting/presaleadd/'.base64_encode($row['id']), 'Edit'))
                );
            }
        }
        echo json_encode ( $response );
        }
       function get_presale() {
                $this->_check_featureauth ( $this->meeting_feature, 'search' );
                $model = array(self::$meetings_model=>'get_presalelist');
           $results = $this->_jqgrid_search($model);
           $response = $result[0]; $result = $results[1];
           if ($result) {
           $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
           $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
           $page=$page - 1;
           $count=$page * $rows;
            foreach ( $result as $i => $row ) {
                    if($row['meeting_schedul_on'] ){
                            $row['meeting_schedul_on']=date('d-m-Y',strtotime($row['meeting_schedul_on']));
                    }
                    if($row['meeting_schedul_on'] == "0000-00-00")
                    {
                        $row['meeting_schedul_on']='';
                    }
                    if($row['date_of_call'] ){
                            $row['date_of_call']=date('d-m-Y',strtotime($row['date_of_call']));
                    }
                $response->rows [$i] ['cell'] = array ( $i+$count+1,
                anchor('/Meeting/presaleview/'.base64_encode($row['id']), $row['presale_code']),$row['organisation'],$row['office'],$row['date_of_call'],$row['contact_person'],$row['meeting_schedul_on'],anchor('/Meeting/presaleadd/'.base64_encode($row['id']), "Edit")
                );
            }
        }
        echo json_encode ($response);
        }
       function presaleadd()
       {
                $id = base64_decode($this->uri->segment(3));
                $title = "Create";
             $presale_details = $this->amodel->getDetails(DB_PREFIX . "presale", array('*'), array('id' => $id));
            
             $industry_all = $this->amodel->getDetails(DB_PREFIX . "presale_industry", array('*'), array('org_id' => $id));

              if(!empty($industry_all)){

                foreach ($industry_all as $key=>$industry_id) {
                        $ind_id[$key] = $industry_id['industry_id'];
                   } 
            } 
             
            $presale_details[0]['type_of_industry'] = $ind_id;

                $data['organisation_list'] = $this->mm->get_autosuggest('organisation','org_name');
                $data['office_list']    = $this->mm->get_autosuggest('office','office_name');
                if ($presale_details) {
                        $this->_check_featureauth ( $this->meeting_feature, 'edit' );
                        $subtitle = "Modify";
                        $auth_link = array(     array($this->meeting_feature,'search','Search',$this->meeting_presale,'')
                          );
                          $office = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id', 'office_name'), array( 'parentoffice_id'=>$presale_details[0]['organisation']) );
             $parent_office = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id','office_name'),array('parent_office' => $presale_details[0]['organisation']));
                } else {
                        $subtitle = "Create";
                        $auth_link = array(     array($this->meeting_feature,'search','Search',$this->meeting_presale,'')
                          );
                } 
                $parent_office1 = $this->amodel->fetchDropdowndetails(DB_PREFIX . "organisation", array('id','org_name'),array('id !=' => 1));
                $calls =array(1 => 'Next call', 2 => 'Meeting');
                $ck =array(1 => 'Hot', 2 => 'Lukeworm', 3 => 'Cold'); 
                $industry = $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id','name'),array('key ' => 'Industry','id !=' => 1));
                $formElement = array(array('date_of_call' => array('text', 'date_of_call', 'R|Z|RO', 'R|Z|RO','', 'RF',''),'call2' => array('', '', '','',array('1' => ''), '', ''),'organisation' => array('text', 'organization', 'R|Z', 'R|Z','' , 'RF', ''),'parent_office' => array('text', 'office1', 'Z', 'Z', '', '', ''),'type_of_industry' => array('multiselect','type_of_industry','Z','Z',$industry,'',''),'num_emp' => array('text','num_emp','Z|D','Z|D','','',''),'address1' => array('textarea','address1','Z','Z','','',''),'address2' => array('textarea','address2','Z','Z','','',''),'contact_num' => array('text','contact_num','N|fix:10','N|fix:10','','',''),'contact_num1' => array('text','contact_num1','N|fix:10','N|fix:10','','',''),'email' => array('text','email','Z','Z','','RF',''),'contact_person' => array('text','contact_person','R|Z','R|Z','','RF',''),'contact_desig' =>array('text','contact_desig','R|Z|MC-getdesig','R|Z|MC-getdesig','','RF',''),"",
                'label'=>array('radio','label','MC-checkcon','MC-checkcon',$calls,'',''),'meeting_option' => array('radio','meeting_option','MC-checkcon','MC-checkcon','','',''),'next_call' => array('text', 'next_call', 'Z|RO|MC-next', 'Z|RO|MC-next','', '',''),'meeting_with' => array('text','meeting_with','Z','Z','','',''),'meeting_schedul_on' => array('text', 'meeting_schedul_on', 'Z|RO|MC-meet', 'Z|RO|MC-meet','', '',''),'time' => array('text', 'time', 'Z|RO|MC-time', 'Z|RO|MC-time', '', ''),'comments'=>array('textarea','comments','Z','Z','','',''),'website_url' => array('text','website_url','Z','Z','','',''),'status' => array('radio','status','MC-checkcon','MC-checkcon',$ck,'RF','') ));
                $data['table'] = form(create_form($formElement,$presale_details,$id), $formElement, 'presale', $this->meeting_presale, $subtitle, $auth_link, '', base_url());
                $this->mm->presaledml($id);
                $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
                $this->breadcrumbs->push('Presale', $this->meeting_presale);
                $this->breadcrumbs->push('Add/Edit Presale', 'Meeting/presaleadd');
                $data[$this->breadcrumb]=$this->breadcrumbs->show();
                $this->amodel->pagerender($data, 'presaleadd');
       }  
       function presaleview()
       {
                $this->_check_featureauth ( $this->meeting_feature, 'view' ); // Check if user is allowed for action
                $subtitle="Meeting";
                $data['presale_id']=$presale_id = base64_decode($this->uri->segment(3)); 
                $url = base_url() . "Meeting/presale";
                $presaleDetails = $this->mm->getpresaledetails($presale_id);
                $data['presale_details'] = $presaleDetails[0];
                $presalecalldetails = $this->amodel->getDetails(DB_PREFIX . "admin_add_calls", array('*'), array('presale_id' => $presale_id),$this->db->order_by("id","desc"));
                $data['contact_name_add']=$presalecalldetails[0]['contact_person'];
                $data['designation_contact']=$presalecalldetails[0]['designation_person'];
                $data['mobile']=$presalecalldetails[0]['contact_number'];
                $data['email']=$presalecalldetails[0]['email'];
                $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
                $this->breadcrumbs->push('Presale', $this->meeting_presale);
                $this->breadcrumbs->push('Presale View', 'Meeting/presaleview');
                $data[$this->breadcrumb]=$this->breadcrumbs->show();
                 $data['id']=$candidate_id=base64_decode($this->uri->segment(3));    
                $id = base64_decode($this->uri->segment(3));
                $this->db->select('organisation');
                $orderid=$this->db->get_where(DB_PREFIX .'presale',array('id'=> $id ))->result_array();
                $data['organisation_name'] = ($orderid[0]['organisation']) ? '( '.$orderid[0]['organisation'].' )' : '';
                $this->amodel->pagerender($data);
       }  
       function get_call_details()
       {
            $presale_id = ($_REQUEST['presale_id']) ? $_REQUEST['presale_id'] : '';
            $mobile = ($_REQUEST['mobile']) ? $_REQUEST['mobile'] : '';
            if($presale_id)
            $condition[]=" presale_id = ".$presale_id;
            if($mobile)
            $condition[]=" contact_no=".$mobile;
            $manual_cond=implode(' and ',$condition);
            $model = array(self::$meetings_model=>'verfierdetails');
            $results = $this->_jqgrid_search($model,$manual_cond); 
            $response = $results[0];  $result = $results[1];        
            if ($result) { 
            foreach ( $result as $i => $row ) {
            $response->rows [] ['cell'] = array ( $i+1,$row['contact_person'],$row['designation_person'],$row['contact_number'],$row['email'],date('d-m-Y',strtotime($row['created_at'])),$row['mom'],$row['first_name']);
            }
           }
        echo json_encode($response);
       }   
       
       //************************* PRESALE END**************/
      function meetingsearch() {
            $this->_check_featureauth ( $this->meeting_feature, 'search' ); 
                $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
                $this->breadcrumbs->push('Meeting', 'Meeting/meetingsearch');
                $data[$this->breadcrumb]=$this->breadcrumbs->show();
                
                $this->amodel->pagerender($data, $this->meeting_feature);
       }
        function get_meeting( $org_id = '' ){ 
                        $this->_check_featureauth ( $this->meeting_feature, 'search' ); 
        $model = array(self::$meetings_model=>'get_meetinglist');
        
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
        $a_status = ($_REQUEST['a_status']) ? $_REQUEST['a_status'] : '';
        $createdby = ($_REQUEST['createdby']) ? $_REQUEST['createdby'] : '';
        $a_date=($_REQUEST['a_date']) ? $_REQUEST['a_date'] : '';
        $t_date=($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $mf_date=($_REQUEST['mf_date']) ? $_REQUEST['mf_date'] : '';
        $mt_date=($_REQUEST['mt_date']) ? $_REQUEST['mt_date'] : '';
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
        if($office){
        $condition[]=" a.client_id = ".$office;
        }
         if($org_id){
        $condition[]=" p.id = ".$org_id;
         }
        if($name){
        $condition[]=" ( c.first_name like '%".$name."%' OR  c.last_name like '%".$name."%' OR  a.name like '%".$name."%') ";
        }
        if($createdby){
        $condition[]="p.user_id = ".$createdby;
        }
        if($a_date){
        $condition[]=$this->date_format_created_frm.date('Y-m-d',strtotime($a_date))."'";
        }
        if($t_date){
        $condition[]=$this->date_format_created_to.date('Y-m-d',strtotime($t_date))."'";
        }
        if($mf_date){
        $condition[]="DATE_FORMAT(a.on_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($mf_date))."'";
        }
        if($mt_date) {
        $condition[]="DATE_FORMAT(a.on_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($mt_date))."'";
        }
           if($term)
        {
                $search = explode(' ', $term);
                foreach($search as $t) {
                    $not        = '';
                    $operator    = 'OR';
                    if(substr($t,0,1) == '-')
                    {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    $t        = substr($t,1,strlen($t));
                    }
                    $like    = '';
                    $like    .= "( p.organisation ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator.$this->flt_first_name.$not."LIKE '%".$t."%' " ;
                    $like    .= $operator.$this->flt_last_name.$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." a.name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." p.user_id ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." p.status ".$not."LIKE '%".$t."%' ) " ;
                   $condition[]=$like;
               
            }
        }
            $manual_cond=implode(' and ',$condition);
            if($a_status){
            if(empty($manual_cond)){
                $manual_condition2=" p.status = ".$a_status;
               }
                else{
                $manual_condition2=" p.status = ".$a_status." and ".$manual_cond;
                }
                }
                else{
                $manual_condition2=$manual_cond;
                }
                $results = $this->_jqgrid_search($model,$manual_condition2);
                $response = $results[0];  $result = $results[1]; 
                   if ($result) {   
                   $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows; 
                    foreach ( $result as $i => $row ) {
                            if($row['on_date']=="0000-00-00") 
                                 { 
                                $row['on_date']="";
                                } 
                         if($row['on_date']) 
                                 { 
                                $row['on_date']=date('d-m-Y',strtotime($row['on_date']));
                                
                                } 
                                if($row['created_on']) 
                                 { 
                                $row['created_on']=date('d-m-Y',strtotime($row['created_on']));
                                }
                                if($row['status']=='1'){
                        $premeetingstatus='Hot';
                    }else if($row['status']=='2'){
                         $premeetingstatus='Lukeworm';
                    }else if($row['status']=='3'){
                         $premeetingstatus='Cold';
                    } 
                    if($row['user_id']=='10'){
                        $precreated_by='Presale P';
                    }else if($row['user_id']=='11'){
                         $precreated_by='Business Development BD';
                    }else if($row['user_id']=='1'){
                         $precreated_by='Admin Dcode';
                    } 
                    $response->rows [$i] ['cell'] = array ( $i+$count+1,
                        anchor('/Meeting/meetingcommonview/'.base64_encode($row['id']), $row['name']),$row['organisation'],$row['on_date'],$precreated_by,$premeetingstatus,$row['created_on'],(anchor('/Meeting/meetingcommonview/'.base64_encode($row['id']),"View ").'/ '.anchor('/Meeting/meetingsearchadd/'.base64_encode($row['id']),"Edit"))
                        );
                    }
                }
                echo json_encode($response);
                }
        function meetingsearchadd() {
                $this->_check_featureauth ( $this->meeting_feature, 'search' );
                $id = base64_decode($this->uri->segment(3));
                $title = "Create";
                $send=array(0 => 'Meet', 1 => 'Call');
                $user_details = $this->amodel->getDetails(DB_PREFIX . "meeting", array('*'), array('id' => $id));
                $rem_emil=array();
                $all_emails=array();
                if ($user_details) {
                $rem_emails=$this->mm->getemails($id);
                $all_emails=$this->mm->getallemail($user_details[0]['client_id']);
                if(!empty($rem_emails))
                {
                foreach($rem_emails as $key=>$value){
                $rem_email[]=$value['email'];
                }
                }
                $user_details[0]['rem_email']=$rem_email;
                $this->_check_featureauth ( $this->meeting_feature, 'edit' ); 
                $subtitle = "Modify";
                $auth_link = array(     array($this->meeting_feature,'search','Search','Meeting/meetingsearch','') );
                } else {
                $this->_check_featureauth ($this->meeting_feature, 'add' ); 
                $subtitle = "Create";
                $auth_link = array(     array($this->meeting_feature,'search','Search','Meeting/meetingsearch','') );
                } 
                $date = date('Y-m-d');
                $presaleids = $this->amodel->fetchDropdowndetails(DB_PREFIX . "presale p ", array('p.id',"concat_ws(' :: ',presale_code,organisation )"),array('p.status'=>0,'p.status'=>1),0);
                $formElement = array(array( 'client_id' => array('text', 'client_id', 'R|Z|Y|MC-checkemail', 'R|Z|Y|MC-checkemail','','RF' ), 'name' => array('text', 'name', 'R|Z', 'R|Z', '', 'RF', ''),'on_date' => array('text', 'on_date', 'RO|Z', 'RO|Z','', '',''), 'time' => array('text', 'time', 'Z|RO|MC-time', 'Z|RO|MC-time','', '',''),'email' => array('text', 'email', 'Z|MC-checkemail', 'Z|MC-checkemail','', ''),'lead_resource'=> array('dropdown', 'lead_resource', 'R|Z|Y', 'R|Z|Y',$this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id','name'),array('key'=>'Lead Source')),'RF'),'mom' => array('textarea', 'mom', 'Z', 'Z', '', '', ''),'lead_name' => array('text', 'lead_name', 'R|Z', 'R|Z', '', 'RF', ''),'requirement' => array('textarea', 'requirement', 'Z', 'Z', '', '', '')));
                $data['table'] = form(create_form($formElement,$user_details,$id), $formElement, 'meeting_add', 'Meeting/meetingsearch', $subtitle, $auth_link, '', base_url());
                $this->mm->meetingdml($id);
                $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
                $this->breadcrumbs->push('Meeting', 'Meeting/meetingsearch');
                $this->breadcrumbs->push('Add Meeting', 'Meeting/meetingsearchadd');
                $data[$this->breadcrumb]=$this->breadcrumbs->show();
                $this->amodel->pagerender($data, 'meeting_add');
        }
        function meetingcommonview() {
    
                $this->_check_featureauth ( $this->meeting_feature, 'view' ); 
                $subtitle="Meeting";
                $meeting_id = base64_decode($this->uri->segment(3));
                $subtitle = "Common view";
                $url = base_url() . "Meeting/meetingsearch";
                $userDetails = $this->mm->getmeetingdetails($meeting_id); 
                $data['meeting_value'] = $meeting_id;
                $data['usercontact'] = $userDetails[0];
                $data['useremails'] = $userDetails;
                $data['proposal'] = $this->mm->getproposaldetails($meeting_id);
                $data['followup'] = $this->mm->getfollowupdetails($meeting_id);
                $data['order'] = $this->mm->getoerderdetails($meeting_id);
                $data['calls'] = $this->mm->getcallsdetails($meeting_id);
                $data['title']="meeting";
                $data['subtitle']="proposal";
                $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
                $this->breadcrumbs->push('Meeting', 'Meeting/meetingsearch');
                $this->breadcrumbs->push('Meeting Details', 'Meeting/meetingcommonview');
                $data[$this->breadcrumb]=$this->breadcrumbs->show();
                $this->amodel->pagerender($data,$data['title'],$data['subtitle']);

        }

        public function meetingdelete() {
                $this->_check_featureauth ( $this->meeting_feature, 'delete' ); 
                $data['id'] = $id = base64_decode($this->uri->segment(3));
                $url = base_url() . "Meeting/meetingsearch";
                $pagetitle = "Meeting_delete";
                $formElement = array(array('confirm' => array('textarea', 'sure_msg', 'R|row:5|col:20|W')));
                $subtitle = "Delete";
                $data['formelements'] = create_form($formElement);
                        $auth_link = array(     array('users','search','Search','Meeting/meetingsearch','')
                                  );
                $data['meetingdelete'] = form($data['formelements'], $formElement, 'user', 'Meeting/meetingsearch', $subtitle, $auth_link, 'delete');

                $this->mm->meeting_delete($id);
                $this->amodel->pagerender($data, 'user');
            }
        function order() {
                $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
                $this->breadcrumbs->push('Order', 'Meeting/order');
               $data[$this->breadcrumb]=$this->breadcrumbs->show();
            $this->amodel->pagerender($data, 'order');
        }   
        function get_orderlist($office_name = 0){ 
            $this->_check_featureauth ( $this->meeting_feature, 'search' );
            $model = array(self::$meetings_model=>'get_orderlist');
            $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
            $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
            $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
            $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
            $billing_type = ($_REQUEST['billing_type']) ? $_REQUEST['billing_type'] : '';
            $order_name = ($_REQUEST['order_name']) ? $_REQUEST['order_name'] : ''; 
            $code = ($_REQUEST['code']) ? $_REQUEST['code'] : ''; 
            $agreement = ($_REQUEST['agreement']) ? $_REQUEST['agreement'] : '';
            $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
            $created_by=($_REQUEST['created_by']) ? $_REQUEST['created_by'] : '';
            $a_date=($_REQUEST['a_date']) ? $_REQUEST['a_date'] : '';
            $t_date=($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
            $status=($_REQUEST['status']) ? $_REQUEST['status'] : ''; 
            if($office){
            $condition[]=" a.office = ".$office;
            }
            if($parent_office){
            $condition[]=" a.parent_office = ".$parent_office;
            }
            if($sub_office){
            $condition[]=" a.sub_office = ".$sub_office;
            }
            if($org_id){
            $condition[]=" a.organisation = ".$org_id;
            }
            if($order_name){
            $condition[]=" a.order_name like '%".$order_name."%'";
            }
            if($billing_type){
            $condition[]=" a.billing_type = ".$billing_type;
            }
            if($status==1){ 
                $condition[]=" a.status = 1 ";
            }
            if($status==2){ 
                $condition[]=" a.status = 0 ";
            }
            if($agreement==1){
            $condition[]=" a.agreement = 1";
            }
            if($agreement==2){
            $condition[]=" a.agreement = 0";
            }
            if($created_by){
            $condition[]=" c.first_name like '%".trim($created_by)."%'";
            }
            if($a_date){
            $condition[]=$this->date_format_created_frm.date('Y-m-d',strtotime($a_date))."'";
            }
            if($t_date) {
            $condition[]=$this->date_format_created_to.date('Y-m-d',strtotime($t_date))."'";
            }
          if($term)
           {
                $search = explode(' ', $term);
                foreach($search as $t) {
                    $not        = '';
                    $operator    = 'OR';
                    if(substr($t,0,1) == '-')
                    {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    $t        = substr($t,1,strlen($t));
                    }
                     $like    = '';
                    $like    .= "( org.org_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." a.order_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." a.order_code ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." off.office_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." p.office_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' " ;

                    $like    .= $operator." a.created_on".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
                    
                    $like    .= $operator." a.billing_type ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator.$this->flt_first_name.$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." c.middle_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator.$this->flt_last_name.$not."LIKE '%".$t."%' ) " ;
                    $condition[]=$like;
                }
            }
            $manual_cond=implode(' and ',$condition);
            $results = $this->_jqgrid_search($model,$manual_cond); 
            $response = $results[0]; 
             $result = $results[1]; 
             if ($result) {
             $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
                    foreach ( $result as $i => $row ) {
                      
                    if($row['on_date']) {
                    $row['on_date']=date('d-m-Y',strtotime($row['on_date']));
                    }
                    if($row['created_on']) {
                    $row['created_on']=date('d-m-Y',strtotime($row['created_on']));
                    }
                $billing_type='';
                if($row['billing_type']==515) {
                    $billing_type='Against Profile Submission';
                }
                else if($row['billing_type']==516){
                    $billing_type='Against Final Report';
                }
                $agreement='';
                if($row['agreement'] == 1) 
                { $agreement='Yes'; 
                 }    
                else if($row['agreement']==0)
                 {  $agreement='No'; 
                  }  
           $valcchk = $this->amodel->getDetails(DB_PREFIX . "digital_candidate_list a", array('a.name'), array('a.id'=>$row['candidate_list']));
            $candidate_list =     $valcchk[0]['name'];

            if($row['per_annum_cost'] == 1){ 
                 $order = 'INR 1500';
            }else if($row['per_annum_cost'] == 2)
            {
               $order = 'INR 4000';
            }
            else if($row['per_annum_cost'] == 3)
            {
              $order = 'INR 5000';
            }
            else if($row['per_annum_cost'] == 4)
            {
              $order = 'Nil';
            }
            else
            {
                $order = "";
            }
                            
             $this->order_status=($row['status']==1)?$this->active:$this->deactive ;  
             $permission= ($row['status']==1)?(anchor('/Meeting/orderadd/'.base64_encode($row['id']),"Edit"). '/' .anchor($this->meeting_ordercommonview.base64_encode($row['id']), 'View')): anchor($this->meeting_ordercommonview.base64_encode($row['id']), 'View');    
    $response->rows [$i] ['cell'] = array ( $i+$count+1,
        anchor($this->meeting_ordercommonview.base64_encode($row['id']), $row['order_name']),$row['org_name'],$row['parent_office'],$row['office'],$row['office_name'],$billing_type,$agreement,$this->order_status,      $candidate_list,$order,$row['created_by'],$row['created_on'],$permission
        );
                    }
                }
                echo json_encode($response);
                }
        /* export order list */
        function export_order() { 
            $model = array(self::$meetings_model=>'get_orderlist');
            $org_id = ($_POST['exp_org_id']) ? $_POST['exp_org_id'] : '';
            $parent_office = ($_POST['exp_parent_office']) ? $_POST['exp_parent_office'] : '';
            $office = ($_POST['exp_office']) ? $_POST['exp_office'] : '';
            $sub_office = ($_POST['exp_sub_office']) ? $_POST['exp_sub_office'] : '';
            $billing_type = ($_POST['exp_billing_type']) ? $_POST['exp_billing_type'] : '';
            $order_name = ($_POST['exp_order_name']) ? $_POST['exp_order_name'] : ''; 
            $agreement = ($_POST['exp_agreement']) ? $_POST['exp_agreement'] : '';
            $term=($_POST['exp_search_term']) ? $_POST['exp_search_term'] : '';
            $created_by=($_POST['exp_created_by']) ? $_POST['exp_created_by'] : '';
            $a_date=($_POST['exp_a_date']) ? $_POST['exp_a_date'] : '';
            $t_date=($_POST['exp_t_date']) ? $_POST['exp_t_date'] : '';
            $status=($_POST['exp_status']) ? $_POST['exp_status'] : '';
            if($office){
                $condition[]=" a.office = ".$office;
            }
            if($parent_office){
                $condition[]=" a.parent_office = ".$parent_office;
            }
            if($sub_office){
                $condition[]=" a.sub_office = ".$sub_office;
            }
            if($org_id){
                $condition[]=" a.organisation = ".$org_id;
            }
            if($order_name){
                $condition[]=" a.order_name like '%".$order_name."%'";
            }
            if($status==1){ 
                $condition[]=" a.status = 1 ";
            }
            if($status==2){ 
                $condition[]=" a.status = 0 ";
            }
            if($agreement==1){
                $condition[]=" a.agreement = 1";
            }
            if($agreement==2){
            $condition[]=" a.agreement = 0";
            }
            if($created_by){
            $condition[]=" c.first_name like '%".trim($created_by)."%'";
            }
            if($billing_type){
            $condition[]=" a.billing_type = ".$billing_type;
            }
            if($a_date){
            $condition[]=$this->date_format_created_frm.date('Y-m-d',strtotime($a_date))."'";
            }
            if($t_date) {
            $condition[]=$this->date_format_created_to.date('Y-m-d',strtotime($t_date))."'";
            }
          if($term)
           {
                $search = explode(' ', $term);
                foreach($search as $t) {
                    $not        = '';
                    $operator    = 'OR';
                    if(substr($t,0,1) == '-')
                    {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    $t        = substr($t,1,strlen($t));
                    }
                     $like    = '';
                    $like    .= "( org.org_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." a.order_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." a.order_code ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." off.office_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." p.office_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." o.office_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." a.created_on".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
                    $like    .= $operator." a.billing_type ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator.$this->flt_first_name.$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." c.middle_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator.$this->flt_last_name.$not."LIKE '%".$t."%' ) " ;
                    $condition[]=$like;
                }
            }
            $manual_cond=implode(' and ',$condition);
            $results = $this->_jqgrid_search($model,$manual_cond); 
            $response = $results[0]; 
             $result = $results[1]; 
             if ($result) {
             $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Order Name");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Head Office");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Branch Office");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Sub Office");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Billing Type");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Agreement");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Status");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Created By");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "Created On");
            $ci=2;
            foreach ( $result as $i => $row ) {
                if($row['created_on']) {
                    $row['created_on']=date('d-m-Y',strtotime($row['created_on']));
                }
                $billing_type='';
                if($row['billing_type']==515) {
                    $billing_type='Against Profile Submission';
                }
                else if($row['billing_type']==516){
                    $billing_type='Against Final Report';
                }
                $agreement='';
                if($row['agreement'] == 1){ 
                    $agreement='Yes'; 
                }    
                else if($row['agreement']==0){ 
                    $agreement='No'; 
                }  
             $this->order_status=($row['status']==1)?$this->active:$this->deactive ;  
             $objPHPExcel->getActiveSheet()->getStyle('A1:K1')->getFont()->setBold(true);
             $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                                  ->setCellValue('B' . $ci, $row['order_name'])
                                  ->setCellValue('C' . $ci, $row['org_name'])
                                  ->setCellValue('D' . $ci, $row['parent_office'])
                                  ->setCellValue('E' . $ci, $row['office'])
                                  ->setCellValue('F' . $ci, $row['office_name'])
                                  ->setCellValue('G' . $ci, $billing_type) 
                                  ->setCellValue('H' . $ci, $agreement)
                                  ->setCellValue('I' . $ci, $this->order_status)
                                  ->setCellValue('J' . $ci, $row['created_by'])
                                  ->setCellValue('K' . $ci, $row['created_on']);
            $ci++;
            }
            $this->export_excel('A','K','Order_List_',$objPHPExcel);
              exit;    
            }
             redirect('Meeting/order');  
        }        
        function orderadd() {
            $this->_check_featureauth ( $this->meeting_feature, 'search' );
            $order_id = ($this->uri->segment(4) == 'xy') ? 0 :base64_decode($this->uri->segment(3)) ;
                $meeting_id = $data['meeting_id']= ($this->uri->segment(4) == 'xy') ? base64_decode($this->uri->segment(3)) : '';
            $data['order_details'] = $order_details = $this->amodel->getDetails(DB_PREFIX . "order", array('*'), array('id' => $order_id));
                $meeting_details = $this->amodel->getDetails(DB_PREFIX . "meeting", array('*'), array('id' => $meeting_id));
                $all_emailid = $this->amodel->getDetails(DB_PREFIX . "user",array('id','email'));
                $data['org_id'] =  $meeting_details[0]['client_id'];
                if ($order_details) { 
                    $data['email_org']=$this->mm->getemail($order_details[0]['office']);
                    $selected_emails = $email_org = $this->amodel->getDetails(DB_PREFIX . "emails", array('*'), array('order_id' => $order_id));
                    foreach($selected_emails as $email){
                    $emails[]=$email['org_email'];
                    }
                    $data['selected_email']=$emails;
                    $this->_check_featureauth ( $this->meeting_feature, 'edit' ); 
                    $subtitle = "Modify";
                   $office = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id','office_name'),array('id' => $order_details[0]['parent']));
                    $parent = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id','office_name'),array('id' => $order_details[0]['parent_office']));
                    $level = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id','office_name'),array('id' => $order_details[0]['level']));
                    $contact = $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id','name'),array('id' => $order_details[0]['contact_for']));
                    $user=$this->amodel->fetchDropdowndetails(DB_PREFIX . "user", array('id','first_name'),array('id' => $order_details[0]['contact_person']));
                   $emails = $this->amodel->fetchDropdowndetails(DB_PREFIX . "emails", array('order_id','org_email'),array('order_id' => $email_org[0]['order_id']));
                } else {
                    $this->_check_featureauth ($this->meeting_feature, 'add' ); 
                    $subtitle = "Create";
                    $contact = $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id', 'name'),array('key' => 'contact_for'));
                } 
                $agreement=array( 1 => 'Yes',0 => 'No');
                $label_exp=array(1 => 'Expiry date', 2 => 'Other');
                $this->order_status=array(""=>'Select',1 => $this->active,0 => $this->deactive);
                $this->per_annum_cost=array(""=>'Select',1 => 'INR 1500',2 => 'INR 4000' , 3 =>'INR 5000' , 4 => 'Nil' );
                //$expiry_date=($order_details['expiry_date'])?date('d-m-Y',strtotime($order_details['expiry_date'])):'';
                $formElement = array(array( 'order_name' => array('text', 'order_name', 'R|Z', 'R|Z|DIS',$order_details['order_name'],'RF','' ), 'organisation' => array('dropdown', 'organisation', 'R|Y', 'R|Y|MC|RO',$this->amodel->fetchDropdowndetails(DB_PREFIX . "organisation", array('id','org_name'),array('user_type'=>2)),'RF','' ),'parent_office'=>array('dropdown','parent_office', 'R|Y', 'Y|DIS', $parent, 'RF', ''),'office' => array('dropdown', 'office_name', 'Y', 'Y|DIS', $office, '', ''),'sub_office'=>array('dropdown','sub_office', 'Y', 'Y|DIS', $level, '', ''),'credit_limit' => array('dropdown', 'credit_limit', 'R|Y', 'R|Y', $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'credit_limit')), 'RF', ''),'billing_type' => array('dropdown', 'billing_type', 'R|Y', 'R|Y', $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'Billing_type')), 'RF', ''),'agreement' => array('radio', 'agreement', 'MC-checkcon', 'MC-checkcon',$agreement, '',''),'label_exp' => array('radio', 'label_exp', 'MC-checkcon', 'MC-checkcon',$label_exp, '',''),'expiry_date' => array('text', 'expiry_date', 'Z|RO|MC-expiry_date', 'Z|RO|MC-expiry_date','', '',''),'other_exp' => array('text','other_exp','Z','Z','','',''),'status' => array('dropdown', 'status', 'Y|R', 'Y|R',$this->order_status, 'RF',''),'candidate_list' => array('dropdown', 'candidate_list', 'R|Y', 'R|Y', $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('seqid', 'name'),array('key' => 'Digital On boarding Facilities')), 'RF', ''),'per_annum_cost' => array('dropdown', 'per_annum_cost', 'Y|R', 'Y|R',$this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('seqid', 'name'),array('key' => 'Per Annum Cost')), 'RF','') ));
                    $auth_link = array(array('users','search','Search','Meeting/order') );
                    $data['table'] = form(create_form($formElement,$order_details,$order_id,@$meeting_id), $formElement, 'order_add', 'Meeting/orderadd',$subtitle,$auth_link, '', base_url());
            $this->mm->orderdml($order_id,$meeting_id);
                $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
                $this->breadcrumbs->push('Order', 'Meeting/order');
                $this->breadcrumbs->push('Add Order', 'Meeting/orderadd');
             $data[$this->breadcrumb]=$this->breadcrumbs->show();            
                $this->amodel->pagerender($data, 'order_add');
            }
        function ordercommonview() {
                $this->_check_featureauth ( $this->meeting_feature, 'view' );
                $order_id = base64_decode($this->uri->segment(3));
                if(empty($_POST['office']) && empty($_POST['sub_office'])) {
                     $header_name = array(array('org_name' => 'organisation', 'parent_office' => 'office', 'credit_limit'=>'credit_limit', 'mode_email'=>'mode_email', 'acceptable_limit'=>'acceptable_limit','status'=>'status','candidate_list' => 'candidate_list',   'per_annum_cost' => 'per_annum_cost'));
                }
                else if(!empty($_POST['office']) && empty($_POST['sub_office'])) {
                     $header_name = array(array('org_name' => 'organisation', 'parent_office' => 'office', 'office_name' => 'office', 'credit_limit'=>'credit_limit', 'mode_email'=>'mode_email', 'acceptable_limit'=>'acceptable_limit','status'=>'status' ,'candidate_list' => 'candidate_list',   'per_annum_cost' => 'per_annum_cost'));
                }else{
                    $header_name = array(array('org_name' => 'organisation', 'parent_office' => 'office', 'office_name' => 'office', 'office' => 'sub_office', 'credit_limit'=>'credit_limit', 'mode_email'=>'mode_email', 'acceptable_limit'=>'acceptable_limit','status'=>'status','candidate_list' => 'candidate_list',   'per_annum_cost' => 'per_annum_cost'));
                }
                $data['subtitle']="View";
                $this->db->select('email');
                $this->db->where('order_id',$order_id);
                $this->db->join(DB_PREFIX.'user u','u.id=e.org_email','left');
                $data['emails']=$emails = $this->db->get(DB_PREFIX.'emails e')->result_array();
               $url = base_url() . "Meeting/order";
                $orderdetails = $this->mm->getorderdetails($order_id);
                 $data['email_id'] = $this->mm->get_contactemail($order_id);

                $data['orderdetails'] = $orderdetails[0];
                $auth_link = array(    
                                     array('users','search','Search','Meeting/order',''),
                                     array('users','edit','Modify','Meeting/orderadd/'.$this->uri->segment(3),'')
                                  );
                $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
                 $this->breadcrumbs->push('Order ', 'Meeting/order');
                $this->breadcrumbs->push('Order Details', 'Meeting/ordercommonview/'.$this->uri->segment(3));
                $data[$this->breadcrumb]=$this->breadcrumbs->show(); 
                $this->amodel->pagerender($data);
             
        }
    function send_email()
    {
                $order_id= base64_decode($this->uri->segment(3));
                $email_id = $this->mm->get_contactemail($order_id);
                $orderdetails = $this->mm->getorderdetails($order_id);
                $this->db->update(DB_PREFIX .'order',array('order_send_email'=>1),array('id'=>$order_id));
                foreach($email_id  as $email_org){
                $org_emails[]=$email_org['email'];
                }
                foreach($orderdetails  as $email_order){
                $order_emails[]=$email_order['email_value'];    
                }
                $data['mail_content'] = $this->mm->getorderdetails($order_id);
                $data['checks_content'] = $this->mm->getcheckdetails($order_id);
                $org_email[] = implode(',',$org_emails);
                $order_email[] = implode(',',$order_emails);
                $this->send_email_common('order_confirmation',"Order Confirmation", $org_emails,$order_emails, $data);
                redirect('Meeting/ordercommonview/'. base64_encode($order_id));
    }
        public function orderdelete() {
                $this->_check_featureauth ( $this->meeting_feature, 'delete' ); 
                $data['id'] = $id = base64_decode($this->uri->segment(3));
            $url = base_url() . "Meeting/order";
                $pagetitle = "order_delete";
                $formElement = array(array('confirm' => array('textarea', 'sure_msg', 'R|row:5|col:20|W')));
                $subtitle = "Delete";
                $data['formelements'] = create_form($formElement);
                        $auth_link = array(     array('users','search','Search','Meeting/order','')
                                  );
                $data['orderdelete'] = form($data['formelements'], $formElement, 'user', 'Meeting/order', $subtitle, $auth_link, 'delete');

                $this->mm->order_delete($id);
                $this->amodel->pagerender($data, 'user');
            }
        function addcheck() { 
                
            $this->_check_featureauth ( $this->meeting_feature, 'search' );
            $order_id = $data['id'] = base64_decode($this->uri->segment(3));
            $met_id=$data['meeting_id'] =$this->amodel->getDetails(DB_PREFIX . "order", array('meeting_id'), array('id'=> $order_id));
            $meeting = base64_encode($met_id[0]['meeting_id']); 
            $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
            $pagetitle = "order_checks";
            
           $org_id=base64_decode($this->uri->segment(4));
           
           $packgQry="select * from dcode_master_masterdata where parent=0 AND `key` IN ('Check','Package') AND id IN(select package_id from dcode_packages where org_id='".$org_id."'OR org_id=0) AND id NOT IN(SELECT types_of_check FROM dcode_add_check WHERE order_id ='".$order_id."')";
           $packageRes=$this->db->query($packgQry)->result_array();


            $nchecks = $this->db->query("select * from ". DB_PREFIX ."master_masterdata where parent=0 AND `key` IN ('Check') AND id NOT IN(SELECT types_of_check FROM ".DB_PREFIX."add_check WHERE order_id =". $order_id . ") order by seqid " )->result_array(); 
               foreach($nchecks as $ky=>$val){
                  $check[$val['id']]=$val['name'];                                      
                                                           
                       }                            
            $subtitle = "ADD";
                $title = "Create";

            $pay = array( 1 => 'Yes',0 => 'No');
                $check_details = $this->amodel->getDetails(DB_PREFIX . "add_check", array('*'), array('check_id' => $check_id));
                
                if ($check_details) {
                    $this->_check_featureauth ($this->meeting_feature, 'edit' ); // Check if user is allowed for action
                        $subtitle = "Modify";
                        $auth_link = array(     array($this->meeting_feature,'search','Search','Meeting/ordercommonview/'. $this->uri->segment(3). '/'. $this->uri->segment(4) )) ;
                       $level = $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('ref_id' => $check_details[0]['types_of_check'],'key'=>'level'));
                       $unit_limit = $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('ref_id' => $check_details[0]['types_of_check'],'key'=>'limit'));
                } else {
                   $subtitle = "Create";
                   $level = ''; $unit_limit = '';
                }
                $data['nchecks'] = $nchecks;
                $data['packageRes']=$packageRes;
                $discrepancy = $this->db->query("select id,name,ref_id from ". DB_PREFIX ."master_masterdata where parent=0 AND `key` IN ('Check','Package','discrepancy_parameters') AND id NOT IN(SELECT types_of_check FROM ".DB_PREFIX."add_check WHERE order_id =". $order_id . ")" )->result_array();
                $data['discrepancy'] = $discrepancy;
            $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
                $this->breadcrumbs->push('Order', 'Meeting/order');                
                $this->breadcrumbs->push('Order Details', 'Meeting/ordercommonview/'.$this->uri->segment(3));               
                $this->breadcrumbs->push('Add/Edit Checks', 'Meeting/addcheck');
                $data[$this->breadcrumb]=$this->breadcrumbs->show(); 
                $this->amodel->pagerender($data,'order_checks');

            }
            function get_ordered_checks(){ 
            $chk = $_POST;
            $order_id = $data['id'] = base64_decode($this->uri->segment(3));
            $met_id=$data['meeting_id'] =$this->amodel->getDetails(DB_PREFIX . "order", array('meeting_id'), array('id'=> $order_id));
            $meeting = base64_encode($met_id[0]['meeting_id']); 
            $check_id = $data['check_id'] = base64_decode($this->uri->segment(4));
            $this->mm->addcheckdml($check_id,$order_id);
            $this->amodel->pagerender('','order_checks');
            }
        function get_checks( $type = 'json' ) {
            $this->_check_featureauth ( $this->meeting_feature, 'search' );
            $order_id=$this->uri->segment(3);
            $role_id = $this->session->userdata['role_id'];
                    $manual_cond = " a.order_id = ". $order_id;
                        $model = array(self::$meetings_model=>'get_checklist');
                $results = $this->_jqgrid_search($model,$manual_cond);
                $response = $results[0]; $result = $results[1]; 
                   if ($result) {
                   $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows; //echo '<pre>';print_r($result);exit;
                    foreach ( $result as $i => $row ) {
                    $acceptable_limit='';
  $acceptable_limit=explode(",", @$row['acceptable_limit']);
  $discrepancy_param='';
  $acceptable=array();
  if(!empty($acceptable_limit)){ $j=1;
  foreach (@$acceptable_limit as $key => $value) {
    if(!empty($value)){
    $acceptable[]="<p>".$j.". ".$value.".</p>";
    }
    $j++;
  }
  $discrepancy_param=implode(" ",@$acceptable);
}
    if($row['types_of_check'] > 650)
    {
        $typeOfCheck=anchor('/Management/packageview/'.base64_encode($row['types_of_check']).'/'.base64_encode($row['order_id']).'/'.base64_encode($row['check_id']), $row['name']);
    }else{
        $typeOfCheck=anchor('/Meeting/addcheck/'.base64_encode($row['order_id']).'/'.base64_encode($row['check_id']), $row['name']);
    }

                    $response->rows [$i] ['cell'] = array ( $i+$count+1,$typeOfCheck
                        ,$row['level'],$row['max_attempt'],$discrepancy_param,$row['Rs']);
                                        
                }
                }
                echo json_encode ( $response );
                }
    function addproposal()
        {
            $this->_check_featureauth ($this->meeting_feature, 'search' );
            $meeting_id= $data['meeting_id']= base64_decode($this->uri->segment(3));
            $proposal_id = base64_decode($this->uri->segment(4));
            $pagetitle = "proposal";
                $data['title'] = "proposal";
             $proposal_details = $this->amodel->getDetails(DB_PREFIX . "proposal", array('*'), array('id' => $proposal_id));

            if ($proposal_details) {
                        $subtitle = "Modify";
                         $auth_link = array(  array($this->meeting_feature,'search','Search',$this->meeting_meetingcommonview.base64_encode($meeting_id),'') );
                } else {
                        $subtitle = "Create";
                         $auth_link = array(  array($this->meeting_feature,'search','Search',$this->meeting_meetingcommonview.base64_encode($meeting_id),'') );
                } 
        $this->db->select('a.email');
        $this->db->where('m.id',$meeting_id);
        $this->db->where('m.id!=',1);
        $this->db->join(DB_PREFIX.'meeting m','m.presale_id=a.id');
        $email = $this->db->get(DB_PREFIX.'presale a')->result_array();
        foreach ($email as $value) {
         $dropvalues = $value['email']; 
         } 
         $formElement = array(array('client_email' => array('text', 'client_email', 'R|Y', 'R|Y', "hhh" ,'RF',''),'requirement' => array('textarea', 'requirement', 'R|Y', 'R|Y', '', 'RF', '')));
         $data['formelements'] = create_form($formElement, $proposal_details, $proposal_id);
            $data['table'] = form($data['formelements'], $formElement, 'Meeting/meetingsearch',$pagetitle,$subtitle,$auth_link, '', base_url());
           $detail_document=$_FILES['details']['name'];
        $data['document'] = $detail_document;
        $data['proposal_document'] = $proposal_details;
        $data['objective'] = $_POST['requirement'];
        
        if(!empty($data['objective'])){

if($_POST['Submit']=='Send'){ 
    
           $this->send_email_common_proposal('proposal_confirmation','Proposal Confirmation Details', $dropvalues,$_POST['client_email'],$data);
           echo "<script> alert('Mail has been successfully sent to the given id')</script>";

        }
         
    }
        $this->mm->proposaldml($proposal_id,$meeting_id,$dropvalues);
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
                $this->breadcrumbs->push('Meeting', 'Meeting/meetingsearch');
                $this->breadcrumbs->push('Meeting Details', $this->meeting_meetingcommonview.base64_encode($meeting_id));
                $this->breadcrumbs->push('Edit Proposal Details', 'Meeting/addproposal');
                $data[$this->breadcrumb]=$this->breadcrumbs->show(); 
            $this->amodel->pagerender($data);       
      
       
        }
        function followup(){

            $meeting_id = $data['meeting_id'] = base64_decode($this->uri->segment(3));
            $followup_id = base64_decode($this->uri->segment(4));
                $pagetitle = "Add Followup";
             $followup_details = $this->amodel->getDetails(DB_PREFIX . "follow_up", array('*'), array('id' => $followup_id));

            if ($followup_details) {
                        $subtitle = "Modify";
                        $auth_link = array(     array($this->meeting_feature,'search','Search',$this->meeting_meetingcommonview.base64_encode($meeting_id),'')  );
                } else {
                        $subtitle = "Create";
                        $auth_link = array(  array($this->meeting_feature,'search','Search',$this->meeting_meetingcommonview.base64_encode($meeting_id),'') );
                } 

            $formElement = array(array('meeting_date' => array('text', 'meeting_date', 'R|RO', 'R|RO', '', 'RF'), 'time' => array('text', 'time', 'R|Z|RO', 'R|Z|RO', '', 'RF'),'latest_update' => array('textarea', 'latest_update', 'R|Y', 'R|Y', '', 'RF', '')));
                $data['formelements'] = create_form($formElement, $followup_details, $followup_id);
                $data['table'] = form($data['formelements'], $formElement, 'followup', 'Meeting/meetingsearch',$subtitle,$auth_link, '', base_url());
                $this->mm->followupdml($followup_id,$meeting_id);
                $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
                $this->breadcrumbs->push('Meeting', 'Meeting/meetingsearch');
                $this->breadcrumbs->push('Meeting Details', $this->meeting_meetingcommonview.base64_encode($meeting_id));
                $this->breadcrumbs->push('Edit Followup Details', 'Meeting/followup');
                $data[$this->breadcrumb]=$this->breadcrumbs->show(); 
            $this->amodel->pagerender($data, 'followup');
            }
       
        function followupview() {
                $this->_check_featureauth ( $this->meeting_feature, 'view' );
                $subtitle="Followup";
                $meeting_id = base64_decode($this->uri->segment(3));
                $followup_id = base64_decode($this->uri->segment(4));
                $followup = $this->mm->followupdetails($followup_id); 
                $url = base_url() . "meeting/meetingsearch";
                $auth_link = array(array('users','search','Search',$this->meeting_meetingcommonview.base64_encode($meeting_id),''),
                                        array('users','edit','Modify','Meeting/followup/'.$this->uri->segment(3).'/'.$this->uri->segment(4),''));
                $data['followupview'] = $followup[0];
                $data['title']="followup";
            $data['subtitle']="View";
            $data['auth_link']=$auth_link;
                $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
                $this->breadcrumbs->push('Meeting', 'Meeting/meetingsearch');
                $this->breadcrumbs->push('Meeting Details', $this->meeting_meetingcommonview.base64_encode($meeting_id));
                $this->breadcrumbs->push('Followup Details', 'Meeting/followupview');
                $data[$this->breadcrumb]=$this->breadcrumbs->show(); 
                $this->amodel->pagerender($data,$data['title'],$data['subtitle']);
        }
        function proposalview()
        {
                $this->_check_featureauth ($this->meeting_feature, 'view');
                $meeting_id= $data['meeting_id']= $this->uri->segment(3);
                $id = base64_decode($this->uri->segment(4));
                $subtitle="Followup";
                $proposaldt=$this->mm->proposaldtl($id);
                $url = base_url() . "meeting/meetingsearch";
                $auth_link = array(array('users','search','Search',$this->meeting_meetingcommonview. $meeting_id,''),
                            array('users','edit','Modify','Meeting/addproposal/'.$meeting_id.'/'.$this->uri->segment(4),''));
            $data['proposalview'] = $proposaldt[0];
            $data['title']="proposal";
            $data['subtitle']="Commonview";
            $data['auth_link']=$auth_link;
            $data['auth_link']=$auth_link;
                $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
                $this->breadcrumbs->push('Meeting', 'Meeting/meetingsearch');
                $this->breadcrumbs->push('Meeting Details', $this->meeting_meetingcommonview.$this->uri->segment(3));
                $this->breadcrumbs->push('Proposal Details', 'Meeting/proposalview');
                $data[$this->breadcrumb]=$this->breadcrumbs->show(); 
                $this->amodel->pagerender($data,$data['title'],$data['subtitle']);
        }
        function load_emails()
        {
                $option='';
                if($_POST['parent_id']<>'')
                {
                $all_emails=$this->mm->getallemail($_POST['parent_id']);
                
                foreach($all_emails as $key=>$row)
            $option .='<option value="'.$key.'">'.$row.'</option>';
                }
                echo $option;
        }
}