<?php if (!defined('BASEPATH')) 
{
    exit('No direct script access allowed');
}
require_once ('Common.php');
require_once ('./PHPExcel-1.8/Classes/PHPExcel.php'); // Needed for export to xls to work

class MissingFiles extends Common {
    protected $index_dashboard= 'Index/dashboard';

    //constructor
    function __construct() 
    {
        parent::__construct();
        $this->_check_userlogin();

        $files_found = 0; // variable for count of files found in folder
        $files_not_found = 0; // variable for count of files not found in folder
      
        $models = array('MissingFiles_model'=>'m');
        foreach ($models as $file => $object_name) {
            $this->load->model($file, $object_name);
        }

        $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','jquery-ui-1.10.4','highcharts','exporting','jquery.validate','grid.locale-en','jquery.jqGrid.min','jquery-ui-1.8.16.custom.min','commonjs'));
        
    }

    /*****************************************************************************************************************************
    * list_deleted_files
    * Displays the view page to select either organisation or entering case numbers for finding files
    ******************************************************************************************************************************/
    function list_deleted_files() {
        
        if($this->session->userdata['userid']==1){
            $userId=$this->session->userdata['userid'];
        }

        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('List Files', 'MissingFiles/list_deleted_files');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'list_deleted_files');
    }

    /************************************************************
     * display_filters_selected
     * Shows details like organization selected etc., for finding_files
     ************************************************************/
    function display_filters_selected()
    {

        // Get all filters selected like organization etc.,
        $org_id = ($_REQUEST['parentoffice_id']) ? $_REQUEST['parentoffice_id'] : '';
        $office = ($_REQUEST['office_id']) ? $_REQUEST['office_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : ''; 
        
        $button_val = ($_REQUEST['button_val']) ? $_REQUEST['button_val'] : ''; 

        // Get oragnization name, head office name etc., for displaying
        if($org_id <> "")
        {        
            $org_res_arr = $this->m->get_organization_name($org_id);
            $org_name = $org_res_arr['org_name'];
        }
        if($parent_office <> "")
        {
            $head_off_res_arr = $this->m->get_head_office_name($org_id, $parent_office);
            $data['head_off_name']=$head_off_res_arr['office_name'];
        }
        
        if($office <> "")
        {
            // get_branch_office_name($org_id, $parent_office, $office) 
            $branch_off_res_arr = $this->m->get_branch_office_name($org_id, $parent_office, $office);
            $data['branch_off_name']=$branch_off_res_arr['office_name'];
        }
        
        if($sub_office <> "")
        {
            $sub_off_res_arr = $this->m->get_sub_office_name($sub_office);
            $data['sub_office']=$sub_off_res_arr['office_name']; 

        }
        $data['org_name']=$org_name;
        $data['c_date']=$c_date; 
        $data['t_date']=$t_date; 

        $data['org_id'] = $org_id;
        $data['office_id'] = $office;
        $data['parent_office_id'] = $parent_office;
        $data['sub_office_id'] = $sub_office;
        $data['button_val'] = $button_val;

        // If organization, head office etc., filters are selected then form a search condition[]
        if($org_id){
            $condition[]=" cr.organisation = ".$org_id;
        }
        if($parent_office){
            $condition[]=" cr.parent_office = ".$parent_office;
        }
        if($office){
            $condition[]=" cr.office = ".$office;
        }
        if($sub_office){
            $condition[]=" cr.sub_office = ".$sub_office;
        }
        if($c_date){
            if($t_date){
                 $condition[]=" (DATE_FORMAT(cr.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and DATE_FORMAT(cr.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."') ";
           }
        }
        
        // if(!empty($c_date)){
        //     $condition[]=" DATE_FORMAT(cr.case_accepted_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and cv.client_status=1 and case when cr.dataentry_by=3 Then DATE_FORMAT(cr.case_recieved_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' else 1 end ";
        // }
        // if(!empty($t_date)){
        //     $condition[]=" DATE_FORMAT(cr.case_accepted_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and cv.client_status=1 and case when cr.dataentry_by=3 Then DATE_FORMAT(cr.case_recieved_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' else 1 end ";
        // }
        $manual_cond=implode(' and ',$condition);
        // get relevant information depending on the filters selected
        $user_result = $this->m->get_users_for_finding_files($manual_cond);
        $noOfUsers =  count($user_result);
        $records_result = $this->m->get_info_for_finding_files($manual_cond);
        $noOfRecords =  count($records_result); 
  
        $data['noOfUsers'] = $noOfUsers;   
        $data['noOfRecords'] = $noOfRecords;
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Get Files', 'MissingFiles/list_deleted_files');
        $this->breadcrumbs->push('Filters selected', 'MissingFiles/display_filters_selected');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'display_filters_selected');

    }

    /**********************************************************************************
    * listing_of_files
    ***********************************************************************************/
    function listing_of_files() 
    {
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Get Files', 'MissingFiles/list_deleted_files');
        $button_val = ($_REQUEST['button_val']) ? $_REQUEST['button_val'] : '';
        // echo $button_val;
        if($button_val == 1)
            $this->breadcrumbs->push('List Files', 'MissingFiles/listing_of_files');
        else if($button_val == 2)
            $this->breadcrumbs->push('List Files', 'MissingFiles/listing_of_files_without_union');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'listing_of_files');
    }

    /**********************************************************************************
    * listing_of_files_without_union
    ***********************************************************************************/
    function listing_of_files_without_union()
    {
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Get Files', 'MissingFiles/list_deleted_files');
        $button_val = ($_REQUEST['button_val']) ? $_REQUEST['button_val'] : '';
        
        $this->breadcrumbs->push('List Files', 'MissingFiles/listing_of_files_without_union');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'listing_of_files_without_union');
    }

    /**********************************************************************************
    * grid_listing_of_files
    ***********************************************************************************/
    function grid_listing_of_files() 
    {
        
        // model name and method name
        $model = array('MissingFiles_model'=>'get_grid_view_of_missing_files');

        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office_id = ($_REQUEST['parent_office_id']) ? $_REQUEST['parent_office_id'] : '';
        $branch_office_id = ($_REQUEST['branch_office_id']) ? $_REQUEST['branch_office_id'] : '';        
        $sub_office_id = ($_REQUEST['sub_office_id']) ? $_REQUEST['sub_office_id'] : '';
        $from_date = ($_REQUEST['from_date']) ? $_REQUEST['from_date'] : '';
        $to_date = ($_REQUEST['to_date']) ? $_REQUEST['to_date'] : '';
        

        if($org_id){
            $condition[]=" cr.organisation = ".$org_id;
        }
        if($parent_office_id){
            $condition[]=" cr.parent_office = ".$parent_office_id;
        }
        if($branch_office_id){
            $condition[]=" cr.office = ".$branch_office_id;
        }
        if($sub_office_id){
            $condition[]=" cr.sub_office = ".$sub_office_id;
        }
        // and `created_on` BETWEEN CAST('2023-01-01' AS DATE) AND CAST('2023-03-31' AS DATE)
        if($from_date){
            if($to_date){
                 $condition[]=" (DATE_FORMAT(cr.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."' and DATE_FORMAT(cr.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."') ";
           }
        }


        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); // calling the model method with $manual_cond as argument

        $response = $results[0]; 
        $result = $results[1];


        $result1 = $this->m->get_users_for_finding_files($manual_cond);

        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            
            $docArr = array(); // declare a multi-dimensional associative array to hold all files
            $deletedFilesArr = array(); // declare a multi-dimensional associative array to hold deleted files
            $arr_count = 0; // count of all file_names in the document array

            foreach( $result as $i => $row ) {      
               
                /************/
                $check_id = $row['check_id']; 
                $req_id =  $row['request_id'];
                $case_no = $row['case_no']; // Added on 8th Aug

                // documents for that particular request_id and check_id is taken
                // for example:-  if check_id is 14, data is taken from db table
                // dcode_education_details
                $documents_arr = $this->m->get_docs_for_finding_files_for_request_id($req_id, $check_id);
                $filepath = '';
                $doc_name ='';
                
                // get vm_name 18th Aug
                $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, $check_id);                
                $vm_name = $vm_name_arr['vm_name'];

                // get qc2_name 18th Aug
                $qc2_name_arr = $this->m->get_qc2_name_for_req_id($req_id);                
                $qc2_name = $qc2_name_arr['qc2_name'];

                //  if files or documents found, populate the $docs array
                if(!empty($documents_arr))
                {   
                    foreach($documents_arr as $record)
                    {
                        if(!empty($record['document_file']))
                        {
                            $doc_name = $record['doc_name'];
                            $filepath = $record['file_path'];
                            /** Aug 30th **/
                            $level_id = $record['level_id'];
                            $chk_count = $record['count_of_chk'];
                            $chk_count =  ($chk_count > 0) ? $chk_count : '';
                            /** Aug 30th **/
                            if($check_id == 14)
                            {
                                switch($doc_name)
                                {
                                    case 'document_file': $doc_name = 'Consolidated Marks';
                                        break;
                                    case 'gdocument': $doc_name = 'Degree Certificate';
                                        break;
                                    case 'consolidate_doc': $doc_name = 'Marks Card';
                                        break;
                                    case 'pdocument': $doc_name = 'Provisional Degree';
                                        break;
                                    default:
                                        break;
                                }

                            }
                            /** Sep 7th **/
                            if($check_id == 59)
                            {
                                switch($doc_name)
                                {
                                    case 'relieve_document': $doc_name = 'Relieving Document';
                                        break;
                                    case 'service_document': $doc_name = 'Service Document';
                                        break;
                                    case 'employement_file': $doc_name = 'Pay Slip Document';
                                        break;                                   
                                    default:
                                        break;
                                }

                            }
                            /** Sep 7th **/
                            $docArr[$arr_count] = array('req_id' => $req_id,
                                                    'org_name' => $row['org_name'],
                                                    'check_id' => $check_id,
                                                    'check_name' => $row['name'],
                                                    'level_id' => $level_id, /** Aug 30th **/
                                                    'chk_count' => $chk_count, /** Aug 30th **/           
                                                    'candidate_name' => $row['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'vm_name' => $vm_name,
                                                    'qc2_name' => $qc2_name, // 18th Aug
                                                    'created_on' => $row['created_on'],
                                                    'case_accepted_date' => $row['case_accepted_date'],
                                                    'case_recieved_date' => $row['case_recieved_date'],
                                                    'final_report_published_date' => $row['final_report_published_date'],
                                                    'supplement_report_date' => $row['supplement_report_date'],
                                                    'filename' => $record['document_file'],
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                            $arr_count++; // increment the index count of the $docs and $docArr arrays
                        }
                    }
                }
                // files or documents found in fielddata and qc2fielddata columns of dcode_verified_level db table
                $res_arr = $this->m->get_verified_documents($req_id, $check_id);


                foreach($res_arr as $row1)
                {
                    $verification_data=toArray(json_decode($row1['fielddata']));

                    // take all filenames in details portion of the json
                    $ver_doc_arr = $verification_data['details'];
                    /** Aug 30th **/
                    $level_id = $row1['level_id'];
                    $chk_count = $row1['count_of_chk'];
                    $chk_count =  ($chk_count > 0) ? $chk_count : '';
                    /** Aug 30th **/
      
                    if(!empty($ver_doc_arr))
                    {   
                        /*** will be helpful later if we need file_path ***/
                        $filepath = 'uploads/qcreferencedetails/'; 

                        $doc_name ='qcreferencedetails';

                        $arr  = explode(',',$ver_doc_arr); 
                        if(!empty($arr))
                        {
                            for($k=0; $k < count($arr);  $k++)
                            {
                                //  if files or documents found, populate the $docs array
                                if(!empty($arr[$k]))
                                {   
                                    // $docs[$arr_count] = $arr[$k];

                                    $docArr[$arr_count] = array('req_id' => $req_id,
                                                    'org_name' => $row['org_name'],
                                                    'check_id' => $check_id,
                                                    'check_name' => $row['name'],
                                                    'level_id' => $level_id, /** Aug 30th **/
                                                    'chk_count' => $chk_count, /** Aug 30th **/  
                                                    'candidate_name' => $row['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'created_on' => $row['created_on'],
                                                    'case_accepted_date' => $row['case_accepted_date'],
                                                    'case_recieved_date' => $row['case_recieved_date'],
                                                    'final_report_published_date' => $row['final_report_published_date'],
                                                    'supplement_report_date' => $row['supplement_report_date'],
                                                    'filename' => $arr[$k],
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                                    $arr_count++;  // increment the index count of the $docs array
                                }
                            }
                        }
                    }

                }

            }
        }

        if(!empty($result1))
        {   
            // This has only request_ids and corresponding user_ids
            foreach($result1 as $row1)
            {
                // files or documents found in common db tables like personal_details etc.,
                $dummy_check_id = 0 ; // for common files check_id is considered as 0
                $req_id =  $row1['request_id'];
                $case_no = $row1['case_no']; 
                
                $doc_arr = $this->m->get_docs_for_finding_files_for_request_id($req_id, $dummy_check_id);
      
                $filepath = '';
                $doc_name ='';

                $vm_name = '';
                $qc2_name = ''; // 18th  Aug

                // get qc2_name
                $qc2_name_arr = $this->m->get_qc2_name_for_req_id($req_id);                                
                $qc2_name = $qc2_name_arr['qc2_name'];

                //  if files or documents found, populate the $docs array
                if(!empty($doc_arr))
                {   
                    foreach($doc_arr as $m)
                    {   
                        // Sep 20th
                        $dummy_check_id = 0 ;
                        $chk_count = 0; 
                        $chk_count =  ($chk_count > 0) ? $chk_count : '';
                        $check_name = 'common';
                        // Sep 20th

                        if(!empty($m['document_file']))
                        {
                            $filepath = $m['file_path'];
                            $tablename = $m['table_name'];
                            $filename = $m['document_file'];
                            $doc_name = $m['doc_name'];
                             /** Aug 30th **/
                            // $level_id = $m['level_id'];
                            // $chk_count = $m['count_of_chk'];
                            // $chk_count =  ($chk_count > 0) ? $chk_count : '';
                            /** Aug 30th **/

                            // Sep 20th
                            if($doc_name == "report_name")
                            {
                                $vm_name  = '';
                                if($tablename == 'dcode_finalreportpublished')
                                {
                                    $doc_name = 'Final Report';
                                }
                                else
                                {
                                    $doc_name = 'Manual Report';
                                }
                            }
                            // Sep 20th
                            /** from  here 17th Aug ***/
                            if($doc_name == "authenticate_doc")
                            {
                                $check_id_doc_name_arr = $this->m->get_check_id_and_documentname_for_req_id_and_filename($req_id, $m['document_file']);
                                /*** Sep 20th  ***/
                                if($check_id_doc_name_arr['status'] == 0)
                                {
                                    continue;
                                }
                                /*** Sep 20th  ***/
                                $dummy_check_id = $check_id_doc_name_arr['check_id'];
                                $check_name = $check_id_doc_name_arr['name'];
                                $doc_name = $check_id_doc_name_arr['document_name'];
                                // get vm_name
                                $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, $dummy_check_id);
                                $vm_name = $vm_name_arr['vm_name'];

                            }
                            
                             /** Sep 13th **/
                            if($tablename == 'dcode_personal_details' && $doc_name == 'user_image')
                            {
                                // get vm name of employment if present i.e., check id 59 
                                $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, 59);
                                if(!empty($vm_name_arr))
                                    {
                                        $vm_name = $vm_name_arr['vm_name'];
                                    }
                            }

                            if($tablename == 'dcode_billing_doc' && $doc_name == 'bill_proof')
                            {
                               
                                $bill_arr = $this->m->get_count_of_chk_for_bill_proof($req_id, $m['document_file']);
                                $dummy_check_id = $bill_arr['check_id'];
                                $check_name = $bill_arr['name'];
                                $chk_count = $bill_arr['count_of_chk'];
                                $level_id = $bill_arr['level_id'];
                    
                                $chk_count =  ($chk_count > 0) ? $chk_count : '';

                                // get vm name of employment i.e., check id 59 if present
                                $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, $dummy_check_id);
                                if(!empty($vm_name_arr))
                                    {
                                        $vm_name = $vm_name_arr['vm_name'];
                                    }
                            }
                            /** Sep 13th **/
                             /** Sep 5th **/
                            if($tablename == 'dcode_contact_details' && $doc_name == 'additional_doc')
                            {
                                $doc_name = 'contact_details_additional_doc';
                            }
                            if($tablename == 'dcode_personal_additional_doc' && $doc_name == 'additional_doc')
                            {
                                $check_id_doc_name_arr_personal = $this->m->get_doc_name_from_personal_additional_doc($req_id, $filename);
                                $dummy_check_id = $check_id_doc_name_arr_personal['check_id'];
                                $doc_name = $check_id_doc_name_arr_personal['document_name'];
                                $check_name = $check_id_doc_name_arr_personal['name'];
                                /** Sep 7th **/
                                if($dummy_check_id != 0)
                                {
                                    // get vm_name
                                    $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, $dummy_check_id);
                                    $vm_name = $vm_name_arr['vm_name'];
                                }
                                /** Sep 7th **/
                                 /** Sep 5th **/
                                if($dummy_check_id == 0)
                                    $check_name = 'common';                               
                                $level_id = $check_id_doc_name_arr_personal['level_id'];
                                $chk_count = 0;
                                $chk_count = $check_id_doc_name_arr_personal['count_of_chk'];
                                $chk_count =  ($chk_count > 0) ? $chk_count : '';
                                /** Sep 5th **/
                                if($doc_name == '')
                                    $doc_name = 'personal_additional_doc';
                            }
                            if($tablename == 'dcode_requested_additional_doc' && $doc_name == 'additional_doc')
                                {
                                    $check_id_doc_name_arr_requested = $this->m->get_doc_name_from_requested_additional_doc($req_id, $filename);
                                    $dummy_check_id = $check_id_doc_name_arr_requested['check_id'];
                                    $doc_name = $check_id_doc_name_arr_requested['document_name'];
                                    $check_name = $check_id_doc_name_arr_requested['name'];
                                    /** Sep 7th **/
                                    if($dummy_check_id != 0)
                                    {
                                        // get vm_name
                                        $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, $dummy_check_id);
                                        $vm_name = $vm_name_arr['vm_name'];
                                    }
                                    /** Sep 7th **/
                                    /** Sep 5th **/
                                    if($dummy_check_id == 0)
                                        $check_name = 'common';                                    
                                    $level_id = $check_id_doc_name_arr_requested['level_id'];
                                    $chk_count = 0;
                                    $chk_count = $check_id_doc_name_arr_requested['count_of_chk'];
                                    $chk_count =  ($chk_count > 0) ? $chk_count : '';
                                    /** Sep 5th **/
                                    if($doc_name == '')
                                        $doc_name = 'requested_additional_doc';
                                }
                            /** Sep 5th **/

                            
                            /** To here 17th Aug ***/

                            if($tablename == 'dcode_partial_upload_document')
                            {
                                $doc_name_arr = $this->m->get_doc_name_from_partial_upload_document($req_id, $filename);
                                /*** Sep 20th  ***/
                                if($doc_name_arr['status'] == 0)
                                {
                                    continue;
                                }
                                /*** Sep 20th  ***/
                                $doc_name = $doc_name_arr['document_name'];
                            }
                            $docArr[$arr_count] = array('req_id' => $req_id,
                                                    'org_name' => $row1['org_name'],
                                                    'check_id' => $dummy_check_id,
                                                    'check_name' => $check_name,
                                                    'level_id' => $level_id, /** Aug 30th **/
                                                    'chk_count' => $chk_count, /** Aug 30th **/
                                                    'candidate_name' => $row1['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'vm_name' => $vm_name,
                                                    'qc2_name' => $qc2_name, // 18th Aug
                                                    'created_on' => $row1['created_on'],
                                                    'case_accepted_date' => $row1['case_accepted_date'],
                                                    'case_recieved_date' => $row1['case_recieved_date'],
                                                    'final_report_published_date' => $row1['final_report_published_date'],
                                                    'supplement_report_date' => $row1['supplement_report_date'],
                                                    'filename' => $filename,
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                            $arr_count++; // increment the index count of the $docs array
                        }

                    }
                }
                
                // files or documents found in dcode_user table
                $dummy_check_id = 999; // check_id is considered as 999 for files in dcode_user table
                $user_id =  $row1['user_id'];

                $user_arr = $this->m->get_docs_for_finding_files_for_request_id($user_id, $dummy_check_id);

                $filepath = '';
                $doc_name ='';

                if(!empty($user_arr))
                {   
                    foreach($user_arr as $u)
                    {
                        //  if files or documents found, populate the $docs array
                        if(!empty($u['document_file']))
                        {

                            $filepath = $u['file_path'];
                            /** Aug 30th **/
                            $level_id = $u['level_id'];
                            $chk_count = $u['count_of_chk'];
                            $chk_count =  ($chk_count > 0) ? $chk_count : '';
                            /** Aug 30th **/

                            $docArr[$arr_count] = array('req_id' => $req_id,
                                        'org_name' => $row1['org_name'],
                                                    'check_id' => $dummy_check_id,
                                                    'check_name' => 'user',
                                                    'level_id' => $level_id, /** Aug 30th **/
                                                    'chk_count' => $chk_count, /** Aug 30th **/
                                                    'candidate_name' => $row1['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'vm_name' => $vm_name,
                                                    'qc2_name' => $qc2_name, // 18th Aug
                                                    'created_on' => $row1['created_on'],
                                                    'case_accepted_date' => $row1['case_accepted_date'],
                                                    'case_recieved_date' => $row1['case_recieved_date'],
                                                    'final_report_published_date' => $row1['final_report_published_date'],
                                                    'supplement_report_date' => $row1['supplement_report_date'],
                                                    'filename' => $u['document_file'],
                                                    'document_name' => $u['doc_name'],
                                                    'filepath' => $filepath
                                                );
                            $arr_count++;
                        }

                    }
                }
                    
            }
        }

        if(!empty($docArr))
        {
            for($i=0, $k=0; $i < count($docArr); $i++)
                {
                    $file_path = $docArr[$i]['filepath'];
                    if($file_path)
                        {
                            // find the position of '/' 
                            $pos = strrpos($docArr[$i]['filename'],"/");            
                            $found = 2;

                            // If '/'  not found then the  array value is just a file name
                            if(empty($pos))
                            {
                                $file_name = $docArr[$i]['filename'];
                                $found = $this->findFile_with_Path($file_name, $file_path ); // call renameFile function
                            }
                            // If '/' found then the array value contains file path.
                            else
                            {
                                // take just the file name from the path
                                $file_name = substr($docArr[$i]['filename'],++$pos);  
                                $found = $this->findFile_with_Path($file_name, $file_path); // call findFile function
                            }
                           
                            // if file not found then store the deleted file information in another array
                            if($found == 0)
                            {
                                $deletedFilesArr[$k] = array('req_id' => $docArr[$i]['req_id'],
                                                        'org_name' => $docArr[$i]['org_name'],
                                                        'check_id' => $docArr[$i]['check_id'],
                                                        'check_name' => $docArr[$i]['check_name'],
                                                        'level_id' => $docArr[$i]['level_id'], /** Aug 30th **/
                                                        'chk_count' => $docArr[$i]['chk_count'], /** Aug 30th **/
                                                        'candidate_name' => $docArr[$i]['candidate_name'],
                                                        'case_no' => $docArr[$i]['case_no'],
                                                        'vm_name' => $docArr[$i]['vm_name'],
                                                        'qc2_name' => $docArr[$i]['qc2_name'], // 18th Aug
                                                        'created_on' => $docArr[$i]['created_on'],
                                                        'case_accepted_date' => $docArr[$i]['case_accepted_date'],
                                                        'case_recieved_date' => $docArr[$i]['case_recieved_date'],
                                                        'final_report_published_date' => $docArr[$i]['final_report_published_date'],
                                                        'supplement_report_date' => $docArr[$i]['supplement_report_date'],
                                                        'filename' => $file_name,
                                                        'document_name' => $docArr[$i]['document_name'],
                                                        'filepath' => $docArr[$i]['filepath']
                                                    );
                                $k++;
                            }

                            if($found == -1) // Not directory
                            {
                                $file_in_red  = "<span style='color:red;'>". $docArr[$i]['filename'] . "</span>";

                                $deletedFilesArr[$k] = array('req_id' => $docArr[$i]['req_id'],
                                                        'org_name' => $docArr[$i]['org_name'],
                                                        'check_id' => $docArr[$i]['check_id'],
                                                        'check_name' => $docArr[$i]['check_name'],
                                                        'level_id' => $docArr[$i]['level_id'], /** Aug 30th **/
                                                        'chk_count' => $docArr[$i]['chk_count'], /** Aug 30th **/
                                                        'candidate_name' => $docArr[$i]['candidate_name'],
                                                        'case_no' => $docArr[$i]['case_no'],
                                                        'vm_name' => $docArr[$i]['vm_name'],
                                                        'qc2_name' => $docArr[$i]['qc2_name'],  // 18th Aug
                                                        'created_on' => $docArr[$i]['created_on'],
                                                        'case_accepted_date' => $docArr[$i]['case_accepted_date'],
                                                        'case_recieved_date' => $docArr[$i]['case_recieved_date'],
                                                        'final_report_published_date' => $docArr[$i]['final_report_published_date'],
                                                        'supplement_report_date' => $docArr[$i]['supplement_report_date'],
                                                        'filename' =>  $file_in_red,
                                                        'document_name' => $docArr[$i]['document_name'],
                                                        'filepath' => $docArr[$i]['filepath']
                                                    );
                                $k++;
                            }
                        }
                }
        }
        $jj = 0; // to show serial numbers
 
        //  loop through the array having deleted  files information to display
        if(!empty($deletedFilesArr))
        {
            foreach ($deletedFilesArr as $fileArr) 
            {
                $response->rows [$jj] ['cell'] = array ( $jj+$count+1,$fileArr['org_name'],$fileArr['candidate_name'],$fileArr['case_no'],$fileArr['check_name'].$fileArr['chk_count'], $fileArr['vm_name'], $fileArr['qc2_name'], $fileArr['document_name'], $fileArr['filename'],$fileArr['created_on'], $fileArr['case_accepted_date'], $fileArr['case_recieved_date'],$fileArr['final_report_published_date'],$fileArr['supplement_report_date']); /** Aug 30th **/
                $jj++;
            }
        }

        echo json_encode($response);

    }
    
    /**********************************************************************************
    * export_missing_files_list
    ***********************************************************************************/
    function export_missing_files_list()
    {
        // model name and method name
        $model = array('MissingFiles_model'=>'get_xls_of_missing_files');

        $org_id = ($_REQUEST['exp_org_id']) ? $_REQUEST['exp_org_id'] : '';
        $parent_office_id = ($_REQUEST['exp_parent_office_id']) ? $_REQUEST['exp_parent_office_id'] : '';
        $branch_office_id = ($_REQUEST['exp_branch_office_id']) ? $_REQUEST['exp_branch_office_id'] : '';        
        $sub_office_id = ($_REQUEST['exp_sub_office_id']) ? $_REQUEST['exp_sub_office_id'] : '';
        $from_date = ($_REQUEST['exp_from_date']) ? $_REQUEST['exp_from_date'] : '';
        $to_date = ($_REQUEST['exp_to_date']) ? $_REQUEST['exp_to_date'] : '';

        if($org_id){
            $condition[]=" cr.organisation = ".$org_id;
        }
        if($parent_office_id){
            $condition[]=" cr.parent_office = ".$parent_office_id;
        }
        if($branch_office_id){
            $condition[]=" cr.office = ".$branch_office_id;
        }
        if($sub_office_id){
            $condition[]=" cr.sub_office = ".$sub_office_id;
        }
        // and `created_on` BETWEEN CAST('2023-01-01' AS DATE) AND CAST('2023-03-31' AS DATE)
        if($from_date){
            if($to_date){
                 $condition[]=" (DATE_FORMAT(cr.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."' and DATE_FORMAT(cr.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."') ";
           }
        }


        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); // calling the model method with $manual_cond as argument
        $response = $results[0]; 
        $result = $results[1];

        $result1 = $this->m->get_users_for_finding_files($manual_cond);
        
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
        
            $docArr = array(); // declare a multi-dimensional associative array to hold all files
            $deletedFilesArr = array(); // declare a multi-dimensional associative array to hold deleted files
            $arr_count = 0; // count of all file_names in the document array

            foreach( $result as $i => $row ) {      
               
                /************/
                $check_id = $row['check_id']; 
                $req_id =  $row['request_id'];
                $case_no = $row['case_no']; // Added on 8th Aug

                // documents for that particular request_id and check_id is taken
                // for example:-  if check_id is 14, data is taken from db table
                // dcode_education_details
                $documents_arr = $this->m->get_docs_for_finding_files_for_request_id($req_id, $check_id);
                $filepath = '';
                $doc_name ='';

                $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, $check_id);                
                $vm_name = $vm_name_arr['vm_name'];
                
                // get qc2_name
                $qc2_name_arr = $this->m->get_qc2_name_for_req_id($req_id);                
                $qc2_name = $qc2_name_arr['qc2_name'];
                //  if files or documents found, populate the $docs array
                if(!empty($documents_arr))
                {   
                    foreach($documents_arr as $record)
                    {
                        if(!empty($record['document_file']))
                        {
                            $filepath = $record['file_path'];
                            $doc_name = $record['doc_name'];
                            /** Aug 30th **/
                            $level_id = $record['level_id'];
                            $chk_count = $record['count_of_chk'];
                            $chk_count =  ($chk_count > 0) ? $chk_count : '';
                            /** Aug 30th **/

                            if($check_id == 14)
                            {
                                switch($doc_name)
                                {
                                    case 'document_file': $doc_name = 'Consolidated Marks';
                                        break;
                                    case 'gdocument': $doc_name = 'Degree Certificate';
                                        break;
                                    case 'consolidate_doc': $doc_name = 'Marks Card';
                                        break;
                                    case 'pdocument': $doc_name = 'Provisional Degree';
                                        break;
                                    default:
                                        break;
                                }

                            }
                            /** Sep 7th **/
                            if($check_id == 59)
                            {
                                switch($doc_name)
                                {
                                    case 'relieve_document': $doc_name = 'Relieving Document';
                                        break;
                                    case 'service_document': $doc_name = 'Service Document';
                                        break;
                                    case 'employement_file': $doc_name = 'Pay Slip Document';
                                        break;                                   
                                    default:
                                        break;
                                }

                            }
                            /** Sep 7th **/
                            $docArr[$arr_count] = array('req_id' => $req_id,
                                                    'org_name' => $row['org_name'],
                                                    'check_id' => $check_id,
                                                    'check_name' => $row['name'],
                                                    'level_id' => $level_id, /** Aug 30th **/
                                                    'chk_count' => $chk_count, /** Aug 30th **/
                                                    'candidate_name' => $row['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'vm_name'  => $vm_name,
                                                    'qc2_name' => $qc2_name,
                                                    'created_on' => $row['created_on'],
                                                    'case_accepted_date' => $row['case_accepted_date'],
                                                    'case_recieved_date' => $row['case_recieved_date'],
                                                    'final_report_published_date' => $row['final_report_published_date'],
                                                    'supplement_report_date' => $row['supplement_report_date'],
                                                    'filename' => $record['document_file'],
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                            $arr_count++; // increment the index count of the $docs and $docArr arrays
                        }
                    }
                }

                // files or documents found in fielddata and qc2fielddata columns of dcode_verified_level db table
                $res_arr = $this->m->get_verified_documents($req_id, $check_id);
      
                foreach($res_arr as $row1)
                {
                    $verification_data=toArray(json_decode($row1['fielddata']));

                    // take all filenames in details portion of the json
                    $ver_doc_arr = $verification_data['details'];
                    /** Aug 30th **/
                    $level_id = $row1['level_id'];
                    $chk_count = $row1['count_of_chk'];
                    $chk_count =  ($chk_count > 0) ? $chk_count : '';
                    /** Aug 30th **/

                    if(!empty($ver_doc_arr))
                    {   
                        /*** will be helpful later if we need file_path ***/
                        $filepath = 'uploads/qcreferencedetails/'; 

                        $doc_name ='qcreferencedetails';

                        $arr  = explode(',',$ver_doc_arr); 
                        if(!empty($arr))
                        {
                            for($k=0; $k < count($arr);  $k++)
                            {
                                //  if files or documents found, populate the $docs array
                                if(!empty($arr[$k]))
                                {   
                                    // $docs[$arr_count] = $arr[$k];

                                    $docArr[$arr_count] = array('req_id' => $req_id,
                                                    'org_name' => $row['org_name'],
                                                    'check_id' => $check_id,
                                                    'check_name' => $row['name'],
                                                    'level_id' => $level_id, /** Aug 30th **/
                                                    'chk_count' => $chk_count, /** Aug 30th **/
                                                    'candidate_name' => $row['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'vm_name'  => $vm_name,
                                                    'qc2_name' => $qc2_name,
                                                    'created_on' => $row['created_on'],
                                                    'case_accepted_date' => $row['case_accepted_date'],
                                                    'case_recieved_date' => $row['case_recieved_date'],
                                                    'final_report_published_date' => $row['final_report_published_date'],
                                                    'supplement_report_date' => $row['supplement_report_date'],
                                                    'filename' => $arr[$k],
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                                    $arr_count++;  // increment the index count of the $docs array
                                }
                            }
                        }
                    }

                }
                 
            
            }
        }

        if(!empty($result1))
        {   
            // This has only request_ids and corresponding user_ids
            foreach($result1 as $row2)
            {
                // files or documents found in common db tables like personal_details etc.,
                $dummy_check_id = 0 ; // for common files check_id is considered as 0
                // $check_id = $row['check_id'];  // Added on 8th Aug
                $req_id =  $row2['request_id'];
                $case_no = $row2['case_no']; // Added on 8th Aug
                
                $doc_arr = $this->m->get_docs_for_finding_files_for_request_id($req_id, $dummy_check_id);
      
                $filepath = '';
                $doc_name ='';
                $check_name = 'common'; // Aug 17th

                $vm_name = '';
                // get qc2_name
                $qc2_name_arr = $this->m->get_qc2_name_for_req_id($req_id);                                
                $qc2_name = $qc2_name_arr['qc2_name'];

                //  if files or documents found, populate the $docs array
                if(!empty($doc_arr))
                {   
                    foreach($doc_arr as $m)
                    {  
                        // Sep 20th
                        $dummy_check_id = 0 ;
                        $chk_count = 0; 
                        $chk_count =  ($chk_count > 0) ? $chk_count : '';
                        $check_name = 'common';
                        // Sep 20th
                        if(!empty($m['document_file']))
                        {
                            // $docs[$arr_count] = $m['document_file'];
                            $filepath = $m['file_path'];
                            $tablename = $m['table_name'];
                            $filename = $m['document_file'];
                            $doc_name = $m['doc_name'];
                            
                            // Sep 20th
                            if($doc_name == "report_name")
                            {
                                $vm_name  = '';
                                if($tablename == 'dcode_finalreportpublished')
                                {
                                    $doc_name = 'Final Report';
                                }
                                else
                                {
                                    $doc_name = 'Manual Report';
                                }
                            }
                            // Sep 20th

                            /** from  here 17th Aug ***/
                            if($doc_name == "authenticate_doc")
                            {
                                $check_id_doc_name_arr = $this->m->get_check_id_and_documentname_for_req_id_and_filename($req_id, $m['document_file']);
                                /*** Sep 20th  ***/
                                if($check_id_doc_name_arr['status'] == 0)
                                {
                                    continue;
                                }
                                /*** Sep 20th  ***/
                                $dummy_check_id = $check_id_doc_name_arr['check_id'];
                                $check_name = $check_id_doc_name_arr['name'];
                                $doc_name = $check_id_doc_name_arr['document_name'];
                                $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, $dummy_check_id);
                
                                $vm_name = $vm_name_arr['vm_name']; 

                            }
                            
                            /** Sep 13th **/
                            if($tablename == 'dcode_personal_details' && $doc_name == 'user_image')
                            {
                                // get vm name of employment i.e., check id 59 if present
                                $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, 59);
                                if(!empty($vm_name_arr))
                                    {
                                        $vm_name = $vm_name_arr['vm_name'];
                                    }
                            }
                            if($tablename == 'dcode_billing_doc' && $doc_name == 'bill_proof')
                            {
                                $bill_arr = $this->m->get_count_of_chk_for_bill_proof($req_id, $m['document_file']);
                                $dummy_check_id = $bill_arr['check_id'];
                                $check_name = $bill_arr['name'];
                                $chk_count = $bill_arr['count_of_chk'];
                                $level_id = $bill_arr['level_id'];
                    
                                $chk_count =  ($chk_count > 0) ? $chk_count : '';

                                // get vm name of employment i.e., check id 59 if present
                                $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, $dummy_check_id);
                                if(!empty($vm_name_arr))
                                    {
                                        $vm_name = $vm_name_arr['vm_name'];
                                        
                                    }
                            }
                            /** Sep 13th **/
                            /** Sep 5th **/
                            if($tablename == 'dcode_contact_details' && $doc_name == 'additional_doc')
                            {
                                $doc_name = 'contact_details_additional_doc';
                            }
                            if($tablename == 'dcode_personal_additional_doc' && $doc_name == 'additional_doc')
                            {
                                $check_id_doc_name_arr_personal = $this->m->get_doc_name_from_personal_additional_doc($req_id, $filename);
                                $dummy_check_id = $check_id_doc_name_arr_personal['check_id'];
                                $doc_name = $check_id_doc_name_arr_personal['document_name'];
                                $check_name = $check_id_doc_name_arr_personal['name'];
                                /** Sep 7th **/
                                if($dummy_check_id != 0)
                                {
                                    // get vm_name
                                    $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, $dummy_check_id);
                                    $vm_name = $vm_name_arr['vm_name'];
                                }
                                /** Sep 7th **/
                                 /** Sep 5th **/
                                if($dummy_check_id == 0)
                                    $check_name = 'common';                               
                                $level_id = $check_id_doc_name_arr_personal['level_id'];
                                $chk_count = 0;
                                $chk_count = $check_id_doc_name_arr_personal['count_of_chk'];
                                $chk_count =  ($chk_count > 0) ? $chk_count : '';
                                /** Sep 5th **/
                                if($doc_name == '')
                                    $doc_name = 'personal_additional_doc';
                            }
                            if($tablename == 'dcode_requested_additional_doc' && $doc_name == 'additional_doc')
                                {
                                    $check_id_doc_name_arr_requested = $this->m->get_doc_name_from_requested_additional_doc($req_id, $filename);
                                    $dummy_check_id = $check_id_doc_name_arr_requested['check_id'];
                                    $doc_name = $check_id_doc_name_arr_requested['document_name'];
                                    $check_name = $check_id_doc_name_arr_requested['name'];
                                    /** Sep 7th **/
                                    if($dummy_check_id != 0)
                                    {
                                        // get vm_name
                                        $vm_name_arr = $this->m->get_vm_name_for_req_id_check_id($req_id, $dummy_check_id);
                                        $vm_name = $vm_name_arr['vm_name'];
                                    }
                                    /** Sep 7th **/
                                    /** Sep 5th **/
                                    if($dummy_check_id == 0)
                                        $check_name = 'common';                                    
                                    $level_id = $check_id_doc_name_arr_requested['level_id'];
                                    $chk_count = 0;
                                    $chk_count = $check_id_doc_name_arr_requested['count_of_chk'];
                                    $chk_count =  ($chk_count > 0) ? $chk_count : '';
                                    /** Sep 5th **/
                                    if($doc_name == '')
                                        $doc_name = 'requested_additional_doc';
                                }
                            /** Sep 5th **/


                            /** To here 17th Aug ***/

                            if($tablename == 'dcode_partial_upload_document')
                            {
                                $doc_name_arr = $this->m->get_doc_name_from_partial_upload_document($req_id, $filename);
                                /*** Sep 20th  ***/
                                if($doc_name_arr['status'] == 0)
                                {
                                    continue;
                                }
                                /*** Sep 20th  ***/
                                $doc_name = $doc_name_arr['document_name'];
                            }
                            $docArr[$arr_count] = array('req_id' => $req_id,
                                        'org_name' => $row2['org_name'],
                                                    'check_id' => $dummy_check_id,
                                                    'check_name' => $check_name, // 17th Aug
                                                    'level_id' => $level_id, /** Aug 30th **/
                                                    'chk_count' => $chk_count, /** Aug 30th **/
                                                    'candidate_name' => $row2['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'vm_name'  => $vm_name,
                                                    'qc2_name' => $qc2_name,
                                                    'created_on' => $row2['created_on'],
                                                    'case_accepted_date' => $row2['case_accepted_date'],
                                                    'case_recieved_date' => $row2['case_recieved_date'],
                                                    'final_report_published_date' => $row2['final_report_published_date'],
                                                    'supplement_report_date' => $row2['supplement_report_date'],
                                                    'filename' => $filename,
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                            $arr_count++; // increment the index count of the $docs array
                        }

                    }
                }
                
                // files or documents found in dcode_user table
                $dummy_check_id = 999; // check_id is considered as 999 for files in dcode_user table
                $user_id =  $row2['user_id'];

                $user_arr = $this->m->get_docs_for_finding_files_for_request_id($user_id, $dummy_check_id);

                $filepath = '';
                $doc_name ='';

                if(!empty($user_arr))
                {   
                    foreach($user_arr as $u)
                    {
                        //  if files or documents found, populate the $docs array
                        if(!empty($u['document_file']))
                        {
                            $filepath = $u['file_path'];
                            /** Aug 30th **/
                            $level_id = $u['level_id'];
                            $chk_count = $u['count_of_chk'];
                            $chk_count =  ($chk_count > 0) ? $chk_count : '';
                            /** Aug 30th **/

                            $docArr[$arr_count] = array('req_id' => $req_id,
                                        'org_name' => $row2['org_name'],
                                                    'check_id' => $dummy_check_id,
                                                    'check_name' => 'user',
                                                    'level_id' => $level_id, /** Aug 30th **/
                                                    'chk_count' => $chk_count, /** Aug 30th **/
                                                    'candidate_name' => $row2['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'vm_name'  => $vm_name,
                                                    'qc2_name' => $qc2_name,
                                                    'created_on' => $row2['created_on'],
                                                    'case_accepted_date' => $row2['case_accepted_date'],
                                                    'case_recieved_date' => $row2['case_recieved_date'],
                                                    'final_report_published_date' => $row2['final_report_published_date'],
                                                    'supplement_report_date' => $row2['supplement_report_date'],
                                                    'filename' => $u['document_file'],
                                                    'document_name' => $u['doc_name'],
                                                    'filepath' => $filepath
                                                );
                            $arr_count++;
                        }

                    }
                }
                    
            }
        }

        if(!empty($docArr))
        {
            for($i=0, $k=0; $i < count($docArr); $i++)
                    {
                        
                        $file_path = $docArr[$i]['filepath'];
                        if($file_path)
                        {// find the position of '/' 
                            $pos = strrpos($docArr[$i]['filename'],"/");            
                            $found = 2;

                            // If '/'  not found then the  array value is just a file name
                            if(empty($pos))
                            {
                                $file_name = $docArr[$i]['filename'];
                                $found = $this->findFile_with_Path($file_name, $file_path ); // call renameFile function
                            }
                            // If '/' found then the array value contains file path.
                            else
                            {
                                // take just the file name from the path
                                $file_name = substr($docArr[$i]['filename'],++$pos);  
                                $found = $this->findFile_with_Path($file_name, $file_path); // call findFile function
                            }
                           
                            // if file not found then store the deleted file information in another array
                            if($found == 0)
                            {
                                $deletedFilesArr[$k] = array('req_id' => $docArr[$i]['req_id'],
                                                        'org_name' => $docArr[$i]['org_name'],
                                                        'check_id' => $docArr[$i]['check_id'],
                                                        'check_name' => $docArr[$i]['check_name'],
                                                        'level_id' => $docArr[$i]['level_id'], /** Aug 30th **/
                                                        'chk_count' => $docArr[$i]['chk_count'], /** Aug 30th **/
                                                        'candidate_name' => $docArr[$i]['candidate_name'],
                                                        'case_no' => $docArr[$i]['case_no'],
                                                        'vm_name'  => $docArr[$i]['vm_name'],
                                                        'qc2_name' => $docArr[$i]['qc2_name'],
                                                        'created_on' => $docArr[$i]['created_on'],
                                                        'case_accepted_date' => $docArr[$i]['case_accepted_date'],
                                                        'case_recieved_date' => $docArr[$i]['case_recieved_date'],
                                                        'final_report_published_date' => $docArr[$i]['final_report_published_date'],
                                                        'supplement_report_date' => $docArr[$i]['supplement_report_date'],
                                                        'filename' => $file_name,
                                                        'document_name' => $docArr[$i]['document_name'],
                                                        'filepath' => $docArr[$i]['filepath']
                                                    );
                                $k++;
                            }

                            if($found == -1) // Not directory
                            {
                                $file_in_red  = $docArr[$i]['filepath'] . "  directory does not exist";

                                $deletedFilesArr[$k] = array('req_id' => $docArr[$i]['req_id'],
                                                        'org_name' => $docArr[$i]['org_name'],
                                                        'check_id' => $docArr[$i]['check_id'],
                                                        'check_name' => $docArr[$i]['check_name'],
                                                        'level_id' => $docArr[$i]['level_id'], /** Aug 30th **/
                                                        'chk_count' => $docArr[$i]['chk_count'], /** Aug 30th **/
                                                        'candidate_name' => $docArr[$i]['candidate_name'],
                                                        'case_no' => $docArr[$i]['case_no'],
                                                        'vm_name'  => $docArr[$i]['vm_name'],
                                                        'qc2_name' => $docArr[$i]['qc2_name'],
                                                        'created_on' => $docArr[$i]['created_on'],
                                                        'case_accepted_date' => $docArr[$i]['case_accepted_date'],
                                                        'case_recieved_date' => $docArr[$i]['case_recieved_date'],
                                                        'final_report_published_date' => $docArr[$i]['final_report_published_date'],
                                                        'supplement_report_date' => $docArr[$i]['supplement_report_date'],
                                                        'filename' =>  $file_in_red,
                                                        'document_name' => $docArr[$i]['document_name'],
                                                        'filepath' => $docArr[$i]['filepath']
                                                    );
                                $k++;
                            }
                        }
                        else
                        {
                            //  what to do if file path not found
                        }
                    }
        }

        $jj = 0;
        if(!empty($deletedFilesArr))
        {
            $objPHPExcel = new PHPExcel(); // Creating an excel object and setting parameters for it.
            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "VM Name");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "QC2 Name");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Document Name");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "File Name");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Created On");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "Case Accepted Date");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Case Received Date");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "Final Report Published Date");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "Supplementary Report Date");
            $objPHPExcel->getActiveSheet()->setCellValue('O1', "File Path"); // Sep 5th

            $ci=2;
            foreach ($deletedFilesArr as $fileArr) 
            {
                $objPHPExcel->getActiveSheet()->getStyle('A1:O1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ( $jj+$count+1))
                                          ->setCellValue('B' . $ci, $fileArr['org_name'])
                                          ->setCellValue('C' . $ci, $fileArr['candidate_name'])
                                          ->setCellValue('D' . $ci, $fileArr['case_no'])
                                          ->setCellValue('E' . $ci, $fileArr['check_name'].$fileArr['chk_count']) /** Aug 30th **/
                                          ->setCellValue('F' . $ci, $fileArr['vm_name'])
                                          ->setCellValue('G' . $ci, $fileArr['qc2_name'])
                                          ->setCellValue('H' . $ci, $fileArr['document_name'])
                                          ->setCellValue('I' . $ci, $fileArr['filename'])
                                          ->setCellValue('J' . $ci, $fileArr['created_on'])
                                          ->setCellValue('K' . $ci, $fileArr['case_accepted_date'])
                                          ->setCellValue('L' . $ci, $fileArr['case_recieved_date'])
                                          ->setCellValue('M' . $ci, $fileArr['final_report_published_date'])
                                          ->setCellValue('N' . $ci, $fileArr['supplement_report_date'])
                                          ->setCellValue('O' . $ci, $fileArr['filepath']);  //  Sep 5th
                $ci++;
                $jj++;
            }
            $this->export_excel('A','O','Missing_Files_List_',$objPHPExcel); // An excel file with above is created. // Sep 5th
            exit; 
        }

            
    }

    /**********************************************************************************
    * list_files_folders
    ***********************************************************************************/
    function list_files_folders() 
    {
        // Using a $html string variable to print the information about files found and renamed, files not found etc.,
        $html = '';
        $html .= '<b>' . date('d-m-Y H:i:s') . '</b>'; $html .= '<br><br><br>';
        // if case_nos have been entered
        $case_nos = ($_POST['case_no']) ? $_POST['case_no'] : '0';
        if($case_nos != '0')
        {
            $c_n = explode(',', $case_nos);
            // get information according to the case_nos  entered
            $result = $this->m->get_info_for_finding_files_for_case_nos($c_n);

            $result1 = $this->m->get_users_for_finding_files_for_case_nos($c_n);

        }

       
        $docArr = array(); // declare a multi-dimensional associative array to hold all files
        $deletedFilesArr = array(); // declare a multi-dimensional associative array to hold deleted files

        // If organization and other filters have been entered instead of case numbers
        if($case_nos == '0')
        {
            $org_id = ($_POST['org_id']) ? $_POST['org_id'] : '';
            $parent_office_id = ($_POST['parent_office_id']) ? $_POST['parent_office_id'] : '';
            $branch_office_id = ($_POST['branch_office_id']) ? $_POST['branch_office_id'] : '';        
            $sub_office_id = ($_POST['sub_office_id']) ? $_POST['sub_office_id'] : '';
            $from_date = ($_POST['from_date']) ? $_POST['from_date'] : '';
            $to_date = ($_POST['to_date']) ? $_POST['to_date'] : '';
            $user_type = ($_POST['user_type']) ? $_POST['user_type'] : '';

            if($org_id){
                $condition[]=" cr.organisation = ".$org_id;
            }
            if($parent_office_id){
                $condition[]=" cr.parent_office = ".$parent_office_id;
            }
            if($branch_office_id){
                $condition[]=" cr.office = ".$branch_office_id;
            }
            if($sub_office_id){
                $condition[]=" cr.sub_office = ".$sub_office_id;
            }
            // and `created_on` BETWEEN CAST('2023-01-01' AS DATE) AND CAST('2023-03-31' AS DATE)
            if($from_date){
                if($to_date){
                     $condition[]=" (DATE_FORMAT(cr.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."' and DATE_FORMAT(cr.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."') ";
               }
            }
            
            if($user_type){
                $condition[]=" u.active_status = 3 ";
            }
           
            $manual_cond=implode(' and ',$condition);
            // get information according to the filters selected
            $result = $this->m->get_info_for_finding_files($manual_cond);

            $result1 = $this->m->get_users_for_finding_files($manual_cond);

        }
        $noOfRecords =  count($result); // This has both request_ids as well as check_ids for a given request_id

        $count = 0; // count of all file_names in the document array

        if(!empty($result))
        {    
            // This has both request_ids as well as check_ids for a given request_id
            foreach($result as $row)
            {
                $check_id = $row['check_id']; 
                $req_id =  $row['request_id'];
                $case_no = $row['case_no']; // Added on 8th Aug

                // documents for that particular request_id and check_id is taken
                // for example:-  if check_id is 14, data is taken from db table
                // dcode_education_details
                $documents_arr = $this->m->get_docs_for_finding_files_for_request_id($req_id, $check_id);
                
                // concatenate request_id and check_id to the existing $html variable
                // $html .= 'CHECKS  ==> Case No  ==> ' . $case_no . '            Req_id => '. $req_id . '          check_id => ' . $check_id . '<br>';

                $filepath = '';
                $doc_name ='';

                //  if files or documents found, populate the $docs array
                if(!empty($documents_arr))
                {   
                    foreach($documents_arr as $record)
                    {
                        if(!empty($record['document_file']))
                        {
                            $docs[$count] = $record['document_file'];
                            
                            $docArr[$count] = array('req_id' => $req_id,
                                                    'check_id' => $check_id,
                                                    'case_no' => $case_no,
                                                    'filename' => $record['document_file'],
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                            $count++; // increment the index count of the $docs array
                        }
                    }
                }

                // files or documents found in fielddata and qc2fielddata columns of dcode_verified_level db table
                $res_arr = $this->m->get_verified_documents($req_id, $check_id);
      
                foreach($res_arr as $row1)
                {
                    $verification_data=toArray(json_decode($row1['fielddata']));
                    // take all filenames in details portion of the json
                    $ver_doc_arr = $verification_data['details'];
      
                    if(!empty($ver_doc_arr))
                    {   
                        /*** will be helpful later if we need file_path ***/
                        $filepath = '/uploads/qcreferencedetails'; 

                        $doc_name ='';

                        $arr  = explode(',',$ver_doc_arr); 
                        if(!empty($arr))
                        {
                            for($k=0; $k < count($arr);  $k++)
                            {
                                //  if files or documents found, populate the $docs array
                                if(!empty($arr[$k]))
                                {   
                                    $docs[$count] = $arr[$k];

                                    $docArr[$count] = array('req_id' => $req_id,
                                                    'check_id' => $check_id,
                                                    'case_no' => $case_no,
                                                    'filename' => $arr[$k],
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                                    $count++;  // increment the index count of the $docs array
                                }
                            }
                        }
                    }

                    $qc2_data=toArray(json_decode($row1['qc2fielddata']));
                    // take all filenames in authenticate_doc portion of the json
                    $qc2_doc_arr = $qc2_data['authenticate_doc'];
      
                    if(!empty($qc2_doc_arr))
                    {                        
                        /*** will be helpful later if we need file_path ***/
                        $filepath = '/uploads/candidate/document'; 
      
                        for($k=0; $k < count($qc2_doc_arr);  $k++)
                            {
                                //  if files or documents found, populate the $docs array
                                if(!empty($qc2_doc_arr[$k]))
                                {   
                                    // $docs[$count] = $qc2_doc_arr[$k];

                                    // echo  $qc2_doc_arr[$k] . '<br>';
                                    $res_doc_name_arr = $this->m->get_documentname_for_filename($req_id, $check_id, $qc2_doc_arr[$k]);
                                    $doc_name = $res_doc_name_arr['document_name'];
                                    
                                    $docArr[$count] = array('req_id' => $req_id,
                                                    'check_id' => $check_id,
                                                    'case_no' => $case_no,
                                                    'filename' => $qc2_doc_arr[$k],
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                                    $count++;  // increment the index count of the $docs array
                                }
                            }

                    }

                }

              
            }
        }
        
        $html .= '<b>Result  ==> </b>';
        
        if(!empty($result1))
        {   
            // This has only request_ids and corresponding user_ids
            foreach($result1 as $row)
            {
                // files or documents found in common db tables like personal_details etc.,
                $dummy_check_id = 0 ; // for common files check_id is considered as 0
                // $check_id = $row['check_id'];  // Added on 8th Aug
                $req_id =  $row['request_id'];
                $case_no = $row['case_no']; // Added on 8th Aug
                
                $doc_arr = $this->m->get_docs_for_finding_files_for_request_id($req_id, $dummy_check_id);
      
                $filepath = '';
                $doc_name ='';

                //  if files or documents found, populate the $docs array
                if(!empty($doc_arr))
                {   
                    foreach($doc_arr as $m)
                    {   
                        if(!empty($m['document_file']))
                        {
                            $docs[$count] = $m['document_file'];
                            $docArr[$count] = array('req_id' => $req_id,
                                                    'check_id' => $dummy_check_id,
                                                    'case_no' => $case_no,
                                                    'filename' => $m['document_file'],
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                            $count++; // increment the index count of the $docs array
                        }

                    }
                }
                $user_id = $row['user_id'];
      

                // files or documents found in dcode_user table
                $dummy_check_id = 999; // check_id is considered as 999 for files in dcode_user table
                $user_id =  $row['user_id'];

                $user_arr = $this->m->get_docs_for_finding_files_for_request_id($user_id, $dummy_check_id);

                $filepath = '';
                $doc_name ='';

                if(!empty($user_arr))
                {   
                    foreach($user_arr as $u)
                    {
                        //  if files or documents found, populate the $docs array
                        if(!empty($u['document_file']))
                        {
                            $docs[$count] = $u['document_file'];

                            $docArr[$count] = array('req_id' => $req_id,
                                                    'check_id' => $dummy_check_id,
                                                    'case_no' => $case_no,
                                                    'filename' => $u['document_file'],
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                            $count++;
                        }

                    }
                }
                    
            }
        }

        $html .= '<b>List of case_nos, check_ids, file_names, document name (if any) and filepaths ==>   </b><br>' . '<br>';
        for($i=0, $k=0; $i < count($docArr); $i++)
        {
            
            // find the position of '/' 
            $pos = strrpos($docArr[$i]['filename'],"/");            
            
            // If '/'  not found then the  array value is just a file name
            if(empty($pos))
            {
                $file_name = $docArr[$i]['filename'];
                $found = $this->findFile($file_name); // call renameFile function
            }
            // If '/' found then the array value contains file path.
            else
            {
                // take just the file name from the path
                $file_name = substr($docArr[$i]['filename'],++$pos);  
                $found = $this->findFile($file_name); // call findFile function
            }
           
            // if file not found then store the deleted file information in another array
            if($found == 0)
            {
                $deletedFilesArr[$k] = array('req_id' => $docArr[$i]['req_id'],
                                                    'check_id' => $docArr[$i]['check_id'],
                                                    'case_no' => $docArr[$i]['case_no'],
                                                    'filename' => $docArr[$i]['filename'],
                                                    'document_name' => $docArr[$i]['document_name'],
                                                    'filepath' => $docArr[$i]['filepath']
                                                );
                $k++;
            }
        }

        $jj = 0; // to show serial numbers
        //  loop through the array having deleted  files information to display
        foreach ($deletedFilesArr as $fileArr) 
        {
            $str = ++$jj .')  <b>case_no ==>' . $fileArr['case_no'] . '</b>&nbsp;&nbsp;&nbsp;        check_id ==>' . $fileArr['check_id'] . '&nbsp;&nbsp;&nbsp;   req_id ==>' . $fileArr['req_id']          . '&nbsp;&nbsp;&nbsp;         file_name ==>' . $fileArr['filename'] .  '&nbsp;&nbsp;&nbsp;<b>         document_name ==>' . $fileArr['document_name'] . '</b>&nbsp;&nbsp;&nbsp;         file_path ==>' . $fileArr['filepath'] .' <br>';
            $html .= $str;
        }

       
        $html .= '<br><br><b>' . date('d-m-Y H:i:s') . '</b>'; $html .= '<br>' .  '<br>';
        if($this->files_not_found == '')
            $this->files_not_found = 0;
        $html .= '<br><b>Number of files not found ==> ' . $this->files_not_found  . '</b>';
        if($this->files_found == '')
            $this->files_found = 0;
        $html .= '<br><b>Number of files found ==> ' . $this->files_found  . '</b>';
        $data['html'] = $html;
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('List Deleted Files', 'MissingFiles/list_deleted_files');
        $this->breadcrumbs->push('Display Missing/ Deleted Files', 'MissingFiles/list_files_folders');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'list_files_folders');

    } //  end of function list_files_folders
      

    /**********************************************************************************
    * grid_listing_of_files_without_union
    ***********************************************************************************/
    function grid_listing_of_files_without_union()
    {
        // echo '<b>IN without UNION' . date('d-m-Y H:i:s') . '</b><br><br>';
        
        // model name and method name
        $model = array('MissingFiles_model'=>'get_grid_view_of_missing_files');


         $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office_id = ($_REQUEST['parent_office_id']) ? $_REQUEST['parent_office_id'] : '';
        $branch_office_id = ($_REQUEST['branch_office_id']) ? $_REQUEST['branch_office_id'] : '';        
        $sub_office_id = ($_REQUEST['sub_office_id']) ? $_REQUEST['sub_office_id'] : '';
        $from_date = ($_REQUEST['from_date']) ? $_REQUEST['from_date'] : '';
        $to_date = ($_REQUEST['to_date']) ? $_REQUEST['to_date'] : '';

        if($org_id){
            $condition[]=" cr.organisation = ".$org_id;
        }
        if($parent_office_id){
            $condition[]=" cr.parent_office = ".$parent_office_id;
        }
        if($branch_office_id){
            $condition[]=" cr.office = ".$branch_office_id;
        }
        if($sub_office_id){
            $condition[]=" cr.sub_office = ".$sub_office_id;
        }
        // and `created_on` BETWEEN CAST('2023-01-01' AS DATE) AND CAST('2023-03-31' AS DATE)
        if($from_date){
            if($to_date){
                 $condition[]=" (DATE_FORMAT(cr.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."' and DATE_FORMAT(cr.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."') ";
           }
        }


        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); // calling the model method with $manual_cond as argument
        $response = $results[0]; 
        $result = $results[1];
        // print_r($result); exit();
        $result1 = $this->m->get_users_for_finding_files($manual_cond);
        
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
        
            $docArr = array(); // declare a multi-dimensional associative array to hold all files
            $deletedFilesArr = array(); // declare a multi-dimensional associative array to hold deleted files
            $arr_count = 0; // count of all file_names in the document array

            foreach( $result as $i => $row ) {      
               
                /************/
                $check_id = $row['check_id']; 
                $req_id =  $row['request_id'];
                $case_no = $row['case_no']; // Added on 8th Aug

                // documents for that particular request_id and check_id is taken
                // for example:-  if check_id is 14, data is taken from db table
                // dcode_education_details
                // $documents_arr = $this->m->get_docs_for_finding_files_for_request_id($req_id, $check_id);
                $table_name_arr = $this->m->get_table_names_file_paths_for_check_id($check_id);
                $filepath = '';
                $doc_name ='';

                if($table_name_arr)
                {
                    $i = 0;
                    foreach($table_name_arr as $table_row)
                    {
                        $col_name = $table_row['column_name'];
                        $table_name = $table_row['table_name'];
                        $req_id_name = $table_row['req_id_name'];
                        $filepath = $table_row['file_path'];

                        $documents_arr[$i] = $this->m->get_doc_name_file_name_for_req_id($col_name,  $table_name, $filepath, $req_id_name, $req_id);
                        $i++;
                    }
                }

                //  if files or documents found, populate the $docs array
                if(!empty($documents_arr))
                {   
                    foreach($documents_arr as $record)
                    {
                        if(!empty($record['document_file']))
                        {
                            // $docs[$arr_count] = $record['document_file'];
                            $filepath = $record['file_path'];
                            $doc_name = $record['doc_name'];
                            if($check_id == 14)
                            {
                                switch($doc_name)
                                {
                                    case 'document_file': $doc_name = 'consolidated marks';
                                        break;
                                    case 'gdocument': $doc_name = 'degree certificate';
                                        break;
                                    case 'consolidate_doc': $doc_name = 'marks card';
                                        break;
                                    case 'pdocument': $doc_name = 'provisional degree';
                                        break;
                                    default:
                                        break;
                                }

                            }

                            $docArr[$arr_count] = array('req_id' => $req_id,
                                                    'org_name' => $row['org_name'],
                                                    'check_id' => $check_id,
                                                    'check_name' => $row['name'],
                                                    'candidate_name' => $row['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'created_on' => $row['created_on'],
                                                    'case_accepted_date' => $row['case_accepted_date'],
                                                    'case_recieved_date' => $row['case_recieved_date'],
                                                    'final_report_published_date' => $row['final_report_published_date'],
                                                    'supplement_report_date' => $row['supplement_report_date'],
                                                    'filename' => $record['document_file'],
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                            $arr_count++; // increment the index count of the $docs and $docArr arrays
                        }
                    }
                }

                // files or documents found in fielddata and qc2fielddata columns of dcode_verified_level db table
                $res_arr = $this->m->get_verified_documents($req_id, $check_id);
      
                foreach($res_arr as $row1)
                {
                    $verification_data=toArray(json_decode($row1['fielddata']));

                    // take all filenames in details portion of the json
                    $ver_doc_arr = $verification_data['details'];
      
                    if(!empty($ver_doc_arr))
                    {   
                        /*** will be helpful later if we need file_path ***/
                        $filepath = 'uploads/qcreferencedetails/'; 

                        $doc_name ='qcreferencedetails';

                        $arr  = explode(',',$ver_doc_arr); 
                        if(!empty($arr))
                        {
                            for($k=0; $k < count($arr);  $k++)
                            {
                                //  if files or documents found, populate the $docs array
                                if(!empty($arr[$k]))
                                {   
                                    $docs[$arr_count] = $arr[$k];

                                    $docArr[$arr_count] = array('req_id' => $req_id,
                                                    'org_name' => $row['org_name'],
                                                    'check_id' => $check_id,
                                                    'check_name' => $row['name'],
                                                    'candidate_name' => $row['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'created_on' => $row['created_on'],
                                                    'case_accepted_date' => $row['case_accepted_date'],
                                                    'case_recieved_date' => $row['case_recieved_date'],
                                                    'final_report_published_date' => $row['final_report_published_date'],
                                                    'supplement_report_date' => $row['supplement_report_date'],
                                                    'filename' => $arr[$k],
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                                    $arr_count++;  // increment the index count of the $docs array
                                }
                            }
                        }
                    }
                    $qc2_data=toArray(json_decode($row1['qc2fielddata']));

                    // take all filenames in authenticate_doc portion of the json
                    $qc2_doc_arr = $qc2_data['authenticate_doc'];
      
                    if(!empty($qc2_doc_arr))
                    {                        
                        /*** will be helpful later if we need file_path ***/
                        $filepath = 'uploads/candidate/document/'; 
      
                        for($k=0; $k < count($qc2_doc_arr);  $k++)
                            {
                                //  if files or documents found, populate the $docs array
                                if(!empty($qc2_doc_arr[$k]))
                                {   
                                    // $docs[$arr_count] = $qc2_doc_arr[$k];
                                    $res_doc_name_arr = $this->m->get_documentname_for_filename($req_id, $check_id, $qc2_doc_arr[$k]);
                                    $doc_name = $res_doc_name_arr['document_name'];
                                    
                                    $docArr[$arr_count] = array('req_id' => $req_id,
                                                    'org_name' => $row['org_name'],
                                                    'check_id' => $check_id,
                                                    'check_name' => $row['name'],
                                                    'candidate_name' => $row['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'created_on' => $row['created_on'],
                                                    'case_accepted_date' => $row['case_accepted_date'],
                                                    'case_recieved_date' => $row['case_recieved_date'],
                                                    'final_report_published_date' => $row['final_report_published_date'],
                                                    'supplement_report_date' => $row['supplement_report_date'],
                                                    'filename' => $qc2_doc_arr[$k],
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );

                                    $arr_count++;  // increment the index count of the $docs array
                                }
                            }

                    }

                }
                /************/  
            
            }

        }

        if(!empty($result1))
        {   
            // This has only request_ids and corresponding user_ids
            foreach($result1 as $row2)
            {
                // files or documents found in common db tables like personal_details etc.,
                $dummy_check_id = 0 ; // for common files check_id is considered as 0
                
                $req_id =  $row2['request_id'];
                $case_no = $row2['case_no']; // Added on 8th Aug
                
                // $doc_arr = $this->m->get_docs_for_finding_files_for_request_id($req_id, $dummy_check_id);
                $table_name_arr_common = $this->m->get_table_names_file_paths_for_check_id($dummy_check_id);
                $filepath = '';
                $doc_name ='';

                if($table_name_arr_common)
                {
                    $i = 0;
                    foreach($table_name_arr_common as $tablerow)
                    {
                        $col_name = $tablerow['column_name'];
                        $table_name = $tablerow['table_name'];
                        $req_id_name = $tablerow['req_id_name'];
                        $doc_arr[$i] = $this->m->get_doc_name_file_name_for_req_id($col_name,  $table_name,  $req_id_name, $req_id);
                        $i++;
                    }
                }
      
                $filepath = '';
                $doc_name ='';

                //  if files or documents found, populate the $docs array
                if(!empty($doc_arr))
                {   
                    foreach($doc_arr as $m)
                    {   
                        if(!empty($m['document_file']))
                        {
                            // $docs[$arr_count] = $m['document_file'];
                            $filepath = $m['file_path'];
                            $tablename = $m['table_name'];
                            $filename = $m['document_file'];
                            $doc_name = $m['doc_name'];

                            if($tablename == 'dcode_partial_upload_document')
                            {
                                $doc_name_arr = $this->m->get_doc_name_from_partial_upload_document($req_id, $filename);
                                $doc_name = $doc_name_arr['document_name'];
                            }
                            $docArr[$arr_count] = array('req_id' => $req_id,
                                        'org_name' => $row2['org_name'],
                                                    'check_id' => $dummy_check_id,
                                                    'check_name' => 'common',
                                                    'candidate_name' => $row2['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'created_on' => $row2['created_on'],
                                                    'case_accepted_date' => $row2['case_accepted_date'],
                                                    'case_recieved_date' => $row2['case_recieved_date'],
                                                    'final_report_published_date' => $row2['final_report_published_date'],
                                                    'supplement_report_date' => $row2['supplement_report_date'],
                                                    'filename' => $filename,
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                            $arr_count++; // increment the index count of the $docs array
                        }

                    }
                }
                
                // files or documents found in dcode_user table
                $dummy_check_id = 999; // check_id is considered as 999 for files in dcode_user table
                $user_id =  $row2['user_id'];

                
                $table_name_arr_user = $this->m->get_table_names_file_paths_for_check_id($dummy_check_id);
                $filepath = '';
                $doc_name ='';

                if($table_name_arr_user)
                {
                    $i = 0;
                    foreach($table_name_arr_user as $user_row)
                    {
                        $col_name = $user_row['column_name'];
                        $table_name = $user_row['table_name'];
                        $req_id_name = $user_row['req_id_name'];
                        $user_arr[$i] = $this->m->get_doc_name_file_name_for_req_id($col_name,  $table_name,  $req_id_name, $req_id);
                        $i++;
                    }
                }

                if(!empty($user_arr))
                {   
                    foreach($user_arr as $u)
                    {
                        //  if files or documents found, populate the $docs array
                        if(!empty($u['document_file']))
                        {
                            
                            $docArr[$arr_count] = array('req_id' => $req_id,
                                        'org_name' => $row2['org_name'],
                                                    'check_id' => $dummy_check_id,
                                                    'check_name' => 'user',
                                                    'candidate_name' => $row2['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'created_on' => $row2['created_on'],
                                                    'case_accepted_date' => $row2['case_accepted_date'],
                                                    'case_recieved_date' => $row2['case_recieved_date'],
                                                    'final_report_published_date' => $row2['final_report_published_date'],
                                                    'supplement_report_date' => $row2['supplement_report_date'],
                                                    'filename' => $u['document_file'],
                                                    'document_name' => $u['doc_name'],
                                                    'filepath' => $filepath
                                                );
                            $arr_count++;
                        }

                    }
                }
                    
            }
        }

        if(!empty($docArr))
        {
            for($i=0, $k=0; $i < count($docArr); $i++)
                    {
                        
                        $file_path = $docArr[$i]['filepath'];
                        $found = 2;
                        if($file_path)
                        {// find the position of '/' 
                            $pos = strrpos($docArr[$i]['filename'],"/");            
                            
                            // If '/'  not found then the  array value is just a file name
                            if(empty($pos))
                            {
                                $file_name = $docArr[$i]['filename'];
                                $found = $this->findFile_with_Path($file_name, $file_path ); // call renameFile function
                            }
                            // If '/' found then the array value contains file path.
                            else
                            {
                                // take just the file name from the path
                                $file_name = substr($docArr[$i]['filename'],++$pos);  
                                $found = $this->findFile_with_Path($file_name, $file_path); // call findFile function
                            }
                           
                            // if file not found then store the deleted file information in another array
                            if($found == 0)
                            {
                                $deletedFilesArr[$k] = array('req_id' => $docArr[$i]['req_id'],
                                                        'org_name' => $docArr[$i]['org_name'],
                                                        'check_id' => $docArr[$i]['check_id'],
                                                        'check_name' => $docArr[$i]['check_name'],
                                                        'candidate_name' => $docArr[$i]['candidate_name'],
                                                        'case_no' => $docArr[$i]['case_no'],
                                                        'created_on' => $docArr[$i]['created_on'],
                                                        'case_accepted_date' => $docArr[$i]['case_accepted_date'],
                                                        'case_recieved_date' => $docArr[$i]['case_recieved_date'],
                                                        'final_report_published_date' => $docArr[$i]['final_report_published_date'],
                                                        'supplement_report_date' => $docArr[$i]['supplement_report_date'],
                                                        'filename' => $docArr[$i]['filename'],
                                                        'document_name' => $docArr[$i]['document_name'],
                                                        'filepath' => $docArr[$i]['filepath']
                                                    );
                                $k++;
                            }

                            if($found == -1) // Not directory
                            {
                                $file_in_red  = "<span style='color:red;'>". $docArr[$i]['filename'] . "</span>";

                                $deletedFilesArr[$k] = array('req_id' => $docArr[$i]['req_id'],
                                                        'org_name' => $docArr[$i]['org_name'],
                                                        'check_id' => $docArr[$i]['check_id'],
                                                        'check_name' => $docArr[$i]['check_name'],
                                                        'candidate_name' => $docArr[$i]['candidate_name'],
                                                        'case_no' => $docArr[$i]['case_no'],
                                                        'created_on' => $docArr[$i]['created_on'],
                                                        'case_accepted_date' => $docArr[$i]['case_accepted_date'],
                                                        'case_recieved_date' => $docArr[$i]['case_recieved_date'],
                                                        'final_report_published_date' => $docArr[$i]['final_report_published_date'],
                                                        'supplement_report_date' => $docArr[$i]['supplement_report_date'],
                                                        'filename' =>  $file_in_red,
                                                        'document_name' => $docArr[$i]['document_name'],
                                                        'filepath' => $docArr[$i]['filepath']
                                                    );
                                $k++;
                            }
                        }
                        else
                        {
                            //  what to do if file path not found
                        }
                    }
        }

        $jj = 0; // to show serial numbers
 // echo 'deletedFilesArr ==>' ; print_r($deletedFilesArr); echo '<br>';
        //  loop through the array having deleted  files information to display
        if(!empty($deletedFilesArr))
        {
            foreach ($deletedFilesArr as $fileArr) 
            {
                $response->rows [$jj] ['cell'] = array ( $jj+$count+1,$fileArr['org_name'],$fileArr['candidate_name'],$fileArr['case_no'],$fileArr['check_name'], $fileArr['document_name'], $fileArr['filename'],$fileArr['created_on'], $fileArr['case_accepted_date'], $fileArr['case_recieved_date'],$fileArr['final_report_published_date'],$fileArr['supplement_report_date']);
                $jj++;
            }
        }

        echo json_encode($response);

    }
    /**********************************************************************************
    * export_missing_files_list_without_union
    ***********************************************************************************/
    function export_missing_files_list_without_union()
    {
        // model name and method name
        $model = array('MissingFiles_model'=>'get_xls_of_missing_files');


        $org_id = ($_REQUEST['exp_org_id']) ? $_REQUEST['exp_org_id'] : '';
        $parent_office_id = ($_REQUEST['exp_parent_office_id']) ? $_REQUEST['exp_parent_office_id'] : '';
        $branch_office_id = ($_REQUEST['exp_branch_office_id']) ? $_REQUEST['exp_branch_office_id'] : '';        
        $sub_office_id = ($_REQUEST['exp_sub_office_id']) ? $_REQUEST['exp_sub_office_id'] : '';
        $from_date = ($_REQUEST['exp_from_date']) ? $_REQUEST['exp_from_date'] : '';
        $to_date = ($_REQUEST['exp_to_date']) ? $_REQUEST['exp_to_date'] : '';

        if($org_id){
            $condition[]=" cr.organisation = ".$org_id;
        }
        if($parent_office_id){
            $condition[]=" cr.parent_office = ".$parent_office_id;
        }
        if($branch_office_id){
            $condition[]=" cr.office = ".$branch_office_id;
        }
        if($sub_office_id){
            $condition[]=" cr.sub_office = ".$sub_office_id;
        }
        // and `created_on` BETWEEN CAST('2023-01-01' AS DATE) AND CAST('2023-03-31' AS DATE)
        if($from_date){
            if($to_date){
                 $condition[]=" (DATE_FORMAT(cr.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."' and DATE_FORMAT(cr.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."') ";
           }
        }


        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); // calling the model method with $manual_cond as argument
        $response = $results[0]; 
        $result = $results[1];

        $result1 = $this->m->get_users_for_finding_files($manual_cond);
        
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
        
            $docArr = array(); // declare a multi-dimensional associative array to hold all files
            $deletedFilesArr = array(); // declare a multi-dimensional associative array to hold deleted files
            $arr_count = 0; // count of all file_names in the document array

            foreach( $result as $i => $row ) {      
               
                /************/
                $check_id = $row['check_id']; 
                $req_id =  $row['request_id'];
                $case_no = $row['case_no']; // Added on 8th Aug

                // documents for that particular request_id and check_id is taken
                // for example:-  if check_id is 14, data is taken from db table
                // dcode_education_details
                // $documents_arr = $this->m->get_docs_for_finding_files_for_request_id($req_id, $check_id);
                $table_name_arr = $this->m->get_table_names_file_paths_for_check_id($check_id);
                $filepath = '';
                $doc_name ='';

                if($table_name_arr)
                {
                    $i = 0;
                    foreach($table_name_arr as $table_row)
                    {
                        $col_name = $table_row['column_name'];
                        $table_name = $table_row['table_name'];
                        $req_id_name = $table_row['req_id_name'];
                        $filepath = $table_row['file_path'];

                        $documents_arr[$i] = $this->m->get_doc_name_file_name_for_req_id($col_name,  $table_name, $filepath, $req_id_name, $req_id);
                    }
                }
                //  if files or documents found, populate the $docs array
                if(!empty($documents_arr))
                {   
                    foreach($documents_arr as $record)
                    {
                        if(!empty($record['document_file']))
                        {
                            // $docs[$arr_count] = $record['document_file'];
                            $filepath = $record['file_path'];
                            $doc_name = $record['doc_name'];
                            if($check_id == 14)
                            {
                                switch($doc_name)
                                {
                                    case 'document_file': $doc_name = 'consolidated marks';
                                        break;
                                    case 'gdocument': $doc_name = 'degree certificate';
                                        break;
                                    case 'consolidate_doc': $doc_name = 'marks card';
                                        break;
                                    case 'pdocument': $doc_name = 'provisional degree';
                                        break;
                                    default:
                                        break;
                                }

                            }

                            $docArr[$arr_count] = array('req_id' => $req_id,
                                                    'org_name' => $row['org_name'],
                                                    'check_id' => $check_id,
                                                    'check_name' => $row['name'],
                                                    'candidate_name' => $row['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'created_on' => $row['created_on'],
                                                    'case_accepted_date' => $row['case_accepted_date'],
                                                    'case_recieved_date' => $row['case_recieved_date'],
                                                    'final_report_published_date' => $row['final_report_published_date'],
                                                    'supplement_report_date' => $row['supplement_report_date'],
                                                    'filename' => $record['document_file'],
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                            $arr_count++; // increment the index count of the $docs and $docArr arrays
                        }
                    }
                }

                // files or documents found in fielddata and qc2fielddata columns of dcode_verified_level db table
                $res_arr = $this->m->get_verified_documents($req_id, $check_id);
      
                foreach($res_arr as $row1)
                {
                    $verification_data=toArray(json_decode($row1['fielddata']));

                    // take all filenames in details portion of the json
                    $ver_doc_arr = $verification_data['details'];
      
                    if(!empty($ver_doc_arr))
                    {   
                        /*** will be helpful later if we need file_path ***/
                        $filepath = 'uploads/qcreferencedetails/'; 

                        $doc_name ='qcreferencedetails';

                        $arr  = explode(',',$ver_doc_arr); 
                        if(!empty($arr))
                        {
                            for($k=0; $k < count($arr);  $k++)
                            {
                                //  if files or documents found, populate the $docs array
                                if(!empty($arr[$k]))
                                {   
                                    $docs[$arr_count] = $arr[$k];

                                    $docArr[$arr_count] = array('req_id' => $req_id,
                                                    'org_name' => $row['org_name'],
                                                    'check_id' => $check_id,
                                                    'check_name' => $row['name'],
                                                    'candidate_name' => $row['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'created_on' => $row['created_on'],
                                                    'case_accepted_date' => $row['case_accepted_date'],
                                                    'case_recieved_date' => $row['case_recieved_date'],
                                                    'final_report_published_date' => $row['final_report_published_date'],
                                                    'supplement_report_date' => $row['supplement_report_date'],
                                                    'filename' => $arr[$k],
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                                    $arr_count++;  // increment the index count of the $docs array
                                }
                            }
                        }
                    }
                    $qc2_data=toArray(json_decode($row1['qc2fielddata']));

                    // take all filenames in authenticate_doc portion of the json
                    $qc2_doc_arr = $qc2_data['authenticate_doc'];
      
                    if(!empty($qc2_doc_arr))
                    {                        
                        /*** will be helpful later if we need file_path ***/
                        $filepath = 'uploads/candidate/document/'; 
      
                        for($k=0; $k < count($qc2_doc_arr);  $k++)
                            {
                                //  if files or documents found, populate the $docs array
                                if(!empty($qc2_doc_arr[$k]))
                                {   
                                    // $docs[$arr_count] = $qc2_doc_arr[$k];
                                    $res_doc_name_arr = $this->m->get_documentname_for_filename($req_id, $check_id, $qc2_doc_arr[$k]);
                                    $doc_name = $res_doc_name_arr['document_name'];
                                    
                                    $docArr[$arr_count] = array('req_id' => $req_id,
                                                    'org_name' => $row['org_name'],
                                                    'check_id' => $check_id,
                                                    'check_name' => $row['name'],
                                                    'candidate_name' => $row['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'created_on' => $row['created_on'],
                                                    'case_accepted_date' => $row['case_accepted_date'],
                                                    'case_recieved_date' => $row['case_recieved_date'],
                                                    'final_report_published_date' => $row['final_report_published_date'],
                                                    'supplement_report_date' => $row['supplement_report_date'],
                                                    'filename' => $qc2_doc_arr[$k],
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );

                                    $arr_count++;  // increment the index count of the $docs array
                                }
                            }

                    }

                }
                /************/  
            
            }
        }

         if(!empty($result1))
        {   
            // This has only request_ids and corresponding user_ids
            foreach($result1 as $row2)
            {
                // files or documents found in common db tables like personal_details etc.,
                $dummy_check_id = 0 ; // for common files check_id is considered as 0
                
                $req_id =  $row2['request_id'];
                $case_no = $row2['case_no']; // Added on 8th Aug
                
                // $doc_arr = $this->m->get_docs_for_finding_files_for_request_id($req_id, $dummy_check_id);
                $table_name_arr_common = $this->m->get_table_names_file_paths_for_check_id($dummy_check_id);
                $filepath = '';
                $doc_name ='';

                if($table_name_arr_common)
                {
                    $i = 0;
                    foreach($table_name_arr_common as $tablerow)
                    {
                        $col_name = $tablerow['column_name'];
                        $table_name = $tablerow['table_name'];
                        $req_id_name = $tablerow['req_id_name'];
                        $doc_arr[$i] = $this->m->get_doc_name_file_name_for_req_id($col_name,  $table_name,  $req_id_name, $req_id);
                        $i++;
                    }
                }
      
                $filepath = '';
                $doc_name ='';

                //  if files or documents found, populate the $docs array
                if(!empty($doc_arr))
                {   
                    foreach($doc_arr as $m)
                    {   
                        if(!empty($m['document_file']))
                        {
                            // $docs[$arr_count] = $m['document_file'];
                            $filepath = $m['file_path'];
                            $tablename = $m['table_name'];
                            $filename = $m['document_file'];
                            $doc_name = $m['doc_name'];

                            if($tablename == 'dcode_partial_upload_document')
                            {
                                $doc_name_arr = $this->m->get_doc_name_from_partial_upload_document($req_id, $filename);
                                $doc_name = $doc_name_arr['document_name'];
                            }
                            $docArr[$arr_count] = array('req_id' => $req_id,
                                        'org_name' => $row2['org_name'],
                                                    'check_id' => $dummy_check_id,
                                                    'check_name' => 'common',
                                                    'candidate_name' => $row2['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'created_on' => $row2['created_on'],
                                                    'case_accepted_date' => $row2['case_accepted_date'],
                                                    'case_recieved_date' => $row2['case_recieved_date'],
                                                    'final_report_published_date' => $row2['final_report_published_date'],
                                                    'supplement_report_date' => $row2['supplement_report_date'],
                                                    'filename' => $filename,
                                                    'document_name' => $doc_name,
                                                    'filepath' => $filepath
                                                );
                            $arr_count++; // increment the index count of the $docs array
                        }

                    }
                }
                
                // files or documents found in dcode_user table
                $dummy_check_id = 999; // check_id is considered as 999 for files in dcode_user table
                $user_id =  $row2['user_id'];

                
                $table_name_arr_user = $this->m->get_table_names_file_paths_for_check_id($dummy_check_id);
                $filepath = '';
                $doc_name ='';

                if($table_name_arr_user)
                {
                    $i = 0;
                    foreach($table_name_arr_user as $user_row)
                    {
                        $col_name = $user_row['column_name'];
                        $table_name = $user_row['table_name'];
                        $req_id_name = $user_row['req_id_name'];
                        $user_arr[$i] = $this->m->get_doc_name_file_name_for_req_id($col_name,  $table_name,  $req_id_name, $req_id);
                        $i++;
                    }
                }

                if(!empty($user_arr))
                {   
                    foreach($user_arr as $u)
                    {
                        //  if files or documents found, populate the $docs array
                        if(!empty($u['document_file']))
                        {
                            
                            $docArr[$arr_count] = array('req_id' => $req_id,
                                        'org_name' => $row2['org_name'],
                                                    'check_id' => $dummy_check_id,
                                                    'check_name' => 'user',
                                                    'candidate_name' => $row2['candidate_name'],
                                                    'case_no' => $case_no,
                                                    'created_on' => $row2['created_on'],
                                                    'case_accepted_date' => $row2['case_accepted_date'],
                                                    'case_recieved_date' => $row2['case_recieved_date'],
                                                    'final_report_published_date' => $row2['final_report_published_date'],
                                                    'supplement_report_date' => $row2['supplement_report_date'],
                                                    'filename' => $u['document_file'],
                                                    'document_name' => $u['doc_name'],
                                                    'filepath' => $filepath
                                                );
                            $arr_count++;
                        }

                    }
                }
                    
            }
        }

        if(!empty($docArr))
        {
            for($i=0, $k=0; $i < count($docArr); $i++)
                    {
                        
                        $file_path = $docArr[$i]['filepath'];
                        if($file_path)
                        {// find the position of '/' 
                            $pos = strrpos($docArr[$i]['filename'],"/");            
                            $found = 2;

                            // If '/'  not found then the  array value is just a file name
                            if(empty($pos))
                            {
                                $file_name = $docArr[$i]['filename'];
                                $found = $this->findFile_with_Path($file_name, $file_path ); // call renameFile function
                            }
                            // If '/' found then the array value contains file path.
                            else
                            {
                                // take just the file name from the path
                                $file_name = substr($docArr[$i]['filename'],++$pos);  
                                $found = $this->findFile_with_Path($file_name, $file_path); // call findFile function
                            }
                           
                            // if file not found then store the deleted file information in another array
                            if($found == 0)
                            {
                                $deletedFilesArr[$k] = array('req_id' => $docArr[$i]['req_id'],
                                                        'org_name' => $docArr[$i]['org_name'],
                                                        'check_id' => $docArr[$i]['check_id'],
                                                        'check_name' => $docArr[$i]['check_name'],
                                                        'candidate_name' => $docArr[$i]['candidate_name'],
                                                        'case_no' => $docArr[$i]['case_no'],
                                                        'created_on' => $docArr[$i]['created_on'],
                                                        'case_accepted_date' => $docArr[$i]['case_accepted_date'],
                                                        'case_recieved_date' => $docArr[$i]['case_recieved_date'],
                                                        'final_report_published_date' => $docArr[$i]['final_report_published_date'],
                                                        'supplement_report_date' => $docArr[$i]['supplement_report_date'],
                                                        'filename' => $docArr[$i]['filename'],
                                                        'document_name' => $docArr[$i]['document_name'],
                                                        'filepath' => $docArr[$i]['filepath']
                                                    );
                                $k++;
                            }

                            if($found == -1) // Not directory
                            {
                                $file_in_red  = $docArr[$i]['filepath'] . "  directory does not exist";

                                $deletedFilesArr[$k] = array('req_id' => $docArr[$i]['req_id'],
                                                        'org_name' => $docArr[$i]['org_name'],
                                                        'check_id' => $docArr[$i]['check_id'],
                                                        'check_name' => $docArr[$i]['check_name'],
                                                        'candidate_name' => $docArr[$i]['candidate_name'],
                                                        'case_no' => $docArr[$i]['case_no'],
                                                        'created_on' => $docArr[$i]['created_on'],
                                                        'case_accepted_date' => $docArr[$i]['case_accepted_date'],
                                                        'case_recieved_date' => $docArr[$i]['case_recieved_date'],
                                                        'final_report_published_date' => $docArr[$i]['final_report_published_date'],
                                                        'supplement_report_date' => $docArr[$i]['supplement_report_date'],
                                                        'filename' =>  $file_in_red,
                                                        'document_name' => $docArr[$i]['document_name'],
                                                        'filepath' => $docArr[$i]['filepath']
                                                    );
                                $k++;
                            }
                        }
                        else
                        {
                            //  what to do if file path not found
                        }
                    }
        }

        $jj = 0;
        if(!empty($deletedFilesArr))
        {
            $objPHPExcel = new PHPExcel(); // Creating an excel object and setting parameters for it.
            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Document Name");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "File Name");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Created On");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Case Accepted Date");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Case Received Date");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "Final Report Published Date");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Supplementary Report Date");
     
            $ci=2;
            foreach ($deletedFilesArr as $fileArr) 
            {
                $objPHPExcel->getActiveSheet()->getStyle('A1:L1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ( $jj+$count+1))
                                          ->setCellValue('B' . $ci, $fileArr['org_name'])
                                          ->setCellValue('C' . $ci, $fileArr['candidate_name'])
                                          ->setCellValue('D' . $ci, $fileArr['case_no'])
                                          ->setCellValue('E' . $ci, $fileArr['check_name'])
                                          ->setCellValue('F' . $ci, $fileArr['document_name'])
                                          ->setCellValue('G' . $ci, $fileArr['filename'])
                                          ->setCellValue('H' . $ci, $fileArr['created_on'])
                                          ->setCellValue('I' . $ci, $fileArr['case_accepted_date'])
                                          ->setCellValue('J' . $ci, $fileArr['case_recieved_date'])
                                          ->setCellValue('K' . $ci, $fileArr['final_report_published_date'])
                                          ->setCellValue('L' . $ci, $fileArr['supplement_report_date']);
                $ci++;
                $jj++;
            }
            $this->export_excel('A','L','Missing_Files_List_',$objPHPExcel); // An excel file with above is created.
            exit; 
        }

            
    }
      
   
    /*******************************************************************************************
     * findFile($file_name)
     * Searches for the file given as an argument in the "uploads" directory
     * A file_found count and file_not_found count are incremented accordingly
     ********************************************************************************************/
    function findFile($file_name)
    {
        $directory = new \RecursiveDirectoryIterator('uploads');
        $iterator = new \RecursiveIteratorIterator($directory);

        $filename = $file_name;

        $str = '';
        foreach ($iterator as $info) {
           
            // If file found
            if ($info->getFilename() == $filename) {
                $oldFile = $info->getFileInfo();
                
                $this->files_found += 1; // increment the file_found variable
                
                // return  "File Name ==> " . $oldFile .  '<br>';
                return 1;
                
            }            
        }

        $this->files_not_found += 1; // increment the file_not_found variable
        // return  $str . '<p style="color:red;"> File Not found ==> ' .$filename . '</p>';
        return 0;

    }

    /*******************************************************************************************
     * findFile_with_Path($file_name, $file_path)
     * Searches for the file given as an argument in the $file_path directory
     * A file_found count and file_not_found count are incremented accordingly
     ********************************************************************************************/
    function findFile_with_Path($file_name, $file_path)
    {
        if($file_path && is_dir($file_path))
        {
           
            $file_name_with_path=$file_path.$file_name;

            if(file_exists($file_name_with_path)){
                return 1;
            }else{
                /** Sep 13th **/
                if($file_path == 'uploads/particaldocument/')
                {
                    $file_path = 'uploads/candidate/files/';
                    $file_name_with_path=$file_path.$file_name;

                    if(file_exists($file_name_with_path)){
                        return 1;
                    }else{
                        return 0;
                    }
                }
                /** Sep 13th **/
                return 0;
            }
            
        }
        return -1; // if file path given is not a directory
    }


  /**********************************************************************************
    * listing_missingfile     // 06/09/2023

    ***********************************************************************************/
    function list_missingfiles() 
    {
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Missing Files', 'MissingFiles/List_missingfiles');
        // 22/09/2023 
        $data['organization'] = $organization=$this->amodel->getDetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('id !=' => 1,'org_status'=>1));
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'list_missingfiles');
    }


function get_list_missingfiles() {

        $model = array('MissingFiles_model'=>'get_list_missingfiles_model');
        
        $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $case_no =($_REQUEST['case_no']) ? $_REQUEST['case_no'] : ''; 
        $status =($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $role_id = $this->session->userdata['role_id'];
        // 22/09/2023 
        if($role_id == 1 || $role_id == 9){
        $qcname = ($_REQUEST['qcname']) ? $_REQUEST['qcname'] : ''; 
        $vname = ($_REQUEST['vname']) ? $_REQUEST['vname'] : ''; 
        }
         
        $org_id =($_REQUEST['org_id']) ? $_REQUEST['org_id'] : ''; 
        if(!empty($org_id)){
                     $condition[]=" o.id = ".$org_id;
               }

        if(trim($vname))
         $condition[]="(usr.first_name like '%".trim($vname)."%')";

        if(trim($qcname))
         $condition[]="(us.first_name like '%".trim($qcname)."%')";
          
        if(trim($name)){
        $condition[]="(cr.candidate_name like '%".trim($name)."%')";
        }

        if($status== 1){
                    $condition[]=" mf.file_status =0 ";
               }
           if($status== 2){
                    $condition[]=" mf.file_status = 1  ";
               }  
             if($status== 3){
                    $condition[]=" mf.file_status = 2 ";
               }     
        //18/01/2024
        $case_no = trim($case_no); 
        if($case_no)
        $condition[]="mf.case_no like '%".$case_no."%' ";
        
        if(!empty($c_date)){
               $condition[]="DATE_FORMAT(mf.insertion_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
            }
            if(!empty($t_date)){
               $condition[]="DATE_FORMAT(mf.insertion_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
            }

        if($term)
        {
        //support multiple words
        $search = explode(' ', $term);

        foreach($search as $t) {
        $not        = '';
        $operator    = 'OR';
        if(substr($t,0,1) == '-')
        {
        $not        = 'NOT ';
        $operator    = 'AND';
        //trim the - sign off
        $t        = substr($t,1,strlen($t));
        }
         // 22/09/2023 
        $like    = '';
        $like    .= "( mf.insertion_date ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator."mf.file_status ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator."o.id ".$not."LIKE '%".$t."%' " ;
        $like    .= $operator." mf.case_no ".$not."LIKE '%".$t."%' )" ;
        
        $condition[]=$like;
        }
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        if ($result) {
            $checkteam = $this->config->item('CHECKLIST',APPLICATIONCONFIG);
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            $k=1;

    foreach( $result as $i => $row ) {
        $candidatename = $row['candidate_name'];
        $case_no       = $row['case_no'];
        $org_name      = $row['org_name'];
        $checkname     = $row['name'];
        $doc_name      = $row['doc_name'];
        $nameof_file     = $row['nameof_file'];
        $pathof_file     = $row['pathof_file'];
        $role_name     = $row['vname'];
        $insertion_date = $row['insertion_date'];
        $file_name_user = $row['user_file_name'];
        $qc2_name       = $row['qcname'];
        $comments       = $row['comments'];
        $qc_updation_dates = date('d-m-Y',strtotime($row['qc_updation_date']));
        $request_id        =$row['request_id'];
        $file_status = $row['file_status']; 
        $count_of_chk =$row['count_of_chk'];
        $copy_error =$row['copy_error'];
        if($count_of_chk != 0)
           $checkname_count= $checkname.' '.$count_of_chk;
         else
          $checkname_count= $checkname;

        if($copy_error!= 0)
            $copy_error_val = $copy_error;
        else
            $copy_error_val= '';

        if($file_status==0){
            $status_name ="Pending";
            
       $pathof_missingfiles = "uploads/missing_files/";
              $myFile = $nameof_file;
            $filename = basename($myFile);
              $encode_names= $filename; 
              $link= '<a href="'.base_url().$pathof_missingfiles.$encode_names.' " target="_blank" style= "color: #377ff1;">'.$doc_name.'</a>'; 
           

        }
        else if($file_status==1){
            $status_name ="Checked";
             $link= '<a href="'.base_url().$pathof_file.$nameof_file.' " target="_blank" style= "color: #377ff1;">'.$doc_name.'</a>';

        }
        else if($file_status==2){
            $status_name ="Revert";
            $pathof_missingfiles = "uploads/missing_files/";
              $myFile = $nameof_file;
            $filename = basename($myFile);
              $encode_names= $filename; 
              $link= '<a href="'.base_url().$pathof_missingfiles.$encode_names.' " target="_blank" style= "color: #377ff1;">'.$doc_name.'</a>'; 

        }
        else{
            $status_name = "" ; 
        }

         if(!empty($insertion_date) )
               $date     = date('d-m-Y',strtotime($row['insertion_date']));
           else{
            $date =" ";
           }
            
         if(!empty($qc_updation_dates) && $qc_updation_dates != '00-00-0000' && $qc_updation_dates != '30-11--0001')
           $qc_updation_date = $qc_updation_dates;
     
           else
            $qc_updation_date = " ";
       
            if($this->session->userdata['role_id']== 5 || $this->session->userdata['role_id']== 9){
       
            $case_number = anchor(base_url().'Management/file_attachment/'.base64_encode($row['case_no']),$case_no,' target="_blank" '); 
            }
           else if($this->session->userdata['role_id']== 1 || $this->session->userdata['role_id']== 17){
            $case_number = anchor(base_url().'Management/file_review/'.base64_encode($row['case_no']),$case_no,' target="_blank" ');
           }
          else
          {
            $case_number = $case_no;
          }  
        
         
$response->rows [$i] ['cell'] = array ( $i+$count+1,$org_name,$candidatename,$case_number,$checkname_count,$link,$nameof_file,$status_name,$comments,$date,$qc_updation_date,$role_name,$qc2_name,$pathof_file,$file_name_user,$copy_error_val);
            } 
      }
    echo json_encode($response);
        }




function get_list_missingfiles_export() {
    
    $model = array('MissingFiles_model'=>'get_list_missingfiles_model');

        $case_no = ($_POST['exp_case_no']) ? $_POST['exp_case_no'] : '';
        $vname = ($_POST['exp_vname']) ? $_POST['exp_vname'] : '';
        $c_date = ($_POST['exp_c_date']) ? $_POST['exp_c_date'] : ''; 
        $t_date = ($_POST['exp_t_date']) ? $_POST['exp_t_date'] : ''; 
        $qc2_name = ($_POST['exp_qc2_name']) ? $_POST['exp_qc2_name'] : '';
        $status = ($_POST['exp_status']) ? $_POST['exp_status'] : '';
        
         $org_id = ($_POST['exp_org_id']) ? $_POST['exp_org_id'] : '';
        if(!empty($org_id)){
                     $condition[]=" o.id = ".$org_id;
               }

         if(trim($vname))
         $condition[]="(usr.first_name like '%".trim($vname)."%')";

        if(trim($qcname))
         $condition[]="(us.first_name like '%".trim($qcname)."%')";
          
        if(trim($name)){
        $condition[]="(cr.candidate_name like '%".trim($name)."%')";
        }

        if($status== 1){
                    $condition[]=" mf.file_status =0 ";
               }
           if($status== 2){
                    $condition[]=" mf.file_status = 1  ";
               }  
             if($status== 3){
                    $condition[]=" mf.file_status = 2 ";
               }     
         //18/01/2024
        $case_no = trim($case_no); 
        if($case_no)
        $condition[]="mf.case_no like '%".$case_no."%' ";
        
        if(!empty($c_date)){
               $condition[]="DATE_FORMAT(mf.insertion_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
            }
            if(!empty($t_date)){
               $condition[]="DATE_FORMAT(mf.insertion_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
            }

            if($term)
        {
                $search = explode(' ', $term);
                foreach($search as $t) {
                    $not        = '';
                    $operator    = 'OR';
                    if(substr($t,0,1) == '-')
                    {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t,1,strlen($t));
                    }
                    $like    = '';
                    $like    .= "( mf.insertion_date ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator."mf.file_status ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator."o.id ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." mf.case_no ".$not."LIKE '%".$t."%' )" ;
                    
                $condition[]=$like;
            }
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];  $result = $results[1];
           if ($result) {
           $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
         $k=1;
         $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Document Name");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Attached Documents");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "File Status");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Comments");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Attachment Date");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "Updation Date");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Verifier Name");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "QC2 Name");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "File Path");
            $objPHPExcel->getActiveSheet()->setCellValue('O1', "File Name");
            $objPHPExcel->getActiveSheet()->setCellValue('P1', "Copy Error");
            
            $ci=2;    

            foreach( $result as $i => $row ) {
        $candidatename = $row['candidate_name'];
        $case_no       = $row['case_no'];
        $org_name      = $row['org_name'];
        $checkname     = $row['name'];
        $doc_name      = $row['doc_name'];
        $nameof_file     = $row['nameof_file'];
        $pathof_file     = $row['pathof_file'];
        $role_name     = $row['vname'];
        $insertion_date = $row['insertion_date'];
        $file_name_user = $row['user_file_name'];
        $qc2_name       = $row['qcname'];
        $comments       = $row['comments'];
        $qc_updation_dates =$row['qc_updation_date'];
        $request_id        =$row['request_id'];
        $file_status = $row['file_status'];
        $count_of_chk = $row['count_of_chk'];
        $copy_error = $row['copy_error'];
        if($copy_error!= 0)
            $copy_error_val = $copy_error;
        else
            $copy_error_val= '';

         if($count_of_chk != 0)
           $checkname_count= $checkname.' '.$count_of_chk;
         else
          $checkname_count= $checkname;
        if($file_status==0){
            $status_name ="Pending";

        }
        else if($file_status==1){
            $status_name ="Checked";

        }
        else if($file_status==2){
            $status_name ="Revert";

        }
        else{
            $status_name = "" ; 
        }

         if(!empty($insertion_date))
               $date     = date('d-m-Y',strtotime($row['insertion_date']));
           else{
            $date =" ";
           }

         if(!empty($qc_updation_dates) && $qc_updation_dates != '00-00-0000' && $qc_updation_dates != '30-11--0001')
           $qc_updation_date = date('d-m-Y',strtotime($row['qc_updation_date']));
           else
            $qc_updation_date = " ";

           $objPHPExcel->getActiveSheet()->getStyle('A1:P1')->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                                  ->setCellValue('B' . $ci, $org_name)
                                  ->setCellValue('C' . $ci, $candidatename)
                                  ->setCellValue('D' . $ci, $case_no)
                                  ->setCellValue('E' . $ci, $checkname_count)
                                  ->setCellValue('F' . $ci, $doc_name)
                                  ->setCellValue('G' . $ci, $nameof_file)
                                  ->setCellValue('H' . $ci, $status_name)
                                  ->setCellValue('I' . $ci, $comments)
                                  ->setCellValue('J' . $ci, $date)
                                  ->setCellValue('K' . $ci, $qc_updation_date)
                                  ->setCellValue('L' . $ci, $role_name)
                                  ->setCellValue('M' . $ci, $qc2_name)
                                  ->setCellValue('N' . $ci, $pathof_file)
                                  ->setCellValue('O' . $ci, $file_name_user)
                                  ->setCellValue('P' . $ci, $copy_error_val);
                                                              
                                   

    $ci++;
    }
    $this->export_excel('A','O','Missing_File_List',$objPHPExcel);
      exit; 
        }
        redirect('MissingFiles/get_list_missingfiles');
         
         
         

        
}



} // End of controller