<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require_once ('Common.php');
require_once ('./PHPExcel-1.8/Classes/PHPExcel.php');
class Qualityverification extends Common {
    protected static $verification_model='Verification_model';
     function __construct() 
     {
        parent::__construct();
        $this->_check_userlogin ();
        $models = array(self::$verification_model => 'vm','Dadmin_model'=>'dm','Dataentry_model'=>'dem','Reports_model'=>'rm','Client_model'=>'cm','Verification_report_model'=>'vrm','Qualityverification_model'=>'qc');
        $this->lang->load('Dataentry');
        foreach ($models as $file => $object_name) {
            $this->load->model($file, $object_name);
        }
        $this->load->helper('text');
        $this->load->helper('list_search_filter_helper');
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min','commonjs','jquery-ui-1.8.16.custom.min','jquery.validate','multipleclone'));
    }
    /**********************************
    * function p_qualitycheck_bulk
    * bulk allotment of quality check1 verification
    ************************************/
    function p_qualitycheck_bulk()
     {
        if(empty($_POST['request_id'])){
            redirect('Verification/qc1_verification');
        }
        $postData=$_POST;
        if($postData)
        {
        $assignee_id = $this->input->post ( 'assignee_id' );
        $date_from = date('Y-m-d');
        $date_to = $this->input->post ( 'date_to' );
        foreach($postData['request_id'] as $key=>$request_id) {
           $exist_id = $this->vm->getqcreqid($request_id);
          
        if($assignee_id){
        $upd_data = array();
        $upd_data['assignee_id'] = $assignee_id;
        $upd_data['qc_assignee_status']= 1;
        $upd_data['deadline_from'] = date("Y-m-d", strtotime($date_from));
        $upd_data['deadline_to'] = date("Y-m-d", strtotime($date_to));;
        $upd_data['updated_on'] = date ( 'Y-m-d H:i:s' );
        $upd_data['updated_by'] = $this->user_id;
        $upd_data['request_id'] = $request_id;
        $qcrequest_id = $exist_id[0]['request_id'];
            if($qcrequest_id)
            {
                    $this->db->where('request_id',$qcrequest_id);
                    $this->db->update ( DB_PREFIX .'qc_request', $upd_data );
            }
            else
            {       
                    $upd_data['created_by'] = $this->user_id;
                    $upd_data['created_on'] = date ( 'Y-m-d' );
                    $this->db->insert ( DB_PREFIX .'qc_request', $upd_data );   
            }
            } 
        }
        redirect ( base_url('Verification/qc1_verification'), 'refresh' );
        }
    }
    /**********************************
    * function p_qualitychecktwo_bulk
    * bulk allotment of quality check2 verification
    ************************************/
    function p_qualitychecktwo_bulk()
        {
        if(empty($_POST['request_id'])){
            redirect('Verification/qc2_allocation');
        }

        $assign_by =    $_SESSION['name'];
        $postData=$_POST;
        if($postData)
        {
        $assignee_id = $this->input->post ( 'assignee_id' );
        $date_from = date('Y-m-d');
        $date_to = $this->input->post ( 'date_to' );
        foreach($postData['request_id'] as $key=>$request_id) {
           $exist_id = $this->vm->getqc2reqid($request_id);
        if($assignee_id){
        $upd_data = array();
        $upd_data['assignee_id'] = $assignee_id;
        $upd_data['assignee_by'] = $assign_by;
        $upd_data['qc2_assignee_status']= 1;
        $upd_data['deadline_from'] = date("Y-m-d", strtotime($date_from));
        $upd_data['deadline_to'] = date("Y-m-d", strtotime($date_to));;
        $upd_data['updated_on'] = date ( 'Y-m-d H:i:s' );
        $upd_data['updated_by'] = $this->user_id;
        $upd_data['request_id'] = $request_id;
        $qc2request_id = $exist_id[0]['request_id'];
            if($qc2request_id)
            {
                    $this->db->where('request_id',$qc2request_id);
                    $this->db->update ( DB_PREFIX .'qc2_request', $upd_data );
            }
            else
            {       
                    $upd_data['created_by'] = $this->user_id;
                    $upd_data['created_on'] = date ( 'Y-m-d H:i:s' );
                    $this->db->insert ( DB_PREFIX .'qc2_request', $upd_data );   
            }
            } 
        }
        redirect ( base_url('Verification/qc2_allocation'), 'refresh' );
        }
    }
    /*********************************************
    * export_qc2reports function
    * QC2 reports exports
    * export qc2reports data 
    ************************************************/ 
    function export_qc2reports(){ 
        $model = array(self::$verification_model=>'get_qc2list_verified');
        $office = ($_POST['exp_office']) ? $_POST['exp_office'] : '';
        $name = ($_POST['exp_name']) ? $_POST['exp_name'] : ''; 
        $org_id = ($_POST['exp_org_id']) ? $_POST['exp_org_id'] : '';
        $parent_office = ($_POST['exp_parent_office']) ? $_POST['exp_parent_office'] : '';
        $a_status = ($_POST['exp_a_status']) ? $_POST['exp_a_status'] : '';
        $sub_office = ($_POST['exp_sub_office']) ? $_POST['exp_sub_office'] : '';
        $case_no = ($_POST['exp_case_no']) ? $_POST['exp_case_no'] : ''; 
        $vname = ($_POST['exp_vname']) ? $_POST['exp_vname'] : ''; 
        $a_date=($_POST['exp_a_date']) ? $_POST['exp_a_date'] : '';
        $t_date=($_POST['exp_t_date']) ? $_POST['exp_t_date'] : '';
        $filter_date=($_POST['exp_filter_date']) ? $_POST['exp_filter_date'] : '';
        $check_name=($_POST['exp_check_name']) ? $_POST['exp_check_name'] : '';
        if($org_id){
            $condition[]=" o.id = ".$org_id;
        }
        if($office){
            $condition[]=" c.id = ".$office;
        }
        if($parent_office){
            $condition[]=" d.id = ".$parent_office;
        }
        if($sub_office){
            $condition[]=" cr.sub_office = ".$sub_office;
        }
        if($name){
            $condition[]=" cr.candidate_name like '%".$name."%'";
        }
        //18/01/2024
        $case_no = trim($case_no); 
        if($case_no){
            $condition[]=" cr.case_no like '%".$case_no."'";
        }
        if($vname){
            $condition[]="(concat_ws(' ',us.first_name,us.last_name) like '%".$vname."%') ";
        }
        if($a_status==1){
        $condition[]=" vl1.qc2_dis in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701) ";
        }
        if($a_status==2){
        $condition[]=" ((vl1.qc2_dis in (120,131,137,143,713,119,130,136,142)) or (vl1.qc2status in (519,110)) or (vl1.vm_discrepency in (1005)))";
        }
        if($a_status==3){
        $condition[]=" vl1.qc2_dis in (116,127,134,140,630,121,125,658,662,660,789) ";
        }
        if($a_date && $filter_date==1){
            $condition[]="DATE_FORMAT(vl1.v_date,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($a_date))."'";
        }
        if($t_date && $filter_date==1){
            $condition[]="DATE_FORMAT(vl1.v_date,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        if($a_date && $filter_date==2){
            $condition[]="DATE_FORMAT(vl1.qc2_date,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($a_date))."'";
        }
        if($t_date && $filter_date==2){
            $condition[]="DATE_FORMAT(vl1.qc2_date,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        if($a_date && $filter_date==3){
            $condition[]="DATE_FORMAT(cr.final_report_published_date,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($a_date))."'";
        }
        if($t_date && $filter_date==3){
            $condition[]="DATE_FORMAT(cr.final_report_published_date,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        if($a_date && $filter_date==4){
            $condition[]="DATE_FORMAT(vl1.supplement_published_date,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($a_date))."'";
        }
        if($t_date && $filter_date==4){
            $condition[]="DATE_FORMAT(vl1.supplement_published_date,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        if($check_name){
            $condition[]=" md1.name like '%".$check_name."%'";
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1]; 
        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Head Office");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Branch Office");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Sub Office");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Status");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "QC2 Name");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "Allotted Date");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "QC2 Completed/Submitted Date");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "Report Published Date");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "Supplementary Report Date");
            $ci=2;
            foreach ( $result as $i => $row ) {
                $verified_data=$this->vm->get_verified_data($row['request_id'],$row['level_id'],$row['check_id']);
                $verification_data=toArray(json_decode($verified_data['qc2fielddata']));

                $status4='';
                $status1=$this->vm->get_status($verification_data['status']);
                $status2=$this->vm->get_status($verification_data['pstatus']);
                $status3=$this->vm->get_status($verification_data['status1']);
                if($verification_data['ostatus']<>''){
                    $status4=$this->vm->get_status($verification_data['ostatus']);
                }
                if($verification_data['dstatus']<>''){
                    $status4=$this->vm->get_status($verification_data['dstatus']);
                }

                if(!empty($status4)){
                    $status41='-'.$status4['name'];
                }
                else{
                    $status41='';
                }

                if($row['chk']==0){
                    $chkval=$row['checkname'];
                }else{
                    $chkval=$row['checkname'].' '.$row['chk'];
                }

                if(!empty($status1['name'])){
                    $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
                }else{
                    $stat='';
                }
                $vm_date=isset($row['v_date'])?date('d-m-Y',strtotime($row['v_date'])):'';
                $qc2_date=isset($row['qc2_date'])?date('d-m-Y',strtotime($row['qc2_date'])):'';
                $rpt_publish_date=isset($row['final_report_published_date'])?date('d-m-Y',strtotime($row['final_report_published_date'])):'';
                $supplement_published_date=(isset($row['supplement_published_date']) && $row['supplement_published_date'] != "0000-00-00 00:00:00")?date('d-m-Y',strtotime($row['supplement_published_date'])):'';
                $objPHPExcel->getActiveSheet()->getStyle('A1:N1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                ->setCellValue('B' . $ci, $row['org_name'])
                ->setCellValue('C' . $ci, $row['parent_office'])
                ->setCellValue('D' . $ci, $row['office_name'])
                ->setCellValue('E' . $ci, $row['sub_office'])
                ->setCellValue('F' . $ci, $row['candidate_name'])
                ->setCellValue('G' . $ci, $row['case_no']) 
                ->setCellValue('H' . $ci, $chkval)
                ->setCellValue('I' . $ci, $stat)
                ->setCellValue('J' . $ci, $row['qc2name'])
                ->setCellValue('K' . $ci, $vm_date)
                ->setCellValue('L' . $ci, $qc2_date)
                ->setCellValue('M' . $ci, $rpt_publish_date)
                ->setCellValue('N' . $ci, $supplement_published_date);
                $ci++;
            }
        $this->export_excel('A','N','QC2_Reports_Verified_',$objPHPExcel);
        exit; 
        }   
        redirect('Verification/qc2_reports_verified'); 
                
    }
    /**********************************
    * function revert raised checks to VM from QC1 and QC2
    * QC reverted to VM checklist
    * Function name is qcrevert_raised_checks */
    function qcrevert_raised_checks(){
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC Revert Raised checks List', 'Verification/qcrevert_raised_checks');
        $data['breadcrumb']=$this->breadcrumbs->show(); 
        $this->amodel->pagerender($data, 'qcrevert_raised_checks');
    }
     /**********************************
    * function revert raised checks to VM from QC1 and QC2
    * QC reverted to VM checklist
    *
    * Function name is qcrevert_raised_checks */
    function get_qcrevertraisedchecks(){
        

        $model = array('Qualityverification_model'=>'get_qcrevertraisedchecks');
        $condition=list_search_filter($_REQUEST);
    
        $c_date = ($_REQUEST['cdate']) ? $_REQUEST['cdate'] : '';
        $t_date = ($_REQUEST['tdate']) ? $_REQUEST['tdate'] : ''; 
        $vm_name = ($_REQUEST['vm_name']) ? $_REQUEST['vm_name'] : ''; 
        $qc_name = ($_REQUEST['qc_name']) ? $_REQUEST['qc_name'] : ''; 
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : ''; 
        $revertreason_name = ($_REQUEST['revert_reason']) ? $_REQUEST['revert_reason'] : ''; 
       
        if($c_date){
            $condition[]="DATE_FORMAT(r.reverted_date,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if($t_date){
            $condition[]="DATE_FORMAT(r.reverted_date,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        if($vm_name){
            $condition[]=" (concat_ws(' ',vm.first_name,vm.last_name) like '%".$vm_name."%') ";
        }
        if($qc_name){
            $condition[]=" (concat_ws(' ',qc.first_name,qc.last_name) like '%".$qc_name."%') ";
        }
        if($check_name){
            $condition[]=" m.name like '%".$check_name."%'";
        }
         if($revertreason_name){
            $condition[]=" r.revertreason like '%".$revertreason_name."%'";
        }

        
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];
        $result = $results[1]; 
        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows;
        foreach ( $result as $i => $row ) {
             
                  $id = $row['revertreason'];

              if(!empty($id)){
                 $revert_name = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$id ))->row_array();
                  $revert_reason = $revert_name['name'];
              }
              else
              {
                $revert_reason = '';
              }

            $chk_num =($row['count_of_chk']>0)?$row['count_of_chk']:'1';
              $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['candidate_name'],$row['case_no'],$row['check_name'].' '.$chk_num,$row['comments'],$revert_reason,$row['vm_name'],$row['qc_name'],date('d-m-Y',strtotime($row['reverted_date'])));   
        }
        }
        echo json_encode($response);
    }
     /**********************************
    * function export of revert raised checks to VM from QC1 and QC2
    * Export of QC reverted to VM checklist
    *
    * Function name is export_qcrevert_raised_checks */
    function export_qcrevert_raised_checks(){
        $model = array('Qualityverification_model'=>'get_qcrevertraisedchecks');
        $condition=list_search_filter($_POST);
        $c_date = ($_POST['exp_cdate']) ? $_POST['exp_cdate'] : '';
        $t_date = ($_POST['exp_tdate']) ? $_POST['exp_tdate'] : ''; 
        $vm_name = ($_POST['exp_vm_name']) ? $_POST['exp_vm_name'] : ''; 
        $qc_name = ($_POST['exp_qc_name']) ? $_POST['exp_qc_name'] : ''; 
        $check_name = ($_POST['exp_check_name']) ? $_POST['exp_check_name'] : ''; 
        $revertreason_name = ($_REQUEST['revert_reason']) ? $_REQUEST['revert_reason'] : ''; 

        if($c_date){
            $condition[]="DATE_FORMAT(r.reverted_date,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if($t_date){
            $condition[]="DATE_FORMAT(r.reverted_date,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        if($vm_name){
            $condition[]=" (concat_ws(' ',vm.first_name,vm.last_name) like '%".$vm_name."%') ";
        }
        if($qc_name){
            $condition[]=" (concat_ws(' ',qc.first_name,qc.last_name) like '%".$qc_name."%') ";
        }
        if($check_name){
            $condition[]=" m.name like '%".$check_name."%'";
        }
        if($revertreason_name){
            $condition[]=" r.revertreason like '%".$revertreason_name."%'";
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];
        $result = $results[1]; 
        if ($result) {
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Reason for reverting");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Revert Reason");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "VM Name");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "QC Name");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "QC Revert Date");
            $ci=2;
            foreach ( $result as $i => $row ) {
            $chk_num =($row['count_of_chk']>0)?$row['count_of_chk']:'1';
             $revert_id =  $row['revertreason'];
            if(!empty($revert_id)){
                
                    $this->db->select('name');
                 $order = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$revert_id ))->row_array(); 
                 $revert_name =  $order['name'];

            }
            else
            {
               $revert_name = '';
            }
            $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['candidate_name'],$row['case_no'],$row['check_name'].' '.$chk_num,$row['comments'],$revert_name,$row['vm_name'],$row['qc_name'],date('d-m-Y',strtotime($row['reverted_date'])));   
            $objPHPExcel->getActiveSheet()->getStyle('A1:J1')->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                                  ->setCellValue('B' . $ci, $row['org_name'])
                                  ->setCellValue('C' . $ci, $row['candidate_name'])
                                  ->setCellValue('D' . $ci, $row['case_no'])
                                  ->setCellValue('E' . $ci, $row['check_name'].' '.$chk_num)
                                  ->setCellValue('F' . $ci, $row['comments'])
                                  ->setCellValue('G' . $ci, $revert_name) 
                                  ->setCellValue('H' . $ci, $row['vm_name']) 
                                  ->setCellValue('I' . $ci, $row['qc_name'])
                                  ->setCellValue('J' . $ci, date('d-m-Y',strtotime($row['reverted_date'])));
            $ci++;
            }
            $this->export_excel('A','I','QC_RevertRaised_CheckList_',$objPHPExcel);
            exit; 
         }   
        redirect('Qualityverification/qcrevert_raised_checks'); 
    }    

     function get_vmrevertraisedchecks(){
        $model = array('Qualityverification_model'=>'get_vmrevertraisedchecks');
        $condition=list_search_filter($_REQUEST);
        $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : ''; 
        $deo_name = ($_REQUEST['deo_name']) ? $_REQUEST['deo_name'] : ''; 
        $vm_name = ($_REQUEST['vm_name']) ? $_REQUEST['vm_name'] : ''; 
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : ''; 
        $revert_status  = ($_REQUEST['revert_status']) ? $_REQUEST['revert_status'] : ''; 

        
        if($c_date){
            $condition[]="DATE_FORMAT(r.reverted_date,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if($t_date){
            $condition[]="DATE_FORMAT(r.reverted_date,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        if($deo_name){
            $condition[]=" (concat_ws(' ',cvv.first_name,cvv.last_name) like '%".$deo_name."%') ";
        }
        if($vm_name){
            $condition[]=" (concat_ws(' ',vm.first_name,vm.last_name) like '%".$vm_name."%') ";
        }
        if($check_name){
            $condition[]=" m.name like '%".$check_name."%'";
        }
        if($revert_status){
               $condition[]="r.revertreason  = ".$revert_status;
            }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];
        $result = $results[1]; 
        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows;
        foreach ( $result as $i => $row ) {
            $chk_num =($row['count_of_chk']>0)?$row['count_of_chk']:'1';
              $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['candidate_name'],$row['case_no'],$row['check_name'].' '.$chk_num,$row['comments'],$row['revertstatus'],$row['deo_name'],$row['vm_name'],date('d-m-Y',strtotime($row['reverted_date'])));   
        }
        }
        echo json_encode($response);
    }
    function export_vmrevert_raised_checks(){

         $model = array('Qualityverification_model'=>'get_vmrevertraisedchecks');
        $condition=list_search_filter($_POST);
        $c_date = ($_POST['exp_c_date']) ? $_POST['exp_c_date'] : '';
        $t_date = ($_POST['exp_t_date']) ? $_POST['exp_t_date'] : ''; 
        $deo_name = ($_POST['exp_deo_name']) ? $_POST['exp_deo_name'] : ''; 
        $vm_name = ($_POST['exp_vm_name']) ? $_POST['exp_vm_name'] : ''; 
        $check_name = ($_POST['exp_check_name']) ? $_POST['exp_check_name'] : ''; 
        if($c_date){
            $condition[]="DATE_FORMAT(r.reverted_date,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }
        if($t_date){
            $condition[]="DATE_FORMAT(r.reverted_date,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }
        if($deo_name){
            $condition[]=" (concat_ws(' ',cvv.first_name,cvv.last_name) like '%".$deo_name."%') ";
        }
        if($vm_name){
            $condition[]=" (concat_ws(' ',vm.first_name,vm.last_name) like '%".$vm_name."%') ";
        }
        if($check_name){
            $condition[]=" m.name like '%".$check_name."%'";
        }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];
        $result = $results[1]; 
        if ($result) {
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Reason for reverting");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "DEO Name");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "VM Name");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "VM Revert Date");
            $ci=2;
            foreach ( $result as $i => $row ) {
            $chk_num =($row['count_of_chk']>0)?$row['count_of_chk']:'1';
            $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['candidate_name'],$row['case_no'],$row['check_name'].' '.$chk_num,$row['comments'],$row['deo_name'],$row['vm_name'],date('d-m-Y',strtotime($row['reverted_date'])));   
            $objPHPExcel->getActiveSheet()->getStyle('A1:I1')->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                                  ->setCellValue('B' . $ci, $row['org_name'])
                                  ->setCellValue('C' . $ci, $row['candidate_name'])
                                  ->setCellValue('D' . $ci, $row['case_no'])
                                  ->setCellValue('E' . $ci, $row['check_name'].' '.$chk_num)
                                  ->setCellValue('F' . $ci, $row['comments'])
                                  ->setCellValue('G' . $ci, $row['deo_name']) 
                                  ->setCellValue('H' . $ci, $row['vm_name'])
                                  ->setCellValue('I' . $ci, date('d-m-Y',strtotime($row['reverted_date'])));
            $ci++;
            }
            $this->export_excel('A','I','VM_RevertRaised_CheckList_',$objPHPExcel);
            exit; 
         }   
        redirect('Qualityverification/vmrevert_raised_checks'); 

    }

    function  revert_raised(){

               $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
                $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
                // add breadcrumbs
                $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
                $this->breadcrumbs->push('QC2 Revert Raised List', 'Verification/revert_raised');
               
                $data['breadcrumb']=$this->breadcrumbs->show();  
                $this->amodel->pagerender($data, 'revert_raised');

    }

    function get_revertraisedlist(){
          $model = array('Verification_model'=>'get_revert_list');
                $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
                $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
                $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
                $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
                $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
                $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
                $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';

                        if($office)
                        $condition[]=" c.id = ".$office;

                         if($parent_office)
                        $condition[]=" p.id = ".$parent_office;

                        if($sub_office)
                        $condition[]=" s.id = ".$sub_office;

                       if($org_id)
                        $condition[]=" o.id = ".$org_id;

                        if($name)
                        $condition[]=" cr.candidate_name like '%".$name."%'";

                    if($case_no)
                        $condition[]=" cr.case_no like '%".$case_no."'";

                        if($term)
        {
                //support multiple words
                $search = explode(' ', $term);

                foreach($search as $t) {
                    $not        = '';
                    $operator    = 'OR';
                    if(substr($t,0,1) == '-')
                    {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t,1,strlen($t));
                    }

                    $like    = '';
                    $like    .= "( b.first_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." c.office_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." cr.candidate_name ".$not."LIKE '%".$t."%'  " ;
                    $like    .= $operator." o.org_name ".$not."LIKE '%".$t."%'  " ;
                    $like    .= $operator." cr.case_no ".$not."LIKE '%".$t."%' ) " ;
$condition[]=$like;
               
            }
        }           
              
              $manual_cond=implode(' and ',$condition);
        
            $results = $this->_jqgrid_search($model,$manual_cond);
            $response = $results[0];  $result = $results[1]; 
              if ($result) {
              $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            
            foreach ( $result as $i => $row ) {

                $id = $row['revertreason'];

                  if(!empty($id)){
                     $revert_name = $this->db->get_where(DB_PREFIX .'master_masterdata',array('id'=>$id ))->row_array();
                      $revert_reason = $revert_name['name'];
                  }
                  else
                  {
                    $revert_reason = '';
                  }
               
                $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],$row['candidate_name'],$row['case_no'],$row['comments'],$revert_reason,$row['vmname'],$row['qcname'],date('d-m-Y',strtotime($row['reverted_date'])));
            
                        }
                      
        }
        echo json_encode($response);
    }

    function revert_closed(){

       $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC2 Revert Closed List', 'Verification/revert_closed');
       
        $data['breadcrumb']=$this->breadcrumbs->show();  
        $this->amodel->pagerender($data, 'revert_closed');
    }

    function get_revertclosedlist(){

         $model = array('Verification_model'=>'get_revert_closed');
                $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
                $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
                $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
                $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
                $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
                $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
                $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';

                        if($office)
                        $condition[]=" c.id = ".$office;

                         if($parent_office)
                        $condition[]=" p.id = ".$parent_office;

                        if($sub_office)
                        $condition[]=" s.id = ".$sub_office;

                       if($org_id)
                        $condition[]=" o.id = ".$org_id;

                        if($name)
                        $condition[]=" cr.candidate_name like '%".$name."%'";

                    if($case_no)
                        $condition[]=" cr.case_no like '%".$case_no."'";

                        if($term)
        {
                //support multiple words
                $search = explode(' ', $term);

                foreach($search as $t) {
                    $not        = '';
                    $operator    = 'OR';
                    if(substr($t,0,1) == '-')
                    {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t,1,strlen($t));
                    }

                    $like    = '';
                    $like    .= "( b.first_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." c.office_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." cr.candidate_name ".$not."LIKE '%".$t."%'  " ;
                    $like    .= $operator." o.org_name ".$not."LIKE '%".$t."%'  " ;
                    $like    .= $operator." cr.case_no ".$not."LIKE '%".$t."%' ) " ;
$condition[]=$like;
               
            }
        }           
              
              $manual_cond=implode(' and ',$condition);
        
            $results = $this->_jqgrid_search($model,$manual_cond);
            $response = $results[0];  $result = $results[1]; 
              if ($result) {
              $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            
            
            foreach ( $result as $i => $row ) {

                $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
               
                $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],$cname,$row['case_no'],$views);
            
                        }
                      
        }
        echo json_encode($response);
    }

    function reopen_closed(){

       $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC2 Reopen Closed List', 'Verification/reopen_closed');
       
        $data['breadcrumb']=$this->breadcrumbs->show();  
        $this->amodel->pagerender($data, 'reopen_closed');
    }

    function get_reopenclosedlist(){

         $model = array('Verification_model'=>'get_reopen_closed');
                $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
                $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
                $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
                $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
                $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
                $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
                $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';

                        if($office)
                        $condition[]=" c.id = ".$office;

                         if($parent_office)
                        $condition[]=" p.id = ".$parent_office;

                        if($sub_office)
                        $condition[]=" s.id = ".$sub_office;

                       if($org_id)
                        $condition[]=" o.id = ".$org_id;

                        if($name)
                        $condition[]=" cr.candidate_name like '%".$name."%'";

                    if($case_no)
                        $condition[]=" cr.case_no like '%".$case_no."'";

                        if($term)
        {
                //support multiple words
                $search = explode(' ', $term);

                foreach($search as $t) {
                    $not        = '';
                    $operator    = 'OR';
                    if(substr($t,0,1) == '-')
                    {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t,1,strlen($t));
                    }

                    $like    = '';
                    $like    .= "( b.first_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." c.office_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." cr.candidate_name ".$not."LIKE '%".$t."%'  " ;
                    $like    .= $operator." o.org_name ".$not."LIKE '%".$t."%'  " ;
                    $like    .= $operator." cr.case_no ".$not."LIKE '%".$t."%' ) " ;
$condition[]=$like;
               
            }
        }           
              
              $manual_cond=implode(' and ',$condition);
        
            $results = $this->_jqgrid_search($model,$manual_cond);
            $response = $results[0];  $result = $results[1]; 
              if ($result) {
              $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            
            
            foreach ( $result as $i => $row ) {

                $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
               
                $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],$cname,$row['case_no'],$views);
            
                        }
                      
        }
        echo json_encode($response);
    }

    function new_candidate(){

         $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC2 New List', 'Verification/new');
       
        $data['breadcrumb']=$this->breadcrumbs->show();  
        $this->amodel->pagerender($data, 'new_candidate');
    }

     function get_newcaselist(){

         $model = array('Verification_model'=>'get_newcaselist');
                $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
                $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
                $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
                $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
                $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
                $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
                $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';

                        if($office)
                        $condition[]=" c.id = ".$office;

                         if($parent_office)
                        $condition[]=" p.id = ".$parent_office;

                        if($sub_office)
                        $condition[]=" s.id = ".$sub_office;

                       if($org_id)
                        $condition[]=" o.id = ".$org_id;

                        if($name)
                        $condition[]=" cr.candidate_name like '%".$name."%'";

                    if($case_no)
                        $condition[]=" cr.case_no like '%".$case_no."'";

                        if($term)
        {
                //support multiple words
                $search = explode(' ', $term);

                foreach($search as $t) {
                    $not        = '';
                    $operator    = 'OR';
                    if(substr($t,0,1) == '-')
                    {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t,1,strlen($t));
                    }

                    $like    = '';
                    $like    .= "( b.first_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." c.office_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." cr.candidate_name ".$not."LIKE '%".$t."%'  " ;
                    $like    .= $operator." o.org_name ".$not."LIKE '%".$t."%'  " ;
                    $like    .= $operator." cr.case_no ".$not."LIKE '%".$t."%' ) " ;
$condition[]=$like;
               
            }
        }           
              
              $manual_cond=implode(' and ',$condition);
        
            $results = $this->_jqgrid_search($model,$manual_cond);
            $response = $results[0];  $result = $results[1]; 
              if ($result) {
              $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            
            
            foreach ( $result as $i => $row ) {

                $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
               
                $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],$cname,$row['case_no'],$views);
            
                        }
                      
        }
        echo json_encode($response);
    }

      function reopenchecklist(){

         $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC2 New List', 'Verification/new');
       
        $data['breadcrumb']=$this->breadcrumbs->show();  
        $this->amodel->pagerender($data, 'reopenchecklist');
    }

    function get_reopenchecklist()
     {
        
       
            $model = array('Verification_model'=>'get_reopencheck');
                $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
                $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
                $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
                $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
                $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
                $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
                $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';

                        if($office)
                        $condition[]=" c.id = ".$office;

                         if($parent_office)
                        $condition[]=" p.id = ".$parent_office;

                        if($sub_office)
                        $condition[]=" s.id = ".$sub_office;

                       if($org_id)
                        $condition[]=" o.id = ".$org_id;

                        if($name)
                        $condition[]=" cr.candidate_name like '%".$name."%'";

                    if($case_no)
                        $condition[]=" cr.case_no like '%".$case_no."'";

                        if($term)
        {
                //support multiple words
                $search = explode(' ', $term);

                foreach($search as $t) {
                    $not        = '';
                    $operator    = 'OR';
                    if(substr($t,0,1) == '-')
                    {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t,1,strlen($t));
                    }

                    $like    = '';
                    $like    .= "( b.first_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." c.office_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." cr.candidate_name ".$not."LIKE '%".$t."%'  " ;
                    $like    .= $operator." o.org_name ".$not."LIKE '%".$t."%'  " ;
                    $like    .= $operator." cr.case_no ".$not."LIKE '%".$t."%' ) " ;
$condition[]=$like;
               
            }
        }           
              
              $manual_cond=implode(' and ',$condition);
        
            $results = $this->_jqgrid_search($model,$manual_cond);
            $response = $results[0];  $result = $results[1]; 
              if ($result) {
              $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            
            
            foreach ( $result as $i => $row ) {

                $cname=anchor('/Verification/qc2_publish/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
               
                $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],$cname,$row['case_no'],$views);
            
                        }
                      
        }
        echo json_encode($response);

     }

     function newcaselist(){

        $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC2 New List', 'Verification/new');
       
        $data['breadcrumb']=$this->breadcrumbs->show();  
        $this->amodel->pagerender($data, 'newcaselist');
     }

      function get_newcasechecklist()
     {
        
       
            $model = array('Verification_model'=>'get_qc2newcaselist');
                $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
                $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
                $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
                $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
                $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
                $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
                $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';

                        if($office)
                        $condition[]=" c.id = ".$office;

                         if($parent_office)
                        $condition[]=" p.id = ".$parent_office;

                        if($sub_office)
                        $condition[]=" s.id = ".$sub_office;

                       if($org_id)
                        $condition[]=" o.id = ".$org_id;

                        if($name)
                        $condition[]=" cr.candidate_name like '%".$name."%'";

                    if($case_no)
                        $condition[]=" cr.case_no like '%".$case_no."'";

                        if($term)
        {
                //support multiple words
                $search = explode(' ', $term);

                foreach($search as $t) {
                    $not        = '';
                    $operator    = 'OR';
                    if(substr($t,0,1) == '-')
                    {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t,1,strlen($t));
                    }

                    $like    = '';
                    $like    .= "( b.first_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." c.office_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." cr.candidate_name ".$not."LIKE '%".$t."%'  " ;
                    $like    .= $operator." o.org_name ".$not."LIKE '%".$t."%'  " ;
                    $like    .= $operator." cr.case_no ".$not."LIKE '%".$t."%' ) " ;
$condition[]=$like;
               
            }
        }           
              
              $manual_cond=implode(' and ',$condition);
        
            $results = $this->_jqgrid_search($model,$manual_cond);
            $response = $results[0];  $result = $results[1]; 
              if ($result) {
              $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            
            
            foreach ( $result as $i => $row ) {

                $cname= anchor('/Verification/qc2_assignee/'.base64_encode($row['request_id']),$row['candidate_name']);
               
                $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],$cname,$row['case_no'],$views);
            
                        }
                      
        }
        echo json_encode($response);

     }


    /********** VM Pending Checks View *****
    ******* function vm_pending_check ******
    ************** By C Kp *****************/
    function vm_pending_check()       
    {
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Tracker List', 'Qualityverification/vm_pending_check');
        $data['breadcrumb']=$this->breadcrumbs->show();  
        $this->amodel->pagerender($data, 'vm_pending_check');
    }

    /*********** VM Pending List **************
    ********** function vm_pending_checks******
    ************* By C Kp *********************/

     function vm_pending_list() {

        $model = array('Qualityverification_model'=>'get_pendinuserlist');

        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : ''; 
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $case_no=($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $check_name=($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $verifier_name=($_REQUEST['verifier_name']) ? $_REQUEST['verifier_name'] : '';
        $qc_name = ($_REQUEST['qc_name']) ? $_REQUEST['qc_name'] : '';
                        
        $checkId = ($_REQUEST['checkId']) ? $_REQUEST['checkId'] : '';
        $year = ($_REQUEST['year']) ? $_REQUEST['year'] : '';
        $type = ($_REQUEST['type']) ? $_REQUEST['type'] : '';

        if($org_id)
        $condition[]=" o.id = ".$org_id;
        if($office)
        $condition[]=" br.id = ".$office;
        if($parent_office)
        $condition[]=" p.id = ".$parent_office;
        if($sub_office)
        $condition[]=" su.id = ".$sub_office;       
        if($name)
        $condition[]="d.candidate_name like '%".$name."%' ";
        if($check_name)
        $condition[]="c.name like '%".$check_name."%' ";
        if($case_no)
        $condition[]="d.case_no like '%".$case_no."' ";
        if($verifier_name)
        $condition[]="(concat_ws(' ',us.first_name,us.last_name) like '%".$verifier_name."%') ";
        if($qc_name)
        $condition[]="(concat_ws(' ',us2.first_name,us2.last_name) like '%".$qc_name."%') ";
        

        if($type == 'member'){
            
            if(is_numeric($checkId)){
                $condition[]=" us.id = ".$checkId;
            } 
            
        }
        if($type == 'check'){
            
            if(is_numeric($checkId)){
                $condition[]=" c.id = ".$checkId;
            } 
            
        }
        if($type == 'organization'){
            
            if(is_numeric($checkId)){
                $condition[]=" o.id = ".$checkId;
            } 
            
        }

        if($year=='backYear'){
            $condition[]=" YEAR(date(vr.deadline_from))<(YEAR(CURRENT_DATE())-1)";
        }
        if($year=='prevYear'){
            $condition[]=" YEAR(date(vr.deadline_from))=(YEAR(CURRENT_DATE())-1)";
        }
        if($year=='currYear'){
            $condition[]=" YEAR(date(vr.deadline_from))=YEAR(CURRENT_DATE())";
        }

        if($a_status==1)
        $condition[]="( a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0)";
        if($a_status==2)
        $condition[]=" (a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1)";
        if($a_status==3)
        $condition[]=" (a.qc_revert_request = 1 and a.vm_assigned_qc=1 and a.verify_status not in(107,684,992))";
        if($a_status==4)
        $condition[]=" a.ass_request = 1 ";
        if($a_status==5)
        $condition[]=" (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111)";
        if($a_status==6)
        $condition[]="((a.verify_status in (110,111,519)) and a.ass_request=0 and a.qc_revert_request = 0 )";
        if($a_status==7)
        $condition[]="(a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107)";
        if($a_status==8)
        $condition[]="s.vm_revert_option_status = 1 and a.vm_revert_to = 2";
        if($a_status==9)
        $condition[]=" a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1";
        if($a_status==10)
        $condition[]=" a.verify_status = 992 and a.qc_revert_request !=1";
        if($a_status==11)
        $condition[]=" a.vm_assigned_qc = 0 and a.ass_request = 0 and vl1.supplementary = 1 and a.qc_revert_request = 1 and a.reopen_revert_qc2 != 1";

        if($term)
        {
            //support multiple words
                $search = explode(' ', $term);
            foreach($search as $t){
                $not        = '';
                $operator    = 'OR';
                if(substr($t,0,1) == '-')
                {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t,1,strlen($t));
                   
                }
            }
        }

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1];
        if ($result) {
            $checkteam = $this->config->item('CHECKLIST',APPLICATIONCONFIG);
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            $k=1;

        foreach( $result as $i => $row ){

            $verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
            $verification_data=toArray(json_decode($verified_data['fielddata']));
         

            $status1=$this->vm->get_status($verification_data['status']);
            $status4='';
            $status2=$this->vm->get_status($verification_data['pstatus']);
            $status3=$this->vm->get_status($verification_data['status1']);
            if($verification_data['ostatus']<>'')
            $status4=$this->vm->get_status($verification_data['ostatus']);
            if($verification_data['dstatus']<>'')
            $status4=$this->vm->get_status($verification_data['dstatus']);
            if(!empty($status4))
            $status41='-'.$status4['name'];
            else
            $status41='';

        

        $rpt_status='';
        /************************ PF_Verification *************************/
    if($row['checkId'] ==652 ){
        if($verification_data['status']!=107 && $verification_data['status']!=684 && !empty($verification_data['status'])) {
            if($status3['name']=="Multiple Active Records" || $status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                    $rpt_status="<span style='color:red;'>RED</span>";
                            
            }
            // May 24th
            else if( $status3['name']=="No Records" || $status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                        
                        $rpt_status="<span style='color:orange;'>ORANGE</span>";
            }
            else 
            {
                            
                $rpt_status="<span style='color:green;'>GREEN</span>";
            }
        }       
                   
    }

/********************* PF_Verification *************************************/
     else{  // PF_verification
            if($verification_data['status']!=107 && $verification_data['status']!=684 && $verification_data['status']!=992 && !empty($verification_data['status'])) {
                if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                    $rpt_status="<span style='color:red;'>RED</span>";
                }
                // May 24th
                else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                    $rpt_status="<span style='color:orange;'>ORANGE</span>";
                }
                else 
                {
                    $rpt_status="<span style='color:green;'>GREEN</span>";
                }
            }
         } // PF_Verification   
                
                $checkadminstatus = $this->vm->get_currentstatus($row['candidate_req_id']);
                

                $candidatename=$row['candidatename'];

                if($row['vm_revert_option_status']==1 && $row['vm_revert_to']==2){
                    $verifyurl = 'Revert Raised to DEO';
                }             
                else if($row['qc_revert_request']==1 ){
                    if($row['vm_assigned_qc']==1 && $row['verify_status']<>107 && $row['verify_status']<>684 && $row['verify_status']<>992 ) {
                        $candidatename= anchor('/Verification/vm_verified/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),$row['candidatename'],'target="_blank"');
                        $verifyurl = 'Revert Rectified';
                    }
                    else if($row['vm_assigned_qc']==0 && $row['ass_request']==0 && $row['supplementary']==1 && $row['qc_revert_request']==1 && $row['reopen_revert_qc']==0 && $row['reopen_revert_qc2']==1 ){
                    $verifyurl = anchor('/Verification/revert_raisedsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']).'/'.base64_encode(1004),'Reopen Assigned','target="_blank"');
                    }

                    else if($row['vm_assigned_qc']==0 && $row['ass_request']==0 && $row['supplementary']==1 && $row['qc_revert_request']==1 && $row['reopen_revert_qc']==1 && $row['reopen_revert_qc2']==1 ){
                    $verifyurl = anchor('/Verification/revert_raisedsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']).'/'.base64_encode(1004),'Reopen Assigned','target="_blank"');
                    }
                    else{
                        
                        $verifyurl = anchor('/Verification/revert_raisedsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),'Revert Assigned','target="_blank"');
                    
                    }
                
                }
                
                elseif($row['verify_status']==111 && $row['vrequest']==0 && $row['ass_request']==0 )
                {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls='';
                                       
                    $candidatename= anchor('/Verification/vm_verified/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),$row['candidatename'],'target="_blank"');
                                        
                }
                else if($row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==3 && $row['vm_revert_to']==2)
                {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls='';
                                       
                    $candidatename= anchor('/Verification/vm_verified/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),$row['candidatename'],'target="_blank"');
                                        
                }

                else if($row['vm_revert_option_status']==3 && $row['vm_revert_to']==2){
                    $verifyurl = anchor('/Verification/level_detailsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),'Revert Closed','target="_blank"');
                }
                
                else if($row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==4 && $row['operator_submited_by']==12 || $row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==4 && $checkadminstatus['role_id']==13)
                {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls='';
                                       
                    $candidatename= anchor('/Verification/vm_verified/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),$row['candidatename'],'target="_blank"');
                                        
                }

                else if($row['vm_revert_option_status']==4 && $row['operator_submited_by']==12 || $row['vm_revert_option_status']==4 && $checkadminstatus['role_id']==13){
                    $verifyurl = anchor('/Verification/level_detailsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),'Revert Closed','target="_blank"');
                }
                else if($row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_to']==3 && $row['vm_revert_supervisor']==0)
                {
                                        $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                                        $requesttoass = '';
                                        $add_calls='';
                                       
                                       $candidatename= anchor('/Verification/vm_verified/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),$row['candidatename'],'target="_blank"');
                                        
                }
                else if($row['vm_revert_to']==3 && $row['vm_revert_supervisor']==0){
                    $verifyurl = anchor('/Verification/level_detailsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),'Revert Closed','target="_blank"');
                }

                else if($row['verify_status']<>'111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0 )
                {
                                        if($row['rstatus']==108)
                                        $vst='Inputs Required';
                                        else if($row['rstatus']==110)
                                        $vst='Stop Check';
                                        else if($row['rstatus']==109)
                                        $vst='Awaiting Authorisation';
                                        else if($row['rstatus']==107)
                                        $vst='Initiated';
                                        else if($row['rstatus']==519)
                                        $vst='Others';
                                        else if($row['rstatus']==684)
                                        $vst='Request Raised';
                                        else if($row['rstatus']==992)
                                        $vst='DD applied';
                
                                        if($row['rstatus']==110 || $row['rstatus']==519){
                                            $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                                        }else{
                                             $verifyurl = anchor('/Verification/level_detailsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),'<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">'.$vst.'</p>','target="_blank"');
                                        }
                                      
                                        $requesttoass = '';
                }

                
                

                else if($row['verify_status']=='111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0)
                {
                                        if($row['rstatus']==108)
                                        $vst='Inputs Required';
                                        else if($row['rstatus']==110)
                                        $vst='Stop Check';
                                        else if($row['rstatus']==109)
                                        $vst='Awaiting Authorisation';
                                        else if($row['rstatus']==107 && $row['verify_status']=='111')
                                        $vst='Verified';
                                        else if($row['rstatus']==107)
                                        $vst='Initiated';
                                        else 
                                        $vst='Verified';
                
                                        $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">'.$vst.'</p>';
                                        $requesttoass = '';
                }
                else if($row['ass_request']==1)
                {
                $verifyurl='Request Raised';
                $requesttoass='Sent to Associate';
                $add_calls='';
                }
                
                
                else
                {
                                        $save['request_id']=$row['candidate_req_id'];
                                        $save['check_id']=$row['checkId'];
                                        $save['level_id']=$row['level_id'];
                                        $this->db->select('count(*) as cnt');
                                        $this->db->where($save);
                                        $countnoti=$this->db->get(DB_PREFIX.'notification_emails')->row_array();

                                        if($countnoti['cnt'] >=1 )
                                        $vtext='Sent Mail to Resource';
                                        else
                                        $vtext='New';
                
                
                
                
                                        $verifyurl = anchor('/Verification/level_detailsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),$vtext,'target="_blank"');
                                        $vst=$row['status'];
                                        $requesttoass ='';
                                }
                                


            if($row['chk']==0){
                $chkval=$row['checkname'];
            }else{
                $chkval=$row['checkname'].$row['chk'];
            }

            if(!empty($status1['name'])){
                $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
            }else{
                $stat='';
            }
        
            
                $deadline_from=isset($row['deadline_from'])? date('d-m-Y',strtotime($row['deadline_from'])) : '';
                $deadline_to=isset($row['deadline_to'])? date('d-m-Y',strtotime($row['deadline_to'])) : '';
                
                $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['checkId']),$candidatename),$row['case_no'],$chkval,$verifyurl,$stat,$rpt_status,$row['vname'],$row['qc2name'],$deadline_from,$deadline_to);
            } 
        }
        
        echo json_encode($response);
        }


    /**********QC2 Pending List ************
     ********* function qc_pending_list **** 
     ***************************************/ 
    function qc_pending_list(){
        
        $model = array('Qualityverification_model'=>'get_qcpending_list'); 

        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : ''; 
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $case_no=($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $check_name=($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $verifier_name=($_REQUEST['verifier_name']) ? $_REQUEST['verifier_name'] : '';
        $qc_name = ($_REQUEST['qc_name']) ? $_REQUEST['qc_name'] : '';                          
        
        $checkId = ($_REQUEST['checkId']) ? $_REQUEST['checkId'] : '';
        $year = ($_REQUEST['year']) ? $_REQUEST['year'] : '';
        $type = ($_REQUEST['type']) ? $_REQUEST['type'] : '';
        $memtype = ($_REQUEST['memtype']) ? $_REQUEST['memtype'] : '';

        if($org_id)
        $condition[]=" o.id = ".$org_id;
        if($office)
        $condition[]=" cr.office = ".$office;
        if($parent_office)
        $condition[]=" cr.parent_office = ".$parent_office;
        if($sub_office)
        $condition[]=" cr.sub_office = ".$sub_office;

        if($qc_name){
            $condition[]=" (concat_ws(' ',us.first_name,us.last_name) like '%".$qc_name."%') ";
        }
        if($verifier_name){
            $condition[]=" (concat_ws(' ',vm.first_name,vm.last_name) like '%".$verifier_name."%') ";
        }

        if($type == 'member'){
            
            if(is_numeric($checkId) && $memtype==17){
                $condition[]=" ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish != 3 else ar.qc2_report_publish != 1 END ) and qc.assignee_id = ".$checkId;
            }
            
        }
        if($type == 'check'){
            
            if(is_numeric($checkId)){
                $condition[]=" md.id = ".$checkId;
            } 
            
        }
        if($type == 'organization'){
            
            if(is_numeric($checkId)){
                $condition[]=" o.id = ".$checkId;
            } 
            
        }

        if($year=='backYear'){
            $condition[]=" (date(vl1.v_date))<(CURRENT_DATE()-1)";
        }
        if($year=='prevYear'){
            $condition[]=" date(vl1.v_date)=(CURRENT_DATE()-1)";
        }
        if($year=='currYear'){
            $condition[]=" date(vl1.v_date)=CURRENT_DATE()";
        }

        if($a_status==1)
        $condition[]="(ar.qc2_verification = 0 and ar.qc1_verification=1 and ar.qc2_revert_request = 0 and vl1.qc2status!=107)";
        if($a_status==2)
        $condition[]=" ((ar.qc2_verification = 0 and ar.qc1_verification=1 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 2 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 2  and ar.qc1_assign_revert=1 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 0 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2)))";
        if($a_status==3)
        $condition[]=" ((ar.qc1_assign_revert = 1 and ar.qc2_verification = 0 and (vl1.supplementary = 0 || vl1.supplementary = 2))  || (ar.qc1_assign_revert=1 and ar.qc_2_verification=0 and (vl1.supplementary = 0 || vl1.supplementary = 2)))";
        if($a_status==4)
        $condition[]=" ((ar.qc2_verification = 1 and ar.qc2_report_publish != 1 and ar.qc2_revert_request = 0) )";
        if($a_status==5)
        $condition[]=" (ar.qc2_verification = 1 and ar.qc2_report_publish=1)";
        if($a_status==6)
        $condition[]=" (ar.qc2_verification = 0 and ar.qc1_verification=1 and vl1.qc2status=107)";
        if($a_status==7)
        $condition[]=" (ar.qc2_verification = 1 and ar.qc2_report_publish=2 and ar.qc1_assign_revert=0)";
        if($a_status==8)
        $condition[]=" (ar.qc1_verification=1 and ar.qc2_verification=0 and ar.qc_revert_request=1 and ar.qc2_revert_request=1 and ar.qc1_assign_revert=1 and ar.qc_2_verification=0 and ar.vm_assigned_qc=1 and vl1.supplementary=1 and  ar.reopen_revert_qc2=0 )";
        if($check_name)
        $condition[]=" md.name like '%".$check_name."%'";
        if($name)
        $condition[]=" cr.candidate_name like '%".$name."%'";
        if($case_no)
        $condition[]="cr.case_no like '%".$case_no."' ";
        
        $manual_cond=implode(' and ',$condition);
                     
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0]; 
        $result = $results[1]; 
           if ($result) {
           $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;

            foreach ( $result as $i => $row ) {
                $verified_data=$this->vm->get_verified_data($row['request_id'],$row['level_id'],$row['check_id']);
                $verification_data=toArray(json_decode($verified_data['qc2fielddata']));
                $status4='';
                $status1=$this->vm->get_status($verification_data['status']);
                $status2=$this->vm->get_status($verification_data['pstatus']);
                $status3=$this->vm->get_status($verification_data['status1']);
                if($verification_data['ostatus']<>'')
                $status4=$this->vm->get_status($verification_data['ostatus']);
                if($verification_data['dstatus']<>'')
                $status4=$this->vm->get_status($verification_data['dstatus']);
                if(!empty($status4))
                $status41='-'.$status4['name'];
                else
                $status41='';
                $rpt_status='';


/************************ PF_Verification *************************/
        if($row['check_id'] ==652 ){
            if($verification_data['status']!=107 && $verification_data['status']!=684 && !empty($verification_data['status'])) {
                    if($status3['name']=="Multiple Active Records" ||$status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                        $rpt_status="<span style='color:red;'>RED</span>";
                    }
                    // May 24th
                    else if( $status3['name']=="No Records" || $status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                        $rpt_status="<span style='color:orange;'>ORANGE</span>";
                    }
                    else 
                    {
                        $rpt_status="<span style='color:green;'>GREEN</span>";
                    }
                }       
               
        }

/********************* PF_Verification *************************************/
        else{ // Start else { PF Verification
            if($verification_data['status']!=107 && $verification_data['status']!=684 && !empty($verification_data['status'])) {
                if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                        $rpt_status="<span style='color:red;'>RED</span>";
                }
                // May 24th
                else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                    $rpt_status="<span style='color:orange;'>ORANGE</span>";
                }
                else 
                {
                    $rpt_status="<span style='color:green;'>GREEN</span>";
                }
            }

        } //END else } PF_Verification    
           
            $slug=url_title(convert_accented_characters($row['name']), 'underscore', TRUE);
                               
                $cname=$row['candidate_name'];
                if($row['status']==1)
                {
                if($row['qc2_verification']==0 && $row['qc1_verification']==1 && $row['qc2status']!=107)
                {                   
                    $statusname=$this->vm->get_status_name($row['request_id'],$row['check_id'],$row['level_id'],'qcstatus');
                    $status='New';
                
                if($row['qc_revert_request']==0){
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                }
                else if($row['qc_revert_request']==1 && $row['qc2_revert_request']==0){
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                }
                else if($row['qc1_assign_revert']==1  && $row['qc_2_verification']==0 && $row['vm_assigned_qc']==1 && $row['reopen_revert_qc2']==0){
                    $status='Revert Closed';
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                }
                else if($row['qc1_assign_revert']==1  && $row['supplementary']==1 && $row['qc_2_verification']==0 && $row['vm_assigned_qc']==1 && $row['reopen_revert_qc2'] == 1){
                    $status='Reopen Closed';
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                }
                else if($row['qc1_assign_revert']==1){
                    $status='Revert Closed';
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                }
                else if($row['qc2_revert_request']==1 && $row['reopen_revert_qc2']== 1 && $row['supplementary']==1 && $row['qc2_report_publish']==2)
                {
                    if($row['revertedBy'] == 17)
                    {
                        $status='Revert Raised';
                        $cname=$row['candidate_name'];
                    }
                    else
                    {
                        $status='Reopened'; 
                        $cname=$row['candidate_name'];
                    }
                
                }
                else if($row['qc2_revert_request']==1 && $row['reopen_revert_qc2']== 1 && $row['supplementary']==1 && $row['qc2_report_publish']==1)
                {
                    if($row['revertedBy'] == 17)
                    {
                        $status='Revert Raised';
                        $cname=$row['candidate_name'];
                    }
                    else
                    {
                        $status='Reopened'; 
                        $cname=$row['candidate_name'];
                    }
                
                }
                else if($row['qc2_revert_request']==1 && $row['reopen_revert_qc2']== 1 && $row['supplementary']==1)
                {
                    $status='Revert Raised';
                    $cname=$row['candidate_name'];
                }
                else if($row['qc2_revert_request']==1 && $row['supplementary']==1 && $row['vm_assigned_qc']==1)
                {
                    $status='Reopened';
                    $cname=$row['candidate_name'];
                }
                else if($row['qc2_revert_request']==1)
                {
                    $status='Revert Raised';
                    $cname=$row['candidate_name'];
                }
               
                }
                else
                {
                    $statusname=$this->vm->get_status_name($row['request_id'],$row['check_id'],$row['level_id'],'qc2status');
                    if($statusname['name']=='Clear'){
                        $status='QC2 Approved';
                    }else if($statusname['name']=='Verified'){
                        $status='QC2 Approved';
                    } else if($row['qc2_verification']==0 && $row['qc1_verification']==1 && $row['qc2status']==107){
                        $status='Initiated';
                    }else{       
                    $status='QC2 Approved';
                                    
                    }
                    if($row['qc_2_verification']==1 && $row['qc2_report_publish']==0)
                    {
                        if($row['qc1_assign_revert']==1){
                            $status='QC2 Approved';
                        }else if($row['qc2_revert_request']==1){
                            $status='Revert Raised';
                        }
                   
                    $cname=anchor('/Verification/qc2_publish/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                    }
                    //  elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==1 && $row['supplementary']==1 && $row['reopen_revert_qc2']== 1)
                    // {
                    // $status='Revert assigned';
                    // $cname=anchor('/Verification/qc2_verified/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                    // }
                    elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==1 && $row['supplementary']==1)
                    {
                    $status='Reopen assigned';
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                    }
                    elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==1)
                    {
                    $status='Report Published';
                    $cname=anchor('/Verification/qc2_verified/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                    }
                    elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==1 && $row['supplementary']==1){
                    $status='Reopen';
                    $cname=anchor('/Verification/qc2_verified/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                    }
                    elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==2 && $row['qc2_revert_request']==0)
                    {
                    $status='Report Reopen';
                    $cname=anchor('/Verification/qc2_publish/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                    }elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==2 && $row['qc2_revert_request']==1 && $row['qc1_assign_revert']==0)
                    {
                    $status='Revert Raised';
                    $cname=$row['candidate_name'];
                    
                    }
                    elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==1  && $row['qc1_assign_revert']==1 && $row['vm_assigned_qc']==0)
                    {
                    $status='Revert Raised'; 
                    }
                    elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==2  && $row['qc1_assign_revert']==1)
                    {
                    $status='Revert Raised';
                    $cname=anchor('/Verification/qc2_publish/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                    
                    }
                    //revert status for qc submit qc2 publish reverted
                    elseif($row['qc1_assign_revert']==1 && $row['qc_2_verification']==0){
                        $status='Revert Closed';
                        $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                    }
                    else if($row['qc2_verification']==0 && $row['qc1_verification']==1 && $row['qc2status']==107){
                        $status='Initiated';
                        $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                    }
                    else{
                    $cname=anchor('/Verification/qc2_verified/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                    }
                }
                }
                else
                $status='Verification Pending';
                if($row['supplementary']==1 && $row['vm_assigned_qc']==1 && $row['qc1_assign_revert']==1 && $row['qc_2_verification']==0)
                {
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                }
                if($row['supplementary']==1 && $row['vm_assigned_qc']==1 && $row['qc1_assign_revert']==0 && $row['qc_2_verification']==1)
                {
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                }
                elseif($row['supplementary']==1 && $row['vm_assigned_qc']==0 && $row['qc1_assign_revert']==0 && $row['qc_2_verification']==1)
                {
                    $cname=$row['candidate_name'];
                }
                elseif ($row['supplementary']==2 && $row['qc2_verification']==1 && $row['qc2_revert_request']==0 && $row['qc_2_verification']==1) {
                    $cname=anchor('/Verification/qc2_publish/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                }
                elseif ($row['supplementary']==2 && $row['qc2_verification']==0 && $row['qc2_revert_request']==1 && $row['qc_2_verification']==0) {
                    $cname=anchor('/Verification/qc2cal_reports/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                }
                

                if($row['chk']==0){
                    $chkval=$row['name'];
                }else{
                    $chkval=$row['name'].$row['chk'];
                }
                if(!empty($status1['name'])){
                    $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
                }else{
                    $stat='';
                }

                $deadline_from=isset($row['qc_date'])? date('d-m-Y',strtotime($row['qc_date'])) : '';
                if($row['qc_date']){
                    $deadline_to=isset($row['qc_date'])? date('d-m-Y',strtotime($row['qc_date']. ' +1 day')) : ''; 
                }
                else {
                    $deadline_from=isset($row['v_date'])? date('d-m-Y',strtotime($row['v_date'])) : '';
                    $deadline_to=isset($row['v_date'])? date('d-m-Y',strtotime($row['v_date']. ' +1 day')) : ''; 
                } 

                
                $response->rows [] ['cell'] = array ( $i+$count+1,  $row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'], $cname,$row['case_no'],$chkval,$status,$stat,$rpt_status,$row['vmname'],$row['qc2name'],$deadline_from,$deadline_to);
            }
           }
               
          echo json_encode($response);
        }

    function adm_pending_list() {

        $model = array('Qualityverification_model'=>'get_admpendinglist');

        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : ''; 
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $case_no=($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $check_name=($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $verifier_name=($_REQUEST['verifier_name']) ? $_REQUEST['verifier_name'] : '';
        $qc_name=($_REQUEST['qc_name']) ? $_REQUEST['qc_name'] : '';
                
        $checkId = ($_REQUEST['checkId']) ? $_REQUEST['checkId'] : '';
        $year = ($_REQUEST['year']) ? $_REQUEST['year'] : '';
        $type = ($_REQUEST['type']) ? $_REQUEST['type'] : '';
        $memtype = ($_REQUEST['memtype']) ? $_REQUEST['memtype'] : '';

        if($org_id)
        $condition[]=" o.id = ".$org_id;
        if($office)
        $condition[]=" br.id = ".$office;
        if($parent_office)
        $condition[]=" p.id = ".$parent_office;
        if($sub_office)
        $condition[]=" su.id = ".$sub_office;       
        if($name)
        $condition[]="d.candidate_name like '%".$name."%' ";
        if($check_name)
        $condition[]="c.name like '%".$check_name."%' ";
        if($case_no)
        $condition[]="d.case_no like '%".$case_no."' ";
        if($verifier_name)
        $condition[]="(concat_ws(' ',us.first_name,us.last_name) like '%".$verifier_name."%') ";
        if($qc_name)
        $condition[]="(concat_ws(' ',us2.first_name,us2.last_name) like '%".$qc_name."%') ";
        
        if($type == 'member'){
            
            if(is_numeric($checkId)){
                $condition[]=" us.id = ".$checkId;
            } 
            
        }
        if($type == 'check'){
            
            if(is_numeric($checkId)){
                $condition[]=" c.id = ".$checkId;
            } 
            
        }
        if($type == 'organization'){
            
            if(is_numeric($checkId)){
                $condition[]=" o.id = ".$checkId;
            } 
            
        }

        if($year=='backYear'){
            $condition[]=" YEAR(date(vr.deadline_from))<(YEAR(CURRENT_DATE())-1)";
        }
        if($year=='prevYear'){
            $condition[]=" YEAR(date(vr.deadline_from))=(YEAR(CURRENT_DATE())-1)";
        }
        if($year=='currYear'){
            $condition[]=" YEAR(date(vr.deadline_from))=YEAR(CURRENT_DATE())";
        }

        if($a_status==1)
        $condition[]="( a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0)";
        if($a_status==2)
        $condition[]=" (a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1)";
        if($a_status==3)
        $condition[]=" (a.qc_revert_request = 1 and a.vm_assigned_qc=1 and a.verify_status not in(107,684,992))";
        if($a_status==4)
        $condition[]=" a.ass_request = 1 ";
        if($a_status==5)
        $condition[]=" (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111)";
        if($a_status==6)
        $condition[]="((a.verify_status in (110,111,519)) and a.ass_request=0 and a.qc_revert_request = 0 )";
        if($a_status==7)
        $condition[]="(a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107)";
        if($a_status==8)
        $condition[]="s.vm_revert_option_status = 1 and a.vm_revert_to = 2";
        if($a_status==9)
        $condition[]=" a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1";
        if($a_status==10)
        $condition[]=" a.verify_status = 992 and a.qc_revert_request !=1";
        if($a_status==11)
        $condition[]=" a.vm_assigned_qc = 0 and a.ass_request = 0 and vl1.supplementary = 1 and a.qc_revert_request = 1 and a.reopen_revert_qc2 != 1";

        if($term)
        {
            //support multiple words
                $search = explode(' ', $term);
            foreach($search as $t){
                $not        = '';
                $operator    = 'OR';
                if(substr($t,0,1) == '-')
                {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t,1,strlen($t));
                   
                }
            }
        }

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1];
        if ($result) {
            $checkteam = $this->config->item('CHECKLIST',APPLICATIONCONFIG);
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            $k=1;

        foreach( $result as $i => $row ){

            $verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
            $verification_data=toArray(json_decode($verified_data['fielddata']));
         

            $status1=$this->vm->get_status($verification_data['status']);
            $status4='';
            $status2=$this->vm->get_status($verification_data['pstatus']);
            $status3=$this->vm->get_status($verification_data['status1']);
            if($verification_data['ostatus']<>'')
            $status4=$this->vm->get_status($verification_data['ostatus']);
            if($verification_data['dstatus']<>'')
            $status4=$this->vm->get_status($verification_data['dstatus']);
            if(!empty($status4))
            $status41='-'.$status4['name'];
            else
            $status41='';

        

        $rpt_status='';
        /************************ PF_Verification *************************/
    if($row['checkId'] ==652 ){
        if($verification_data['status']!=107 && $verification_data['status']!=684 && !empty($verification_data['status'])) {
            if($status3['name']=="Multiple Active Records" || $status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                    $rpt_status="<span style='color:red;'>RED</span>";
                            
            }
            // May 24th
            else if( $status3['name']=="No Records" || $status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                        
                        $rpt_status="<span style='color:orange;'>ORANGE</span>";
            }
            else 
            {
                            
                $rpt_status="<span style='color:green;'>GREEN</span>";
            }
        }       
                   
    }

/********************* PF_Verification *************************************/
     else{  // PF_verification
            if($verification_data['status']!=107 && $verification_data['status']!=684 && $verification_data['status']!=992 && !empty($verification_data['status'])) {
                if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                    $rpt_status="<span style='color:red;'>RED</span>";
                }
                // May 24th
                else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                    $rpt_status="<span style='color:orange;'>ORANGE</span>";
                }
                else 
                {
                    $rpt_status="<span style='color:green;'>GREEN</span>";
                }
            }
         } // PF_Verification   
                
                $checkadminstatus = $this->vm->get_currentstatus($row['candidate_req_id']);
                

                $candidatename=$row['candidatename'];

                if($row['vm_revert_option_status']==1 && $row['vm_revert_to']==2){
                    $verifyurl = 'Revert Raised to DEO';
                }             
                else if($row['qc_revert_request']==1 ){
                    if($row['vm_assigned_qc']==1 && $row['verify_status']<>107 && $row['verify_status']<>684 && $row['verify_status']<>992 ) {
                        $candidatename= anchor('/Verification/vm_verified/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),$row['candidatename'],'target="_blank"');
                        $verifyurl = 'Revert Rectified';
                    }
                    else if($row['vm_assigned_qc']==0 && $row['ass_request']==0 && $row['supplementary']==1 && $row['qc_revert_request']==1 && $row['reopen_revert_qc']==0 && $row['reopen_revert_qc2']==1 ){
                    $verifyurl = anchor('/Verification/revert_raisedsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']).'/'.base64_encode(1004),'Reopen Assigned','target="_blank"');
                    }

                    else if($row['vm_assigned_qc']==0 && $row['ass_request']==0 && $row['supplementary']==1 && $row['qc_revert_request']==1 && $row['reopen_revert_qc']==1 && $row['reopen_revert_qc2']==1 ){
                    $verifyurl = anchor('/Verification/revert_raisedsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']).'/'.base64_encode(1004),'Reopen Assigned','target="_blank"');
                    }
                    else{
                        
                        $verifyurl = anchor('/Verification/revert_raisedsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),'Revert Assigned','target="_blank"');
                    
                    }
                
                }
                
                elseif($row['verify_status']==111 && $row['vrequest']==0 && $row['ass_request']==0 )
                {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls='';
                                       
                    $candidatename= anchor('/Verification/vm_verified/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),$row['candidatename'],'target="_blank"');
                                        
                }
                else if($row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==3 && $row['vm_revert_to']==2)
                {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls='';
                                       
                    $candidatename= anchor('/Verification/vm_verified/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),$row['candidatename'],'target="_blank"');
                                        
                }

                else if($row['vm_revert_option_status']==3 && $row['vm_revert_to']==2){
                    $verifyurl = anchor('/Verification/level_detailsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),'Revert Closed','target="_blank"');
                }
                
                else if($row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==4 && $row['operator_submited_by']==12 || $row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==4 && $checkadminstatus['role_id']==13)
                {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls='';
                                       
                    $candidatename= anchor('/Verification/vm_verified/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),$row['candidatename'],'target="_blank"');
                                        
                }

                else if($row['vm_revert_option_status']==4 && $row['operator_submited_by']==12 || $row['vm_revert_option_status']==4 && $checkadminstatus['role_id']==13){
                    $verifyurl = anchor('/Verification/level_detailsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),'Revert Closed','target="_blank"');
                }
                else if($row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_to']==3 && $row['vm_revert_supervisor']==0)
                {
                                        $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                                        $requesttoass = '';
                                        $add_calls='';
                                       
                                       $candidatename= anchor('/Verification/vm_verified/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),$row['candidatename'],'target="_blank"');
                                        
                }
                else if($row['vm_revert_to']==3 && $row['vm_revert_supervisor']==0){
                    $verifyurl = anchor('/Verification/level_detailsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),'Revert Closed','target="_blank"');
                }

                else if($row['verify_status']<>'111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0 )
                {
                                        if($row['rstatus']==108)
                                        $vst='Inputs Required';
                                        else if($row['rstatus']==110)
                                        $vst='Stop Check';
                                        else if($row['rstatus']==109)
                                        $vst='Awaiting Authorisation';
                                        else if($row['rstatus']==107)
                                        $vst='Initiated';
                                        else if($row['rstatus']==519)
                                        $vst='Others';
                                        else if($row['rstatus']==684)
                                        $vst='Request Raised';
                                        else if($row['rstatus']==992)
                                        $vst='DD applied';
                
                                        if($row['rstatus']==110 || $row['rstatus']==519){
                                            $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                                        }else{
                                             $verifyurl = anchor('/Verification/level_detailsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),'<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">'.$vst.'</p>','target="_blank"');
                                        }
                                      
                                        $requesttoass = '';
                }

                
                

                else if($row['verify_status']=='111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0)
                {
                                        if($row['rstatus']==108)
                                        $vst='Inputs Required';
                                        else if($row['rstatus']==110)
                                        $vst='Stop Check';
                                        else if($row['rstatus']==109)
                                        $vst='Awaiting Authorisation';
                                        else if($row['rstatus']==107 && $row['verify_status']=='111')
                                        $vst='Verified';
                                        else if($row['rstatus']==107)
                                        $vst='Initiated';
                                        else 
                                        $vst='Verified';
                
                                        $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">'.$vst.'</p>';
                                        $requesttoass = '';
                }
                else if($row['ass_request']==1)
                {
                $verifyurl='Request Raised';
                $requesttoass='Sent to Associate';
                $add_calls='';
                }
                
                
                else
                {
                                        $save['request_id']=$row['candidate_req_id'];
                                        $save['check_id']=$row['checkId'];
                                        $save['level_id']=$row['level_id'];
                                        $this->db->select('count(*) as cnt');
                                        $this->db->where($save);
                                        $countnoti=$this->db->get(DB_PREFIX.'notification_emails')->row_array();

                                        if($countnoti['cnt'] >=1 )
                                        $vtext='Sent Mail to Resource';
                                        else
                                        $vtext='New';
                
                
                
                
                                        $verifyurl = anchor('/Verification/level_detailsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),$vtext,'target="_blank"');
                                        $vst=$row['status'];
                                        $requesttoass ='';
                                }
                                


            if($row['chk']==0){
                $chkval=$row['checkname'];
            }else{
                $chkval=$row['checkname'].$row['chk'];
            }

            if(!empty($status1['name'])){
                $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
            }else{
                $stat='';
            }
        
            
                $deadline_from=isset($row['deadline_from'])? date('d-m-Y',strtotime($row['deadline_from'])) : '';
                $deadline_to=isset($row['deadline_to'])? date('d-m-Y',strtotime($row['deadline_to'])) : '';
                
                $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['checkId']),$candidatename),$row['case_no'],$chkval,$verifyurl,$stat,$rpt_status,$row['vname'],$row['qc2name'],$deadline_from,$deadline_to);
            } 
        }
        
        echo json_encode($response);
        }

//********************TRACKER EXPORT *****************************************************//
//Edited By Amritha P P


function tracker_adminpendinglist_export(){
      
         $model = array('Qualityverification_model'=>'tracker_adminpendinglist_export');
        $office = ($_POST['exp_office']) ? $_POST['exp_office'] : '';
        $org_id = ($_POST['exp_org_id']) ? $_POST['exp_org_id'] : '';
        $parent_office = ($_POST['exp_parent_office']) ? $_POST['exp_parent_office'] : '';
        $sub_office = ($_POST['exp_sub_office']) ? $_POST['exp_sub_office'] : ''; 
        $name = ($_POST['exp_name']) ? $_POST['exp_name'] : ''; 
        $a_status = ($_POST['exp_a_status']) ? $_POST['exp_a_status'] : '';
        $case_no=($_POST['exp_case_no']) ? $_POST['exp_case_no'] : '';
        $check_name=($_POST['exp_check_name']) ? $_POST['exp_check_name'] : '';
        $verifier_name=($_POST['exp_vm_name']) ? $_POST['exp_vm_name'] : '';
        $qc_name=($_POST['exp_qc_name']) ? $_POST['exp_qc_name'] : '';
                
        $checkId = ($_POST['exp_checkId']) ? $_POST['exp_checkId'] : '';
        $year = ($_POST['exp_year']) ? $_POST['exp_year'] : '';
        $type = ($_POST['exp_type']) ? $_POST['exp_type'] : '';
        $memtype = ($_POST['exp_memtype']) ? $_POST['exp_memtype'] : ''; 

        if($org_id)
        $condition[]=" o.id = ".$org_id;
        if($office)
        $condition[]=" br.id = ".$office;
        if($parent_office)
        $condition[]=" p.id = ".$parent_office;
        if($sub_office)
        $condition[]=" su.id = ".$sub_office;       
        if($name)
        $condition[]="d.candidate_name like '%".$name."%' ";
        if($check_name)
        $condition[]="c.name like '%".$check_name."%' ";
        if($case_no)
        $condition[]="d.case_no like '%".$case_no."' ";
        if($verifier_name)
        $condition[]="(concat_ws(' ',us.first_name,us.last_name) like '%".$verifier_name."%') ";
        if($qc_name)
        $condition[]="(concat_ws(' ',us2.first_name,us2.last_name) like '%".$qc_name."%') ";
        
        if($type == 'member'){
            
            if(is_numeric($checkId)){
                $condition[]=" us.id = ".$checkId;
            } 
            
        }
        if($type == 'check'){
            
            if(is_numeric($checkId)){
                $condition[]=" c.id = ".$checkId;
            } 
            
        }
        if($type == 'organization'){
            
            if(is_numeric($checkId)){
                $condition[]=" o.id = ".$checkId;
            } 
            
        }
    
        if($year=='backYear'){
            $condition[]=" YEAR(date(vr.deadline_from))<(YEAR(CURRENT_DATE())-1)";
        }
        if($year=='prevYear'){
            $condition[]=" YEAR(date(vr.deadline_from))=(YEAR(CURRENT_DATE())-1)";
        }
        if($year=='currYear'){
            $condition[]=" YEAR(date(vr.deadline_from))=YEAR(CURRENT_DATE())";
        }

        if($a_status==1)
        $condition[]="( a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0)";
        if($a_status==2)
        $condition[]=" (a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1)";
        if($a_status==3)
        $condition[]=" (a.qc_revert_request = 1 and a.vm_assigned_qc=1 and a.verify_status not in(107,684,992))";
        if($a_status==4)
        $condition[]=" a.ass_request = 1 ";
        if($a_status==5)
        $condition[]=" (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111)";
        if($a_status==6)
        $condition[]="((a.verify_status in (110,111,519)) and a.ass_request=0 and a.qc_revert_request = 0 )";
        if($a_status==7)
        $condition[]="(a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107)";
        if($a_status==8)
        $condition[]="s.vm_revert_option_status = 1 and a.vm_revert_to = 2";
        if($a_status==9)
        $condition[]=" a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1";
        if($a_status==10)
        $condition[]=" a.verify_status = 992 and a.qc_revert_request !=1";
        if($a_status==11)
        $condition[]=" a.vm_assigned_qc = 0 and a.ass_request = 0 and vl1.supplementary = 1 and a.qc_revert_request = 1 and a.reopen_revert_qc2 != 1";

        if($term)
        {
            //support multiple words
                $search = explode(' ', $term);
            foreach($search as $t){
                $not        = '';
                $operator    = 'OR';
                if(substr($t,0,1) == '-')
                {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t,1,strlen($t));
                   
                }
            }
        }

         $manual_cond=implode(' and ',$condition);

            $results = $this->_jqgrid_search($model,$manual_cond);
            $response = $results[0]; 
            $result = $results[1]; 
            if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;

            $objPHPExcel = new PHPExcel();
            
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Head Office");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Branch Office");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Sub Office");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Name");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Status");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Verified Status");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "Check Status");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Verifier Name");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "QC Name");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "Deadline From");
            $objPHPExcel->getActiveSheet()->setCellValue('O1', "Deadline To");
            
          
            $ci=2;

        foreach( $result as $i => $row ){

            
            $verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
            $verification_data=toArray(json_decode($verified_data['fielddata']));
         

            $status1=$this->vm->get_status($verification_data['status']);
            $status4='';
            $status2=$this->vm->get_status($verification_data['pstatus']);
            $status3=$this->vm->get_status($verification_data['status1']);
            if($verification_data['ostatus']<>'')
            $status4=$this->vm->get_status($verification_data['ostatus']);
            if($verification_data['dstatus']<>'')
            $status4=$this->vm->get_status($verification_data['dstatus']);
            if(!empty($status4))
            $status41='-'.$status4['name'];
            else
            $status41='';

        

        $rpt_status='';
        /************************ PF_Verification *************************/
    if($row['checkId'] ==652 ){
        if($verification_data['status']!=107 && $verification_data['status']!=684 && !empty($verification_data['status'])) {
            if($status3['name']=="Multiple Active Records" || $status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                    $rpt_status="RED";
                            
            }
            // May 24th
            else if( $status3['name']=="No Records" || $status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                        
                        $rpt_status="ORANGE";
            }
            else 
            {
                            
                $rpt_status="GREEN";
            }
        }       
                   
    }

/********************* PF_Verification *************************************/
     else{  // PF_verification
            if($verification_data['status']!=107 && $verification_data['status']!=684 && $verification_data['status']!=992 && !empty($verification_data['status'])) {
                if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                    $rpt_status="RED";
                }
                // May 24th
                else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                    $rpt_status="ORANGE";
                }
                else 
                {
                    $rpt_status="GREEN";
                }
            }
         } // PF_Verification   
                
                $checkadminstatus = $this->vm->get_currentstatus($row['candidate_req_id']);
                

                $candidatename=$row['candidatename'];

                if($row['vm_revert_option_status']==1 && $row['vm_revert_to']==2){
                    $verifyurl = 'Revert Raised to DEO';
                }             
                else if($row['qc_revert_request']==1 ){
                    if($row['vm_assigned_qc']==1 && $row['verify_status']<>107 && $row['verify_status']<>684 && $row['verify_status']<>992 ) {
                        $candidatename= $row['candidatename'];
                        $verifyurl = 'Revert Rectified';
                    }
                    else if($row['vm_assigned_qc']==0 && $row['ass_request']==0 && $row['supplementary']==1 && $row['qc_revert_request']==1 && $row['reopen_revert_qc']==0 && $row['reopen_revert_qc2']==1 ){
                    $verifyurl = "Reopen Assigned";
                    }

                    else if($row['vm_assigned_qc']==0 && $row['ass_request']==0 && $row['supplementary']==1 && $row['qc_revert_request']==1 && $row['reopen_revert_qc']==1 && $row['reopen_revert_qc2']==1 ){
                    $verifyurl = "Reopen Assigned";
                    }
                    else{
                        
                        $verifyurl = "Revert Assigned";
                    
                    }
                
                }
                
                elseif($row['verify_status']==111 && $row['vrequest']==0 && $row['ass_request']==0 )
                {
                    $verifyurl = "Verified";
                    $requesttoass = '';
                    $add_calls='';
                                       
                    $candidatename= $row['candidatename'];
                                        
                }
                else if($row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==3 && $row['vm_revert_to']==2)
                {
                    $verifyurl = "Verified";
                    $requesttoass = '';
                    $add_calls='';
                                       
                    $candidatename= $row['candidatename'];
                                        
                }

                else if($row['vm_revert_option_status']==3 && $row['vm_revert_to']==2){
                    $verifyurl = "Revert Closed";
                }
                
                else if($row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==4 && $row['operator_submited_by']==12 || $row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==4 && $checkadminstatus['role_id']==13)
                {
                    $verifyurl = "Verified";
                    $requesttoass = '';
                    $add_calls='';
                                       
                    $candidatename= $row['candidatename'];
                                        
                }

                else if($row['vm_revert_option_status']==4 && $row['operator_submited_by']==12 || $row['vm_revert_option_status']==4 && $checkadminstatus['role_id']==13){
                    $verifyurl = "Revert Closed";
                }
                else if($row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_to']==3 && $row['vm_revert_supervisor']==0)
                {
                                        $verifyurl =" Verified";
                                        $requesttoass = '';
                                        $add_calls='';
                                       
                                       $candidatename= $row['candidatename'];
                                        
                }
                else if($row['vm_revert_to']==3 && $row['vm_revert_supervisor']==0){
                    $verifyurl = "Revert Closed";
                }

                else if($row['verify_status']<>'111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0 )
                {
                                        if($row['rstatus']==108)
                                        $vst='Inputs Required';
                                        else if($row['rstatus']==110)
                                        $vst='Stop Check';
                                        else if($row['rstatus']==109)
                                        $vst='Awaiting Authorisation';
                                        else if($row['rstatus']==107)
                                        $vst='Initiated';
                                        else if($row['rstatus']==519)
                                        $vst='Others';
                                        else if($row['rstatus']==684)
                                        $vst='Request Raised';
                                        else if($row['rstatus']==992)
                                        $vst='DD applied';
                
                                        if($row['rstatus']==110 || $row['rstatus']==519){
                                            $verifyurl =" Verified";
                                        }else{
                                             $verifyurl = $vst;
                                        }
                                      
                                        $requesttoass = '';
                }

                
                

                else if($row['verify_status']=='111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0)
                {
                                        if($row['rstatus']==108)
                                        $vst='Inputs Required';
                                        else if($row['rstatus']==110)
                                        $vst='Stop Check';
                                        else if($row['rstatus']==109)
                                        $vst='Awaiting Authorisation';
                                        else if($row['rstatus']==107 && $row['verify_status']=='111')
                                        $vst='Verified';
                                        else if($row['rstatus']==107)
                                        $vst='Initiated';
                                        else 
                                        $vst='Verified';
                
                                        $verifyurl = $vst;
                                        $requesttoass = '';
                }
                else if($row['ass_request']==1)
                {
                $verifyurl='Request Raised';
                $requesttoass='Sent to Associate';
                $add_calls='';
                }
                
                
                else
                {
                                        $save['request_id']=$row['candidate_req_id'];
                                        $save['check_id']=$row['checkId'];
                                        $save['level_id']=$row['level_id'];
                                        $this->db->select('count(*) as cnt');
                                        $this->db->where($save);
                                        $countnoti=$this->db->get(DB_PREFIX.'notification_emails')->row_array();

                                        if($countnoti['cnt'] >=1 )
                                        $vtext='Sent Mail to Resource';
                                        else
                                        $vtext='New';
                
                
                
                
                                        $verifyurl = $vtext;
                                        $vst=$row['status'];
                                        $requesttoass ='';
                                }
                                


            if($row['chk']==0){
                $chkval=$row['checkname'];
            }else{
                $chkval=$row['checkname'].$row['chk'];
            }

            if(!empty($status1['name'])){
                $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
            }else{
                $stat='';
            }
        
            
                $deadline_from=isset($row['deadline_from'])? date('d-m-Y',strtotime($row['deadline_from'])) : '';
                $deadline_to=isset($row['deadline_to'])? date('d-m-Y',strtotime($row['deadline_to'])) : '';
                
               
     
         $objPHPExcel->getActiveSheet()->getStyle('A1:O1')->getFont()->setBold(true);
    $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                                  ->setCellValue('B' . $ci, $row['org_name'])
                                  ->setCellValue('C' . $ci, $row['parent_office'])
                                  ->setCellValue('D' . $ci, $row['office_name'])
                                  ->setCellValue('E' . $ci, $row['sub_office'])
                                  ->setCellValue('F' . $ci, $candidatename)
                                  ->setCellValue('G' . $ci, $row['case_no'])
                                  ->setCellValue('H' . $ci, $chkval)
                                  ->setCellValue('I' . $ci, $verifyurl)
                                  ->setCellValue('J' . $ci, $stat)
                                  ->setCellValue('K' . $ci, $rpt_status)
                                  ->setCellValue('L' . $ci, $row['vname'])
                                  ->setCellValue('M' . $ci, $row['qc2name'])
                                  ->setCellValue('N' . $ci, $deadline_from)
                                  
                                  ->setCellValue('O' . $ci, $deadline_to);
                                  
    $ci++;
            }
     $this->export_excel('A','O','Admin_Pending_List_',$objPHPExcel);
      exit;        
        }
       
        
       
}
  
function tracker_qc_pending_list(){
        
        $model = array('Qualityverification_model'=>'tracker_qc_pending_list'); 
        $office = ($_POST['exp_office']) ? $_POST['exp_office'] : '';
        $org_id = ($_POST['exp_org_id']) ? $_POST['exp_org_id'] : '';
        $parent_office = ($_POST['exp_parent_office']) ? $_POST['exp_parent_office'] : '';
        $sub_office = ($_POST['exp_sub_office']) ? $_POST['exp_sub_office'] : ''; 
        $name = ($_POST['exp_name']) ? $_POST['exp_name'] : ''; 
        $a_status = ($_POST['exp_a_status']) ? $_POST['exp_a_status'] : '';
        $case_no=($_POST['exp_case_no']) ? $_POST['exp_case_no'] : '';
        $check_name=($_POST['exp_check_name']) ? $_POST['exp_check_name'] : '';
        $verifier_name=($_POST['exp_vm_name']) ? $_POST['exp_vm_name'] : '';
        $qc_name=($_POST['exp_qc_name']) ? $_POST['exp_qc_name'] : '';
                
        $checkId = ($_POST['exp_checkId']) ? $_POST['exp_checkId'] : '';
        $year = ($_POST['exp_year']) ? $_POST['exp_year'] : '';
        $type = ($_POST['exp_type']) ? $_POST['exp_type'] : '';
        $memtype = ($_POST['exp_memtype']) ? $_POST['exp_memtype'] : '';

        if($org_id)
        $condition[]=" o.id = ".$org_id;
        if($office)
        $condition[]=" cr.office = ".$office;
        if($parent_office)
        $condition[]=" cr.parent_office = ".$parent_office;
        if($sub_office)
        $condition[]=" cr.sub_office = ".$sub_office;

        if($qc_name){
            $condition[]=" (concat_ws(' ',us.first_name,us.last_name) like '%".$qc_name."%') ";
        }
        if($verifier_name){
            $condition[]=" (concat_ws(' ',vm.first_name,vm.last_name) like '%".$verifier_name."%') ";
        }

        if($type == 'member'){
            
            if(is_numeric($checkId) && $memtype==17){
                $condition[]=" ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish != 3 else ar.qc2_report_publish != 1 END ) and qc.assignee_id = ".$checkId;
            }
            
        }
        if($type == 'check'){
            
            if(is_numeric($checkId)){
                $condition[]=" md.id = ".$checkId;
            } 
            
        }
        if($type == 'organization'){
            
            if(is_numeric($checkId)){
                $condition[]=" o.id = ".$checkId;
            } 
            
        }

        if($year=='backYear'){
            $condition[]=" (date(vl1.v_date))<(CURRENT_DATE()-1)";
        }
        if($year=='prevYear'){
            $condition[]=" date(vl1.v_date)=(CURRENT_DATE()-1)";
        }
        if($year=='currYear'){
            $condition[]=" date(vl1.v_date)=CURRENT_DATE()";
        }

        if($a_status==1)
        $condition[]="(ar.qc2_verification = 0 and ar.qc1_verification=1 and ar.qc2_revert_request = 0 and vl1.qc2status!=107)";
        if($a_status==2)
        $condition[]=" ((ar.qc2_verification = 0 and ar.qc1_verification=1 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 2 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 2  and ar.qc1_assign_revert=1 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 0 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2)))";
        if($a_status==3)
        $condition[]=" ((ar.qc1_assign_revert = 1 and ar.qc2_verification = 0 and (vl1.supplementary = 0 || vl1.supplementary = 2))  || (ar.qc1_assign_revert=1 and ar.qc_2_verification=0 and (vl1.supplementary = 0 || vl1.supplementary = 2)))";
        if($a_status==4)
        $condition[]=" ((ar.qc2_verification = 1 and ar.qc2_report_publish != 1 and ar.qc2_revert_request = 0) )";
        if($a_status==5)
        $condition[]=" (ar.qc2_verification = 1 and ar.qc2_report_publish=1)";
        if($a_status==6)
        $condition[]=" (ar.qc2_verification = 0 and ar.qc1_verification=1 and vl1.qc2status=107)";
        if($a_status==7)
        $condition[]=" (ar.qc2_verification = 1 and ar.qc2_report_publish=2 and ar.qc1_assign_revert=0)";
        if($a_status==8)
        $condition[]=" (ar.qc1_verification=1 and ar.qc2_verification=0 and ar.qc_revert_request=1 and ar.qc2_revert_request=1 and ar.qc1_assign_revert=1 and ar.qc_2_verification=0 and ar.vm_assigned_qc=1 and vl1.supplementary=1 and  ar.reopen_revert_qc2=0 )";
        if($check_name)
        $condition[]=" md.name like '%".$check_name."%'";
        if($name)
        $condition[]=" cr.candidate_name like '%".$name."%'";
        if($case_no)
        $condition[]="cr.case_no like '%".$case_no."' ";
        
        $manual_cond=implode(' and ',$condition);
                     
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0]; 
        $result = $results[1];


        if ($result) {
           $objPHPExcel = new PHPExcel();
            
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Head Office");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Branch Office");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Sub Office");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Status");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Assigned Status");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "Check Status");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "VM Name");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "QC2 Name");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "Deadline From");
            $objPHPExcel->getActiveSheet()->setCellValue('O1', "Deadline To");
            
          
            $ci=2; 
           

            foreach ( $result as $i => $row ) {
                $verified_data=$this->vm->get_verified_data($row['request_id'],$row['level_id'],$row['check_id']);
                $verification_data=toArray(json_decode($verified_data['qc2fielddata']));
                $status4='';
                $status1=$this->vm->get_status($verification_data['status']);
                $status2=$this->vm->get_status($verification_data['pstatus']);
                $status3=$this->vm->get_status($verification_data['status1']);
                if($verification_data['ostatus']<>'')
                $status4=$this->vm->get_status($verification_data['ostatus']);
                if($verification_data['dstatus']<>'')
                $status4=$this->vm->get_status($verification_data['dstatus']);
                if(!empty($status4))
                $status41='-'.$status4['name'];
                else
                $status41='';
                $rpt_status='';


/************************ PF_Verification *************************/
        if($row['check_id'] ==652 ){
            if($verification_data['status']!=107 && $verification_data['status']!=684 && !empty($verification_data['status'])) {
                    if($status3['name']=="Multiple Active Records" ||$status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                        $rpt_status="RED";
                    }
                    // May 24h
                    else if( $status3['name']=="No Records" || $status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                        $rpt_status="ORANGE";
                    }
                    else 
                    {
                        $rpt_status="GREEN";
                    }
                }       
               
        }

/********************* PF_Verification *************************************/
        else{ // Start else { PF Verification
            if($verification_data['status']!=107 && $verification_data['status']!=684 && !empty($verification_data['status'])) {
                if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                        $rpt_status="RED";
                }
                // May 24th
                else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                    $rpt_status="ORANGE";
                }
                else 
                {
                    $rpt_status="GREEN";
                }
            }

        } //END else } PF_Verification    
           
            $slug=url_title(convert_accented_characters($row['name']), 'underscore', TRUE);
                               
                $cname=$row['candidate_name'];
                if($row['status']==1)
                {
                if($row['qc2_verification']==0 && $row['qc1_verification']==1 && $row['qc2status']!=107)
                {                   
                    $statusname=$this->vm->get_status_name($row['request_id'],$row['check_id'],$row['level_id'],'qcstatus');
                    $status='New';
                
                if($row['qc_revert_request']==0){
                    $cname=$row['candidate_name'];
                }
                else if($row['qc_revert_request']==1 && $row['qc2_revert_request']==0){
                    $cname=$row['candidate_name'];
                }
                else if($row['qc1_assign_revert']==1  && $row['qc_2_verification']==0 && $row['vm_assigned_qc']==1 && $row['reopen_revert_qc2']==0){
                    $status='Revert Closed';
                    $cname=$row['candidate_name'];
                }
                else if($row['qc1_assign_revert']==1  && $row['supplementary']==1 && $row['qc_2_verification']==0 && $row['vm_assigned_qc']==1 && $row['reopen_revert_qc2'] == 1){
                    $status='Reopen Closed';
                    $cname=$row['candidate_name'];
                }
                else if($row['qc1_assign_revert']==1){
                    $status='Revert Closed';
                    $cname=$row['candidate_name'];
                }
                else if($row['qc2_revert_request']==1 && $row['reopen_revert_qc2']== 1 && $row['supplementary']==1 && $row['qc2_report_publish']==2)
                {
                    if($row['revertedBy'] == 17)
                    {
                        $status='Revert Raised';
                        $cname=$row['candidate_name'];
                    }
                    else
                    {
                        $status='Reopened'; 
                        $cname=$row['candidate_name'];
                    }
                
                }
                else if($row['qc2_revert_request']==1 && $row['reopen_revert_qc2']== 1 && $row['supplementary']==1 && $row['qc2_report_publish']==1)
                {
                    if($row['revertedBy'] == 17)
                    {
                        $status='Revert Raised';
                        $cname=$row['candidate_name'];
                    }
                    else
                    {
                        $status='Reopened'; 
                        $cname=$row['candidate_name'];
                    }
                
                }
                else if($row['qc2_revert_request']==1 && $row['reopen_revert_qc2']== 1 && $row['supplementary']==1)
                {
                    $status='Revert Raised';
                    $cname=$row['candidate_name'];
                }
                else if($row['qc2_revert_request']==1 && $row['supplementary']==1 && $row['vm_assigned_qc']==1)
                {
                    $status='Reopened';
                    $cname=$row['candidate_name'];
                }
                else if($row['qc2_revert_request']==1)
                {
                    $status='Revert Raised';
                    $cname=$row['candidate_name'];
                }
               
                }
                else
                {
                    $statusname=$this->vm->get_status_name($row['request_id'],$row['check_id'],$row['level_id'],'qc2status');
                    if($statusname['name']=='Clear'){
                        $status='QC2 Approved';
                    }else if($statusname['name']=='Verified'){
                        $status='QC2 Approved';
                    } else if($row['qc2_verification']==0 && $row['qc1_verification']==1 && $row['qc2status']==107){
                        $status='Initiated';
                    }else{       
                    $status='QC2 Approved';
                                    
                    }
                    if($row['qc_2_verification']==1 && $row['qc2_report_publish']==0)
                    {
                        if($row['qc1_assign_revert']==1){
                            $status='QC2 Approved';
                        }else if($row['qc2_revert_request']==1){
                            $status='Revert Raised';
                        }
                   
                    $cname=$row['candidate_name'];
                    }
                    
                    elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==1 && $row['supplementary']==1)
                    {
                    $status='Reopen assigned';
                    $cname=$row['candidate_name'];
                    }
                    elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==1)
                    {
                    $status='Report Published';
                    $cname=$row['candidate_name'];
                    }
                    elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==1 && $row['supplementary']==1){
                    $status='Reopen';
                    $cname=$row['candidate_name'];
                    }
                    elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==2 && $row['qc2_revert_request']==0)
                    {
                    $status='Report Reopen';
                    $cname=$row['candidate_name'];
                    }elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==2 && $row['qc2_revert_request']==1 && $row['qc1_assign_revert']==0)
                    {
                    $status='Revert Raised';
                    $cname=$row['candidate_name'];
                    
                    }
                    elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==1  && $row['qc1_assign_revert']==1 && $row['vm_assigned_qc']==0)
                    {
                    $status='Revert Raised'; 
                    }
                    elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==2  && $row['qc1_assign_revert']==1)
                    {
                    $status='Revert Raised';
                    $cname=$row['candidate_name'];
                    
                    }
                    //revert status for qc submit qc2 publish reverted
                    elseif($row['qc1_assign_revert']==1 && $row['qc_2_verification']==0){
                        $status='Revert Closed';
                        $cname=$row['candidate_name'];
                    }
                    else if($row['qc2_verification']==0 && $row['qc1_verification']==1 && $row['qc2status']==107){
                        $status='Initiated';
                        $cname=$row['candidate_name'];
                    }
                    else{
                    $cname=$row['candidate_name'];
                    }
                }
                }
                else
                $status='Verification Pending';
                if($row['supplementary']==1 && $row['vm_assigned_qc']==1 && $row['qc1_assign_revert']==1 && $row['qc_2_verification']==0)
                {
                    $cname=$row['candidate_name'];
                }
                if($row['supplementary']==1 && $row['vm_assigned_qc']==1 && $row['qc1_assign_revert']==0 && $row['qc_2_verification']==1)
                {
                    $cname=$row['candidate_name'];
                }
                elseif($row['supplementary']==1 && $row['vm_assigned_qc']==0 && $row['qc1_assign_revert']==0 && $row['qc_2_verification']==1)
                {
                    $cname=$row['candidate_name'];
                }
                elseif ($row['supplementary']==2 && $row['qc2_verification']==1 && $row['qc2_revert_request']==0 && $row['qc_2_verification']==1) {
                    $cname=$row['candidate_name'];
                }
                elseif ($row['supplementary']==2 && $row['qc2_verification']==0 && $row['qc2_revert_request']==1 && $row['qc_2_verification']==0) {
                    $cname=$row['candidate_name'];
                }
                

                if($row['chk']==0){
                    $chkval=$row['name'];
                }else{
                    $chkval=$row['name'].$row['chk'];
                }
                if(!empty($status1['name'])){
                    $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
                }else{
                    $stat='';
                }

                $deadline_from=isset($row['qc_date'])? date('d-m-Y',strtotime($row['qc_date'])) : '';
                if($row['qc_date']){
                    $deadline_to=isset($row['qc_date'])? date('d-m-Y',strtotime($row['qc_date']. ' +1 day')) : ''; 
                }
                else {
                    $deadline_from=isset($row['v_date'])? date('d-m-Y',strtotime($row['v_date'])) : '';
                    $deadline_to=isset($row['v_date'])? date('d-m-Y',strtotime($row['v_date']. ' +1 day')) : ''; 
                } 

                
    $objPHPExcel->getActiveSheet()->getStyle('A1:O1')->getFont()->setBold(true);
    $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                                  ->setCellValue('B' . $ci, $row['org_name'])
                                  ->setCellValue('C' . $ci, $row['parent_office'])
                                  ->setCellValue('D' . $ci, $row['office_name'])
                                  ->setCellValue('E' . $ci, $row['sub_office'])
                                  ->setCellValue('F' . $ci, $cname)
                                  ->setCellValue('G' . $ci, $row['case_no'])
                                  ->setCellValue('H' . $ci, $chkval)
                                  ->setCellValue('I' . $ci, $status)
                                  ->setCellValue('J' . $ci, $stat)
                                  ->setCellValue('K' . $ci, $rpt_status)
                                  ->setCellValue('L' . $ci, $row['vmname'])
                                  ->setCellValue('M' . $ci, $row['qc2name'])
                                  ->setCellValue('N' . $ci, $deadline_from)
                                  ->setCellValue('O' . $ci, $deadline_to);
                                  
    $ci++;
            }
     $this->export_excel('A','O','Quality_Pending_List_',$objPHPExcel);
      exit;        
        }
        

}


function tracker_vm_pending_list() {

       $model = array('Qualityverification_model'=>'tracker_vm_pending_list');

        $office = ($_POST['exp_office']) ? $_POST['exp_office'] : '';
        $org_id = ($_POST['exp_org_id']) ? $_POST['exp_org_id'] : '';
        $parent_office = ($_POST['exp_parent_office']) ? $_POST['exp_parent_office'] : '';
        $sub_office = ($_POST['exp_sub_office']) ? $_POST['exp_sub_office'] : ''; 
        $name = ($_POST['exp_name']) ? $_POST['exp_name'] : ''; 
        $a_status = ($_POST['exp_a_status']) ? $_POST['exp_a_status'] : '';
        $case_no=($_POST['exp_case_no']) ? $_POST['exp_case_no'] : '';
        $check_name=($_POST['exp_check_name']) ? $_POST['exp_check_name'] : '';
        $verifier_name=($_POST['exp_vm_name']) ? $_POST['exp_vm_name'] : '';
        $qc_name=($_POST['exp_qc_name']) ? $_POST['exp_qc_name'] : '';
                
        $checkId = ($_POST['exp_checkId']) ? $_POST['exp_checkId'] : '';
        $year = ($_POST['exp_year']) ? $_POST['exp_year'] : '';
        $type = ($_POST['exp_type']) ? $_POST['exp_type'] : '';
        $memtype = ($_POST['exp_memtype']) ? $_POST['exp_memtype'] : '';

        if($org_id)
        $condition[]=" o.id = ".$org_id;
        if($office)
        $condition[]=" br.id = ".$office;
        if($parent_office)
        $condition[]=" p.id = ".$parent_office;
        if($sub_office)
        $condition[]=" su.id = ".$sub_office;       
        if($name)
        $condition[]="d.candidate_name like '%".$name."%' ";
        if($check_name)
        $condition[]="c.name like '%".$check_name."%' ";
        if($case_no)
        $condition[]="d.case_no like '%".$case_no."' ";
        if($verifier_name)
        $condition[]="(concat_ws(' ',us.first_name,us.last_name) like '%".$verifier_name."%') ";
        if($qc_name)
        $condition[]="(concat_ws(' ',us2.first_name,us2.last_name) like '%".$qc_name."%') ";
        

        if($type == 'member'){
            
            if(is_numeric($checkId)){
                $condition[]=" us.id = ".$checkId;
            } 
            
        }
        if($type == 'check'){
            
            if(is_numeric($checkId)){
                $condition[]=" c.id = ".$checkId;
            } 
            
        }
        if($type == 'organization'){
            
            if(is_numeric($checkId)){
                $condition[]=" o.id = ".$checkId;
            } 
            
        }

        if($year=='backYear'){
            $condition[]=" YEAR(date(vr.deadline_from))<(YEAR(CURRENT_DATE())-1)";
        }
        if($year=='prevYear'){
            $condition[]=" YEAR(date(vr.deadline_from))=(YEAR(CURRENT_DATE())-1)";
        }
        if($year=='currYear'){
            $condition[]=" YEAR(date(vr.deadline_from))=YEAR(CURRENT_DATE())";
        }

        if($a_status==1)
        $condition[]="( a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0)";
        if($a_status==2)
        $condition[]=" (a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1)";
        if($a_status==3)
        $condition[]=" (a.qc_revert_request = 1 and a.vm_assigned_qc=1 and a.verify_status not in(107,684,992))";
        if($a_status==4)
        $condition[]=" a.ass_request = 1 ";
        if($a_status==5)
        $condition[]=" (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111)";
        if($a_status==6)
        $condition[]="((a.verify_status in (110,111,519)) and a.ass_request=0 and a.qc_revert_request = 0 )";
        if($a_status==7)
        $condition[]="(a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107)";
        if($a_status==8)
        $condition[]="s.vm_revert_option_status = 1 and a.vm_revert_to = 2";
        if($a_status==9)
        $condition[]=" a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1";
        if($a_status==10)
        $condition[]=" a.verify_status = 992 and a.qc_revert_request !=1";
        if($a_status==11)
        $condition[]=" a.vm_assigned_qc = 0 and a.ass_request = 0 and vl1.supplementary = 1 and a.qc_revert_request = 1 and a.reopen_revert_qc2 != 1";

        if($term)
        {
            //support multiple words
                $search = explode(' ', $term);
            foreach($search as $t){
                $not        = '';
                $operator    = 'OR';
                if(substr($t,0,1) == '-')
                {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t,1,strlen($t));
                   
                }
            }
        }

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1];
       if ($result) {
           $objPHPExcel = new PHPExcel();
            
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Head Office");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Branch Office");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Sub Office");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Name");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Status");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Verified Status");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "Check Status");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Verifier Name");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "QC Name");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "Deadline From");
            $objPHPExcel->getActiveSheet()->setCellValue('O1', "Deadline To");
            
          
            $ci=2;
        foreach( $result as $i => $row ){

            $verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
            $verification_data=toArray(json_decode($verified_data['fielddata']));
         

            $status1=$this->vm->get_status($verification_data['status']);
            $status4='';
            $status2=$this->vm->get_status($verification_data['pstatus']);
            $status3=$this->vm->get_status($verification_data['status1']);
            if($verification_data['ostatus']<>'')
            $status4=$this->vm->get_status($verification_data['ostatus']);
            if($verification_data['dstatus']<>'')
            $status4=$this->vm->get_status($verification_data['dstatus']);
            if(!empty($status4))
            $status41='-'.$status4['name'];
            else
            $status41='';

        

        $rpt_status='';
        /************************ PF_Verification *************************/
    if($row['checkId'] ==652 ){
        if($verification_data['status']!=107 && $verification_data['status']!=684 && !empty($verification_data['status'])) {
            if($status3['name']=="Multiple Active Records" || $status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                    $rpt_status="RED";
                            
            }
            // May 24th
            else if( $status3['name']=="No Records" || $status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                        
                        $rpt_status="ORANGE";
            }
            else 
            {
                            
                $rpt_status="GREEN";
            }
        }       
                   
    }

/********************* PF_Verification *************************************/
     else{  // PF_verification
            if($verification_data['status']!=107 && $verification_data['status']!=684 && $verification_data['status']!=992 && !empty($verification_data['status'])) {
                if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                    $rpt_status="RED";
                }
                // May 24th
                else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Possible Match" || $status3['name']=="Partial Match"){
                    $rpt_status="ORANGE";
                }
                else 
                {
                    $rpt_status="GREEN";
                }
            }
         } // PF_Verification   
                
                $checkadminstatus = $this->vm->get_currentstatus($row['candidate_req_id']);
                

                $candidatename=$row['candidatename'];

                if($row['vm_revert_option_status']==1 && $row['vm_revert_to']==2){
                    $verifyurl = 'Revert Raised to DEO';
                }             
                else if($row['qc_revert_request']==1 ){
                    if($row['vm_assigned_qc']==1 && $row['verify_status']<>107 && $row['verify_status']<>684 && $row['verify_status']<>992 ) {
                        $candidatename= $row['candidatename'];
                        $verifyurl = 'Revert Rectified';
                    }
                    else if($row['vm_assigned_qc']==0 && $row['ass_request']==0 && $row['supplementary']==1 && $row['qc_revert_request']==1 && $row['reopen_revert_qc']==0 && $row['reopen_revert_qc2']==1 ){
                    $verifyurl = 'Reopen Assigned';
                    }

                    else if($row['vm_assigned_qc']==0 && $row['ass_request']==0 && $row['supplementary']==1 && $row['qc_revert_request']==1 && $row['reopen_revert_qc']==1 && $row['reopen_revert_qc2']==1 ){
                    $verifyurl = 'Reopen Assigned';
                    }
                    else{
                        
                        $verifyurl = 'Revert Assigned';
                    
                    }
                
                }
                
                elseif($row['verify_status']==111 && $row['vrequest']==0 && $row['ass_request']==0 )
                {
                    $verifyurl = 'Verified';
                    $requesttoass = '';
                    $add_calls='';
                                       
                    $candidatename= $row['candidatename'];
                                        
                }
                else if($row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==3 && $row['vm_revert_to']==2)
                {
                    $verifyurl = 'Verified';
                    $requesttoass = '';
                    $add_calls='';
                                       
                    $candidatename= $row['candidatename'];
                                        
                }

                else if($row['vm_revert_option_status']==3 && $row['vm_revert_to']==2){
                    $verifyurl = 'Revert Closed';
                }
                
                else if($row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==4 && $row['operator_submited_by']==12 || $row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_option_status']==4 && $checkadminstatus['role_id']==13)
                {
                    $verifyurl = 'Verified';
                    $requesttoass = '';
                    $add_calls='';
                                       
                    $candidatename= $row['candidatename'];
                                        
                }

                else if($row['vm_revert_option_status']==4 && $row['operator_submited_by']==12 || $row['vm_revert_option_status']==4 && $checkadminstatus['role_id']==13){
                    $verifyurl ='Revert Closed';
                }
                else if($row['verify_status']==111 && $row['vrequest']==1 && $row['ass_request']==0 && $row['vm_revert_to']==3 && $row['vm_revert_supervisor']==0)
                {
                                        $verifyurl = 'Verified';
                                        $requesttoass = '';
                                        $add_calls='';
                                       
                                       $candidatename= $row['candidatename'];
                                        
                }
                else if($row['vm_revert_to']==3 && $row['vm_revert_supervisor']==0){
                    $verifyurl = 'Revert Closed';
                }

                else if($row['verify_status']<>'111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0 )
                {
                                        if($row['rstatus']==108)
                                        $vst='Inputs Required';
                                        else if($row['rstatus']==110)
                                        $vst='Stop Check';
                                        else if($row['rstatus']==109)
                                        $vst='Awaiting Authorisation';
                                        else if($row['rstatus']==107)
                                        $vst='Initiated';
                                        else if($row['rstatus']==519)
                                        $vst='Others';
                                        else if($row['rstatus']==684)
                                        $vst='Request Raised';
                                        else if($row['rstatus']==992)
                                        $vst='DD applied';
                
                                        if($row['rstatus']==110 || $row['rstatus']==519){
                                            $verifyurl = 'Verified';
                                        }else{
                                             $verifyurl = $vst;
                                        }
                                      
                                        $requesttoass = '';
                }

                
                

                else if($row['verify_status']=='111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0)
                {
                                        if($row['rstatus']==108)
                                        $vst='Inputs Required';
                                        else if($row['rstatus']==110)
                                        $vst='Stop Check';
                                        else if($row['rstatus']==109)
                                        $vst='Awaiting Authorisation';
                                        else if($row['rstatus']==107 && $row['verify_status']=='111')
                                        $vst='Verified';
                                        else if($row['rstatus']==107)
                                        $vst='Initiated';
                                        else 
                                        $vst='Verified';
                
                                        $verifyurl = $vst;
                                        $requesttoass = '';
                }
                else if($row['ass_request']==1)
                {
                $verifyurl='Request Raised';
                $requesttoass='Sent to Associate';
                $add_calls='';
                }
                
                
                else
                {
                                        $save['request_id']=$row['candidate_req_id'];
                                        $save['check_id']=$row['checkId'];
                                        $save['level_id']=$row['level_id'];
                                        $this->db->select('count(*) as cnt');
                                        $this->db->where($save);
                                        $countnoti=$this->db->get(DB_PREFIX.'notification_emails')->row_array();

                                        if($countnoti['cnt'] >=1 )
                                        $vtext='Sent Mail to Resource';
                                        else
                                        $vtext='New';
                
                
                
                
                                        $verifyurl = $vtext;
                                        $vst=$row['status'];
                                        $requesttoass ='';
                                }
                                


            if($row['chk']==0){
                $chkval=$row['checkname'];
            }else{
                $chkval=$row['checkname'].$row['chk'];
            }

            if(!empty($status1['name'])){
                $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
            }else{
                $stat='';
            }
        
            
                $deadline_from=isset($row['deadline_from'])? date('d-m-Y',strtotime($row['deadline_from'])) : '';
                $deadline_to=isset($row['deadline_to'])? date('d-m-Y',strtotime($row['deadline_to'])) : '';
                
               


      $objPHPExcel->getActiveSheet()->getStyle('A1:O1')->getFont()->setBold(true);
    $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                                  ->setCellValue('B' . $ci, $row['org_name'])
                                  ->setCellValue('C' . $ci, $row['parent_office'])
                                  ->setCellValue('D' . $ci, $row['office_name'])
                                  ->setCellValue('E' . $ci, $row['sub_office'])
                                  ->setCellValue('F' . $ci, $candidatename)
                                  ->setCellValue('G' . $ci, $row['case_no'])
                                  ->setCellValue('H' . $ci, $chkval)
                                  ->setCellValue('I' . $ci, $verifyurl)
                                  ->setCellValue('J' . $ci, $stat)
                                  ->setCellValue('K' . $ci, $rpt_status)
                                  ->setCellValue('L' . $ci, $row['vname'])
                                  ->setCellValue('M' . $ci, $row['qc2name'])
                                  ->setCellValue('N' . $ci, $deadline_from)
                                  
                                  ->setCellValue('O' . $ci, $deadline_to);
                                  
    $ci++;
            }
     $this->export_excel('A','O','VM_Pending_List_',$objPHPExcel);
      exit;        
        }


}


//******************** END TRACKER EXPORT *********************************//




    
}
?>