<?php
require_once ('Common.php');
class Roles extends Common {
//DEfault Constructor called by controller 
	function __construct() 
	{
        parent::__construct();
                $this->_check_userlogin ();
		$this->load->model ( 'Roles_model', 'rm' );
                $this->amodel->loadjsscript(array( 'grid.locale-en','jquery.jqGrid.min','jquery.validate', 'jquery.dropdownPlain','commonjs','jquery-ui-1.8.16.custom.min'));

	}

	 // Manage Roles Function 
	
	function manage_roles() {
		$this->_check_featureauth ( 'roles', 'search' ); // Check if user is allowed for action
		$this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
		$data ['role_list'] = $this->db->get ( DB_PREFIX ."role_types" )->result_array (); 
		$data['user_type'] = $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_usertype", array('id', 'name'), array('key' => 'user_types'));
		$data ['title'] = 'Manage Roles';
		// add breadcrumbs
		$this->breadcrumbs->push('Dashboard', 'Index/dashboard');
		$this->breadcrumbs->push('Roles', 'Roles/manage_roles');
		// unshift crumb
		// output
		$data['breadcrumb']=$this->breadcrumbs->show();  
		//render the views
		$this->amodel->pagerender($data, 'Manage_Roles');
	}

    public function get_roles($office = 0 ) {
        $condition=array();
        $model = array('Roles_model'=>'get_roles');
        $organization=($_REQUEST['organization']) ? $_REQUEST['organization'] : '';
        $parent_office=($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $office=($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $sub_office=($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $role=($_REQUEST['role']) ? $_REQUEST['role'] : '';
        $term=($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $role_name=($_REQUEST['role_name']) ? $_REQUEST['role_name'] : '';
        
        if($organization)
        $condition[]="r.organization=".$organization;
        
        if($parent_office)
        $condition[]="r.parent_office=".$parent_office;

        if($office)
        $condition[]="r.office_id=".$office;

   		if($sub_office)
        $condition[]="r.sub_office=".$sub_office;

        if($role)
        $condition[]="r.user_type=".$role;
    	if($role_name)
    	$condition[]=" a.role_name like '%".$role_name."%'";
        
        if($term)
        {
                //support multiple words
                $search = explode(' ', $term);

                foreach($search as $t) {
                    $not        = '';
                    $operator    = 'OR';
                    if(substr($t,0,1) == '-')
                    {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t,1,strlen($t));
                    }

                    $like    = '';
                    $like    .= "( a.role_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." c.office_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." org_name ".$not."LIKE '%".$t."%' " ;
                    $like    .= $operator." g.office_name ".$not."LIKE '%".$t."%' ) " ;
$condition[]=$like;
               
            }
        }
        
        
        $manual_cond=implode(' and ',$condition);
		$results = $this->_jqgrid_search($model,$manual_cond); 
		$response = $results[0];  $result = $results[1]; 
		   if ($result) {
		   $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
			$rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
			$page=$page - 1;
			$count=$page * $rows;
			foreach ( $result as $i => $row ) {
			$editurl=$row['organization'].'/'.$row['parent'].'/'.$row['office_id'];
			 $auth_link = array(   array('config_menu','task_status','Menu Configuration','Roles/config_menu/'.$row['id'].'/'.$editurl,''),
                                                              array('roles','edit','Modify Role Permissions','Roles/roleedit/'.$row['id'].'/'.$editurl,''),
                                                          );
                            
                                $list = check_link_featureauth ( $auth_link, 1 ); 
                $actions = implode (' | ',$list);
                                
			$response->rows [$i] ['cell'] = array ( $i+$count+1, $row['org_name'],$row['role_name'], $actions);
			}
		}
		echo json_encode ( $response );
    }
   // Add Roles Function 
	
	function roleadd() {
		$this->_check_featureauth ( 'roles', 'add' ); // Check if user is allowed for action
		$data ['title'] = 'Add Role Details';
		// add breadcrumbs
                $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
                $this->breadcrumbs->push('Roles', 'Roles/manage_roles');
                $this->breadcrumbs->push('Add Roles', 'Roles/roleadd');
                // unshift crumb

                // output
                $data['breadcrumb']=$this->breadcrumbs->show();  
                $this->amodel->pagerender($data, 'Create_Role');
	}

        function get_featurelist(){ 
        $usertype_id = $this->uri->segment(4);
		$feature_list = $this->rm->_get_feature_list ( $usertype_id );
                foreach($feature_list as $feature){
	                $feature_id = $feature['id'];

                $table_row =    "<tr class='s-usebrd' height='42'>
	                        <td width='140'>".$feature['feature_name']."</td>";

		  if($feature['type'] == 'task'){

	           $table_row .= '<td align="center"><input type="checkbox" checked value="1" name="role_config['.$feature_id.'][task_status]"></td>
		                <td colspan="7">&nbsp;</td>';
		
		        }else{

	                $table_row .= '<td>&nbsp;</td>
		                <td align="center"><input type="checkbox" value="1" name="role_config['.$feature_id.'][add]"></td>
		                <td align="center"><input type="checkbox" value="1" name="role_config['.$feature_id.'][edit]"></td>
		                <td align="center"><input type="checkbox" value="1" name="role_config['.$feature_id.'][view]"></td>
		                <td align="center"><input type="checkbox" value="1" name="role_config['.$feature_id.'][delete]"></td>
		                <td align="center"><input type="checkbox" value="1" name="role_config['.$feature_id.'][search]"></td>
		                <td align="center"><input type="checkbox" value="1" name="role_config['.$feature_id.'][list]"></td>
		                <td align="center"><input type="checkbox" value="1" name="role_config['.$feature_id.'][generate]"></td>';
	                } 
                $table_row .= '</tr>';
           echo $table_row;	
                }
        echo '<tr>
                <td colspan="8" align="right"></td>
	        <td align="right">
		        <input type="submit" class="button" value="Submit">
	        </td>
	     </tr>';
        }
        
	function p_add_role() {
		$this->_check_featureauth ( 'roles', 'add' ); // Check if user is allowed for action
		
		
		if($_POST['role_name']=='Others')
		{
		
		// Create Role
		$ins_data = array ();
		$ins_data ['role_name'] = $this->input->post ( 'roleadd' );
		$ins_data ['user_type'] = $this->input->post ( 'user_type' );
		$ins_data ['active_status'] = 1;
		$ins_data ['created_on'] = date ( 'Y-m-d H:i:s' );
		$ins_data = $this->security->xss_clean($ins_data);
		$this->db->insert ( DB_PREFIX .'role_types', $ins_data );
		
		$role_id = $this->db->insert_id ();
		}
		else
		$role_id=$_POST['role_name'];
		
		$role_config = $this->input->post ( 'role_config' );
		$pr_data ['user_type'] = $this->input->post ( 'user_type' );
                $pr_data ['role_id'] = $role_id;
                $pr_data ['office_id'] = $this->input->post ( 'office_id' );
                $pr_data ['parent_office'] = $this->input->post ( 'parent_office' );
                $pr_data ['sub_office'] = $this->input->post ( 'sub_office' );
                $pr_data ['organization'] = $this->input->post ( 'parentoffice_id' );
                $pr_data ['active_status'] = 1;
		$pr_data ['created_on'] = date ( 'Y-m-d H:i:s' );
		$pr_data = $this->security->xss_clean($pr_data);
		$this->db->insert ( DB_PREFIX .'role_permissions', $pr_data );
		
		
		
		foreach ( $role_config as $feature_id => $config ) {
			
			// Create Role Config 
			$ins_data = array ();
			$ins_data ['role_id'] = $role_id;
			$ins_data ['office_id'] = $this->input->post ( 'office_id' );
			$ins_data ['parent_office'] = $this->input->post ( 'parent_office' );
			$ins_data ['organization'] = $this->input->post ( 'parentoffice_id' );
			$ins_data ['sub_office'] = $this->input->post ( 'sub_office' );
			$ins_data ['feature_id'] = $feature_id;
			$ins_data ['add'] = ((isset ( $config ['add'] )) ? $config ['add'] : 0);
			$ins_data ['edit'] = ((isset ( $config ['edit'] )) ? $config ['edit'] : 0);
			$ins_data ['view'] = ((isset ( $config ['view'] )) ? $config ['view'] : 0);
			$ins_data ['delete'] = ((isset ( $config ['delete'] )) ? $config ['delete'] : 0);
			$ins_data ['search'] = ((isset ( $config ['search'] )) ? $config ['search'] : 0);
			$ins_data ['list'] = ((isset ( $config ['list'] )) ? $config ['list'] : 0);
			$ins_data ['generate'] = ((isset ( $config ['generate'] )) ? $config ['generate'] : 0);
			$ins_data ['task_status'] = ((isset ( $config ['task_status'] )) ? $config ['task_status'] : 0);
			$ins_data ['created_by'] = $this->user_id;
			$ins_data ['created_on'] = date ( 'Y-m-d H:i:s' );
			$ins_data = $this->security->xss_clean($ins_data);
			$this->db->insert ( 'm_role_config', $ins_data );
		   }

		redirect ( base_url('Roles/manage_roles') );
	}

//Edit Roles Function 
	function roleedit($role_id = '',$organization=0,$parent=0,$office=0) {
                $this->amodel->loadjsscript(array('jquery.validate', 'jquery.dropdownPlain'));
		$this->_check_featureauth ( 'roles', 'edit' ); // Check if user is allowed for action

		if (! $role_id) {
			show_error ( "Unknown Role " );
			exit ();
		}
        	
		if($organization<>0)
		$condition[]="r.organization=".$organization;
		if($parent<>0)
		$condition[]="r.parent_office=".$parent;
		if($office<>0)
		$condition[]="r.office_id=".$office;
		$cond = implode(' AND ',$condition);
		if($role_id<>0)
		$condition[]="role_id=".$role_id;
		
		$mcond=implode(' AND ',$condition);
		
		$role_det = $this->db->query ( "select a.*,b.name,f.org_name,a.user_type,g.office_name,c.office_name as parent_office,organization,r.parent_office as parent,r.office_id from ". DB_PREFIX ."role_types a
		
                                        LEFT JOIN m_role_config r ON r.role_id = a.id
                                        LEFT JOIN " . DB_PREFIX . "office g ON g.id=r.office_id
                                        JOIN " . DB_PREFIX . "organisation f ON f.id=r.organization
                                        LEFT JOIN " . DB_PREFIX . "office c ON c.id=r.parent_office
                JOIN ".DB_PREFIX ."master_usertype b on a.user_type = b.id WHERE a.id=".$role_id." AND ".$cond )->result_array();
		$data ['role_det'] = $role_det [0];
		$role_config_det = $this->rm->_get_role_config ( $role_id, $mcond );
		
		$tmp_role_cfg = array ();
		foreach ( $role_config_det as $cfg ) {
			$feature_id = $cfg ['feature_id'];
			$tmp_role_cfg [$feature_id] = $cfg;
		}
		
		$data ['role_config'] = $tmp_role_cfg; 
		
		$data ['feature_list'] = $this->rm->_get_feature_list ( $role_det [0]['user_type'] );
		$data ['title'] = 'Edit Role Details';
		// add breadcrumbs
                $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
                $this->breadcrumbs->push('Roles', 'Roles/manage_roles');
                $this->breadcrumbs->push('Edit Role Details', 'Roles/roleedit');
                // unshift crumb

                // output
                $data['breadcrumb']=$this->breadcrumbs->show();
             	$this->amodel->pagerender($data, 'Modify_Role');
	}

	function p_edit_role() {
		$this->_check_featureauth ( 'roles', 'edit' ); // Check if user is allowed for action

		$role_id = $this->input->post( 'role_id' );
		// Create Role
		
		$role_config = $this->input->post ( 'role_config' );
		$ids_id=array();
		foreach ( $role_config as $ids)
		{
		$ids_id[]=$ids['id'];
		}
		if(!empty($ids_id)){
		$notid="'".implode("','",$ids_id)."'";
		$condtions="id NOT IN (".$notid.")";
                $delete_data ['role_id'] = $role_id;
                $delete_data ['office_id'] = $this->input->post ( 'office_id' );
                $delete_data ['parent_office'] = $this->input->post ( 'parent_office' );
                $delete_data ['organization'] = $this->input->post ( 'parentoffice_id' );
		$this->db->where($delete_data);
		$this->db->where($condtions);
		$this->db->delete('m_role_config');
		}
		
		
		foreach ( $role_config as $feature_id => $config ) {
			
			// Create Role Config 
			$ins_data = array ();
			$ins_data ['role_id'] = $role_id;
			$ins_data ['office_id'] = $this->input->post ( 'office_id' );
			$ins_data ['parent_office'] = $this->input->post ( 'parent_office' );
			$ins_data ['organization'] = $this->input->post ( 'parentoffice_id' );
			$ins_data ['feature_id'] = $feature_id;
			$ins_data ['add'] = ((isset ( $config ['add'] )) ? $config ['add'] : 0);
			$ins_data ['edit'] = ((isset ( $config ['edit'] )) ? $config ['edit'] : 0);
			$ins_data ['view'] = ((isset ( $config ['view'] )) ? $config ['view'] : 0);
			$ins_data ['delete'] = ((isset ( $config ['delete'] )) ? $config ['delete'] : 0);
			$ins_data ['search'] = ((isset ( $config ['search'] )) ? $config ['search'] : 0);
			$ins_data ['list'] = ((isset ( $config ['list'] )) ? $config ['list'] : 0);
			$ins_data ['generate'] = ((isset ( $config ['generate'] )) ? $config ['generate'] : 0);
			$ins_data ['task_status'] = ((isset ( $config ['task_status'] )) ? $config ['task_status'] : 0);
			if ($config ['id']) {
				$this->db->where ( 'id', $config ['id'] );
				$ins_data ['modified_by'] = $this->user_id;
				$ins_data ['modified_on'] = date ( 'Y-m-d H:i:s' );
				$this->db->update ( 'm_role_config', $ins_data );
			} else {
				$ins_data ['created_on'] = date ( 'Y-m-d H:i:s' );
				$ins_data ['created_by'] = $this->user_id;
				$this->db->insert ( 'm_role_config', $ins_data );
			}
		
		}

		redirect ( base_url('Roles/manage_roles') );
	}

	function del_role($role_id) {
		$this->_check_featureauth ( 'roles', 'delete' ); // Check if user is allowed for action
		
        	$this->db->where ( 'id', $role_id );
		$this->db->delete ( DB_PREFIX .'role_types' );
		
		$this->db->where ( 'role_id', $role_id );
		$this->db->delete ( 'm_role_config' );
		
		echo '<script type="text/javascript">window.parent.hndl_del_roleresp("Successfully Deleted Role")</script>';
	        redirect ( base_url('Roles/manage_roles') );
	}


	function config_menu($role_id = '',$organization=0,$parent=0,$office=0) {
	
	

		$this->_check_featureauth ( 'config_menu', 'task_status' );
		$office_id = $this->session->userdata('office_id');
		
		$data['organization']=$organization;
		$data['parent_office']=$parent;
		$data['office_id']=$office;
		
		$this->db->select('r.*,t.role_name');
		$this->db->where($data);	
		$this->db->where ( 'role_id', $role_id );
		$this->db->join(DB_PREFIX ."role_types t",'role_id=t.id','left');
		$role_det = $this->db->get ( DB_PREFIX ."role_permissions r" )->result_array ();
		$data ['role_det'] = $role_det [0];
		$data ['title'] = 'Configure Menu'; 
		// add breadcrumbs
                $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
                $this->breadcrumbs->push('Roles', 'Roles/manage_roles');
                $this->breadcrumbs->push('Manage Roles', 'roles/config_menu');
                // unshift crumb

                // output
                $data['breadcrumb']=$this->breadcrumbs->show();  
		$this->amodel->pagerender($data, 'Config_Menu');
	}


	function p_config_menu() {
		$role_id = $this->input->post ( 'role_id' );
		$id = $this->input->post ( 'id' );
		$menu_ids = $this->input->post ( 'menu_ids' );
		
                $office = $this->input->post ( 'office_id' );
                $parent = $this->input->post ( 'parent_office' );
                $organization = $this->input->post ( 'parentoffice_id' );
			
		
		if($organization<>0)
		$condition['organization']=$organization;
		if($parent<>0)
		$condition['parent_office']=$parent;
		if($office<>0)
		$condition['office_id']=$office;
		
		
		$upd_data = array ();
		$upd_data ['menu_ids'] = ($menu_ids ? implode ( ',', $menu_ids ) : '');
		$upd_data ['modified_on'] = date ( 'Y-m-d H:i:s' );
		$this->db->where ( 'id', $id );
		$this->db->update ( DB_PREFIX .'role_permissions', $upd_data );
		$editurl=$organization.'/'.$parent.'/'.$office;
		$this->session->set_flashdata ( 'notify_user', 'Menu Settings updated successfully' );
		 redirect ( base_url('Roles/manage_roles') );
	}
}
