<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('Common.php');
require_once ('./PHPExcel-1.8/Classes/PHPExcel.php'); 
class Settings extends Common {
    function __construct() 
    {
        parent::__construct();
        $this->_check_userlogin ();
        $this->load->model('Adm_model', 'amodel', true);
        $this->load->model('Settings_model', 'smodel', true);
        $this->load->config(APPLICATIONCONFIG, TRUE);
        $this->load->helper(array('form', 'currency', 'date', 'add', 'translate', 'pagination', 'view', 'table', 'array', 'convertdate'));
        $models = array('Management_model' => 'mm','Verification_model' => 'vm');
        foreach ($models as $file => $object_name) {
            $this->load->model($file, $object_name);
        }
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','jquery-ui-1.10.4','highcharts','exporting','jquery.validate','grid.locale-en','jquery.jqGrid.min','jquery-ui-1.8.16.custom.min','autocomplete','multipleclone','commonjs','jquery.datepick'));
    }
    
   //************************************************ MASTER DATA ***********************************************
    function masterdata($key=false,$discrepency_name=false) {
    
    
        $this->_check_featureauth ( 'settings', 'search' ); // Check if user is allowed for action
        //load css and js files
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min'));
        //getting the key
        if($key)
        $keyWord = base64_decode($key); 
        else  if ($_POST['masterkey'])
        $keyWord = $_POST['masterkey'];
        //$discrepency_type = $this->amodel->getDetails( DB_PREFIX."master_masterdata", array('id', 'name'), array('key' => 'check'));
        $discrepencyname = $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id','name'),array('key' => 'check'));
             
        //$discrepencyname = $this->amodel->fetchDropdowndetails($discrepency_type, array('id', 'name'));
        //print_r($discrepencyname);

        $formElement = array(array('masterkey' => array('dropdown', 'master_name','Y', '', $this->config->item('MASTER_KEY'), ''),'discrepecyref' => array('dropdown','discrepecyref','Z','',$discrepencyname,''))); 

        if ($keyWord) {
            $auth_link = array( array('settings','add','Create','Settings/masterdataadd/'.base64_encode($keyWord) )  );
            
        } else {
                $keyWord = $key;
                $auth_link  = '';
        }
        

        $data['formelements'] = create_searchform($formElement);
        $data['table'] = form($data['formelements'], $formElement, 'master_data', 'Settings/masterdata', 'Search', $auth_link, $keyWord, base_url());
       $data['pages'] = $pages = $values[1]; 
        // add breadcrumbs
                $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
                $this->breadcrumbs->push('Master Data', 'Settings/masterdata');
              
                // unshift crumb

                // output
                $data['breadcrumb']=$this->breadcrumbs->show();
        //render the views
        $this->amodel->pagerender($data, 'master_name');
    }
    
    function get_list()    {
        $this->_check_featureauth ( 'settings', 'search' ); // Check if user is allowed for action
                 $key = ($_REQUEST['key']) ? $_REQUEST['key'] : '';
                 $discrepency_name = ($_REQUEST['discrepency_name']) ? $_REQUEST['discrepency_name'] : '';
                
                if($key=='Country' || $key=='State' || $key=='institutions')
                {
                 
                $model = array('Settings_model'=>'get_address_data');
                $manual_cond = "";
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  $result = $results[1]; 
           if ($result) {
           $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            foreach ( $result as $i => $row ) {
    // anchor('/settings/masterdatacommonview/'.base64_encode($row['id']).'/'.base64_encode($key),$row['name']);
                if($key=='institutions'){
        $response->rows [$i] ['cell'] = array ( $i+$count+1, anchor('/Settings/masterdatacommonview/'.base64_encode($row['id']).'/'.base64_encode($key), $row['name']),"N/A");
    }else{
        $response->rows [$i] ['cell'] = array ( $i+$count+1, $row['name'],"N/A");
    }
            }
        }
                }
                else
                {
                
                $model = array('Settings_model'=>'get_masterlist');
                if($key)
                $condition[]=" a.key ='". $key ."'";
                  
                  if($key == "status"){
                      if($discrepency_name)
                     $condition[]=" a.ref_id='". $discrepency_name ."'";

                  }
                  else
                  {
                       if($discrepency_name)
                       $condition[]=" a.ref_id='". $discrepency_name ."'";
                  }

                $manual_cond = implode(' and ',$condition);
                
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  $result = $results[1]; 
           if ($result) {
           $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            foreach ( $result as $i => $row ) {
                   
                  /* echo "<pre>";
                  print_r($row);exit();*/
                 
                if( $key == 'status')
                {     
                     $response->rows [$i] ['cell'] = array ( $i+$count+1,
                anchor('/Settings/masterdatacommonview/'.base64_encode($row['id']) . '/' . base64_encode($_REQUEST['key']), $row['name']) , $row['checkname'] ,$row['statusname']
                );    
                }
                else {
                if($row['ref_id']){
            $ref = $this->smodel->getrefname($row['ref_id']);
            $response->rows [$i] ['cell'] = array ( $i+$count+1,
                anchor('/Settings/masterdatacommonview/'.base64_encode($row['id']), $row['name']),$ref[0]['name']
                );}
            else {
            $response->rows [$i] ['cell'] = array ( $i+$count+1,
                anchor('/Settings/masterdatacommonview/'.base64_encode($row['id']), $row['name']),"N/A"
                );
        }
    }

            
            }
        }
        }
        echo json_encode($response);
    
    }
    
    function company_decl()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.validate','jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min','commonjs','jquery-ui-1.8.16.custom.min'));
       
        $id = base64_decode($this->uri->segment(3));
            $title = "Add";
            $data['editdeclaration']=$this->smodel->getdeclaration($id); 
            $data['id']=$id;
        //$data['declaration_details']=$this->smodel->getdecla();
        // add breadcrumbs
                $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
                $this->breadcrumbs->push('Declaration', 'Settings/company_decl');
                 
                // unshift crumb

                // output
                $data['breadcrumb']=$this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'add_company_declr'); 
    }
    function company_declaration_list()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.validate','jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min','commonjs','jquery-ui-1.8.16.custom.min'));
        /*$this->amodel->loadcssScript(array( 'jquery-ui-1.10.4'));
                $this->amodel->loadjsscript(array( 'jquery.validate', 'jquery.dropdownPlain', 'commonjs','jquery-ui-1.8.16.custom.min'));*/
        $id = base64_decode($this->uri->segment(3));
            $title = "Add";
            $data['editdeclaration']=$this->smodel->getdeclaration($id);
            $data['id']=$id;
        //$data['declaration_details']=$this->smodel->getdecla();
        // add breadcrumbs
                $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
                $this->breadcrumbs->push('Declaration', 'Settings/company_decl');
                 
                // unshift crumb

                // output
                $data['breadcrumb']=$this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'add_company_declr'); 
    }
    function get_company_declaration($office_name = 0)
    {
        $model = array('Settings_model'=>'getdecla');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        if($office)
                        $condition[]=" a.office_id = ".$office;
                        if($parent_office)
                        $condition[]=" a.parent_office_id = ".$parent_office;
                        if($sub_office)
                        $condition[]=" a.sub_office = ".$sub_office;
                        if($org_id)
                        $condition[]=" a.organization = ".$org_id;
                        if($name)
                        $condition[]=" a.declaration_name like '%".$name."%' ";
                    
     
        
        $manual_cond=implode(' and ',$condition);
    
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];  $result = $results[1];
       
           if ($result) {
           $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            foreach ( $result as $i => $row ) {
                      
                        
            $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],anchor('/Settings/company_decl/'.base64_encode($row['id']), $row['declaration_name']));

            }
        }
        echo json_encode($response);
        }
    
    function declaration_add()
    {
        
        $this->smodel->declarationdml($_POST);
        
    }
    
    function masterdataadd() { 
      $this->load->library('Csvreader');
      $result =   $this->csvreader->parse_file($_FILES['csvfile']['tmp_name']); 
    
      //getting the key
        $key = base64_decode($this->uri->segment(3));
        $College_key = base64_decode($this->uri->segment(4)); 
//print_r($key);
      if($College_key == "institutions"){
            $data['editDetails'] = $editDetails = $this->amodel->getDetails(DB_PREFIX . "institutions", array('*'), array('id' => $key));
            //print_r($details);
          //   $details = $this->smodel->getdropdowndetails($id,$College_key);
       }else if($College_key == "status") {

     $data['editDetails'] = $editDetails = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('*'), array('id' => $key));
     $case_status_data = $this->amodel->getDetails(DB_PREFIX . "check_status", array('*'), array('status_id' => $editDetails[0]['id'] ));
           $editDetails[0]['check_name'] =     $case_status_data[0]['check_id'];

       }
       else
       {
           $data['editDetails'] = $editDetails = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('*'), array('id' => $key));
       }
        //$data['editDetails'] = $editDetails = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('*'), array('id' => $key));
        if ($editDetails) { 
            $this->_check_featureauth ( 'settings', 'edit' ); // Check if user is allowed for action
                $keyLabel = $editDetails[0]['key'];
        } else {
            $this->_check_featureauth ( 'settings', 'add' ); // Check if user is allowed for action
                $keyLabel = $key;
        }
       $test = $this->smodel->masterdml($editDetails, $keyLabel, $key,$result);    

        //load css and js files
        $this->amodel->loadjsscript(array( 'jquery.validate', 'jquery.dropdownPlain', 'address'));
        $formElement = $this->smodel->loadFormelements($keyLabel); 

               $auth_link = array(     array('settings','search','Search','Settings/masterdata/'.base64_encode($key)) ); 
               //print_r($formElement);
        $data['masterdata_addform'] = form(create_form($formElement, $editDetails, $key), $formElement, 'master_name', 'Settings/masterdata','add-,- '.$keyLabel, $auth_link, $key, base_url());

        // add breadcrumbs
                $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
                $this->breadcrumbs->push('Master Data', 'Settings/masterdata');
                 $this->breadcrumbs->push('Add Master Data', 'Settings/masterdataadd');
                // unshift crumb

                // output
                $data['breadcrumb']=$this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'add_master_data'); 
    }

    function masterdatacommonview() {
        $this->_check_featureauth ( 'settings', 'view' ); // Check if user is allowed for action
                $this->amodel->loadcssScript(array('jquery-ui-1.10.4'));
        $this->amodel->loadjsscript(array( 'jquery.dropdownPlain'));
        //get url parameters
        $id = base64_decode($this->uri->segment(3)); 
        $College_key = base64_decode($this->uri->segment(4)); 

      if($College_key == "institutions"){
            $details = $this->amodel->getDetails(DB_PREFIX . "institutions", array('*'), array('id' => $id));
            //print_r($details);
          //   $details = $this->smodel->getdropdowndetails($id,$College_key);
       }else
       {
            $masterview= $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('*'), array('id' => $id));
             $details = $this->smodel->getdropdowndetails($id,$masterview[0]['key']);

       }
        //$masterview= $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('*'), array('id' => $id));
            // $details = $this->smodel->getdropdowndetails($id,$masterview[0]['key']);
   
        //commonview layout
        
        
        switch( $details[0]['key1'] ){ 
                case 'State':
                $header_name = array(array('name' => 'name', 'insurer' => 'country', 'status' => 'status'));                        
                break;
                case 'City':
                $header_name = array(array('name' => 'name', 'insurer' => 'state', 'status' => 'status'));              
                break;
                case 'University':
                $header_name = array(array('name' => 'name', 'insurer' =>'city', 'status' => 'status')); 
                break;
                case 'Police_Station':
                $header_name = array(array('name' => 'name', 'insurer' =>'city', 'status' => 'status')); 
                break;
                case 'contact_for':
                $header_name = array(array('name' => 'contact_for', 'insurer' =>'department', 'status' => 'status')); 
                break;
                
                case 'status' :
                $header_name = array(array('name' => 'name', 'status' => 'status','check_name' => 'check_name'));
                break;

                default: 
                $header_name = array(array('name' => 'name', 'status' => 'status'));
                break;
        }
                
        if($College_key == "institutions"){        
        
        $auth_link = array(     array('settings','search','Search','Settings/masterdata',''),
            array('settings','edit','Modify','Settings/masterdataadd/'.$this->uri->segment(3).'/'.$this->uri->segment(4),'')
            
            
          );
    }else{
        $auth_link = array(     array('settings','search','Search','Settings/masterdata',''),
         array('settings','edit','Modify','Settings/masterdataadd/'.$this->uri->segment(3) .'/'.$this->uri->segment(4),'')
         );
    }
          $data['keyLabel'] = implode(' ', explode('_',$details[0]['key1']) )." Details";
        $data['settings_viewform'] = commonview($details,$header_name, 'master_data_commonview', base_url() . "Settings/masterdata", $auth_link);
         // add breadcrumbs
                $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
                $this->breadcrumbs->push('Master Data', 'Settings/masterdata');
                 $this->breadcrumbs->push('Master Data View', 'Settings/masterdatacommonview');
                // unshift crumb

                // output
                $data['breadcrumb']=$this->breadcrumbs->show();
        //render the views
        $this->amodel->pagerender($data, 'master_data_commonview');
    }
    //Master data cannot be deleted as they have status set to active or inactive
    
        function checklevel_status()
        {
                $lists=array();
                $this->amodel->loadjsscript(array( 'jquery.validate', 'pagination', 'jquery.dropdownPlain','jquery-ui-1.8.16.custom.min'));
                $data['status']=$this->smodel->load_status_by_client(0,'status');
                $data['checks']=$this->smodel->load_status_by_client(0,'Check');
                $this->amodel->pagerender($data, 'add_status_checklist'); 
        }
        function savestatus()
        {
               $batch=array();
                $formStatus=$_POST;
                if(empty($formStatus))
                {
                        $this->session->set_userdata('error','Please select the status againest check');
                        redirect('Settings/checklevel_status');
                }
                
                $this->db->empty_table(DB_PREFIX .'check_status');
                
                foreach($formStatus as $key=>$status)
                {
                        foreach($status as $keys=>$value)
                        {
                        $save['check_id']=$key;
                        $save['status_id']=$value;
                       $batch[]= $save;
                        
                        }
                
                }
                
                $this->db->insert_batch(DB_PREFIX .'check_status',$batch);
               redirect('Settings/checklevel_status');
        
        
        }

        function check_declaration()
        {
       // echo 'hgifdo';
            if(!empty($_POST) && empty($_POST['id'])) { 
        
                $this->db->where('organization',$_POST['organization']);
                $this->db->where('parent_office_id',$_POST['parent_office']);
                $this->db->where('office_id',$_POST['office_id']);
                $this->db->where('sub_office',$_POST['sub_office']);
                $this->db->where('declaration_type',$_POST['declaration_type']);
                $result=$this->db->get(DB_PREFIX .'company_decl')->row_array();
            }
            echo ($result) ?   1 : 0;
        }


        function get_declarationtype()
        {
            //print_r($_POST);exit;
            
            if(!empty($_POST) && empty($_POST['id'])) { 
                
                $this->db->where('organization',$_POST['organization']);
                $this->db->where('parent_office_id',$_POST['parent_office']);
                $this->db->where('office_id',$_POST['office_id']);
                $this->db->where('sub_office',$_POST['sub_office']);
                $result=$this->db->get(DB_PREFIX .'company_decl')->row_array();
            }
            echo ($result) ? $result['doc_type'] : 0;
        }

        function updateDoctype()
        {
               // echo 'hgifdo'; 
            //print_r($_POST);
            
            if(!empty($_POST) && !empty($_POST['id'])) { 
                
                $this->db->set('doc_type', $_POST['doc_type']);
                $this->db->where('organization',$_POST['organization']);
                $this->db->where('parent_office_id',$_POST['parent_office']);
                $this->db->where('office_id',$_POST['office_id']);
                $this->db->where('sub_office',$_POST['sub_office']);
                $this->db->update(DB_PREFIX .'company_decl');
            }
          
        }

        /* Master holiday lists */
        function masterholidays()
        {
            $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
            $this->amodel->loadjsscript(array( 'jquery.validate','jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min','commonjs','jquery-ui-1.8.16.custom.min'));
            
            // add breadcrumbs
                    $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
                    $this->breadcrumbs->push('Master holidays', 'Settings/master_holidays');
                     
                    // unshift crumb

                    // output
                    $data['breadcrumb']=$this->breadcrumbs->show();
            $this->amodel->pagerender($data, 'masterholidays'); 
        }
    /* Listing holidays list*/
    function get_masterholidays(){
        $model = array('Settings_model'=>'get_masterholidays');
        $description = ($_REQUEST['description']) ? $_REQUEST['description'] : '';
        $h_date = ($_REQUEST['h_date']) ? $_REQUEST['h_date'] : '';
        if($description)
        $condition[]=" a.description like '%".$description."%'";

        if($h_date)
        $condition[]=" DATE_FORMAT(a.holiday_date ,'%Y-%m-%d') = '".date('Y-m-d',strtotime($h_date))."'";

        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);

        $response = $results[0];  $result = $results[1]; 
        
           if ($result) {
           $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
           
        foreach ( $result as $i => $row ) {


        $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['description'],date('d-m-Y',strtotime($row['holiday_date'])),anchor('/Settings/create_holiday/'.base64_encode($row['id']),'Modify'));

        }
        }
        echo json_encode($response);
        }

        function create_holiday()
        {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.validate','jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min','commonjs','jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Master holidays', 'Settings/master_holidays');
        $data['breadcrumb']=$this->breadcrumbs->show();
        $id = base64_decode($this->uri->segment(3)); 
         $details = $this->amodel->getDetails('dcode_master_holidays',array('id','description','DATE_FORMAT(holiday_date, "%d-%m-%Y") as holiday_date','status'),array('id'=>$id));
        $data['holidaylist']=$details[0]; 
        $this->amodel->pagerender($data, 'create_holiday'); 
        }

        function save_masterholidays(){
          //  print_r($this->session->userdata('userid')); exit;
            $post=$_POST;
            $save=array();
            $save['description']=$post['description'];
            $save['holiday_date']=date('Y-m-d',strtotime($post['holiday_date']));
            $save['status']=$post['status'];
            if(empty($post['id']))
            {
                $save['created_by']=$this->session->userdata('userid');
                $save['created_on']=date('Y-m-d H:i:s');
                $this->db->insert('dcode_master_holidays',$save);
            }
            else
            {
                $save['updated_by']=$this->session->userdata('userid');
                $this->db->where('id',$post['id']);
                $this->db->update('dcode_master_holidays',$save);
            }   
            redirect('Settings/masterholidays');  
        }


    //************** Organization not active View Page ************/
    function organization_not_active() { 
        
        $this->_check_featureauth ( 'organisation', 'search' ); 
        $formElement = array(array('cn-org_name' => array('text', 'org_name', 'L|max:25|min:1|Z', '', '', ''), 'eq-user_type' => array('dropdown', 'user_type', 'max:25|min:1|Z', '', $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_usertype", array('id', 'name'), array('key' => 'user_types')), '')));
        $data['formelements'] = create_searchform($formElement);
        
        $header_name = array('org_name' => 'org_name', 'user_type' => 'user_type');
        $values = pagination($this->mm->getorganisationList('', 'count', array('user_type')), uri_string());
        $data['pages'] = $pages = $values[1];
        $data['table_header'] = table_view($header_name, $this->mm->getorganisationList($values[0], '', $header_name), base_url() . 'Settings/organization_not_active', '');
        $data['org_data'] = $this->mm->getorganisationListed();
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Organization', 'Settings/organization_not_active');
        $data['breadcrumb']=$this->breadcrumbs->show();  
        $this->amodel->pagerender($data, 'organization_not_active');
    }


    //*************** Listing of Organization Not Active **********************/
    function get_organization_notactive() {  
         $model = array('Settings_model'=>'get_organizationListed');
        // if($_REQUEST['t_date']){
        //     $condition[]="DATE_FORMAT(a.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($_REQUEST['t_date']))."'";
        // }
             
 
        if($_REQUEST['a_date']){
          // $condition[]="DATE_FORMAT(b.case_recieved_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($_REQUEST['a_date']))."' AND DATE_FORMAT(b.case_accepted_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($_REQUEST['a_date']))."' AND DATE_FORMAT(b.max_created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($_REQUEST['a_date']))."'";

            $condition[]="a.id NOT IN (SELECT organisation FROM dcode_client_request WHERE DATE_FORMAT(b.max_created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($_REQUEST['a_date']))."')";
        }
        if($_REQUEST['org_status']){
            $condition[]=" a.org_status like '%".$_REQUEST['org_status']."%'";
        }
       
        $manual_cond=implode(' and ',(array)$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0]; 
        $result = $results[1]; 
        if ($result) { 
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
    // echo '<pre>';print_r($result);exit;        
            foreach ( $result as $i => $row ) {
            
                $org_status=($row['org_status']==1)?'Active':'Deactive';

                $MinAcceptedDate='';
                $MinReceivedDate='';
                if($row['dataentry_by']==3 && $row['mincase_recieved_date']!="0000-00-00" && !empty($row['mincase_recieved_date']))
                {
                    $MinReceivedDate=date('d-m-Y ',strtotime($row['mincase_recieved_date']));
                }
                else if($row['dataentry_by']!=3 && $row['mincase_accepted_date']!="0000-00-00 00:00:00" && !empty($row['mincase_accepted_date']))
                {
                    $MinAcceptedDate=date('d-m-Y',strtotime($row['mincase_accepted_date']));
                }  
                   
                $AcceptedDate='';
                $ReceivedDate='';
                if($row['dataentry_by']==3 && $row['case_recieved_date']!="0000-00-00" && !empty($row['case_recieved_date']) ){
                        $case_recieved_date =date('d-m-Y ',strtotime($row['case_recieved_date'])); 
                         $created_on = date('d-m-Y ',strtotime($row['created_on']));
                                  
                         $lastcasereceived_date =  ($case_recieved_date >$created_on) ? $case_recieved_date :  $created_on ;
                  
                  $ReceivedDate=$lastcasereceived_date;
                }  
                else if($row['dataentry_by']!=3 && $row['case_accepted_date']!="0000-00-00 00:00:00" && !empty($row['case_accepted_date']))
                {
                    $AcceptedDate=date('d-m-Y',strtotime($row['case_accepted_date']));
                }
                if($row['max_created_on']){
                    $createdOn=date('d-m-Y',strtotime($row['max_created_on']));
                }else{
                    $createdOn='';
                }
                       
                $response->rows [] ['cell'] = array ( $i+$count+1,$row['org_name'],$org_status,$createdOn,$MinReceivedDate,$MinAcceptedDate,$ReceivedDate,$AcceptedDate);
            }
        }
        echo json_encode ($response);

        }
       
// ****************Audit Trail*****************************************//

function audit_trail(){
      
      $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min','commonjs','jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
                $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
                $this->breadcrumbs->push('Audit Trail','Audit Trail');
               
                // unshift crumb

                // output
       $data['breadcrumb']=$this->breadcrumbs->show();
         

        $this->amodel->pagerender($data,'audit_trail');
    }
        
function get_audit_trail() {
      
       
        $model = array('Settings_model'=>'getaudit_trailModel');

        
       $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : ''; 
       $check_id = ($_REQUEST['check_id']) ? $_REQUEST['check_id'] : '';
       $user_id = ($_REQUEST['user_id']) ? $_REQUEST['user_id'] : ''; 
       $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : ''; 
       $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : ''; 
       $role_id = ($_REQUEST['role_id']) ? $_REQUEST['role_id'] : ''; 
       $one = str_split($check_id,3);
       $check= $one[0];
       $chk_count =$one[1];
    
           
        if(!empty($chk_count))
            $condition[]="v.count_of_chk = '".$chk_count."' "; 
        //17/01/2024
        $case_no = trim($case_no);
         if($case_no)
            $condition[]="a.case_no like '%".$case_no."' ";
            
         if(!empty($check))
            $condition[]="a.check_id = '".$check."' ";  

         if(!empty($user_id))
            $condition[]="a.user_id = '".$user_id."' ";      
            
         if(!empty($c_date)){
            $condition[]="DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }   

         if(!empty($t_date)){
            $condition[]="DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        }  
        if(!empty($role_id))
            $condition[]="a.role_id ='".$role_id."' ";  

      if($term)
      {
      //support multiple words
      $search = explode(' ', $term);

      foreach($search as $t) {
      $not        = '';
      $operator    = 'OR';
      if(substr($t,0,1) == '-')
      {
      $not        = 'NOT ';
      $operator    = 'AND';
      //trim the - sign off
      $t        = substr($t,1,strlen($t));
       
      }

       $like    = '';
       $like    .= "( a.case_no ".$not."LIKE '%".$t."%'"; 
       $like    .= $operator." a.check_id ".$not."LIKE '%".$t."%'" ;
       $like    .= $operator." a.count_of_chk ".$not."LIKE '%".$t."%'" ;
       $like    .= $operator." a.role_id ".$not."LIKE '%".$t."%'" ;
       $like    .= $operator." a.date_of_update".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
       $like    .= $operator." a.user_id ".$not."LIKE '%".$t."%' ) " ;
     
        
      $condition[]=$like;
      }
      }
      $manual_cond=implode(' and ',$condition);
      $results = $this->_jqgrid_search($model,$manual_cond); 
      $response = $results[0];  
      $result = $results[1];
      //echo "<pre>"; print_r($result); exit;
      if ($result) {
         $checkteam = $this->config->item('CHECKLIST',APPLICATIONCONFIG);
         $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
         $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
         $page=$page - 1;
         $count=$page * $rows;
         $k=1;
     
   
   $activity_statusArray = array(107 => "Initiated",110=>"Stop Check",111 => "Verified",519=>" Others",992=>"DD Applied",1001 => "Revert to DEO",1002=>"QC Revert Closed",1003=>"Revert to VM",1004=>"Re - Verify",1005=>"Reminder Sent",1006=>"Ticket Re-open",1007=>"Report Published",1008=>"QC2 Approved",1110=>"Re - Stop",1011=> "Reopen by Admin", 1012=> "Reopen by CRM",1013=> "Reopen by QC2",1591=>"Re - Others");

   foreach( $result as $i => $row ) {
             
         $status ="";
         $status_id = $row['check_status'];
         $status   = $activity_statusArray[$status_id];
               

            if($row['count_of_chk']==0){
            $chkval=$row['name'];
             }
            else{
            $chkval=$row['name'].$row['count_of_chk'];
             }
            $activity_date = date('d-m-Y h:i:s',strtotime($row['updateddate']));
            $inter = ''; 
            if($row['check_status'] == 1007){
                
                                 if($row['f_report']== 1){

                    if($row['supplementary']!= 3)
                    {
                        $inter= "Final"; 
                    }

                    else{
                        if($row['updateddate']<$row['supplement_published_date'])
                            $inter= "Final"; 
                          else
                            $inter= "Supplementary"; 
                     }

                   
                }
                else{
                    $inter = "Interim";
                }

              
            }
       
          
if($row['origin'] == 1)
         {
            $origin = "1";
         }
            
            else{

                $origin = " ";
            }

          
             if($row['check_status'] == 1007){
            if($row['report_flag'] == 0){
                $flag_val = "Interim";
            }
            elseif($row['report_flag'] == 1){
                $flag_val = "Final";
            }
            elseif($row['report_flag'] == 3){
                $flag_val = "Supplementary";
            }
             }
         
          else{
            $flag_val = " ";
          }


            if(!empty($row['published_date']))
            $published_date = date('d-m-Y h:i:s',strtotime( $row['published_date']));
            else
             $published_date = " ";   
              
 $response->rows[$i]['cell'] = array ($i+$count+1,$row['case_no'],$chkval,$status,$activity_date,$row['vname'],$row['role_name'],$flag_val,$published_date,$inter,$origin);
            
               
                  
              } 
              
             echo json_encode($response);

        
        }
       
    }
  

function export_audit_trail() {

          
      $model = array('Settings_model'=>'export_audit_trail');
      $case_no = ($_POST['exp_case_no']) ? $_POST['exp_case_no'] : '';
      $check_id = ($_POST['exp_check_id']) ? $_POST['exp_check_id'] : '';
       $user_id = ($_POST['exp_user_id']) ? $_POST['exp_user_id'] : ''; 
       $c_date = ($_POST['exp_c_date']) ? $_POST['exp_c_date'] : ''; 
       $t_date = ($_POST['exp_t_date']) ? $_POST['exp_t_date'] : '';
       $role_id = ($_REQUEST['exp_role_id']) ? $_REQUEST['exp_role_id'] : ''; 
       
       $one = str_split($check_id,3);
       $check= $one[0];
       $chk_count = $one[1];
    
          if(!empty($role_id))
            $condition[]="a.role_id ='".$role_id."' ";   
        if(!empty($chk_count))
            $condition[]="v.count_of_chk = '".$chk_count."' "; 
         //17/01/2024
        $case_no = trim($case_no);
         if($case_no)
            $condition[]="a.case_no like '%".$case_no."' ";
            
         if(!empty($check_id))
            $condition[]="a.check_id ='".$check_id."' ";  

         if(!empty($user_id))
            $condition[]="a.user_id ='".$user_id."' ";      
            
         if(!empty($c_date)){
            $condition[]="DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
        }   

         if(!empty($t_date)){
            $condition[]="DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        } 
         
        
        if(!empty($role_id))
            $condition[]="a.role_id ='".$role_id."' ";      
            
            
            

      if($term)
      {
      //support multiple words
      $search = explode(' ', $term);

      foreach($search as $t) {
      $not        = '';
      $operator    = 'OR';
      if(substr($t,0,1) == '-')
      {
      $not        = 'NOT ';
      $operator    = 'AND';
      //trim the - sign off
      $t        = substr($t,1,strlen($t));
       
      }
       $like    = '';
       $like    .= "( a.case_no ".$not."LIKE '%".$t."%'"; 
       $like    .= $operator." a.check_id ".$not."LIKE '%".$t."%'" ;
       $like    .= $operator." a.count_of_chk ".$not."LIKE '%".$t."%'" ;
       $like    .= $operator." a.role_id ".$not."LIKE '%".$t."%'" ;
       $like    .= $operator." a.date_of_update".$not." LIKE '%".date('Y-m-d',strtotime($t))."%' " ;
       $like    .= $operator." a.user_id ".$not."LIKE '%".$t."%' ) " ;
     
        
      $condition[]=$like;
      }
      }
      $manual_cond=implode(' and ',$condition);
      $results = $this->_jqgrid_search($model,$manual_cond); 
      $response = $results[0];  
      $result = $results[1];
      
      if ($result) {

         $checkteam = $this->config->item('CHECKLIST',APPLICATIONCONFIG);
         $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
         $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
         $page=$page - 1;
         $count=$page * $rows;
         $k=1;
         $objPHPExcel = new PHPExcel();
         $objPHPExcel->setActiveSheetIndex(0);
         $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
         $objPHPExcel->getActiveSheet()->setCellValue('B1', "Case Number");
         $objPHPExcel->getActiveSheet()->setCellValue('C1', "Check Name");
         $objPHPExcel->getActiveSheet()->setCellValue('D1', "Activity");
         $objPHPExcel->getActiveSheet()->setCellValue('E1', "Activity Date");
         $objPHPExcel->getActiveSheet()->setCellValue('F1', "User");
         $objPHPExcel->getActiveSheet()->setCellValue('G1', "Role");
         $objPHPExcel->getActiveSheet()->setCellValue('H1', "Report Type");
         $objPHPExcel->getActiveSheet()->setCellValue('I1', "Published Date");
         $objPHPExcel->getActiveSheet()->setCellValue('J1', "Report");
         $objPHPExcel->getActiveSheet()->setCellValue('K1', "Origin");
         $ci=2;

     $activity_statusArray = array(107 => "Initiated",110=>"Stop Check",111 => "Verified",519=>" Others",992=>"DD Applied",1001 => "Revert to DEO",1002=>"QC Revert Closed",1003=>"Revert to VM",1004=>"Re - Verify",1005=>"Reminder Sent",1006=>"Ticket Re-open",1007=>"Report Published",1008=>"QC2 Approved",1110=>"Re - Stop",1011=> "Reopen by Admin", 1012=> "Reopen by CRM",1013=> "Reopen by QC2",1591=>"Re - Others");

   foreach( $result as $i => $row ) {
          
         $status ="";
        $status_id = $row['check_status'];
        $status = $activity_statusArray[$status_id];  
              

            if($row['count_of_chk']==0){
            $chkval=$row['name'];
            }
            
            else{
            $chkval=$row['name'].$row['count_of_chk'];
             
            }

            $activity_date = date('d-m-Y h:i:s',strtotime($row['updateddate']));
            $inter = ''; 
            if($row['check_status'] == 1007){
                
                                 if($row['f_report']== 1){

                    if($row['supplementary']!= 3)
                    {
                        $inter= "Final"; 
                    }

                    else{
                        if($row['updateddate']<$row['supplement_published_date'])
                            $inter= "Final"; 
                          else
                            $inter= "Supplementary"; 
                     }

                   
                }
                else{
                    $inter = "Interim";
                }

              
            }


                if($row['origin'] == 1)
         {
            $origin = "1";
         }
            
            else{

                $origin = " ";
            }

         if($row['check_status'] == 1007){
            if($row['report_flag'] == 0){
                $flag_val = "Interim";
            }
            elseif($row['report_flag'] == 1){
                $flag_val = "Final";
            }
            elseif($row['report_flag'] == 3){
                $flag_val = "Supplementary";
            }
             }
         
          else{
            $flag_val = " ";
          }


            if(!empty($row['published_date']))
            $published_date = date('d-m-Y h:i:s',strtotime( $row['published_date']));
            else
             $published_date = " ";

 $objPHPExcel->getActiveSheet()->getStyle('A1:K1')->getFont()->setBold(true);
 $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                                  ->setCellValue('B' . $ci, $row['case_no'])
                                  ->setCellValue('C' . $ci, $chkval)
                                  ->setCellValue('D' . $ci, $status)
                                  ->setCellValue('E' . $ci, $activity_date)
                                  ->setCellValue('F' . $ci, $row['vname'])
                                  ->setCellValue('G' . $ci, $row['role_name'])
                                  ->setCellValue('H' . $ci, $flag_val)
                                  ->setCellValue('I' . $ci, $published_date)
                                  ->setCellValue('J' . $ci, $inter)
                                  ->setCellValue('K' . $ci, $origin);
                                    
                                
            $ci++;
         }
         $this->export_excel('A','K','Audit_Trail_List_',$objPHPExcel);
         exit; 
              

        
        }
       
    }

function get_checkname(){
        
    $case_no=$_POST['case_no'];
    //17/01/2024
    $case_no = trim($case_no);         
    $request_id  = $this->smodel->get_requestid($case_no); 
              
     $U_check = $this->smodel->get_checkname($request_id[0]['request_id']);
      
            $html="<option value=".'0'.">Select Check </option>";
            foreach($U_check as $checks) {
                if($checks['count_of_chk'] == 0){
                    $chk_count = '';
                }
                else{
                   $chk_count = $checks['count_of_chk'];  
                }

                $html.="<option  name='check_id' id='check_id' value=".$checks['check_id'].'+'.$chk_count.">".$checks['checkname'].$chk_count."
            </option>";
            }
             echo $html; 
 
    }
function get_username(){
    
  
    $case_no=$_POST['case_no'];

    //17/01/2024
    $case_no = trim($case_no);

     $U_user = $this->smodel->get_username($case_no);
       
           
            $html= "<option value=".'0'.">Select User </option>";
            foreach($U_user as $users) {
                $html.="<option  name='user_id' id='user_id' value=".$users['user_id'].">".$users['vname']."
            </option>";

            
            }
             echo $html; 
}    



function get_rolename(){
  
    $case_no=$_POST['case_no'];

    //17/01/2024
    $case_no = trim($case_no);  
     $U_role = $this->smodel->get_rolename($case_no);
       
           
            $html= "<option value=".'0'.">Select Role </option>";
            foreach($U_role as $users) {
                $html.="<option  name='role_id' id='role_id' value=".$users['role_id'].">".$users['rolename']."
            </option>";

            
            }
             echo $html; 
}  

// ****************End Audit Trail*****************************************//

}
