<?php if (!defined('BASEPATH')) 
{
    exit('No direct script access allowed');
}
require_once ('Common.php');
require_once ('./PHPExcel-1.8/Classes/PHPExcel.php'); // Needed for export to xls to work

class TAT extends Common {
    protected $index_dashboard= 'Index/dashboard';

    //constructor
    function __construct() 
    {
        parent::__construct();
        $this->_check_userlogin();
        $models = array('TAT_model'=>'tm','Verification_model'=>'vm', 'Activity_model'=>'am');
        foreach ($models as $file => $object_name) {
            $this->load->model($file, $object_name);
        }
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','jquery-ui-1.10.4','highcharts','exporting','jquery.validate','grid.locale-en','jquery.jqGrid.min','jquery-ui-1.8.16.custom.min','commonjs'));
        $this->load->helper('text');
    }

    /*
     * generate_TAT ==> Shows generate TAT view page
     */

    function generate_TAT() { 

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('TAT', 'TAT/generate_TAT');
        $data['breadcrumb']=$this->breadcrumbs->show();  
        $data['organization'] = $organization=$this->amodel->getDetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('id !=' => 1,'org_status'=>1),  "org_name"); 
  
        $this->amodel->pagerender($data, 'generate_TAT');
    }

     /*
     * list_TAT ==> Shows list TAT view page
     */
    function list_TAT() { 

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('TAT Analysis', 'TAT/list_TAT');
        $data['breadcrumb']=$this->breadcrumbs->show();  
        $data['organization'] = $organization=$this->amodel->getDetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('id !=' => 1,'org_status'=>1),  "org_name"); 

        $poffice=implode(",", $this->session->userdata['poffice'] );
        $boffice=implode(",", $this->session->userdata['boffice'] );
        $soffice=implode(",", $this->session->userdata['soffice'] );

        $orderdetails=$this->dmodel->get_orderdetails($poffice,$boffice,$soffice);
        foreach ($orderdetails as $ckey => $cvalue) {
            if(!empty($cvalue['chkname'])){
                $chkdetails[$cvalue['chkid']]=$cvalue['chkname'];
            }
        }
        $data['chkdetails']=$chkdetails;
  
        $this->amodel->pagerender($data, 'list_TAT');
    }

    /*
     * save_TAT ==> generate_TAT() in turn calls this save_TAT for
     * creating TAT data and either creating or updating TAT records in
     * dcode_tat_checks table
     */
    function save_TAT()
    { 
        $from_date=$_POST['c_date'];
        $to_date=$_POST['t_date'];
        $org_id=$_POST['org_id'];
        $date_filter=$_POST['date_filter'];       

        if(!empty($from_date) && $date_filter==1)
        {
            $condition[]="DATE_FORMAT(a.case_accepted_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."'";
        }
        if(!empty($to_date) && $date_filter==1)
        {
            $condition[]="DATE_FORMAT(a.case_accepted_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."'";  
        }

        if($org_id)
        {
            $condition[]=" c.id = ".$org_id;
        }

        $manual_cond=implode(' and ',$condition); 

        $result_data = $this->tm->get_info_for_computation_of_TAT($manual_cond);

        $bulk_tat_save = array();

        

        foreach ( $result_data as $i => $row ) 
        {

            $published_date = array();

            $report_type = "";
            $to_date_src_tbl = '';
            $TAT_days = 0;
            $rep_published_date = '';
            $final_rep  = 0;

            /*
             * 1) if supplemetary  == 0
             *   Straight away take  all  qc2_dates

             * 2) if  supplementary  > 0

             *      if the report is  final
	         *      take date from  finalreport published  date of  client_request if available
	         *       if  not  available
		     *      check if  finalreportpublished has  any records
			 *           if yes,
			 *	            take  frd from  finalreportpublished table
					
		     *       if finalreportpublished does nothave  any records
		     *        take qc2_date
             */

            // if check has NOT been reopened, use qc2_dates as report published date
            if($row['supplementary'] == 0)
            {
                $startdate=(date('d-m-Y',strtotime($row['startdate']))) ? date('d-m-Y',strtotime($row['startdate'])) : '';
                $rep_published_date = $row['intpublishdate']; 
                $published_date['published_date'] = $rep_published_date;
                $finalpublishdate=(date('d-m-Y',strtotime($row['intpublishdate']))) ? date('d-m-Y',strtotime($row['intpublishdate'])) : '';
                $TAT_days = $this->compute_working_days($startdate, $finalpublishdate, $considerHolidays=0);
                $to_date_src_tbl = 'vl.qc2_date';

            }

            // if check has been reopened
            if($row['supplementary'] > 0)
            {
                $startdate=(date('d-m-Y',strtotime($row['startdate']))) ? date('d-m-Y',strtotime($row['startdate'])) : '';
                
                $status_update_arr = $this->tm->get_first_report_published_date_from_status_updates($row['request_id'],$row['check_id'],$row['level_id']);
                
                if($row['f_report'] == 1)
                {
                    if(!empty($row['final_report_published_date']))
                    {
                        $intpublishdate=(date('d-m-Y',strtotime($row['final_report_published_date']))) ? date('d-m-Y',strtotime($row['final_report_published_date'])) : '';
                        $rep_published_date = $row['final_report_published_date'];
                        $to_date_src_tbl = 'cr.final_report_published_date';

                        $TAT_days = $this->compute_working_days($startdate, $intpublishdate, $considerHolidays=0);
                        $final_rep  = 1;
                    }
                    else
                    {
                        $final_rep_exists = $this->tm->get_final_report_published_dates($row['request_id']);
                        
                        if(!empty($final_rep_exists['published_date']))
                        {
                            $intpublishdate=(date('d-m-Y',strtotime($final_rep_exists['published_date']))) ? date('d-m-Y',strtotime($final_rep_exists['published_date'])) : '';
                            $rep_published_date = $final_rep_exists['published_date'];
                            $to_date_src_tbl = 'fr.published_date';

                            $TAT_days = $this->compute_working_days($startdate, $intpublishdate, $considerHolidays=0);
                        }
                        else
                        {
                            $intpublishdate=(date('d-m-Y',strtotime($row['intpublishdate']))) ? date('d-m-Y',strtotime($row['intpublishdate'])) : '';
                            $rep_published_date = $row['intpublishdate'];
                            $to_date_src_tbl = 'vl.qc2_date';
                            $TAT_days = $this->compute_working_days($startdate, $intpublishdate, $considerHolidays=0);
                        }
                    }
                }
                else
                {
                    $final_rep_exists = $this->tm->get_final_report_published_dates($row['request_id']);
                    if(empty($final_rep_exists))
                    {
                        if(empty($row['final_report_published_date']) || ($row['intpublishdate'] <= $row['final_report_published_date']  ))
                        {
                            $intpublishdate=(date('d-m-Y',strtotime($row['intpublishdate']))) ? date('d-m-Y',strtotime($row['intpublishdate'])) : '';
                            $rep_published_date = $row['intpublishdate'];
                            $to_date_src_tbl = 'vl.qc2_date';
                            $TAT_days = $this->compute_working_days($startdate, $intpublishdate, $considerHolidays=0);
                        }
                    }
                }
                // if status update array has data and report published date is empty
                // take date 
                if(!empty($status_update_arr))
                {
                    if($final_rep == 0)
                    {
                        if(empty($rep_published_date) ||  $rep_published_date == '')
                        {
                            $intpublishdate=(date('d-m-Y',strtotime($status_update_arr['date_of_update']))) ? date('d-m-Y',strtotime($status_update_arr['date_of_update'])) : '';
                            $rep_published_date = $status_update_arr['date_of_update'];
                            $to_date_src_tbl = 'st.date_of_update';

                            $TAT_days = $this->compute_working_days($startdate, $intpublishdate, $considerHolidays=0);
                    
                        }
                    }
                }
                
            }   
            $published_date['published_date'] = $rep_published_date;

            if($row['f_report'] == 1)
            {
                $report_type = "final";
            }
            else
            {
                $report_type = "interim";
            }

            if(!empty($rep_published_date) ||  $rep_published_date != '')
            {
                $ticket_details = $this->tm->get_ticket_details($row['request_id'],$row['check_id'],$row['level_id'], $rep_published_date);

                $ticket_id = NULL;
                $wait_days = 0;
                $total_wait_days = 0;
                $prev_requested_date = '0000-00-00 00:00:00';
                
                if(!empty($ticket_details))
                {
                    foreach($ticket_details as $t_d)
                    {
                        if($t_d['ticket_status'] != 101)
                            {
                                $prev_requested_date = $t_d['requested_date'];
                            }
                        if($t_d['ticket_status'] == 101 && $prev_requested_date != '0000-00-00 00:00:00')
                        {
                            $wait_days = $this->compute_working_days($prev_requested_date, $t_d['close_date'], 0);
                            $total_wait_days += $wait_days;

                            $prev_requested_date = '0000-00-00 00:00:00';
                        }
                        $ticket_id = $t_d['ticket_no'];
                    }
                }
            }
        

            $org_id = ($row['organisation']) ? $row['organisation'] : 0;
            $check_id = $row['check_id'];
            $tat_sla_arr = $this->tm->get_customer_sla($org_id, $check_id);
            if(empty($tat_sla_arr))
                $tat_sla_arr = $this->tm->get_customer_sla(0, $check_id);
            $tat_sla = $tat_sla_arr['check_tat'];

            $tat = $TAT_days-$total_wait_days;;
            if($tat <= 0)
                $tat = 1;

            $sla_status = $tat-$tat_sla;

            if(!isset($rep_published_date))
            {
                $TAT_days = 0;
            }
            else
            {
                if($TAT_days == 0)
                    $TAT_days = 1;

            }


            $tat_exists = $this->tm->check_if_TAT_record_exists($row['request_id'],$row['check_id'],$row['level_id']);

            // form an array of records to insert if TAT table does not have any record for the  given
            // request_id,check_id and level_id
            if(empty($tat_exists)) 
            { 
                $arr_insert_tat['request_id'] = $row['request_id'];
                $arr_insert_tat['case_no'] = $row['case_no'];
                $arr_insert_tat['check_id'] = $row['check_id'];
                $arr_insert_tat['level_id'] = $row['level_id'];
                $arr_insert_tat['tat_overall'] = $TAT_days;
                $arr_insert_tat['from_date'] = $row['startdate'];
                $arr_insert_tat['to_date'] = $published_date['published_date'];
                $arr_insert_tat['to_date_source'] = $to_date_src_tbl;
                $arr_insert_tat['report_type'] = $report_type;
                $arr_insert_tat['wait_ticket'] = $total_wait_days;
                $arr_insert_tat['sla_status'] = $sla_status ;
                $arr_insert_tat['wait_ticket_ids'] = $ticket_id ;
                $arr_insert_tat['created_date'] = date('Y-m-d H:i:s'); // arr_insert_tat
                $arr_insert_tat['updated_date'] = date('Y-m-d H:i:s');
                
                $bulk_tat_save[] = $arr_insert_tat;
            }
            else //  update TAT record for this particular request_id,check_id and level_id
            {
                $arr_update_tat['tat_overall'] = $TAT_days;
                $arr_update_tat['from_date'] = $row['startdate'];
                $arr_update_tat['to_date'] = $published_date['published_date'];
                $arr_update_tat['to_date_source'] = $to_date_src_tbl;
                $arr_update_tat['report_type'] = $report_type;
                $arr_update_tat['wait_ticket'] = $total_wait_days;
                $arr_update_tat['sla_status'] = $sla_status ;
                $arr_update_tat['wait_ticket_ids'] = $ticket_id ;
                $arr_update_tat['updated_date'] = date('Y-m-d H:i:s'); // arr_update_tat
                
                $this->tm->update_TAT($row['request_id'],$row['check_id'],$row['level_id'],$arr_update_tat);

            }
            
        }

        // insert records batch wise to TAT table
        if(!empty($bulk_tat_save)) 
        { 
            $bulk_tat_save = $this->security->xss_clean($bulk_tat_save);
            $id = $this->db->insert_batch( DB_PREFIX .'tat_checks', $bulk_tat_save );
        }

        echo '<script language="javascript" type="text/javascript"> 
                        alert("TAT generated successfully!");
                        window.location = "generate_TAT";
                </script>';

    }

    /*
     * get_TAT_list ==> list_TAT() in turn calls this function for
     * listing and filtering TAT data from
     * dcode_tat_checks table
     */
    function get_TAT_list()
    {
        $model = array('TAT_model'=>'get_TAT_list');
        
        $from_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $to_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $date_filter = ($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
        $chk_name = ($_REQUEST['chk_name']) ? $_REQUEST['chk_name'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $sla_status = ($_REQUEST['sla_status']) ? $_REQUEST['sla_status'] : '';

        
        if(!empty($from_date) && $date_filter==1)
        {
            $condition[]=" DATE_FORMAT(tc.from_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."'";
            
        }
        if(!empty($to_date) && $date_filter==1)
        {
            $condition[]=" DATE_FORMAT(tc.from_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."'";
            
        }

        if(!empty($from_date) && $date_filter==2)
        {
            $condition[]=" DATE_FORMAT(tc.to_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."'";
        }

        if(!empty($to_date) && $date_filter==2)
        {
            $condition[]=" DATE_FORMAT(tc.to_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."'";
        }

        if($org_id){
            $condition[]=" c.id = ".$org_id;
        }
        if($case_no){
            $condition[]=" tc.case_no = '".$case_no ."'";
        }
        if($chk_name){
            $condition[]=" tc.check_id = ".$chk_name;
        }
        if($sla_status){
            if($sla_status == 1)
                $condition[]=" tc.sla_status <= 0 ";
            if($sla_status == 2)
                $condition[]=" tc.sla_status > 0 ";
        }

        $manual_cond=implode(' and ',$condition);  
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1];  

        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            $total_interim=0;
            $count1=0;
            foreach ( $result as $i => $row ) {

                $finalpublishdate  = '';
                $startdate=(date('d-m-Y',strtotime($row['from_date']))) ? date('d-m-Y',strtotime($row['from_date'])) : '';
                $finalpublishdate=(date('d-m-Y',strtotime($row['to_date']))) ? date('d-m-Y',strtotime($row['to_date'])) : '';
                $reopen_date=(date('d-m-Y',strtotime($row['reopen_date']))) ? date('d-m-Y',strtotime($row['reopen_date'])) : ''; // MN Aug

                $chknum='';

                $chk_count_arr = $this->tm->get_count_of_chk($row['request_id'], $row['check_id'], $row['level_id']);

                
                if($chk_count_arr['count_of_chk']==0)
                {
                    $chknum='';
                }
                else
                {
                    $chknum=$chk_count_arr['count_of_chk'];
                }
                $wait_days = ($row['wait_ticket']) ? $row['wait_ticket'] : ''; 
                $ticket_ids = ($row['wait_ticket_ids']) ? $row['wait_ticket_ids'] : ''; 
                $org_id = ($row['organisation']) ? $row['organisation'] : 0;
                $check_id = $row['check_id'];
    
                $tat_sla_arr = $this->tm->get_customer_sla($org_id, $check_id);
                if(empty($tat_sla_arr))
                    $tat_sla_arr = $this->tm->get_customer_sla(0, $check_id);
                $tat_sla = $tat_sla_arr['check_tat'];

                $tat = $row['tat_overall']-$row['wait_ticket'];
                if($tat <= 0)
                    $tat = 1;

                $within_sla = $tat-$tat_sla;
                if($within_sla <= 0)
                {
                    $within_sla  = "<span style='color:green;'><b>" . $within_sla  ."</b></span>";
                }
                else
                {
                    $within_sla  = "<span style='color:red;'><b>" . $within_sla  ."</b></span>";
                }

                if($row['to_date'] == '0000-00-00 00:00:00')
                {
                    $finalpublishdate  = '';
                    $row['tat_overall'] ='';
                    $wait_days = '';
                    $tat = '';
                    $within_sla = '';

                }
                // MN Aug
                if(is_null($row['reopen_date']))
                {
                    $reopen_date = '';
                } // MN Aug
                if($finalpublishdate  != '')
                {
                    if($this->session->userdata('userType')==1) 
                    {
                        
                        $response->rows [] ['cell'] = array ( $i+$count+1,  $row['case_no'],$row['candidate_name'],$row['checkname'].' '.$chknum,$startdate,$reopen_date,$finalpublishdate,$row['tat_overall'],$wait_days,$tat,$tat_sla,$within_sla,$row['org_name'],$row['parent_office'],$row['branch_office'],$row['sub_office']); // MN Aug
                    }
                    else
                    {
                        
                        $response->rows [] ['cell'] = array ( $i+$count+1,  $row['case_no'],$row['candidate_name'],$row['checkname'].' '.$chknum,$startdate,$reopen_date,$finalpublishdate,$row['tat_overall'],$wait_days,$tat,$tat_sla,$within_sla,$row['parent_office'],$row['branch_office'],$row['sub_office']); // MN Aug
                    }
                    $count1=$count1+1;
                }
                // $total_interim += $row['tat_overall'];
            }
        }
          echo json_encode($response);
      

    }

    function export_TAT_listing()
    {
        // model name and method name
        $model = array('TAT_model'=>'export_TAT_list');
        $from_date = ($_POST['exp_c_date']) ? $_POST['exp_c_date'] : '';
        $to_date = ($_POST['exp_t_date']) ? $_POST['exp_t_date'] : '';
        $chk_name = ($_POST['exp_chk_name']) ? $_POST['exp_chk_name'] : '';
        $case_no = ($_POST['exp_case_no']) ? $_POST['exp_case_no'] : '';
        $date_filter = ($_POST['exp_date_filter']) ? $_POST['exp_date_filter'] : '';
        $org_id = ($_POST['exp_org_id']) ? $_POST['exp_org_id'] : '';
        $sla_status = ($_POST['exp_sla_status']) ? $_POST['exp_sla_status'] : '';

        if(!empty($from_date) && $date_filter==1)
        {
            $condition[]=" DATE_FORMAT(tc.from_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."'";
        }
        if(!empty($to_date) && $date_filter==1){
            $condition[]="DATE_FORMAT(tc.from_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."'";
        }
        if($org_id){
            $condition[]=" c.id = ".$org_id;
        }
        if($case_no){
            $condition[]=" tc.case_no = '".$case_no ."'";
        }
        if($chk_name){
            $condition[]=" tc.check_id = ".$chk_name;
        }
        if($sla_status){
            if($sla_status == 1)
                $condition[]=" tc.sla_status <= 0 ";
            if($sla_status == 2)
                $condition[]=" tc.sla_status > 0 ";
        }

        if(!empty($from_date) && $date_filter==2)
        {
            $condition[]=" DATE_FORMAT(tc.to_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($from_date))."'";
        }

        if(!empty($to_date) && $date_filter==2)
        {
            $condition[]=" DATE_FORMAT(tc.to_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($to_date))."'";
        }

        $manual_cond=implode(' and ',$condition);  
        $results = $this->_jqgrid_search($model,$manual_cond); 
        $response = $results[0];  
        $result = $results[1];  


        if ($result) {
            $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;

            $objPHPExcel = new PHPExcel(); // Creating an excel object and setting parameters for it.
            $objPHPExcel->setActiveSheetIndex(0);

            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Case Accepted Date'");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Reopened Date"); // MN Aug
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Published Date");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Report published (days)");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Request Raised (days)");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "TAT (days)");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "SLA (days)");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "SLA Status");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "Head Office");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "Branch Office");
            $objPHPExcel->getActiveSheet()->setCellValue('O1', "Sub Office");
           
            $ci=2;
            $total_interim=0;
            
            foreach ( $result as $i => $row ) {

                $startdate=(date('d-m-Y',strtotime($row['from_date']))) ? date('d-m-Y',strtotime($row['from_date'])) : '';
                $finalpublishdate=(date('d-m-Y',strtotime($row['to_date']))) ? date('d-m-Y',strtotime($row['to_date'])) : '';
                $reopendate = (date('d-m-Y',strtotime($row['reopen_date']))) ? date('d-m-Y',strtotime($row['reopen_date'])) : ''; // MN Aug

                $chknum='';
    
                $chk_count_arr = $this->tm->get_count_of_chk($row['request_id'], $row['check_id'], $row['level_id']);

                if($chk_count_arr['count_of_chk']==0)
                {
                    $chknum='';
                }
                else
                {
                    $chknum=$chk_count_arr['count_of_chk'];
                }
                $wait_days = ($row['wait_ticket']) ? $row['wait_ticket'] : ''; 
                $ticket_ids = ($row['wait_ticket_ids']) ? $row['wait_ticket_ids'] : ''; 
                $org_id = ($row['organisation']) ? $row['organisation'] : 0;
                $check_id = $row['check_id'];
                
                $tat_sla_arr = $this->tm->get_customer_sla($org_id, $check_id);
                if(empty($tat_sla_arr))
                    $tat_sla_arr = $this->tm->get_customer_sla(0, $check_id);
                
                $tat_sla = $tat_sla_arr['check_tat'];

                $tat = $row['tat_overall']-$row['wait_ticket'];
                if($tat <= 0)
                    $tat = 1;

                $within_sla = $tat-$tat_sla;
                
                if($row['to_date'] == '0000-00-00 00:00:00')
                {
                    $finalpublishdate  = '';
                    $row['tat_overall'] ='';
                    $wait_days = '';
                    $tat = '';
                    $within_sla = '';

                }
               
                // MN Aug
                if(is_null($row['reopen_date']))
                {
                    $reopendate = '';
                }// MN Aug

                
                if($finalpublishdate  != '')
                {
                    $objPHPExcel->getActiveSheet()->getStyle('A1:O1')->getFont()->setBold(true); // MN Aug
                    $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i+$count+1))
                                      ->setCellValue('B' . $ci, $row['case_no'])
                                      ->setCellValue('C' . $ci, $row['candidate_name'])
                                      ->setCellValue('D' . $ci, $row['checkname'].' '.$chknum)
                                      ->setCellValue('E' . $ci, $startdate)
                                      ->setCellValue('F' . $ci, $reopendate) // MN Aug
                                      ->setCellValue('G' . $ci, $finalpublishdate)
                                      ->setCellValue('H' . $ci, $row['tat_overall'])
                                      ->setCellValue('I' . $ci, $wait_days)
                                      ->setCellValue('J' . $ci, $tat)
                                      ->setCellValue('K' . $ci, $tat_sla)
                                      ->setCellValue('L' . $ci, $within_sla)
                                      ->setCellValue('M' . $ci, $row['parent_office'])
                                      ->setCellValue('N' . $ci, $row['branch_office'])
                                      ->setCellValue('O' . $ci, $row['sub_office']);
                }
                $ci++;                
                $total_interim += $row['tat_overall'];
            }

            // MN Aug
            $this->export_excel('A','O','TAT_List_',$objPHPExcel); // An excel file with abov is created.
            exit; 
        }
          
      
    }

    function call_compute_working_days() {
        $from = '2024-01-24';
        $to =  '2024-01-31';
        echo $days = $this->compute_working_days($from, $to, 0) . ' days';
        // echo $days;
    }


    function compute_working_days($from_date, $to_date, $considerHolidays=0) {
        $workingDays = [1, 2, 3, 4, 5]; # date format = N (1 = Monday, ...)
        
        // If holidays  are considered
        if($considerHolidays == 1)
        {
            $allHolidays=$this->am->get_masterholidays();
            foreach($allHolidays as $holiday)
            {
                $holidayDays[] = $holiday['holiday_date'];
            }
            
        }

        $from = new DateTime($from_date);
        // $from->modify('+1 day');
        $to = new DateTime($to_date);
        $to->modify('+1 day'); //  include even the last date or to calculate inclusive of to date
        
        $interval = new DateInterval('P1D'); //  period of 1 day
        $periods = new DatePeriod($from, $interval, $to); // all days between  the from and to date with an  interval of 1 day


        $days = 0;
        foreach ($periods as $period) {            
            if (!in_array($period->format('N'), $workingDays)) continue;
            if (in_array($period->format('Y-m-d'), $holidayDays)) continue;
            
            $days++;
        }

        //  if difference between dates is greater than 1 then  decrement the days by 1 
        if($days > 1)
        {
            $days =  $days - 1;
        }

        return $days;
    }

    function differenceInHours($startdate,$enddate)
    { 
        $starttimestamp = strtotime($startdate); 
        $endtimestamp = strtotime($enddate); 
        $difference = abs($endtimestamp - $starttimestamp)/3600; 
        return $difference; 
    } 

}