<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require_once('Common.php');
require_once('./PHPExcel-1.8/Classes/PHPExcel.php');

class Verification extends Common
{
    protected $request_orgid = 'org_id';
    protected $request_office = 'office';
    protected $request_parent_office = 'parent_office';
    protected $request_sub_office = 'sub_office';

    function __construct()
    {
        parent::__construct();
        $this->_check_userlogin();
        $models = array('Verification_model' => 'vm', 'Dadmin_model' => 'dm', 'Dataentry_model' => 'dem', 'Reports_model' => 'rm', 'Client_model' => 'cm', 'Verification_report_model' => 'vrm', 'Qualityverification_model' => 'qc', 'Candidate_model' => 'cam', 'TAT_model' => 'tm'); //  MN Jul
        $this->lang->load('Dataentry');
        foreach ($models as $file => $object_name) {
            $this->load->model($file, $object_name);
        }
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'jquery-ui-1.10.4', 'highcharts', 'exporting', 'jquery.validate', 'grid.locale-en', 'jquery.jqGrid.min', 'jquery-ui-1.8.16.custom.min', 'autocomplete', 'multipleclone', 'jquery.datepick'));
        $this->load->helper('text');
    }

    function allotment_list()
    {
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Verification List', 'Verification/allotment_list');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'verification_list');
    }
    function get_alottedlist($office_id = 0)
    {
        $completed = ($_REQUEST['completed']) ? $_REQUEST['completed'] : 0;
        if ($completed == 1) {
            $model = array('Verification_model' => 'get_newuserlistoffsuper');
        } else {
            $model = array('Verification_model' => 'get_userlistoffsuper');
        }

        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $start_date = ($_REQUEST['start_date']) ? $_REQUEST['start_date'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $order_no = ($_REQUEST['order_no']) ? $_REQUEST['order_no'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        if ($office)
            $condition[] = " b.id = " . $office;
        if ($org_id)
            $condition[] = " c.id = " . $org_id;

        if ($parent_office)
            $condition[] = " d.id = " . $parent_office;
        if ($sub_office)
            $condition[] = " o.id = " . $sub_office;

        if ($name)
            $condition[] = " a.candidate_name like '%" . $name . "%'";

        if ($a_status == 1)
            $condition[] = " a.assainee_status =1";

        if ($a_status == 2)
            $condition[] = " a.assainee_status !=1";

        if ($order_no)
            $condition[] = " e.order_name like '%" . $order_no . "%'";

        //17/01/2024
        $case_no = trim($case_no);
        if ($case_no)
            $condition[] = " a.case_no like '%" . $case_no . "'";

        if ($start_date)
            $condition[] = "DATE_FORMAT(a.created_on ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($start_date)) . "'";

        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( a.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " b.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " e.order_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.assainee_status " . $not . "LIKE '%" . $t . "%' ";

                $like    .= $operator . " f.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.dedicated_operator " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " o.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vs.verification_status " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }

        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            $cnt = 0;
            $cnt1 = 0;
            foreach ($result as $cnt => $row) {
                $status = $this->vm->getstatus($row['request_id']);
                if ($status[0]['assignee_status'] == 1) {
                    $chk_status = $this->vm->getchkstatus($row['request_id']);
                    if ($chk_status == 0 && $completed == 1 && $status[0]['vm_revert_vs'] == 1) {
                        $response->rows[$cnt]['cell'] = array($cnt + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], anchor('/Verification/vm_revertview/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']), $row['case_no'], $row['order_name'], anchor('/Verification/vm_revertview/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Revert Assigned'));
                        $cnt++;
                    } else if (($chk_status != 0 || $chk_status == 0) && $completed == 1) {
                        $response->rows[$cnt]['cell'] = array($cnt + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], anchor('/Dadmin/dadminview/' . base64_encode($row['request_id']), $row['candidate_name']), $row['case_no'], $row['order_name'], 'Assigned', anchor('/Verification/assigned_list/' . base64_encode($row['request_id']), "View"));
                        $cnt++;
                    } else if ($chk_status != 0 && $completed == 0) {
                        $response->rows[$cnt1]['cell'] = array($cnt1 + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'],  anchor('/Verification/newverification_request/' . base64_encode($row['request_id']), $row['candidate_name']), $row['case_no'], $row['order_name'], $chk_status . " check not assigned", anchor('/Dadmin/dadminview/' . base64_encode($row['request_id']), " View"));
                        $cnt1++;
                    }
                }
            }
        }
        echo json_encode($response);
    }
    function submitrevert()
    {
        $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['level_id'] =  $level_id = base64_decode($this->uri->segment(4));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $data['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));

        $this->db->select('case_no');
        $this->db->where('request_id', $request_id);
        $CaseNo = $this->db->get(DB_PREFIX . 'client_request')->row_array();

        $save['vm_revert_option_status'] = 1;
        $this->db->where('request_id', $request_id);
        $this->db->update(DB_PREFIX . 'submit_cv', $save);
        $savesval['vm_revert_request'] = 1;
        $savesval['vm_revert_status'] = 1;
        $savesval['vm_revert_to'] = 2;
        $savesval['vm_revert_by'] = $this->session->userdata('userid');
        $savesval['vm_revert_date'] = date('Y-m-d H:i:s');
        $this->db->where('candidate_req_id', $request_id);
        $this->db->where('check_id', $check_id);
        $this->db->where('level_id', $level_id);
        $this->db->where('pack_id', $pack_id);
        $this->db->update(DB_PREFIX . 'ver_assign_rep', $savesval);

        $saves['service'] = $_POST['vm_revert_reason'];
        $saves['reason'] = $_POST['reason'][0];
        $saves = $this->security->xss_clean($saves);
        $this->db->where('request_id', $request_id);
        $this->db->update(DB_PREFIX . 'client_request', $saves);
        $revert_history['request_id'] = $request_id;
        $revert_history['check_id'] = $check_id;
        $revert_history['level_id'] = $level_id;
        $revert_history['reverted_by'] = $this->session->userdata('userid');
        $revert_history['comments'] = $_POST['reason'][0];
        $revert_history['reverted_to'] = $_POST['assignee_id'];
        $revert_history['reverted_date'] = date('y-m-d H:i:s');
        $revert_history['revertreason'] = $_POST['vm_revert_reason'];
        $this->db->insert(DB_PREFIX . 'revert_history', $revert_history);

        /************* Status Updtes ***************/
        $stat_save['request_id'] = $request_id;
        $stat_save['case_no'] = $CaseNo['case_no'];
        $stat_save['check_id'] = $check_id;
        $stat_save['level_id'] = $level_id;
        $stat_save['check_status'] = 1001;
        $stat_save['verified_status'] = '';
        $stat_save['date_of_update'] = date('y-m-d H:i:s');
        $stat_save['role_id'] = $this->session->userdata('role_id');
        $stat_save['user_id'] = $this->session->userdata['userid'];

        $stat_save = $this->security->xss_clean($stat_save);
        $this->db->insert(DB_PREFIX . 'status_updates', $stat_save);
        /****************************************************************/
        redirect(base_url('Verification/allotted_list'), 'refresh');
    }


    function newverification_request()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4'));
        $this->amodel->loadjsscript(array('jquery.validate', 'jquery.dropdownPlain', 'jquery-ui-1.8.16.custom.min'));
        $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
        $operator_id = base64_decode($this->uri->segment(4));
        $candidate_name = $data['checks_result'] = $this->vm->get_userlist($request_id);
        $data['candidate_name'] = $candidate_name[0]['candidate_name'];

        $data['chk_Details'] = $this->vm->getchkDetails($request_id);
        $check_det = $data['checks_det'] = $candidate_name[0];
        $order = $check_det['order_id'];
        $data['check_det'] = $checks = $this->dm->orderdetails($order);
        $data['title'] = 'New Verification Request';
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Verification List', 'Verification/allotment_list');
        $this->breadcrumbs->push('Verification Allotment', 'Verification/newverification_request');
        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'new_request');
    }

    function newbulkverification_request()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'jquery.datepick'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'jquery.datepick', 'jquery.validate', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        $office_list = $this->vm->get_offices();
        $ed_assignee_list = $this->vm->geted_assignee_list();
        $ad_assignee_list = $this->vm->getad_assignee_list();
        $em_assignee_list = $this->vm->getem_assignee_list();
        $data['office_list'] = $this->amodel->filterDropdown($office_list, array('office_id', 'office_name'));
        $data['ed_assignee_list'] = $this->amodel->filterDropdown($ed_assignee_list, array('assignee_id', 'name'));
        $data['ad_assignee_list'] = $this->amodel->filterDropdown($ad_assignee_list, array('assignee_id', 'name'));
        $data['em_assignee_list'] = $this->amodel->filterDropdown($em_assignee_list, array('assignee_id', 'name'));
        $data['title'] = 'New Verification Request';
        $this->amodel->pagerender($data, 'new_request');
    }

    function getuniver()
    {
        $source = $this->uri->segment(3);
        $office = $this->uri->segment(4);
        $key = $this->uri->segment(5);
        $req_id = $this->vm->getalluser($office, $key);
        foreach ($req_id as $req) {
            $candidate_name = $this->vm->candidate_nm($req['req_id']);
            $check_list = $this->vm->checklist($req['req_id']);

            foreach ($candidate_name as $cname) {
                $table .= "<tr class='at_tr' height='35'><td  class='at_td2'><h2>Name:" . ucwords($cname['candidate_name']) . "</h2></td></tr>";
                $table .= "<tr class='at_tr' height='35'>
                                <td  class='at_td1'>Check Name</th>
                                <td  class='at_td1'>Source</th>
                                <td  class='at_td1'>City</th>
				<td  class='at_td1'>Major</th>
				
                           </tr>";
                foreach ($check_list as $list) {

                    $table .= "<tr class='at_tr' height='35'>";
                    if ($source == 1 && $list['check_name'] == "Education") {
                        $table .= "<td  class='at_td'><input type='checkbox' name = 'request_level[]' value = '" . $cname['request_id'] . "_" . $list['check_id'] . "_" . $list['level'] . "' />" . ucwords("Education") . "</td>";
                    }
                    if ($source == 2 && $list['check_name'] == "Employment") {
                        $table .= "<td  class='at_td'><input type='checkbox' name = 'request_level[]' value = '" . $cname['request_id'] . "_" . $list['check_id'] . "_" . $list['level'] . "' />" . ucwords("Employment") . "</td>";
                    }
                    $check_dat = $this->vm->check_datasource($req['req_id'], $list['check_id'], $source);
                    foreach ($check_dat as $cd) {
                        $table .= "<td  class='at_td'>" . ucwords($cd['source']) . "</td>
					  <td  class='at_td'>" . ucwords($cd['address']) . "</td>
					  <td  class='at_td'>" . ucwords($cd['level']) . "</td>";
                    }
                    $table .= "</tr>";
                }
            }
        }
        $table .= "<tr class='s-usebrd' height='35'><td colspan='4'><input class='button' style='float: right;' type='submit' value='Submit'></td></tr>";
        echo $table;
    }
    function p_bulknewrequest()
    {

        if ($_POST['mem_id'])
            $assignee_id = $_POST['mem_id'];

        if ($assignee_id) {

            foreach ($_POST['request_level'] as $req_lv) {
                $temp = explode('_', $req_lv);
                $ins_data['candidate_req_id'] = $temp[0];
                $ins_data['check_id'] = $temp[1];
                $ins_data['level_id'] = $temp[2];
                $ins_data['team_mem_id'] = $assignee_id;
                $ins_data['team'] = $_POST['a_team'];
                $this->db->insert(DB_PREFIX . 'ver_assign_rep', $ins_data);
                $upd_data['assignee_status'] = 1;
                $this->db->where('request_id', $temp[0]);
                $this->db->update(DB_PREFIX . 'verification_request', $upd_data);
            }
        }

        redirect(base_url('Verification/allotment_list'), 'refresh');
    }
    function p_newrequest()
    {
        $assignee_id = $this->input->post('assignee_id');
        $date_from = date('Y-m-d');
        $date_to = $this->input->post('date_to');
        $user_id = $this->input->post('user_id');
        $chk_Details = $this->vm->getcheckDetails($_POST['request_id']);
        $exist_id = $this->vm->getreqid($_POST['request_id']);

        if ($_POST) {
            $upd_data = array();
            $upd_data['assignee_id'] = $assignee_id;
            $upd_data['assignee_status'] = 1;
            $upd_data['deadline_from'] = date("Y-m-d");
            $upd_data['deadline_to'] = date("Y-m-d", strtotime($date_to));

            $upd_data['request_id'] = $_POST['request_id'];
            $vrequest_id = $exist_id[0]['vrequest_id'];

            $this->db->insert(DB_PREFIX . 'verification_status', array('request_id' => $_POST['request_id'], 'verification_status' => 1));

            if ($chk_Details) {

                foreach ($chk_Details as $check) {

                    if (!empty($check['pname'])) {
                        $checkname = $check['pname'];
                        $postvalue = $_POST['assignee_id_' . $check['description']];
                        $check_id = $check['description'];
                        $pcheck = $check['check_id'];
                    } else {
                        $pcheck = 0;
                        $checkname = $check['name'];
                        $check_id = $check['check_id'];
                        $postvalue = $_POST['assignee_id_' . $check['check_id']];
                    }
                    if ($postvalue) {

                        $slug = url_title(convert_accented_characters($checkname), 'underscore', TRUE);
                        switch ($check_id) {
                            case 14:
                                $levels = $this->vm->getcheckDetails($_POST['request_id'], 'education_details', 'request_id', $check['check_id']);
                                break;
                            case 15:
                                $levels = $this->vm->getcheckDetails($_POST['request_id'], 'permanent_contact_details', 'request_id', $check['check_id']);
                                break;
                            case 16:
                                $levels = $this->vm->getcheckDetails($_POST['request_id'], 'contact_details', 'request_id', $check['check_id']);
                                break;
                            case 59:
                                $levels = $this->vm->getcheckDetails($_POST['request_id'], 'employment', 'req_id', $check['check_id']);
                                break;
                            default:
                                $levels = $this->vm->getcheckDetails($_POST['request_id'], $slug, 'request_id', $check['check_id']);
                        }
                        if ($levels[1] == TRUE) {
                            $k = 1;
                        } else {
                            $k = 0;
                        }

                        foreach ($levels as $level) {

                            $assigneeData = array('team_mem_id' => $postvalue, 'candidate_req_id' => $_POST['request_id'], 'level_id' => $level['id'], 'check_id' => $check_id, 'pack_id' => $pcheck, 'verify_status' => 107, 'count_of_chk' => $k);

                            $this->db->insert(DB_PREFIX . 'ver_assign_rep', $assigneeData);
                            $upd_data = array('assignee_status' => 1, 'deadline_from' => date("Y-m-d"), 'deadline_to' => date("Y-m-d", strtotime($date_to)), 'request_id' => $_POST['request_id'], 'level_id' => $level['id'], 'check_id' => $check_id, 'pack_id' => $pcheck);
                            $this->db->insert(DB_PREFIX . 'verification_request', $upd_data);
                            $k++;
                        }
                    }
                    unset($check);
                }
            }
        }
        $inslog_data['action'] = 'Allotted to VM';
        $inslog_data['updated_by'] = $this->user_id;
        $inslog_data['updated_on'] = date('Y-m-d H:i:s');
        $this->db->where('request_id', $_POST['request_id']);
        $this->db->update(DB_PREFIX . 'loghistory', $inslog_data);
        redirect(base_url('Verification/allotment_list'), 'refresh');
    }
    function allotted_list()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Verification List', 'Verification/allotted_list');

        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'allotted_list');
    }

    function get_verificationlist()
    {

        $model = array('Verification_model' => 'get_userlistverification');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $company_name = ($_REQUEST['company_name']) ? $_REQUEST['company_name'] : '';
        $college_name = ($_REQUEST['college_name']) ? $_REQUEST['college_name'] : '';
        $university_name = ($_REQUEST['university_name']) ? $_REQUEST['university_name'] : '';
        $verifier_name = ($_REQUEST['verifier_name']) ? $_REQUEST['verifier_name'] : '';
        $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $request_status = ($_REQUEST['request_status']) ? $_REQUEST['request_status'] : '';
        $chk_status = ($_REQUEST['chk_status']) ? $_REQUEST['chk_status'] : '';
        $verified_status = ($_REQUEST['verified_status']) ? $_REQUEST['verified_status'] : '';


        $reopen_status = ($_REQUEST['reopen_status']) ? $_REQUEST['reopen_status'] : '';
        $additional_docs = ($_REQUEST['additional_docs']) ? $_REQUEST['additional_docs'] : '';
        $check_count = ($_REQUEST['check_count']) ? $_REQUEST['check_count'] : '';
        $date_filter = ($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
        $check_type  = ($_REQUEST['check_type']) ? $_REQUEST['check_type'] : '';
        // $reminder  = ($_REQUEST['reminder']) ? $_REQUEST['reminder'] : '';
        $ticket_status = ($_REQUEST['ticket_status']) ? $_REQUEST['ticket_status'] : '';

        if (!empty($ticket_status)) {
            $condition[] = " td.ticket_status =" . $ticket_status;
        }
        if ($org_id)
            $condition[] = " o.id = " . $org_id;
        if ($office)
            $condition[] = " br.id = " . $office;
        if ($parent_office)
            $condition[] = " p.id = " . $parent_office;
        if ($sub_office)
            $condition[] = " su.id = " . $sub_office;
        if ($name)
            $condition[] = "d.candidate_name like '%" . $name . "%' ";
        if ($check_name)
            $condition[] = "c.name like '%" . $check_name . "%' ";
        if ($company_name)
            $condition[] = "((em.company_name like '%" . $company_name . "%'  and a.check_id = 59) || (pr.company_name like '%" . $company_name . "%'  and a.check_id = 68))";
        if ($college_name)
            $condition[] = "(ed.collegename_add like '%" . $college_name . "%'  and a.check_id = 14)";
        if ($university_name)
            $condition[] = "(ed.affliated like '%" . $university_name . "%'  and a.check_id = 14)";
        if ($this->session->userdata['role_id'] == 1 || $this->session->userdata['role_id'] == 24 || $this->session->userdata['role_id'] == 9 || $this->session->userdata['role_id'] == 21) {
            if ($a_status == 0)
                // edited by amritha on 30/06/2023
                $condition[] = "((a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0) or (a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1) or (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111) or (a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107) or (s.vm_revert_option_status = 1 and a.vm_revert_to = 2) or (a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1) or (a.verify_status = 992 and a.qc_revert_request !=1) or ( a.vm_assigned_qc = 0 and a.ass_request = 0 and vl1.supplementary = 1 and a.qc_revert_request = 1 and a.reopen_revert_qc2 = 1) or (a.verify_status =107 or a.vm_assigned_qc=0 or a.verify_status =684 or a.verify_status =992 )) ";
        }
        if ($a_status == 1)
            $condition[] = "( a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0)";
        if ($a_status == 2)
            $condition[] = " (a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1)";
        if ($a_status == 3)
            $condition[] = " (a.qc_revert_request = 1 and a.vm_assigned_qc=1 and a.verify_status not in(107,684,992))";
        if ($a_status == 4)
            $condition[] = " a.ass_request = 1 ";
        if ($a_status == 5)
            $condition[] = " (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111)";
        if ($a_status == 6)
            $condition[] = "((a.verify_status in (110,111,519)) and a.ass_request=0 and a.qc_revert_request = 0 )";
        if ($a_status == 7)
            $condition[] = "(a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107)";
        if ($a_status == 8)
            $condition[] = "s.vm_revert_option_status = 1 and a.vm_revert_to = 2";
        if ($a_status == 9)
            $condition[] = " a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1";
        if ($a_status == 10)
            $condition[] = " a.verify_status = 992 and a.qc_revert_request !=1";
        if ($a_status == 11)
            $condition[] = " a.vm_assigned_qc = 0 and a.ass_request = 0 and vl1.supplementary = 1 and a.qc_revert_request = 1 ";
        if ($a_status == 12)
            $condition[] = " ";
        if ($case_no) {
            // edited by amritha  23/05/2023 
            $case_no = trim($case_no);
            $condition[] = "d.case_no like '%" . $case_no . "' ";
        }
        if ($verifier_name)
            $condition[] = "(concat_ws(' ',us.first_name,us.last_name) like '%" . $verifier_name . "%') ";
        if ($c_date && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(vr.deadline_from ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "'";
        }
        if ($t_date && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(vr.deadline_from ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }
        if ($c_date && $date_filter == 2) {
            $condition[] = "DATE_FORMAT(vr.deadline_to ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "'";
        }
        if ($t_date && $date_filter == 2) {
            $condition[] = "DATE_FORMAT(vr.deadline_to ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }
        if ($c_date && $date_filter == 3) {
            $condition[] = "DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "'";
        }
        if ($t_date && $date_filter == 3) {
            $condition[] = "DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }

        // $condition[]="d.case_no like '%".$case_no."' ";
        if ($request_status)
            $condition[] = " vl1.reqstatus like '%" . $request_status . "' ";
        if ($chk_status == 1) {
            $condition[] = " (vl1.vm_discrepency in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701)) ";
        }
        if ($chk_status == 2) {
            $condition[] = " ((vl1.vm_discrepency in (120,131,137,143,713,119,130,136,142)) or (a.verify_status in (519,110))  or (vl1.vm_discrepency in (1005)))";
        }
        if ($chk_status == 3) {
            $condition[] = " (vl1.vm_discrepency in (116,127,134,140,630,121,125,658,662,660,789)) ";
        }
        if ($reopen_status == 1) {
            $condition[] = " vl1.supplementary in (1,2) ";
        }
        if ($reopen_status == 2) {
            $condition[] = " vl1.supplementary = 3 ";
        }
        if ($additional_docs == 1) {
            $condition[] = " a.additional_docs is NOT NULL ";
        }
        if ($additional_docs == 2) {
            $condition[] = " a.additional_docs is NULL ";
        }
        if ($verified_status == 1) {
            $condition[] = " (vl1.vm_discrepency in (116,127,134,140,630)) ";
        }
        if ($verified_status == 2) {
            $condition[] = " (vl1.vm_discrepency in (121)) ";
        }
        if ($verified_status == 3) {
            $condition[] = " (vl1.vm_discrepency in (122)) ";
        }
        if ($verified_status == 4) {
            $condition[] = " (vl1.vm_discrepency in (129,135,141,701,139,701,118)) ";
        }
        if ($verified_status == 5) {
            $condition[] = " (vl1.vm_discrepency in (117,126)) ";
        }
        if ($verified_status == 6) {
            $condition[] = " ((vl1.vm_discrepency in (119,130,136,142)) or (a.verify_status in (110)))";
        }
        if ($verified_status == 7) {
            $condition[] = " ((vl1.vm_discrepency in (120,131,137,143,713)) or (a.verify_status in (519)))";
        }
        /* if($reminder){
          		$condition[]="adc.email_count =  ".$reminder." ";
		 }*/



        if ($check_type == 1)
            $condition[] = "c.id = 15";
        if ($check_type == 2)
            $condition[] = "c.id = 16";
        if ($check_type == 3)
            $condition[] = "c.id = 71";
        if ($check_type == 4)
            $condition[] = "c.id = 639";
        if ($check_type == 5)
            $condition[] = "c.id = 640";
        if ($check_type == 6)
            $condition[] = "c.id = 636";
        if ($check_type == 7)
            $condition[] = "c.id = 75";

        if ($check_count == 'currentEmpAuth') {
            $condition[] = " vl1.reqstatus = 710";
        } else if ($check_count == 'DDAuth') {
            $condition[] = " vl1.reqstatus = 704";
        } else if ($check_count == 'NeedPin') {
            $condition[] = " vl1.reqstatus = 714";
        } else if ($check_count == 'CompPermanentAddr') {
            $condition[] = " vl1.reqstatus = 715";
        } else if ($check_count == 'CompCurrententAddr') {
            $condition[] = " vl1.reqstatus = 716";
        } else if ($check_count == 'FatherName') {
            $condition[] = " vl1.reqstatus = 717";
        } else if ($check_count == 'ContactNo') {
            $condition[] = " vl1.reqstatus = 718";
        } else if ($check_count == 'CompleteAddr') {
            $condition[] = " vl1.reqstatus = 719";
        } else if ($check_count == 'NeedDOB') {
            $condition[] = " vl1.reqstatus = 720";
        } else if ($check_count == 'Aadhar') {
            $condition[] = " vl1.reqstatus = 721";
        } else if ($check_count == 'PermanentAddWithPIN') {
            $condition[] = " vl1.reqstatus = 722";
        } else if ($check_count == 'PAN_no') {
            $condition[] = " vl1.reqstatus = 723";
        } else if ($check_count == 'PAN_Card') {
            $condition[] = " vl1.reqstatus = 724";
        } else if ($check_count == 'Passport') {
            $condition[] = " vl1.reqstatus = 725";
        } else if ($check_count == 'DL') {
            $condition[] = " vl1.reqstatus = 726";
        } else if ($check_count == 'CurrentAddrWithPin') {
            $condition[] = " vl1.reqstatus = 727";
        } else if ($check_count == 'AppliedDD') {
            $condition[] = " vl1.reqstatus = 752";
        } else if ($check_count == 'VoterID') {
            $condition[] = " vl1.reqstatus = 778";
        } else if ($check_count == 'Form_16') {
            $condition[] = " vl1.reqstatus = 780";
        } else if ($check_count == 'Other') {
            $condition[] = " vl1.reqstatus = 713";
        } else if ($check_count == 'AdditionalDDAuth') {
            $condition[] = " vl1.reqstatus = 705";
        } else if ($check_count == 'AdditionalDOC') {
            $condition[] = " vl1.reqstatus = 706";
        } else if ($check_count == 'AdditionalInfo') {
            $condition[] = " vl1.reqstatus = 707";
        } else if ($check_count == 'AdditionalCharge') {
            $condition[] = " vl1.reqstatus = 711";
        } else if ($check_count == 'ClientNameDiscloser') {
            $condition[] = " vl1.reqstatus = 708";
        } else if ($check_count == 'ShareOLA') {
            $condition[] = " vl1.reqstatus = 709";
        } else if ($check_count == 'NeedClarification') {
            $condition[] = " vl1.reqstatus = 712";
        } else {

            if ($check_count && $this->session->userdata['role_id'] == 5) {
                $rep_id = " (SELECT  GROUP_CONCAT(ar.rep_id) as verifier from dcode_ver_assign_rep ar
                LEFT  JOIN  dcode_verified_level vl1 ON vl1.request_id = ar.candidate_req_id and vl1.check_id = ar.check_id and vl1.level_id = ar.level_id
                where ar.team_mem_id = 21234 and (ar.verify_status =107 or ar.vm_assigned_qc=0 or ar.verify_status =684  )  or  (ar.qc_revert_request = 1 and ar.vm_assigned_qc=0) group by ar.candidate_req_id having count(verifier)=" . $check_count . ")";
                $rid = $this->db->query($rep_id)->result_array();
                foreach ($rid as  $rvalue) {
                    $verifier_ids[] = $rvalue['verifier'];
                }
                $condition[] = " a.rep_id in (" . implode(',', $verifier_ids) . " )";
            }
            if ($check_count && (in_array($this->session->userdata['role_id'], array(1, 9, 21, 24)))) {
                $rep_id = " (SELECT  GROUP_CONCAT(ar.rep_id) as verifier from dcode_ver_assign_rep ar
		      where (ar.verify_status =107 or ar.vm_assigned_qc=0 or ar.verify_status =684 ) group by ar.candidate_req_id having count(ar.candidate_req_id)=" . $check_count . ")";
                $rid = $this->db->query($rep_id)->result_array();
                foreach ($rid as  $rvalue) {
                    $verifier_ids[] = $rvalue['verifier'];
                }
                $condition[] = " a.rep_id in (" . implode(',', $verifier_ids) . " )";
            }
        }

        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.firstname " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " b.lastname " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " f.order_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vs.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " o.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " p.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " su.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " br.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.case_no " . $not . "LIKE '%" . $t . "%' ";

                $like    .= $operator . " ed.collegename_add " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " ed.affliated " . $not . "LIKE '%" . $t . "%' ";

                $like    .= $operator . " em.company_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " pr.company_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vr.deadline_from " . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";
                $like    .= $operator . " vr.deadline_to " . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";
                $like    .= $operator . " vl1.reqstatus " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " verify_status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.additional_docs " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.vm_revert_status " . $not . "LIKE '%" . $t . "%' ) ";

                $condition[] = $like;
            }
        }
        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $checkteam = $this->config->item('CHECKLIST', APPLICATIONCONFIG);
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            $k = 1;

            foreach ($result as $i => $row) {
                $company_details = $this->vm->get_verifiedcompany_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);
                $education_details = $this->vm->get_verifiedcollege_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);
                $professional_details = $this->vm->get_verifiedprofessional_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);

                $verified_data = $this->vm->get_verified_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);
                $verification_data = toArray(json_decode($verified_data['fielddata']));
                $vm_expenses  = toArray(json_decode($verified_data['vmexpenses']));
                $qc2verification_data = toArray(json_decode($verified_data['qc2fielddata']));

                if ($vm_expenses <> null) {


                    if ($vm_expenses[0]['ddcurrency']) {

                        $ddcurrencyid =   $vm_expenses[0]['ddcurrency'];

                        $results = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'currencykey', 'id' => $ddcurrencyid));

                        $currencyname =   $results[0]['name'];
                    } else {
                        $currencyname = '';
                    }

                    $d_amount = 0;
                    foreach ($vm_expenses as $key => $dd_exprenses) {

                        $d_amount += $dd_exprenses['amount'];
                    }

                    $dd_amount = $currencyname . ' ' . $d_amount;
                } else {
                    $dd_amount = '';
                }


                $status1 = $this->vm->get_status($verification_data['status']);
                $status4 = '';
                $status2 = $this->vm->get_status($verification_data['pstatus']);
                $status3 = $this->vm->get_status($verification_data['status1']);
                if ($verification_data['ostatus'] <> '') {
                    $status4 = $this->vm->get_status($verification_data['ostatus']);
                    $status4_id = $verification_data['ostatus']; //  Dec 13th
                }
                if ($verification_data['dstatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['dstatus']);
                if (!empty($status4))
                    $status41 = '-' . $status4['name'];
                else
                    $status41 = '';

                $reqstatus = '';
                if (!empty($row['reqstatus'])) {
                    $req_raised_status =    $this->vm->get_status($row['reqstatus']);
                    $reqstatus = $req_raised_status['name'];
                }
                $rpt_status = '';
                if ($row['checkId'] == 1306) { // ka added on april 24
                    $rpt_status = '';
                }  // ka added on april 24
                /************************ PF_Verification *************************/
                else if ($row['checkId'] == 652) {
                    if ($verification_data['status'] != 107 && $verification_data['status'] != 684 && !empty($verification_data['status'])) {
                        if ($status3['name'] == "Multiple Active Records" || $status3['name'] == "Discrepant" || $status3['name'] == "Possible Discrepant" || $status3['name'] == "Record Found" || $status3['name'] == "Positive" || $status3['name'] == "Invalid" || $status3['name'] == "Not Completed" || $status3['name'] == "High Risk") {
                            $rpt_status = "<span style='color:red;'>RED</span>";
                        }
                        // Dec 15th
                        else if ($status3['name'] == "No Records" || $status1['name'] == "Stop Check" || $status3['name'] == "Stop Check" || $status3['name'] == "Others" || $status3['name'] == "Possible Match" || $status3['name'] == "Partial Match" || ($status1['name'] == "Others" && ($status4_id != 750 && $status4_id != 699))) {
                            $rpt_status = "<span style='color:orange;'>ORANGE</span>";
                        }
                        /** Dec 13th **/
                        else if ($status1['name'] == "Others" && ($status4_id == 750 || $status4_id == 699)) {
                            $rpt_status = "<span style='color:green;'>GREEN</span>";
                        }
                        /** Aug 24th **/
                        else {
                            $rpt_status = "<span style='color:green;'>GREEN</span>";
                        }
                    }
                }

                /********************* PF_Verification *************************************/
                else {  // For OTHER CHECKS
                    if ($verification_data['status'] != 107 && $verification_data['status'] != 684 && $verification_data['status'] != 992 && !empty($verification_data['status'])) {
                        if ($status3['name'] == "Discrepant" || $status3['name'] == "Possible Discrepant" || $status3['name'] == "Record Found" || $status3['name'] == "Positive" || $status3['name'] == "No Records" || $status3['name'] == "Invalid" || $status3['name'] == "Not Completed" || $status3['name'] == "High Risk") {
                            $rpt_status = "<span style='color:red;'>RED</span>";
                        }
                        // Dec 15th
                        else if ($status3['name'] == "No Records" || $status1['name'] == "Stop Check" || $status3['name'] == "Stop Check" || $status3['name'] == "Others" || $status3['name'] == "Possible Match" || $status3['name'] == "Partial Match" || ($status1['name'] == "Others" && ($status4_id != 750 && $status4_id != 699))) {
                            $rpt_status = "<span style='color:orange;'>ORANGE</span>";
                        }
                        /** Dec 13th **/
                        else if ($status1['name'] == "Others" && ($status4_id == 750 || $status4_id == 699)) {
                            $rpt_status = "<span style='color:green;'>GREEN</span>";
                        }
                        /** Aug 24th **/
                        else {
                            $rpt_status = "<span style='color:green;'>GREEN</span>";
                        }
                    }
                } // For OTHER CHECKS
                $checkstatus = $this->vm->getstatus_of_can($row['candidate_req_id'], $row['checkId']);
                $checkadminstatus = $this->vm->get_currentstatus($row['candidate_req_id']);
                $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');

                $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                $candidatename = $row['candidatename'];
                if ($row['vm_revert_option_status'] == 1 && $row['vm_revert_to'] == 2) {
                    $verifyurl = 'Revert Raised to DEO';
                } else if ($row['qc_revert_request'] == 1) {
                    if ($row['vm_assigned_qc'] == 1 && $row['verify_status'] <> 107 && $row['verify_status'] <> 684 && $row['verify_status'] <> 992) {
                        $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                        $verifyurl = 'Revert Rectified';
                    } else if ($row['vm_assigned_qc'] == 0 && $row['ass_request'] == 0 && $row['supplementary'] == 1 && $row['qc_revert_request'] == 1 && $row['reopen_revert_qc'] == 0 && $row['reopen_revert_qc2'] == 1) {
                        $verifyurl = anchor('/Verification/revert_raisedsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']) . '/' . base64_encode(1004), 'Reopen Assigned', 'target="_blank"');
                    } else if ($row['vm_assigned_qc'] == 0 && $row['ass_request'] == 0 && $row['supplementary'] == 1 && $row['qc_revert_request'] == 1 && $row['reopen_revert_qc'] == 1 && $row['reopen_revert_qc2'] == 1) {
                        $verifyurl = anchor('/Verification/revert_raisedsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']) . '/' . base64_encode(1004), 'Reopen Assigned', 'target="_blank"');
                    } else {

                        $verifyurl = anchor('/Verification/revert_raisedsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Assigned', 'target="_blank"');
                    }
                } elseif ($row['verify_status'] == 111 && $row['vrequest'] == 0 && $row['ass_request'] == 0) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 3 && $row['vm_revert_to'] == 2) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_option_status'] == 3 && $row['vm_revert_to'] == 2) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 4 && $row['operator_submited_by'] == 12 || $row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 4 && $checkadminstatus['role_id'] == 13) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_option_status'] == 4 && $row['operator_submited_by'] == 12 || $row['vm_revert_option_status'] == 4 && $checkadminstatus['role_id'] == 13) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_to'] == 3 && $row['vm_revert_supervisor'] == 0) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_to'] == 3 && $row['vm_revert_supervisor'] == 0) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] <> '111' && $row['vrequest'] == 1 && $row['rstatus'] != 0 && $row['ass_request'] == 0) {
                    if ($row['rstatus'] == 108)
                        $vst = 'Inputs Required';
                    else if ($row['rstatus'] == 110)
                        $vst = 'Stop Check';
                    else if ($row['rstatus'] == 109)
                        $vst = 'Awaiting Authorisation';
                    else if ($row['rstatus'] == 107)
                        $vst = 'Initiated';
                    else if ($row['rstatus'] == 519)
                        $vst = 'Others';
                    else if ($row['rstatus'] == 684)
                        $vst = 'Request Raised';
                    else if ($row['rstatus'] == 992)
                        $vst = 'DD applied';

                    if ($row['rstatus'] == 110 || $row['rstatus'] == 519) {
                        $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    } else {
                        $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">' . $vst . '</p>', 'target="_blank"');
                    }

                    $requesttoass = '';
                } else if ($row['verify_status'] == '111' && $row['vrequest'] == 1 && $row['rstatus'] != 0 && $row['ass_request'] == 0) {
                    if ($row['rstatus'] == 108)
                        $vst = 'Inputs Required';
                    else if ($row['rstatus'] == 110)
                        $vst = 'Stop Check';
                    else if ($row['rstatus'] == 109)
                        $vst = 'Awaiting Authorisation';
                    else if ($row['rstatus'] == 107 && $row['verify_status'] == '111')
                        $vst = 'Verified';
                    else if ($row['rstatus'] == 107)
                        $vst = 'Initiated';
                    else
                        $vst = 'Verified';

                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">' . $vst . '</p>';
                    $requesttoass = '';
                } else if ($row['ass_request'] == 1) {
                    $verifyurl = 'Request Raised';
                    $requesttoass = 'Sent to Associate';
                    $add_calls = '';
                } else {
                    $save['request_id'] = $row['candidate_req_id'];
                    $save['check_id'] = $row['checkId'];
                    $save['level_id'] = $row['level_id'];
                    $this->db->select('count(*) as cnt');
                    $this->db->where($save);
                    $countnoti = $this->db->get(DB_PREFIX . 'notification_emails')->row_array();

                    if ($countnoti['cnt'] >= 1)
                        $vtext = 'Sent Mail to Resource';
                    else
                        $vtext = 'New';




                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $vtext, 'target="_blank"');
                    $vst = $row['status'];
                    $requesttoass = '';
                }
                $slug = url_title(convert_accented_characters($row['checkname']), 'underscore', TRUE);


                if ($row['checkid'] == 14)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'education_details');
                else if ($row['checkid'] == 16)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'contact_details', 'request_id', 'permanent_address');
                else if ($row['checkid'] == 59)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'employment', 'req_id', 'level_id');
                else if ($row['checkid'] == 76 || $row['checkid'] == 77 || $row['checkid'] == 75)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], $slug, 'request_id', 'level_name');
                else
                    $levelnames['level'] = $row['checkname'];

                if ($row['status'] == 'Initiated')
                    $rowstatus = 'Assigned in VM';
                else
                    $rowstatus = $row['status'];
                if ($row['chk'] == 0) {
                    $chkval = $row['checkname'];
                } else {
                    $chkval = $row['checkname'] . $row['chk'];
                }
                if (!empty($status1['name'])) {
                    $stat = $status1['name'] . '-' . $status2['name'] . '-' . $status3['name'] . '' . $status41;
                } else {
                    $stat = '';
                }
                if ($row['checkid'] == 14) {
                    $clgname = $education_details['collegename_add'];
                    $uniname = $education_details['affliated'];
                } else {
                    $clgname = '';
                    $uniname = '';
                }


                if ($row['checkid'] == 59) {
                    $cmpnyname = $company_details['company_name'];
                } else if ($row['checkid'] == 68) {
                    $cmpnyname = $professional_details['company_name'];
                } else {
                    $cmpnyname = '';
                }
                $supplement = '';
                if ($row['supplementary'] == 1 || $row['supplementary'] == 2) {
                    $supplement = 'Reopen';
                } elseif ($row['supplementary'] == 3) {
                    $supplement = 'Reopen-Completed';
                }
                $deadline_from = isset($row['deadline_from']) ? date('d-m-Y', strtotime($row['deadline_from'])) : '';
                $deadline_to = isset($row['deadline_to']) ? date('d-m-Y', strtotime($row['deadline_to'])) : '';

                $v_date = isset($row['v_date']) ? date('d-m-Y', strtotime($row['v_date'])) : '';
                $req_raise_date = isset($row['vm_request_raised_date']) ? date('d-m-Y', strtotime($row['vm_request_raised_date'])) : '';

                $dd_recived =     $qc2verification_data['dd_recevied_form'];

                if ($dd_recived == 1) {
                    $dd_status = 'None';
                } elseif ($dd_recived == 2) {
                    $dd_status = 'University';
                } elseif ($dd_recived == 3) {
                    $dd_status = 'College';
                } elseif ($dd_recived == 4) {
                    $dd_status = 'Company';
                } elseif ($dd_recived == 5) {
                    $dd_status = 'University and College';
                } else {
                    $dd_status = '';
                }

                $veri_received =   $qc2verification_data['veri_received_dropdown'];

                if ($veri_received == 1) {
                    $veri_received_data  = "Recevied";
                } elseif ($veri_received == 2) {
                    $veri_received_data  = "Not received";
                } else {
                    $veri_received_data = '';
                }


                if ($row['ticket_status'] == 1) {
                    $tktStatus = 'Open';
                } else if ($row['ticket_status'] == 2) {
                    $tktStatus = 'Requested';
                } else if ($row['ticket_status'] == 3) {
                    $tktStatus = 'Revert';
                } else if ($row['ticket_status'] == 4) {
                    $tktStatus = 'Re-Requested';
                } else if ($row['ticket_status'] == 5) {
                    $tktStatus = 'Re-Open';
                } else if ($row['ticket_status'] == 101) {
                    $tktStatus = 'Closed';
                } else {
                    $tktStatus = '';
                }

                $startDate = date('Y-m-d', strtotime($row['requested_date']));
                $endDate = date('Y-m-d');
                $workingDays = $this->number_of_working_days($startDate, $endDate);

                if (($row['ticket_status'] == 2 && $workingDays > 7) || ($row['ticket_status'] == 4 && $workingDays > 7) || ($row['ticket_status'] == 3 || $row['ticket_status'] == 101) && $row['rstatus'] == 684) {
                    $tktStatus = "<span style='background-color:yellow;'>" . $tktStatus . "</span>";
                } else if (($row['ticket_status'] == 2 && $workingDays > 7) || ($row['ticket_status'] == 4 && $workingDays > 7) || ($row['ticket_status'] == 3 || $row['ticket_status'] == 101) && ($row['qc_revert_request'] == 1 && $row['verify_status'] == 684)) {
                    $tktStatus = "<span style='background-color:yellow;'>" . $tktStatus . "</span>";
                } else if ($row['rstatus'] != 684) {
                    $tktStatus = '';
                } else if ($row['qc_revert_request'] != 1 && $row['verify_status'] != 684) {
                    $tktStatus = '';
                } else {
                    $tktStatus = $tktStatus;
                }


                $response->rows[$i]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], anchor('/Dadmin/dadminview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['checkId']), $candidatename), $row['case_no'], $chkval, $verifyurl, $tktStatus, $stat, $row['Days'], $reqstatus, $rpt_status, $supplement, $cmpnyname, $verification_data['verification_received'], $veri_received_data, $dd_status, $clgname, $uniname, $dd_amount, $verification_data['rti_reference_no'], $procedure_details, $verfier_details, $row['vname'], $deadline_from, $deadline_to, $row['verification_tat'], $req_raise_date, $v_date, $row['additional_docs'], anchor('/Dadmin/dadminview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['checkId']), 'View'));
            }
        }

        echo json_encode($response);
    }

    function  verification_ckecklist()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        $mem_id = base64_decode($this->uri->segment(3));
        $team = base64_decode($this->uri->segment(4));
        $data['team'] = $team;
        $verification_data = $this->vm->getverificationdata($mem_id, $team);
        $data['assignee_data'] = $this->vm->getassigneedata($mem_id);
        foreach ($verification_data as $vd) {
            $ckeck_dat[] = $this->vm->ckeckdt($vd['candidate_req_id'], $team);
            $status[] = $this->vm->getstatus_of_can($vd['candidate_req_id'], $team);
        }
        $data['verification_checks'] = $ckeck_dat;
        $data['status'] = $status;
        $data['team'] = $team;
        $data['mem'] = $mem_id;
        $this->amodel->pagerender($data, 'verification_checklist');
    }

    function verify_education()
    {

        // ka added on may 20
        if ($_POST['check_id'] == 1306) {
            $existing_record_json = $this->vm->fetch_existing_record_json($_POST['request_id']);
            $existing_record = toArray(json_decode($existing_record_json['gapdata']));
            $count_gap = count($existing_record);
            for ($i = 0; $i < $count_gap; $i++) {
                if (!empty($_POST['previous_org'][$i])) {
                    $cleaned_previous_org = str_replace(array("\\n", "\\r", "\\"), '', $_POST['previous_org'][$i]);
                    $cleaned_previous_org = str_replace("'", "''", $cleaned_previous_org); // Jan 20th 2025
                    $existing_record[$i]['previous_org'] = trim($cleaned_previous_org);
                }
                if (!empty($_POST['next_org'][$i])) {
                    $cleaned_next_org = str_replace(array("\\n", "\\r", "\\"), '', $_POST['next_org'][$i]);
                    $cleaned_next_org = str_replace("'", "''", $cleaned_next_org); // Jan 20th 2025
                    $existing_record[$i]['next_org'] = trim($cleaned_next_org);
                }
                //  Jan 20th 2025
                if(!empty($existing_record[$i]['gap_reason_emp']))
                {
                    $cleaned_reason_emp = str_replace(array("\\n", "\\r", "\\"), '', $existing_record[$i]['gap_reason_emp']);
                    $cleaned_reason_emp = str_replace("'", "''", $cleaned_reason_emp); 
                    $existing_record[$i]['gap_reason_emp'] = trim($cleaned_reason_emp);
                }
                //  Jan 20th 2025
            }
            $json_gap = json_encode($existing_record);
            //print_r($json_gap);
            $this->vm->update_company_name_forgap($_POST['request_id'], $json_gap);
            $cleaned_data = $existing_record;
        }
        // ka added on may 20

        // ************************************ education and employment gap *********************
        // ka added on july 17
        if (($_POST['check_id'] == 1306)) {
            $existing_record_edu_json = $this->vm->fetch_existing_record_edu_json($_POST['request_id']);
            $existing_record_edu = toArray(json_decode($existing_record_edu_json['gap_edu']));
            $count_gap_edu = count($existing_record_edu);
            for ($i = 0; $i < $count_gap_edu; $i++) {
                if (!empty($_POST['qualification'][$i] != '')) {
                    $cleaned_qualification = str_replace(array("\\n", "\\r", "\\"), '', $_POST['qualification'][$i]);
                    $cleaned_qualification = str_replace("'", "''", $cleaned_qualification); // Jan 15th 2025
                    $existing_record_edu[$i]['qualification'] = trim($cleaned_qualification);
                }

                if (!empty($_POST['previous_org_edu'][$i] != '')) {
                    $cleaned_previous_org_edu = str_replace(array("\\n", "\\r", "\\"), '', $_POST['previous_org_edu'][$i]);
                    $cleaned_previous_org_edu = str_replace("'", "''", $cleaned_previous_org_edu); // Jan 15th 2025
                    $existing_record_edu[$i]['previous_org_edu'] = trim($cleaned_previous_org_edu);
                }
                /** Added on Dec 19th **/    
                if(!empty($_POST['gap_duration_edu'][$i] != '')) {
                    $gap_duration_edu = $_POST['gap_duration_edu'][$i];
                    $existing_record_edu[$i]['gap_duration_edu'] = trim($gap_duration_edu);
                }
                if(empty($_POST['gap_duration_edu'][$i])) {
                    $existing_record_edu[$i]['gap_duration_edu'] = "";
                }
                if(!empty($_POST['previous_exit_date_edu'][$i] != '')) {
                    $previous_exit_date_edu = $_POST['previous_exit_date_edu'][$i];
                    $previous_exit_date_edu = date('Y-m-d', strtotime($previous_exit_date_edu));
                    $existing_record_edu[$i]['previous_exit_date_edu'] = $previous_exit_date_edu;
                }
                if(empty($_POST['previous_exit_date_edu'][$i])) {
                    $existing_record_edu[$i]['previous_exit_date_edu'] = null;
                }
                if(!empty($_POST['previous_join_date_edu'][$i] != '')) {
                    $previous_join_date_edu = $_POST['previous_join_date_edu'][$i];
                    $previous_join_date_edu = date('Y-m-d', strtotime($previous_join_date_edu));
                    $existing_record_edu[$i]['previous_join_date'] = $previous_join_date_edu;
                }
                if(empty($_POST['previous_join_date_edu'][$i])) {
                    $existing_record_edu[$i]['previous_join_date'] = null;
                } /** Added on Dec 19th till here**/
                //  Jan 20th 2025
                if(!empty($existing_record_edu[$i]['gap_reason_edu']))
                {
                    $cleaned_reason_edu = str_replace(array("\\n", "\\r", "\\"), '', $existing_record_edu[$i]['gap_reason_edu']);
                    $cleaned_reason_edu = str_replace("'", "''", $cleaned_reason_edu); 
                    $existing_record_edu[$i]['gap_reason_edu'] = trim($cleaned_reason_edu);
                }
                //  Jan 20th 2025
            }

            $json_gap_edu = json_encode($existing_record_edu);
            $this->vm->update_qualification_companyname_forgap($_POST['request_id'], $json_gap_edu);
        }
        // ************************************** end **************************************************
        $one = $_POST['expences'];
        $two = $_POST['amount'];
        $three = $_POST['reference'];
        $four = $_POST['ddcurrency'];
        $five = $_POST['payment_date'];
        $six = $_POST['payment_to'];
        $origin_verification = $_POST['origin_verification']; // 26th Oct


        // ******** charges for international check *********
        $chkcharge = $_POST['chkcharge'];

        if ($chkcharge == 1) {
            $approval_date  = $_POST['approval_date'];
            $inter_currency = $_POST['inter_currency'];
            $inter_amount   = $_POST['inter_amount'];
            $inter_rate     = $_POST['inter_rate'];
            $case_no        = $_POST['case_no'];
            $org_id         = $_POST['org_id'];
            $level_id       = $_POST['level_id'];
            $created_on     = date("Y-m-d H:i:s");
            $check_id       = $_POST['check_id'];
            if ($inter_currency != 885)
                $amount_rupees = $inter_amount * $inter_rate;
            else {
                $amount_rupees = $inter_amount * 1;
                $inter_rate = '';
            }
        } elseif ($chkcharge == 0 && ($_POST['status'] == 111 || $_POST['status'] == 519 || $_POST['status'] == 110)) {
            $check_id         = $_POST['check_id'];
            $level_id       = $_POST['level_id'];
            $org_id         = $_POST['org_id'];
            $case_no        = $_POST['case_no'];
            $created_on     = date("Y-m-d H:i:s");
            $approval_date  = 00 - 00 - 0000;
            $inter_currency = 0;
            $inter_amount   = 0;
            $inter_rate     = 0;
            $amount_rupees  = 0;
        }

        $request_id = base64_decode($this->uri->segment(3));
        $level_id = base64_decode($this->uri->segment(4));
        $check_id = base64_decode($this->uri->segment(5));

        // ******** charges for international check *********

        if ($check_id == 651  || $check_id == 644 || $check_id == 1306 || $check_id == 647 || $check_id == 646 || $check_id == 645  || $check_id == 653 || $check_id == 654) {

            $charges['approval_date'] = date('Y-m-d', strtotime($approval_date));
            $charges['currency']       = $inter_currency;
            $charges['amount']         = $inter_amount;
            $charges['exchange_rate']  = $inter_rate;
            $charges['request_id']     = $request_id;
            $charges['check_id']       = $check_id;
            $charges['level_id']       = $level_id;
            $charges['amount_rupees']  = $amount_rupees;
            $charges['case_no']        = $case_no;
            $charges['org_id']         = $org_id;
            $charges['creation_date']  = $created_on;

            $charges_count = $this->vm->service_chrges_international($request_id, $check_id, $level_id);

            if ($charges_count['cnt'] == 0) {

                $this->db->insert(DB_PREFIX . 'service_charges_intchecks', $charges);
            } else {

                $this->db->where('request_id', $request_id);
                $this->db->where('check_id', $check_id);
                $this->db->where('level_id', $level_id);
                $this->db->update(DB_PREFIX . 'service_charges_intchecks', $charges);
            }
        }


        // ******** charges for international check *********

        for ($i = 0; $i < count($one); $i++) {
            if ((!empty($one[$i])) && (!empty($two[$i]))) {
                $vmexpenses[] = array('expences' => $one[$i], 'amount' => $two[$i], 'reference' => $three[$i], 'ddcurrency' => $four[$i], 'payment_date' => $five[$i], 'payment_to' => $six[$i]);
            }
        }
        $request_id = base64_decode($this->uri->segment(3));
        $level_id = base64_decode($this->uri->segment(4));
        $check_id = base64_decode($this->uri->segment(5));
        $pack_id = base64_decode($this->uri->segment(6));

        $upload_files = array('document_name', 'authenticate_doc');
        $status = $this->insertcloneDetails($_POST['count1'], $upload_files, $return_id, 'vm_upload_files', $request_id, 'request_id', $check_id, $level_id);

        $upload_doc = array('bill_proof');
        $status1 = $this->insertBillDetails($_POST['count'], $upload_doc, $return_id, 'billing_doc', $request_id, 'request_id', $check_id, $level_id);

        $userid = $this->session->userdata('userid');
        /*********************************************************************/
        // edited by Amritha on 23/03/2023   

        $userid = $this->session->userdata('userid');
        if (!empty($_FILES['details0']["name"][0])) {
            $temp = array();

            for ($i = 0; $i <= $_POST['counts']; $i++) {

                $tmp_name = $_FILES["details" . $i]["tmp_name"];

                if ($tmp_name != '') {
                    $name = strtotime("now") . '_' . $_FILES["details" . $i]["name"];
                    //$name = $_FILES["details".$i]["name"]; 
                    $px = $name;

                    $px = preg_replace('/\s+/', '_', $px);
                    $px = str_replace('&', 'and', $px);
                }
                $target = './uploads/qcreferencedetails/';
                if (is_dir($target) == false) {
                    mkdir($target, 0755);
                    echo "Directory Created</br>";
                }


                $u = $target . $px;

                move_uploaded_file($tmp_name, $u);
                $temp[] = $px;
            }

            $_POST['details'] = implode($temp, ",");
        }
        /***********************************************************/
        $verify_qc = $this->vm->verify_qc($request_id);
        if ($verify_qc[0]['dedicated_qc'] == 17) {

            $update_qc['qc1_verification'] = 1;
            $this->db->where(array('candidate_req_id' => $request_id, 'level_id' => $level_id, 'check_id' => $check_id, 'pack_id' => $pack_id));
            $this->db->update(DB_PREFIX . 'ver_assign_rep', $update_qc);

            $this->db->where(array('request_id' => $request_id));
            $update_ver['qc_assignee_status'] = 1;
            $this->db->update(DB_PREFIX . 'verification_request', $update_ver);
        }
        $save['request_id'] = $cond['request_id'] = $request_id;
        $save['check_id'] = $cond['check_id'] = $check_id;
        $save['level_id'] = $cond['level_id'] = $level_id;
        $save['package_id'] = $cond['package_id'] = $pack_id;

        $this->db->select('updated_by');
        $this->db->where('request_id', $request_id);
        $verificationdata = $this->db->get(DB_PREFIX . 'verification_request')->row_array();

        $this->db->where('check_id', $check_id);
        $this->db->where('level_id', $level_id);
        if ($pack_id > 94)
            $this->db->where('pack_id', $pack_id);
        $this->db->where('candidate_req_id', $request_id);

        $update['vm_revert_status'] = $_POST['status'];
        $update['vm_revert_request'] = 1;

        if ($this->session->userdata('role_id') == 10)
            $update['vm_revert_to'] = 54;
        else
            $update['vm_revert_to'] = $verificationdata['updated_by'];
        $update['vm_revert_by'] = $this->session->userdata('userid');
        $update['vm_revert_date'] = date('y-m-d H:i:s');
        $update['vm_comments'] = mysqli_real_escape_string($_POST['sum_text']);
        $this->db->update(DB_PREFIX . 'ver_assign_rep', $update);


        /************* Status Updtes ***************/
        if ($_POST['status'] == 111 || $_POST['status'] == 107 || $_POST['status'] == 519 || $_POST['status'] == 110 || $_POST['status'] == 684 || $_POST['status'] == 992) {

            $stat_save['request_id'] = $request_id;
            $stat_save['case_no'] = $_POST['case_no'];
            $stat_save['check_id'] = $check_id;
            $stat_save['level_id'] = $level_id;
            $stat_save['check_status'] = $_POST['status'];
            $stat_save['verified_status'] = '';
            $stat_save['date_of_update'] = date('y-m-d H:i:s');
            $stat_save['role_id'] = $this->session->userdata('role_id');
            $stat_save['user_id'] = $this->session->userdata['userid'];

            $stat_save = $this->security->xss_clean($stat_save);
            $this->db->insert(DB_PREFIX . 'status_updates', $stat_save);
        }
        /******************************************/

        if ($_POST['status'] <> '111') {
            $inslog_data['pack_id'] = $pack_id;
            $inslog_data['action'] = 'Inputs Required';
            $inslog_data['updated_by'] = $this->session->userdata('userid');
            $inslog_data['updated_on'] = date('Y-m-d H:i:s');
            $this->db->where('request_id', $request_id);
            $this->db->update(DB_PREFIX . 'loghistory', $inslog_data);

            if ($_POST['status'] == 110 || $_POST['status'] == 109 || $_POST['status'] == 108 || $_POST['status'] == 519) {

                $save['status'] = 1;
                $save['fielddata'] = json_encode($_POST);
                $save['vmexpenses'] = json_encode($vmexpenses);
                $save['verified_by'] = $userid;
                $save['reqstatus'] = '';
                $save['v_date'] = date('Y-m-d H:i:s');
                $save['vm_discrepency'] = 0;
                //Edited By amritha on 09/06/2023 for checking  vmexpenses is null or not
                // 26th /oct
                if (!empty($origin_verification)) {
                    $save['outside_india'] = $origin_verification;
                } else {
                    $save['outside_india'] = 0;
                }

                if (!empty($vmexpenses)) {
                    $save['exp_status'] = 1;
                } else {
                    $save['exp_status'] = 0;
                }

                $this->db->select('count(*) as cnt');
                $this->db->where($cond);
                $result =  $this->db->get(DB_PREFIX . 'verified_level')->row_array();
                $this->vm->update_status($request_id, $check_id, $level_id, $pack_id, $_POST);
                if ($result['cnt'] == 0) {
                    $this->db->insert(DB_PREFIX . 'verified_level', $save);
                } else {
                    $this->db->where($cond);
                    $this->db->update(DB_PREFIX . 'verified_level', $save);
                }
            } else if ($_POST['status'] == 684  ||  $_POST['status'] == 992) {
                $save['status'] = 1;
                $save['vmexpenses'] = json_encode($vmexpenses);
                $save['fielddata'] = json_encode($_POST);
                $save['reqstatus'] = $_POST['reqstatus'];
                $save['v_date'] = date('Y-m-d H:i:s');
                $save['vm_request_raised_date'] = date('Y-m-d H:i:s');
                //Edited By amritha on 09/06/2023 for checking  vmexpenses is null or not
                // Oct 26th 2023
                if (!empty($origin_verification)) {
                    $save['outside_india'] = $origin_verification;
                } else {
                    $save['outside_india'] = 0;
                }
                if (!empty($vmexpenses)) {
                    $save['exp_status'] = 1;
                } else {
                    $save['exp_status'] = 0;
                }
                $this->db->select('count(*) as cnt');
                $this->db->where($cond);
                $save = $this->security->xss_clean($save);
                $result =  $this->db->get(DB_PREFIX . 'verified_level')->row_array();
                if ($result['cnt'] == 0) {
                    $this->db->insert(DB_PREFIX . 'verified_level', $save);
                } else {
                    $this->db->where($cond);
                    $this->db->update(DB_PREFIX . 'verified_level', $save);
                }




                $this->db->where('candidate_req_id', $request_id);
                $this->db->where('check_id', $check_id);
                $this->db->where('level_id', $level_id);
                $save_request['verify_status'] = $_POST['status'];
                $save_request['comments'] = mysqli_real_escape_string($_POST['sum_text']);
                $this->db->update(DB_PREFIX . 'ver_assign_rep', $save_request);
            } else {
                $save['fielddata'] = json_encode($_POST);
                $save['vmexpenses'] = json_encode($vmexpenses);
                $save['verified_by'] = $userid;
                $save['reqstatus'] = '';
                //Edited By amritha on 09/06/2023 for checking  vmexpenses is null or not
                // Oct 26th 2023
                if (!empty($origin_verification)) {
                    $save['outside_india'] = $origin_verification;
                } else {
                    $save['outside_india'] = 0;
                }
                if (!empty($vmexpenses)) {
                    $save['exp_status'] = 1;
                } else {
                    $save['exp_status'] = 0;
                }
                $this->db->select('count(*) as cnt');
                $this->db->where($cond);
                $result =  $this->db->get(DB_PREFIX . 'verified_level')->row_array();
                if ($result['cnt'] == 0) {
                    $this->db->insert(DB_PREFIX . 'verified_level', $save);
                } else {
                    $this->db->where($cond);
                    $this->db->update(DB_PREFIX . 'verified_level', $save);
                }


                $this->db->where('candidate_req_id', $request_id);
                $this->db->where('check_id', $check_id);
                $this->db->where('level_id', $level_id);
                $save_request['verify_status'] = $_POST['status'];
                $save_request['comments'] = mysqli_real_escape_string($_POST['sum_text']);
                $this->db->update(DB_PREFIX . 'ver_assign_rep', $save_request);
            }

            if ($_POST['status'] == 684) {

                $userid = $this->session->userdata['userid'];
                $role_id = $this->session->userdata['role_id'];

                $ticketDetail = $this->vm->get_ticket($request_id, $check_id, $level_id);
                $sl_no = count($ticketDetail);

                $ticketNo = $this->vm->get_ticketno();

                if (!empty($ticketNo[0]['ticketNo'])) {
                    $ticket_no = $ticketNo[0]['ticketNo'] + 1;
                } else {
                    $ticket_no = 1;
                }


                if ($ticketDetail[0]['request_id'] == $request_id && $ticketDetail[0]['check_id'] == $check_id && $ticketDetail[0]['level_id'] == $level_id) {
                    $req_save['ticket_no'] = $ticketDetail[0]['ticket_no'];
                    $req_save['ticket_serial_no'] = $sl_no + 1;
                    $req_save['ticket_status'] = 5;

                    $this->db->set('current_status', 0);
                    $this->db->where('request_id', $request_id);
                    $this->db->where('check_id', $check_id);
                    $this->db->where('level_id', $level_id);
                    $this->db->update(DB_PREFIX . 'ticket_details');
                } else {
                    $req_save['ticket_no'] = $ticket_no;
                    $req_save['ticket_serial_no'] = 1;
                    $req_save['ticket_status'] = 1;
                }

                $req_save['request_id'] = $request_id;
                $req_save['case_no'] = $_POST['case_no'];
                $req_save['level_id'] = $level_id;
                $req_save['check_id'] = $check_id;
                $req_save['action_date'] = date('y-m-d H:i:s');
                $req_save['role_id'] = $role_id;
                $req_save['user_id'] = $userid;
                $req_save['request_reason_id'] = $_POST['reqstatus'];
                $req_save['ticket_details'] = $_POST['ticket_details'];
                $req_save['current_status'] = 1;

                $req_save = $this->security->xss_clean($req_save);
                $this->db->insert(DB_PREFIX . 'ticket_details', $req_save);
            }

            $this->db->select('order_id,candidate_name,office,sub_office,case_no');
            $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();

            $valuecomma = implode(',', $one);
            $valuecomma2 = implode(',', $two);
            $valuecomma3 = implode(',', $three);
            $valuecomma4 = implode(',', $four);

            $insbill_data['request_id'] = $request_id;
            $insbill_data['check_id'] = $check_id;
            $insbill_data['vm_expences'] = $valuecomma;
            $insbill_data['order_id'] = $orderid[0]['order_id'];

            $insbill_data['vm_amount'] = $valuecomma2;
            $insbill_data['vm_reference'] = $valuecomma3;
            $insbill_data['vm_currency'] = $valuecomma4;


            $insbill_data['billing_type'] = 517;
            $insbill_data['created_on'] = date('y-m-d');
            $insbill_data = $this->security->xss_clean($insbill_data);
            $this->db->where('request_id', $request_id);
            $this->db->select('*');
            $billingfinal = $this->db->get_where(DB_PREFIX . 'billing', array('request_id' => $request_id, 'check_id' => $check_id))->row_array();
            if (!empty($billingfinal)) {
                $this->db->insert(DB_PREFIX . 'billing', $insbill_data);
            } else {
                $this->db->update(DB_PREFIX . 'billing', $insbill_data);
            }
            redirect('Verification/vm_newcaselist');
        }

        $this->vm->update_status($request_id, $check_id, $level_id, $pack_id, $_POST);

        $this->vm->update_level($request_id, $level_id, $check_id, $_POST, 1, $userid, $pack_id, $vmexpenses);
        $this->vm->update_loglevel($request_id, $userid, $pack_id);
        $this->db->select('order_id,candidate_name,office,sub_office,case_no');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();

        $valuecomma = implode(',', $one);
        $valuecomma2 = implode(',', $two);
        $valuecomma3 = implode(',', $three);
        $valuecomma4 = implode(',', $four);
        $insbill_data['request_id'] = $request_id;
        $insbill_data['check_id'] = $check_id;
        $insbill_data['vm_expences'] = $valuecomma;
        $insbill_data['order_id'] = $orderid[0]['order_id'];
        $insbill_data['vm_amount'] = $valuecomma2;
        $insbill_data['vm_reference'] = $valuecomma3;
        $insbill_data['vm_currency'] = $valuecomma4;
        $insbill_data['billing_type'] = 517;
        $insbill_data['created_on'] = date('y-m-d');
        $insbill_data = $this->security->xss_clean($insbill_data);
        $this->db->where('request_id', $request_id);
        $this->db->select('*');
        $billingfinal = $this->db->get_where(DB_PREFIX . 'billing', array('request_id' => $request_id, 'check_id' => $check_id))->row_array();
        if (!empty($billingfinal)) {
            $this->db->insert(DB_PREFIX . 'billing', $insbill_data);
        } else {
            $this->db->update(DB_PREFIX . 'billing', $insbill_data);
        }

        if ($_POST['status1'] == 117 || $_POST['status1'] == 118 || $_POST['status1'] == 122 || $_POST['status1'] == 124 || $_POST['status1'] == 126 || $_POST['status1'] == 128 || $_POST['status1'] == 129 || $_POST['status1'] == 133 || $_POST['status1'] == 135 || $_POST['status1'] == 139 || $_POST['status1'] == 141 || $_POST['status1'] == 145 || $_POST['status1'] == 695 || $_POST['status1'] == 661 || $_POST['status1'] == 663 || $_POST['status1'] == 701) {

            $vm_submitted_redreport = $this->vm->vm_submitted_redreport($request_id, $level_id, $check_id);
            $data['vm_submitted_redreport']  = $submit_red_reports =  $vm_submitted_redreport[0];

            if ($submit_red_reports['qc2_email']) {

                $email = $submit_red_reports['qc2_email'];
            } else {
                $email = config_item('email');
            }

            $cc = config_item('email');

            $this->send_email_common_notification('vm_submitted_redreport_qc', ' RED Report submitted', '', $email, $data, $cc);
        }

        if ($this->session->userdata('role_id') == 10)
            redirect('Associate/listrequest');
        else
            redirect('' . base_url('Verification/vm_newcaselist'));

        if ($this->session->userdata('role_id') == 10)
            redirect('Associate/listrequest');
        else
            redirect('' . base_url('Verification/vm_newcaselist'));
    }

    function insertcloneDetails($clonecount = 0, $insertValue = '', $marketId = '', $tablename = '', $editId = '', $fId = '', $cId = '', $lId = '')
    {
        if ($editId != 0) {
            $marketId = $editId;
            $rcId = $cId;
            $rlId = $lId;
        }

        $insertsales = array();
        $bulksave = array();
        if (!empty($_FILES['authenticate_doc']['name'])) {
            if ($clonecount != 0) {
                for ($i = 1; $i <= $clonecount; $i++) {
                    $j = $i;
                    if ($i == 1) {
                        $j = '';
                    }

                    foreach ($insertValue as $value) {
                        switch ($value) {
                            case 'authenticate_doc':
                            case '':
                                //upload files
                                $this->load->library('Upload');
                                $config['allowed_types'] = 'jpg|png|jpeg';
                                $config['upload_path'] = 'uploads/candidate/document/';
                                $config['encrypt_name'] = true;
                                $config['remove_spaces'] = true;
                                $this->load->library('upload', $config);
                                if (!empty($_FILES['authenticate_doc' . $j . $j]['name'])) {
                                    $this->upload->initialize($config);
                                    if ($this->upload->do_upload('authenticate_doc' . $j . $j)) {

                                        $upload_data = $this->upload->data();
                                        $image['original'] = $config['upload_path'] . '' . $upload_data['file_name'];
                                        $config['source_image'] = getcwd() . '/uploads/candidate/document/' . $upload_data['file_name'];
                                        $insertsales['authenticate_doc'] = $image['original'];
                                    }
                                }
                                if ($this->upload->display_errors() != '') {

                                    return $this->upload->display_errors();
                                }

                                $insertsales[$value] = $image['original'];
                                break;

                            default:
                                $insertsales[$value] = $_POST[$value . $j];
                                break;
                        }
                    }
                    $insertsales[$fId] = $marketId;
                    $insertsales['check_id'] = $cId;
                    $insertsales['level_id'] = $lId;
                    $insertsales['status'] = '1';
                    $bulksave[] = $insertsales;
                }
                $this->db->insert_batch($this->config->item('table_prefix') . $tablename, $bulksave);
            }
        }
        return 1;
    }

    function verify_send_status()
    {
        $request_id = base64_decode($this->uri->segment(3));
        $update_data['verify_status'] = 1;
        $this->db->where('request_id', $request_id);
        $this->db->update(DB_PREFIX . 'verification_status', $update_data);
        redirect('' . base_url('Verification/allotted_list'));
    }

    function verification_report()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Verified Reports List', 'Verification/verification_report');

        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'allotted_list');
    }

    function get_reportlist($usertype_id = '')
    {
        $model = array('Verification_model' => 'get_userlistreports');

        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $a_date = ($_REQUEST['a_date']) ? $_REQUEST['a_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $company_name = ($_REQUEST['company_name']) ? $_REQUEST['company_name'] : '';
        $college_name = ($_REQUEST['college_name']) ? $_REQUEST['college_name'] : '';
        $university_name = ($_REQUEST['university_name']) ? $_REQUEST['university_name'] : '';
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        if ($office)
            $condition[] = " c.id = " . $office;
        if ($org_id)
            $condition[] = " e.id = " . $org_id;
        if ($parent_office)
            $condition[] = " cr.parent_office = " . $parent_office;
        if ($sub_office)
            $condition[] = " cr.sub_office = " . $sub_office;

        if ($check_name)
            $condition[] = " md1.name like '%" . $check_name . "%'";
        if ($company_name)
            $condition[] = "((em.company_name like '%" . $company_name . "%'  and ar.check_id = 59) || (pr.company_name like '%" . $company_name . "%'  and ar.check_id = 68))";
        if ($college_name)
            $condition[] = "(ed.collegename_add like '%" . $college_name . "%'  and ar.check_id = 14)";
        if ($university_name)
            $condition[] = "(ed.affliated like '%" . $university_name . "%'  and ar.check_id = 14)";
        if ($a_status == 1)
            $condition[] = "((ar.verify_status = 111 and vl1.vm_discrepency = 128) || (ar.verify_status = 111 and vl1.vm_discrepency = 129) || (ar.verify_status = 111 and vl1.vm_discrepency = 126) || (ar.verify_status = 111 and vl1.vm_discrepency = 124) || (ar.verify_status = 111 and vl1.vm_discrepency = 122))";
        if ($a_status == 2)
            $condition[] = "(ar.verify_status = 110 || ar.verify_status = 519 || (ar.verify_status = 111 and vl1.vm_discrepency = 130 ) || (ar.verify_status = 111 and vl1.vm_discrepency = 131 ) || (ar.verify_status = 111 and vl1.vm_discrepency = 1005 ))";
        if ($a_status == 3)
            $condition[] = "((ar.verify_status = 111 and vl1.vm_discrepency = 127) || (ar.verify_status = 111 and vl1.vm_discrepency = 125) || (ar.verify_status = 111 and vl1.vm_discrepency = 123) || (ar.verify_status = 111 and vl1.vm_discrepency = 121))";
        if ($name)
            $condition[] = " ( cr.candidate_name like '%" . $name . "%' OR  cr.candidate_name like '%" . $name . "%') ";
        if ($a_date)
            $condition[] = "DATE_FORMAT(a.deadline_from ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($a_date)) . "'";
        if ($t_date)
            $condition[] = "DATE_FORMAT(a.deadline_to ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";

        //17/01/2024
        $case_no = trim($case_no);
        if ($case_no)
            $condition[] = " cr.case_no like '%" . $case_no . "'";
        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " o.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " md2.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " md.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " md1.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " e.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.deadline_from" . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";
                $like    .= $operator . " a.deadline_to" . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";

                $like    .= $operator . " ass.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " em.company_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " pr.company_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " ed.collegename_add " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " ed.affliated " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " ass.last_name " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }

        $manual_cond = implode(' and ', $condition);


        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {
                $company_details = $this->vm->get_verifiedcompany_data($row['request_id'], $row['level_id'], $row['check_id']);
                $education_details = $this->vm->get_verifiedcollege_data($row['request_id'], $row['level_id'], $row['check_id']);
                $professional_details = $this->vm->get_verifiedprofessional_data($row['request_id'], $row['level_id'], $row['check_id']);
                $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                $verified_data = $this->vm->get_verified_data($row['request_id'], $row['level_id'], $row['check_id']);
                $verification_data = toArray(json_decode($verified_data['fielddata']));
                $status4 = '';
                $status1 = $this->vm->get_status($verification_data['status']);
                $status2 = $this->vm->get_status($verification_data['pstatus']);
                $status3 = $this->vm->get_status($verification_data['status1']);
                if ($verification_data['ostatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['ostatus']);
                if ($verification_data['dstatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['dstatus']);
                if (!empty($status4))
                    $status41 = '-' . $status4['name'];
                else
                    $status41 = '';

                $deadline_from = isset($row['deadline_from']) ? date('d-m-Y', strtotime($row['deadline_from'])) : '';
                $deadline_to = isset($row['deadline_to']) ? date('d-m-Y', strtotime($row['deadline_to'])) : '';
                $vm_completed_date = isset($row['v_date']) ? date('d-m-Y', strtotime($row['v_date'])) : '';
                if ($row['check_id'] == 14) {
                    $clgname = $education_details['collegename_add'];
                    $uniname = $education_details['affliated'];
                } else {
                    $clgname = '';
                    $uniname = '';
                }


                if ($row['check_id'] == 59) {
                    $cmpnyname = $company_details['company_name'];
                } else if ($row['check_id'] == 68) {
                    $cmpnyname = $professional_details['company_name'];
                } else {
                    $cmpnyname = '';
                }
                if (!empty($status1['name'])) {
                    $stat = $status1['name'] . '-' . $status2['name'] . '-' . $status3['name'] . '' . $status41;
                } else {
                    $stat = '';
                }

                $response->rows[]['cell'] = array(
                    $i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], anchor('/Verification/vm_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']), $row['candidate_name']), $row['case_no'], $row['checkname'], $deadline_from, $deadline_to, $vm_completed_date, $stat, $cmpnyname, $clgname, $uniname, $verfier_details, anchor('/Verification/vm_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']), 'View')
                );
            }
        }
        echo json_encode($response);
    }

    function reports_ckecklist()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        $request_id = base64_decode($this->uri->segment(3));
        $verification_data = $this->vm->getverificationaldata($request_id);

        $this->db->select('candidate_name');
        $ver = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['verification'] = $ver[0]['candidate_name'];
        foreach ($verification_data as $vd) {
            $reports_d = $this->vm->getverdatarep($vd['candidate_req_id'], $vd['name'], $vd['level_id']);
            $fields_d = $this->vm->getverdatarepfield($vd['candidate_req_id'], $vd['name'], $vd['level_id']);
            $reports_data[] = $reports_d;
            $fields_data[] = $fields_d;
        }
        $data['reports_data'] = $reports_data;
        $data['fields_data'] = $fields_data;
        $data['verification_data'] = $verification_data;
        $this->amodel->pagerender($data, 'verification_reports');
    }
    function qc1_verification()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC1 Assignee List', 'Verification/qc1_verification');

        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $assignee_list = $this->qc->get_quality_list();
        $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list, array('assignee_id', 'name'));
        $this->amodel->pagerender($data, 'allotted_list');
    }
    /* qc1 allocation*/
    function get_qcallotedlist()
    {
        $model = array('Verification_model' => 'get_qc1userlist');
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $a_status = ($_REQUEST['a_status']) ? $_REQUEST['a_status'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $list_status = ($_REQUEST['list_status']) ? $_REQUEST['list_status'] : '';
        if ($office)
            $condition[] = " c.id = " . $office;

        if ($parent_office)
            $condition[] = " p.id = " . $parent_office;

        if ($sub_office)
            $condition[] = " s.id = " . $sub_office;

        if ($org_id)
            $condition[] = " o.id = " . $org_id;

        if ($name)
            $condition[] = " r.candidate_name like '%" . $name . "%'";

        if ($a_status == 1)
            $condition[] = " q.qc_assignee_status = 1";

        if ($a_status == 2)
            $condition[] = " a.assignee_status = 1 and q.qc_assignee_status IS NULL ";
        //18/01/2024
        $case_no = trim($case_no);
        if ($case_no)
            $condition[] = " r.case_no like '%" . $case_no . "'";

        if ($list_status == 1) {
            $condition[] = " ( (
			(select count(vl.request_id) FROM " . DB_PREFIX . "verified_level vl LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar1 ON ar1.candidate_req_id = vl.request_id and vl.check_id = ar1.check_id AND vl.level_id = ar1.level_id where vl.request_id = a.request_id  and (ar1.verify_status IN (111,110,519)) 

			) = (select sum(no_checks) FROM " . DB_PREFIX . "request_check re where re.request_id=a.request_id ) ) 
			and ((select sum(no_checks) FROM " . DB_PREFIX . "request_check rq where rq.request_id=a.request_id ) != (select count(va.rep_id) FROM " . DB_PREFIX . "ver_assign_rep va LEFT JOIN " . DB_PREFIX . "verified_level vl2 ON va.candidate_req_id = vl2.request_id and vl2.check_id = va.check_id AND vl2.level_id = va.level_id where va.candidate_req_id = a.request_id and vl2.qcstatus IN (111,110,519)))) and a.assignee_status = 1 and q.qc_assignee_status IS NULL ";
        }
        if ($list_status == 2) {
            $condition[] = " ( vl1.vm_discrepency in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701) AND vl1.qcstatus in(0,107)) and a.assignee_status = 1 and q.qc_assignee_status IS NULL ";
        }

        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( r.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " o.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " p.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " r.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " s.office_name " . $not . "LIKE '%" . $t . "%' ) ";

                $condition[] = $like;
            }
        }


        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {
                $qc_assigndetails = $this->vm->qc_assaindata($row['request_id']);
                $check = '<input type="checkbox" name="request_id[]" value="' . ($row['request_id']) . '"/>';
                if ($qc_assigndetails) {
                    $response->rows[$i]['cell'] = array($i + $count + 1, $check, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], $row['candidate_name'], $row['case_no'], $qc_assigndetails[0]['first_name'], 'Assigned', anchor('/Verification/qc_assignee/' . base64_encode($row['request_id']), 'Reassign'));
                } else {
                    $response->rows[$i]['cell'] = array($i + $count + 1, $check, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], anchor('/Verification/qc_assignee/' . base64_encode($row['request_id']), $row['candidate_name']), $row['case_no'], 'Not yet Assigned', 'New', anchor('/Verification/qc_assignee/' . base64_encode($row['request_id']), 'Assign'));
                }
            }
        }
        echo json_encode($response);
    }
    function acc()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC1 ACC List', 'Verification/acc');

        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'acc');
    }
    function get_acclist()
    {
        $model = array('Verification_model' => 'get_qc1accallottedlist');
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';

        if ($office)
            $condition[] = " c.id = " . $office;

        if ($parent_office)
            $condition[] = " p.id = " . $parent_office;

        if ($sub_office)
            $condition[] = " s.id = " . $sub_office;

        if ($org_id)
            $condition[] = " o.id = " . $org_id;

        if ($name)
            $condition[] = " r.candidate_name like '%" . $name . "%'";
        //18/01/2024
        $case_no = trim($case_no);
        if ($case_no)
            $condition[] = " r.case_no like '%" . $case_no . "'";

        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " r.candidate_name " . $not . "LIKE '%" . $t . "%' ) ";
                $like    .= $operator . " o.org_name " . $not . "LIKE '%" . $t . "%' ) ";
                $like    .= $operator . " r.case_no " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }


        $manual_cond = implode(' and ', $condition);

        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;

            foreach ($result as $i => $row) {
                $ttl_no_of_accchk = $this->vm->getcountchecksverify($row['request_id']);
                $accchk = count($ttl_no_of_accchk);
                $vm_assign_accchk = $this->vm->getcountvmassign($row['request_id']);
                $vmassignaccchk = count($vm_assign_accchk);

                if ($vmassignaccchk == $accchk) {
                    $views = anchor('/Verification/check_wise_assign/' . base64_encode($row['request_id']), "View", 'target=_blank');
                    $names = anchor('/Verification/check_wise_assign/' . base64_encode($row['request_id']), $row['candidate_name'], 'target=_blank');
                } elseif ($vmassignaccchk != $accchk) {
                    $names = '';
                    $views = '';
                }
                $response->rows[$i]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], anchor('/Verification/check_wise_assign/' . base64_encode($row['request_id']), $row['candidate_name'], 'target=_blank'), $row['case_no'], anchor('/Verification/check_wise_assign/' . base64_encode($row['request_id']), "View", 'target=_blank'));
            }
        }
        echo json_encode($response);
    }
    function check_wise_assign()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC1 Assignee List', 'Verification/qc1_verification');
        $data['request_id'] = base64_decode($this->uri->segment(3));
        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'reports');
    }
    /*ACC check wise */
    function get_check_wise_assign()
    {
        $model = array('Verification_model' => 'get_check_wise_assign');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $request_id = ($_REQUEST['request_id']) ? $_REQUEST['request_id'] : '';
        if ($org_id)
            $condition[] = " o.id = " . $org_id;
        if ($office)
            $condition[] = " c.id = " . $office;
        if ($parent_office)
            $condition[] = " d.parent = " . $parent_office;
        if ($sub_office)
            $condition[] = " e.sub_office = " . $sub_office;
        if ($check_name)
            $condition[] = " md.name like '%" . $check_name . "%'";
        if ($name)
            $condition[] = " cr.candidate_name like '%" . $name . "%'";
        if ($case_no)
            $condition[] = " cr.case_no like '%" . $case_no . "'";
        if ($request_id)
            $condition[] = " a.request_id = " . $request_id;

        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.locality " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " md.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vl1.status " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }

        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;

            foreach ($result as $i => $row) {
                $verified_data = $this->vm->get_verified_data($row['request_id'], $row['level_id'], $row['check_id']);
                $verification_data = toArray(json_decode($verified_data['qcfielddata']));
                $status4 = '';
                $status1 = $this->vm->get_status($verification_data['status']);
                $status2 = $this->vm->get_status($verification_data['pstatus']);
                $status3 = $this->vm->get_status($verification_data['status1']);
                if ($verification_data['ostatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['ostatus']);
                if ($verification_data['dstatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['dstatus']);
                if (!empty($status4))
                    $status41 = '-' . $status4['name'];
                else
                    $status41 = '';

                $slug = url_title(convert_accented_characters($row['name']), 'underscore', TRUE);

                if ($row['check_id'] == 14)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'education_details');
                else if ($row['check_id'] == 16)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'contact_details', 'request_id', 'permanent_address');
                else if ($row['check_id'] == 59)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'employment', 'req_id', 'level_id');
                else if ($row['check_id'] == 76 || $row['check_id'] == 77 || $row['check_id'] == 75)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], $slug, 'request_id', 'level_name');
                else
                    $levelnames['level'] = $row['name'];

                $cname = $row['candidate_name'];
                if ($row['status'] == 1) {
                    if ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc1_verification'] == 1 && $row['qc2_revert_request'] == 0) {
                        $cname = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'QC1 Approved';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['qc1_assign_revert'] == 1 && $row['qc1_verification'] == 1 && $row['qc2_revert_request'] == 1) {
                        $cname = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'Revert Rectified';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc1_verification'] == 1 && $row['qc2_revert_request'] == 1) {
                        $cname = anchor('/Verification/qccal_revert_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'Revert Assigned';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } else if ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc2_revert_request'] == 0) {
                        $cname = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'Revert Closed';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['qc2_revert_request'] == 0) {
                        $cname = $row['candidate_name'];
                        $status = 'Revert Raised';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['qc2_revert_request'] == 1) {
                        $cname = $row['candidate_name'];
                        $status = 'Revert Raised';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc2_verification'] == 0 && $row['qc1_verification'] == 0) {
                        $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qcstatus');
                        if ($statusname['name'])
                            $status = $statusname['name'];
                        else
                            $status = 'New';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                        if ($row['qc1_verification'] == 0)
                            $cname = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        else
                            $cname = $row['candidate_name'];
                    } else {
                        $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qc2status');
                        $status = $statusname['name'];
                        if ($statusname['name'] == 'Verified') {
                            $status = 'QC1 Approved';
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                            $cname = anchor('/Verification/qc_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        } else {
                            $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qcstatus');
                            if ($statusname['name'] == 'Verified') {
                                $status = 'QC1 Approved';
                            } else {
                                $status = $statusname['name'];
                            }
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                            $cname = anchor('/Verification/qc_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        }
                    }

                    if ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1)
                        $action_name = anchor('/Verification/qc_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View', 'target="_blank"');
                    elseif ($row['qc_revert_request'] == 1)
                        $action_name = 'View';
                    elseif ($row['qc1_verification'] == 0)
                        $action_name = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                    else
                        $action_name = anchor('/Verification/qc_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                } else {
                    $status = 'Verification Pending';
                }

                if ($row['chk'] == 0) {
                    $chkval = $row['name'];
                } else {
                    $chkval = $row['name'] . $row['chk'];
                }
                if (!empty($status1['name'])) {
                    $stat = $status1['name'] . '-' . $status2['name'] . '-' . $status3['name'] . '' . $status41;
                } else {
                    $stat = '';
                }

                $response->rows[]['cell'] = array($i + $count + 1, $row['case_no'], $cname, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], $chkval, $status, $stat, $verfier_details, $caller_details, $action_name);
            }
        }

        echo json_encode($response);
    }
    function qcacc()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC2 ACC List', 'Verification/qcacc');

        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'qcacc');
    }
    function get_qcacclist()
    {
        $model = array('Verification_model' => 'get_qc2accallottedlist');
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';

        if ($office)
            $condition[] = " c.id = " . $office;

        if ($parent_office)
            $condition[] = " p.id = " . $parent_office;

        if ($sub_office)
            $condition[] = " s.id = " . $sub_office;

        if ($org_id)
            $condition[] = " o.id = " . $org_id;

        if ($name)
            $condition[] = " r.candidate_name like '%" . $name . "%'";

        if ($case_no)
            $condition[] = " r.case_no like '%" . $case_no . "'";

        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " r.candidate_name " . $not . "LIKE '%" . $t . "%'  ";
                $like    .= $operator . " o.org_name " . $not . "LIKE '%" . $t . "%'  ";
                $like    .= $operator . " r.case_no " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }


        $manual_cond = implode(' and ', $condition);

        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;

            foreach ($result as $i => $row) {
                $views = anchor('/Verification/check_wise_qcassign/' . base64_encode($row['request_id']), "View", 'target=_blank');
                $name = anchor('/Verification/check_wise_qcassign/' . base64_encode($row['request_id']), $row['candidate_name'], 'target=_blank');
                $response->rows[$i]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], $name, $row['case_no'], $views);
            }
        }
        echo json_encode($response);
    }
    function check_wise_qcassign()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC1 Assignee List', 'Verification/qc1_verification');
        $data['request_id'] = base64_decode($this->uri->segment(3));
        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'reports');
    }
    /*ACC QC check wise */
    function get_check_wise_qcassign()
    {
        $model = array('Verification_model' => 'get_check_wise_assign');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $a_date = ($_REQUEST['a_date']) ? $_REQUEST['a_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $request_id = ($_REQUEST['request_id']) ? $_REQUEST['request_id'] : '';
        if ($org_id)
            $condition[] = " o.id = " . $org_id;
        if ($office)
            $condition[] = " c.id = " . $office;
        if ($parent_office)
            $condition[] = " c.parent_office = " . $parent_office;
        if ($sub_office)
            $condition[] = " cr.sub_office = " . $sub_office;
        if ($check_name)
            $condition[] = " md.name like '%" . $check_name . "%'";

        if ($name)
            $condition[] = " cr.candidate_name like '%" . $name . "%'";
        if ($a_date)
            $condition[] = "DATE_FORMAT(vl1.qc_date,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($a_date)) . "'";
        if ($t_date)
            $condition[] = "DATE_FORMAT(vl1.qc_date,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        if ($case_no)
            $condition[] = " cr.case_no like '%" . $case_no . "'";
        if ($request_id)
            $condition[] = " a.request_id = " . $request_id;
        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.locality " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " md.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vs.qc1_status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vs.qc1_discrapancy " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vl1.status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " ar.vm_assigned_qc " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }

        $manual_cond = implode(' and ', $condition);

        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {
                $verified_data = $this->vm->get_verified_data($row['request_id'], $row['level_id'], $row['check_id']);
                $verification_data = toArray(json_decode($verified_data['qc2fielddata']));
                $status4 = '';
                $status1 = $this->vm->get_status($verification_data['status']);
                $status2 = $this->vm->get_status($verification_data['pstatus']);
                $status3 = $this->vm->get_status($verification_data['status1']);
                if ($verification_data['ostatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['ostatus']);
                if ($verification_data['dstatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['dstatus']);
                if (!empty($status4))
                    $status41 = '-' . $status4['name'];
                else
                    $status41 = '';
                if ($row['qc_date']) {
                    $row['qc_date'] = date('d-m-Y H:i:s', strtotime($row['qc_date']));
                }


                $slug = url_title(convert_accented_characters($row['name']), 'underscore', TRUE);
                if ($row['check_id'] == 14)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'education_details');
                else if ($row['check_id'] == 16)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'contact_details', 'request_id', 'permanent_address');
                else if ($row['check_id'] == 59)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'employment', 'req_id', 'level_id');
                else if ($row['check_id'] == 76 || $row['check_id'] == 77 || $row['check_id'] == 75)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], $slug, 'request_id', 'level_name');
                else
                    $levelnames['level'] = $row['name'];

                $cname = $row['candidate_name'];
                if ($row['status'] == 1) {
                    if ($row['qc2_verification'] == 0 && $row['qc1_verification'] == 1 && $row['qc2status'] != 107) {

                        $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qcstatus');
                        $status = 'New';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');

                        if ($row['qc_revert_request'] == 0) {
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else if ($row['qc_revert_request'] == 1 && $row['qc2_revert_request'] == 0) {
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else if ($row['qc1_assign_revert'] == 1) {
                            $status = 'Revert Closed';
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else if ($row['qc2_revert_request'] == 1) {
                            $status = 'Revert Raised';
                            $cname = $row['candidate_name'];
                            $action_name = 'View';
                        }
                    } else {
                        $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qc2status');
                        if ($statusname['name'] == 'Clear') {
                            $status = 'QC2 Approved';
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                        } else if ($statusname['name'] == 'Verified') {
                            $status = 'QC2 Approved';
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                        } else if ($row['qc2_verification'] == 0 && $row['qc1_verification'] == 1 && $row['qc2status'] == 107) {
                            $status = 'Initiated';
                        } else {
                            $status = 'QC2 Approved';
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                        }
                        if ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 0) {
                            if ($row['qc1_assign_revert'] == 1) {
                                $status = 'QC2 Approved';
                            } else if ($row['qc2_revert_request'] == 1) {
                                $status = 'Revert Raised';
                            }

                            $cname = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 1) {
                            $status = 'Report Published';
                            $cname = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 2 && $row['qc2_revert_request'] == 0) {
                            $status = 'Report Reopen';
                            $cname = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Reopen');
                        } elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 2 && $row['qc2_revert_request'] == 1 && $row['qc1_assign_revert'] == 0) {
                            $status = 'Revert Raised';
                            $cname = $row['candidate_name'];
                            $action_name = 'View';
                        } elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 2  && $row['qc1_assign_revert'] == 1) {
                            $status = 'Revert Raised';
                            $cname = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        }
                        //revert status for qc submit qc2 publish reverted
                        elseif ($row['qc1_assign_revert'] == 1 && $row['qc_2_verification'] == 0) {
                            $status = 'Revert Closed';
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else if ($row['qc2_verification'] == 0 && $row['qc1_verification'] == 1 && $row['qc2status'] == 107) {
                            $status = 'Initiated';
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else {
                            $cname = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        }
                    }
                } else
                    $status = 'Verification Pending';


                if ($row['chk'] == 0) {
                    $chkval = $row['name'];
                } else {
                    $chkval = $row['name'] . $row['chk'];
                }
                if (!empty($status1['name'])) {
                    $stat = $status1['name'] . '-' . $status2['name'] . '-' . $status3['name'] . '' . $status41;
                } else {
                    $stat = '';
                }


                $qc_assigndetails = $this->vm->qc_assaindata($row['request_id']);
                $response->rows[]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'],  $cname, $row['case_no'], $chkval, $status, $stat, $verfier_details, $caller_details, $row['qc_date'], $action_name);
            }
        }

        echo json_encode($response);
    }

    function discrepency()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC1 Assignee List', 'Verification/qc1_verification');

        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'allotted_list');
    }
    /*discrepency list */
    function get_discrepencylist()
    {
        $model = array('Verification_model' => 'get_qc1discrepencylist');

        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        if ($org_id)
            $condition[] = " o.id = " . $org_id;
        if ($office)
            $condition[] = " c.id = " . $office;
        if ($parent_office)
            $condition[] = " d.parent = " . $parent_office;
        if ($sub_office)
            $condition[] = " e.sub_office = " . $sub_office;
        if ($check_name)
            $condition[] = " md.name like '%" . $check_name . "%'";
        if ($name)
            $condition[] = " cr.candidate_name like '%" . $name . "%'";
        //18/01/2024
        $case_no = trim($case_no);
        if ($case_no)
            $condition[] = " cr.case_no like '%" . $case_no . "'";

        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.locality " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " md.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vl1.status " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }

        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;

            foreach ($result as $i => $row) {
                $verified_data = $this->vm->get_verified_data($row['request_id'], $row['level_id'], $row['check_id']);
                $verification_data = toArray(json_decode($verified_data['qcfielddata']));
                $status4 = '';
                $status1 = $this->vm->get_status($verification_data['status']);
                $status2 = $this->vm->get_status($verification_data['pstatus']);
                $status3 = $this->vm->get_status($verification_data['status1']);
                if ($verification_data['ostatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['ostatus']);
                if ($verification_data['dstatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['dstatus']);
                if (!empty($status4))
                    $status41 = '-' . $status4['name'];
                else
                    $status41 = '';

                $slug = url_title(convert_accented_characters($row['name']), 'underscore', TRUE);

                if ($row['check_id'] == 14)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'education_details');
                else if ($row['check_id'] == 16)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'contact_details', 'request_id', 'permanent_address');
                else if ($row['check_id'] == 59)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'employment', 'req_id', 'level_id');
                else if ($row['check_id'] == 76 || $row['check_id'] == 77 || $row['check_id'] == 75)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], $slug, 'request_id', 'level_name');
                else
                    $levelnames['level'] = $row['name'];

                $cname = $row['candidate_name'];
                if ($row['status'] == 1) {
                    if ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc1_verification'] == 1 && $row['qc2_revert_request'] == 0) {
                        $cname = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'QC1 Approved';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['qc1_assign_revert'] == 1 && $row['qc1_verification'] == 1 && $row['qc2_revert_request'] == 1) {
                        $cname = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'Revert Rectified';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc1_verification'] == 1 && $row['qc2_revert_request'] == 1) {
                        $cname = anchor('/Verification/qccal_revert_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'Revert Assigned';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } else if ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc2_revert_request'] == 0) {
                        $cname = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'Revert Closed';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['qc2_revert_request'] == 0) {
                        $cname = $row['candidate_name'];
                        $status = 'Revert Raised';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['qc2_revert_request'] == 1) {
                        $cname = $row['candidate_name'];
                        $status = 'Revert Raised';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc2_verification'] == 0 && $row['qc1_verification'] == 0) {
                        $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qcstatus');
                        if ($statusname['name'])
                            $status = $statusname['name'];
                        else
                            $status = 'New';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                        if ($row['qc1_verification'] == 0)
                            $cname = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        else
                            $cname = $row['candidate_name'];
                    } else {
                        $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qc2status');
                        $status = $statusname['name'];
                        if ($statusname['name'] == 'Verified') {
                            $status = 'QC1 Approved';
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                            $cname = anchor('/Verification/qc_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        } else {
                            $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qcstatus');
                            if ($statusname['name'] == 'Verified') {
                                $status = 'QC1 Approved';
                            } else {
                                $status = $statusname['name'];
                            }
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                            $cname = anchor('/Verification/qc_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        }
                    }

                    if ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1)
                        $action_name = anchor('/Verification/qc_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View', 'target="_blank"');
                    elseif ($row['qc_revert_request'] == 1)
                        $action_name = 'View';
                    elseif ($row['qc1_verification'] == 0)
                        $action_name = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                    else
                        $action_name = anchor('/Verification/qc_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                } else {
                    $status = 'Verification Pending';
                }

                if ($row['chk'] == 0) {
                    $chkval = $row['name'];
                } else {
                    $chkval = $row['name'] . $row['chk'];
                }
                if (!empty($status1['name'])) {
                    $stat = $status1['name'] . '-' . $status2['name'] . '-' . $status3['name'] . '' . $status41;
                } else {
                    $stat = '';
                }

                $response->rows[]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], $cname, $row['case_no'], $chkval, $status, $stat, $verfier_details, $caller_details, $action_name);
            }
        }

        echo json_encode($response);
    }
    function qcdiscrepency()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC Discrepency List', 'Verification/qcdiscrepency');

        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'qcdiscrepency');
    }
    /*QC discrepency list */
    function get_qcdiscrepencylist()
    {
        $model = array('Verification_model' => 'get_qc2discrepencylist');

        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $a_date = ($_REQUEST['a_date']) ? $_REQUEST['a_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        if ($org_id)
            $condition[] = " o.id = " . $org_id;
        if ($office)
            $condition[] = " c.id = " . $office;
        if ($parent_office)
            $condition[] = " c.parent_office = " . $parent_office;
        if ($sub_office)
            $condition[] = " cr.sub_office = " . $sub_office;
        if ($check_name)
            $condition[] = " md.name like '%" . $check_name . "%'";
        if ($name)
            $condition[] = " cr.candidate_name like '%" . $name . "%'";
        if ($a_date)
            $condition[] = "DATE_FORMAT(vl1.qc_date,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($a_date)) . "'";
        if ($t_date)
            $condition[] = "DATE_FORMAT(vl1.qc_date,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        if ($case_no)
            $condition[] = " cr.case_no like '%" . $case_no . "'";
        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.locality " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " md.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vs.qc1_status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vs.qc1_discrapancy " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vl1.status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " ar.vm_assigned_qc " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }

        $manual_cond = implode(' and ', $condition);

        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {
                $verified_data = $this->vm->get_verified_data($row['request_id'], $row['level_id'], $row['check_id']);
                $verification_data = toArray(json_decode($verified_data['qc2fielddata']));
                $status4 = '';
                $status1 = $this->vm->get_status($verification_data['status']);
                $status2 = $this->vm->get_status($verification_data['pstatus']);
                $status3 = $this->vm->get_status($verification_data['status1']);
                if ($verification_data['ostatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['ostatus']);
                if ($verification_data['dstatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['dstatus']);
                if (!empty($status4))
                    $status41 = '-' . $status4['name'];
                else
                    $status41 = '';
                if ($row['qc_date']) {
                    $row['qc_date'] = date('d-m-Y H:i:s', strtotime($row['qc_date']));
                }


                $slug = url_title(convert_accented_characters($row['name']), 'underscore', TRUE);
                if ($row['check_id'] == 14)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'education_details');
                else if ($row['check_id'] == 16)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'contact_details', 'request_id', 'permanent_address');
                else if ($row['check_id'] == 59)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'employment', 'req_id', 'level_id');
                else if ($row['check_id'] == 76 || $row['check_id'] == 77 || $row['check_id'] == 75)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], $slug, 'request_id', 'level_name');
                else
                    $levelnames['level'] = $row['name'];

                $cname = $row['candidate_name'];
                if ($row['status'] == 1) {
                    if ($row['qc2_verification'] == 0 && $row['qc1_verification'] == 1 && $row['qc2status'] != 107) {

                        $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qcstatus');
                        $status = 'New';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');

                        if ($row['qc_revert_request'] == 0) {
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else if ($row['qc_revert_request'] == 1 && $row['qc2_revert_request'] == 0) {
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else if ($row['qc1_assign_revert'] == 1) {
                            $status = 'Revert Closed';
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else if ($row['qc2_revert_request'] == 1) {
                            $status = 'Revert Raised';
                            $cname = $row['candidate_name'];
                            $action_name = 'View';
                        }
                    } else {
                        $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qc2status');
                        if ($statusname['name'] == 'Clear') {
                            $status = 'QC2 Approved';
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                        } else if ($statusname['name'] == 'Verified') {
                            $status = 'QC2 Approved';
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                        } else if ($row['qc2_verification'] == 0 && $row['qc1_verification'] == 1 && $row['qc2status'] == 107) {
                            $status = 'Initiated';
                        } else {
                            $status = 'QC2 Approved';
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                        }
                        if ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 0) {
                            if ($row['qc1_assign_revert'] == 1) {
                                $status = 'QC2 Approved';
                            } else if ($row['qc2_revert_request'] == 1) {
                                $status = 'Revert Raised';
                            }

                            $cname = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 1) {
                            $status = 'Report Published';
                            $cname = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 2 && $row['qc2_revert_request'] == 0) {
                            $status = 'Report Reopen';
                            $cname = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Reopen');
                        } elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 2 && $row['qc2_revert_request'] == 1 && $row['qc1_assign_revert'] == 0) {
                            $status = 'Revert Raised';
                            $cname = $row['candidate_name'];
                            $action_name = 'View';
                        } elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 2  && $row['qc1_assign_revert'] == 1) {
                            $status = 'Revert Raised';
                            $cname = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        }
                        //revert status for qc submit qc2 publish reverted
                        elseif ($row['qc1_assign_revert'] == 1 && $row['qc_2_verification'] == 0) {
                            $status = 'Revert Closed';
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else if ($row['qc2_verification'] == 0 && $row['qc1_verification'] == 1 && $row['qc2status'] == 107) {
                            $status = 'Initiated';
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else {
                            $cname = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        }
                    }
                } else
                    $status = 'Verification Pending';



                if ($row['chk'] == 0) {
                    $chkval = $row['name'];
                } else {
                    $chkval = $row['name'] . $row['chk'];
                }
                if (!empty($status1['name'])) {
                    $stat = $status1['name'] . '-' . $status2['name'] . '-' . $status3['name'] . '' . $status41;
                } else {
                    $stat = '';
                }


                $qc_assigndetails = $this->vm->qc_assaindata($row['request_id']);
                $response->rows[]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], $cname, $row['case_no'], $chkval, $status, $stat, $verfier_details, $caller_details, $row['qc_date'], $action_name);
            }
        }

        echo json_encode($response);
    }
    function qc_assignee()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'jquery.validate', 'jquery-ui-1.8.16.custom.min'));
        $data['request_id'] = $request_id = $this->uri->segment(3);
        $operator_id = base64_decode($this->uri->segment(4));
        $candidate_name = $data['checks_result'] = $this->vm->get_userlist(base64_decode($request_id));
        $data['candidate_name'] = $candidate_name[0]['candidate_name'];
        $assignee_list = $this->vm->get_qcassignee_list();
        if ($operator_id == 0) {
            $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list, array('assignee_id', 'name'));
        } else {
            $operator_name = $this->cm->getopername($operator_id);
            $data['operator_list'] = $operator_name[0];
        }
        $data['title'] = 'New Verification Request';
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'index/dashboard');
        $this->breadcrumbs->push('QC1 Assignee List', 'Verification/qc1_verification');
        $this->breadcrumbs->push('QC Allotment Request', 'Verification/qc_assignee');
        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();

        $this->amodel->pagerender($data, 'new_request');
    }
    function p_qcnewrequest()
    {
        $assignee_id = $this->input->post('assignee_id');
        $date_from = date('Y-m-d');
        $date_to = $this->input->post('date_to');
        $user_id = $this->input->post('user_id');
        $request_id = base64_decode($this->input->post('request_id'));
        $exist_id = $this->vm->getqcreqid($request_id);
        if ($assignee_id) {
            $upd_data = array();
            $upd_data['assignee_id'] = $assignee_id;
            $upd_data['qc_assignee_status'] = 1;
            $upd_data['deadline_from'] = date("Y-m-d", strtotime($date_from));
            $upd_data['deadline_to'] = date("Y-m-d", strtotime($date_to));;
            $upd_data['updated_on'] = date('Y-m-d H:i:s');
            $upd_data['updated_by'] = $this->user_id;
            $upd_data['request_id'] = $request_id;
            $upd_data = $this->security->xss_clean($upd_data);
            $qcrequest_id = $exist_id[0]['request_id'];
            if ($qcrequest_id) {
                $this->db->where('request_id', $qcrequest_id);
                $this->db->update(DB_PREFIX . 'qc_request', $upd_data);
            } else {
                $this->db->insert(DB_PREFIX . 'qc_request', $upd_data);
            }
        }
        redirect(base_url('Verification/qc1_verification'), 'refresh');
    }
    function qc1_allotedlist()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min', 'exporting'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC1 Assigned List', 'Verification/qc1_allotedlist');
        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'allotted_list');
    }
    /* qc1 allotted casewise list*/
    function qc1_casewiselist()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC1 Casewise List', 'Verification/qc1_casewiselist');
        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'qc1_casewiselist');
    }

    /* get data of qc1 allotted casewise list*/
    function get_qc1casewiselist()
    {
        $model = array('Verification_model' => 'get_qc1casewiselist');
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $a_status = ($_REQUEST['a_status']) ? $_REQUEST['a_status'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';

        if ($office)
            $condition[] = " c.id = " . $office;

        if ($parent_office)
            $condition[] = " p.id = " . $parent_office;

        if ($sub_office)
            $condition[] = " s.id = " . $sub_office;

        if ($org_id)
            $condition[] = " o.id = " . $org_id;

        if ($name)
            $condition[] = " r.candidate_name like '%" . $name . "%'";
        //18/01/2024
        $case_no = trim($case_no);
        if ($case_no)
            $condition[] = " r.case_no like '%" . $case_no . "'";

        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( o.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " s.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " p.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " r.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " b.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " r.case_no " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }
        $manual_cond = implode(' and ', $condition);

        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {

                $response->rows[$i]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], $row['candidate_name'], $row['case_no'], anchor('/Verification/qc1_casechecklist/' . base64_encode($row['request_id']), 'View'));
            }
        }
        echo json_encode($response);
    }
    /* particular case check list */
    function qc1_casechecklist()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC1 Checks List', 'Verification/qc1_casechecklist');
        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'qc1_casechecklist');
    }
    /* get cases of checklist of qc1 */
    function get_qc1caseschecklist($req_id)
    {
        $model = array('Verification_model' => 'get_qc1caseschecklist');
        if ($req_id) {
            $condition[] = " a.request_id = " . $req_id;
        }
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';

        if ($org_id)
            $condition[] = " o.id = " . $org_id;
        if ($office)
            $condition[] = " c.id = " . $office;
        if ($parent_office)
            $condition[] = " d.parent = " . $parent_office;
        if ($sub_office)
            $condition[] = " e.sub_office = " . $sub_office;
        if ($check_name)
            $condition[] = " md.name like '%" . $check_name . "%'";
        if ($name)
            $condition[] = " cr.candidate_name like '%" . $name . "%'";
        if ($case_no)
            $condition[] = " cr.case_no like '%" . $case_no . "'";
        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.locality " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " md.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vl1.status " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }

        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;

            foreach ($result as $i => $row) {
                $verified_data = $this->vm->get_verified_data($row['request_id'], $row['level_id'], $row['check_id']);
                $verification_data = toArray(json_decode($verified_data['qcfielddata']));
                $status4 = '';
                $status1 = $this->vm->get_status($verification_data['status']);
                $status2 = $this->vm->get_status($verification_data['pstatus']);
                $status3 = $this->vm->get_status($verification_data['status1']);
                if ($verification_data['ostatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['ostatus']);
                if ($verification_data['dstatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['dstatus']);
                if (!empty($status4))
                    $status41 = '-' . $status4['name'];
                else
                    $status41 = '';

                $slug = url_title(convert_accented_characters($row['name']), 'underscore', TRUE);

                if ($row['check_id'] == 14)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'education_details');
                else if ($row['check_id'] == 16)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'contact_details', 'request_id', 'permanent_address');
                else if ($row['check_id'] == 59)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'employment', 'req_id', 'level_id');
                else if ($row['check_id'] == 76 || $row['check_id'] == 77 || $row['check_id'] == 75)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], $slug, 'request_id', 'level_name');
                else
                    $levelnames['level'] = $row['name'];

                $cname = $row['candidate_name'];
                if ($row['status'] == 1) {
                    if ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc1_verification'] == 1 && $row['qc2_revert_request'] == 0) {
                        $cname = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'QC1 Approved';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['qc1_assign_revert'] == 1 && $row['qc1_verification'] == 1 && $row['qc2_revert_request'] == 1) {
                        $cname = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'Revert Rectified';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc1_verification'] == 1 && $row['qc2_revert_request'] == 1) {
                        $cname = anchor('/Verification/qccal_revert_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'Revert Assigned';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } else if ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc2_revert_request'] == 0) {
                        $cname = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'Revert Closed';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['qc2_revert_request'] == 0) {
                        $cname = $row['candidate_name'];
                        $status = 'Revert Raised';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['qc2_revert_request'] == 1) {
                        $cname = $row['candidate_name'];
                        $status = 'Revert Raised';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc2_verification'] == 0 && $row['qc1_verification'] == 0) {
                        $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qcstatus');
                        if ($statusname['name'])
                            $status = $statusname['name'];
                        else
                            $status = 'New';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                        if ($row['qc1_verification'] == 0)
                            $cname = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        else
                            $cname = $row['candidate_name'];
                    } else {
                        $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qc2status');
                        $status = $statusname['name'];
                        if ($statusname['name'] == 'Verified') {
                            $status = 'QC1 Approved';
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                            $cname = anchor('/Verification/qc_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        } else {
                            $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qcstatus');
                            if ($statusname['name'] == 'Verified') {
                                $status = 'QC1 Approved';
                            } else {
                                $status = $statusname['name'];
                            }
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                            $cname = anchor('/Verification/qc_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        }
                    }

                    if ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1)
                        $action_name = anchor('/Verification/qc_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View', 'target="_blank"');
                    elseif ($row['qc_revert_request'] == 1)
                        $action_name = 'View';
                    elseif ($row['qc1_verification'] == 0)
                        $action_name = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                    else
                        $action_name = anchor('/Verification/qc_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                } else {
                    $status = 'Verification Pending';
                }

                if ($row['chk'] == 0) {
                    $chkval = $row['name'];
                } else {
                    $chkval = $row['name'] . $row['chk'];
                }
                if (!empty($status1['name'])) {
                    $stat = $status1['name'] . '-' . $status2['name'] . '-' . $status3['name'] . '' . $status41;
                } else {
                    $stat = '';
                }

                $response->rows[]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], $cname, $row['case_no'], $chkval, $status, $stat, $verfier_details, $caller_details, $action_name);
            }
        }

        echo json_encode($response);
    }
    /* particular case check list of qc2 */
    function qc2_casechecklist()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC2 Checks List', 'Verification/qc2_casechecklist');
        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'qc2_casechecklist');
    }
    /* Get particular cases checklist*/
    function get_qc2caseschecklist($req_id)
    {
        $model = array('Verification_model' => 'get_qc2casechecklist');
        if ($req_id) {
            $condition[] = " a.request_id = " . $req_id;
        }
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $a_date = ($_REQUEST['a_date']) ? $_REQUEST['a_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        if ($org_id)
            $condition[] = " o.id = " . $org_id;
        if ($office)
            $condition[] = " c.id = " . $office;
        if ($parent_office)
            $condition[] = " d.office_name = " . $parent_office;
        if ($sub_office)
            $condition[] = " s.office_name = " . $sub_office;
        if ($check_name)
            $condition[] = " md.name like '%" . $check_name . "%'";
        if ($name)
            $condition[] = " cr.candidate_name like '%" . $name . "%'";
        if ($a_date)
            $condition[] = "DATE_FORMAT(vl1.qc_date,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($a_date)) . "'";
        if ($t_date)
            $condition[] = "DATE_FORMAT(vl1.qc_date,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        if ($case_no)
            $condition[] = " cr.case_no like '%" . $case_no . "'";
        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " s.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.candidate_name " . $not . "LIKE '%" . $t . "%'  ";
                $like    .= $operator . " o.org_name " . $not . "LIKE '%" . $t . "%'  ";
                $like    .= $operator . " cr.case_no " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }

        $manual_cond = implode(' and ', $condition);

        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {
                $verified_data = $this->vm->get_verified_data($row['request_id'], $row['level_id'], $row['check_id']);
                $verification_data = toArray(json_decode($verified_data['qc2fielddata']));
                $status4 = '';
                $status1 = $this->vm->get_status($verification_data['status']);
                $status2 = $this->vm->get_status($verification_data['pstatus']);
                $status3 = $this->vm->get_status($verification_data['status1']);
                if ($verification_data['ostatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['ostatus']);
                if ($verification_data['dstatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['dstatus']);
                if (!empty($status4))
                    $status41 = '-' . $status4['name'];
                else
                    $status41 = '';
                if ($row['qc_date']) {
                    $row['qc_date'] = date('d-m-Y H:i:s', strtotime($row['qc_date']));
                }


                $slug = url_title(convert_accented_characters($row['name']), 'underscore', TRUE);
                if ($row['check_id'] == 14)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'education_details');
                else if ($row['check_id'] == 16)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'contact_details', 'request_id', 'permanent_address');
                else if ($row['check_id'] == 59)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'employment', 'req_id', 'level_id');
                else if ($row['check_id'] == 76 || $row['check_id'] == 77 || $row['check_id'] == 75)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], $slug, 'request_id', 'level_name');
                else
                    $levelnames['level'] = $row['name'];

                $cname = $row['candidate_name'];
                if ($row['status'] == 1) {
                    if ($row['qc2_verification'] == 0 && $row['qc1_verification'] == 1) {
                        $action_name = '';
                        $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qcstatus');
                        $status = 'New';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');

                        if ($row['qc_revert_request'] == 0) {
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else if ($row['qc_revert_request'] == 1 && $row['qc2_revert_request'] == 0) {
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else if ($row['qc1_assign_revert'] == 1) {
                            $status = 'Revert Closed';
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else if ($row['qc2_revert_request'] == 1) {
                            $status = 'Revert Raised';
                            $cname = $row['candidate_name'];
                            $action_name = 'View';
                        }
                    } else {
                        $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qc2status');
                        if ($statusname['name'] == 'Clear') {
                            $status = 'QC2 Approved';
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                        } else if ($statusname['name'] == 'Verified') {
                            $status = 'QC2 Approved';
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                        } else {
                            $status = $statusname['name'];
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                        }
                        if ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 0) {
                            if ($row['qc1_assign_revert'] == 1) {
                                $status = 'QC2 Approved';
                            } else if ($row['qc2_revert_request'] == 1) {
                                $status = 'Revert Raised';
                            }

                            $cname = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 1) {
                            $status = 'Report Published';
                            $cname = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_reopenchk/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Reopen');
                        } elseif ($row['qc2_verification'] == 1 && $row['qc2_report_publish'] == 2 && $row['qc2_revert_request'] == 0) {
                            $status = 'Report Reopen';
                            $cname = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_reopenchk/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Reopen');
                        } elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 2 && $row['qc2_revert_request'] == 1 && $row['qc1_assign_revert'] == 0) {
                            $status = 'Revert Raised';
                            $cname = $row['candidate_name'];
                            $action_name = 'View';
                        } elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 2  && $row['qc1_assign_revert'] == 1) {
                            $status = 'Revert Raised';
                            $cname = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        }
                        //revert status for qc submit qc2 publish reverted
                        elseif ($row['qc1_assign_revert'] == 1 && $row['qc_2_verification'] == 0) {
                            $status = 'Revert Closed';
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else {
                            $cname = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        }
                    }
                } else {
                    $status = 'Verification Pending';
                    $action_name = '';
                }
                $action2 = '';
                if ($this->session->userdata('role_id') == 1 || $this->session->userdata('role_id') == 21 || $this->session->userdata('role_id') == 24) {
                    if ($row['qc2_verification'] == 1 && $row['qc2_report_publish'] == 1 && $row['final_report'] == 1) {
                        $cname = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $action_name = anchor('/Vsupervisor/reopen_finalreport/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), "<span style='color:red;'>Case Reopen</span>");
                    }
                }
                $action2 = '';
                if ($row['supplementary'] == 1 || $row['supplementary'] == 2) {
                    $action2 = anchor('/Vsupervisor/reopen_finalreport/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), "<span style='color:red;'>Case Reopen</span>");
                    $action_name = 'Case Reopened';
                } else if ($row['supplementary'] == 3) {
                    $action2 = 'Reopen-Completed';
                } else {
                    $action2 = '';
                }
                if ($row['chk'] == 0) {
                    $chkval = $row['name'];
                } else {
                    $chkval = $row['name'] . ' ' . $row['chk'];
                }
                if (!empty($status1['name'])) {
                    $stat = $status1['name'] . '-' . $status2['name'] . '-' . $status3['name'] . '' . $status41;
                } else {
                    $stat = '';
                }


                $qc_assigndetails = $this->vm->qc_assaindata($row['request_id']);
                $response->rows[]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], $cname, $row['case_no'], $chkval, $status, $stat, $verfier_details, $caller_details, $action_name, $action2);
            }
        }

        echo json_encode($response);
    }
    /* qc2 allotted casewise list*/
    function qc2_casewiselist()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC2 Casewise List', 'Verification/qc2_casewiselist');
        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'qc2_casewiselist');
    }

    /* get data of qc2 allotted casewise list*/
    function get_qc2casewiselist()
    {
        $model = array('Verification_model' => 'get_qc2casewiselist');
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $a_status = ($_REQUEST['a_status']) ? $_REQUEST['a_status'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';

        if ($office)
            $condition[] = " c.id = " . $office;

        if ($parent_office)
            $condition[] = " p.id = " . $parent_office;

        if ($sub_office)
            $condition[] = " s.id = " . $sub_office;

        if ($org_id)
            $condition[] = " o.id = " . $org_id;

        if ($name)
            $condition[] = " r.candidate_name like '%" . $name . "%'";
        //18/01/2024
        $case_no = trim($case_no);

        if ($case_no)
            $condition[] = " r.case_no like '%" . $case_no . "'";
        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " p.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " s.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " r.candidate_name " . $not . "LIKE '%" . $t . "%'  ";
                $like    .= $operator . " o.org_name " . $not . "LIKE '%" . $t . "%'  ";
                $like    .= $operator . " r.case_no " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }
        $manual_cond = implode(' and ', $condition);

        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {

                $response->rows[$i]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], $row['candidate_name'], $row['case_no'], anchor('/Verification/qc2_casechecklist/' . base64_encode($row['request_id']), 'View'), anchor('/Verification/qc2additional_report/' . base64_encode($row['request_id']), '<div style="color:#E00E0E;">Add</div>'));
            }
        }
        echo json_encode($response);
    }
    /* additional report to client*/
    function qc2additional_report($request_id)
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4'));
        $this->amodel->loadjsscript(array('jquery.validate', 'jquery.dropdownPlain', 'jquery-ui-1.8.16.custom.min', 'autocomplete'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC2 Additional Report', 'Verification/qc2additional_report');
        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $data['request_id'] = $request_id = base64_decode($request_id);
        $candidate_info = $this->amodel->getDetails(DB_PREFIX . "client_request", array('request_id', 'candidate_name'), array('request_id' => $request_id));
        $data['uploaded_documents'] = $uploaded_documents = $this->amodel->getDetails(DB_PREFIX . "clientadditional_report", array('request_id', 'document_name', 'report_name', 'status', 'id'), array('request_id' => $request_id));
        $data['candidate_info'] = $candidate_info[0];
        $this->amodel->pagerender($data, 'qc2additional_report');
    }
    function addreportstoclient()
    {

        $request_id = $_POST['request_id'];
        $imag_name  = $_FILES['document']['name'];

        $this->db->select('request_id', 'report_name');
        $this->db->from(DB_PREFIX . "clientadditional_report");
        $this->db->where('report_name', $imag_name);
        $this->db->where('request_id', $request_id);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            $row = $query->row_array();

            if ($row == true) {

                echo " <script>alert('This file cannot be attached as it has already been uploaded.'); history.go(-1);</script>";
            }
        } else {

            $this->vm->addreportstoclient();
        }
    }

    // ************DELETE Client Addition Report***************
    function Additionreport_delete()

    {

        $id = $_POST['id'];

        $doc_name = $_POST['doc_name'];

        $config['upload_path'] = 'uploads/additionalreport/';

        if (!empty($id)) {

            unlink($config['upload_path'] . $doc_name);       //delete from folder

            $this->db->where('id', $id);

            $this->db->delete(DB_PREFIX . "clientadditional_report");      //delete  table row



        }
    }
    // ************ END DELETE Client Addition Report***************


    /* qc1 allotted list */
    function get_qcreportslist()
    {
        $model = array('Verification_model' => 'get_qc1list');

        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $verifier_name = ($_REQUEST['verifier_name']) ? $_REQUEST['verifier_name'] : '';
        $qc_name = ($_REQUEST['qc_name']) ? $_REQUEST['qc_name'] : '';

        $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $chk_status = ($_REQUEST['chk_status']) ? $_REQUEST['chk_status'] : '';
        $reopen_status = ($_REQUEST['reopen_status']) ? $_REQUEST['reopen_status'] : '';


        if ($org_id)
            $condition[] = " o.id = " . $org_id;
        if ($office)
            $condition[] = " c.id = " . $office;
        if ($parent_office)
            $condition[] = " d.id = " . $parent_office;
        if ($sub_office)
            $condition[] = " e.sub_office = " . $sub_office;

        if ($a_status == 1)
            $condition[] = "(ar.qc2_verification=0 and ar.qc1_verification=0 and ar.qc_revert_request=0  and vl1.qcstatus!=107)";
        if ($a_status == 2)
            $condition[] = "(ar.qc_revert_request=1 and ar.vm_assigned_qc=1 and ar.qc1_verification=1 and ar.qc2_revert_request=1 and ar.qc1_assign_revert=0)";
        if ($a_status == 3)
            $condition[] = "(ar.qc_revert_request=1 and ar.qc1_assign_revert=1 and ar.qc1_verification=1 and ar.qc2_revert_request=1)";
        if ($a_status == 4)
            $condition[] = "(ar.qc_revert_request=1 and ar.qc2_revert_request=0 and ar.vm_assigned_qc=0)";
        if ($a_status == 5)
            $condition[] = "(ar.qc_revert_request=1 and ar.vm_assigned_qc=1 and ar.qc2_revert_request=0 and ar.qc1_verification=0)";
        if ($a_status == 6)
            $condition[] = "(ar.qc_revert_request=1 and ar.vm_assigned_qc=1 and ar.qc1_verification=1 and ar.qc2_revert_request=0)";
        if ($a_status == 7)
            $condition[] = "( ar.qc_revert_request=0 and ar.qc2_verification=0 and ar.qc1_verification=0 and vl1.qcstatus=107)";

        if ($check_name)
            $condition[] = " md.name like '%" . $check_name . "%'";
        if ($name)
            $condition[] = " cr.candidate_name like '%" . $name . "%'";
        //18/01/2024
        $case_no = trim($case_no);
        if ($case_no)
            $condition[] = " cr.case_no like '%" . $case_no . "'";
        if ($verifier_name)
            $condition[] = "(concat_ws(' ',us.first_name,us.last_name) like '%" . $verifier_name . "%') ";

        if ($qc_name)
            $condition[] = "(concat_ws(' ',us.first_name,us.last_name) like '%" . $qc_name . "%') ";
        if ($c_date)
            $condition[] = "DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "'";
        if ($t_date)
            $condition[] = "DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date . ' -1 day')) . "'";
        if ($chk_status == 1) {
            $condition[] = " vl1.qc_discrepency in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701) ";
        }
        if ($chk_status == 2) {
            $condition[] = " ((vl1.qc_discrepency in (120,131,137,143,713,119,130,136,142)) or (vl1.qcstatus in (519,110)))";
        }
        if ($chk_status == 3) {
            $condition[] = " vl1.qc_discrepency in (116,127,134,140,630,121,125,658,662,660) ";
        }
        if ($reopen_status == 1) {
            $condition[] = " vl1.supplementary in (1,2) ";
        }
        if ($reopen_status == 2) {
            $condition[] = " vl1.supplementary = 3 ";
        }
        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.locality " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " md.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " s.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " o.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vl1.v_date" . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";
                $like    .= $operator . " vl1.qc_date" . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";
                $like    .= $operator . " vl1.status " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }

        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;

            foreach ($result as $i => $row) {
                $verified_data = $this->vm->get_verified_data($row['request_id'], $row['level_id'], $row['check_id']);
                $verification_data = toArray(json_decode($verified_data['qcfielddata']));
                $status4 = '';
                $status1 = $this->vm->get_status($verification_data['status']);
                $status2 = $this->vm->get_status($verification_data['pstatus']);
                $status3 = $this->vm->get_status($verification_data['status1']);
                if ($verification_data['ostatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['ostatus']);
                if ($verification_data['dstatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['dstatus']);
                if (!empty($status4))
                    $status41 = '-' . $status4['name'];
                else
                    $status41 = '';
                $rpt_status = '';
                if ($verification_data['status'] != 107 && $verification_data['status'] != 684 && !empty($verification_data['status'])) {
                    if ($status3['name'] == "Discrepant" || $status3['name'] == "Possible Discrepant" || $status3['name'] == "Record Found" || $status3['name'] == "Positive" || $status3['name'] == "No Records" || $status3['name'] == "Invalid" || $status3['name'] == "Not Completed" || $status3['name'] == "High Risk") {
                        $rpt_status = "<span style='color:red;'>RED</span>";
                    } else if ($status1['name'] == "Stop Check" || $status1['name'] == "Others" || $status3['name'] == "Stop Check" || $status3['name'] == "Others") {
                        $rpt_status = "<span style='color:orange;'>ORANGE</span>";
                    } else {
                        $rpt_status = "<span style='color:green;'>GREEN</span>";
                    }
                }

                $slug = url_title(convert_accented_characters($row['name']), 'underscore', TRUE);

                if ($row['check_id'] == 14)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'education_details');
                else if ($row['check_id'] == 16)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'contact_details', 'request_id', 'permanent_address');
                else if ($row['check_id'] == 59)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'employment', 'req_id', 'level_id');
                else if ($row['check_id'] == 76 || $row['check_id'] == 77 || $row['check_id'] == 75)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], $slug, 'request_id', 'level_name');
                else
                    $levelnames['level'] = $row['name'];

                $cname = $row['candidate_name'];
                if ($row['status'] == 1) {
                    if ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc1_verification'] == 1 && $row['qc2_revert_request'] == 0) {
                        $cname = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'QC1 Approved';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');

                        $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');


                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['qc1_assign_revert'] == 1 && $row['qc1_verification'] == 1 && $row['qc2_revert_request'] == 1) {
                        $cname = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'Revert Rectified';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                        $caller_details = anchget_qcreportslistor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc1_verification'] == 1 && $row['qc2_revert_request'] == 1 && $row['qc2_verification'] == 0 && $row['qc_revert_status'] == 0 && $row['qc1_assign_revert'] == 0 && $row['supplementary'] == 1) {
                        $cname = anchor('/Verification/qccal_revert_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'Reopen Assigned';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc1_verification'] == 1 && $row['qc2_revert_request'] == 1 && $row['qc2_verification'] == 0 && $row['qc_revert_status'] == 0 && $row['qc1_assign_revert'] == 0 && $row['supplementary'] == 1 && $row['reopen_revert_qc'] == 1 || $row['reopen_revert_qc2'] == 1) {
                        $cname = anchor('/Verification/qccal_revert_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'Revert Assigned';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc1_verification'] == 1 && $row['qc2_revert_request'] == 1 && $row['qc2_verification'] == 0 && $row['qc1_assign_revert'] == 0 && $row['supplementary'] == 1 && $row['reopen_revert_qc'] == 1 || $row['reopen_revert_qc2'] == 1) {
                        $cname = anchor('/Verification/qccal_revert_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'Revert Closed';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc1_verification'] == 1 && $row['qc2_revert_request'] == 1 && $row['qc2_verification'] == 0 && $row['qc1_assign_revert'] == 0 && $row['supplementary'] == 1) {
                        $cname = anchor('/Verification/qccal_revert_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'Reopen Closed';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc1_verification'] == 1 && $row['qc2_revert_request'] == 1) {
                        $cname = anchor('/Verification/qccal_revert_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'Revert Assigned';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc1_verification'] == 0 && $row['qc2_revert_request'] == 1) {
                        $cname = anchor('/Verification/qccal_revert_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'Revert Assigned';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } else if ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc2_revert_request'] == 0) {
                        $cname = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        $status = 'Revert Closed';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['qc2_revert_request'] == 0) {
                        $cname = $row['candidate_name'];
                        $status = 'Revert Raised';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 0 && $row['qc1_verification'] == 1 && $row['qc2_revert_request'] == 1 && $row['qc2_verification'] == 0 && $row['qc1_assign_revert'] == 0 && $row['supplementary'] == 1 && $row['reopen_revert_qc'] == 1 || $row['reopen_revert_qc2'] == 1) {
                        $cname = $row['candidate_name'];
                        $status = 'Revert Raised';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['qc2_revert_request'] == 1 && $row['supplementary'] == 1 && $row['vm_assigned_qc'] == 0 && $row['qc1_assign_revert'] == 0) {
                        $cname = $row['candidate_name'];
                        $status = 'Reopened';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc_revert_request'] == 1 && $row['qc2_revert_request'] == 1) {
                        $cname = $row['candidate_name'];
                        $status = 'Revert Raised';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                    } elseif ($row['qc2_verification'] == 0 && $row['qc1_verification'] == 0) {
                        $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qcstatus');
                        if ($statusname['name'])
                            $status = $statusname['name'];
                        else
                            $status = 'New';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                        $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                        if ($row['qc1_verification'] == 0)
                            $cname = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        else
                            $cname = $row['candidate_name'];
                    } else {
                        $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qc2status');
                        $status = $statusname['name'];
                        if ($statusname['name'] == 'Verified') {
                            $status = 'QC1 Approved';
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                            $cname = anchor('/Verification/qc_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        } else {
                            $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qcstatus');
                            if ($statusname['name'] == 'Verified') {
                                $status = 'QC1 Approved';
                            } else {
                                $status = 'Verified';
                            }
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                            $cname = anchor('/Verification/qc_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                        }
                    }

                    if ($row['qc_revert_request'] == 1 && $row['vm_assigned_qc'] == 1)
                        $action_name = anchor('/Verification/qc_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View', 'target="_blank"');
                    elseif ($row['qc_revert_request'] == 1)
                        $action_name = 'View';
                    elseif ($row['qc1_verification'] == 0)
                        $action_name = anchor('/Verification/qccal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                    else
                        $action_name = anchor('/Verification/qc_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                } else {
                    $status = 'Verification Pending';
                }

                if ($row['chk'] == 0) {
                    $chkval = $row['name'];
                } else {
                    $chkval = $row['name'] . $row['chk'];
                }
                if (!empty($status1['name'])) {
                    $stat = $status1['name'] . '-' . $status2['name'] . '-' . $status3['name'] . '' . $status41;
                } else {
                    $stat = '';
                }
                $supplement = '';
                if ($row['supplementary'] == 1 || $row['supplementary'] == 2) {
                    $supplement = 'Reopen';
                } elseif ($row['supplementary'] == 3) {
                    $supplement = 'Reopen-Completed';
                }
                $deadline_from = isset($row['v_date']) ? date('d-m-Y', strtotime($row['v_date'])) : '';
                $deadline_to = isset($row['v_date']) ? date('d-m-Y', strtotime($row['v_date'] . ' +1 day')) : '';
                $qcrevert_date = (isset($row['qc_revert_date']) && $row['qc_revert_date'] != "0000-00-00 00:00:00") ? date('d-m-Y', strtotime($row['qc_revert_date'])) : '';
                $response->rows[]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], $cname, $row['case_no'], $chkval, $status, $stat, $rpt_status, $supplement, $procedure_details, $verfier_details, $caller_details, $row['vmname'], $row['qcname'], $qcrevert_date, $deadline_from, $deadline_to, $action_name);
            }
        }

        echo json_encode($response);
    }

    function qc_reports()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        $request_id = base64_decode($this->uri->segment(3));
        $this->db->select('order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';
        $personalreport_data = $this->vm->personalreportsdata($request_id);
        $data['personal_data'] = $personalreport_data;

        $educationreport_data = $this->vm->edu_reportsdata($request_id);
        $data['education_data'] = $educationreport_data;

        $data['other_details'] = $this->vm->otherreportsdata($request_id);
        $data['dataentrypersonal'] = $this->vm->personaldetails($request_id);
        $data['dataentryeducation'] = $this->vm->educationdetails($request_id);
        $data['dataentryother'] = $this->vm->otherdetails($request_id);
        $data['user_checkdata'] = $this->vm->get_user_checkdata($request_id);
        $data['status'] = $this->vm->get_ver1status($request_id);
        $this->amodel->pagerender($data, 'verification_reports');
    }
    function qc2_reports()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        $request_id = base64_decode($this->uri->segment(3));
        $this->db->select('order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';
        $personalreport_data = $this->vm->personalreportsdata($request_id);
        $data['personal_data'] = $personalreport_data;

        $educationreport_data = $this->vm->edu_reportsdata($request_id);
        $data['education_data'] = $educationreport_data;

        $data['other_details'] = $this->vm->otherreportsdata($request_id);
        $data['dataentrypersonal'] = $this->vm->personaldetails($request_id);
        $data['dataentryeducation'] = $this->vm->educationdetails($request_id);
        $data['dataentryother'] = $this->vm->otherdetails($request_id);
        $data['user_checkdata'] = $this->vm->get_user_checkdata($request_id);
        $data['status'] = $this->vm->get_ver2status($request_id);
        $this->amodel->pagerender($data, 'qc2_reports');
    }

    function qccal_reports()
    {

        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'jquery-ui-1.8.16.custom.min', 'commonjs', 'jquery.validate', 'multipleclone'));
        $condition['candidate_req_id'] = $data['candidate_req_id'] = $request_id = base64_decode($this->uri->segment(3));
        $condition['level_id'] = $data['level_id'] = $level_id = base64_decode($this->uri->segment(4));
        $condition['check_id'] = $data['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $condition['pack_id'] = $data['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));
        $checkreport = $this->vm->check_report($condition);
        $revertreport = $this->vm->revert_report($condition);
        if ($checkreport['qc1_verification'] <> 0)
            redirect('Index/dashboard');


        $this->db->select('name');
        $order = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->result_array();
        $key = $data['key'] = $order[0]['name'];
        $this->db->select('order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';
        $this->db->select('name');
        $data['checkname'] = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->row_array();
        $slug = url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);
        $data['revertcomment'] = $revertreport;
        $revert_id =      $revertreport['qc_revert_reason'];
        $revert_name = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $revert_id))->row_array();
        $data['revert_name'] =  $revert_name['name'];
        if ($pack_id > 94)
            $level_details = $this->dm->$slug($request_id, $pack_id, $level_id);
        else
            $level_details = $this->dm->$slug($request_id, $check_id, $level_id);

        //30/10/2023   
        // if($check_id==651)
        //     {

        //        $data['check_id']=$check_id;
        //        $data['icc_data']=$icc_data=$this->db->query("select current_address,cperiod_of_stay,cperiod_from,cperiod_to from ". DB_PREFIX ."icc_doc where request_id=".$request_id." && check_id=".$check_id."")->result_array();

        //        foreach($icc_data as $keyy => $iccvalue){

        //        	$iccidx = $keyy+1;
        //        	$iccadr = 'current_address'.$iccidx;
        //        	$iccstay = 'cperiod_of_stay'.$iccidx;
        //        	$iccfrom = 'cperiod_from'.$iccidx;
        //        	$iccto = 'cperiod_to'.$iccidx; 
        //        	$level_details[0][$iccadr] = $iccvalue['current_address'];
        //        	$level_details[0][$iccstay] = $iccvalue['cperiod_of_stay'];
        //        	$level_details[0][$iccfrom] = $iccvalue['cperiod_from'];
        //        	$level_details[0][$iccto] = $iccvalue['cperiod_to'];

        //        }
        //     }  
        $this->db->select('id');
        $checkname = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('parent' => $check_id, 'name' => $level_details[0]['level_name']))->row_array();

        $data['dataentrydata'] = $level_details[0];
        $data['verified_data'] = $verified_data = $this->vm->get_verified_data($request_id, $level_id, $check_id);
        $data['expencedata'] = toArray(json_decode($verified_data['vmexpenses']));
        if ($check_id == 76 || $check_id == 77) {
            $check_id = $checkname['id'];
            $data['scheck_id'] = $check_id;
        } else
            $data['scheck_id'] = $check_id;

        $data['status'] = $this->dem->get_check_status($check_id, 0);
        $this->db->select('*');
        $partial_coduments = $this->db->get_where(DB_PREFIX . 'partial_upload_document', array('request_id' => $request_id, 'status' => '1'))->result_array();

        $this->db->where('req_id', $request_id);
        $this->db->where('status', 1);
        $this->db->select('upload_file as multipleupload,file_name as document_name');
        $offline_coduments =  $this->db->get(DB_PREFIX . 'candidate_upload_files')->result_array();
        $this->db->where('candidate_req_id', $request_id);
        $this->db->where('check_id', $check_id);
        $this->db->where('level_id', $level_id);
        $this->db->select('vm_comments,vm_revert_status');
        $stopcheck_comments =  $this->db->get(DB_PREFIX . 'ver_assign_rep')->row_array();
        $this->db->select('*');
        $deo_upload_doc = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['deo_upload_documents'] = $deo_upload_doc;
        $this->db->where('request_id', $request_id);
        $this->db->where('check_id', $check_id);
        $this->db->where('level_id', $level_id);
        $this->db->where('status', '1');
        $this->db->select('authenticate_doc,document_name');

        $offline_multicoduments = $this->db->get(DB_PREFIX . 'vm_upload_files')->result_array();
        $data['offline_multicodument'] = $offline_multicoduments;
        $data['stopcheck_comment'] = $stopcheck_comments;
        $data['partial_coduments'] = array_merge($partial_coduments, $offline_coduments);
        $data['documents'] = $this->vm->documentsup($request_id);
        $data['revert_documents'] = $this->vm->revert_documentsup($request_id, $check_id, $level_id);
        $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['level_id'] = $level_id = base64_decode($this->uri->segment(4));
        $data['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));
        $data['check_id'] = base64_decode($this->uri->segment(5));
        $revertexpences = $this->db->query("select p.check_id,a.vm_amount,a.vm_expences,a.vm_reference,a.check_id as profile_id,a.case_no,a.created_on,c.org_name,b.office_name,b.address1,b.address2,b.address3,b.locality,b.pincode,d.office_name as parent_office,o.office_name as sub_office,a.id,a.candidate_name, p.no_checks from " . DB_PREFIX . "billing a 
               
                LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
                    LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    LEFT JOIN " . DB_PREFIX . "request_check p ON p.request_id=a.request_id
                
                where a.request_id =" . $request_id . " and a.billing_type=517 GROUP BY a.id")->result_array();
        $data['revertexpencess'] = $revertexpences;

        $data['international_db'] = $this->db->query("select * from " . DB_PREFIX . "international_chk where checkid=" . $check_id . " order by sort_order asc,id asc")->result_array();
        if ($pack_id > 94)
            $level_details = $this->dm->$slug($request_id, $pack_id, $level_id);
        else
            $level_details = $this->dm->$slug($request_id, $check_id, $level_id);
        $data['level_data'] = $level_details;
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Qc1 - Verification Details', 'Verification/qccal_reports');
        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->db->select('acceptable_limit');
        $data['discrepancy_limit'] = $discrepancy_limit = $this->db->get_where(DB_PREFIX . 'add_check', array('order_id' => $orderid[0][order_id], 'types_of_check' => $check_id))->row_array();
        $data['contsofcheck'] = $this->vm->countsofchk($request_id, $check_id, $level_id);
        $data['total_chk'] = $this->vm->getallchecks($request_id);
        if ($pack_id > 94)
            $colour_details = $this->vrm->$slug($pack_id);
        else
            $colour_details = $this->vrm->$slug($check_id);
        $data['colourtxt'] = $colour_details;
        $data['deo_additional_document'] = $this->vm->deo_add_doc($request_id);
        $data['revertdate'] = $revertdate = $this->vm->check_revertdate($request_id, $check_id, $level_id);
        $data['authorization_letter'] = $this->db->query("select company_decl_doc from " . DB_PREFIX . "declaration_details where user_id=" . $request_id)->row_array();
        $data['deo_name'] = $this->vm->deoname($request_id);
        $data['check_resources'] = $this->config->item('Checkdata_fields');
        $this->amodel->pagerender($data, 'verification_reports');
    }
    function qccal_revert_reports()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'jquery-ui-1.8.16.custom.min', 'commonjs', 'jquery.validate', 'multipleclone'));

        $data['candidate_req_id'] = $condition['candidate_req_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['level_id'] = $condition['level_id'] = $level_id = base64_decode($this->uri->segment(4));
        $data['check_id'] = $condition['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $data['pack_id'] = $condition['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));
        $qcrevertname = $this->vm->check_qcrevertname($request_id, $check_id, $level_id);
        $checkreport = $this->vm->check_report($condition);
        $revertreport = $this->vm->qcrevert_report($condition);
        $data['revertcomment'] = $revertreport;
        $data['qcrevertname'] = $qcrevertname;

        $this->db->select('name');
        $order = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->result_array();
        $key = $data['key'] = $order[0]['name'];
        $this->db->select('order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';
        $this->db->select('name');
        $data['checkname'] = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->row_array();
        $slug = url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);
        if ($pack_id > 94)
            $level_details = $this->dm->$slug($request_id, $pack_id, $level_id);
        else
            $level_details = $this->dm->$slug($request_id, $check_id, $level_id);
        $this->db->select('id');
        $checkname = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('parent' => $check_id, 'name' => $level_details[0]['level_name']))->row_array();

        $data['dataentrydata'] = $level_details[0];
        $data['verified_data'] = $verified_data = $this->vm->get_verified_data($request_id, $level_id, $check_id);
        $data['expencedata'] = toArray(json_decode($verified_data['vmexpenses']));
        if ($check_id == 76 || $check_id == 77) {
            $check_id = $checkname['id'];
            $data['scheck_id'] = $check_id;
        } else
            $data['scheck_id'] = $check_id;

        $data['status'] = $this->dem->get_check_status($check_id, 0);
        $this->db->select('*');
        $partial_coduments = $this->db->get_where(DB_PREFIX . 'partial_upload_document', array('request_id' => $request_id, 'status' => '1'))->result_array();

        $this->db->where('req_id', $request_id);
        $this->db->where('status', 1);
        $this->db->select('upload_file as multipleupload,file_name as document_name');
        $offline_coduments =  $this->db->get(DB_PREFIX . 'candidate_upload_files')->result_array();

        $data['partial_coduments'] = array_merge($partial_coduments, $offline_coduments);
        $data['documents'] = $this->vm->documentsup($request_id);
        $data['revert_documents'] = $this->vm->revert_documentsup($request_id);
        $this->db->where('request_id', $request_id);
        $this->db->where('check_id', $check_id);
        $this->db->where('level_id', $level_id);
        $this->db->where('status', '1');
        $this->db->select('authenticate_doc,document_name');
        $offline_multicoduments = $this->db->get(DB_PREFIX . 'vm_upload_files')->result_array();
        $data['offline_multicodument'] = $offline_multicoduments;
        $valueed_data = $data['verified_data'];
        $verify_fielddata = toArray(json_decode($valueed_data['qcfielddata']));
        $data['verifying_fielddata'] = $verify_fielddata;
        $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['level_id'] = base64_decode($this->uri->segment(4));
        $data['check_id'] = base64_decode($this->uri->segment(5));
        $data['pack_id'] = base64_decode($this->uri->segment(6));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Qc1 - Verification Details', 'Verification/qccal_reports');
        $revertexpences = $this->db->query("select p.check_id,a.vm_amount,a.vm_expences,a.vm_reference,a.check_id as profile_id,a.case_no,a.created_on,c.org_name,b.office_name,b.address1,b.address2,b.address3,b.locality,b.pincode,d.office_name as parent_office,o.office_name as sub_office,a.id,a.candidate_name, p.no_checks from " . DB_PREFIX . "billing a 
               
                LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
                    LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    LEFT JOIN " . DB_PREFIX . "request_check p ON p.request_id=a.request_id
                
                where a.request_id =" . $request_id . " and a.billing_type=517 GROUP BY c.org_name")->result_array();
        $data['revertexpencess'] = $revertexpences;
        $this->db->select('acceptable_limit');
        $data['discrepancy_limit'] = $discrepancy_limit = $this->db->get_where(DB_PREFIX . 'add_check', array('order_id' => $orderid[0][order_id], 'types_of_check' => $check_id))->row_array();
        if ($pack_id > 94)
            $level_details = $this->dm->$slug($request_id, $pack_id, $level_id);
        else
            $level_details = $this->dm->$slug($request_id, $check_id, $level_id);
        $data['level_data'] = $level_details;
        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $data['contsofcheck'] = $this->vm->countsofchk($request_id, $check_id, $level_id);
        $data['total_chk'] = $this->vm->getallchecks($request_id);
        if ($pack_id > 94)
            $colour_details = $this->vrm->$slug($pack_id);
        else
            $colour_details = $this->vrm->$slug($check_id);
        $data['colourtxt'] = $colour_details;
        $data['deo_additional_document'] = $this->vm->deo_add_doc($request_id);
        $data['revertdate'] = $revertdate = $this->vm->check_qc2revertdate($condition);
        $data['authorization_letter'] = $this->db->query("select company_decl_doc from " . DB_PREFIX . "declaration_details where user_id=" . $request_id)->row_array();
        $data['deo_name'] = $this->vm->deoname($request_id);
        $data['check_resources'] = $this->config->item('Checkdata_fields');
        $this->amodel->pagerender($data, 'verification_reports');
    }

    function qc2cal_reports()
    {

        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'jquery-ui-1.8.16.custom.min', 'commonjs', 'jquery.validate', 'multipleclone'));
        $pack_id = base64_decode($this->uri->segment(6));

        $condition['candidate_req_id'] = $data['candidate_req_id'] = $request_id = base64_decode($this->uri->segment(3));
        $condition['level_id'] = $data['level_id'] = $level_id = base64_decode($this->uri->segment(4));
        $condition['check_id'] = $data['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $condition['pack_id'] = $data['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));

        //Code added by MN for share_code on  Nov 29th
        $res = $this->cam->get_share_code($request_id, $check_id);
        $share_code = $res[0]['share_code'];
        $data['share_code'] = $share_code;

        $checkreport = $this->vm->check_report($condition);

        $revertreport = $this->vm->qcrevert_report($condition);
        $data['revertcomment'] = $revertreport;
        $qcrevert_reason = $revertreport['qc_revert_reason'];
        $qc2revert_reason = $revertreport['qc2_revert_reason'];
        if (!empty($qcrevert_reason)) {
            $revert_id = $qcrevert_reason;
        } else {
            $revert_id = $qc2revert_reason;
        }
        $this->db->select('name');
        $revert_name = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $revert_id))->row_array();
        $data['revert_name'] = $revert_name['name'];

        $this->db->select('name');
        $order = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->result_array();
        $key = $data['key'] = $order[0]['name'];
        $this->db->select('order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';
        $this->db->select('name');
        $data['checkname'] = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->row_array();
        $slug = url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);
        if ($pack_id > 94)
            $level_details = $this->dm->$slug($request_id, $pack_id, $level_id);
        else
            $level_details = $this->dm->$slug($request_id, $check_id, $level_id);

        if ($check_id == 651  || $check_id == 644 || $check_id == 1306 || $check_id == 647 || $check_id == 646 || $check_id == 645 || $check_id == 653 || $check_id == 654) {
            $data['check_id'] = $check_id;
            $data['inter_charges'] = $inter_charges = $this->db->query("select * from " . DB_PREFIX . "service_charges_intchecks where request_id=" . $request_id . " && check_id=" . $check_id . " && level_id=" . $level_id . "")->result_array();
        }

        $data['dataentrydata'] = $level_details[0];
        $this->db->select('id');
        $checkname = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('parent' => $check_id, 'name' => $level_details[0]['level_name']))->row_array();

        $data['verified_data'] = $verified_data = $this->vm->get_verified_data($request_id, $level_id, $check_id);
        // print_r($verified_data);exit;
        $data['expencedata'] = toArray(json_decode($verified_data['vmexpenses']));
        if ($check_id == 76 || $check_id == 77) {
            $check_id = $checkname['id'];
            $data['scheck_id'] = $check_id;
        } else
            $data['scheck_id'] = $check_id;

        $data['status'] = $this->dem->get_check_status($check_id, 0);
        $this->db->select('*');
        $partial_coduments = $this->db->get_where(DB_PREFIX . 'partial_upload_document', array('request_id' => $request_id, 'status' => '1'))->result_array();

        $this->db->where('req_id', $request_id);
        $this->db->where('status', 1);
        $this->db->select('upload_file as multipleupload,file_name as document_name');
        $offline_coduments =  $this->db->get(DB_PREFIX . 'candidate_upload_files')->result_array();
        $this->db->select('*');
        $deo_upload_doc = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['deo_upload_documents'] = $deo_upload_doc;
        $this->db->where('request_id', $request_id);
        $this->db->where('check_id', base64_decode($this->uri->segment(5)));
        $this->db->where('level_id', $level_id);
        $this->db->where('status', '1');
        $this->db->select('authenticate_doc,document_name');

        $offline_multicoduments = $this->db->get(DB_PREFIX . 'vm_upload_files')->result_array();

        $data['offline_multicodument'] = $offline_multicoduments;
        $data['revert_documents'] = $this->vm->revert_documentsup($request_id);
        $data['partial_coduments'] = array_merge($partial_coduments, $offline_coduments);
        $data['documents'] = $this->vm->documentsup($request_id);
        $data['request_id'] = base64_decode($this->uri->segment(3));
        $revertexpences = $this->db->query("select p.check_id,a.vm_amount,a.vm_expences,a.vm_reference,a.check_id as profile_id,a.case_no,a.created_on,c.org_name,b.office_name,b.address1,b.address2,b.address3,b.locality,b.pincode,d.office_name as parent_office,o.office_name as sub_office,a.id,a.candidate_name, p.no_checks from " . DB_PREFIX . "billing a 
               
                LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
                    LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    LEFT JOIN " . DB_PREFIX . "request_check p ON p.request_id=a.request_id
                
                where a.request_id =" . $request_id . " and a.billing_type=517 GROUP BY c.org_name")->result_array();
        if ($pack_id > 94)
            $level_details = $this->dm->$slug($request_id, $pack_id, $level_id);
        else
            $level_details = $this->dm->$slug($request_id, $check_id, $level_id);
        $data['level_data'] = $level_details;
        $data['revertexpencess'] = $revertexpences;
        $this->db->select('acceptable_limit');
        $data['discrepancy_limit'] = $discrepancy_limit = $this->db->get_where(DB_PREFIX . 'add_check', array('order_id' => $orderid[0][order_id], 'types_of_check' => $check_id))->row_array();
        $data['contsofcheck'] = $this->vm->countsofchk($request_id, $check_id, $level_id);
        $data['total_chk'] = $this->vm->getallchecks($request_id);
        if ($pack_id > 94)
            $colour_details = $this->vrm->$slug($pack_id);
        else
            $colour_details = $this->vrm->$slug($check_id);
        $data['colourtxt'] = $colour_details;
        $data['deo_additional_document'] = $this->vm->deo_add_doc($request_id);
        $data['revertdate'] = $revertdate = $this->vm->check_revertdate($request_id, $check_id, $level_id);
        $data['authorization_letter'] = $this->db->query("select company_decl_doc from " . DB_PREFIX . "declaration_details where user_id=" . $request_id)->row_array();
        $data['deo_name'] = $this->vm->deoname($request_id);
        $data['check_resources'] = $this->config->item('Checkdata_fields');
        $this->amodel->pagerender($data, 'verification_reports');
    }

    function verify_reportqc1()
    {
        $this->amodel->loadcssScript(array('validationEngine.jquery', 'jquery.datepick', 'timePicker'));
        $this->amodel->loadjsscript(array('jquery.validate', 'jquery.dropdownPlain', 'commonjs', 'jquery.datepick', 'jquery.timePicker', 'jquery.timePicker.min', 'jquery-ui-1.8.16.custom.min'));
        $request_id = $this->uri->segment(3);
        $req_id = base64_decode($request_id);
        $level_id = base64_decode($this->uri->segment(4));
        $check_id = base64_decode($this->uri->segment(5));
        $pack_id = base64_decode($this->uri->segment(6));
        //print_r($_POST);exit;

        $documents = $this->amodel->getDetails(DB_PREFIX . "vm_upload_files", array('*'), array('request_id' => $req_id, 'check_id' => $check_id, 'level_id' => $level_id, 'status' => 1));

        $doc = count($documents);
        $uploaded_docs = $_POST['authenticate_doc'];
        for ($i = 0; $i < $doc; $i++) {
            $request = $documents[$i]['request_id'];
            $check = $documents[$i]['check_id'];
            $level = $documents[$i]['level_id'];
            $docse = $documents[$i]['authenticate_doc'];
            if (in_array(trim($documents[$i]['authenticate_doc']), $uploaded_docs)) {
                $this->db->set('status', 1);
                $this->db->where('request_id', $request);
                $this->db->where('check_id', $check);
                $this->db->where('level_id', $level);
                $this->db->where('authenticate_doc', $docse);
                $this->db->update(DB_PREFIX . 'vm_upload_files');
            } else {
                $this->db->set('status', 0);
                $this->db->where('request_id', $request);
                $this->db->where('check_id', $check);
                $this->db->where('level_id', $level);
                $this->db->where('authenticate_doc', $docse);
                $this->db->update(DB_PREFIX . 'vm_upload_files');
            }
        }
        if ($_POST['status'] <> 107) {
            $this->vm->qc1_change_status($req_id, $check_id, $level_id, $_POST, $pack_id);
        }
        $userid = $this->session->userdata('userid');
        $this->vm->update_qclevel($req_id, $level_id, $check_id, $_POST, $_POST['status'], $userid, $pack_id);
        $this->vm->update_logqclevel($req_id, $userid, $pack_id);
        redirect('' . base_url('Verification/qc1_allotedlist/' . $request_id));
    }
    function revertverify_reportqc1()
    {
        $this->amodel->loadcssScript(array('validationEngine.jquery', 'jquery.datepick', 'timePicker'));
        $this->amodel->loadjsscript(array('jquery.validate', 'jquery.dropdownPlain', 'commonjs', 'jquery.datepick', 'jquery.timePicker', 'jquery.timePicker.min', 'jquery-ui-1.8.16.custom.min'));
        $request_id = $this->uri->segment(3);
        $req_id = base64_decode($request_id);
        $level_id = base64_decode($this->uri->segment(4));
        $check_id = base64_decode($this->uri->segment(5));
        $pack_id = base64_decode($this->uri->segment(6));
        if ($_POST['status'] <> 107) {
            $this->vm->qc1_change_revertstatus($req_id, $check_id, $level_id, $_POST, $pack_id);
        }
        $userid = $this->session->userdata('userid');
        $this->vm->update_qclevel($req_id, $level_id, $check_id, $_POST, $_POST['status'], $userid, $pack_id);
        $this->vm->update_logqclevel($req_id, $userid, $pack_id);
        redirect('' . base_url('Verification/qc1_allotedlist/' . $request_id));
    }
    function verify_reportqc2()
    {

        $request_id = $this->uri->segment(3);
        $req_id = base64_decode($request_id);
        $level_id = base64_decode($this->uri->segment(4));
        $check_id = base64_decode($this->uri->segment(5));
        $pack_id = base64_decode($this->uri->segment(6));

        $this->db->select('case_no');
        $this->db->where('request_id', $req_id);
        $CaseNo = $this->db->get(DB_PREFIX . 'client_request')->row_array();


        if (!empty($_POST['rcomments'])) {
            /************* Status Updtes ***************/

            $stat_save['request_id'] = $req_id;
            $stat_save['case_no'] = $CaseNo['case_no'];
            $stat_save['check_id'] = $check_id;
            $stat_save['level_id'] = $level_id;
            $stat_save['check_status'] = 1003;
            $stat_save['verified_status'] = '';
            $stat_save['date_of_update'] = date('y-m-d H:i:s');
            $stat_save['role_id'] = $this->session->userdata('role_id');
            $stat_save['user_id'] = $this->session->userdata['userid'];
            $stat_save = $this->security->xss_clean($stat_save);
            $this->db->insert(DB_PREFIX . 'status_updates', $stat_save);

            /******************************************/

            $this->revert_to_qc($req_id, $level_id, $check_id, $_POST);
        } else {
            $documents = $this->amodel->getDetails(DB_PREFIX . "vm_upload_files", array('*'), array('request_id' => $req_id, 'check_id' => $check_id, 'level_id' => $level_id, 'status' => 1));

            $doc = count($documents);

            $uploaded_docs = $_POST['authenticate_doc'];
            for ($i = 0; $i < $doc; $i++) {
                $request = $documents[$i]['request_id'];
                $check = $documents[$i]['check_id'];
                $level = $documents[$i]['level_id'];
                $docse = $documents[$i]['authenticate_doc'];
                if (in_array(trim($documents[$i]['authenticate_doc']), $uploaded_docs)) {
                    $this->db->set('status', 1);
                    $this->db->where('request_id', $request);
                    $this->db->where('check_id', $check);
                    $this->db->where('level_id', $level);
                    $this->db->where('authenticate_doc', trim($docse));
                    $this->db->update(DB_PREFIX . 'vm_upload_files');
                } else {
                    $this->db->set('status', 0);
                    $this->db->where('request_id', $request);
                    $this->db->where('check_id', $check);
                    $this->db->where('level_id', $level);
                    $this->db->where('authenticate_doc', trim($docse));
                    $this->db->update(DB_PREFIX . 'vm_upload_files');
                }
            }
            if ($_POST['status'] <> 107) {
                $this->vm->qc2_change_status($req_id, $check_id, $level_id, $_POST, $pack_id);
            }
            $userid = $this->session->userdata('userid');
            $this->vm->update_qc2level($req_id, $level_id, $check_id, $_POST, $_POST['status'], $userid, $pack_id);
            $this->vm->update_logqc2level($req_id, $userid, $pack_id);

            /************* Status Updtes ***************/

            $stat_save['request_id'] = $req_id;
            $stat_save['case_no'] = $CaseNo['case_no'];
            $stat_save['check_id'] = $check_id;
            $stat_save['level_id'] = $level_id;
            $stat_save['check_status'] = 1008;
            $stat_save['verified_status'] = '';
            $stat_save['date_of_update'] = date('y-m-d H:i:s');
            $stat_save['role_id'] = $this->session->userdata('role_id');
            $stat_save['user_id'] = $this->session->userdata['userid'];
            // print_r($stat_save);exit;
            $stat_save = $this->security->xss_clean($stat_save);
            $this->db->insert(DB_PREFIX . 'status_updates', $stat_save);



            /******************************************/
            // Ka added on may 20th
            if ($_POST['check_id'] == 1306) {
                $existing_record_json = $this->vm->fetch_existing_record_json($_POST['request_id']);
                $existing_record = json_decode($existing_record_json['gapdata'], true);
                $count_gap = count($existing_record);
                for ($i = 0; $i < $count_gap; $i++) {
                    if (!empty($_POST['previous_org'][$i])) {
                        $cleaned_previous_org = str_replace(array("\\n", "\\r", "\\"), '', $_POST['previous_org'][$i]);
                        $cleaned_previous_org = str_replace("'", "''", $cleaned_previous_org); // Jan 20th 2025
                        $existing_record[$i]['previous_org'] = trim($cleaned_previous_org);
                    }
                    if (!empty($_POST['next_org'][$i])) {
                        $cleaned_next_org = str_replace(array("\\n", "\\r", "\\"), '', $_POST['next_org'][$i]);
                        $cleaned_next_org = str_replace("'", "''", $cleaned_next_org); // Jan 20th 2025
                        $existing_record[$i]['next_org'] = trim($cleaned_next_org);
                    }
                    //  Jan 20th 2025
                    if(!empty($existing_record[$i]['gap_reason_emp']))
                    {
                        $cleaned_reason_emp = str_replace(array("\\n", "\\r", "\\"), '', $existing_record[$i]['gap_reason_emp']);
                        $cleaned_reason_emp = str_replace("'", "''", $cleaned_reason_emp); 
                        $existing_record[$i]['gap_reason_emp'] = trim($cleaned_reason_emp);
                    }
                    //  Jan 20th 2025
                }
                $json_gap = json_encode($existing_record);
                //print_r($json_gap);
                $this->vm->update_company_name_forgap($_POST['request_id'], $json_gap);
                $cleaned_data = $existing_record;
            }
            // ka added on may 20th

            // ************************************ education and employment gap *********************
            // ka added on july 17
            if (($_POST['check_id'] == 1306)) {
                $existing_record_edu_json = $this->vm->fetch_existing_record_edu_json($_POST['request_id']);
                $existing_record_edu = toArray(json_decode($existing_record_edu_json['gap_edu']));
                $count_gap_edu = count($existing_record_edu);
                for ($i = 0; $i < $count_gap_edu; $i++) {
                    if (!empty($_POST['qualification'][$i] != '')) {
                        $cleaned_qualification = str_replace(array("\\n", "\\r", "\\"), '', $_POST['qualification'][$i]);
                        $cleaned_qualification = str_replace("'", "''", $cleaned_qualification); // Jan 15th 2025
                        $existing_record_edu[$i]['qualification'] = trim($cleaned_qualification);
                    }

                    if (!empty($_POST['previous_org_edu'][$i] != '')) {
                        $cleaned_previous_org_edu = str_replace(array("\\n", "\\r", "\\"), '', $_POST['previous_org_edu'][$i]);
                        $cleaned_previous_org_edu = str_replace("'", "''", $cleaned_previous_org_edu); // Jan 15th 2025
                        $existing_record_edu[$i]['previous_org_edu'] = trim($cleaned_previous_org_edu);
                    }
                    /** Added on Dec 19th **/    
                    if(!empty($_POST['gap_duration_edu'][$i] != '')) {
                        $gap_duration_edu = $_POST['gap_duration_edu'][$i];
                        $existing_record_edu[$i]['gap_duration_edu'] = trim($gap_duration_edu);
                    }
                    if(empty($_POST['gap_duration_edu'][$i])) {
                        $existing_record_edu[$i]['gap_duration_edu'] = "";
                    }
                    if(!empty($_POST['previous_exit_date_edu'][$i] != '')) {
                        $previous_exit_date_edu = $_POST['previous_exit_date_edu'][$i];
                        $previous_exit_date_edu = date('Y-m-d', strtotime($previous_exit_date_edu));
                        $existing_record_edu[$i]['previous_exit_date_edu'] = $previous_exit_date_edu;
                    }
                    if(empty($_POST['previous_exit_date_edu'][$i])) {
                        $existing_record_edu[$i]['previous_exit_date_edu'] = null;
                    }
                    if(!empty($_POST['previous_join_date_edu'][$i] != '')) {
                        $previous_join_date_edu = $_POST['previous_join_date_edu'][$i];
                        $previous_join_date_edu = date('Y-m-d', strtotime($previous_join_date_edu));
                        $existing_record_edu[$i]['previous_join_date'] = $previous_join_date_edu;
                    }
                    if(empty($_POST['previous_join_date_edu'][$i])) {
                        $existing_record_edu[$i]['previous_join_date'] = null;
                    } /** Added on Dec 19th till here**/ 
                    //  Jan 20th 2025
                    if(!empty($existing_record_edu[$i]['gap_reason_edu']))
                    {
                        $cleaned_reason_edu = str_replace(array("\\n", "\\r", "\\"), '', $existing_record_edu[$i]['gap_reason_edu']);
                        $cleaned_reason_edu = str_replace("'", "''", $cleaned_reason_edu);
                        $existing_record_edu[$i]['gap_reason_edu'] = trim($cleaned_reason_edu);
                    }
                    //  Jan 20th 2025
                }

                $json_gap_edu = json_encode($existing_record_edu);
                $this->vm->update_qualification_companyname_forgap($_POST['request_id'], $json_gap_edu);
            }
            // ************************************** end ********

            redirect('' . base_url('Verification/qc2_verification/' . $request_id));
        }
    }

    function verify_publishreportqc2()
    {

        $request_id = $this->uri->segment(3);
        $req_id = base64_decode($request_id);
        $level_id = base64_decode($this->uri->segment(4));
        $check_id = base64_decode($this->uri->segment(5));
        $pack_id = base64_decode($this->uri->segment(6));
        if (!empty($_POST['rcomments'])) {
            $this->revert_to_qc($req_id, $level_id, $check_id, $_POST);
        } else {

            $documents = $this->amodel->getDetails(DB_PREFIX . "vm_upload_files", array('*'), array('request_id' => $req_id, 'check_id' => $check_id, 'level_id' => $level_id, 'status' => 1));

            /******** Code for Billing Reference By Chandan Kp*****/
            $orderRes = $this->vm->get_order($req_id);
            $order_id = $orderRes['order_id'];

            $checkWithCount = $this->vm->get_checkwithcount($req_id, $order_id);
            $intChk = array("644", "645", "646", "647");
            // echo '<pre>';print_r($checkWithCount); 
            // exit;
            $totalChkCost = 0;
            $chkCost = 0;
            $pkgCost = 0;
            $Scharge_Check = 0;
            $overSeas_charge = 0;
            $int_chk_cost = 0;
            foreach ($checkWithCount as $checkVal) {

                if ($checkVal['package_id'] == 0) {

                    if (in_array($checkVal['check_id'], $intChk)) {
                        $chkCost = $checkVal['amount_rupees'];
                        $int_chk_cost += $checkVal['amount_rupees'];
                    } else {

                        if ($checkVal['outside_india'] == 0) {
                            $chkCost = $checkVal['Rs'];
                            $Scharge_Check += $checkVal['Rs'];
                        } else {
                            if ($checkVal['overseas_charge'] > 0) {
                                $chkCost = ($checkVal['Rs'] + $checkVal['overseas_charge']);
                                $overSeas_charge += $checkVal['overseas_charge'];
                            } else {
                                $chkCost = ($checkVal['Rs'] + 500);
                                $Scharge_Check += $checkVal['Rs'];
                                $overSeas_charge += 500;
                            }
                        }
                        $CheckCost += $chkCost;
                    }
                } else {

                    if ($checkVal['Rs'] == 0) {

                        $packagewithchk = $this->vm->get_packagecheck($req_id, $order_id, $checkVal['check_id']);

                        // echo '<pre>';print_r($packagewithchk);

                        if (in_array($checkVal['check_id'], $intChk)) {
                            $chkCost = $checkVal['amount_rupees'];
                            $int_chk_cost += $checkVal['amount_rupees'];
                        } else {

                            if ($packagewithchk['outside_india'] == 0) {
                                $chkCost = $packagewithchk['Rs'];
                                $Scharge_Check += $packagewithchk['Rs'];
                            } else {
                                if ($packagewithchk['overseas_charge'] > 0) {
                                    $chkCost = ($packagewithchk['Rs'] + $packagewithchk['overseas_charge']);
                                    $overSeas_charge += $packagewithchk['overseas_charge'];
                                } else {
                                    $chkCost = ($packagewithchk['Rs'] + 500);
                                    $Scharge_Check += $packagewithchk['Rs'];
                                    $overSeas_charge += 500;
                                }
                            }
                            $CheckCost += $chkCost;
                        }
                    } else {

                        if ($pkgCost == 0) {
                            $pkgCost = $checkVal['Rs'];
                        }

                        if (in_array($checkVal['check_id'], $intChk)) {
                            $chkCost = $checkVal['amount_rupees'];
                            $CheckCost += $chkCost;
                            $int_chk_cost += $checkVal['amount_rupees'];
                        } else {
                            if ($checkVal['outside_india'] == 1) {

                                if ($checkVal['overseas_charge'] > 0) {
                                    $CheckCost += $checkVal['overseas_charge'];
                                    $overSeas_charge += $checkVal['overseas_charge'];
                                } else {
                                    $CheckCost += 500;
                                    $overSeas_charge += 500;
                                }
                            }
                        }
                    }
                }

                $totalChkCost = ($CheckCost + $pkgCost + $int_chk_cost);
            }
            // echo $overSeas_charge. '<br>';
            // echo $totalChkCost;
            // exit;
            /********* Code for Billing Ref End ********/

            if (!empty($documents)) {
                $doc = count($documents);
                foreach ($_POST['authenticate_doc'] as $key => $value) {
                    $uploaded_docs[] = trim($value);
                }

                for ($i = 0; $i < $doc; $i++) {
                    $request = $documents[$i]['request_id'];
                    $check = $documents[$i]['check_id'];
                    $level = $documents[$i]['level_id'];
                    $docse = $documents[$i]['document_name'];

                    if (in_array(trim($documents[$i]['authenticate_doc']), $uploaded_docs)) {
                        $this->db->set('status', 1);
                        $this->db->where('request_id', $request);
                        $this->db->where('check_id', $check);
                        $this->db->where('level_id', $level);
                        $this->db->where('authenticate_doc', trim($documents[$i]['authenticate_doc']));
                        $this->db->update(DB_PREFIX . 'vm_upload_files');
                    } else {
                        $this->db->set('status', 0);
                        $this->db->where('request_id', $request);
                        $this->db->where('check_id', $check);
                        $this->db->where('level_id', $level);
                        $this->db->where('authenticate_doc', trim($documents[$i]['authenticate_doc']));
                        $this->db->update(DB_PREFIX . 'vm_upload_files');
                    }
                }
            }
            if ($_POST['status'] <> 107) {
                $this->vm->qc2_change_publishstatus($req_id, $check_id, $level_id, $_POST, $pack_id);
            }
            $userid = $this->session->userdata('userid');
            $this->vm->update_qc2publishlevel($req_id, $level_id, $check_id, $_POST, $_POST['status'], $userid, $pack_id);
            $this->vm->update_logqc2level($req_id, $userid, $pack_id);
            /* Final report submission */
            $verifiedlevelstatus = $this->vm->get_verifiedlevelstatus($req_id, $check_id, $level_id);
            $finalreport_checksa = $this->rm->getcountcheck($req_id);
            $count_pending_checksa = $this->rm->getcountchecksverify($req_id);
            $namw = count($finalreport_checksa);
            $sum = 0;
            foreach ($count_pending_checksa as $count_pending_val) {
                $sum += $count_pending_val['no_checks'];
            }

            // if($sum == $namw){

            // 	$billSave['case_no']=$_POST['case_no'];
            // 	$billSave['request_id']=$req_id;
            // 	$billSave['org_id']=$_POST['org_id'];
            // 	$billSave['report_type']=1;
            // 	$billSave['report_date']=date('Y-m-d H:i:s');
            // 	$billSave['charges_services']=$totalChkCost;
            // 	$billSave['charges_services_checks']=$Scharge_Check;
            // 	$billSave['charges_services_package']=$pkgCost;
            // 	$billSave['charges_services_overseas']=$overSeas_charge;
            // 	$billSave['charges_services_international']=$int_chk_cost;
            // 	$this->db->insert ( DB_PREFIX .'bill_receipts', $billSave );
            // }

            $this->db->select('final_report');
            $finalReport = $this->db->get_where('dcode_client_request', array('request_id' => $req_id))->row_array();

            $sup = $this->db->query("select qc2_date, supplementary, supplement_published_date, reopen_by from " . DB_PREFIX . "verified_level 
                 where request_id=" . $req_id . " and level_id=" . $level_id . " and check_id=" . $check_id . " ")->row_array();
            if (!empty($verifiedlevelstatus['qc2fielddata'])) {
                if ($sum <= $namw) {
                    $this->db->where('request_id', $req_id);
                    // Code Modified On 06/Feb/2024 By Ck

                    // if($sup['reopen_by'] !=17){
                    // 	if($sup['supplementary']==3){

                    // 		$this->db->set(array('supplement_report'=>1,'supplement_report_date'=>date('Y-m-d H:i:s', strtotime($sup['supplement_published_date']))));
                    // 	}
                    // 	else{
                    // 		if($finalReport['final_report'] == 0){
                    // 			$this->db->set(array('final_report'=>1,'final_report_published_date'=>date('Y-m-d H:i:s', strtotime($sup['qc2_date']))));
                    // 		}
                    // 	}
                    // }

                    if ($sup['reopen_by'] != 17) {
                        if ($finalReport['final_report'] == 0) {
                            $this->db->set(array('final_report' => 1, 'final_report_published_date' => date('Y-m-d H:i:s', strtotime($sup['qc2_date']))));
                        } else {
                            if ($sup['supplementary'] == 3) {
                                $this->db->set(array('supplement_report' => 1, 'supplement_report_date' => date('Y-m-d H:i:s', strtotime($sup['supplement_published_date']))));
                            }
                        }
                    }

                    $this->db->update(DB_PREFIX . 'client_request');
                }

                $rep_status = $this->cm->get_verified_data($req_id);
                $report_status = '';
                $publish_status = '';
                $rstatus1 = [];

                $cnt_not_applicable = 0;
                if ($_POST['ostatus'] == 699)
                    ++$cnt_not_applicable;
                if ($_POST['ostatus'] == 750)
                    ++$cnt_not_applicable;

                if ($rep_status) {

                    foreach ($rep_status as $k => $rps) {
                        $rid = $rps['request_id'];
                        if (!empty($rps['qc2fielddata'])) {
                            $qc2_data = toArray(json_decode($rps['qc2fielddata']));
                            if ($qc2_data['status']) {
                                $pstatus[$rid][] = $this->vm->get_status($qc2_data['status']);
                            }
                            if ($qc2_data['status1']) {
                                $pstatus[$rid][] = $this->vm->get_status($qc2_data['status1']);
                            }
                        }
                    }
                    foreach ($pstatus[$rid] as $rp) {
                        $rstatus1[] = $rp['name'];
                    }
                    if (in_array("Discrepant", $rstatus1) || in_array("Possible Discrepant", $rstatus1) || in_array("Record Found", $rstatus1) || in_array("Positive", $rstatus1) || in_array("No Records", $rstatus1) || in_array("High Risk", $rstatus1) || in_array("Invalid", $rstatus1) || in_array("Not Completed", $rstatus1)) {
                        $report_status = 'RED';
                    }
                    // May 24th
                    else if (in_array("Stop Check", $rstatus1) || (in_array("Others", $rstatus1) && $cnt_not_applicable == 0) || in_array("Possible Match", $rstatus1) || in_array("Partial Match", $rstatus1)) {
                        $report_status = 'ORANGE';
                    } else {
                        $report_status = 'GREEN';
                    }
                }
                $this->db->set('report_status', $report_status);
                $this->db->where('request_id', $req_id);
                $this->db->update(DB_PREFIX . 'client_request');
            }
            /*Discrepency Mail Start*/
            $discrepancy = $this->db->query("select u.role_id,d.id,d.organization,d.email, c.candidate_name, d.first_name, c.case_no, c.client_ref_number, p.office_name as poffice,b.office_name as boffice,s.office_name as soffice,ur.parent_office as clt_parent_office,ub.branch_office as clt_branch_office,us.sub_office as clt_sub_office,c.parent_office,c.office,c.sub_office,c.dataentry_by,vr.count_of_chk,c.report_status,o.orange_report_mail,a.check_id from " . DB_PREFIX . "verified_level a
				JOIN " . DB_PREFIX . "ver_assign_rep vr ON vr.candidate_req_id = a.request_id and vr.check_id=a.check_id and vr.level_id=a.level_id
			LEFT JOIN " . DB_PREFIX . "client_request c ON c.request_id = a.request_id
			LEFT JOIN " . DB_PREFIX . "office p ON p.id = c.parent_office
			LEFT JOIN " . DB_PREFIX . "office b ON b.id = c.office
			LEFT JOIN " . DB_PREFIX . "office s ON s.id = c.sub_office 	
			JOIN " . DB_PREFIX . "users_roles u ON u.user_id = c.created_by
			JOIN " . DB_PREFIX . "user_headoffices ur ON ur.parent_office = c.parent_office
			JOIN dcode_organisation o ON o.id = c.organisation
			left JOIN " . DB_PREFIX . "user_branchoffices ub ON ub.user_id = ur.user_id
			left JOIN " . DB_PREFIX . "user_suboffices us ON us.user_id = ur.user_id
			JOIN " . DB_PREFIX . "user d ON d.id = 
			CASE WHEN c.dataentry_by != 3
			THEN ur.user_id
			ELSE ur.user_id
			END 
			WHERE a.request_id =" . $req_id . " and a.check_id =" . $check_id . " and a.level_id =" . $level_id . " and d.status = 1 GROUP By d.email ")->result_array();
            $this->db->select('name');
            $discrepancy_check = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->result_array();
            if (!empty($discrepancy)) {
                foreach ($discrepancy as $dkey => $dvalue) {
                    $dis_data = array();
                    if ($dvalue['soffice']) {
                        $dis_data['office'] = $dvalue['soffice'];
                    } elseif ($dvalue['boffice']) {
                        $dis_data['office'] = $dvalue['boffice'];
                    } else {
                        $dis_data['office'] = $dvalue['poffice'];
                    }

                    if ($dvalue['soffice'] && $dvalue['clt_parent_office'] == $discrepancy[0]['parent_office'] &&  $dvalue['clt_branch_office'] == $discrepancy[0]['office'] && $dvalue['clt_sub_office'] == $discrepancy[0]['sub_office']) {
                        $dis_data['email'] = $dvalue['email'];
                    } elseif ($dvalue['boffice'] && $dvalue['clt_parent_office'] == $discrepancy[0]['parent_office'] &&  $dvalue['clt_branch_office'] == $discrepancy[0]['office'] && $dvalue['clt_sub_office'] == 0) {
                        $dis_data['email'] = $dvalue['email'];
                    } elseif ($dvalue['clt_parent_office'] == $discrepancy[0]['parent_office'] && $dvalue['clt_branch_office'] == 0 && $dvalue['clt_sub_office'] == 0) {
                        $dis_data['email'] = $dvalue['email'];
                    }
                    $dis_data['first_name'] = $dvalue['first_name'];
                    $dis_data['candidate_name'] = $dvalue['candidate_name'];
                    $dis_data['case_no'] = $dvalue['case_no'];
                    $dis_data['client_ref_number'] = $dvalue['client_ref_number'];
                    $num_chk = ($discrepancy[0]['count_of_chk'] != 0) ? $discrepancy[0]['count_of_chk'] : '';
                    $dis_data['check_name'] = $discrepancy_check[0]['name'] . ' ' . $num_chk;
                    $dis_data['report_status'] = $discrepancy[0]['report_status'];
                    $dis_data['orange_report_mail'] = $discrepancy[0]['orange_report_mail'];
                    if ($sup['supplementary'] == 3) {
                        $this->send_email_common_discrepency('supplementary_report', 'Re opened Report Alert by Dcode Research', $dis_data['email'], $dis_data);
                    } else if (($_POST['status1'] == 128 || $_POST['status1'] == 129 || $_POST['status1'] == 126 || $_POST['status1'] == 139 || $_POST['status1'] == 122 || $_POST['status1'] == 117 || $_POST['status1'] == 124 || $_POST['status1'] == 118 || $_POST['status1'] == 135 || $_POST['status1'] == 141 || $_POST['status1'] == 133 || $_POST['status1'] == 145 || $_POST['status1'] == 701 ||  $_POST['status1'] == 663 || $_POST['status1'] == 661 || $_POST['status1'] == 659 || $_POST['status1'] == 1183) && ($dis_data['email'])) {
                        $this->send_email_common_discrepency('discrepency_report', 'Red Report Alert by Dcode Research', $dis_data['email'], $dis_data);
                    } else if (($_POST['status1'] == 120 || $_POST['status1'] == 131 || $_POST['status1'] == 137 || $_POST['status1'] == 143 || $_POST['status'] == 155 || $_POST['status1'] == 713 || $_POST['status1'] == 765 || $_POST['status1'] == 813 || $_POST['status1'] == 119 || $_POST['status1'] == 130 || $_POST['status1'] == 136 || $_POST['status1'] == 142 || $_POST['pstatus'] == 1005 || $_POST['status'] == 110 || $_POST['status1'] == 110 || ($_POST['status'] == 519 && $cnt_not_applicable == 0) || $_POST['status1'] == 519) && ($dis_data['email']) && ($dis_data['orange_report_mail'] == 1)) {
                        $this->send_email_common_discrepency('discrepency_report', '	Orange Report Alert by Dcode Research', $dis_data['email'], $dis_data);
                    }
                }
            }
            /*Discrepency Mail End*/

            /************* Status Updtes ***************/
            $this->db->select('case_no');
            $this->db->where('request_id', $req_id);
            $CaseNo = $this->db->get(DB_PREFIX . 'client_request')->row_array();

            $report_flag = 'NULL';
            $published_date = 'NULL';
            $supp = $this->db->query("select supplementary, qc2_date, reopen_by, f_report from " . DB_PREFIX . "verified_level 
                 where request_id=" . $req_id . " and level_id=" . $level_id . " and check_id=" . $check_id . " ")->row_array();
            
            if ($supp['f_report'] == 1 && $supp['supplementary'] == 0) {

                $report_flag = $supp['f_report'];
                $published_date = date('Y-m-d H:i:s', strtotime($supp['qc2_date']));
            } else if ($supp['supplementary'] == 3 && $supp['reopen_by'] != 17) {

                $report_flag = $supp['supplementary'];
                $published_date = date('Y-m-d H:i:s', strtotime($supp['qc2_date']));
            } else if ($supp['supplementary'] == 3 && $supp['reopen_by'] == 17) {

                $report_flag = 'NULL';
                $published_date = date('Y-m-d H:i:s', strtotime($supp['qc2_date']));
            } else {
                $report_flag = 'NULL';
                $published_date = date('Y-m-d H:i:s', strtotime($supp['qc2_date']));
            }


            $stat_save['request_id'] = $req_id;
            $stat_save['case_no'] = $CaseNo['case_no'];
            $stat_save['check_id'] = $check_id;
            $stat_save['level_id'] = $level_id;
            $stat_save['check_status'] = 1007;
            $stat_save['verified_status'] = '';
            $stat_save['date_of_update'] = date('y-m-d H:i:s');
            $stat_save['report_flag'] = $report_flag;
            $stat_save['published_date'] = $published_date;
            $stat_save['role_id'] = $this->session->userdata('role_id');
            $stat_save['user_id'] = $this->session->userdata['userid'];
            
            $stat_save = $this->security->xss_clean($stat_save);
            $this->db->insert(DB_PREFIX . 'status_updates', $stat_save);

            //  MN Jul 16th
            if ($supp['supplementary'] == 0) {
                $this->tm->save_individual_TAT($req_id, $check_id, $level_id); //  MN Jul
            } else {
                if($supp['reopen_by'] != 17)
                    $this->tm->save_individual_TAT_after_reopen($req_id, $check_id, $level_id); //  MN Aug 5th
            } //  MN Aug 5th
           
            /******************************************/

            //ka added on may 20th
            if ($_POST['check_id'] == 1306) {
                $existing_record_json = $this->vm->fetch_existing_record_json($_POST['request_id']);
                $existing_record = json_decode($existing_record_json['gapdata'], true);
                $count_gap = count($existing_record);
                for ($i = 0; $i < $count_gap; $i++) {
                    if (!empty($_POST['previous_org'][$i])) {
                        $cleaned_previous_org = str_replace(array("\\n", "\\r", "\\"), '', $_POST['previous_org'][$i]);
                        $cleaned_previous_org = str_replace("'", "''", $cleaned_previous_org); // Jan 20th 2025
                        $existing_record[$i]['previous_org'] = trim($cleaned_previous_org);
                    }
                    if (!empty($_POST['next_org'][$i])) {
                        $cleaned_next_org = str_replace(array("\\n", "\\r", "\\"), '', $_POST['next_org'][$i]);
                        $cleaned_next_org = str_replace("'", "''", $cleaned_next_org); // Jan 20th 2025
                        $existing_record[$i]['next_org'] = trim($cleaned_next_org);
                    }
                    //  Jan 20th 2025
                    if(!empty($existing_record[$i]['gap_reason_emp']))
                    {
                        $cleaned_reason_emp = str_replace(array("\\n", "\\r", "\\"), '', $existing_record[$i]['gap_reason_emp']);
                        $cleaned_reason_emp = str_replace("'", "''", $cleaned_reason_emp); 
                        $existing_record[$i]['gap_reason_emp'] = trim($cleaned_reason_emp);
                    }
                    //  Jan 20th 2025
                }
                $json_gap = json_encode($existing_record);
                //print_r($json_gap);
                $this->vm->update_company_name_forgap($_POST['request_id'], $json_gap);
                $cleaned_data = $existing_record;
            }
            // ka added on may 20th

             // ************************************ education and employment gap *********************
        // ka added on july 17
        if (($_POST['check_id'] == 1306)) {
            $existing_record_edu_json = $this->vm->fetch_existing_record_edu_json($_POST['request_id']);
            $existing_record_edu = toArray(json_decode($existing_record_edu_json['gap_edu']));
            $count_gap_edu = count($existing_record_edu);
            for ($i = 0; $i < $count_gap_edu; $i++) {
                if (!empty($_POST['qualification'][$i] != '')) {
                    $cleaned_qualification = str_replace(array("\\n", "\\r", "\\"), '', $_POST['qualification'][$i]);
                    $cleaned_qualification = str_replace("'", "''", $cleaned_qualification); // Jan 15th 2025
                    $existing_record_edu[$i]['qualification'] = trim($cleaned_qualification);
                }
                
                if (!empty($_POST['previous_org_edu'][$i] != '')) {
                    $cleaned_previous_org_edu = str_replace(array("\\n", "\\r", "\\"), '', $_POST['previous_org_edu'][$i]);
                    $cleaned_previous_org_edu = str_replace("'", "''", $cleaned_previous_org_edu); // Jan 15th 2025
                    $existing_record_edu[$i]['previous_org_edu'] = trim($cleaned_previous_org_edu);
                }
                /** Added on Dec 19th **/    
                if(!empty($_POST['gap_duration_edu'][$i] != '')) {
                    $gap_duration_edu = $_POST['gap_duration_edu'][$i];
                    $existing_record_edu[$i]['gap_duration_edu'] = trim($gap_duration_edu);
                }
                if(empty($_POST['gap_duration_edu'][$i])) {
                    $existing_record_edu[$i]['gap_duration_edu'] = "";
                }
                if(!empty($_POST['previous_exit_date_edu'][$i] != '')) {
                    $previous_exit_date_edu = $_POST['previous_exit_date_edu'][$i];
                    $previous_exit_date_edu = date('Y-m-d', strtotime($previous_exit_date_edu));
                    $existing_record_edu[$i]['previous_exit_date_edu'] = $previous_exit_date_edu;
                }
                if(empty($_POST['previous_exit_date_edu'][$i])) {
                    $existing_record_edu[$i]['previous_exit_date_edu'] = null;
                }
                if(!empty($_POST['previous_join_date_edu'][$i] != '')) {
                    $previous_join_date_edu = $_POST['previous_join_date_edu'][$i];
                    $previous_join_date_edu = date('Y-m-d', strtotime($previous_join_date_edu));
                    $existing_record_edu[$i]['previous_join_date'] = $previous_join_date_edu;
                }
                if(empty($_POST['previous_join_date_edu'][$i])) {
                    $existing_record_edu[$i]['previous_join_date'] = null;
                } /** Added on Dec 19th till here**/
                //  Jan 20th 2025
                if(!empty($existing_record_edu[$i]['gap_reason_edu']))
                {
                    $cleaned_reason_edu = str_replace(array("\\n", "\\r", "\\"), '', $existing_record_edu[$i]['gap_reason_edu']);
                    $cleaned_reason_edu = str_replace("'", "''", $cleaned_reason_edu);
                    $existing_record_edu[$i]['gap_reason_edu'] = trim($cleaned_reason_edu);
                }
                //  Jan 20th 2025
            }

            $json_gap_edu = json_encode($existing_record_edu);
            $this->vm->update_qualification_companyname_forgap($_POST['request_id'], $json_gap_edu);
        }
        // ************************************** end ********
            redirect('' . base_url('Verification/qc2_verification/'));
        }
    }
    function verify_reopenreportqc2()
    {

        $request_id = $this->uri->segment(3);
        $req_id = base64_decode($request_id);
        $level_id = base64_decode($this->uri->segment(4));
        $check_id = base64_decode($this->uri->segment(5));
        $pack_id = base64_decode($this->uri->segment(6));

        if (!empty($_POST['rcomments'])) {
            $this->revert_to_qc($req_id, $level_id, $check_id, $_POST);
        } else {
            $documents = $this->amodel->getDetails(DB_PREFIX . "vm_upload_files", array('*'), array('request_id' => $req_id, 'check_id' => $check_id, 'level_id' => $level_id));

            if (!empty($documents)) {
                $doc = count($documents);
                foreach ($_POST['authenticate_doc'] as $key => $value) {
                    $uploaded_docs[] = trim($value);
                }

                for ($i = 0; $i < $doc; $i++) {
                    $request = $documents[$i]['request_id'];
                    $check = $documents[$i]['check_id'];
                    $level = $documents[$i]['level_id'];
                    $docse = $documents[$i]['document_name'];

                    if (in_array(trim($documents[$i]['authenticate_doc']), $uploaded_docs)) {
                        $this->db->set('status', 1);
                        $this->db->where('request_id', $request);
                        $this->db->where('check_id', $check);
                        $this->db->where('level_id', $level);
                        $this->db->where('authenticate_doc', trim($documents[$i]['authenticate_doc']));
                        $this->db->update(DB_PREFIX . 'vm_upload_files');
                    } else {
                        $this->db->set('status', 0);
                        $this->db->where('request_id', $request);
                        $this->db->where('check_id', $check);
                        $this->db->where('level_id', $level);
                        $this->db->where('authenticate_doc', trim($documents[$i]['authenticate_doc']));
                        $this->db->update(DB_PREFIX . 'vm_upload_files');
                    }
                }
            }
            if ($_POST['status'] <> 107) {
                $this->vm->qc2_change_publishstatus($req_id, $check_id, $level_id, $_POST, $pack_id);
            }
            $userid = $this->session->userdata('userid');
            $this->vm->update_qc2publishlevel($req_id, $level_id, $check_id, $_POST, $_POST['status'], $userid, $pack_id);
            $this->vm->update_logqc2level($req_id, $userid, $pack_id);
            $rep_status = $this->cm->get_verified_data($req_id);
            $verifiedlevelstatus = $this->vm->get_verifiedlevelstatus($req_id, $check_id, $level_id);
            $finalreport_checksa = $this->rm->getcountcheck($req_id);
            $count_pending_checksa = $this->rm->getcountchecksverify($req_id);
            $namw = count($finalreport_checksa);
            $sum = 0;
            foreach ($count_pending_checksa as $count_pending_val) {
                $sum += $count_pending_val['no_checks'];
            }
            if ($sum <= $namw) {
                $this->db->where('request_id', $req_id);
                $this->db->set(array('final_report' => 1, 'final_report_published_date' => date('Y-m-d H:i:s')));
                $this->db->update(DB_PREFIX . 'client_request');
            }
            $report_status = '';
            $publish_status = '';
            $rstatus1 = [];
            if ($rep_status) {

                foreach ($rep_status as $k => $rps) {
                    $rid = $rps['request_id'];
                    if (!empty($rps['qc2fielddata'])) {
                        $qc2_data = toArray(json_decode($rps['qc2fielddata']));
                        if ($qc2_data['status']) {
                            $pstatus[$rid][] = $this->vm->get_status($qc2_data['status']);
                        }
                        if ($qc2_data['status1']) {
                            $pstatus[$rid][] = $this->vm->get_status($qc2_data['status1']);
                        }
                    }
                }
                foreach ($pstatus[$rid] as $rp) {
                    $rstatus1[] = $rp['name'];
                }
                if (in_array("Discrepant", $rstatus1) || in_array("Possible Discrepant", $rstatus1) || in_array("Record Found", $rstatus1) || in_array("Positive", $rstatus1) || in_array("No Records", $rstatus1) || in_array("High Risk", $rstatus1) || in_array("Invalid", $rstatus1) || in_array("Not Completed", $rstatus1)) {
                    $report_status = 'RED';
                } else if (in_array("Stop Check", $rstatus1) || in_array("Others", $rstatus1)) {
                    $report_status = 'ORANGE';
                } else {
                    $report_status = 'GREEN';
                }
            }
            $this->db->set('report_status', $report_status);
            $this->db->where('request_id', $req_id);
            $this->db->update(DB_PREFIX . 'client_request');

            redirect('' . base_url('Verification/qc2_casechecklist/' . $request_id));
        }
    }
    function qc1_reports()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC1 Assigned List Reports', 'Verification/qc1_Reports');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'reports');
    }

    function get_qc1reportslist()
    {
        $model = array('Verification_model' => 'get_userlistreports');

        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        if ($office)
            $condition[] = " c.id = " . $office;
        if ($check_name)
            $condition[] = " md1.name like '%" . $check_name . "%'";
        if ($status)
            $condition[] = " md2.name like '%" . $status . "%'";

        if ($name)
            $condition[] = " cr.candidate_name like '%" . $name . "%'";

        if ($case_no)
            $condition[] = " cr.case_no like '%" . $case_no . "'";

        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " md2.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " md.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " md1.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " ass.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " ass.last_name " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }

        $manual_cond = implode(' and ', $condition);

        $results = $this->_jqgrid_search($model, $manual_cond);

        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {

                $slug = url_title(convert_accented_characters($row['checkname']), 'underscore', TRUE);
                if ($row['check_id'] == 14)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'education_details');
                else if ($row['check_id'] == 16)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'contact_details', 'request_id', 'permanent_address');
                else if ($row['check_id'] == 59)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'employment', 'req_id', 'level_id');
                else if ($row['check_id'] == 76 || $row['check_id'] == 77 || $row['check_id'] == 75)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], $slug, 'request_id', 'level_name');
                else
                    $levelnames['level'] = $row['name'];


                $cname = anchor('/Reports/qc1_reportsdata/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']), $row['candidate_name'], 'target=_blank');
                $status = $row['status'];
                $action_name = anchor('/Reports/qc1_reportsdata/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']), 'View');


                if ($row['chk'] == 0) {
                    $chkval = $row['checkname'];
                } else {
                    $chkval = $row['checkname'] . $row['chk'];
                }

                $qc_assigndetails = $this->vm->qc_assaindata($row['request_id']);
                $response->rows[]['cell'] = array($i + $count + 1, $row['case_no'], $cname, $row['office_name'], $chkval, $row['assigne'], $status, $action_name);
            }
        }
        echo json_encode($response);
    }

    function qc1_reportsdata()
    {
        $this->load->model('Reports_model', 'rm');
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));

        $request_id = base64_decode($this->uri->segment(3));
        $candidate_info = $this->rm->get_candidateionfo($request_id);
        $data['candidate_info'] = $candidate_info;
        $checks = $this->rm->getcheck($request_id);
        $verification_data = $this->rm->getchecks($request_id, 'qc1');
        $data['checkdata'] = $verification_data;

        $chk = '';
        foreach ($verification_data as $key => $ci) {
            if ($key == 0)
                $chk .= $ci['name'];
            else
                $chk .= ", " . $ci['name'];
        }
        $data['check_type'] = $chk;
        $this->amodel->pagerender($data, 'verification_reports');
    }

    function qc1_satisfy()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        $request_id = base64_decode($this->uri->segment(3));
        $insert_data['request_id'] = $request_id;
        $insert_data['satisfy_status'] = $_POST['satisfy'];
        $this->db->insert(DB_PREFIX . 'verification_status', $insert_data);
        redirect('' . base_url('Verification/qc1_reports/s'));
    }
    /* qc2 assigned list */
    function qc2_verification()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'jquery-ui-1.8.16.custom.min', 'commonjs'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC2 Assigned List', 'Verification/qc2_verification');

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'qc2_verification');
    }
    /*allocation of qc2*/
    function qc2_allocation()
    {
        // $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        // $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC2 Non Assign / Reassign List', 'Verification/qc2_allocation');

        // unshift crumb
        // $newuser =   $this->vm->get_qc2newcaselist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='count');

        // $accuser =   $this->vm->get_qc2acclist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='count');

        // $discripencylist =   $this->vm->get_qc2discrepancylist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='count');
        //  print_r($accuser);exit();
        $data['newlist']  =    $newuser[0]['count'];
        $data['acclist']  =    $accuser[0]['count'];
        $data['discripencylist']  =    $discripencylist[0]['count'];
        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $assignee_list = $this->qc->get_qualitycheck2_list();
        $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list, array('assignee_id', 'name'));
        $this->amodel->pagerender($data, 'qc2_allocation');
    }
    function get_qc2allotedlist()
    {
        $model = array('Verification_model' => 'get_qc2userlist');
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $a_status = ($_REQUEST['a_status']) ? $_REQUEST['a_status'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $list_status = ($_REQUEST['list_status']) ? $_REQUEST['list_status'] : '';

        if ($office) {
            $condition[] = " c.id = " . $office;
        }

        if ($parent_office) {
            $condition[] = " p.id = " . $parent_office;
        }

        if ($sub_office) {
            $condition[] = " s.id = " . $sub_office;
        }

        if ($org_id) {
            $condition[] = " o.id = " . $org_id;
        }

        if ($name) {
            $condition[] = " r.candidate_name like '%" . $name . "%'";
        }

        if ($a_status == 1) {
            $condition[] = " q.qc2_assignee_status = 1 ";
        }

        if ($a_status == 2) {
            $condition[] = " q.qc2_assignee_status IS NULL ";
        }
        //18/01/2024
        $case_no = trim($case_no);
        if ($case_no) {
            $condition[] = " r.case_no like '%" . $case_no . "'";
        }

        if ($list_status == 1) {
            $condition[] = " (( select count(vl.request_id) FROM " . DB_PREFIX . "verified_level vl LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = vl.request_id and vl.check_id = ar.check_id AND vl.level_id = ar.level_id where vl.request_id = a.request_id  and
		CASE WHEN o.dedicated_qc = 17  THEN (ar.verify_status IN (111,110,519) AND ar.vm_assigned_qc=1 ) 
		ELSE ( (ar.verify_status IN (111,110,519)) AND vl.qcstatus IN (111,110,519) ) 
		END ) = (select sum(no_checks) FROM " . DB_PREFIX . "request_check re where re.request_id=a.request_id )) and
		((select sum(no_checks) FROM " . DB_PREFIX . "request_check re where re.request_id=a.request_id ) != (select count(va.rep_id) FROM " . DB_PREFIX . "ver_assign_rep va LEFT JOIN " . DB_PREFIX . "verified_level vl ON va.candidate_req_id = vl.request_id and vl.check_id = va.check_id AND vl.level_id = va.level_id where va.candidate_req_id = a.request_id and va.qc2_report_publish=1)) and a.qc_assignee_status = 1 and q.qc2_assignee_status IS NULL ";
        }
        if ($list_status == 2) {
            $condition[] = " ( CASE WHEN o.dedicated_qc=17 THEN 
                                 vl1.vm_discrepency in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701)
                                 ELSE 
                                 vl1.qc_discrepency in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701) 
                                 END  AND qc2_report_publish !=1 ) and a.qc_assignee_status = 1 and q.qc2_assignee_status IS NULL ";
        }

        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " p.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " s.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " r.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " o.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " r.case_no " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }
        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result[0]['vrequest_id']) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {
                $qc2_assigndetails = $this->vm->qc2_assaindata($row['request_id']);
                $check = '<input type="checkbox" name="request_id[]" value="' . ($row['request_id']) . '"/>';
                $vm_date = isset($row['vm_date']) ? date('d-m-Y', strtotime($row['vm_date'])) : '';
                $qc2_assignname =  $row['assignee_by'];

                if ($qc2_assigndetails) {
                    $response->rows[$i]['cell'] = array($i + $count + 1, $check, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], $row['candidate_name'], $row['case_no'], $qc2_assigndetails[0]['first_name'], $qc2_assignname, 'Assigned', $vm_date, anchor('/Verification/qc2_assignee/' . base64_encode($row['request_id']), 'Reassign'));
                } else {
                    $response->rows[$i]['cell'] = array($i + $count + 1, $check, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], anchor('/Verification/qc2_assignee/' . base64_encode($row['request_id']), $row['candidate_name']), $row['case_no'], 'Not yet Assigned', 'Not yet Assigned', 'New', $vm_date, anchor('/Verification/qc2_assignee/' . base64_encode($row['request_id']), 'Assign'));
                }
            }
        }
        echo json_encode($response);
    }
    function qc2_assignee()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'jquery.validate', 'jquery-ui-1.8.16.custom.min'));
        $data['request_id'] = $request_id = $this->uri->segment(3);
        $operator_id = base64_decode($this->uri->segment(4));
        $candidate_name = $data['checks_result'] = $this->vm->get_userlist(base64_decode($request_id));
        $data['candidate_name'] = $candidate_name[0]['candidate_name'];
        $assignee_list = $this->vm->get_qc2assignee_list();
        if ($operator_id == 0) {
            $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list, array('assignee_id', 'name'));
        } else {
            $operator_name = $this->cm->getopername($operator_id);
            $data['operator_list'] = $operator_name[0];
        }
        $data['title'] = 'New Verification Request';
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC2 Assignee List', 'Verification/qc2_allocation');
        $this->breadcrumbs->push('QC2 Allotment Request', 'Verification/qc2_assignee');
        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();

        $this->amodel->pagerender($data, 'qc2_assignee');
    }

    function p_qc2newrequest()
    {
        $assignee_id = $this->input->post('assignee_id');
        $assign_by =    $_SESSION['name'];
        $date_from = date('Y-m-d');
        $date_to = $this->input->post('date_to');
        $user_id = $this->input->post('user_id');
        $request_id = base64_decode($this->input->post('request_id'));
        $exist_id = $this->vm->getqc2reqid($request_id);
        if ($assignee_id) {
            $upd_data = array();
            $upd_data['assignee_id'] = $assignee_id;
            $upd_data['assignee_by'] = $assign_by;
            $upd_data['qc2_assignee_status'] = 1;
            $upd_data['deadline_from'] = date("Y-m-d", strtotime($date_from));
            $upd_data['deadline_to'] = date("Y-m-d", strtotime($date_to));;
            $upd_data['updated_on'] = date('Y-m-d H:i:s');
            $upd_data['updated_by'] = $this->user_id;
            $upd_data['request_id'] = $request_id;
            $qc2request_id = $exist_id[0]['request_id'];
            if ($qc2request_id) {
                $this->db->where('request_id', $qc2request_id);
                $this->db->update(DB_PREFIX . 'qc2_request', $upd_data);
            } else {
                $upd_data['created_by'] = $this->user_id;
                $upd_data['created_on'] = date('Y-m-d H:i:s');
                $this->db->insert(DB_PREFIX . 'qc2_request', $upd_data);
            }
        }
        redirect(base_url('Verification/qc2_allocation'), 'refresh');
    }
    /* qc2 allotted list*/
    function get_qc2reportslist()
    {
        $model = array('Verification_model' => 'get_qc2list');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $a_date = ($_REQUEST['a_date']) ? $_REQUEST['a_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $verifier_name = ($_REQUEST['verifier_name']) ? $_REQUEST['verifier_name'] : '';
        $chk_status = ($_REQUEST['chk_status']) ? $_REQUEST['chk_status'] : '';
        $reopen_status = ($_REQUEST['reopen_status']) ? $_REQUEST['reopen_status'] : '';
        $qc_name = ($_REQUEST['qc_name']) ? $_REQUEST['qc_name'] : '';

        if ($org_id)
            $condition[] = " o.id = " . $org_id;
        if ($office)
            $condition[] = " cr.office = " . $office;
        if ($parent_office)
            $condition[] = " cr.parent_office = " . $parent_office;
        if ($sub_office)
            $condition[] = " cr.sub_office = " . $sub_office;

        if ($qc_name) {
            $condition[] = " (concat_ws(' ',us.first_name,us.last_name) like '%" . $qc_name . "%') ";
        }
        if ($this->session->userdata['role_id'] == 1 || $this->session->userdata['role_id'] == 24 || $this->session->userdata['role_id'] == 21) {
            if ($a_status == 0)
                $condition[] = "((ar.qc2_verification = 0 and ar.qc1_verification=1 and ar.qc2_revert_request = 0 and vl1.qc2status!=107) or ((ar.qc2_verification = 0 and ar.qc1_verification=1 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 2 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 2  and ar.qc1_assign_revert=1) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 0 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0)) or ((ar.qc1_assign_revert = 1 and ar.qc2_verification = 0 and (vl1.supplementary = 0 || vl1.supplementary = 2))  || (ar.qc1_assign_revert=1 and ar.qc_2_verification=0 and (vl1.supplementary = 0 || vl1.supplementary = 2))) or ((ar.qc2_verification = 1 and ar.qc2_report_publish != 1 and ar.qc2_revert_request = 0) ) or (ar.qc2_verification = 0 and ar.qc1_verification=1 and vl1.qc2status=107) or (ar.qc2_verification = 1 and ar.qc2_report_publish=2 and ar.qc1_assign_revert=0) or (ar.qc1_verification=1 and ar.qc2_verification=0 and ar.qc_revert_request=1 and ar.qc2_revert_request=1 and ar.qc1_assign_revert=1 and ar.qc_2_verification=0 and ar.vm_assigned_qc=1 and vl1.supplementary=1 and  ar.reopen_revert_qc2=0 ) or (ar.qc_2_verification = 1 and  ar.qc2_report_publish = 1 and vl1.supplementary = 1) or (ar.qc1_assign_revert = 1 and  vl1.supplementary = 1 and ar.qc_2_verification = 1 and ar.vm_assigned_qc) or (ar.qc2_revert_request = 1 and vl1.supplementary = 1))";
        }
        if ($a_status == 1)
            $condition[] = "(ar.qc2_verification = 0 and ar.qc1_verification=1 and ar.qc2_revert_request = 0 and vl1.qc2status!=107)";

        if ($a_status == 2)
            $condition[] = " ((ar.qc2_verification = 0 and ar.qc1_verification=1 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 2 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 2  and ar.qc1_assign_revert=1 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 0 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2)))";
        if ($a_status == 3)
            $condition[] = " ((ar.qc1_assign_revert = 1 and ar.qc2_verification = 0 and (vl1.supplementary = 0 || vl1.supplementary = 2))  || (ar.qc1_assign_revert=1 and ar.qc_2_verification=0 and (vl1.supplementary = 0 || vl1.supplementary = 2)))";
        if ($a_status == 4)
            $condition[] = " ((ar.qc2_verification = 1 and ar.qc2_report_publish != 1 and ar.qc2_revert_request = 0) )";
        if ($a_status == 5)
            $condition[] = " (ar.qc2_verification = 1 and ar.qc2_report_publish=1)";
        if ($a_status == 6)
            $condition[] = " (ar.qc2_verification = 0 and ar.qc1_verification=1 and vl1.qc2status=107)";

        if ($a_status == 7)
            $condition[] = " (ar.qc2_verification = 1 and ar.qc2_report_publish=2 and ar.qc1_assign_revert=0)";
        if ($a_status == 8)
            $condition[] = " (ar.qc1_verification=1 and ar.qc2_verification=0 and ar.qc_revert_request=1 and ar.qc2_revert_request=1 and ar.qc1_assign_revert=1 and ar.qc_2_verification=0 and ar.vm_assigned_qc=1 and vl1.supplementary=1 and  ar.reopen_revert_qc2=0 )";
        if ($check_name)
            $condition[] = " md.name like '%" . $check_name . "%'";
        if ($name)
            $condition[] = " cr.candidate_name like '%" . $name . "%'";
        //                 if($a_date)
        // $condition[]="DATE_FORMAT(vl1.qc_date,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($a_date))."'";
        // if($t_date)
        // $condition[]="DATE_FORMAT(vl1.qc_date,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
        //18/01/2024
        $case_no = trim($case_no);
        if ($case_no)
            $condition[] = " cr.case_no like '%" . $case_no . "'";
        if ($verifier_name)
            $condition[] = "(concat_ws(' ',us.first_name,us.last_name) like '%" . $verifier_name . "%') ";
        if ($a_date)
            $condition[] = "((DATE_FORMAT(vl1.qc_date,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($a_date)) . "') OR (DATE_FORMAT(vl1.v_date,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($a_date)) . "'))";
        if ($t_date)
            $condition[] = "((DATE_FORMAT(vl1.qc_date,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date . ' -1 day')) . "') OR (DATE_FORMAT(vl1.v_date,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date . ' -1 day')) . "'))";
        if ($chk_status == 1) {
            $condition[] = " vl1.qc2_dis in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701) ";
        }
        if ($chk_status == 2) {
            $condition[] = " ((vl1.qc2_dis in (120,131,137,143,713,119,130,136,142)) or (vl1.qc2status in (519,110)) or (vl1.vm_discrepency in (1005)))";
        }
        if ($chk_status == 3) {
            $condition[] = " vl1.qc2_dis in (116,127,134,140,630,121,125,658,662,660,789) ";
        }
        if ($reopen_status == 1) {
            $condition[] = " vl1.supplementary in (1,2) ";
        }
        if ($reopen_status == 2) {
            $condition[] = " vl1.supplementary = 3 ";
        }
        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " o.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " s.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vl1.v_date" . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";
                $like    .= $operator . " vl1.qc_date" . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";
                $like    .= $operator . " c.locality " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " md.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vs.qc1_status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vs.qc1_discrapancy " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vl1.status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " cr.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " ar.vm_assigned_qc " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }

        $manual_cond = implode(' and ', $condition);

        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {
                $verified_data = $this->vm->get_verified_data($row['request_id'], $row['level_id'], $row['check_id']);
                $verification_data = toArray(json_decode($verified_data['qc2fielddata']));
                $status4 = '';
                $status1 = $this->vm->get_status($verification_data['status']);
                $status2 = $this->vm->get_status($verification_data['pstatus']);
                $status3 = $this->vm->get_status($verification_data['status1']);
                if ($verification_data['ostatus'] <> '') {
                    $status4 = $this->vm->get_status($verification_data['ostatus']);
                    $status4_id = $verification_data['ostatus']; //  Dec 13th
                }
                if ($verification_data['dstatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['dstatus']);
                if (!empty($status4))
                    $status41 = '-' . $status4['name'];
                else
                    $status41 = '';
                $rpt_status = '';
                if ($row['check_id'] == 1306) { // ka added on april 24
                    $rpt_status = '';
                } // ka added on april 24


                /************************ PF_Verification *************************/
                else if ($row['check_id'] == 652) {
                    if ($verification_data['status'] != 107 && $verification_data['status'] != 684 && !empty($verification_data['status'])) {
                        if ($status3['name'] == "Multiple Active Records" || $status3['name'] == "Discrepant" || $status3['name'] == "Possible Discrepant" || $status3['name'] == "Record Found" || $status3['name'] == "Positive" || $status3['name'] == "Invalid" || $status3['name'] == "Not Completed" || $status3['name'] == "High Risk") {
                            $rpt_status = "<span style='color:red;'>RED</span>";
                        }
                        // Dec 15th
                        else if ($status3['name'] == "No Records" || $status1['name'] == "Stop Check" || $status3['name'] == "Stop Check" || $status3['name'] == "Others" || $status3['name'] == "Possible Match" || $status3['name'] == "Partial Match" || ($status1['name'] == "Others" && ($status4_id != 750 && $status4_id != 699))) {
                            $rpt_status = "<span style='color:orange;'>ORANGE</span>";
                        }
                        /** Dec 13th **/
                        else if ($status1['name'] == "Others" && ($status4_id == 750 || $status4_id == 699)) {
                            $rpt_status = "<span style='color:green;'>GREEN</span>";
                        } else {
                            $rpt_status = "<span style='color:green;'>GREEN</span>";
                        }
                    }
                }

                /********************* PF_Verification *************************************/
                else { // Start else { PF Verification
                    if ($verification_data['status'] != 107 && $verification_data['status'] != 684 && !empty($verification_data['status'])) {
                        if ($status3['name'] == "Discrepant" || $status3['name'] == "Possible Discrepant" || $status3['name'] == "Record Found" || $status3['name'] == "Positive" || $status3['name'] == "No Records" || $status3['name'] == "Invalid" || $status3['name'] == "Not Completed" || $status3['name'] == "High Risk") {
                            $rpt_status = "<span style='color:red;'>RED</span>";
                        }
                        // Dec 15th
                        else if ($status3['name'] == "No Records" || $status1['name'] == "Stop Check" || $status3['name'] == "Stop Check" || $status3['name'] == "Others" || $status3['name'] == "Possible Match" || $status3['name'] == "Partial Match" || ($status1['name'] == "Others" && ($status4_id != 750 && $status4_id != 699))) {
                            $rpt_status = "<span style='color:orange;'>ORANGE</span>";
                        }
                        /** Dec 13th **/
                        else if ($status1['name'] == "Others" && ($status4_id == 750 || $status4_id == 699)) {
                            $rpt_status = "<span style='color:green;'>GREEN</span>";
                        }
                        /** Aug 24th **/
                        else {
                            $rpt_status = "<span style='color:green;'>GREEN</span>";
                        }
                    }
                } //END else } PF_Verification    

                $slug = url_title(convert_accented_characters($row['name']), 'underscore', TRUE);
                if ($row['check_id'] == 14)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'education_details');
                else if ($row['check_id'] == 16)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'contact_details', 'request_id', 'permanent_address');
                else if ($row['check_id'] == 59)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'employment', 'req_id', 'level_id');
                else if ($row['check_id'] == 76 || $row['check_id'] == 77 || $row['check_id'] == 75)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], $slug, 'request_id', 'level_name');
                else
                    $levelnames['level'] = $row['name'];

                $cname = $row['candidate_name'];
                if ($row['status'] == 1) {
                    if ($row['qc2_verification'] == 0 && $row['qc1_verification'] == 1 && $row['qc2status'] != 107) {

                        $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qcstatus');
                        $status = 'New';
                        $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                        $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                        $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');

                        if ($row['qc_revert_request'] == 0) {
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else if ($row['qc_revert_request'] == 1 && $row['qc2_revert_request'] == 0) {
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        }
                        // March 17th 2023
                        // else if($row['qc1_assign_revert']==1  && $row['supplementary']==1 && $row['qc_2_verification']==0 && $row['vm_assigned_qc']==1 && $row['reopen_revert_qc2']==1){

                        else if ($row['qc1_assign_revert'] == 1  && $row['qc_2_verification'] == 0 && $row['vm_assigned_qc'] == 1 && $row['reopen_revert_qc2'] == 0) {
                            $status = 'Revert Closed';
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        }

                        // March 17th 
                        // else if($row['qc1_assign_revert']==1  && $row['supplementary']==1 && $row['qc_2_verification']==0 && $row['vm_assigned_qc']==1){

                        else if ($row['qc1_assign_revert'] == 1  && $row['supplementary'] == 1 && $row['qc_2_verification'] == 0 && $row['vm_assigned_qc'] == 1 && $row['reopen_revert_qc2'] == 1) {
                            $status = 'Reopen Closed';
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else if ($row['qc1_assign_revert'] == 1) {
                            $status = 'Revert Closed';
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        }

                        //  Added on March 17th
                        else if ($row['qc2_revert_request'] == 1 && $row['reopen_revert_qc2'] == 1 && $row['supplementary'] == 1  && $row['qc2_report_publish'] == 2) {
                            if ($row['revertedBy'] == 17) {
                                $status = 'Revert Raised';
                            } else {
                                $status = 'Reopened';
                            }
                        } else if ($row['qc2_revert_request'] == 1 && $row['reopen_revert_qc2'] == 1 && $row['supplementary'] == 1  && $row['qc2_report_publish'] == 1) {
                            if ($row['revertedBy'] == 17) {
                                $status = 'Revert Raised';
                            } else {
                                $status = 'Reopened';
                            }
                        } // March 17th 

                        else if ($row['qc2_revert_request'] == 1 && $row['reopen_revert_qc2'] == 1 && $row['supplementary'] == 1) {
                            $status = 'Revert Raised';
                            $cname = $row['candidate_name'];
                            $action_name = 'View';
                        }

                        // March 17th
                        // else if($row['qc2_revert_request']==1 && $row['supplementary']==1)
                        else if ($row['qc2_revert_request'] == 1 && $row['supplementary'] == 1 && $row['vm_assigned_qc'] == 1) {
                            $status = 'Reopened';
                            $cname = $row['candidate_name'];
                            $action_name = 'View';
                        } else if ($row['qc2_revert_request'] == 1) {
                            $status = 'Revert Raised';
                            $cname = $row['candidate_name'];
                            $action_name = 'View';
                        }
                    } else {
                        $statusname = $this->vm->get_status_name($row['request_id'], $row['check_id'], $row['level_id'], 'qc2status');
                        if ($statusname['name'] == 'Clear') {
                            $status = 'QC2 Approved';
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                        } else if ($statusname['name'] == 'Verified') {
                            $status = 'QC2 Approved';
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                        } else if ($row['qc2_verification'] == 0 && $row['qc1_verification'] == 1 && $row['qc2status'] == 107) {
                            $status = 'Initiated';
                        } else {
                            $status = 'QC2 Approved';
                            $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');
                            $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                            $caller_details = anchor('/Verification/add_verifiercalls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Verifier Details', 'target="_blank"');
                        }
                        if ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 0) {
                            if ($row['qc1_assign_revert'] == 1) {
                                $status = 'QC2 Approved';
                            } else if ($row['qc2_revert_request'] == 1) {
                                $status = 'Revert Raised';
                            }

                            $cname = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        }

                        // Commented on March 17th 2023
                        //  elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==1 && $row['supplementary']==1 && $row['reopen_revert_qc2']== 1)
                        // {
                        // $status='Revert assigned';
                        // $cname=anchor('/Verification/qc2_verified/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),$row['candidate_name']);
                        // $action_name=anchor('/Verification/qc2_verified/'.base64_encode($row['request_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['check_id']).'/'.base64_encode($row['pack_id']),'View');
                        // }

                        elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 1 && $row['supplementary'] == 1) {
                            $status = 'Reopen assigned';
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 1) {
                            $status = 'Report Published';
                            $cname = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 1 && $row['supplementary'] == 1) {
                            $status = 'Reopen';
                            $cname = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 2 && $row['qc2_revert_request'] == 0) {
                            $status = 'Report Reopen';
                            $cname = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'Reopen');
                        } elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 2 && $row['qc2_revert_request'] == 1 && $row['qc1_assign_revert'] == 0) {
                            $status = 'Revert Raised';
                            $cname = $row['candidate_name'];
                            $action_name = 'View';
                        }
                        // March 17th
                        elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 1  && $row['qc1_assign_revert'] == 1 && $row['vm_assigned_qc'] == 0) {
                            $status = 'Revert Raised';
                        } // March 17th

                        elseif ($row['qc_2_verification'] == 1 && $row['qc2_report_publish'] == 2  && $row['qc1_assign_revert'] == 1) {
                            $status = 'Revert Raised';
                            $cname = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        }
                        //revert status for qc submit qc2 publish reverted
                        elseif ($row['qc1_assign_revert'] == 1 && $row['qc_2_verification'] == 0) {
                            $status = 'Revert Closed';
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else if ($row['qc2_verification'] == 0 && $row['qc1_verification'] == 1 && $row['qc2status'] == 107) {
                            $status = 'Initiated';
                            $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        } else {
                            $cname = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                            $action_name = anchor('/Verification/qc2_verified/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), 'View');
                        }
                    }
                } else
                    $status = 'Verification Pending';
                $supplement = '';
                if ($row['supplementary'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc1_assign_revert'] == 1 && $row['qc_2_verification'] == 0) {
                    $supplement = 'Reopen';
                    $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                }
                if ($row['supplementary'] == 1 && $row['vm_assigned_qc'] == 1 && $row['qc1_assign_revert'] == 0 && $row['qc_2_verification'] == 1) {
                    $supplement = 'Reopen';
                    $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                }

                // March 17th
                if ($row['supplementary'] == 1 && $row['vm_assigned_qc'] == 0 && $row['qc1_assign_revert'] == 0 && $row['qc_2_verification'] == 0) {
                    $supplement = 'Reopen';
                } elseif ($row['supplementary'] == 1 && $row['vm_assigned_qc'] == 0 && $row['qc1_assign_revert'] == 0 && $row['qc_2_verification'] == 1) {
                    $supplement = 'Reopen';
                    $cname = $row['candidate_name'];
                } elseif ($row['supplementary'] == 2 && $row['qc2_verification'] == 1 && $row['qc2_revert_request'] == 0 && $row['qc_2_verification'] == 1) {
                    $supplement = 'Reopen';
                    $cname = anchor('/Verification/qc2_publish/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                } elseif ($row['supplementary'] == 2 && $row['qc2_verification'] == 0 && $row['qc2_revert_request'] == 1 && $row['qc_2_verification'] == 0) {
                    $supplement = 'Reopen';
                    $cname = anchor('/Verification/qc2cal_reports/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']), $row['candidate_name']);
                } elseif ($row['supplementary'] == 3) {
                    $supplement = 'Reopen-Completed';
                }

                if ($row['chk'] == 0) {
                    $chkval = $row['name'];
                } else {
                    $chkval = $row['name'] . $row['chk'];
                }
                if (!empty($status1['name'])) {
                    $stat = $status1['name'] . '-' . $status2['name'] . '-' . $status3['name'] . '' . $status41;
                } else {
                    $stat = '';
                }

                $deadline_from = isset($row['qc_date']) ? date('d-m-Y', strtotime($row['qc_date'])) : '';
                if ($row['qc_date']) {
                    $deadline_to = isset($row['qc_date']) ? date('d-m-Y', strtotime($row['qc_date'] . ' +1 day')) : '';
                } else {
                    $deadline_from = isset($row['v_date']) ? date('d-m-Y', strtotime($row['v_date'])) : '';
                    $deadline_to = isset($row['v_date']) ? date('d-m-Y', strtotime($row['v_date'] . ' +1 day')) : '';
                }

                $qc2_revert_date = (isset($row['qc2_revert_date']) && $row['qc2_revert_date'] != "0000-00-00 00:00:00") ? date('d-m-Y', strtotime($row['qc2_revert_date'])) : '';
                $qc_assigndetails = $this->vm->qc_assaindata($row['request_id']);

                $response->rows[]['cell'] = array($i + $count + 1,  $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], $cname, $row['case_no'], $chkval, $status, $stat, $rpt_status, $supplement, $procedure_details, $verfier_details, $caller_details, $row['vmname'], $row['qc2name'], $qc2_revert_date, $deadline_from, $deadline_to, $action_name);
            }
        }

        echo json_encode($response);
    }

    function qc2_reportsdata()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        $request_id = base64_decode($this->uri->segment(3));
        $level_id = base64_decode($this->uri->segment(4));
        $check_id = base64_decode($this->uri->segment(5));
        $this->db->select('order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';

        $personalreport_data = $this->vm->personalreportsdata($request_id);
        $data['personal_data'] = $personalreport_data;

        $educationreport_data = $this->vm->geteducationreportsdata($request_id);
        $data['education_data'] = $educationreport_data;
        $data['other_details'] = $this->vm->otherreportsdata($request_id);
        $data['dataentrypersonal'] = $this->vm->personaldetails($request_id);
        $data['dataentryeducation'] = $dataentryeducation = $this->vm->educationdetails($request_id);
        $data['dataentryother'] = $this->vm->otherdetails($request_id);
        $data['qc1personaldata'] = $this->vm->qcspersonalreportsdata($request_id);
        $data['qc1_edudata'] = $this->vm->qc1_edu_reportsdata($request_id);
        $data['qc1otherdata'] = $this->vm->qcsotherreportsdata($request_id);
        $data['status'] = $this->dem->get_check_status($check_id, 111);
        $data['dataentrydata'] = $this->dem->educationdetails($request_id, $level_id);
        $data['verified_data'] = $this->vm->get_verified_data($request_id, $level_id, $check_id);
        $this->amodel->pagerender($data, 'verification_reports');
    }
    function qc2_reportsdetails()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        $request_id = base64_decode($this->uri->segment(3));
        $this->db->select('order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';

        $personalreport_data = $this->vm->q2getpersonalreportsdata($request_id);
        $data['personal_data'] = $personalreport_data;

        $educationreport_data = $this->vm->q2edu_reports($request_id);
        $data['education_data'] = $educationreport_data;

        $data['other_details'] = $this->vm->q2getotherreportsdata($request_id);
        $this->amodel->pagerender($data, 'verification_reports');
    }

    function getcandidate_status()
    {
        $request_id = $this->uri->segment(3);
        $results = $this->amodel->getDetails(DB_PREFIX . "verification_status", array('personal_status', 'other_status', 'educational_status'), array('request_id' => $request_id));
    }
    function add_calls()
    {


        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.validate', 'jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));

        $data['request_id'] = $candidate_id = base64_decode($this->uri->segment(3));
        $data['level_id'] = $level_id = base64_decode($this->uri->segment(4));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(5));

        $request_id = base64_decode($this->uri->segment(3));
        $level_id = base64_decode($this->uri->segment(4));
        $this->db->select('candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';

        $vmcalldetails = $this->amodel->getDetails(DB_PREFIX . "add_calls", array('*'), array('candidate_req_id' => $candidate_id, 'check_id' => $check_id, 'level_id' => $level_id), $this->db->order_by("id", "desc"));

        $allemailcount = $this->amodel->getDetails(DB_PREFIX . "add_calls", array('*'), array('candidate_req_id' => $candidate_id, 'check_id' => $check_id, 'level_id' => $level_id, 'reminder' => 'on'), $this->db->order_by("id", "desc"));

        $query = $this->db->query("SELECT * FROM dcode_add_calls WHERE id = (SELECT MAX(id) FROM dcode_add_calls WHERE reminder = 'on' and  candidate_req_id = '" . $candidate_id . "' and check_id = '" . $check_id . "' and level_id = '" . $level_id . "')");

        if ($query->num_rows() == 1) {
            $row = $query->row();
        }

        $data['contact_name_add'] = $vmcalldetails[0]['contact_person'];
        $data['designation_contact'] = $vmcalldetails[0]['designation_person'];
        $data['mobile'] = $vmcalldetails[0]['contact_no'];
        $data['email'] = $vmcalldetails[0]['email'];
        $data['reminder'] = $vmcalldetails[0]['reminder'];
        //$data['total_count']   = count($allemailcount);

        if ($vmcalldetails) {
            if ($vmcalldetails[0]['reminder'] == off) {
                $data['total_count']   = $row->email_count;
            } else {
                $data['total_count']   = $row->email_count;
            }
        } else {
            $data['total_count'] = 0;
        }

        $this->amodel->pagerender($data, 'add_calls');
    }

    function add_callsqc()
    {


        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.validate', 'jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));

        $data['request_id'] = $candidate_id = base64_decode($this->uri->segment(3));
        $data['level_id'] = $level_id = base64_decode($this->uri->segment(4));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(5));


        $request_id = base64_decode($this->uri->segment(3));
        $level_id = base64_decode($this->uri->segment(4));
        $this->db->select('candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();

        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';
        $this->amodel->pagerender($data, 'add_calls');
    }
    function add_verifiercalls()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.validate', 'jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));

        $data['request_id'] = $candidate_id = base64_decode($this->uri->segment(3));
        $data['level_id'] = $level_id = base64_decode($this->uri->segment(4));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $request_id = base64_decode($this->uri->segment(3));
        $level_id = base64_decode($this->uri->segment(4));
        $this->db->select('candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();

        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';
        $data['verified_data'] = $this->vm->get_verified_data($request_id, $level_id, $check_id);
        $this->amodel->pagerender($data, 'add_verifiercalls');
    }
    function addcallsdml()
    {
        $request_id = base64_decode($this->uri->segment(3));
        $level_id = base64_decode($this->uri->segment(4));
        $check_id = base64_decode($this->uri->segment(5));
        $pack_id = base64_decode($this->uri->segment(6));
        $formData = $_POST;

        $this->db->select('case_no');
        $this->db->where('request_id', $request_id);
        $CaseNo = $this->db->get(DB_PREFIX . 'client_request')->row_array();

        $this->vm->call_m_dml($formData, $request_id, $level_id, $check_id);
        if ($formData['total_count'] > 4) {
            $result =  $this->amodel->reminderemail($request_id, $level_id, $check_id);
            $this->send_email_reminder('vm_reminder_mail', "Reminders completed", $result[0]['email'], $result);
        }

        /************* Status Updtes ***************/
        if ($formData['reminder'] == 'on') {
            $stat_save['request_id'] = $request_id;
            $stat_save['case_no'] = $CaseNo['case_no'];
            $stat_save['check_id'] = $check_id;
            $stat_save['level_id'] = $level_id;
            $stat_save['check_status'] = 1005;
            $stat_save['verified_status'] = '';
            $stat_save['date_of_update'] = date('y-m-d H:i:s');
            $stat_save['role_id'] = $this->session->userdata('role_id');
            $stat_save['user_id'] = $this->session->userdata['userid'];
            // print_r($stat_save);exit;
            $stat_save = $this->security->xss_clean($stat_save);
            $this->db->insert(DB_PREFIX . 'status_updates', $stat_save);
            /******************************************/
        }

        redirect('Verification/add_calls/' . base64_encode($request_id) . '/' . base64_encode($level_id) . '/' . base64_encode($check_id) . '/' . base64_encode($pack_id));
    }
    function addcallsadmindml()
    {

        $presale_id = base64_decode($this->uri->segment(3));
        $formData = $_POST;
        $this->vm->call_admin_dml($formData, $presale_id);
        redirect('Meeting/presaleview/' . base64_encode($presale_id));
    }
    function verifier_details()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));

        $data['request_id'] = $candidate_id = base64_decode($this->uri->segment(3));
        $data['level_id'] = $level_id = base64_decode($this->uri->segment(4));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $this->db->select('candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $candidate_id))->result_array();
        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';
        $this->amodel->pagerender($data, 'verifier_details');
    }
    function get_call_details()
    {
        $request_id = ($_REQUEST['request_id']) ? $_REQUEST['request_id'] : '';
        $level_id = ($_REQUEST['level_id']) ? $_REQUEST['level_id'] : '';
        $check_id = ($_REQUEST['check_id']) ? $_REQUEST['check_id'] : '';
        $email = ($_REQUEST['email']) ? $_REQUEST['email'] : '';
        $mobile = ($_REQUEST['mobile']) ? $_REQUEST['mobile'] : '';
        if ($request_id)
            $condition[] = " candidate_req_id = " . $request_id;
        if ($level_id)
            $condition[] = " level_id = " . $level_id;
        if ($check_id)
            $condition[] = " check_id = " . $check_id;
        if ($email)
            $condition[] = " email = " . $email;
        if ($mobile)
            $condition[] = " contact_no=" . $mobile;

        $manual_cond = implode(' and ', $condition);
        $model = array('Verification_model' => 'verfierdetails');
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];

        if ($result) {
            foreach ($result as $i => $row) {

                if ($row['reminder'] == 'on') {

                    $emailcount =  "Reminder " . $row['email_count'];
                } else {
                    $emailcount = ' ';
                }
                $mob =      str_replace(',', '<br>', $row['contact_no']);


                $response->rows[]['cell'] = array($i + 1, $row['contact_person'], $row['designation_person'], $mob, $row['email'], $emailcount, date('d-m-Y h:i:s', strtotime($row['created_at'])), $row['mom'], $row['first_name']);
            }
        }
        echo json_encode($response);
    }
    function allocation_user()
    {

        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min'));

        $this->db->select('id,name');
        $data['checklevels'] = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('parent' => 0, 'key' => 'Check'))->result_array();
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Checklist Allotment', 'Verification/allocation_user');


        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'checklist_allotment');
    }
    function allocation_check($checkid)
    {
        $check_id = base64_decode($this->uri->segment(3));
        $eassignee = $this->dm->get_assigneecheck_list($check_id);
        $data['assignee_list'] = $this->amodel->filterDropdown($eassignee, array('id', 'name'));
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min'));

        $this->db->select('id,name');
        $data['checklevels'] = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('parent' => 0, 'key' => 'Check', 'id' => $check_id))->row_array();
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Checklist Allotment', 'Verification/allocation_user');
        $this->breadcrumbs->push('Checklist Details', 'Verification/allocation_check');

        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'checklist_allotment');
    }

    function get_allocationcheck()
    {

        $check_id = ($_REQUEST['check_id']) ? $_REQUEST['check_id'] : '';
        if ($check_id == 14) {
            $model = array('Dadmin_model' => 'get_allocationeducheck');
        } else if ($check_id == 59) {
            $model = array('Dadmin_model' => 'get_allocationempcheck');
        } else {
            $model = array('Dadmin_model' => 'get_allocationcheck');
        }


        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $cmp_name = ($_REQUEST['cmp_name']) ? $_REQUEST['cmp_name'] : '';
        $clg_name = ($_REQUEST['clg_name']) ? $_REQUEST['clg_name'] : '';
        $uni_name = ($_REQUEST['uni_name']) ? $_REQUEST['uni_name'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        if ($office)
            $condition[] = " co.id = " . $office;
        if ($org_id)
            $condition[] = " po.id = " . $org_id;
        if ($parent_office)
            $condition[] = " cr.parent_office = " . $parent_office;
        if ($sub_office)
            $condition[] = " cr.sub_office = " . $sub_office;
        if ($clg_name)
            $condition[] = " e.collegename_add like '%" . $clg_name . "%'";
        if ($name)
            $condition[] = " cr.candidate_name like '%" . $name . "%'";
        if ($cmp_name)
            $condition[] = " e.company_name like '%" . $cmp_name . "%'";
        if ($uni_name)
            $condition[] = " e.affliated like '%" . $uni_name . "%'";
        if ($case_no)
            $condition[] = " cr.case_no like '%" . $case_no . "'";
        if ($check_id)
            $condition[] = " rc.check_id = " . $check_id;

        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            $cnt = 0;
            $cnt1 = 0;
            foreach ($result as $i => $row) {
                if ($row['chkid'] == 14 || $row['chkid'] == 59) {
                    $count_checks = 1;
                } else {
                    $count_checks = $row['no_checks'];
                }
                $check = '<input type="checkbox" name="request_id[]" value="' . ($row['request_id']) . '" />';
                $response->rows[$cnt]['cell'] = array($check, $row['orgname'], $row['parent_office'], $row['office_name'], $row['sub_office'], $row['candidatename'], $row['case_no'], $row['company_name'], $row['collegename_add'], $row['affliated'], $count_checks);
                $cnt++;
            }
        }
        echo json_encode($response);
    }


    function savechecklist()
    {

        $datas = $_POST;
        $save_batch = array();
        $cnt = 0;
        $save = array();

        if (!empty($datas)) {

            foreach ($datas['request_id'] as $key => $userid) {

                $chk_Details = $this->vm->getchkDetails($userid, $datas['check_id']);

                $exist_id = $this->vm->getreqid($userid);
                $upd_data = array();
                $upd_data['assignee_id'] = 0;
                $upd_data['assignee_status'] = 1;
                $upd_data['deadline_from'] = date("Y-m-d");
                //$upd_data['deadline_to'] = date("Y-m-d", strtotime("+5 days"));

                $upd_data['request_id'] = $datas['request_id'][$userid];
                $vrequest_id = $exist_id[0]['request_id'];

                $this->db->insert(DB_PREFIX . 'verification_status', array('request_id' => $userid, 'verification_status' => 1));

                if ($chk_Details) {

                    foreach ($chk_Details as $check) {
                        if ($datas['assignee_id']) {
                            $slug = url_title(convert_accented_characters($check['name']), 'underscore', TRUE);
                            switch ($check['id']) {
                                case 14:
                                    $levels = $this->vm->getcheckDetails($userid, 'education_details', 'request_id', $check['id']);
                                    break;
                                case 15:
                                    $levels = $this->vm->getcheckDetails($userid, 'permanent_contact_details', 'request_id', $check['id']);
                                    break;
                                case 16:
                                    $levels = $this->vm->getcheckDetails($userid, 'contact_details', 'request_id', $check['id']);
                                    break;
                                case 59:
                                    $levels = $this->vm->getcheckDetails($userid, 'employment', 'req_id', $check['id']);
                                    break;
                                default:
                                    $levels = $this->vm->getcheckDetails($userid, $slug, 'request_id', $check['id']);
                            }
                            if ($levels[1] == TRUE) {
                                $k = 1;
                            } else {
                                $k = 0;
                            }

                            $_POST['startdate'] = date('Y-m-d');
                            $d = new DateTime($_POST['startdate']);
                            $t = $d->getTimestamp();
                            for ($i = 0; $i < $check['verification_tat']; $i++) {
                                $addDay = 86400;
                                $nextDay = date('w', ($t + $addDay));
                                if ($nextDay == 0 || $nextDay == 6) {
                                    $i--;
                                }
                                $t = $t + $addDay;
                            }
                            $d->setTimestamp($t);
                            $DeadlineTo = $d->format('Y-m-d');

                            // $upd_data['deadline_to'] = date("Y-m-d", strtotime("+".$check['verification_tat']." days"));
                            $upd_data['deadline_to'] = $DeadlineTo;

                            foreach ($levels as $level) {
                                $assigneeData = array('team_mem_id' => $datas['assignee_id'], 'candidate_req_id' => $userid, 'level_id' => $level['id'], 'check_id' => $check['id'], 'verify_status' => 107, 'count_of_chk' => $k);
                                $this->db->insert(DB_PREFIX . 'ver_assign_rep', $assigneeData);
                                $upd_data = array('assignee_status' => 1, 'deadline_from' => date("Y-m-d"), 'deadline_to' => $DeadlineTo, 'request_id' => $userid, 'level_id' => $level['id'], 'check_id' => $check['id'], 'pack_id' => 0);
                                $this->db->insert(DB_PREFIX . 'verification_request', $upd_data);
                                $k++;
                            }
                        }
                    }
                }
            }
        }
        redirect('Verification/allocation_user');
    }
    function revert_raisedsview()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'jquery.datepick', 'multipleclone', 'jquery.validate', 'grid.locale-en', 'jquery.jqGrid.min'));
        $condition['candidate_req_id'] = $request_id = base64_decode($this->uri->segment(3));
        $condition['level_id'] = $level_id = base64_decode($this->uri->segment(4));
        $condition['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $condition['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));
        $this->db->select('dataentry_by');
        $dataentrywise = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $values = $dataentrywise[0]['dataentry_by'];
        $assignee_list = $this->vm->get_assignee_list_super($values);
        $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list, array('assignee_id', 'name'));
        $this->load->helper('cloneform');

        $skillsadd_clones = array(array('document_name' => array('text', 'document_name', '', '', '', '', ''), 'authenticate_doc' => array('upload', 'authenticate_doc', '', '', '', '', ''), 'preview' => array('label', 'preview')));
        $data['skills_file_clone'] = create_cloneform($skillsadd_clones, '', $user_id);
        $data['upload_file'] = formclonecreation($skillsadd_clones, $data['skills_file_clone'], 1, 'Add Document', "Multiple Document");

        $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['level_id'] = $level_id = base64_decode($this->uri->segment(4));
        $data['check_id'] = base64_decode($this->uri->segment(5));
        $data['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));

        $this->db->select('ticket_status');
        $data['ticket'] = $this->db->get_where(DB_PREFIX . 'ticket_details', array('request_id' => $request_id, 'check_id' => $check_id, 'level_id' => $level_id, 'current_status' => 1))->result_array();

        $revertname = $this->vm->check_revertname($request_id, $check_id, $level_id);
        $checkreport = $this->vm->check_report($condition);
        $revertreport = $this->vm->revert_report($condition);
        $revertexpences = $this->db->query("select p.check_id,a.vm_amount,a.vm_expences,a.vm_reference,a.check_id as profile_id,a.case_no,a.created_on,c.org_name,b.office_name,b.address1,b.address2,b.address3,b.locality,b.pincode,d.office_name as parent_office,o.office_name as sub_office,a.id,a.candidate_name, p.no_checks from " . DB_PREFIX . "billing a 
               
                LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
                    LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    LEFT JOIN " . DB_PREFIX . "request_check p ON p.request_id=a.request_id
                
                where a.request_id =" . $request_id . " and a.billing_type=517 GROUP BY c.org_name")->result_array();
        $data['revertname'] = $revertname;
        $data['revertexpencess'] = $revertexpences;
        $data['revertcomment'] = $revertreport;
        $this->db->select('name');
        $order = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->result_array();
        $key = $data['key'] = $order[0]['name'];
        $this->db->select('order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';
        $this->db->select('name');
        $data['checkname'] = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->row_array();
        $slug = url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);
        $revertreason = $this->db->query("select qc_rcomments , qc_revert_reason from " . DB_PREFIX . "ver_assign_rep 
                       	 where candidate_req_id=" . $request_id . " and check_id=" . $check_id . " and level_id=" . $level_id)->result_array();
        $data['revertreason'] = $revertreason[0]['qc_rcomments'];
        $rev_reason = $revertreason[0]['qc_revert_reason'];
        $revertreason_name = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $rev_reason))->row_array();
        $data['revert_reason_name']  = $revertreason_name['name'];

        $data['verified_data'] = $this->vm->get_verified_data($request_id, $level_id, $check_id);
        $valueed_data = $data['verified_data'];
        $verify_fielddata = toArray(json_decode($valueed_data['fielddata']));
        $data['verifying_fielddata'] = $verify_fielddata;
        $data['expencedata'] = toArray(json_decode($valueed_data['vmexpenses']));
        if ($pack_id > 94)
            $level_details = $this->dm->$slug($request_id, $pack_id, $level_id);
        else
            $level_details = $this->dm->$slug($request_id, $check_id, $level_id);
        $this->db->select('id');
        $checkname = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('parent' => $check_id, 'name' => $level_details[0]['level_name']))->row_array();

        $data['dataentrydata'] = $level_details[0];
        $data['verified_data'] = $this->vm->get_verified_data($request_id, $level_id, $check_id);
        if ($check_id == 76 || $check_id == 77) {
            $check_id = $checkname['id'];
            $data['scheck_id'] = $check_id;
        } else
            $data['scheck_id'] = $check_id;

        $data['status'] = $this->dem->get_check_status($check_id, 0);
        $data['reqstatus'] = $this->dem->get_check_status($check_id, 684);
        $verification_field = toArray(json_decode($data['verified_data']));
        $data['verification_field'] = $verification_field;
        $data['level_data'] = $level_details;
        $data['international_db'] = $this->db->query("select * from " . DB_PREFIX . "international_chk where checkid=" . $check_id . " order by sort_order asc,id asc")->result_array();
        $this->db->select('*');
        $partial_coduments = $this->db->get_where(DB_PREFIX . 'partial_upload_document', array('request_id' => $request_id, 'status' => '1'))->result_array();

        $this->db->where('req_id', $request_id);
        $this->db->where('status', 1);
        $this->db->select('upload_file as multipleupload,file_name as document_name');
        $offline_coduments =  $this->db->get(DB_PREFIX . 'candidate_upload_files')->result_array();
        $this->db->where('request_id', $request_id);
        $this->db->where('check_id', $check_id);
        $this->db->where('level_id', $level_id);
        $this->db->where('status', '1');
        $this->db->select('authenticate_doc,document_name');
        $offline_multicoduments = $this->db->get(DB_PREFIX . 'vm_upload_files')->result_array();
        $data['offline_multicodument'] = $offline_multicoduments;

        $data['partial_coduments'] = array_merge($partial_coduments, $offline_coduments);
        $data['documents'] = $this->vm->documentsup($request_id);
        $data['devices'] = $this->vm->all_devices();
        $data['dataentryoperator'] = $dataentryoperator = $this->db->query("select u.role_id as assignee_id,concat_ws(' ',first_name,middle_name,last_name)as name from " . DB_PREFIX . "user a
               left join " . DB_PREFIX . "submit_cv c ON c.operator_submited_by=a.id
               left join " . DB_PREFIX . "users_roles u on u.user_id = a.id
                where request_id=" . $request_id)->result_array();
        $data['authorization_letter'] = $this->db->query("select company_decl_doc from " . DB_PREFIX . "declaration_details where user_id=" . $request_id)->row_array();
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('VM - Revert Details', 'Verification/revert_raisedsview');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->db->select('acceptable_limit');
        $data['discrepancy_limit'] = $discrepancy_limit = $this->db->get_where(DB_PREFIX . 'add_check', array('order_id' => $orderid[0][order_id], 'types_of_check' => $check_id))->row_array();
        $data['contsofcheck'] = $this->vm->countsofchk($request_id, $check_id, $level_id);
        $data['total_chk'] = $this->vm->getallchecks($request_id);
        if ($pack_id > 94)
            $colour_details = $this->vrm->$slug($pack_id);
        else
            $colour_details = $this->vrm->$slug($check_id);
        $data['colourtxt'] = $colour_details;
        $data['deo_additional_document'] = $this->vm->deo_add_doc($request_id);
        $data['revertdate'] = $revertdate = $this->vm->check_revertdate($request_id, $check_id, $level_id);
        if ($check_id == 651  || $check_id == 644 || $check_id == 1306 || $check_id == 647 || $check_id == 646 || $check_id == 645 || $check_id == 653 || $check_id == 654) {
            $data['check_id'] = $check_id;
            $data['inter_charges'] = $inter_charges = $this->db->query("select * from " . DB_PREFIX . "service_charges_intchecks where request_id=" . $request_id . " && check_id=" . $check_id . " && level_id=" . $level_id . "")->result_array();

            if (!empty($inter_charges[0]['currency'])) {
                $data['chkcharge'] = 1;
            } else {
                $data['chkcharge'] = 0;
            }
        }
        $this->amodel->pagerender($data, 'verification_reports');
    }
    function verify_revertqc1()
    {
        // ka added on may 20
        if ($_POST['check_id'] == 1306) {
            $existing_record_json = $this->vm->fetch_existing_record_json($_POST['request_id']);
            $existing_record = json_decode($existing_record_json['gapdata'], true);
            $count_gap = count($existing_record);
            for ($i = 0; $i < $count_gap; $i++) {
                if (!empty($_POST['previous_org'][$i])) {
                    $cleaned_previous_org = str_replace(array("\\n", "\\r", "\\"), '', $_POST['previous_org'][$i]);
                    $cleaned_previous_org = str_replace("'", "''", $cleaned_previous_org); 
                    $existing_record[$i]['previous_org'] = trim($cleaned_previous_org);
                }
                if (!empty($_POST['next_org'][$i])) {
                    $cleaned_next_org = str_replace(array("\\n", "\\r", "\\"), '', $_POST['next_org'][$i]);
                    $cleaned_next_org = str_replace("'", "''", $cleaned_next_org); 
                    $existing_record[$i]['next_org'] = trim($cleaned_next_org);
                }
                //  Jan 20th 2025
                if(!empty($existing_record[$i]['gap_reason_emp']))
                {
                    $cleaned_reason_emp = str_replace(array("\\n", "\\r", "\\"), '', $existing_record[$i]['gap_reason_emp']);
                    $cleaned_reason_emp = str_replace("'", "''", $cleaned_reason_emp); 
                    $existing_record[$i]['gap_reason_emp'] = trim($cleaned_reason_emp);
                }
                //  Jan 20th 2025
            }
            $json_gap = json_encode($existing_record);
            //print_r($json_gap);
            $this->vm->update_company_name_forgap($_POST['request_id'], $json_gap);
            $cleaned_data = $existing_record;
        }
        // ka added on may 20th

         // ************************************ education and employment gap *********************
        // ka added on july 17
        if (($_POST['check_id'] == 1306)) {
            $existing_record_edu_json = $this->vm->fetch_existing_record_edu_json($_POST['request_id']);
            $existing_record_edu = toArray(json_decode($existing_record_edu_json['gap_edu']));
            $count_gap_edu = count($existing_record_edu);
            for ($i = 0; $i < $count_gap_edu; $i++) {
                if (!empty($_POST['qualification'][$i] != '')) {
                    $cleaned_qualification = str_replace(array("\\n", "\\r", "\\"), '', $_POST['qualification'][$i]);
                    $cleaned_qualification = str_replace("'", "''", $cleaned_qualification); // Jan 15th 2025
                    $existing_record_edu[$i]['qualification'] = trim($cleaned_qualification);
                }
                
                if (!empty($_POST['previous_org_edu'][$i] != '')) {
                    $cleaned_previous_org_edu = str_replace(array("\\n", "\\r", "\\"), '', $_POST['previous_org_edu'][$i]);
                    $cleaned_previous_org_edu = str_replace("'", "''", $cleaned_previous_org_edu); // Jan 15th 2025
                    $existing_record_edu[$i]['previous_org_edu'] = trim($cleaned_previous_org_edu);
                }
                /** Added on Dec 19th **/    
                if(!empty($_POST['gap_duration_edu'][$i] != '')) {
                    $gap_duration_edu = $_POST['gap_duration_edu'][$i];
                    $existing_record_edu[$i]['gap_duration_edu'] = trim($gap_duration_edu);
                }
                if(empty($_POST['gap_duration_edu'][$i])) {
                    $existing_record_edu[$i]['gap_duration_edu'] = "";
                }
                if(!empty($_POST['previous_exit_date_edu'][$i] != '')) {
                    $previous_exit_date_edu = $_POST['previous_exit_date_edu'][$i];
                    $previous_exit_date_edu = date('Y-m-d', strtotime($previous_exit_date_edu));
                    $existing_record_edu[$i]['previous_exit_date_edu'] = $previous_exit_date_edu;
                }
                if(empty($_POST['previous_exit_date_edu'][$i])) {
                    $existing_record_edu[$i]['previous_exit_date_edu'] = null;
                }
                if(!empty($_POST['previous_join_date_edu'][$i] != '')) {
                    $previous_join_date_edu = $_POST['previous_join_date_edu'][$i];
                    $previous_join_date_edu = date('Y-m-d', strtotime($previous_join_date_edu));
                    $existing_record_edu[$i]['previous_join_date'] = $previous_join_date_edu;
                }
                if(empty($_POST['previous_join_date_edu'][$i])) {
                    $existing_record_edu[$i]['previous_join_date'] = null;
                } /** Added on Dec 19th till here**/
                //  Jan 20th 2025
                if(!empty($existing_record_edu[$i]['gap_reason_edu']))
                {
                    $cleaned_reason_edu = str_replace(array("\\n", "\\r", "\\"), '', $existing_record_edu[$i]['gap_reason_edu']);
                    $cleaned_reason_edu = str_replace("'", "''", $cleaned_reason_edu); 
                    $existing_record_edu[$i]['gap_reason_edu'] = trim($cleaned_reason_edu);
                }
                //  Jan 20th 2025
            }

            $json_gap_edu = json_encode($existing_record_edu);
            $this->vm->update_qualification_companyname_forgap($_POST['request_id'], $json_gap_edu);
        }
        // ************************************** end ********
        //print_r($_POST['origin_verification']); exit;
        $this->amodel->loadcssScript(array('validationEngine.jquery', 'jquery.datepick', 'timePicker'));
        $this->amodel->loadjsscript(array('jquery.validate', 'jquery.dropdownPlain', 'commonjs', 'jquery.datepick', 'jquery.timePicker', 'jquery.timePicker.min', 'jquery-ui-1.8.16.custom.min'));
        $request_id = $this->uri->segment(3);
        $req_id = base64_decode($request_id);
        $level_id = base64_decode($this->uri->segment(4));
        $check_id = base64_decode($this->uri->segment(5));
        $pack_id = base64_decode($this->uri->segment(6));

        $one = $_POST['expences'];
        $two = $_POST['amount'];
        $three = $_POST['reference'];
        $four = $_POST['ddcurrency'];
        $five = $_POST['payment_date'];
        $six = $_POST['payment_to'];

        //16/01/2023

        $upload_doc = array('bill_proof');
        //print_r($_POST['count']); exit;
        $status1 = $this->insertBillDetails($_POST['count'], $upload_doc, $return_id, 'billing_doc', $req_id, 'request_id', $check_id, $level_id);

        for ($i = 0; $i < count($one); $i++) {
            if ((!empty($one[$i])) && (!empty($two[$i]))) {
                $vmexpenses[] = array('expences' => $one[$i], 'amount' => $two[$i], 'reference' => $three[$i], 'ddcurrency' => $four[$i], 'payment_date' => $five[$i], 'payment_to' => $six[$i]);
            }
        }
        /** commented on Mar 06 **/
        // 	for($i=0;$i<count($one);$i++)
        // 	{   if((!empty($one[$i])) && (!empty($two[$i]))){
        // $vmexpenses[] = array('expences'=>$one[$i],'amount'=>$two[$i],'reference'=>$three[$i],'ddcurrency'=>$four[$i],'payment_date'=>$five[$i],'payment_to'=>$six[$i]);
        // 		}
        // 	}
        /** commented on Mar 06 **/

        // ******** charges for international check *********
        $chkcharge = $_POST['chkcharge'];

        if ($chkcharge == 1) {
            $approval_date  = $_POST['approval_date'];
            $inter_currency = $_POST['inter_currency'];
            $inter_amount   = $_POST['inter_amount'];
            $inter_rate     = $_POST['inter_rate'];
            $case_no        = $_POST['case_no'];
            $org_id         = $_POST['org_id'];
            $level_id       = $_POST['level_id'];
            $created_on     = date("Y-m-d H:i:s");
            $check_id       = $_POST['check_id'];
            if ($inter_currency != 885)
                $amount_rupees = $inter_amount * $inter_rate;
            else {
                $amount_rupees = $inter_amount * 1;
                $inter_rate = '';
            }
        } elseif ($chkcharge == 0 && ($_POST['status'] == 111 || $_POST['status'] == 519 || $_POST['status'] == 110)) {
            $check_id         = $_POST['check_id'];
            $level_id       = $_POST['level_id'];
            $org_id         = $_POST['org_id'];
            $case_no        = $_POST['case_no'];
            $created_on     = date("Y-m-d H:i:s");
            $approval_date  = 00 - 00 - 0000;
            $inter_currency = 0;
            $inter_amount   = 0;
            $inter_rate     = 0;
            $amount_rupees  = 0;
        }

        $request_id = base64_decode($this->uri->segment(3));
        $level_id = base64_decode($this->uri->segment(4));
        $check_id = base64_decode($this->uri->segment(5));

        // ******** charges for international check *********

        if ($check_id == 651  || $check_id == 644 || $check_id == 1306 || $check_id == 647 || $check_id == 646 || $check_id == 645 || $check_id == 653 || $check_id == 654) {

            $charges['approval_date'] = date('Y-m-d', strtotime($approval_date));
            $charges['currency']       = $inter_currency;
            $charges['amount']         = $inter_amount;
            $charges['exchange_rate']  = $inter_rate;
            $charges['request_id']     = $request_id;
            $charges['check_id']       = $check_id;
            $charges['level_id']       = $level_id;
            $charges['amount_rupees']  = $amount_rupees;
            $charges['case_no']        = $case_no;
            $charges['org_id']         = $org_id;
            $charges['creation_date']  = $created_on;

            $charges_count = $this->vm->service_chrges_international($request_id, $check_id, $level_id);
            //print_r($charges); //exit;

            // $this->vm->update_status($request_id,$check_id,$level_id,$pack_id,$_POST);
            if ($charges_count['cnt'] == 0) {
                //echo "new = "; print_r($charges);  
                $this->db->insert(DB_PREFIX . 'service_charges_intchecks', $charges);
            } else {
                //echo "update= "; print_r($charges);
                $this->db->where('request_id', $request_id);
                $this->db->where('check_id', $check_id);
                $this->db->where('level_id', $level_id);
                $this->db->update(DB_PREFIX . 'service_charges_intchecks', $charges);
            }
        }





        /************************************************************************/
        //edited by Amritha on : 16/03/2023
        if (!empty($_FILES['details0']["name"][0])) {
            $temp = array();

            for ($i = 0; $i <= $_POST['counts']; $i++) {

                $tmp_name = $_FILES["details" . $i]["tmp_name"];
                $name = strtotime("now") . '_' . $_FILES["details" . $i]["name"];
                $px = $name;

                $px = preg_replace('/\s+/', '_', $px);
                $px = str_replace('&', 'and', $px);
                $target = './uploads/qcreferencedetails/';
                if (is_dir($target) == false) {
                    mkdir($target, 0755);
                    echo "Directory Created</br>";
                }


                $u = $target . $px;

                move_uploaded_file($tmp_name, $u);
                $temp[] = $px;
            }


            $qcupddoc = implode($temp, ",");
        }
        /****************************************************************/
        $qcrefer_doc = $this->db->query("select fielddata from " . DB_PREFIX . "verified_level where request_id=" . $req_id . " and check_id=" . $check_id . " and level_id=" . $level_id . " ")->row_array();
        $qcref_data = toArray(json_decode($qcrefer_doc['fielddata']));
        $qcupdrevtdoc = $qcref_data['details'];

        $valueacd = $qcupddoc;
        $valuecad = $qcupdrevtdoc;

        $_POST['details'] = $qcupddoc . ',' . $qcupdrevtdoc;

        $documents = $this->amodel->getDetails(DB_PREFIX . "vm_upload_files", array('*'), array('request_id' => $req_id, 'check_id' => $check_id, 'level_id' => $level_id, 'status' => 1));

        $doc = count($documents);
        $uploaded_docs = $_POST['authenticate_doc'];
        for ($i = 0; $i < $doc; $i++) {
            $request = $documents[$i]['request_id'];
            $check = $documents[$i]['check_id'];
            $level = $documents[$i]['level_id'];
            $docse = $documents[$i]['authenticate_doc'];
            if (in_array(trim($documents[$i]['authenticate_doc']), $uploaded_docs)) {
                $this->db->set('status', 1);
                $this->db->where('request_id', $request);
                $this->db->where('check_id', $check);
                $this->db->where('level_id', $level);
                $this->db->where('authenticate_doc', $docse);
                $this->db->update(DB_PREFIX . 'vm_upload_files');
            } else {
                $this->db->set('status', 0);
                $this->db->where('request_id', $request);
                $this->db->where('check_id', $check);
                $this->db->where('level_id', $level);
                $this->db->where('authenticate_doc', $docse);
                $this->db->update(DB_PREFIX . 'vm_upload_files');
            }
        }

        /* End Status change while deleting the document */
        $upload_files = array('document_name', 'authenticate_doc');

        $status = $this->insertclonerevertDetails($_POST['count1'], $upload_files, $return_id, 'vm_upload_files', $req_id, 'request_id', $check_id, $level_id);
        $this->vm->vmrevert_update_status($_POST['count1'], $req_id, $check_id, $level_id, $_POST, $pack_id, $vmexpenses);
        if ($_POST['status'] != '684' && $_POST['status'] != '107' &&  $_POST['status'] != '992') {
            $this->vm->vmrevert_updates($req_id, $check_id, $level_id, $_POST, $pack_id);
        } else {
            $save_request['verify_status'] = $_POST['status'];
            $save_request['comments'] = $_POST['sum_text'];
            $this->db->where('candidate_req_id', $req_id);
            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            $this->db->update('dcode_ver_assign_rep', $save_request);

            $save_req['reqstatus'] = $_POST['reqstatus'];
            $save_req['fielddata'] = json_encode($_POST);
            $save_req['outside_india'] = $_POST['origin_verification'];

            $this->db->where('request_id', $req_id);
            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            $this->db->update('dcode_verified_level', $save_req);
        }

        if ($_POST['status'] == 684) {

            $userid = $this->session->userdata['userid'];
            $role_id = $this->session->userdata['role_id'];

            $ticketDetail = $this->vm->get_ticket($req_id, $check_id, $level_id);
            $sl_no = count($ticketDetail);

            $ticketNo = $this->vm->get_ticketno();

            if (!empty($ticketNo[0]['ticketNo'])) {
                $ticket_no = $ticketNo[0]['ticketNo'] + 1;
            } else {
                $ticket_no = 1;
            }


            if ($ticketDetail[0]['request_id'] == $req_id && $ticketDetail[0]['check_id'] == $check_id && $ticketDetail[0]['level_id'] == $level_id) {
                $req_save['ticket_no'] = $ticketDetail[0]['ticket_no'];
                $req_save['ticket_serial_no'] = $sl_no + 1;
                $req_save['ticket_status'] = 5;

                $this->db->set('current_status', 0);
                $this->db->where('request_id', $req_id);
                $this->db->where('check_id', $check_id);
                $this->db->where('level_id', $level_id);
                $this->db->update(DB_PREFIX . 'ticket_details');
            } else {
                $req_save['ticket_no'] = $ticket_no;
                $req_save['ticket_serial_no'] = 1;
                $req_save['ticket_status'] = 1;
            }

            $req_save['request_id'] = $req_id;
            $req_save['case_no'] = $_POST['case_no'];
            $req_save['level_id'] = $level_id;
            $req_save['check_id'] = $check_id;
            $req_save['action_date'] = date('y-m-d H:i:s');
            $req_save['role_id'] = $role_id;
            $req_save['user_id'] = $userid;
            $req_save['request_reason_id'] = $_POST['reqstatus'];
            $req_save['ticket_details'] = $_POST['ticket_details'];
            $req_save['current_status'] = 1;

            $req_save = $this->security->xss_clean($req_save);
            $this->db->insert(DB_PREFIX . 'ticket_details', $req_save);
        }

        $one = $_POST['expences'];
        $two = $_POST['amount'];
        $three = $_POST['reference'];
        $four = $_POST['ddcurrency'];


        $this->db->select('order_id,candidate_name,office,sub_office,case_no');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $req_id))->result_array();
        $userid = $this->session->userdata('userid');
        $valuecomma = implode(',', $one);
        $valuecomma2 = implode(',', $two);
        $valuecomma3 = implode(',', $three);
        $valuecomma4 = implode(',', $four);
        $insbill_data['request_id'] = $req_id;
        $insbill_data['vm_expences'] = $valuecomma;
        $insbill_data['order_id'] = $orderid[0]['order_id'];
        $insbill_data['user_id'] = $userid;
        $insbill_data['candidate_name'] = $orderid[0]['candidate_name'];
        $insbill_data['office'] = $orderid[0]['office'];
        $insbill_data['sub_office'] = $orderid[0]['sub_office'];
        $insbill_data['case_no'] = $orderid[0]['case_no'];
        $insbill_data['vm_amount'] = $valuecomma2;
        $insbill_data['vm_reference'] = $valuecomma3;
        $insbill_data['vm_currency'] = $valuecomma4;
        $insbill_data['check_id'] = $check_id;
        $insbill_data['billing_type'] = 517;
        $insbill_data['created_on'] = date('y-m-d');
        $insbill_data = $this->security->xss_clean($insbill_data);
        $this->db->select('*');
        $billingfinal = $this->db->get_where(DB_PREFIX . 'billing', array('request_id' => $request_id, 'check_id' => $check_id))->row_array();
        if (empty($billingfinal)) {
            $this->db->insert(DB_PREFIX . 'billing', $insbill_data);
        } else {
            $this->db->where('request_id', $req_id);
            $this->db->update(DB_PREFIX . 'billing', $insbill_data);
        }

        /************* Status Updtes ***************/

        $stat_save['request_id'] = $req_id;
        $stat_save['case_no'] = $_POST['case_no'];
        $stat_save['check_id'] = $check_id;
        $stat_save['level_id'] = $level_id;
        if ($_POST['reopen'] == 1004) {
            // edited on 16th Jan '23 for activity sheet changes, to show reopened closed properly
            if ($_POST['status'] == 111) // verified
            {
                $stat_save['check_status'] = 1004;
                $stat_save['origin'] = 1;
            } else if ($_POST['status'] == 110) // stop check
            {
                $stat_save['check_status'] = 1110;
                $stat_save['origin'] = 1;
            } else if ($_POST['status'] == 519) //others
            {
                $stat_save['check_status'] = 1519;
                $stat_save['origin'] = 1;
            } else if ($_POST['status'] == 107) //initiated
            {
                $stat_save['check_status'] = 107;
                $stat_save['origin'] = 1;
            } else {
                $stat_save['check_status'] = $_POST['status'];
                $stat_save['origin'] = 1;
            }
        } else {
            $stat_save['check_status'] = 1002; // plain revert  from QC2
        }
        $stat_save['verified_status'] = '';
        $stat_save['date_of_update'] = date('y-m-d H:i:s');
        $stat_save['role_id'] = $this->session->userdata('role_id');
        $stat_save['user_id'] = $this->session->userdata['userid'];
        $stat_save = $this->security->xss_clean($stat_save);
        $this->db->insert(DB_PREFIX . 'status_updates', $stat_save);

        /******************************************/

        redirect('' . base_url('Verification/allotted_list'));
    }
    function insertclonerevertDetails($clonecount = 0, $insertValue = '', $marketId = '', $tablename = '', $editId = '', $fId = '', $cId = '', $lId = '')
    {
        if ($editId != 0) {
            $marketId = $editId;
            $rcId = $cId;
            $rlId = $lId;
        }
        $insertsales = array();
        $bulksave = array();
        if (!empty($_FILES['authenticate_doc']['name'])) {
            if ($clonecount != 0) {
                for ($i = 1; $i <= $clonecount; $i++) {
                    $j = $i;
                    if ($i == 1) {
                        $j = '';
                    }

                    foreach ($insertValue as $value) {
                        switch ($value) {
                            case 'authenticate_doc':
                            case '':
                                //upload files
                                $this->load->library('Upload');
                                $config['allowed_types'] = 'jpg|png|jpeg';
                                $config['upload_path'] = 'uploads/candidate/document/';
                                $config['encrypt_name'] = true;
                                $config['remove_spaces'] = true;
                                $this->load->library('upload', $config);
                                if (!empty($_FILES['authenticate_doc' . $j . $j]['name'])) {
                                    $this->upload->initialize($config);
                                    if ($this->upload->do_upload('authenticate_doc' . $j . $j)) {

                                        $upload_data = $this->upload->data();
                                        $image['original'] = $config['upload_path'] . '' . $upload_data['file_name'];
                                        $config['source_image'] = getcwd() . '/uploads/candidate/document/' . $upload_data['file_name'];
                                        $insertsales['authenticate_doc'] = $image['original'];
                                    }
                                }
                                if ($this->upload->display_errors() != '') {

                                    return $this->upload->display_errors();
                                }

                                $insertsales[$value] = $image['original'];
                                break;

                            default:
                                $insertsales[$value] = $_POST[$value . $j];
                                break;
                        }
                    }
                    $insertsales[$fId] = $marketId;
                    $insertsales['check_id'] = $cId;
                    $insertsales['level_id'] = $lId;
                    $insertsales['status'] = 1;
                    $bulksave[] = $insertsales;
                }
                $this->db->insert_batch($this->config->item('table_prefix') . $tablename, $bulksave);
            }
        }
        return 1;
    }
    function level_detailsview()
    {

        $this->amodel->loadcssScript(array('jquery-ui-1.10.4'));
        $this->amodel->loadjsscript(array('jquery.validate', 'jquery.dropdownPlain', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'jquery.datepick', 'multipleclone', 'jquery.validate'));
        $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
        // print_r($request_id); exit;
        $data['level_id'] =  $level_id = base64_decode($this->uri->segment(4));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $data['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));

        $this->db->select('ticket_status');
        $data['ticket'] = $this->db->get_where(DB_PREFIX . 'ticket_details', array('request_id' => $request_id, 'check_id' => $check_id, 'level_id' => $level_id, 'current_status' => 1))->result_array();

        $this->db->select('dataentry_by');
        $dataentrywise = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $values = $dataentrywise[0]['dataentry_by'];
        $assignee_list = $this->vm->get_assignee_list_super($values);
        $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list, array('assignee_id', 'name'));
        $this->load->helper('cloneform');

        $skillsadd_clones = array(array('document_name' => array('text', 'document_name', '', '', '', 'RF', ''), 'authenticate_doc' => array('upload', 'authenticate_doc', '', '', '', '', ''), 'preview' => array('label', 'preview')));
        $data['skills_file_clone'] = create_cloneform($skillsadd_clones, '', $user_id);
        $data['upload_file'] = formclonecreation($skillsadd_clones, $data['skills_file_clone'], 1, 'Add Document', "Authenticate Document");
        $this->db->select('order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';

        $this->db->select('name');
        $data['checkname'] = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->row_array();
        $data['slug'] = $slug = url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);
        $this->db->select('*');
        $partial_coduments = $this->db->get_where(DB_PREFIX . 'partial_upload_document', array('request_id' => $request_id, 'status' => '1'))->result_array();

        $this->db->where('req_id', $request_id);
        $this->db->where('status', 1);
        $this->db->select('upload_file as multipleupload,file_name as document_name');

        $offline_coduments =  $this->db->get(DB_PREFIX . 'candidate_upload_files')->result_array();
        $this->db->select('*');
        $deo_upload_doc = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['deo_upload_documents'] = $deo_upload_doc;
        $data['partial_coduments'] = array_merge($partial_coduments, $offline_coduments);
        $data['documents'] = $this->vm->documentsup($request_id);
        $data['devices'] = $this->vm->all_devices();
        //for displaying discrepancy limit for VM
        $this->db->select('acceptable_limit');
        $data['discrepancy_limit'] = $discrepancy_limit = $this->db->get_where(DB_PREFIX . 'add_check', array('order_id' => $orderid[0][order_id], 'types_of_check' => $check_id))->row_array();

        $data['slug'] = $slug = url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);
        if ($pack_id > 94)
            $level_details = $this->dm->$slug($request_id, $pack_id, $level_id);
        else
            $level_details = $this->dm->$slug($request_id, $check_id, $level_id);
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');

        //10/01/2024 -- table not using
        // if($check_id==651)
        // {

        //    $data['check_id']=$check_id;
        //    $data['icc_data']=$icc_data=$this->db->query("select current_address,cperiod_of_stay,cperiod_from,cperiod_to from ". DB_PREFIX ."icc_doc where request_id=".$request_id." && check_id=".$check_id."")->result_array();
        //    $data['icc_data']=$icc_data=$this->db->query("select current_address,cperiod_of_stay,cperiod_from,cperiod_to from ". DB_PREFIX ."icc_doc where request_id=".$request_id." ")->result_array();

        //    foreach($icc_data as $keyy => $iccvalue){

        //    	$iccidx = $keyy+1;
        //    	$iccadr = 'current_address'.$iccidx;
        //    	$iccstay = 'cperiod_of_stay'.$iccidx;
        //    	$iccfrom = 'cperiod_from'.$iccidx;
        //    	$iccto = 'cperiod_to'.$iccidx; 
        //    	$level_details[0][$iccadr] = $iccvalue['current_address'];
        //    	$level_details[0][$iccstay] = $iccvalue['cperiod_of_stay'];
        //    	$level_details[0][$iccfrom] = $iccvalue['cperiod_from'];
        //    	$level_details[0][$iccto] = $iccvalue['cperiod_to'];

        //     }
        // }
        $this->db->select('id');
        $checkname = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('parent' => $check_id, 'name' => $level_details[0]['level_name']))->row_array();

        if ($check_id == 76 || $check_id == 77) {
            $check_id = $checkname['id'];
            $data['scheck_id'] = $check_id;
        } else

            $data['scheck_id'] = $check_id;
        $data['status'] = $this->dem->get_check_status($check_id, 0);
        $data['reqstatus'] = $this->dem->get_check_status($check_id, 684);
        $data['international_db'] = $this->db->query("select * from " . DB_PREFIX . "international_chk where checkid=" . $check_id . " order by sort_order asc,id asc")->result_array();

        $data['level_data'] = $level_details;
        $data['remdetails'] = $this->dem->education_rem($request_id, $level_id);
        $data['dataentryoperator'] = $dataentryoperator = $this->db->query("select u.role_id as assignee_id,concat_ws(' ',first_name,middle_name,last_name)as name from " . DB_PREFIX . "user a
               left join " . DB_PREFIX . "submit_cv c ON c.operator_submited_by=a.id
               left join " . DB_PREFIX . "users_roles u on u.user_id = a.id
                where request_id=" . $request_id)->result_array();
        $data['contsofcheck'] = $this->vm->countsofchk($request_id, $check_id, $level_id);
        $data['total_chk'] = $this->vm->getallchecks($request_id);

        if ($pack_id > 94)
            $colour_details = $this->vrm->$slug($pack_id);

        else
            $colour_details = $this->vrm->$slug($check_id);
        $data['colourtxt'] = $colour_details;
        $data['deo_additional_document'] = $this->vm->deo_add_doc($request_id);
        $data['verified_data'] = $this->vm->get_verified_data($request_id, $level_id, $check_id);
        $valueed_data = $data['verified_data'];
        $data['expencedata'] = toArray(json_decode($valueed_data['vmexpenses']));
        $data['authorization_letter'] = $this->db->query("select company_decl_doc from " . DB_PREFIX . "declaration_details where user_id=" . $request_id)->row_array();
        $data['inter_charges'] = $inter_charges = $this->vm->get_service_chrges_intrnational($request_id, $check_id, $level_id);
        if ($inter_charges['amount']  == 0)
            $data['chkcharge'] = 0;
        else
            $data['chkcharge'] = 1;



        $this->amodel->pagerender($data, 'level_detailsview');
    }
    function vm_revertview()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4'));
        $this->amodel->loadjsscript(array('jquery.validate', 'jquery.dropdownPlain', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'jquery.datepick', 'multipleclone', 'jquery.validate'));
        $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['level_id'] =  $level_id = base64_decode($this->uri->segment(4));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $data['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));
        $this->db->select('dataentry_by');
        $dataentrywise = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $values = $dataentrywise[0]['dataentry_by'];
        $assignee_list = $this->vm->get_assignee_list_super($values);
        $data['assignee_list'] = $this->amodel->filterDropdown($assignee_list, array('assignee_id', 'name'));
        $this->load->helper('cloneform');

        $skillsadd_clones = array(array('authenticate_doc[]' => array('upload', 'authenticate_doc', 'R', 'R', '', '', '')));
        $data['skills_file_clone'] = create_cloneform($skillsadd_clones, '', $user_id);
        $data['upload_file'] = formclonecreation($skillsadd_clones, $data['skills_file_clone'], 1, 'Add Document', "Authenticate Document");
        //for displaying name on title
        $this->db->select('order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';
        $data['status_value'] = $this->amodel->getDetails(DB_PREFIX . 'verification_request', 'vm_revert_vs', array('request_id' => $request_id));
        $data['status_revert'] = $this->amodel->getDetails(DB_PREFIX . 'client_request', 'revert_status,service,reason', array('request_id' => $request_id));
        $this->db->select('name');
        $data['checkname'] = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->row_array();
        $data['slug'] = $slug = url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);
        $this->db->select('*');
        $partial_coduments = $this->db->get_where(DB_PREFIX . 'partial_upload_document', array('request_id' => $request_id, 'status' => '1'))->result_array();

        $this->db->where('req_id', $request_id);
        $this->db->select('upload_file as multipleupload,file_name as document_name');

        $offline_coduments =  $this->db->get(DB_PREFIX . 'candidate_upload_files')->result_array();

        $data['partial_coduments'] = array_merge($partial_coduments, $offline_coduments);
        $data['documents'] = $this->vm->documentsup($request_id);
        $data['devices'] = $this->vm->all_devices();
        //for displaying discrepancy limit for VM
        $this->db->select('acceptable_limit');
        $data['discrepancy_limit'] = $discrepancy_limit = $this->db->get_where(DB_PREFIX . 'add_check', array('order_id' => $orderid[0][order_id], 'types_of_check' => $check_id))->row_array();
        if ($pack_id > 94)
            $level_details = $this->dm->$slug($request_id, $pack_id, $level_id);
        else
            $level_details = $this->dm->$slug($request_id, $check_id, $level_id);

        $this->db->select('id');
        $checkname = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('parent' => $check_id, 'name' => $level_details[0]['level_name']))->row_array();

        if ($check_id == 76 || $check_id == 77) {
            $check_id = $checkname['id'];
            $data['scheck_id'] = $check_id;
        } else
            $data['scheck_id'] = $check_id;
        $data['status'] = $this->dem->get_check_status($check_id, 0);

        $data['level_data'] = $level_details;
        $data['remdetails'] = $this->dem->education_rem($request_id, $level_id);
        $this->db->select('acceptable_limit');
        $data['discrepancy_limit'] = $discrepancy_limit = $this->db->get_where(DB_PREFIX . 'add_check', array('order_id' => $orderid[0][order_id], 'types_of_check' => $check_id))->row_array();
        $this->amodel->pagerender($data, 'education_data');
    }
    function qc2_reports_verified()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC2 Verified Reports', 'Verification/qc2_reports_verified');

        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'reports');
    }
    function get_qc2reportslist_v()
    {
        $model = array('Verification_model' => 'get_qc2list_verified');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $vname = ($_REQUEST['vname']) ? $_REQUEST['vname'] : '';
        $a_date = ($_REQUEST['a_date']) ? $_REQUEST['a_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $filter_date = ($_REQUEST['filter_date']) ? $_REQUEST['filter_date'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        if ($org_id)
            $condition[] = " o.id = " . $org_id;
        if ($office)
            $condition[] = " c.id = " . $office;
        if ($parent_office)
            $condition[] = " d.id = " . $parent_office;
        if ($sub_office)
            $condition[] = " cr.sub_office = " . $sub_office;

        if ($name)
            $condition[] = " cr.candidate_name like '%" . $name . "%'";
        //18/01/2024
        $case_no = trim($case_no);
        if ($case_no)
            $condition[] = " cr.case_no like '%" . $case_no . "'";
        if ($vname)
            $condition[] = "(concat_ws(' ',us.first_name,us.last_name) like '%" . $vname . "%') ";
        if ($a_status == 1) {
            $condition[] = " vl1.qc2_dis in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701) ";
        }
        if ($a_status == 2) {
            $condition[] = " ((vl1.qc2_dis in (120,131,137,143,713,119,130,136,142)) or (vl1.qc2status in (519,110)) or (vl1.vm_discrepency in (1005)))";
        }
        if ($a_status == 3) {
            $condition[] = " vl1.qc2_dis in (116,127,134,140,630,121,125,658,662,660,789) ";
        }
        if ($a_date && $filter_date == 1)
            $condition[] = "DATE_FORMAT(vl1.v_date,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($a_date)) . "'";
        if ($t_date && $filter_date == 1)
            $condition[] = "DATE_FORMAT(vl1.v_date,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        if ($a_date && $filter_date == 2)
            $condition[] = "DATE_FORMAT(vl1.qc2_date,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($a_date)) . "'";
        if ($t_date && $filter_date == 2)
            $condition[] = "DATE_FORMAT(vl1.qc2_date,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        if ($a_date && $filter_date == 3)
            $condition[] = "DATE_FORMAT(cr.final_report_published_date,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($a_date)) . "'";
        if ($t_date && $filter_date == 3)
            $condition[] = "DATE_FORMAT(cr.final_report_published_date,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        if ($a_date && $filter_date == 4)
            $condition[] = "DATE_FORMAT(vl1.supplement_published_date,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($a_date)) . "' and cr.final_report != 0 ";
        if ($t_date && $filter_date == 4)
            $condition[] = "DATE_FORMAT(vl1.supplement_published_date,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "' and cr.final_report != 0";
        if ($check_name) {
            $condition[] = " md1.name like '%" . $check_name . "%'";
        }
        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {
                $verified_data = $this->vm->get_verified_data($row['request_id'], $row['level_id'], $row['check_id']);
                $verification_data = toArray(json_decode($verified_data['qc2fielddata']));
                $status4 = '';
                $status1 = $this->vm->get_status($verification_data['status']);
                $status2 = $this->vm->get_status($verification_data['pstatus']);
                $status3 = $this->vm->get_status($verification_data['status1']);
                if ($verification_data['ostatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['ostatus']);
                if ($verification_data['dstatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['dstatus']);
                if (!empty($status4))
                    $status41 = '-' . $status4['name'];
                else
                    $status41 = '';

                $interim = $this->vm->get_interim($row['request_id'], $row['check_id'], $row['level_id'], $row['pack_id']);
                $slug = url_title(convert_accented_characters($row['checkname']), 'underscore', TRUE);
                if ($row['check_id'] == 14)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'education_details');
                else if ($row['check_id'] == 16)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'contact_details', 'request_id', 'permanent_address');
                else if ($row['check_id'] == 59)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], 'employment', 'req_id', 'level_id');
                else if ($row['check_id'] == 76 || $row['check_id'] == 77 || $row['check_id'] == 75)
                    $levelnames = $this->vm->get_level_name($row['request_id'], $row['check_id'], $row['level_id'], $slug, 'request_id', 'level_name');
                else
                    $levelnames['level'] = $row['checkname'];

                if ($row['chk'] == 0) {
                    $chkval = $row['checkname'];
                } else {
                    $chkval = $row['checkname'] . ' ' . $row['chk'];
                }
                if ((isset($row['supplement_published_date']) && $row['supplement_published_date'] != "0000-00-00 00:00:00")) {
                    $cname = anchor('/Reports/candidate_reports_view/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']) . '/' . base64_encode($row['supplement_published_date']), $row['candidate_name'], 'target=_blank');
                } else {
                    $cname = anchor('/Reports/candidate_reports_view/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']) . '/' . base64_encode($row['qc2_date']), $row['candidate_name'], 'target=_blank');
                }

                if (!empty($status1['name'])) {
                    $stat = $status1['name'] . '-' . $status2['name'] . '-' . $status3['name'] . '' . $status41;
                } else {
                    $stat = '';
                }
                $status = $row['status'];
                $vm_date = isset($row['v_date']) ? date('d-m-Y', strtotime($row['v_date'])) : '';
                $qc2_date = isset($row['qc2_date']) ? date('d-m-Y', strtotime($row['qc2_date'])) : '';
                $rpt_publish_date = isset($row['final_report_published_date']) ? date('d-m-Y', strtotime($row['final_report_published_date'])) : '';
                $supplement_published_date = (isset($row['supplement_published_date']) && $row['supplement_published_date'] != "0000-00-00 00:00:00" && $row['final_report'] != 0 && $row['qc2_report_publish'] != 0) ? date('d-m-Y', strtotime($row['supplement_published_date'])) : '';
                $qc_assigndetails = $this->vm->qc_assaindata($row['request_id']);
                $response->rows[]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], $cname, $row['case_no'], $chkval, $stat, $row['qc2name'], $vm_date, $qc2_date, $rpt_publish_date, $supplement_published_date, anchor('/Reports/candidate_reports_view/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['pack_id']) . '/' . base64_encode($row['qc2_date']), 'View'));
            }
        }

        echo json_encode($response);
    }

    function qc2_reportsdata_details()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        $request_id = base64_decode($this->uri->segment(3));
        $level_id = base64_decode($this->uri->segment(4));
        $check_id = base64_decode($this->uri->segment(5));
        $this->db->select('candidate_name');
        $ver = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['verification'] = $ver[0]['candidate_name'];
        $verification_data = $this->vm->getqcverificationaldata($request_id);
        $data['checkdata'] = $verification_data;
        $this->amodel->pagerender($data, 'verification_reports');
    }
    function load_status()
    {


        if (empty($_POST))
            echo false;
        $option = '<option value="">Select</option>';
        $newstatus = $this->dem->get_check_status($_POST['rid'], $_POST['id']);
        foreach ($newstatus as $keys => $cstatuss)
            $option .= '<option value="' . $cstatuss['id'] . '" title="' . $cstatuss['name'] . '">' . ucfirst($cstatuss['name']) . '</option>';

        echo $option;
    }
    function revert_to_vm()
    {
        $request_id = base64_decode($this->uri->segment(3));
        $level_id = base64_decode($this->uri->segment(4));
        $check_id = base64_decode($this->uri->segment(5));

        $this->db->select('case_no');
        $this->db->where('request_id', $request_id);
        $CaseNo = $this->db->get(DB_PREFIX . 'client_request')->row_array();

        if (!empty($_POST)) {
            $this->db->select('verified_by,supplementary');
            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            $this->db->where('request_id', $request_id);
            $verificationdata = $this->db->get(DB_PREFIX . 'verified_level')->row_array();


            $this->db->select('qc_revert_request,vm_assigned_qc,qc2_revert_request,qc1_assign_revert,qc1_verification,qc2_verification,qc_revert_status');
            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            $this->db->where('candidate_req_id', $request_id);
            $data1 = $this->db->get(DB_PREFIX . 'ver_assign_rep')->row_array();

            if ($data1['qc_revert_request'] == 1 && $data1['vm_assigned_qc'] == 1 && $data1['qc1_verification'] == 1 && $data1['qc2_revert_request'] == 1 && $data1['qc2_verification'] == 0 && $data1['qc1_assign_revert'] == 0 && $verificationdata['supplementary'] == 1 && $data1['qc_revert_status'] != 0) {
                $update['reopen_revert_qc'] = 1;
            } else {
                $update['reopen_revert_qc'] = 0;
            }
            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            $this->db->where('candidate_req_id', $request_id);
            $this->db->update(DB_PREFIX . 'ver_assign_rep', $update);

            $update['qc_revert_request'] = 1;
            $update['vm_assigned_qc'] = 0;
            $update['qc_revert_status'] = $_POST['rstatus'];
            $update['qc_revert_reason'] = $_POST['qc_revert_reason'];
            $update['qc_revert_to'] = $verificationdata['verified_by'];
            $update['qc_revert_by'] = $this->session->userdata('userid');
            $update['qc_revert_date'] = date('y-m-d H:i:s');
            $update['qc_rcomments'] = $_POST['rcomments'];
            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            $this->db->where('candidate_req_id', $request_id);
            $this->db->update(DB_PREFIX . 'ver_assign_rep', $update);

            $inslog_data['action'] = 'Revert to VM';
            $inslog_data['updated_by'] = $this->session->userdata('userid');
            $inslog_data['updated_on'] = date('Y-m-d H:i:s');
            $this->db->where('request_id', $request_id);
            $this->db->update(DB_PREFIX . 'loghistory', $inslog_data);
            $revert_history['request_id'] = $request_id;
            $revert_history['check_id'] = $check_id;
            $revert_history['level_id'] = $level_id;
            $revert_history['reverted_by'] = $this->session->userdata('userid');
            $revert_history['comments'] = $_POST['qcrevert_comment'];
            $revert_history['revertreason'] = $_POST['rreason'];
            $revert_history['reverted_to'] = $verificationdata['verified_by'];
            $revert_history['reverted_date'] = date('y-m-d H:i:s');
            $this->db->insert(DB_PREFIX . 'revert_history', $revert_history);

            /************* Status Updtes ***************/

            $stat_save['request_id'] = $request_id;
            $stat_save['case_no'] = $CaseNo['case_no'];
            $stat_save['check_id'] = $check_id;
            $stat_save['level_id'] = $level_id;
            $stat_save['check_status'] = 1003;
            $stat_save['verified_status'] = '';
            $stat_save['date_of_update'] = date('y-m-d H:i:s');
            $stat_save['role_id'] = $this->session->userdata('role_id');
            $stat_save['user_id'] = $this->session->userdata['userid'];
            $stat_save = $this->security->xss_clean($stat_save);
            $this->db->insert(DB_PREFIX . 'status_updates', $stat_save);

            /******************************************/
            redirect('Verification/qc1_allotedlist');
        }
    }

    //  Changes made on 16th Jan '23 for showing reopen checks properly
    function revert_to_qc($request_id, $level_id, $check_id, $post)
    {
        $form_data = $post;

        if (!empty($_POST)) {
            $this->db->select('qcverified_by,verified_by,supplementary');
            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            $this->db->where('request_id', $request_id);
            $verificationdata = $this->db->get(DB_PREFIX . 'verified_level')->row_array();

            //  Changes made on 16th Jan '23 for showing reopen checks properly
            // $this->db->select('qc1_assign_revert,qc_2_verification,vm_assigned_qc');
            $this->db->select('qc2_verification,qc2_revert_request,vm_assigned_qc');
            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            $this->db->where('candidate_req_id', $request_id);
            $data1 = $this->db->get(DB_PREFIX . 'ver_assign_rep')->row_array();

            // if($data1['qc1_assign_revert']==1 && $data1['qc_2_verification']==0 && $data1['vm_assigned_qc']==1 && $verificationdata['supplementary']==1){
            // 	$update['reopen_revert_qc2']=1;
            // }
            // else{
            // 	$update['reopen_revert_qc2']=0;
            // }

            //  Changes made on 16th Jan '23 for showing reopen checks properly
            if ($data1['qc2_verification'] == 1 && $data1['qc2_revert_request'] == 0 && $data1['vm_assigned_qc'] == 1 && $verificationdata['supplementary'] == 1) {
                $update['reopen_revert_qc2'] = 1;
            } else {
                $update['reopen_revert_qc2'] = 0;
            }

            if (!empty($form_data['rostatus']) && empty($form_data['rdstatus']))
                $status = $form_data['rostatus'];
            else if (empty($form_data['rostatus']) && !empty($form_data['rdstatus']))
                $status = $form_data['rdstatus'];
            else if (empty($form_data['rostatus']) && empty($form_data['rdstatus']))
                $status = $form_data['rstatus'];

            $verify_qc = $this->vm->verify_qc($request_id);
            if ($verify_qc[0]['dedicated_qc'] == 17) {
                $update['qc2_revert_request'] = 1;
                $update['qc2_verification'] = 0;
                $update['qc_revert_request'] = 1;
                $update['vm_assigned_qc'] = 0;
                $update['qc1_assign_revert'] = 0;
                $update['qc_revert_status'] = $form_data['rstatus'];
                $update['qc_revert_to'] = $verificationdata['verified_by'];
                $update['qc2_revert_by'] = $this->session->userdata('userid');
                $update['qc2_revert_date'] = date('y-m-d H:i:s');
                $update['qc_rcomments'] = $form_data['rcomments'];
                $update['qc_revert_reason'] = $form_data['qc2_revert_reason'];
            } else {
                $update['qc2_verification'] = 0;
                $update['qc2_revert_request'] = 1;
                $update['vm_assigned_qc'] = 1;
                $update['qc_revert_request'] = 1;
                $update['qc1_assign_revert'] = 0;
                $update['qc2_revert_status'] = $status;
                $update['qc2_revert_to'] = $verificationdata['qcverified_by'];
                $update['qc2_revert_by'] = $this->session->userdata('userid');
                $update['qc2_revert_date'] = date('y-m-d H:i:s');
                $update['qc2_rcomments'] = $form_data['rcomments'];
                $update['qc2_revert_reason'] = $form_data['qc2_revert_reason'];
            }

            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            $this->db->where('candidate_req_id', $request_id);
            $this->db->update(DB_PREFIX . 'ver_assign_rep', $update);

            /*$verified_level['qc2fielddata']=json_encode($form_data);
				$this->db->where('check_id',$check_id);
		        $this->db->where('level_id',$level_id);
		        $this->db->where('request_id',$request_id);
				$this->db->update(DB_PREFIX.'verified_level',$verified_level);*/

            $inslog_data['action'] = 'Revert to QC1';
            $inslog_data['updated_by'] = $this->session->userdata('userid');
            $inslog_data['updated_on'] = date('Y-m-d H:i:s');
            $this->db->where('request_id', $request_id);
            $this->db->update(DB_PREFIX . 'loghistory', $inslog_data);
            $revert_history['request_id'] = $request_id;
            $revert_history['check_id'] = $check_id;
            $revert_history['level_id'] = $level_id;
            $revert_history['reverted_by'] = $this->session->userdata('userid');
            $revert_history['comments'] = $form_data['qc2revert_comment'];
            $revert_history['revertreason'] = $form_data['qc2_revert_reason'];
            if ($verify_qc[0]['dedicated_qc'] == 17) {
                $revert_history['reverted_to'] = $verificationdata['verified_by'];
            } else {
                $revert_history['reverted_to'] = $verificationdata['qcverified_by'];
            }
            $revert_history['reverted_date'] = date('y-m-d H:i:s');
            $this->db->insert(DB_PREFIX . 'revert_history', $revert_history);
            redirect('Verification/qc2_verification');
        }
    }
    function reopen_to_qc()
    {
        $request_id = base64_decode($this->uri->segment(3));
        $level_id = base64_decode($this->uri->segment(4));
        $check_id = base64_decode($this->uri->segment(5));
        if (!empty($_POST)) {
            $this->db->select('qcverified_by,verified_by');
            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            $this->db->where('request_id', $request_id);
            $verificationdata = $this->db->get(DB_PREFIX . 'verified_level')->row_array();
            if (!empty($_POST['rostatus']) && empty($_POST['rdstatus']))
                $status = $_POST['rostatus'];
            else if (empty($_POST['rostatus']) && !empty($_POST['rdstatus']))
                $status = $_POST['rdstatus'];
            else if (empty($_POST['rostatus']) && empty($_POST['rdstatus']))
                $status = $_POST['rstatus'];

            $verify_qc = $this->vm->verify_qc($request_id);
            if ($verify_qc[0]['dedicated_qc'] == 17) {
                $update['qc2_revert_request'] = 1;
                $update['qc_revert_request'] = 1;
                $update['vm_assigned_qc'] = 0;
                $update['qc_revert_status'] = $_POST['rstatus'];
                $update['qc_revert_to'] = $verificationdata['verified_by'];
                $update['qc2_revert_by'] = $this->session->userdata('userid');
                $update['qc2_revert_date'] = date('y-m-d H:i:s');
                $update['qc_rcomments'] = $_POST['rcomments'];
            } else {
                $update['qc2_revert_request'] = 1;
                $update['vm_assigned_qc'] = 1;
                $update['qc_revert_request'] = 1;
                $update['qc1_assign_revert'] = 0;
                $update['qc2_revert_status'] = $status;
                $update['qc2_revert_to'] = $verificationdata['qcverified_by'];
                $update['qc2_revert_by'] = $this->session->userdata('userid');
                $update['qc2_revert_date'] = date('y-m-d H:i:s');
                $update['qc2_rcomments'] = $_POST['rcomments'];
            }

            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            $this->db->where('candidate_req_id', $request_id);
            $this->db->update(DB_PREFIX . 'ver_assign_rep', $update);
            $inslog_data['action'] = 'Revert to QC1';
            $inslog_data['updated_by'] = $this->session->userdata('userid');
            $inslog_data['updated_on'] = date('Y-m-d H:i:s');
            $this->db->where('request_id', $request_id);
            $this->db->update(DB_PREFIX . 'loghistory', $inslog_data);
            $revert_history['request_id'] = $request_id;
            $revert_history['check_id'] = $check_id;
            $revert_history['level_id'] = $level_id;
            $revert_history['reverted_by'] = $this->session->userdata('userid');
            $revert_history['comments'] = $_POST['qc2revert_comment'];
            if ($verify_qc[0]['dedicated_qc'] == 17) {
                $revert_history['reverted_to'] = $verificationdata['verified_by'];
            } else {
                $revert_history['reverted_to'] = $verificationdata['qcverified_by'];
            }
            $revert_history['reverted_date'] = date('y-m-d H:i:s');
            $this->db->insert(DB_PREFIX . 'revert_history', $revert_history);
            redirect('' . base_url('Verification/qc2_casechecklist/' . $this->uri->segment(3)));
        }
    }
    function vm_verified()
    {

        $this->amodel->loadcssScript(array('jquery-ui-1.10.4'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['level_id'] =  $level_id = base64_decode($this->uri->segment(4));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $data['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));
        $this->db->select('order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid['candidate_name']) ? '( ' . $orderid['candidate_name'] . ' )' : '';

        $this->db->select('name');
        $data['checkname'] = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->row_array();

        $slug = url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);
        if ($pack_id > 94)
            $level_details = $this->dm->$slug($request_id, $pack_id, $level_id);
        else
            $level_details = $this->dm->$slug($request_id, $check_id, $level_id);

        $this->db->select('id');
        $checkname = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('parent' => $check_id, 'name' => $level_details[0]['level_name']))->row_array();
        $data['dataentrydata'] = $level_details[0];
        $data['verified_data'] = $verified_data = $this->vm->get_verified_data($request_id, $level_id, $check_id);
        $data['expencedata'] = toArray(json_decode($verified_data['vmexpenses']));

        if ($check_id == 76 || $check_id == 77) {
            $check_id = $checkname['id'];
            $data['scheck_id'] = $check_id;
        } else
            $data['scheck_id'] = $check_id;

        $data['key'] = $checkname['name'];
        $revertexpences = $this->db->query("select p.check_id,a.vm_amount,a.vm_expences,a.vm_reference,a.check_id as profile_id,a.case_no,a.created_on,c.org_name,b.office_name,b.address1,b.address2,b.address3,b.locality,b.pincode,d.office_name as parent_office,o.office_name as sub_office,a.id,a.candidate_name, p.no_checks from " . DB_PREFIX . "billing a 
               
                LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
                    LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    LEFT JOIN " . DB_PREFIX . "request_check p ON p.request_id=a.request_id
                
                where a.request_id =" . $request_id . " and a.billing_type=517 GROUP BY c.org_name")->result_array();
        $data['revertexpencess'] = $revertexpences;
        $this->db->select('*');
        $deo_upload_doc = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['deo_upload_documents'] = $deo_upload_doc;
        $this->db->select('*');
        $partial_coduments = $this->db->get_where(DB_PREFIX . 'partial_upload_document', array('request_id' => $request_id, 'status' => '1'))->result_array();

        $this->db->where('req_id', $request_id);
        $this->db->select('upload_file as multipleupload,file_name as document_name');
        $offline_coduments =  $this->db->get(DB_PREFIX . 'candidate_upload_files')->result_array();
        $this->db->where('candidate_req_id', $request_id);
        $this->db->where('check_id', $check_id);
        $this->db->where('level_id', $level_id);
        $this->db->select('vm_comments,vm_revert_status');
        $stopcheck_comments =  $this->db->get(DB_PREFIX . 'ver_assign_rep')->row_array();
        $data['partial_coduments'] = array_merge($partial_coduments, $offline_coduments);
        $data['international_db'] = $this->db->query("select * from " . DB_PREFIX . "international_chk where checkid=" . $check_id . " order by sort_order asc,id asc")->result_array();
        $data['contsofcheck'] = $this->vm->countsofchk($request_id, $check_id, $level_id);
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Verification Reports List', 'Verification/verification_report');
        $this->breadcrumbs->push('Verification Member of Verified Details ', 'Verification/vm_verified');

        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'education_data');
    }
    function qc_verified()
    {

        $this->amodel->loadcssScript(array('jquery-ui-1.10.4'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        $condition['candidate_req_id'] = $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
        $condition['level_id'] = $data['level_id'] =  $level_id = base64_decode($this->uri->segment(4));
        $condition['check_id'] = $data['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $condition['pack_id'] = $data['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));

        $checkreport = $this->vm->check_report($condition);
        if ($checkreport['qc1_verification'] == 0)
            redirect('Index/dashboard');

        //for displaying name on title
        $this->db->select('order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid['candidate_name']) ? '( ' . $orderid['candidate_name'] . ' )' : '';

        $this->db->select('name');
        $data['checkname'] = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->row_array();
        $slug = url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);
        if ($pack_id > 94)
            $level_details = $this->dm->$slug($request_id, $pack_id, $level_id);
        else
            $level_details = $this->dm->$slug($request_id, $check_id, $level_id);

        $this->db->select('id');
        $checkname = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('parent' => $check_id, 'name' => $level_details[0]['level_name']))->row_array();
        $data['dataentrydata'] = $level_details[0];
        $data['verified_data'] = $verified_data = $this->vm->get_verified_data($request_id, $level_id, $check_id);
        $data['expencedata'] = toArray(json_decode($verified_data['vmexpenses']));
        if ($check_id == 76 || $check_id == 77) {
            $check_id = $checkname['id'];
            $data['scheck_id'] = $check_id;
        } else
            $data['scheck_id'] = $check_id;

        $data['key'] = $checkname['name'];

        $revertexpences = $this->db->query("select p.check_id,a.vm_amount,a.vm_expences,a.vm_reference,a.check_id as profile_id,a.case_no,a.created_on,c.org_name,b.office_name,b.address1,b.address2,b.address3,b.locality,b.pincode,d.office_name as parent_office,o.office_name as sub_office,a.id,a.candidate_name, p.no_checks from " . DB_PREFIX . "billing a 
               
                LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
                    LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    LEFT JOIN " . DB_PREFIX . "request_check p ON p.request_id=a.request_id
                
                where a.request_id =" . $request_id . " and a.billing_type=517 GROUP BY c.org_name")->result_array();
        $data['revertexpencess'] = $revertexpences;
        $this->db->select('*');
        $deo_upload_doc = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['deo_upload_documents'] = $deo_upload_doc;
        $this->db->select('*');
        $partial_coduments = $this->db->get_where(DB_PREFIX . 'partial_upload_document', array('request_id' => $request_id, 'status' => '1'))->result_array();

        $this->db->where('req_id', $request_id);
        $this->db->select('upload_file as multipleupload,file_name as document_name');
        $offline_coduments =  $this->db->get(DB_PREFIX . 'candidate_upload_files')->result_array();
        $this->db->where('candidate_req_id', $request_id);
        $this->db->where('check_id', $check_id);
        $this->db->where('level_id', $level_id);
        $this->db->select('vm_comments,vm_revert_status');
        $stopcheck_comments =  $this->db->get(DB_PREFIX . 'ver_assign_rep')->row_array();
        $data['partial_coduments'] = array_merge($partial_coduments, $offline_coduments);
        $data['contsofcheck'] = $this->vm->countsofchk($request_id, $check_id, $level_id);
        $data['check_resources'] = $this->config->item('Checkdata_fields');
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC1 Assigned List', 'Verification/qc1_allotedlist');
        $this->breadcrumbs->push('Qc1 - Verification Report ', 'Verification/qc_verified');

        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'qc_verified');
    }
    function qc2_verified()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        $condition['candidate_req_id'] = $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
        $condition['level_id'] = $data['level_id'] =  $level_id = base64_decode($this->uri->segment(4));
        $condition['check_id'] = $data['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $condition['pack_id'] = $data['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));


        $checkreport = $this->vm->check_report($condition);
        if ($checkreport['qc2_verification'] == 0)
            redirect('Index/dashboard');
        //for displaying name on title
        $this->db->select('order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid['candidate_name']) ? '( ' . $orderid['candidate_name'] . ' )' : '';
        $this->db->select('name');
        $data['checkname'] = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->row_array();

        $slug = url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);
        if ($pack_id > 94)
            $level_details = $this->dm->$slug($request_id, $pack_id, $level_id);
        else
            $level_details = $this->dm->$slug($request_id, $check_id, $level_id);





        $this->db->select('id,name');
        $checkname = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('parent' => $check_id, 'name' => $level_details[0]['level_name']))->row_array();

        $data['verified_data'] = $this->vm->get_qc2verified_data($request_id, $level_id, $check_id);
        $verified_data = $this->vm->get_verified_data($request_id, $level_id, $check_id);
        $data['expencedata'] = toArray(json_decode($verified_data['vmexpenses']));
        $data['dataentrydata'] = $level_details[0];
        if ($check_id == 76 || $check_id == 77) {
            $check_id = $checkname['id'];
            $data['scheck_id'] = $check_id;
        } else
            $data['scheck_id'] = $check_id;

        $data['key'] = $checkname['name'];

        $revertexpences = $this->db->query("select p.check_id,a.vm_amount,a.vm_expences,a.vm_reference,a.check_id as profile_id,a.case_no,a.created_on,c.org_name,b.office_name,b.address1,b.address2,b.address3,b.locality,b.pincode,d.office_name as parent_office,o.office_name as sub_office,a.id,a.candidate_name, p.no_checks from " . DB_PREFIX . "billing a 
               
                LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
                    LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    LEFT JOIN " . DB_PREFIX . "request_check p ON p.request_id=a.request_id
                
                where a.request_id =" . $request_id . " and a.billing_type=517 GROUP BY c.org_name")->result_array();
        $data['revertexpencess'] = $revertexpences;
        $this->db->select('*');
        $deo_upload_doc = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['deo_upload_documents'] = $deo_upload_doc;
        $this->db->select('*');
        $partial_coduments = $this->db->get_where(DB_PREFIX . 'partial_upload_document', array('request_id' => $request_id, 'status' => '1'))->result_array();


        $this->db->where('req_id', $request_id);
        $this->db->where('status', 1);
        $this->db->select('upload_file as multipleupload,file_name as document_name');
        $offline_coduments =  $this->db->get(DB_PREFIX . 'candidate_upload_files')->result_array();
        $this->db->where('candidate_req_id', $request_id);
        $this->db->where('check_id', $check_id);
        $this->db->where('level_id', $level_id);
        $this->db->select('vm_comments,vm_revert_status');
        $stopcheck_comments =  $this->db->get(DB_PREFIX . 'ver_assign_rep')->row_array();
        $data['partial_coduments'] = array_merge($partial_coduments, $offline_coduments);
        $data['contsofcheck'] = $this->vm->countsofchk($request_id, $check_id, $level_id);
        $data['total_chk'] = $this->vm->getallchecks($request_id);
        if ($pack_id > 94)
            $colour_details = $this->vrm->$slug($pack_id);
        else
            $colour_details = $this->vrm->$slug($check_id);
        $data['colourtxt'] = $colour_details;
        $data['deo_additional_document'] = $this->vm->deo_add_doc($request_id);
        $data['authorization_letter'] = $this->db->query("select company_decl_doc from " . DB_PREFIX . "declaration_details where user_id=" . $request_id)->row_array();
        $data['deo_name'] = $this->vm->deoname($request_id);
        $data['check_resources'] = $this->config->item('Checkdata_fields');
        if ($check_id == 651  || $check_id == 644 || $check_id == 1306   || $check_id == 647 || $check_id == 646 || $check_id == 645 || $check_id == 653 || $check_id == 654) {
            $data['check_id'] = $check_id;
            $data['inter_charges'] = $inter_charges = $this->db->query("select * from " . DB_PREFIX . "service_charges_intchecks where request_id=" . $request_id . " && check_id=" . $check_id . " && level_id=" . $level_id . "")->result_array();
        }


        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('QC2 Assigned List', 'Verification/qc2_verification');
        $this->breadcrumbs->push('Qc2 - Verification Details  ', 'Verification/qc_verified');

        // unshift crumb




        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();

        $this->amodel->pagerender($data, 'education_data');
    }
    function export()
    {
        $model = array('Verification_model' => 'get_userlistoffsuper');
        $office = ($_REQUEST['hoffice']) ? $_REQUEST['hoffice'] : '';
        $hcompleted = ($_REQUEST['hcompleted']) ? $_REQUEST['hcompleted'] : 0;
        $name = ($_REQUEST['hname']) ? $_REQUEST['hname'] : '';
        $a_status = ($_REQUEST['hstatus']) ? $_REQUEST['hstatus'] : '';


        if ($office)
            $condition[] = " b.id = " . $office;

        if ($name)
            $condition[] = " a.candidate_name like '%" . $name . "%'";

        if ($a_status == 1)
            $condition[] = " a.assainee_status =1";

        if ($a_status == 2)
            $condition[] = " a.assainee_status !=1";

        $manual_cond = implode(' and ', $condition);

        $results = $this->_jqgrid_search($model, $manual_cond);

        $data['results'] = toArray($results);

        $response = $results[0];
        $result = $results[1];

        $out = '<table><thead><th>S.No</th><th>Candidate Name</th>
                        <th>Organization Name</th><th>Office Name</th><th>Order Name</th><th>Status</th></thead>';

        $out .= '<tbody>';

        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            $ii = 0;
            $jj = 0;
            foreach ($result as $i => $row) {
                $status = $this->vm->getstatus($row['request_id']);
                if ($status[0]['assignee_status'] == 1) {
                    $chk_status = $this->vm->getchkstatus($row['request_id']);
                    $coun = $ii + $count + 1;
                    $coun1 = $jj + $count + 1;
                    if ($chk_status == 0 && $hcompleted == 1) {

                        $out .= '<tr><td>' . $coun . '</td><td>' . $row['candidate_name'] . '</td><td>' . $row['org_name'] . '</td><td>' . $row['office_name'] . '</td><td>' . $row['order_name'] . '</td><td>Assigned</td><td>';
                        $ii++;
                    } else if ($chk_status != 0 && $hcompleted == 0) {
                        $out .= '<tr><td>' . $coun1 . '</td><td>' . $row['candidate_name'] . '</td><td>' . $row['org_name'] . '</td><td>' . $row['office_name'] . '</td><td>' . $row['order_name'] . '</td><td>' . $chk_status . 'check not assigned</td><td>';
                        $jj++;
                    }
                }
            }
        }

        $out .= '</tbody><table>';
        $filename = "Case_Details_On_" . date('d-m-Y H:i:s') . ".xls";
        header("Content-Type:   application/vnd.ms-excel; charset=utf-8");
        header("Content-Disposition: attachment; filename=\"$filename\"");
        header("Expires: 0");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("Cache-Control: private", false);
        echo $out;
    }
    function new_allotted_list()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Verification List', 'Verification/new_allotted_list');


        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'verification_list');
    }
    function assigned_list()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Assigned List', 'Verification/assigned_list');


        // unshift crumb

        // output
        $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'assigned_list');
    }

    function get_assignedlist()
    {

        $model = array('Verification_model' => 'get_assignedlist');
        $check = ($_REQUEST['check']) ? $_REQUEST['check'] : '';
        $status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $office_name = ($_REQUEST['office_name']) ? $_REQUEST['office_name'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $request_id = ($_REQUEST['request_id']) ? $_REQUEST['request_id'] : '';
        if ($check)
            $condition[] = " a.check_id = " . $check;
        if ($request_id)
            $condition[] = " a.candidate_req_id = " . $request_id;
        if ($status)
            $condition[] = " a.verify_status=" . $status;
        if ($name)
            $condition[] = "d.candidate_name like '%" . $name . "%' ";
        if ($office_name)
            $condition[] = "p.office_name like '%" . $office_name . "%' ";
        if ($case_no)
            $condition[] = "d.case_no like '%" . $case_no . "' ";
        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( d.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " b.lastname " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " p.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " f.order_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vs.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " verify_status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " v.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.vm_revert_status " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }
        $manual_cond = implode(' and ', $condition);



        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $checkteam = $this->config->item('CHECKLIST', APPLICATIONCONFIG);
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            foreach ($result as $i => $row) {

                $checkstatus = $this->vm->getstatus_of_can($row['candidate_req_id'], $row['checkId']);

                $checkadminstatus = $this->vm->get_currentstatus($row['candidate_req_id']);
                $assignee_val = $this->vm->getassignee_name($row['candidate_req_id']);
                $verfier_details = 'Call Details';
                $candidatename = $row['candidatename'];
                if ($row['qc_revert_request'] == 1) {
                    if ($row['vm_assigned_qc'] == 1) {
                        $verifyurl = 'Revert Rectified';
                    } else {
                        $verifyurl = 'Revert Assigned';
                    }
                } elseif ($row['vm_revert_option_status'] == 1 && $row['vm_revert_to'] == 2) {
                    $verifyurl = 'Revert Raised on DEO';
                } elseif ($row['vm_revert_option_status'] == 2) {
                    $verifyurl = 'Revert Raised on cadmin';
                } elseif ($row['vm_revert_to'] == 3 && $row['vm_revert_supervisor'] == 1) {
                    $verifyurl = 'Revert Raised on DES';
                } elseif ($row['verify_status'] == 111 && $row['vrequest'] == 0 && $row['ass_request'] == 0) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = $row['candidatename'];
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 3 && $row['vm_revert_to'] == 2) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = $row['candidatename'];
                } else if ($row['vm_revert_option_status'] == 3 && $row['vm_revert_to'] == 2) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 4 && $row['operator_submited_by'] == 12 || $row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 4 && $checkadminstatus['role_id'] == 13) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = $row['candidatename'];
                } else if ($row['vm_revert_option_status'] == 4 && $row['operator_submited_by'] == 12 || $row['vm_revert_option_status'] == 4 && $checkadminstatus['role_id'] == 13) {
                    $verifyurl = 'Revert Closed';
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_to'] == 3 && $row['vm_revert_supervisor'] == 0) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = $row['candidatename'];
                } else if ($row['vm_revert_to'] == 3 && $row['vm_revert_supervisor'] == 0) {
                    $verifyurl = 'Revert Closed';
                } else if ($row['verify_status'] <> '111' && $row['vrequest'] == 1 && $row['rstatus'] != 0 && $row['ass_request'] == 0) {
                    if ($row['rstatus'] == 108)
                        $vst = 'Inputs Required';
                    else if ($row['rstatus'] == 110)
                        $vst = 'Stop Check';
                    else if ($row['rstatus'] == 109)
                        $vst = 'Awaiting Authorisation';
                    else if ($row['rstatus'] == 107)
                        $vst = 'Initiated';
                    else if ($row['rstatus'] == 519)
                        $vst = 'Others';
                    else if ($row['rstatus'] == 684)
                        $vst = 'Request Raised';

                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">' . $vst . '</p>';

                    $requesttoass = '';
                } else if ($row['verify_status'] == '111' && $row['vrequest'] == 1 && $row['rstatus'] != 0 && $row['ass_request'] == 0) {
                    if ($row['rstatus'] == 108)
                        $vst = 'Inputs Required';
                    else if ($row['rstatus'] == 110)
                        $vst = 'Stop Check';
                    else if ($row['rstatus'] == 109)
                        $vst = 'Awaiting Authorisation';
                    else if ($row['rstatus'] == 107 && $row['verify_status'] == '111')
                        $vst = 'Verified';
                    else if ($row['rstatus'] == 107)
                        $vst = 'Initiated';
                    else
                        $vst = 'Verified';

                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">' . $vst . '</p>';
                    $requesttoass = '';
                } else if ($row['ass_request'] == 1) {
                    $verifyurl = 'Request Raised';
                    $requesttoass = 'Sent to Associate';
                    $add_calls = '';
                } else {
                    $save['request_id'] = $row['candidate_req_id'];
                    $save['check_id'] = $row['checkId'];
                    $save['level_id'] = $row['level_id'];
                    $this->db->select('count(*) as cnt');
                    $this->db->where($save);
                    $countnoti = $this->db->get(DB_PREFIX . 'notification_emails')->row_array();

                    if ($countnoti['cnt'] >= 1)
                        $vtext = 'Sent Mail to Resource';
                    else
                        $vtext = 'New';




                    $verifyurl = $vtext;
                    $vst = $row['status'];
                    $requesttoass = '';
                }
                $slug = url_title(convert_accented_characters($row['checkname']), 'underscore', TRUE);


                if ($row['checkid'] == 14)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'education_details');
                else if ($row['checkid'] == 16)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'contact_details', 'request_id', 'permanent_address');
                else if ($row['checkid'] == 59)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'employment', 'req_id', 'level_id');
                else if ($row['checkid'] == 76 || $row['checkid'] == 77 || $row['checkid'] == 75)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], $slug, 'request_id', 'level_name');
                else
                    $levelnames['level'] = $row['checkname'];

                if ($row['status'] == 'Initiated')
                    $rowstatus = 'New';
                else
                    $rowstatus = $row['status'];

                if ($row['chk'] == 0) {
                    $chkval = $row['checkname'];
                } else {
                    $chkval = $row['checkname'] . ' ' . $row['chk'];
                }
                $reassign = $this->vm->getassignstatus($row['candidate_req_id'], $row['checkid'], $row['level_id']);
                if ($reassign) {
                    $assignstat = anchor('/Verification/vm_reassignee/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['checkid']) . '/' . base64_encode($row['level_id']), 'Reassign');
                }
                $deadline_from = isset($row['deadline_from']) ? date('d-m-Y', strtotime($row['deadline_from'])) : '';
                $deadline_to = isset($row['deadline_to']) ? date('d-m-Y', strtotime($row['deadline_to'])) : '';

                $response->rows[$i]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], $candidatename, $row['case_no'], $chkval, $verifyurl, $verfier_details, $rowstatus, $row['vname'], $deadline_from, $deadline_to, $assignstat, anchor('/Verification/revert_history/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['checkid']) . '/' . base64_encode($row['level_id']), 'Revert History'));
            }
        }
        echo json_encode($response);
    }
    function vm_reassignee()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4'));
        $this->amodel->loadjsscript(array('jquery.validate', 'jquery.dropdownPlain', 'jquery-ui-1.8.16.custom.min'));
        $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(4));
        $data['level_id'] = $level_id = base64_decode($this->uri->segment(5));
        $candidate_name = $data['checks_result'] = $this->vm->get_userlist($request_id);
        $data['candidate_name'] = $candidate_name[0]['candidate_name'];
        $data['chk_details'] = $this->vm->getvmreassignchkDetails($request_id, $check_id, $level_id);
        $allverificationmembes = $this->vm->get_assignee_list();
        $data['assignee_list'] = $this->amodel->filterDropdown($allverificationmembes, array('assignee_id', 'name'));

        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Verification List', 'Verification/new_allotted_list');

        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'vm_reassignee');
    }
    function revert_history()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Revert History', 'Verification/revert_history');


        $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'assigned_list');
    }
    function get_reverthistory()
    {
        $model = array('Verification_model' => 'get_reverthistory');
        $check = ($_REQUEST['check']) ? $_REQUEST['check'] : '';
        $status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $office_name = ($_REQUEST['office_name']) ? $_REQUEST['office_name'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $request_id = ($_REQUEST['request_id']) ? $_REQUEST['request_id'] : '';
        $check_id = ($_REQUEST['check_id']) ? $_REQUEST['check_id'] : '';
        $level_id = ($_REQUEST['level_id']) ? $_REQUEST['level_id'] : '';
        if ($check)
            $condition[] = " a.check_id = " . $check;
        if ($request_id)
            $condition[] = " a.candidate_req_id = " . $request_id;
        if ($check_id)
            $condition[] = " a.check_id = " . $check_id;
        if ($level_id)
            $condition[] = " a.level_id = " . $level_id;
        if ($status)
            $condition[] = " a.verify_status=" . $status;
        if ($name)
            $condition[] = "b.firstname like '%" . $name . "%' ";
        if ($office_name)
            $condition[] = "p.office_name like '%" . $office_name . "%' ";
        //18/01/2024
        $case_no = trim($case_no);
        if ($case_no)
            $condition[] = "d.case_no like '%" . $case_no . "' ";
        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.firstname " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " b.lastname " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " p.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " f.order_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vs.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " verify_status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.vm_revert_status " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }
        $manual_cond = implode(' and ', $condition);



        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $checkteam = $this->config->item('CHECKLIST', APPLICATIONCONFIG);
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;

            foreach ($result as $i => $row) {
                $rt_date = '';
                if ($row['reverted_date']) {
                    $rt_date = date('d-m-Y ', strtotime($row['reverted_date']));
                }
                $chk_num = '';
                if ($row['chk'] == 0) {
                    $chk_num = $row['checkname'];
                } else {
                    $chk_num = $row['checkname'] . ' ' . $row['count_of_chk'];
                }
                if ($row['revertreason']) {
                    $id = $row['revertreason'];
                    $this->db->select('name');
                    $revertid  = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $id))->row_array();
                    $revert_name = $revertid['name'];
                }
                $candidatename = $row['candidatename'];
                $response->rows[$i]['cell'] = array($i + $count + 1, $row['case_no'], $candidatename, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], $chk_num, $row['comments'], $revert_name, $row['revert_from'], $row['revert_to'], $rt_date);
            }
        }
        echo json_encode($response);
    }
    function qc2_publish()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'jquery-ui-1.8.16.custom.min', 'commonjs', 'jquery.validate', 'multipleclone'));
        $data['candidate_req_id'] = $condition['candidate_req_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['level_id'] = $condition['level_id'] = $level_id = base64_decode($this->uri->segment(4));
        $data['check_id'] = $condition['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $data['pack_id'] = $condition['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));

        //Code added by MN for share_code on  Nov 30th
        $res = $this->cam->get_share_code($request_id, $check_id);
        $share_code = $res[0]['share_code'];
        $data['share_code'] = $share_code;

        $checkreport = $this->vm->check_report($condition);
        $revertreport = $this->vm->qcrevert_report($condition);
        $this->db->select('name');
        $order = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->result_array();
        $key = $data['key'] = $order[0]['name'];
        $this->db->select('order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';
        $this->db->select('name');
        $data['checkname'] = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->row_array();
        $slug = url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);
        if ($pack_id > 94)
            $level_details = $this->dm->$slug($request_id, $pack_id, $level_id);
        else
            $level_details = $this->dm->$slug($request_id, $check_id, $level_id);
        if ($check_id == 651  || $check_id == 644 || $check_id == 1306  || $check_id == 647 || $check_id == 646 || $check_id == 645 || $check_id == 653 || $check_id == 654) {
            $data['check_id'] = $check_id;
            $data['inter_charges'] = $inter_charges = $this->db->query("select * from " . DB_PREFIX . "service_charges_intchecks where request_id=" . $request_id . " && check_id=" . $check_id . " && level_id=" . $level_id . "")->result_array();
        }



        $this->db->select('id');
        $checkname = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('parent' => $check_id, 'name' => $level_details[0]['level_name']))->row_array();
        $data['dataentrydata'] = $level_details[0];
        $data['verified_data'] = $verified_data = $this->vm->get_verified_data($request_id, $level_id, $check_id);
        $data['expencedata'] = toArray(json_decode($verified_data['vmexpenses']));
        if ($check_id == 76 || $check_id == 77) {

            $check_id = $checkname['id'];
            $data['scheck_id'] = $check_id;
        } else
            $data['scheck_id'] = $check_id;

        $data['status'] = $this->dem->get_check_status($check_id, 0);
        $this->db->select('*');
        $partial_coduments = $this->db->get_where(DB_PREFIX . 'partial_upload_document', array('request_id' => $request_id, 'status' => '1'))->result_array();

        $this->db->where('req_id', $request_id);
        $this->db->where('status', 1);
        $this->db->select('upload_file as multipleupload,file_name as document_name');
        $offline_coduments =  $this->db->get(DB_PREFIX . 'candidate_upload_files')->result_array();
        $this->db->select('*');
        $deo_upload_doc = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['deo_upload_documents'] = $deo_upload_doc;
        $data['partial_coduments'] = array_merge($partial_coduments, $offline_coduments);
        $data['documents'] = $this->vm->documentsup($request_id);
        $data['revert_documents'] = $this->vm->revert_documentsup($request_id);
        $this->db->where('request_id', $request_id);
        $this->db->where('check_id', $check_id);
        $this->db->where('level_id', $level_id);
        $this->db->where('status', '1');
        $this->db->select('authenticate_doc,document_name');
        $offline_multicoduments = $this->db->get(DB_PREFIX . 'vm_upload_files')->result_array();

        $data['offline_multicodument'] = $offline_multicoduments;
        $valueed_data = $data['verified_data'];
        //print_r($data['verified_data']); exit;
        $verify_fielddata = toArray(json_decode($valueed_data['qc2fielddata']));
        $data['verifying_fielddata'] = $verify_fielddata;
        $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['level_id'] = base64_decode($this->uri->segment(4));
        $data['check_id'] = base64_decode($this->uri->segment(5));
        $data['pack_id'] = base64_decode($this->uri->segment(6));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Qc2 - Verification Details', 'Verification/qc2_publish');
        $revertexpences = $this->db->query("select p.check_id,a.vm_amount,a.vm_expences,a.vm_reference,a.check_id as profile_id,a.case_no,a.created_on,c.org_name,b.office_name,b.address1,b.address2,b.address3,b.locality,b.pincode,d.office_name as parent_office,o.office_name as sub_office,a.id,a.candidate_name, p.no_checks from " . DB_PREFIX . "billing a 
               
                LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
                    LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    LEFT JOIN " . DB_PREFIX . "request_check p ON p.request_id=a.request_id
                
                where a.request_id =" . $request_id . " and a.billing_type=517 GROUP BY c.org_name")->result_array();
        $data['revertexpencess'] = $revertexpences;
        $data['contsofcheck'] = $this->vm->countsofchk($request_id, $check_id, $level_id);
        $data['total_chk'] = $this->vm->getallchecks($request_id);
        if ($pack_id > 94)
            $colour_details = $this->vrm->$slug($pack_id);
        else
            $colour_details = $this->vrm->$slug($check_id);
        $data['colourtxt'] = $colour_details;
        $data['deo_additional_document'] = $this->vm->deo_add_doc($request_id);
        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->db->select('acceptable_limit');
        $data['discrepancy_limit'] = $discrepancy_limit = $this->db->get_where(DB_PREFIX . 'add_check', array('order_id' => $orderid[0][order_id], 'types_of_check' => $check_id))->row_array();
        $data['authorization_letter'] = $this->db->query("select company_decl_doc from " . DB_PREFIX . "declaration_details where user_id=" . $request_id)->row_array();
        $data['deo_name'] = $this->vm->deoname($request_id);
        $data['check_resources'] = $this->config->item('Checkdata_fields');
        $this->amodel->pagerender($data, 'verification_reports');
    }

    function qc2_reopen()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'jquery-ui-1.8.16.custom.min', 'commonjs', 'jquery.validate', 'multipleclone'));
        $data['candidate_req_id'] = $condition['candidate_req_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['level_id'] = $condition['level_id'] = $level_id = base64_decode($this->uri->segment(4));
        $data['check_id'] = $condition['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $data['pack_id'] = $condition['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));

        $checkreport = $this->vm->check_report($condition);
        $revertreport = $this->vm->qcrevert_report($condition);
        $data['revertcomment'] = $revertreport;
        $this->db->select('name');
        $order = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->result_array();
        $key = $data['key'] = $order[0]['name'];
        $this->db->select('order_id,candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';
        $this->db->select('name');
        $data['checkname'] = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->row_array();
        $slug = url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);
        if ($pack_id > 94)
            $level_details = $this->dm->$slug($request_id, $pack_id, $level_id);
        else
            $level_details = $this->dm->$slug($request_id, $check_id, $level_id);
        $this->db->select('id');
        $checkname = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('parent' => $check_id, 'name' => $level_details[0]['level_name']))->row_array();
        $data['dataentrydata'] = $level_details[0];
        $data['verified_data'] = $this->vm->get_verified_data($request_id, $level_id, $check_id);

        if ($check_id == 76 || $check_id == 77) {

            $check_id = $checkname['id'];
            $data['scheck_id'] = $check_id;
        } else
            $data['scheck_id'] = $check_id;

        $data['status'] = $this->dem->get_check_status($check_id, 0);
        $this->db->select('*');
        $partial_coduments = $this->db->get_where(DB_PREFIX . 'partial_upload_document', array('request_id' => $request_id, 'status' => '1'))->result_array();

        $this->db->where('req_id', $request_id);
        $this->db->where('status', 1);
        $this->db->select('upload_file as multipleupload,file_name as document_name');
        $offline_coduments =  $this->db->get(DB_PREFIX . 'candidate_upload_files')->result_array();
        $this->db->select('*');
        $deo_upload_doc = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();

        $data['deo_upload_documents'] = $deo_upload_doc;
        $data['partial_coduments'] = array_merge($partial_coduments, $offline_coduments);
        $data['documents'] = $this->vm->documentsup($request_id);
        $data['revert_documents'] = $this->vm->revert_documentsup($request_id);
        $this->db->where('request_id', $request_id);
        $this->db->where('check_id', $check_id);
        $this->db->where('level_id', $level_id);
        $this->db->where('status', '1');
        $this->db->select('authenticate_doc,document_name');
        $offline_multicoduments = $this->db->get(DB_PREFIX . 'vm_upload_files')->result_array();
        $data['offline_multicodument'] = $offline_multicoduments;
        $valueed_data = $data['verified_data'];
        $verify_fielddata = toArray(json_decode($valueed_data['qc2fielddata']));
        $data['verifying_fielddata'] = $verify_fielddata;
        $data['request_id'] = base64_decode($this->uri->segment(3));
        $data['level_id'] = base64_decode($this->uri->segment(4));
        $data['check_id'] = base64_decode($this->uri->segment(5));
        $data['pack_id'] = base64_decode($this->uri->segment(6));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Qc1 - Verification Details', 'Verification/qccal_reports');
        $revertexpences = $this->db->query("select p.check_id,a.vm_amount,a.vm_expences,a.vm_reference,a.check_id as profile_id,a.case_no,a.created_on,c.org_name,b.office_name,b.address1,b.address2,b.address3,b.locality,b.pincode,d.office_name as parent_office,o.office_name as sub_office,a.id,a.candidate_name, p.no_checks from " . DB_PREFIX . "billing a 
               
                LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
                    LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    LEFT JOIN " . DB_PREFIX . "request_check p ON p.request_id=a.request_id
                
                where a.request_id =" . $request_id . " and a.billing_type=517 GROUP BY c.org_name")->result_array();
        $data['revertexpencess'] = $revertexpences;
        $data['contsofcheck'] = $this->vm->countsofchk($request_id, $check_id, $level_id);
        $data['total_chk'] = $this->vm->getallchecks($request_id);
        if ($pack_id > 94)
            $colour_details = $this->vrm->$slug($pack_id);
        else
            $colour_details = $this->vrm->$slug($check_id);
        $data['colourtxt'] = $colour_details;
        $data['deo_additional_document'] = $this->vm->deo_add_doc($request_id);
        // ******* charges for international check *********
        if ($check_id == 651  || $check_id == 644 || $check_id == 1306  || $check_id == 647 || $check_id == 646 || $check_id == 645 || $check_id == 653 || $check_id == 654) {
            $data['check_id'] = $check_id;
            $data['inter_charges'] = $inter_charges = $this->db->query("select * from " . DB_PREFIX . "service_charges_intchecks where request_id=" . $request_id . " && check_id=" . $check_id . " && level_id=" . $level_id . "")->result_array();
        }  // ******* End charges for international check *********


        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->db->select('acceptable_limit');
        $data['discrepancy_limit'] = $discrepancy_limit = $this->db->get_where(DB_PREFIX . 'add_check', array('order_id' => $orderid[0][order_id], 'types_of_check' => $check_id))->row_array();
        $data['authorization_letter'] = $this->db->query("select company_decl_doc from " . DB_PREFIX . "declaration_details where user_id=" . $request_id)->row_array();
        $data['deo_name'] = $this->vm->deoname($request_id);
        $data['check_resources'] = $this->config->item('Checkdata_fields');
        $this->amodel->pagerender($data, 'verification_reports');
    }

    function qc2_reopenchk()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'jquery-ui-1.8.16.custom.min', 'commonjs', 'jquery.validate', 'multipleclone'));
        $data['candidate_req_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['level_id'] = $level_id = base64_decode($this->uri->segment(4));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $data['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));
        $candidate = $this->vm->get_canname($request_id);
        $data['candidate_name'] = $candidate[0]['candidate_name'];
        $data['case_no'] = $candidate[0]['case_no'];
        $data['checkname'] = $this->db->query("select a.count_of_chk,b.name from " . DB_PREFIX . "ver_assign_rep a LEFT JOIN " . DB_PREFIX . "master_masterdata b ON b.id=a.check_id where b.id=" . $check_id . " and a.candidate_req_id=" . $request_id . " and a.level_id =" . $level_id)->row_array();

        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Qc2 Reopen Request', 'Verification/qc2_reopenchk');
        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();

        $this->amodel->pagerender($data, 'verification_reports');
    }

    function qc2_reopendata()
    {
        $upd_data = array();
        $RoleId = $this->session->userdata('role_id');

        $reopen['qc2_report_publish'] = 2;
        $reopen['qc2_revert_request'] = 0;
        $this->db->where('candidate_req_id', $_POST['request_id']);
        $this->db->where('check_id', $_POST['check_id']);
        $this->db->where('level_id', $_POST['level_id']);
        $this->db->where('pack_id', $_POST['pack_id']);
        $this->db->update(DB_PREFIX . 'ver_assign_rep', $reopen);
        $reopenv['supplementary'] = 1;
        $reopenv['reopen_by'] = $this->session->userdata['role_id'];
        $this->db->where('request_id', $_POST['request_id']);
        $this->db->where('check_id', $_POST['check_id']);
        $this->db->where('level_id', $_POST['level_id']);
        $this->db->where('package_id', $_POST['pack_id']);
        $this->db->update(DB_PREFIX . 'verified_level', $reopenv);

        /************* Status Updtes ***************/
        if ($RoleId == 1) {
            $chkStatus = 1011;
        } else if ($RoleId == 21 || $RoleId == 24) {
            $chkStatus = 1012;
        } else if ($RoleId == 17) {
            $chkStatus = 1013;
        } else {
            $chkStatus = '';
        }

        $stat_save['request_id'] = $_POST['request_id'];
        $stat_save['case_no'] = $_POST['case_no'];
        $stat_save['check_id'] = $_POST['check_id'];
        $stat_save['level_id'] = $_POST['level_id'];
        $stat_save['check_status'] = $chkStatus;
        $stat_save['verified_status'] = '';
        $stat_save['date_of_update'] = date('y-m-d H:i:s');
        $stat_save['role_id'] = $this->session->userdata('role_id');
        $stat_save['user_id'] = $this->session->userdata['userid'];
        // print_r($stat_save);exit;
        $stat_save = $this->security->xss_clean($stat_save);
        $this->db->insert(DB_PREFIX . 'status_updates', $stat_save);

        /******************************************/
        $final['final_report'] = 0;
        $this->db->where('request_id', $_POST['request_id']);
        $this->db->update(DB_PREFIX . 'client_request', $final);
        // redirect ( base_url('Verification/qc2_reopen/'.base64_encode($_POST['request_id']).'/'.base64_encode($_POST['level_id']).'/'.base64_encode($_POST['check_id']).'/'.base64_encode($_POST['pack_id'])), 'refresh' );
        if($RoleId != 17)
            $this->tm->save_TAT_on_interim_reopen($_POST['request_id'], $_POST['check_id'], $_POST['level_id']); // MN Aug
        redirect(base_url('Verification/qc2cal_reports/' . base64_encode($_POST['request_id']) . '/' . base64_encode($_POST['level_id']) . '/' . base64_encode($_POST['check_id']) . '/' . base64_encode($_POST['pack_id'])), 'refresh');
    }

    /* showing all verified documents for particular check*/
    function verified_docs()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'jquery-ui-1.8.16.custom.min', 'commonjs', 'jquery.validate', 'multipleclone'));

        $data['candidate_req_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['level_id'] = $level_id = base64_decode($this->uri->segment(4));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $data['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));


        $data['verified_docs'] = $verified_docs = $this->amodel->getDetails(DB_PREFIX . "vm_upload_files", array('authenticate_doc', 'document_name'), array('request_id' => $request_id, 'check_id' => $check_id, 'level_id' => $level_id, 'status' => '1'));
        $data['candidate_info'] = $candidate_info = $this->amodel->getDetails(DB_PREFIX . "client_request", array('request_id', 'candidate_name'), array('request_id' => $request_id));
        $data['check_name'] = $check_name = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('name'), array('id' => $check_id, 'key' => 'check'));

        $this->amodel->pagerender($data, 'verified_docs');
    }
    /* Reassignment of vmember*/
    function p_vmnewrequest()
    {
        $assignee_id = $this->input->post('assignee_id');
        $date_to = $this->input->post('date_to');
        $request_id = $_POST['request_id'];
        if ($_POST) {
            $upd_data = array();
            $upd_data['team_mem_id'] = $assignee_id;
            $this->db->where('candidate_req_id', $_POST['request_id']);
            $this->db->where('check_id', $_POST['check_id']);
            $this->db->where('level_id', $_POST['level_id']);
            $this->db->update(DB_PREFIX . 'ver_assign_rep', $upd_data);

            $upd_request = array();
            $upd_request['deadline_to'] = date('Y-m-d', strtotime($date_to));
            $upd_request['updated_by'] = $this->session->userdata('userid');
            $this->db->where('request_id', $_POST['request_id']);
            $this->db->where('check_id', $_POST['check_id']);
            $this->db->where('level_id', $_POST['level_id']);
            $this->db->update(DB_PREFIX . 'verification_request', $upd_request);
        }
        $inslog_data['action'] = 'ReAllotted to VM';
        $inslog_data['updated_by'] = $this->session->userdata('userid');
        $inslog_data['updated_on'] = date('Y-m-d H:i:s');
        $this->db->where('request_id', $_POST['request_id']);
        $this->db->update(DB_PREFIX . 'loghistory', $inslog_data);
        redirect(base_url('Verification/assigned_list/' . base64_encode($request_id)), 'refresh');
    }
    function previous_verification()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'jquery-ui-1.8.16.custom.min', 'commonjs', 'jquery.validate', 'multipleclone'));
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Verification List', 'Verification/allotted_list');
        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'previous_verification');
    }
    function get_previous_verification($univ_name = null, $check_id = null)
    {
        $check_id = ($_REQUEST['check_id']) ? $_REQUEST['check_id'] : '';

        if ($check_id == 14) {
            $model = array('Verification_model' => 'get_previous_eduverification');
        }
        if ($check_id == 59) {
            $model = array('Verification_model' => 'get_previous_empverification');
        }
        $univ_name = ($_REQUEST['univ_name']) ? $_REQUEST['univ_name'] : '';
        $affiliate = ($_REQUEST['affiliate']) ? $_REQUEST['affiliate'] : '';
        $office_name = ($_REQUEST['office_name']) ? $_REQUEST['office_name'] : '';
        if ($office_name)
            $condition[] = "p.office_name like '%" . $office_name . "%' ";
        if ($check_id == 14) {
            if (!empty($univ_name) && !empty($affiliate))
                $condition[] = "( a.collegename_add like '%" . $univ_name . "%'  or a.affliated like '%" . $affiliate . "%' )";
        } else if ($check_id == 59) {
            if ($univ_name)
                $condition[] = " (a.company_name like '%" . $univ_name . "%')";
        }

        $manual_cond = implode(' and ', $condition);

        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $checkteam = $this->config->item('CHECKLIST', APPLICATIONCONFIG);
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;

            foreach ($result as $i => $row) {
                $verifierdata = toArray(json_decode($row['fielddata']));
                if ($row['check_id'] == 14)
                    $univname = $row['collegename_add'] . '/' . $row['affliated'];
                $actual_reimbursement_data = toArray(json_decode($row['vmexpenses']));
                if (!empty($actual_reimbursement_data[0]['expences'])) {
                    $actual_reimbursement = anchor('/Verification/actual_reimbursement/' . base64_encode($row['request_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['level_id']), 'View expenses', 'target="_blank"');
                } else {
                    $actual_reimbursement = '';
                }
                $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['package_id']), 'Call Details', 'target="_blank"');

                $procedure_atts = array('target' => '_blank', 'style' => 'color:blue');

                $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['request_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['package_id']), 'Procedure Details', $procedure_atts);

                $dactual_reimbursement = $verifierdata['expences'];
                $response->rows[$i]['cell'] = array($i + $count + 1, $row['company_name'], $univname, $verifierdata['verifiedby'], $verifierdata['designation'], $verifierdata['contact'], $verifierdata['email'], $actual_reimbursement, $verfier_details, $procedure_details);
            }
        }
        echo json_encode($response);
    }
    function actual_reimbursement()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'jquery-ui-1.8.16.custom.min', 'commonjs', 'jquery.validate', 'multipleclone'));
        $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(4));
        $data['level_id'] = $level_id = base64_decode($this->uri->segment(5));
        $data['verified_data'] = $verified_data = $this->vm->get_verified_data($request_id, $level_id, $check_id);
        $data['expencedata'] = toArray(json_decode($verified_data['vmexpenses']));
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Verification List', 'Verification/allotted_list');
        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'actual_reimbursement');
    }
    function add_procedure()
    {


        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.validate', 'jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));

        $data['request_id'] = $candidate_id = base64_decode($this->uri->segment(3));
        $data['level_id'] = $level_id = base64_decode($this->uri->segment(4));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(5));

        $request_id = base64_decode($this->uri->segment(3));
        $level_id = base64_decode($this->uri->segment(4));
        $this->db->select('candidate_name');
        $orderid = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $request_id))->result_array();
        $data['candidate_name'] = ($orderid[0]['candidate_name']) ? '( ' . $orderid[0]['candidate_name'] . ' )' : '';
        $vmcalldetails = $this->amodel->getDetails(DB_PREFIX . "add_procedure", array('*'), array('candidate_req_id' => $candidate_id, 'check_id' => $check_id, 'level_id' => $level_id), $this->db->order_by("id", "desc"));
        $data['contact_name_add'] = $vmcalldetails[0]['contact_person'];
        $data['designation_contact'] = $vmcalldetails[0]['designation_person'];
        $data['mobile'] = $vmcalldetails[0]['contact_no'];
        $data['email'] = $vmcalldetails[0]['email'];
        $data['mom'] = $vmcalldetails[0]['mom'];
        $data['college_procedure'] = $vmcalldetails[0]['college_procedure'];

        $this->amodel->pagerender($data, 'add_procedure');
    }
    function addproceduredml()
    {
        $request_id = base64_decode($this->uri->segment(3));
        $level_id = base64_decode($this->uri->segment(4));
        $check_id = base64_decode($this->uri->segment(5));
        $pack_id = base64_decode($this->uri->segment(6));
        $formData = $_POST;

        $this->vm->call_procedure_dml($formData, $request_id, $level_id, $check_id);
        redirect('Verification/add_procedure/' . base64_encode($request_id) . '/' . base64_encode($level_id) . '/' . base64_encode($check_id) . '/' . base64_encode($pack_id));
    }
    function get_procedure_details()
    {
        $request_id = ($_REQUEST['request_id']) ? $_REQUEST['request_id'] : '';
        $level_id = ($_REQUEST['level_id']) ? $_REQUEST['level_id'] : '';
        $check_id = ($_REQUEST['check_id']) ? $_REQUEST['check_id'] : '';
        $email = ($_REQUEST['email']) ? $_REQUEST['email'] : '';
        $mobile = ($_REQUEST['mobile']) ? $_REQUEST['mobile'] : '';
        if ($request_id)
            $condition[] = " candidate_req_id = " . $request_id;
        if ($level_id)
            $condition[] = " level_id = " . $level_id;
        if ($check_id)
            $condition[] = " check_id = " . $check_id;
        if ($email)
            $condition[] = " email = " . $email;
        if ($mobile)
            $condition[] = " contact_no=" . $mobile;

        $manual_cond = implode(' and ', $condition);
        $model = array('Verification_model' => 'verfierproceduredetails');
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];

        if ($result) {
            foreach ($result as $i => $row) {

                $response->rows[]['cell'] = array($i + 1, $row['contact_person'], $row['designation_person'], $row['college_procedure'], $row['contact_no'], $row['email'], date('d-m-Y', strtotime($row['created_at'])), $row['mom'], $row['first_name']);
            }
        }
        echo json_encode($response);
    }


    function vmrevert_raised_checks()
    {

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('VM Revert Raised checks List', 'Verification/vmrevert_raised_checks');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'vmrevert_raised_checks');
    }

    function personal_details()
    {

        $data['request_id'] = $candidate_id = base64_decode($this->uri->segment(3));

        /* $this->db->select('*');
           $data['personaldetails']=$this->db->get_where(DB_PREFIX .'personal_details',array('user_id'=> $candidate_id))->result_array();*/

        $data['personaldetails'] = $p = $this->dm->personaldetails($candidate_id);
        if ($p[0]['current_stay_flag'] != '') {
            if (($p[0]['current_stay_flag']) == '0') {
                $p[0]['current_stay_flag'] = 'Yes';
            } else {
                $p[0]['current_stay_flag'] = 'No';
            }
        }
        $data['personaldetails'] = $p;

        $this->amodel->pagerender($data, 'personal_details');
    }

    function verification_not()
    {

        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Verification Not Received List', 'Verification/verification_not');

        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'verification_not');
    }

    function get_verification_not()
    {

        $model = array('Verification_model' => 'get_userlistverification_not');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $company_name = ($_REQUEST['company_name']) ? $_REQUEST['company_name'] : '';
        $college_name = ($_REQUEST['college_name']) ? $_REQUEST['college_name'] : '';
        $university_name = ($_REQUEST['university_name']) ? $_REQUEST['university_name'] : '';
        $verifier_name = ($_REQUEST['verifier_name']) ? $_REQUEST['verifier_name'] : '';
        $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $request_status = ($_REQUEST['request_status']) ? $_REQUEST['request_status'] : '';
        $chk_status = ($_REQUEST['chk_status']) ? $_REQUEST['chk_status'] : '';
        $verified_status = ($_REQUEST['verified_status']) ? $_REQUEST['verified_status'] : '';

        $reopen_status = ($_REQUEST['reopen_status']) ? $_REQUEST['reopen_status'] : '';
        $additional_docs = ($_REQUEST['additional_docs']) ? $_REQUEST['additional_docs'] : '';
        $check_count = ($_REQUEST['check_count']) ? $_REQUEST['check_count'] : '';
        $date_filter = ($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
        $check_type  = ($_REQUEST['check_type']) ? $_REQUEST['check_type'] : '';
        // $reminder  = ($_REQUEST['reminder']) ? $_REQUEST['reminder'] : '';



        if ($org_id)
            $condition[] = " o.id = " . $org_id;
        if ($office)
            $condition[] = " br.id = " . $office;
        if ($parent_office)
            $condition[] = " p.id = " . $parent_office;
        if ($sub_office)
            $condition[] = " su.id = " . $sub_office;
        if ($name)
            $condition[] = "b.firstname like '%" . $name . "%' ";
        if ($check_name)
            $condition[] = "c.name like '%" . $check_name . "%' ";
        if ($company_name)
            $condition[] = "((em.company_name like '%" . $company_name . "%'  and a.check_id = 59) || (pr.company_name like '%" . $company_name . "%'  and a.check_id = 68))";
        if ($college_name)
            $condition[] = "(ed.collegename_add like '%" . $college_name . "%'  and a.check_id = 14)";
        if ($university_name)
            $condition[] = "(ed.affliated like '%" . $university_name . "%'  and a.check_id = 14)";

        if ($a_status == 1)
            $condition[] = "( a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0)";
        if ($a_status == 2)
            $condition[] = " (a.qc_revert_request = 1 and a.vm_assigned_qc=0)";
        if ($a_status == 3)
            $condition[] = " (a.qc_revert_request = 1 and a.vm_assigned_qc=1)";
        if ($a_status == 4)
            $condition[] = " a.ass_request = 1 ";
        if ($a_status == 5)
            $condition[] = " (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111)";
        if ($a_status == 6)
            $condition[] = "((a.verify_status in (110,111,519)) and a.ass_request=0 and a.qc_revert_request = 0 )";
        if ($a_status == 7)
            $condition[] = "(a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107)";
        if ($a_status == 8)
            $condition[] = "s.vm_revert_option_status = 1 and a.vm_revert_to = 2";
        if ($a_status == 9)
            $condition[] = " a.verify_status = 684 ";
        if ($a_status == 10)
            $condition[] = " a.verify_status = 992 ";
        if ($case_no)
            $condition[] = "d.case_no like '%" . $case_no . "' ";
        if ($verifier_name)
            $condition[] = "(concat_ws(' ',us.first_name,us.last_name) like '%" . $verifier_name . "%') ";
        if ($c_date && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(vr.deadline_from ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "'";
        }
        if ($t_date && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(vr.deadline_from ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }
        if ($c_date && $date_filter == 2) {
            $condition[] = "DATE_FORMAT(vr.deadline_to ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "'";
        }
        if ($t_date && $date_filter == 2) {
            $condition[] = "DATE_FORMAT(vr.deadline_to ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }
        if ($c_date && $date_filter == 3) {
            $condition[] = "DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "'";
        }
        if ($t_date && $date_filter == 3) {
            $condition[] = "DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }
        if ($request_status)
            $condition[] = " vl1.reqstatus = " . $request_status;
        if ($chk_status == 1) {
            $condition[] = " (vl1.vm_discrepency in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701)) ";
        }
        if ($chk_status == 2) {
            $condition[] = " ((vl1.vm_discrepency in (120,131,137,143,713,119,130,136,142)) or (a.verify_status in (519,110))  or (vl1.vm_discrepency in (1005)))";
        }
        if ($chk_status == 3) {
            $condition[] = " (vl1.vm_discrepency in (116,127,134,140,630,121,125,658,662,660,789)) ";
        }
        if ($reopen_status == 1) {
            $condition[] = " vl1.supplementary in (1,2) ";
        }
        if ($reopen_status == 2) {
            $condition[] = " vl1.supplementary = 3 ";
        }
        if ($additional_docs == 1) {
            $condition[] = " a.additional_docs is NOT NULL ";
        }
        if ($additional_docs == 2) {
            $condition[] = " a.additional_docs is NULL ";
        }
        if ($verified_status == 1) {
            $condition[] = " (vl1.vm_discrepency in (116,127,134,140,630)) ";
        }
        if ($verified_status == 2) {
            $condition[] = " (vl1.vm_discrepency in (121)) ";
        }
        if ($verified_status == 3) {
            $condition[] = " (vl1.vm_discrepency in (122)) ";
        }
        if ($verified_status == 4) {
            $condition[] = " (vl1.vm_discrepency in (129,135,141,701,139,701,118)) ";
        }
        if ($verified_status == 5) {
            $condition[] = " (vl1.vm_discrepency in (117,126)) ";
        }
        if ($verified_status == 6) {
            $condition[] = " ((vl1.vm_discrepency in (119,130,136,142)) or (a.verify_status in (110)))";
        }
        if ($verified_status == 7) {
            $condition[] = " ((vl1.vm_discrepency in (120,131,137,143,713)) or (a.verify_status in (519)))";
        }
        // if($reminder){
        //        		$condition[]="adc.email_count =  ".$reminder." ";
        // }

        if ($check_type == 1)
            $condition[] = "c.id = 15";
        if ($check_type == 2)
            $condition[] = "c.id = 16";
        if ($check_type == 3)
            $condition[] = "c.id = 71";
        if ($check_type == 4)
            $condition[] = "c.id = 639";
        if ($check_type == 5)
            $condition[] = "c.id = 640";
        if ($check_type == 6)
            $condition[] = "c.id = 636";
        if ($check_type == 7)
            $condition[] = "c.id = 75";

        if ($check_count && $this->session->userdata['role_id'] == 5) {
            $rep_id = " (SELECT  GROUP_CONCAT(ar.rep_id) as verifier from dcode_ver_assign_rep ar
		      where ar.team_mem_id=" . $this->session->userdata['userid'] . " and (ar.verify_status =107 or ar.vm_assigned_qc=0 or ar.verify_status =684 ) group by ar.candidate_req_id having count(ar.candidate_req_id)=" . $check_count . ")";
            $rid = $this->db->query($rep_id)->result_array();
            foreach ($rid as  $rvalue) {
                $verifier_ids[] = $rvalue['verifier'];
            }
            $condition[] = " a.rep_id in (" . implode(',', $verifier_ids) . " )";
        }
        if ($check_count && (in_array($this->session->userdata['role_id'], array(1, 9, 21, 24)))) {
            $rep_id = " (SELECT  GROUP_CONCAT(ar.rep_id) as verifier from dcode_ver_assign_rep ar
		      where (ar.verify_status =107 or ar.vm_assigned_qc=0 or ar.verify_status =684 ) group by ar.candidate_req_id having count(ar.candidate_req_id)=" . $check_count . ")";
            $rid = $this->db->query($rep_id)->result_array();
            foreach ($rid as  $rvalue) {
                $verifier_ids[] = $rvalue['verifier'];
            }
            $condition[] = " a.rep_id in (" . implode(',', $verifier_ids) . " )";
        }
        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.firstname " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " b.lastname " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " f.order_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vs.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " o.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " p.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " su.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " br.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " ed.collegename_add " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " ed.affliated " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " em.company_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " pr.company_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vr.deadline_from " . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";
                $like    .= $operator . " vr.deadline_to " . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";

                $like    .= $operator . " c.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " verify_status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.additional_docs " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.vm_revert_status " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }
        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $checkteam = $this->config->item('CHECKLIST', APPLICATIONCONFIG);
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            $k = 1;

            foreach ($result as $i => $row) {
                $company_details = $this->vm->get_verifiedcompany_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);
                $education_details = $this->vm->get_verifiedcollege_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);
                $professional_details = $this->vm->get_verifiedprofessional_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);

                $verified_data = $this->vm->get_verified_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);
                $verification_data = toArray(json_decode($verified_data['fielddata']));
                $vm_expenses  = toArray(json_decode($verified_data['vmexpenses']));
                $qc2verification_data = toArray(json_decode($verified_data['qc2fielddata']));

                if ($vm_expenses <> null) {


                    if ($vm_expenses[0]['ddcurrency']) {

                        $ddcurrencyid =   $vm_expenses[0]['ddcurrency'];

                        $results = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'currencykey', 'id' => $ddcurrencyid));

                        $currencyname =   $results[0]['name'];
                    } else {
                        $currencyname = '';
                    }

                    $d_amount = 0;
                    foreach ($vm_expenses as $key => $dd_exprenses) {

                        $d_amount += $dd_exprenses['amount'];
                    }

                    $dd_amount = $currencyname . ' ' . $d_amount;
                } else {
                    $dd_amount = '';
                }


                $status1 = $this->vm->get_status($verification_data['status']);
                $status4 = '';
                $status2 = $this->vm->get_status($verification_data['pstatus']);
                $status3 = $this->vm->get_status($verification_data['status1']);
                if ($verification_data['ostatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['ostatus']);
                if ($verification_data['dstatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['dstatus']);
                if (!empty($status4))
                    $status41 = '-' . $status4['name'];
                else
                    $status41 = '';

                $reqstatus = '';
                if (!empty($row['reqstatus'])) {
                    $req_raised_status =    $this->vm->get_status($row['reqstatus']);
                    $reqstatus = $req_raised_status['name'];
                }
                $rpt_status = '';
                if ($verification_data['status'] != 107 && $verification_data['status'] != 684 && $verification_data['status'] != 992 && !empty($verification_data['status'])) {
                    if ($status3['name'] == "Discrepant" || $status3['name'] == "Possible Discrepant" || $status3['name'] == "Record Found" || $status3['name'] == "Positive" || $status3['name'] == "No Records" || $status3['name'] == "Invalid" || $status3['name'] == "Not Completed" || $status3['name'] == "High Risk") {
                        $rpt_status = "<span style='color:red;'>RED</span>";
                    }
                    // May 24th
                    else if ($status1['name'] == "Stop Check" || $status1['name'] == "Others" || $status3['name'] == "Stop Check" || $status3['name'] == "Others" || $status3['name'] == "Possible Match" || $status3['name'] == "Partial Match") {
                        $rpt_status = "<span style='color:orange;'>ORANGE</span>";
                    } else {
                        $rpt_status = "<span style='color:green;'>GREEN</span>";
                    }
                }
                $checkstatus = $this->vm->getstatus_of_can($row['candidate_req_id'], $row['checkId']);
                $checkadminstatus = $this->vm->get_currentstatus($row['candidate_req_id']);
                $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');

                $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');

                $candidatename = $row['candidatename'];
                if ($row['vm_revert_option_status'] == 1 && $row['vm_revert_to'] == 2) {
                    $verifyurl = 'Revert Raised to DEO';
                } else if ($row['qc_revert_request'] == 1) {
                    if ($row['vm_assigned_qc'] == 1 && $row['verify_status'] <> 107 && $row['verify_status'] <> 684 && $row['verify_status'] <> 992) {
                        $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                        $verifyurl = 'Revert Rectified';
                    } else {
                        $verifyurl = anchor('/Verification/revert_raisedsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Assigned', 'target="_blank"');
                    }
                } elseif ($row['verify_status'] == 111 && $row['vrequest'] == 0 && $row['ass_request'] == 0) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 3 && $row['vm_revert_to'] == 2) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_option_status'] == 3 && $row['vm_revert_to'] == 2) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 4 && $row['operator_submited_by'] == 12 || $row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 4 && $checkadminstatus['role_id'] == 13) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_option_status'] == 4 && $row['operator_submited_by'] == 12 || $row['vm_revert_option_status'] == 4 && $checkadminstatus['role_id'] == 13) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_to'] == 3 && $row['vm_revert_supervisor'] == 0) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_to'] == 3 && $row['vm_revert_supervisor'] == 0) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] <> '111' && $row['vrequest'] == 1 && $row['rstatus'] != 0 && $row['ass_request'] == 0) {
                    if ($row['rstatus'] == 108)
                        $vst = 'Inputs Required';
                    else if ($row['rstatus'] == 110)
                        $vst = 'Stop Check';
                    else if ($row['rstatus'] == 109)
                        $vst = 'Awaiting Authorisation';
                    else if ($row['rstatus'] == 107)
                        $vst = 'Initiated';
                    else if ($row['rstatus'] == 519)
                        $vst = 'Others';
                    else if ($row['rstatus'] == 684)
                        $vst = 'Request Raised';
                    else if ($row['rstatus'] == 992)
                        $vst = 'DD applied';

                    if ($row['rstatus'] == 110 || $row['rstatus'] == 519) {
                        $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    } else {
                        $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">' . $vst . '</p>', 'target="_blank"');
                    }

                    $requesttoass = '';
                } else if ($row['verify_status'] == '111' && $row['vrequest'] == 1 && $row['rstatus'] != 0 && $row['ass_request'] == 0) {
                    if ($row['rstatus'] == 108)
                        $vst = 'Inputs Required';
                    else if ($row['rstatus'] == 110)
                        $vst = 'Stop Check';
                    else if ($row['rstatus'] == 109)
                        $vst = 'Awaiting Authorisation';
                    else if ($row['rstatus'] == 107 && $row['verify_status'] == '111')
                        $vst = 'Verified';
                    else if ($row['rstatus'] == 107)
                        $vst = 'Initiated';
                    else
                        $vst = 'Verified';

                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">' . $vst . '</p>';
                    $requesttoass = '';
                } else if ($row['ass_request'] == 1) {
                    $verifyurl = 'Request Raised';
                    $requesttoass = 'Sent to Associate';
                    $add_calls = '';
                } else {
                    $save['request_id'] = $row['candidate_req_id'];
                    $save['check_id'] = $row['checkId'];
                    $save['level_id'] = $row['level_id'];
                    $this->db->select('count(*) as cnt');
                    $this->db->where($save);
                    $countnoti = $this->db->get(DB_PREFIX . 'notification_emails')->row_array();

                    if ($countnoti['cnt'] >= 1)
                        $vtext = 'Sent Mail to Resource';
                    else
                        $vtext = 'New';




                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $vtext, 'target="_blank"');
                    $vst = $row['status'];
                    $requesttoass = '';
                }
                $slug = url_title(convert_accented_characters($row['checkname']), 'underscore', TRUE);


                if ($row['checkid'] == 14)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'education_details');
                else if ($row['checkid'] == 16)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'contact_details', 'request_id', 'permanent_address');
                else if ($row['checkid'] == 59)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'employment', 'req_id', 'level_id');
                else if ($row['checkid'] == 76 || $row['checkid'] == 77 || $row['checkid'] == 75)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], $slug, 'request_id', 'level_name');
                else
                    $levelnames['level'] = $row['checkname'];

                if ($row['status'] == 'Initiated')
                    $rowstatus = 'Assigned in VM';
                else
                    $rowstatus = $row['status'];
                if ($row['chk'] == 0) {
                    $chkval = $row['checkname'];
                } else {
                    $chkval = $row['checkname'] . $row['chk'];
                }
                if (!empty($status1['name'])) {
                    $stat = $status1['name'] . '-' . $status2['name'] . '-' . $status3['name'] . '' . $status41;
                } else {
                    $stat = '';
                }
                if ($row['checkid'] == 14) {
                    $clgname = $education_details['collegename_add'];
                    $uniname = $education_details['affliated'];
                } else {
                    $clgname = '';
                    $uniname = '';
                }


                if ($row['checkid'] == 59) {
                    $cmpnyname = $company_details['company_name'];
                } else if ($row['checkid'] == 68) {
                    $cmpnyname = $professional_details['company_name'];
                } else {
                    $cmpnyname = '';
                }
                $supplement = '';
                if ($row['supplementary'] == 1 || $row['supplementary'] == 2) {
                    $supplement = 'Reopen';
                } elseif ($row['supplementary'] == 3) {
                    $supplement = 'Reopen-Completed';
                }
                $deadline_from = isset($row['deadline_from']) ? date('d-m-Y', strtotime($row['deadline_from'])) : '';
                $deadline_to = isset($row['deadline_to']) ? date('d-m-Y', strtotime($row['deadline_to'])) : '';

                $v_date = isset($row['v_date']) ? date('d-m-Y', strtotime($row['v_date'])) : '';
                $req_raise_date = isset($row['vm_request_raised_date']) ? date('d-m-Y', strtotime($row['vm_request_raised_date'])) : '';

                $dd_recived =     $qc2verification_data['dd_recevied_form'];

                if ($dd_recived == 1) {
                    $dd_status = 'None';
                } elseif ($dd_recived == 2) {
                    $dd_status = 'University';
                } elseif ($dd_recived == 3) {
                    $dd_status = 'College';
                } elseif ($dd_recived == 4) {
                    $dd_status = 'Company';
                } elseif ($dd_recived == 5) {
                    $dd_status = 'University and College';
                } else {
                    $dd_status = '';
                }

                $veri_received =   $qc2verification_data['veri_received_dropdown'];

                if ($veri_received == 1) {
                    $veri_received_data  = "Recevied";
                } elseif ($veri_received == 2) {
                    $veri_received_data  = "Not received";
                } else {
                    $veri_received_data = '';
                }



                $response->rows[$i]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], anchor('/Dadmin/dadminview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['checkId']), $candidatename), $row['case_no'], $chkval, $verifyurl, $stat, $reqstatus, $rpt_status, $supplement, $cmpnyname, $verification_data['verification_received'], $veri_received_data, $dd_status, $clgname, $uniname, $dd_amount, $verification_data['rti_reference_no'], $procedure_details, $verfier_details, $row['vname'], $deadline_from, $deadline_to, $req_raise_date, $v_date, $row['additional_docs'], anchor('/Dadmin/dadminview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['checkId']), 'View'));
            }
        }
        echo json_encode($response);
    }


    function insertBillDetails($clonecount = 0, $insertValue = '', $marketId = '', $tablename = '', $editId = '', $fId = '', $cId = '', $lId = '')
    {
        if ($editId != 0) {
            $marketId = $editId;
            $rcId = $cId;
            $rlId = $lId;
        }

        $insertsales = array();
        $bulksave = array();
        if (!empty($_FILES['bill_proof']['name'])) {
            if ($clonecount != 0) {
                for ($i = 1; $i <= $clonecount; $i++) {
                    $j = $i;
                    if ($i == 1) {
                        $j = '';
                    }

                    foreach ($insertValue as $value) {
                        switch ($value) {
                            case 'bill_proof':
                            case '':
                                //upload files
                                $this->load->library('Upload');
                                $config['allowed_types'] = 'jpg|png|jpeg|pdf|csv|xls|ppt|doc|docx';
                                $config['upload_path'] = 'uploads/candidate/document/';
                                $config['encrypt_name'] = true;
                                $config['remove_spaces'] = true;
                                $this->load->library('upload', $config);
                                if (!empty($_FILES['bill_proof' . $j . $j]['name'])) {
                                    $this->upload->initialize($config);
                                    if ($this->upload->do_upload('bill_proof' . $j . $j)) {

                                        $upload_data = $this->upload->data();
                                        $image['original'] = $config['upload_path'] . '' . $upload_data['file_name'];
                                        $config['source_image'] = getcwd() . '/uploads/candidate/document/' . $upload_data['file_name'];
                                        $insertsales['bill_proof'] = $image['original'];
                                    }
                                }
                                if ($this->upload->display_errors() != '') {

                                    return $this->upload->display_errors();
                                }

                                $insertsales[$value] = $image['original'];
                                break;

                            default:
                                $insertsales[$value] = $_POST[$value . $j];
                                break;
                        }
                    }
                    $insertsales[$fId] = $marketId;
                    $insertsales['check_id'] = $cId;
                    $insertsales['level_id'] = $lId;
                    $insertsales['status'] = '1';
                    $bulksave[] = $insertsales;
                }
                $this->db->insert_batch($this->config->item('table_prefix') . $tablename, $bulksave);
            }
        }
        return 1;
    }

    /********* VM New Case Lists ************
     ******* function vm_newcaselist *********
     *****************************************/
    function vm_newcaselist()
    {

        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));

        $title = base64_decode($this->uri->segment(3));
        if ($title == 'New') {
            $Newtitle = 'New';
        } else if ($title == 'NewOverdue') {
            $Newtitle = 'Overdue';
        } else if ($title == 'NewDueTday') {
            $Newtitle = 'Due Today';
        } else if ($title == 'NewDueNext5day') {
            $Newtitle = 'Due in Next 5 Days';
        } else if ($title == 'NewDueNext6dayPlus') {
            $Newtitle = 'Due in Next 6+ Days';
        } else if ($title == 'Initiated') {
            $Newtitle = 'Initiated';
        } else if ($title == 'InitiatedOverdue') {
            $Newtitle = 'Overdue';
        } else if ($title == 'InitiatedDueTday') {
            $Newtitle = 'Due Today';
        } else if ($title == 'InitiateDueNext5day') {
            $Newtitle = 'Due in Next 5 Days';
        } else if ($title == 'InitiateDueNext6dayPlus') {
            $Newtitle = 'Due in Next 6+ Days';
        } else if ($title == 'RevertAssigned') {
            $Newtitle = 'Revert Assigned';
        } else if ($title == 'RevertAssignedOverdue') {
            $Newtitle = 'Overdue';
        } else if ($title == 'RevertAssignedDueTday') {
            $Newtitle = 'Due Today';
        } else if ($title == 'RevertAssignedDueNext5day') {
            $Newtitle = 'Due in Next 5 Days';
        } else if ($title == 'RevertAssignedDueNext6dayPlus') {
            $Newtitle = 'Due in Next 6+ Days';
        } else if ($title == 'RevertRaised') {
            $Newtitle = 'Revert Raised';
        } else if ($title == 'RevertRaisedOverdue') {
            $Newtitle = 'Overdue';
        } else if ($title == 'RevertRaisedDueTday') {
            $Newtitle = 'Due Today';
        } else if ($title == 'RevertRaisedDueNext5day') {
            $Newtitle = 'Due in Next 5 Days';
        } else if ($title == 'RevertRaisedDueNext6dayPlus') {
            $Newtitle = 'Due in Next 6+ Days';
        } else if ($title == 'RevertClosed') {
            $Newtitle = 'Revert Closed';
        } else if ($title == 'RevertClosedOverdue') {
            $Newtitle = 'Overdue';
        } else if ($title == 'RevertClosedDueTday') {
            $Newtitle = 'Due Today';
        } else if ($title == 'RevertClosedDueNext5day') {
            $Newtitle = 'Due in Next 5 Days';
        } else if ($title == 'RevertClosedDueNext6dayPlus') {
            $Newtitle = 'Due in Next 6+ Days';
        } else if ($title == 'RequestRaised') {
            $Newtitle = 'Request Raised';
        } else if ($title == 'RequestRaisedOverdue') {
            $Newtitle = 'Overdue';
        } else if ($title == 'RequestRaisedDueTday') {
            $Newtitle = 'Due Today';
        } else if ($title == 'RequestRaisedDueNext5day') {
            $Newtitle = 'Due in Next 5 Days';
        } else if ($title == 'RequestRaisedDueNext6dayPlus') {
            $Newtitle = 'Due in Next 6+ Days';
        } else if ($title == 'DDApplied') {
            $Newtitle = 'DD Applied';
        } else if ($title == 'DDAppliedOverdue') {
            $Newtitle = 'Overdue';
        } else if ($title == 'DDAppliedDueTday') {
            $Newtitle = 'Due Today';
        } else if ($title == 'DDAppliedDueNext5day') {
            $Newtitle = 'Due in Next 5 Days';
        } else if ($title == 'DDAppliedDueNext6dayPlus') {
            $Newtitle = 'Due in Next 6+ Days';
        } else if ($title == 'ReopenAssigned') {
            $Newtitle = 'Reopen Assigned';
        } else if ($title == 'ReopenAssignedOverdue') {
            $Newtitle = 'Overdue';
        } else if ($title == 'ReopenAssignedDueTday') {
            $Newtitle = 'Due Today';
        } else if ($title == 'ReopenAssignedDueNext5day') {
            $Newtitle = 'Due in Next 5 Days';
        } else if ($title == 'ReopenAssignedDueNext6dayPlus') {
            $Newtitle = 'Due in Next 6+ Days';
        } else {
            $Newtitle = '';
        }


        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push("VM " . $Newtitle . " List", 'Verification/new');

        $data['new_title'] = $Newtitle;
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'vm_newcaselist');
    }

    function get_newverificationlist()
    {

        $model = array('Verification_model' => 'get_newuserlistverification');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        //$a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $company_name = ($_REQUEST['company_name']) ? $_REQUEST['company_name'] : '';
        $college_name = ($_REQUEST['college_name']) ? $_REQUEST['college_name'] : '';
        $university_name = ($_REQUEST['university_name']) ? $_REQUEST['university_name'] : '';
        $verifier_name = ($_REQUEST['verifier_name']) ? $_REQUEST['verifier_name'] : '';
        $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $request_status = ($_REQUEST['request_status']) ? $_REQUEST['request_status'] : '';
        $chk_status = ($_REQUEST['chk_status']) ? $_REQUEST['chk_status'] : '';
        $verified_status = ($_REQUEST['verified_status']) ? $_REQUEST['verified_status'] : '';

        $reopen_status = ($_REQUEST['reopen_status']) ? $_REQUEST['reopen_status'] : '';
        $additional_docs = ($_REQUEST['additional_docs']) ? $_REQUEST['additional_docs'] : '';
        $check_count = ($_REQUEST['check_count']) ? $_REQUEST['check_count'] : '';
        $date_filter = ($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
        $check_type  = ($_REQUEST['check_type']) ? $_REQUEST['check_type'] : '';
        $userId  = ($_REQUEST['userId']) ? $_REQUEST['userId'] : '';


        if (!empty($userId)) {
            $condition[] = " a.team_mem_id = " . $userId;
        } else {
            $condition[] = " a.team_mem_id = " . $this->session->userdata['userid'];
        }

        if ($org_id)
            $condition[] = " o.id = " . $org_id;
        if ($office)
            $condition[] = " br.id = " . $office;
        if ($parent_office)
            $condition[] = " p.id = " . $parent_office;
        if ($sub_office)
            $condition[] = " su.id = " . $sub_office;
        if ($name)
            $condition[] = "b.firstname like '%" . $name . "%' ";
        if ($check_name)
            $condition[] = "c.name like '%" . $check_name . "%' ";
        if ($company_name)
            $condition[] = "((em.company_name like '%" . $company_name . "%'  and a.check_id = 59) || (pr.company_name like '%" . $company_name . "%'  and a.check_id = 68))";
        if ($college_name)
            $condition[] = "(ed.collegename_add like '%" . $college_name . "%'  and a.check_id = 14)";
        if ($university_name)
            $condition[] = "(ed.affliated like '%" . $university_name . "%'  and a.check_id = 14)";
        //17/01/2024
        $case_no = trim($case_no);
        if ($case_no)
            $condition[] = "d.case_no like '%" . $case_no . "' ";
        if ($verifier_name)
            $condition[] = "(concat_ws(' ',us.first_name,us.last_name) like '%" . $verifier_name . "%') ";
        if ($c_date && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(vr.deadline_from ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "'";
        }
        if ($t_date && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(vr.deadline_from ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }
        if ($c_date && $date_filter == 2) {
            $condition[] = "DATE_FORMAT(vr.deadline_to ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "'";
        }
        if ($t_date && $date_filter == 2) {
            $condition[] = "DATE_FORMAT(vr.deadline_to ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }
        if ($c_date && $date_filter == 3) {
            $condition[] = "DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "'";
        }
        if ($t_date && $date_filter == 3) {
            $condition[] = "DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }
        if ($request_status)
            $condition[] = " vl1.reqstatus = " . $request_status;
        if ($chk_status == 1) {
            $condition[] = " (vl1.vm_discrepency in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701)) ";
        }
        if ($chk_status == 2) {
            $condition[] = " ((vl1.vm_discrepency in (120,131,137,143,713,119,130,136,142)) or (a.verify_status in (519,110))  or (vl1.vm_discrepency in (1005)))";
        }
        if ($chk_status == 3) {
            $condition[] = " (vl1.vm_discrepency in (116,127,134,140,630,121,125,658,662,660,789)) ";
        }
        if ($reopen_status == 1) {
            $condition[] = " vl1.supplementary in (1,2) ";
        }
        if ($reopen_status == 2) {
            $condition[] = " vl1.supplementary = 3 ";
        }
        if ($additional_docs == 1) {
            $condition[] = " a.additional_docs is NOT NULL ";
        }
        if ($additional_docs == 2) {
            $condition[] = " a.additional_docs is NULL ";
        }
        if ($verified_status == 1) {
            $condition[] = " (vl1.vm_discrepency in (116,127,134,140,630)) ";
        }
        if ($verified_status == 2) {
            $condition[] = " (vl1.vm_discrepency in (121)) ";
        }
        if ($verified_status == 3) {
            $condition[] = " (vl1.vm_discrepency in (122)) ";
        }
        if ($verified_status == 4) {
            $condition[] = " (vl1.vm_discrepency in (129,135,141,701,139,701,118)) ";
        }
        if ($verified_status == 5) {
            $condition[] = " (vl1.vm_discrepency in (117,126)) ";
        }
        if ($verified_status == 6) {
            $condition[] = " ((vl1.vm_discrepency in (119,130,136,142)) or (a.verify_status in (110)))";
        }
        if ($verified_status == 7) {
            $condition[] = " ((vl1.vm_discrepency in (120,131,137,143,713)) or (a.verify_status in (519)))";
        }
        // if($reminder){
        //        		$condition[]="adc.email_count =  ".$reminder." ";
        // }

        if ($check_type == 1)
            $condition[] = "c.id = 15";
        if ($check_type == 2)
            $condition[] = "c.id = 16";
        if ($check_type == 3)
            $condition[] = "c.id = 71";
        if ($check_type == 4)
            $condition[] = "c.id = 639";
        if ($check_type == 5)
            $condition[] = "c.id = 640";
        if ($check_type == 6)
            $condition[] = "c.id = 636";
        if ($check_type == 7)
            $condition[] = "c.id = 75";
        /**************** New *****************/
        $dateDiff = "(5 * (DATEDIFF(CURDATE(), date(vr.deadline_from)) DIV 7) + MID('0123444401233334012222340111123400012345001234550', 7 * WEEKDAY(date(vr.deadline_from)) + WEEKDAY(CURDATE()) + 1, 1)) - (SELECT COUNT(*) FROM dcode_master_holidays WHERE status=1 and  holiday_date >= date(vr.deadline_from) and holiday_date <= CURDATE())";

        if ($check_count == 'New') {
            $condition[] = "a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0 ";
        } else if ($check_count == 'NewOverdue') {
            $condition[] = " a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0 and (" . $dateDiff . " > ct.verification_tat) ";
        } else if ($check_count == 'NewDueTday') {
            $condition[] = " a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0  and (" . $dateDiff . " = ct.verification_tat) ";
        } else if ($check_count == 'NewDueNext5day') {
            $condition[] = " a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0 and ((" . $dateDiff . " < ct.verification_tat) and " . $dateDiff . " > (ct.verification_tat) - 5) ";
        } else if ($check_count == 'NewDueNext6dayPlus') {
            $condition[] = " a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0 and (" . $dateDiff . " <= (ct.verification_tat) - 5) ";
        }
        /**************** Initiated *****************/
        else if ($check_count == 'Initiated') {
            $condition[] = " (a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107 )";
        } else if ($check_count == 'InitiatedOverdue') {
            $condition[] = " (a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107  and (" . $dateDiff . " > ct.verification_tat) )";
        } else if ($check_count == 'InitiatedDueTday') {
            $condition[] = " (a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107  and (" . $dateDiff . " = ct.verification_tat) )";
        } else if ($check_count == 'InitiateDueNext5day') {
            $condition[] = " (a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107 and ((" . $dateDiff . " < ct.verification_tat) and " . $dateDiff . " > (ct.verification_tat) - 5) )";
        } else if ($check_count == 'InitiateDueNext6dayPlus') {
            $condition[] = " (a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107 and (" . $dateDiff . " <= (ct.verification_tat) - 5) )";
        }
        /**************** RevertAssigned *****************/
        else if ($check_count == 'RevertAssigned') {
            $condition[] = "(a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1 )";
        } else if ($check_count == 'RevertAssignedOverdue') {
            $condition[] = "(a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1 and (" . $dateDiff . " > ct.verification_tat) )";
        } else if ($check_count == 'RevertAssignedDueTday') {
            $condition[] = "(a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1 and (" . $dateDiff . " = ct.verification_tat) )";
        } else if ($check_count == 'RevertAssignedDueNext5day') {
            $condition[] = "(a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1 and ((" . $dateDiff . " < ct.verification_tat) and " . $dateDiff . " > (ct.verification_tat) - 5) )";
        } else if ($check_count == 'RevertAssignedDueNext6dayPlus') {
            $condition[] = "(a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1 and (" . $dateDiff . " <= (ct.verification_tat) - 5) and vr.deadline_from !='')";
        }
        /**************** RevertRaised *****************/
        else if ($check_count == 'RevertRaised') {
            $condition[] = "s.vm_revert_option_status = 1 and a.vm_revert_to = 2 ";
        } else if ($check_count == 'RevertRaisedOverdue') {
            $condition[] = "s.vm_revert_option_status = 1 and a.vm_revert_to = 2 and (" . $dateDiff . " > ct.verification_tat) ";
        } else if ($check_count == 'RevertRaisedDueTday') {
            $condition[] = "s.vm_revert_option_status = 1 and a.vm_revert_to = 2 and (" . $dateDiff . " = ct.verification_tat) ";
        } else if ($check_count == 'RevertRaisedDueNext5day') {
            $condition[] = "s.vm_revert_option_status = 1 and a.vm_revert_to = 2  and ((" . $dateDiff . " < ct.verification_tat) and " . $dateDiff . " > (ct.verification_tat) - 5) ";
        } else if ($check_count == 'RevertRaisedDueNext6dayPlus') {
            $condition[] = "s.vm_revert_option_status = 1 and a.vm_revert_to = 2 and (" . $dateDiff . " <= (ct.verification_tat) - 5) ";
        }
        /**************** RevertClosed *****************/
        else if ($check_count == 'RevertClosed') {
            $condition[] = " (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111) ";
        } else if ($check_count == 'RevertClosedOverdue') {
            $condition[] = " (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111) and (" . $dateDiff . " > ct.verification_tat) ";
        } else if ($check_count == 'RevertClosedDueTday') {
            $condition[] = " (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111) and (" . $dateDiff . " = ct.verification_tat) ";
        } else if ($check_count == 'RevertClosedDueNext5day') {
            $condition[] = " (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111) and ((" . $dateDiff . " < ct.verification_tat) and " . $dateDiff . " > (ct.verification_tat) - 5) ";
        } else if ($check_count == 'RevertClosedDueNext6dayPlus') {
            $condition[] = " (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111) and (" . $dateDiff . " <= (ct.verification_tat) - 5) ";
        }
        /**************** RequestRaised *****************/
        else if ($check_count == 'RequestRaised') {
            $condition[] = " a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1 ";
        } else if ($check_count == 'RequestRaisedOverdue') {
            $condition[] = " a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1 and (" . $dateDiff . " > ct.verification_tat) ";
        } else if ($check_count == 'RequestRaisedDueTday') {
            $condition[] = " a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1 and (" . $dateDiff . " = ct.verification_tat) ";
        } else if ($check_count == 'RequestRaisedDueNext5day') {
            $condition[] = " a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1 and ((" . $dateDiff . " < ct.verification_tat) and " . $dateDiff . " > (ct.verification_tat) - 5) ";
        } else if ($check_count == 'RequestRaisedDueNext6dayPlus') {
            $condition[] = " a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1 and (" . $dateDiff . " <= (ct.verification_tat) - 5) ";
        }
        /**************** DDApplied *****************/
        else if ($check_count == 'DDApplied') {
            $condition[] = " a.verify_status = 992 and a.qc_revert_request !=1 ";
        } else if ($check_count == 'DDAppliedOverdue') {
            $condition[] = " a.verify_status = 992 and a.qc_revert_request !=1 and (" . $dateDiff . " > ct.verification_tat) ";
        } else if ($check_count == 'DDAppliedDueTday') {
            $condition[] = " a.verify_status = 992 and a.qc_revert_request !=1 and (" . $dateDiff . " = ct.verification_tat) ";
        } else if ($check_count == 'DDAppliedDueNext5day') {
            $condition[] = " a.verify_status = 992 and a.qc_revert_request !=1 and ((" . $dateDiff . " < ct.verification_tat) and " . $dateDiff . " > (ct.verification_tat) - 5) ";
        } else if ($check_count == 'DDAppliedDueNext6dayPlus') {
            $condition[] = " a.verify_status = 992 and a.qc_revert_request !=1 and (" . $dateDiff . " <= (ct.verification_tat) - 5) ";
        }

        /**************** ReopenAssigned *****************/
        else if ($check_count == 'ReopenAssigned') {
            $condition[] = "(a.qc_revert_request =1 and a.vm_assigned_qc=0 and vl1.supplementary=1 )";
        } else if ($check_count == 'ReopenAssignedOverdue') {
            $condition[] = "(a.qc_revert_request =1 and a.vm_assigned_qc=0 and vl1.supplementary=1 and (" . $dateDiff . " > ct.verification_tat) )";
        } else if ($check_count == 'ReopenAssignedDueTday') {
            $condition[] = "(a.qc_revert_request =1 and a.vm_assigned_qc=0 and vl1.supplementary=1 and (" . $dateDiff . " = ct.verification_tat) )";
        } else if ($check_count == 'ReopenAssignedDueNext5day') {
            $condition[] = "(a.qc_revert_request =1 and a.vm_assigned_qc=0 and vl1.supplementary=1 and ((" . $dateDiff . " < ct.verification_tat) and " . $dateDiff . " > (ct.verification_tat) - 5) )";
        } else if ($check_count == 'ReopenAssignedDueNext6dayPlus') {
            $condition[] = "(a.qc_revert_request =1 and a.vm_assigned_qc=0 and vl1.supplementary=1 and (" . $dateDiff . " <= (ct.verification_tat) - 5) and vr.deadline_from !='')";
        } else if ($check_count == 'AllChecks') {
            $condition[] = "( (a.qc_revert_request = 1 or a.qc_revert_request != 1 ) and a.vm_assigned_qc!=1) and ((a.verify_status not in (110,111,519)) or (a.qc_revert_request = 0 or a.qc_revert_request != 0) and a.ass_request=0)";
        } else if ($check_count == 'AllOverDue') {
            $condition[] = "( (a.qc_revert_request = 1 or a.qc_revert_request != 1 ) and a.vm_assigned_qc!=1) and ((a.verify_status not in (110,111,519)) and a.ass_request=0 or a.qc_revert_request = 0 or a.qc_revert_request != 0) and (DATEDIFF(CURDATE(), vr.deadline_from) > ct.verification_tat) ";
        } else {

            if ($check_count && $this->session->userdata['role_id'] == 5) {
                $rep_id = " (SELECT  GROUP_CONCAT(ar.rep_id) as verifier from dcode_ver_assign_rep ar
		      where ar.team_mem_id=" . $this->session->userdata['userid'] . " and (ar.verify_status =107 or ar.vm_assigned_qc=0 or ar.verify_status =684 ) group by ar.candidate_req_id having count(ar.candidate_req_id)=" . $check_count . ")";
                $rid = $this->db->query($rep_id)->result_array();
                foreach ($rid as  $rvalue) {
                    $verifier_ids[] = $rvalue['verifier'];
                }
                $condition[] = " a.rep_id in (" . implode(',', $verifier_ids) . " )";
            }
            if ($check_count && (in_array($this->session->userdata['role_id'], array(1, 9, 21, 24)))) {
                $rep_id = " (SELECT  GROUP_CONCAT(ar.rep_id) as verifier from dcode_ver_assign_rep ar
		      where (ar.verify_status =107 or ar.vm_assigned_qc=0 or ar.verify_status =684 ) group by ar.candidate_req_id having count(ar.candidate_req_id)=" . $check_count . ")";
                $rid = $this->db->query($rep_id)->result_array();
                foreach ($rid as  $rvalue) {
                    $verifier_ids[] = $rvalue['verifier'];
                }
                $condition[] = " a.rep_id in (" . implode(',', $verifier_ids) . " )";
            }
        }

        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.firstname " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " b.lastname " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " f.order_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vs.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " o.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " p.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " su.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " br.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " ed.collegename_add " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " ed.affliated " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " em.company_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " pr.company_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vr.deadline_from " . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";
                $like    .= $operator . " vr.deadline_to " . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";

                $like    .= $operator . " c.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " verify_status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.additional_docs " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.vm_revert_status " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }
        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $checkteam = $this->config->item('CHECKLIST', APPLICATIONCONFIG);
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            $k = 1;

            foreach ($result as $i => $row) {
                $company_details = $this->vm->get_verifiedcompany_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);
                $education_details = $this->vm->get_verifiedcollege_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);
                $professional_details = $this->vm->get_verifiedprofessional_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);

                $verified_data = $this->vm->get_verified_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);
                $verification_data = toArray(json_decode($verified_data['fielddata']));
                $vm_expenses  = toArray(json_decode($verified_data['vmexpenses']));
                $qc2verification_data = toArray(json_decode($verified_data['qc2fielddata']));

                if ($vm_expenses <> null) {


                    if ($vm_expenses[0]['ddcurrency']) {

                        $ddcurrencyid =   $vm_expenses[0]['ddcurrency'];

                        $results = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'currencykey', 'id' => $ddcurrencyid));

                        $currencyname =   $results[0]['name'];
                    } else {
                        $currencyname = '';
                    }

                    $d_amount = 0;
                    foreach ($vm_expenses as $key => $dd_exprenses) {

                        $d_amount += $dd_exprenses['amount'];
                    }

                    $dd_amount = $currencyname . ' ' . $d_amount;
                } else {
                    $dd_amount = '';
                }


                $status1 = $this->vm->get_status($verification_data['status']);
                $status4 = '';
                $status2 = $this->vm->get_status($verification_data['pstatus']);
                $status3 = $this->vm->get_status($verification_data['status1']);
                if ($verification_data['ostatus'] <> '') {
                    $status4 = $this->vm->get_status($verification_data['ostatus']);
                    $status4_id = $verification_data['ostatus']; //  Dec 13th
                }
                if ($verification_data['dstatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['dstatus']);
                if (!empty($status4))
                    $status41 = '-' . $status4['name'];
                else
                    $status41 = '';

                $reqstatus = '';
                if (!empty($row['reqstatus'])) {
                    $req_raised_status =    $this->vm->get_status($row['reqstatus']);
                    $reqstatus = $req_raised_status['name'];
                }
                $rpt_status = '';


                /********************* PF_Verification *************************************/
                if ($row['checkId'] == 652) {
                    if ($verification_data['status'] != 107 && $verification_data['status'] != 684 && !empty($verification_data['status'])) {
                        if ($status3['name'] == "Multiple Active Records" || $status3['name'] == "Discrepant" || $status3['name'] == "Possible Discrepant" || $status3['name'] == "Record Found" || $status3['name'] == "Positive" || $status3['name'] == "Invalid" || $status3['name'] == "Not Completed" || $status3['name'] == "High Risk") {
                            $rpt_status = "<span style='color:red;'>RED</span>";
                        }
                        // Dec 15th
                        else if ($status3['name'] == "No Records" || $status1['name'] == "Stop Check" || $status3['name'] == "Stop Check" || $status3['name'] == "Others" || $status3['name'] == "Possible Match" || $status3['name'] == "Partial Match" || ($status1['name'] == "Others" && ($status4_id != 750 && $status4_id != 699))) {
                            $rpt_status = "<span style='color:orange;'>ORANGE</span>";
                        }
                        //  Dec 13th
                        else if ($status1['name'] == "Others" && ($status4_id == 750 || $status4_id == 699)) {
                            $rpt_status = "<span style='color:green;'>GREEN</span>";
                        }
                        /** Aug 24th **/
                        else {
                            $rpt_status = "<span style='color:green;'>GREEN</span>";
                        }
                    }
                }

                /********************* PF_Verification *************************************/
                else {  // Other Checks


                    if ($verification_data['status'] != 107 && $verification_data['status'] != 684 && $verification_data['status'] != 992 && !empty($verification_data['status'])) {
                        if ($status3['name'] == "Discrepant" || $status3['name'] == "Possible Discrepant" || $status3['name'] == "Record Found" || $status3['name'] == "Positive" || $status3['name'] == "No Records" || $status3['name'] == "Invalid" || $status3['name'] == "Not Completed" || $status3['name'] == "High Risk") {
                            $rpt_status = "<span style='color:red;'>RED</span>";
                        }
                        // Dec 15th
                        else if ($status3['name'] == "No Records" || $status1['name'] == "Stop Check" || $status3['name'] == "Stop Check" || $status3['name'] == "Others" || $status3['name'] == "Possible Match" || $status3['name'] == "Partial Match" || ($status1['name'] == "Others" && ($status4_id != 750 && $status4_id != 699))) {
                            $rpt_status = "<span style='color:orange;'>ORANGE</span>";
                        }
                        //  Dec 13th
                        else if ($status1['name'] == "Others" && ($status4_id == 750 || $status4_id == 699)) {
                            $rpt_status = "<span style='color:green;'>GREEN</span>";
                        } else {
                            $rpt_status = "<span style='color:green;'>GREEN</span>";
                        }
                    }
                }
                $checkstatus = $this->vm->getstatus_of_can($row['candidate_req_id'], $row['checkId']);
                $checkadminstatus = $this->vm->get_currentstatus($row['candidate_req_id']);
                $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');

                $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');

                $candidatename = $row['candidatename'];
                if ($row['vm_revert_option_status'] == 1 && $row['vm_revert_to'] == 2) {
                    $verifyurl = 'Revert Raised to DEO';
                } else if ($row['qc_revert_request'] == 1) {
                    if ($row['vm_assigned_qc'] == 1 && $row['verify_status'] <> 107 && $row['verify_status'] <> 684 && $row['verify_status'] <> 992) {
                        $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                        $verifyurl = 'Revert Rectified';
                    }
                    // else if($row['vm_assigned_qc']==0 && $row['ass_request']==0 && $row['supplementary']==1 && $row['qc_revert_request']==1 && $row['reopen_revert_qc']==0 && $row['reopen_revert_qc2']==1 ){
                    // $verifyurl = anchor('/Verification/revert_raisedsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),'Reopen Assigned','target="_blank"');
                    // }

                    //  Edited on 16th Jan '23 to include .'/'.base64_encode(1004) in the link for reopen cases
                    else if ($row['vm_assigned_qc'] == 0 && $row['ass_request'] == 0 && $row['supplementary'] == 1 && $row['qc_revert_request'] == 1 && $row['reopen_revert_qc'] == 0 && $row['reopen_revert_qc2'] == 1) {
                        $verifyurl = anchor('/Verification/revert_raisedsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']) . '/' . base64_encode(1004), 'Reopen Assigned', 'target="_blank"');
                    }

                    // else if($row['vm_assigned_qc']==0 && $row['ass_request']==0 && $row['supplementary']==1 && $row['qc_revert_request']==1 && $row['reopen_revert_qc']==1 && $row['reopen_revert_qc2']==1 ){
                    // $verifyurl = anchor('/Verification/revert_raisedsview/'.base64_encode($row['candidate_req_id']).'/'.base64_encode($row['level_id']).'/'.base64_encode($row['checkId']).'/'.base64_encode($row['pack_id']),'Reopen Assigned','target="_blank"');
                    // }

                    //  Edited on 16th Jan '23 to include .'/'.base64_encode(1004) in the link for reopen cases
                    else if ($row['vm_assigned_qc'] == 0 && $row['ass_request'] == 0 && $row['supplementary'] == 1 && $row['qc_revert_request'] == 1 && $row['reopen_revert_qc'] == 1 && $row['reopen_revert_qc2'] == 1) {
                        $verifyurl = anchor('/Verification/revert_raisedsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']) . '/' . base64_encode(1004), 'Reopen Assigned', 'target="_blank"');
                    } else {
                        $verifyurl = anchor('/Verification/revert_raisedsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Assigned', 'target="_blank"');
                    }
                } elseif ($row['verify_status'] == 111 && $row['vrequest'] == 0 && $row['ass_request'] == 0) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 3 && $row['vm_revert_to'] == 2) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_option_status'] == 3 && $row['vm_revert_to'] == 2) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 4 && $row['operator_submited_by'] == 12 || $row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 4 && $checkadminstatus['role_id'] == 13) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_option_status'] == 4 && $row['operator_submited_by'] == 12 || $row['vm_revert_option_status'] == 4 && $checkadminstatus['role_id'] == 13) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_to'] == 3 && $row['vm_revert_supervisor'] == 0) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_to'] == 3 && $row['vm_revert_supervisor'] == 0) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] <> '111' && $row['vrequest'] == 1 && $row['rstatus'] != 0 && $row['ass_request'] == 0) {
                    if ($row['rstatus'] == 108)
                        $vst = 'Inputs Required';
                    else if ($row['rstatus'] == 110)
                        $vst = 'Stop Check';
                    else if ($row['rstatus'] == 109)
                        $vst = 'Awaiting Authorisation';
                    else if ($row['rstatus'] == 107)
                        $vst = 'Initiated';
                    else if ($row['rstatus'] == 519)
                        $vst = 'Others';
                    else if ($row['rstatus'] == 684)
                        $vst = 'Request Raised';
                    else if ($row['rstatus'] == 992)
                        $vst = 'DD applied';

                    if ($row['rstatus'] == 110 || $row['rstatus'] == 519) {
                        $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    } else {
                        $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">' . $vst . '</p>', 'target="_blank"');
                    }

                    $requesttoass = '';
                } else if ($row['verify_status'] == '111' && $row['vrequest'] == 1 && $row['rstatus'] != 0 && $row['ass_request'] == 0) {
                    if ($row['rstatus'] == 108)
                        $vst = 'Inputs Required';
                    else if ($row['rstatus'] == 110)
                        $vst = 'Stop Check';
                    else if ($row['rstatus'] == 109)
                        $vst = 'Awaiting Authorisation';
                    else if ($row['rstatus'] == 107 && $row['verify_status'] == '111')
                        $vst = 'Verified';
                    else if ($row['rstatus'] == 107)
                        $vst = 'Initiated';
                    else
                        $vst = 'Verified';

                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">' . $vst . '</p>';
                    $requesttoass = '';
                } else if ($row['ass_request'] == 1) {
                    $verifyurl = 'Request Raised';
                    $requesttoass = 'Sent to Associate';
                    $add_calls = '';
                } else {
                    $save['request_id'] = $row['candidate_req_id'];
                    $save['check_id'] = $row['checkId'];
                    $save['level_id'] = $row['level_id'];
                    $this->db->select('count(*) as cnt');
                    $this->db->where($save);
                    $countnoti = $this->db->get(DB_PREFIX . 'notification_emails')->row_array();

                    if ($countnoti['cnt'] >= 1)
                        $vtext = 'Sent Mail to Resource';
                    else
                        $vtext = 'New';




                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $vtext, 'target="_blank"');
                    $vst = $row['status'];
                    $requesttoass = '';
                }
                $slug = url_title(convert_accented_characters($row['checkname']), 'underscore', TRUE);


                if ($row['checkid'] == 14)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'education_details');
                else if ($row['checkid'] == 16)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'contact_details', 'request_id', 'permanent_address');
                else if ($row['checkid'] == 59)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'employment', 'req_id', 'level_id');
                else if ($row['checkid'] == 76 || $row['checkid'] == 77 || $row['checkid'] == 75)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], $slug, 'request_id', 'level_name');
                else
                    $levelnames['level'] = $row['checkname'];

                if ($row['status'] == 'Initiated')
                    $rowstatus = 'Assigned in VM';
                else
                    $rowstatus = $row['status'];
                if ($row['chk'] == 0) {
                    $chkval = $row['checkname'];
                } else {
                    $chkval = $row['checkname'] . $row['chk'];
                }
                if (!empty($status1['name'])) {
                    $stat = $status1['name'] . '-' . $status2['name'] . '-' . $status3['name'] . '' . $status41;
                } else {
                    $stat = '';
                }
                if ($row['checkid'] == 14) {
                    $clgname = $education_details['collegename_add'];
                    $uniname = $education_details['affliated'];
                } else {
                    $clgname = '';
                    $uniname = '';
                }


                if ($row['checkid'] == 59) {
                    $cmpnyname = $company_details['company_name'];
                } else if ($row['checkid'] == 68) {
                    $cmpnyname = $professional_details['company_name'];
                } else {
                    $cmpnyname = '';
                }
                $supplement = '';
                if ($row['supplementary'] == 1 || $row['supplementary'] == 2) {
                    $supplement = 'Reopen';
                } elseif ($row['supplementary'] == 3) {
                    $supplement = 'Reopen-Completed';
                }
                $deadline_from = isset($row['deadline_from']) ? date('d-m-Y', strtotime($row['deadline_from'])) : '';
                $deadline_to = isset($row['deadline_to']) ? date('d-m-Y', strtotime($row['deadline_to'])) : '';

                $v_date = isset($row['v_date']) ? date('d-m-Y', strtotime($row['v_date'])) : '';
                $req_raise_date = isset($row['vm_request_raised_date']) ? date('d-m-Y', strtotime($row['vm_request_raised_date'])) : '';

                $dd_recived =     $qc2verification_data['dd_recevied_form'];

                if ($dd_recived == 1) {
                    $dd_status = 'None';
                } elseif ($dd_recived == 2) {
                    $dd_status = 'University';
                } elseif ($dd_recived == 3) {
                    $dd_status = 'College';
                } elseif ($dd_recived == 4) {
                    $dd_status = 'Company';
                } elseif ($dd_recived == 5) {
                    $dd_status = 'University and College';
                } else {
                    $dd_status = '';
                }

                $veri_received =   $qc2verification_data['veri_received_dropdown'];

                if ($veri_received == 1) {
                    $veri_received_data  = "Recevied";
                } elseif ($veri_received == 2) {
                    $veri_received_data  = "Not received";
                } else {
                    $veri_received_data = '';
                }


                // Edited on 05/04/2023  .by Amritha --- ticket status column added 
                if ($row['ticket_status'] == 1) {
                    $tktStatus = 'Open';
                } else if ($row['ticket_status'] == 2) {
                    $tktStatus = 'Requested';
                } else if ($row['ticket_status'] == 3) {
                    $tktStatus = 'Revert';
                } else if ($row['ticket_status'] == 4) {
                    $tktStatus = 'Re-Requested';
                } else if ($row['ticket_status'] == 5) {
                    $tktStatus = 'Re-Open';
                } else if ($row['ticket_status'] == 101) {
                    $tktStatus = 'Closed';
                } else {
                    $tktStatus = '';
                }
                $startDate = date('Y-m-d', strtotime($row['requested_date']));
                $endDate = date('Y-m-d');
                $workingDays = $this->number_of_working_days($startDate, $endDate);
                if (($row['ticket_status'] == 2 && $workingDays > 7) || ($row['ticket_status'] == 4 && $workingDays > 7) || ($row['ticket_status'] == 3 || $row['ticket_status'] == 101) && $row['rstatus'] == 684) {
                    $tktStatus = "<span style='background-color:yellow;'>" . $tktStatus . "</span>";
                } else if (($row['ticket_status'] == 2 && $workingDays > 7) || ($row['ticket_status'] == 4 && $workingDays > 7) || ($row['ticket_status'] == 3 || $row['ticket_status'] == 101) && ($row['qc_revert_request'] == 1 && $row['verify_status'] == 684)) {
                    $tktStatus = "<span style='background-color:yellow;'>" . $tktStatus . "</span>";
                } else if ($row['rstatus'] != 684) {
                    $tktStatus = '';
                } else if ($row['qc_revert_request'] != 1 && $row['verify_status'] != 684) {
                    $tktStatus = '';
                } else {
                    $tktStatus = $tktStatus;
                }





                $response->rows[$i]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], anchor('/Dadmin/dadminview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['checkId']), $candidatename), $row['case_no'], $chkval, $verifyurl, $tktStatus, $stat, $row['Days'], $reqstatus, $rpt_status, $supplement, $cmpnyname, $verification_data['verification_received'], $veri_received_data, $dd_status, $clgname, $uniname, $dd_amount, $verification_data['rti_reference_no'], $procedure_details, $verfier_details, $row['vname'], $deadline_from, $deadline_to, $row['verification_tat'], $req_raise_date, $v_date, $row['additional_docs'], anchor('/Dadmin/dadminview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['checkId']), 'View'));
            }
        }
        echo json_encode($response);
    }


    /*****************
     * Request Raised list VM page
     * request_raised_vm
     ******************/
    function request_raised_vm()
    {
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Request Raised List', 'Verification/request_raised_vm');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'request_raised_vm');
    }

    /*****************
     * Request raised listing of records ,status and history 
     * get_ticketlist_vm
     ******************/
    function get_ticketlist_vm($office_id = 0)
    {

        $model = array('Verification_model' => 'get_ticketlist_vm');

        $ticket_no = ($_REQUEST['ticket_no']) ? $_REQUEST['ticket_no'] : '';
        $case_number = ($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
        $username = ($_REQUEST['username']) ? $_REQUEST['username'] : '';
        $ticket_status = ($_REQUEST['ticket_status']) ? $_REQUEST['ticket_status'] : '';
        $org_id = ($_REQUEST[$this->request_orgid]) ? $_REQUEST[$this->request_orgid] : '';
        $office = ($_REQUEST[$this->request_office]) ? $_REQUEST[$this->request_office] : '';
        $parent_office = ($_REQUEST[$this->request_parent_office]) ? $_REQUEST[$this->request_parent_office] : '';
        $sub_office = ($_REQUEST[$this->request_sub_office]) ? $_REQUEST[$this->request_sub_office] : '';
        $last_thirtyVal = ($_REQUEST['last_thirty']) ? $_REQUEST['last_thirty'] : '';
        $fp_fdate = ($_REQUEST['fp_fdate']) ? $_REQUEST['fp_fdate'] : '';
        $fp_tdate = ($_REQUEST['fp_tdate']) ? $_REQUEST['fp_tdate'] : '';

        $tkt = explode('TKT-', $ticket_no);
        $tkt_no = $tkt[1];

        if ($tkt_no) {
            $condition[] = " td.ticket_no = " . $tkt_no;
        }

        if ($parent_office) {
            $condition[] = " d.id = " . $parent_office;
        }
        if ($office) {
            $condition[] = " b.id = " . $office;
        }
        if ($org_id) {
            $condition[] = " c.id = " . $org_id;
        }
        if ($sub_office) {
            $condition[] = " o.id = " . $sub_office;
        }
        // if($username){
        //     $condition[]=" (concat_ws(' ',us.first_name,us.middle_name,us.last_name) like '%".$username."%') "; Tickets Closed in last 30 days
        // }
        if ($username) {
            $condition[] = " (concat_ws(' ',us.first_name,us.last_name) like '%" . $username . "%') ";
        }
        //17/01/2024
        $case_number = trim($case_number);
        if ($case_number) {
            $condition[] = " a.case_no like '%" . $case_number . "'";
        }

        if (!empty($ticket_status)) {
            $condition[] = " td.ticket_status =" . $ticket_status;
        }

        if ($last_thirtyVal == 'Tickets Closed in last 30 days') {
            $lastDate = date('Y-m-d', strtotime('-30 days'));
            $curDate = date('Y-m-d');

            $condition[] = "DATE_FORMAT(td.close_date ,'%Y-%m-%d') >= '" . $lastDate . "' and td.ticket_status=101";
            $condition[] = "DATE_FORMAT(td.close_date ,'%Y-%m-%d') <= '" . $curDate . "' and td.ticket_status=101";
        }


        if (!empty($fp_fdate) && ($ticket_status == 1 || $ticket_status == 5)) {
            $condition[] = "DATE_FORMAT(td.action_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($fp_fdate)) . "' ";
        }
        if (!empty($fp_tdate) && ($ticket_status == 1 || $ticket_status == 5)) {
            $condition[] = "DATE_FORMAT(td.action_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($fp_tdate)) . "' ";
        }

        if (!empty($fp_fdate) && ($ticket_status == 2 || $ticket_status == 4)) {
            $condition[] = "DATE_FORMAT(td.requested_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($fp_fdate)) . "' ";
        }
        if (!empty($fp_tdate) && $ticket_status == 2) {
            $condition[] = "DATE_FORMAT(td.requested_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($fp_tdate)) . "' ";
        }

        if (!empty($fp_fdate) && $ticket_status == 3) {
            $condition[] = "DATE_FORMAT(td.revert_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($fp_fdate)) . "' ";
        }
        if (!empty($fp_tdate) && $ticket_status == 3) {
            $condition[] = "DATE_FORMAT(td.revert_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($fp_tdate)) . "' ";
        }

        if (!empty($fp_fdate) && $ticket_status == 101) {
            $condition[] = "DATE_FORMAT(td.close_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($fp_fdate)) . "' ";
        }
        if (!empty($fp_tdate) && $ticket_status == 101) {
            $condition[] = "DATE_FORMAT(td.close_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($fp_tdate)) . "' ";
        }


        if ($term) {
            //support multiple words
            $search = explode(' ', $term);
            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';

                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= " ( a.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " b.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " o.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.client_ref_number " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.report_status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " f.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.reason " . $not . "LIKE '%" . $t . "%' ";

                $condition[] = $like;
            }
        }

        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows; //echo '<pre>';print_r($result);
            foreach ($result as $i => $row) {

                $role = $this->session->userdata('user_type');

                if ($row['parent'] == 0) {
                    $officevalue = $row[$this->request_parent_office];
                    $branchofficevalue = $row['office_name'];
                } else if ($row['parent'] != 0) {
                    $officevalue = $row['office_name'];
                    $branchofficevalue = $row[$this->request_parent_office];
                }

                if ($row['chk'] == 0) {
                    $chkval = $row['name'];
                } else {
                    $chkval = $row['name'] . $row['chk'];
                }

                $ticket_noO = 'TKT-' . $row['ticket_no'];
                $employer = "";
                if ($row['check_id'] == 14) {
                    $this->db->select("affliated");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow = $this->db->get(DB_PREFIX . 'education_details')->row_array();
                    $employer = $ResRow['affliated'];
                }

                if ($row['check_id'] == 15) {
                    $this->db->select("permanent_address");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'permanent_contact_details')->row_array();
                    $employer = $ResRow1['permanent_address'];
                }

                if ($row['check_id'] == 16) {
                    $this->db->select("current_address");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'contact_details')->row_array();
                    $employer = $ResRow1['current_address'];
                }

                if ($row['check_id'] == 59) {
                    $this->db->select("company_name");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("req_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'employment')->row_array();
                    $employer = $ResRow1['company_name'];
                }
                if ($row['check_id'] == 68) {
                    $this->db->select("company_name");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'professional_reference')->row_array();
                    $employer = $ResRow1['company_name'];
                }
                if ($row['check_id'] == 649) {
                    $this->db->select("company_name");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'professional_reference_check_colleague')->row_array();
                    $employer = $ResRow1['company_name'];
                }

                $openDate = date('d-m-Y h:i', strtotime($row['action_date']));

                $ticketStatus = "";
                $tstatus = '';
                $Modify = '';

                $requestedDate = '';
                if ($row['ticket_status'] == 2) {
                    $tstatus = 'Requested';

                    if ($row['requested_date'] != '0000-00-00 00:00:00') {
                        $requestedDate = date('d-m-Y h:i', strtotime($row['requested_date']));
                    }
                    $Modify = anchor('/Verification/ticketmodify_vm/' . base64_encode($row['request_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['level_id']), "<span style='color:green;'>Modify</span>");
                }

                if ($row['ticket_status'] == 4) {
                    $tstatus = 'Re-Requested';
                    if ($row['requested_date'] != '0000-00-00 00:00:00') {
                        $requestedDate = date('d-m-Y h:i', strtotime($row['requested_date']));
                    }
                    $Modify = anchor('/Verification/ticketmodify_vm/' . base64_encode($row['request_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['level_id']), "<span style='color:green;'>Modify</span>");
                }


                $startDate = date('Y-m-d', strtotime($row['requested_date']));
                $endDate = date('Y-m-d');
                $workingDays = $this->number_of_working_days($startDate, $endDate);

                if (($row['ticket_status'] == 2 || $row['ticket_status'] == 4) && $workingDays > 7) {
                    $ticket_no = "<span style='background-color:yellow;'>" . $ticket_noO . "</span>";
                    $ticketStatus = "<span style='background-color:yellow;'>" . $tstatus . "</span>";
                } else {
                    $ticket_no = $ticket_noO;
                    $ticketStatus = $tstatus;
                }

                $revertedDate = '';
                if ($row['revert_date'] != '0000-00-00 00:00:00') {
                    $revertedDate = date('d-m-Y h:i', strtotime($row['revert_date']));
                }

                if ($row['ticket_status'] == 1) {
                    $ticketStatus = 'Open';
                }

                if ($row['ticket_status'] == 3) {
                    $ticketStatus = 'Revert';

                    $Modify = anchor('/Verification/ticketmodify_vm/' . base64_encode($row['request_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['level_id']), "<span style='color:green;'>Modify</span>");
                }

                if ($row['ticket_status'] == 5) {
                    $ticketStatus = 'Re-Open';
                }

                if ($row['ticket_status'] == 101) {
                    $ticketStatus = 'Closed';

                    if (in_array($row['qc2_dis'], array(117, 118, 122, 124, 126, 128, 129, 133, 135, 139, 141, 145, 659, 661, 663, 701))) {
                        $repstatus = "<label style='color:red'>RED</label>";
                    }
                    if (in_array($row['qc2_dis'], array(116, 127, 134, 140, 630, 121, 125, 658, 662, 660, 789))) {
                        $repstatus = "<label style='color:green'>GREEN</label>";
                    }
                    if (in_array($row['qc2_dis'], array(120, 131, 137, 143, 713, 119, 130, 136, 142, 1005)) || in_array($row['qc2status'], array(519, 110))) {
                        $repstatus = "<label style='color:orange'>ORANGE</label>";
                    }
                }

                $this->db->select('vm_revert_status');
                $this->db->where('candidate_req_id', $row['request_id']);
                $this->db->where('check_id', $row['check_id']);
                $this->db->where('level_id', $row['level_id']);
                $reqDetail = $this->db->get(DB_PREFIX . 'ver_assign_rep')->result_array();

                $closeDate = '';
                if ($row['ticket_status'] == 101 && $reqDetail[0]['vm_revert_status'] == 684) {
                    if ($row['close_date'] != '0000-00-00 00:00:00') {
                        $closeDate = date('d-m-Y h:i', strtotime($row['close_date']));
                    }

                    $Modify = anchor('/Verification/ticketmodify_vm/' . base64_encode($row['request_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['level_id']), "<span style='color:green;'>Modify</span>");
                }


                $response->rows[$i]['cell'] = array($i + $count + 1, $ticket_no, $row['case_no'], $row['candidate_name'], $chkval, $employer, $ticketStatus, $row['req_name'], $row['ticket_details'], anchor('/Client/ticketview/' . base64_encode($row['request_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['level_id']), "<span style='color:#10a1d3;'>View</span>"), $Modify, $repstatus, $row['org_name'], $officevalue, $branchofficevalue, $row[$this->request_sub_office], $row['username'], $openDate, $requestedDate, $revertedDate, $closeDate, $row['email']);
            }
        }
        echo json_encode($response);
    }

    /*******************************
     ******* Ticket Detail View *****
     ***** function tickeedit_vm*******/
    function ticketmodify_vm()
    {

        $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(4));
        $data['level_id'] = $level_id = base64_decode($this->uri->segment(5));

        $ticketdetails = $this->cm->get_ticket_modifydetail($request_id, $check_id, $level_id);

        $data['ticket'] = $ticketdetails;

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Ticket', 'Verification/request_raised_vm');
        $this->breadcrumbs->push('Modify Ticket', 'Verification/ticketmodify_vm');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'ticketmodify_vm');
    }

    function addticket_vm()
    {
        // print_r($_POST);exit;
        $userid = $this->session->userdata['userid'];
        $role_id = $this->session->userdata['role_id'];
        $formData = $_POST;
        if ($formData) {

            if ($formData['current_status'] == 1) {
                $this->db->set('current_status', 0);
                $this->db->where('request_id', $formData['request_id']);
                $this->db->where('check_id', $formData['check_id']);
                $this->db->where('level_id', $formData['level_id']);
                $this->db->update(DB_PREFIX . 'ticket_details');
            }

            if ($formData['submit'] == 'Re-Open & Submit to CRM') {
                $req_save['ticket_status'] = 5;
                $action_date = date('y-m-d H:i:s');

                $stat_save['request_id'] = $formData['request_id'];
                $stat_save['case_no'] = $formData['case_no'];
                $stat_save['check_id'] = $formData['check_id'];
                $stat_save['level_id'] = $formData['level_id'];
                $stat_save['check_status'] = 1006;
                $stat_save['verified_status'] = '';
                $stat_save['date_of_update'] = date('y-m-d H:i:s');
                $stat_save['role_id'] = $this->session->userdata('role_id');
                $stat_save['user_id'] = $this->session->userdata['userid'];
                // print_r($stat_save);exit;
                $stat_save = $this->security->xss_clean($stat_save);
                $this->db->insert(DB_PREFIX . 'status_updates', $stat_save);
            } else {
                $req_save['ticket_status'] = 101;
                $action_date = $formData['action_date'];
                $close_date = date('y-m-d H:i:s');
            }

            $req_save['request_id'] = $formData['request_id'];
            $req_save['ticket_no'] = $formData['ticket_no'];
            $req_save['ticket_serial_no'] = $formData['ticket_serial_no'];
            $req_save['case_no'] = $formData['case_no'];
            $req_save['level_id'] = $formData['level_id'];
            $req_save['check_id'] = $formData['check_id'];
            $req_save['action_date'] = $action_date;
            $req_save['requested_date'] = '';
            $req_save['revert_date'] = $formData['revert_date'];
            $req_save['close_date'] = $close_date;
            $req_save['role_id'] = $role_id;
            $req_save['user_id'] = $userid;
            $req_save['request_reason_id'] = $formData['request_reason_id'];
            $req_save['ticket_details'] = $formData['ticket_details'];
            $req_save['current_status'] = 1;

            $req_save = $this->security->xss_clean($req_save);
            $this->db->insert(DB_PREFIX . 'ticket_details', $req_save);
        }

        redirect('Verification/request_raised_vm');
    }



    /*****************
     * Request raised listing of records ,status and history 
     * export_requestraised_vm
     ******************/
    function export_requestraised_vm($office_id = 0)
    {
        // print_r($_REQUEST);exit;
        $model = array('Verification_model' => 'export_requestraised_vm');

        $ticket_no = ($_REQUEST['exp_ticket_no']) ? $_REQUEST['exp_ticket_no'] : '';
        $case_number = ($_REQUEST['exp_case_number']) ? $_REQUEST['exp_case_number'] : '';
        $username = ($_REQUEST['exp_username']) ? $_REQUEST['exp_username'] : '';
        $ticket_status = ($_REQUEST['exp_ticket_status']) ? $_REQUEST['exp_ticket_status'] : '';
        $closed_data = ($_REQUEST['exp_closed_data']) ? $_REQUEST['exp_closed_data'] : '';
        $org_id = ($_REQUEST['exp_parentoffice_id']) ? $_REQUEST['exp_parentoffice_id'] : '';
        $office = ($_REQUEST['exp_office_id']) ? $_REQUEST['exp_office_id'] : '';
        $parent_office = ($_REQUEST['exp_parent_office']) ? $_REQUEST['exp_parent_office'] : '';
        $sub_office = ($_REQUEST['exp_sub_office']) ? $_REQUEST['exp_sub_office'] : '';

        $last_thirtyVal = ($_REQUEST['last_thirty']) ? $_REQUEST['last_thirty'] : '';

        $fp_fdate = ($_REQUEST['exp_fp_fdate']) ? $_REQUEST['exp_fp_fdate'] : '';
        $fp_tdate = ($_REQUEST['exp_fp_tdate']) ? $_REQUEST['exp_fp_tdate'] : '';

        $tkt = explode('TKT-', $ticket_no);
        $tkt_no = $tkt[1];

        if ($tkt_no) {
            $condition[] = " td.ticket_no = " . $tkt_no;
        }

        if ($parent_office) {
            $condition[] = " d.id = " . $parent_office;
        }
        if ($office) {
            $condition[] = " b.id = " . $office;
        }
        if ($org_id) {
            $condition[] = " c.id = " . $org_id;
        }
        if ($sub_office) {
            $condition[] = " o.id = " . $sub_office;
        }
        // if($username){
        //     $condition[]=" (concat_ws(' ',us.first_name,us.middle_name,us.last_name) like '%".$username."%') "; Tickets Closed in last 30 days
        // }
        if ($username) {
            $condition[] = " (concat_ws(' ',us.first_name,us.last_name) like '%" . $username . "%') ";
        }
        //17/01/2024
        $case_number = trim($case_number);
        if ($case_number) {
            $condition[] = " a.case_no like '%" . $case_number . "'";
        }

        if (!empty($ticket_status)) {
            $condition[] = " td.ticket_status =" . $ticket_status;
        }

        if ($closed_data == 'Tickets Closed in last 30 days') {
            $lastDate = date('Y-m-d', strtotime('-30 days'));
            $curDate = date('Y-m-d');

            $condition[] = "DATE_FORMAT(td.close_date ,'%Y-%m-%d') >= '" . $lastDate . "' and td.ticket_status=101";
            $condition[] = "DATE_FORMAT(td.close_date ,'%Y-%m-%d') <= '" . $curDate . "' and td.ticket_status=101";
        }


        if (!empty($fp_fdate) && ($ticket_status == 1 || $ticket_status == 5)) {
            $condition[] = "DATE_FORMAT(td.action_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($fp_fdate)) . "' ";
        }
        if (!empty($fp_tdate) && ($ticket_status == 1 || $ticket_status == 5)) {
            $condition[] = "DATE_FORMAT(td.action_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($fp_tdate)) . "' ";
        }

        if (!empty($fp_fdate) && ($ticket_status == 2 || $ticket_status == 4)) {
            $condition[] = "DATE_FORMAT(td.requested_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($fp_fdate)) . "' ";
        }
        if (!empty($fp_tdate) && $ticket_status == 2) {
            $condition[] = "DATE_FORMAT(td.requested_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($fp_tdate)) . "' ";
        }

        if (!empty($fp_fdate) && $ticket_status == 3) {
            $condition[] = "DATE_FORMAT(td.revert_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($fp_fdate)) . "' ";
        }
        if (!empty($fp_tdate) && $ticket_status == 3) {
            $condition[] = "DATE_FORMAT(td.revert_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($fp_tdate)) . "' ";
        }

        if (!empty($fp_fdate) && $ticket_status == 101) {
            $condition[] = "DATE_FORMAT(td.close_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($fp_fdate)) . "' ";
        }
        if (!empty($fp_tdate) && $ticket_status == 101) {
            $condition[] = "DATE_FORMAT(td.close_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($fp_tdate)) . "' ";
        }


        if ($term) {
            //support multiple words
            $search = explode(' ', $term);
            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';

                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= " ( a.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " b.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " o.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.client_ref_number " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.report_status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " f.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.reason " . $not . "LIKE '%" . $t . "%' ";

                $condition[] = $like;
            }
        }

        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows; //echo '<pre>';print_r($result);

            $k = 1;
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Ticket No.");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Head Office");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Branch Office");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Sub Office");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Employer / University / Addres");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "User");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Request raised reason");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "Ticket Status");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "Ticket Details / Comment");
            $objPHPExcel->getActiveSheet()->setCellValue('O1', "Open / Re-Open Date");
            $objPHPExcel->getActiveSheet()->setCellValue('P1', "Requested / Re-Requested Date");
            $objPHPExcel->getActiveSheet()->setCellValue('Q1', "Reverted Date");
            $objPHPExcel->getActiveSheet()->setCellValue('R1', "Ticket Closed Date");
            $objPHPExcel->getActiveSheet()->setCellValue('S1', "Candidate Email");
            $ci = 2;

            foreach ($result as $i => $row) {

                $role = $this->session->userdata('user_type');

                if ($row['parent'] == 0) {
                    $officevalue = $row[$this->request_parent_office];
                    $branchofficevalue = $row['office_name'];
                } else if ($row['parent'] != 0) {
                    $officevalue = $row['office_name'];
                    $branchofficevalue = $row[$this->request_parent_office];
                }

                if ($row['chk'] == 0) {
                    $chkval = $row['name'];
                } else {
                    $chkval = $row['name'] . $row['chk'];
                }

                $ticket_noO = 'TKT-' . $row['ticket_no'];
                $employer = "";
                if ($row['check_id'] == 14) {
                    $this->db->select("affliated");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow = $this->db->get(DB_PREFIX . 'education_details')->row_array();
                    $employer = $ResRow['affliated'];
                }

                if ($row['check_id'] == 15) {
                    $this->db->select("permanent_address");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'permanent_contact_details')->row_array();
                    $employer = $ResRow1['permanent_address'];
                }

                if ($row['check_id'] == 16) {
                    $this->db->select("current_address");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'contact_details')->row_array();
                    $employer = $ResRow1['current_address'];
                }

                if ($row['check_id'] == 59) {
                    $this->db->select("company_name");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("req_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'employment')->row_array();
                    $employer = $ResRow1['company_name'];
                }
                if ($row['check_id'] == 68) {
                    $this->db->select("company_name");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'professional_reference')->row_array();
                    $employer = $ResRow1['company_name'];
                }
                if ($row['check_id'] == 649) {
                    $this->db->select("company_name");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'professional_reference_check_colleague')->row_array();
                    $employer = $ResRow1['company_name'];
                }

                $openDate = date('d-m-Y h:i', strtotime($row['action_date']));

                $ticketStatus = "";
                $tstatus = '';
                $Modify = '';

                $requestedDate = '';
                if ($row['ticket_status'] == 2) {
                    $tstatus = 'Requested';

                    if ($row['requested_date'] != '0000-00-00 00:00:00') {
                        $requestedDate = date('d-m-Y h:i', strtotime($row['requested_date']));
                    }
                    $Modify = anchor('/Verification/ticketmodify_vm/' . base64_encode($row['request_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['level_id']), "<span style='color:green;'>Modify</span>");
                }

                if ($row['ticket_status'] == 4) {
                    $tstatus = 'Re-Requested';
                    if ($row['requested_date'] != '0000-00-00 00:00:00') {
                        $requestedDate = date('d-m-Y h:i', strtotime($row['requested_date']));
                    }
                    $Modify = anchor('/Verification/ticketmodify_vm/' . base64_encode($row['request_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['level_id']), "<span style='color:green;'>Modify</span>");
                }


                $startDate = date('Y-m-d', strtotime($row['requested_date']));
                $endDate = date('Y-m-d');
                $workingDays = $this->number_of_working_days($startDate, $endDate);

                if (($row['ticket_status'] == 2 || $row['ticket_status'] == 4) && $workingDays > 7) {
                    $ticket_no = $ticket_noO;
                    $ticketStatus = $tstatus;
                } else {
                    $ticket_no = $ticket_noO;
                    $ticketStatus = $tstatus;
                }

                $revertedDate = '';
                if ($row['revert_date'] != '0000-00-00 00:00:00') {
                    $revertedDate = date('d-m-Y h:i', strtotime($row['revert_date']));
                }

                if ($row['ticket_status'] == 1) {
                    $ticketStatus = 'Open';
                }

                if ($row['ticket_status'] == 3) {
                    $ticketStatus = 'Revert';

                    $Modify = anchor('/Verification/ticketmodify_vm/' . base64_encode($row['request_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['level_id']), "<span style='color:green;'>Modify</span>");
                }

                if ($row['ticket_status'] == 5) {
                    $ticketStatus = 'Re-Open';
                }

                if ($row['ticket_status'] == 101) {
                    $ticketStatus = 'Closed';
                }

                $this->db->select('vm_revert_status');
                $this->db->where('candidate_req_id', $row['request_id']);
                $this->db->where('check_id', $row['check_id']);
                $this->db->where('level_id', $row['level_id']);
                $reqDetail = $this->db->get(DB_PREFIX . 'ver_assign_rep')->result_array();

                $closeDate = '';
                if ($row['ticket_status'] == 101 && $reqDetail[0]['vm_revert_status'] == 684) {
                    if ($row['close_date'] != '0000-00-00 00:00:00') {
                        $closeDate = date('d-m-Y h:i', strtotime($row['close_date']));
                    }

                    $Modify = anchor('/Verification/ticketmodify_vm/' . base64_encode($row['request_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['level_id']), "<span style='color:green;'>Modify</span>");
                }


                $objPHPExcel->getActiveSheet()->getStyle('A1:S1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i + $count + 1))
                    ->setCellValue('B' . $ci, $ticket_no)
                    ->setCellValue('C' . $ci, $row['org_name'])
                    ->setCellValue('D' . $ci, $officevalue)
                    ->setCellValue('E' . $ci, $branchofficevalue)
                    ->setCellValue('F' . $ci, $row[$this->request_sub_office])
                    ->setCellValue('G' . $ci, $row['candidate_name'])
                    ->setCellValue('H' . $ci, $row['case_no'])
                    ->setCellValue('I' . $ci, $employer)
                    ->setCellValue('J' . $ci, $chkval)
                    ->setCellValue('K' . $ci, $row['username'])
                    ->setCellValue('L' . $ci, $row['req_name'])
                    ->setCellValue('M' . $ci, $ticketStatus)
                    ->setCellValue('N' . $ci, $row['ticket_details'])
                    ->setCellValue('O' . $ci, $openDate)
                    ->setCellValue('P' . $ci, $requestedDate)
                    ->setCellValue('Q' . $ci, $revertedDate)
                    ->setCellValue('R' . $ci, $closeDate)
                    ->setCellValue('S' . $ci, $row['email']);
                $ci++;
            }
            $this->export_excel('A', 'S', 'Ticket_Details_', $objPHPExcel);
            exit;
        }
        redirect('Verification/request_raised_vm');
    }


    /*****************
     * Request Raised list page
     * request_raised_qc
     ******************/
    function request_raised_qc()
    {
        $this->breadcrumbs->push('Dashboard', $this->index_dashboard);
        $this->breadcrumbs->push('Request Raised List', 'Verification/request_raised_qc');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'request_raised_qc');
    }

    /*****************
     * Request raised listing of records ,status and history 
     * get_qcticketlist
     ******************/
    function get_qcticketlist($office_id = 0)
    {

        $model = array('Verification_model' => 'get_qcticketlist');

        $ticket_no = ($_REQUEST['ticket_no']) ? $_REQUEST['ticket_no'] : '';
        $case_number = ($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
        $username = ($_REQUEST['username']) ? $_REQUEST['username'] : '';
        $ticket_status = ($_REQUEST['ticket_status']) ? $_REQUEST['ticket_status'] : '';
        // $closed_by = ($_REQUEST['closed_by']) ? $_REQUEST['closed_by'] : ''; 
        $org_id = ($_REQUEST[$this->request_orgid]) ? $_REQUEST[$this->request_orgid] : '';
        $office = ($_REQUEST[$this->request_office]) ? $_REQUEST[$this->request_office] : '';
        $parent_office = ($_REQUEST[$this->request_parent_office]) ? $_REQUEST[$this->request_parent_office] : '';
        $sub_office = ($_REQUEST[$this->request_sub_office]) ? $_REQUEST[$this->request_sub_office] : '';
        $fp_fdate = ($_REQUEST['fp_fdate']) ? $_REQUEST['fp_fdate'] : '';
        $fp_tdate = ($_REQUEST['fp_tdate']) ? $_REQUEST['fp_tdate'] : '';

        $tkt = explode('TKT-', $ticket_no);
        $tkt_no = $tkt[1];

        if ($tkt_no) {
            $condition[] = " td.ticket_no = " . $tkt_no;
        }

        if ($parent_office) {
            $condition[] = " d.id = " . $parent_office;
        }
        if ($office) {
            $condition[] = " b.id = " . $office;
        }
        if ($org_id) {
            $condition[] = " c.id = " . $org_id;
        }
        if ($sub_office) {
            $condition[] = " o.id = " . $sub_office;
        }
        // if($username){
        //     $condition[]=" (concat_ws(' ',us.first_name,us.middle_name,us.last_name) like '%".$username."%') ";
        // }
        if ($username) {
            $condition[] = " (concat_ws(' ',us.first_name,us.last_name) like '%" . $username . "%') ";
        }
        //18/01/2024
        $case_number = trim($case_number);
        if ($case_number) {
            $condition[] = " a.case_no like '%" . $case_number . "'";
        }

        if (!empty($ticket_status)) {
            $condition[] = " td.ticket_status =" . $ticket_status;
        }
        // if(!empty($closed_by)){
        //     $condition[]=" td.role_id =".$closed_by ;
        // }

        if (!empty($fp_fdate) && ($ticket_status == 1 || $ticket_status == 5)) {
            $condition[] = "DATE_FORMAT(td.action_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($fp_fdate)) . "' ";
        }
        if (!empty($fp_tdate) && ($ticket_status == 1 || $ticket_status == 5)) {
            $condition[] = "DATE_FORMAT(td.action_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($fp_tdate)) . "' ";
        }

        if (!empty($fp_fdate) && ($ticket_status == 2 || $ticket_status == 4)) {
            $condition[] = "DATE_FORMAT(td.requested_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($fp_fdate)) . "' ";
        }
        if (!empty($fp_tdate) && $ticket_status == 2) {
            $condition[] = "DATE_FORMAT(td.requested_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($fp_tdate)) . "' ";
        }

        if (!empty($fp_fdate) && $ticket_status == 3) {
            $condition[] = "DATE_FORMAT(td.revert_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($fp_fdate)) . "' ";
        }
        if (!empty($fp_tdate) && $ticket_status == 3) {
            $condition[] = "DATE_FORMAT(td.revert_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($fp_tdate)) . "' ";
        }

        if (!empty($fp_fdate) && $ticket_status == 101) {
            $condition[] = "DATE_FORMAT(td.close_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($fp_fdate)) . "' ";
        }
        if (!empty($fp_tdate) && $ticket_status == 101) {
            $condition[] = "DATE_FORMAT(td.close_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($fp_tdate)) . "' ";
        }

        if ($term) {
            //support multiple words
            $search = explode(' ', $term);
            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';

                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= " ( a.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " b.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " o.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.client_ref_number " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.report_status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " f.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.reason " . $not . "LIKE '%" . $t . "%' ";

                $condition[] = $like;
            }
        }

        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows; //echo '<pre>';print_r($result);exit;
            foreach ($result as $i => $row) {

                $type = '';
                if ($row['dataentry_by'] == 1) {
                    $type = 'Partial Entry';
                } else if ($row['dataentry_by'] == 2) {
                    $type = 'Full Entry';
                } else if ($row['dataentry_by'] == 3) {
                    $type = 'Offline Entry';
                } else if ($row['dataentry_by'] == 0) {
                    $type = 'Candidate Entry';
                }


                if ($row['parent'] == 0) {
                    $officevalue = $row[$this->request_parent_office];
                    $branchofficevalue = $row['office_name'];
                } else if ($row['parent'] != 0) {
                    $officevalue = $row['office_name'];
                    $branchofficevalue = $row[$this->request_parent_office];
                }

                if ($row['chk'] == 0) {
                    $chkval = $row['name'];
                } else {
                    $chkval = $row['name'] . $row['chk'];
                }


                $roleid = $this->session->userdata('role_id');
                $usertype = $this->session->userdata('user_type');

                $ticket_noO = 'TKT-' . $row['ticket_no'];

                $employer = "";

                if ($row['check_id'] == 14) {
                    $this->db->select("affliated");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow = $this->db->get(DB_PREFIX . 'education_details')->row_array();
                    $employer = $ResRow['affliated'];
                }

                if ($row['check_id'] == 15) {
                    $this->db->select("permanent_address");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'permanent_contact_details')->row_array();
                    $employer = $ResRow1['permanent_address'];
                }

                if ($row['check_id'] == 16) {
                    $this->db->select("current_address");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'contact_details')->row_array();
                    $employer = $ResRow1['current_address'];
                }

                if ($row['check_id'] == 59) {
                    $this->db->select("company_name");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("req_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'employment')->row_array();
                    $employer = $ResRow1['company_name'];
                }

                if ($row['check_id'] == 68) {
                    $this->db->select("company_name");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'professional_reference')->row_array();
                    $employer = $ResRow1['company_name'];
                }
                if ($row['check_id'] == 649) {
                    $this->db->select("company_name");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'professional_reference_check_colleague')->row_array();
                    $employer = $ResRow1['company_name'];
                }

                $openDate = date('d-m-Y h:i', strtotime($row['action_date']));

                $Modify = '';
                $tstatus = '';
                $ticketStatus = "";
                if ($row['ticket_status'] == 1) {
                    $tstatus = 'Open';
                    $Modify = anchor('/Client/ticketmodify/' . base64_encode($row['request_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['level_id']), "<span style='color:green;'>Modify</span>");
                }

                if ($row['ticket_status'] == 5) {
                    $tstatus = 'Re-Open';
                    if ($usertype != 2 && $roleid != 12) {
                        $Modify = anchor('/Client/ticketmodify/' . base64_encode($row['request_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['level_id']), "<span style='color:green;'>Modify</span>");
                    }
                }

                $startDate = date('Y-m-d', strtotime($row['action_date']));
                $endDate = date('Y-m-d');
                $workingDays = $this->number_of_working_days($startDate, $endDate);

                if (($row['ticket_status'] == 1 || $row['ticket_status'] == 5) && $workingDays > 1) {
                    $ticket_no = "<span style='background-color:yellow;'>" . $ticket_noO . "</span>";
                    $ticketStatus = "<span style='background-color:yellow;'>" . $tstatus . "</span>";
                } else {
                    $ticket_no = $ticket_noO;
                    $ticketStatus = $tstatus;
                }

                $requestedDate = '';
                if ($row['ticket_status'] == 2 || $row['ticket_status'] == 101) {
                    $ticketStatus = 'Requested';
                    if ($row['requested_date'] != '0000-00-00 00:00:00') {
                        $requestedDate = date('d-m-Y h:i', strtotime($row['requested_date']));
                    }
                }

                $revertedDate = '';
                if ($row['ticket_status'] == 3) {
                    $ticketStatus = 'Revert';
                    if ($row['revert_date'] != '0000-00-00 00:00:00') {
                        $revertedDate = date('d-m-Y h:i', strtotime($row['revert_date']));
                    }
                }

                $closeDate = '';
                if ($row['ticket_status'] == 101) {
                    $ticketStatus = 'Closed';
                    if ($row['close_date'] != '0000-00-00 00:00:00') {
                        $closeDate = date('d-m-Y h:i', strtotime($row['close_date']));
                    }
                }


                if ($row['ticket_status'] == 4) {
                    $ticketStatus = 'Re-Requested';
                    if ($row['requested_date'] != '0000-00-00 00:00:00') {
                        $requestedDate = date('d-m-Y h:i', strtotime($row['requested_date']));
                    }
                }


                $response->rows[$i]['cell'] = array($i + $count + 1, $ticket_no, $row['case_no'], $row['candidate_name'], $chkval, $employer, $ticketStatus, $row['req_name'], $row['ticket_details'], anchor('/Client/ticketview/' . base64_encode($row['request_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['level_id']), "<span style='color:#10a1d3;'>View</span>"), $row['org_name'], $officevalue, $branchofficevalue, $row[$this->request_sub_office], $row['username'], $openDate, $requestedDate, $revertedDate, $closeDate);
            }
        }
        echo json_encode($response);
    }


    /*****************
     * Request raised listing of records ,status and history 
     * export_qcticketlist
     ******************/
    function export_qcticketlist($office_id = 0)
    {

        $model = array('client_model' => 'export_scrmticketlist');

        $ticket_no = ($_REQUEST['exp_ticket_no']) ? $_REQUEST['exp_ticket_no'] : '';
        $case_number = ($_REQUEST['exp_case_number']) ? $_REQUEST['exp_case_number'] : '';
        $username = ($_REQUEST['exp_username']) ? $_REQUEST['exp_username'] : '';
        $ticket_status = ($_REQUEST['exp_ticket_status']) ? $_REQUEST['exp_ticket_status'] : '';
        $org_id = ($_REQUEST[$this->request_orgid]) ? $_REQUEST[$this->request_orgid] : '';
        $office = ($_REQUEST['exp_office_id']) ? $_REQUEST['exp_office_id'] : '';
        $parent_office = ($_REQUEST['exp_parent_office']) ? $_REQUEST['exp_parent_office'] : '';
        $sub_office = ($_REQUEST['exp_sub_office']) ? $_REQUEST['exp_sub_office'] : '';
        $fp_fdate = ($_REQUEST['exp_fp_fdate']) ? $_REQUEST['exp_fp_fdate'] : '';
        $fp_tdate = ($_REQUEST['exp_fp_tdate']) ? $_REQUEST['exp_fp_tdate'] : '';

        $tkt = explode('TKT-', $ticket_no);
        $tkt_no = $tkt[1];

        if ($tkt_no) {
            $condition[] = " td.ticket_no = " . $tkt_no;
        }

        if ($parent_office) {
            $condition[] = " d.id = " . $parent_office;
        }
        if ($office) {
            $condition[] = " b.id = " . $office;
        }
        if ($org_id) {
            $condition[] = " c.id = " . $org_id;
        }
        if ($sub_office) {
            $condition[] = " o.id = " . $sub_office;
        }
        // if($username){
        //     $condition[]=" (concat_ws(' ',us.first_name,us.middle_name,us.last_name) like '%".$username."%') ";
        // }
        if ($username) {
            $condition[] = " (concat_ws(' ',us.first_name,us.last_name) like '%" . $username . "%') ";
        }
        //18/01/2024
        $case_number = trim($case_number);
        if ($case_number) {
            $condition[] = " a.case_no like '%" . $case_number . "'";
        }

        if (!empty($ticket_status)) {
            $condition[] = " td.ticket_status =" . $ticket_status;
        }


        if (!empty($fp_fdate) && ($ticket_status == 1 || $ticket_status == 5)) {
            $condition[] = "DATE_FORMAT(td.action_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($fp_fdate)) . "' ";
        }
        if (!empty($fp_tdate) && ($ticket_status == 1 || $ticket_status == 5)) {
            $condition[] = "DATE_FORMAT(td.action_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($fp_tdate)) . "' ";
        }

        if (!empty($fp_fdate) && ($ticket_status == 2 || $ticket_status == 4)) {
            $condition[] = "DATE_FORMAT(td.requested_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($fp_fdate)) . "' ";
        }
        if (!empty($fp_tdate) && $ticket_status == 2) {
            $condition[] = "DATE_FORMAT(td.requested_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($fp_tdate)) . "' ";
        }

        if (!empty($fp_fdate) && $ticket_status == 3) {
            $condition[] = "DATE_FORMAT(td.revert_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($fp_fdate)) . "' ";
        }
        if (!empty($fp_tdate) && $ticket_status == 3) {
            $condition[] = "DATE_FORMAT(td.revert_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($fp_tdate)) . "' ";
        }

        if (!empty($fp_fdate) && $ticket_status == 101) {
            $condition[] = "DATE_FORMAT(td.close_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($fp_fdate)) . "' ";
        }
        if (!empty($fp_tdate) && $ticket_status == 101) {
            $condition[] = "DATE_FORMAT(td.close_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($fp_tdate)) . "' ";
        }

        if ($term) {
            //support multiple words
            $search = explode(' ', $term);
            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';

                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= " ( a.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " b.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " o.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.client_ref_number " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.report_status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " f.first_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.reason " . $not . "LIKE '%" . $t . "%' ";

                $condition[] = $like;
            }
        }

        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows; //echo '<pre>';print_r($result);exit;

            $k = 1;
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->setCellValue('A1', "SlNo");
            $objPHPExcel->getActiveSheet()->setCellValue('B1', "Ticket No.");
            $objPHPExcel->getActiveSheet()->setCellValue('C1', "Organization");
            $objPHPExcel->getActiveSheet()->setCellValue('D1', "Head Office");
            $objPHPExcel->getActiveSheet()->setCellValue('E1', "Branch Office");
            $objPHPExcel->getActiveSheet()->setCellValue('F1', "Sub Office");
            $objPHPExcel->getActiveSheet()->setCellValue('G1', "Candidate Name");
            $objPHPExcel->getActiveSheet()->setCellValue('H1', "Case Number");
            $objPHPExcel->getActiveSheet()->setCellValue('I1', "Employer / University / Addres");
            $objPHPExcel->getActiveSheet()->setCellValue('J1', "Check Name");
            $objPHPExcel->getActiveSheet()->setCellValue('K1', "User");
            $objPHPExcel->getActiveSheet()->setCellValue('L1', "Request raised reason");
            $objPHPExcel->getActiveSheet()->setCellValue('M1', "Ticket Status");
            $objPHPExcel->getActiveSheet()->setCellValue('N1', "Ticket Details / Comment");
            $objPHPExcel->getActiveSheet()->setCellValue('O1', "Open / Re-Open Date");
            $objPHPExcel->getActiveSheet()->setCellValue('P1', "Requested / Re-Requested Date");
            $objPHPExcel->getActiveSheet()->setCellValue('Q1', "Reverted Date");
            $objPHPExcel->getActiveSheet()->setCellValue('R1', "Ticket Closed Date");
            $ci = 2;

            foreach ($result as $i => $row) {

                $type = '';
                if ($row['dataentry_by'] == 1) {
                    $type = 'Partial Entry';
                } else if ($row['dataentry_by'] == 2) {
                    $type = 'Full Entry';
                } else if ($row['dataentry_by'] == 3) {
                    $type = 'Offline Entry';
                } else if ($row['dataentry_by'] == 0) {
                    $type = 'Candidate Entry';
                }


                if ($row['parent'] == 0) {
                    $officevalue = $row[$this->request_parent_office];
                    $branchofficevalue = $row['office_name'];
                } else if ($row['parent'] != 0) {
                    $officevalue = $row['office_name'];
                    $branchofficevalue = $row[$this->request_parent_office];
                }

                if ($row['chk'] == 0) {
                    $chkval = $row['name'];
                } else {
                    $chkval = $row['name'] . $row['chk'];
                }


                $roleid = $this->session->userdata('role_id');
                $usertype = $this->session->userdata('user_type');

                $ticket_noO = 'TKT-' . $row['ticket_no'];

                $employer = "";

                if ($row['check_id'] == 14) {
                    $this->db->select("affliated");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow = $this->db->get(DB_PREFIX . 'education_details')->row_array();
                    $employer = $ResRow['affliated'];
                }

                if ($row['check_id'] == 15) {
                    $this->db->select("permanent_address");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'permanent_contact_details')->row_array();
                    $employer = $ResRow1['permanent_address'];
                }

                if ($row['check_id'] == 16) {
                    $this->db->select("current_address");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'contact_details')->row_array();
                    $employer = $ResRow1['current_address'];
                }

                if ($row['check_id'] == 59) {
                    $this->db->select("company_name");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("req_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'employment')->row_array();
                    $employer = $ResRow1['company_name'];
                }

                if ($row['check_id'] == 68) {
                    $this->db->select("company_name");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'professional_reference')->row_array();
                    $employer = $ResRow1['company_name'];
                }
                if ($row['check_id'] == 649) {
                    $this->db->select("company_name");
                    $this->db->where("id=", $row['level_id']);
                    $this->db->where("checkid=", $row['check_id']);
                    $this->db->where("request_id=", $row['request_id']);
                    $ResRow1 = $this->db->get(DB_PREFIX . 'professional_reference_check_colleague')->row_array();
                    $employer = $ResRow1['company_name'];
                }

                $openDate = date('d-m-Y h:i', strtotime($row['action_date']));

                $Modify = '';
                $tstatus = '';
                $ticketStatus = "";
                if ($row['ticket_status'] == 1) {
                    $tstatus = 'Open';
                    $Modify = anchor('/Client/ticketmodify/' . base64_encode($row['request_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['level_id']), "<span style='color:green;'>Modify</span>");
                }

                if ($row['ticket_status'] == 5) {
                    $tstatus = 'Re-Open';
                    if ($usertype != 2 && $roleid != 12) {
                        $Modify = anchor('/Client/ticketmodify/' . base64_encode($row['request_id']) . '/' . base64_encode($row['check_id']) . '/' . base64_encode($row['level_id']), "<span style='color:green;'>Modify</span>");
                    }
                }

                $startDate = date('Y-m-d', strtotime($row['action_date']));
                $endDate = date('Y-m-d');
                $workingDays = $this->number_of_working_days($startDate, $endDate);

                if (($row['ticket_status'] == 1 || $row['ticket_status'] == 5) && $workingDays > 1) {
                    $ticket_no = $ticket_noO;
                    $ticketStatus = $tstatus;
                } else {
                    $ticket_no = $ticket_noO;
                    $ticketStatus = $tstatus;
                }

                $requestedDate = '';
                if ($row['ticket_status'] == 2 || $row['ticket_status'] == 101) {
                    $ticketStatus = 'Requested';
                    if ($row['requested_date'] != '0000-00-00 00:00:00') {
                        $requestedDate = date('d-m-Y h:i', strtotime($row['requested_date']));
                    }
                }

                $revertedDate = '';
                if ($row['ticket_status'] == 3) {
                    $ticketStatus = 'Revert';
                    if ($row['revert_date'] != '0000-00-00 00:00:00') {
                        $revertedDate = date('d-m-Y h:i', strtotime($row['revert_date']));
                    }
                }

                $closeDate = '';
                if ($row['ticket_status'] == 101) {
                    $ticketStatus = 'Closed';
                    if ($row['close_date'] != '0000-00-00 00:00:00') {
                        $closeDate = date('d-m-Y h:i', strtotime($row['close_date']));
                    }
                }


                if ($row['ticket_status'] == 4) {
                    $ticketStatus = 'Re-Requested';
                    if ($row['requested_date'] != '0000-00-00 00:00:00') {
                        $requestedDate = date('d-m-Y h:i', strtotime($row['requested_date']));
                    }
                }

                $objPHPExcel->getActiveSheet()->getStyle('A1:R1')->getFont()->setBold(true);
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $ci, ($i + $count + 1))
                    ->setCellValue('B' . $ci, $ticket_no)
                    ->setCellValue('C' . $ci, $row['org_name'])
                    ->setCellValue('D' . $ci, $officevalue)
                    ->setCellValue('E' . $ci, $branchofficevalue)
                    ->setCellValue('F' . $ci, $row[$this->request_sub_office])
                    ->setCellValue('G' . $ci, $row['candidate_name'])
                    ->setCellValue('H' . $ci, $row['case_no'])
                    ->setCellValue('I' . $ci, $employer)
                    ->setCellValue('J' . $ci, $chkval)
                    ->setCellValue('K' . $ci, $row['username'])
                    ->setCellValue('L' . $ci, $row['req_name'])
                    ->setCellValue('M' . $ci, $ticketStatus)
                    ->setCellValue('N' . $ci, $row['ticket_details'])
                    ->setCellValue('O' . $ci, $openDate)
                    ->setCellValue('P' . $ci, $requestedDate)
                    ->setCellValue('Q' . $ci, $revertedDate)
                    ->setCellValue('R' . $ci, $closeDate);
                $ci++;
            }
            $this->export_excel('A', 'O', 'Ticket_Details_', $objPHPExcel);
            exit;
        }
        redirect('Verification/request_raised_qc');
    }


    function allotted_list_export()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Verification List', 'Verification/allotted_list_export');

        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'allotted_list_export');
    }

    function get_verificationlist_export()
    {

        $model = array('Verification_model' => 'get_userlistverification_export');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $company_name = ($_REQUEST['company_name']) ? $_REQUEST['company_name'] : '';
        $college_name = ($_REQUEST['college_name']) ? $_REQUEST['college_name'] : '';
        $university_name = ($_REQUEST['university_name']) ? $_REQUEST['university_name'] : '';
        $verifier_name = ($_REQUEST['verifier_name']) ? $_REQUEST['verifier_name'] : '';
        $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $request_status = ($_REQUEST['request_status']) ? $_REQUEST['request_status'] : '';
        $chk_status = ($_REQUEST['chk_status']) ? $_REQUEST['chk_status'] : '';
        $verified_status = ($_REQUEST['verified_status']) ? $_REQUEST['verified_status'] : '';

        $reopen_status = ($_REQUEST['reopen_status']) ? $_REQUEST['reopen_status'] : '';
        $additional_docs = ($_REQUEST['additional_docs']) ? $_REQUEST['additional_docs'] : '';
        $check_count = ($_REQUEST['check_count']) ? $_REQUEST['check_count'] : '';
        $date_filter = ($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
        $check_type  = ($_REQUEST['check_type']) ? $_REQUEST['check_type'] : '';
        // $reminder  = ($_REQUEST['reminder']) ? $_REQUEST['reminder'] : '';



        if ($org_id)
            $condition[] = " o.id = " . $org_id;
        if ($office)
            $condition[] = " br.id = " . $office;
        if ($parent_office)
            $condition[] = " p.id = " . $parent_office;
        if ($sub_office)
            $condition[] = " su.id = " . $sub_office;
        if ($name)
            $condition[] = "b.firstname like '%" . $name . "%' ";
        if ($check_name)
            $condition[] = "c.name like '%" . $check_name . "%' ";
        if ($company_name)
            $condition[] = "((em.company_name like '%" . $company_name . "%'  and a.check_id = 59) || (pr.company_name like '%" . $company_name . "%'  and a.check_id = 68))";
        if ($college_name)
            $condition[] = "(ed.collegename_add like '%" . $college_name . "%'  and a.check_id = 14)";
        if ($university_name)
            $condition[] = "(ed.affliated like '%" . $university_name . "%'  and a.check_id = 14)";
        if ($this->session->userdata['role_id'] == 1 || $this->session->userdata['role_id'] == 24 || $this->session->userdata['role_id'] == 9 || $this->session->userdata['role_id'] == 21) {
            if ($a_status == 0)
                $condition[] = "((a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0) or (a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1) or (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111) or (a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107) or (s.vm_revert_option_status = 1 and a.vm_revert_to = 2) or (a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1) or (a.verify_status = 992 and a.qc_revert_request !=1) or ( a.vm_assigned_qc = 0 and a.ass_request = 0 and vl1.supplementary = 1 and a.qc_revert_request = 1 and a.reopen_revert_qc2 != 1)) ";
        }
        if ($a_status == 1)
            $condition[] = "( a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0)";
        if ($a_status == 2)
            $condition[] = " (a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1)";
        if ($a_status == 3)
            $condition[] = " (a.qc_revert_request = 1 and a.vm_assigned_qc=1 and a.verify_status not in(107,684,992))";
        if ($a_status == 4)
            $condition[] = " a.ass_request = 1 ";
        if ($a_status == 5)
            $condition[] = " (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111)";
        if ($a_status == 6)
            $condition[] = "((a.verify_status in (110,111,519)) and a.ass_request=0 and a.qc_revert_request = 0 )";
        if ($a_status == 7)
            $condition[] = "(a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107)";
        if ($a_status == 8)
            $condition[] = "s.vm_revert_option_status = 1 and a.vm_revert_to = 2";
        if ($a_status == 9)
            $condition[] = " a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1";
        if ($a_status == 10)
            $condition[] = " a.verify_status = 992 and a.qc_revert_request !=1";
        if ($a_status == 11)
            $condition[] = " a.vm_assigned_qc = 0 and a.ass_request = 0 and vl1.supplementary = 1 and a.qc_revert_request = 1 and a.reopen_revert_qc2 != 1";
        if ($a_status == 12)
            $condition[] = " ";
        //17/01/2024
        $case_no = trim($case_no);
        if ($case_no)
            $condition[] = "d.case_no like '%" . $case_no . "' ";
        if ($verifier_name)
            $condition[] = "(concat_ws(' ',us.first_name,us.last_name) like '%" . $verifier_name . "%') ";
        if ($c_date && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(vr.deadline_from ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "'";
        }
        if ($t_date && $date_filter == 1) {
            $condition[] = "DATE_FORMAT(vr.deadline_from ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }
        if ($c_date && $date_filter == 2) {
            $condition[] = "DATE_FORMAT(vr.deadline_to ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "'";
        }
        if ($t_date && $date_filter == 2) {
            $condition[] = "DATE_FORMAT(vr.deadline_to ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }
        if ($c_date && $date_filter == 3) {
            $condition[] = "DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "'";
        }
        if ($t_date && $date_filter == 3) {
            $condition[] = "DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }
        if ($request_status)
            $condition[] = " vl1.reqstatus = " . $request_status;
        if ($chk_status == 1) {
            $condition[] = " (vl1.vm_discrepency in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701)) ";
        }
        if ($chk_status == 2) {
            $condition[] = " ((vl1.vm_discrepency in (120,131,137,143,713,119,130,136,142)) or (a.verify_status in (519,110))  or (vl1.vm_discrepency in (1005)))";
        }
        if ($chk_status == 3) {
            $condition[] = " (vl1.vm_discrepency in (116,127,134,140,630,121,125,658,662,660,789)) ";
        }
        if ($reopen_status == 1) {
            $condition[] = " vl1.supplementary in (1,2) ";
        }
        if ($reopen_status == 2) {
            $condition[] = " vl1.supplementary = 3 ";
        }
        if ($additional_docs == 1) {
            $condition[] = " a.additional_docs is NOT NULL ";
        }
        if ($additional_docs == 2) {
            $condition[] = " a.additional_docs is NULL ";
        }
        if ($verified_status == 1) {
            $condition[] = " (vl1.vm_discrepency in (116,127,134,140,630)) ";
        }
        if ($verified_status == 2) {
            $condition[] = " (vl1.vm_discrepency in (121)) ";
        }
        if ($verified_status == 3) {
            $condition[] = " (vl1.vm_discrepency in (122)) ";
        }
        if ($verified_status == 4) {
            $condition[] = " (vl1.vm_discrepency in (129,135,141,701,139,701,118)) ";
        }
        if ($verified_status == 5) {
            $condition[] = " (vl1.vm_discrepency in (117,126)) ";
        }
        if ($verified_status == 6) {
            $condition[] = " ((vl1.vm_discrepency in (119,130,136,142)) or (a.verify_status in (110)))";
        }
        if ($verified_status == 7) {
            $condition[] = " ((vl1.vm_discrepency in (120,131,137,143,713)) or (a.verify_status in (519)))";
        }
        // if($reminder){
        //        		$condition[]="adc.email_count =  ".$reminder." ";
        // }

        if ($check_type == 1)
            $condition[] = "c.id = 15";
        if ($check_type == 2)
            $condition[] = "c.id = 16";
        if ($check_type == 3)
            $condition[] = "c.id = 71";
        if ($check_type == 4)
            $condition[] = "c.id = 639";
        if ($check_type == 5)
            $condition[] = "c.id = 640";
        if ($check_type == 6)
            $condition[] = "c.id = 636";
        if ($check_type == 7)
            $condition[] = "c.id = 75";


        if ($check_count && $this->session->userdata['role_id'] == 5) {
            $rep_id = " (SELECT  GROUP_CONCAT(ar.rep_id) as verifier from dcode_ver_assign_rep ar
		      where (ar.verify_status =107 or ar.vm_assigned_qc=0 or ar.verify_status =684 ) group by ar.candidate_req_id having count(ar.candidate_req_id)=" . $check_count . ")";
            $rid = $this->db->query($rep_id)->result_array();
            foreach ($rid as  $rvalue) {
                $verifier_ids[] = $rvalue['verifier'];
            }
            $condition[] = " a.rep_id in (" . implode(',', $verifier_ids) . " )";
        }
        if ($check_count && (in_array($this->session->userdata['role_id'], array(1, 9, 21, 24)))) {
            $rep_id = " (SELECT  GROUP_CONCAT(ar.rep_id) as verifier from dcode_ver_assign_rep ar
		      where (ar.verify_status =107 or ar.vm_assigned_qc=0 or ar.verify_status =684 ) group by ar.candidate_req_id having count(ar.candidate_req_id)=" . $check_count . ")";
            $rid = $this->db->query($rep_id)->result_array();
            foreach ($rid as  $rvalue) {
                $verifier_ids[] = $rvalue['verifier'];
            }
            $condition[] = " a.rep_id in (" . implode(',', $verifier_ids) . " )";
        }


        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.firstname " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " b.lastname " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " f.order_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vs.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " o.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " p.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " su.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " br.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " ed.collegename_add " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " ed.affliated " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " em.company_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " pr.company_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vr.deadline_from " . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";
                $like    .= $operator . " vr.deadline_to " . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";

                $like    .= $operator . " c.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " verify_status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.additional_docs " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.vm_revert_status " . $not . "LIKE '%" . $t . "%' ) ";
                $condition[] = $like;
            }
        }
        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        // echo '<pre>';print_r($result);
        if ($result) {
            $checkteam = $this->config->item('CHECKLIST', APPLICATIONCONFIG);
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            $k = 1;

            foreach ($result as $i => $row) {
                $company_details = $this->vm->get_verifiedcompany_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);
                $education_details = $this->vm->get_verifiedcollege_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);
                $professional_details = $this->vm->get_verifiedprofessional_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);

                $verified_data = $this->vm->get_verified_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);
                $verification_data = toArray(json_decode($verified_data['fielddata']));
                $vm_expenses  = toArray(json_decode($verified_data['vmexpenses']));
                $qc2verification_data = toArray(json_decode($verified_data['qc2fielddata']));

                if ($vm_expenses <> null) {


                    if ($vm_expenses[0]['ddcurrency']) {

                        $ddcurrencyid =   $vm_expenses[0]['ddcurrency'];

                        $results = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'currencykey', 'id' => $ddcurrencyid));

                        $currencyname =   $results[0]['name'];
                    } else {
                        $currencyname = '';
                    }

                    $d_amount = 0;
                    foreach ($vm_expenses as $key => $dd_exprenses) {

                        $d_amount += $dd_exprenses['amount'];
                    }

                    $dd_amount = $currencyname . ' ' . $d_amount;
                } else {
                    $dd_amount = '';
                }


                // $status1=$this->vm->get_status($verification_data['status']);
                // $status4='';
                //       $status2=$this->vm->get_status($verification_data['pstatus']);
                //       $status3=$this->vm->get_status($verification_data['status1']);
                //       if($verification_data['ostatus']<>'')
                //       $status4=$this->vm->get_status($verification_data['ostatus']);
                //       if($verification_data['dstatus']<>'')
                //       $status4=$this->vm->get_status($verification_data['dstatus']);
                //   	if(!empty($status4))
                //       $status41='-'.$status4['name'];
                //       else
                //       $status41='';

                //   	$reqstatus='';
                //   	if(!empty($row['reqstatus'])){ 
                //   	$req_raised_status=	$this->vm->get_status($row['reqstatus']); 
                //   	$reqstatus= $req_raised_status['name'];
                //   	}
                //   	$rpt_status='';
                //   	if($verification_data['status']!=107 && $verification_data['status']!=684 && $verification_data['status']!=992 && !empty($verification_data['status'])) {
                // 	if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                // 		$rpt_status="<span style='color:red;'>RED</span>";
                // 	}
                // 	else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Partial Match"){
                // 		$rpt_status="<span style='color:orange;'>ORANGE</span>";
                // 	}
                // 	else 
                // 	{
                // 		$rpt_status="<span style='color:green;'>GREEN</span>";
                // 	}
                //   	}

                $checkstatus = $this->vm->getstatus_of_can($row['candidate_req_id'], $row['checkId']);
                $checkadminstatus = $this->vm->get_currentstatus($row['candidate_req_id']);
                $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');

                $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                $candidatename = $row['candidatename'];
                if ($row['vm_revert_option_status'] == 1 && $row['vm_revert_to'] == 2) {
                    $verifyurl = 'Revert Raised to DEO';
                } else if ($row['qc_revert_request'] == 1) {
                    if ($row['vm_assigned_qc'] == 1 && $row['verify_status'] <> 107 && $row['verify_status'] <> 684 && $row['verify_status'] <> 992) {
                        $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                        $verifyurl = 'Revert Rectified';
                    } else if ($row['vm_assigned_qc'] == 0 && $row['ass_request'] == 0 && $row['supplementary'] == 1 && $row['qc_revert_request'] == 1 && $row['reopen_revert_qc'] == 1 || $row['reopen_revert_qc2'] == 1) {
                        $verifyurl = anchor('/Verification/revert_raisedsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Assigned', 'target="_blank"');
                    } else if ($row['vm_assigned_qc'] == 0 && $row['ass_request'] == 0 && $row['supplementary'] == 1 && $row['qc_revert_request'] == 1) {
                        $verifyurl = anchor('/Verification/revert_raisedsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Reopen Assigned', 'target="_blank"');
                    } else {

                        $verifyurl = anchor('/Verification/revert_raisedsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Assigned', 'target="_blank"');
                    }
                } elseif ($row['verify_status'] == 111 && $row['vrequest'] == 0 && $row['ass_request'] == 0) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 3 && $row['vm_revert_to'] == 2) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_option_status'] == 3 && $row['vm_revert_to'] == 2) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 4 && $row['operator_submited_by'] == 12 || $row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 4 && $checkadminstatus['role_id'] == 13) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_option_status'] == 4 && $row['operator_submited_by'] == 12 || $row['vm_revert_option_status'] == 4 && $checkadminstatus['role_id'] == 13) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_to'] == 3 && $row['vm_revert_supervisor'] == 0) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_to'] == 3 && $row['vm_revert_supervisor'] == 0) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] <> '111' && $row['vrequest'] == 1 && $row['rstatus'] != 0 && $row['ass_request'] == 0) {
                    if ($row['rstatus'] == 108)
                        $vst = 'Inputs Required';
                    else if ($row['rstatus'] == 110)
                        $vst = 'Stop Check';
                    else if ($row['rstatus'] == 109)
                        $vst = 'Awaiting Authorisation';
                    else if ($row['rstatus'] == 107)
                        $vst = 'Initiated';
                    else if ($row['rstatus'] == 519)
                        $vst = 'Others';
                    else if ($row['rstatus'] == 684)
                        $vst = 'Request Raised';
                    else if ($row['rstatus'] == 992)
                        $vst = 'DD applied';

                    if ($row['rstatus'] == 110 || $row['rstatus'] == 519) {
                        $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    } else {
                        $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">' . $vst . '</p>', 'target="_blank"');
                    }

                    $requesttoass = '';
                } else if ($row['verify_status'] == '111' && $row['vrequest'] == 1 && $row['rstatus'] != 0 && $row['ass_request'] == 0) {
                    if ($row['rstatus'] == 108)
                        $vst = 'Inputs Required';
                    else if ($row['rstatus'] == 110)
                        $vst = 'Stop Check';
                    else if ($row['rstatus'] == 109)
                        $vst = 'Awaiting Authorisation';
                    else if ($row['rstatus'] == 107 && $row['verify_status'] == '111')
                        $vst = 'Verified';
                    else if ($row['rstatus'] == 107)
                        $vst = 'Initiated';
                    else
                        $vst = 'Verified';

                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">' . $vst . '</p>';
                    $requesttoass = '';
                } else if ($row['ass_request'] == 1) {
                    $verifyurl = 'Request Raised';
                    $requesttoass = 'Sent to Associate';
                    $add_calls = '';
                } else {
                    $save['request_id'] = $row['candidate_req_id'];
                    $save['check_id'] = $row['checkId'];
                    $save['level_id'] = $row['level_id'];
                    $this->db->select('count(*) as cnt');
                    $this->db->where($save);
                    $countnoti = $this->db->get(DB_PREFIX . 'notification_emails')->row_array();

                    if ($countnoti['cnt'] >= 1)
                        $vtext = 'Sent Mail to Resource';
                    else
                        $vtext = 'New';




                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $vtext, 'target="_blank"');
                    $vst = $row['status'];
                    $requesttoass = '';
                }
                $slug = url_title(convert_accented_characters($row['checkname']), 'underscore', TRUE);


                // 	if($row['checkid']==14)
                // 	$levelnames=$this->vm->get_level_name($row['candidate_req_id'],$row['checkid'],$row['level_id'],'education_details');
                // 	else if($row['checkid']==16)
                // 	$levelnames=$this->vm->get_level_name($row['candidate_req_id'],$row['checkid'],$row['level_id'],'contact_details','request_id','permanent_address');
                // 	else if($row['checkid']==59)
                // 	$levelnames=$this->vm->get_level_name($row['candidate_req_id'],$row['checkid'],$row['level_id'],'employment','req_id','level_id');
                // 	else if($row['checkid']==76 || $row['checkid']==77 || $row['checkid']==75)
                // 	$levelnames=$this->vm->get_level_name($row['candidate_req_id'],$row['checkid'],$row['level_id'],$slug,'request_id','level_name');
                // 	else
                // 	$levelnames['level']=$row['checkname'];

                // 	if($row['status']=='Initiated')
                // 	$rowstatus='Assigned in VM';
                // 	else
                // 	$rowstatus=$row['status'];


                if ($row['chk'] == 0) {
                    $chkval = $row['checkname'];
                } else {
                    $chkval = $row['checkname'] . $row['chk'];
                }


                // if(!empty($status1['name'])){
                // 	$stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
                // }else{
                // 	$stat='';
                // }
                // if($row['checkid']==14){
                // $clgname=$education_details['collegename_add'];
                // $uniname=$education_details['affliated'];	
                // }else{
                // 	$clgname='';
                // 	$uniname='';
                // }


                // if($row['checkid']==59){
                // 	$cmpnyname=$company_details['company_name'];
                // }else if($row['checkid']==68){
                // $cmpnyname=$professional_details['company_name'];
                // }else{
                // 	$cmpnyname='';
                // }
                // $supplement='';
                // if($row['supplementary']==1 || $row['supplementary']==2)
                // {
                // $supplement='Reopen';
                // }
                // elseif($row['supplementary']==3){
                // $supplement='Reopen-Completed';
                // } 
                // $deadline_from=isset($row['deadline_from'])? date('d-m-Y',strtotime($row['deadline_from'])) : '';
                // $deadline_to=isset($row['deadline_to'])? date('d-m-Y',strtotime($row['deadline_to'])) : '';

                // $v_date=isset($row['v_date'])? date('d-m-Y',strtotime($row['v_date'])) : '';
                // $req_raise_date=isset($row['vm_request_raised_date'])? date('d-m-Y',strtotime($row['vm_request_raised_date'])) : '';

                //    $dd_recived = 	$qc2verification_data['dd_recevied_form'];

                //             if($dd_recived == 1){
                //                $dd_status = 'None';
                //              }
                //              elseif($dd_recived == 2){
                //                    $dd_status = 'University';
                //              }
                //              elseif($dd_recived == 3){
                //                    $dd_status = 'College';
                //              }
                //              elseif($dd_recived == 4){
                //                    $dd_status = 'Company';
                //              }
                //              elseif($dd_recived == 5){
                //                    $dd_status = 'University and College';
                //              }
                //              else
                //              {
                //                $dd_status = '';
                //              }

                // $veri_received =   $qc2verification_data['veri_received_dropdown'];

                // if($veri_received == 1){
                // 	$veri_received_data  = "Recevied";
                // }
                // elseif($veri_received == 2)
                // {
                //    $veri_received_data  = "Not received";
                // }
                // else
                // {
                // 	$veri_received_data = '';
                // }

                if ($row['checkid'] == 15) {
                    $father = $row['father_name'];
                    $address = $row['permanent_address'];
                    $mobile = $this->encryption->decrypt($row['mobile']);
                    $pin = $row['pincode'];
                    $valcchk = $this->amodel->getDetails(DB_PREFIX . "cities a", array('a.city'), array('a.id' => $row['district']));
                    $city = $valcchk[0]['city'];

                    $value = $this->amodel->getDetails(DB_PREFIX . "states a", array('a.name'), array('a.country_code' => 'IN', 'a.adminCode1' => $row['state']));
                    $state = $value[0]['name'];
                } else {
                    $father = $row['cfather_name'];
                    $address = $row['current_address'];
                    $mobile = $this->encryption->decrypt($row['cmobile']);
                    $pin = $row['cpincode'];

                    $valcchk = $this->amodel->getDetails(DB_PREFIX . "cities a", array('a.city'), array('a.id' => $row['cdistrict']));
                    $city = $valcchk[0]['city'];

                    $value = $this->amodel->getDetails(DB_PREFIX . "states a", array('a.name'), array('a.country_code' => 'IN', 'a.adminCode1' => $row['cstate']));
                    $state = $value[0]['name'];
                }


                $response->rows[$i]['cell'] = array($i + $count + 1, $row['case_no'], $row['org_name'], $chkval, $candidatename, $father, $address, $mobile, $pin, $city, $state, anchor('/Dadmin/dadminview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['checkId']), 'View'));
            }
        }
        echo json_encode($response);
    }



    function get_Activity_data()
    {
        if (!empty($_POST)) {

            $fromDate = $_POST['fp_fdate'];
            $toDate = $_POST['fp_tdate'];

            if (!empty($_POST['vmember'])) {
                $userId = $_POST['vmember'];
            } else {

                if ($this->session->userdata['role_id'] == 5) {
                    $userId = $this->session->userdata['userid'];
                } else {
                    $userId = 0;
                }
            }
        } else {
            $fromDate = date('d-m-Y');
            $toDate = date('d-m-Y');
            $data['fromDate'] = $fromDate;
            $data['toDate'] = $toDate;
            if ($this->session->userdata['role_id'] == 5) {
                $userId = $this->session->userdata['userid'];
            } else {
                $userId = 0;
            }
        }

        $init = $this->vm->get_activitysheet('107', $fromDate, $toDate, $userId);
        $verrfy = $this->vm->get_activitysheet('111', $fromDate, $toDate, $userId);
        $other = $this->vm->get_activitysheet('519', $fromDate, $toDate, $userId);
        $stopChk = $this->vm->get_activitysheet('110', $fromDate, $toDate, $userId);
        $revert_rectify = $this->vm->get_activitysheet('1002', $fromDate, $toDate, $userId);
        $reminder = $this->vm->get_activitysheet('1005', $fromDate, $toDate, $userId);
        $DDApply = $this->vm->get_activitysheet('992', $fromDate, $toDate, $userId);
        $Rev_toDEO = $this->vm->get_activitysheet('1001', $fromDate, $toDate, $userId);
        $Re_Open = $this->vm->get_activitysheet('1004', $fromDate, $toDate, $userId);
        $RequestRaised = $this->vm->get_activitysheet('684', $fromDate, $toDate, $userId);
        $Tkt_reopen = $this->vm->get_activitysheet('1006', $fromDate, $toDate, $userId);
        // print_r($DDApply);exit;
        $initiated = $init['status'];
        $verified = $verrfy['status'] + $other['status'] + $stopChk['status'];
        $revert_rectify = $revert_rectify['status'];
        $reminder = $reminder['status'];
        $DDApply = $DDApply['status'];
        $Rev_toDEO = $Rev_toDEO['status'];
        $Re_Open = $Re_Open['status'];
        $RequestRaised = $RequestRaised['status'];
        $Tkt_reopen = $Tkt_reopen['status'];



        $html = '
				<tr style="height: 50px;">
                    <th style="width:50px;padding:5px;border:1px solid black; font-weight: bold;">Sl. no.</th>
                    <th style="padding:5px;border:1px solid black;font-weight: bold;width:350px;">Activity</th>
                    <th id="results" style="padding:5px;border:1px solid black;font-weight: bold;">Count</th>
                </tr>';
        $initiated = ($initiated) ? $initiated : '';
        $html .= '<tr>
                    <td style="width:50px;padding:5px;border:1px solid black;text-align:right;">1</td>
                    <td style="padding:5px;border:1px solid black;">Initiated</td>
                    <td style="padding:5px;border:1px solid black;text-align:right;">'
            . anchor("/Verification/vm_activity/" . base64_encode($userId) . "/" . base64_encode("Initiated") . "/" . base64_encode($fromDate) . "/" . base64_encode($toDate), "<span style='color:black'>" . $initiated . "</span>") .
            '</td>
                </tr>';
        $verified = ($verified) ? $verified : '';
        $html .= '<tr>
                    <td style="width:50px;padding:5px;border:1px solid black;text-align:right;">2</td>
                    <td style="padding:5px;border:1px solid black;">Verified</td>
                    <td style="padding:5px;border:1px solid black;text-align:right;">'
            . anchor("/Verification/vm_activity/" . base64_encode($userId) . "/" . base64_encode("Verified") . "/" . base64_encode($fromDate) . "/" . base64_encode($toDate), "<span style='color:black'>" . $verified . "</span>") .
            '</td>
                </tr>';
        $revert_rectify = ($revert_rectify) ? $revert_rectify : '';
        $html .= '<tr>
                    <td style="width:50px;padding:5px;border:1px solid black;text-align:right;">3</td>
                    <td style="padding:5px;border:1px solid black;">QC reverts closed</td>
                    <td style="padding:5px;border:1px solid black;text-align:right;">'
            . anchor("/Verification/vm_activity/" . base64_encode($userId) . "/" . base64_encode("QCRevertClosed") . "/" . base64_encode($fromDate) . "/" . base64_encode($toDate), "<span style='color:black'>" . $revert_rectify . "</span>") .
            '</td>
                </tr>';
        $reminder = ($reminder) ? $reminder : '';
        $html .= '<tr>
                    <td style="width:50px;padding:5px;border:1px solid black;text-align:right;">4</td>
                    <td style="padding:5px;border:1px solid black;">Reminder sent</td>
                    <td style="padding:5px;border:1px solid black;text-align: right;">'
            . anchor("/Verification/vm_activity/" . base64_encode($userId) . "/" . base64_encode("Reminder") . "/" . base64_encode($fromDate) . "/" . base64_encode($toDate), "<span style='color:black'>" . $reminder . "</span>") .
            '</td>
                </tr>';
        $DDApply = ($DDApply) ? $DDApply : '';
        $html .= '<tr>
                    <td style="width:50px;padding:5px;border:1px solid black;text-align:right;">5</td>
                    <td style="padding:5px;border:1px solid black;">DD applied</td>
                    <td style="padding:5px;border:1px solid black;text-align: right;">'
            . anchor("/Verification/vm_activity/" . base64_encode($userId) . "/" . base64_encode("DDApplied") . "/" . base64_encode($fromDate) . "/" . base64_encode($toDate), "<span style='color:black'>" . $DDApply . "</span>") .
            '</td>
                </tr>';
        $Rev_toDEO = ($Rev_toDEO) ? $Rev_toDEO : '';
        $html .= '<tr>
                    <td style="width:50px;padding:5px;border:1px solid black;text-align:right;">6</td>
                    <td style="padding:5px;border:1px solid black;">Reverted to DEO</td>
                    <td style="padding:5px;border:1px solid black;text-align: right;">'
            . anchor("/Verification/vm_activity/" . base64_encode($userId) . "/" . base64_encode("RevertedToDEO") . "/" . base64_encode($fromDate) . "/" . base64_encode($toDate), "<span style='color:black'>" . $Rev_toDEO . "</span>") .
            '</td>
                </tr>';
        $Re_Open = ($Re_Open) ? $Re_Open : '';
        $html .= '<tr>
                    <td style="width:50px;padding:5px;border:1px solid black;text-align:right;">7</td>
                    <td style="padding:5px;border:1px solid black;">Re-open</td>
                    <td style="padding:5px;border:1px solid black;text-align: right;">'
            . anchor("/Verification/vm_activity/" . base64_encode($userId) . "/" . base64_encode("ReOpen") . "/" . base64_encode($fromDate) . "/" . base64_encode($toDate), "<span style='color:black'>" . $Re_Open . "</span>") .
            '</td>
                </tr>';
        $RequestRaised = ($RequestRaised) ? $RequestRaised : '';
        $html .= '<tr>
                    <td style="width:50px;padding:5px;border:1px solid black;text-align:right;">8</td>
                    <td style="padding:5px;border:1px solid black;">Request raised</td>
                    <td style="padding:5px;border:1px solid black;text-align: right;">'
            . anchor("/Verification/vm_activity/" . base64_encode($userId) . "/" . base64_encode("RequestRaised") . "/" . base64_encode($fromDate) . "/" . base64_encode($toDate), "<span style='color:black'>" . $RequestRaised . "</span>") .
            '</td>
                </tr>';
        $Tkt_reopen = ($Tkt_reopen) ? $Tkt_reopen : '';
        $html .= '<tr>
                    <td style="width:50px;padding:5px;border:1px solid black;text-align:right;">9</td>
                    <td style="padding:5px;border:1px solid black;">Tickets Re-opened</td>
                    <td style="padding:5px;border:1px solid black;text-align: right;">'
            . anchor("/Verification/vm_activity/" . base64_encode($userId) . "/" . base64_encode("TicketReopen") . "/" . base64_encode($fromDate) . "/" . base64_encode($toDate), "<span style='color:black'>" . $Tkt_reopen . "</span>") .
            '</td>
                </tr>';

        $total = $initiated + $verified + $revert_rectify + $reminder + $DDApply + $Rev_toDEO + $Re_Open + $RequestRaised + $Tkt_reopen;

        $html .= '<tr>
                    <td colspan="2" style="padding:5px;border:1px solid black;text-align: right;font-weight: bold;">Total</td>
                    <td style="text-align: right;font-weight: bold;padding:5px;">' .
            $total
            . '</td>
                </tr>';

        echo $html;
    }


    function composemail()
    {

        // print_r($_POST);exit;
        $formData = $this->security->xss_clean($_POST);

        $this->amodel->loadcssScript(array('jquery-ui-1.10.4'));
        $this->amodel->loadjsscript(array('jquery.validate', 'jquery.dropdownPlain', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'jquery.datepick', 'multipleclone', 'jquery.validate'));

        $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['level_id'] =  $level_id = base64_decode($this->uri->segment(4));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $data['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));


        $data['additional_Doc'] = $this->amodel->getDetails(DB_PREFIX . "personal_additional_doc a", array('a.*'), array('a.check_id' => $check_id, 'a.request_id' => $request_id, 'a.ref_id' => $level_id));

        // echo '<pre>';print_r($data['additional_Doc']);


        $userId =  $this->session->userdata['userid'];
        $roleid =  $this->session->userdata['role_id'];

        $this->db->select('first_name, last_name, designation, email');
        $email_from = $this->db->get_where(DB_PREFIX . 'user', array('id' => $userId, 'user_type' => 1))->row_array();

        $fName = $email_from['first_name'] ? $email_from['first_name'] . " " : "";
        $lName = $email_from['last_name'] ? $email_from['last_name'] . " " : "";
        $data['full_name'] = $fName . ' ' . $lName;
        $data['designation'] = $email_from['designation'] ? $email_from['designation'] . " " : "";


        $this->db->select('name');
        $data['checkname'] = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->row_array();

        $data['slug'] = $slug = url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        if ($pack_id > 94)
            $level_details = $this->dm->$slug($request_id, $pack_id, $level_id);
        else
            $level_details = $this->dm->$slug($request_id, $check_id, $level_id);
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');

        // echo '<pre>';print_r($level_details);
        $title = $level_details[0]['title'];
        $f_name = $level_details[0]['firstname'] ? $level_details[0]['firstname'] . " " : "";
        $m_name = $level_details[0]['middlename'] ? $level_details[0]['middlename'] . " " : "";
        $l_name = $level_details[0]['lastname'] ? $level_details[0]['lastname'] . " " : "";

        $data['candidate_name'] = $title . ' ' . $f_name . $m_name . ' ' . $l_name;
        $data['employer'] = $level_details[0]['company_name'];

        if ($check_id == 59) {

            $data['employer'] = $level_details[0]['company_name'];
            $data['employee_code'] = $this->encryption->decrypt($level_details[0]['employee_code']);
            if ($level_details[0]['employment'] == 1) {
                $data['employment'] = "Permanent";
            } else if ($level_details[0]['employment'] == 2) {
                $data['employment'] = "Contract";
            } else {
                $data['employment'] = "Others";
            }

            $data['period_from'] = date('d-m-Y', strtotime($level_details[0]['period_from']));
            $data['period_to'] = date('d-m-Y', strtotime($level_details[0]['period_to']));
            $data['last_designation'] = $level_details[0]['last_designation'];
            $data['salary'] = $level_details[0]['salary'];

            if (!empty($level_details[0]['currency'])) {
                $valcchk = $this->amodel->getDetails(DB_PREFIX . "currency a", array('a.currency'), array('a.country' => $level_details[0]['currency']));
                if (!empty($valcchk)) {
                    $data['currency'] = $valcchk[0]['currency'];
                } else {
                    $data['currency'] = $level_details[0]['currency'];
                }
            }

            if (!empty($level_details[0]['work_time'])) {
                $valcchk = $this->amodel->getDetails(DB_PREFIX . "work_time a", array('a.name'), array('a.id' => $level_details[0]['work_time']));
                $data['work_time'] = $valcchk[0]['name'];
            }

            $data['manager_name'] = $level_details[0]['manager_name'];
            $data['manager_designation'] = $level_details[0]['manager_designation'];
            $data['reason'] = $level_details[0]['reason'];

            if (!empty($level_details[0]['employement_file'])) {
                $data['employement_file'] = $level_details[0]['employement_file'];
            }
            if (!empty($level_details[0]['relieve_document'])) {
                $data['relieve_document'] = $level_details[0]['relieve_document'];
            }
            if (!empty($level_details[0]['service_document'])) {
                $data['service_document'] = $level_details[0]['service_document'];
            }
        } else if ($check_id == 68) {
            $data['manager_name'] = $level_details[0]['manager_name'];
        } else if ($check_id == 14) {
            $data['collegename_add'] = $level_details[0]['collegename_add'];
            $data['year_of_passing'] = $level_details[0]['year_of_passing'];
            $data['roll'] = $this->encryption->decrypt($level_details[0]['roll']);
            $data['degree'] = $level_details[0]['degree'];

            if (!empty($level_details[0]['document_file'])) {
                $data['document_file'] = $level_details[0]['document_file'];
            }
            if (!empty($level_details[0]['gdocument'])) {
                $data['gdocument'] = $level_details[0]['gdocument'];
            }
            if (!empty($level_details[0]['pdocument'])) {
                $data['pdocument'] = $level_details[0]['pdocument'];
            }
            if (!empty($level_details[0]['consolidate_doc'])) {
                $data['consolidate_doc'] = $level_details[0]['consolidate_doc'];
            }
        } else if ($check_id == 69) {
            $data['reference_name'] = $level_details[0]['reference_name'];
            $data['reference_relationship'] = $level_details[0]['reference_relationship'];
            $data['reference_knowntime'] = $level_details[0]['reference_knowntime'];
        }


        $data['contsofcheck'] = $CaseNo = $this->vm->countsofchk($request_id, $check_id, $level_id);


        if ($formData['Submit'] == 'Send') {
            $data = $formData;
            // echo '<pre>';print_r($formData);exit;

            $compose_Doc = $this->amodel->getDetails(DB_PREFIX . "composedoc a", array('a.doc_name', 'a.doc_file'), array('a.check_id' => $check_id, 'a.request_id' => $request_id, 'a.level_id' => $level_id));

            if (!empty($compose_Doc)) {

                $this->db->where('request_id', $request_id);
                $this->db->where('check_id', $check_id);
                $this->db->where('level_id', $level_id);
                $this->db->delete(DB_PREFIX . 'composedoc');
            }

            if ($formData['count'] > 0) {

                $upload_doc = array('doc_name', 'doc_file');
                $status = $this->insertAddtional_doc($formData['count'], $upload_doc, $return_id, 'composedoc', $request_id, 'request_id', $check_id, $level_id);
            }

            $compose_Doc = $this->amodel->getDetails(DB_PREFIX . "composedoc a", array('a.doc_name', 'a.doc_file'), array('a.check_id' => $check_id, 'a.request_id' => $request_id, 'a.level_id' => $level_id));


            $email = send_email_clientfromvm('mailto_client_fromvm', $formData['Subject'], $email_from['email'], $data, $compose_Doc);

            if ($email == 1) {
                $stat_save['case_no'] = $CaseNo[0]['case_no'];
                $stat_save['request_id'] = $request_id;
                $stat_save['check_id'] = $check_id;
                $stat_save['level_id'] = $level_id;
                $stat_save['email_to'] = $formData['mailto'];
                $stat_save['email_cc'] = $formData['ccto'];
                $stat_save['role_id'] = $this->session->userdata('role_id');
                $stat_save['user_id'] = $this->session->userdata['userid'];
                $stat_save['sent_date'] = date('Y-m-d H:i:s');
                $stat_save['last_update_date'] = date('Y-m-d H:i:s');
                $stat_save = $this->security->xss_clean($stat_save);
                // print_r($stat_save);exit;
                $this->db->insert(DB_PREFIX . 'compose_mail', $stat_save);
            }

            redirect('Verification/level_detailsview/' . base64_encode($request_id) . '/' . base64_encode($level_id) . '/' . base64_encode($check_id) . '/' . base64_encode($pack_id), 'refresh');
        }


        $this->amodel->pagerender($data, 'composemail');
    }



    function insertAddtional_doc($clonecount = 0, $insertValue = '', $marketId = '', $tablename = '', $editId = '', $fId = '', $cId = '', $lId = '')
    {

        if ($editId != 0) {
            $marketId = $editId;
            $rcId = $cId;
            $rlId = $lId;
        }

        $insertsales = array();
        $bulksave = array();

        if ($clonecount != 0) {
            $k = 0;
            for ($i = 1; $i <= $clonecount; $i++) {
                $j = $i + $k;
                /* Flag is continue untill file is !empty. */
                $Flag = true;
                while ($Flag) {
                    /* If emty eg.file11, file22 etc increment value by 1 of j and K  */
                    if (empty($_FILES['doc_file' . $j . $j]['name'])) {
                        $j = $j + 1;
                        $k = $k + 1;
                    }
                    if (!empty($_FILES['doc_file' . $j . $j]['name'])) {
                        $Flag = false;
                    }
                }


                foreach ($insertValue as $value) {
                    switch ($value) {
                        case 'doc_file':
                        case '':
                            //upload files
                            $this->load->library('Upload');
                            $config['allowed_types'] = 'jpg|png|jpeg|pdf';
                            $config['upload_path'] = 'uploads/compose_doc/';
                            $config['encrypt_name'] = true;
                            $config['remove_spaces'] = true;
                            $this->load->library('upload', $config);


                            if (!empty($_FILES['doc_file' . $j . $j]['name'])) {

                                $this->upload->initialize($config);
                                if ($this->upload->do_upload('doc_file' . $j . $j)) {

                                    $upload_data = $this->upload->data();
                                    $image['original'] = $config['upload_path'] . '' . $upload_data['file_name'];
                                    $config['source_image'] = getcwd() . '/uploads/compose_doc/' . $upload_data['file_name'];
                                    $insertsales['doc_file'] = $image['original'];
                                }
                            }

                            if ($this->upload->display_errors() != '') {

                                return $this->upload->display_errors();
                            }

                            $insertsales[$value] = $image['original'];
                            break;

                        default:
                            $insertsales[$value] = $_POST[$value . $j];
                            break;
                    }
                }

                $insertsales[$fId] = $marketId;
                $insertsales['check_id'] = $cId;
                $insertsales['level_id'] = $lId;
                $insertsales['created_date'] = date('Y-m-d H:i:s');
                $bulksave[] = $insertsales;
            }

            $this->db->insert_batch($this->config->item('table_prefix') . $tablename, $bulksave);
        }

        return 1;
    }


    function priority_caselist()
    {


        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Priority Case List', 'Verification/priority_caselist');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'priority_caselist');
    }
    function get_prioritycaselist()
    {
        $model = array('Verification_model' => 'get_prioritycaselist');

        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';

        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';

        $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $verifier_name = ($_REQUEST['verifier_name']) ? $_REQUEST['verifier_name'] : '';

        if ($verifier_name)
            $condition[] = "(concat_ws(' ',us.first_name,us.last_name) like '%" . $verifier_name . "%') ";
        if ($org_id)
            $condition[] = " o.id = " . $org_id;

        if ($office)
            $condition[] = " br.id = " . $office;
        if ($parent_office)
            $condition[] = " p.id = " . $parent_office;
        if ($sub_office)
            $condition[] = " su.id = " . $sub_office;
        if ($name)
            $condition[] = "b.firstname like '%" . $name . "%' ";
        if ($check_name)
            $condition[] = "c.name like '%" . $check_name . "%' ";
        if ($this->session->userdata['role_id'] == 1 || $this->session->userdata['role_id'] == 24 || $this->session->userdata['role_id'] == 9 || $this->session->userdata['role_id'] == 21) {
            if ($a_status == 0)
                $condition[] = "((a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0) or (a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1) or (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111) or (a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107) or (s.vm_revert_option_status = 1 and a.vm_revert_to = 2) or (a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1) or (a.verify_status = 992 and a.qc_revert_request !=1) or ( a.vm_assigned_qc = 0 and a.ass_request = 0 and vl1.supplementary = 1 and a.qc_revert_request = 1 and a.reopen_revert_qc2 = 1)) ";
        }
        if ($a_status == 1)
            $condition[] = "( a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0)";
        if ($a_status == 2)
            $condition[] = " (a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1)";
        if ($a_status == 3)
            $condition[] = " (a.qc_revert_request = 1 and a.vm_assigned_qc=1 and a.verify_status not in(107,684,992))";
        if ($a_status == 4)
            $condition[] = " a.ass_request = 1 ";
        if ($a_status == 5)
            $condition[] = " (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111)";
        if ($a_status == 6)
            $condition[] = "((a.verify_status in (110,111,519)) and a.ass_request=0 and a.qc_revert_request = 0 )";
        if ($a_status == 7)
            $condition[] = "(a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107)";
        if ($a_status == 8)
            $condition[] = "s.vm_revert_option_status = 1 and a.vm_revert_to = 2";
        if ($a_status == 9)
            $condition[] = " a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1";
        if ($a_status == 10)
            $condition[] = " a.verify_status = 992 and a.qc_revert_request !=1";
        if ($a_status == 11)
            $condition[] = " a.vm_assigned_qc = 0 and a.ass_request = 0 and vl1.supplementary = 1 and a.qc_revert_request = 1 ";
        if ($a_status == 12)
            $condition[] = " ";
        //17/01/2024
        $case_no = trim($case_no);
        if ($case_no)
            $condition[] = " d.case_no like '%" . $case_no . "'";


        if ($request_status)
            $condition[] = " vl1.reqstatus like '%" . $request_status . "' ";
        if ($chk_status == 1) {
            $condition[] = " (vl1.vm_discrepency in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701)) ";
        }
        if ($chk_status == 2) {
            $condition[] = " ((vl1.vm_discrepency in (120,131,137,143,713,119,130,136,142)) or (a.verify_status in (519,110))  or (vl1.vm_discrepency in (1005)))";
        }
        if ($chk_status == 3) {
            $condition[] = " (vl1.vm_discrepency in (116,127,134,140,630,121,125,658,662,660,789)) ";
        }
        if ($reopen_status == 1) {
            $condition[] = " vl1.supplementary in (1,2) ";
        }
        if ($reopen_status == 2) {
            $condition[] = " vl1.supplementary = 3 ";
        }
        if ($additional_docs == 1) {
            $condition[] = " a.additional_docs is NOT NULL ";
        }
        if ($additional_docs == 2) {
            $condition[] = " a.additional_docs is NULL ";
        }
        if ($verified_status == 1) {
            $condition[] = " (vl1.vm_discrepency in (116,127,134,140,630)) ";
        }
        if ($verified_status == 2) {
            $condition[] = " (vl1.vm_discrepency in (121)) ";
        }
        if ($verified_status == 3) {
            $condition[] = " (vl1.vm_discrepency in (122)) ";
        }
        if ($verified_status == 4) {
            $condition[] = " (vl1.vm_discrepency in (129,135,141,701,139,701,118)) ";
        }
        if ($verified_status == 5) {
            $condition[] = " (vl1.vm_discrepency in (117,126)) ";
        }
        if ($verified_status == 6) {
            $condition[] = " ((vl1.vm_discrepency in (119,130,136,142)) or (a.verify_status in (110)))";
        }
        if ($verified_status == 7) {
            $condition[] = " ((vl1.vm_discrepency in (120,131,137,143,713)) or (a.verify_status in (519)))";
        }

        if ($c_date) {
            $condition[] = "DATE_FORMAT(pri.date_ofupdate ,'%Y-%m-%d') >= '" . date('Y-m-d', strtotime($c_date)) . "'";
        }
        if ($t_date) {
            $condition[] = "DATE_FORMAT(pri.date_ofupdate,'%Y-%m-%d') <= '" . date('Y-m-d', strtotime($t_date)) . "'";
        }

        if ($check_type == 1)
            $condition[] = "c.id = 15";
        if ($check_type == 2)
            $condition[] = "c.id = 16";
        if ($check_type == 3)
            $condition[] = "c.id = 71";
        if ($check_type == 4)
            $condition[] = "c.id = 639";
        if ($check_type == 5)
            $condition[] = "c.id = 640";
        if ($check_type == 6)
            $condition[] = "c.id = 636";
        if ($check_type == 7)
            $condition[] = "c.id = 75";

        if ($check_count == 'currentEmpAuth') {
            $condition[] = " vl1.reqstatus = 710";
        } else if ($check_count == 'DDAuth') {
            $condition[] = " vl1.reqstatus = 704";
        } else if ($check_count == 'NeedPin') {
            $condition[] = " vl1.reqstatus = 714";
        } else if ($check_count == 'CompPermanentAddr') {
            $condition[] = " vl1.reqstatus = 715";
        } else if ($check_count == 'CompCurrententAddr') {
            $condition[] = " vl1.reqstatus = 716";
        } else if ($check_count == 'FatherName') {
            $condition[] = " vl1.reqstatus = 717";
        } else if ($check_count == 'ContactNo') {
            $condition[] = " vl1.reqstatus = 718";
        } else if ($check_count == 'CompleteAddr') {
            $condition[] = " vl1.reqstatus = 719";
        } else if ($check_count == 'NeedDOB') {
            $condition[] = " vl1.reqstatus = 720";
        } else if ($check_count == 'Aadhar') {
            $condition[] = " vl1.reqstatus = 721";
        } else if ($check_count == 'PermanentAddWithPIN') {
            $condition[] = " vl1.reqstatus = 722";
        } else if ($check_count == 'PAN_no') {
            $condition[] = " vl1.reqstatus = 723";
        } else if ($check_count == 'PAN_Card') {
            $condition[] = " vl1.reqstatus = 724";
        } else if ($check_count == 'Passport') {
            $condition[] = " vl1.reqstatus = 725";
        } else if ($check_count == 'DL') {
            $condition[] = " vl1.reqstatus = 726";
        } else if ($check_count == 'CurrentAddrWithPin') {
            $condition[] = " vl1.reqstatus = 727";
        } else if ($check_count == 'AppliedDD') {
            $condition[] = " vl1.reqstatus = 752";
        } else if ($check_count == 'VoterID') {
            $condition[] = " vl1.reqstatus = 778";
        } else if ($check_count == 'Form_16') {
            $condition[] = " vl1.reqstatus = 780";
        } else if ($check_count == 'Other') {
            $condition[] = " vl1.reqstatus = 713";
        } else if ($check_count == 'AdditionalDDAuth') {
            $condition[] = " vl1.reqstatus = 705";
        } else if ($check_count == 'AdditionalDOC') {
            $condition[] = " vl1.reqstatus = 706";
        } else if ($check_count == 'AdditionalInfo') {
            $condition[] = " vl1.reqstatus = 707";
        } else if ($check_count == 'AdditionalCharge') {
            $condition[] = " vl1.reqstatus = 711";
        } else if ($check_count == 'ClientNameDiscloser') {
            $condition[] = " vl1.reqstatus = 708";
        } else if ($check_count == 'ShareOLA') {
            $condition[] = " vl1.reqstatus = 709";
        } else if ($check_count == 'NeedClarification') {
            $condition[] = " vl1.reqstatus = 712";
        } else {

            if ($check_count && $this->session->userdata['role_id'] == 5) {
                $rep_id = " (SELECT  GROUP_CONCAT(ar.rep_id) as verifier from dcode_ver_assign_rep ar
              where (ar.verify_status =107 or ar.vm_assigned_qc=0 or ar.verify_status =684 ) group by ar.candidate_req_id having count(ar.candidate_req_id)=" . $check_count . ")";
                $rid = $this->db->query($rep_id)->result_array();
                foreach ($rid as  $rvalue) {
                    $verifier_ids[] = $rvalue['verifier'];
                }
                $condition[] = " a.rep_id in (" . implode(',', $verifier_ids) . " )";
            }
            if ($check_count && (in_array($this->session->userdata['role_id'], array(1, 21, 24, 12, 13, 9)))) {
                $rep_id = " (SELECT  GROUP_CONCAT(ar.rep_id) as verifier from dcode_ver_assign_rep ar
              where (ar.verify_status =107 or ar.vm_assigned_qc=0 or ar.verify_status =684 ) group by ar.candidate_req_id having count(ar.candidate_req_id)=" . $check_count . ")";
                $rid = $this->db->query($rep_id)->result_array();
                foreach ($rid as  $rvalue) {
                    $verifier_ids[] = $rvalue['verifier'];
                }
                $condition[] = " a.rep_id in (" . implode(',', $verifier_ids) . " )";
            }
        }

        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.firstname " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " b.lastname " . $not . "LIKE '%" . $t . "%' ";


                $like    .= $operator . " d.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " o.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " p.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " su.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " br.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.case_no " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " pri.date_ofupdate " . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";


                $condition[] = $like;
                //print_r($condition);exit;
            }
        }
        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {

            $checkteam = $this->config->item('CHECKLIST', APPLICATIONCONFIG);
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            $k = 1;

            foreach ($result as $i => $row) {


                $company_details = $this->vm->get_verifiedcompany_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);
                $education_details = $this->vm->get_verifiedcollege_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);
                $professional_details = $this->vm->get_verifiedprofessional_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);

                $verified_data = $this->vm->get_verified_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);
                $verification_data = toArray(json_decode($verified_data['fielddata']));
                $vm_expenses  = toArray(json_decode($verified_data['vmexpenses']));
                $qc2verification_data = toArray(json_decode($verified_data['qc2fielddata']));

                $reqstatus = '';
                if (!empty($row['reqstatus'])) {
                    $req_raised_status = $this->vm->get_status($row['reqstatus']);
                    $reqstatus = $req_raised_status['name'];
                }
                $rpt_status = '';
                if ($verification_data['status'] != 107 && $verification_data['status'] != 684 && $verification_data['status'] != 992 && !empty($verification_data['status'])) {
                    if ($status3['name'] == "Discrepant" || $status3['name'] == "Possible Discrepant" || $status3['name'] == "Record Found" || $status3['name'] == "Positive" || $status3['name'] == "No Records" || $status3['name'] == "Invalid" || $status3['name'] == "Not Completed" || $status3['name'] == "High Risk") {
                        $rpt_status = "<span style='color:red;'>RED</span>";
                    }
                    // May 24th
                    else if ($status1['name'] == "Stop Check" || $status1['name'] == "Others" || $status3['name'] == "Stop Check" || $status3['name'] == "Others" || $status3['name'] == "Possible Match" || $status3['name'] == "Partial Match") {
                        $rpt_status = "<span style='color:orange;'>ORANGE</span>";
                    } else {
                        $rpt_status = "<span style='color:green;'>GREEN</span>";
                    }
                }
                $checkstatus = $this->vm->getstatus_of_can($row['candidate_req_id'], $row['checkId']);
                $checkadminstatus = $this->vm->get_currentstatus($row['candidate_req_id']);
                $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');

                $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                $candidatename = $row['candidatename'];
                if ($row['vm_revert_option_status'] == 1 && $row['vm_revert_to'] == 2) {
                    $verifyurl = 'Revert Raised to DEO';
                } else if ($row['qc_revert_request'] == 1) {
                    if ($row['vm_assigned_qc'] == 1 && $row['verify_status'] <> 107 && $row['verify_status'] <> 684 && $row['verify_status'] <> 992) {
                        $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                        $verifyurl = 'Revert Rectified';
                    } else if ($row['vm_assigned_qc'] == 0 && $row['ass_request'] == 0 && $row['supplementary'] == 1 && $row['qc_revert_request'] == 1 && $row['reopen_revert_qc'] == 0 && $row['reopen_revert_qc2'] == 1) {
                        $verifyurl = 'Reopen Assigned';
                    } else if ($row['vm_assigned_qc'] == 0 && $row['ass_request'] == 0 && $row['supplementary'] == 1 && $row['qc_revert_request'] == 1 && $row['reopen_revert_qc'] == 1 && $row['reopen_revert_qc2'] == 1) {
                        $verifyurl = 'Reopen Assigned';
                    } else {

                        $verifyurl = 'Revert Assigned';
                    }
                } elseif ($row['verify_status'] == 111 && $row['vrequest'] == 0 && $row['ass_request'] == 0) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 3 && $row['vm_revert_to'] == 2) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_option_status'] == 3 && $row['vm_revert_to'] == 2) {
                    $verifyurl = 'Revert Closed';
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 4 && $row['operator_submited_by'] == 12 || $row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 4 && $checkadminstatus['role_id'] == 13) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_option_status'] == 4 && $row['operator_submited_by'] == 12 || $row['vm_revert_option_status'] == 4 && $checkadminstatus['role_id'] == 13) {
                    $verifyurl = 'Revert Closed';
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_to'] == 3 && $row['vm_revert_supervisor'] == 0) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_to'] == 3 && $row['vm_revert_supervisor'] == 0) {
                    $verifyurl = 'Revert Closed';
                } else if ($row['verify_status'] <> '111' && $row['vrequest'] == 1 && $row['rstatus'] != 0 && $row['ass_request'] == 0) {
                    if ($row['rstatus'] == 108)
                        $vst = 'Inputs Required';
                    else if ($row['rstatus'] == 110)
                        $vst = 'Stop Check';
                    else if ($row['rstatus'] == 109)
                        $vst = 'Awaiting Authorisation';
                    else if ($row['rstatus'] == 107)
                        $vst = 'Initiated';
                    else if ($row['rstatus'] == 519)
                        $vst = 'Others';
                    else if ($row['rstatus'] == 684)
                        $vst = 'Request Raised';
                    else if ($row['rstatus'] == 992)
                        $vst = 'DD applied';

                    if ($row['rstatus'] == 110 || $row['rstatus'] == 519) {
                        $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    } else {
                        $verifyurl = $vst;
                    }

                    $requesttoass = '';
                } else if ($row['verify_status'] == '111' && $row['vrequest'] == 1 && $row['rstatus'] != 0 && $row['ass_request'] == 0) {
                    if ($row['rstatus'] == 108)
                        $vst = 'Inputs Required';
                    else if ($row['rstatus'] == 110)
                        $vst = 'Stop Check';
                    else if ($row['rstatus'] == 109)
                        $vst = 'Awaiting Authorisation';
                    else if ($row['rstatus'] == 107 && $row['verify_status'] == '111')
                        $vst = 'Verified';
                    else if ($row['rstatus'] == 107)
                        $vst = 'Initiated';
                    else
                        $vst = 'Verified';

                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">' . $vst . '</p>';
                    $requesttoass = '';
                } else if ($row['ass_request'] == 1) {
                    $verifyurl = 'Request Raised';
                    $requesttoass = 'Sent to Associate';
                    $add_calls = '';
                } else {
                    $save['request_id'] = $row['candidate_req_id'];
                    $save['check_id'] = $row['checkId'];
                    $save['level_id'] = $row['level_id'];
                    $this->db->select('count(*) as cnt');
                    $this->db->where($save);
                    $countnoti = $this->db->get(DB_PREFIX . 'notification_emails')->row_array();

                    if ($countnoti['cnt'] >= 1)
                        $vtext = 'Sent Mail to Resource';
                    else
                        $vtext = 'New';




                    $verifyurl = $vtext;
                    $vst = $row['status'];
                    $requesttoass = '';
                }
                $slug = url_title(convert_accented_characters($row['checkname']), 'underscore', TRUE);


                if ($row['checkid'] == 14)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'education_details');
                else if ($row['checkid'] == 16)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'contact_details', 'request_id', 'permanent_address');
                else if ($row['checkid'] == 59)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'employment', 'req_id', 'level_id');
                else if ($row['checkid'] == 76 || $row['checkid'] == 77 || $row['checkid'] == 75)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], $slug, 'request_id', 'level_name');
                else
                    $levelnames['level'] = $row['checkname'];

                if ($row['status'] == 'Initiated')
                    $rowstatus = 'Assigned in VM';
                else
                    $rowstatus = $row['status'];
                if ($row['chk'] == 0) {
                    $chkval = $row['checkname'];
                } else {
                    $chkval = $row['checkname'] . $row['chk'];
                }
                if (!empty($status1['name'])) {
                    $stat = $status1['name'] . '-' . $status2['name'] . '-' . $status3['name'] . '' . $status41;
                } else {
                    $stat = '';
                }


                if ($row['priority'] == 100)
                    $priority = "<span style='color:Red;'>High</span>";
                else
                    $priority = 'Low';
                if ($row['date_ofupdate'])
                    $Date = date('d-m-Y', strtotime($row['date_ofupdate']));
                else
                    $Date = ' ';
                $response->rows[$i]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], anchor('/Dadmin/dadminview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['checkId']), $candidatename), $row['case_no'], $chkval, $verifyurl, $priority, $row['vname'], $Date, $row['comments']);
            }
        }

        echo json_encode($response);
    }



    /******** Reminder List ***********
     ******* function reminder_list****
     **********************************/
    function reminder_list()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Reminder List', 'Verification/reminder_list');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'reminder_list');
    }


    function get_reminder_list()
    {

        $model = array('Verification_model' => 'get_reminderList');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $term = ($_REQUEST['term']) ? $_REQUEST['term'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $company_name = ($_REQUEST['company_name']) ? $_REQUEST['company_name'] : '';
        $college_name = ($_REQUEST['college_name']) ? $_REQUEST['college_name'] : '';
        $university_name = ($_REQUEST['university_name']) ? $_REQUEST['university_name'] : '';
        $verifier_name = ($_REQUEST['verifier_name']) ? $_REQUEST['verifier_name'] : '';
        $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
        $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : '';
        $request_status = ($_REQUEST['request_status']) ? $_REQUEST['request_status'] : '';
        $chk_status = ($_REQUEST['chk_status']) ? $_REQUEST['chk_status'] : '';
        $verified_status = ($_REQUEST['verified_status']) ? $_REQUEST['verified_status'] : '';


        $reopen_status = ($_REQUEST['reopen_status']) ? $_REQUEST['reopen_status'] : '';
        $additional_docs = ($_REQUEST['additional_docs']) ? $_REQUEST['additional_docs'] : '';
        $check_count = ($_REQUEST['check_count']) ? $_REQUEST['check_count'] : '';
        $date_filter = ($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
        $check_type  = ($_REQUEST['check_type']) ? $_REQUEST['check_type'] : '';
        // $reminder  = ($_REQUEST['reminder']) ? $_REQUEST['reminder'] : '';
        $ticket_status = ($_REQUEST['ticket_status']) ? $_REQUEST['ticket_status'] : '';

        if (!empty($ticket_status)) {
            $condition[] = " td.ticket_status =" . $ticket_status;
        }
        if ($org_id)
            $condition[] = " o.id = " . $org_id;
        if ($office)
            $condition[] = " br.id = " . $office;
        if ($parent_office)
            $condition[] = " p.id = " . $parent_office;
        if ($sub_office)
            $condition[] = " su.id = " . $sub_office;
        if ($name)
            $condition[] = "b.firstname like '%" . $name . "%' ";
        if ($check_name)
            $condition[] = "c.name like '%" . $check_name . "%' ";
        if ($company_name)
            $condition[] = "((em.company_name like '%" . $company_name . "%'  and a.check_id = 59) || (pr.company_name like '%" . $company_name . "%'  and a.check_id = 68))";
        if ($college_name)
            $condition[] = "(ed.collegename_add like '%" . $college_name . "%'  and a.check_id = 14)";
        if ($university_name)
            $condition[] = "(ed.affliated like '%" . $university_name . "%'  and a.check_id = 14)";
        if ($this->session->userdata['role_id'] == 1 || $this->session->userdata['role_id'] == 24 || $this->session->userdata['role_id'] == 9 || $this->session->userdata['role_id'] == 21) {
            if ($a_status == 0)
                $condition[] = "((a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0) or (a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1) or (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111) or (a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107) or (s.vm_revert_option_status = 1 and a.vm_revert_to = 2) or (a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1) or (a.verify_status = 992 and a.qc_revert_request !=1) or ( a.vm_assigned_qc = 0 and a.ass_request = 0 and vl1.supplementary = 1 and a.qc_revert_request = 1 and a.reopen_revert_qc2 = 1)) ";
        }
        if ($a_status == 1)
            $condition[] = "( a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0)";
        if ($a_status == 2)
            $condition[] = " (a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1)";
        if ($a_status == 3)
            $condition[] = " (a.qc_revert_request = 1 and a.vm_assigned_qc=1 and a.verify_status not in(107,684,992))";
        if ($a_status == 4)
            $condition[] = " a.ass_request = 1 ";
        if ($a_status == 5)
            $condition[] = " (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111)";
        if ($a_status == 6)
            $condition[] = "((a.verify_status in (110,111,519)) and a.ass_request=0 and a.qc_revert_request = 0 )";
        if ($a_status == 7)
            $condition[] = "(a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107)";
        if ($a_status == 8)
            $condition[] = "s.vm_revert_option_status = 1 and a.vm_revert_to = 2";
        if ($a_status == 9)
            $condition[] = " a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1";
        if ($a_status == 10)
            $condition[] = " a.verify_status = 992 and a.qc_revert_request !=1";
        if ($a_status == 11)
            $condition[] = " a.vm_assigned_qc = 0 and a.ass_request = 0 and vl1.supplementary = 1 and a.qc_revert_request = 1 ";
        if ($a_status == 12)
            $condition[] = " ";
        if ($case_no)
            $condition[] = "d.case_no like '%" . $case_no . "' ";


        /* if($reminder){
          		$condition[]="adc.email_count =  ".$reminder." ";
		 }*/



        if ($check_type == 1)
            $condition[] = "c.id = 15";
        if ($check_type == 2)
            $condition[] = "c.id = 16";
        if ($check_type == 3)
            $condition[] = "c.id = 71";
        if ($check_type == 4)
            $condition[] = "c.id = 639";
        if ($check_type == 5)
            $condition[] = "c.id = 640";
        if ($check_type == 6)
            $condition[] = "c.id = 636";
        if ($check_type == 7)
            $condition[] = "c.id = 75";

        // if($check_count == 'currentEmpAuth'){
        // 	$condition[]=" vl1.reqstatus = 710";
        // }
        // else if($check_count == 'DDAuth'){
        // 	$condition[]=" vl1.reqstatus = 704";
        // }else if($check_count == 'NeedPin'){
        // 	$condition[]=" vl1.reqstatus = 714";
        // }else if($check_count == 'CompPermanentAddr'){
        // 	$condition[]=" vl1.reqstatus = 715";
        // }else if($check_count == 'CompCurrententAddr'){
        // 	$condition[]=" vl1.reqstatus = 716";
        // }else if($check_count == 'FatherName'){
        // 	$condition[]=" vl1.reqstatus = 717";
        // }else if($check_count == 'ContactNo'){
        // 	$condition[]=" vl1.reqstatus = 718";
        // }else if($check_count == 'CompleteAddr'){
        // 	$condition[]=" vl1.reqstatus = 719";
        // }else if($check_count == 'NeedDOB'){
        // 	$condition[]=" vl1.reqstatus = 720";
        // }else if($check_count == 'Aadhar'){
        // 	$condition[]=" vl1.reqstatus = 721";
        // }else if($check_count == 'PermanentAddWithPIN'){
        // 	$condition[]=" vl1.reqstatus = 722";
        // }else if($check_count == 'PAN_no'){
        // 	$condition[]=" vl1.reqstatus = 723";
        // }else if($check_count == 'PAN_Card'){
        // 	$condition[]=" vl1.reqstatus = 724";
        // }else if($check_count == 'Passport'){
        // 	$condition[]=" vl1.reqstatus = 725";
        // }else if($check_count == 'DL'){
        // 	$condition[]=" vl1.reqstatus = 726";
        // }else if($check_count == 'CurrentAddrWithPin'){
        // 	$condition[]=" vl1.reqstatus = 727";
        // }else if($check_count == 'AppliedDD'){
        // 	$condition[]=" vl1.reqstatus = 752";
        // }else if($check_count == 'VoterID'){
        // 	$condition[]=" vl1.reqstatus = 778";
        // }else if($check_count == 'Form_16'){
        // 	$condition[]=" vl1.reqstatus = 780";
        // }else if($check_count == 'Other'){
        // 	$condition[]=" vl1.reqstatus = 713";
        // }else if($check_count == 'AdditionalDDAuth'){
        // 	$condition[]=" vl1.reqstatus = 705";
        // }else if($check_count == 'AdditionalDOC'){
        // 	$condition[]=" vl1.reqstatus = 706";
        // }else if($check_count == 'AdditionalInfo'){
        // 	$condition[]=" vl1.reqstatus = 707";
        // }else if($check_count == 'AdditionalCharge'){
        // 	$condition[]=" vl1.reqstatus = 711";
        // }else if($check_count == 'ClientNameDiscloser'){
        // 	$condition[]=" vl1.reqstatus = 708";
        // }else if($check_count == 'ShareOLA'){
        // 	$condition[]=" vl1.reqstatus = 709";
        // }else if($check_count == 'NeedClarification'){
        // 	$condition[]=" vl1.reqstatus = 712";
        // } 

        // else{

        // 	if($check_count && $this->session->userdata['role_id']==5){
        // 	$rep_id= " (SELECT  GROUP_CONCAT(ar.rep_id) as verifier from dcode_ver_assign_rep ar
        // 	      where (ar.verify_status =107 or ar.vm_assigned_qc=0 or ar.verify_status =684 ) group by ar.candidate_req_id having count(ar.candidate_req_id)=".$check_count.")" ;
        // 	      $rid=$this->db->query($rep_id)->result_array();
        // 	      foreach ($rid as  $rvalue) {
        // 	      	$verifier_ids[]=$rvalue['verifier'];
        // 	      }
        // 	$condition[]=" a.rep_id in (".implode(',',$verifier_ids)." )";
        // 	}
        // 	if($check_count && (in_array($this->session->userdata['role_id'], array(1,9,21,24)))) {
        // 	$rep_id= " (SELECT  GROUP_CONCAT(ar.rep_id) as verifier from dcode_ver_assign_rep ar
        // 	      where (ar.verify_status =107 or ar.vm_assigned_qc=0 or ar.verify_status =684 ) group by ar.candidate_req_id having count(ar.candidate_req_id)=".$check_count.")" ;
        // 	      $rid=$this->db->query($rep_id)->result_array();
        // 	      foreach ($rid as  $rvalue) {
        // 	      	$verifier_ids[]=$rvalue['verifier'];
        // 	      }
        // 	$condition[]=" a.rep_id in (".implode(',',$verifier_ids)." )";
        // 	}
        // }

        if ($term) {
            //support multiple words
            $search = explode(' ', $term);

            foreach ($search as $t) {
                $not        = '';
                $operator    = 'OR';
                if (substr($t, 0, 1) == '-') {
                    $not        = 'NOT ';
                    $operator    = 'AND';
                    //trim the - sign off
                    $t        = substr($t, 1, strlen($t));
                }

                $like    = '';
                $like    .= "( b.firstname " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " b.lastname " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " f.order_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vs.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.candidate_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " o.org_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " p.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " su.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " br.office_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " d.case_no " . $not . "LIKE '%" . $t . "%' ";

                $like    .= $operator . " ed.collegename_add " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " ed.affliated " . $not . "LIKE '%" . $t . "%' ";

                $like    .= $operator . " em.company_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " pr.company_name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " vr.deadline_from " . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";
                $like    .= $operator . " vr.deadline_to " . $not . " LIKE '%" . date('Y-m-d', strtotime($t)) . "%' ";
                $like    .= $operator . " vl1.reqstatus " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " c.name " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " verify_status " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.additional_docs " . $not . "LIKE '%" . $t . "%' ";
                $like    .= $operator . " a.vm_revert_status " . $not . "LIKE '%" . $t . "%' ) ";

                $condition[] = $like;
            }
        }
        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $checkteam = $this->config->item('CHECKLIST', APPLICATIONCONFIG);
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            $k = 1;

            foreach ($result as $i => $row) {
                // $company_details=$this->vm->get_verifiedcompany_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
                // $education_details=$this->vm->get_verifiedcollege_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);
                // $professional_details=$this->vm->get_verifiedprofessional_data($row['candidate_req_id'],$row['level_id'],$row['checkId']);

                $verified_data = $this->vm->get_verified_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);
                $verification_data = toArray(json_decode($verified_data['fielddata']));
                // $vm_expenses  = toArray(json_decode($verified_data['vmexpenses']));
                $qc2verification_data = toArray(json_decode($verified_data['qc2fielddata']));

                // if($vm_expenses<>null){


                //          if($vm_expenses[0]['ddcurrency']){

                //                 $ddcurrencyid =   $vm_expenses[0]['ddcurrency'];

                //              $results = $this->amodel->getDetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'currencykey', 'id' => $ddcurrencyid));

                //                  $currencyname =   $results[0]['name'];
                //              }
                //              else
                //              {
                //                   $currencyname = '';
                //              }

                //   $d_amount = 0;
                // foreach($vm_expenses as $key => $dd_exprenses) {

                //           $d_amount += $dd_exprenses['amount'];

                // 	    }

                // 	    $dd_amount = $currencyname .' ' . $d_amount;
                //   }
                //   else
                //   {
                //   	  $dd_amount = '';
                //   }


                // $status1=$this->vm->get_status($verification_data['status']);
                // $status4='';
                //       $status2=$this->vm->get_status($verification_data['pstatus']);
                //       $status3=$this->vm->get_status($verification_data['status1']);
                //       if($verification_data['ostatus']<>'')
                //       $status4=$this->vm->get_status($verification_data['ostatus']);
                //       if($verification_data['dstatus']<>'')
                //       $status4=$this->vm->get_status($verification_data['dstatus']);
                //   	if(!empty($status4))
                //       $status41='-'.$status4['name'];
                //       else
                //       $status41='';

                //  	$reqstatus='';
                //  	if(!empty($row['reqstatus'])){ 
                //  	$req_raised_status=	$this->vm->get_status($row['reqstatus']); 
                //  	$reqstatus= $req_raised_status['name'];
                //  	}
                //  	$rpt_status='';
                //  	if($verification_data['status']!=107 && $verification_data['status']!=684 && $verification_data['status']!=992 && !empty($verification_data['status'])) {
                // if($status3['name']=="Discrepant" || $status3['name']=="Possible Discrepant" || $status3['name']=="Record Found" || $status3['name']=="Positive" || $status3['name']=="No Records" || $status3['name']=="Invalid" || $status3['name']=="Not Completed" || $status3['name']=="High Risk"){
                // 	$rpt_status="<span style='color:red;'>RED</span>";
                // }
                // else if($status1['name']=="Stop Check" || $status1['name']=="Others" || $status3['name']=="Stop Check" || $status3['name']=="Others" || $status3['name']=="Partial Match"){
                // 	$rpt_status="<span style='color:orange;'>ORANGE</span>";
                // }
                // else 
                // {
                // 	$rpt_status="<span style='color:green;'>GREEN</span>";
                // }
                //  	}
                $checkstatus = $this->vm->getstatus_of_can($row['candidate_req_id'], $row['checkId']);
                $checkadminstatus = $this->vm->get_currentstatus($row['candidate_req_id']);
                $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');

                $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                $candidatename = $row['candidatename'];
                if ($row['vm_revert_option_status'] == 1 && $row['vm_revert_to'] == 2) {
                    $verifyurl = 'Revert Raised to DEO';
                } else if ($row['qc_revert_request'] == 1) {
                    if ($row['vm_assigned_qc'] == 1 && $row['verify_status'] <> 107 && $row['verify_status'] <> 684 && $row['verify_status'] <> 992) {
                        $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                        $verifyurl = 'Revert Rectified';
                    } else if ($row['vm_assigned_qc'] == 0 && $row['ass_request'] == 0 && $row['supplementary'] == 1 && $row['qc_revert_request'] == 1 && $row['reopen_revert_qc'] == 0 && $row['reopen_revert_qc2'] == 1) {
                        $verifyurl = anchor('/Verification/revert_raisedsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']) . '/' . base64_encode(1004), 'Reopen Assigned', 'target="_blank"');
                    } else if ($row['vm_assigned_qc'] == 0 && $row['ass_request'] == 0 && $row['supplementary'] == 1 && $row['qc_revert_request'] == 1 && $row['reopen_revert_qc'] == 1 && $row['reopen_revert_qc2'] == 1) {
                        $verifyurl = anchor('/Verification/revert_raisedsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']) . '/' . base64_encode(1004), 'Reopen Assigned', 'target="_blank"');
                    } else {

                        $verifyurl = anchor('/Verification/revert_raisedsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Assigned', 'target="_blank"');
                    }
                } elseif ($row['verify_status'] == 111 && $row['vrequest'] == 0 && $row['ass_request'] == 0) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 3 && $row['vm_revert_to'] == 2) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_option_status'] == 3 && $row['vm_revert_to'] == 2) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 4 && $row['operator_submited_by'] == 12 || $row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 4 && $checkadminstatus['role_id'] == 13) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_option_status'] == 4 && $row['operator_submited_by'] == 12 || $row['vm_revert_option_status'] == 4 && $checkadminstatus['role_id'] == 13) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_to'] == 3 && $row['vm_revert_supervisor'] == 0) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_to'] == 3 && $row['vm_revert_supervisor'] == 0) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] <> '111' && $row['vrequest'] == 1 && $row['rstatus'] != 0 && $row['ass_request'] == 0) {
                    if ($row['rstatus'] == 108)
                        $vst = 'Inputs Required';
                    else if ($row['rstatus'] == 110)
                        $vst = 'Stop Check';
                    else if ($row['rstatus'] == 109)
                        $vst = 'Awaiting Authorisation';
                    else if ($row['rstatus'] == 107)
                        $vst = 'Initiated';
                    else if ($row['rstatus'] == 519)
                        $vst = 'Others';
                    else if ($row['rstatus'] == 684)
                        $vst = 'Request Raised';
                    else if ($row['rstatus'] == 992)
                        $vst = 'DD applied';

                    if ($row['rstatus'] == 110 || $row['rstatus'] == 519) {
                        $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    } else {
                        $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">' . $vst . '</p>', 'target="_blank"');
                    }

                    $requesttoass = '';
                } else if ($row['verify_status'] == '111' && $row['vrequest'] == 1 && $row['rstatus'] != 0 && $row['ass_request'] == 0) {
                    if ($row['rstatus'] == 108)
                        $vst = 'Inputs Required';
                    else if ($row['rstatus'] == 110)
                        $vst = 'Stop Check';
                    else if ($row['rstatus'] == 109)
                        $vst = 'Awaiting Authorisation';
                    else if ($row['rstatus'] == 107 && $row['verify_status'] == '111')
                        $vst = 'Verified';
                    else if ($row['rstatus'] == 107)
                        $vst = 'Initiated';
                    else
                        $vst = 'Verified';

                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">' . $vst . '</p>';
                    $requesttoass = '';
                } else if ($row['ass_request'] == 1) {
                    $verifyurl = 'Request Raised';
                    $requesttoass = 'Sent to Associate';
                    $add_calls = '';
                } else {
                    $save['request_id'] = $row['candidate_req_id'];
                    $save['check_id'] = $row['checkId'];
                    $save['level_id'] = $row['level_id'];
                    $this->db->select('count(*) as cnt');
                    $this->db->where($save);
                    $countnoti = $this->db->get(DB_PREFIX . 'notification_emails')->row_array();

                    if ($countnoti['cnt'] >= 1)
                        $vtext = 'Sent Mail to Resource';
                    else
                        $vtext = 'New';




                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $vtext, 'target="_blank"');
                    $vst = $row['status'];
                    $requesttoass = '';
                }
                $slug = url_title(convert_accented_characters($row['checkname']), 'underscore', TRUE);


                if ($row['checkid'] == 14)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'education_details');
                else if ($row['checkid'] == 16)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'contact_details', 'request_id', 'permanent_address');
                else if ($row['checkid'] == 59)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], 'employment', 'req_id', 'level_id');
                else if ($row['checkid'] == 76 || $row['checkid'] == 77 || $row['checkid'] == 75)
                    $levelnames = $this->vm->get_level_name($row['candidate_req_id'], $row['checkid'], $row['level_id'], $slug, 'request_id', 'level_name');
                else
                    $levelnames['level'] = $row['checkname'];

                if ($row['status'] == 'Initiated')
                    $rowstatus = 'Assigned in VM';
                else
                    $rowstatus = $row['status'];
                if ($row['chk'] == 0) {
                    $chkval = $row['checkname'];
                } else {
                    $chkval = $row['checkname'] . $row['chk'];
                }

                // if(!empty($status1['name'])){
                // 	$stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
                // }else{
                // 	$stat='';
                // }
                // if($row['checkid']==14){
                // $clgname=$education_details['collegename_add'];
                // $uniname=$education_details['affliated'];	
                // }else{
                // 	$clgname='';
                // 	$uniname='';
                // }


                // if($row['checkid']==59){
                // 	$cmpnyname=$company_details['company_name'];
                // }else if($row['checkid']==68){
                // $cmpnyname=$professional_details['company_name'];
                // }else{
                // 	$cmpnyname='';
                // }
                // $supplement='';
                // if($row['supplementary']==1 || $row['supplementary']==2)
                // {
                // $supplement='Reopen';
                // }
                // elseif($row['supplementary']==3){
                // $supplement='Reopen-Completed';
                // } 
                // $deadline_from=isset($row['deadline_from'])? date('d-m-Y',strtotime($row['deadline_from'])) : '';
                // $deadline_to=isset($row['deadline_to'])? date('d-m-Y',strtotime($row['deadline_to'])) : '';

                // $v_date=isset($row['v_date'])? date('d-m-Y',strtotime($row['v_date'])) : '';
                // $req_raise_date=isset($row['vm_request_raised_date'])? date('d-m-Y',strtotime($row['vm_request_raised_date'])) : '';

                //    $dd_recived = 	$qc2verification_data['dd_recevied_form'];

                //             if($dd_recived == 1){
                //                $dd_status = 'None';
                //              }
                //              elseif($dd_recived == 2){
                //                    $dd_status = 'University';
                //              }
                //              elseif($dd_recived == 3){
                //                    $dd_status = 'College';
                //              }
                //              elseif($dd_recived == 4){
                //                    $dd_status = 'Company';
                //              }
                //              elseif($dd_recived == 5){
                //                    $dd_status = 'University and College';
                //              }
                //              else
                //              {
                //                $dd_status = '';
                //              }

                //              $veri_received =   $qc2verification_data['veri_received_dropdown'];

                //              if($veri_received == 1){
                //              	$veri_received_data  = "Recevied";
                //              }
                //              elseif($veri_received == 2)
                //              {
                //                 $veri_received_data  = "Not received";
                //              }
                //              else
                //              {
                //              	$veri_received_data = '';
                //              }


                // if($row['ticket_status']==1){
                // 	$tktStatus='Open';
                // }
                // else if($row['ticket_status']==2){
                // 	$tktStatus='Requested';
                // }
                // else if($row['ticket_status']==3){
                // 	$tktStatus='Revert';
                // }
                // else if($row['ticket_status']==4){
                // 	$tktStatus='Re-Requested';
                // }
                // else if($row['ticket_status']==5){
                // 	$tktStatus='Re-Open';
                // }
                // else if($row['ticket_status']==101){
                // 	$tktStatus='Closed';
                // }else{
                // 	$tktStatus='';
                // }

                //       $startDate=date('Y-m-d',strtotime($row['requested_date']));
                // $endDate=date('Y-m-d');
                // $workingDays = $this->number_of_working_days($startDate, $endDate);

                //       if(($row['ticket_status']==2 && $workingDays > 7) || ($row['ticket_status']==4 && $workingDays > 7) || ($row['ticket_status']==3 || $row['ticket_status']==101) && $row['rstatus']==684){
                //       	$tktStatus="<span style='background-color:yellow;'>".$tktStatus."</span>";
                //       }
                //       else if(($row['ticket_status']==2 && $workingDays > 7) || ($row['ticket_status']==4 && $workingDays > 7) || ($row['ticket_status']==3 || $row['ticket_status']==101) && ($row['qc_revert_request']==1 && $row['verify_status']==684) ){
                //       	$tktStatus="<span style='background-color:yellow;'>".$tktStatus."</span>";
                //       }
                //       else if($row['rstatus'] !=684){
                //       	$tktStatus='';
                //       }else if($row['qc_revert_request'] !=1 && $row['verify_status'] !=684){
                //       	$tktStatus='';
                //       }
                //       else{
                //       	$tktStatus=$tktStatus;
                //       }


                $response->rows[$i]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], anchor('/Dadmin/dadminview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['checkId']), $candidatename), $row['case_no'], $chkval, $verifyurl, '', $deadline_from, $deadline_to, '', '', $procedure_details, anchor('/Dadmin/dadminview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['checkId']), 'View'));
            }
        }

        echo json_encode($response);
    }






    /*********************************************************************
     ******* Tracker for VM ****************
     ******* function tracker****************
     ******* Added by Kp Chandan ************
     **********************************************************************/
    function tracker()
    {
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push("Tracker-Lists", 'Verification/tracker');

        $data['title'] = 'Tracker';
        $data['breadcrumb'] = $this->breadcrumbs->show();

        $this->amodel->pagerender($data, 'tracker');
    }
    /**********************************************
     ******* Tracker for VM **********************
     ******* function tracker_list****************
     ******* Added by Kp Chandan *****************
     *********************************************/

    function tracker_list()
    {

        // print_r($_POST);
        if ($_POST['memVal']) {
            $memtype = $_POST['memVal'];
        } else {
            $memtype = 0;
        }

        if ($_POST['role_id'] == 17 || $_POST['memVal'] == 17) {
            $year = date("Y-m-d");
            $current = "Today";
            $back = "Yesterday";
            $prev = "Previous Days";
            $prevDay = date('Y-m-d', strtotime('-1 day', strtotime($year)));
        } else {
            $year = date("Y");
            $current = $year;
            $back = ($year - 1);
            $prev = "Previous Years";
        }

        if ($_POST['radio_button_value'] == 1 && $_POST['role_id'] != 17) {

            $labelName = "Members Name";
            $type = 'member';

            if ($_POST['role_id'] == 1) {
                if ($_POST['memVal'] == 5) {
                    $allMembers = $this->qc->get_verifymembers();
                    $all_yearData = $this->qc->get_vmemberforvs_allYear();
                } else if ($_POST['memVal'] == 17) {
                    $allMembers = $this->qc->get_qcmembers();
                    $all_yearData = $this->qc->get_qcmemberforadm_allYear();
                }
            } else {
                $allMembers = $this->qc->get_verifymembers();
                $all_yearData = $this->qc->get_vmemberforvs_allYear();
            }


            $yearlyCount = array();
            foreach ($allMembers as $field => $value) {
                $yearlyCount[$value['user_id']] = [0, 0, 0, $value['count'], $value['vname']];
            }

            foreach ($all_yearData as $key => $val) {

                $keyExists = array_key_exists($val['user_id'], $yearlyCount);

                if ($keyExists) {

                    if ($_POST['role_id'] == 17 || $_POST['memVal'] == 17) {

                        if ($val['year'] == $year) {
                            $yearlyCount[$val['user_id']][2] = $val['count'];
                        } else if ($val['year'] == $prevDay) {
                            $yearlyCount[$val['user_id']][1] = $val['count'];
                        } else {
                            $yearlyCount[$val['user_id']][0] += $val['count'];
                        }
                    } else {
                        if ($val['year'] == $year) {
                            $yearlyCount[$val['user_id']][2] = $val['count'];
                        } else if ($val['year'] == $year - 1 || $val['year'] == $prevDay) {
                            $yearlyCount[$val['user_id']][1] = $val['count'];
                        } else {
                            $yearlyCount[$val['user_id']][0] += $val['count'];
                        }
                    }
                }
            }
        } else if ($_POST['radio_button_value'] == 2) {

            $labelName = "Organization Name";
            $type = 'organization';

            if ($_POST['role_id'] == 17) {
                $allOrganisation = $this->qc->get_qcpending_organisation();
                $all_yearData = $this->qc->get_qcmpending_orgwise();
            } else if ($_POST['role_id'] == 1) {

                if ($_POST['memVal'] == 17) {
                    $allOrganisation = $this->qc->get_qcpending_organisation();
                    $all_yearData = $this->qc->get_qcmpending_admorgwise();
                } else if ($_POST['memVal'] == 5) {
                    $allOrganisation = $this->qc->get_vmpending_organisation($_POST['memVal']);
                    $all_yearData = $this->qc->get_vmpending_orgwise($_POST['role_id']);
                } else {
                    $allOrganisation = $this->qc->get_vmpending_organisation($_POST['memVal']);
                    $all_yearData = $this->qc->get_admpending_orgwise();
                }
            } else {
                $allOrganisation = $this->qc->get_vmpending_organisation();
                $all_yearData = $this->qc->get_vmpending_orgwise($_POST['role_id']);
            }

            $yearlyCount = array();
            foreach ($allOrganisation as $field => $value) {
                $yearlyCount[$value['org_id']] = [0, 0, 0, $value['count'], $value['org_name']];
            }

            foreach ($all_yearData as $key => $val) {

                $keyExists = array_key_exists($val['org_id'], $yearlyCount);

                if ($keyExists) {
                    // $year = date("Y");
                    if ($_POST['role_id'] == 17 || $_POST['memVal'] == 17) {

                        if ($val['year'] == $year) {
                            $yearlyCount[$val['org_id']][2] = $val['count'];
                        } else if ($val['year'] == $prevDay) {
                            $yearlyCount[$val['org_id']][1] = $val['count'];
                        } else {
                            $yearlyCount[$val['org_id']][0] += $val['count'];
                        }
                    } else {

                        if ($val['year'] == $year) {
                            $yearlyCount[$val['org_id']][2] = $val['count'];
                        } else if ($val['year'] == $year - 1) {
                            $yearlyCount[$val['org_id']][1] = $val['count'];
                        } else {
                            $yearlyCount[$val['org_id']][0] += $val['count'];
                        }
                    }
                }
            }
        } else {
            $labelName = "Check Name";
            $type = 'check';

            if ($_POST['role_id'] == 1) {

                if ($_POST['memVal'] == 17) {
                    $allChecks = $this->qc->get_qcpending_check();
                    $all_yearData = $this->qc->get_qcmpending_admcheckwise();
                } else if ($_POST['memVal'] == 5) {
                    $allChecks = $this->qc->get_vmpending_checks($_POST['memVal']);
                    $all_yearData = $this->qc->get_vmpending_allYear($_POST['role_id']);
                } else {
                    $allChecks = $this->qc->get_vmpending_checks($_POST['memVal']);
                    $all_yearData = $this->qc->get_admpending_allYear();
                }
            } else if ($_POST['role_id'] == 17) {
                $allChecks = $this->qc->get_qcpending_check();
                $all_yearData = $this->qc->get_qcmpending_checkwise();
            } else {
                $allChecks = $this->qc->get_vmpending_checks();
                $all_yearData = $this->qc->get_vmpending_allYear($_POST['role_id']);
            }

            $yearlyCount = array();

            foreach ($allChecks as $field => $value) {
                $yearlyCount[$value['checkId']] = [0, 0, 0, $value['count'], $value['check_name']];
            }

            foreach ($all_yearData as $key => $val) {

                $keyExists = array_key_exists($val['checkId'], $yearlyCount);

                if ($keyExists) {

                    if ($_POST['role_id'] == 17 || $_POST['memVal'] == 17) {
                        if ($val['year'] == $year) {
                            $yearlyCount[$val['checkId']][2] = $val['count'];
                        } else if ($val['year'] == $prevDay) {
                            $yearlyCount[$val['checkId']][1] = $val['count'];
                        } else {
                            $yearlyCount[$val['checkId']][0] += $val['count'];
                        }
                    } else {
                        if ($val['year'] == $year) {
                            $yearlyCount[$val['checkId']][2] = $val['count'];
                        } else if ($val['year'] == $year - 1) {
                            $yearlyCount[$val['checkId']][1] = $val['count'];
                        } else {
                            $yearlyCount[$val['checkId']][0] += $val['count'];
                        }
                    }
                }
            }
        }


        $html = "<table border='' align='center' style='width:700px;'>
                    <thead style='position: sticky;top: 0;'>
                        <tr class='at_tr' height='35' >
                        	<th class='at_th' style='width:50px;padding-left:0px;'>
                        	<h2 style='color:black;'>Sl No. </h2>
                        	</th>
                        	<th class='at_th' style='width:500px;'>
                        	<h2 style='color:black;'>" . $labelName . "</h2>
                        	</th>               
                            <th class='at_th' style='width:50px;'>
                            <h2 style='color:black;margin-right:5px;'>" . $prev . "</h2>
                            </th>
                            <th class='at_th' style='width:50px;'>
                            <h2 style='color:black;margin-right:5px;'>" . $back . "</h2>
                            </th>
                            <th class='at_th' style='width:50px;'>
                            <h2 style='color:black;margin-right:5px;'>" . $current . "</h2>
                            </th>
                            <th class='at_th' style='width:50px;'>
                            <h2 style='color:black;'>Total</h2>
                            </th>

                        </tr>
                    </thead>";
        $html .= "<tbody>";
        // echo '<pre>';print_r($yearlyCount);
        $i = 1;
        foreach ($yearlyCount as $key => $chkValue) {
            $html .= "<tr class='' height='25'>
            				<td  class='at_td' style='color:black;width:50px;height: 25px;text-align:right;padding-right: 10px;'>
                            	" . $i . "
                            </td>
                            <td  class='at_td' style='color:#022151;width:500px;height: 25px;'>
                            	<label>
                            	" . $chkValue[4] . "
                            	</label>
                            </td>

                            <td  class='at_td' style='color:#1c1b1b;width:50px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>";
            $chkValue[0] = ($chkValue[0]) ? $chkValue[0] : '';
            $html .= anchor('/Qualityverification/vm_pending_check/' . base64_encode($key) . '/' . base64_encode('backYear') . '/' . base64_encode($type) . '/' . base64_encode($memtype), '<span style="color:black">' . $chkValue[0] . '</span>', 'target=_blank') . "
                            	
                            </td>

                            <td  class='at_td' style='color:#1c1b1b;width:50px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>";
            $chkValue[1] = ($chkValue[1]) ? $chkValue[1] : '';
            $html .= anchor('/Qualityverification/vm_pending_check/' . base64_encode($key) . '/' . base64_encode('prevYear') . '/' . base64_encode($type) . '/' . base64_encode($memtype), '<span style="color:black">' . $chkValue[1] . '</span>', 'target=_blank') . "

                            </td>

                            <td  class='at_td' style='color:#1c1b1b;width:50px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>";
            $chkValue[2] = ($chkValue[2]) ? $chkValue[2] : '';
            $html .= anchor('/Qualityverification/vm_pending_check/' . base64_encode($key) . '/' . base64_encode('currYear') . '/' . base64_encode($type) . '/' . base64_encode($memtype), '<span style="color:black">' . $chkValue[2] . '</span>', 'target=_blank') . "
                            </td> 

                            <td  class='at_td' style='color:#1c1b1b;width:50px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>";
            $chkValue[3] = ($chkValue[3]) ? $chkValue[3] : '';
            $html .= anchor('/Qualityverification/vm_pending_check/' . base64_encode($key) . '/' . base64_encode('-') . '/' . base64_encode($type) . '/' . base64_encode($memtype), '<span style="color:black">' . $chkValue[3] . '</span>', 'target=_blank') . "
                            </td>

                        </tr>";
            $bforePrevYearTotal += $chkValue[0];
            $pevYearTotal += $chkValue[1];
            $currYearTotal += $chkValue[2];
            $allTotal += $chkValue[3];
            $i++;
        }

        $html .= "
                		<tr height='25'>
                			<td colspan='2' class='at_td' style='color:black;width:500px;height: 25px;'>
                            	<label style='float:right;font-weight:bold; margin-right:10px;'>
                            		Total                      	
                            	</label>
                            </td>
                			<td  class='at_td' style='color:#1c1b1b;width:50px;font-size:15px;text-align:right;padding-right: 10px;height: 25px;'>";
        $bforePrevYearTotal = ($bforePrevYearTotal) ? $bforePrevYearTotal : '';
        $html .= anchor('/Qualityverification/vm_pending_check/' . base64_encode('-') . '/' . base64_encode('backYear') . '/' . base64_encode($type) . '/' . base64_encode($memtype), '<span style="color:black">' . $bforePrevYearTotal . '</span>', 'target=_blank') . "
                             	
                            </td>

                            <td  class='at_td' style='color:#1c1b1b;width:50px;font-size:15px;text-align:right;padding-right: 10px;height: 25px;'>";
        $pevYearTotal = ($pevYearTotal) ? $pevYearTotal : '';
        $html .= anchor('/Qualityverification/vm_pending_check/' . base64_encode('-') . '/' . base64_encode('prevYear') . '/' . base64_encode($type) . '/' . base64_encode($memtype), '<span style="color:black">' . $pevYearTotal . '</span>', 'target=_blank') . "
                            	
                            </td>

                            <td  class='at_td' style='color:#1c1b1b;width:50px;font-size:15px;text-align:right;padding-right: 10px;height: 25px;'>";
        $currYearTotal = ($currYearTotal) ? $currYearTotal : '';
        $html .= anchor('/Qualityverification/vm_pending_check/' . base64_encode('-') . '/' . base64_encode('currYear') . '/' . base64_encode($type) . '/' . base64_encode($memtype), '<span style="color:black">' . $currYearTotal . '</span>', 'target=_blank') . "
                             	
                            </td> 

                            <td  class='at_td' style='color:#1c1b1b;width:50px;font-size:15px;text-align:right;padding-right: 10px;height: 25px;'>";
        $allTotal = ($allTotal) ? $allTotal : '';
        $html .= anchor('/Qualityverification/vm_pending_check/' . base64_encode('-') . '/' . base64_encode('-') . '/' . base64_encode($type) . '/' . base64_encode($memtype), '<span style="color:black">' . $allTotal . '</span>', 'target=_blank') . "
                            	
                            </td>
                		</tr>
                	</tbody>
                </table>";

        echo $html;
    }


    /******* QC Status for QC ****************
     ******* function qc2_status****************
     ******* Added by Kp Chandan ************/
    function qc2_status()
    {
        // $revertid = $this->vm->get_revert_list($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='count');
        $revertclosed = $this->vm->get_revert_closed($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='count');

        $newcaselist = $this->vm->get_newcaselist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='count');

        $acc = $this->vm->get_qc2accallottedlist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='count');

        $discrepancy_data = $this->vm->get_qc2discrepencylist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='count');

        $reopenclosed = $this->vm->get_reopen_closed($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='count');

        // $QC_Members=$this->qc->get_qcmembers();

        $data['revert_raised']  =  $revertid[0]['count'];
        $data['revert_closed']  =  $revertclosed[0]['count'];
        $data['newcase_list']  =  $newcaselist[0]['count'];
        $data['acc_data']  =  $acc[0]['count'];
        $data['discrepancy_data']  =  $discrepancy_data[0]['count'];
        $data['reopen_closed']  =  $reopenclosed[0]['count'];

        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push("QC-Status", 'Verification/qc2_status');

        $data['title'] = 'QC2 Status';
        $data['breadcrumb'] = $this->breadcrumbs->show();

        $this->amodel->pagerender($data, 'qc2_status');
    }


    function get_qc2_status()
    {

        if ($this->session->userdata('role_id') == 17) {
            $userId = $this->session->userdata('userid');
            $QC_Members = $this->qc->get_qcmember($userId);
        } else {
            $QC_Members = $this->qc->get_qualitycheck2_list();
        }

        // print_r($QC_Members);exit;
        $html = "<table border='' align='center' style='width:900px;'>
            	<thead style='position: sticky;top: 0;'>
                <tr class='at_tr' height='35' >
               		
                    <th class='at_th' style='width:300px;'>
                       	<h2 style='color:black;'>Name</h2>
                    </th>               
                    <th class='at_th' style='width:100px;'>
                        <h2 style='color:black;margin-right:5px;'>New</h2>
                    </th>
                    <th class='at_th' style='width:100px;'>
                        <h2 style='color:black;margin-right:5px;'>Reopen Closed</h2>
                    </th>
                    <th class='at_th' style='width:100px;'>
                        <h2 style='color:black;margin-right:5px;'>Revert Closed</h2>
                    </th>
                    <th class='at_th' style='width:100px;'>
                        <h2 style='color:black;margin-right:5px;'>Discrepency</h2>
                    </th>
                    <th class='at_th' style='width:100px;'>
                        <h2 style='color:black;margin-right:5px;'>ACC</h2>
                    </th>
                    <th class='at_th' style='width:100px;'>
                        <h2 style='color:orange;margin-right:5px;'>Total</h2>
                    </th>
                </tr>
            	</thead>";

        $html .= "<tbody>";
        //echo $html;

        $totalNew = 0;
        $totalReOpenClosed = 0;
        $totalRevertClosed = 0;
        $TotalDiscrepancy = 0;
        $totalACC = 0;
        $TotalStatus = 0;

        foreach ($QC_Members as $QCval) {

            $newcaselist = $this->vm->get_qcnewcaselist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '', $type = 'count', $QCval['assignee_id']);

            $reopenclosed = $this->vm->get_qcreopen_closed($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '', $type = 'count', $QCval['assignee_id']);

            $revertclosed = $this->vm->get_qcrevert_closed($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '', $type = 'count', $QCval['assignee_id']);

            $discrepancy_data = $this->vm->get_qcdiscrepency_list($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '', $type = 'count', $QCval['assignee_id']);

            $acc = $this->vm->get_qcaccallotted_list($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '', $type = 'count', $QCval['assignee_id']);

            $new = ($newcaselist[0]['count'] > 0) ? $newcaselist[0]['count'] : '';
            $reopenclose = ($reopenclosed[0]['count'] > 0) ? $reopenclosed[0]['count'] : '';
            $revertclose = ($revertclosed[0]['count'] > 0) ? $revertclosed[0]['count'] : '';
            $Discrepancy = ($discrepancy_data[0]['count'] > 0) ? $discrepancy_data[0]['count'] : '';
            $ACC = ($acc[0]['count'] > 0) ? $acc[0]['count'] : '';

	    	$TotalStatus=$new+$reopenclose+$revertclose;
	    	$TotalStatus=($TotalStatus > 0) ? $TotalStatus : '';


            // echo $QCval['name'];
            $html .= "<tr class='' height='25'>
            			<td  class='at_td' style='color:#022151;width:300px;height: 25px;'>
                            	" . $QCval['name'] . "
                        </td>

                        <td class='at_td' style='color:#1c1b1b;width:100px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>
                           	<label>" . $new . "</label>
                        </td>
                        <td  class='at_td' style='color:#1c1b1b;width:100px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>
                            <span style='color:black'>" . $reopenclose . "</span>

                        </td>

                        <td  class='at_td' style='color:#1c1b1b;width:100px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>
                           <span style='color:black'>" . $revertclose . "</span>
                        </td> 

                        <td  class='at_td' style='color:#1c1b1b;width:100px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>
                            <span style='color:black'>" . $Discrepancy . "</span>
                        </td>
                        <td  class='at_td' style='color:#1c1b1b;width:100px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>
                            	<span style='color:black'>" . $ACC . "</span>
                        </td>
                        <td  class='at_td' style='color:#1c1b1b;width:100px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>
                        	<span style='color:black'>" . $TotalStatus . "</span>
                        </td>
                    </tr>";
            $totalNew += $new;
            $totalReOpenClosed += $reopenclose;
            $totalRevertClosed += $revertclose;
            $TotalDiscrepancy += $Discrepancy;
            $totalACC += $ACC;
        }

        $totalNew = ($totalNew > 0) ? $totalNew : '';
        $totalReOpenClosed = ($totalReOpenClosed > 0) ? $totalReOpenClosed : '';
        $totalRevertClosed = ($totalRevertClosed > 0) ? $totalRevertClosed : '';
        $TotalDiscrepancy = ($TotalDiscrepancy > 0) ? $TotalDiscrepancy : '';
        $totalACC = ($totalACC > 0) ? $totalACC : '';

	    $subTotal=$totalNew+$totalReOpenClosed+$totalRevertClosed;
	    $subTotal=($subTotal>0) ? $subTotal : '';


        $html .= "
	    			<tr class='' height='25'>

	    				<td class='at_td' style='width:300px;'>
                       		<label style='color:orange;font-weight: bold;font-size:15px;float: right;padding:5px;'>Total</label>
                    	</td>

                        <td  class='at_td' style='color:#1c1b1b;width:100px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>
                        	" . $totalNew . "
                        </td>

                        <td  class='at_td' style='color:#1c1b1b;width:100px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>
                           	<span style='color:black'>" . $totalReOpenClosed . "</span>
                        </td>

                        <td  class='at_td' style='color:#1c1b1b;width:100px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>
                           	<span style='color:black'>" . $totalRevertClosed . "</span>
                        </td> 

                        <td  class='at_td' style='color:#1c1b1b;width:100px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>
                        	<span style='color:black'>" . $TotalDiscrepancy . "</span>
                        </td>
                        
                        <td  class='at_td' style='color:#1c1b1b;width:100px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>
                        	<span style='color:black'>" . $totalACC . "</span>
                        </td>
                        <td  class='at_td' style='color:#1c1b1b;width:100px;font-size:14px;text-align:right;padding-right: 10px;height: 25px;'>
                        	<span style='color:black'>" . $subTotal . "</span>
                        </td>
    				</tr>
    			</tbody>
        
        	</table>";
        echo $html;
    }

    /********* VM New vm_exportnew  ***********************************************/
    function vm_exportnew()
    {


        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('Export Details', 'Verification/vm_exportnew');

        // unshift crumb

        // output
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'vm_exportnew');
    }


    function get_newcourtrecordlist()
    {

        $model = array('Verification_model' => 'get_newcourtrecordlist');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        //$a_status = ($_REQUEST['status']) ? $_REQUEST['status'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';

        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $check_count = ($_REQUEST['check_count']) ? $_REQUEST['check_count'] : '';

        $userId  = ($_REQUEST['userId']) ? $_REQUEST['userId'] : '';

        if ($org_id)
            $condition[] = " o.id = " . $org_id;
        if ($office)
            $condition[] = " br.id = " . $office;
        if ($parent_office)
            $condition[] = " p.id = " . $parent_office;
        if ($sub_office)
            $condition[] = " su.id = " . $sub_office;
        if ($name) {
            $condition[] = "((concat_ws(' ',cr.firstname,cr.middlename,cr.lastname) like '%" . $name . "%')" . 'OR' .
                "(concat_ws(' ',lf.firstname,lf.middlename,lf.lastname) like '%" . $name . "%')" . 'OR' .
                "(concat_ws(' ',ind.firstname,ind.middlename,ind.lastname) like '%" . $name . "%'))";
        }

        if ($case_no)
            $condition[] = "d.case_no like '%" . $case_no . "%' ";

        if ($check_count == 'New') {
            $condition[] = "a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0 ";
        }


        // if ($term) {
        //     //support multiple words
        //     $search = explode(' ', $term);

        //     foreach ($search as $t) {
        //         $not        = '';
        //         $operator    = 'OR';
        //         if (substr($t, 0, 1) == '-') {
        //             $not        = 'NOT ';
        //             $operator    = 'AND';
        //             //trim the - sign off
        //             $t        = substr($t, 1, strlen($t));
        //         }

        //         $like    = '';
        //         $like    .= "( cr.firstname " . $not . "LIKE '%" . $t . "%' ";
        //         $like    .= $operator . " cr.lastname " . $not . "LIKE '%" . $t . "%' ";
        //         $like    .= $operator . " lffirstname " . $not . "LIKE '%" . $t . "%' ";
        //         $like    .= $operator . " cr.middlename " . $not . "LIKE '%" . $t . "%' ";
        //         $like    .= $operator . " o.org_name " . $not . "LIKE '%" . $t . "%' ";
        //         $like    .= $operator . " p.office_name " . $not . "LIKE '%" . $t . "%' ";
        //         $like    .= $operator . " su.office_name " . $not . "LIKE '%" . $t . "%' ";
        //         $like    .= $operator . " br.office_name " . $not . "LIKE '%" . $t . "%' ";
        //         $like    .= $operator . " d.case_no " . $not . "LIKE '%" . $t . "%' )";

        //         $condition[] = $like;
        //     }
        // }
        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $checkteam = $this->config->item('CHECKLIST', APPLICATIONCONFIG);
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            $k = 1;

            foreach ($result as $i => $row) {
                if ($row['checkId'] == 640) {
                    $fa = $row['crfather'];
                    $dob = date("d-m-Y", strtotime($row['crdob']));
                    $candidatename = $row['crfirstname'] . " " . $row['crmidname'] . " " . $row['crlastname'];
                    $address = $row['craddress'];
                    $level = $row['crlevelname'];
                    $pincode = $row['crpincode'];
                }

                if ($row['checkId'] == 71) {
                    $fa = $row['indfather'];
                    $dob = date("d-m-Y", strtotime($row['inddob']));
                    $candidatename = $row['indfirstname'] . " " . $row['indmidname'] . " " . $row['indlastname'];
                    $address = $row['indaddress'];
                    //$level='Permanent Address';
                    $level = '';
                    $pincode = '';
                }
                if ($row['checkId'] == 639) {
                    $fa = $row['lffather'];
                    $dob = date("d-m-Y", strtotime($row['lfdob']));
                    $candidatename = $row['lffirstname'] . " " . $row['lfmidname'] . " " . $row['lflastname'];
                    $address = $row['lfaddress'];
                    // $level='Permanent Address';
                    $level = '';
                    $pincode = $row['lfpincode'];
                }


                $vtext = 'New';
                // $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $vtext, 'target="_blank"');
                $response->rows[$i]['cell'] = array($i + $count + 1, $row['case_no'], $dob, $candidatename, $fa, $level, $address, $pincode, $vtext, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], anchor('/Dadmin/dadminview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['checkId']), 'View'));
            }
        }
        echo json_encode($response);
    }


    /********* VM New vm_exportnew  ***********************************************/




    /********************************
     ****** Payment Request *********
     ***** Function payment_request()  
     ********************************/
    function payment_request()
    {


        $data['request_id'] = $request_id = base64_decode($this->uri->segment(3));
        $data['level_id'] = $level_id = base64_decode($this->uri->segment(4));
        $data['check_id'] = $check_id = base64_decode($this->uri->segment(5));
        $data['pack_id'] = $pack_id = base64_decode($this->uri->segment(6));
        $data['pr_id'] = $pr_id = base64_decode($this->uri->segment(7));

        $this->db->select('order_id,organisation');
        $order = $this->db->get_where('dcode_client_request', array('request_id' => $request_id))->row_array();
        $orderID = $order['order_id'];
        $organization = $order['organisation'];

        $payment_count = $this->vm->get_payment_count($request_id, $check_id, $level_id);
        $data['payCount'] = $payment_count['paycount'];

        $blanket_approval = $this->vm->get_blanket_limit($orderID, $organization);
        $data['blanket_approval_limit'] = $blanket_approval['blanket_approval_limit'];

        $data['contsofcheck'] = $check_details = $this->vm->countsofchk($request_id, $check_id, $level_id);
        $data['data_details'] = $check_details[0];

        $data['checkname'] = $this->db->get_where(DB_PREFIX . 'master_masterdata', array('id' => $check_id))->row_array();
        $data['slug'] = $slug = url_title(convert_accented_characters($data['checkname']['name']), 'underscore', TRUE);

        $data['payment_details'] = $this->vm->get_payment_request_details($pr_id);

        $this->db->select('*');
        $data['neftDetails'] = $this->db->get_where('dcode_payment_request_neft', array('pr_id' => $pr_id))->row_array();

        $this->db->select('*');
        $data['cardDetails'] = $this->db->get_where('dcode_payment_request_card', array('pr_id' => $pr_id))->row_array();

        $this->db->select('*');
        $data['onlineDetails'] = $this->db->get_where('dcode_payment_request_online', array('pr_id' => $pr_id))->row_array();

        $this->db->select('*');
        $data['challanDetails'] = $this->db->get_where('dcode_payment_request_challan', array('pr_id' => $pr_id))->row_array();

        if ($pack_id > 94) {

            $level_details = $this->dm->$slug($request_id, $pack_id, $level_id);
        } else {
            $level_details = $this->dm->$slug($request_id, $check_id, $level_id);
        }
        $level_details[0]['lastname'] = rtrim($level_details[0]['lastname'], '.');
        $data['college'] = $level_details[0]['collegename_add'];
        $data['university'] = $level_details[0]['affliated'];
        // echo '<pre>';print_r($level_details);

        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push("Payment Request", 'Verification/payment_request');

        $data['title'] = 'Payment Request';
        $data['breadcrumb'] = $this->breadcrumbs->show();

        $this->amodel->pagerender($data, 'payment_request');
    }


    /**********************************
     ***** Save Payment Request *******
     *** function save_payment() ******/
    function save_payment()
    {
        // echo '<pre>';print_r($_POST);exit;

        $request_id =  $_POST['request_id'];
        $check_id = $_POST['check_id'];
        $level_id = $_POST['level_id'];

        $roleID = $this->session->userdata('role_id');
        $userId = $this->session->userdata["userid"];
        $insertion_date = date("Y-m-d H:i:s");
        $count = $_POST['count'];

        $config['allowed_types'] = '*';
        $config['encrypt_name'] = false;
        $config['remove_spaces'] = false;
        $config['upload_path'] = 'uploads/prposaldetails/';
        $this->load->library('upload', $config);
        $this->upload->initialize($config);

        $fileName = $_FILES['payment_file']['name'];

        $formData['request_id'] =  $_POST['request_id'];
        $formData['check_id'] = $_POST['check_id'];
        $formData['level_id'] = $_POST['level_id'];
        $formData['case_no'] = $_POST['case_no'];
        $formData['org_id '] = $_POST['org_id'];
        if ($_POST['pr_id'] == 0) {
            $formData['requested_date'] = date("Y-m-d H:i:s");
        } else {
            $formData['approved_date'] = date("Y-m-d H:i:s");
            $formData['approved_by'] = $userId;
        }

        if ($this->session->userdata('role_id') == 5) {
            $formData['requested_by'] = $userId;

            if ($_POST['payment_mode'] == 24 && $_POST['dd_from'] == 'Kotak') {
                $formData['payment_status'] = 31;
            } else {
                $formData['payment_status'] = 32;
                $formData['approved_date'] = date("Y-m-d H:i:s");
            }
        } else {
            $formData['payment_status'] = $_POST['payment_status'];
        }

        $formData['currency'] = $_POST['currency'];
        $formData['requested_amount'] = $_POST['amount'];
        $formData['reason_payment'] = $_POST['payment_reason'];
        $formData['customer_approval'] = $_POST['client_approval'];
        $formData['payment_to'] = $_POST['payment_to'];
        $formData['beneficiary_name'] = $_POST['beneficiary'];
        $formData['beneficiary_location'] = $_POST['location'];
        $formData['payment_mode'] = $_POST['payment_mode'];
        $formData['bank_name'] = $_POST['dd_from'];
        $formData['ref_branch_code'] = $_POST['branch_code'];
        $formData['comments'] = $_POST['comment'];
        $formData['attachment'] = $fileName;


        if ($this->upload->do_upload('payment_file' . $i)) {
            $documents[]  = $this->upload->data();
        }
        // else
        // {
        // 	echo ($documents['payment_file'] = $this->upload->display_errors());
        // }

        $ins_data['request_id'] = $_POST['request_id'];
        $ins_data['case_no'] = $_POST['case_no'];
        $ins_data['check_id'] = $_POST['check_id'];
        $ins_data['level_id'] = $_POST['level_id'];
        if ($this->session->userdata('role_id') == 5) {

            if ($_POST['payment_mode'] == 24 && $_POST['dd_from'] == 'Kotak') {
                $ins_data['payment_status'] = 31;
            } else {
                $ins_data['payment_status'] = 32;
            }
        } else {
            $ins_data['payment_status'] = $_POST['payment_status'];
        }
        $ins_data['date_of_update'] = date('Y-m-d H:i:s');
        $ins_data['role_id'] = $roleID;
        $ins_data['user_id'] = $userId;

        $ins_data = $this->security->xss_clean($ins_data);
        $this->db->insert(DB_PREFIX . 'payment_status_updates', $ins_data);

        if ($_POST['pr_id'] == 0) {

            $formData = $this->security->xss_clean($formData);
            $this->db->insert(DB_PREFIX . 'payment_request', $formData);
            $insertID = $this->db->insert_id();

            if ($_POST['payment_mode'] == 24) {

                $formData1['pr_id'] = $insertID;
                $formData1['payment_mode'] = $_POST['payment_mode'];
                $formData1['dd_bank_name'] = $_POST['dd_from'];
                $formData1['dd_branch_code'] = $_POST['branch_code'];
                $formData1['dd_creation_date'] = date("Y-m-d H:i:s");

                $formData1 = $this->security->xss_clean($formData1);
                $this->db->insert(DB_PREFIX . 'payment_request_dd', $formData1);
            }

            if ($_POST['payment_mode'] == 25) {

                $formData2['pr_id'] = $insertID;
                $formData2['payment_mode'] = $_POST['payment_mode'];
                $formData2['neft_bank_name'] = $_POST['neft_bank'];
                $formData2['neft_account_no'] = $_POST['neft_account_no'];
                $formData2['neft_ifsc_code'] = $_POST['branch_code'];
                $formData2['neft_account_type'] = $_POST['neft_account_type'];
                $formData2['neft_creation_date'] = date("Y-m-d H:i:s");

                $formData2 = $this->security->xss_clean($formData2);
                $this->db->insert(DB_PREFIX . 'payment_request_neft', $formData2);
            }

            if ($_POST['payment_mode'] == 22) {

                $formData3['pr_id'] = $insertID;
                $formData3['payment_mode'] = $_POST['payment_mode'];
                $formData3['chln_bank'] = $_POST['chln_bank'];
                $formData3['chln_branch'] = $_POST['chln_branch'];
                $formData3['chln_creation_date'] = date("Y-m-d H:i:s");

                $formData3 = $this->security->xss_clean($formData3);
                $this->db->insert(DB_PREFIX . 'payment_request_challan', $formData3);
            }

            if ($_POST['payment_mode'] == 23) {

                $formData4['pr_id'] = $insertID;
                $formData4['cr_card_type'] = $_POST['card_type'];
                $formData4['payment_mode'] = $_POST['payment_mode'];
                $formData4['cr_created_on'] = date("Y-m-d H:i:s");

                $formData4 = $this->security->xss_clean($formData4);
                $this->db->insert(DB_PREFIX . 'payment_request_card', $formData4);
            }

            if ($_POST['payment_mode'] == 26) {

                $formData5['pr_id'] = $insertID;
                $formData5['op_mobile_no'] = $this->encryption->encrypt($_POST['mobile_no']);
                $formData5['payment_mode'] = $_POST['payment_mode'];
                $formData5['op_created_on'] = date("Y-m-d H:i:s");

                $formData5 = $this->security->xss_clean($formData5);
                $this->db->insert(DB_PREFIX . 'payment_request_online', $formData5);
            }

            redirect('' . base_url('Verification/level_detailsview/' . base64_encode($request_id) . '/' . base64_encode($level_id) . '/' . base64_encode($check_id)));
        } else {

            if (empty($fileName)) {
                $this->db->select('attachment');
                $this->db->where('pr_id', $_POST['pr_id']);
                $attachment = $this->db->get(DB_PREFIX . 'payment_request')->row_array();

                $formData['attachment'] = $attachment['attachment'];
            } else {
                $formData['attachment'] = $fileName;
            }

            if ($_POST['payment_mode'] == 24 && $this->session->userdata('role_id') == 5) {

                $formData1['payment_mode'] = $_POST['payment_mode'];
                $formData1['dd_bank_name'] = $_POST['dd_from'];
                $formData1['dd_branch_code'] = $_POST['branch_code'];
                $formData1['dd_creation_date'] = date("Y-m-d H:i:s");

                $this->db->where('pr_id', $_POST['pr_id']);
                $this->db->update(DB_PREFIX . "payment_request_dd", $formData1);
            }

            if ($_POST['payment_mode'] == 25 && $this->session->userdata('role_id') == 5) {

                $formData2['payment_mode'] = $_POST['payment_mode'];
                $formData2['neft_bank_name'] = $_POST['neft_bank'];
                $formData2['neft_account_no'] = $_POST['neft_account_no'];
                $formData2['neft_ifsc_code'] = $_POST['branch_code'];
                $formData2['neft_account_type'] = $_POST['neft_account_type'];
                $formData2['neft_last_updated_date'] = date("Y-m-d H:i:s");

                $this->db->where('pr_id', $_POST['pr_id']);
                $this->db->update(DB_PREFIX . "payment_request_neft", $formData2);
            }

            if ($_POST['payment_mode'] == 22 && $this->session->userdata('role_id') == 5) {

                $formData3['payment_mode'] = $_POST['payment_mode'];
                $formData3['chln_bank'] = $_POST['chln_bank'];
                $formData3['chln_branch'] = $_POST['chln_branch'];
                $formData3['chln_creation_date'] = date("Y-m-d H:i:s");

                $this->db->where('pr_id', $_POST['pr_id']);
                $this->db->update(DB_PREFIX . "payment_request_challan", $formData3);
            }

            if ($_POST['payment_mode'] == 23 && $this->session->userdata('role_id') == 5) {

                $formData4['cr_card_type'] = $_POST['card_type'];
                $formData4['payment_mode'] = $_POST['payment_mode'];
                $formData4['cr_updated_on'] = date("Y-m-d H:i:s");

                $this->db->where('pr_id', $_POST['pr_id']);
                $this->db->update(DB_PREFIX . "payment_request_card", $formData4);
            }

            if ($_POST['payment_mode'] == 26 && $this->session->userdata('role_id') == 5) {

                $formData5['op_mobile_no'] = $this->encryption->encrypt($_POST['mobile_no']);
                $formData5['payment_mode'] = $_POST['payment_mode'];
                $formData5['op_updated_on'] = date("Y-m-d H:i:s");

                $this->db->where('pr_id', $_POST['pr_id']);
                $this->db->update(DB_PREFIX . "payment_request_online", $formData5);
            }

            $this->db->where('pr_id', $_POST['pr_id']);
            $this->db->update(DB_PREFIX . "payment_request", $formData);
            redirect('' . base_url('Billing/payment_requestlist'));
        }
    }

    function getlocation()
    {

        $location = $_POST['location'];
        $this->db->select('bank_name');
        $locationVal = $this->db->get_where('dcode_bank_branches', array('branch_city' => $location))->row_array();
        echo ($locationVal['bank_name'] == 'KOTAK') ? 1 : 0;
    }


    //16/01/2024 delete bill document from the vm revert page
    function  bill_doc_delete()
    {

        $id = $_POST['id'];

        $doc_name = $_POST['doc_name'];


        $config['upload_path'] = $doc_name;
        if (file_exists($doc_name) && !empty($id)) {
            //image is delete from folder.
            $file_del_status = unlink($config['upload_path']);
            if ($file_del_status == TRUE) {

                $this->db->where('id', $id);
                $this->db->delete(DB_PREFIX . 'billing_doc');  //delete  table row  

            }
        } else {

            if (!file_exists($doc_name)) {

                $this->db->set('status', 0);
                $this->db->where('id', $id);
                $this->db->update(DB_PREFIX . 'billing_doc');
            }
        }
    }

    /*********** VM Pending List *********
     * ** function vmpending_lists() *****
     * **********************************/

    function vmpending_lists()
    {
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4', 'ui.jqgrid'));
        $this->amodel->loadjsscript(array('jquery.dropdownPlain', 'grid.locale-en', 'jquery.jqGrid.min', 'commonjs', 'jquery-ui-1.8.16.custom.min'));
        // add breadcrumbs
        $this->breadcrumbs->push('Dashboard', 'Index/dashboard');
        $this->breadcrumbs->push('VM Pending List', 'Verification/vmpending_lists');
        $data['breadcrumb'] = $this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'vmpending_lists');
    }

    /*********** VM Pending List *****************
     * function get_verificationpendinglist ******
     * *******************************************/
    function get_verificationpendinglist()
    {

        $model = array('Verification_model' => 'get_verificationpending');
        $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
        $name = ($_REQUEST['name']) ? $_REQUEST['name'] : '';
        $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
        $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
        $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
        $case_no = ($_REQUEST['case_no']) ? $_REQUEST['case_no'] : '';
        $check_name = ($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
        $verifier_name = ($_REQUEST['verifier_name']) ? $_REQUEST['verifier_name'] : '';
        $check_count = ($_REQUEST['check_count']) ? $_REQUEST['check_count'] : '';

        if ($verifier_name) {
            $memQuery = " ar.team_mem_id = " . $verifier_name . " and ";
        } else {
            $memQuery = '';
        }

        if ($org_id) {
            $condition[] = " o.id = " . $org_id;
        }
        if ($office) {
            $condition[] = " br.id = " . $office;
        }
        if ($parent_office) {
            $condition[] = " p.id = " . $parent_office;
        }
        if ($sub_office) {
            $condition[] = " su.id = " . $sub_office;
        }
        if ($name) {
            $condition[] = "d.candidate_name like '%" . $name . "%' ";
        }
        if ($check_name) {
            $condition[] = "c.name like '%" . $check_name . "%' ";
        }

        if ($this->session->userdata['role_id'] == 1 || $this->session->userdata['role_id'] == 24 || $this->session->userdata['role_id'] == 9 || $this->session->userdata['role_id'] == 21) {

            // edited by amritha on 30/06/2023
            // $condition[]="((a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0) or (a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1) or (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111) or (a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107) or (s.vm_revert_option_status = 1 and a.vm_revert_to = 2) or (a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1) or (a.verify_status = 992 and a.qc_revert_request !=1) or ( a.vm_assigned_qc = 0 and a.ass_request = 0 and vl1.supplementary = 1 and a.qc_revert_request = 1 and a.reopen_revert_qc2 = 1) or (a.verify_status =107 or a.vm_assigned_qc=0 or a.verify_status =684 or a.verify_status =992 )) ";
        }

        if ($case_no) {
            $case_no = trim($case_no);
            $condition[] = "d.case_no like '%" . $case_no . "' ";
        }


        if ($check_count && $this->session->userdata['role_id'] == 5) {
            $rep_id = " (SELECT  GROUP_CONCAT(ar.rep_id) as verifier from dcode_ver_assign_rep ar LEFT  JOIN  dcode_verified_level vl1 ON vl1.request_id = ar.candidate_req_id and vl1.check_id = ar.check_id and vl1.level_id = ar.level_id
				where ar.team_mem_id = " . $this->session->userdata['userid'] . " and (ar.verify_status =107 or ar.vm_assigned_qc=0 or ar.verify_status =684  )  or  (ar.qc_revert_request = 1 and ar.vm_assigned_qc=0) group by ar.candidate_req_id having count(verifier)=" . $check_count . ")";
            $rid = $this->db->query($rep_id)->result_array();
            foreach ($rid as  $rvalue) {
                $verifier_ids[] = $rvalue['verifier'];
            }
            $condition[] = " a.rep_id in (" . implode(',', $verifier_ids) . " )";
        }

        if ($check_count && (in_array($this->session->userdata['role_id'], array(1, 9, 21, 24)))) {
            $rep_id = " (SELECT  GROUP_CONCAT(ar.rep_id) as verifier from dcode_ver_assign_rep ar LEFT  JOIN  dcode_verified_level vl1 ON vl1.request_id = ar.candidate_req_id and vl1.check_id = ar.check_id and vl1.level_id = ar.level_id
				where " . $memQuery . "  (ar.verify_status =107 or ar.vm_assigned_qc=0 or ar.verify_status =684  )  or  (ar.qc_revert_request = 1 and ar.vm_assigned_qc=0) group by ar.candidate_req_id having count(verifier)=" . $check_count . ")";
            $rid = $this->db->query($rep_id)->result_array();
            foreach ($rid as  $rvalue) {
                $verifier_ids[] = $rvalue['verifier'];
            }
            $condition[] = " a.rep_id in (" . implode(',', $verifier_ids) . " )";
        }


        $manual_cond = implode(' and ', $condition);
        $results = $this->_jqgrid_search($model, $manual_cond);
        $response = $results[0];
        $result = $results[1];
        if ($result) {
            $checkteam = $this->config->item('CHECKLIST', APPLICATIONCONFIG);
            $page = ($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows = ($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page = $page - 1;
            $count = $page * $rows;
            $k = 1;

            foreach ($result as $i => $row) {

                $verified_data = $this->vm->get_verified_data($row['candidate_req_id'], $row['level_id'], $row['checkId']);
                $verification_data = toArray(json_decode($verified_data['fielddata']));
                // $vm_expenses  = toArray(json_decode($verified_data['vmexpenses']));
                // $qc2verification_data=toArray(json_decode($verified_data['qc2fielddata']));




                $status1 = $this->vm->get_status($verification_data['status']);
                $status4 = '';
                $status2 = $this->vm->get_status($verification_data['pstatus']);
                $status3 = $this->vm->get_status($verification_data['status1']);
                if ($verification_data['ostatus'] <> '') {
                    $status4 = $this->vm->get_status($verification_data['ostatus']);
                    $status4_id = $verification_data['ostatus']; //  Dec 13th
                }
                if ($verification_data['dstatus'] <> '')
                    $status4 = $this->vm->get_status($verification_data['dstatus']);
                if (!empty($status4))
                    $status41 = '-' . $status4['name'];
                else
                    $status41 = '';

                $reqstatus = '';
                if (!empty($row['reqstatus'])) {
                    $req_raised_status =    $this->vm->get_status($row['reqstatus']);
                    $reqstatus = $req_raised_status['name'];
                }

                $checkadminstatus = $this->vm->get_currentstatus($row['candidate_req_id']);
                $verfier_details = anchor('/Verification/add_calls/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Call Details', 'target="_blank"');

                $procedure_details = anchor('/Verification/add_procedure/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Procedure Details', 'target="_blank"');
                $candidatename = $row['candidatename'];
                if ($row['vm_revert_option_status'] == 1 && $row['vm_revert_to'] == 2) {
                    $verifyurl = 'Revert Raised to DEO';
                } else if ($row['qc_revert_request'] == 1) {
                    if ($row['vm_assigned_qc'] == 1 && $row['verify_status'] <> 107 && $row['verify_status'] <> 684 && $row['verify_status'] <> 992) {
                        $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                        $verifyurl = 'Revert Rectified';
                    } else if ($row['vm_assigned_qc'] == 0 && $row['ass_request'] == 0 && $row['supplementary'] == 1 && $row['qc_revert_request'] == 1 && $row['reopen_revert_qc'] == 0 && $row['reopen_revert_qc2'] == 1) {
                        $verifyurl = anchor('/Verification/revert_raisedsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']) . '/' . base64_encode(1004), 'Reopen Assigned', 'target="_blank"');
                    } else if ($row['vm_assigned_qc'] == 0 && $row['ass_request'] == 0 && $row['supplementary'] == 1 && $row['qc_revert_request'] == 1 && $row['reopen_revert_qc'] == 1 && $row['reopen_revert_qc2'] == 1) {
                        $verifyurl = anchor('/Verification/revert_raisedsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']) . '/' . base64_encode(1004), 'Reopen Assigned', 'target="_blank"');
                    } else {

                        $verifyurl = anchor('/Verification/revert_raisedsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Assigned', 'target="_blank"');
                    }
                } elseif ($row['verify_status'] == 111 && $row['vrequest'] == 0 && $row['ass_request'] == 0) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 3 && $row['vm_revert_to'] == 2) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_option_status'] == 3 && $row['vm_revert_to'] == 2) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 4 && $row['operator_submited_by'] == 12 || $row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_option_status'] == 4 && $checkadminstatus['role_id'] == 13) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_option_status'] == 4 && $row['operator_submited_by'] == 12 || $row['vm_revert_option_status'] == 4 && $checkadminstatus['role_id'] == 13) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] == 111 && $row['vrequest'] == 1 && $row['ass_request'] == 0 && $row['vm_revert_to'] == 3 && $row['vm_revert_supervisor'] == 0) {
                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    $requesttoass = '';
                    $add_calls = '';

                    $candidatename = anchor('/Verification/vm_verified/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $row['candidatename'], 'target="_blank"');
                } else if ($row['vm_revert_to'] == 3 && $row['vm_revert_supervisor'] == 0) {
                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), 'Revert Closed', 'target="_blank"');
                } else if ($row['verify_status'] <> '111' && $row['vrequest'] == 1 && $row['rstatus'] != 0 && $row['ass_request'] == 0) {
                    if ($row['rstatus'] == 108)
                        $vst = 'Inputs Required';
                    else if ($row['rstatus'] == 110)
                        $vst = 'Stop Check';
                    else if ($row['rstatus'] == 109)
                        $vst = 'Awaiting Authorisation';
                    else if ($row['rstatus'] == 107)
                        $vst = 'Initiated';
                    else if ($row['rstatus'] == 519)
                        $vst = 'Others';
                    else if ($row['rstatus'] == 684)
                        $vst = 'Request Raised';
                    else if ($row['rstatus'] == 992)
                        $vst = 'DD applied';

                    if ($row['rstatus'] == 110 || $row['rstatus'] == 519) {
                        $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">Verified</p>';
                    } else {
                        $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">' . $vst . '</p>', 'target="_blank"');
                    }

                    $requesttoass = '';
                } else if ($row['verify_status'] == '111' && $row['vrequest'] == 1 && $row['rstatus'] != 0 && $row['ass_request'] == 0) {
                    if ($row['rstatus'] == 108)
                        $vst = 'Inputs Required';
                    else if ($row['rstatus'] == 110)
                        $vst = 'Stop Check';
                    else if ($row['rstatus'] == 109)
                        $vst = 'Awaiting Authorisation';
                    else if ($row['rstatus'] == 107 && $row['verify_status'] == '111')
                        $vst = 'Verified';
                    else if ($row['rstatus'] == 107)
                        $vst = 'Initiated';
                    else
                        $vst = 'Verified';

                    $verifyurl = '<p style="color:#ef1906; font-family: serif; font-size: 10px;float:right;font-weight: bold;">' . $vst . '</p>';
                    $requesttoass = '';
                } else if ($row['ass_request'] == 1) {
                    $verifyurl = 'Request Raised';
                    $requesttoass = 'Sent to Associate';
                    $add_calls = '';
                } else {
                    $save['request_id'] = $row['candidate_req_id'];
                    $save['check_id'] = $row['checkId'];
                    $save['level_id'] = $row['level_id'];
                    $this->db->select('count(*) as cnt');
                    $this->db->where($save);
                    $countnoti = $this->db->get(DB_PREFIX . 'notification_emails')->row_array();

                    if ($countnoti['cnt'] >= 1)
                        $vtext = 'Sent Mail to Resource';
                    else
                        $vtext = 'New';

                    $verifyurl = anchor('/Verification/level_detailsview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['level_id']) . '/' . base64_encode($row['checkId']) . '/' . base64_encode($row['pack_id']), $vtext, 'target="_blank"');
                    $vst = $row['status'];
                    $requesttoass = '';
                }

                if ($row['chk'] == 0) {
                    $chkval = $row['checkname'];
                } else {
                    $chkval = $row['checkname'] . $row['chk'];
                }
                if (!empty($status1['name'])) {
                    $stat = $status1['name'] . '-' . $status2['name'] . '-' . $status3['name'] . '' . $status41;
                } else {
                    $stat = '';
                }


                $deadline_from = isset($row['deadline_from']) ? date('d-m-Y', strtotime($row['deadline_from'])) : '';
                $deadline_to = isset($row['deadline_to']) ? date('d-m-Y', strtotime($row['deadline_to'])) : '';

                if ($row['ticket_status'] == 1) {
                    $tktStatus = 'Open';
                } else if ($row['ticket_status'] == 2) {
                    $tktStatus = 'Requested';
                } else if ($row['ticket_status'] == 3) {
                    $tktStatus = 'Revert';
                } else if ($row['ticket_status'] == 4) {
                    $tktStatus = 'Re-Requested';
                } else if ($row['ticket_status'] == 5) {
                    $tktStatus = 'Re-Open';
                } else if ($row['ticket_status'] == 101) {
                    $tktStatus = 'Closed';
                } else {
                    $tktStatus = '';
                }

                $startDate = date('Y-m-d', strtotime($row['requested_date']));
                $endDate = date('Y-m-d');
                $workingDays = $this->number_of_working_days($startDate, $endDate);

                if (($row['ticket_status'] == 2 && $workingDays > 7) || ($row['ticket_status'] == 4 && $workingDays > 7) || ($row['ticket_status'] == 3 || $row['ticket_status'] == 101) && $row['rstatus'] == 684) {
                    $tktStatus = "<span style='background-color:yellow;'>" . $tktStatus . "</span>";
                } else if (($row['ticket_status'] == 2 && $workingDays > 7) || ($row['ticket_status'] == 4 && $workingDays > 7) || ($row['ticket_status'] == 3 || $row['ticket_status'] == 101) && ($row['qc_revert_request'] == 1 && $row['verify_status'] == 684)) {
                    $tktStatus = "<span style='background-color:yellow;'>" . $tktStatus . "</span>";
                } else if ($row['rstatus'] != 684) {
                    $tktStatus = '';
                } else if ($row['qc_revert_request'] != 1 && $row['verify_status'] != 684) {
                    $tktStatus = '';
                } else {
                    $tktStatus = $tktStatus;
                }

                // $holidays=[];
                // if(!empty($qc2_date)){
                //     $NoOfday= $this->getWorkingDays($case_accepted_date,$qc2_date,$holidays);
                //     if($NoOfday==0){
                //        $SLA=1; 
                //     }else{
                //         $SLA=$NoOfday-1;
                //     }   
                // }else{
                //     $SLA='';
                // }


                $response->rows[$i]['cell'] = array($i + $count + 1, $row['org_name'], $row['parent_office'], $row['office_name'], $row['sub_office'], anchor('/Dadmin/dadminview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['checkId']), $candidatename), $row['case_no'], $chkval, $verifyurl, $tktStatus, $stat, $row['Days'], $reqstatus, $row['vname'], $deadline_from, $deadline_to, $row['verification_tat'], anchor('/Dadmin/dadminview/' . base64_encode($row['candidate_req_id']) . '/' . base64_encode($row['checkId']), 'View'));
            }
        }

        echo json_encode($response);
    }
}
