<?php if (!defined('BASEPATH')) {
exit('No direct script access allowed');
}
require_once ('Common.php');
class Vsupervisor extends Common {
    protected static $vsupervisor_model = 'Vsupervisor_model';
    protected $index_dashboard= 'Index/dashboard';
    protected $dashboard= 'Dashboard';
     function __construct() 
    {
        parent::__construct();
        $this->_check_userlogin ();
        $models = array('Verification_model' => 'vm');
        $this->load->model('Dadmin_model','dm');
        $this->load->model('Dataentry_model','dem');
        $this->load->model('Reports_model','rm');
        $this->load->model('Client_model','cm');
        $this->load->model('Verification_report_model','vrm');
        $this->load->model('Qualityverification_model','qc');
        $this->load->model(self::$vsupervisor_model,'vs');
        $this->load->model('TAT_model','tm');  //  MN  Aug
        $this->lang->load('Dataentry');
        $this->load->library('pdfexport'); 
        $this->load->helper('list_search_filter_helper');
        foreach ($models as $file => $object_name) {
            $this->load->model($file, $object_name);
        }
        $this->load->helper('text');
        $this->amodel->loadcssScript(array('jquery-ui-1.10.4','ui.jqgrid'));
        $this->amodel->loadjsscript(array( 'jquery.dropdownPlain','grid.locale-en','jquery.jqGrid.min','commonjs','jquery-ui-1.8.16.custom.min','jquery.validate','multipleclone'));
    }
    /******************************
    case status
    ********************************/
    function case_status()
    {
        $this->breadcrumbs->push($this->dashboard, $this->index_dashboard);
        $this->breadcrumbs->push('Case Status', 'Vsupervisor/casestatus');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'Case_status');
    }

function get_cases($office_id = 0 ){   
       
    $model = array(self::$vsupervisor_model=>'get_casestatus');
    $condition=list_search_filter($_REQUEST);
    $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
    $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : ''; 
    $date_filter=($_REQUEST['date_filter']) ? $_REQUEST['date_filter'] : '';
    
    if(!empty($c_date) && $date_filter==1){
    $condition[]="DATE_FORMAT(a.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
    }
    if(!empty($t_date) && $date_filter==1){
    $condition[]="DATE_FORMAT(a.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
    }
    if(!empty($c_date) && $date_filter==2){
    $condition[]="DATE_FORMAT(a.case_accepted_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and cv.client_status=1 and case when a.dataentry_by=3 Then DATE_FORMAT(a.case_recieved_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' else 1 end ";
    }
    if(!empty($t_date) && $date_filter==2){
            $condition[]="DATE_FORMAT(a.case_accepted_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and cv.client_status=1 and case when a.dataentry_by=3 Then DATE_FORMAT(a.case_recieved_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' else 1 end ";
    }
    if(!empty($c_date) && $date_filter==4){
    $condition[]="DATE_FORMAT(cv.candidate_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and a.dataentry_by=0 ";
    }
    if(!empty($t_date) && $date_filter==4){
    $condition[]="DATE_FORMAT(cv.candidate_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and a.dataentry_by =0 ";
    }
    if(!empty($c_date) && $date_filter==5){
    $condition[]="DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and a.dataentry_by != 3 ";
    }
    if(!empty($t_date) && $date_filter==5){
    $condition[]="DATE_FORMAT(cv.client_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and a.dataentry_by != 3 ";
    }
    if(!empty($c_date) && $date_filter==6){
    $condition[]="DATE_FORMAT(cv.des_rejected_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
    }
    if(!empty($t_date) && $date_filter==6){
    $condition[]="DATE_FORMAT(cv.des_rejected_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
    }
        $manual_cond=implode(' and ',$condition);
        $results = $this->_jqgrid_search($model,$manual_cond);
        $response = $results[0];
          $result = $results[1]; 
           if ($result) {
           $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
            $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
            $page=$page - 1;
            $count=$page * $rows;
            foreach ( $result as $i => $row ) {
              $checkstatus = $this->cm->get_currentstatus($row['request_id']);
               $verifiedlevelstatus = $this->cm->get_verifiedlevelstatus($row['request_id']);
            
            if($checkstatus['verification_status']==1 && $checkstatus['team_mem_id'] ==''){
            $status='Initiated';
            }
            else if($checkstatus['verification_status']==1 && $checkstatus['team_mem_id'] <>'' && $checkstatus['vm_revert_option_status']!=2 && $checkstatus['vm_revert_option_status']!=4){
            $status='Initiated';
            }
            else if($checkstatus['verification_status']==0 && $checkstatus['client_status']==1 && $checkstatus['vm_revert_option_status']==0 && $checkstatus['reverted_by']==0){
            $status='Submitted to Dcode';
            }
            else if($checkstatus['verification_status']==0 && $checkstatus['operator_status']==2){
            $status='Revert';
            }
            else if($checkstatus['revert_status']==0 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus['role_id']==13 && $checkstatus['assainee_status']==0){
            $status='Revert Closed';
            }
            else if($checkstatus['revert_status']==1 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus['role_id']==13){
            $status='Revert Assigned';
            }
            else if($checkstatus['revert_status']==0 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus['role_id']==12 && $checkstatus['assainee_status']==0){
            $status='Revert Closed';
            }
            else if($checkstatus['revert_status']==1 && !empty($checkstatus['service']) && !empty($checkstatus['reason'] ) && $checkstatus['role_id']==12){
            $status='Revert Assigned';
            }
            else if($checkstatus['reverted_by']==0 && !empty($checkstatus['reverted_reason']) && $checkstatus['assainee_status']==1){
            $status='Submitted to Dcode';
            }
            else if($checkstatus['reverted_by']!=0 && !empty($checkstatus['reverted_reason'])){
            $status='Reject Assigned';
            }
            else if($checkstatus['reverted_by']==0 && !empty($checkstatus['reverted_reason'])){
            $status='Reject Rectified';
            }
            else if($checkstatus['vm_revert_to']==3 && $checkstatus['vm_revert_by']==5 && $checkstatus['vm_revert_supervisor']==1){
            $status='Revert Assigned';
            }
            else if($checkstatus['vm_revert_option_status']==2){
            $status='Revert Assigned';
            }
            else if($checkstatus['vm_revert_option_status']==4){
            $status='Revert Closed';
            }
             else if($checkstatus['verification_status']==0 && $checkstatus['operator_status']==1 && $checkstatus['vm_revert_option_status']==0 && $row['dataentry_by']!=0){
            $status='Submitted to Dcode';
             }
            else if($row['dataentry_by']==0 && $checkstatus['status']!=1){
            $status = 'Pending';
            }
            else if($checkstatus['status']==1 && $row['dataentry_by']==0 ){
            $status = 'Candidate Profile  Completed';
            }
            else if($checkstatus['client_status']==1 && $checkstatus['operator_status']==0 && $checkstatus['assignee_id']<>0 && $row['dataentry_by']==0){
            $status = 'Submitted to Dcode';
            }
            else if($checkstatus['client_status']==1 && $checkstatus['operator_status']==0 && $checkstatus['assignee_id']==0 && $row['dataentry_by']==0){
            $status='Submitted to Dcode';
            }
            else{
            $status = 'New';
            }
             $request_status = 'New';
            if($row['assainee_status']==1){
                 $request_status = 'Assigned';
            } else if($row['dataentry_by']==1){
            $request_status= 'New';
            if($status=='Allotted to DES'){
            $request_status= 'Assigned';
            }
            else if($status=='Revert Closed'){
            $request_status= 'Assigned';
            }else{
            $request_status = 'New';
            }
            } else if($row['dataentry_by']==2){
            if($status=='Revert Closed'){
            $request_status= 'Assigned';
            }
            }
            else {
               if($this->session->userdata['user_type'] == 2 ) {
                    $request_status= 'New';
                            if($status=='Allotted to DES'){
                            $request_status= 'Assigned';
                            }
                            else{
                             $request_status= 'New';
                            }
                    }
                    else{
                        if($status=='Revert DES'){
                          $request_status= 'Revert Raised';  
                        }
                        else{
                         $request_status= 'New';
                        }
                    }
            }
            if($status=='Revert Assigned' && $row['dataentry_by']==3){
            $request_status= 'Revert Raised';  
            }
            if($status=='Revert Assigned' && $row['dataentry_by']==1 || $status=='Revert Assigned' && $row['dataentry_by']==2){
            $request_status= 'Revert Raised';  
            }
            if($status=='Reject Assigned'){
            $request_status= 'Reject';  
            }
            if($status=='Reject Rectified'){
            $request_status= 'Assigned';  
            }
            $type='';
            if($row['dataentry_by']==1){
            $type='Partial Entry';
            }
            else if($row['dataentry_by']==2){
            $type='Full Entry';
            }
            else if($row['dataentry_by']==3){
            $type='Offline Entry';
            }
            else if($row['dataentry_by']==0){
            $type='Candidate Entry';
            }

            if($status=='Revert to DES' && $row['revert_status']==1 && $row['assainee_status']==1){
            $request_status= 'DEC';
            }
            else if($row['revert_status']==1 && $row['assainee_status']==1){
            $request_status= 'Revert Closed';
            }
            $assign=anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),"View");
        if($row['parent']==0){
            $officevalue=$row['parent_office'];
            $branchofficevalue=$row['office_name'];
        }else if($row['parent']!=0){
            $officevalue=$row['office_name'];
            $branchofficevalue=$row['parent_office'];
    }
    if($row['created_on']){
          $created_on=date('d-m-Y',strtotime($row['created_on']));
        }
        $frp_date='';
    if($row['final_report_published_date']){
          $frp_date=date('d-m-Y',strtotime($row['final_report_published_date']));
        }   
        $case_recieved_date=''; 
    if($row['case_recieved_date'] && ($row['case_recieved_date'] != "0000-00-00")){
          $case_recieved_date=date('d-m-Y',strtotime($row['case_recieved_date']));
        }  
        elseif($checkstatus['client_status']==1)
        {
            $case_recieved_date=date('d-m-Y',strtotime($row['deadline_from']));
        }     
        if($row['dataentry_by']==3)
        {
            $cname='Dcode';
        }
        else
        {
            $cname=$row['first_name'];
        }
        $pending_chkint = $this->rm->getchecksintverify($row['request_id']);
        $cntck=count($pending_chkint);
        $interim='';
        foreach($pending_chkint as $chks){ 
        if($chks['qc2_report_publish']==1){   
        $interim=anchor('/Client/interimreport/'.base64_encode($row['request_id']),"Interim");
        
       }
    }
    $pending_checksa = $this->rm->getchecksverify($row['request_id']);
    $finalreport_checksa = $this->rm->getcountcheck($row['request_id']);
    $count_pending_checksa = $this->rm->getcountchecksverify($row['request_id']);
    $count_date_checksa = $this->rm->getfinalupdateedate($row['request_id']);
    $namw=count($finalreport_checksa);
    $sum=0;
    foreach($count_pending_checksa as $count_pending_val){
    $sum+=$count_pending_val['no_checks'];
    }
    if(!empty($verifiedlevelstatus['qc2fielddata'])){
    if($sum<=$namw){
    $status='Report Published';
    $final=anchor('/Reports/candidate_reports_view/'.base64_encode($row['request_id']).'/'.base64_encode(1).'/'.base64_encode(2).'/'.base64_encode(3).'/'.base64_encode($count_date_checksa['created_date']),"Final",'target=_blank');
    }
    else{
    $final='';
    }
    }else{
    $final='';
    }
/* report status*/
    $rep_status=$this->cm->get_verified_data_with_checkid($row['request_id']);
    $report_status='';
    $publish_status=''; 
    $rstatus1=[];
  if($rep_status){
     $orange_check = 0; // ka added on april 26
        foreach($rep_status as $k => $rps)
        {     
            $rid=$row['request_id'];  
            if(!empty($rps['qc2fielddata'])){    
                $qc2_data=toArray(json_decode($rps['qc2fielddata']));   
                if($qc2_data['status']){
                   $pstatus[$rid][]=$this->vm->get_status($qc2_data['status']);
                    if($rps['check_id'] != 1306){ //if not gap check ka added on april 26
                            if($qc2_data['status'] == "519") //others
                            {
                                $ostatus[] = $this->vm->get_status($qc2_data['ostatus']); 
                                $orange_check++;
                            }
                            if($qc2_data['status'] == 110) // stop check
                            {
                                $orange_check++;
                            }
                        } // ka have added on 29
                }
                /** Dec 15th **/
                if($qc2_data['status'] == "519") //others
                {
                    $ostatus[] = $this->vm->get_status($qc2_data['ostatus']); 
                }
                /** Dec 15th **/
                if($qc2_data['status1']){
                   $pstatus[$rid][]=$this->vm->get_status($qc2_data['status1']);
                   $status1[]=$this->vm->get_status($qc2_data['status1']); // Dec 15th
                }
             }
        }  
        foreach($pstatus[$rid] as $rp)
        {
            $rstatus1[]=$rp['name'];
        }

        /*** Dec 15th ***/
        if(!empty($ostatus))
            $count_others_orange = 0;
        else
            $count_others_orange = -1;

        foreach($status1 as $sp) // status of 3rd drop down // Dec  15th
        {
            if($sp['name'] == "Others")
            {
                $count_others_orange = 1; 
            }
        }
        /**
         * In dcode_master_masterdata table
         * 699 -  Not Applicable
         * 750 - Not applicable  
         */
        foreach($ostatus as $orp) // For Others - Not Applicable -  Only this check in Others is to  be GREEN
        {
            $orstatus[]=$orp['name'];
            $others_id  = $orp['id']; 
            if($others_id != 699 && $others_id != 750) 
                $count_others_orange++;  // Count of  orange others checks 

        }        
        if (in_array("Discrepant", $rstatus1) || in_array("Possible Discrepant" , $rstatus1) || in_array("Record Found" , $rstatus1) || in_array("Positive" , $rstatus1) || in_array("No Records" , $rstatus1) || in_array("High Risk" , $rstatus1) || in_array("Invalid" , $rstatus1) || in_array("Not Completed" , $rstatus1) || in_array("Multiple Active Records" , $rstatus1))
        { 
            $report_status ="<span style='color:red;'>RED</span>";
        }
        //  from below i have taken and pasted here on April 26th 
         else if ((in_array("Stop Check" , $rstatus1) &&  $orange_check>0) || (in_array("Others" , $rstatus1) && ($count_others_orange > 0) &&  $orange_check>0) || (in_array("Others" , $rstatus1) && ($count_others_orange == -1)&&  $orange_check>0) || in_array("Possible Match" , $rstatus1) || in_array("Record Not Found" , $rstatus1) || in_array("Partial Match" , $rstatus1)&&  $orange_check>0) {
            $report_status ="<span style='color:orange;'>ORANGE</span>";
        }         
        else if(in_array("Others" , $rstatus1) && (in_array("Not applicable" , $orstatus) || in_array("Not Applicable" , $orstatus)) && ($count_others_orange == 0))
        {
            $report_status ="<span style='color:green;'>GREEN</span>";
        }        
        // else if (in_array("Stop Check" , $rstatus1) || (in_array("Others" , $rstatus1) && ($count_others_orange > 0)) || (in_array("Others" , $rstatus1) && ($count_others_orange == -1)) || in_array("Possible Match" , $rstatus1) || in_array("Record Not Found" , $rstatus1) || in_array("Partial Match" , $rstatus1)) {
        //     $report_status ="<span style='color:orange;'>ORANGE</span>";
        // }
        else
        {
            $report_status ="<span style='color:green;'>GREEN</span>";
        }
        $publish_status=$report_status;
        /** Dec 15th **/
   }
   $chk_status=anchor('/Vsupervisor/check_status/'.base64_encode($row['request_id']),"View");
   $modify_checks='';
   if($this->session->userdata('role_id')==1 || $this->session->userdata('role_id')==3 || $this->session->userdata('role_id')==23){
        if($row['verification_status']==0){
           $modify_checks=anchor('/Management/editcandidate/'.base64_encode($row['user_id']),"Modify_Checks");
        }
   }
   if($this->session->userdata('role_id')==3)
   {
   $modify_name=anchor('/Management/candidatedit/'.base64_encode($row['user_id']),"Modify_Name",array('style' => 'color:'));
    }

 $cand_submit_date=(isset($row['candidate_submit_date']) && ($row['dataentry_by']==0)) ? date('d-m-Y',strtotime($row['candidate_submit_date'])):'';
   $client_submit_date=(isset($row['client_submit_date']) && ($row['dataentry_by']!=3)) ? date('d-m-Y',strtotime($row['client_submit_date'])):'';
   $des_rejected_date=(isset($row['des_rejected_date']) && ($row['dataentry_by']!=3)) ? date('d-m-Y',strtotime($row['des_rejected_date'])):'';  
$response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$officevalue,$branchofficevalue,$row['sub_office'],anchor('/Dadmin/dadminview/'.base64_encode($row['request_id']),$row['candidate_name']),$row['case_no'],$row['client_ref_number'],$type,$status,$publish_status,$interim,$final,'',$frp_date,$cname,$created_on,$case_recieved_date,$cand_submit_date,$client_submit_date,$des_rejected_date,$chk_status,$modify_checks.'<br>'.$modify_name); 
        }
        }
  echo json_encode($response);
  }
  /***************************************
   check_status
   ****************************************/
    function check_status(){
        $this->breadcrumbs->push($this->dashboard, $this->index_dashboard);
        $this->breadcrumbs->push('Case Status', 'Vsupervisor/case_status');
        $this->breadcrumbs->push('Check Status', 'Vsupervisor/check_status');
        $data['breadcrumb']=$this->breadcrumbs->show();
        $this->amodel->pagerender($data, 'case_status');  
}
function get_checkstatus(){
     $model = array(self::$vsupervisor_model=>'get_checkstatus');
   $req_id = ($_REQUEST['req_id']) ? $_REQUEST['req_id'] : '';
   if($req_id){
                $condition[]=" d.request_id = ".$req_id;
   }
        $manual_cond=implode(' and ',$condition);
        $manual_condition2=$manual_cond;
        $results = $this->_jqgrid_search($model,$manual_condition2);
        $response = $results[0]; 
         $result = $results[1];
        if ($result) {
        $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
        $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
        $page=$page - 1;
        $count=$page * $rows;
        foreach ( $result as $i => $row ) {
        $checkadminstatus = $this->vm->get_currentstatus($row['candidate_req_id']);    
        //VM Status Start
        $verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['check_id']);
        $verification_data=toArray(json_decode($verified_data['fielddata']));
        $status1=$this->vm->get_status($verification_data['status']);
        $status4='';
        $status2=$this->vm->get_status($verification_data['pstatus']);
        $status3=$this->vm->get_status($verification_data['status1']);
        if($verification_data['ostatus']<>''){
        $status4=$this->vm->get_status($verification_data['ostatus']);
        }
        if($verification_data['dstatus']<>''){
        $status4=$this->vm->get_status($verification_data['dstatus']);
        }
        if(!empty($status4)){
        $status41='-'.$status4['name'];
        }
        else{
        $status41='';
        }
        $stat='';
        $verifyurl='';
        if(!empty($status1['name'])){
        $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
        }
        else if($row['verify_status']<>'111' && $row['vrequest']==1 && $row['rstatus']==107){
        $stat='Initiated';
        }
        else{
        $stat='New';
        }
        if($row['qc_revert_request']==1){
        if($row['vm_assigned_qc']==1 && $row['verify_status']<>107){
        $verifyurl=$stat;
        }
        else{
        $verifyurl = 'Revert Assigned';
        }
        }elseif($row['vm_revert_option_status']==1 && $row['vm_revert_to']==2){
        $verifyurl = 'Revert Raised to DEO';
        }elseif($row['vm_revert_option_status']==2){
        $verifyurl = 'Revert Raised to cadmin';
        }elseif($row['vm_revert_to']==3 && $row['vm_revert_supervisor']==1){
        $verifyurl = 'Revert Raised to DES';
        }
        else if($row['vm_revert_option_status']==4 && $row['operator_submited_by']==12 || $row['vm_revert_option_status']==4 && $checkadminstatus['role_id']==13){
            $verifyurl = 'Revert Closed'; 
        }
        else if($row['vm_revert_to']==2 ){
            $verifyurl = 'Revert Closed'; 
        }
        else if($row['verify_status']<>'111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0)
        {
            $verifyurl = $stat;  
        }
        else if($row['verify_status']=='111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0)
        {
            $verifyurl = $stat; 
        }
        else if($row['ass_request']==1)
        { 
        $verifyurl='Request Raised';
        }
        else
        { 
          $verifyurl = $stat;
        }
        /* VM Status End */
        if($row['v_date']==''){
            $vmdetails=$row['vname'];
        }else{
        $vmdetails=$row['vname'].' - ('.date('d-m-Y', strtotime($row['v_date'])).')';
        }
        /* QC Status Start */
        $qc1verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['check_id']);
        $qc1verification_data=toArray(json_decode($qc1verified_data['qcfielddata']));
        $qc1status4='';
        $qc1status1=$this->vm->get_status($qc1verification_data['status']);
        $qc1status2=$this->vm->get_status($qc1verification_data['pstatus']);
        $qc1status3=$this->vm->get_status($qc1verification_data['status1']);
        if($verification_data['ostatus']<>''){
        $qc1status4=$this->vm->get_status($qc1verification_data['ostatus']);
        }
        if($verification_data['dstatus']<>''){
        $qc1status4=$this->vm->get_status($qc1verification_data['dstatus']);
        }
        if(!empty($status4)){
        $qc1status41='-'.$status4['name'];
        }
        else{
        $qc1status41='';
        }
        if(!empty($qc1status1['name'])){
        $qc1stat=$qc1status1['name'].'-'.$qc1status2['name'].'-'.$qc1status3['name'].''.$qc1status41;
        }else{
        $qc1stat='';
        }
        if($row['vmstatus']==1)
        {
        if($row['qc_revert_request']==1 && $row['vm_assigned_qc']==1 && $row['qc1_verification']==1 && $row['qc2_revert_request']==0){
        $qc1status=$qc1stat; 
        }
        elseif($row['qc_revert_request']==1 && $row['qc1_assign_revert']==1 && $row['qc1_verification']==1 && $row['qc2_revert_request']==1){
        $qc1status=$qc1stat; 
        }
        elseif($row['qc_revert_request']==1 && $row['vm_assigned_qc']==1 && $row['qc1_verification']==1 && $row['qc2_revert_request']==1){
        $qc1status='Revert Assigned';
        }
        else if($row['qc_revert_request']==1 && $row['vm_assigned_qc']==1 && $row['qc2_revert_request']==0){
        $qc1status='Revert Closed';
        }
        elseif($row['qc_revert_request']==1 && $row['qc2_revert_request']==0){
        $qc1status='Revert Raised';
        }
        elseif($row['qc2_verification']==0 && $row['qc1_verification']==0)
        {
        $qc1status='';
        }
        else{
        $qc1status=$qc1stat;
        }
        }
        else{
        $qc1status='';
        }
        if($row['qc_date']==''){
            $qc_name= $this->db->query("select concat_ws(' ',a.first_name,a.middle_name,a.last_name) as first_name from dcode_user a left join dcode_qc_request q ON a.id=q.assignee_id where q.request_id =".$row['candidate_req_id'])->row_array();
            $qcdetails=$qc_name['first_name'];
        }else{
        $qcdetails=$row['qcname'].' - ('.date('d-m-Y', strtotime($row['qc_date'])).')';
        }
        /* QC Status End */
        /* qc2 Status Start */
        $qc2verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['check_id']);
        $qc2verification_data=toArray(json_decode($qc2verified_data['qc2fielddata']));
        $qc2status4='';
        $qc2status1=$this->vm->get_status($qc2verification_data['status']);
        $qc2status2=$this->vm->get_status($qc2verification_data['pstatus']);
        $qc2status3=$this->vm->get_status($qc2verification_data['status1']);
        if($qc2verification_data['ostatus']<>''){
        $qc2status4=$this->vm->get_status($qc2verification_data['ostatus']);
        }
        if($qc2verification_data['dstatus']<>''){
        $qc2status4=$this->vm->get_status($qc2verification_data['dstatus']);
        }
        if(!empty($qc2status4)){
           $qc2status41='-'.$qc2status4['name'];
        }
        else{
        $qc2status41='';
        }
        if(!empty($qc2status1['name'])){
        $qc2stat=$qc2status1['name'].'-'.$qc2status2['name'].'-'.$qc2status3['name'].''.$qc2status41;
        }
        else{
        $qc2stat='';
        }
        if($row['vmstatus']==1)
        {
        if($row['qc2_verification']==0 && $row['qc1_verification']==1 )
        {
        $qc2status='New';
        if($row['qc1_assign_revert']==1){
            $qc2status='Revert Closed';
        }
        else if($row['qc2_revert_request']==1)
        {
        $qc2status='Revert Raised';
        }
        }
        elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==2 && $row['qc2_revert_request']==0)
        {
        $qc2status='Report Reopen';
        }
        else
        {
            $qc2status=$qc2stat;
        } 
        }
        else
        {
            $qc2status='';
        }
        if($row['qc2_date']==''){
            $qc2_name= $this->db->query("select concat_ws(' ',a.first_name,a.middle_name,a.last_name) as first_name from dcode_user a left join dcode_qc2_request q2 ON a.id=q2.assignee_id where q2.request_id =".$row['candidate_req_id'])->row_array();
            $qc2details=$qc2_name['first_name'];
        }else{
        $qc2details=$row['qc2name'].' - ('.date('d-m-Y', strtotime($row['qc2_date'])).')';
        }
        $chk_count='';
        $chk_count=($row['count_of_chk'] != 0)?$row['count_of_chk']:'';
        $deo_name='';
        $dname=$this->db->query("select concat_ws(' ',first_name,middle_name,last_name) as first_name from dcode_user where id =".$row['operator_id'])->row_array();
        $deo_name=$dname['first_name'];
        $deo_submit_date='';
        $deo_submit_date=isset($row['operator_submit_date'])? date('d-m-Y', strtotime($row['operator_submit_date'])):'';
        $qc2checkstatus='';
        if($row['qc2_verification']==1 && $row['qc2_report_publish']==0)
        {
            $qc2checkstatus='QC2 Approved';
        }
        elseif($row['qc2_verification']==1 && $row['qc2_report_publish']==1)
        {
             $qc2checkstatus='Report Published';
        }
       /* qc2Status End */
$response->rows [$i] ['cell'] = array ( $i+$count+1,$row['case_no'],$row['candidatename'],$row['checkname'].' '.$chk_count,$deo_name.' - ('.$deo_submit_date.')',$verifyurl,$vmdetails,$qc1status,$qcdetails,$qc2status,$qc2details,$qc2checkstatus );
        }
    }
        echo json_encode($response);
}
/*************************************************
 Listing of Verification of check status 
 *************************************************/
function verificationcheck_status()
    {
        $this->breadcrumbs->push($this->dashboard, $this->index_dashboard);
        $this->breadcrumbs->push('Check Status', 'Vsupervisor/verificationcheck_status');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'verificationcheck_status');
    }
function get_verificationcheckstatus(){
        
     $model = array(self::$vsupervisor_model=>'get_checkstatus');
    $name = ($_REQUEST['name']) ? $_REQUEST['name'] : ''; 
    $org_id = ($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
    $office = ($_REQUEST['office']) ? $_REQUEST['office'] : '';
    $parent_office = ($_REQUEST['parent_office']) ? $_REQUEST['parent_office'] : '';
    $sub_office = ($_REQUEST['sub_office']) ? $_REQUEST['sub_office'] : '';
    $case_number=($_REQUEST['case_number']) ? $_REQUEST['case_number'] : '';
    $vmname=($_REQUEST['vmname']) ? $_REQUEST['vmname'] : '';
    $qc1name=($_REQUEST['qc1name']) ? $_REQUEST['qc1name'] : '';
    $qc2name=($_REQUEST['qc2name']) ? $_REQUEST['qc2name'] : '';
    $check_name=($_REQUEST['check_name']) ? $_REQUEST['check_name'] : '';
    $a_status = ($_REQUEST['a_status']) ? $_REQUEST['a_status'] : '';
    //echo $a_status; exit;
    $college_name=($_REQUEST['college_name']) ? $_REQUEST['college_name'] : '';
    $university_name=($_REQUEST['university_name']) ? $_REQUEST['university_name'] : '';
    $c_date = ($_REQUEST['c_date']) ? $_REQUEST['c_date'] : '';
    $t_date = ($_REQUEST['t_date']) ? $_REQUEST['t_date'] : ''; 
    $chk_rpt_status = ($_REQUEST['chk_rpt_status']) ? $_REQUEST['chk_rpt_status'] : '';
    $company_name = ($_REQUEST['company_name']) ? $_REQUEST['company_name'] : '';
    $interim = ($_REQUEST['interim']) ? $_REQUEST['interim'] : '';
     
    $checkStatus = ($_REQUEST['check_status']) ? $_REQUEST['check_status'] : '';


    // $CaseAcceptedDate="(CASE WHEN (d.dataentry_by !=3 ) THEN d.case_accepted_date ELSE d.case_recieved_date END)";
    
    $CaseAcceptedDate="IF(d.dataentry_by =3 AND d.case_recieved_date != '0000-00-00' AND d.case_recieved_date != '', d.case_recieved_date, d.case_accepted_date )";

    $dateDiff="(5 * (DATEDIFF(CURDATE(), date(".$CaseAcceptedDate.")) DIV 7) + MID('0123444401233334012222340111123400012345001234550', 7 * WEEKDAY(date(".$CaseAcceptedDate.")) + WEEKDAY(CURDATE()) + 1, 1)) - (SELECT COUNT(*) FROM dcode_master_holidays WHERE status=1 and  holiday_date >= date(".$CaseAcceptedDate.") and holiday_date <= CURDATE())";

    if($checkStatus=='totalCheck'){
    $condition[]=" a.qc2_verification !=1 and a.qc2_report_publish !=1";
    }
    if($checkStatus=='overDue'){
    $condition[]=" (".$dateDiff." > ct.check_tat) and a.qc2_verification !=1 and a.qc2_report_publish !=1";
    }
    if($checkStatus=='dueToday'){
    $condition[]=" (".$dateDiff." = ct.check_tat) and a.qc2_verification !=1 and a.qc2_report_publish !=1";
    }
    if($checkStatus=='dueInNext5Days'){
    $condition[]=" ((".$dateDiff." < ct.check_tat) and ".$dateDiff." > (ct.check_tat) - 5) and a.qc2_verification !=1 and a.qc2_report_publish !=1";
    }
    if($checkStatus=='dueIn6DaysPlus'){
    $condition[]=" (".$dateDiff." <= (ct.check_tat) - 5) and a.qc2_verification !=1 and a.qc2_report_publish !=1";
    }

    if($parent_office){
    $condition[]=" d.parent_office = ".$parent_office;
    }
    if($office){
    $condition[]=" d.office = ".$office;
    }
    if($org_id){
    $condition[]=" d.organisation = ".$org_id;
    }
    if($sub_office){
    $condition[]=" d.sub_office = ".$sub_office;
    }
    if($name){
    $condition[]=" d.candidate_name like '%".$name."%'";
    }
    //17/01/2024
    $case_number = trim($case_number);
    if($case_number){
    $condition[]=" d.case_no like '%".$case_number."'";
    }
    if($vmname){
    $condition[]=" concat_ws(' ',us.first_name,us.last_name) like '%".$vmname."%'";
    }
    if($qc1name){
    $condition[]=" concat_ws(' ',us1.first_name,us1.last_name) like '%".$qc1name."%'";
    }
    if($qc2name){
    $condition[]=" concat_ws(' ',us2.first_name,us2.last_name) like '%".$qc2name."%'";
    }
    if($check_name){
    $condition[]=" c.name like '%".$check_name."%'";
    }
    if($college_name){
    $condition[]="(ed.collegename_add like '%".$college_name."%' and a.check_id = 14)";
    }
    if($university_name){
    $condition[]="(ed.affliated like '%".$university_name."%' and a.check_id = 14)";
    }
    if(!empty($c_date) && $a_status==1){
    $condition[]="DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
    }
    if(!empty($t_date) && $a_status==1){
    $condition[]="DATE_FORMAT(vl1.v_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
    }
    if(!empty($c_date) && $a_status==2){
    $condition[]="DATE_FORMAT(vl1.qc_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
    }
    if(!empty($t_date) && $a_status==2){
    $condition[]="DATE_FORMAT(vl1.qc_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
    }
    if(!empty($c_date) && $a_status==3){
    $condition[]="DATE_FORMAT(vl1.qc2_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
    }
    if(!empty($t_date) && $a_status==3){
    $condition[]="DATE_FORMAT(vl1.qc2_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
    }
    if(!empty($c_date) && $a_status==4){
    $condition[]="DATE_FORMAT(vl1.qc2_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
    }
    if(!empty($t_date) && $a_status==4){
    $condition[]="DATE_FORMAT(vl1.qc2_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
    }
    if(!empty($c_date) && $a_status==5){
    $condition[]="DATE_FORMAT(d.created_on ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
    }
    if(!empty($t_date) && $a_status==5){
    $condition[]="DATE_FORMAT(d.created_on ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
    }
    if(!empty($c_date) && $a_status==6){
    $condition[]="DATE_FORMAT(s.candidate_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and d.dataentry_by=0 ";
    }
    if(!empty($t_date) && $a_status==6){
    $condition[]="DATE_FORMAT(s.candidate_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and d.dataentry_by =0 ";
    }
    if(!empty($c_date) && $a_status==7){
    $condition[]="DATE_FORMAT(s.client_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and d.dataentry_by != 3 ";
    }
    if(!empty($t_date) && $a_status==7){
    $condition[]="DATE_FORMAT(s.client_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and d.dataentry_by != 3 ";
    }
    if(!empty($c_date) && $a_status==8){
    $condition[]="DATE_FORMAT(s.operator_submit_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
    }
    if(!empty($t_date) && $a_status==8){
    $condition[]="DATE_FORMAT(s.operator_submit_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
    }
     if(!empty($c_date) && $a_status==9){
    $condition[]="DATE_FORMAT(s.verification_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
    }
    if(!empty($t_date) && $a_status==9){
    $condition[]="DATE_FORMAT(s.verification_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
    }
     if(!empty($c_date) && $a_status==10){
    $condition[]="DATE_FORMAT(vr.deadline_from ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."'";
    }
    if(!empty($t_date) && $a_status==10){
    $condition[]="DATE_FORMAT(vr.deadline_from ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'";
    }
    if(!empty($c_date) && $a_status==11){
    $condition[]="(DATE_FORMAT(d.case_accepted_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' and s.client_status=1 and case when d.dataentry_by=3 Then DATE_FORMAT(d.case_recieved_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($c_date))."' else 1 end) ";
    }
    if(!empty($t_date) && $a_status==11){
    $condition[]="(DATE_FORMAT(d.case_accepted_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' and s.client_status=1 and case when d.dataentry_by=3 Then DATE_FORMAT(d.case_recieved_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."' else 1 end) ";
    }
    if($a_status==1){
    $condition[]=" a.verify_status in (110,111,519) and a.vm_assigned_qc=1 " ;
    }
    if($a_status==2){
    $condition[]=" a.qc_revert_request=0 and a.vm_assigned_qc=1 and a.qc1_verification=1 and a.qc2_revert_request=0 " ;
    }
    if($a_status==3){
    $condition[]=" a.qc_revert_request=0 and a.vm_assigned_qc=1 and a.qc2_verification=1 and a.qc2_revert_request=0 " ;
    }
    if($a_status==4){
    $condition[]="   a.qc2_verification=1 and a.qc2_report_publish=1" ;
    }
    if($a_status==12){
      $condition[]="a.qc2_report_publish != 1 ";
    }
    

    if($chk_rpt_status==1){
    $condition[]=" vl1.qc2_dis in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701) ";
    }
    if($chk_rpt_status==2){
    $condition[]=" ((vl1.qc2_dis in (120,131,137,143,713,119,130,136,142,1005)) or (vl1.qc2status in (519,110)))";
    }
    if($chk_rpt_status==3){
    $condition[]=" vl1.qc2_dis in (116,127,134,140,630,121,125,658,662,660,789) ";
    } 

    
    if($company_name){
    $condition[]="( em.company_name like '%".$company_name."%' OR ed.degree like '%".$company_name."%' OR pr.company_name like '%".$company_name."%')";   
    }

    if($interim ==1){
            $condition[]=" a.qc2_report_publish = 1 and a.qc2_verification=1 ";
        }
        if($interim ==2){
            $condition[]=" a.qc2_report_publish = 1 and d.final_report=1 ";
        }
        if($interim ==3){
            $condition[]=" ca.request_id IS NOT NULL ";
        }
        if($interim ==4){
            $condition[]=" d.supplement_report = 1 ";
        }
    $manual_cond=implode(' and ',$condition);  
    $manual_condition2=$manual_cond;
    $results = $this->_jqgrid_search($model,$manual_condition2);
    $response = $results[0];  
    $result = $results[1];
    if ($result) {
    $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
    $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
    $page=$page - 1;
    $count=$page * $rows;
    foreach ( $result as $i => $row ) {
    $checkadminstatus = $this->vm->get_currentstatus($row['candidate_req_id']);
    /* VM Status Start */
    $verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['check_id']);
    $verification_data=toArray(json_decode($verified_data['fielddata']));
    $status1=$this->vm->get_status($verification_data['status']);
    $status4='';
    $status2=$this->vm->get_status($verification_data['pstatus']);
    $status3=$this->vm->get_status($verification_data['status1']);
    if($verification_data['ostatus']<>''){
    $status4=$this->vm->get_status($verification_data['ostatus']);
    }
    if($verification_data['dstatus']<>''){
    $status4=$this->vm->get_status($verification_data['dstatus']);
    }
    if(!empty($status4)){
    $status41='-'.$status4['name'];
    }
    else{
    $status41='';
    }
    $stat='';
    $verifyurl='';
        if(!empty($status1['name'])){
        $stat=$status1['name'].'-'.$status2['name'].'-'.$status3['name'].''.$status41;
        }
        else if($row['verify_status']<>'111' && $row['vrequest']==1 && $row['rstatus']==107){
        $stat='Initiated';
        }
        else{
        $stat='New';
        }
        if($row['qc_revert_request']==1){
            if($row['vm_assigned_qc']==1 && $row['verify_status']<>107){
                $verifyurl=$stat;
            }
             // March 27th
            else if($row['vm_assigned_qc']==0 && $row['ass_request']==0 && $row['reopen_revert_qc2']==1)
            {
                $verifyurl = 'Reopen Assigned';
            }  // March 27th

            else{
            $verifyurl = 'Revert Assigned';
            }
        }elseif($row['vm_revert_option_status']==1 && $row['vm_revert_to']==2){
        $verifyurl = 'Revert Raised to DEO';
        }elseif($row['vm_revert_option_status']==2){
        $verifyurl = 'Revert Raised to cadmin';
        }elseif($row['vm_revert_to']==3 && $row['vm_revert_supervisor']==1){
        $verifyurl = 'Revert Raised to DES';
        }
        else if($row['vm_revert_option_status']==4 && $row['operator_submited_by']==12 || $row['vm_revert_option_status']==4 && $checkadminstatus['role_id']==13){
        $verifyurl = 'Revert Closed'; 
        }
        else if($row['vm_revert_to']==2 ){
        $verifyurl = 'Revert Closed'; 
        }
        else if($row['verify_status']<>'111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0)
        {
        $verifyurl = $stat;  
        }
        else if($row['verify_status']=='111' && $row['vrequest']==1 && $row['rstatus']!=0 && $row['ass_request']==0)
        {
        $verifyurl = $stat; 
        }
        else if($row['ass_request']==1)
        { 
        $verifyurl='Request Raised';
        }
        else
        { 
        $verifyurl = $stat;
        }
        /* VM Status End */
        $vm_name='';
        $vm_date='';
        $vm_name=$row['vname'];
        if($row['v_date']!=''){
        $vm_date=date('d-m-Y h:i a', strtotime($row['v_date']));
        }
        /*QC Status Start */
        $qc1verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['check_id']);
        $qc1verification_data=toArray(json_decode($qc1verified_data['qcfielddata']));
        $qc1status4='';
        $qc1status1=$this->vm->get_status($qc1verification_data['status']);
        $qc1status2=$this->vm->get_status($qc1verification_data['pstatus']);
        $qc1status3=$this->vm->get_status($qc1verification_data['status1']);
        if($verification_data['ostatus']<>'')
        {
           $qc1status4=$this->vm->get_status($qc1verification_data['ostatus']);
        }    
        if($verification_data['dstatus']<>''){
           $qc1status4=$this->vm->get_status($qc1verification_data['dstatus']);
        }
        if(!empty($status4)){
           $qc1status41='-'.$status4['name'];
        }
        else{
           $qc1status41='';
        }
        if(!empty($qc1status1['name'])){
        $qc1stat='QC1 Approved';
        }else{
        $qc1stat='';
        }
        $qc1status='';
        if($row['vmstatus']==1)
        {
        if($row['qc_revert_request']==1 && $row['vm_assigned_qc']==1 && $row['qc1_verification']==1 && $row['qc2_revert_request']==0){
        $qc1status=$qc1stat; 
        }
        elseif($row['qc_revert_request']==1 && $row['qc1_assign_revert']==1 && $row['qc1_verification']==1 && $row['qc2_revert_request']==1){
        $qc1status=$qc1stat; 
        }
        elseif($row['qc_revert_request']==1 && $row['vm_assigned_qc']==1 && $row['qc1_verification']==1 && $row['qc2_revert_request']==1){
        $qc1status='Revert Assigned';
        }
        else if($row['qc_revert_request']==1 && $row['vm_assigned_qc']==1 && $row['qc2_revert_request']==0){
        $qc1status='Revert Closed';
        }
        elseif($row['qc_revert_request']==1 && $row['qc2_revert_request']==0){
        $qc1status='Revert Raised';
        }
        elseif($row['qc2_verification']==0 && $row['qc1_verification']==0)
        {
        $qc1status='';
        }
        else{
        $qc1status=$qc1stat;
        }
        }
        else{
        $qc1status='';
        }
        $qc1_name='';
        $qc1_date='';
        $qc_name= $this->db->query("select concat_ws(' ',a.first_name,a.middle_name,a.last_name) as first_name from dcode_user a left join dcode_qc_request q ON a.id=q.assignee_id where q.request_id =".$row['candidate_req_id'])->row_array();
        if($row['qc_date']!=''){
        $qc1_date=date('d-m-Y', strtotime($row['qc_date']));
        $qc1_name=$row['qcname'];
        }
        else
        {
        $qc1_name=$qc_name['first_name'];
        }  
        /* QC Status End */
        /* qc2 Status Start */
        $qc2verified_data=$this->vm->get_verified_data($row['candidate_req_id'],$row['level_id'],$row['check_id']);
        $qc2verification_data=toArray(json_decode($qc2verified_data['qc2fielddata']));
        $qc2status4='';
        $qc2status1=$this->vm->get_status($qc2verification_data['status']);
        $qc2status2=$this->vm->get_status($qc2verification_data['pstatus']);
        $qc2status3=$this->vm->get_status($qc2verification_data['status1']);
        $qc2remark=$qc2verification_data['other_comment'];
        if($qc2verification_data['ostatus']<>''){
        $qc2status4=$this->vm->get_status($qc2verification_data['ostatus']);
        }
        if($qc2verification_data['dstatus']<>''){
        $qc2status4=$this->vm->get_status($qc2verification_data['dstatus']);
        }
        if(!empty($qc2status4)){
        $qc2status41='-'.$qc2status4['name'];
        }
        else{
        $qc2status41='';
        }
        if(!empty($qc2status1['name']) && $row['qc2_report_publish']==1){
            // // March 27th
            if($row['qc_2_verification']==1 && $row['supplementary']==1)
                {
                    $qc2stat='Reopen Assigned';
                }
            else // March 27th
                $qc2stat='Report Published';
        }else if(!empty($qc2status1['name']) && $row['qc2_verification']==1 && $row['qc2_report_publish']==0){
        $qc2stat='QC2 Approved';
        }
        else
        {
        $qc2stat='';
        }
        $qc2status='';
        $rpt_status='';
        if($row['check_id']==1306) { // ka added on april 25
            $rpt_status='';
        } // ka added on april 25
        else if($qc2verification_data['status']!=107 && $qc2verification_data['status']!=684 && !empty($qc2verification_data['status'])) {
        if($qc2status3['name']=="Discrepant" || $qc2status3['name']=="Possible Discrepant" || $qc2status3['name']=="Record Found" || $qc2status3['name']=="Positive" || $qc2status3['name']=="No Records" || $qc2status3['name']=="Invalid" || $qc2status3['name']=="Not Completed" || $qc2status3['name']=="High Risk" || $qc2status3['name']=="Multiple Active Records"){
        $rpt_status="<span style='color:red;'>RED</span>";
        }
        /** Aug 24th **/
        else if($qc2status1['name']=="Others" && (strtoupper($qc2status4['name']) == "NOT APPLICABLE")) // Dec 15th
        {
            $rpt_status="<span style='color:green;'>GREEN</span>";
        }
        /** Aug 24th **/
        else if($qc2status1['name']=="Stop Check" || $qc2status3['name']=="Stop Check" || $qc2status3['name']=="Others" || $qc2status3['name']=="Possible Match" || $qc2status3['name']=="Partial Match" || $qc2status1['name']=="Others" && (strtoupper($qc2status4['name']) != "NOT APPLICABLE")) // Dec 15th
        {
        $rpt_status="<span style='color:orange;'>ORANGE</span>";
        }
        else 
        {
        $rpt_status="<span style='color:green;'>GREEN</span>";
        }
        }     
        if($row['vmstatus']==1)
        {
        if($row['qc2_verification']==0 && $row['qc1_verification']==1 )
        {
            $qc2status='New';
            // if($row['qc1_assign_revert']==1){
            //     $qc2status='Revert Closed';
            // }
            // else if($row['qc2_revert_request']==1)
            // {
            // $qc2status='Revert Raised';
            // }
            // March  27th
            if($row['qc1_assign_revert']==1  && $row['qc_2_verification']==0 && $row['vm_assigned_qc']==1 && $row['reopen_revert_qc2']==0){
                $qc2status='Revert Closed';

            }

            else if($row['qc1_assign_revert']==1  && $row['supplementary']==1 && $row['qc_2_verification']==0 && $row['vm_assigned_qc']==1 && $row['reopen_revert_qc2'] == 1){
                $qc2status='Reopen Closed';
            }

            else if($row['qc2_revert_request']==1 && $row['reopen_revert_qc2']== 1 && $row['supplementary']==1  && $row['qc2_report_publish']==2)
            {
                if($row['revertedBy'] == 17)
                {
                    $qc2status='Revert Raised';
                }
                else
                {
                    $qc2status='Reopened'; 
                }
            }

            else if($row['qc2_revert_request']==1 && $row['reopen_revert_qc2']== 1 && $row['supplementary']==1  && $row['qc2_report_publish']==1)
            {
                if($row['revertedBy'] == 17)
                {
                    $qc2status='Revert Raised';
                }
                else
                {
                    $qc2status='Reopened'; 
                }
            } 

            else if($row['qc2_revert_request']==1 && $row['supplementary']==1 && $row['vm_assigned_qc']==1)
            {
                $qc2status='Reopened';
            
            } 
            else if($row['qc2_revert_request']==1 && $row['reopen_revert_qc2']== 1 && $row['supplementary']==1)
            {
                $qc2status='Revert Raised';
            }

            else if($row['qc2_revert_request']==1)
            {
                $qc2status='Revert Raised';
            }         // March  27th

        }
        elseif($row['qc_2_verification']==1 && $row['qc2_report_publish']==2 && $row['qc2_revert_request']==0)
        {
        $qc2status='Report Reopen';
        }
        else
        {
            $qc2status=$qc2stat;
        }    
        }
        else
        {
            $qc2status='';
        }
       $qc2_name='';
       $qc2_date='';
       $tat = '';
        $qc2name= $this->db->query("select concat_ws(' ',a.first_name,a.middle_name,a.last_name) as first_name from dcode_user a left join dcode_qc2_request q2 ON a.id=q2.assignee_id where q2.request_id =".$row['candidate_req_id'])->row_array();
        if($row['qc2_date']!='' && $row['qc2_report_publish']==1){
            $qc2_name=$row['qc2name'];
        $qc2_date=date('d-m-Y H:i:a', strtotime($row['qc2_date']));
               $tat = $row['finaldatetat'];

        }
        else if($row['qc2_verification']==1 && $row['qc2_report_publish']==0){
              $qc2_name=$row['qc2name'];
        }
        else
        {
            $qc2_name=$qc2name['first_name'];
        }
        $chk_count='';
        $chk_count=($row['count_of_chk'] != 0)?$row['count_of_chk']:'';
        $cand_submit_date=(isset($row['candidate_submit_date']) && ($row['dataentry_by']==0)) ? date('d-m-Y h:i a',strtotime($row['candidate_submit_date'])):'';
        $client_submit_date=(isset($row['client_submit_date']) && ($row['dataentry_by']!=3)) ? date('d-m-Y h:i a',strtotime($row['client_submit_date'])):''; 
        $created_on=(isset($row['created_on'])) ? date('d-m-Y h:i a',strtotime($row['created_on'])):'';
        $opt_submit_date=(isset($row['operator_submit_date'])) ? date('d-m-Y h:i a',strtotime($row['operator_submit_date'])):'';
        $allot_to_vs_date=(isset($row['vs_allotted_date'])) ? date('d-m-Y h:i a',strtotime($row['vs_allotted_date'])):'';
        $vm_allotted_date=(isset($row['vm_allotted_date'])) ? date('d-m-Y',strtotime($row['vm_allotted_date'])):'';
        $case_accepted_date='';
        if($row['dataentry_by']!=3 && $row['case_accepted_date']!="0000-00-00 00:00:00" && !empty($row['case_accepted_date']))
        {
            $case_accepted_date=date('d-m-Y h:i a',strtotime($row['case_accepted_date']));
        }  
        else if($row['dataentry_by']==3 && $row['case_recieved_date']!="0000-00-00" && !empty($row['case_recieved_date']))
        {
            $case_accepted_date=date('d-m-Y',strtotime($row['case_recieved_date']));
        }
       /* qc2Status End */
       $college_name='';
       $university_name='';
       if($row['check_id']==14){
            $clg_cmpny_name=$row['degree'];
            $college_name = $row['collegename_add'];
            $university_name = $row['affliated'];
       }
       else if($row['check_id']==59){
            $clg_cmpny_name=$row['company_name'];
       }
       else if($row['check_id']==68){
            $clg_cmpny_name=$row['pcompany_name'];
       }
       else{
        $clg_cmpny_name='';
       }

       $no_of_working_date =$this->vm->get_no_working_days($row['candidate_req_id']);
       $no_of_working  =  $no_of_working_date['accept_case_tat'];

       $no_of_day_deo  =$this->vm->get_no_day_deo($row['candidate_req_id']);
       $no_taken_deo_day =  $no_of_day_deo['accept_case_tat'];

       $no_of_day_vs_allot  =$this->vm->get_no_day_vs_allot($row['candidate_req_id'],$row['check_id'], $row['level_id']);
       $no_of_day_taken_vs =       $no_of_day_vs_allot['accept_case_tat'];

       $no_of_day_taken_vm  =$this->vm->get_no_day_taken_vm($row['candidate_req_id'],$row['check_id'], $row['level_id']);
       $no_day_taken_vm  =   $no_of_day_taken_vm['accept_case_tat'];
       $no_of_day_taken_qc2  = 0;
       $no_of_day_taken_qc2  =$this->vm->get_no_day_taken_qc2($row['candidate_req_id'],$row['check_id'], $row['level_id']);
       $no_day_taken_qc2 =   $no_of_day_taken_qc2['accept_case_tat'];

     $response->rows [$i] ['cell'] = array ( $i+$count+1,$row['org_name'],$row['parent_office'],$row['office_name'],$row['sub_office'],$row['candidatename'],$row['case_no'],$row['checkname'].' '.$chk_count,$clg_cmpny_name,$college_name,$university_name,$vm_name,$verifyurl,$qc2remark,$vm_date,$qc1_name,$qc1status,$qc1_date,$qc2_name,$qc2status,$qc2_date,$rpt_status,$created_on,$cand_submit_date,$client_submit_date,$case_accepted_date,$row['check_tat'],$row['Days'],$no_of_working,$opt_submit_date,$no_taken_deo_day,$allot_to_vs_date,$no_of_day_taken_vs,$vm_allotted_date,$no_day_taken_vm , $no_day_taken_qc2,$tat);

        }
    }
        echo json_encode($response);
}    
/**********************************
 Reopen final report case 
 *************************************/
function reopen_finalreport()
    {
        $data['candidate_req_id']=$condition['candidate_req_id']=$request_id=base64_decode($this->uri->segment(3));
        $data['level_id']=$level_id=base64_decode($this->uri->segment(4));
        $data['check_id']=$check_id=base64_decode($this->uri->segment(5));
        $data['pack_id']=$pack_id=base64_decode($this->uri->segment(6));
        $candidate = $this->vm->get_canname($request_id);
        $data['candidate_name'] = $candidate[0]['candidate_name'];
        $data['case_no'] = $candidate[0]['case_no'];
        $data['checkname'] = $this->db->query("select a.count_of_chk,b.name from ". DB_PREFIX ."ver_assign_rep a LEFT JOIN " . DB_PREFIX . "master_masterdata b ON b.id=a.check_id where b.id=".$check_id." and a.candidate_req_id=".$request_id." and a.level_id=".$level_id)->row_array();
        $this->breadcrumbs->push($this->dashboard, $this->index_dashboard);
        $this->breadcrumbs->push('Reopen final report', 'Vsupervisor/reopen_finalreport');
        $data['breadcrumb']=$this->breadcrumbs->show();  
        $this->amodel->pagerender($data, 'reopen_finalreport');
    }
 /************************
   reopencase
   **************************/
function reopencase(){
    $checkStatus='';
    $this->load->helper('file');
    $rep_status['supplement_report']= 2;
    $this->db->where('request_id',$_POST['request_id']);
    $this->db->update ( DB_PREFIX .'client_request', $rep_status );
    $reopen['supplementary']= 1;
    // $reopen['role_id']= $this->session->userdata['role_id'];
    $this->db->where('request_id',$_POST['request_id']);
    $this->db->where('check_id',$_POST['check_id']);
    $this->db->where('level_id',$_POST['level_id']);
    $this->db->where('package_id',$_POST['pack_id']);
    $this->db->update ( DB_PREFIX .'verified_level', $reopen );

    $roleId=$this->session->userdata['role_id'];

    if($roleId==1){
        $checkStatus=1011;
    }
    else if($roleId==21 || $roleId==24){
        $checkStatus=1012;
    }else if($roleId==17){
        $checkStatus=1013;
    }else{
       $checkStatus=''; 
    }

    /************* Status Updtes ***************/ 

        $stat_save['request_id']=$_POST['request_id'];
        $stat_save['case_no']=$_POST['case_no'];
        $stat_save['check_id']=$_POST['check_id'];
        $stat_save['level_id']=$_POST['level_id'];
        $stat_save['check_status']=$checkStatus;
        $stat_save['verified_status']='';
        $stat_save['date_of_update']=date('y-m-d H:i:s');
        $stat_save['role_id']=$this->session->userdata('role_id');
        $stat_save['user_id']=$this->session->userdata['userid'];
        // print_r($stat_save);exit;
        $stat_save = $this->security->xss_clean($stat_save);
        $this->db->insert(DB_PREFIX.'status_updates',$stat_save);

    /******************************************/


    $request_id=$_POST['request_id'];
    $cdate = $this->rm->getfinalupdateedate($request_id);
    $qccheck ='admin';
    $pdfresult=$this->pdfexport->generate_pdf($request_id,base64_encode($cdate['created_date']),$qccheck,'export');
    $candidate_info = $this->rm->get_candidateionfo($request_id);
    $html=$pdfresult['html']; 
    $pdf = (object)$html;
    require_once("./dom_pdf/dompdf_config.inc.php");
    $dompdf = new DOMPDF();
    $dompdf->load_html($html);
    $dompdf->render();
    $canvas = $dompdf->get_canvas();
    $font = Font_Metrics::get_font("Times New Roman", "oblique");
    $canvas->page_text(500, 780, "Confidential {PAGE_NUM} / {PAGE_COUNT}",
    $font, 10, array(0,0,0));
    $filename="Report_".base64_encode($candidate_info['candidate_name']."_".date('d_m_Y_H_i_s')).".pdf";
    $output1 = $dompdf->output($filename);
    file_put_contents( getcwd()."/uploads/finalreport/".$filename, $output1) ;
    chmod($filename, 777);
    $reports = $this->amodel->getDetails(DB_PREFIX . "finalreportpublished", array('report_name'), array('request_id' => $request_id));
    if(!empty($reports)){
        $this->db->set('status',2);
         $this->db->where('request_id',$request_id);
         $this->db->update(DB_PREFIX.'finalreportpublished');
    }
    $save['request_id']=$request_id;
    $save['report_name']=$filename;
    $save['published_date']=date("Y-m-d H:i:s", strtotime($cdate['created_date']));
    $save['status']=1;
    $save['created_by']=$this->session->userdata['userid'];
    $save['created_on']=date('Y-m-d H:i:s');
    $this->db->insert(DB_PREFIX.'finalreportpublished',$save);
    if($roleId != 17)
        $this->tm->save_TAT_on_final_reopen($_POST['request_id'], $_POST['check_id'], $_POST['level_id']);  // MN Aug         
    redirect ( base_url('Verification/qc2_casechecklist/'.base64_encode($_POST['request_id'])), 'refresh' );
    }   
  /************************
   Pending checks
   **************************/
  function vmpending_checks()
    {
        $this->breadcrumbs->push($this->dashboard, $this->index_dashboard);
        $this->breadcrumbs->push('VM Pending Checks', 'Vsupervisor/vmpending_checks');
        $data['breadcrumb']=$this->breadcrumbs->show();    
        $this->amodel->pagerender($data, 'vmpending_checks');
    }   
   function get_pendingchecks()
   {
       $model = array(self::$vsupervisor_model=>'get_pendingchecks');

       $pending_chk = ($_REQUEST['pending_chk']) ? $_REQUEST['pending_chk'] : '';

        // if($this->session->userdata['role_id']==5){
            // $rep_id= " (SELECT  GROUP_CONCAT(ar.rep_id) as verifier from dcode_ver_assign_rep ar
            //     LEFT  JOIN  dcode_verified_level vl1 ON vl1.request_id = ar.candidate_req_id and vl1.check_id = ar.check_id and vl1.level_id = ar.level_id
            //     where ar.team_mem_id = 21234 and (ar.verify_status =107 or ar.vm_assigned_qc=0 or ar.verify_status =684  )  or  (ar.qc_revert_request = 1 and ar.vm_assigned_qc=0) group by ar.candidate_req_id having count(verifier)=5)" ;
            // $rid=$this->db->query($rep_id)->result_array();
            // foreach ($rid as  $rvalue) {
            //     $verifier_ids[]=$rvalue['verifier'];
            // }
            // $condition[]=" a.rep_id in (".implode(',',$verifier_ids)." )";
        // }

        if(in_array($this->session->userdata['role_id'], array(1,9,21,24))) {
            // edited by amritha on 30/06/2023
            $condition[]="((a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0) or (a.qc_revert_request = 1 and a.vm_assigned_qc=0 and s.vm_revert_option_status != 1 and vl1.supplementary != 1) or (s.vm_revert_option_status = 3 and a.vm_revert_to=2 and a.qc_revert_request = 0 and a.verify_status<>111) or (a.verify_status<>111 and a.vm_revert_request!=0 and a.vm_revert_status=107) or (s.vm_revert_option_status = 1 and a.vm_revert_to = 2) or (a.verify_status = 684 and s.vm_revert_option_status != 1 and a.qc_revert_request !=1) or (a.verify_status = 992 and a.qc_revert_request !=1) or ( a.vm_assigned_qc = 0 and a.ass_request = 0 and vl1.supplementary = 1 and a.qc_revert_request = 1 and a.reopen_revert_qc2 = 1) or (a.verify_status =107 or a.vm_assigned_qc=0 or a.verify_status =684 or a.verify_status =992 )) ";
            
            // $rep_id= " (SELECT  GROUP_CONCAT(ar.rep_id) as verifier from dcode_ver_assign_rep ar
            //   where (ar.verify_status =107 or ar.vm_assigned_qc=0 or ar.verify_status =684 ) group by ar.candidate_req_id having count(ar.candidate_req_id)=1)" ;
            //   $rid=$this->db->query($rep_id)->result_array();

            //   foreach ($rid as  $rvalue) {
            //     $verifier_ids[]=$rvalue['verifier'];
            //   }
            // $condition[]=" a.rep_id in (".implode(',',$verifier_ids)." )";
        }

            $manual_cond=implode(' and ',$condition);
            $results = $this->_jqgrid_search($model,$manual_cond);
            $response = $results[0];  
            $result = $results[1]; 
            if ($result) {
                $page=($_REQUEST['page']) ? $_REQUEST['page'] : 1;
                $rows=($_REQUEST['rows']) ? $_REQUEST['rows'] : 1;
                $page=$page - 1;
                $count=$page * $rows;
                // echo '<pre>';print_r($result);exit;
                foreach ( $result as $i => $row ) {

                    $total[$row['num_checks']]['checks']= $total[$row['num_checks']]['checks']+$row['num_checks'];
                    $total[$row['num_checks']]['cases']= $total[$row['num_checks']]['cases']+$row['num_cases'];
                    $total[$row['num_checks']]['pending_check']=$row['num_checks'];

                }

                $k=0;
                $j=1;
                for($j=1;$j<=5;$j++){
                $k=$j-1;
                $num_pending=0;
                $num_pending=($total[$j]['pending_check'])?$total[$j]['pending_check']:0;
                $num_cases=0;
                $num_cases=($total[$j]['cases'])?$total[$j]['cases']:0;
                $num_checks=0;
                $num_checks=($total[$j]['checks'])?$total[$j]['checks']:0;
                $list='';
                if($num_pending != 0){
                    $list=anchor('/Verification/vmpending_lists/'.base64_encode($num_pending)," View");
                }
               $response->rows[$k]  ['cell'] = array ($j, $num_cases, $num_checks,$list);
                }
            } 
             echo json_encode($response);  
   }

     function tds_doc_del($userid,$id){

       $id = base64_decode($id);
       //print_r($id);exit();
       $this->db->query( 'delete from '.DB_PREFIX .'tds_doc where id = "' . $id . '"');
       redirect('Dadmin/dadminview'.'/'. $userid);

    }

    //10/01/2024 -- table not using
   //  function icc_doc_del($userid,$id){

   //     $id = base64_decode($id);
   //     //print_r($id);exit();
   //     $this->db->query( 'delete from '.DB_PREFIX .'icc_doc where id = "' . $id . '"');
   //     redirect('Dadmin/dadminview'.'/'. $userid);

   // }
}    