<?php
function textbox($name, $value = '', $param = '', $zend_validation = '') {
    $fieldtype = "Zend_Form_Element_Text";
    $formVariable = new $fieldtype($name);
    $formVariable->setValue($value);
    $formVariable->setAttrib('id', $name);
    $validation = explode('|', $param);
    $valid_id = $this->validationparams($validation);
    $zend_val = explode('|', $zend_validation);
    foreach ($zend_val as $zend_val1) {
        switch ($zend_val1) {
            case 'RO':
                $formVariable->setAttrib('readonly', 'true');
            break;
            case 'D':
                $formVariable->setAttrib('disable', 'true');
            break;
            default:
            break;
        }
    }
    $formVariable->setAttrib('class', $valid_id);
    $formVariable->removeDecorator('DtDdWrapper');
    $formVariable->removeDecorator('HtmlTag');
    $formVariable->removeDecorator('label');
    return $formVariable;
}
function selectbox($name, $value = '', $selected = '', $param = '', $zend_validation = '') {
    $fieldtype = "Zend_Form_Element_Select";
    $formVariable = new $fieldtype($name);
    $formVariable->addMultiOption('', 'Select');
    $formVariable->setValue($selected);
    $formVariable->setAttrib('id', $name);
    if ($value) {
        foreach ($value as $value) {
            $formVariable->addMultiOption($value['id'], $value['type']);
        }
    }
    $validation = explode('|', $param);
    $valid_id = $this->validationparams($validation);
    $formVariable->setAttrib('class', $valid_id);
    $zend_val = explode('|', $zend_validation);
    if ($zend_validation) {
        foreach ($zend_val as $zend_val1) {
            switch ($zend_val1) {
                case 'D':
                    $formVariable->setAttrib('disable', 'true');
                break;
                default:
                break;
            }
        }
    }
    $formVariable->removeDecorator('DtDdWrapper');
    file: ///var/www/ourbank-core/application/views/helpers/Textform.php
        $formVariable->removeDecorator('HtmlTag');
        $formVariable->removeDecorator('label');
        return $formVariable;
    }
    function nullspace() {
        return NULL;
    }
    function button($name, $value = '', $param = '') {
        $formVariable = new Zend_Form_Element_Button('' . $name . '');
        $formVariable->setlabel('Yes');
        $formVariable->setAttrib('id', $name);
        $formVariable->setAttrib('class', 's-button');
        $formVariable->setDecorators(array(array('ViewHelper'), array('Description'), array('HtmlTag', array('tag' => 'div', 'class' => 's-button')),));
        return $formVariable;
    }
    function submit($name, $value = '', $param = '') {
        $formVariable = new Zend_Form_Element_Button('' . $name . '');
        $formVariable->setlabel('Yes');
        $formVariable->setAttrib('id', $name);
        $formVariable->setAttrib('type', 'submit');
        $formVariable->setDecorators(array(array('ViewHelper'), array('Description'), array('HtmlTag', array('tag' => 'div', 'class' => 's-button')),));
        return $formVariable;
    }
    function image($name, $value = '', $param = '') {
        $submit = new Zend_Form_Element_Image('submit');
        $submit->setlabel('Submit')->setImage('images/submit.png')->setAttrib('id', 'submitbutton')->setAttrib('type', 'submit');
        // buttons do not need labels
        $submit->setDecorators(array(array('ViewHelper'), array('Description'), array('HtmlTag', array('tag' => 'div', 'class' => 'submit-group')),));
    }
    function textbox_hidden($name, $value = '', $param = '') {
        $fieldtype = "Zend_Form_Element_Hidden";
        $formVariable = new $fieldtype($name);
        $formVariable->setValue($value);
        $formVariable->setAttrib('id', $name);
        $validation = explode('|', $param);
        $valid_id = $this->validationparams($validation);
        $formVariable->setAttrib('class', $valid_id);
        $formVariable->removeDecorator('DtDdWrapper');
        $formVariable->removeDecorator('HtmlTag');
        $formVariable->removeDecorator('label');
        return $formVariable;
    }
    function checkbox($name, $value = '', $param = '') {
        $fieldtype = "Zend_Form_Element_Checkbox";
        $formVariable = new $fieldtype($name);
        $formVariable->setAttrib('id', $name);
        $validation = explode('|', $param);
        $valid_id = $this->validationparams($validation);
        $formVariable->setAttrib('class', $valid_id);
        $formVariable->removeDecorator('DtDdWrapper');
        $formVariable->removeDecorator('HtmlTag');
        $formVariable->removeDecorator('label');
        return $formVariable;
    }
    function textarea($name, $value, $param = '') {
        $fieldtype = "Zend_Form_Element_Textarea";
        $formVariable = new $fieldtype($name);
        $validation = explode('|', $param);
        $valid_id = $this->validationparams($validation);
        $formVariable->setAttrib('class', $valid_id);
        $formVariable->setAttrib('id', $name)->setAttrib('rows', '2')->setAttrib('cols', '2');
        $translator = $this->getTranslator();
        $formVariable->removeDecorator('DtDdWrapper');
        $formVariable->removeDecorator('HtmlTag');
        $formVariable->removeDecorator('label');
        return $formVariable;
    }
    function validationparams($validations) {
        $valid_id = array();
        foreach ($validations as $values) {
            switch ($values) {
                case 'R':
                    $valid_id[] = "required";
                break;
                case 'D1':
                    $valid_id[] = "date1";
                break;
                case 'D2':
                    $valid_id[] = "date2";
                break;
                case 'N':
                    $valid_id[] = "number";
                break;
                case 'M':
                    $valid_id[] = "mand";
                break;
                case 'L':
                    $valid_id[] = "letters";
                break;
                case 'P':
                    $valid_id[] = "percentage";
                break;
                case 'AN':
                    $valid_id[] = "alphanumerics";
                break;
                case 'W':
                    $valid_id[] = "v-usetxt";
                break;
                case 'Y':
                    $valid_id[] = "s-option";
                break;
                case 'Z':
                    $valid_id[] = "s-inpt";
                break;
                default:
                break;
            }
        }
        return $valid_id;
    }
    function selectbox_dropdown($name, $value = '', $selected = '', $param = '') {
        $fieldtype = "Zend_Form_Element_Select";
        $formVariable = new $fieldtype($name);
        $formVariable->addMultiOption('', 'Select');
        $formVariable->setValue($selected);
        $formVariable->setAttrib('id', $name);
        $x = "";
        if ($value) {
            foreach ($value as $value1) {
                if ($value1['parent'] == 0) {
                    $formVariable->addMultiOption($value1['id'], $value1['type']);
                } elseif ($value1['parent'] > 0) {
                    //                                     echo $value1['parent'];
                    for ($i = 0;$i < $value1['parent'];$i++) {
                        $x = $x . "--";
                    }
                    $formVariable->addMultiOption($value1['id'], $x . $value1['type']);
                    $x = "";
                }
            }
        }
        $validation = explode('|', $param);
        $valid_id = $this->validationparams($validation);
        $formVariable->setAttrib('class', $valid_id);
        $formVariable->removeDecorator('DtDdWrapper');
        $formVariable->removeDecorator('HtmlTag');
        $formVariable->removeDecorator('label');
        return $formVariable;
    }