<?php
/**
 * FeatureAuth Class  
 * @author shariff 
 *
 */
class FeatureAuth {
	
	private $logged_in_user = ''; // logged in userid 
	private $CI = ''; // Codeigniter Core Instance 
	private $tbl_config = array ('tbl_role_cfg' => 'm_role_config', 'tbl_featurelist' => 'm_featurelist' );
	
	/**
	 * Default Constructor 
	 */
	function FeatureAuth() {
		$this->CI = & get_instance ();
	}
	
	/**
	 * Initilaise FA Config  
	 * @param $config
	 */
	function _init($config) {
		$this->logged_in_user = $config ['logged_in_user'];
		$this->user_role_id = $config ['user_role_id'];
	}
	
	/**
	 * Check for valid action 
	 * @param $action
	 */
	function _check_valid_action($ref_name = '', $action = '', $return = FALSE) {
		 
		if (! $ref_name) {
                        echo '<script>alert("Invalid Action / Permission Denied For Logged in user"); history.go(-1); </script>';
			//show_error ( 'Invalid Action / Permission Denied For Logged in user' );
			exit ();
		}
		
		$role_config = $this->_get_roleconfig_by_refname ( $this->user_role_id, $ref_name );
		
		$this->CI->config->set_item('fa_'.$ref_name.'_perms',$role_config);
		
		if(!isset($role_config [$action])){
			show_error ( $action.' not found in feature '.$ref_name );
			exit ();
		}
		if ($role_config [$action]) {
			return TRUE;
		} else {
			if ($return == FALSE) {
			        echo '<script>alert("Permission Denied For Logged in user"); history.go(-1); </script>';
				//show_error ( 'Permission Denied For Logged in user on <b>' . $ref_name . '</b>' );
				exit ();
			} else {
				$this->error_string = 'Permission Denied For Logged in user on <b>' . $ref_name . '</b>';
				return FALSE;
			}
		
		}
	}
	
	function _check_valid_link($ref_name = '', $action = '', $return = FALSE) {

		if (! $ref_name) { 
                       // echo '<script>alert("Invalid Action / Permission Denied For Logged in user"); history.go(-1); </script>';
                        redirect(base_url('Index/dashboard'));
			//show_error ( 'Invalid Action / Permission Denied For Logged in user' );
			exit ();
		}
		
		$role_config = $this->_get_roleconfig_by_refname ( $this->user_role_id, $ref_name );
	     //   echo "<pre>";print_r($role_config); exit;
		$this->CI->config->set_item('fa_'.$ref_name.'_perms',$role_config);
		
		if(!isset($role_config [$action])){ 
			show_error ( $action.' not found in feature '.$ref_name );
			exit ();
		}
		if ($role_config [$action]) { 
			return 1;
		} else { 
			return 0; 
		}
		
	}
	

	function get_access_perms($ref_name){
		if (! $ref_name) {
			show_error ( 'Invalid Action / Permission Denied For Logged in user' );
			exit ();
		}
		
		return $this->_get_roleconfig_by_refname ( $this->user_role_id, $ref_name );
	}
	
	function _get_roleconfig_by_refname($role_id, $ref_name) {
		
		$dbObj = $this->CI->db;
		$tbl_config = $this->tbl_config
		;
		
		
		$dbObj->where ( 'f.ref_name', $ref_name );
		$dbObj->where ( 'r.role_id', $role_id );
		$dbObj->where ( 'r.organization', $this->CI->session->userdata('organization'));
		if($this->CI->session->userdata('parent_office')<>0 )
		$dbObj->where ( 'r.parent_office', $this->CI->session->userdata('parent_office') );
		if($this->CI->session->userdata('office_id') <>0 && $this->CI->session->userdata('role_id')<>12)
		$dbObj->where ( 'r.office_id', $this->CI->session->userdata('office_id') );
		
		
		
		$dbObj->join ( $tbl_config ['tbl_featurelist'] . ' f ', ' f.id = r.feature_id ' );
		$rc_results = $dbObj->get ( $tbl_config ['tbl_role_cfg'] . ' as r' );
		
		//echo $dbObj->last_query();
		if ($rc_results->num_rows ()) {
			$role_config = $rc_results->result_array ();  
			return $role_config [0];
		} else {
		
		}
	}

}
