<?php 
    class Activity_model extends CI_Model {
        //Constructor
        function __construct() 
        {
            parent::__construct();
            $this->load->database();
            $this->load->model('Adm_model', 'amodel');
        }

    /**************************** function get_newactivity *************    
    Made changes On 29th September - for  getting  verified status 
    and status of check (to show red, green and orange) 
    Added LEFT JOIN  ".DB_PREFIX ."user ur ON ur.id = d.user_id
    and ur.active_status != 3 on 3rd May
    *******************************************************************/
    function get_newactivity($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') {    
        $select = " vs.candidate_req_id, vs.level_id, c.id as checkId, a.case_no,d.candidate_name as candidatename,o.org_name,p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,c.name as checkname,a.check_status as status,vs.vm_revert_status as rstatus, a.date_of_update as date, r.role_name,concat_ws(' ',u.first_name,u.middle_name ,u.last_name) as user_name, vs.count_of_chk as chk ";
        $from = "  from ".DB_PREFIX ."status_updates a
        LEFT JOIN ".DB_PREFIX ."client_request d ON d.request_id = a.request_id
        LEFT JOIN  ".DB_PREFIX ."user ur ON ur.id = d.user_id
        LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
        LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
        LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
        LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
        LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."role_types r ON r.id = a.role_id
        LEFT JOIN  ".DB_PREFIX ."user u ON u.id = a.user_id
        LEFT JOIN  ".DB_PREFIX ."ver_assign_rep vs ON vs.candidate_req_id=a.request_id and vs.check_id = a.check_id and vs.level_id=a.level_id WHERE 1=1 and ur.active_status != 3 ";       

        if ($searchCond) {
        $from .= " and $searchCond";
        }

        if ($type == 'count') $select = "count(DISTINCT(a.id)) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " group by a.id order by a.id $sOrder limit $pg," . $limit;
        }

        // Forming  SQL select query and querying the db.
        $sql = "SELECT " . $select . "" . $from;        
        $query = $this->db->query($sql);

        // Returning the resultset as an array.
        return $query->result_array();
    }

    /****************get_newactivity ends  here*************************/

    /*******************************************************
    ***** function get_datewise_activitysheet *************
    ********************************************************/
    // Added by MN on 9th Aug and modified on 11th Aug 2022,22nd Aug 2022 and 5th Sep (to take care of more than 1 VM)
    /* 
    /*
     * This function takes fromDate, toDate(search parameters entered) and userId of the logged  in user OR the user ID 
     * whose  activity needs  to  be  viewed and fetches 
     * date_of_update, COUNT(check_status) and check_status columns from status_updates table where role_id = 5 i.e.,
     * role is verification member
     * and returns row(s) of records with the data.
     * Added  active or  inactive member check = $status
     * Edited on 18th Jan to include target for each user from user_target table
     * Removed target on 17th Feb (user data needs to be there in user_target for this to work so)
     * Added LEFT JOIN ".DB_PREFIX ."client_request d ON d.request_id = s.request_id
     * LEFT JOIN ".DB_PREFIX ."user ur ON ur.id = d.user_id   
     * ur.active_status !=3 on May 3rd 2023
     */

    function get_datewise_activitysheet($fromDate,$toDate,$userId=0,  $status){
        
        // DATE is used since  we need  only  the date portion of the date-time stamp in the db
        $select = "DATE(date_of_update)  as updateDate,  COUNT(a.check_status) as status, a.check_status";
        $from  = " FROM " . DB_PREFIX . "status_updates a JOIN " . DB_PREFIX ."user u ON   u.id = a.user_id
        LEFT JOIN ".DB_PREFIX ."client_request d ON d.request_id = a.request_id
        LEFT JOIN ".DB_PREFIX ."user ur ON ur.id = d.user_id ";
        // JOINur.active_status !=3 and  " . DB_PREFIX ."user_target t ON t.user_id = u.id"; // user_target removed on 17th Feb
        $from  .= " where ur.active_status !=3 and a.role_id = 5 AND (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')";


        $groupBy = " GROUP BY DATE(a.date_of_update), check_status"; // We want individual dates and check_status
        $orderBy =  " ORDER BY DATE(`date_of_update`) DESC"; // Ordering by date_of_update in descending order.

    
        if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==9){
            if($userId!=0){
                // taking into account 1  or more VMs
                $from .= " and a.user_id IN (".$userId . ")";
            }else{
                $from .= " "; // All active or inactive VMs 
            }
        }
        else{
            $from .= " and a.user_id=".$this->session->userdata['userid']; // logged in user
        }

        // inactive or active status
        $from .= " and u.status=" .$status;

        // Forming  SQL select query and querying the db.
        $sql = "SELECT " . $select . "" . $from . $groupBy .  $orderBy;
        $query = $this->db->query($sql);

        // Added on 18th Jan
        // Returning the resultset as an array.
        return $query->result_array();
        
    }



    /*******************************************************
    ***** function get_member_wise_activitysheet *************
    ********************************************************/
    // Added by MN on 18th Aug and modified on 22nd Aug and 5th Sep (to take care of more than 1 VM)
    /* 
    /*
     * This function takes fromDate,toDate (search parameters entered) and userId of the logged  in user OR the user ID 
     * whose  activity needs  to  be  viewed and fetches
     * first_name, middle_name, last_name from the  user table (of all the users or the given  user_id, 
     * whichever maybe the case. Also, date_of_update, COUNT(check_status) and check_status columns from 
     * status_updates table where   
     * role_id = 5 i.e., role is verification member
     * and returns row(s) of records with the data.
     * Added  active or  inactive member check -  $status
     * 16th Jan added 1110 and 1519 for "where check_status in". 1110 and 1519 are codesfor others andd stop check when a check * is reopened
     *  LEFT JOIN ".DB_PREFIX ."client_request d ON d.request_id = a.request_id
     * LEFT JOIN ".DB_PREFIX ."user ur ON ur.id = d.user_id 
     * ur.active_status !=3 on May 3rd  
     */
    function get_member_wise_activitysheet($fromDate, $toDate, $userId=0, $status)
    {
        $select = "concat(u.first_name,' ', u.middle_name, ' ', u.last_name) as Name, s.check_status, DATE(date_of_update) as updateDate, COUNT(s.check_status) as statusActivity , s.user_id, s.role_id";
        $from  =    " FROM " . DB_PREFIX . "status_updates s JOIN " . DB_PREFIX ."user u ON   u.id = s.user_id 
                    LEFT JOIN ".DB_PREFIX ."client_request d ON d.request_id = s.request_id
                    LEFT JOIN ".DB_PREFIX ."user ur ON ur.id = d.user_id 
                    where ur.active_status !=3 and s.check_status IN ('107', '110', '111', '519', '992', '684', '1001', '1002', '1004', '1005', '1006', '1110', '1519') and s.role_id=5 AND (DATE_FORMAT(s.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."' and DATE_FORMAT(s.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')";

        $groupBy = " GROUP BY check_status, user_id"; // We want individual dates and check_status
        $orderBy =  " ORDER BY user_id"; // Ordering by date_of_update in descending order.

        if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==9){
            if($userId!=0){
                // taking into account 1  or more VMs
                $from .= " and s.user_id IN (".$userId . ")";
            }else{
                $from .= " "; // All active or inactive VMs 
            }
        }
        else{
            $from .= " and s.user_id=".$this->session->userdata['userid']; // logged in user
        }

        // inactive or active status
        $from .= " and u.status=" .$status;

        // Forming  SQL select query and querying the db.
        $sql = "SELECT " . $select . "" . $from . $groupBy .  $orderBy;
        $query = $this->db->query($sql);

        // Returning the resultset as an array.
        return $query->result_array();
    }


    /*******************************************************
    ***** function get_users_for_activity *************
    ********************************************************/
    // Added by MN on 18th Aug and modified on 22nd Aug and 5th Sep (to take care of more than 1 user)
    /* 
    /*
     * This function gets distinct user_id from dcode_status_updates table where   
     * role_id = 5 i.e., role is verification member
     * and returns row(s) of records with the data.
     * Added  active or  inactive member check -  $status
     * Added and u.active_status != 3 on May 3rd
     */
    function  get_users_for_activity($fromDate, $toDate, $userId=0, $status)
    {
        
        $select = "DISTINCT(user_id) as user_id ";
        $from  = " FROM " . DB_PREFIX . "status_updates s JOIN " . DB_PREFIX ."user u ON   u.id = s.user_id  
        and u.active_status != 3 where  
        s.role_id=5 AND (DATE_FORMAT(date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."' and DATE_FORMAT(date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')";

        if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==9){
            if($userId!=0){
                // taking into account 1  or more VMs
                $from .= " and s.user_id IN (".$userId . ")";
            }else{
                $from .= " "; // All active or inactive VMs 
            }
        }
        else{
            $from .= " and s.user_id=".$this->session->userdata['userid']; // logged in user
        }

        // inactive or active status
        $from .= " and u.status=" .$status;
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);

        // Returning the resultset as an array.
        return $query->result_array();
    }


    /*******************************************************
    ***** function getMonthWiseActivities *************
    ********************************************************/
    // Added by MN on 02nd Sep 2022  and changed on 5th Sep (to take care of selection  of more than 1 VM)
    /* 
     * This function takes fromDate, toDate(search parameters entered) and userId of  the logged in user in case of 
     * VM OR the user IDs of all selected  VMs if a VS logs in. 
     * whose  activity needs  to  be  viewed, active or  inactive member check = $status and fetches 
     * month, year of date_of_update and count of check_status from status_updates table where role_id = 5 i.e.,
     * role is verification member
     * and returns row(s) of records with the data.
     * Added active or  inactive member check -  $status
     * Edited on 23rd Jan for target
     * Removed target on 17th Feb (user data needs to be there in user_target for this to work so)
     * Added LEFT JOIN ".DB_PREFIX ."client_request d ON d.request_id = s.request_id
     * LEFT JOIN ".DB_PREFIX ."user ur ON ur.id = d.user_id   
     * ur.active_status !=3 on May 3rd 2023
     */
    function  getMonthWiseActivities($fromDate,$toDate,$userId=0,  $status)
    {

         // MONTH and YEAR are used since  we need those portions of the date-time stamp in the db
        $select = "count(`a.check_status`) as status, YEAR(`date_of_update`) as year, MONTH(`date_of_update`) as month, MONTHNAME(`date_of_update`) as month_name,  `a.check_status` ";
        $from  =    " FROM " . DB_PREFIX . "status_updates a JOIN " . DB_PREFIX ."user u ON   u.id = a.user_id 
                    LEFT JOIN ".DB_PREFIX ."client_request d ON d.request_id = s.request_id
                    LEFT JOIN ".DB_PREFIX ."user ur ON ur.id = d.user_id ";
        // JOIN dcode_user_target t ON  t.user_id = u.id "; // commented on 17th Feb
        $from  .= " where ur.active_status != 3 and a.role_id = 5 AND (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')";

        // We want month, year and check_status of all data between the selected from and to date.
        $groupBy = " GROUP BY YEAR(`date_of_update`), MONTH(`date_of_update`)  DESC, `check_status`"; 

        if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==9){
            if($userId!=0){
                // taking into account 1  or more VMs
                $from .= " and a.user_id IN (".$userId . ")";
            }else{
                $from .= " "; // All active or inactive VMs 
            }
        }
        else{
            $from .= " and a.user_id=".$this->session->userdata['userid']; // logged in user
        }

        // inactive or active status
        $from .= " and u.status=" .$status;

        // Forming  SQL select query and querying the db.
        $sql = "SELECT " . $select . "" . $from . $groupBy;
        $query = $this->db->query($sql);
        
        // Added on 23rd Jan
        // Returning the resultset as an array.
        return $query->result_array();

    }

    /*******************************************************
    ***** function get_new_cases_for_activity *************
    ********************************************************/
    // Added by MN on 04th Oct 2022 
    /* 
     * This function takes fromDate, toDate(search parameters entered) and userId of  
     * VM whose newly assigned activity needs to be viewed, active or  inactive member check = $status and 
     * fetches row(s) of records with the data.
     * Changed by  MN on 15th Nov to show constant assigned cases.
     * Added LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = a.candidate_req_id
     * LEFT JOIN " . DB_PREFIX . "user t ON t.id = d.user_id
     * and t.active_status != 3 
     */    
    function get_new_cases_for_activity($fromDate, $toDate, $userId=0, $status=1)
    {
        
        $select = "DISTINCT(rep_id) as new_cases, team_mem_id, vr.deadline_from";

        $from  = " FROM " . DB_PREFIX . "ver_assign_rep a LEFT JOIN " . DB_PREFIX ."user u ON u.id=a.team_mem_id 
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = a.candidate_req_id
        LEFT JOIN " . DB_PREFIX . "user t ON t.id = d.user_id
        LEFT JOIN " . DB_PREFIX ."verification_request vr ON vr.request_id = a.candidate_req_id and vr.check_id=a.check_id and vr.level_id=a.level_id and vr.pack_id=a.pack_id LEFT JOIN  " . DB_PREFIX ."verification_status vs ON  vs.request_id=a.candidate_req_id WHERE 1 and t.active_status != 3 ";

        $from  .= " AND (DATE_FORMAT(vr.deadline_from ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."' and DATE_FORMAT(vr.deadline_from ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')";

        if($userId!=0)  
        {
            // taking into account 1  or more VMs
            $from .= " and a.team_mem_id IN (".$userId . ")";
        }else
        {
            $from .= " "; // All active or inactive VMs 
        }

        // Forming  SQL select query and querying the db.
        $sql = "SELECT " . $select . "" . $from . " AND  u.status=" .  $status;
        $query = $this->db->query($sql);

        // print_r($this->db->last_query()); exit();
        // Returning the resultset as an array.
        return $query->result_array();

    }

     /***************** function get_all_vmembers ****************************************
     * Added by MN to get all verification members for showing new/ assigned checks
     * Edited  on 25th Jan 
     ************************************************************************************/
    function get_all_vmembers($role_id, $userId=0, $status)
    {
    
        $select = " distinct(us.id) as user_id, concat_ws(' ',us.first_name,us.middle_name,us.last_name) as name";
        $from = "  from ".DB_PREFIX ."ver_assign_rep a
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id =a.candidate_req_id
        LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id
        LEFT JOIN ".DB_PREFIX ."users_roles ur ON ur.user_id = us.id
        JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3 ";
        
        if( $role_id==9 || $role_id==1) {
             $from .= " WHERE 1=1 and us.status=".$status;
        }   
         if($userId!=0)  
        {
            // taking into account 1  or more VMs
            $from .= "  and ur.role_id=5 and us.id IN (".$userId . ")";
        }else
        {
            $from .= " and ur.role_id=5 "; // All active or inactive VMs 
        }
    
        // inactive or active status
        $from .= " and us.status=" .$status ." ORDER BY us.first_name";

        // Forming  SQL select query and querying the db.
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);

        // Returning the resultset as an array.
        return $query->result_array();
        
    }

    /**************************** function get_vm_assigned_list ********************************    
    Added by MN - For getting information of newly assigned checks to  verification  members.
    Modified on 03rd Jan '23 to show proper pagination
    Added LEFT JOIN ".DB_PREFIX ."user ur ON ur.id = d.user_id 
    ********************************************************************************************/
    function get_vm_assigned_list($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')  
    {
        
        $select = " DISTINCT(rep_id), vs.candidate_req_id, vs.level_id, c.id as checkId, d.case_no,d.candidate_name as candidatename,o.org_name,p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,c.name as checkname,md.name as status,vs.vm_revert_status as rstatus, vr.deadline_from as date, rt.role_name,concat_ws(' ',u.first_name,u.middle_name ,u.last_name) as user_name, vs.count_of_chk as chk ";

        $from = "  from ".DB_PREFIX ."ver_assign_rep vs        
        LEFT JOIN ".DB_PREFIX ."client_request d ON d.request_id = vs.candidate_req_id
        LEFT JOIN ".DB_PREFIX ."user ur ON ur.id = d.user_id 
        LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
        LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
        LEFT JOIN ".DB_PREFIX ."office su ON su.id = d.sub_office
        LEFT JOIN ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
        LEFT JOIN ".DB_PREFIX ."master_masterdata c ON c.id = vs.check_id
        LEFT JOIN ".DB_PREFIX ."master_masterdata md ON md.id = vs.verify_status 
        LEFT JOIN ".DB_PREFIX ."user u ON u.id = vs.team_mem_id
        LEFT JOIN ".DB_PREFIX ."role_types r ON r.user_type = u.user_type
        LEFT JOIN ".DB_PREFIX ."users_roles a ON a.user_id = u.id
        LEFT JOIN ".DB_PREFIX ."role_types rt ON rt.id = a.role_id
        LEFT JOIN ".DB_PREFIX ."verification_request vr ON vr.request_id = vs.candidate_req_id and vr.check_id=vs.check_id and vr.level_id=vs.level_id and vr.pack_id=vs.pack_id WHERE 1=1 and ur.active_status != 3 ";  

        if ($searchCond) {
            $from .= " and $searchCond";
        }

        // Added by MN on 03rd Jan '23 for pagination
        if ($type == 'count') $select = "count(DISTINCT(rep_id)) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
            $from .= " group by vs.rep_id order by $sBy $sOrder limit $pg," . $limit;
        }

        // Forming  SQL select query and querying the db.
        $sql = "SELECT " . $select . "" . $from;       
        $query = $this->db->query($sql);

        // print_r($this->db->last_query()); exit();
        // Returning the result set as an array.
        if($query !== FALSE && $query->num_rows() > 0){
            return $query->result_array();
        }

    }


    // Added on 25th Jan
    // get Verification members according to their active inactive status in the form of a select box
    function get_vmembers(){
        
        $role_id=$_POST['role_id'];
        $status=$_POST['status'];

        $select = " distinct(us.id) as userID, concat_ws(' ',us.first_name,us.middle_name,us.last_name) as vname";
        $from = "  from ".DB_PREFIX ."ver_assign_rep a
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id =a.candidate_req_id
        LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id
        LEFT JOIN ".DB_PREFIX ."users_roles ur ON ur.user_id = us.id
        JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3 ";
        
        if( $role_id==9 || $role_id==1) {
             $from .= " WHERE 1=1 and ur.role_id=5 and us.status=".$status." ORDER BY us.first_name";
        }   
        
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        $U_member= $query->result_array();

            $html='<option value="">Select Verifier</option>';
            foreach($U_member as $members) {
                $html.="<option name='vmember' value=".$members['userID'].">".$members['vname']."
            </option>";
            }
            echo $html; 

    }

    /**************************** function export_vm_newList ****************************    
     * Added by MN On 19th Oct  - For getting information of newly assigned checks to  verification member for 
     * creating an excel document. 
     * Added LEFT JOIN " . DB_PREFIX . "user t ON t.id = d.user_id 
     * and t.active_status != 3 on May 3rd
     **************************************************************************************/
    function export_vm_newList($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '')
    {
        // If order by field is empty
        if($sBy == '')
        {
            $sBy = 'vs.rep_id';  
        } 
        $select = " DISTINCT(rep_id), vs.candidate_req_id, vs.level_id, c.id as checkId, d.case_no,d.candidate_name as candidatename,o.org_name,p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,c.name as checkname,md.name as status,vs.vm_revert_status as rstatus, vr.deadline_from as date, rt.role_name,concat_ws(' ',u.first_name,u.middle_name ,u.last_name) as user_name, vs.count_of_chk as chk ";

        $from = "  from ".DB_PREFIX ."ver_assign_rep vs        
        LEFT JOIN ".DB_PREFIX ."client_request d ON d.request_id = vs.candidate_req_id
        LEFT JOIN " . DB_PREFIX . "user t ON t.id = d.user_id 
        LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
        LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
        LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
        LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
        LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = vs.check_id
        LEFT JOIN ".DB_PREFIX ."master_masterdata md ON md.id = vs.verify_status 
        LEFT JOIN  ".DB_PREFIX ."user u ON u.id = vs.team_mem_id and u.active_status != 3 
        LEFT JOIN  ".DB_PREFIX ."role_types r ON r.user_type = u.user_type
        LEFT JOIN  ".DB_PREFIX ."users_roles a ON a.user_id = u.id
        LEFT JOIN  ".DB_PREFIX ."role_types rt ON rt.id = a.role_id
        LEFT JOIN ".DB_PREFIX ."verification_request vr ON vr.request_id = vs.candidate_req_id and vr.check_id=vs.check_id and vr.level_id=vs.level_id and vr.pack_id=vs.pack_id WHERE 1=1 and t.active_status != 3 ";  

        // Include  all the search conditions which are got as an argument
        if ($searchCond) {
            $from .= " and $searchCond";
        }

         // Include group by and order by but don't use limit since all the data has to come in a single sheet
         //  in Excel. Pagination format is not required.
        if ($pg >= 0 && $type <> 'count') { 
            $from .= " group by vs.rep_id order by $sBy $sOrder ";
        
        }

        $sql = "SELECT " . $select . "" . $from;
       
        $query = $this->db->query($sql);

        // print_r($this->db->last_query()); exit();
        if($query !== FALSE && $query->num_rows() > 0){
            return $query->result_array();

        }
    }


     /**************************** function export_vmactivitylists *************    
      *  Made changes On 03rd  Oct  - for  getting  verified status (Verified-written-clear etc.,)
      *  and status of check (to show red, green and orange) 
      * Added LEFT JOIN " . DB_PREFIX . "user t ON t.id = d.user_id 
      *  and t.active_status != 3 on May 3rd
      ************************************************************************/
    function export_vmactivitylists($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')
    {
        $select = " vs.candidate_req_id, vs.level_id, c.id as checkId, a.case_no,d.candidate_name as candidatename,o.org_name,p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,c.name as checkname,a.check_status as status,vs.vm_revert_status as rstatus, a.date_of_update as date, r.role_name,concat_ws(' ',u.first_name,u.middle_name ,u.last_name) as user_name, vs.count_of_chk as chk ";
            $from = "  from ".DB_PREFIX ."status_updates a
            LEFT JOIN ".DB_PREFIX ."client_request d ON d.request_id = a.request_id
            LEFT JOIN " . DB_PREFIX . "user t ON t.id = d.user_id 
            LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
            LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
            LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
            LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
            LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
            LEFT JOIN  ".DB_PREFIX ."role_types r ON r.id = a.role_id
            LEFT JOIN  ".DB_PREFIX ."user u ON u.id = a.user_id
            LEFT JOIN  ".DB_PREFIX ."ver_assign_rep vs ON vs.candidate_req_id=a.request_id and vs.check_id = a.check_id and vs.level_id=a.level_id WHERE 1=1 and t.active_status != 3 ";       

        if ($searchCond) {
        $from .= " and $searchCond";
        }

        if ($type == 'count') $select = "count(DISTINCT(a.id)) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " group by a.id order by  a.id $sOrder ";
        }

         $sql = "SELECT " . $select . "" . $from; 
       
        $query = $this->db->query($sql);

        return $query->result_array();
    }



    // 26th  Jan
    // Getting targets set for each verification member in the list from dcode_user_target table
    function get_target_member_wise($fromDate,$toDate,$userId=0,$status)
    {

        $select = "a.user_id, check_status, date_of_update as updateDate, t.target "; 

        $from = "  from ".DB_PREFIX ."status_updates a 
        LEFT JOIN ".DB_PREFIX ."user u ON u.id = a.user_id 
        LEFT JOIN ".DB_PREFIX ."user_target t ON t.user_id = u.id  ";

        $from = $from . "where  check_status IN ('107', '110', '111', '519', '992', '684', '1001', '1002', '1004', '1005', '1006', '1110', '1519') and a.role_id=5 AND (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')";

        $orderBy =  " ORDER BY date_of_update DESC"; // Ordering by user_id.

        if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==9){
            if($userId!=0){
                // taking into account 1  or more VMs
                $from .= " and a.user_id IN (".$userId . ")";
            }else{
                $from .= " "; // All active or inactive VMs 
            }
        }
        else{
            $from .= " and a.user_id=".$this->session->userdata['userid']; // logged in user
        }

        // inactive or active status
        $from .= " and u.status=" .$status;
        $sql = "SELECT " . $select . "" . $from . $orderBy;
        $query = $this->db->query($sql);

        // Returning the resultset as an array.
        return $query->result_array();

    }

    // get all holidays from  master table
    function get_masterholidays() { 
        $select = " a.id,a.description, a.holiday_date, a.status ";
        $from = "   FROM " . DB_PREFIX . "master_holidays a
                            where a.status=1  ";
        
        $sql = "SELECT " . $select . " " . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    // Used to get monthly target for an individual verification member
    // function  getMonthlyTargets($fromDate,$toDate,$userId=0,  $status)
    // {
    //      // MONTH and YEAR are used since  we need those portions of the date-time stamp in the db
    //     $select = "a.user_id, YEAR(`date_of_update`) as year, MONTH(`date_of_update`) as month, MONTHNAME(`date_of_update`) as month_name,  `check_status` ,  t.target";
    //     $from  = " FROM " . DB_PREFIX . "status_updates a JOIN " . DB_PREFIX ."user u ON   u.id = a.user_id
    //     JOIN dcode_user_target t ON  t.user_id = u.id ";
    //     $from  .= " where a.role_id = 5 AND (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')";

        
    //     if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==9){
    //         if($userId!=0){
    //             // taking into account 1  or more VMs
    //             $from .= " and a.user_id IN (".$userId . ")";
    //         }else{
    //             $from .= " "; // All active or inactive VMs 
    //         }
    //     }
    //     else{
    //         $from .= " and a.user_id=".$this->session->userdata['userid']; // logged in user
    //     }

    //     // inactive or active status
    //     $from .= " and u.status=" .$status;

    //     // Forming  SQL select query and querying the db.
    //     $sql = "SELECT " . $select . "" . $from; // . $groupBy;
    //     $query = $this->db->query($sql);
        
    //     // Added on 23rd Jan
    //     // Returning the resultset as an array.
    //     return $query->result_array();

    // }


    function get_datewise_qc2activity($fromDate,$toDate,$userId=0,  $status){
        
        $select = "DATE(date_of_update)  as updateDate,  COUNT(a.check_status) as status, a.published_date, a.check_status, a.request_id";
        $from  = " FROM " . DB_PREFIX . "status_updates a 
        JOIN " . DB_PREFIX ."user u ON   u.id = a.user_id
        LEFT JOIN ".DB_PREFIX ."client_request d ON d.request_id = a.request_id
        LEFT JOIN ".DB_PREFIX ."user ur ON ur.id = d.user_id
        LEFT JOIN ".DB_PREFIX ."verified_level vl1 ON vl1.request_id = a.request_id and vl1.check_id=a.check_id and vl1.level_id=a.level_id ";
        $from  .= " where ur.active_status !=3 and a.role_id = 17 AND a.check_status IN(111, 1007,1003) AND (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')";


        $groupBy = " GROUP BY DATE(a.date_of_update), check_status";
        $orderBy =  " ORDER BY DATE(`date_of_update`) DESC"; 

    
        if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==9){
            if($userId!=0){
                $from .= " and a.user_id IN (".$userId . ")";
            }else{
                $from .= " "; 
            }
        }
        else{
            $from .= " and a.user_id=".$this->session->userdata['userid']; // logged in user
        }

        $from .= " and u.status=" .$status;

        $sql = "SELECT " . $select . "" . $from . $groupBy .  $orderBy;
        $query = $this->db->query($sql);
        return $query->result_array();

    }

    function get_qc2target_memberwise($fromDate,$toDate,$userId=0,$status)
    {

        $select = "a.user_id, a.check_status, a.date_of_update as updateDate, ut.target, vl1.qc_date,vl1.v_date,vl1.qc2_date as rep_publish_date"; 

        $from = "  from ".DB_PREFIX ."status_updates a
        LEFT JOIN ".DB_PREFIX ."client_request d ON d.request_id = a.request_id 
        LEFT JOIN ".DB_PREFIX ."user u ON u.id = a.user_id 
        LEFT JOIN ".DB_PREFIX ."user_target_dynamic ut ON ut.user_id = u.id
        LEFT JOIN ".DB_PREFIX ."verified_level vl1 ON vl1.request_id = a.request_id and vl1.check_id=a.check_id and vl1.level_id=a.level_id ";

        $from = $from . "where  a.check_status IN ('111', '1003', '1007') and a.role_id=17 AND (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') and ut.status=1";

        $orderBy =  " ORDER BY date_of_update DESC"; // Ordering by user_id.

        if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==9){
            if($userId!=0){
                // taking into account 1  or more VMs
                $from .= " and a.user_id IN (".$userId . ")";
            }else{
                $from .= " "; // All active or inactive VMs 
            }
        }
        else{
            $from .= " and a.user_id=".$this->session->userdata['userid'];
        }

        $from .= " and u.status=" .$status;
        $sql = "SELECT " . $select . "" . $from . $orderBy;
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    function get_qc2tat_memberwise($fromDate, $toDate, $userId=0, $status=1)
    {

        $select = "a.user_id, a.check_status, a.date_of_update as updateDate, ut.target, vl1.request_id, vl1.qc_date,vl1.v_date,vl1.qc2_date as rep_publish_date,vl1.qc2status"; 

        $from = "  from ".DB_PREFIX ."status_updates a
        LEFT JOIN ".DB_PREFIX ."client_request d ON d.request_id = a.request_id 
        LEFT JOIN ".DB_PREFIX ."user u ON u.id = a.user_id 
        LEFT JOIN ".DB_PREFIX ."user_target_dynamic ut ON ut.user_id = u.id
        LEFT JOIN ".DB_PREFIX ."verified_level vl1 ON vl1.request_id = a.request_id and vl1.check_id=a.check_id and vl1.level_id=a.level_id ";

        $from = $from . "where a.check_status IN (1007) and a.role_id=17 AND (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') and ut.status=1";

        $orderBy =  " ORDER BY date_of_update DESC"; // Ordering by user_id.

        if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==9){
            if($userId!=0){
                // taking into account 1  or more VMs
                $from .= " and a.user_id IN (".$userId . ")";
            }else{
                $from .= " "; // All active or inactive VMs 
            }
        }
        else{
            $from .= " and a.user_id=".$this->session->userdata['userid'];
        }

        $from .= " and u.status=" .$status;
        $sql = "SELECT " . $select . "" . $from . $orderBy;
        $query = $this->db->query($sql);
        return $query->result_array();
    }

     function get_qc2assignlist($a_date, $t_date)   
     {
        
        $select = "count(DISTINCT(ar.rep_id)) as rep_id,a.request_id,vl1.v_date, vl1.qc_date,ar.qc2_verification, ar.qc1_verification, ar.qc2_revert_request, vl1.qc2status";

        // March 17th -- added  line no 959
         $from = "   FROM " . DB_PREFIX . "verification_request a 
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
         LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation
         
         LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
         LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id 
         LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
         LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
         LEFT JOIN " . DB_PREFIX . "user vm ON vm.id=vl1.verified_by
         LEFT JOIN " . DB_PREFIX . "users_roles ur ON ur.user_id=ar.qc2_revert_by 
          JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
         where 1  and a.assignee_status=1 and ar.verify_status in (111,110,519) AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id and (ar.qc2_verification = 0 and ar.qc1_verification=1 and ar.qc2_revert_request = 0 and vl1.qc2status!=107) and ((DATE_FORMAT(vl1.qc_date,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($a_date))."') OR (DATE_FORMAT(vl1.v_date,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($a_date))."')) and ((DATE_FORMAT(vl1.qc_date,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."') OR (DATE_FORMAT(vl1.v_date,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($t_date))."'))";
                   
                        
        /* qc2 verification*/
        if($this->session->userdata('role_id')==17 ){
            $from .="  and ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish != 3 else ar.qc2_report_publish != 1 END ) and qc.assignee_id =".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and qc.assignee_id != 0 and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }
        else{
            $from .= " and qc.assignee_id != 0 ";
        }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();

    //         $str = $this->db->last_query();
    // echo "<pre>";
    // print_r($str);
    // exit;
    }

    public function getNumberOfDays($startDate, $endDate, $hoursPerDay="8", $excludeToday=true)
    {
        
        // d/m/Y
        $start = new DateTime($startDate);
        $end = new DateTime($endDate);
        $oneday = new DateInterval("P1D");

        $days = array();

        /* Iterate from $start up to $end+1 day, one day in each iteration.
        We add one day to the $end date, because the DatePeriod only iterates up to,
        not including, the end date. */
        foreach(new DatePeriod($start, $oneday, $end->add($oneday)) as $day) {
            $day_num = $day->format("N"); /* 'N' number days 1 (mon) to 7 (sun) */
            if($day_num < 6) { /* weekday */
                $days[$day->format("Y-m-d")] = $hoursPerDay;
            } 
        }    

        if ($excludeToday)
            array_pop ($days);

        return $days;       
    }


    function get_qc2activity($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')
    {
        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,ar.qc_2_verification,ar.qc2_report_publish,ar.reopen_revert_qc2,vl1.qc2status,vl1.v_date,vl1.qc_date,vl1.qc2_date,concat_ws(' ',us.first_name,us.last_name) as qc2name,concat_ws(' ',vm.first_name,vm.last_name) as vmname,ar.qc2_revert_date, ur.role_id as revertedBy "; 

         $from = "   FROM " . DB_PREFIX . "verification_request a 
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
         LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation
         
         LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
         LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id 
         LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
         LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
         LEFT JOIN " . DB_PREFIX . "user vm ON vm.id=vl1.verified_by
         LEFT JOIN " . DB_PREFIX . "users_roles ur ON ur.user_id=ar.qc2_revert_by 
          JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
         where 1  and a.assignee_status=1 AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id ";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        
        /* qc2 verification*/
        if($this->session->userdata('role_id')==17 ){
            $from .="  and (( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish != 3 else ar.qc2_report_publish != 1 END ) || ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish = 1 else ar.qc2_verification = 1 END )) and qc.assignee_id =".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and qc.assignee_id != 0 and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }
        else{
            $from .= " and qc.assignee_id != 0 ";
        }
        
                
            if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count ";
                
            if ($pg >= 0 && $type <> 'count') { 
                $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
            }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();

        // $str = $this->db->last_query();
        // echo "<pre>";
        // print_r($str);
        // exit;
    }





}

?>