<?php
class Billing_model extends CI_Model {
    //Constuctor
    function __construct() 
    {
        parent::__construct();
        $this->load->database();
    }
    function get_userlistoff ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 

  
                $select = "c.org_name,a.request_id,a.candidate_name,c.org_name,b.office_name,d.office_name as parent_office,o.office_name as sub_office,a.assainee_status, f.first_name, a.created_on, a.dataentry_by,e.order_name,e.order_code,e.billing_type,e.id";
                        
                    $from = "   FROM " . DB_PREFIX . "client_request a 
                    LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
                    LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by
                                where 1  and a.status_of_candidate=2 ";

                if ($searchCond)
                $from .= " and $searchCond";
                if ($type == 'count') $select = "count(*) as count "; 

                if ($pg >= 0 && $type <> 'count') 
                $from .= " order by $sBy $sOrder limit $pg," . $limit;

                $sql = "SELECT " . $select . "" . $from;
                $query = $this->db->query($sql);
                return $query->result_array();
    }
    function get_billinglistoff($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type=''){
        $select = "c.org_name,a.request_id,a.candidate_name,c.org_name,b.office_name,d.office_name as parent_office,o.office_name as sub_office,a.assainee_status, f.first_name, a.created_on, a.dataentry_by,e.order_name,e.order_code,e.billing_type,a.order_id";
                        
                    $from = "   FROM " . DB_PREFIX . "client_request a 
                    LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
                    LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by

                                where 1  and a.status_of_candidate=2 and e.billing_type =515 GROUP BY a.order_id";
                                
                if ($searchCond)
                $from .= " and $searchCond";
                if ($type == 'count') $select = "count(*) as count "; 

                if ($pg >= 0 && $type <> 'count') 
                $from .= " order by $sBy $sOrder limit $pg," . $limit;

                $sql = "SELECT " . $select . "" . $from;
                $query = $this->db->query($sql);
                return $query->result_array();
    
    }
    function get_reportbillinglistoff($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type=''){
        $select = "c.org_name,a.request_id,a.candidate_name,c.org_name,b.office_name,d.office_name as parent_office,o.office_name as sub_office,a.assainee_status, f.first_name, a.created_on, a.dataentry_by,e.order_name,e.order_code,e.billing_type,a.order_id";
                        
                    $from = "   FROM " . DB_PREFIX . "client_request a 
                    LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
                    LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by

                                where 1  and a.status_of_candidate=2 and e.billing_type=516 GROUP BY a.order_id";
                                
                if ($searchCond)
                $from .= " and $searchCond";
                if ($type == 'count') $select = "count(*) as count "; 

                if ($pg >= 0 && $type <> 'count') 
                $from .= " order by $sBy $sOrder limit $pg," . $limit;

                $sql = "SELECT " . $select . "" . $from;
                $query = $this->db->query($sql);
                return $query->result_array();
    
    }
    function orderdml($order_id = 0, $billing_id = 0) {
                $formData = $_POST;

                $order_code = $this->getorderid();

                if ($formData) {
                    $formData['order_code']= ORDER_PREFIX.$order_code; 
 
                        if ($order_id == 0) {
                        $formData['billing_id'] = @$billing_id;
                        $new_meeting = 1;   
                        $insertData = elements(array('organisation','parent_office','billing_id','order_code','order_name',
                        'billing_term','billing_type','office','sub_office'), $formData);
                        
                       
                         $order_id= $this->db->insert_id();
                         
                        } else {
                        $insertData = elements(array('contact_person', 'order_name', 'billing_term','credit_limit','billing_type','acceptable_limit', 'email_value','post_value', 'mode_email','mode_post','others','office','sub_office'), $formData);
                        }
                       $order_id=$this->amodel->dmlfunction(DB_PREFIX . "billing", array('id' => $order_id), $insertData, $order_id); 
                        redirect('' . base_url('Billing/create/'. base64_encode($order_id)));
                        }
               }

        function getorderid(){
             $this->db->select('id,key_value')->from('m_erp_config as a')->where('a.key_name','ORDER_ID'); 
             $ord = $this->db->get()->result_array(); 
             $order = $ord[0]['key_value'];
             $order = $order+1; 
             $this->db->update("m_erp_config", array('key_value' => $order), array('id' => $ord[0]['id']));
             return $order;
         }

        function addcheckdml($check_id = 0, $order_id) {
	$formData = $_POST;
           if ($formData) {
              foreach($formData['types_of_check'] as  $chk)
	    {
	     	   
		 $insert_array[] =array("order_id"=>$_POST['order_id'],"types_of_check"=>$chk,"max_attempt"=>$_POST['max_attempt'.$chk],"acceptable_limit"=>$_POST['acceptable_limit'.$chk],"Rs"=>$_POST['Rs'.$chk],"remarks"=>$_POST['remarks'.$chk],"created_on"=> date('Y-m-d H:i:s'),"updated_on"=> date('Y-m-d H:i:s')); 
	    }
        $this->db->insert_batch(DB_PREFIX."add_check", $insert_array); 
	         $order_details = $this->amodel->getDetails(DB_PREFIX . "billing", array('billing_id'), array('id' => $_POST['order_id']));
	    $this->db->select('a.check_id,b.name')
            ->from(DB_PREFIX . 'add_check as a')
	    ->join(DB_PREFIX . 'master_masterdata as b','a.types_of_check = b.id','left')
	    ->where('a.order_id',$_POST['order_id']);
	    $checks =$data['checks']= $this->db->get()->result_array();  
	    $num = sizeof($checks);
	    $ordername="";
	    foreach($checks as $chk)
	    {
		$ordername.=substr($chk['name'],0,4);
	    }
	    $ordername.="-";
	    $ordername.=$num;
	    $this->db->update(DB_PREFIX . "billing", array('order_code' => $ordername), array('id' => $_POST['order_id']));
            redirect(base_url('Billing/create') );
           }
	
	}
    function get_vmexpenseslistoff ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
        $select = "c.org_name,a.request_id,a.candidate_name,c.org_name,b.office_name,d.office_name as parent_office,o.office_name as sub_office,a.assainee_status, f.first_name, a.created_on, a.dataentry_by,e.order_name,e.order_code,e.billing_type,a.order_id";
                        
                    $from = "   FROM " . DB_PREFIX . "client_request a 
                    LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
                    LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by
                    LEFT JOIN " . DB_PREFIX . "billing g ON g.request_id = a.request_id
                                where 1  and a.status_of_candidate=2 and g.vm_expences=517 or g.vm_expences=518 or g.vm_expences=519 GROUP BY a.order_id";

               
        if ($searchCond) {
            $from .= " and $searchCond";
        }

                if ($type == 'count') $select = "count(*) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }  
    function get_packagelistoff ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
        $select = "c.org_name,a.request_id,a.candidate_name,c.org_name,b.office_name,d.office_name as parent_office,o.office_name as sub_office,a.assainee_status, f.first_name, a.created_on, a.dataentry_by,e.order_name,e.order_code,e.billing_type,a.order_id";
                        
                    $from = "   FROM " . DB_PREFIX . "client_request a 
                    LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = b.parentoffice_id
                    LEFT JOIN " . DB_PREFIX . "office d ON d.id = b.parent_office 
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by
                    LEFT JOIN " . DB_PREFIX . "billing g ON g.request_id = a.request_id
                    where 1  and g.pack_id IS NOT NULL and a.status_of_candidate=2 GROUP BY a.order_id";

               
        if ($searchCond) {
            $from .= " and $searchCond";
        }

                if ($type == 'count') $select = "count(*) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }  

    function get_finalreport_data($fromDate, $toDate){
        
        $select = "a.request_id,a.organisation, a.order_id, a.case_no, a.case_accepted_date, a.final_report_published_date,p.current_stay_flag";
        $from = "   FROM " . DB_PREFIX . "client_request a
        LEFT JOIN " . DB_PREFIX . "personal_details p ON p.user_id = a.request_id
        where (DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."') AND (DATE_FORMAT(a.final_report_published_date ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."') AND final_report=1";

        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    function get_endtoenddetails($orgId, $AcceptedDate){
        
        $select = "ee_domestic_charge,ee_overseas_charge";
        $from = "   FROM " . DB_PREFIX . "endtoend_charges
        where (('".date('Y-m-d',strtotime($AcceptedDate))."' >= DATE_FORMAT(ee_from_date ,'%Y-%m-%d') AND ee_to_date IS NULL) OR ('".date('Y-m-d',strtotime($AcceptedDate))."' >= DATE_FORMAT(ee_from_date ,'%Y-%m-%d') AND '".date('Y-m-d',strtotime($AcceptedDate))."' <= DATE_FORMAT(ee_to_date ,'%Y-%m-%d'))) AND org_id=".$orgId;

        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();

    //     $str = $this->db->last_query();
    // echo "<pre>";
    // print_r($str);
    // exit;

    }


    /****************************************
     Payment Request List
     function get_paymentrequest_list
    ****************************************/

    function get_paymentrequest_list ($pg = 0, $limit = 10, $sBy = 'pr.pr_id', $sOrder = 'desc', $searchCond = '',$type=''){ 

            $select = "pr.pr_id,pr.request_id,pr.check_id,pr.level_id,pr.case_no,cr.candidate_name,c.org_name,m.name as check_name,pr.beneficiary_name,pr.beneficiary_location,pr.payment_mode,pm.pm_name,pr.requested_amount as amount, pm1.pm_name as paymode, pm2.pm_name as paystatus,pr.payment_status,pr.requested_date,pr.ref_branch_code as branchcode, pr.approved_date, pr.paid_date,pr.bank_name,pm3.pm_name as reason,pm4.pm_name as payto,pr.comments,pr.attachment,pr.initiated_on,pr.completed_on, concat_ws(' ',f.first_name,f.last_name) as requested_by, concat_ws(' ',u.first_name,u.last_name) as approved_by,prd.dd_no as dd_txn_no,prd.dd_no,prd.dd_date,prd.dd_charges,prd.chk_number,prd.chk_date,prd.dd_file,prn.neft_id,prn.neft_bank_name,prn.neft_account_type,prn.neft_reference_no,prn.neft_payment_date,prn.neft_trans_charge,prn.neft_file, vr.count_of_chk,prc.cr_card_file,chln.chln_file,pro.op_online_file";
                        
                    $from = "   FROM " . DB_PREFIX . "payment_request pr 
                    LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = pr.request_id
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = pr.org_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=pr.check_id
                    LEFT JOIN " . DB_PREFIX . "payment_master pm ON pm.pm_id=pr.currency
                    LEFT JOIN " . DB_PREFIX . "payment_master pm1 ON pm1.pm_id=pr.payment_mode
                    LEFT JOIN " . DB_PREFIX . "payment_master pm2 ON pm2.pm_id=pr.payment_status
                    LEFT JOIN " . DB_PREFIX . "payment_master pm3 ON pm3.pm_id=pr.reason_payment
                    LEFT JOIN " . DB_PREFIX . "payment_master pm4 ON pm4.pm_id=pr.payment_to
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = pr.requested_by
                    LEFT JOIN " . DB_PREFIX . "user u ON u.id = pr.approved_by
                    LEFT JOIN " . DB_PREFIX . "payment_request_dd prd ON prd.pr_id =pr.pr_id
                    LEFT JOIN " . DB_PREFIX . "payment_request_neft prn ON prn.pr_id =pr.pr_id
                    LEFT JOIN " . DB_PREFIX . "payment_request_card prc ON prc.pr_id =pr.pr_id
                    LEFT JOIN " . DB_PREFIX . "payment_request_challan chln ON chln.pr_id =pr.pr_id
                    LEFT JOIN " . DB_PREFIX . "payment_request_online pro ON pro.pr_id =pr.pr_id
                    LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=pr.request_id and vr.check_id=pr.check_id and vr.level_id=pr.level_id
                    where 1 ";

                    $roleid= $this->session->userdata('role_id');
                    if($roleid==5 || $roleid==27){
                        $from .= " and vr.team_mem_id = ".$this->session->userdata['userid'];
                    }
                    else if($roleid==9){
                        $from .= " and pr.payment_status = 31";
                    }
                    else 
                    {
                        $from .= " ";
                    }
               
            if ($searchCond) {
                $from .= " and $searchCond";
            }else{
                if($roleid==26){
                    $from .= " and pr.payment_status IN (32,34,35)";
                }
            }

            if ($type == 'count') $select = "count(*) as count "; 
                
            if ($pg >= 0 && $type <> 'count') { 
                $from .= " order by $sBy $sOrder limit $pg," . $limit;
            }

            
            $sql = "SELECT " . $select . "" . $from;
            $query = $this->db->query($sql);
            return $query->result_array();

            // $str = $this->db->last_query();
            // echo "<pre>";
            // print_r($str);
            // exit;

    }

    /************ Payment Request Details**************
     ***** function get_fccheck_details********
     *************************************************/
    function get_fccheck_details($id){

        $select="*";
            $from = "   FROM " . DB_PREFIX . "payment_request_dd
            where prd_id=".$id;
            $sql = "SELECT " . $select . "" . $from;
            $query = $this->db->query($sql);
            return $query->row_array();

    }

    function get_neft_details($id){

        $select="*";
            $from = "   FROM " . DB_PREFIX . "payment_request_neft
            where neft_id=".$id;
            $sql = "SELECT " . $select . "" . $from;
            $query = $this->db->query($sql);
            return $query->row_array();

    }

    function get_challan_details($id){
        $select="*";
        $from = "   FROM " . DB_PREFIX . "payment_request_challan
        where chln_id=".$id;
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->row_array();
    }

    function get_card_details($id){
        $select="*";
        $from = "   FROM " . DB_PREFIX . "payment_request_card
        where cr_id=".$id;
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->row_array();
    }

    function get_online_details($id){
        $select="*";
        $from = "   FROM " . DB_PREFIX . "payment_request_online
        where op_id=".$id;
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->row_array();
    }


    function get_kotak_payment_list ($pg = 0, $limit = 10, $sBy = 'pr.pr_id', $sOrder = 'desc', $searchCond = '',$type=''){ 

            $select = "pr.pr_id,pr.request_id,pr.check_id,pr.level_id,pr.case_no,cr.candidate_name,c.org_name,m.name as check_name,pr.beneficiary_name,pr.beneficiary_location,pr.payment_mode,pm.pm_name,pr.requested_amount as amount, pm1.pm_name as paymode, pm2.pm_name as paystatus,pr.payment_status,pr.requested_date,pr.ref_branch_code as branchcode, pr.approved_date, pr.paid_date,pr.bank_name,pm3.pm_name as reason,pm4.pm_name as payto,pr.comments,pr.attachment,pr.initiated_on,pr.completed_on, concat_ws(' ',f.first_name,f.last_name) as requested_by, concat_ws(' ',u.first_name,u.last_name) as approved_by,prd.prd_id,prd.dd_no as dd_txn_no,prd.dd_no,prd.dd_date,prd.dd_charges,prd.chk_number,prd.chk_date, vr.count_of_chk,prd.dd_file";
                        
                    $from = "   FROM " . DB_PREFIX . "payment_request pr 
                    LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = pr.request_id
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = pr.org_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=pr.check_id
                    LEFT JOIN " . DB_PREFIX . "payment_master pm ON pm.pm_id=pr.currency
                    LEFT JOIN " . DB_PREFIX . "payment_master pm1 ON pm1.pm_id=pr.payment_mode
                    LEFT JOIN " . DB_PREFIX . "payment_master pm2 ON pm2.pm_id=pr.payment_status
                    LEFT JOIN " . DB_PREFIX . "payment_master pm3 ON pm3.pm_id=pr.reason_payment
                    LEFT JOIN " . DB_PREFIX . "payment_master pm4 ON pm4.pm_id=pr.payment_to
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = pr.requested_by
                    LEFT JOIN " . DB_PREFIX . "user u ON u.id = pr.approved_by
                    LEFT JOIN " . DB_PREFIX . "payment_request_dd prd ON prd.pr_id =pr.pr_id
                    LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=pr.request_id and vr.check_id=pr.check_id and vr.level_id=pr.level_id
                    where 1 ";

                    $roleid= $this->session->userdata('role_id');
                    if($roleid==5 || $roleid==27){
                        $from .= " and pr.bank_name like '%Kotak%' and vr.team_mem_id = ".$this->session->userdata['userid'];
                    }
                    else if($roleid==9){
                        $from .= "and pr.bank_name like '%Kotak%' ";
                    }
                    else 
                    {
                        $from .= " ";
                    }
               
            if ($searchCond) {
                $from .= " and $searchCond and pr.bank_name like '%Kotak%'";
            }
            else{
                if($roleid==26){
                    $from .= "and pr.bank_name like '%Kotak%' and pr.payment_status IN (32,34,38)";
                }
            }
            
            if ($type == 'count') $select = "count(*) as count "; 
                
            if ($pg >= 0 && $type <> 'count') { 
                $from .= " order by $sBy $sOrder limit $pg," . $limit;
            }

            // $from .= " order by pr.pr_id desc ";
            $sql = "SELECT " . $select . "" . $from;
            $query = $this->db->query($sql);
            return $query->result_array();
    }

    function get_sbi_payment_list ($pg = 0, $limit = 10, $sBy = 'pr.pr_id', $sOrder = 'desc', $searchCond = '',$type=''){ 

            $select = "pr.pr_id,pr.request_id,pr.check_id,pr.level_id,pr.case_no,cr.candidate_name,c.org_name,m.name as check_name,pr.beneficiary_name,pr.beneficiary_location,pr.payment_mode,pm.pm_name,pr.requested_amount as amount, pm1.pm_name as paymode, pm2.pm_name as paystatus,pr.payment_status,pr.requested_date,pr.ref_branch_code as branchcode, pr.approved_date, pr.paid_date,pr.bank_name,pm3.pm_name as reason,pm4.pm_name as payto,pr.comments,pr.attachment,pr.initiated_on,pr.completed_on, concat_ws(' ',f.first_name,f.last_name) as requested_by, concat_ws(' ',u.first_name,u.last_name) as approved_by,prd.prd_id,prd.dd_no as dd_txn_no,prd.dd_no,prd.dd_date,prd.dd_charges,prd.chk_number,prd.chk_date, vr.count_of_chk,prd.dd_file";
                        
                    $from = "   FROM " . DB_PREFIX . "payment_request pr 
                    LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = pr.request_id
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = pr.org_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=pr.check_id
                    LEFT JOIN " . DB_PREFIX . "payment_master pm ON pm.pm_id=pr.currency
                    LEFT JOIN " . DB_PREFIX . "payment_master pm1 ON pm1.pm_id=pr.payment_mode
                    LEFT JOIN " . DB_PREFIX . "payment_master pm2 ON pm2.pm_id=pr.payment_status
                    LEFT JOIN " . DB_PREFIX . "payment_master pm3 ON pm3.pm_id=pr.reason_payment
                    LEFT JOIN " . DB_PREFIX . "payment_master pm4 ON pm4.pm_id=pr.payment_to
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = pr.requested_by
                    LEFT JOIN " . DB_PREFIX . "user u ON u.id = pr.approved_by
                    LEFT JOIN " . DB_PREFIX . "payment_request_dd prd ON prd.pr_id =pr.pr_id
                    LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=pr.request_id and vr.check_id=pr.check_id and vr.level_id=pr.level_id
                    where 1 ";

                    $roleid= $this->session->userdata('role_id');
                    if($roleid==5 || $roleid==27){
                        $from .= "and pr.bank_name like '%SBI%' and vr.team_mem_id = ".$this->session->userdata['userid'];
                    }
                    else if($roleid==9){
                        $from .= "and pr.bank_name like '%SBI%' ";
                    }
                    else 
                    {
                        $from .= " ";
                    }
               
            if ($searchCond) {
                $from .= " and $searchCond and pr.bank_name like '%SBI%'";
            }
            else{
                if($roleid==26){
                    $from .= "and pr.bank_name like '%SBI%' and pr.payment_status IN (32,34)";
                }
            }
            
            if ($type == 'count') $select = "count(*) as count "; 
                
            if ($pg >= 0 && $type <> 'count') { 
                $from .= " order by $sBy $sOrder limit $pg," . $limit;
            }

            // $from .= " order by pr.pr_id desc ";
            $sql = "SELECT " . $select . "" . $from;
            $query = $this->db->query($sql);
            return $query->result_array();
    }


    function get_neft_payment_list ($pg = 0, $limit = 10, $sBy = 'pr.pr_id', $sOrder = 'desc', $searchCond = '',$type=''){ 

            $select = "pr.pr_id,pr.request_id,pr.check_id,pr.level_id,pr.case_no,cr.candidate_name,c.org_name,m.name as check_name,pr.beneficiary_name,pr.beneficiary_location,pr.payment_mode,pm.pm_name,pr.requested_amount as amount, pm1.pm_name as paymode, pm2.pm_name as paystatus,pr.payment_status,pr.requested_date,pr.ref_branch_code as branchcode, pr.approved_date, pr.paid_date,pr.bank_name,pm3.pm_name as reason,pm4.pm_name as payto,pr.comments,pr.attachment,pr.initiated_on,pr.completed_on, concat_ws(' ',f.first_name,f.last_name) as requested_by, concat_ws(' ',u.first_name,u.last_name) as approved_by,prn.neft_id,prn.neft_bank_name,prn.neft_account_type,prn.neft_reference_no,prn.neft_payment_date,prn.neft_trans_charge, vr.count_of_chk,prn.neft_file";
                        
                    $from = "   FROM " . DB_PREFIX . "payment_request pr 
                    LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = pr.request_id
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = pr.org_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=pr.check_id
                    LEFT JOIN " . DB_PREFIX . "payment_master pm ON pm.pm_id=pr.currency
                    LEFT JOIN " . DB_PREFIX . "payment_master pm1 ON pm1.pm_id=pr.payment_mode
                    LEFT JOIN " . DB_PREFIX . "payment_master pm2 ON pm2.pm_id=pr.payment_status
                    LEFT JOIN " . DB_PREFIX . "payment_master pm3 ON pm3.pm_id=pr.reason_payment
                    LEFT JOIN " . DB_PREFIX . "payment_master pm4 ON pm4.pm_id=pr.payment_to
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = pr.requested_by
                    LEFT JOIN " . DB_PREFIX . "user u ON u.id = pr.approved_by
                    LEFT JOIN " . DB_PREFIX . "payment_request_neft prn ON prn.pr_id =pr.pr_id
                    LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=pr.request_id and vr.check_id=pr.check_id and vr.level_id=pr.level_id
                    where 1 ";

                    $roleid= $this->session->userdata('role_id');
                    if($roleid==5 || $roleid==27){
                        $from .= "and pr.payment_mode=25 and vr.team_mem_id = ".$this->session->userdata['userid'];
                    }
                    else if($roleid==9){
                        $from .= "and pr.payment_mode=25 ";
                    }
                    else 
                    {
                        $from .= " ";
                    }
               
            if ($searchCond) {
                $from .= " and $searchCond and pr.payment_mode=25";
            }else{
                if($roleid==26){
                    $from .= " and pr.payment_mode=25 and pr.payment_status IN (32)";
                }
            }

            if ($type == 'count') $select = "count(*) as count "; 
                
            if ($pg >= 0 && $type <> 'count') { 
                $from .= " order by $sBy $sOrder limit $pg," . $limit;
            }

            // $from .= " order by pr.pr_id desc ";
            $sql = "SELECT " . $select . "" . $from;
            $query = $this->db->query($sql);
            return $query->result_array();
    }


    function get_challan_payment_list ($pg = 0, $limit = 10, $sBy = 'pr.pr_id', $sOrder = 'desc', $searchCond = '',$type=''){ 

            $select = "pr.pr_id as p_rid,pr.request_id,pr.check_id,pr.level_id,pr.case_no,cr.candidate_name,c.org_name,m.name as check_name,pr.beneficiary_name,pr.beneficiary_location,pr.payment_mode,pm.pm_name,pr.requested_amount as amount, pm1.pm_name as paymode, pm2.pm_name as paystatus,pr.payment_status,pr.requested_date,pr.ref_branch_code as branchcode, pr.approved_date, pr.paid_date,pr.bank_name,pm3.pm_name as reason,pm4.pm_name as payto,pr.comments,pr.attachment,pr.initiated_on,pr.completed_on, concat_ws(' ',f.first_name,f.last_name) as requested_by, concat_ws(' ',u.first_name,u.last_name) as approved_by,prc.chln_id,prc.pr_id,prc.chln_bank,prc.chln_journal_no,prc.chln_date,prc.chln_charges,prc.chln_file, vr.count_of_chk";
                        
                    $from = "   FROM " . DB_PREFIX . "payment_request pr 
                    LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = pr.request_id
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = pr.org_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=pr.check_id
                    LEFT JOIN " . DB_PREFIX . "payment_master pm ON pm.pm_id=pr.currency
                    LEFT JOIN " . DB_PREFIX . "payment_master pm1 ON pm1.pm_id=pr.payment_mode
                    LEFT JOIN " . DB_PREFIX . "payment_master pm2 ON pm2.pm_id=pr.payment_status
                    LEFT JOIN " . DB_PREFIX . "payment_master pm3 ON pm3.pm_id=pr.reason_payment
                    LEFT JOIN " . DB_PREFIX . "payment_master pm4 ON pm4.pm_id=pr.payment_to
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = pr.requested_by
                    LEFT JOIN " . DB_PREFIX . "user u ON u.id = pr.approved_by
                    LEFT JOIN " . DB_PREFIX . "payment_request_challan prc ON prc.pr_id =pr.pr_id
                    LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=pr.request_id and vr.check_id=pr.check_id and vr.level_id=pr.level_id
                    where 1 ";

                    $roleid= $this->session->userdata('role_id');
                    if($roleid==5 || $roleid==27){
                        $from .= "and pr.payment_mode=22 and vr.team_mem_id = ".$this->session->userdata['userid'];
                    }
                    else if($roleid==9){
                        $from .= "and pr.payment_mode=22 ";
                    }
                    else 
                    {
                        $from .= " ";
                    }
               
            if ($searchCond) {
                $from .= " and $searchCond and pr.payment_mode=22";
            }else{
                if($roleid==26){
                    $from .= " and pr.payment_mode=22 and pr.payment_status IN (32,34)";
                }
            }

            if ($type == 'count') $select = "count(*) as count "; 
                
            if ($pg >= 0 && $type <> 'count') { 
                $from .= " order by $sBy $sOrder limit $pg," . $limit;
            }

            // $from .= " order by pr.pr_id desc ";
            $sql = "SELECT " . $select . "" . $from;
            $query = $this->db->query($sql);
            return $query->result_array();

    }


    /****************************************
     Payment Request List
     function get_individualchk_list
    ****************************************/

    function get_individualchk_list ($pg = 0, $limit = 10, $sBy = 'pr.pr_id', $sOrder = 'desc', $searchCond = '',$type=''){ 

            $select = "pr.pr_id,pr.request_id,pr.check_id,pr.level_id,pr.case_no,cr.candidate_name,c.org_name,m.name as check_name,pr.beneficiary_name,pr.beneficiary_location,pr.payment_mode,pm.pm_name,pr.requested_amount as amount, pm1.pm_name as paymode, pm2.pm_name as paystatus,pr.payment_status,pr.requested_date,pr.ref_branch_code as branchcode, pr.approved_date, pr.paid_date,pr.bank_name,pm3.pm_name as reason,pm4.pm_name as payto,pr.comments,pr.attachment,pr.initiated_on,pr.completed_on, concat_ws(' ',f.first_name,f.last_name) as requested_by, concat_ws(' ',u.first_name,u.last_name) as approved_by,prd.dd_no as dd_txn_no,prd.dd_no,prd.dd_date,prd.dd_charges,prd.chk_number,prd.chk_date,prn.neft_id,prn.neft_bank_name,prn.neft_account_type,prn.neft_reference_no,prn.neft_payment_date,prn.neft_trans_charge, vr.count_of_chk";
                        
                    $from = "   FROM " . DB_PREFIX . "payment_request pr 
                    LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = pr.request_id
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = pr.org_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=pr.check_id
                    LEFT JOIN " . DB_PREFIX . "payment_master pm ON pm.pm_id=pr.currency
                    LEFT JOIN " . DB_PREFIX . "payment_master pm1 ON pm1.pm_id=pr.payment_mode
                    LEFT JOIN " . DB_PREFIX . "payment_master pm2 ON pm2.pm_id=pr.payment_status
                    LEFT JOIN " . DB_PREFIX . "payment_master pm3 ON pm3.pm_id=pr.reason_payment
                    LEFT JOIN " . DB_PREFIX . "payment_master pm4 ON pm4.pm_id=pr.payment_to
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = pr.requested_by
                    LEFT JOIN " . DB_PREFIX . "user u ON u.id = pr.approved_by
                    LEFT JOIN " . DB_PREFIX . "payment_request_dd prd ON prd.pr_id =pr.pr_id
                    LEFT JOIN " . DB_PREFIX . "payment_request_neft prn ON prn.pr_id =pr.pr_id
                    LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=pr.request_id and vr.check_id=pr.check_id and vr.level_id=pr.level_id
                    where 1 ";

                    $roleid= $this->session->userdata('role_id');
                    if($roleid==5){
                        $from .= " and vr.team_mem_id = ".$this->session->userdata['userid'];
                    }
                    else 
                    {
                        $from .= " ";
                    }
               
            if ($searchCond) {
                $from .= " and $searchCond";
            }
        
                $sql = "SELECT " . $select . "" . $from;
                $query = $this->db->query($sql);
                return $query->result_array();
    }

    function get_card_payment_list ($pg = 0, $limit = 10, $sBy = 'pr.pr_id', $sOrder = 'desc', $searchCond = '',$type=''){ 

            $select = "pr.pr_id,pr.request_id,pr.check_id,pr.level_id,pr.case_no,cr.candidate_name,c.org_name,m.name as check_name,pr.beneficiary_name,pr.beneficiary_location,pr.payment_mode,pm.pm_name,pr.requested_amount as amount, pm1.pm_name as paymode, pm2.pm_name as paystatus,pr.payment_status,pr.requested_date,pr.ref_branch_code as branchcode, pr.approved_date, pr.paid_date,pr.bank_name,pm3.pm_name as reason,pm4.pm_name as payto,pr.comments,pr.attachment,pr.initiated_on,pr.completed_on, concat_ws(' ',f.first_name,f.last_name) as requested_by, concat_ws(' ',u.first_name,u.last_name) as approved_by,pc.cr_id,pc.pr_id,pc.cr_card_type,pc.cr_transaction_no,pc.cr_transaction_date,pc.cr_transaction_charge,pc.cr_card_file, vr.count_of_chk";
                        
                    $from = "   FROM " . DB_PREFIX . "payment_request pr 
                    LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = pr.request_id
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = pr.org_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=pr.check_id
                    LEFT JOIN " . DB_PREFIX . "payment_master pm ON pm.pm_id=pr.currency
                    LEFT JOIN " . DB_PREFIX . "payment_master pm1 ON pm1.pm_id=pr.payment_mode
                    LEFT JOIN " . DB_PREFIX . "payment_master pm2 ON pm2.pm_id=pr.payment_status
                    LEFT JOIN " . DB_PREFIX . "payment_master pm3 ON pm3.pm_id=pr.reason_payment
                    LEFT JOIN " . DB_PREFIX . "payment_master pm4 ON pm4.pm_id=pr.payment_to
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = pr.requested_by
                    LEFT JOIN " . DB_PREFIX . "user u ON u.id = pr.approved_by
                    LEFT JOIN " . DB_PREFIX . "payment_request_card pc ON pc.pr_id =pr.pr_id
                    LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=pr.request_id and vr.check_id=pr.check_id and vr.level_id=pr.level_id
                    where 1 ";

                    $roleid= $this->session->userdata('role_id');
                    if($roleid==5 || $roleid==27){
                        $from .= "and pr.payment_mode=23 and vr.team_mem_id = ".$this->session->userdata['userid'];
                    }
                    else if($roleid==9){
                        $from .= "and pr.payment_mode=23 ";
                    }
                    else 
                    {
                        $from .= " ";
                    }
               
            if ($searchCond) {
                $from .= " and $searchCond and pr.payment_mode=23";
            }else{
                if($roleid==26){
                    $from .= " and pr.payment_mode=23 and pr.payment_status IN (32)";
                }
            }

            if ($type == 'count') $select = "count(*) as count "; 
                
            if ($pg >= 0 && $type <> 'count') { 
                $from .= " order by $sBy $sOrder limit $pg," . $limit;
            }
            // $from .= " order by pr.pr_id desc ";
            $sql = "SELECT " . $select . "" . $from;
            $query = $this->db->query($sql);
            return $query->result_array();
    }


    function get_online_payment_list ($pg = 0, $limit = 10, $sBy = 'pr.pr_id', $sOrder = 'desc', $searchCond = '',$type=''){ 

            $select = "pr.pr_id,pr.request_id,pr.check_id,pr.level_id,pr.case_no,cr.candidate_name,c.org_name,m.name as check_name,pr.beneficiary_name,pr.beneficiary_location,pr.payment_mode,pm.pm_name,pr.requested_amount as amount, pm1.pm_name as paymode, pm2.pm_name as paystatus,pr.payment_status,pr.requested_date,pr.ref_branch_code as branchcode, pr.approved_date, pr.paid_date,pr.bank_name,pm3.pm_name as reason,pm4.pm_name as payto,pr.comments,pr.attachment,pr.initiated_on,pr.completed_on, concat_ws(' ',f.first_name,f.last_name) as requested_by, concat_ws(' ',u.first_name,u.last_name) as approved_by,po.op_id,po.pr_id,po.op_mobile_no,po.op_transaction_no,po.op_transaction_date,po.op_transaction_charge,po.op_online_file, vr.count_of_chk";
                        
                    $from = "   FROM " . DB_PREFIX . "payment_request pr 
                    LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = pr.request_id
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = pr.org_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=pr.check_id
                    LEFT JOIN " . DB_PREFIX . "payment_master pm ON pm.pm_id=pr.currency
                    LEFT JOIN " . DB_PREFIX . "payment_master pm1 ON pm1.pm_id=pr.payment_mode
                    LEFT JOIN " . DB_PREFIX . "payment_master pm2 ON pm2.pm_id=pr.payment_status
                    LEFT JOIN " . DB_PREFIX . "payment_master pm3 ON pm3.pm_id=pr.reason_payment
                    LEFT JOIN " . DB_PREFIX . "payment_master pm4 ON pm4.pm_id=pr.payment_to
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = pr.requested_by
                    LEFT JOIN " . DB_PREFIX . "user u ON u.id = pr.approved_by
                    LEFT JOIN " . DB_PREFIX . "payment_request_online po ON po.pr_id =pr.pr_id
                    LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=pr.request_id and vr.check_id=pr.check_id and vr.level_id=pr.level_id
                    where 1 ";

                    $roleid= $this->session->userdata('role_id');
                    if($roleid==5 || $roleid==27){
                        $from .= "and pr.payment_mode=26 and vr.team_mem_id = ".$this->session->userdata['userid'];
                    }
                    else if($roleid==9){
                        $from .= "and pr.payment_mode=26 ";
                    }
                    else 
                    {
                        $from .= " ";
                    }
               
            if ($searchCond) {
                $from .= " and $searchCond and pr.payment_mode=26";
            }else{
                if($roleid==26){
                    $from .= " and pr.payment_mode=26 and pr.payment_status IN (32)";
                }
            }

            if ($type == 'count') $select = "count(*) as count "; 
                
            if ($pg >= 0 && $type <> 'count') { 
                $from .= " order by $sBy $sOrder limit $pg," . $limit;
            }
            
            // $from .= " order by pr.pr_id desc ";
            $sql = "SELECT " . $select . "" . $from;
            $query = $this->db->query($sql);
            return $query->result_array();

    }

    function get_newcheckstatus ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') {   

        $select = " a.candidate_req_id,a.vm_revert_to,a.ass_request, a.qc_revert_request, a.vm_assigned_qc, d.candidate_name as candidatename, a.level_id,s.vm_revert_option_status,s.operator_submited_by,d.vm_revert_supervisor,c.name as checkname,verify_status,a.check_id ,a.vm_revert_status as rstatus, vm_revert_request as vrequest, d.case_no,o.org_name,a.qc1_assign_revert,a.qc1_verification,a.qc2_revert_request,a.qc2_verification,vl1.status as vmstatus,a.qc_2_verification,a.qc2_report_publish,vl1.qc2_date,a.count_of_chk,d.dataentry_by,d.case_recieved_date,d.case_accepted_date, a.reopen_revert_qc2,em.company_name,t.email, pr.company_name as pcompany_name,ed.collegename_add,ed.affliated,ed.degree, vl1.supplementary, td.ticket_status,td.ticket_details";
          $from = "  from
                    ".DB_PREFIX ."ver_assign_rep a
                    LEFT JOIN ".DB_PREFIX ."personal_details b ON b.user_id = a.candidate_req_id
                    LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
                    LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = b.user_id
                    LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
                    LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
                    LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
                    LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
                    JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3
                    LEFT JOIN ".DB_PREFIX ."submit_cv s ON s.request_id = a.candidate_req_id
                    LEFT JOIN ".DB_PREFIX ."employment em ON em.id = a.level_id and a.check_id=59
                    LEFT JOIN ".DB_PREFIX ."education_details ed ON ed.id = a.level_id and a.check_id=14
                    LEFT JOIN ".DB_PREFIX ."professional_reference pr ON pr.id = a.level_id and a.check_id=68
                    LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.candidate_req_id and vl1.level_id=a.level_id and vl1.check_id=a.check_id
                    LEFT JOIN " . DB_PREFIX . "ticket_details td ON td.request_id=vl1.request_id and td.check_id=vl1.check_id and td.level_id=vl1.level_id and td.current_status=1
                    WHERE 1=1 ";  
        if($this->session->userdata('user_type') == 1 && $this->session->userdata('role_id')==21 )
        {
            $from .= " and o.crm_userid = ".$this->session->userdata['userid']."  ";
        } 

        // $from .= " and (CASE WHEN ct.org_id !=0 THEN ct.org_id=o.id ELSE ct.org_id=0 END) and ct.tat_status=1 ";

        if ($searchCond) {
            $from .= " and $searchCond";
        }

                if ($type == 'count') $select = "count(DISTINCT(a.rep_id)) as count ";
               
                if ($pg >= 0 && $type <> 'count') {
                        $from .= " group by a.rep_id order by a.candidate_req_id desc,$sBy $sOrder limit $pg," . $limit;
                }
       
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    function randomString($length)
    {
        $str = "";
        $characters = array_merge(range('A', 'Z'), range('a', 'z'), range('0', '9'));
        $max = count($characters) - 1;
        for ($i = 0; $i < $length; $i++) {
        $rand = mt_rand(0, $max);
        $str .= $characters[$rand];
        }
        return $str;
    }


    function get_orgid($name)
    {
        $this->db->select('id');
        $this->db->from(DB_PREFIX . 'organisation');
        $this->db->where('org_name', $name);
        $query = $this->db->get();
        return $query->row_array();
    }

    function get_hoffice_id($name, $org_id)
    {
        $this->db->select('id');
        $this->db->from(DB_PREFIX . 'office');
        $this->db->where('office_name', $name);
        $this->db->where('parentoffice_id', $org_id);
        $query = $this->db->get();
        return $query->row_array();
    }

    function get_branchoffice_id($name, $org_id)
    {
        $this->db->select('id');
        $this->db->from(DB_PREFIX . 'office');
        $this->db->where('office_name', $name);
        $this->db->where('parentoffice_id', $org_id);
        $query = $this->db->get();
        return $query->row_array();
    }

    function get_suboffice_id($name, $org_id)
    {
        $this->db->select('id');
        $this->db->from(DB_PREFIX . 'office');
        $this->db->where('office_name', $name);
        $this->db->where('parentoffice_id', $org_id);
        $query = $this->db->get();
        return $query->row_array();
    }

    function get_package_id($name, $org_id)
    {
        $this->db->select('package_id');
        $this->db->from(DB_PREFIX . 'packages');
        $this->db->where('package_name', $name);
        $this->db->where('org_id', $org_id);
        $query = $this->db->get();
        return $query->row_array();
    }

    function get_admin_hrid($org_id,$fname,$lname)
    {
        $where = '(organization="'.$org_id.'" AND first_name = "'.$fname.'" AND last_name="'.$lname.'" AND user_type=2)';
        return $this->db->select('id')
         ->from(DB_PREFIX.'user')
         ->where($where)
         ->get()
         ->row_array();
    }

    /***********************
     * **** Bulk Invite ****
     * **** function bulkdml
     * *********************/
    function bulkdml($data, $id)
    {
        if(count($data) > RECORD_COUNT){
            echo "<script language='javascript' type='text/javascript'>
                alert('Number of candidate should not be more that 25');
                </script>";
        }else
        {
            foreach($data as $val){

                $orgId=$this->bm->get_orgid($val['Organization']);
                $org_id=$orgId['id'];
                
                $hoId=$this->bm->get_hoffice_id($val['Head Office'],$org_id);
                $ho_id=$hoId['id'];

                $brId=$this->bm->get_branchoffice_id($val['Branch Office'],$org_id);
                $br_id=$brId['id'];

                $soId=$this->bm->get_suboffice_id($val['Sub Office'],$org_id);
                $so_id=$soId['id'];

                $packId=$this->bm->get_package_id($val['Package Name'],$org_id);
                $pack_id=$packId['package_id'];

                // Extracting First_name and Last_name from single string
                $name = explode(' ', $val['Client Admin / HR']);
                $uf_name=$name[0];
                $ul_name=$name[1];
                
                $user_id = $this->get_admin_hrid($org_id, $uf_name, $ul_name);
                $hr_id=$user_id['id'];
                $roleid = $this->session->userdata('role_id');
                
                if($roleid == 1 && empty($user_id)){
                    $created_by=$this->session->userdata['userid'].'=>';
                }else if(($roleid == 12 || $roleid == 13) && empty($user_id)){
                    $created_by=$this->session->userdata['userid'].'=>';
                }else{
                    $created_by=$hr_id;
                }

                if($val['Gender']=='Male'){
                    $gender=7;
                }else{
                    $gender=8;
                }
                
                if ($id == 0 ) {

                    $formData['first_name'] = $val['First Name'];
                    $formData['middle_name'] = $val['Middle Name'];
                    $formData['last_name'] = $val['Last Name'];
                    $formData['gender'] = $gender;
                    $formData['email'] = $val['Email Id'];
                    $formData['status'] = 1;
                    $formData['role_id'] = 16;
                    $formData['user_type'] = 2;
                    
                    if (!empty($val['Organization']))
                    $org_id = $org_id;
                    else if ($this->session->userdata('organization') != 1)
                    $org_id = $this->session->userdata('organization');
                    $org = $this->amodel->getDetails(DB_PREFIX . "organisation", array('org_name', 'id', 'num_days_submit'), array('id' => $org_id));
                
                    $num_days = isset($org[0]['num_days_submit']) ? $org[0]['num_days_submit'] : '5';
                    $formData['submit_date'] = date('Y-m-d H:i:s', strtotime($num_days . " weekdays"));
                    $new_password = $this->randomString(10);
                    $formData['password'] =  md5($new_password);
                    $explodeemail = explode('@', $val['Email Id']);
                    $formData['username'] = $explodeemail[0];
                    
                    $insertData = elements(array('first_name', 'middle_name', 'last_name', 'gender', 'user_type', 'office_id', 'role_id', 'email', 'username', 'password', 'role_id', 'submit_date', 'status', 'type_of_employees'), $formData);
                }

                if (!empty($val['Organization']))
                    $insertData['organization'] = $org_id;
                else if ($this->session->userdata('organization') != 1)
                    $insertData['organization'] = $this->session->userdata('organization');
                if (!empty($val['Branch Office']))
                    $insertData['office_id'] = $br_id;
                if (!empty($val['Head Office']))
                    $insertData['parent_office'] = $ho_id;
                if (!empty($val['Sub Office']))
                    $insertData['sub_office'] = $so_id;

                $insertData = $this->security->xss_clean($insertData);
                $return_id = $this->bulkdmlfunction(DB_PREFIX . "user", array('id' => $id), $insertData, $id, $created_by);
            
                // print_r($return_id);
                // exit;

                $this->db->select('MAX(request_id) as id');
                $this->db->where('organisation', $org_id);
                $lastcase = $this->db->get(DB_PREFIX . 'client_request')->row_array();
        
                $this->db->select('case_no');
                $this->db->where('request_id', $lastcase['id']);
                $this->db->where('organisation', $org_id);
                $lastcase = $this->db->get(DB_PREFIX . 'client_request')->row_array();
        
                $current = date('dm');
        
                if (empty($lastcase['case_no']))
                $caseno = 1;
                else {
                $explode = explode('-', $lastcase['case_no']);
                $caseno = $explode[1] + 1;
                }

                $offices = '';
                if (!empty($val['Head Office']) && !empty($val['Branch Office']) && !empty($val['Sub Office'])) {
                $offices = array('parent_office' => $ho_id, 'office' => $br_id, 'sub_office' => $so_id, 'status' => 1);
                }
                if (!empty($val['Head Office']) && !empty($val['Branch Office']) && empty($val['Sub Office']))
                $offices = array('parent_office' => $ho_id, 'office' => $br_id, 'sub_office' => 0, 'status' => 1);
                else if (!empty($val['Head Office']) && empty($val['Branch Office'])  && empty($val['Sub Office']))
                $offices = array('parent_office' => $ho_id, 'office' => 0, 'sub_office' => 0, 'status' => 1);

                $order = $this->amodel->getDetails(DB_PREFIX . "order", array('id', 'billing_type'), $offices);
                //for branch offices
                if (empty($order)) {
                $offices = array('parent_office' => $ho_id, 'office' => $br_id, 'sub_office' => 0, 'status' => 1);
                $order = $this->amodel->getDetails(DB_PREFIX . "order", array('id', 'billing_type'), $offices);
                }
                //for head offices
                if (empty($order)) {
                $offices = array('parent_office' => $ho_id, 'office' => 0, 'sub_office' => 0, 'status' => 1);
                $order = $this->amodel->getDetails(DB_PREFIX . "order", array('id', 'billing_type'), $offices);
                }
                
                $billingtype = '';
                if ($order[0]['billing_type'] == 515) {
                $billingtype = "PR";
                } elseif ($order[0]['billing_type'] == 516) {
                $billingtype = "PO";
                }
                $casenumber = $billingtype . $org_id . '-' . $caseno;

                $formcliData['user_id'] = $return_id;
                $formcliData['candidate_name'] = $val['First Name'] . ' ' . $val['Middle Name'] . ' ' . $val['Last Name'];
                $formcliData['organisation'] = $org_id;
                $formcliData['parent_office'] = $ho_id;
                $formcliData['office'] = $br_id;
                $formcliData['sub_office'] = $so_id;
                $formcliData['order_id'] = $order[0]['id'];
                $formcliData['case_no'] = $casenumber;
                $formcliData['deadline_from'] = date('Y-m-d');
                $formcliData['deadline_to'] = date('Y-m-d', strtotime("5 weekdays"));
                $formcliData['client_ref_number'] = '';
        
                $insertcliData = elements(array('user_id', 'deadline_from', 'deadline_to', 'candidate_name', 'organisation', 'office', 'parent_office', 'sub_office', 'order_id', 'case_no', 'client_ref_number'), $formcliData);

                $candidatereqId =  $this->bulkdmlfunction(DB_PREFIX . "client_request", array('id' => $id), $insertcliData, $id, $created_by);
                
                $this->db->insert(DB_PREFIX . 'profile_status', array('candidate_request_id' => $candidatereqId));

                if ($order == NULL) {
                    $order = $this->amodel->getDetails(DB_PREFIX . "order", array('id'), array('parent_office' => $ho_id));
                }
                $client_request_id = $this->db->insert_id();
                $levelid = '';
                // $levelid = json_encode($formData['level_id']);
                $levelar = $pack_id;
                $inslog_data['order_id'] = $order[0]['id'];
                $inslog_data['user_id'] = $return_id;
                $inslog_data['request_id'] = $client_request_id;
                $inslog_data['check_id'] = $levelar;
                $inslog_data['action'] = $levelid;
                $inslog_data['updated_by'] = $return_id;
                $inslog_data['updated_on'] = date('Y-m-d H:i:s');
                $this->db->insert(DB_PREFIX . 'loghistory', $inslog_data);

                /****Packages*****/
                if ($levelar > 650) {
                    $this->db->select('*');
                    $this->db->where_in('package_id', $levelar);
                    $package_details = $this->db->get(DB_PREFIX . "packages")->result_array();
                    //echo '<pre>';print_r($package_details);exit;
                    foreach ($package_details as $key => $pval) {
                    //print_r($pval['acceptable_limit']);
                    $check_id = $pval['check_id'];

                    if ($pval['group_id'] == 1) {
                        $no_ofchek = ($pval['mandatory'] == 'Yes') ? 1 : 0;
                    } else {
                        $no_ofchek = ($pval['no_ofcheck']) ? $pval['no_ofcheck'] : 1;
                    }
                    if ($check_id == 75) {
                        $levelname = "DRUG " . $pval['acceptable_limit'];
                    } else {
                        $levelname = $pval['acceptable_limit'];
                    }
                    $request_check_insert[] = array(
                        'check_id' => $check_id,
                        'no_checks' => $no_ofchek,
                        'description' => $levelname,
                        'request_id' => $candidatereqId,
                        'package_id' => $pval['package_id'],
                        'information' => ''
                    );
                    }
                }

                if ($request_check_insert) {
                    $this->db->insert_batch(DB_PREFIX . 'request_check', $request_check_insert);
                }
        
                $sql = $this->db->query('delete from ' . DB_PREFIX . 'profile_level_status where client_request_id = "' . $candidatereqId . '"');

                $ins_data['client_request_id'] = $candidatereqId;
                $ins_data['check_level_id'] = $pack_id;
                $ins_data['level_status'] = 1;
                $ins_data['created_on'] = date('Y-m-d H:i:s');
                $ins_data['created_by'] = $created_by;
                $this->db->insert(DB_PREFIX . 'profile_level_status', $ins_data);
                
                $this->db->select('billing_type');
                $billingtype = $this->db->get_where('dcode_order ', array('id' => $order[0]['id']))->row_array();

                $insbill_data['pack_id'] = $pack_id;
                $ncheck = $this->db->query("select SUM(m.Rs*a.no_checks) AS total_value
                            from " . DB_PREFIX . "request_check a
                            JOIN " . DB_PREFIX . "add_check m ON m.types_of_check = a.check_id
                            where a.request_id =  " . $client_request_id . " AND (a.check_id < 95 OR (a.check_id >630 AND a.check_id <=654))
                            AND m.order_id =" . $order[0]['id'] . "")->row_array();

                $ncheckvalue = $this->db->query("select sum(Rs) as total_package from " . DB_PREFIX . "add_check where  `types_of_check` IN(SELECT package_id FROM " . DB_PREFIX . "request_check WHERE request_id =" . $client_request_id . " AND order_id =" . $order[0]['id'] . " ) ")->row_array();

                $insbill_data['parent_office'] = $ho_id;
                $insbill_data['organisation'] = $org_id;
                $insbill_data['sub_office'] = $so_id;

                $insbill_data['office'] = $br_id;
                $insbill_data['candidate_name'] = $val['First Name'] . ' ' . $val['Middle Name'] . ' ' . $val['Last Name'];
                $insbill_data['order_id'] = $order[0]['id'];
                $insbill_data['amount'] = $ncheck['total_value'];
                $insbill_data['package_amount'] = $ncheckvalue['total_package'];
                $insbill_data['user_id'] = $return_id;
                $insbill_data['request_id'] = $candidatereqId;

                $insbill_data['case_no'] = $casenumber;
                $insbill_data['created_on'] = date('Y-m-d');
                $insbill_data['billing_type'] = $billingtype['billing_type'];
                $this->db->insert(DB_PREFIX . 'billing', $insbill_data);

                $cand_details = $this->amodel->getDetails(DB_PREFIX . "client_request", array('organisation', 'created_by'), array('user_id' => $return_id));

                $org = $this->amodel->getDetails(DB_PREFIX . "organisation", array('org_name', 'id', 'num_days_submit', 'logo'), array('id' => $cand_details[0]['organisation']));
                $num_days = isset($org[0]['num_days_submit']) ? $org[0]['num_days_submit'] : '5';
                $logo = isset($org[0]['logo']) ? $org[0]['logo'] : '';
                $data['new_password'] = $new_password;
                $data['first_name'] = $val['First Name'];
                $data['email'] = $val['Email Id'];
                $data['org_name'] = $val['Organization'];
                $data['expiry_date'] = '';
                $client = $this->amodel->getDetails(DB_PREFIX . "user", array("email,CONCAT(first_name,' ',last_name) AS name"), array('id' => $cand_details[0]['created_by']));
                $data['cemail'] = $client[0]['email'];
                $data['cname'] = $client[0]['name'];
                $data['num_days'] = $num_days;
                $data['logo'] = $logo;
                $data['cand_user_id'] = base64_encode($return_id);
        
                $data['request_id'] = (!empty($candidatereqId)) ? $candidatereqId : $reqID;

                if (@$return_id && empty($status_order)) {
                    $id_mail =   send_email_candidateadd('new_registration_candidate', 'Background Verification Login Details @' . $data['org_name'], @$val['Email Id'], @$client[0], $data);
                } else if ($status_order[0]['status'] == 1 ) {
                    $returnpsd_id = $this->amodel->getDetails(DB_PREFIX . "user", array('email', 'first_name', 'password'), array('id' => $id));
                    $id_mail =   send_email_candidateadd('new_registration_candidate', 'Background Verification Login Details @' . $data['org_name'], @$val['email'], @$client[0], $data);
                }

                //permission
                if ($id == 0) {

                    $menucond = "menu_ids IS NOT NULL AND  menu_ids!=''";
                    $this->db->select('menu_ids');
                    $this->db->where('user_type', 2);
                    $this->db->where('role_id', 16);
                    $this->db->where($menucond);
                    $this->db->order_by('role_id', 'DESC');
                    $menus = $this->db->get(DB_PREFIX . 'role_permissions')->row_array();

                    if (!empty($val['Organization']))
                    $organization = $org_id;
                    else
                    $organization = $this->session->userdata('organization');
                    $role_permission['user_type'] = 2;
                    $role_permission['role_id'] = 16;
                    $role_permission['office_id'] = $br_id;
                    $role_permission['parent_office'] = $ho_id;
                    $role_permission['organization'] = $organization;
                    $this->db->where($role_permission);
                    $checkrole = $this->db->get(DB_PREFIX . 'role_permissions')->row_array();
                    if (empty($checkrole)) {
                    $role_permission['active_status'] = 1;
                    $role_permission['created_on'] = date('Y-m-d H:i:s');
                    $role_permission['menu_ids'] = $menus['menu_ids'];

                    $this->db->insert(DB_PREFIX . 'role_permissions', $role_permission);
                    }
                    $this->db->select('feature_id,add,edit,delete,search,list,generate,task_status');
                    $this->db->where('role_id', 16);
                    $this->db->group_by('feature_id');
                    $this->db->order_by('role_id', 'DESC');
                    $roles_config = $this->db->get('m_role_config')->result_array();
                    $this->db->where('role_id', 16);
                    $this->db->where('office_id', $br_id);
                    $this->db->where('parent_office', $ho_id);
                    $this->db->where('organization', $organization);
                    $this->db->group_by('feature_id');
                    $check_config = $this->db->get('m_role_config')->row_array();


                    if (!empty($roles_config) && empty($check_config)) {
                    $new_config = array();
                    $newarryay = array();
                    foreach ($roles_config as $config_role) {
                        $new_config[$config_role['feature_id']] = $config_role;

                        $new_config1[$config_role['feature_id']]['role_id'] = 16;
                        $new_config1[$config_role['feature_id']]['office_id'] = $br_id;
                        $new_config1[$config_role['feature_id']]['parent_office'] = $ho_id;
                        $new_config1[$config_role['feature_id']]['organization'] = $organization;
                        $new_config1[$config_role['feature_id']]['created_by'] = $this->user_id;
                        $new_config1[$config_role['feature_id']]['created_on'] = date('Y-m-d H:i:s');

                        $newarryay[] = array_merge($new_config[$config_role['feature_id']], $new_config1[$config_role['feature_id']]);
                    }
                    if (!empty($newarryay))
                        $this->db->insert_batch('m_role_config', $newarryay);
                    }
                    // echo "<script>alert('Candidate has been created successfully');</script>";
                
                }
                
                $userID=$this->session->userdata['userid'];
                $inst_data['request_id'] = $candidatereqId;
                $inst_data['organization'] = $val['Organization'];
                $inst_data['head_office']= $val['Head Office'];
                $inst_data['branch_office'] = $val['Branch Office'];
                $inst_data['sub_office'] = $val['Sub Office'];
                $inst_data['first_name'] = $val['First Name'];
                $inst_data['middle_name'] = $val['Middle Name'];;
                $inst_data['last_name'] = $val['Last Name'];;
                $inst_data['gender'] = $val['Gender'];;
                $inst_data['email_id'] = $val['Email Id'];
                $inst_data['created_by'] = $created_by;  
                $inst_data['package_name'] = $val['Package Name'];
                $inst_data['created_on'] = date('Y-m-d H:i:s');             

                $inst_data = $this->security->xss_clean($inst_data);
                $this->db->insert( DB_PREFIX .'bulk_invite', $inst_data);
            }
        }
        $this->session->set_flashdata('success_mail', $id_mail, 300);
        redirect('Billing/bulk_invite', 'refresh');

    }

    /*********** Bulk Invite **********
     ** function get_bulk_invitelist ** 
     **********************************/
    function get_bulk_invitelist($pg = 0, $limit = 10, $sBy = 'jd_id', $sOrder = 'desc', $searchCond = '', $type = '')
    {
        $select = "a.*, concat_ws(' ', b.first_name, b.last_name) as user_name ";

        $from = "FROM " . DB_PREFIX . "bulk_invite a
        LEFT JOIN " . DB_PREFIX . "user b ON b.id = a.created_by
        where 1 ";

        if ($searchCond) {
            $from .= " and $searchCond ";
        }

        if ($type == 'count') $select = "count(DISTINCT(a.id)) as count ";

        if ($pg >= 0 && $type <> 'count') {
            $from .= " GROUP BY a.id order by $sBy $sOrder limit $pg," . $limit;
        }
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    
    }

    /******** Data**********/
    public function bulkdmlfunction($table, $condition, $formData, $editId = 0, $created_by = 0)
    {
        if ($formData) {
            $formData =  array_map('trim', $formData);

            if ($editId == 0) {
                $formData['created_by'] = $created_by;
                $formData['created_on'] = date('Y-m-d H:i:s');
                $this->db->insert($table, $formData);
                return $this->db->insert_id();
            }
        }
    }

    




    





}
