<?php
class client_model extends CI_Model {

   //Constuctor
    function __construct() 
    {
        parent::__construct();
        $this->load->database();

    }
    function get_organisation_checks($user_id) {
        $sql = "SELECT b.id as user_id, concat_ws(' ',b.first_name,b.middle_name,b.last_name) as name, a.id as order_id
                FROM " . DB_PREFIX ."order a 
                LEFT JOIN " . DB_PREFIX ."office c on c.id = a.office
                LEFT JOIN " . DB_PREFIX ."user b on b.office_id = c.id
                WHERE b.id = ? order by a.updated_on desc, a.created_on desc limit 0,1 ";
        $query = $this->db->query( $sql, array( $user_id ) );
        return $query->result_array();
    }
    
        function get_config_checks($order_id){
                $sql = "SELECT b.name as check_name,a.order_id, a.types_of_check
                        FROM " . DB_PREFIX ."add_check a 
                        LEFT JOIN " . DB_PREFIX ."master_masterdata b on b.id = a.types_of_check 
                        WHERE a.order_id = ? and status =1 group by a.types_of_check order by a.types_of_check asc";
                $query = $this->db->query( $sql, array( $order_id ) );
                return $query->result_array();
        }    

        function get_config_checklevels($types_of_check,$order_id){
                $sql = "SELECT b.name as check_name, a.types_of_check as order_id, level as types_of_check
                        FROM " . DB_PREFIX ."add_check a 
                        LEFT JOIN " . DB_PREFIX ."master_masterdata b on b.id = a.level
                        WHERE a.types_of_check = ? and a.order_id = ? and status =1 order by a.types_of_check asc";
                $query = $this->db->query( $sql, array( $types_of_check,$order_id ) );
                return $query->result_array();
        } 
 
        function get_order_details( $user_id ){ 
                $sql = "SELECT a.id, a.order_name
                        FROM " . DB_PREFIX ."order a 
                        join " . DB_PREFIX ."office c on c.id = a.office 
                        join " . DB_PREFIX ."user b on b.office_id = c.id
                        WHERE b.id = ? ";
                $query = $this->db->query( $sql, array( $user_id ) );
                return $query->result_array();    
        }
        
        function orderdetails( $order_id ){ 
                $sql = "SELECT b.name as checks,a.types_of_check
                        FROM " . DB_PREFIX ."add_check a
                        join " . DB_PREFIX ."master_masterdata b on b.id = a.types_of_check
                        join " . DB_PREFIX ."master_masterdata c on c.id = a.level
                        WHERE 1 and b.key = 'check' and c.key = 'level' and a.order_id = ? group by a.types_of_check order by a.created_on desc";
                $query = $this->db->query( $sql, array( $order_id ) );
                return $query->result_array();    
        }
        
        function get_order_checks( $check_id,$order_id ){ 
                $sql = "SELECT a.check_id, b.name as level,a.Rs as charges_percheck,a.max_attempt
                        FROM " . DB_PREFIX ."add_check a 
                        join " . DB_PREFIX ."master_masterdata b on b.id = a.level
                        WHERE 1 and b.key = 'level' and a.types_of_check = ? and a.order_id = ? order by a.created_on desc";
                $query = $this->db->query( $sql, array( $check_id,$order_id ) );
                return $query->result_array();    
        }
        
        function orderdetails1( $order_id ){ 
                $sql = "SELECT b.name,a.level
                        FROM " . DB_PREFIX ."add_check a 
                        join " . DB_PREFIX ."master_masterdata b on b.id = a.types_of_check
                        WHERE 1 and b.key = 'check' and a.order_id = ? order by a.created_on desc";
                $query = $this->db->query( $sql, array( $order_id ) );
                return $query->result_array();    
        }
        function get_userlist ($pg = 0, $limit = 10, $sBy = 'id', $sOrder = 'desc', $searchCond = '',$type='') { 

       
                $select = "a.id,e.role_name, concat_ws(' ',a.first_name,a.middle_name,a.last_name) as name, 
                        d.name as gender,a.username ,g.office_name,a.photo ";
                        $userType =  $this->session->userdata['userType'];
        
                if($userType == '2')
                {
                $from = "   FROM " . DB_PREFIX . "user a 
                                LEFT JOIN " . DB_PREFIX . "master_masterdata d ON a.gender=d.id
              LEFT JOIN " . DB_PREFIX . "office g ON g.id=a.office_id
              LEFT JOIN " . DB_PREFIX . "role_types e ON e.id=a.role_id
              LEFT JOIN " . DB_PREFIX . "organisation f ON f.id=g.parentoffice_id
                            where 1  and a.active_status <>3 and f.user_type = ". $userType . "";
                 }
                 else {
                        $from = "   FROM " . DB_PREFIX . "user a 
                                LEFT JOIN " . DB_PREFIX . "master_masterdata d ON a.gender=d.id
              LEFT JOIN " . DB_PREFIX . "office g ON g.id=a.office_id
              LEFT JOIN " . DB_PREFIX . "role_types e ON e.id=a.role_id
                                 where 1  and a.active_status <>3";
                 }   
                    
    if ($searchCond) {
      $from .= " and $searchCond";
    }

                if ($type == 'count') $select = "count(*) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                       $from .= " order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function get_user_details($user_id)
    {
        $sql = "SELECT a.id as user_id, concat_ws(' ',a.first_name,a.middle_name,a.last_name) as name,b.office_name,c.org_name
                FROM " . DB_PREFIX ."user a 
                LEFT JOIN " . DB_PREFIX ."office b on b.id = a.office_id
                LEFT JOIN " . DB_PREFIX ."organisation c on c.id = b.parentoffice_id
                WHERE a.id = ". $user_id;
                $query = $this->db->query($sql);
                return $query->result_array();
        }
        function offlinedml($id=0)
        {
    
       
  $formData = $_POST;
        if ($formData) {
        
            if ($id == 0) {
                $insertData = elements(array('candidate_name','organisation','office','created_by','created_on','updated_by','updated_on'), $formData);
            } 
else {
               $insertData = elements(array('candidate_name','organisation','office','updated_by','updated_on'), $formData);
            }
          
            $return_id = $this->amodel->dmlfunction(DB_PREFIX . "client_request", array('id' => $id), $insertData, $id);
           
            redirect('' . base_url('client/clientofflinesearch/'. base64_encode($return_id)));
        }
    }

   function clientorderdetails($office_id) {
         $sql = "SELECT a.id,a.order_code
                        FROM " . DB_PREFIX ."order a 
                        WHERE a.office = ? ";
                $query = $this->db->query($sql,array($office_id));
                return $query->result_array();
   }  
   
   function get_userlistoff_partial($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
   
   $roleid= $this->session->userdata('role_id'); 
   $usertype= $this->session->userdata('user_type'); 

                $select = "c.org_name, a.request_id, a.user_id, a.candidate_name, c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office, a.assainee_status, f.first_name, a.created_on, a.dataentry_by, a.revert_status, a.service, a.reason,a.case_no,a.client_ref_number,a.final_report";
                        
                    $from = "   FROM " . DB_PREFIX . "client_request a 
                                LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
                                LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
                                LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
                                LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                                LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                          LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by
                          JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3
                               LEFT JOIN " . DB_PREFIX . "user_headoffices h ON h.user_id=f.id
                           LEFT JOIN " . DB_PREFIX . "user_branchoffices br ON br.user_id=f.id
                           LEFT JOIN " . DB_PREFIX . "user_suboffices so ON so.user_id=f.id
                          where 1  and a.status_of_candidate=2 ";
                $poffice=implode(",", $this->session->userdata['poffice'] );
                    $boffice=implode(",", $this->session->userdata['boffice'] );
                    $soffice=implode(",", $this->session->userdata['soffice'] );
                if($usertype == 2 && $roleid==12 )
                {
                  if(empty($boffice) and empty($soffice)){
                    $from .= " and h.parent_office in (".$poffice.") and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                    else if(!empty($boffice) and empty($soffice)){
                    $from .= " and h.parent_office in (".$poffice." ) and br.branch_office in (".$boffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                  else{
                         $from .= " and h.parent_office in (".$poffice." ) and br.branch_office in (".$boffice." ) and so.sub_office in (".$soffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                      } 
                      $from .= " and a.dataentry_by = 1 ";
                }    
                else if($usertype == 2 && $roleid==13 )
               {
                   $from .= " and a.dataentry_by = 1 and a.created_by = ".$this->session->userdata['userid']; 
               } 
               else if($usertype == 2 && $roleid==14 )
               {
                    $from .= " and a.dataentry_by = 1 and a.created_by = ".$this->session->userdata['userid']; 
               } 
               else 
               {
                    $from .= " and ( a.dataentry_by = 1 ) ";
               }            
                     
    if ($searchCond) {
      $from .= " and $searchCond ";
    }

                if ($type == 'count') $select = "count(DISTINCT(a.request_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " GROUP BY a.request_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    } 
    
  //full entry details
  function get_userlistoff_full($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
   
   $roleid= $this->session->userdata('role_id'); 
   $usertype= $this->session->userdata('user_type'); 

                $select = "c.org_name, a.request_id,a.user_id, a.candidate_name, c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office, a.assainee_status, f.first_name, a.created_on, a.dataentry_by, a.revert_status, a.service, a.reason,a.case_no,a.client_ref_number,a.final_report,a.aadhaar_number";
                        
                    $from = "   FROM " . DB_PREFIX . "client_request a 
                               LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
                                LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
                                LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
                                LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                                LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                          LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by
                           JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3
                              LEFT JOIN " . DB_PREFIX . "user_headoffices h ON h.user_id=f.id
                           LEFT JOIN " . DB_PREFIX . "user_branchoffices br ON br.user_id=f.id
                           LEFT JOIN " . DB_PREFIX . "user_suboffices so ON so.user_id=f.id
                          where 1  and a.status_of_candidate=2 ";
                $poffice=implode(",", $this->session->userdata['poffice'] );
                    $boffice=implode(",", $this->session->userdata['boffice'] );
                    $soffice=implode(",", $this->session->userdata['soffice'] );
                if($usertype == 2 && $roleid==12 )
                {
                     if(empty($boffice) and empty($soffice)){
                    $from .= " and h.parent_office in(".$poffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                    else if(!empty($boffice) and empty($soffice)){
                    $from .= " and h.parent_office in(".$poffice." ) and br.branch_office in(".$boffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                  else{
                         $from .= " and h.parent_office in(".$poffice." ) and br.branch_office in(".$boffice." ) and so.sub_office in(".$soffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                      } 
                      $from .= " and a.dataentry_by = 2";
                }    
                else if($usertype == 2 && $roleid==13 )
               {
                    $from .= " and a.dataentry_by = 2 and a.created_by = ".$this->session->userdata['userid']; 
               } 
               else if($usertype == 2 && $roleid==14 )
               {
                     $from .= " and a.dataentry_by = 2 and a.created_by = ".$this->session->userdata['userid']; 
               } 
               else 
               {
                    $from .= " and ( a.dataentry_by = 2 ) ";
               }               
                     
    if ($searchCond) {
      $from .= " and $searchCond";
    }

                if ($type == 'count') $select = "count(DISTINCT(a.request_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " GROUP BY a.request_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    } 
    
  //offline entry details
  function get_userlistoff($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
   
   $roleid= $this->session->userdata('role_id'); 
   $usertype= $this->session->userdata('user_type'); 

                $select = "c.org_name, a.request_id,a.user_id, a.candidate_name, c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office, a.assainee_status, f.first_name, a.created_on, a.dataentry_by, a.revert_status, a.service, a.reason,a.case_no,a.client_ref_number,a.case_recieved_date";
                        
                    $from = "   FROM " . DB_PREFIX . "client_request a 
                            LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
                                LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
                                LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
                                LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                                LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                          LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by
                          
                            LEFT JOIN " . DB_PREFIX . "user_headoffices h ON h.user_id=f.id
                           LEFT JOIN " . DB_PREFIX . "user_branchoffices br ON br.user_id=f.id
                           LEFT JOIN " . DB_PREFIX . "user_suboffices so ON so.user_id=f.id
                          where 1  and a.status_of_candidate=2 ";
                    $poffice=implode(",", $this->session->userdata['poffice'] );
                    $boffice=implode(",", $this->session->userdata['boffice'] );
                    $soffice=implode(",", $this->session->userdata['soffice'] );
                if($usertype == 2 && $roleid==12 )
                {
                   if(empty($boffice) and empty($soffice)){
                    $from .= " and h.parent_office in(".$poffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                    else if(!empty($boffice) and empty($soffice)){
                    $from .= " and h.parent_office in(".$poffice." ) and a.office in(".$boffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                  else{
                         $from .= " and h.parent_office in(".$poffice." ) and a.office in(".$boffice." ) and a.sub_office in(".$soffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                      }
                }    
                else if($usertype == 2 && $roleid==13 )
               {
                    $from .= " and a.dataentry_by <> 3 and a.created_by = ".$this->session->userdata['userid']; 
               } 
               else if($usertype == 2 && $roleid==14 )
               {
                     $from .= " and a.dataentry_by <> 3 and a.created_by = ".$this->session->userdata['userid']; 
               } 
                else if($usertype == 1 && ($roleid==3 || $roleid==23) )
               {
                     $from .= " and a.dataentry_by = 3 and a.assainee_status = 0 "; 
               }
               else 
               {
                    $from .= " and ( a.dataentry_by = 3 )";
               }                     
               
                     
    if ($searchCond) {
      $from .= " and $searchCond ";
    }

                if ($type == 'count') $select = " count(DISTINCT(a.request_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " GROUP BY a.request_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    } 
    //All case details
   function get_caselist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 

    $roleid= $this->session->userdata('role_id'); 
   $usertype= $this->session->userdata('user_type'); 
    
    
      if($sBy=='') 
      $sBy='a.created_on';
                $select = "c.org_name, a.user_id, a.request_id, a.candidate_name, c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office, a.assainee_status, concat_ws(' ', f.first_name, f.last_name) as first_name,f.id, a.created_on, a.dataentry_by, a.revert_status, a.service, a.reason,a.case_no,a.client_ref_number,ar.qc2_report_publish,rc.no_checks,a.final_report,a.report_status,a.final_report_published_date,a.case_recieved_date,cv.candidate_status,cv.client_verified,a.case_accepted_date,t.email,uc.telephone,a.billed,cv.client_submit_date, vl.qc2_date,cv.candidate_submit_date,cv.des_rejected_date,a.supplement_report,a.supplement_report_date,a.supplement_report,t.status,t.type_of_employees ,a.payment_status ,mr.name as paym_status";
                        
                    $from = "   FROM " . DB_PREFIX . "client_request a 
                      LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
                      LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
                      LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
                      LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                      LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                      LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by
                      JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3 and t.status != 2 
                      LEFT JOIN " . DB_PREFIX . "user_contact_details uc ON uc.user_id = a.user_id
                      LEFT JOIN " . DB_PREFIX . "user_headoffices h ON h.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "user_branchoffices br ON br.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "user_suboffices so ON so.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=a.request_id
                      LEFT JOIN " . DB_PREFIX . "master_masterdata mr ON mr.id=a.payment_status
                      LEFT JOIN dcode_ver_assign_rep ar ON ar.candidate_req_id=a.request_id
                      LEFT JOIN dcode_verified_level vl ON vl.request_id=a.request_id 
                      LEFT JOIN dcode_request_check rc ON rc.request_id=a.request_id 
                      LEFT JOIN dcode_clientadditional_report ca ON ca.request_id=a.request_id and ca.status = 1  
                      where 1 " ;
                $poffice=implode(",", $this->session->userdata['poffice'] );
                    $boffice=implode(",", $this->session->userdata['boffice'] );
                    $soffice=implode(",", $this->session->userdata['soffice'] );
                if($usertype == 2 && $roleid==12 )
                {

                  if(empty($boffice) and empty($soffice)){
                    $from .= " and a.parent_office in (".$poffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                    else if(!empty($boffice) and empty($soffice)){
                    $from .= " and a.parent_office in (".$poffice." ) and a.office in (".$boffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                  else{
                         $from .= " and a.parent_office in (".$poffice." ) and a.office in (".$boffice." ) and a.sub_office in (".$soffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                      }
                }    
                else if($usertype == 2 && $roleid==13 )
               {
                     if(empty($boffice) and empty($soffice)){
                    $from .= " and a.parent_office in (".$poffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                    else if(!empty($boffice) and empty($soffice)){
                    $from .= " and a.parent_office in (".$poffice." ) and a.office in (".$boffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                  else{
                         $from .= " and a.parent_office in (".$poffice." ) and a.office in (".$boffice." ) and a.sub_office in (".$soffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                      }                
                    $from .= " and ( a.dataentry_by = 3 or a.created_by = ".$this->session->userdata['userid']." ) ";
               } 
               else if($usertype == 2 && $roleid==14 )
               {
                    $from .= " and a.created_by = ".$this->session->userdata['userid'];
               }
               else if($usertype == 2 && $roleid==16 )
               {
                    $from .= " and a.user_id = ".$this->session->userdata['userid'];
               } 
               else if($usertype == 1 && $roleid==21 )
                {
                    $from .= " and c.crm_userid = ".$this->session->userdata['userid']."  ";
                }
               else 
               {
                    $from .= " ";
               }      
                if ($searchCond) {
                  $from .= " and $searchCond ";
                }
                if ($type == 'count') 
                  $select = " count(DISTINCT(a.request_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " GROUP BY a.request_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql); 
        return $query->result_array();
   
   
    } 
    
    function get_userlistoffsuper ($pg = 0, $limit = 10, $sBy = 'request_id', $sOrder = 'desc', $searchCond = '',$type='') { 

                $select = "a.request_id,a.candidate_name,c.org_name,b.office_name,d.office_name as parent_office,e.order_name,a.assainee_status,a.deadline_to,f.first_name, c.dedicated_operator as oprid,dataentry_by,o.office_name as sub_office,cv.reverted_by,cv.reverted_reason,a.case_no,cv.client_submit_date";
                        
                $from = "   FROM " . DB_PREFIX . "client_request a 
                LEFT JOIN " . DB_PREFIX . "office d ON d.id=a.parent_office
                LEFT    JOIN " . DB_PREFIX . "office b ON b.id=a.office
                LEFT  JOIN " . DB_PREFIX . "organisation c ON c.id=a.organisation
              JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
              LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office 
              LEFT JOIN " . DB_PREFIX . "user f ON f.id=a.assignee_id
               JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3
              LEFT JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=a.request_id
                                where 1   AND client_status=1 ";
                        if($this->session->userdata['user_type'] == 2 ) {
                                $from .= "and (a.dataentry_by = 1  || a.dataentry_by = 3 )";
                        } else {
                                $from .= " and a.dataentry_by <> 3 ";
                        }
                         if($this->session->userdata['user_type'] == 1 &&  ($this->session->userdata['role_id'] == 3 || $this->session->userdata['role_id'] == 23 )) {
                                $from .= " and( a.assainee_status = 0 or ( a.dataentry_by = 1 and a.assignee_id=0 ))";
                        } 
    if ($searchCond) {
      $from .= " and $searchCond";
    }

                if ($type == 'count') $select = "count(*) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                       $from .= " order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
        function get_onlineuserlistoffsuper ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 

                $user_id=$this->session->userdata['userid'];
                if($this->session->userdata['org_name']=="Dcode Officeddd") {
                $select = "a.request_id,f.first_name,c.org_name,b.office_name,e.order_name,a.entry_status";
                        
                                 $from = "   FROM " . DB_PREFIX . "client_request a 
                                LEFT JOIN " . DB_PREFIX . "office b ON b.id=a.office
                                LEFT JOIN " . DB_PREFIX . "user f ON f.id=".$user_id."
                                LEFT JOIN " . DB_PREFIX . "organisation c ON c.id=a.organisation
              LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                                 where 1  and a.user_id=".$user_id; }
                                 else {
                                 $select = "a.request_id,f.first_name,c.org_name,b.office_name,e.order_name";
                        
                                 $from = "   FROM " . DB_PREFIX . "client_request a 
                                LEFT JOIN " . DB_PREFIX . "office b ON b.id=a.office
                                LEFT JOIN " . DB_PREFIX . "user f ON f.id=".$user_id."
                                LEFT JOIN " . DB_PREFIX . "organisation c ON c.id=a.organisation
              LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                                 where 1  and a.user_id=".$user_id." and b.id=".$this->session->userdata['office_id'];;
                                 }
                   
                    
    if ($searchCond) {
      $from .= " and $searchCond";
    }

                if ($type == 'count') $select = "count(*) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                       $from .= " order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function getopername($operator_id)    {   
        $sql = "SELECT c.id,c.first_name
                        FROM " . DB_PREFIX ."organisation a 
                        LEFT JOIN " . DB_PREFIX . "user c ON c.id=a.dedicated_operator
                        WHERE a.dedicated_operator= ? ";
                $query = $this->db->query( $sql,array($operator_id));
                return $query->result_array();
    }
    
    function get_candidate_onlinelist ($pg = 0, $limit = 10, $sBy = 'id', $sOrder = 'desc', $searchCond = '',$type='') { 

        $select = "a.id,e.role_name, concat_ws(' ',a.first_name,a.middle_name,a.last_name) as name, 
        d.name as gender,a.username ,g.office_name,a.photo,h.check_status,h.request_id,f.org_name,o.office_name as parent_office,a.created_on,r.office_name as sub_office,h.case_no,h.client_ref_number,h.final_report,h.created_on,h.final_report_published_date";
                        
        $usertype =  $this->session->userdata['userType'];
        $userid = $this->session->userdata['userid'];
        $role_id = $this->session->userdata['role_id'];
    
        $from = "   FROM " . DB_PREFIX . "user a 
          LEFT JOIN " . DB_PREFIX . "master_masterdata d ON a.gender=d.id
          LEFT JOIN " . DB_PREFIX . "role_types e ON e.id=a.role_id
          LEFT JOIN " . DB_PREFIX . "office g ON g.id=a.office_id
          LEFT JOIN " . DB_PREFIX . "organisation f ON f.id=a.organization
          LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.parent_office
          LEFT JOIN " . DB_PREFIX . "office r ON r.id=a.sub_office
          LEFT JOIN " . DB_PREFIX . "client_request h ON h.user_id=a.id
          JOIN " . DB_PREFIX . "user t ON t.id = h.user_id and t.active_status != 3
          LEFT JOIN " . DB_PREFIX . "profile_status i ON i.candidate_request_id = h.request_id
          LEFT JOIN " . DB_PREFIX . "user_headoffices ho ON ho.user_id=h.created_by
          LEFT JOIN " . DB_PREFIX . "user_branchoffices br ON br.user_id=h.created_by
          LEFT JOIN " . DB_PREFIX . "user_suboffices so ON so.user_id=h.created_by
          LEFT JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=h.request_id
              where 1  and a.active_status <>3 and a.role_id = 16 and status_of_candidate=0  and h.dataentry_by=0 ";
                $poffice=implode(",", $this->session->userdata['poffice'] );
                    $boffice=implode(",", $this->session->userdata['boffice'] );
                    $soffice=implode(",", $this->session->userdata['soffice'] );
            if($usertype == 2 && $role_id==12 )
            {
                if(empty($boffice) and empty($soffice)){
                $from .= " and ho.parent_office in (".$poffice." ) and f.id=".$this->session->userdata['parentoffice_id'];
              }
                else if(!empty($boffice) and empty($soffice)){
                $from .= " and ho.parent_office in (".$poffice." ) and br.branch_office in(".$boffice." ) and f.id=".$this->session->userdata['parentoffice_id'];
              }
              else{
                     $from .= " and ho.parent_office in (".$poffice." ) and br.branch_office in(".$boffice." ) and so.sub_office in(".$soffice." ) and f.id=".$this->session->userdata['parentoffice_id'];
                  } 
            }    
            else if($usertype == 2 && $role_id==13 )
           {
                $from .= " and h.created_by = ".$this->session->userdata['userid'];
           } 
           else if($usertype == 2 && $role_id==14 )
           {
                $from .= " and h.created_by = ".$this->session->userdata['userid'];
           } 
            if($role_id==16){
              $from .= "   and a.id = ".$userid; 
            }
                   
          if ($searchCond) {
            $from .= " and $searchCond";
          }

          if ($type == 'count') 
              $select = "count(DISTINCT(h.request_id)) as count "; 
          
          if ($pg >= 0 && $type <> 'count') { 
                 $from .= " GROUP BY a.id order by $sBy $sOrder limit $pg," . $limit;
          }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql); 
        return $query->result_array();
    }
    function check_submission($userid)
    {
        
        $count=0;
        $this->db->select('personal,education,employment,other_details,declaration');
        $this->db->join(DB_PREFIX.'client_request','request_id=candidate_request_id','left');
        $this->db->where('user_id',$userid);
        $results=$this->db->get(DB_PREFIX.'profile_status')->row_array();
        
        if(!empty($results))
        {
        $count=$results['personal'] + $results['education']  + $results['employment']  + $results['other_details'] + $results['declaration']; 
        }
        
        if($count==0) {
        $this->db->select('count(id) as cnt');
        $cond="submit_date != '0000-00-00 00:00:00' AND submit_date IS NOT NULL AND DATE_FORMAT(submit_date,'%Y-%m-%d') > '".date('Y-m-d')."'";
        $this->db->where('id',$userid);
        $this->db->where($cond);
        return $this->db->get(DB_PREFIX.'user')->row_array();
        }
        else
        {
        return array('cnt'=>1);
        }
        
    }
    function check_submission_new($userid)
    {
        $this->db->select('count(request_id) as cnt');
        $cond="deadline_to != '0000-00-00' AND deadline_to IS NOT NULL AND DATE_FORMAT(deadline_to,'%Y-%m-%d') >= '".date('Y-m-d')."'";
        $this->db->where('user_id',$userid);
        $this->db->where($cond);
        return $this->db->get(DB_PREFIX.'client_request')->row_array();
    }
    
    
    function checkprofilesubmit($userid)
    {
        $this->db->select('count(id) as cnt');
        $this->db->where('id',$userid);
        $this->db->where('profile_date_request >',0);
        return $this->db->get(DB_PREFIX.'user')->row_array();
    }
    function checkprofilesubmitcnt($userid)
    {
        $this->db->select('profile_date_request as cnt');
        $this->db->where('id',$userid);
       return $this->db->get(DB_PREFIX.'user')->row_array();
    }
    function insertprofilesubmit($userid,$cnt)
    {
        $cnts =$cnt +1;
        $cond="profile_date_request";
        $this->db->where('id',$userid);
        if($cnt==0)
        $this->db->set('submit_date',date('Y-m-d H:i:s',strtotime("3 weekdays")));
        $this->db->set('profile_date_request',$cnts);
         $this->db->update(DB_PREFIX.'user');
        
         $this->db->where('user_id',$userid);
        $this->db->set('deadline_to',date('Y-m-d',strtotime("3 weekdays")));
        return $this->db->update(DB_PREFIX.'client_request');
        
    }
    function updateprofilesubmit($userid)
    {
        $this->db->where('id',0);
        $this->db->set('profile_date_request',1);
        return $this->db->update(DB_PREFIX.'user');
    }
    function getprofilestatus($table,$field,$rid)
    {
        $this->db->select('count(id) as cnt ');
        $this->db->where($field,$rid);
        return $this->db->get(DB_PREFIX.$table)->row_array();
    
    }
    function get_verified_users ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 

                $select = "a.request_id,a.candidate_name,c.org_name,b.office_name,p.office_name as parent_office,e.order_name,a.assainee_status,a.deadline_to,f.first_name,f.last_name, c.dedicated_operator as oprid,client_status,operator_status,verification_status,a.dataentry_by,cv.reverted_by,o.office_name as sub_office,cv.reverted_reason,a.case_no,cv.deo_status,cv.deo_remarks ";
                        
                $from = "   FROM " . DB_PREFIX . "client_request a 
                JOIN " . DB_PREFIX . "organisation c ON c.id=a.organisation
              LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
              LEFT JOIN " . DB_PREFIX . "office p ON p.id=a.parent_office
              LEFT JOIN " . DB_PREFIX . "office b ON b.id=a.office
              LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
              
              LEFT JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=a.request_id
              LEFT JOIN " . DB_PREFIX . "user f ON f.id=cv.assignee_id
              JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3
                       where 1   AND client_status=1 AND operator_status=1 AND candidate_status=1 ";
                if ($searchCond) {
      $from .= " and $searchCond";
    }

                if ($type == 'count') $select = "count(*) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                       $from .= " order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
        function load_order_by_client($oid,$parent=0)
        {           
                
                $this->db->select('count(*) as cnt');
                $this->db->where('parent_office',$oid['parent_office']);
               $officecnt= $this->db->get(DB_PREFIX.'office')->row_array();
               
                
                $condition='';
                if(!empty($oid['parent_office']) && !empty($oid['office_id']) && !empty($oid['sub_office'])) {
                $condition="AND (of.id=".$oid['office_id']." AND pa.id=".$oid['parent_office']." AND sub.id=".$oid['sub_office'].")";
                }
                if(!empty($oid['parent_office']) && !empty($oid['office_id']) && empty($oid['sub_office']))
                $condition="AND (of.id=".$oid['office_id']." AND pa.id=".$oid['parent_office'].") AND o.sub_office=0";
                else if(!empty($oid['parent_office']) && empty($oid['office_id'])  && empty($oid['sub_office']) )
                $condition="AND (pa.id=".$oid['parent_office'].") AND o.office=0";

                $subcheck=array();
                if(!empty($condition)) { 
                $sql="SELECT md.id,md.name,md.key,ac.level FROM ".DB_PREFIX ."master_masterdata md 
                LEFT JOIN ".DB_PREFIX."add_check ac ON ac.types_of_check=md.id
                LEFT JOIN ".DB_PREFIX."order o ON o.id=ac.order_id and o.status=1";
                if(!empty($oid['parent_office']) && !empty($oid['office_id']) && !empty($oid['sub_office'])) {
                $sql .=" LEFT JOIN ".DB_PREFIX."office pa ON pa.id=o.parent_office
                LEFT JOIN ".DB_PREFIX."office of ON of.id=o.office
                LEFT JOIN ".DB_PREFIX."office sub ON sub.id=o.sub_office";
                }
                else if(!empty($oid['parent_office']) && !empty($oid['office_id']) && empty($oid['sub_office'])) {
                $sql .=" LEFT JOIN ".DB_PREFIX."office pa ON pa.id=o.parent_office
                LEFT JOIN ".DB_PREFIX."office of ON of.id=o.office";
                }
                else if(!empty($oid['parent_office']) && empty($oid['office_id']) && empty($oid['sub_office']))
                $sql .=" LEFT JOIN ".DB_PREFIX."office pa ON pa.id=o.parent_office  ";
                
                $sql .=" WHERE (md.key='Check' OR md.key='Package') AND md.parent=".$parent." ".$condition."  ORDER BY md.key ASC,md.seqid ASC";

                $result= $this->db->query($sql);
                $subcheck= $result->result_array();  
                }
                $condition='';
                $condition="AND (pa.id=".$oid['parent_office'].") AND o.office=0 AND o.sub_office=0";
                if(!empty($condition)) { 
                $sql="SELECT md.id,md.name,md.key FROM ".DB_PREFIX ."master_masterdata md 
                LEFT JOIN ".DB_PREFIX."add_check ac ON ac.types_of_check=md.id
                LEFT JOIN ".DB_PREFIX."order o ON o.id=ac.order_id and o.status=1";
                 
                $sql .=" LEFT JOIN ".DB_PREFIX."office pa ON pa.id=o.parent_office";
                $sql .=" LEFT JOIN ".DB_PREFIX."office of ON of.id=o.office";
                $sql .=" LEFT JOIN ".DB_PREFIX."office sub ON sub.id=o.sub_office";

                $sql .=" WHERE (md.key='Check' OR md.key='Package') AND md.parent=".$parent." ".$condition."  ORDER BY md.key ASC";

                $result= $this->db->query($sql);
                $paretncheck= $result->result_array();
                if(!empty($subcheck))
                return $subcheck;
                else
                return $paretncheck;
                
                }
                else
                return array();

                }
     function load_order_by_client_new($oid,$parent=0)
    {
           $sql="SELECT md.id,md.name FROM ".DB_PREFIX ."master_masterdata md 
           LEFT JOIN ".DB_PREFIX."add_check ac ON ac.types_of_check=md.id
           LEFT JOIN ".DB_PREFIX."order o ON o.id=ac.order_id
           LEFT JOIN ".DB_PREFIX."office of ON of.id=o.office
           WHERE md.key='Check' AND md.parent= ? ";
           
          $result= $this->db->query($sql,array($parent));
           return $result->result_array();
    }
    
    function get_currentstatus($id)
    {
        $this->db->select('client_status,operator_status,verification_status,cr.assignee_id,cr.revert_status,cr.service,cr.reason,cr.created_by,vr.team_mem_id,status,sc.vm_revert_option_status,vr.vm_revert_to,vm_revert_by,cr.vm_revert_supervisor,ur.role_id,cr.assainee_status,sc.reverted_by,sc.reverted_reason,sc.reason,qc_2_verification,qc2_report_publish,sc.status,group_concat(vr.verify_status) as vmstatus');
        $this->db->where('sc.request_id',$id);
       $this->db->join(DB_PREFIX.'ver_assign_rep vr','candidate_req_id=sc.request_id','left');
       $this->db->join(DB_PREFIX.'client_request cr','cr.request_id=sc.request_id','left');
       $this->db->join(DB_PREFIX.'users_roles ur','ur.user_id=cr.created_by','left');
       return  $this->db->get(DB_PREFIX.'submit_cv sc')->row_array();

    }
    function get_verifiedlevelstatus($id)
    {
     $sql="SELECT va.check_id,va.level_id,fielddata,qcfielddata,qc2fielddata,vr.candidate_name,vl.qc2_verification,vl.qc2_report_publish  FROM ".DB_PREFIX ."ver_assign_rep vl 
           LEFT JOIN ".DB_PREFIX."client_request vr ON vr.request_id=vl.candidate_req_id
           LEFT JOIN ".DB_PREFIX."verified_level va ON va.request_id=vl.candidate_req_id
           WHERE vl.candidate_req_id= ? ";
          $result= $this->db->query($sql,array($id));
           return $result->row_array();

         

    }
    function get_interimreport($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {
        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc2_status,vs.qc2_discrapancy,concat_ws(' - ',md2.name,md.name) as status,vl1.level_id,vl1.check_id,vl1.qc2_date,md1.name as checkname,ar.pack_id,o.org_name,d.office_name as parent_office,p.office_name as sub_office,cr.case_no,ar.count_of_chk as chk,vl1.supplementary";
                                 $from = "   FROM " . DB_PREFIX . "verification_request a 
                                 LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
                                 LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
                                 LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
                                 LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
                                 LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation
                                 LEFT JOIN " . DB_PREFIX . "office p ON p.id=cr.sub_office
                                  LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
                                 LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
                                 LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id
                                 LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=ar.candidate_req_id AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id
                                 LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id=vl1.qc2status
                                 LEFT JOIN " . DB_PREFIX . "master_masterdata md1 ON md1.id=vl1.check_id
                                 LEFT JOIN " . DB_PREFIX . "master_masterdata md2 ON md2.id=md.parent
                                 where 1  and a.assignee_status=1  AND ar.qc2_report_publish=1 ";
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        if($this->session->userdata('role_id')==2)
                $from .=" and b.organization=".$this->session->userdata('organization');
                if ($type == 'count') $select = "count(*) as count ";
                if ($pg >= 0 && $type <> 'count') { 
                        $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function get_level_name($request_id,$checkid,$levelid,$table='',$field='request_id',$select='degree')
        {
                $newselect='';
                if($checkid==14)
                    $newselect=",CONCAT_WS(' | ',collegename_add, affliated ) as details";
                if($checkid==16)
                $newselect=", permanent_address as details ";
                if($checkid==59)
                $newselect=",CONCAT_WS(' ',company_name,office_address ) as details ";
                
                $this->db->select('id,'.$select.' as level '.$newselect);
                $this->db->where('id',$levelid);
                $this->db->where($field,$request_id);
                if($table)
                return $this->db->get(DB_PREFIX.$table)->row_array();
        }
    function get_case($id)
        {
                $this->db->select('deadline_from,deadline_to,request_id');
                $this->db->where('user_id',$id);
                return $this->db->get(DB_PREFIX.'client_request')->row_array();
        }
     function get_verified_data($rid)
        {
                $this->db->select('vl.request_id,vl.qc2fielddata,qc2status,vl.qc2_dis');
                $this->db->join(DB_PREFIX.'ver_assign_rep vs','vs.candidate_req_id=vl.request_id and vs.check_id=vl.check_id and vs.level_id=vl.level_id');
                $this->db->where('vl.request_id',$rid);
                 $this->db->where('vs.qc2_report_publish',1);
                $this->db->where_in('vl.qc2status',array(111,519,110));
               return  $this->db->get(DB_PREFIX.'verified_level vl')->result_array();
        }   
/* export all cases list for admin login */
  function get_export_allcaselist($pg = 0, $limit = 10, $sBy = 'a.created_on', $sOrder = 'desc', $searchCond = '',$type='') {  
  $roleid= $this->session->userdata('role_id'); 
   $usertype= $this->session->userdata('user_type'); 
   
  
     if($sBy=='')
      $sBy='a.created_on';
                $select = "c.org_name, a.request_id, a.candidate_name, c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office, a.assainee_status,  concat_ws(' ', f.first_name, f.last_name) as first_name,f.id, a.created_on, a.dataentry_by, a.revert_status, a.service, a.reason,a.case_no,a.client_ref_number,ar.qc2_report_publish,rc.no_checks,a.final_report,a.report_status,a.final_report_published_date,a.case_recieved_date,cv.candidate_status,cv.client_verified,a.case_accepted_date,t.email,uc.telephone,a.billed,cv.client_submit_date, cv.candidate_submit_date,cv.des_rejected_date,a.supplement_report,a.supplement_report_date,a.supplement_report,t.status,t.type_of_employees , mr.name as payment_status  ";
                        
                    $from = "   FROM " . DB_PREFIX . "client_request a 
                      LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
                      LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
                      LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
                      LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                      LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                      LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by
                      JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3 and t.status != 2
                      LEFT JOIN " . DB_PREFIX . "user_contact_details uc ON uc.user_id = a.user_id
                      LEFT JOIN " . DB_PREFIX . "user_headoffices h ON h.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "user_branchoffices br ON br.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "user_suboffices so ON so.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=a.request_id
                      LEFT JOIN " . DB_PREFIX . "master_masterdata mr ON mr.id=a.payment_status
                      LEFT JOIN dcode_ver_assign_rep ar ON ar.candidate_req_id=a.request_id
                      LEFT JOIN dcode_verified_level vl ON vl.request_id=a.request_id 
                      LEFT JOIN dcode_request_check rc ON rc.request_id=a.request_id 
                      LEFT JOIN dcode_clientadditional_report ca ON ca.request_id=a.request_id and ca.status = 1  
                      where 1 ";
                $poffice=implode(",", $this->session->userdata['poffice'] );
                    $boffice=implode(",", $this->session->userdata['boffice'] );
                    $soffice=implode(",", $this->session->userdata['soffice'] );
                if($usertype == 2 && $roleid==12 )
                {

                  if(empty($boffice) and empty($soffice)){
                    $from .= " and a.parent_office in (".$poffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                    else if(!empty($boffice) and empty($soffice)){
                    $from .= " and a.parent_office in (".$poffice." ) and a.office in (".$boffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                  else{
                         $from .= " and a.parent_office in (".$poffice." ) and a.office in (".$boffice." ) and a.sub_office in (".$soffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                      }
                }    
                else if($usertype == 2 && $roleid==13 )
               {
                     if(empty($boffice) and empty($soffice)){
                    $from .= " and a.parent_office in (".$poffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                    else if(!empty($boffice) and empty($soffice)){
                    $from .= " and a.parent_office in (".$poffice." ) and a.office in (".$boffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                  else{
                         $from .= " and a.parent_office in (".$poffice." ) and a.office in (".$boffice." ) and a.sub_office in (".$soffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                      }                
                    $from .= " and ( a.dataentry_by = 3 or a.created_by = ".$this->session->userdata['userid']." ) ";
               } 
               else if($usertype == 2 && $roleid==14 )
               {
                    $from .= " and a.created_by = ".$this->session->userdata['userid'];
               } 
               else if($usertype == 1 && $roleid==21 )
                {
                    $from .= " and c.crm_userid = ".$this->session->userdata['userid']."  ";
                }
               else 
               {
                    $from .= " ";
               }      
    if ($searchCond) {
      $from .= " and $searchCond ";
    }

                if ($type == 'count') $select = " count(DISTINCT(a.request_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " GROUP BY a.request_id order by a.created_on desc ";
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }

     function get_userrevertlistdes ($pg = 0, $limit = 10, $sBy = 'request_id', $sOrder = 'desc', $searchCond = '',$type='') { 

                $select = "a.request_id,a.candidate_name,c.org_name,b.office_name,d.office_name as parent_office,e.order_name,a.assainee_status,a.deadline_to,f.first_name, c.dedicated_operator as oprid,dataentry_by,o.office_name as sub_office,cv.reverted_by,cv.reverted_reason,a.case_no,cv.client_submit_date";
                        
                $from = "   FROM " . DB_PREFIX . "client_request a 
                LEFT JOIN " . DB_PREFIX . "office d ON d.id=a.parent_office
                LEFT    JOIN " . DB_PREFIX . "office b ON b.id=a.office
                LEFT  JOIN " . DB_PREFIX . "organisation c ON c.id=a.organisation
              JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
              LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office 
              LEFT JOIN " . DB_PREFIX . "user f ON f.id=a.assignee_id
               JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3
              LEFT JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=a.request_id
                                where 1   AND client_status=1  and cv.reverted_reason !='' AND a.assainee_status != 1  ";
                        if($this->session->userdata['user_type'] == 2 ) {
                                $from .= "and (a.dataentry_by = 1  || a.dataentry_by = 3 )";
                        } else {
                                $from .= " and a.dataentry_by <> 3 ";
                        }
                         if($this->session->userdata['user_type'] == 1 &&  ($this->session->userdata['role_id'] == 3 || $this->session->userdata['role_id'] == 23 )) {
                                $from .= " and( a.assainee_status = 0 or ( a.dataentry_by = 1 and a.assignee_id=0 ))";
                        } 
    if ($searchCond) {
      $from .= " and $searchCond";
    }

                if ($type == 'count') $select = "count(*) as count "; 
                
                if ($pg >= 0 && $type <> 'count' && $_POST['export_btn'] !=="Export" ) { 
                       $from .= " order by $sBy $sOrder limit $pg," . $limit;
                }

               if($_POST['export_btn'] =="Export"){

                       $from .= " order by $sBy $sOrder";
               }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    /****************************************
     Ticket list history
     get_ticketlist
    ****************************************/
    function get_ticketlist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
   
         $roleid= $this->session->userdata('role_id'); 
         $usertype= $this->session->userdata('user_type'); 

          $select = "td.check_id,td.ticket_no,td.case_no,td.ticket_details,td.ticket_status,td.action_date, td.request_id,td.level_id,td.requested_date,td.revert_date,td.close_date,c.org_name, a.user_id, a.candidate_name,f.email, uc.telephone, c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office, m.name,rm.name as req_name, concat_ws(' ',us.first_name,us.last_name) as username, vr.count_of_chk as chk,vl1.qc2_dis,vl1.qc2status,pr.mobile";
                                
          $from = "   FROM " . DB_PREFIX . "client_request a 
              LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
              LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
              LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
              LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
              LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
              LEFT JOIN " . DB_PREFIX . "ticket_details td ON td.request_id=a.request_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=td.check_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata rm ON rm.id=td.request_reason_id
              LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=td.request_id and vr.check_id=td.check_id and vr.level_id=td.level_id
              LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=td.request_id and vl1.level_id=td.level_id and vl1.check_id=td.check_id            
              LEFT JOIN " . DB_PREFIX . "user f ON f.id=a.user_id
              LEFT JOIN " . DB_PREFIX . "user_contact_details uc ON uc.user_id=f.id
              LEFT JOIN " . DB_PREFIX . "user ft ON ft.id = a.created_by
              LEFT JOIN " . DB_PREFIX . "user us ON us.id=td.user_id
              LEFT JOIN " . DB_PREFIX . "personal_details pr ON pr.user_id=a.request_id
              JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3 and t.status != 2 
              WHERE td.request_id=a.request_id and td.current_status =1 and td.ticket_status !=5";


              $poffice=implode(",", $this->session->userdata['poffice'] );
              $boffice=implode(",", $this->session->userdata['boffice'] );
              $soffice=implode(",", $this->session->userdata['soffice'] );

              
              if($usertype == 2 && $roleid==12 )
              {
                  if(empty($boffice) and empty($soffice)){
                    $from .= " and a.parent_office in (".$poffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                  else if(!empty($boffice) and empty($soffice)){
                    $from .= " and a.parent_office in (".$poffice." ) and a.office in (".$boffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                  else{
                    $from .= " and a.parent_office in (".$poffice." ) and a.office in (".$boffice." ) and a.sub_office in (".$soffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
              }
              else if($usertype == 2 && $roleid==13 )
               {
                     if(empty($boffice) and empty($soffice)){
                    $from .= " and a.parent_office in (".$poffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                    else if(!empty($boffice) and empty($soffice)){
                    $from .= " and a.parent_office in (".$poffice." ) and a.office in (".$boffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                  else{
                         $from .= " and a.parent_office in (".$poffice." ) and a.office in (".$boffice." ) and a.sub_office in (".$soffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                      }                
                    $from .= " and ( a.dataentry_by = 3 or a.created_by = ".$this->session->userdata['userid']." ) ";
               } 
               else if($usertype == 2 && $roleid==14 )
               {
                    $from .= " and a.created_by = ".$this->session->userdata['userid'];
               }
               else if($usertype == 2 && $roleid==16 )
               {
                    $from .= " and a.user_id = ".$this->session->userdata['userid'];
               } 
               else if($usertype == 1 && $roleid==21 )
                {
                    $from .= " and c.crm_userid = ".$this->session->userdata['userid']."  ";
                }
               else 
               {
                    $from .= " ";
               }
                      
              if($searchCond){
                  $from .= " and $searchCond";
              }else{
                  $from .= " and td.ticket_status !=3 and td.ticket_status !=101 and td.ticket_status !=1";
              }

              if ($type == 'count') $select = "count(td.id) as count "; 
                
              if ($pg >= 0 && $type <> 'count') { 
                       $from .= " GROUP BY td.id order by $sBy $sOrder limit $pg," . $limit;
              }
        
          $sql = "SELECT " . $select . "" . $from;
          $query = $this->db->query($sql); 
          return $query->result_array();
         
    }

     /****************************************
     Ticket list history
     get_scrmticketlist
    ****************************************/
    function get_scrmticketlist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
   
       $roleid= $this->session->userdata('role_id'); 
       $usertype= $this->session->userdata('user_type'); 

          $select = "td.check_id,td.ticket_no,td.case_no,td.ticket_details,td.ticket_status,td.action_date, td.request_id,td.level_id,td.requested_date,td.revert_date,td.close_date,c.org_name, a.user_id, a.candidate_name, f.email, c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office, m.name,rm.name as req_name, concat_ws(' ',us.first_name,us.last_name) as username, vr.count_of_chk as chk,vl1.qc2_dis,vl1.qc2status";
                                
          $from = "   FROM " . DB_PREFIX . "client_request a 
              LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
              LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
              LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
              LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
              LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
              
              LEFT JOIN " . DB_PREFIX . "ticket_details td ON td.request_id=a.request_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=td.check_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata rm ON rm.id=td.request_reason_id
              LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=td.request_id and vr.check_id=td.check_id and vr.level_id=td.level_id 
              LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=td.request_id and vl1.level_id=td.level_id and vl1.check_id=td.check_id           
              LEFT JOIN " . DB_PREFIX . "user f ON f.id=a.user_id
              LEFT JOIN " . DB_PREFIX . "user us ON us.id=td.user_id
              JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3 and t.status != 2 WHERE td.request_id=a.request_id and td.current_status !=0 ";


             
              
              if ($searchCond == 'td.ticket_status =3') {
                  $from .= " and td.ticket_status =3";
              }else if($searchCond == 'td.ticket_status =101'){
                  $from .= " and td.ticket_status =101";
              }else if($searchCond == 'td.ticket_status =2'){
                  $from .= " and td.ticket_status =2";
              }else if($searchCond == 'td.ticket_status =4'){
                  $from .= " and td.ticket_status =4";
              }else if($searchCond){
                  $from .= " and $searchCond";
              }else{
                  $from .= " and td.ticket_status !=3 and td.ticket_status !=101 and td.ticket_status !=2 and td.ticket_status !=4";
              }

              if ($type == 'count') $select = "count(*) as count "; 
                
              if ($pg >= 0 && $type <> 'count') { 
                       $from .= " order by $sBy $sOrder limit $pg," . $limit;
              }
        
          $sql = "SELECT " . $select . "" . $from;
          $query = $this->db->query($sql); 
         return $query->result_array();
          
    }

    /*************** Get Ticket Details *************
    ********** function get_ticketdetail*************
    *************************************************/
    function get_ticketdetail($request_id,$check_id,$level_id){

      $roleid= $this->session->userdata('role_id'); 
      $usertype= $this->session->userdata('user_type'); 

      $select = "td.*,td.user_id as user_name,c.org_name, a.user_id, a.candidate_name, c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office, m.name,rm.name as req_name, concat_ws(' ',us.first_name,us.middle_name,us.last_name) as username, f.email, vr.count_of_chk as chk";
                                
          $from = "   FROM " . DB_PREFIX . "client_request a 
              LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
              LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
              LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
              LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
              LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
              LEFT JOIN " . DB_PREFIX . "ticket_details td ON td.request_id=a.request_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=td.check_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata rm ON rm.id=td.request_reason_id
              LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=td.request_id and vr.check_id=td.check_id and vr.level_id=td.level_id
              LEFT JOIN " . DB_PREFIX . "user us ON us.id=td.user_id
              LEFT JOIN " . DB_PREFIX . "user f ON f.id=a.user_id
              JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3 and t.status != 2 WHERE td.request_id='".$request_id."' and td.check_id='".$check_id."' and td.level_id='".$level_id."'";

          if($usertype == 2 && $roleid==12 )
          {
            $from .= " and td.ticket_status !=1 and td.ticket_status !=3 and td.ticket_status !=5";
          }else{
            $from .=" ";
          }
          $from .=" ORDER BY td.id DESC";

          $sql = "SELECT " . $select . "" . $from;
          $query = $this->db->query($sql);
          return $query->result_array();
    }

    /*************** Get Requested Document *************
    ********** function get_requested_doc*************
    *************************************************/
    function get_requested_doc($request_id,$check_id,$level_id){

      $this->db->select('*');
        $this->db->where('request_id',$request_id);
        $this->db->where('check_id',$check_id);
        $this->db->where('ref_id',$level_id);
        return $this->db->get(DB_PREFIX .'requested_additional_doc')->result_array();
    }


    function get_ticket_modifydetail($request_id,$check_id,$level_id){

      $select = "td.*,td.user_id as user_name,c.org_name, a.user_id, a.candidate_name, c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office, m.name,rm.name as req_name, concat_ws(' ',us.first_name,us.middle_name,us.last_name) as username, f.email, vr.count_of_chk as chk";
                                
          $from = "   FROM " . DB_PREFIX . "client_request a 
              LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
              LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
              LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
              LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
              LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
              
              LEFT JOIN " . DB_PREFIX . "ticket_details td ON td.request_id=a.request_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=td.check_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata rm ON rm.id=td.request_reason_id
              LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=td.request_id and vr.check_id=td.check_id and vr.level_id=td.level_id
              LEFT JOIN " . DB_PREFIX . "user us ON us.id=td.user_id
              LEFT JOIN " . DB_PREFIX . "user f ON f.id=a.user_id
              JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3 and t.status != 2 WHERE td.request_id='".$request_id."' and td.check_id='".$check_id."' and td.level_id='".$level_id."' and td.current_status=1";

          $sql = "SELECT " . $select . "" . $from;
          $query = $this->db->query($sql); 
          return $query->result_array();
    }


    /****************************************
     Ticket list history
     export_get_clientticket
    ****************************************/
    function export_get_clientticket($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
   
         // $roleid= $this->session->userdata('role_id'); 
         // $usertype= $this->session->userdata('user_type'); 

          $select = "td.check_id,td.ticket_no,td.case_no,td.ticket_details,td.ticket_status,td.action_date, td.request_id,td.level_id,td.requested_date,td.revert_date,td.close_date,c.org_name, a.user_id, a.candidate_name, f.email, uc.telephone, c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office, m.name,rm.name as req_name, concat_ws(' ',us.first_name,us.last_name) as username, vr.count_of_chk as chk,pr.mobile,vl1.qc2_dis,vl1.qc2status";
                                
          $from = "   FROM " . DB_PREFIX . "client_request a 
              LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
              LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
              LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
              LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
              LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
              
              LEFT JOIN " . DB_PREFIX . "ticket_details td ON td.request_id=a.request_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=td.check_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata rm ON rm.id=td.request_reason_id
              LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=td.request_id and vr.check_id=td.check_id and vr.level_id=td.level_id            
              LEFT JOIN " . DB_PREFIX . "user f ON f.id=a.user_id
              LEFT JOIN " . DB_PREFIX . "user_contact_details uc ON uc.user_id=f.id
              LEFT JOIN " . DB_PREFIX . "user us ON us.id=td.user_id
              LEFT JOIN " . DB_PREFIX . "personal_details pr ON pr.user_id=a.request_id
               LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=td.request_id and vl1.level_id=td.level_id and vl1.check_id=td.check_id
              JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3 and t.status != 2 WHERE td.request_id=a.request_id and td.current_status =1 ";


              $poffice=implode(",", $this->session->userdata['poffice'] );
              $boffice=implode(",", $this->session->userdata['boffice'] );
              $soffice=implode(",", $this->session->userdata['soffice'] );

              

                  if(empty($boffice) and empty($soffice)){
                    $from .= " and a.parent_office in (".$poffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                  else if(!empty($boffice) and empty($soffice)){
                    $from .= " and a.parent_office in (".$poffice." ) and a.office in (".$boffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                  else{
                    $from .= " and a.parent_office in (".$poffice." ) and a.office in (".$boffice." ) and a.sub_office in (".$soffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                      
              if($searchCond){
                  $from .= " and $searchCond";
              }else{
                  $from .= " and td.ticket_status !=3 and td.ticket_status !=101 and td.ticket_status !=1 and td.ticket_status !=5";
              }

              if ($type == 'count') $select = "count(*) as count "; 

              if($pg >= 0 && $type <> 'count'){ 
                $from .= " order by td.ticket_no desc ";
              }
        
          $sql = "SELECT " . $select . "" . $from;
          $query = $this->db->query($sql); 
          return $query->result_array();
    }


    /****************************************
     Ticket list history
     export_scrmticketlist
    ****************************************/
    function export_scrmticketlist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
$roleid= $this->session->userdata('role_id'); 
   $usertype= $this->session->userdata('user_type'); 
          $select = "td.check_id,td.ticket_no,td.case_no,td.ticket_details,td.ticket_status,td.action_date, td.request_id,td.level_id,td.requested_date,td.revert_date,td.close_date,c.org_name, a.user_id, a.candidate_name, f.email, c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office, m.name,rm.name as req_name, concat_ws(' ',us.first_name,us.last_name) as username, vr.count_of_chk as chk";
                                
          $from = "   FROM " . DB_PREFIX . "client_request a 
              LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
              LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
              LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
              LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
              LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
              
              LEFT JOIN " . DB_PREFIX . "ticket_details td ON td.request_id=a.request_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=td.check_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata rm ON rm.id=td.request_reason_id
              LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=td.request_id and vr.check_id=td.check_id and vr.level_id=td.level_id            
              LEFT JOIN " . DB_PREFIX . "user f ON f.id=a.user_id
              LEFT JOIN " . DB_PREFIX . "user us ON us.id=td.user_id
              JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3 and t.status != 2 WHERE td.request_id=a.request_id and td.current_status !=0 ";

              if ($searchCond == 'td.ticket_status =3') {
                  $from .= " and td.ticket_status =3";
              }else if($searchCond == 'td.ticket_status =101'){
                  $from .= " and td.ticket_status =101";
              }else if($searchCond == 'td.ticket_status =2'){
                  $from .= " and td.ticket_status =2";
              }else if($searchCond == 'td.ticket_status =4'){
                  $from .= " and td.ticket_status =4";
              }else if($searchCond){
                  $from .= " and $searchCond";
              }else{
                  $from .= " and td.ticket_status in(1, 5)";
              }

              if ($type == 'count') $select = "count(*) as count "; 
                
              if($pg >= 0 && $type <> 'count'){ 
                $from .= " order by td.ticket_no desc ";
              }
        
          $sql = "SELECT " . $select . "" . $from;
          $query = $this->db->query($sql); 
          return $query->result_array();
    }


    function get_payment_requestlist($pg = 0, $limit = 10, $sBy = 'pr.pr_id', $sOrder = 'desc', $searchCond = '',$type='') {  
            
            $select = "pr.pr_id,pr.request_id,pr.check_id,pr.level_id,pr.case_no,cr.candidate_name,c.org_name,m.name as check_name,pr.beneficiary_name,pr.beneficiary_location,pr.payment_mode,pm.pm_name,pr.requested_amount as amount, pm1.pm_name as paymode, pm2.pm_name as paystatus,pr.payment_status,pr.requested_date,pr.ref_branch_code as branchcode, pr.approved_date, pr.paid_date,pr.bank_name,pm3.pm_name as reason,pm4.pm_name as payto,pr.comments,pr.attachment,pr.initiated_on,pr.completed_on, concat_ws(' ',f.first_name,f.last_name) as requested_by, concat_ws(' ',u.first_name,u.last_name) as approved_by,prd.dd_no as dd_txn_no,prd.dd_no,prd.dd_date,prd.dd_charges,prd.chk_number,prd.chk_date,prn.neft_id,prn.neft_bank_name,prn.neft_account_type,prn.neft_reference_no,prn.neft_payment_date,prn.neft_trans_charge, vr.count_of_chk";
                        
                    $from = "   FROM " . DB_PREFIX . "payment_request pr 
                    LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = pr.request_id
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = pr.org_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=pr.check_id
                    LEFT JOIN " . DB_PREFIX . "payment_master pm ON pm.pm_id=pr.currency
                    LEFT JOIN " . DB_PREFIX . "payment_master pm1 ON pm1.pm_id=pr.payment_mode
                    LEFT JOIN " . DB_PREFIX . "payment_master pm2 ON pm2.pm_id=pr.payment_status
                    LEFT JOIN " . DB_PREFIX . "payment_master pm3 ON pm3.pm_id=pr.reason_payment
                    LEFT JOIN " . DB_PREFIX . "payment_master pm4 ON pm4.pm_id=pr.payment_to
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = pr.requested_by
                    LEFT JOIN " . DB_PREFIX . "user u ON u.id = pr.approved_by
                    LEFT JOIN " . DB_PREFIX . "payment_request_dd prd ON prd.pr_id =pr.pr_id
                    LEFT JOIN " . DB_PREFIX . "payment_request_neft prn ON prn.pr_id =pr.pr_id
                    LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=pr.request_id and vr.check_id=pr.check_id and vr.level_id=pr.level_id
                    where 1 ";

                    $roleid= $this->session->userdata('role_id');
                    if($roleid==5 || $roleid==27){
                        $from .= " and vr.team_mem_id = ".$this->session->userdata['userid'];
                    }
                    else if($roleid==9){
                        $from .= " and pr.payment_status = 31";
                    }
                    else 
                    {
                        $from .= " ";
                    }
               
                if ($searchCond) {
                    $from .= " and $searchCond";
                }else{
                    if($roleid==26){
                        $from .= " and pr.payment_status IN (32,34,35)";
                    }
                }
                    
                if ($pg >= 0 && $type <> 'count') { 
                    $from .= " order by pr.pr_id desc ";
                }
            
                $sql = "SELECT " . $select . "" . $from;
                $query = $this->db->query($sql);
                return $query->result_array();
    }

    //  April 15th
    function get_verified_data_with_checkid($rid)
    {
                $this->db->select('vl.request_id,vl.check_id,vl.qc2fielddata,qc2status,vl.qc2_dis');
                $this->db->join(DB_PREFIX.'ver_assign_rep vs','vs.candidate_req_id=vl.request_id and vs.check_id=vl.check_id and vs.level_id=vl.level_id');
                $this->db->where('vl.request_id',$rid);
                 $this->db->where('vs.qc2_report_publish',1);
                $this->db->where_in('vl.qc2status',array(111,519,110));
               return  $this->db->get(DB_PREFIX.'verified_level vl')->result_array();
    } 



    function export_kotakdd_list($pg = 0, $limit = 10, $sBy = 'pr.pr_id', $sOrder = 'desc', $searchCond = '',$type='') 
    {  
        
        $select = "pr.pr_id,pr.request_id,pr.check_id,pr.level_id,pr.case_no,cr.candidate_name,c.org_name,m.name as check_name,pr.beneficiary_name,pr.beneficiary_location,pr.payment_mode,pm.pm_name,pr.requested_amount as amount, pm1.pm_name as paymode, pm2.pm_name as paystatus,pr.payment_status,pr.requested_date,pr.ref_branch_code as branchcode, pr.approved_date, pr.paid_date,pr.bank_name,pm3.pm_name as reason,pm4.pm_name as payto,pr.comments,pr.attachment,pr.initiated_on,pr.completed_on, concat_ws(' ',f.first_name,f.last_name) as requested_by, concat_ws(' ',u.first_name,u.last_name) as approved_by,prd.prd_id,prd.dd_no as dd_txn_no,prd.dd_no,prd.dd_date,prd.dd_charges,prd.chk_number,prd.chk_date, vr.count_of_chk";
                        
                    $from = "   FROM " . DB_PREFIX . "payment_request pr 
                    LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = pr.request_id
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = pr.org_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=pr.check_id
                    LEFT JOIN " . DB_PREFIX . "payment_master pm ON pm.pm_id=pr.currency
                    LEFT JOIN " . DB_PREFIX . "payment_master pm1 ON pm1.pm_id=pr.payment_mode
                    LEFT JOIN " . DB_PREFIX . "payment_master pm2 ON pm2.pm_id=pr.payment_status
                    LEFT JOIN " . DB_PREFIX . "payment_master pm3 ON pm3.pm_id=pr.reason_payment
                    LEFT JOIN " . DB_PREFIX . "payment_master pm4 ON pm4.pm_id=pr.payment_to
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = pr.requested_by
                    LEFT JOIN " . DB_PREFIX . "user u ON u.id = pr.approved_by
                    LEFT JOIN " . DB_PREFIX . "payment_request_dd prd ON prd.pr_id =pr.pr_id
                    LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=pr.request_id and vr.check_id=pr.check_id and vr.level_id=pr.level_id
                    where 1 ";

                $roleid= $this->session->userdata('role_id');    
                if($roleid==5 || $roleid==27){
                    $from .= " and pr.bank_name like '%Kotak%' and vr.team_mem_id = ".$this->session->userdata['userid'];
                }
                else if($roleid==9){
                    $from .= "and pr.bank_name like '%Kotak%' ";
                }
                else 
                {
                    $from .= " ";
                }
               
                if ($searchCond) {
                    $from .= " and $searchCond and pr.bank_name like '%Kotak%'";
                }
                else{
                    if($roleid==26){
                        $from .= "and pr.bank_name like '%Kotak%' and pr.payment_status IN (32,34,38)";
                    }
                }

                // if ($type == 'count') $select = " count(DISTINCT(pr.request_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " order by pr.pr_id desc ";
                }
        
                $sql = "SELECT " . $select . "" . $from;
                $query = $this->db->query($sql);
                return $query->result_array();
    }


    function export_sbidd_list($pg = 0, $limit = 10, $sBy = 'pr.pr_id', $sOrder = 'desc', $searchCond = '',$type='') 
    {  
        
        $select = "pr.pr_id,pr.request_id,pr.check_id,pr.level_id,pr.case_no,cr.candidate_name,c.org_name,m.name as check_name,pr.beneficiary_name,pr.beneficiary_location,pr.payment_mode,pm.pm_name,pr.requested_amount as amount, pm1.pm_name as paymode, pm2.pm_name as paystatus,pr.payment_status,pr.requested_date,pr.ref_branch_code as branchcode, pr.approved_date, pr.paid_date,pr.bank_name,pm3.pm_name as reason,pm4.pm_name as payto,pr.comments,pr.attachment,pr.initiated_on,pr.completed_on, concat_ws(' ',f.first_name,f.last_name) as requested_by, concat_ws(' ',u.first_name,u.last_name) as approved_by,prd.prd_id,prd.dd_no as dd_txn_no,prd.dd_no,prd.dd_date,prd.dd_charges,prd.chk_number,prd.chk_date, vr.count_of_chk";
                        
                    $from = "   FROM " . DB_PREFIX . "payment_request pr 
                    LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = pr.request_id
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = pr.org_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=pr.check_id
                    LEFT JOIN " . DB_PREFIX . "payment_master pm ON pm.pm_id=pr.currency
                    LEFT JOIN " . DB_PREFIX . "payment_master pm1 ON pm1.pm_id=pr.payment_mode
                    LEFT JOIN " . DB_PREFIX . "payment_master pm2 ON pm2.pm_id=pr.payment_status
                    LEFT JOIN " . DB_PREFIX . "payment_master pm3 ON pm3.pm_id=pr.reason_payment
                    LEFT JOIN " . DB_PREFIX . "payment_master pm4 ON pm4.pm_id=pr.payment_to
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = pr.requested_by
                    LEFT JOIN " . DB_PREFIX . "user u ON u.id = pr.approved_by
                    LEFT JOIN " . DB_PREFIX . "payment_request_dd prd ON prd.pr_id =pr.pr_id
                    LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=pr.request_id and vr.check_id=pr.check_id and vr.level_id=pr.level_id
                    where 1 ";

                $roleid= $this->session->userdata('role_id');    
                if($roleid==5 || $roleid==27){
                    $from .= " and pr.bank_name like '%SBI%' and vr.team_mem_id = ".$this->session->userdata['userid'];
                }
                else if($roleid==9){
                    $from .= "and pr.bank_name like '%SBI%' ";
                }
                else 
                {
                    $from .= " ";
                }
               
                if ($searchCond) {
                    $from .= " and $searchCond and pr.bank_name like '%SBI%'";
                }
                else{
                    if($roleid==26){
                        $from .= "and pr.bank_name like '%SBI%' and pr.payment_status IN (32,34)";
                    }
                }

                // if ($type == 'count') $select = " count(DISTINCT(pr.request_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " order by pr.pr_id desc ";
                }
        
                $sql = "SELECT " . $select . "" . $from;
                $query = $this->db->query($sql);
                return $query->result_array();
    }


    function export_neft_request($pg = 0, $limit = 10, $sBy = 'pr.pr_id', $sOrder = 'desc', $searchCond = '',$type='') 
    {  
        
            $select = "pr.pr_id,pr.request_id,pr.check_id,pr.level_id,pr.case_no,cr.candidate_name,c.org_name,m.name as check_name,pr.beneficiary_name,pr.beneficiary_location,pr.payment_mode,pm.pm_name,pr.requested_amount as amount, pm1.pm_name as paymode, pm2.pm_name as paystatus,pr.payment_status,pr.requested_date,pr.ref_branch_code as branchcode, pr.approved_date, pr.paid_date,pr.bank_name,pm3.pm_name as reason,pm4.pm_name as payto,pr.comments,pr.attachment,pr.initiated_on,pr.completed_on, concat_ws(' ',f.first_name,f.last_name) as requested_by, concat_ws(' ',u.first_name,u.last_name) as approved_by,prn.neft_id,prn.neft_bank_name,prn.neft_account_type,prn.neft_reference_no,prn.neft_payment_date,prn.neft_trans_charge, vr.count_of_chk";
                        
                    $from = "   FROM " . DB_PREFIX . "payment_request pr 
                    LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = pr.request_id
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = pr.org_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=pr.check_id
                    LEFT JOIN " . DB_PREFIX . "payment_master pm ON pm.pm_id=pr.currency
                    LEFT JOIN " . DB_PREFIX . "payment_master pm1 ON pm1.pm_id=pr.payment_mode
                    LEFT JOIN " . DB_PREFIX . "payment_master pm2 ON pm2.pm_id=pr.payment_status
                    LEFT JOIN " . DB_PREFIX . "payment_master pm3 ON pm3.pm_id=pr.reason_payment
                    LEFT JOIN " . DB_PREFIX . "payment_master pm4 ON pm4.pm_id=pr.payment_to
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = pr.requested_by
                    LEFT JOIN " . DB_PREFIX . "user u ON u.id = pr.approved_by
                    LEFT JOIN " . DB_PREFIX . "payment_request_neft prn ON prn.pr_id =pr.pr_id
                    LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=pr.request_id and vr.check_id=pr.check_id and vr.level_id=pr.level_id
                    where 1 ";

                    $roleid= $this->session->userdata('role_id');
                    if($roleid==5 || $roleid==27){
                        $from .= "and pr.payment_mode=25 and vr.team_mem_id = ".$this->session->userdata['userid'];
                    }
                    else if($roleid==9){
                        $from .= "and pr.payment_mode=25 ";
                    }
                    else 
                    {
                        $from .= " ";
                    }
               
                if ($searchCond) {
                    $from .= " and $searchCond and pr.payment_mode=25";
                }else{
                    if($roleid==26){
                        $from .= " and pr.payment_mode=25 and pr.payment_status IN (32)";
                    }
                }

                // if ($type == 'count') $select = " count(DISTINCT(pr.request_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " order by pr.pr_id desc ";
                }
        
                $sql = "SELECT " . $select . "" . $from;
                $query = $this->db->query($sql);
                return $query->result_array();
    }



    function export_challan_request($pg = 0, $limit = 10, $sBy = 'pr.pr_id', $sOrder = 'desc', $searchCond = '',$type='') 
    {  
        
            $select = "pr.pr_id,pr.request_id,pr.check_id,pr.level_id,pr.case_no,cr.candidate_name,c.org_name,m.name as check_name,pr.beneficiary_name,pr.beneficiary_location,pr.payment_mode,pm.pm_name,pr.requested_amount as amount, pm1.pm_name as paymode, pm2.pm_name as paystatus,pr.payment_status,pr.requested_date,pr.ref_branch_code as branchcode, pr.approved_date, pr.paid_date,pr.bank_name,pm3.pm_name as reason,pm4.pm_name as payto,pr.comments,pr.attachment,pr.initiated_on,pr.completed_on, concat_ws(' ',f.first_name,f.last_name) as requested_by, concat_ws(' ',u.first_name,u.last_name) as approved_by,prc.chln_id,prc.pr_id,prc.chln_bank,prc.chln_journal_no,prc.chln_date,prc.chln_charges, vr.count_of_chk";
                        
                    $from = "   FROM " . DB_PREFIX . "payment_request pr 
                    LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = pr.request_id
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = pr.org_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=pr.check_id
                    LEFT JOIN " . DB_PREFIX . "payment_master pm ON pm.pm_id=pr.currency
                    LEFT JOIN " . DB_PREFIX . "payment_master pm1 ON pm1.pm_id=pr.payment_mode
                    LEFT JOIN " . DB_PREFIX . "payment_master pm2 ON pm2.pm_id=pr.payment_status
                    LEFT JOIN " . DB_PREFIX . "payment_master pm3 ON pm3.pm_id=pr.reason_payment
                    LEFT JOIN " . DB_PREFIX . "payment_master pm4 ON pm4.pm_id=pr.payment_to
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = pr.requested_by
                    LEFT JOIN " . DB_PREFIX . "user u ON u.id = pr.approved_by
                    LEFT JOIN " . DB_PREFIX . "payment_request_challan prc ON prc.pr_id =pr.pr_id
                    LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=pr.request_id and vr.check_id=pr.check_id and vr.level_id=pr.level_id
                    where 1 ";

                    $roleid= $this->session->userdata('role_id');
                    if($roleid==5 || $roleid==27){
                        $from .= "and pr.payment_mode=22 and vr.team_mem_id = ".$this->session->userdata['userid'];
                    }
                    else if($roleid==9){
                        $from .= "and pr.payment_mode=22 ";
                    }
                    else 
                    {
                        $from .= " ";
                    }
               
                if ($searchCond) {
                    $from .= " and $searchCond and pr.payment_mode=22";
                }else{
                    if($roleid==26){
                        $from .= " and pr.payment_mode=22 and pr.payment_status IN (32,34)";
                    }
                }

                // if ($type == 'count') $select = " count(DISTINCT(pr.request_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " order by pr.pr_id desc ";
                }
        
                $sql = "SELECT " . $select . "" . $from;
                $query = $this->db->query($sql);
                return $query->result_array();
    }

    function export_card_request($pg = 0, $limit = 10, $sBy = 'pr.pr_id', $sOrder = 'desc', $searchCond = '',$type='') 
    {  
        
            $select = "pr.pr_id,pr.request_id,pr.check_id,pr.level_id,pr.case_no,cr.candidate_name,c.org_name,m.name as check_name,pr.beneficiary_name,pr.beneficiary_location,pr.payment_mode,pm.pm_name,pr.requested_amount as amount, pm1.pm_name as paymode, pm2.pm_name as paystatus,pr.payment_status,pr.requested_date,pr.ref_branch_code as branchcode, pr.approved_date, pr.paid_date,pr.bank_name,pm3.pm_name as reason,pm4.pm_name as payto,pr.comments,pr.attachment,pr.initiated_on,pr.completed_on, concat_ws(' ',f.first_name,f.last_name) as requested_by, concat_ws(' ',u.first_name,u.last_name) as approved_by,pc.cr_id,pc.pr_id,pc.cr_card_type,pc.cr_transaction_no,pc.cr_transaction_date,pc.cr_transaction_charge, vr.count_of_chk";
                        
                    $from = "   FROM " . DB_PREFIX . "payment_request pr 
                    LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = pr.request_id
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = pr.org_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=pr.check_id
                    LEFT JOIN " . DB_PREFIX . "payment_master pm ON pm.pm_id=pr.currency
                    LEFT JOIN " . DB_PREFIX . "payment_master pm1 ON pm1.pm_id=pr.payment_mode
                    LEFT JOIN " . DB_PREFIX . "payment_master pm2 ON pm2.pm_id=pr.payment_status
                    LEFT JOIN " . DB_PREFIX . "payment_master pm3 ON pm3.pm_id=pr.reason_payment
                    LEFT JOIN " . DB_PREFIX . "payment_master pm4 ON pm4.pm_id=pr.payment_to
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = pr.requested_by
                    LEFT JOIN " . DB_PREFIX . "user u ON u.id = pr.approved_by
                    LEFT JOIN " . DB_PREFIX . "payment_request_card pc ON pc.pr_id =pr.pr_id
                    LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=pr.request_id and vr.check_id=pr.check_id and vr.level_id=pr.level_id
                    where 1 ";

                    $roleid= $this->session->userdata('role_id');
                    if($roleid==5 || $roleid==27){
                        $from .= "and pr.payment_mode=23 and vr.team_mem_id = ".$this->session->userdata['userid'];
                    }
                    else if($roleid==9){
                        $from .= "and pr.payment_mode=23 ";
                    }
                    else 
                    {
                        $from .= " ";
                    }
               
                if ($searchCond) {
                    $from .= " and $searchCond and pr.payment_mode=23";
                }else{
                    if($roleid==26){
                        $from .= " and pr.payment_mode=23 and pr.payment_status IN (32)";
                    }
                }

                // if ($type == 'count') $select = " count(DISTINCT(pr.request_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " order by pr.pr_id desc ";
                }
        
                $sql = "SELECT " . $select . "" . $from;
                $query = $this->db->query($sql);
                return $query->result_array();
    }


    function export_online_request($pg = 0, $limit = 10, $sBy = 'pr.pr_id', $sOrder = 'desc', $searchCond = '',$type='') 
    {  
        
            $select = "pr.pr_id,pr.request_id,pr.check_id,pr.level_id,pr.case_no,cr.candidate_name,c.org_name,m.name as check_name,pr.beneficiary_name,pr.beneficiary_location,pr.payment_mode,pm.pm_name,pr.requested_amount as amount, pm1.pm_name as paymode, pm2.pm_name as paystatus,pr.payment_status,pr.requested_date,pr.ref_branch_code as branchcode, pr.approved_date, pr.paid_date,pr.bank_name,pm3.pm_name as reason,pm4.pm_name as payto,pr.comments,pr.attachment,pr.initiated_on,pr.completed_on, concat_ws(' ',f.first_name,f.last_name) as requested_by, concat_ws(' ',u.first_name,u.last_name) as approved_by,po.op_id,po.pr_id,po.op_mobile_no,po.op_transaction_no,po.op_transaction_date,po.op_transaction_charge, vr.count_of_chk";
                        
                    $from = "   FROM " . DB_PREFIX . "payment_request pr 
                    LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = pr.request_id
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = pr.org_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=pr.check_id
                    LEFT JOIN " . DB_PREFIX . "payment_master pm ON pm.pm_id=pr.currency
                    LEFT JOIN " . DB_PREFIX . "payment_master pm1 ON pm1.pm_id=pr.payment_mode
                    LEFT JOIN " . DB_PREFIX . "payment_master pm2 ON pm2.pm_id=pr.payment_status
                    LEFT JOIN " . DB_PREFIX . "payment_master pm3 ON pm3.pm_id=pr.reason_payment
                    LEFT JOIN " . DB_PREFIX . "payment_master pm4 ON pm4.pm_id=pr.payment_to
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = pr.requested_by
                    LEFT JOIN " . DB_PREFIX . "user u ON u.id = pr.approved_by
                    LEFT JOIN " . DB_PREFIX . "payment_request_online po ON po.pr_id =pr.pr_id
                    LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=pr.request_id and vr.check_id=pr.check_id and vr.level_id=pr.level_id
                    where 1 ";

                    $roleid= $this->session->userdata('role_id');
                    if($roleid==5 || $roleid==27){
                        $from .= "and pr.payment_mode=26 and vr.team_mem_id = ".$this->session->userdata['userid'];
                    }
                    else if($roleid==9){
                        $from .= "and pr.payment_mode=26 ";
                    }
                    else 
                    {
                        $from .= " ";
                    }
               
                if ($searchCond) {
                    $from .= " and $searchCond and pr.payment_mode=26";
                }else{
                    if($roleid==26){
                        $from .= " and pr.payment_mode=26 and pr.payment_status IN (32)";
                    }
                }

                // if ($type == 'count') $select = " count(DISTINCT(pr.request_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " order by pr.pr_id desc ";
                }
        
                $sql = "SELECT " . $select . "" . $from;
                $query = $this->db->query($sql);
                return $query->result_array();
    }











        
}
