<?php
class dadmin_model extends CI_Model {

   //Constuctor
    function __construct() 
    {
        parent::__construct();
        $this->load->database();

    }
    function get_userlist ($pg = 0, $limit = 10, $sBy = 'id', $sOrder = 'desc', $searchCond = '',$type='') { 

       
                $select = "b.id,e.role_name, concat_ws(' ',b.first_name,b.middle_name,b.last_name) as name, 
                        d.name as gender,b.username ,g.office_name ";
        
                $from = "   FROM " . DB_PREFIX . "client_request a 
                                JOIN " . DB_PREFIX . "user b on b.id = a.user_id 
                                LEFT JOIN " . DB_PREFIX . "master_masterdata d ON d.id = b.gender
                    LEFT JOIN " . DB_PREFIX . "office g ON g.id = b.office_id
                    LEFT JOIN " . DB_PREFIX . "role_types e ON e.id = b.role_id
                            where 1  and b.active_status <>3 ";
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }

                if ($type == 'count') $select = "count(*) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                       $from .= " order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    
    function get_organisation_checks($user_id) {
        $sql = "SELECT b.id as user_id, concat_ws(' ',b.first_name,b.middle_name,b.last_name) as name, a.id as order_id
                FROM " . DB_PREFIX ."order a 
                LEFT JOIN " . DB_PREFIX ."user b on b.parentoffice_id = a.organisation
                WHERE b.id = ? order by a.updated_on desc, a.created_on desc limit 0,1 ";
        $query = $this->db->query( $sql, array( $user_id ) );
        return $query->result_array();
    }
    
        function get_config_checks($order_id){
                $sql = "SELECT b.name as check_name,a.order_id, a.types_of_check
                        FROM " . DB_PREFIX ."add_check a 
                        LEFT JOIN " . DB_PREFIX ."master_masterdata b on b.id = a.types_of_check 
                        WHERE a.order_id = ? and status =1 group by a.types_of_check order by a.types_of_check asc";
                $query = $this->db->query( $sql, array( $order_id ) );
                return $query->result_array();
        }    

        function get_config_checklevels($types_of_check,$order_id,$user_id){
                $sql = "SELECT b.name as check_name, a.types_of_check as order_id, level as types_of_check
                        FROM " . DB_PREFIX ."add_check a 
                        JOIN " . DB_PREFIX ."master_masterdata b on b.id = a.level
                        LEFT JOIN " . DB_PREFIX ."profile_level_status d on d.check_level_id  = a.level
                        LEFT JOIN " . DB_PREFIX ."client_request c on c.request_id  = d.client_request_id
                        WHERE a.types_of_check = ? and a.order_id = ? and c.user_id = ? and status =1 order by a.types_of_check asc";
                $query = $this->db->query( $sql, array( $types_of_check,$order_id,$user_id ) );
                return $query->result_array();
        } 
        
        function get_checks_details( $user_id ){

                $sql = "SELECT b.check_level_id 
                        FROM " . DB_PREFIX ."client_request a 
                        join  " . DB_PREFIX ."profile_level_status b on b.client_request_id = a.request_id
                        WHERE a.user_id = ? ";
                $query = $this->db->query( $sql, array( $user_id ) );
                return $query->result_array();
                
        }
        
        function get_assignee_list($id='') {
        
        if($id<>'')
        $cond="r.role_id = $id ";
        else
        $cond="r.role_id = '2' ";
        
                $sql = "SELECT c.id as assignee_id, concat_ws(' ', first_name,middle_name,last_name) as name
                        FROM " . DB_PREFIX ."organisation a 
                        left join " . DB_PREFIX ."user c on c.organization = a.id
                        left join " . DB_PREFIX ."users_roles r on r.user_id = c.id
                        WHERE a.user_type = 1 and c.status = 1 and ".$cond." ";
                $query = $this->db->query( $sql );
                return $query->result_array();
        }
        function get_assignes_list($id='') {
        if($id<>'')
        $cond="r.role_id = $id ";
        else
        $cond="r.role_id = '9' ";
        
                $sql = "SELECT c.id as assignee_id, concat_ws(' ', first_name,middle_name,last_name) as name
                        FROM " . DB_PREFIX ."organisation a 
                        left join " . DB_PREFIX ."user c on c.organization = a.id
                        left join " . DB_PREFIX ."users_roles r on r.user_id = c.id
                        WHERE a.user_type = 1 and c.status = 1 and ".$cond." ";
                $query = $this->db->query( $sql );
                return $query->result_array();
        }
         function get_revert_list($id='') {
        
        if($id<>'')
        $cond="r.role_id = $id ";
        else
        $cond="r.role_id = '12' ";
        
                $sql = "SELECT c.id as assignee_id, concat_ws(' ', first_name,middle_name) as name
                        FROM " . DB_PREFIX ."organisation a 
                        left join " . DB_PREFIX ."user c on c.organization = a.id
                        left join " . DB_PREFIX ."users_roles r on r.user_id = c.id
                        WHERE a.user_type = 2 and c.status = 1 and ".$cond." ";
                $query = $this->db->query( $sql );
                return $query->result_array();
        }
        
    function get_alottedlist ($pg = 0, $limit = 10, $sBy = 'id', $sOrder = 'desc', $searchCond = '',$type='') { 

                $session_userid = $this->session->userdata['userid'];
       
                $select = "a.id,e.role_name, concat_ws(' ',a.first_name,a.middle_name,a.last_name) as name, 
                        d.name as gender,a.username ,g.office_name,a.photo ";
        
                $from = "   FROM " . DB_PREFIX . "user a 
                                JOIN " . DB_PREFIX . "client_request b on b.user_id = a.id
                                LEFT JOIN " . DB_PREFIX . "master_masterdata d ON a.gender=d.id
                    LEFT JOIN " . DB_PREFIX . "office g ON g.id=a.office_id
                    LEFT JOIN " . DB_PREFIX . "role_types e ON e.id=a.role_id
                            where 1  and a.active_status <>3 and b.assignee_id = ".$session_userid;
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }

                if ($type == 'count') $select = "count(*) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                       $from .= " order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function getleveldetails($request_id,$check_id=false)    {
        $this->db->select('a.request_id,d.name as level_name,c.name as check_name,ac.level,d.id as check_level_id')
                ->from(DB_PREFIX .'client_request a')
                ->join(DB_PREFIX .'add_check as ac','ac.order_id = a.order_id')
                ->join(DB_PREFIX .'master_masterdata as c','c.id = ac.types_of_check')
                ->join(DB_PREFIX .'master_masterdata as d' ,'d.id = ac.level','left');
                if($check_id)
                $this->db->where('c.id',$check_id);
                $this->db->where('a.request_id',$request_id);
            return $this->db->get()->result_array();
    }
        
        function getonlineleveldetails($request_id)    {
               $this->db->select('a.request_id,b.check_level_id,c.name as level_name,d.name as check_name,b.profilelevel_id as profile_id,d.function_name,c.ref_id')->from(DB_PREFIX .'client_request a')->join(DB_PREFIX .'profile_level_status as b','b.client_request_id = a.request_id')
                       ->join(DB_PREFIX .'master_masterdata as c','c.id=b.check_level_id')->join(DB_PREFIX .'master_masterdata as d' ,'d.id=c.ref_id')->where('a.request_id',$request_id);
                   return $this->db->get()->result_array();

        }
        function employementdetails($request_id)   {

                $this->db->select('a.id,m.name as title,a.firstname,middlename,lastname,father_name,husband_name,a.date_of_birth,
                ma.name as gender,a.primary_skill,a.passport,a.passport_expire,a.place_of_issue,a.date_of_issue,
                a.nationality,a.SSN,company_name,office_address,branch_address,telephone_no,employment,agency_name,agency_address,
                agency_number,employee_code,last_designation,last_department,period_from,period_to,
                manager_name,manager_designation,email_id,contact_no,salary,reason,reference,edocustatus,employement_file,edocument_remarks,
                relieve_status,relieve_document,relieve_remarks,service_status,service_document,service_remarks')
                ->from(DB_PREFIX . 'employment as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->where('a.req_id', $request_id);
                return $this->db->get()->result_array();
        }
        function leveldetails($level,$request_id)    {
                $this->db->select('m.name as title,a.firstname,middlename,lastname,father_name,husband_name,a.date_of_birth,
                ma.name as gender,date_of_birth,a.id,a.degree,collegename_add,a.affliated, 
                period_from,period_to, 
                a.roll,a.reason1,year_of_passing,specialization,a.collegename_add_a,a.affliated_add,
                docustatus,document_remarks,document_file,grade_status,gdocument,grade_remarks,provisional_status,pdocument,provisional_remarks,consolidate_doc')
                ->from(DB_PREFIX . 'education_details as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->where('a.request_id', $request_id);
                return $this->db->get()->result_array();
        }
        function documentsup($req_id)
    {
        $this->db->select('a.req_id,a.upload_file,a.file_name')
                ->from(DB_PREFIX . 'candidate_upload_files as a')
                ->where('a.req_id', $req_id);
                return $this->db->get()->result_array();
    }
    
        function contactdetails($level,$request_id)    {
            
                $this->db->select('a.id,a.request_id,m.name as title,a.firstname,middlename,lastname,father_name,husband_name,ma.name as gender,permanent_address,
                period_of_stay,pincode,landmark,permanent_tel_no,office_tel_no,mobile,current_address,
                cperiod_of_stay,cpincode,clandmark,current_tel_no,
                coffice_tel_no,cmobile,md.name as address_prooft,address_proof')
                ->from(DB_PREFIX . 'contact_details as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->join(DB_PREFIX.'master_masterdata md','md.id=a.address_proof_type','left')
                ->where('a.request_id', $request_id);
                return $this->db->get()->result_array();
        }
        
        function personaldetails($request_id)   {
            
                $this->db->select('m.name as title,  a.firstname,middlename,lastname,father_name,husband_name,a.date_of_birth,mar.name as martial ,other_details_marital as marital_details,other_details_gender as gender_details,a.primary_skill,
                a.experience,a.experience_month,a.passport,a.passport_expire, 
                a.place_of_issue,a.date_of_issue,a.license_no,a.valid_up_to,a.nationality,a.current_stay_flag,a.SSN,permanent_address,
                period_of_stay,current_address,cperiod_of_stay,current_tel_no,permanent_tel_no,office_tel_no,mobile,alternate_contact,relationship,email_id,alter_email_id,user_image,a.upload_doc,photo_insuff')
                ->from(DB_PREFIX . 'personal_details as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype mar','mar.id=a.marital','left')
                ->where('a.user_id', $request_id);
                return  $this->db->get()->result_array();

        }
        
        function status_change( $request_id )     {

                
                $this->db->query("UPDATE " . DB_PREFIX . "client_request SET entry_status = 1  WHERE `request_id` = ".$request_id );
        $upd_data['request_id']= $request_id;
                $this->db->insert ( DB_PREFIX .'verification_request', $upd_data );
        $upd_data['request_id']= $request_id;
                $this->db->insert ( DB_PREFIX .'verification_status', $upd_data );
                redirect('' . base_url( 'Dadmin/dadminview/'.base64_encode( $request_id ) ));
        }
        
        function declerationdetails($request_id)  {
                $this->db->select('b.declaration  as comdecdet,b.declaration_name as comdecnam ,c.declaration_name as usedecnam,c.declaration  as usedecdet,a.company_decl_doc,a.user_decl_doc,authorization_insuff,a.user_declr,a.updated_on,c.documentation as user_declaration,c.doc_type,a.auth_letter_understood')
                ->from(DB_PREFIX . 'declaration_details as a')
        ->join(DB_PREFIX . 'company_decl as b','b.id=a.company_declr')
        ->join(DB_PREFIX . 'company_decl as c', 'c.id=a.user_declr')
                ->where('a.user_id', $request_id);
                return $this->db->get()->result_array();
        }
        
        function otherdetails($request_id)     {
                $this->db->select('a.agreement,a.criminal,a.bankrupt,a.civil,a.company,a.agre_text,a.crim_text,a.bank_text,a.civil_text,a.company_text')
                ->from(DB_PREFIX . 'other_details as a')
                ->where('a.user_id', $request_id);
                return $this->db->get()->result_array();
        }
        
        function getstatus($request_id)        {
                $this->db->select('a.entry_status')
                ->from(DB_PREFIX . 'client_request as a')
                ->where('a.request_id', $request_id);
                return $this->db->get()->result_array();
        }
        
        function getrequestid($user_id)        {
                 $this->db->select('a.request_id')
                ->from(DB_PREFIX . 'client_request as a')
                ->where('a.user_id', $user_id);
                return $this->db->get()->result_array();
         }
         
        function orderdetails($order)        {
                $this->db->select('a.check_id,b.name as checkname,c.name as levelname')
                ->from(DB_PREFIX . 'add_check as a')
                ->join(DB_PREFIX . 'master_masterdata as b', 'b.id=a.types_of_check')
                ->join(DB_PREFIX . 'master_masterdata as c', 'c.id=a.level')
                ->where('a.order_id', $order);
                return $this->db->get()->result_array();
        
        }
        function get_userlistoffsuper ($request_id) { 

       
                $select = "a.request_id,a.candidate_name,a.case_no,a.client_ref_number,dataentry_by";
                        
                                 $from = " FROM " . DB_PREFIX . "client_request a 
                                 where 1  and a.request_id=".$request_id;
                   
               
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function get_hrlist($request_id){
       $select = "a.request_id,b.first_name,c.org_name,b.email";
                        
                                 $from = " FROM " . DB_PREFIX . "client_request a 
                                 LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.created_by
                                 LEFT JOIN " . DB_PREFIX . "organisation c ON c.id=a.organisation
                                 where 1  and a.request_id=".$request_id;
                   
               
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->row_array(); 
    }
    function get_revertlistofsuper ($request_id) { 

       
                $select = "a.request_id,a.reason";
                        
                                 $from = "   FROM " . DB_PREFIX . "client_request a 
                                 where 1  and a.request_id=".$request_id;
                   
               
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    //supervisor reject case
    function get_rejectlistofsuper ($request_id) { 

       
                $select = "a.request_id,a.reverted_reason";
                        
                                 $from = "   FROM " . DB_PREFIX . "submit_cv a 
                                 where 1  and a.request_id=".$request_id;
                   
               
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    
    function get_allotted_list ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 

                $select = "a.request_id,a.candidate_name,c.org_name,b.office_name,d.parent,d.office_name as parent_office,
                e.order_name,a.assainee_status,a.assignee_id,a.deadline_to,f.first_name, c.dedicated_operator as oprid, 
                concat_ws(' ',f.first_name,f.last_name) as assignee,a.entry_status,a.revert_status,cv.revert_option_status,cv.operator_status,o.office_name as sub_office,cv.vm_revert_option_status,a.service,a.reason,a.case_no,a.dataentry_by,cv.operator_submit_date,a.deadline_from,a.final_report ,a.payment_status , mr.name as pay_status,a.client_ref_number";
                        
                $from = "  FROM " . DB_PREFIX . "client_request a 
                                LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office
                                LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
                                LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
                                LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                                LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office 
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id=a.assignee_id
                     JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3
                    LEFT JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=a.request_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata mr ON mr.id = a.payment_status
                                where 1  and  client_status=1 and a.assignee_id != 0 ";
                                if($this->session->userdata['role_id'] == 2) {
                $from .= " and a.assignee_id = ".$this->session->userdata['userid']."  ";
                }
                 if($this->session->userdata['user_type'] == 1 &&  $this->session->userdata['role_id'] == 2) {
                                $from .= " and (cv.operator_status = 0 || a.entry_status !=1 || cv.vm_revert_option_status=1 || cv.candidate_status=0 ) ";
                        }     
        if ($searchCond) {
            $from .= " and $searchCond ";
        }
                /*if ($type == 'count') $select = "count(*) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                       $from .= " order by $sBy $sOrder limit $pg," . $limit;
                }*/
                 if(!$_GET['export'] ){
                  
                  if ($type == 'count') $select = "count(*) as count "; 
                if ($pg >= 0 && $type <> 'count') { 
                       $from .= " order by $sBy $sOrder limit $pg," . $limit;
                }
            }
            else
            {
            $from .= " order by a.request_id  $sOrder ";

            }

        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }


    function submittoclient($request_id)
    {
    
    if($_POST) {
            $this->db->select('request_id,client_verified')
                ->where('request_id',$request_id);
        $submit=$this->db->get(DB_PREFIX.'submit_cv')->row_array(); 
        if($request_id==$submit['request_id'] && $submit['client_verified']==2){
              $this->db->query("UPDATE " . DB_PREFIX . "submit_cv SET status = 1, operator_status = 0,client_status=0, reverted_by = 0,client_verified=3 WHERE `request_id` = ".$request_id );
            }
            else if($request_id==$submit['request_id']){
              $this->db->query("UPDATE " . DB_PREFIX . "submit_cv SET status = 1, operator_status = 0,client_status=0, reverted_by = 0 WHERE `request_id` = ".$request_id );
            }
            else{ $this->db->insert('dcode_submit_cv',array('request_id'=>$request_id,'status'=>1,'candidate_submit_date'=>date ( 'Y-m-d H:i:s')));}
              redirect('' . base_url( 'Dadmin/dadminview/'.base64_encode( $request_id ) ), 'refresh');
              
        }
        
    }
    function submittoclients($request_id)
    {
    if($_POST) {
            $this->db->select('request_id')
                ->where('request_id',$request_id);
        $submit=$this->db->get(DB_PREFIX.'submit_cv')->row_array();
        if($request_id==$submit['request_id']){
              $this->db->query("UPDATE " . DB_PREFIX . "submit_cv SET status = 1,client_status=0,revert_option_status =0 WHERE `request_id` = ".$request_id );
            }
            else{ $this->db->insert('dcode_submit_cv',array('request_id'=>$request_id,'status'=>1));}
              redirect('' . base_url( 'Dadmin/dadminview/'.base64_encode( $request_id ) ));
    }
    }
    function reverttoadmin($request_id,$service,$reason)
    {

         $this->db->select("c.dataentry_by,a.first_name as cname,o.org_name,a.email as clientemail,ca.email as candemail,ca.first_name as candname,c.candidate_name,c.client_ref_number,ca.id as userid")
        ->where('request_id',$request_id);
            $this->db->join(DB_PREFIX.'user a','a.id=c.created_by','left');
            $this->db->join(DB_PREFIX.'user ca','ca.id=c.user_id','left');
            $this->db->join(DB_PREFIX.'organisation o','o.id=ca.organization','left');
        $data['candidatelist']=$candidatelist=$this->db->get(DB_PREFIX.'client_request c')->row_array();
        if($candidatelist['dataentry_by']==0){
            $data['service']=$service;
            $data['reason']=$reason[0];
            send_email_candidaterevert('revert_candidate','Your Background Verification form has been reverted by '.$candidatelist['org_name'].' Kindly update details',@$candidatelist['candemail'],@$candidatelist, $data);
        }
    $this->db->select('request_id')
                ->where('request_id',$request_id);
        $submits=$this->db->get(DB_PREFIX.'submit_cv')->row_array();
        if($request_id==$submits['request_id']){
    $this->db->query("UPDATE " . DB_PREFIX . "submit_cv SET `service` ='" .implode($service). "',`reason`='" . implode($reason) . "' WHERE `request_id` = ".$request_id );
}else{
$this->db->insert('dcode_submit_cv', array('service'=>implode(',', $service),'reason'=>implode(',', $reason),'request_id'=>$request_id));
}

    if($_POST) {
  $this->db->query("UPDATE " . DB_PREFIX . "submit_cv SET status = 0,client_verified = 2  WHERE `request_id` = ".$request_id );
    $user['submit_date']=date('Y-m-d H:i:s',strtotime("5 weekdays"));                   
    $user['status'] = 1;
    $this->db->where('id',$candidatelist['userid']);
    $this->db->update ( DB_PREFIX .'user', $user );
        }

redirect('' . base_url( 'Dadmin/dadminview/'.base64_encode( $request_id ) ),'refresh');
    }
    function reverttologadmin($request_id){
                $inslog_data['action']='Revert to Admin';                    
                $inslog_data['updated_on'] = date ( 'Y-m-d H:i:s' );
                $this->db->where('request_id',$request_id);
                $this->db->update ( DB_PREFIX .'loghistory', $inslog_data );
    }
    function submitlogadmin($request_id){
        $inslog_data['action']='Submitted to Client HR';                    
                $inslog_data['updated_on'] = date ( 'Y-m-d H:i:s' );
                $this->db->where('request_id',$request_id);
                $this->db->update ( DB_PREFIX .'loghistory', $inslog_data );
    }
    function checklevels($request_id,$check_id=false)    {
    $cond="(description=".$check_id." OR check_id=".$check_id.")";
        $this->db->select("m.name as name,package_id,check_id as id,description,GROUP_CONCAT(information SEPARATOR ', ') as information")
                ->where('candidate_request_id',$request_id);
            $this->db->join(DB_PREFIX.'profile_status','candidate_request_id=request_id','left');
            $this->db->join(DB_PREFIX.'master_masterdata m','check_id=m.id','left');
            $this->db->group_by('check_id');

            if($check_id)
                        $this->db->where($cond);
                        //$this->db->where('m.id <',1024);
                        $this->db->order_by('m.seqid'); 

            return $this->db->get(DB_PREFIX.'request_check')->result_array();
            
    }
    function insufficiencylevels($request_id,$check_id=false)    {
    $cond="(description=".$check_id." OR check_id=".$check_id.")";
        $this->db->select('check_id as id,m.name,description')
                ->where('candidate_request_id',$request_id);
            $this->db->join(DB_PREFIX.'profile_status','candidate_request_id=request_id','left');
            $this->db->join(DB_PREFIX.'master_masterdata m','check_id=m.id','left');
            
            if($check_id)
                        $this->db->where($cond);                    
            return  $this->db->get(DB_PREFIX.'request_check')->result_array();

    }
    function submittodcode($save)
    {
            
           $check= $this->check_submit($save['request_id']);
           if($check['cnt']==0)
           $this->db->insert(DB_PREFIX.'submit_cv',$save);
           else
           {
           $this->db->where('request_id',$save['request_id']);
           $this->db->update(DB_PREFIX.'submit_cv',$save);
           }
    }
    function submitreverttodcode($saverevert){
        $this->db->where('request_id',$save['request_id']);
           $this->db->update(DB_PREFIX.'ver_assign_rep',$save);
           }
    
    function submittodcodedeo($savedeo){
            $this->db->where('request_id',$savedeo['request_id']);
           $this->db->update(DB_PREFIX.'submit_cv',$savedeo);
    }
    function submittolog($savelog){
       $this->db->where('request_id',$savelog['request_id']);
           $this->db->update(DB_PREFIX.'loghistory',$savelog); 
    }
    function adminsubmittodes($saveadmin){
         $this->db->where('request_id',$saveadmin['request_id']);
           $this->db->update(DB_PREFIX.'client_request',$saveadmin);
    }
    function submittorevertoption($save_revert)
    {
    $check= $this->check_submit($save_revert['request_id']);
           if($check['cnt']==0)
           $this->db->insert(DB_PREFIX.'client_request',$save_revert);
           else
           {
    $this->db->where('request_id',$save_revert['request_id']);
           $this->db->update(DB_PREFIX.'client_request',$save_revert);
    }
    }
    function submittorevert($saves,$service,$reason)
    {
            
           $check= $this->check_submit($saves['request_id']);
           if($check['cnt']==0)
           $this->db->insert(DB_PREFIX.'client_request',$saves);
           
           else
           {
           $this->db->where('request_id',$saves['request_id']);
           $this->db->update(DB_PREFIX.'client_request',$saves);
           
           $this->db->query("UPDATE " . DB_PREFIX . "client_request SET `service` ='" .implode($service). "',`reason`='" . implode($reason) . "' WHERE `request_id` = ".$saves['request_id'] );
           
           }
    }
    function submittorevertdeo($savesdeo,$service,$reason)
    {
            
           $check= $this->check_submit($savesdeo['request_id']);
           if($check['cnt']==0)
           $this->db->insert(DB_PREFIX.'client_request',$savesdeo);
           
           else
           {
           $this->db->where('request_id',$savesdeo['request_id']);
           $this->db->update(DB_PREFIX.'client_request',$savesdeo);
           
           $this->db->query("UPDATE " . DB_PREFIX . "client_request SET `service` ='" .implode($service). "',`reason`='" . implode($reason) . "' WHERE `request_id` = ".$savesdeo['request_id'] );
           
           }
    }
    function submittorevertdcode($save_submit){
        $this->db->where('request_id',$save_submit['request_id']);
           $this->db->update(DB_PREFIX.'submit_cv',$save_submit);
    }
    function submittorevertrequest($saves_req){

           $this->db->insert(DB_PREFIX.'verification_request',$saves_req);
    }
    function check_submit($id)
    {
            $this->db->select('count(request_id) as cnt');
            $this->db->where('request_id',$id);
            return $this->db->get(DB_PREFIX.'submit_cv')->row_array();
    }
    function get_checklist($checkname,$table,$field='request_id',$cid=false)
    {
    $idss=array();
    $final=array(); 

            $this->db->select('candidate_req_id as id,level_id,check_id');
            if($checkname=='Education')
            $this->db->where('check_id',14); 
            else if($checkname=='Current Address')
            $this->db->where('check_id',16);
            else if($checkname=='Permanent Address')
            $this->db->where('check_id',15);
            else if($checkname=='Employment')
            $this->db->where('check_id',59);
            else
            $this->db->where('check_id',$cid);
         $allotedids=   $this->db->get(DB_PREFIX.'ver_assign_rep')->result_array();
        
       foreach($allotedids as $ids)
         $idss[]=$ids['id'];
         
         if(!empty($idss))
        $final= "'".implode("','",$idss)."'";
        if(!empty($final))
        $notin="d.".$field." NOT IN (".$final.")";
            
            $userid=$this->session->userdata('userid');
                $this->db->select('rc.*,cr.candidate_name as candidatename,o.office_name,org_name,d.*,cr.user_id');
                if(!empty($checkname))
                $this->db->join(DB_PREFIX.'request_check rc','check_id=md.id','left');
                $this->db->join(DB_PREFIX.'client_request cr','cr.request_id=rc.request_id','left');
                $this->db->join(DB_PREFIX.''.$table.' d','d.'.$field.'=rc.request_id','left');
                $this->db->join(DB_PREFIX.'submit_cv sc','sc.request_id=rc.request_id','left');
                $this->db->join(DB_PREFIX.'user u','u.id=cr.user_id','left');
                $this->db->join(DB_PREFIX.'office o','o.id=u.office_id','left');
                $this->db->join(DB_PREFIX.'organisation po','po.id=o.parentoffice_id','left');
                $this->db->where('verification_status',1);
                $this->db->where('sc.assignee_id',$userid);
                if(!empty($final))
                $this->db->where($notin);
                if(!empty($checkname)){
                $this->db->where('key','Check');
                $this->db->where('name',$checkname);
                $this->db->where('md.status',1);
                $this->db->group_by('rc.request_id');
                }
                else
                $this->db->group_by('d.id');

                if(!empty($checkname))
                return $this->db->get(DB_PREFIX.'master_masterdata md')->result_array();
                else
                return $this->db->get(DB_PREFIX.'request_check rc')->result_array();
            
    
    }
/* Allocation for checkwise in vsupervisor   */
    function get_allocationcheck($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {
    
        $userid=$this->session->userdata('userid');
        $field="request_id";

        if(!empty($_REQUEST['check_id'])){
                 $cid=$_REQUEST['check_id'];
        $this->db->select('name as chkname');
        $this->db->where('id',$cid);
         $chk=   $this->db->get(DB_PREFIX.'master_masterdata')->row_array();
         if($_REQUEST['check_id']==15){
            $table=url_title(convert_accented_characters('permanent_contact_details'), 'underscore', TRUE);
         }
         else if($_REQUEST['check_id']==16)
         {
            $table=url_title(convert_accented_characters('contact_details'), 'underscore', TRUE);
         }
         else
         {
            $table=url_title(convert_accented_characters($chk['chkname']), 'underscore', TRUE);
         }
         
}
        $idss=array();
    $final=array(); 
            $this->db->select('candidate_req_id as id,level_id,check_id');
            $this->db->where('check_id',$cid);
         $allotedids=   $this->db->get(DB_PREFIX.'ver_assign_rep')->result_array();
         foreach($allotedids as $ids)
         $idss[]=$ids['id'];
         
         if(!empty($idss))
        $final= "'".implode("','",$idss)."'";
        if(!empty($final))
        $notin=" d.".$field." NOT IN (".$final.")";
    if($notin){
            $notins=" and ".$notin;
         }
         else
         {
            $notins=" ";
         }
        $select = "rc.*,rc.check_id as chkid,cr.candidate_name as candidatename,org_name,cr.user_id,sc.assignee_id,rp.candidate_req_id as crid,rp.level_id,rp.check_id,po.org_name as orgname,do.office_name as parent_office,o.office_name as sub_office,co.office_name,cr.request_id,cr.case_no";
                                 $from = "   FROM " . DB_PREFIX . "master_masterdata md 
                                 LEFT JOIN " . DB_PREFIX . "request_check rc ON rc.check_id=md.id
                                 LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = rc.request_id
                                LEFT JOIN  " . DB_PREFIX . $table. " d ON d.".$field." =rc.request_id and d.check_status=14
                                 LEFT JOIN " . DB_PREFIX . "submit_cv sc ON sc.request_id=rc.request_id
                                 LEFT JOIN " . DB_PREFIX . "user u ON u.id=cr.user_id
                                 LEFT JOIN " . DB_PREFIX . "office do ON do.id = cr.parent_office
                                 LEFT JOIN " . DB_PREFIX . "office co ON co.id = cr.office
                                 LEFT JOIN " . DB_PREFIX . "organisation po ON po.id=do.parentoffice_id
                                 LEFT JOIN " . DB_PREFIX . "office o ON o.id=cr.sub_office
                                 LEFT JOIN " . DB_PREFIX . "ver_assign_rep rp ON rp.candidate_req_id=rc.request_id
                                 JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
                                 where verification_status=1 AND md.status=1 AND md.key='check' 
                                  ".$notins." ";
               
            if ($searchCond) {
            $from .= " and $searchCond";
        }
        if($this->session->userdata('role_id')==2)
                $from .=" and po.organization=".$this->session->userdata('organization');
                if($this->session->userdata('role_id')==13)
                $from .=" and po.parent_office=".$this->session->userdata('parent_office');
        $from .=" and verification_status=1 ";
                if ($type == 'count') $select = "count(DISTINCT(rc.request_id)) as count ";

                if ($pg >= 0 && $type <> 'count') { 
                        $from .= " group by rc.request_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
/* Allocation for education check in vsupervisor   */
    function get_allocationeducheck($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {
       
        $userid=$this->session->userdata('userid');
        $field="request_id";
        
        if(!empty($_REQUEST['check_id'])){
                 $cid=$_REQUEST['check_id'];
        $this->db->select('name as chkname');
        $this->db->where('id',$cid);
         $chk=   $this->db->get(DB_PREFIX.'master_masterdata')->row_array();
         $table=url_title(convert_accented_characters($chk['chkname']), 'underscore', TRUE);
}
        $idss=array();
    $final=array(); 
            $this->db->select('candidate_req_id as id,level_id,check_id');
            $this->db->where('check_id',$cid);
         $allotedids=   $this->db->get(DB_PREFIX.'ver_assign_rep')->result_array();
         foreach($allotedids as $ids)
         $idss[]=$ids['id'];
         
         if(!empty($idss))
        $final= "'".implode("','",$idss)."'";
        if(!empty($final))
        $notin=" e.".$field." NOT IN (".$final.")";
        if($notin){
            $notins=" and ".$notin;
         }
         else
         {
            $notins=" ";
         }
        $select = "rc.*,rc.check_id as chkid,cr.candidate_name as candidatename,org_name,cr.user_id,sc.assignee_id,e.*,rp.candidate_req_id as crid,rp.level_id,rp.check_id,po.org_name as orgname,do.office_name as parent_office,o.office_name as sub_office,co.office_name,cr.request_id,cr.case_no";
                                 $from = "   FROM " . DB_PREFIX . "master_masterdata md 
                                 LEFT JOIN " . DB_PREFIX . "request_check rc ON rc.check_id=md.id
                                 LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = rc.request_id
                                LEFT JOIN " . DB_PREFIX . "education_details e ON e.request_id = rc.request_id and e.check_status=14

                               LEFT JOIN " . DB_PREFIX . "submit_cv sc ON sc.request_id=rc.request_id
                                 LEFT JOIN " . DB_PREFIX . "user u ON u.id=cr.user_id
                                 LEFT JOIN " . DB_PREFIX . "office do ON do.id = cr.parent_office
                                 LEFT JOIN " . DB_PREFIX . "office co ON co.id = cr.office
                                 LEFT JOIN " . DB_PREFIX . "organisation po ON po.id=do.parentoffice_id
                                 LEFT JOIN " . DB_PREFIX . "office o ON o.id=cr.sub_office
                                 LEFT JOIN " . DB_PREFIX . "ver_assign_rep rp ON rp.candidate_req_id=rc.request_id
                                 JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
                                  where verification_status=1 AND md.status=1 AND md.key='check' 
                                  ".$notins." ";
            if ($searchCond) {
            $from .= " and $searchCond";
        }
        if($this->session->userdata('role_id')==2)
                $from .=" and po.organization=".$this->session->userdata('organization');
                if($this->session->userdata('role_id')==13)
                $from .=" and po.parent_office=".$this->session->userdata('parent_office');
        $from .=" and verification_status=1 ";
                if ($type == 'count') $select = "count(Distinct(e.id)) as count ";

                if ($pg >= 0 && $type <> 'count') { 
                        $from .= "group by e.id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
/* Allocation for employment check in vsupervisor   */
    function get_allocationempcheck($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {
       
        $userid=$this->session->userdata('userid');
        $field="req_id";
        
        if(!empty($_REQUEST['check_id'])){
                 $cid=$_REQUEST['check_id'];
        $this->db->select('name as chkname');
        $this->db->where('id',$cid);
         $chk=   $this->db->get(DB_PREFIX.'master_masterdata')->row_array();
         $table=url_title(convert_accented_characters($chk['chkname']), 'underscore', TRUE);
}
        $idss=array();
    $final=array(); 
            $this->db->select('candidate_req_id as id,level_id,check_id');
            $this->db->where('check_id',$cid);
         $allotedids=   $this->db->get(DB_PREFIX.'ver_assign_rep')->result_array();
         foreach($allotedids as $ids)
         $idss[]=$ids['id'];
         
         if(!empty($idss))
        $final= "'".implode("','",$idss)."'";
        if(!empty($final))
        $notin=" e.".$field." NOT IN (".$final.")";
        if($notin){
            $notins=" and ".$notin;
         }
         else
         {
            $notins=" ";
         }
        $select = "rc.*,rc.check_id as chkid,cr.candidate_name as candidatename,org_name,cr.user_id,sc.assignee_id,e.*,rp.candidate_req_id as crid,rp.level_id,rp.check_id,po.org_name as orgname,do.office_name as parent_office,o.office_name as sub_office,co.office_name,cr.request_id,cr.case_no";
                                $from = "   FROM " . DB_PREFIX . "master_masterdata md 
                                 LEFT JOIN " . DB_PREFIX . "request_check rc ON rc.check_id=md.id
                                 LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = rc.request_id
                                LEFT JOIN " . DB_PREFIX . "employment e ON e.req_id = rc.request_id and e.check_status=14
                               LEFT JOIN " . DB_PREFIX . "submit_cv sc ON sc.request_id=rc.request_id
                                 LEFT JOIN " . DB_PREFIX . "user u ON u.id=cr.user_id
                                 LEFT JOIN " . DB_PREFIX . "office do ON do.id = cr.parent_office
                                 LEFT JOIN " . DB_PREFIX . "office co ON co.id = cr.office
                                 LEFT JOIN " . DB_PREFIX . "organisation po ON po.id=do.parentoffice_id
                                 LEFT JOIN " . DB_PREFIX . "office o ON o.id=cr.sub_office
                                 LEFT JOIN " . DB_PREFIX . "ver_assign_rep rp ON rp.candidate_req_id=rc.request_id
                                 JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
                                  where verification_status=1 AND md.status=1 AND md.key='check' 
                                  ".$notins." ";
                               
            if ($searchCond) {
            $from .= " and $searchCond";
        }
        if($this->session->userdata('role_id')==2)
                $from .=" and po.organization=".$this->session->userdata('organization');
                if($this->session->userdata('role_id')==13)
                $from .=" and po.parent_office=".$this->session->userdata('parent_office');
        $from .=" and verification_status=1 ";
                if ($type == 'count') $select = "count(DISTINCT(e.id)) as count ";

                if ($pg >= 0 && $type <> 'count') { 
                        $from .= " group by e.id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }    
    function get_assignee($key)
    {
            $this->db->select('u.id,first_name,last_name');
            $this->db->join(DB_PREFIX.'user_skills us','us.key=md.id','left');
            $this->db->join(DB_PREFIX.'user u','u.id=us.user_id','left');
            $this->db->join(DB_PREFIX.'users_roles r','r.user_id=u.id','left');
            $this->db->where('r.role_id',5);
            $this->db->where('u.status',1);
            $this->db->where('lower(md.name)',strtolower($key));
            $this->db->group_by('u.id');
            return $this->db->get(DB_PREFIX.'master_masterdata md')->result_array();
    }
    function get_assigneecheck_list($key)
    {
            $this->db->select('u.id as id,first_name as name');
            $this->db->join(DB_PREFIX.'user_skills us','us.key=md.id','left');
            $this->db->join(DB_PREFIX.'user u','u.id=us.user_id','left');
            $this->db->join(DB_PREFIX.'users_roles r','r.user_id=u.id','left');
            $this->db->where('r.role_id',5);
            $this->db->where('u.status',1);
            $this->db->where('lower(md.id)',strtolower($key));
            $this->db->group_by('u.id');
            return $this->db->get(DB_PREFIX.'master_masterdata md')->result_array();
    }
    function getlevelcount($lid,$rid,$cid=false)
    {   
        $where = '(request_id="'.$rid.'" AND check_id = "'.$lid.'")';
            $this->db->select('SUM(no_checks) as no_checks,full_info');
            $this->db->where($where); 
            //$this->db->where('request_id',$rid);


            if($lid>94 && $cid)
            { 
            $this->db->where('description',$cid);
            $this->db->where('check_id',$lid);
            } 
            else {
                $this->db->where('check_id',$lid);
                //$this->db->where($where);   
            }
            return $this->db->get(DB_PREFIX.'request_check')->row_array();
    }


    function employment($request_id,$check_id,$id=false)   {
                $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.level_id as level_name,company_name,office_address,branch_address,a.id,m.name as title,a.firstname,middlename,
                lastname,father_name,husband_name,a.date_of_birth,
                ma.name as gender,a.primary_skill,a.passport,a.passport_expire,a.place_of_issue,a.date_of_issue,
                a.nationality,a.SSN,telephone_no,employment,agency_name,agency_address,
                agency_number,employee_code,last_designation,last_department,currently_working,period_from,period_to,period_others_emp,period_of_employment,
                manager_name,manager_designation,email_id,contact_no,salary  ,currency, work_time,reason,hrname,hrdesignation,hrcontact_no,hremailid,reference_taken,reference_date,edocustatus,employement_file,edocument_remarks,
                relieve_status,relieve_document,relieve_remarks,service_status,service_document,additional_doc,service_remarks,exit_formality')
                ->from(DB_PREFIX . 'employment as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.req_id', $request_id)
                 ->where('a.checkid', $check_id);
               
                if($id)
               $this->db->where('a.id',$id);
            $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
        }
        function education($request_id,$check_id,$id=false)    {
            $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
            $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.degree as level_name,a.degree,collegename_add,a.collegename_add_a,a.affliated, a.affliated_add, m.name as title,a.firstname,middlename,lastname,father_name,husband_name,
            a.date_of_birth,ma.name as gender,date_of_birth,a.id,
            period_from,period_to,period_others,period_of_education,a.roll,a.reason1,year_of_passing,specialization,
            docustatus,document_remarks,document_file,grade_status,gdocument,grade_remarks,
            provisional_status,pdocument,provisional_remarks,consolidate_doc,photocopy_remarks,additional_doc,a.nad')
            ->from(DB_PREFIX . 'education_details as a')
            ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
            ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
             ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
            ->where('a.request_id', $request_id)
             ->where('a.checkid', $check_id);
            
            if($id)
            $this->db->where('a.id',$id);
            $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
            return $this->db->get()->result_array();
        }
       
        function current_address($request_id,$check_id,$id=false)    {
                $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();

                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.level_id as level_name,a.id,a.request_id,m.name as title,a.firstname,middlename,
                lastname,father_name,husband_name,ma.name as gender,permanent_address,
                period_of_stay,landmark,permanent_tel_no,office_tel_no,mobile,r.name as rental_type,current_address,
                cperiod_of_stay,cpincode,clandmark,current_tel_no, district as int_district, state as int_state,country as int_country,
                coffice_tel_no,cmobile,cr.name as crental_type,md.name as address_prooft,address_proof,insuff_details, additional_doc')
                ->from(DB_PREFIX . 'contact_details as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->join(DB_PREFIX.'master_masterdata md','md.id=a.address_proof_type','left')
                ->join(DB_PREFIX.'master_masterdata r','r.id=a.rental_type','left')
                ->join(DB_PREFIX.'master_masterdata cr','cr.id=a.crental_type','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);
            $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
        }
        function permanent_address($request_id,$check_id,$id=false)    {
            $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.level_id as level_name,a.id,a.request_id,m.name as title,a.firstname,middlename,
                lastname,father_name,husband_name,ma.name as gender,permanent_address,district as int_district,state as int_state,country as int_country,
                period_of_stay,pincode,landmark,permanent_tel_no,office_tel_no,mobile,r.name as rental_type,current_address,
                cperiod_of_stay,clandmark,current_tel_no,
                cmobile,cr.name as crental_type,md.name as address_prooft,address_proof,insuff_details, additional_doc')
                ->from(DB_PREFIX . 'permanent_contact_details as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->join(DB_PREFIX.'master_masterdata md','md.id=a.address_proof_type','left')
                ->join(DB_PREFIX.'master_masterdata r','r.id=a.rental_type','left')
                ->join(DB_PREFIX.'master_masterdata cr','cr.id=a.crental_type','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);
            $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
        }
    function professional_reference($request_id,$check_id,$id=false)
    {
            $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,m.name as title,a.firstname,middlename,lastname,
                company_name,office_address,branch_address,telephone_no,
                employee_code,last_designation,last_department,period_of_profref,period_others_prof,period_from,period_to,
                manager_name,manager_designation,email_id,contact_no,contact_no2,reason,reference_taken,reference_date,annexures_attach,nature_work,meeting_obj,work_pressure,people_skill,social_skill,comm_skill,prof_strength,prof_weak,person_prob,attend_punct,job_perform,honesty,reliability,commitment,reason_leaving,notice_bfr_leave,rehire,perform_rating,other_comments,insuff_details')
                ->from(DB_PREFIX . 'professional_reference as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);
                  $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
    }
    function personal_reference($request_id,$check_id,$id=false)
    {
            $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,m.name as title,a.firstname,middlename,lastname,reference_company_name,reference_address,reference_name,reference_mobile,
                reference_email,reference_designation,
                reference_relationship,reference_occupation,reference_knowntime,insuff_details');
                $this->db->join(DB_PREFIX.'master_usertype m','m.id=a.title','left');
                $this->db->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left');
                $this->db->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);  
            $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get(DB_PREFIX . 'personal_reference as a')->result_array();
    }
    function police_permanent_address_verification($request_id,$check_id,$id=false)
    {
        $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
       $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,a.request_id,m.name as title,a.firstname,middlename,lastname,father_name,husband_name,permanent_address,
                period_of_stay,pincode,landmark,permanent_tel_no,office_tel_no,mobile,current_address,
                cperiod_of_stay,cpincode,
                md.name as address_prooft,address_proof,police_station,insuff_details, additional_doc')
                ->from(DB_PREFIX . 'police_permanent_address_verification as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_masterdata md','md.id=a.address_proof_type','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id); 
                 $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
    }
    function court_record_check_india($request_id,$check_id,$id=false)
    {
        $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
    $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,a.request_id,m.name as title,a.firstname,middlename,lastname,date_of_birth,father_name,husband_name,address_type,address,period_of_stay,supreme_court_record,high_court_record,insuff_details')
                ->from(DB_PREFIX . 'court_record_check_india as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id); 
                 $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
    }
    
    function india_specific_database_check($request_id,$check_id,$id=false)
    {
        $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
    $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,a.request_id,m.name as title,a.firstname,middlename,lastname,husband_name,permanent_address,
                period_of_stay,current_address,
                cperiod_of_stay,central_bureau, central_vigilance,most_wanted,labour_service,consumer_protection,environmental_protection,arbitration,direct_taxes,excise_customs,company_law,sales_tax,securities_exchange,bombay_stock_exchange,department_of_company,indian_prosecuted,bankruptcy_check,india_specific_internet')
                ->from(DB_PREFIX . 'india_specific_database_check as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);  
            $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
    }
    
    function international_database_check($request_id,$check_id,$id=false)
    {
        $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
    $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,a.request_id,m.name as title,a.firstname,middlename,lastname,husband_name,permanent_address,
                period_of_stay,current_address,
                cperiod_of_stay')
                ->from(DB_PREFIX . 'international_database_check as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);
                  $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
    }
    function international_database_check_ii($request_id,$check_id,$id=false)
    {
        $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
    $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,a.request_id,m.name as title,a.firstname,middlename,lastname,husband_name,permanent_address,
                period_of_stay,current_address,
                cperiod_of_stay')
                ->from(DB_PREFIX . 'international_database_check_ii as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);
                  $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
    }
    function exit_interview($request_id,$check_id,$id=false)
    {
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,a.request_id,m.name as title,firstname,middlename,lastname,
                ma.name as gender,department,designation,supervisor_name,date_of_joining,last_working_date,
                mobile,email_id,alter_email_id,date_of_interview,time_of_interview,place_of_interview')
                ->from(DB_PREFIX . 'exit_interview as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id); 
             $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
    }
    function drug_tests($request_id,$check_id,$id=false)
    {
    $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
    $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,request_id,level_name,m.name as title,firstname,middlename,lastname,ma.name as gender,mobile,
    employee_code,designation,department,email_id,alter_email_id,date_of_test,time_of_test,contact_person,contact_number,insuff_details')
                ->from(DB_PREFIX . 'drug_tests as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);  
            $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
    }
    function tenant_verification($request_id,$check_id,$id=false)
    {
     $this->db->select('a.id,level_name,m.name as title,a.firstname,middlename,lastname,father_name,husband_name,a.date_of_birth,
                ma.name as gender,a.primary_skill,a.experience,a.experience_month,a.passport,a.passport_expire,a.place_of_issue,a.date_of_issue,
                a.nationality,a.SSN,company_name,office_address,branch_address,telephone_no,employment
                ,employee_code,last_designation,last_department,period_from,period_to,
               salary,edocustatus,employement_file,edocument_remarks,
                relieve_status,relieve_document,relieve_remarks,service_status,
                service_document,service_remarks,additional_details,currently_working,optional_document,
                business_name,business_address,landmark,telephone,registration_no,
                number_of_clients,number_of_employees,turnover,infrastructure,
                incorporation_date,details_of_directors,business_branch_address,registration_document,income_tax_document,
                permanent_address,period_of_stay,
                mobile,pincode,plandmark,md.name as address_prooft,permanent_tel_no,office_tel_no,address_proof,
                landlord_name,landlord_address,landlord_occupation,landlord_contact,landlord_email,
                landlord_premises,no_of_people_living,rented_since,rental_agreement,
                reference_name,reference_address,reference_company,reference_designation,reference_occupation,
        reference_contact,reference_email,reference_relationship,reference_knowntime')
                ->from(DB_PREFIX . 'tenant_verification as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->join(DB_PREFIX.'master_masterdata md','md.id=a.address_proof_type','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id){
                    $this->db->where('a.id',$id);  
                }
                return $this->db->get()->result_array();
    }
    function vendor_verification($request_id,$check_id,$id=false)
    {
    $this->db->select('a.id,level_name,m.name as title,a.firstname,middlename,lastname,father_name,
                business_name,business_address,landmark,telephone,registration_no,
                number_of_clients,number_of_employees,turnover,infrastructure,
                incorporation_date,details_of_directors,business_branch_address,registration_document,income_tax_document,
                permanent_address,period_of_stay,
                mobile,pincode,plandmark,md.name as address_prooft,permanent_tel_no,office_tel_no,address_proof,
                client_company_name,client_address,client_landmark,client_telephone,providing_business_since')
                ->from(DB_PREFIX . 'vendor_verification as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->join(DB_PREFIX.'master_masterdata md','md.id=a.address_proof_type','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id){
                    $this->db->where('a.id',$id);
                }
                return $this->db->get()->result_array();
    }
    

function all_devices(){
    $this->db->select('name,seqid')
            ->from(DB_PREFIX . 'master_masterdata')
            ->where('key', 'Revert_reason');
    return $this->db->get()->result_array();
}
function get_contactemail($request_id){
   $this->db->select('a.email')
                ->from(DB_PREFIX . 'user as a')
                ->join(DB_PREFIX . 'client_request as b','b.user_id = a.id','left')
                ->where('a.email IS NOT NULL')
                ->where('b.request_id', $request_id);
                return $this->db->get()->result_array();  
}
function get_insufficiency_users ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
    $roleid= $this->session->userdata('role_id'); 
   $usertype= $this->session->userdata('user_type'); 
                $select = "a.request_id,a.candidate_name,c.org_name,b.office_name,p.office_name as parent_office,e.order_name,cv.insufficiency_report,o.office_name as sub_office,cv.created_date,a.case_no,cv.emp_code";
                        
              $from = "   FROM " . DB_PREFIX . "client_request a 
                      LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
                      LEFT JOIN " . DB_PREFIX . "office p ON p.id = a.parent_office 
                      LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
                      LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                      LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                      LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by
                      JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3
                      LEFT JOIN " . DB_PREFIX . "user_headoffices h ON h.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "user_branchoffices br ON br.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "user_suboffices so ON so.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "insufficiency cv ON cv.request_id=a.request_id
                      where 1 AND cv.insufficiency_report IS NOT NULL and cv.status=1 ";
                $poffice=implode(",", $this->session->userdata['poffice'] );
                    $boffice=implode(",", $this->session->userdata['boffice'] );
                    $soffice=implode(",", $this->session->userdata['soffice'] );
                if($usertype == 2 && $roleid==12 )
                {

                  if(empty($boffice) and empty($soffice)){
                    $from .= " and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                    else if(!empty($boffice) and empty($soffice)){
                    $from .= " and h.parent_office in (".$poffice." ) and br.branch_office in (".$boffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                  else{
                         $from .= " and h.parent_office in (".$poffice." ) and br.branch_office in (".$boffice." ) and so.sub_office in (".$soffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                      }
                }    
                else if($usertype == 2 && $roleid==13 )
               {
                    $from .= " and a.created_by = ".$this->session->userdata['userid'];
               } 
               else if($usertype == 2 && $roleid==14 )
               {
                    $from .= " and a.created_by = ".$this->session->userdata['userid'];
               }
               else if($usertype == 1 && $roleid==21 )
                {
                    $from .= " and c.crm_userid = ".$this->session->userdata['userid']."  ";
                } 
               else 
               {
                    $from .= "";
               }             
                if ($searchCond) {
            $from .= " and $searchCond";
        }

                if ($type == 'count') $select = "count(DISTINCT(a.request_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                       $from .= " group by a.request_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function get_assignee_vslist() {
       
        $cond="r.role_id = '9' ";
       
                $sql = "SELECT c.id as assignee_id, concat_ws(' ', first_name,middle_name,last_name) as name , c.email
                        FROM " . DB_PREFIX ."organisation a
                        left join " . DB_PREFIX ."user c on c.organization = a.id
                        left join " . DB_PREFIX ."users_roles r on r.user_id = c.id
                        WHERE a.user_type = 1 and c.status = 1 and ".$cond." ";
                $query = $this->db->query( $sql );
                return $query->result_array();
        }
     /* new checks models of 07/06/2017, share_code and  upload_xml added on 21st Nov 22 by MN*/
    function aadhaar_card_verification($request_id,$check_id,$id=false)    {
        $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.aadhaar_card_name,a.id,a.request_id,a.checkid,m.name as title,a.firstname,middlename,
                lastname,father_name,date_of_birth,husband_name,ma.name as gender,a.address,
                pincode,district,state,aadhaar_no,address_proof,insuff_details, additional_doc, a.share_code, a.upload_xml, a.upload_zip, a.remarks')
                ->from(DB_PREFIX . 'aadhaar_card_verification as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);  
            $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
        }
        function pan_card_verification($request_id,$check_id,$id=false)    {
            $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.pancard_name,a.id,a.request_id,a.checkid,m.name as title,a.firstname,middlename,
                lastname,father_name,date_of_birth,ma.name as gender,
               pan_card_no,address_proof,insuff_details, additional_doc')
                ->from(DB_PREFIX . 'pan_card_verification as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);  
            $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
        }
        function passport_verification($request_id,$check_id,$id=false)    {
            $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.passport_name,a.id,a.request_id,a.checkid,m.name as title,a.firstname,middlename,
                lastname,father_name,husband_name,a.address,date_of_birth,ma.name as gender,pincode,district,state,
               passport_no,date_of_issue,date_of_expiry,address_proof,insuff_details, additional_doc')
                ->from(DB_PREFIX . 'passport_verification as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id); 
                 $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
        }
        function voter_id_verification($request_id,$check_id,$id=false)    {
            $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.voter_id_name,a.id,a.request_id,a.checkid,m.name as title,a.firstname,middlename,
                lastname,father_name,husband_name,date_of_birth,ma.name as gender,a.address,pincode,district,state,
               voter_id_no,address_proof,insuff_details, additional_doc')
                ->from(DB_PREFIX . 'voter_id_verification as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);
                  $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
        }
        function driving_licence_verification($request_id,$check_id,$id=false)    {
            $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.driving_licence_name,a.id,a.request_id,a.checkid,m.name as title,a.firstname,middlename,
                lastname,father_name,husband_name,a.address,date_of_birth,ma.name as gender,pincode,district,state,
               driving_licence_no,driving_date_of_issue,valid_up_to,address_proof,insuff_details, additional_doc')
                ->from(DB_PREFIX . 'driving_licence_verification as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);  
            $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
        }
        function cibil_check($request_id,$check_id,$id=false)    {
            $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.pancard_name,a.id,a.request_id,m.name as title,a.firstname,middlename,
                lastname,father_name,husband_name,date_of_birth,ma.name as gender,
               pan_card_no,address_proof,credit_score,insuff_details, additional_doc')
                ->from(DB_PREFIX .'cibil_check as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id); 
                 $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
        }
    function court_record_check_lf($request_id,$check_id,$id=false)
    {
        $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
    $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,cr.created_on,a.request_id,m.name as title,a.firstname,middlename,lastname,a.father_name,husband_name, a.date_of_birth, permanent_address, period_of_stay,current_address, cperiod_of_stay,pincode,district,state,current_pincode,clandmark,additional_doc,additional_remark,can_policestation,insuff_details,pincode_before_marriage, address_before_marriage, p_before_marriage, pincode_after_marriage, address_after_marriage, p_after_marriage')
                ->from(DB_PREFIX .'court_record_check_lf as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->join(DB_PREFIX.'client_request cr','cr.request_id=a.request_id','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id); 
                 $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
    }
    function court_record_check($request_id,$check_id,$id=false)
    {
        $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
    $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,a.request_id,m.name as title,a.firstname,middlename,lastname,date_of_birth,father_name,husband_name,address_type,address,
                period_of_stay,current_address,
                cperiod_of_stay,pincode,district,state,current_pincode,a.level_name as court_leveldetails,clandmark,additional_doc,additional_remark,can_policestation,insuff_details,pincode_before_marriage, address_before_marriage,p_before_marriage,pincode_after_marriage,address_after_marriage , p_after_marriage')
                ->from(DB_PREFIX .'court_record_check as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id); 
                 $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
    }
    function ofac($request_id,$check_id,$id=false)    {
        $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.full_name,a.id,a.request_id,m.name as title,a.firstname,middlename,
                lastname,father_name,husband_name,ma.name as gender,date_of_birth,int_country,nationality,
               permanent_address,period_of_stay,current_address,cperiod_of_stay,md.name as address_proof_type,address_proof,insuff_details')
                ->from(DB_PREFIX .'ofac as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->join(DB_PREFIX.'master_masterdata md','md.id=a.address_proof_type','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                ->where('a.checkid', $check_id);
            
                if($id)
                $this->db->where('a.id',$id); 
                 $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
        }
        function form_16_verification($request_id,$check_id,$id=false)    {
            $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.full_name,a.id,a.request_id,m.name as title,a.firstname,middlename,
                lastname,father_name,husband_name,date_of_birth,ma.name as gender,
               pancard_no,tan_of_deductor,source_of_income,tds_amount_deducted,address_proof,assessment_year,insuff_details, additional_doc')
                ->from(DB_PREFIX .'form_16_verification as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                ->where('a.checkid', $check_id);
            
                if($id)
                $this->db->where('a.id',$id); 
                 $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
        }
        function us_travel_verification($request_id,$check_id,$id=false)    {
            $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.full_name,a.id,a.request_id,m.name as title,a.firstname,middlename,
                lastname,father_name,husband_name,date_of_birth,ma.name as gender,passport_no,passport_issuance,address_proof,insuff_details')
                ->from(DB_PREFIX .'us_travel_verification as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id); 
                 $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
        }
        function police_current_address_verification($request_id,$check_id,$id=false)
    {
        $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
       $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,a.request_id,m.name as title,a.firstname,middlename,lastname,father_name,husband_name,current_address,
                cperiod_of_stay,cpincode,clandmark,current_tel_no,
                coffice_tel_no,cmobile,md.name as address_prooft,address_proof,police_station,insuff_details')
                ->from(DB_PREFIX . 'police_current_address_verification as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_masterdata md','md.id=a.address_proof_type','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);  
            $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
    }
    function vm_revertstatus($request_id)
    {   
        $sql = "SELECT revert_status,service,reason,dataentry_by,concat_ws(' ', u.first_name,u.last_name) as vname
                        FROM " . DB_PREFIX ."client_request a 
                        join " . DB_PREFIX ."ver_assign_rep v on v.candidate_req_id=a.request_id
                        join " . DB_PREFIX ."user u on u.id=v.vm_revert_by and v.vm_revert_by=v.team_mem_id
                        WHERE a.request_id=".$request_id." and v.vm_revert_to=2 group by a.request_id ";
                $query = $this->db->query( $sql );
                return $query->result_array();
      
    }
    /* reassigning operator */
   function getassignstatus($request_id){
        $sql = "SELECT a.assignee_id,b.first_name
                        FROM " . DB_PREFIX ."client_request a
                        LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
                        WHERE a.request_id=". $request_id." and a.assignee_id!=0";
                $query = $this->db->query( $sql );
                return $query->result_array();
    }

    /* fetch counts of all checks */
    function getchkcounts($request_id,$table, $field,$checkid)
    {


         if($table)
           { 
                $chks='';
                $this->db->select('count(id) as chkcount');
                $this->db->where('checkid',$checkid);
                $this->db->where($field,$request_id);
                $this->db->where('check_status',14);
               $chks= $this->db->get(DB_PREFIX.$table)->row_array();
             

               if($chks['chkcount']==0)
               {
                $this->db->where('request_id', $request_id); 
                $this->db->where('check_id', $checkid);
                $this->db->delete('dcode_request_check');
               }   
                else
               {
                $this->db->set('no_checks', $chks['chkcount']);   
                $this->db->where('request_id', $request_id); 
                $this->db->where('check_id', $checkid);
                $this->db->update('dcode_request_check');

               }
               
           }
    }
    /* Fetch all insufficiency details from all id checks */
    function getinsuffdetails($req_id,$table,$check_id,$sname)
    {
        if($table)
        {

            $insuff='';
            $this->db->select('a.insuff_details,m.level_details');
            $this->db->join(DB_PREFIX.'master_masterdata m','m.id=a.checkid','left');
            $this->db->where('checkid',$check_id);
            $this->db->where('request_id',$req_id);
            $this->db->where('check_status',14);
            $insdetails= $this->db->get(DB_PREFIX.$table.' as a')->result_array();
             
             

            $i=1;
            $insuff='' || $insuff= [];
            $ins='' || $ins= [];

            foreach ($insdetails as $key => $insuffdetails) {
               if(!empty($insuffdetails['insuff_details'])){
                $insuff[]='<p>('.$sname.'-'.$i.') '.$insuffdetails['level_details'].' (Reason - '.$insuffdetails['insuff_details'].').</p>';
                $i++;
                }
            }

            $ins=implode('', $insuff);
            return $ins;
        }
    }
    /* generating insufficiency report of candidates */
    function insufficiencyreport($request_id,$check_id)
    {

         
        $data['insufflevels']=$insufflevels = $this->dm->insufficiencylevels($request_id,$check_id);
        $insuffcount=count($insufflevels);

           $this->db->select('edocustatus,edocument_remarks,relieve_status,relieve_remarks,service_status,service_remarks,company_name');
        $insuffemp=$this->db->get_where(DB_PREFIX .'employment',array
      ('checkid'=> '59','req_id'=> $request_id,'check_status'=>14 ))->result_array(); 
           $incountemp=count($insuffemp);
 
           $this->db->select('docustatus,document_remarks,grade_status,gdocument,grade_remarks,provisional_status,pdocument,provisional_remarks,additional_doc,additional_remark,collegename_add,degree,photocopy_remarks');
        $insuffedu=$this->db->get_where(DB_PREFIX .'education_details',array
      ('checkid'=> '14','request_id'=> $request_id,'check_status'=>14 ))->result_array();
           $incount=count($insuffedu);
        $innsuffval=array(); 
          
        if($insuffcount > 0) {   
        for($i=0;$i<$insuffcount;$i++) {

                if($insufflevels[$i]['id']==14)
                {

                if($incount>=2){
                $ed=1;
                for($j=0;$j<$incount;$j++){

                if($insuffedu[$j]['docustatus']==0 || $insuffedu[$j]['grade_status']==0 || $insuffedu[$j]['provisional_status']==0 || !empty($insuffedu[$j]['photocopy_remarks'])){  
                $val='(EDU-'.$ed.') '.$insuffedu[$j]['degree'];
                $insuffrportremark[$j]['name']=$val;
                }

                if($insuffedu[$j]['docustatus']==0){
                $insuffrportremark[$j]['document_remarks']='Consolidate Mark Sheet '.'(Reason - '.$insuffedu[$j]['document_remarks'].'), ';
                }if($insuffedu[$j]['grade_status']==0){
                $insuffrportremark[$j]['grade_remarks']='Photocopy of Degree Certificate '.'(Reason - '.$insuffedu[$j]['grade_remarks'].'), ';
                }if($insuffedu[$j]['provisional_status']==0){
                $insuffrportremark[$j]['provisional_remarks']='Provisional Degree Certificate '.'(Reason - '.$insuffedu[$j]['provisional_remarks'].') ';
                }
                if(!empty($insuffedu[$j]['photocopy_remarks'])) {
                $insuffrportremark[$j]['photocopy_remarks']='Photocopy of Marks Cards '.'(Reason - '.$insuffedu[$j]['photocopy_remarks'].') ';
                }
                $ed++;
                }

                foreach($insuffrportremark as $value){

                if(!empty($value)){
                echo"<p>";
                $innsuffvals='<p>';
                $innsuffvals.=$value['name'].' - ';
                if(!empty($value['document_remarks'])){
                $innsuffvals.=$value['document_remarks'];
                }
                if(!empty($value['grade_remarks'])){
                $innsuffvals.=$value['grade_remarks'];
                }
                if(!empty($value['provisional_remarks'])){
                $innsuffvals.=$value['provisional_remarks'];
                }
                if(!empty($value['photocopy_remarks'])){
                $innsuffvals.=$value['photocopy_remarks'];
                }
                $innsuffvals.=', '.'</p>';
                echo"</p>";
                $innsuffvalues[]=$innsuffvals;

                }

                }

               $innsuffval[]=implode('',$innsuffvalues);
                }else{
                if($insuffedu[$i]['docustatus']==0){

                $insuffrportremark[]='Consolidate Mark Sheet '.'(Reason - '.$insuffedu[0]['document_remarks'].')';
                }if($insuffedu[0]['grade_status']==0){
                $insuffrportremark[]=' Photocopy of Degree Certificate '.'(Reason - '.$insuffedu[$i]['grade_remarks'].')';
                }if($insuffedu[0]['provisional_status']==0){
                $insuffrportremark[]=' Provisional Degree Certificate '.'(Reason - '.$insuffedu[0]['provisional_remarks'].')';
                }
                if(!empty($insuffedu[0]['photocopy_remarks'])) {
                $insuffrportremark[]=' Photocopy of Marks Cards '.'(Reason - '.$insuffedu[0]['photocopy_remarks'].') ';
                }
                if(!empty($insuffrportremark)){

                $innsuffval[]='<p>'.'(EDU-1) '.$insuffedu[0]['degree'].' - '.implode(',',$insuffrportremark).', '.'</p>';
                }

                }

                }
                if($insufflevels[$i]['id']==59){
                if($incountemp>=2){
                $em=1;
                for($k=0;$k<$incountemp;$k++){
                if($insuffemp[$k]['edocustatus']==0 || $insuffemp[$k]['relieve_status']==0 || $insuffemp[$k]['service_status']==0){
                $val='(EMP-'.$em.') '.$insuffemp[$k]['company_name'];
                $insuffemprportremark[$k]['name']=$val;
                }
                if($insuffemp[$k]['edocustatus']==0){
                $insuffemprportremark[$k]['edocument_remarks']='Pay Slip '.'(Reason - '.$insuffemp[$k]['edocument_remarks'].'), ';  
                }if($insuffemp[$k]['relieve_status']==0){
                $insuffemprportremark[$k]['relieve_remarks']='Relieving Document '.'(Reason - '.$insuffemp[$k]['relieve_remarks'].') ';
                }if($insuffemp[$k]['service_status']==0){
                $insuffemprportremark[$k]['service_remarks']='Service Letter '.'(Reason - '.$insuffemp[$k]['service_remarks'].')';
                }

                $em++;
                }
                $innsuffval='' || $innsuffval=[];

                foreach($insuffemprportremark as $values){

                if(!empty($values)){
                echo"<p>";
                $innsuffvalsemp='<p>';
                $innsuffvalsemp.=$values['name'].' - ';
                if(!empty($values['edocument_remarks'])){
                $innsuffvalsemp.=$values['edocument_remarks'];
                }if(!empty($values['relieve_remarks'])){
                $innsuffvalsemp.=$values['relieve_remarks'];
                }if(!empty($values['service_remarks'])){
                $innsuffvalsemp.=$values['service_remarks'];
                }
                $innsuffvalsemp.=', '.'</p>';
                echo"</p>";
                $innsuffvalues[]=$innsuffvalsemp;

                }

                }
               $innsuffval[]=implode('',$innsuffvalues);
                }else{
                if($insuffemp[0]['edocustatus']==0){
                $insuffemprportremark[]='Pay Slip '.'(Reason - '.$insuffemp[0]['edocument_remarks'].')';  
                }if($insuffemp[0]['relieve_status']==0){
                $insuffemprportremark[]=' Relieving Document '.'(Reason - '.$insuffemp[0]['relieve_remarks'].')';
                }if($insuffemp[0]['service_status']==0){
                $insuffemprportremark[]=' Service Letter '.'(Reason - '.$insuffemp[0]['service_remarks'].')';
                }
                if(!empty($insuffemprportremark)){
                $innsuffval[]='<p>'.'(EMP-1) '.$insuffemp[0]['company_name'].' - '.implode(',',$insuffemprportremark).', '.'</p>';
                }
                }
                }
           }

           $insuff_photo=array();
           $insuff_authorization=array();
           $this->db->select('photo_insuff');
        $userphoto_remarks=$this->db->get_where('dcode_personal_details',array('user_id'=> $request_id ))->row_array();
        if(!empty($userphoto_remarks['photo_insuff'])){
            $insuff_photo[]='<p>'.'Candidate image'.' (Reason - '.$userphoto_remarks['photo_insuff'].').</p>';
        }
         $this->db->select('authorization_insuff');
        $authorization_remarks=$this->db->get_where('dcode_declaration_details',array('user_id'=> $request_id ))->row_array();
        if(!empty($authorization_remarks['authorization_insuff'])){
            $insuff_authorization[]='<p>'.'Authorization Letter'.' (Reason - '.$authorization_remarks['authorization_insuff'].').</p>';
        }

        /* insufficiency details for all id checks */
        $chk_details=$this->db->query("select a.check_id,m.name as chkname,m.short_name from dcode_request_check a join dcode_master_masterdata m ON a.check_id=m.id where a.check_id not in(14,59,72,73,643,74) and a.request_id=".$request_id)->result_array();
            foreach ($chk_details as $ckey => $check) { 
                $slug=url_title(convert_accented_characters($check['chkname']), 'underscore', TRUE); 
                 switch($check['check_id'])
                 {
                        case 15:
                        $details[]=$this->dm->getinsuffdetails($request_id,'permanent_contact_details',$check['check_id'],$check['short_name']);
                        break;
                        case 16:
                        $details[]=$this->dm->getinsuffdetails($request_id,'contact_details',$check['check_id'],$check['short_name']);
                        break;
                        default:

                        $details[]=$this->dm->getinsuffdetails($request_id,$slug,$check['check_id'],$check['short_name']);

                 } 
            } 
            $ins_details[]=implode('',$details);  
           $sufficiency=array_merge($innsuffval,$ins_details,$insuff_photo,$insuff_authorization);
        $insufficientfinal=implode(' ',$sufficiency);
        }  
        $this->db->select('a.status,a.request_id');
        $insuffstatus=$this->db->get_where('dcode_insufficiency a',array('a.request_id'=> $request_id ))->result_array();
            foreach($insuffstatus as $val){
            if($val['status']==1){
               $this->db->update(DB_PREFIX . "insufficiency", array('status' => 0), array('request_id' => $val['request_id'])); 
            }
        }

          if(!empty($insufficientfinal)){
           $insuffi['insufficiency_report'] = $insufficientfinal;
           $this->db->select('a.case_no,a.client_ref_number,a.candidate_name');
        $case_number=$this->db->get_where('dcode_client_request a',array
      ('a.request_id'=> $request_id ))->row_array();

           $insuffi['request_id'] = $request_id;
           $insuffi['check_id'] = $check_id;
           $insuffi['client_name'] = $case_number['candidate_name'];
           $insuffi['emp_code'] = $case_number['client_ref_number'];
           $insuffi['case_no'] = $case_number['case_no'];
           $insuffi['status'] = 1;
           $insuffi['created_date'] = date ( 'Y-m-d H:i:s' );
           $insuffi['updated_date'] = date ( 'Y-m-d H:i:s' );
       
       $this->db->insert ( DB_PREFIX .'insufficiency', $insuffi );
        }
    }
    function additiondoc_emails($req_id){
           
            $sql = "SELECT a.case_no,o.org_name,concat_ws(' ', ds.first_name,ds.last_name) as dsname,ds.email as ds_email,concat_ws(' ', vs.first_name,vs.last_name) as vsname,vs.email as vs_email,concat_ws(' ', vm.first_name,vm.last_name) as vmname,vm.email as vm_email,concat_ws(' ', u.first_name,u.last_name) as cand_name
                        FROM " . DB_PREFIX ."client_request a 
                        left join " . DB_PREFIX ."organisation o on o.id=a.organisation
                        left join " . DB_PREFIX ."submit_cv cv on a.request_id=cv.request_id
                        left join " . DB_PREFIX ."ver_assign_rep v on v.candidate_req_id=a.request_id
                        left join " . DB_PREFIX ."user ds on ds.id=cv.verification_by and ds.status = 1
                        left join " . DB_PREFIX ."user vs on vs.id=cv.assignee_id and vs.status = 1
                        left join " . DB_PREFIX ."user vm on vm.id=v.team_mem_id and vm.status = 1 
                        left join " . DB_PREFIX ."user u on u.id=a.user_id  
                        WHERE a.request_id=".$req_id." group by v.team_mem_id ";
                $query = $this->db->query( $sql ); 
                return $query->result_array();

    }
    function modify_office($post){
        $this->db->trans_begin();
         $upd_data = array();
        $upd_data['organisation'] =$post['organization'];
        $upd_data['parent_office']= $post['parent_office'];
        $upd_data['office']=$post['branch_office'];
         $upd_data['sub_office']=$post['sub_office'];
         $upd_data['client_ref_number']=$post['client_ref_number'];

        $userdata = $this->amodel->getDetails(DB_PREFIX . "client_request", array('dataentry_by'), array('request_id' => $post['request_id']));
        if($userdata[0]['dataentry_by'] == 3){
        $upd_data['case_recieved_date'] = (!empty($_POST['case_recieved_date'])) ? date('Y-m-d'  , strtotime($post['case_recieved_date'])) : "0000-00-00";
        }
        else
        {
        $upd_data['case_accepted_date'] = (!empty($_POST['case_accepted_date'])) ? date('Y-m-d'  , strtotime($post['case_accepted_date'])) : '0000-00-00 00:00:00';
        } 
        $upd_data['updated_by'] = $this->session->userdata('userid');
        $upd_data['updated_on'] = date ( 'Y-m-d H:i:s' );   
        $this->db->where('request_id',$post['request_id']);
        $this->db->update ( DB_PREFIX .'client_request', $upd_data );
        $user = $this->amodel->getDetails(DB_PREFIX . "client_request", array('user_id'), array('request_id' => $post['request_id']));
             
        $upd_userdata = array();
        $upd_userdata['organization'] =$post['organization'];
        $upd_userdata['parent_office']= $post['parent_office'];
        $upd_userdata['office_id']=$post['branch_office'];
        $upd_userdata['sub_office']=$post['sub_office'];
        $this->db->where('id',$user[0]['user_id']);
        $this->db->update ( DB_PREFIX .'user', $upd_userdata );
        if ($this->db->trans_status() === FALSE)
        {
        $this->db->trans_rollback();
        }
        else
        {
        $this->db->trans_commit();
        }
    }
    /* count of checks for particular case */
    /*
    function count_checks($request_id)    {
        $this->db->select('sum(no_checks) as chk_count')
                ->where('request_id',$request_id)
                ->group_by('request_id');
            return $this->db->get(DB_PREFIX.'request_check')->row_array();
    }*/

    function count_checks($request_id)    {
        $sql="SELECT SUM(no_checks) as checksum1, package_id FROM dcode_request_check WHERE request_id='".$request_id."' AND package_id !=0 AND check_id NOT IN (SELECT id from dcode_master_masterdata WHERE ref_id=1)";
      $result= $this->db->query($sql);
      return $result->result_array();
    }

    function get_packageID($request_id){
        $sql="SELECT package_id FROM dcode_request_check WHERE request_id='".$request_id."' AND package_id !=0 ";
        $result= $this->db->query($sql);
        return $result->result_array();
    }

    /************** Get anycount************/
    function get_anyCount($package_id){

        $sql="SELECT DISTINCT(anycount) FROM ".DB_PREFIX ."packages
         WHERE package_id='".$package_id."' AND group_id=1";
        $Query= $this->db->query($sql);
        return $Query->result_array();
    }

    function get_checkCount($request_id){
        $sql="SELECT SUM(no_checks) as checksum2 FROM ".DB_PREFIX ."request_check WHERE request_id='".$request_id."' AND package_id=0";
        $Query= $this->db->query($sql);
        return $Query->result_array();
    }

    

    function international_criminal_check($request_id,$check_id,$id=false)        
    {  

          $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
    $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,a.request_id,m.name as title,a.firstname,middlename,lastname,a.father_name, a.date_of_birth, permanent_address, period_of_stay as permanent_period ,period_fromp,period_top,current_address, cperiod_of_stay,cperiod_from,cperiod_to,pincode,district as int_district ,state as int_state ,country as int_country ,current_pincode,clandmark,additional_doc,additional_remark,can_policestation,insuff_details,cstate,cdistrict ,ccountry')
                ->from(DB_PREFIX .'international_criminal_check as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id); 
                 $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return  $this->db->get()->result_array();
            
    }
    //international address check current
    function   international_address_check_current_address($request_id,$check_id,$id=false) {

            $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();

                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.level_id as level_name,a.id,a.request_id,m.name as title,a.firstname,middlename,
                lastname,ma.name as gender,permanent_address,
                period_of_stay,landmark,permanent_tel_no,office_tel_no,mobile,r.name as rental_type,current_address,state as int_state,district as int_district,country as int_country,
                cperiod_of_stay,cperiod_from,cperiod_to,cpincode,clandmark,current_tel_no,other_details,other_details_crental as rental_type_details
                ,cmobile,cr.name as crental_type,md.name as address_prooft,address_proof,insuff_details, additional_doc')
                ->from(DB_PREFIX . 'international_address_check_current_address as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->join(DB_PREFIX.'master_masterdata md','md.id=a.address_proof_type','left')
                ->join(DB_PREFIX.'master_masterdata r','r.id=a.rental_type','left')
                ->join(DB_PREFIX.'master_masterdata cr','cr.id=a.crental_type','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);
            $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();      
    }
    function  international_address_check_permanent_address($request_id,$check_id,$id=false) {

       $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.level_id as level_name,a.id,a.request_id,m.name as title,a.firstname,middlename,
                lastname,ma.name as gender,permanent_address,
                period_of_stay,period_fromp,period_top,pincode,landmark,permanent_tel_no,mobile,r.name as rental_type,current_address,other_details,district as int_district,state as int_state,country as int_country,
                cperiod_of_stay,clandmark,current_tel_no,other_details_crental as rental_type_details,
                cmobile,cr.name as crental_type,md.name as address_prooft,address_proof,insuff_details, additional_doc')
                ->from(DB_PREFIX . 'international_address_check_permanent_address as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->join(DB_PREFIX.'master_masterdata md','md.id=a.address_proof_type','left')
                ->join(DB_PREFIX.'master_masterdata r','r.id=a.rental_type','left')
                ->join(DB_PREFIX.'master_masterdata cr','cr.id=a.crental_type','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);
            $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
           
    }
    function  international_bankruptcy_check_individual($request_id,$check_id,$id=false){
     
        $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,a.request_id,m.name as title,a.firstname,middlename,
                lastname,date_of_birth,ma.name as gender,a.email_id,a.contact_no,a.marital,a.idcardno,type_of_id,a.state as int_state,a.district as int_district,a.country as int_country,a.cdistrict,a.cstate,a.ccountry')
                ->from(DB_PREFIX . 'international_bankruptcy_check_individual as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);  
            $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return  $this->db->get()->result_array();
           

          
    }

    function form_26as($request_id,$check_id,$id=false){
        
        $chkstatus=$this->db->select('candidate_status,operator_status')
                ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.full_name,a.id,a.request_id,m.name as title,a.firstname,middlename,
                lastname,father_name,husband_name,date_of_birth,ma.name as gender,
               pancard_no,insuff_details, additional_doc')
                ->from(DB_PREFIX .'form_26as as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                ->join(DB_PREFIX.'master_usertype ma','ma.id=a.gender','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                ->where('a.checkid', $check_id);
            
                if($id)
                $this->db->where('a.id',$id); 
                 $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
    }

    function professional_reference_check_colleague($request_id,$check_id,$id=false){
        
        $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.check_type,a.id,m.name as title,a.firstname,middlename,lastname,
                company_name,office_address,branch_address,telephone_no,
                employee_code,designation,department,period_from,period_to,
                college_name,college_designation,college_email_id,college_contact_no,period_of_reference,reference_relationship,reason,check_type,annexures_attach,nature_work, meeting_obj, work_pressure,people_skill,social_skill,comm_skill,prof_strength,prof_weak,person_prob,honesty,reliability,commitment')
                ->from(DB_PREFIX . 'professional_reference_check_colleague as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);
                  $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
    }

    /******** Get ID Proof check ******
    ***** function getcheckwithoutpackage ********/
    function checkwithoutpackage($request_id)
    {
        $where = '(package_id=0 AND request_id="'.$request_id.'" AND check_id = 59 )';
        return $this->db->select('no_checks')
         ->from(DB_PREFIX.'request_check')
         ->where($where)
         ->get()
         ->result_array();
    }


    /******** Get ID Proof check ******
    ***** function getIdproof ********/
    function getIdproof($request_id,$check_id)
    {
        $where = '(r.package_id=p.package_id AND r.request_id="'.$request_id.'" AND r.check_id = "'.$check_id.'" )';
         return $this->db->select('p.package_id, p.mandatory, p.anycount, p.check_id, p.no_ofcheck, p.noof_year')
         ->from(DB_PREFIX.'packages as p')
         ->where($where)
         ->join(DB_PREFIX.'request_check as r', 'p.check_id = r.check_id')
         ->order_by('p.mandatory')
         ->get()
         ->result_array();
//echo $this->db->last_query();
      

    }

    /******** Get ID Proof check Mandatory ******
    ***** function getMandCount ********/
    function getMandCount($request_id)
    {
        return $this->db->query("select COUNT(*) as total_mandatory from ". DB_PREFIX ."packages where mandatory='Yes' AND `package_id` IN(SELECT package_id FROM ".DB_PREFIX."request_check WHERE request_id =". $request_id . ") " )->row_array();

    }

    function getIDProofCheckID($group_id)
    {
        //echo $group_id;exit;
        $where = '(ref_id="'.$group_id.'" AND key="Check" )';
        $this->db->select("id,level_details")
        ->where($where);
        return $this->db->get(DB_PREFIX.'master_masterdata')->result_array();
    }

function facis($request_id,$check_id,$id=false)
{
    $chkstatus=$this->db->select('candidate_status,operator_status')
    ->from(DB_PREFIX.'submit_cv')
    ->where('request_id', $request_id)->get()->row_array();
    
    $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,a.request_id,m.name as title,a.firstname,middlename,lastname,husband_name,date_of_birth,father_name,permanent_address,
        period_of_stay')
    ->from(DB_PREFIX . 'facis as a')
    ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
    ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
    ->where('a.request_id', $request_id)
    ->where('a.checkid', $check_id);
    if($id)
        $this->db->where('a.id',$id);
    $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
    return $this->db->get()->result_array();
}

// function international_credit_check($request_id,$check_id,$id=false)
// {
//     $chkstatus=$this->db->select('candidate_status,operator_status')
//     ->from(DB_PREFIX.'submit_cv')
//     ->where('request_id', $request_id)->get()->row_array();
    
//     $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,a.request_id,m.name as title,a.firstname,middlename,lastname,husband_name,date_of_birth,father_name')
//     ->from(DB_PREFIX . 'international_credit_check as a')
//     ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
//     ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
//     ->where('a.request_id', $request_id)
//     ->where('a.checkid', $check_id);
//     if($id)
//         $this->db->where('a.id',$id);
//     $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
//     return $this->db->get()->result_array();
// }

function getpriority ($request_id) { 

     //echo $request_id; exit;

  $select = " SELECT request_id,candidate_name,case_no,user_id
             from ".DB_PREFIX."client_request where request_id = ".$request_id;
             
            
             $query = $this->db->query($select); 
             return $query->result_array();
           } 



    function insert_priority($data){
    
    $check= $this->check_priority($data['request_id']);
           if($check['cnt']==0){

    $result = $this->db->insert(DB_PREFIX.'priority',$data);
    if($result){
       
             redirect ( base_url('Client/client_caselist/'. $this->uri->segment(3)), 'refresh' ); 
    }
      }
    else
           {
            //$updata['request_id']=$data['request_id']
            $update['priority'] = $data['priority'];
            $update['comments'] = $data['comments'];
            $update['role_id']  = $data['role_id'];
            $update['date_ofupdate']=date('Y-m-d');

           $this->db->where('request_id',$data['request_id']);
           $this->db->update(DB_PREFIX.'priority',$update);
           
             redirect ( base_url('Client/client_caselist/'. $this->uri->segment(3)), 'refresh' ); 
           }
}


  function check_priority($request_id)
    {
            $this->db->select('comments,date_ofset,priority,request_id as cnt');
            $this->db->where('request_id',$request_id);
            return $this->db->get(DB_PREFIX.'priority')->row_array();
    }

/********************* PF_Verification ****************************************/
function pf_verification($request_id,$check_id,$id=0){
        
        $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,m.name as title,a.firstname,middlename,lastname,date_of_birth,a.father_name,mu.name as gender ,a.UAN_number,a.PF_number')
                ->from(DB_PREFIX . 'pf_verification as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                 ->join(DB_PREFIX.'master_usertype mu','mu.id=a.gender','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id);
                  $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return $this->db->get()->result_array();
    }


/*********************END PF_Verification ****************************************/

        function getTatchecks($request_id)
        {
                $sql = " select a.request_id,a.case_no,a.user_id as candidate_id,s.client_submit_date,(5 * (DATEDIFF(CURDATE(), date(s.client_submit_date)) DIV 7) + MID('0123444401233334012222340111123400012345001234550', 7 * WEEKDAY(date(s.client_submit_date)) + WEEKDAY(CURDATE()) + 1, 1)) - (SELECT COUNT(*) FROM dcode_master_holidays WHERE status=1 and  holiday_date >= date(s.client_submit_date) and holiday_date <= CURDATE()) as Days from dcode_client_request a left join dcode_submit_cv s ON s.request_id=a.request_id where a.request_id=  " .$request_id."  ";

                $query = $this->db->query($sql);
                return $query->row_array();
                
        }


        // function some_func_name($from, $to) {
        //     $workingDays = [1, 2, 3, 4, 5]; # date format = N
        //     $workingHours = ['from' => ['08', '00'], 'to' => ['17', '00']];

        //     $start = new DateTime($from);
        //     $end = new DateTime($to);

        //     $startP = clone $start;
        //     $startP->setTime(0, 0, 0);
        //     $endP = clone $end;
        //     $endP->setTime(23, 59, 59);
        //     $interval = new DateInterval('P1D');
        //     $periods = new DatePeriod($startP, $interval, $endP);

        //     $sum = [];
        //     foreach ($periods as $i => $period) {
        //         if (!in_array($period->format('N'), $workingDays)) continue;

        //         $startT = clone $period;
        //         $startT->setTime($workingHours['from'][0], $workingHours['from'][1]);
        //         if (!$i && $start->diff($startT)->invert) $startT = $start;

        //         $endT = clone $period;
        //         $endT->setTime($workingHours['to'][0], $workingHours['to'][1]);
        //         if (!$end->diff($endT)->invert) $endT = $end;

        //         #echo $startT->format('Y-m-d H:i') . ' - ' . $endT->format('Y-m-d H:i') . "\n"; # debug

        //         $diff = $startT->diff($endT);
        //         if ($diff->invert) continue;
        //         foreach ($diff as $k => $v) {
        //             if (!isset($sum[$k])) $sum[$k] = 0;
        //             $sum[$k] += $v;
        //         }
        //     }

        //     if (!$sum) return 'ccc, no time on job?';

        //     $spec = "P{$sum['y']}Y{$sum['m']}M{$sum['d']}DT{$sum['h']}H{$sum['i']}M{$sum['s']}S";
        //     $interval = new DateInterval($spec);
        //     $startS = new DateTime;
        //     $endS = clone $startS;
        //     $endS->sub($interval);
        //     $diff = $endS->diff($startS);

        //     $labels = [
        //         'y' => 'year',
        //         'm' => 'month',
        //         'd' => 'day',
        //         'h' => 'hour',
        //         'i' => 'minute',
        //         's' => 'second',
        //     ];
        //     $return = [];
        //     foreach ($labels as $k => $v) {
        //         if ($diff->$k) {
        //             $return[] = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
        //         }
        //     }

        //     return implode(', ', $return);

        // }


function international_civil_check($request_id,$check_id,$id=false)        
    {  

          $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
    $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,a.request_id,m.name as title,a.firstname,middlename,lastname,a.father_name, a.date_of_birth, permanent_address, period_of_stay as permanent_period ,period_fromp,period_top,current_address, cperiod_of_stay,cperiod_from,cperiod_to,pincode,district as int_district ,state as int_state ,country as int_country ,current_pincode,clandmark,additional_doc,additional_remark,can_policestation,insuff_details,cstate,cdistrict ,ccountry')
                ->from(DB_PREFIX .'international_civil_check as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id); 
                 $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return  $this->db->get()->result_array();
            
    }

   function international_corruption_record_check($request_id,$check_id,$id=false)        
    {  

          $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
    $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,a.request_id,m.name as title,a.firstname,middlename,lastname,a.father_name, a.date_of_birth, permanent_address, period_of_stay as permanent_period ,period_fromp,period_top,current_address, cperiod_of_stay,cperiod_from,cperiod_to,pincode,district as int_district ,state as int_state ,country as int_country ,current_pincode,clandmark,additional_doc,additional_remark,can_policestation,insuff_details,cstate,cdistrict ,ccountry,a.local_document_file,a.local_document_remarks,a.local_docustatus')
                ->from(DB_PREFIX .'international_corruption_record_check as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id); 
                 $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return  $this->db->get()->result_array();
            
    }

     function international_credit_check($request_id,$check_id,$id=false)        
    {  

          $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
    $this->db->select('mc.name as status,a.check_type,a.check_status_reason,a.id,a.request_id,m.name as title,a.firstname,middlename,lastname,a.father_name, a.date_of_birth, permanent_address, period_of_stay as permanent_period ,period_fromp,period_top,current_address, cperiod_of_stay,cperiod_from,cperiod_to,pincode,district as int_district ,state as int_state ,country as int_country ,current_pincode,clandmark,additional_doc,additional_remark,can_policestation,insuff_details,cstate,cdistrict ,ccountry,a.local_docu_file,a.local_docu_remarks,a.local_docu_status')
                ->from(DB_PREFIX .'international_credit_check as a')
                ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
                 ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                 ->where('a.checkid', $check_id);
                if($id)
                $this->db->where('a.id',$id); 
                 $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
                return  $this->db->get()->result_array();
            
    } 

    //i have added on 7th feb
    function gap_analysis_check($request_id,$check_id,$id=false)    {
            $chkstatus=$this->db->select('candidate_status,operator_status')
                 ->from(DB_PREFIX.'submit_cv')
                ->where('request_id', $request_id)->get()->row_array();
                
                $this->db->select('mc.name as status,a.*')
                ->from(DB_PREFIX . 'gap_analysis_check as a')
                ->join(DB_PREFIX.'master_usertype mc','mc.id=a.check_status','left')
                ->where('a.request_id', $request_id)
                ->where('a.checkid', $check_id);
                //print_r($this->db->last_query());exit();
                if($id)
                $this->db->where('a.id',$id);  
            $this->db->order_by("CASE a.check_type WHEN '0' THEN 10  ELSE a.check_type END asc",FALSE);
            $query = $this->db->get();
            

            if($query !== FALSE && $query->num_rows()>0){

                return $query->result_array();
                return $query;
                }
        }      
}
