<?php
class Dataentry_model extends CI_Model
{
  protected  $ymd = 'Y-m-d';
  protected $passport_expire = 'passport_expire';
  protected $date_of_issue = 'date_of_issue';
  protected $valid_up_to = 'valid_up_to';
  protected $date_of_birth = 'date_of_birth';
  //Constuctor
  function __construct()
  {
    parent::__construct();
    $this->load->database();
  }
  /*******************************
   * personal details of dataentry
   *personaldml
   ****************************/
  function personaldml($id = 0)
  {

    $Passport = $this->encryption->encrypt($_POST['passport']);
    $License_no = $this->encryption->encrypt($_POST['license_no']);
    $SSN = $this->encryption->encrypt($_POST['SSN']);
    $Mobile = $this->encryption->encrypt($_POST['mobile']);
    $EmailId = $this->encryption->encrypt($_POST['email_id']);


    $formData = $_POST;
    if ($formData['gender'] == 16) {
      $formData['other_details_gender'] = $formData['other_details_gender'];
    } else {
      $formData['other_details_gender'] = '';
    }
    if ($formData['marital'] == 17) {
      $formData['other_details_marital'] = $formData['other_details_marital'];
    } else {
      $formData['other_details_marital'] = '';
    }

    if ($formData) {
      $formData['passport'] = $Passport;
      $formData['license_no'] = $License_no;
      $formData['SSN'] = $SSN;
      $formData['mobile'] = $Mobile;
      $formData['email_id'] = $EmailId;
      $formData['current_stay_flag'] = $_POST['current_stay_flag'];
      if ($formData[$this->passport_expire]) {
        $formData[$this->passport_expire] = date($this->ymd, strtotime($formData[$this->passport_expire]));
      } else {
        $formData[$this->passport_expire] = NULL;
      }
      if ($formData[$this->date_of_issue]) {
        $formData[$this->date_of_issue] = date($this->ymd, strtotime($formData[$this->date_of_issue]));
      } else {
        $formData[$this->date_of_issue] = NULL;
      }
      if ($formData[$this->valid_up_to]) {
        $formData[$this->valid_up_to] = date($this->ymd, strtotime($formData[$this->valid_up_to]));
      } else {
        $formData[$this->valid_up_to] = NULL;
      }
      if ($formData[$this->date_of_birth]) {
        $formData[$this->date_of_birth] = date($this->ymd, strtotime($formData[$this->date_of_birth]));
      } else {
        $formData[$this->date_of_birth] = NULL;
      }
      $user_id = $formData['user_id'];
      $upload_files = array('document_name', 'additional_doc');
      $status = $this->insertcloneDetails($_POST['count1'], $upload_files, $return_id, 'personal_additional_doc', $user_id, '', '', '');
      $us_id = $this->getid($user_id);
      $id = $us_id[0]['id'];
      if (!empty($_FILES['user_image']['name'])) {
        $this->load->library('Upload');
        $config['allowed_types'] = 'jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/verified_user_photo/original/';
        $config['upload_thumb'] = 'uploads/verified_user_photo/thumb/';
        $config['max_size']    = 1024;
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('user_image')) {
          $upload_data        = $this->upload->data();
          $upload_data['file_name'] = $upload_data['file_name'];
          $formData['original'] = $config['upload_path'] . '' . $upload_data['file_name'];
          $config['image_library'] = 'gd2';
          $config['source_image']        = getcwd() . '/uploads/verified_user_photo/original/' . $upload_data['file_name'];
          $config['new_image'] = getcwd() . '/uploads/verified_user_photo/thumb/' . $upload_data['file_name'];
          $config['create_thumb'] = FALSE;
          $config['width']        = 90;
          $config['height']        = 86;
          $this->load->library('image_lib', $config);
          $this->image_lib->initialize($config);

          if (!$this->image_lib->resize()) {
            $this->session->set_userdata('error', $this->image_lib->display_errors());
            redirect('' . base_url('Dataentry/personal_detailsadd/' . base64_encode($user_id)));
          } else {
            $formData['user_image'] =  $upload_data['file_name'];
          }
        }

        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          redirect('' . base_url('Dataentry/personal_detailsadd/' . base64_encode($user_id)));
        }
      }
      $i = 0;
      $temp = array();
      $this->db->select('a.upload_doc');
      $addiper = $this->db->get_where(DB_PREFIX . 'personal_details a', array('a.user_id' => $user_id))->row_array();
      if ($addiper['upload_doc'] != '') {
        $temp[] = $addiper['upload_doc'];
      }
      foreach ($_FILES["upload_doc"]["name"] as $key => $error) {
        if (!empty($_FILES['upload_doc']["name"][$key])) {
          $tmp_name = $_FILES["upload_doc"]["tmp_name"][$i];

          $name = md5($_FILES["upload_doc"]["name"][$i]);
          $px = $name;
          $px = preg_replace('/\s+/', '_', $px);
          $px = str_replace('&', 'and', $px);
          $target = './uploads/personaldetails/';
          if (is_dir($target) == false) {
            mkdir($target, 0755);
            echo "Directory Created</br>";
          }
          $u = $target . $px;
          move_uploaded_file($tmp_name, $u);
          $temp[] = $px;
          $i++;
        }
      }
      $uploadeddoc = implode($temp, ",");
      $this->db->select('upload_doc');
      $editedupload_doc = $this->db->get_where(DB_PREFIX . 'personal_details', array('user_id' => $user_id))->row_array();

      $editupd = $editedupload_doc['upload_doc'];
      $valueupd = $uploadeddoc;
      $updoc = $editupd;
      if (empty($uploadeddoc)) {
        $formData['upload_doc'] = $updoc;
      } else {
        $formData['upload_doc'] = implode($temp, ",");
      }
      if ($id == 0) {
        $insertData = elements(array('user_id', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', 'primary_skill', 'experience', 'experience_month', 'passport', $this->passport_expire, 'place_of_issue', $this->date_of_issue, 'license_no', $this->valid_up_to, 'nationality', 'current_stay_flag', $this->date_of_birth, 'gender', 'other_details_gender', 'marital', 'other_details_marital', 'SSN', 'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'mobile', 'alternate_contact', 'relationship', 'email_id', 'alter_email_id', 'photo_insuff', 'created_by', 'created_on'), $formData);
      } else {
        $insertData = elements(array('title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', 'primary_skill', 'experience', 'experience_month', 'passport', $this->passport_expire, 'place_of_issue', $this->date_of_issue, 'license_no', $this->valid_up_to, 'nationality', 'current_stay_flag', $this->date_of_birth, 'gender', 'other_details_gender', 'marital', 'other_details_marital', 'SSN', 'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'mobile', 'alternate_contact', 'relationship', 'email_id', 'alter_email_id', 'photo_insuff', 'updated_by', 'updated_on'), $formData);
      }
      $insertData['current_tel_no'] = $formData['current_country'] . '-' . $formData['current_city'] . '-' . $this->encryption->encrypt($formData['current_no']);
      $insertData['permanent_tel_no'] = $formData['permanent_country'] . '-' . $formData['permanent_city'] . '-' . $this->encryption->encrypt($formData['permanent_no']);
      $insertData['office_tel_no'] = $formData['office_country'] . '-' . $formData['office_city'] . '-' . $this->encryption->encrypt($formData['office_no']);

      if (isset($formData['user_image']) && $formData['user_image'] <> '')
        $insertData['user_image'] = $formData['user_image'];
      if (isset($formData['upload_doc']) && $formData['upload_doc'] <> '')
        $insertData['upload_doc'] = $formData['upload_doc'];
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "personal_details", array('id' => $id), $insertData, $id);

      if ($id == 0) {
        $this->updateprofilestatus($user_id, 'personal');
      }
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($user_id)));
    }
  }
  /*******************************
   * update profile status of dataentry
   *updateprofilestatus
   ****************************/
  function updateprofilestatus($request_id, $fieldname)
  {
    $this->db->update('dcode_profile_status', array($fieldname => 1), array('candidate_request_id' => $request_id));
  }
  /*******************************
   * Current address detaails of dataentry
   *contactdml
   ****************************/
  function contactdml($id = 0)
  {
    $cMobile = $this->encryption->encrypt($_POST['cmobile']);
    $formData = $_POST;

    if ($formData) {
      $req_id = $formData['request_id'];
      $formData['cmobile'] = $cMobile;
      $chkdt = $this->getcheck($request_id);
      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "Address") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "education_details a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();
      $formData['level_id'] = 'Address';
      $documnets = array();
      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0)
            redirect('' . base_url('Dataentry/address_detailsadd/' . base64_encode($req_id)));
          else
            redirect('' . base_url('Dataentry/address_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
        }
      }
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'level_id', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'gender', 'current_address', 'cperiod_of_stay', 'cmobile', 'cpincode', 'clandmark', 'address_proof_type',
          'crental_type', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason', 'district', 'state', 'country'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'checkid', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', 'gender',
          'current_address', 'cperiod_of_stay', 'crental_type',
          'cmobile', 'cpincode', 'clandmark', 'address_proof_type', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason', 'district', 'state', 'country'
        ), $formData);
      }
      $insertData['current_tel_no'] = $formData['current_country'] . '-' . $formData['current_city'] . '-' . $this->encryption->encrypt($formData['current_no']);
      $insertData['coffice_tel_no'] = $formData['coffice_country'] . '-' . $formData['coffice_city'] . '-' . $this->encryption->encrypt($formData['coffice_no']);
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "contact_details", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($user_id, 'address');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }
  /*******************************
   * Permanent address details of dataentry
   *permanentcontactdml
   ****************************/
  function permanentcontactdml($id = 0)
  {
    $Mobile = $this->encryption->encrypt($_POST['mobile']);
    $formData = $_POST;

    if ($formData) {
      $req_id = $formData['request_id'];
      $formData['mobile'] = $Mobile;
      $chkdt = $this->getcheck($request_id);
      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "Address") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "education_details a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();
      $formData['level_id'] = 'Permanent Address';
      $documnets = array();
      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0)
            redirect('' . base_url('Dataentry/permanent_address_detailsadd/' . base64_encode($req_id)));
          else
            redirect('' . base_url('Dataentry/permanent_address_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
        }
      }
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'level_id', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'gender', 'permanent_address', 'period_of_stay', 'mobile', 'pincode', 'landmark', 'address_proof_type',
          'rental_type', 'created_by', 'created_on',   'check_status', 'insuff_details', 'check_type', 'check_status_reason', 'district', 'state', 'country'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'checkid', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', 'gender',
          'permanent_address', 'period_of_stay', 'mobile', 'pincode', 'landmark',
          'rental_type', 'address_proof_type', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason', 'district', 'state', 'country'
        ), $formData);
      }
      $insertData['permanent_tel_no'] = $formData['permanent_country'] . '-' . $formData['permanent_city'] . '-' . $this->encryption->encrypt($formData['permanent_no']);
      $insertData['office_tel_no'] = $formData['office_country'] . '-' . $formData['office_city'] . '-' . $this->encryption->encrypt($formData['office_no']);
      $insertData['coffice_tel_no'] = $formData['coffice_country'] . '-' . $formData['coffice_city'] . '-' . $formData['coffice_no'];
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "permanent_contact_details", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($user_id, 'permanent_address');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }
  /*******************************
   * Country details of dataentry
   *countrydml
   ****************************/
  function countrydml($id = 0)
  {
    $formData = $_POST;
    if ($formData) {
      if ($id == 0) {
        $insertData = elements(array('country_name', 'duration', 'reason', 'country_name2', 'duration2', 'reason2', 'created_by', 'created_on', 'updated_by', 'updated_on'), $formData);
      } else {
        $insertData = elements(array('country_name', 'duration', 'reason', 'country_name2', 'duration2', 'reason2', 'updated_by', 'updated_on'), $formData);
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "country", array('id' => $id), $insertData, $id);

      $view_id = $this->getuserid($id);
      $view = $view_id[0]['user_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }
  /*******************************
   * Other details of dataentry
   *otherdml
   ****************************/
  function otherdml($id = 0)
  {
    $formData = $_POST;
    if ($formData) {
      $user_id = $formData['user_id'];
      $us_id = $this->getothid($user_id);
      $id = $us_id[0]['id'];
      if ($id == 0) {
        $insertData = elements(array('user_id', 'agreement', 'criminal', 'bankrupt', 'civil', 'company', 'agre_text', 'crim_text', 'bank_text', 'civil_text', 'company_text', 'created_by', 'created_on'), $formData);
      } else {
        $insertData = elements(array('agreement', 'criminal', 'bankrupt', 'civil', 'company', 'agre_text', 'crim_text', 'bank_text', 'civil_text', 'company_text', 'updated_by', 'updated_on'), $formData);
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "other_details", array('id' => $id), $insertData, $id);

      if ($id == 0) {
        $this->updateprofilestatus($user_id, 'other_details');
      }
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($user_id)));
    }
  }
  /*******************************
   * getcheck details of dataentry
   *getcheck
   ****************************/
  function getcheck($request_id)
  {
    $this->db->select('a.request_id,c.name,c.name as check_name,a.user_id,c.id as level_id,c.id as ref_id,a.dataentry_by')
      ->from(DB_PREFIX . 'client_request a')
      ->join(DB_PREFIX . 'add_check as ac', 'ac.order_id = a.order_id')
      ->join(DB_PREFIX . 'master_masterdata as c', 'c.id = ac.types_of_check')
      ->where('a.request_id', $request_id);
    return $this->db->get()->result_array();
    // echo $this->db->last_query();
    //  echo "<pre>";

    // exit;
  }
  /*******************************
   * getuserid details of dataentry
   *getuserid
   ****************************/
  function getuserid($req_id)
  {
    $this->db->select('c.request_id')->from(DB_PREFIX . 'profile_level_status as a')->join(DB_PREFIX . 'client_request as c', 'c.request_id=a.client_request_id')->where('a.client_request_id', $req_id);
    return $this->db->get()->result_array();
  }
  /*******************************
   * Education details of dataentry
   *educationdml
   ****************************/
  function educationdml()
  {
    $request_id = $_POST['request_id'];
    $edu_id = $_POST['edu_id'];
    $title = $_POST['title'];
    $firstname = $_POST['firstname'];
    $lastname = $_POST['lastname'];
    $middlename = $_POST['middlename'];
    $father_name = $_POST['father_name'];
    $husband_name = $_POST['husband_name'];
    $gender = $_POST['gender'];
    $date_of_birth = $_POST[$this->date_of_birth];
    $degree = $_POST['degree'];
    $edu_id = $_POST['edu_id'];
    $collegename_add = $_POST['collegename_add'];
    $affliated = $_POST['affliated'];
    $period_from = $_POST['period_from'];
    $period_to = $_POST['period_to'];
    $roll = $this->encryption->encrypt($_POST['roll']);
    $graduate = $_POST['graduate'];
    $program = $_POST['program'];
    $subject = $_POST['subject'];
    $reason1 = $_POST['reason1'];
    $checkid = $_POST['checkid'];
    $collegename_add_a = $_POST['collegename_add_a'];
    $affliated_add = $_POST['affliated_add'];
    $year_of_passing = $_POST['year_of_passing'];
    $specialization = $_POST['specialization'];
    $period_of_education = $_POST['period_of_education'];
    $period_others = $_POST['period_others'];
    $check_status = $_POST['check_status'];
    $check_type = $_POST['check_type'];
    $nad = $_POST['nad'];
    /* Institute Name Add*/
    if ($_POST['collegename_add']) {
      $institute_names = $this->db->query("SELECT a.name FROM  dcode_institutions a WHERE  a.name LIKE '%" . mysqli_real_escape_string($collegename_add) . "%' and active=1 and status=1")->row_array();
      if (empty($institute_names)) {
        $insuti['name'] = $_POST['collegename_add'];
        $insuti['active'] = 1;
        $insuti['key'] = 'institutions';
        $insuti['status'] = 1;
        $this->db->insert(DB_PREFIX . 'institutions', $insuti);
      }
    }

    $documnets = array();
    $config['allowed_types'] = '*';
    $config['upload_path'] = 'uploads/candidate/document';
    $config['encrypt_name'] = true;
    $config['remove_spaces'] = true;

    $this->load->library('upload', $config);
    $count = count($_FILES['document']['size']);
    $s = 0;
    foreach ($_FILES as $key => $value) {

      $_FILES['userfile']['name'] = $value['name'];
      $_FILES['userfile']['type']    = $value['type'];
      $_FILES['userfile']['tmp_name'] = $value['tmp_name'];
      $_FILES['userfile']['error']       = $value['error'];
      $_FILES['userfile']['size']    = $value['size'];

      if ($this->upload->do_upload()) {
        $documnets[$key]  = $this->upload->data();
      }
      $s++;
    }
    $formData['request_id'] = $request_id;
    $formData['title'] = $title;
    $formData['firstname'] = $firstname;
    $formData['lastname'] = $lastname;
    $formData['middlename'] = $middlename;
    $formData['father_name'] = $father_name;
    $formData['husband_name'] = $husband_name;
    $formData['gender'] = $gender;
    $formData[$this->date_of_birth] = ($date_of_birth) ? date($this->ymd, strtotime($date_of_birth)) : NULL;
    $formData['degree'] = $degree;
    $formData['collegename_add'] = $collegename_add;
    $formData['affliated'] = $affliated;
    $formData['roll'] = $roll;
    $formData['graduate'] = $graduate;
    $formData['program'] = $program;
    $formData['subject'] = $subject;
    $formData['reason1'] = $reason1;
    $formData['collegename_add_a'] = $collegename_add_a;
    $formData['affliated_add'] = $affliated_add;
    $formData['check_status'] = $check_status;
    $formData['photocopy_remarks'] = $_POST['photocopy_remarks'];
    if ($period_from != '') {
      $formData['period_from'] = ($period_from) ? date('Y-m-01', strtotime($period_from)) : NULL;
    }
    if ($period_to != '') {
      $formData['period_to'] = ($period_to) ? date('Y-m-01', strtotime($period_to)) : NULL;
    }
    $formData['year_of_passing'] = $year_of_passing;
    $formData['specialization'] = $specialization;
    $formData['checkid'] = $checkid;
    $formData['period_of_education'] = ($period_of_education) ? $period_of_education : 0;
    $formData['period_others'] = ($period_others) ? $period_others : '';
    $formData['check_type'] = $check_type;
    $formData['check_status_reason'] = $_POST['check_status_reason'];
    $formData['nad'] = $nad;
    if ($formData['period_of_education'] == 3) {
      $formData['period_from'] = NULL;
      $formData['period_to'] = NULL;
    } else {
      $formData['period_others'] = '';
    }

    if ($formData) {

      if ($edu_id == 0) {
        $insertData = elements(array(
          'request_id', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'gender', $this->date_of_birth, 'degree', 'collegename_add', 'affliated',
          'period_from', 'period_to', 'roll', 'year_of_passing', 'specialization', 'reason1',
          'created_by', 'created_on', 'collegename_add_a', 'affliated_add', 'checkid', 'period_of_education', 'period_others', 'check_status', 'photocopy_remarks', 'check_type', 'check_status_reason', 'nad'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'gender', $this->date_of_birth, 'degree', 'collegename_add', 'affliated', 'period_from', 'period_to',
          'roll', 'year_of_passing', 'specialization', 'reason1', 'updated_by', 'updated_on',
          'collegename_add_a', 'affliated_add', 'period_of_education', 'period_others', 'check_status', 'photocopy_remarks', 'check_type', 'check_status_reason', 'nad'
        ), $formData);
      }
      if (isset($_POST['dstatus']) && $_POST['dstatus'] == 1) {
        if (!empty($documnets['document'])) {
          $insertData['document_file'] = $documnets['document']['file_name'];
          $insertData['docustatus'] = 1;
          $insertData['document_remarks'] = '';
        }
      } else {
        $insertData['document_remarks'] = $_POST['remarks'];
        $insertData['docustatus'] = 0;
      }

      if (isset($_POST['grade_status']) && $_POST['grade_status'] == 1) {
        if (!empty($documnets['gdocument'])) {
          $insertData['gdocument'] = $documnets['gdocument']['file_name'];
          $insertData['grade_status'] = 1;
          $insertData['grade_remarks'] = '';
        }
      } else {
        $insertData['grade_remarks'] = $_POST['grade_remarks'];
        $insertData['grade_status'] = 0;
      }
      if (isset($_POST['provisional_status']) && $_POST['provisional_status'] == 1) {
        if (!empty($documnets['pdocument'])) {
          $insertData['pdocument'] = $documnets['pdocument']['file_name'];
          $insertData['provisional_status'] = 1;
          $insertData['provisional_remarks'] = '';
        }
      } else {
        $insertData['provisional_remarks'] = $_POST['provisional_remarks'];
        $insertData['provisional_status'] = 0;
      }
      echo $documents;

      if (isset($documnets['consolidate_doc']['file_name']) && $documnets['consolidate_doc']['file_name'] <> '')
        $insertData['consolidate_doc'] = $documnets['consolidate_doc']['file_name'];
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "education_details", array('id' => $edu_id), $insertData, $edu_id);
      $this->updateprofilestatus($request_id, 'education');
    }
    $this->db->select('id');
    $addiedu = $this->db->get_where('dcode_education_details', array('request_id' => $request_id, 'year_of_passing' => $year_of_passing, 'checkid' => $checkid))->row_array();
    $upload_files = array('document_name', 'additional_doc');
    $status = $this->insertcloneDetails($_POST['count1'], $upload_files, $return_id, 'personal_additional_doc', $request_id, $checkid, $addiedu['id'], '');
    redirect('' . base_url('Dadmin/dadminview/' . base64_encode($request_id)));
  }
  function set_upload_options()
  {
    // upload an image options
    $config = array();
    //give the path to upload the image in folder
    $config['upload_path'] = './uploads/candidate/document/';
    $config['allowed_types'] = '*';
    $config['max_size'] = '0';
    $config['overwrite'] = FALSE;
    return $config;
  }
  /*******************************
   * Declaration details of dataentry
   * declarationdml
   ****************************/
  function declarationdml($id = 0, $Authfile = '', $signImg = '')
  {
    $formData['user_id'] = $_POST['user_id'];
    $formData['company_declr'] = $_POST['company_declr_1'];
    $formData['user_declr'] = $_POST['company_declr_2'];
    $formData['authorization_insuff'] = $_POST['authorization_insuff'];
    $formData['auth_letter_understood'] = $_POST['auth_letter_understood'];

    $formData['signature'] = $signImg;

    if ($formData) {
      $user_id = $formData['user_id'];
      $dec_id = $this->getdecid($user_id);
      $id = $dec_id[0]['id'];

      if ($id == 0) {
        $insertData = elements(array('user_id', 'company_declr', 'user_declr', 'authorization_insuff', 'created_by', 'created_on', 'auth_letter_understood', 'signature'), $formData);
      } else {
        $insertData = elements(array('company_declr', 'user_declr', 'authorization_insuff', 'updated_by', 'updated_on', 'auth_letter_understood', 'signature'), $formData);
      }
      $insertData = $this->security->xss_clean($insertData);
      $returnid = $this->amodel->dmlfunction(DB_PREFIX . "declaration_details", array('id' => $id), $insertData, $id);
      $i = 0;
      if ($_POST['doc_type'] == 0 || $_POST['doc_type'] != 1) {
        $temp = array();
        $config['allowed_types'] = '*';
        $config['upload_path'] = 'uploads/prposaldetails/';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        echo '<pre>';
        $this->load->library('upload', $config);
        $count = count($_FILES['document']['size']);
        foreach ($_FILES as $key => $value) {
          $_FILES['company_declr']['name'] = $value['name'];
          $_FILES['company_declr']['type']    = $value['type'];
          $_FILES['company_declr']['tmp_name'] = $value['tmp_name'];
          $_FILES['company_declr']['error']       = $value['error'];
          $_FILES['company_declr']['size']    = $value['size'];
          if ($this->upload->do_upload('document')) {
            $documents[$key]  = $this->upload->data();
          } else {
            echo ($documents['upload_error'] = $this->upload->display_errors());
          }
        }
      }

      if ($Authfile) {
        $this->db->update(DB_PREFIX . "declaration_details", array('company_decl_doc' => $Authfile), array('id' => $returnid));
      }
      if ($documents['document']['file_name']) {
        $this->db->update(DB_PREFIX . "declaration_details", array('company_decl_doc' => $documents['document']['file_name']), array('id' => $returnid));
      }

      if ($id == 0) {
        $this->updateprofilestatus($_POST['user_id'], 'declaration');
      }
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($user_id)));
    }
  }
  /*******************************
   * declarationdata details of dataentry
   * declarationdata
   ****************************/
  function declarationdata($request_id)
  {
    $sql = "SELECT c.id,c.declaration_name,c.declaration_type,c.declaration,c.doc_type,c.declaration_text,c.documentation
      FROM " . DB_PREFIX . "client_request a
      LEFT JOIN " . DB_PREFIX . "office b on b.id=a.parent_office 
      LEFT JOIN " . DB_PREFIX . "company_decl c on c.office_id=b.id OR c.parent_office_id=b.id OR c.sub_office=b.id
      where request_id=" . $request_id . " AND a.sub_office=c.sub_office and a.office=c.office_id and a.parent_office=c.parent_office_id order by c.declaration_type ";
    $query = $this->db->query($sql, array($request_id))->result_array();
    if (empty($query)) {
      $sql = "SELECT c.id,c.declaration_name,c.declaration,c.documentation,c.declaration_type,c.doc_type,c.declaration_text
      FROM " . DB_PREFIX . "client_request a
      LEFT JOIN " . DB_PREFIX . "office b on b.id=a.parent_office 
      LEFT JOIN " . DB_PREFIX . "company_decl c on c.office_id=b.id OR c.parent_office_id=b.id OR c.sub_office=b.id
      where request_id=" . $request_id . " AND c.sub_office=0 and a.office=c.office_id and a.parent_office=c.parent_office_id order by c.declaration_type ";
      $query = $this->db->query($sql, array($request_id))->result_array();
    }
    if (empty($query)) {
      $sql = "SELECT c.id,c.declaration_name,c.declaration,c.documentation,c.declaration_type,c.doc_type,c.declaration_text
      FROM " . DB_PREFIX . "client_request a
      LEFT JOIN " . DB_PREFIX . "office b on b.id=a.parent_office 
      LEFT JOIN " . DB_PREFIX . "company_decl c on c.office_id=b.id OR c.parent_office_id=b.id OR c.sub_office=b.id
      where request_id=" . $request_id . " AND c.sub_office=0 and c.office_id=0 and a.parent_office=c.parent_office_id order by c.declaration_type ";
      $query = $this->db->query($sql, array($request_id))->result_array();
    }
    return $query;
  }
  /*******************************
   * Employment details of dataentry
   * employmentdml
   ****************************/
  function employmentdml()
  { //print_r($_POST);exit;
    $req_id = $_POST['request_id'];

    $where = '(request_id="' . $req_id . '" AND check_id = "' . $_POST['checkid'] . '")';
    $this->db->select('SUM(no_checks) as no_checks,full_info');
    $this->db->where($where);
    $chkcount = $this->db->get(DB_PREFIX . 'request_check')->row_array();
    $check_No = $chkcount['no_checks'];
    $full_info = $chkcount['full_info'];
    //echo '<pre>';print_r($chkcount);exit;

    $this->db->select('dataentry_by');
    $resultdata = $this->db->get_where(DB_PREFIX . 'client_request', array('request_id' => $req_id))->row_array();
    $can_type =  $resultdata['dataentry_by'];

    if ($can_type <> 1 && $can_type <> 2 && $can_type <> 3 && $_POST['check_status'] <> 15) {
      $this->form_validation->set_rules('period_from', 'period_from', 'required');
      // $this->form_validation->set_rules('period_to', 'period_to','required');


      if ($this->form_validation->run() == FALSE) {
        $error    = validation_errors();
        $this->session->set_flashdata('error', validation_errors());
        redirect(base_url("Dataentry/employment_detailsadd/" . base64_encode($_POST['request_id']) . '/' . base64_encode($_POST['checkid']) . '/' . base64_encode($_POST['employementid'])), 'refresh');
        exit;
      }
    }
    $Passport = $this->encryption->encrypt($_POST['passport']);
    $SSN = $this->encryption->encrypt($_POST['SSN']);
    $Telephone = $this->encryption->encrypt($_POST['telephone_no']);
    $empCode = $this->encryption->encrypt($_POST['employee_code']);
    $RMemailId = $this->encryption->encrypt($_POST['email_id']);
    $RMcontact = $this->encryption->encrypt($_POST['contact_no']);


    $req_id = $_POST['request_id'];
    $id = $_POST['employementid'];
    $chkdt = $this->getcheck($req_id);
    foreach ($chkdt as $cd) {
      if ($cd['check_name'] == "Employment") {
        $level_id[] = $cd['level_id'];
      }
    }
    $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "employment a WHERE a.req_id=" . $req_id;
    $query = $this->db->query($sql);
    $res = $query->result_array();
    $formData = $_POST;
    $formData['level_id'] = 'Last Employment';
    $formData['req_id'] = $req_id;

    $formData['passport'] = $Passport;
    $formData['SSN'] = $SSN;
    $formData['telephone_no'] = $Telephone;
    $formData['employee_code'] = $empCode;
    $formData['email_id'] = $RMemailId;
    $formData['contact_no'] = $RMcontact;


    $config['allowed_types'] = '*';
    $config['upload_path'] = 'uploads/candidate/document';
    $config['encrypt_name'] = true;
    $config['remove_spaces'] = true;
    $this->load->library('upload', $config);
    $count = count($_FILES['document']['size']);
    foreach ($_FILES as $key => $value) {
      $_FILES['userfile']['name'] = $value['name'];
      $_FILES['userfile']['type']    = $value['type'];
      $_FILES['userfile']['tmp_name'] = $value['tmp_name'];
      $_FILES['userfile']['error']       = $value['error'];
      $_FILES['userfile']['size']    = $value['size'];
      if ($this->upload->do_upload()) {
        $documnets[$key]  = $this->upload->data();
      }
    }
    if ($formData['period_of_employment'] == 3) {
      $formData['period_from'] = NULL;
      $formData['period_to'] = NULL;
    } else {
      $formData['period_others_emp'] = '';
    }
    if ($formData) {
      if ($id == 0) {
        $insertData = elements(array(
          'req_id', 'level_id', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'primary_skill', 'experience', 'experience_month', 'passport', 'place_of_issue',
          'nationality', 'gender', 'SSN', 'company_name', 'office_address',
          'branch_address', 'telephone_no', 'employment', 'last_designation', 'last_department',
          'manager_name', 'manager_designation', 'email_id', 'contact_no',
          'salary', 'reason', 'agency_status', 'agency_name', 'agency_address', 'employee_code', 'agency_number', 'period_of_employment', 'period_others_emp',
          'currently_working', 'reference_taken', 'reference_date', 'checkid', 'created_by', 'created_on', 'reason1', 'check_status', 'check_type', 'check_status_reason', 'currency', 'work_time', 'hrname', 'hrdesignation', 'hrcontact_no', 'hremailid'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'primary_skill', 'experience', 'experience_month', 'passport', 'place_of_issue',
          'nationality', 'gender', 'SSN', 'company_name', 'office_address',
          'branch_address', 'telephone_no', 'employment', 'last_designation', 'last_department',
          'manager_name', 'manager_designation', 'email_id', 'contact_no',
          'salary', 'reason', 'period_of_employment', 'period_others_emp', 'agency_name', 'agency_status', 'agency_address', 'employee_code', 'agency_number',
          'reference_date', 'currently_working', 'reference_taken', 'created_by', 'created_on', 'updated_by', 'updated_on', 'reason1', 'check_status', 'check_type', 'check_status_reason', 'currency', 'work_time', 'hrname', 'hrdesignation', 'hrcontact_no', 'hremailid'
        ), $formData);
      }
      if ($formData['agency_status'] == 1) {
        $insertData['agency_name'] = $formData['agency_name'];
        $insertData['agency_address'] = $formData['agency_address'];
        $insertData['agency_number'] = $formData['agency_number'];
      } else {
        $insertData['agency_name'] = '';
        $insertData['agency_address'] = '';
        $insertData['agency_number'] = '';
      }
      if ($formData['currently_working'] == 1) {
        $insertData['reference_taken'] = $formData['reference_taken'];
      } else {
        $insertData['reference_taken'] = '';
      }
      if ($formData['reference_taken'] == 0 and $formData['currently_working'] == 1) {
        $insertData['reference_date'] = $formData['reference_date'];
      } else {
        $insertData['reference_date'] = '';
      }
      if ($formData['csalary']) {

        $insertData['salary']  =  $formData['csalary'];
      }
      $insertData['period_from'] = ($formData['period_from']) ? date($this->ymd, strtotime($formData['period_from'])) : NULL;
      $insertData['period_to'] = ($formData['period_to']) ? date($this->ymd, strtotime($formData['period_to'])) : NULL;
      $insertData[$this->date_of_birth] = ($formData[$this->date_of_birth]) ? date($this->ymd, strtotime($formData[$this->date_of_birth])) : NULL;
      $insertData[$this->passport_expire] = ($formData[$this->passport_expire]) ? date($this->ymd, strtotime($formData[$this->passport_expire])) : NULL;
      $insertData[$this->date_of_issue] = ($formData[$this->date_of_issue]) ? date($this->ymd, strtotime($formData[$this->date_of_issue])) : NULL;
      if (isset($formData['dstatus']) && $formData['dstatus'] == 1) {
        if (!empty($documnets['document']['file_name'])) {
          $insertData['employement_file'] = $documnets['document']['file_name'];
          $insertData['edocustatus'] = 1;
          $insertData['edocument_remarks'] = '';
        }
      } else {
        $insertData['edocument_remarks'] = $formData['remarks'];
        $insertData['edocustatus'] = 0;
      }
      if (isset($formData['relieve_status']) && $formData['relieve_status'] == 1) {
        if (!empty($documnets['relieve_document']['file_name'])) {
          $insertData['relieve_document'] = $documnets['relieve_document']['file_name'];
          $insertData['relieve_status'] = 1;
          $insertData['relieve_remarks'] = '';
        }
      } else {
        $insertData['relieve_remarks'] = $formData['relieve_remarks'];
        $insertData['relieve_status'] = 0;
      }
      if (isset($formData['service_status']) && $formData['service_status'] == 1) {
        if (!empty($documnets['service_document']['file_name'])) {
          $insertData['service_document'] = $documnets['service_document']['file_name'];
          $insertData['service_status'] = 1;
          $insertData['service_remarks'] = '';
        }
      } else {
        $insertData['service_remarks'] = $formData['service_remarks'];
        $insertData['service_status'] = 0;
      }


      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "employment", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'employment');
      }
      $this->db->select('a.id');
      $addiemp = $this->db->get_where('dcode_employment a', array('a.req_id' => $req_id, 'a.company_name' => $_POST['company_name'], 'a.employee_code' => $formData['employee_code'], 'a.checkid' => $_POST['checkid'], 'a.manager_name' => $_POST['manager_name'], 'a.contact_no' => $formData['contact_no']))->row_array();
      $upload_files = array('document_name', 'additional_doc');
      $status = $this->insertcloneDetails($_POST['count1'], $upload_files, $return_id, 'personal_additional_doc', $req_id, $_POST['checkid'], $addiemp['id'], '');
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['user_id'];

      if ($check_No >= 99) {
        redirect(base_url("Dataentry/employment_detailsadd/" . base64_encode($_POST['request_id']) . '/' . base64_encode($_POST['checkid'])), 'refresh');
      } else {
        redirect('' . base_url('Dadmin/dadminview/' . base64_encode($req_id)));
      }
    }
  }
  /*******************************
   * getid details of dataentry
   * getid
   ****************************/
  function getid($user_id)
  {
    $this->db->select('a.id')
      ->from(DB_PREFIX . 'personal_details as a')
      ->where('a.user_id', $user_id);
    return $this->db->get()->result_array();
  }
  /*******************************
   * getdecid details of dataentry
   * getdecid
   ****************************/
  function getdecid($user_id)
  {
    $this->db->select('a.id')
      ->from(DB_PREFIX . 'declaration_details as a')
      ->where('a.user_id', $user_id);
    return $this->db->get()->result_array();
  }
  /*******************************
   * getothid details of dataentry
   * getothid
   ****************************/
  function getothid($user_id)
  {
    $this->db->select('a.id')
      ->from(DB_PREFIX . 'other_details as a')
      ->where('a.user_id', $user_id);
    return $this->db->get()->result_array();
  }
  /*******************************
   * getedulevels details of dataentry
   * getedulevels
   ****************************/
  function getedulevels($request_id)
  {
    $this->db->select('*')
      ->from(DB_PREFIX . 'education_details as a ')
      ->where('a.request_id', $request_id);
    $this->db->order_by("a.id", "desc");
    return $this->db->get()->result_array();
  }
  /*******************************
   * getemplevels details of dataentry
   * getemplevels
   ****************************/
  function getemplevels($request_id, $levelId)
  {
    $this->db->select('*')
      ->from(DB_PREFIX . 'employment as a ');
    $this->db->where('a.req_id', $request_id);
    $this->db->order_by("a.id", "desc");
    return $this->db->get()->result_array();
  }
  /*******************************
   * personaldetails details of dataentry
   * personaldetails
   ****************************/
  function personaldetails($request_id)
  {
    $this->db->select('a.firstname,a.date_of_birth,a.primary_skill,a.experience,a.passport,a.passport_expire, a.place_of_issue,
      a.date_of_issue, a.license_no,a.valid_up_to,a.nationality,a.SSN')
      ->from(DB_PREFIX . 'personal_details as a')
      ->where('a.user_id', $request_id);
    return $this->db->get()->result_array();
  }
  /*******************************
   * personalfeildlist details of dataentry
   * personalfeildlist
   ****************************/
  function personalfeildlist()
  {
    $this->db->select('a.id,a.field_name')
      ->from(DB_PREFIX . 'master_field_table as a')
      ->where('key', 'personal_key');
    return $this->db->get()->result_array();
  }
  /*******************************
   * education details details of dataentry
   * educationdetails
   ****************************/
  function educationdetails($request_id, $level_id)
  {
    if ($level_id) {
      $master_child = $this->config->item('CHECKLIST', APPLICATIONCONFIG);
      $sql = "SELECT a.title,a.firstname,middlename,lastname,father_name,husband_name,a.date_of_birth,a.request_id,a.checkid,
      a.gender,date_of_birth,a.id,a.degree,collegename_add,a.affliated, 
      DATE_FORMAT(a.period_from,'%d-%m-%Y') as period_from, DATE_FORMAT(a.period_to,'%d-%m-%Y') as period_to, 
      a.roll,a.reason1,year_of_passing,specialization,a.collegename_add_a,a.affliated_add,
      docustatus,document_remarks,document_file,grade_status,gdocument,grade_remarks,provisional_status,pdocument,provisional_remarks,additional_doc,consolidate_doc,period_of_education,period_others,a.check_status,a.photocopy_remarks,a.check_type,a.check_status_reason ,a.nad
      FROM " . DB_PREFIX . "education_details a 
      WHERE a.request_id =" . $request_id . " and a.id=" . $level_id;
      $query = $this->db->query($sql);
      return $query->result_array();
    }
  }
  /*******************************
   * contact details details of dataentry
   * contactdetails
   ****************************/
  function contactdetails($request_id, $level_id)
  {
    $sql = "SELECT a.id, a.permanent_address,a.period_of_stay, a.current_address, a.current_address, a.cperiod_of_stay, a.current_tel_no,a.permanent_tel_no,a.office_tel_no,a.mobile,a.email_id,a.alter_email_id
      FROM " . DB_PREFIX . "contact_details a 
      join " . DB_PREFIX . "master_masterdata b on b.id = a.level_id
      WHERE a.request_id =" . $request_id . " and a.level_id=" . $level_id;
    $query = $this->db->query($sql);
    return $query->result_array();
  }
  /*******************************
   * employment details details of dataentry
   * employmentdetails
   ****************************/
  function employmentdetails($request_id, $level_id)
  {
    $sql = "SELECT a.id,a.level_id,a.company_name,a.office_address,a.branch_address,a.telephone_no,a.manager_name,a.manager_designation,
      a.email_id,a.contact_no,a.salary,a.reason,a.reference,a.check_status,a.check_type
      FROM " . DB_PREFIX . "employment a 
      join " . DB_PREFIX . "master_masterdata b on b.id = a.level_id
      WHERE a.req_id =" . $request_id . " and a.level_id=" . $level_id;
    $query = $this->db->query($sql);
    return $query->result_array();
  }
  /*******************************
   * educationalfieldlist details details of dataentry
   * educationalfieldlist
   ****************************/
  function educationalfieldlist()
  {
    $this->db->select('a.id,a.field_name')
      ->from(DB_PREFIX . 'master_field_table as a')
      ->where('key', 'education_key');
    return $this->db->get()->result_array();
  }
  /*******************************
   * contactfieldlist details details of dataentry
   * contactfieldlist
   ****************************/
  function contactfieldlist()
  {
    $this->db->select('a.id,a.field_name')
      ->from(DB_PREFIX . 'master_field_table as a')
      ->where('key', 'contact_key');
    return $this->db->get()->result_array();
  }
  /*******************************
   * employmentfieldlist details details of dataentry
   * employmentfieldlist
   ****************************/
  function employmentfieldlist()
  {
    $this->db->select('a.id,a.field_name')
      ->from(DB_PREFIX . 'master_field_table as a')
      ->where('key', 'employment_key');
    return $this->db->get()->result_array();
  }
  /*******************************
   * otherdetails details of dataentry
   * otherdetails
   ****************************/
  function  otherdetails($request_id)
  {
    $this->db->select('a.agreement,a.criminal,a.bankrupt,a.civil,a.company')
      ->from(DB_PREFIX . 'other_details as a')
      ->where('a.user_id', $request_id);
    return $this->db->get()->result_array();
  }
  /*******************************
   * otherfieldlist details details of dataentry
   * otherfieldlist
   ****************************/
  function otherfieldlist()
  {
    $this->db->select('a.id,a.field_name')
      ->from(DB_PREFIX . 'master_field_table as a')
      ->where('key', 'other_key');
    return $this->db->get()->result_array();
  }
  /*******************************
   * get_edu_details details details of dataentry
   * get_edu_details
   ****************************/
  function get_edu_details($request_id)
  {
    $this->db->select('a.firstname,a.date_of_birth,a.primary_skill,a.experience,a.passport,a.passport_expire,a.place_of_issue,a.date_of_issue,a.license_no,a.valid_up_to,a.nationality,a.SSN')
      ->from(DB_PREFIX . 'personal_details as a')
      ->where('a.user_id', $request_id);
    return $this->db->get()->result_array();
  }
  /*******************************
   * education_rem details details of dataentry
   * education_rem
   ****************************/
  function education_rem($request_id)
  {
    $this->db->select('*')
      ->from(DB_PREFIX . 'education_rem as a')
      ->where('a.req_id', $request_id);
    return $this->db->get()->result_array();
  }
  /*******************************
   * contact_rem details details of dataentry
   * contact_rem
   ****************************/
  function contact_rem($request_id)
  {
    $this->db->select('*')
      ->from(DB_PREFIX . 'contact_rem as a')
      ->where('a.req_id', $request_id);
    return $this->db->get()->result_array();
  }
  /*******************************
   * get_check_status details details of dataentry
   * get_check_status
   ****************************/
  function get_check_status($id, $parent = 0)
  {
    $this->db->select('id,name');
    $this->db->where('check_id', $id);
    $this->db->where('parent', $parent);
    $this->db->join(DB_PREFIX . 'master_masterdata', 'id=status_id', 'left');
    $this->db->order_by('seqid');
    return $this->db->get(DB_PREFIX . "check_status")->result_array();
  }
  /*******************************
   * Professional details of dataentry
   * save_professional
   ****************************/
  function save_professional($formData = null, $id = 0)
  {
    $Telephone = $this->encryption->encrypt($_POST['telephone_no']);
    $RMemailId = $this->encryption->encrypt($_POST['email_id']);
    $RMcontact = $this->encryption->encrypt($_POST['contact_no']);
    $formData = $_POST;

    if ($formData) {
      $formData['telephone_no'] = $Telephone;
      $formData['email_id'] = $RMemailId;
      $formData['contact_no'] = $RMcontact;

      $id = $formData['id'];
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'title', 'firstname', 'middlename', 'lastname',
          'company_name', 'office_address', 'branch_address', 'telephone_no', 'last_designation', 'last_department',
          'manager_name', 'manager_designation', 'email_id', 'contact_no', 'reason', 'employee_code',
          'reference_taken', 'checkid', 'created_by', 'created_on', 'period_of_profref', 'period_others_prof', 'reference_date', 'contact_no2', 'other_comments', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'firstname', 'middlename', 'lastname',
          'company_name', 'office_address', 'branch_address', 'telephone_no', 'last_designation', 'last_department',
          'manager_name', 'manager_designation', 'email_id', 'contact_no', 'reason', 'employee_code',
          'reference_taken', 'updated_by', 'updated_on', 'period_of_profref', 'period_others_prof', 'reference_date', 'contact_no2', 'other_comments', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      $insertData['period_from'] = ($formData['period_from']) ? date($this->ymd, strtotime($formData['period_from'])) : NULL;
      $insertData['period_to'] = ($formData['period_to']) ? date($this->ymd, strtotime($formData['period_to'])) : NULL;
      if ($insertData['period_of_profref'] == 3) {
        $insertData['period_from'] = NULL;
        $insertData['period_to'] = NULL;
      } else {
        $insertData['period_others_prof'] = '';
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "professional_reference", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($formData['request_id'], 'professional_reference');
      }
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($formData['request_id'])));
    }
  }
  /*******************************
   * Personal reference details of dataentry
   * save_personal_reference
   ****************************/
  function save_personal_reference($formData, $id = 0)
  {

    if ($formData) {
      $id = $formData['id'];
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'title', 'firstname', 'middlename', 'lastname',
          'reference_company_name', 'reference_address', 'reference_name', 'reference_mobile',
          'reference_email', 'reference_designation',
          'reference_relationship', 'reference_occupation', 'reference_knowntime', 'checkid', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'firstname', 'middlename', 'lastname',
          'reference_company_name', 'reference_address', 'reference_name', 'reference_mobile',
          'reference_email', 'reference_designation',
          'reference_relationship', 'reference_occupation', 'reference_knowntime', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "personal_reference", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($formData['request_id'], 'personal_reference');
      }

      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($formData['request_id'])));
    }
  }
  /*******************************
   * Police permanent address details of dataentry
   * save_police_permanent_address_verificaion
   ****************************/
  function save_police_permanent_address_verificaion($formData, $id = 0)
  {
    if ($formData) {
      $request_id = $formData['request_id'];
      $documnets = array();
      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0) {
            redirect('' . base_url('Dataentry/police_verification_detailsadd/' . base64_encode($req_id)));
          } else {
            redirect('' . base_url('Dataentry/police_verification_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
          }
        }
      } else if ($id == 0 && empty($_FILES['address_proof']['name'])) {
        $documnets['file_name'] = $formData['oldaddressproof'];
      }
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'permanent_address', 'period_of_stay', 'current_address',
          'cperiod_of_stay', 'mobile', 'pincode', 'landmark', 'cmobile', 'cpincode', 'clandmark',
          'address_proof_type', 'police_station', 'created_by', 'checkid', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name',
          'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'mobile', 'pincode', 'landmark',
          'cmobile', 'cpincode', 'clandmark', 'address_proof_type', 'police_station', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      $insertData['current_tel_no'] = $formData['current_country'] . '-' . $formData['current_city'] . '-' . $formData['current_no'];
      $insertData['permanent_tel_no'] = $formData['permanent_country'] . '-' . $formData['permanent_city'] . '-' . $this->encryption->encrypt($formData['permanent_no']);
      $insertData['office_tel_no'] = $formData['office_country'] . '-' . $formData['office_city'] . '-' . $this->encryption->encrypt($formData['office_no']);
      $insertData['coffice_tel_no'] = $formData['coffice_country'] . '-' . $formData['coffice_city'] . '-' . $formData['coffice_no'];
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "police_permanent_address_verification", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($formData['request_id'], 'police_permanent_address_verification');
      }
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($formData['request_id'])));
    }
  }
  /*******************************
   * get_policechk details  of dataentry
   * get_policechk
   ****************************/
  function get_policechk($request_id)
  {
    $query = $this->db->query("select c.*,b.* from " . DB_PREFIX . "personal_details a
            left join " . DB_PREFIX . "contact_details b on b.request_id = a.user_id
            left join " . DB_PREFIX . "permanent_contact_details c on c.request_id = b.request_id
             Where c.checkid = 15 and c.request_id=" . $request_id);
    return $query->result_array();
  }
  /*******************************
   * save_common_record_check details of dataentry
   * save_common_record_check
   ****************************/
  function save_common_record_check($table, $formData, $id = 0)
  {
    if ($formData) {
      $request_id = $formData['request_id'];
      $documnets = array();
      $date_of_birth = $_POST[$this->date_of_birth];
      $formData[$this->date_of_birth] = ($date_of_birth) ? date($this->ymd, strtotime($date_of_birth)) : NULL;
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name',
          'address', 'period_of_stay', 'checkid', 'created_by', 'created_on', $this->date_of_birth, 'address_type', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name',
          'address', 'period_of_stay', 'updated_by', 'updated_on', $this->date_of_birth, 'address_type', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . $table, array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($formData['request_id'], $table);
      }
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($formData['request_id'])));
    }
  }
  /*******************************
   * save_common_database_check details details of dataentry
   * save_common_database_check
   ****************************/
  function save_common_database_check($table, $formData, $id = 0)
  {
    if ($formData) {
      $request_id = $formData['request_id'];
      $documnets = array();
      $date_of_birth = $_POST[$this->date_of_birth];
      $formData[$this->date_of_birth] = ($date_of_birth) ? date($this->ymd, strtotime($date_of_birth)) : NULL;
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name',
          'permanent_address', 'period_of_stay', 'checkid', 'created_by', 'created_on', 'current_address', 'cperiod_of_stay', 'check_status', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name',
          'permanent_address', 'period_of_stay', 'updated_by', 'updated_on', 'current_address', 'cperiod_of_stay', 'check_status', 'check_type', 'check_status_reason'
        ), $formData);
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . $table, array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($formData['request_id'], $table);
      }
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($formData['request_id'])));
    }
  }
  /*******************************
   * educationalfieldlist details details of dataentry
   * educationalfieldlist
   ****************************/
  function save_exit_interview($formData, $id)
  {
    $EmailId = $this->encryption->encrypt($_POST['email_id']);
    $Mobile = $this->encryption->encrypt($_POST['mobile']);

    if ($formData) {
      $formData['email_id'] = $EmailId;
      $formData['mobile'] = $Mobile;
      $request_id = $formData['request_id'];
      $documnets = array();
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'title', 'firstname', 'middlename', 'lastname',
          'gender', 'department', 'designation', 'supervisor_name', 'mobile', 'email_id', 'alter_email_id', 'place_of_interview',
          'created_by', 'created_on', 'checkid', 'check_status', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'firstname', 'middlename', 'lastname',
          'gender', 'department', 'designation', 'supervisor_name', 'mobile', 'email_id', 'alter_email_id', 'place_of_interview', 'updated_by', 'updated_on', 'check_status', 'check_type', 'check_status_reason'
        ), $formData);
      }
      $insertData['date_of_joining'] = ($formData['date_of_joining']) ? date($this->ymd, strtotime($formData['date_of_joining'])) : NULL;
      $insertData['last_working_date'] = ($formData['last_working_date']) ? date($this->ymd, strtotime($formData['last_working_date'])) : NULL;
      $insertData['date_of_interview'] = ($formData['date_of_interview']) ? date($this->ymd, strtotime($formData['date_of_interview'])) : NULL;
      $insertData['time_of_interview'] = ($formData['time_of_interview']) ? date('H:i:s', strtotime($formData['time_of_interview'])) : NULL;
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . 'exit_interview', array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($formData['request_id'], 'exit_interview');
      }
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($formData['request_id'])));
    }
  }
  /*******************************
   * save_drug_tests details details of dataentry
   * save_drug_tests
   ****************************/
  function save_drug_tests($formData, $id = 0)
  {
    if ($formData) {
      $id = $formData['id'];
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'level_name', 'title', 'firstname', 'middlename', 'lastname',
          'gender', 'mobile', 'employee_code', 'designation', 'department', 'location_of_test',
          'email_id', 'alter_email_id', 'time_of_test',
          'contact_person', 'contact_number', 'created_by', 'created_on', 'checkid', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'firstname', 'middlename', 'lastname',
          'gender', 'mobile', 'employee_code', 'designation', 'department', 'location_of_test',
          'email_id', 'alter_email_id', 'time_of_test',
          'contact_person', 'contact_number', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      $insertData['date_of_test'] = ($formData['date_of_test']) ? date($this->ymd, strtotime($formData['date_of_test'])) : NULL;
      $insertData['time_of_test'] = ($formData['time_of_test']) ? date('H:i:s', strtotime($formData['time_of_test'])) : NULL;
      $this->amodel->dmlfunction(DB_PREFIX . "drug_tests", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($formData['request_id'], 'drug_tests');
      }
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($formData['request_id'])));
    }
  }
  /*******************************
   * save_hr_verification details details of dataentry
   * save_hr_verification
   ****************************/
  function save_hr_verification($formData)
  {
    $request_id = $formData['request_id'];
    $id = $formData['id'];
    $documnets = array();
    $config['allowed_types'] = '*';
    $config['upload_path'] = 'uploads/candidate/document';
    $config['encrypt_name'] = false;
    $config['remove_spaces'] = true;
    $this->load->library('upload', $config);
    $count = count($_FILES['document']['size']);
    if ($_FILES['document']['name'] <> '') {
      foreach ($_FILES as $key => $value) {
        $_FILES['userfile']['name'] = $value['name'];
        $_FILES['userfile']['type']    = $value['type'];
        $_FILES['userfile']['tmp_name'] = $value['tmp_name'];
        $_FILES['userfile']['error']       = $value['error'];
        $_FILES['userfile']['size']    = $value['size'];
        if ($this->upload->do_upload()) {
          $documnets[$key]  = $this->upload->data();
        }
      }
    }
    if ($id == 0 && empty($_FILES['document']['name']))
      $documnets['document']['file_name'] = $formData['olddocument'];
    if ($id == 0 && empty($_FILES['relieve_document']['name']))
      $documnets['relieve_document']['file_name'] = $formData['oldrelive'];
    if ($id == 0 && empty($_FILES['service_document']['name']))
      $documnets['service_document']['file_name'] = $formData['oldservice'];
    if ($id == 0 && empty($_FILES['optional_document']['name']))
      $documnets['optional_document']['file_name'] = $formData['oldoptional'];
    if ($formData) {
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'level_name', 'title', 'firstname', 'middlename', 'lastname',
          'father_name', 'husband_name', 'primary_skill', 'experience', 'experience_month', 'passport', 'place_of_issue',
          'nationality', 'gender', 'SSN', 'company_name', 'office_address',
          'branch_address', 'telephone_no', 'employment', 'last_designation', 'last_department',
          'salary', 'employee_code', 'additional_details', 'currently_working',
          'created_by', 'created_on', 'checkid'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'firstname', 'middlename', 'lastname',
          'father_name', 'husband_name', 'primary_skill', 'experience', 'experience_month', 'passport', 'place_of_issue',
          'nationality', 'gender', 'SSN', 'company_name', 'office_address',
          'branch_address', 'telephone_no', 'employment', 'last_designation', 'last_department',
          'salary', 'employee_code', 'additional_details', 'currently_working', 'updated_by', 'updated_on'
        ), $formData);
      }
      $insertData['period_from'] = ($formData['period_from']) ? date($this->ymd, strtotime($formData['period_from'])) : NULL;
      $insertData['period_to'] = ($formData['period_to']) ? date($this->ymd, strtotime($formData['period_to'])) : NULL;
      $insertData[$this->date_of_birth] = ($formData[$this->date_of_birth]) ? date($this->ymd, strtotime($formData[$this->date_of_birth])) : NULL;
      $insertData[$this->passport_expire] = ($formData[$this->passport_expire]) ? date($this->ymd, strtotime($formData[$this->passport_expire])) : NULL;
      $insertData[$this->date_of_issue] = ($formData[$this->date_of_issue]) ? date($this->ymd, strtotime($formData[$this->date_of_issue])) : NULL;
      if (isset($formData['dstatus']) && $formData['dstatus'] == 1) {
        if (!empty($documnets['document']['file_name'])) {
          $insertData['employement_file'] = $documnets['document']['file_name'];
          $insertData['edocustatus'] = 1;
        }
      } else {
        $insertData['edocument_remarks'] = $formData['remarks'];
        $insertData['edocustatus'] = 0;
      }
      if (isset($formData['relieve_status']) && $formData['relieve_status'] == 1) {
        if (!empty($documnets['relieve_document']['file_name'])) {
          $insertData['relieve_document'] = $documnets['relieve_document']['file_name'];
          $insertData['relieve_status'] = 1;
        }
      } else {
        $insertData['relieve_remarks'] = $formData['relieve_remarks'];
        $insertData['relieve_status'] = 0;
      }
      if (isset($formData['service_status']) && $formData['service_status'] == 1) {
        if (!empty($documnets['service_document']['file_name'])) {
          $insertData['service_document'] = $documnets['service_document']['file_name'];
          $insertData['service_status'] = 1;
        }
      } else {
        $insertData['service_remarks'] = $formData['service_remarks'];
        $insertData['service_status'] = 0;
      }
      if (!empty($documnets['optional_document']['file_name']))
        $insertData['optional_document'] = $documnets['optional_document']['file_name'];
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "tenant_verification", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($request_id, 'tenant_verification');
      }
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($request_id)));
    }
  }
  /*******************************
   * save_bussiness_verification details details of dataentry
   * save_bussiness_verification
   ****************************/
  function save_bussiness_verification($formData, $table, $redirect)
  {
    $request_id = $formData['request_id'];
    $id = $formData['id'];
    $config['allowed_types'] = '*';
    $config['upload_path'] = 'uploads/candidate/document';
    $config['encrypt_name'] = false;
    $config['remove_spaces'] = true;
    $this->load->library('upload', $config);
    $count = count($_FILES['registration_document']['size']);
    foreach ($_FILES as $key => $value) {
      $_FILES['userfile']['name'] = $value['name'];
      $_FILES['userfile']['type']    = $value['type'];
      $_FILES['userfile']['tmp_name'] = $value['tmp_name'];
      $_FILES['userfile']['error']       = $value['error'];
      $_FILES['userfile']['size']    = $value['size'];
      if ($this->upload->do_upload()) {
        $documnets[$key]  = $this->upload->data();
      }
    }
    if ($formData) {
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'level_name', 'title', 'firstname', 'middlename', 'lastname',
          'business_name', 'business_address', 'landmark', 'telephone', 'registration_no',
          'number_of_clients', 'number_of_employees', 'turnover', 'infrastructure', 'details_of_directors', 'business_branch_address',
          'created_by', 'created_on', 'checkid'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'firstname', 'middlename', 'lastname',
          'business_name', 'business_address', 'landmark', 'telephone', 'registration_no',
          'number_of_clients', 'number_of_employees', 'turnover', 'infrastructure',
          'details_of_directors', 'business_branch_address', 'updated_by', 'updated_on'
        ), $formData);
      }
      $insertData['incorporation_date'] = ($formData['incorporation_date']) ? date($this->ymd, strtotime($formData['incorporation_date'])) : NULL;
      if (!empty($documnets['registration_document']['file_name'])) {
        $insertData['registration_document'] = $documnets['registration_document']['file_name'];
      }
      if (!empty($documnets['income_tax_document']['file_name'])) {
        $insertData['income_tax_document'] = $documnets['income_tax_document']['file_name'];
      }
      if (!empty($formData['branch_address'])) {
        $insertData['business_branch_address'] = json_encode($formData['branch_address']);
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "" . $table, array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($request_id, $table);
      }
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($request_id)));
    }
  }
  /*******************************
   * save_permanent_address details details of dataentry
   * save_permanent_address
   ****************************/
  function save_permanent_address($formData, $table, $redirect)
  {
    $request_id = $formData['request_id'];
    $id = $formData['id'];
    if (!empty($_FILES['address_proof']['name'])) {
      $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
      $config['upload_path'] = 'uploads/candidate/document';
      $config['encrypt_name'] = true;
      $config['remove_spaces'] = true;
      $this->load->library('upload', $config);
      $this->upload->initialize($config);
      if ($this->upload->do_upload('address_proof')) {
        $documnets  = $this->upload->data();
      }
      if ($this->upload->display_errors() != '') {
        $this->session->set_userdata('error', $this->upload->display_errors());
        if ($id == 0) {
          redirect('' . base_url('Dataentry/' . $redirect . '_verification_detailsadd/' . base64_encode($request_id)));
        } else {
          redirect('' . base_url('Dataentry/' . $redirect . '_verification_detailsadd/' . base64_encode($request_id) . '/' . base64_encode($id)));
        }
      }
    } else if ($id == 0 &&  empty($_FILES['address_proof']['name'])) {
      $documnets['file_name'] = $formData['oldaddressproof'];
    }
    if ($id == 0) {
      $insertData = elements(array(
        'request_id', 'level_name', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
        'gender', 'permanent_address', 'period_of_stay',
        'mobile', 'pincode', 'plandmark', 'address_proof_type', 'created_by', 'created_on', 'checkid'
      ), $formData);
    } else {
      $insertData = elements(array(
        'title', 'firstname', 'middlename', 'lastname', 'father_name',
        'gender', 'permanent_address', 'period_of_stay',
        'mobile', 'pincode', 'plandmark', 'address_proof_type', 'updated_by', 'updated_on'
      ), $formData);
    }
    $insertData['husband_name'] = ($formData['husband_name'] <> '') ? $formData['husband_name'] : NULL;
    $insertData['permanent_tel_no'] = $formData['permanent_country'] . '-' . $formData['permanent_city'] . '-' . $formData['permanent_no'];
    $insertData['office_tel_no'] = $formData['office_country'] . '-' . $formData['office_city'] . '-' . $formData['office_no'];
    if ($documnets['file_name'] <> '') {
      $insertData['address_proof'] = $documnets['file_name'];
    }
    $insertData = $this->security->xss_clean($insertData);
    $this->amodel->dmlfunction(DB_PREFIX . '' . $table, array('id' => $id), $insertData, $id);
    if ($id == 0) {
      $this->updateprofilestatus($request_id, $table);
    }
    redirect('' . base_url('Dadmin/dadminview/' . base64_encode($request_id)));
  }
  /*******************************
   * save_landlord_reference details details of dataentry
   * save_landlord_reference
   ****************************/
  function save_landlord_reference($formData)
  {
    $request_id = $formData['request_id'];
    $id = $formData['id'];
    if (!empty($_FILES['rental_agreement']['name'])) {
      $config['allowed_types'] = 'doc|pdf|jpg|jpeg|png';
      $config['upload_path'] = 'uploads/candidate/document';
      $config['encrypt_name'] = true;
      $config['remove_spaces'] = true;
      $this->load->library('upload', $config);
      $this->upload->initialize($config);
      if ($this->upload->do_upload('rental_agreement')) {
        $documnets  = $this->upload->data();
      }
      if ($this->upload->display_errors() != '') {
        $this->session->set_userdata('error', $this->upload->display_errors());
        if ($id == 0) {
          redirect('' . base_url('Dataentry/tenant_verification_detailsadd/' . base64_encode($request_id)));
        } else {
          redirect('' . base_url('Dataentry/tenant_verification_detailsadd/' . base64_encode($request_id) . '/' . base64_encode($id)));
        }
      }
    }
    if ($id == 0) {
      $insertData = elements(array(
        'request_id', 'level_name', 'title', 'firstname', 'middlename', 'lastname',
        'landlord_name', 'landlord_address', 'landlord_occupation', 'landlord_contact', 'landlord_email', 'landlord_premises',
        'no_of_people_living', 'created_by', 'created_on', 'checkid',
      ), $formData);
    } else {
      $insertData = elements(array(
        'title', 'firstname', 'middlename', 'lastname',
        'landlord_name', 'landlord_address', 'landlord_occupation', 'landlord_contact', 'landlord_email', 'landlord_premises',
        'no_of_people_living', 'updated_by', 'updated_on'
      ), $formData);
    }
    $insertData['rented_since'] = ($formData['rented_since']) ? date($this->ymd, strtotime($formData['rented_since'])) : NULL;
    if ($documnets['file_name'] <> '') {
      $insertData['rental_agreement'] = $documnets['file_name'];
    }
    $insertData = $this->security->xss_clean($insertData);
    $this->amodel->dmlfunction(DB_PREFIX . "tenant_verification", array('id' => $id), $insertData, $id);
    if ($id == 0) {
      $this->updateprofilestatus($request_id, 'tenant_verification');
    }
    redirect('' . base_url('Dadmin/dadminview/' . base64_encode($request_id)));
  }
  /*******************************
   * save_reference_check details details of dataentry
   * save_reference_check
   ****************************/
  function save_reference_check($formData)
  {
    $request_id = $formData['request_id'];
    $id = $formData['id'];
    if ($id == 0) {
      $insertData = elements(array(
        'request_id', 'level_name', 'title', 'firstname', 'middlename', 'lastname',
        'reference_name', 'reference_address', 'reference_company', 'reference_designation', 'reference_occupation',
        'reference_contact', 'reference_email', 'reference_relationship',
        'reference_knowntime', 'created_by', 'created_on', 'checkid'
      ), $formData);
    } else {
      $insertData = elements(array(
        'title', 'firstname', 'middlename', 'lastname',
        'reference_name', 'reference_address', 'reference_company', 'reference_designation', 'reference_occupation',
        'reference_contact', 'reference_email', 'reference_relationship',
        'reference_knowntime', 'updated_by', 'updated_on'
      ), $formData);
    }
    $insertData = $this->security->xss_clean($insertData);
    $this->amodel->dmlfunction(DB_PREFIX . "tenant_verification", array('id' => $id), $insertData, $id);
    if ($id == 0) {
      $this->updateprofilestatus($request_id, 'tenant_verification');
    }
    redirect('' . base_url('Dadmin/dadminview/' . base64_encode($request_id)));
  }
  /*******************************
   * save_vendor_referecnce_check details details of dataentry
   * save_vendor_referecnce_check
   ****************************/
  function save_vendor_referecnce_check($formData)
  {
    $request_id = $formData['request_id'];
    $id = $formData['id'];
    if ($formData) {
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'level_name', 'title', 'firstname', 'middlename', 'lastname',
          'client_company_name', 'client_address', 'client_landmark', 'client_telephone', 'checkid',
          'created_by', 'created_on'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'firstname', 'middlename', 'lastname',
          'client_company_name', 'client_address', 'client_landmark', 'client_telephone', 'updated_by', 'updated_on'
        ), $formData);
      }
      $insertData['providing_business_since'] = ($formData['providing_business_since']) ? date($this->ymd, strtotime($formData['providing_business_since'])) : NULL;
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "vendor_verification", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($request_id, 'vendor_verification');
      }
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($request_id)));
    }
  }
  /*******************************
   * insertcloneDetails details details of dataentry
   * insertcloneDetails
   ****************************/
  function insertcloneDetails($clonecount = 0, $insertValue = '', $marketId = '', $tablename = '', $editId = '', $fId = '', $cId = '', $lId = '')
  {
    if ($editId != 0) {
      $marketId = $editId;
    }

    $insertsales = array();
    $bulksave = array();
    if (!empty($_FILES['additional_doc']['name'])) {
      if ($clonecount != 0) {
        for ($i = 1; $i <= $clonecount; $i++) {
          $j = $i;
          if ($i == 1) {
            $j = '';
          }

          foreach ($insertValue as $value) {
            switch ($value) {
              case 'additional_doc':
              case '':
                //upload files
                $this->load->library('Upload');
                $config['allowed_types'] = 'jpg|png|jpeg|pdf';
                $config['upload_path'] = 'uploads/candidate/document/';
                $config['encrypt_name'] = true;
                $config['remove_spaces'] = true;
                $this->load->library('upload', $config);
                if (!empty($_FILES['additional_doc' . $j . $j]['name'])) {
                  $this->upload->initialize($config);
                  if ($this->upload->do_upload('additional_doc' . $j . $j)) {

                    $upload_data = $this->upload->data();
                    $image['original'] = $config['upload_path'] . '' . $upload_data['file_name'];
                    $config['source_image'] = getcwd() . '/uploads/candidate/document/' . $upload_data['file_name'];
                    $insertsales['additional_doc'] = $image['original'];
                  }
                }
                if ($this->upload->display_errors() != '') {

                  return $this->upload->display_errors();
                }

                $insertsales[$value] = $image['original'];
                break;

              default:
                $insertsales[$value] = $_POST[$value . $j];
                break;
            }
          }

          if ($fId == 14) {
            $insertsales['request_id'] = $editId;
            $insertsales['check_id'] = $fId;
            $insertsales['ref_id'] = $cId;
            $insertsales['status'] = '1';
            $insertsales['created_date'] = date('Y-m-d H:i:s');
          } elseif ($fId == 59) {
            $insertsales['request_id'] = $editId;
            $insertsales['check_id'] = $fId;
            $insertsales['ref_id'] = $cId;
            $insertsales['status'] = '1';
            $insertsales['created_date'] = date('Y-m-d H:i:s');
          } elseif ($fId == 1306) { // i have added the check id
            $insertsales['request_id'] = $editId;
            $insertsales['check_id'] = $fId;
            $insertsales['ref_id'] = $cId;
            $insertsales['status'] = '1';
            $insertsales['created_date'] = date('Y-m-d H:i:s');
          } else {
            $insertsales['request_id'] = $editId;
            $insertsales['check_id'] = '0';
            $insertsales['ref_id'] = '0';
            $insertsales['status'] = '1';
            $insertsales['created_date'] = date('Y-m-d H:i:s');
          }
          $bulksave[] = $insertsales;
        }
        $this->db->insert_batch($this->config->item('table_prefix') . $tablename, $bulksave);
      }
    }
    return 1;
  }
  /* new checks models on 07/06/2017 */
  /*******************************
   * aadhaarcheckkdml  details of dataentry
   * aadhaarcheckkdml
   ****************************/
  function aadhaarcheckkdml($id = 0)
  {
    $formData = $_POST;

    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);
      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "Aadhaar Card Verification") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "education_details a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();
      $formData['level_id'] = 'Aadhaar Card Verification';
      $documnets = array();
      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0) {
            redirect('' . base_url('Dataentry/aadhaar_card_verification_detailsadd/' . base64_encode($req_id)));
          } else {
            redirect('' . base_url('Dataentry/aadhaar_card_verification_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
          }
        }
      }
      /*--Added on 21st Nov --*/

      if (!empty($_FILES['upload_xml']['name'])) {

        $config['allowed_types'] = '*';
        $config['upload_path'] = 'uploads/candidate/aadhaarxml';
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('upload_xml')) {
          $xml_file  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0) {
            redirect('' . base_url('Dataentry/aadhaar_card_verification_detailsadd/' . base64_encode($req_id)));
          } else {
            redirect('' . base_url('Dataentry/aadhaar_card_verification_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
          }
        }
      }


      $formData['share_code'] = ($_POST['share_code']) ? $_POST['share_code'] : '';
      $formData['remarks'] = ($_POST['show_remarks']) ? $_POST['show_remarks'] : '';


      /*--------*/

      $formdata['state'] = ($_POST['state']) ? $_POST['state'] : '';
      $formdata['district'] = ($_POST['district']) ? $_POST['district'] : '';

      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'aadhaar_card_name', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'gender', 'address', 'pincode', 'state', 'district', 'aadhaar_no', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason', 'share_code'
        ), $formData);
      } else {
        $insertData = elements(array(
          'aadhaar_card_name', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'gender', 'address', 'pincode', 'state', 'district', 'aadhaar_no', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason', 'share_code'
        ), $formData);
      }
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }
      if ($xml_file['file_name'] <> '' && $formData['share_code'] <> '') {
        $insertData['upload_xml'] = $xml_file['file_name'];
        $insertData['upload_zip'] = $xml_file['file_name'];
      } elseif ($formData['file'] <> '' && $formData['share_code'] <> '') {
        $insertData['upload_xml'] = $formData['file'];
        $insertData['upload_zip'] = $formData['file'];
      } else {
        $insertData['upload_xml'] = '';
        $insertData['upload_zip'] = '';
      }
      if ($formData['share_code'] <> '' && $formData['share_code'] <> 0)
        $insertData['remarks'] = '';
      else
        $insertData['remarks'] = $formData['remarks'];
      if ($formData[$this->date_of_birth]) {
        $insertData[$this->date_of_birth] = date($this->ymd, strtotime($formData[$this->date_of_birth]));
      } else {
        $insertData[$this->date_of_birth] = NULL;
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "aadhaar_card_verification", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'aadhaar_card_verification');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  } // aadhaarcheckdml ends here

  /*******************************
   * pancheckdml details of dataentry
   * pancheckdml
   ****************************/
  function pancheckdml($id = 0)
  {
    $formData = $_POST;
    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);
      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "Pan Card Verification") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "pan_card_verification a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();
      $formData['level_id'] = 'Pan Card Verification';
      $documnets = array();
      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0)
            redirect('' . base_url('Dataentry/pan_card_verification_detailsadd/' . base64_encode($req_id)));
          else
            redirect('' . base_url('Dataentry/pan_card_verification_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
        }
      }
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'pancard_name', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'gender', 'pan_card_no', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'pancard_name', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'gender', 'pan_card_no', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }
      if ($formData[$this->date_of_birth]) {
        $insertData[$this->date_of_birth] = date($this->ymd, strtotime($formData[$this->date_of_birth]));
      } else {
        $insertData[$this->date_of_birth] = NULL;
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "pan_card_verification", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'pan_card_verification');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }
  /*******************************
   * passportcheckdml  details of dataentry
   * passportcheckdml
   ****************************/
  function passportcheckdml($id = 0)
  {
    $formData = $_POST;
    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);
      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "Passport Verification") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "passport_verification a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();
      $formData['level_id'] = 'Passport Verification';
      $documnets = array();


      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0)
            redirect('' . base_url('Dataentry/passport_verification_detailsadd/' . base64_encode($req_id)));
          else
            redirect('' . base_url('Dataentry/passport_verification_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
        }
      }

      $formdata['state'] = ($_POST['state']) ? $_POST['state'] : '';
      $formdata['district'] = ($_POST['district']) ? $_POST['district'] : '';
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'passport_name', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'gender', 'address', 'pincode', 'state', 'district', 'passport_no', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'passport_name', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'gender', 'address', 'pincode', 'state', 'district', 'passport_no', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }
      if ($formData[$this->date_of_birth]) {
        $insertData[$this->date_of_birth] = date($this->ymd, strtotime($formData[$this->date_of_birth]));
      } else {
        $insertData[$this->date_of_birth] = NULL;
      }
      if ($formData[$this->date_of_issue]) {
        $insertData[$this->date_of_issue] = date($this->ymd, strtotime($formData[$this->date_of_issue]));
      } else {
        $insertData[$this->date_of_issue] = NULL;
      }
      if ($formData['date_of_expiry']) {
        $insertData['date_of_expiry'] = date($this->ymd, strtotime($formData['date_of_expiry']));
      } else {
        $insertData['date_of_expiry'] = NULL;
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "passport_verification", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'passport_verification');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }
  /*******************************
   * votercheckdml  details of dataentry
   * votercheckdml
   ****************************/
  function votercheckdml($id = 0)
  {
    $formData = $_POST;
    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);
      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "Voter ID Verification") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "education_details a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();
      $formData['level_id'] = 'Voter ID Verification';
      $documnets = array();
      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0) {
            redirect('' . base_url('Dataentry/voter_id_verification_detailsadd/' . base64_encode($req_id)));
          } else {
            redirect('' . base_url('Dataentry/voter_id_verification_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
          }
        }
      }
      $formdata['state'] = ($_POST['state']) ? $_POST['state'] : '';
      $formdata['district'] = ($_POST['district']) ? $_POST['district'] : '';
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'voter_id_name', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'gender', 'address', 'pincode', 'state', 'district', 'voter_id_no', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'voter_id_name', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'gender', 'address', 'pincode', 'state', 'district', 'voter_id_no', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }
      if ($formData[$this->date_of_birth]) {
        $insertData[$this->date_of_birth] = date($this->ymd, strtotime($formData[$this->date_of_birth]));
      } else {
        $insertData[$this->date_of_birth] = NULL;
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "voter_id_verification", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'voter_id_verification');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }
  /*******************************
   * drivinglicencecheckdml details details of dataentry
   * drivinglicencecheckdml
   ****************************/
  function drivinglicencecheckdml($id = 0)
  {
    $formData = $_POST;
    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);
      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "Driving Licence Verification") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "passport_verification a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();
      $formData['level_id'] = 'Driving Licence Verification';
      $documnets = array();
      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0)
            redirect('' . base_url('Dataentry/driving_licence_verification_detailsadd/' . base64_encode($req_id)));
          else
            redirect('' . base_url('Dataentry/driving_licence_verification_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
        }
      }
      $formdata['state'] = ($_POST['state']) ? $_POST['state'] : '';
      $formdata['district'] = ($_POST['district']) ? $_POST['district'] : '';
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'driving_licence_name', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'gender', 'address', 'pincode', 'state', 'district', 'driving_licence_no', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'driving_licence_name', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'gender', 'address', 'pincode', 'state', 'district', 'driving_licence_no', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }
      if ($formData[$this->date_of_birth]) {
        $insertData[$this->date_of_birth] = date($this->ymd, strtotime($formData[$this->date_of_birth]));
      } else {
        $insertData[$this->date_of_birth] = NULL;
      }
      if ($formData['driving_date_of_issue']) {
        $insertData['driving_date_of_issue'] = date($this->ymd, strtotime($formData['driving_date_of_issue']));
      } else {
        $insertData['driving_date_of_issue'] = NULL;
      }
      if ($formData[$this->valid_up_to]) {
        $insertData[$this->valid_up_to] = date($this->ymd, strtotime($formData[$this->valid_up_to]));
      } else {
        $insertData[$this->valid_up_to] = NULL;
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "driving_licence_verification", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'driving_licence_verification');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }
  /*******************************
   * cibilcheckdml details details of dataentry
   * cibilcheckdml
   ****************************/
  function cibilcheckdml($id = 0)
  {
    $formData = $_POST;
    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);
      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "CIBIL Check") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "cibil_check a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();
      $formData['level_id'] = 'CIBIL Check';
      $documnets = array();


      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0) {
            redirect('' . base_url('Dataentry/cibil_check_detailsadd/' . base64_encode($req_id)));
          } else {
            redirect('' . base_url('Dataentry/cibil_check_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
          }
        }
      }
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'pancard_name', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name',
          'gender', 'pan_card_no', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'pancard_name', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name',
          'gender', 'pan_card_no', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }
      if ($formData[$this->date_of_birth]) {
        $insertData[$this->date_of_birth] = date($this->ymd, strtotime($formData[$this->date_of_birth]));
      } else {
        $insertData[$this->date_of_birth] = NULL;
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "cibil_check", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'cibil_check');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }
  /*******************************
   * form16checkdml  details of dataentry
   * form16checkdml
   ****************************/
  function form16checkdml($id = 0)
  {
    $formData = $_POST;
    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);
      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "Form 16 Check") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "form_16_verification a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();
      $formData['level_id'] = 'Form 16 Check';
      $documnets = array();
      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0) {
            redirect('' . base_url('Dataentry/form_16_verification_detailsadd/' . base64_encode($req_id)));
          } else {
            redirect('' . base_url('Dataentry/form_16_verification_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
          }
        }
      }
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'tan_of_deductor', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name',
          'gender', 'pancard_no', 'source_of_income', 'tds_amount_deducted', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'tan_of_deductor', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name',
          'gender', 'pancard_no', 'source_of_income', 'tds_amount_deducted', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }
      if ($formData[$this->date_of_birth]) {
        $insertData[$this->date_of_birth] = date($this->ymd, strtotime($formData[$this->date_of_birth]));
      } else {
        $insertData[$this->date_of_birth] = NULL;
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "form_16_verification", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'form_16_verification');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }
  /*******************************
   * save_court_record_lf_checkdml details details of dataentry
   * save_court_record_lf_checkdml
   ****************************/
  function save_court_record_lf_checkdml($id = 0)
  {
    $formData = $_POST;
    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);
      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "Court Record Check LF") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "court_record_check_lf a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();
      $formData['level_id'] = 'Court Record Check LF';
      $documnets = array();
      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0)
            redirect('' . base_url('Dataentry/court_record_lf_detailsadd/' . base64_encode($req_id)));
          else
            redirect('' . base_url('Dataentry/court_record_lf_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
        }
      }
      $date_of_birth = $_POST[$this->date_of_birth];
      $formData[$this->date_of_birth] = ($date_of_birth) ? date($this->ymd, strtotime($date_of_birth)) : NULL;
      $formdata['state'] = ($_POST['state']) ? $_POST['state'] : '';
      $formdata['district'] = ($_POST['district']) ? $_POST['district'] : '';
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', $this->date_of_birth,
          'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'pincode', 'current_pincode', 'can_policestation', 'state', 'district', 'clandmark', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason', 'pincode_before_marriage', 'address_before_marriage', 'p_before_marriage', 'pincode_after_marriage', 'address_after_marriage', 'p_after_marriage'
        ), $formData);
      } else {
        $insertData = elements(array(
          'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', $this->date_of_birth,
          'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'pincode', 'current_pincode', 'can_policestation', 'state', 'district', 'clandmark', 'updated_on', 'updated_by', 'check_status', 'insuff_details', 'check_type', 'check_status_reason', 'pincode_before_marriage', 'address_before_marriage', 'p_before_marriage', 'pincode_after_marriage', 'address_after_marriage', 'p_after_marriage'
        ), $formData);
      }
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "court_record_check_lf", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'court_record_check_lf');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }
  /*******************************
   * save_court_record_checkdml details details of dataentry
   * save_court_record_checkdml
   ****************************/
  function save_court_record_checkdml($id = 0)
  {
    $formData = $_POST;

    $req_id = $_POST['request_id'];
    $where = '(request_id="' . $req_id . '" AND check_id = "' . $_POST['checkid'] . '")';
    $this->db->select('SUM(no_checks) as no_checks,full_info');
    $this->db->where($where);
    $chkcount = $this->db->get(DB_PREFIX . 'request_check')->row_array();
    $check_No = $chkcount['no_checks'];

    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);
      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "Court Record Check") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "court_record_check a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();
      $formData['level_id'] = 'Court Record Check ';
      $documnets = array();
      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0) {
            redirect('' . base_url('Dataentry/court_record_detailsadd/' . base64_encode($req_id)));
          } else {
            redirect('' . base_url('Dataentry/court_record_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
          }
        }
      }
      $date_of_birth = $_POST[$this->date_of_birth];
      $formData[$this->date_of_birth] = ($date_of_birth) ? date($this->ymd, strtotime($date_of_birth)) : NULL;
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'level_name', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', $this->date_of_birth,
          'address', 'period_of_stay', 'address_type', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason', 'pincode', 'pincode_before_marriage', 'address_before_marriage', 'p_before_marriage', 'pincode_after_marriage', 'address_after_marriage', 'p_after_marriage'
        ), $formData);
      } else {
        $insertData = elements(array(
          'request_id', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', $this->date_of_birth, 'address_type',
          'address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'pincode', 'current_pincode', 'can_policestation', 'state', 'district', 'clandmark', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason', 'pincode_before_marriage', 'address_before_marriage', 'p_before_marriage', 'pincode_after_marriage', 'address_after_marriage', 'p_after_marriage'
        ), $formData);
      }
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "court_record_check", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'court_record_check');
      }
      if ($check_No == 99) {
        redirect(base_url("Dataentry/court_record_check_detailsadd/" . base64_encode($_POST['request_id']) . '/' . base64_encode($_POST['checkid'])), 'refresh');
      } else {
        $view_id = $this->getuserid($req_id);
        $view = $view_id[0]['request_id'];
        redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
      }
    }
  }
  /*******************************
   * ofaccheckdml  details of dataentry
   * ofaccheckdml
   ****************************/
  function ofaccheckdml($id = 0)
  {
    $formData = $_POST;
    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);
      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "OFAC") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "ofac a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();
      $formData['level_id'] = 'OFAC';
      $documnets = array();
      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0) {
            redirect('' . base_url('Dataentry/ofac_detailsadd/' . base64_encode($req_id)));
          } else {
            redirect('' . base_url('Dataentry/ofac_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
          }
        }
      }
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'full_name', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name',
          'gender', 'int_country', 'nationality', 'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'address_proof_type', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'full_name', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name',
          'gender', 'int_country', 'nationality', 'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'address_proof_type', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }
      if ($formData[$this->date_of_birth]) {
        $insertData[$this->date_of_birth] = date($this->ymd, strtotime($formData[$this->date_of_birth]));
      } else {
        $insertData[$this->date_of_birth] = NULL;
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "ofac", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'ofac');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }
  /*******************************
   * ustravelcheckdml details details of dataentry
   * ustravelcheckdml
   ****************************/
  function ustravelcheckdml($id = 0)
  {
    $formData = $_POST;
    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);
      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "US Travel Check") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "us_travel_verification a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();
      $formData['level_id'] = 'US Travel Check';
      $documnets = array();
      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0)
            redirect('' . base_url('Dataentry/us_travel_verification_detailsadd/' . base64_encode($req_id)));
          else
            redirect('' . base_url('Dataentry/us_travel_verification_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
        }
      }
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'full_name', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name',
          'gender', 'passport_no', 'passport_issuance', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'full_name', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name',
          'gender', 'passport_no', 'passport_issuance', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }
      if ($formData[$this->date_of_birth]) {
        $insertData[$this->date_of_birth] = date($this->ymd, strtotime($formData[$this->date_of_birth]));
      } else {
        $insertData[$this->date_of_birth] = NULL;
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "us_travel_verification", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'us_travel_verification');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }
  /*******************************
   * save_police_current_address_verificaion details details of dataentry
   * save_police_current_address_verificaion
   ****************************/
  function save_police_current_address_verificaion($formData, $id = 0)
  {
    if ($formData) {
      $request_id = $formData['request_id'];
      $documnets = array();
      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0) {
            redirect('' . base_url('Dataentry/police_current_address_verification_detailsadd/' . base64_encode($req_id)));
          } else {
            redirect('' . base_url('Dataentry/police_current_address_verification_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
          }
        }
      } else if ($id == 0 && empty($_FILES['address_proof']['name'])) {
        $documnets['file_name'] = $formData['oldaddressproof'];
      }
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'permanent_address', 'period_of_stay', 'current_address',
          'cperiod_of_stay', 'mobile', 'pincode', 'landmark', 'cmobile', 'cpincode', 'clandmark',
          'address_proof_type', 'police_station', 'created_by', 'checkid', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name',
          'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'mobile', 'pincode', 'landmark',
          'cmobile', 'cpincode', 'clandmark', 'address_proof_type', 'police_station', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      $insertData['current_tel_no'] = $formData['current_country'] . '-' . $formData['current_city'] . '-' . $this->encryption->encrypt($formData['current_no']);
      $insertData['permanent_tel_no'] = $formData['permanent_country'] . '-' . $formData['permanent_city'] . '-' . $formData['permanent_no'];
      $insertData['office_tel_no'] = $formData['office_country'] . '-' . $formData['office_city'] . '-' . $formData['office_no'];
      $insertData['coffice_tel_no'] = $formData['coffice_country'] . '-' . $formData['coffice_city'] . '-' . $this->encryption->encrypt($formData['coffice_no']);
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "police_current_address_verification", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($formData['request_id'], 'police_current_address_verification');
      }
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($formData['request_id'])));
    }
  }
  function save_international_criminal_checkdml($id = 0)
  {
    $formData = $_POST;


    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);



      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "International Criminal check") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "international_criminal_check a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();

      $formData['level_id'] = 'International Criminal check';
      $documnets = array();
      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0)
            redirect('' . base_url('Dataentry/international_criminal_check_detailsadd/' . base64_encode($req_id)));
          else
            redirect('' . base_url('Dataentry/international_criminal_check_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
        }
      }


      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', $this->date_of_birth,
          'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'pincode', 'district', 'state', 'country',      'cdistrict', 'cstate', 'ccountry', 'current_pincode', 'can_policestation', 'clandmark', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', $this->date_of_birth,
          'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'pincode', 'district', 'state', 'country',      'cdistrict', 'cstate', 'ccountry', 'current_pincode', 'can_policestation', 'clandmark', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }

      $insertData['period_fromp'] = ($formData['period_fromp']) ? date($this->ymd, strtotime($formData['period_fromp'])) : NULL;
      $insertData['period_top'] = ($formData['period_top']) ? date($this->ymd, strtotime($formData['period_top'])) : NULL;

      $insertData['cperiod_from'] = ($formData['cperiod_from']) ? date($this->ymd, strtotime($formData['cperiod_from'])) : NULL;
      $insertData['cperiod_to'] = ($formData['cperiod_to']) ? date($this->ymd, strtotime($formData['cperiod_to'])) : NULL;

      $insertData = $this->security->xss_clean($insertData);


      $this->amodel->dmlfunction(DB_PREFIX . "international_criminal_check", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'international_criminal_check');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }

  function international_address_checkdml($id = 0)
  {

    $Cmobile = $this->encryption->encrypt($_POST['cmobile']);
    $formData = $_POST;


    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);
      $formData['cmobile'] = $Cmobile;

      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "International Address Check (Current Address)") {
          $level_id[] = $cd['level_id'];
        }
      }


      $formData['level_id'] = 'International Address Check (Current Address)';
      $documnets = array();
      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0)
            redirect('' . base_url('Dataentry/international_address_check_current_address_detailsadd/' . base64_encode($req_id)));
          else
            redirect('' . base_url('Dataentry/international_address_check_current_address_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
        }
      }
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'level_id', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'gender', 'current_address', 'cperiod_of_stay', 'cmobile', 'cpincode', 'clandmark', 'other_details', 'address_proof_type', 'state', 'district', 'country',
          'crental_type', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason', 'other_details_crental'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'checkid', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', 'gender', 'state', 'district', 'country',
          'current_address', 'cperiod_of_stay', 'crental_type', 'other_details',
          'cmobile', 'cpincode', 'clandmark', 'address_proof_type', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason', 'other_details_crental'
        ), $formData);
      }
      $insertData['cperiod_from'] = ($formData['cperiod_from']) ? date($this->ymd, strtotime($formData['cperiod_from'])) : NULL;
      $insertData['cperiod_to'] = ($formData['cperiod_to']) ? date($this->ymd, strtotime($formData['cperiod_to'])) : NULL;
      $insertData['current_tel_no'] = $formData['current_country'] . '-' . $formData['current_city'] . '-' . $this->encryption->encrypt($formData['current_no']);
      $insertData['coffice_tel_no'] = $formData['coffice_country'] . '-' . $formData['coffice_city'] . '-' . $formData['coffice_no'];
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "international_address_check_current_address", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($user_id, 'international_address_check_current_address');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }

  function intaddresspermanentdml($id = 0)
  {

    $Mobile = $this->encryption->encrypt($_POST['mobile']);
    $formData = $_POST;

    if ($formData) {
      $formData['mobile'] = $Mobile;
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);

      foreach ($chkdt as $cd) {

        if ($cd['check_name'] == "International Address check (Permanent Address)") {
          $level_id[] = $cd['level_id'];
        }
      }

      $formData['level_id'] = 'International Address check (Permanent Address)';
      $documnets = array();
      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0)
            redirect('' . base_url('Dataentry/international_address_check_permanent_detailsadd/' . base64_encode($req_id)));
          else
            redirect('' . base_url('Dataentry/international_address_check_permanent_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
        }
      }
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'level_id', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'gender', 'permanent_address', 'period_of_stay', 'mobile', 'pincode', 'landmark', 'country', 'district', 'state', 'other_details', 'address_proof_type',
          'rental_type', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason', 'other_details_crental'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'checkid', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', 'gender',
          'permanent_address', 'period_of_stay', 'mobile', 'pincode', 'landmark', 'country', 'district', 'state', 'other_details',
          'rental_type', 'address_proof_type', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason', 'other_details_crental'
        ), $formData);
      }
      $insertData['period_fromp'] = ($formData['period_fromp']) ? date($this->ymd, strtotime($formData['period_fromp'])) : NULL;
      $insertData['period_top'] = ($formData['period_top']) ? date($this->ymd, strtotime($formData['period_top'])) : NULL;
      $insertData['permanent_tel_no'] = $formData['permanent_country'] . '-' . $formData['permanent_city'] . '-' . $this->encryption->encrypt($formData['permanent_no']);
      $insertData['office_tel_no'] = $formData['office_country'] . '-' . $formData['office_city'] . '-' . $formData['office_no'];
      $insertData['coffice_tel_no'] = $formData['coffice_country'] . '-' . $formData['coffice_city'] . '-' . $formData['coffice_no'];
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "international_address_check_permanent_address", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($user_id, 'international_address_check_permanent_address');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }

  function bankruptcycheckdml($id = 0)
  {
    $EmailId = $this->encryption->encrypt($_POST['email_id']);
    $formData = $_POST;

    if ($formData) {
      $formData['email_id'] = $EmailId;
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);

      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "International Bankruptcy Check (Individual)") {
          $level_id[] = $cd['level_id'];
        }
      }

      $formData['level_id'] = 'International Bankruptcy Check (Individual)';
      $documnets = array();


      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'email_id', 'contact_no', 'gender', 'marital', 'idcardno',
          'created_by', 'created_on', 'check_status', 'check_type', 'check_status_reason', 'type_of_id', 'permanent_address', 'current_address', 'cperiod_of_stay', 'pincode', 'district', 'state', 'current_pincode', 'clandmark', 'can_policestation', 'country', 'cdistrict', 'cstate', 'ccountry'
        ), $formData);
      } else {
        $insertData = elements(array('checkid', 'title', 'firstname', 'middlename', 'lastname', 'email_id', 'contact_no', 'gender', 'marital', 'idcardno', 'updated_by', 'updated_on', 'check_status', 'check_type', 'check_status_reason', 'type_of_id', 'permanent_address', 'current_address', 'cperiod_of_stay', 'pincode', 'district', 'state', 'current_pincode', 'clandmark', 'can_policestation', 'country', 'cdistrict', 'cstate', 'ccountry'), $formData);
      }

      if ($formData[$this->date_of_birth]) {
        $insertData[$this->date_of_birth] = date($this->ymd, strtotime($formData[$this->date_of_birth]));
      } else {
        $insertData[$this->date_of_birth] = NULL;
      }

      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "international_bankruptcy_check_individual", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'international_bankruptcy_check_individual');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }

  function insertTDSDetails($clonecount = 0, $insertValue = '', $marketId = '', $tablename = '', $editId = '', $fId = '', $cId = '', $lId = '')
  {


    if ($editId != 0) {
      $marketId = $editId;
    }

    $insertsales = array();
    $bulksave = array();
    if (!empty($_FILES['tds_proof']['name'])) {
      if ($clonecount != 0) {
        for ($i = 1; $i <= $clonecount; $i++) {
          $j = $i;
          if ($i == 1) {
            $j = '';
          }

          foreach ($insertValue as $value) {

            switch ($value) {
              case 'tds_proof':
              case '':
                //upload files
                $this->load->library('Upload');
                $config['allowed_types'] = 'jpg|png|jpeg|pdf';
                $config['upload_path'] = 'uploads/candidate/document/';
                $config['encrypt_name'] = true;
                $config['remove_spaces'] = true;
                $this->load->library('upload', $config);
                if (!empty($_FILES['tds_proof' . $j . $j]['name'])) {
                  $this->upload->initialize($config);
                  if ($this->upload->do_upload('tds_proof' . $j . $j)) {

                    $upload_data = $this->upload->data();
                    $image['original'] = $config['upload_path'] . '' . $upload_data['file_name'];
                    $config['source_image'] = getcwd() . '/uploads/candidate/document/' . $upload_data['file_name'];
                    $insertsales['tds_proof'] = $image['original'];
                  }
                }
                if ($this->upload->display_errors() != '') {

                  return $this->upload->display_errors();
                }

                $insertsales[$value] = $image['original'];
                break;

              default:
                $insertsales[$value] = $_POST[$value . $j];
                break;
            }
          }

          if ($fId == 14) {
            $insertsales['request_id'] = $editId;
            $insertsales['check_id'] = $fId;
            $insertsales['ref_id'] = $cId;
            $insertsales['status'] = '1';
            $insertsales['created_date'] = date('Y-m-d H:i:s');
          } elseif ($fId == 59) {
            $insertsales['request_id'] = $editId;
            $insertsales['check_id'] = $fId;
            $insertsales['ref_id'] = $cId;
            $insertsales['status'] = '1';
            $insertsales['created_date'] = date('Y-m-d H:i:s');
          } else {
            $insertsales['request_id'] = $editId;
            $insertsales['check_id'] = '0';
            $insertsales['ref_id'] = '0';
            $insertsales['status'] = '1';
            $insertsales['created_date'] = date('Y-m-d H:i:s');
          }
          $bulksave[] = $insertsales;
        }
        // echo "<pre>";
        // print_r($bulksave);exit();

        $this->db->insert_batch($this->config->item('table_prefix') . $tablename, $bulksave);
      }
    }
    return 1;
  }

  function form26ascheckdml($id = 0)
  {
    $formData = $_POST;
    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);
      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "Form 16 Check") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "form_26as a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();
      $formData['level_id'] = 'Form 26AS Check';

      $p = 1;
      $user_id = $formData['request_id'];
      $upload_files = array('tan_of_deductor', 'source_of_income', 'tds_amount_deducted', 'tds_proof');
      $status = $this->insertTDSDetails($_POST['count'], $upload_files, $return_id, 'tds_doc', $user_id, '', '', '');

      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name',
          'gender', 'pancard_no', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name',
          'gender', 'pancard_no', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }

      if ($formData[$this->date_of_birth]) {
        $insertData[$this->date_of_birth] = date($this->ymd, strtotime($formData[$this->date_of_birth]));
      } else {
        $insertData[$this->date_of_birth] = NULL;
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "form_26as", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'form_26as');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }

  function prc_colleguecheckdml($id = 0)
  {
    $formData = $_POST;
    if ($formData) {
      $req_id = $formData['request_id'];

      $chkdt = $this->getcheck($req_id);

      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "Professional Reference Check Collegue") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "professional_reference_check_colleague a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();
      $formData['level_id'] = 'Professional Reference Collegue';

      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'company_name', 'office_address',
          'branch_address', 'telephone_no', 'designation', 'department', 'employee_code', 'college_name', 'college_designation', 'college_email_id', 'college_contact_no', 'period_of_reference', 'reference_relationship', 'reason', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type'
        ), $formData);
      } else {
        $insertData = elements(array(
          'checkid', 'title', 'firstname', 'middlename', 'lastname', 'company_name', 'office_address',
          'branch_address', 'telephone_no', 'designation', 'department', 'employee_code', 'college_name', 'college_designation', 'college_email_id', 'college_contact_no', 'period_of_reference', 'reference_relationship', 'reason', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type'
        ), $formData);
      }

      if ($formData['period_from'] && $formData['period_to']) {
        $insertData['period_from'] = date($this->ymd, strtotime($formData['period_from']));
        $insertData['period_to'] = date($this->ymd, strtotime($formData['period_to']));
      } else {
        $insertData['period_from'] = NULL;
        $insertData['period_to'] = NULL;
      }

      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "professional_reference_check_colleague", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'professional_reference_check_colleague');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }


  /*******************************
   * save_common_database_check details details of dataentry
   * save_common_database_check
   ****************************/
  function facischeckdml($table, $formData, $id = 0)
  {
    if ($formData) {
      $request_id = $formData['request_id'];
      $documnets = array();
      $date_of_birth = $_POST[$this->date_of_birth];
      $formData[$this->date_of_birth] = ($date_of_birth) ? date($this->ymd, strtotime($date_of_birth)) : NULL;
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'date_of_birth',
          'permanent_address', 'period_of_stay', 'checkid', 'created_by', 'created_on', 'check_status', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'date_of_birth',
          'permanent_address', 'period_of_stay', 'updated_by', 'updated_on', 'check_status', 'check_type', 'check_status_reason'
        ), $formData);
      }
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . $table, array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($formData['request_id'], $table);
      }
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($formData['request_id'])));
    }
  }

  /*******************************
   * save_common_database_check details details of dataentry
   * save_common_database_check
   ****************************/
  function intcreditcheckdml($table, $formData, $id = 0)
  {
    $formData = $_POST;
    if ($formData) {
      $request_id = $formData['request_id'];
      $date_of_birth = $_POST[$this->date_of_birth];
      $formData[$this->date_of_birth] = ($date_of_birth) ? date($this->ymd, strtotime($date_of_birth)) : NULL;
      $documnets = array();
      $config['allowed_types'] = '*';
      $config['upload_path'] = 'uploads/candidate/document';
      $config['encrypt_name'] = true;
      $config['remove_spaces'] = true;
      $this->load->library('upload', $config);
      $count = count($_FILES['passport_file']['size'] || $_FILES['national_id_file']['size']);
      $s = 0;
      foreach ($_FILES as $key => $value) {

        $_FILES['userfile']['name'] = $value['name'];
        $_FILES['userfile']['type']    = $value['type'];
        $_FILES['userfile']['tmp_name'] = $value['tmp_name'];
        $_FILES['userfile']['error']       = $value['error'];
        $_FILES['userfile']['size']    = $value['size'];

        if ($this->upload->do_upload()) {
          $documnets[$key]  = $this->upload->data();
        }
        $s++;
      }
      $p = 1;
      $user_id = $formData['request_id'];
      $upload_files = array('current_address', 'cperiod_of_stay', 'cperiod_from', 'cperiod_to');
      $status = $this->insertICCDetails($_POST['count'], $upload_files, $return_id, 'icc_doc', $user_id, '', '', '');
      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'date_of_birth', 'checkid', 'created_by', 'created_on', 'check_status', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'title', 'firstname', 'middlename', 'lastname', 'father_name',
          'husband_name', 'date_of_birth', 'updated_by', 'updated_on', 'check_status', 'check_type', 'check_status_reason'
        ), $formData);
      }


      if (isset($_POST['psptstatus']) && $_POST['psptstatus'] == 1) {
        if (!empty($documnets['passport_file'])) {
          $insertData['passport_file'] = $documnets['passport_file']['file_name'];
          $insertData['psptstatus'] = 1;
          $insertData['passport_remark'] = '';
        }
      } else {
        $insertData['passport_remark'] = $_POST['passport_remark'];
        $insertData['psptstatus'] = 0;
      }

      if (isset($_POST['nat_id_status']) && $_POST['nat_id_status'] == 1) {
        if (!empty($documnets['national_id_file'])) {
          $insertData['national_id_file'] = $documnets['national_id_file']['file_name'];
          $insertData['nat_id_status'] = 1;
          $insertData['nat_id_remark'] = '';
        }
      } else {
        $insertData['nat_id_remark'] = $_POST['nat_id_remark'];
        $insertData['nat_id_status'] = 0;
      }
      echo $documents;
      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . $table, array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($formData['request_id'], $table);
      }
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($formData['request_id'])));
    }
  }
  function insertICCDetails($clonecount = 0, $insertValue = '', $marketId = '', $tablename = '', $editId = '', $fId = '', $cId = '', $lId = '')
  {

    if ($editId != 0) {
      $marketId = $editId;
    }

    $insertsales = array();
    $bulksave = array();
    if (!empty($_POST['current_address'])) {
      if ($clonecount != 0) {
        for ($i = 1; $i <= $clonecount; $i++) {
          $j = $i;
          if ($i == 1) {
            $j = '';
          }

          foreach ($insertValue as $value) {


            $insertsales[$value] = $_POST[$value . $j];
          }

          $insertsales['request_id'] = $editId;
          $insertsales['check_id'] = $_POST['checkid'];
          $insertsales['ref_id'] = $j;
          $insertsales['status'] = '1';
          $insertsales['created_date'] = date('Y-m-d H:i:s');

          $bulksave[] = $insertsales;
        }

        $this->db->insert_batch($this->config->item('table_prefix') . $tablename, $bulksave);
      }
    }

    return 1;
  }


  function declerationtext($request_id)
  {
    $this->db->select('a.signature,c.declaration_text,c.doc_type')
      ->from(DB_PREFIX . 'declaration_details as a')
      ->join(DB_PREFIX . 'company_decl as c', 'c.id=a.user_declr')
      ->where('a.user_id', $request_id);
    return $this->db->get()->result_array();
  }



  /**********************PF_Verification *********
   * PFdml details of dataentry
  pfdml
   ****************************/
  function pfdml($id = 0)
  {
    $formData = $_POST;

    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);

      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "PF Verification") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "pf_verification a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();

      $formData['UAN_number'] = base64_encode($formData['UAN_number']);
      $formData['PF_number'] = base64_encode($formData['PF_number']);

      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'title', 'UAN_number', 'PF_number', 'firstname', 'middlename', 'lastname', 'father_name',
          'gender', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'checkid', 'title', 'UAN_number', 'PF_number', 'firstname', 'middlename', 'lastname', 'father_name',
          'gender', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }

      if ($formData[$this->date_of_birth]) {
        $insertData[$this->date_of_birth] = date($this->ymd, strtotime($formData[$this->date_of_birth]));
      } else {
        $insertData[$this->date_of_birth] = NULL;
      }

      $insertData = $this->security->xss_clean($insertData);
      $this->amodel->dmlfunction(DB_PREFIX . "pf_verification", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'pf_verification');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }
  /********************* END PF_Verification********************************************/


  /***********************************************************************************
   * international_civil_check_
   * Add international_civil_check_ details of dataentry
   ***********************************************************/

  /***********************************************************************************
   * international_civil_check_
   * Add international_civil_check_ details of dataentry
   ***********************************************************/

  function save_international_civil_checkdml($id = 0)
  {
    $formData = $_POST;


    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);



      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "International Civil check") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "international_civil_check a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();

      $formData['level_id'] = 'International Civil check';
      $documnets = array();
      if (!empty($_FILES['address_proof']['name'])) {
        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('address_proof')) {
          $documnets  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0)
            redirect('' . base_url('Dataentry/international_civil_check_detailsadd/' . base64_encode($req_id)));
          else
            redirect('' . base_url('Dataentry/international_civil_check_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
        }
      }


      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', $this->date_of_birth,
          'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'pincode', 'district', 'state', 'country',      'cdistrict', 'cstate', 'ccountry', 'current_pincode', 'can_policestation', 'clandmark', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', $this->date_of_birth,
          'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'pincode', 'district', 'state', 'country',      'cdistrict', 'cstate', 'ccountry', 'current_pincode', 'can_policestation', 'clandmark', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      if ($documnets['file_name'] <> '') {
        $insertData['address_proof'] = $documnets['file_name'];
      }

      $insertData['period_fromp'] = ($formData['period_fromp']) ? date($this->ymd, strtotime($formData['period_fromp'])) : NULL;
      $insertData['period_top'] = ($formData['period_top']) ? date($this->ymd, strtotime($formData['period_top'])) : NULL;

      $insertData['cperiod_from'] = ($formData['cperiod_from']) ? date($this->ymd, strtotime($formData['cperiod_from'])) : NULL;
      $insertData['cperiod_to'] = ($formData['cperiod_to']) ? date($this->ymd, strtotime($formData['cperiod_to'])) : NULL;

      $insertData = $this->security->xss_clean($insertData);


      $this->amodel->dmlfunction(DB_PREFIX . "international_civil_check", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'international_civil_check');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }

  /***********************************************************************************
   * END international_civil_check_
   * Add international_civil_check_ details of dataentry
   ***********************************************************/

  /***********************************************************************************
   * international_corruption_record_check_
   * Add international_corruption_record_check_ details of dataentry
   ***********************************************************/

  function save_international_corruption_record_checkdml($id = 0)
  {
    $formData = $_POST;


    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);



      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "International Corruption Record Check") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "international_corruption_record_check a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();

      $formData['level_id'] = 'International Corruption Record Check';
      $docu = array();

      if (!empty($_FILES['document']['name'])) {

        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('document')) {
          $docu  = $this->upload->data();
        }



        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0)
            redirect('' . base_url('Dataentry/international_corruption_record_check_detailsadd/' . base64_encode($req_id)));
          else
            redirect('' . base_url('Dataentry/international_corruption_record_check_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
        }
      }


      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', $this->date_of_birth,
          'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'pincode', 'district', 'state', 'country',      'cdistrict', 'cstate', 'ccountry', 'current_pincode', 'can_policestation', 'clandmark', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', $this->date_of_birth,
          'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'pincode', 'district', 'state', 'country',      'cdistrict', 'cstate', 'ccountry', 'current_pincode', 'can_policestation', 'clandmark', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      if (isset($_POST['dstatus']) && $_POST['dstatus'] == 1) {

        if (!empty($docu['file_name'])) {
          $insertData['local_document_file'] = $docu['file_name'];
          $insertData['local_docustatus'] = 1;
          $insertData['local_document_remarks'] = '';
        }
      } else {

        $insertData['local_document_remarks'] = $_POST['remarks'];
        $insertData['local_docustatus'] = 0;
        $insertData['local_document_file'] = '';
      }
      $insertData['period_fromp'] = ($formData['period_fromp']) ? date($this->ymd, strtotime($formData['period_fromp'])) : NULL;
      $insertData['period_top'] = ($formData['period_top']) ? date($this->ymd, strtotime($formData['period_top'])) : NULL;

      $insertData['cperiod_from'] = ($formData['cperiod_from']) ? date($this->ymd, strtotime($formData['cperiod_from'])) : NULL;
      $insertData['cperiod_to'] = ($formData['cperiod_to']) ? date($this->ymd, strtotime($formData['cperiod_to'])) : NULL;

      $insertData = $this->security->xss_clean($insertData);


      $this->amodel->dmlfunction(DB_PREFIX . "international_corruption_record_check", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'international_corruption_record_check');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }

  /***********************************************************************************
   * END international_credit_check_
   * Add international_credit_check_ details of dataentry
   ***********************************************************/



  function save_international_credit_checkdml($id = 0)
  {
    $formData = $_POST;


    if ($formData) {
      $req_id = $formData['request_id'];
      $chkdt = $this->getcheck($req_id);



      foreach ($chkdt as $cd) {
        if ($cd['check_name'] == "International Credit check") {
          $level_id[] = $cd['level_id'];
        }
      }
      $sql = "SELECT COUNT(a.id) as cnt FROM " . DB_PREFIX . "international_credit_check a WHERE a.request_id=" . $req_id;
      $query = $this->db->query($sql);
      $res = $query->result_array();

      $formData['level_id'] = 'International Credit check';
      $documnets = array();
      $docu = array();

      if (!empty($_FILES['document']['name'])) {

        $config['allowed_types'] = 'doc|pdf|jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/candidate/document';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('document')) {
          $docu  = $this->upload->data();
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          if ($id == 0)
            redirect('' . base_url('Dataentry/international_credit_check_detailsadd/' . base64_encode($req_id)));
          else
            redirect('' . base_url('Dataentry/international_credit_check_detailsadd/' . base64_encode($req_id) . '/' . base64_encode($id)));
        }
      }


      if ($id == 0) {
        $insertData = elements(array(
          'request_id', 'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', $this->date_of_birth,
          'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'pincode', 'district', 'state', 'country',      'cdistrict', 'cstate', 'ccountry', 'current_pincode', 'can_policestation', 'clandmark', 'created_by', 'created_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      } else {
        $insertData = elements(array(
          'checkid', 'title', 'firstname', 'middlename', 'lastname', 'father_name', 'husband_name', $this->date_of_birth,
          'permanent_address', 'period_of_stay', 'current_address', 'cperiod_of_stay', 'pincode', 'district', 'state', 'country',      'cdistrict', 'cstate', 'ccountry', 'current_pincode', 'can_policestation', 'clandmark', 'updated_by', 'updated_on', 'check_status', 'insuff_details', 'check_type', 'check_status_reason'
        ), $formData);
      }
      if (isset($_POST['dstatus']) && $_POST['dstatus'] == 1) {

        if (!empty($docu['file_name'])) {
          $insertData['local_docu_file'] = $docu['file_name'];
          $insertData['local_docu_status'] = 1;
          $insertData['local_docu_remarks'] = '';
        }
      } else {

        $insertData['local_docu_remarks'] = $_POST['remarks'];
        $insertData['local_docu_status'] = 0;
        $insertData['local_docu_file'] = '';
      }

      $insertData['period_fromp'] = ($formData['period_fromp']) ? date($this->ymd, strtotime($formData['period_fromp'])) : NULL;
      $insertData['period_top'] = ($formData['period_top']) ? date($this->ymd, strtotime($formData['period_top'])) : NULL;

      $insertData['cperiod_from'] = ($formData['cperiod_from']) ? date($this->ymd, strtotime($formData['cperiod_from'])) : NULL;
      $insertData['cperiod_to'] = ($formData['cperiod_to']) ? date($this->ymd, strtotime($formData['cperiod_to'])) : NULL;

      $insertData = $this->security->xss_clean($insertData);


      $this->amodel->dmlfunction(DB_PREFIX . "international_credit_check", array('id' => $id), $insertData, $id);
      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'international_credit_check');
      }
      $view_id = $this->getuserid($req_id);
      $view = $view_id[0]['request_id'];
      redirect('' . base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }

  /***********************************************************************************
   * END international_credit_check_
   * Add international_credit_ details of dataentry
   ***********************************************************/


  /******************************************************************************************/
  /* gap_analysis
    * gap_analysis details of dataentry_model
    added by kavya on 9th feb 
    ***********************************************************/
  // iam adding on 17th feb

  function addgapanalysisdml($id = 0)
  {
    $formData = $_POST;
    if ($formData) {
      $req_id = $formData['request_id'];
      $gapDaysFound = false;

      foreach ($formData['previous_org'] as $key => $org) {
        if (!empty($formData['gap_duration'][$key])) {
          $gapDaysFound = true;
          break;
        }
      }

      $jsonData = [];
      if (!$gapDaysFound) {

        foreach ($formData['previous_org'] as $key => $org) {
          $gap_reason_emp = $this->sanitizeGapReason($formData['gap_reason_emp'][$key]); //code modified on july 17
          $record = [
            'previous_org' => $org,
            'previous_join_date' => $formData['previous_join_date'][$key],
            'previous_exit_date' => $formData['previous_exit_date'][$key],
            'next_org' => $formData['next_org'][$key],
            'next_join_date' => $formData['next_join_date'][$key],
            'next_exit_date' => $formData['next_exit_date'][$key],
            'gap_duration' => '',
            // 'gap_reason' => $formData['gap_reason'][$key]
            'gap_reason_emp' => $gap_reason_emp //code modified on july 17
          ];
          $jsonData[] = $record;
          //ka added on july 17
          if (!empty($record['gap_reason_emp'])) {
            $this->amodel->updateEmploymentGapReason($record['previous_org'], $record['previous_join_date'], $record['gap_reason_emp']);
          } //ka added on july 17
        }
      } else {

        foreach ($formData['previous_org'] as $key => $org) {
          $gap_reason_emp = $this->sanitizeGapReason($formData['gap_reason_emp'][$key]); // code modified on july 17
          $record = [
            'previous_org' => $org,
            'previous_join_date' => $formData['previous_join_date'][$key],
            'previous_exit_date' => $formData['previous_exit_date'][$key],
            'next_org' => $formData['next_org'][$key],
            'next_join_date' => $formData['next_join_date'][$key],
            'next_exit_date' => $formData['next_exit_date'][$key],
            'gap_duration' => $formData['gap_duration'][$key],
            // 'gap_reason' => $formData['gap_reason'][$key]
            'gap_reason_emp' => $gap_reason_emp //code modified on july 17
          ];
          $jsonData[] = $record;

          //ka added on july 17
          if (!empty($record['gap_reason_emp'])) {
            $this->amodel->updateEmploymentGapReason($record['previous_org'], $record['previous_join_date'], $record['gap_reason_emp']);
          } //ka added on july 17
        }
      }


      $insertData['gapdata'] = json_encode($jsonData);
      $insertData['request_id'] = $formData['request_id'];
      $insertData['checkid'] = $formData['checkid'];
      $insertData['created_by'] = $this->session->userdata['userid'];
      $insertData['updated_by'] = $this->session->userdata['userid'];
      $insertData['created_on'] = date('Y-m-d H:i:s');
      $insertData['check_type'] = $formData['check_type'];
      $insertData['check_status'] = $formData['check_status'];

      // **************************** eduction and employment gap *****************************
      // ka added on july 17
      $eduJsonData = [];
      foreach ($formData['qualification'] as $key => $qualification) {
        $gap_reason_edu = $this->sanitizeGapReason($formData['gap_reason_edu'][$key]);
        $record = [
          'qualification' => $qualification,
          'previous_join_date_edu' => $formData['previous_join_date_edu'][$key],
          'previous_exit_date_edu' => $formData['previous_exit_date_edu'][$key],
          'previous_org_edu' => $formData['previous_org_edu'][$key],
          'previous_join_date' => $formData['previous_join_date'][$key],
          'previous_exit_date' => $formData['previous_exit_date'][$key],
          'gap_duration_edu' => $formData['gap_duration_edu'][$key],
          'gap_reason_edu' => $gap_reason_edu
        ];
        $eduJsonData[] = $record;
        if (!empty($record['gap_reason_edu'])) {
          $this->amodel->updateEducationGapReason($record['qualification'], $record['previous_exit_date_edu'], $record['gap_reason_edu']);
        }
      }

      $insertData['gap_edu'] = json_encode($eduJsonData);
      // ***************************************// ka added on july 17 end ***************************

      $insertData = $this->security->xss_clean($insertData);


      $this->amodel->dmlfunction(DB_PREFIX . "gap_analysis_check", array('id' => $id), $insertData, $id);

      $documnets = array();
      $config['allowed_types'] = '*';
      $config['upload_path'] = 'uploads/candidate/document';
      $config['encrypt_name'] = true;
      $config['remove_spaces'] = true;

      $this->load->library('upload', $config);
      $count = count($_FILES['document']['size']);

      $s = 0;

      foreach ($_FILES as $key => $value) {
        $_FILES['userfile']['name'] = $value['name'];
        $_FILES['userfile']['type']    = $value['type'];
        $_FILES['userfile']['tmp_name'] = $value['tmp_name'];
        $_FILES['userfile']['error']       = $value['error'];
        $_FILES['userfile']['size']    = $value['size'];

        if ($this->upload->do_upload()) {
          $documnets[$key]  = $this->upload->data();
        }
        $s++;
      }

      if ($id == 0) {
        $this->updateprofilestatus($req_id, 'gap_analysis_check');
      }

      $check_type = isset($_POST['check_type']) ? $_POST['check_type'] : '';
      $this->db->select('a.id');

      $query = $this->db->get_where('dcode_gap_analysis_check a ', array('a.request_id' => $_POST['request_id'], 'a.checkid' => $_POST['checkid']));
      //print_r($this->db->last_query()); exit();
      $addigap = $query->row_array();

      $upload_files = array('document_name', 'additional_doc');
      $status = $this->insertcloneDetails($_POST['count1'], $upload_files, $return_id, 'personal_additional_doc', $_POST['request_id'], $_POST['checkid'], $addigap[id], '');
      $view_id = $this->getuserid($formData['request_id']);
      $view = $view_id[0]['request_id'];
      redirect(base_url('Dadmin/dadminview/' . base64_encode($view)));
    }
  }


  //ka added on july 11

  function sanitizeGapReason($gap_reason)
  {
    $gap_reason = trim($gap_reason);
    $gap_reason = preg_replace('/[\r\n]+/', ' ', $gap_reason);
    $gap_reason = preg_replace('/\s+/', ' ', $gap_reason);
    return $gap_reason;
  }
  //ka added on july 11
  

}
