<?php
class Dateconverter_model extends CI_Model {
    //Constuctor
    function __construct() 
    {
        parent::__construct();
        $this->load->database();
    }
    function mysqlformat($nformat) {
        $ndate = new Zend_Date($nformat, 'dd/mm/yyyy');
        $mdate = $ndate->toString('yyyy-mm-dd');
        return $mdate;
    }
    function normalformat($mformat) {
        $mdate = new Zend_Date($mformat, 'yyyy-mm-dd');
        $ndate = $mdate->toString('dd/mm/yyyy');
        return $ndate;
    }
    function phpmysqlformat($nformat) {
        $ndate = explode("/", $nformat);
        $mdate = $ndate[2] . "-" . $ndate[1] . "-" . $ndate[0];
        return $mdate;
    }
    function phpnormalformat($mformat) {
        $mdate = explode("-", $mformat);
        $ndate = $mdate[2] . "/" . $mdate[1] . "/" . $mdate[0];
        return $ndate;
    }
    function dateDiff($start, $end) {
        $start_ts = strtotime($start);
        $end_ts = strtotime($end);
        $diff = $end_ts - $start_ts;
        return round($diff / 86400);
    }
    function position($amt, $posValue) {
        $len = strlen($amt);
        $pos = ($posValue - 35) - ($len * 4);
        return $pos;
    }
    function checkingDate($value) {
        $checkdate = preg_match('`^\d{4}-\d{1,2}-\d{1,2}$`', $value);
        if ($checkdate == 1) {
            $mdate = new Zend_Date($value, 'yyyy-mm-dd');
            $ndate = $mdate->toString('dd/mm/yyyy');
            return $ndate;
        } else if ($value) {
            return $value;
        } else {
            return '';
        }
    }
    function no_to_words1($no) {
        $convertors = new App_Model_dateConvertor();
        $words = array('0' => '', '1' => 'one', '2' => 'two', '3' => 'three', '4' => 'four', '5' => 'five', '6' => 'six', '7' => 'seven', '8' => 'eight', '9' => 'nine', '10' => 'ten', '11' => 'eleven', '12' => 'twelve', '13' => 'thirteen', '14' => 'fouteen', '15' => 'fifteen', '16' => 'sixteen', '17' => 'seventeen', '18' => 'eighteen', '19' => 'nineteen', '20' => 'twenty', '30' => 'thirty', '40' => 'fourty', '50' => 'fifty', '60' => 'sixty', '70' => 'seventy', '80' => 'eighty', '90' => 'ninty', '100' => 'hundred &', '1000' => 'thousand', '100000' => 'lakh', '10000000' => 'crore');
        if ($no == 0) return ' ';
        else {
            $novalue = '';
            $highno = $no;
            $remainno = 0;
            $value = 100;
            $value1 = 1000;
            while ($no >= 100) {
                if (($value <= $no) && ($no < $value1)) {
                    $novalue = $words["$value"];
                    $highno = (int)($no / $value);
                    $remainno = $no % $value;
                    break;
                }
                $value = $value1;
                $value1 = $value * 100;
            }
            if (array_key_exists("$highno", $words)) return $words["$highno"] . " " . $novalue . " " . $convertors->no_to_words($remainno);
            else {
                $unit = $highno % 10;
                $ten = (int)($highno / 10) * 10;
                return $words["$ten"] . " " . $words["$unit"] . " " . $novalue . " " . $convertors->no_to_words($remainno);
            }
        }
    }
    function no_to_words($number) {
        $convertors = new App_Model_dateConvertor();
        if (($number < 0) || ($number > 999999999)) {
            throw new Exception("Number is out of range");
        }
        $Gn = floor($number / 100000); /* Laks */
        $number-= $Gn * 100000;
        $kn = floor($number / 1000); /* Thousands (kilo) */
        $number-= $kn * 1000;
        $Hn = floor($number / 100); /* Hundreds (hecto) */
        $number-= $Hn * 100;
        $Dn = floor($number / 10); //Tens (deca) /
        $n = $number % 10; // Ones
        $res = "";
        if ($Gn) {
            $res.= $convertors->no_to_words($Gn) . " Lakh";
        }
        if ($kn) {
            $res.= (empty($res) ? "" : " ") . $convertors->no_to_words($kn) . " Thousand";
        }
        if ($Hn) {
            $res.= (empty($res) ? "" : " ") . $convertors->no_to_words($Hn) . " Hundred";
        }
        $ones = array("", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eightteen", "Nineteen");
        $tens = array("", "", "Twenty", "Thirty", "Fourty", "Fifty", "Sixty", "Seventy", "Eigthy", "Ninety");
        if ($Dn || $n) {
            if (!empty($res)) {
                $res.= " and ";
            }
            if ($Dn < 2) {
                $res.= $ones[$Dn * 10 + $n];
            } else {
                $res.= $tens[$Dn];
                if ($n) {
                    $res.= "-" . $ones[$n];
                }
            }
        }
        if (empty($res)) {
            $res = "zero";
        }
        return $res;
    }
}
