<?php 
    class Delete_request_model extends CI_Model {
        //Constructor
        function __construct() 
        {
            parent::__construct();
            $this->load->database();            
        }

        
        function get_info_for_delete_for_case_nos($case_nos)
        {

        	$sql_sel = "SELECT cr.request_id,cr.case_no,rc.check_id,candidate_name,organisation,cr.parent_office,cr.office,cr.sub_office,cr.user_id,cr.created_on ";
			$from = "  from ".DB_PREFIX ."client_request cr
			LEFT JOIN ".DB_PREFIX ."request_check rc ON rc.request_id=cr.request_id 
			LEFT JOIN ".DB_PREFIX ."user u ON u.id = cr.user_id WHERE case_no IN (";

        	$c = '';

        	// form comma separated values like this 'PO14-834','PO14-835','PO14-836','PO14-837'
    		for($i=0; $i < count($case_nos);$i++)
    		{
    			if($i == (count($case_nos)-1))
    				$c .= "'" . $case_nos[$i] . "'";
    			else
    				$c .= "'" . $case_nos[$i] . "',";

    		}

    		// Forming  SQL select query and querying the db.
    		$sql_sel .= $from . $c . ")"  ;
			$query = $this->db->query($sql_sel);
    		
        	// Returning the resultset as an array.
        	if($query !== FALSE && $query->num_rows() > 0){
        		return $query->result_array();
        	}
        }

        
        function is_organization_unique($case_nos)
		{
			$sql_sel = "SELECT count(DISTINCT(organisation)) as  noOfOrg, count(case_no) as noOfCases FROM " . 
			DB_PREFIX . "client_request where case_no IN (";

        	$c = '';
        	// form comma separated values like this 'PO14-834','PO14-835','PO14-836','PO14-837'
    		for($i=0; $i < count($case_nos);$i++)
    		{
    			if($i == (count($case_nos)-1))
    				$c .= "'" . $case_nos[$i] . "'";
    			else
    				$c .= "'" . $case_nos[$i] . "',";

    		}

    		// Forming  SQL select query and querying the db.
    		$sql_sel .= $c . ")"  ;    		
    		$query = $this->db->query($sql_sel);
    		
        	// Returning the resultset as an array.
        	if($query !== FALSE && $query->num_rows() > 0){
    			return $query->row_array();
    		}
		}


        function get_organization_name($id) 
        {
			$sql = "SELECT org_name FROM  " .  DB_PREFIX .  "organisation WHERE id=" . $id;
			$query = $this->db->query($sql);

			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->row_array();
        	}
		}


		function get_head_office_name($org_id, $head_off_id) 
        {
			$sql = "SELECT office_name FROM  " .  DB_PREFIX .  "office WHERE id=" . $head_off_id . " AND parentoffice_id=" . $org_id; 
			$query = $this->db->query($sql);

			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->row_array();
        	}
		}


		function get_branch_office_name($org_id, $head_off_id, $branch_id) 
        {
			$sql = "SELECT office_name FROM  " .  DB_PREFIX .  "office WHERE id=" . $branch_id . " AND parentoffice_id=" . $org_id . " AND parent_office=" . $head_off_id; 
			$query = $this->db->query($sql);

			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->row_array();
        	}
		}

		function get_sub_office_name($sub_office_id) 
        {
			$sql = "SELECT office_name FROM  " .  DB_PREFIX .  "office WHERE id=" . $sub_office_id; 
			$query = $this->db->query($sql);

			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->row_array();
        	}
		}

		function get_no_of_users_for_delete_for_case_nos($case_nos)
		{
        	$select = " cr.request_id, cr.case_no, candidate_name,  organisation, cr.parent_office,cr.office,cr.sub_office,cr.user_id,cr.created_on ";
			$from = "  from ".DB_PREFIX ."client_request cr
			LEFT JOIN ".DB_PREFIX ."user u ON u.id = cr.user_id WHERE case_no IN (";

        	$c = '';
        	// form comma separated values like this 'PO14-834','PO14-835','PO14-836','PO14-837'
    		for($i=0; $i < count($case_nos);$i++)
    		{
    			if($i == (count($case_nos)-1))
    				$c .= "'" . $case_nos[$i] . "'";
    			else
    				$c .= "'" . $case_nos[$i] . "',";

    		}

    		$select .= $from . $c . ")"  ;

    		// Forming  SQL select query and querying the db.
        	$sql = "SELECT " . $select ;   
    		$query = $this->db->query($sql);
    		
        	// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
    			return $query->result_array();
    		}
		}

		function get_no_of_users_for_delete($searchCondition)
		{
			$select = " cr.request_id,cr.case_no, candidate_name,  organisation, cr.parent_office,cr.office,cr.sub_office,cr.user_id,cr.created_on ";
			$from = "  from ".DB_PREFIX ."client_request cr
			LEFT JOIN ".DB_PREFIX ."user u ON u.id = cr.user_id WHERE u.status=1 and u.active_status !=3 ";

			if ($searchCondition) {
        		$from .= " and $searchCondition";
        	}

		 	// Forming  SQL select query and querying the db.
        	$sql = "SELECT " . $select . "" . $from;        
        	$query = $this->db->query($sql);

        	// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->result_array();
        	}
		}

		function mark_user_for_delete($user_id)
		{
	
        	$this->db->set('active_status', 3);
        	$this->db->set('status', 0);
   			$this->db->where('id', $user_id);
   	 
   			$this->db->update(DB_PREFIX.'user');
     
   	        return;
		}


		function get_info_for_delete($searchCondition)
		{
			$select = " cr.request_id,rc.check_id,`candidate_name`,`organisation`,cr.parent_office,cr.office,cr.sub_office,cr.user_id,cr.created_on ";
			$from = "  from ".DB_PREFIX ."client_request cr
			LEFT JOIN ".DB_PREFIX ."request_check rc ON rc.request_id=cr.request_id 
			LEFT JOIN ".DB_PREFIX ."user u ON u.id = cr.user_id WHERE 1 ";

			if ($searchCondition) {
        		$from .= " and $searchCondition";
        	}

		 	// Forming  SQL select query and querying the db.
        	$sql = "SELECT " . $select . "" . $from;        
        	$query = $this->db->query($sql);

			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->result_array();
        	}
		}

		function get_verified_documents($request_id)
        {
            $this->db->select('request_id, fielddata, qc2fielddata');
            $this->db->where('request_id', $request_id);
            
           	return  $this->db->get(DB_PREFIX.'verified_level')->result_array();
        }

        function get_docs_for_delete_for_request_id($req_id, $check_id)
		{
			$sql = "SELECT table_name, column_name, req_id_name FROM  " .  DB_PREFIX .  "master_document_columns WHERE check_id=" . $check_id; 
			$query = $this->db->query($sql);
        	$result = $query->result_array();
			
			$noOfRows = count($result);
			
			$count = 0;
			$sql_union = '';
			
			// Forming  SQL select query and querying the db.
        	foreach ($result as $row)
			{
				$count ++;
				$sql_union .= "SELECT " . $row['column_name'] .  " AS document_file  FROM " . $row['table_name'] . " WHERE " . $row['req_id_name'] . " = " . $req_id . " AND ".  $row['column_name'] . " !=  ''" ;
				if($count < $noOfRows)
					$sql_union .= " UNION ";
			}
			$query = $this->db->query($sql_union);
			
        	// Returning the resultset as an array.
        	if($query !== FALSE && $query->num_rows() > 0){
            	return $query->result_array();
        	}
        	
		}

		/********** Get Request ID ********* 
		 * ******** function get_requestid()
		***************CK******************/
		function get_requestid($case_no){
 
			$select = "request_id,user_id ";
			$from = "from ".DB_PREFIX ."client_request  WHERE  case_no = '".$case_no."' ";
			$sql = "SELECT " . $select . "" . $from;
			$query = $this->db->query($sql);
			return $query->result_array();
		}
		/********** Get Check ID ********* 
		 * ******** function get_checks()
		************************************/
		function get_checks($request_id){
 
			$select = "check_id,no_checks ";
			$from = "from ".DB_PREFIX ."request_check  WHERE  request_id = '".$request_id."' ";
			$sql = "SELECT " . $select . "" . $from;
			$query = $this->db->query($sql);
			return $query->result_array();
		}

		/********** Get Tables ************* 
		 * ******* function get_tablename()
		************************************/
		function get_tablename($check_id){
 
			$select = "DISTINCT(check_id) as check_id,table_name ";
			$from = "from ".DB_PREFIX ."master_document_columns  WHERE  check_id = '".$check_id."' ";
			$sql = "SELECT " . $select . "" . $from;
			$query = $this->db->query($sql);
			return $query->result_array();
		}

		/********** Get Columns ************* 
		 * ******* function get_columns()
		************************************/
		function get_columns($check_id){
 
			$select = "column_name,file_path ";
			$from = "from ".DB_PREFIX ."master_document_columns  WHERE  check_id = '".$check_id."' ";
			$sql = "SELECT " . $select . "" . $from;
			$query = $this->db->query($sql);
			return $query->result_array();
		}

		/*********** Get Level ID ***********
		 **********function get_level()******
		************************************/
		function get_level($tableName, $request_id, $check_id){

			if($check_id==59){
				$req_id='req_id';
			}else{
				$req_id='request_id';
			}

			$select = "id as level_id ";
			$from = "from ".DB_PREFIX .$tableName."  WHERE  $req_id = '".$request_id."' ";
			$sql = "SELECT " . $select . "" . $from;
			$query = $this->db->query($sql);
			return $query->result_array();	
		}		
		/*********** Get documnts from given table and column name*************
		 *********** function get_file_name ()********************************/
		function get_file_name($tableName, $request_id, $colName, $check_id,$level_id){

			if($check_id==59){
				$req_id='req_id';
			}else{
				$req_id='request_id';
			}

			$select = "$colName ";
			$from = "from ".DB_PREFIX .$tableName."  WHERE  $req_id = '".$request_id."' AND id=".$level_id;
			$sql = "SELECT " . $select . "" . $from;
			$query = $this->db->query($sql);
			return $query->result_array();	
		}


		function get_filtersearch_data($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type=''){

			$select = "a.candidate_name,a.case_no,c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office,a.created_on,a.final_report_published_date as final_date, m.name";
                                
			$from = "   FROM " . DB_PREFIX . "client_request a 
				LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
				LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
				LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
				LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office				
				LEFT JOIN ".DB_PREFIX ."request_check rc ON  rc.request_id=a.request_id
				LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=rc.check_id
				LEFT JOIN " . DB_PREFIX . "user u ON u.id=a.user_id 
				WHERE u.active_status !=3 and u.status=1 ";

				if ($searchCond) {
					$from .= " and $searchCond";
				}
			
				if ($type == 'count') $select = "count(DISTINCT(rc.check_id)) as count ";
						   	   
				if ($pg >= 0 && $type <> 'count') {
					$from .= " group by rc.check_id order by rc.check_id asc,$sBy $sOrder limit $pg," . $limit;
				}
				   
				$sql = "SELECT " . $select . "" . $from;
				$query = $this->db->query($sql);
				return $query->result_array();
	// 			$str = $this->db->last_query();
    // echo "<pre>";
    // print_r($str);
    // exit;
		}

		/*********** Get data to delete**********************
		 *********** function get_bulkdelete_data()**********/
		function get_bulkdelete_data($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type=''){

			$select = "a.candidate_name,a.case_no,c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office,a.created_on,a.final_report_published_date as final_date, m.name";
                                
			$from = "   FROM " . DB_PREFIX . "client_request a 
				LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
				LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
				LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
				LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office				
				LEFT JOIN ".DB_PREFIX ."request_check rc ON  rc.request_id=a.request_id
				LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=rc.check_id
				LEFT JOIN " . DB_PREFIX . "user u ON u.id=a.user_id 
				WHERE u.active_status !=3 and u.status=1 ";

				if ($searchCond) {
					$from .= " and $searchCond";
				}
			
				if ($type == 'count') $select = "count(DISTINCT(rc.check_id)) as count ";
						   
				if ($pg >= 0 && $type <> 'count') {
					$from .= " group by rc.check_id order by rc.check_id asc,$sBy $sOrder limit $pg," . $limit;
				}
				   
				$sql = "SELECT " . $select . "" . $from;
				$query = $this->db->query($sql);
				return $query->result_array();
				
		}


		function get_info_for_grid_delete_for_case_nos($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond='',$type='')
        {

        	$sql_sel = " distinct(cr.request_id),cr.case_no, candidate_name,organisation,cr.parent_office,cr.office,cr.sub_office,cr.user_id,cr.created_on,o.org_name,p.office_name as head_office,br.office_name as branch_office,su.office_name as sub_office, cr.final_report,cr.report_status,cr.final_report_published_date,cr.supplement_report,cr.supplement_report_date ";
			$from =  "  from ".DB_PREFIX ."client_request cr
			LEFT JOIN ".DB_PREFIX ."request_check rc ON rc.request_id=cr.request_id 
			LEFT JOIN ".DB_PREFIX ."user u ON u.id = cr.user_id 
			LEFT JOIN ".DB_PREFIX ."master_masterdata md ON md.id = rc.check_id
            LEFT JOIN ".DB_PREFIX ."office p ON p.id = cr.parent_office
        	LEFT JOIN ".DB_PREFIX ."office br ON br.id = cr.office
        	LEFT JOIN  ".DB_PREFIX ."office su ON su.id = cr.sub_office
        	LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id ";

        	$c = '';
			
			$case_nos = explode(',', $searchCond);

			// form comma separated values like this 'PO14-834','PO14-835','PO14-836','PO14-837'
			if($searchCond)
			{
				$from .=  " WHERE case_no IN (";
				for($i=0; $i < count($case_nos);$i++)
				{
					$case_no = trim($case_nos[$i]);
					if($i == (count($case_nos)-1))
						$c .= "'" . $case_no . "'";
					else
						$c .= "'" . $case_no . "',";
				}
				// Forming  SQL select query and querying the db.
				$from .=   $c . ")"  ;

			}
			if ($type == 'count') $sql_sel = "count(DISTINCT(cr.request_id)) as count "; 
			
        	if ($pg >= 0 && $type <> 'count') { 
				$from .= " group by cr.request_id order by cr.request_id $sOrder limit $pg," . $limit;				
        	}
			
			// Forming  SQL select query and querying the db.
			$sql = "SELECT " . $sql_sel . "" . $from;
			$query = $this->db->query($sql);
			
			// Returning the resultset as an array.
        	if($query !== FALSE && $query->num_rows() > 0){
        		return $query->result_array();
        	}
        }

		function get_info_for_grid_delete_for_organization($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond='',$type='')
        {
			$select = " distinct(cr.request_id),cr.case_no, candidate_name,organisation,cr.parent_office,cr.office,cr.sub_office,cr.user_id,cr.created_on,o.org_name,p.office_name as head_office,br.office_name as branch_office,su.office_name as sub_office, cr.final_report,cr.report_status,cr.final_report_published_date,cr.supplement_report,cr.supplement_report_date ";
			$from =  "  from ".DB_PREFIX ."client_request cr
			LEFT JOIN ".DB_PREFIX ."request_check rc ON rc.request_id=cr.request_id 
			LEFT JOIN ".DB_PREFIX ."user u ON u.id = cr.user_id 
			LEFT JOIN ".DB_PREFIX ."master_masterdata md ON md.id = rc.check_id
            LEFT JOIN ".DB_PREFIX ."office p ON p.id = cr.parent_office
        	LEFT JOIN ".DB_PREFIX ."office br ON br.id = cr.office
        	LEFT JOIN  ".DB_PREFIX ."office su ON su.id = cr.sub_office
        	LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id WHERE 1";

			if ($searchCond) {
				$from .= " and $searchCond";
			}
		
			if ($type == 'count') $select = "count(DISTINCT(cr.request_id)) as count "; 
	
			if ($pg >= 0 && $type <> 'count') { 
			$from .= " group by cr.request_id order by cr.request_id $sOrder limit $pg," . $limit;
			}
	
			// Forming  SQL select query and querying the db.
			$sql = "SELECT " . $select . "" . $from;        
			$query = $this->db->query($sql);
	
			// Returning the resultset as an array.
			return $query->result_array();
		}


		function get_info_for_delete_org($searchCondition)
		{
			$select = " cr.request_id, cr.case_no, rc.check_id, md.name, `candidate_name`,`organisation`, o.org_name, cr.parent_office,cr.office,cr.sub_office,cr.user_id, DATE_FORMAT(cr.created_on, '%d/%m/%y') AS created_on, DATE_FORMAT(cr.case_accepted_date, '%d/%m/%y') AS case_accepted_date,DATE_FORMAT(cr.case_recieved_date, '%d/%m/%y') AS case_recieved_date, DATE_FORMAT(cr.final_report_published_date, '%d/%m/%y') AS final_report_published_date, DATE_FORMAT(cr.supplement_report_date, '%d/%m/%y') AS supplement_report_date ";
			$from = "  from ".DB_PREFIX ."client_request cr
			LEFT JOIN ".DB_PREFIX ."request_check rc ON rc.request_id=cr.request_id 
			LEFT JOIN  ".DB_PREFIX ."master_masterdata md ON md.id = rc.check_id
			LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = cr.organisation
			LEFT JOIN ".DB_PREFIX ."user u ON u.id = cr.user_id WHERE 1 ";

			if ($searchCondition) {
        		$from .= " and $searchCondition";
        	}

			// Forming  SQL select query and querying the db.
        	$sql = "SELECT " . $select . "" . $from;        
        	$query = $this->db->query($sql);

			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->result_array();
        	}

		}

		/********** Get Candidate Info ********* 
		 * ******** function get_candidate_info() */
		function get_candidate_info($case_no){

			$select = "a.request_id, a.organisation, a.parent_office as h_office, a.office as b_office, a.sub_office, a.candidate_name, a.user_id, a.case_no, a.created_on ";
			$from = "from ".DB_PREFIX ."client_request a
			LEFT JOIN " . DB_PREFIX . "user u ON u.id=a.user_id
			WHERE  a.case_no='".$case_no."' and u.active_status !=3 and u.status=1 ";
			$sql = "SELECT " . $select . "" . $from;
			$query = $this->db->query($sql);
			return $query->result_array();
		}

		/*******************************************************************************************
		 * renameFileName($file_name,  $file_path)
		 * Searches for the file given as an argument in the directory sent as file_path 
		 * sent as an argument and renames the file
		 * with a prefix 'dcode_delete_' if found.
		 ********************************************************************************************/
		function renameFileName($file_name, $file_path)
		{
			$file_path = $file_path;
			
			if($file_path && is_dir($file_path))
			{  
				
				$file_name_with_path=$file_path.$file_name;
				
				if(file_exists($file_name_with_path)){
					$oldFile = $file_name_with_path;
					$newFile = $file_path . 'dcode_delete_' . $file_name;
					/**** rename file ***/
					rename($oldFile, $newFile);
					// return 1;
				}         
			}
			
		}

		/*********** Get marked deleted data**********************
		 *********** function get_markeddeleted_data()**********/
		function get_markeddeleted_data($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type=''){

			$select = "a.candidate_name,a.case_no,c.org_name, b.office_name as b_office, d.office_name AS h_office, o.office_name AS sub_office,concat_ws(' ',u.first_name,u.middle_name,u.last_name) as deleted_by,a.deleted_on ";
                                
			$from = "   FROM " . DB_PREFIX . "hard_delete_log a 
				LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.branch_office 
				LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.head_office 
				LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organization
				LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
				LEFT JOIN " . DB_PREFIX . "user u ON u.id=a.deleted_by
				WHERE 1=1 ";

				if ($searchCond) {
					$from .= " and $searchCond";
				}
			
				if ($type == 'count') $select = "count(DISTINCT(a.delete_id)) as count ";
						   
				if ($pg >= 0 && $type <> 'count') {
					$from .= " group by a.delete_id order by a.delete_id desc,$sBy $sOrder limit $pg," . $limit;
				}
				   
				$sql = "SELECT " . $select . "" . $from;
				$query = $this->db->query($sql);
				return $query->result_array();	
		}

		/*********** Get export marked deleted data**********************
		 *********** function get_markeddeleted_data()*******************/
		function get_export_marked_deleted_data($pg = 0, $limit = 10, $sBy = 'a.delete_id', $sOrder = 'desc', $searchCond = '',$type=''){

			$select = "a.candidate_name,a.case_no,c.org_name, b.office_name as b_office, d.office_name AS h_office, o.office_name AS sub_office,concat_ws(' ',u.first_name,u.middle_name,u.last_name) as deleted_by,a.deleted_on ";
                                
			$from = "   FROM " . DB_PREFIX . "hard_delete_log a 
				LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.branch_office 
				LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.head_office 
				LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organization
				LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
				LEFT JOIN " . DB_PREFIX . "user u ON u.id=a.deleted_by
				WHERE 1=1 ";

				if ($searchCond) {
					$from .= " and $searchCond";
				}
			
				if ($type == 'count') $select = "count(DISTINCT(a.delete_id)) as count ";
						   
				if ($pg >= 0 && $type <> 'count') {
					$from .= " group by a.delete_id order by a.delete_id desc ";
				}
				   
				$sql = "SELECT " . $select . "" . $from;
				$query = $this->db->query($sql);
				return $query->result_array();
				
		}













	} // End of model

	


?>