<?php
/**
 * general_model Model containing general site config or action functions  
 * @author sharif
 *
 */
class general_model extends CI_Model {
	
	/**
	 * function to fetch account_types 
	 */
	function _get_account_types() {
		return $this->db->get ( 'm_bank_account_type' )->result_array ();
	}
	
	/**
	 * function to fetch  employee_types 
	 */
	function _get_employee_types() {
		$sql = "select id,role_name as employee_type from a_role_types where active_status = 1";
		return $this->db->query ( $sql )->result_array ();
	}
	
	/**
	 * function to fetch  templates  
	 */
	function _get_templates() {
		return $this->db->get ( 'm_template_info' )->result_array ();
	}
	
	/**
	 * function to fetch  storage_locations  
	 */
	function _get_storage_locations() {
		return $this->db->get ( 'm_storage_location_info' )->result_array ();
	}
	
	 function get_menubyparentid($parent_id=0) {
       $query = $this->db->query("SELECT a.* FROM m_menu_info a
                       where a.active_status = 1 and a.parent_id = ? order by menu_order asc", array($parent_id) );
       return $query->result_array ();
       }

	function get_config_menubyparentid( $parent_id = 0, $usertype_id = '' ) {
                $sql = "SELECT a.*  FROM m_menu_info a
                        where a.active_status = 1 and a.parent_id = ? ";
	        switch($usertype_id){
	        case 1: $sql .= " and a.dcode = 1 "; break;
	        case 2: $sql .= " and a.client = 1 "; break;
	        case 3: $sql .= " and a.candidate = 1 "; break;
	        }
	       $sql .= "order by menu_order asc";
	        $query = $this->db->query($sql,array($parent_id));
        return $query->result_array ();
	}
	
	function _get_companydetailsbyid($id) {
		$this->db->where ( 'company_id', $id );
		$this->db->where ( 'active_status', 1 );
		
		$res = $this->db->get ( 'm_company_info' );
		if ($res->num_rows ()) {
			$row = $res->result_array ();
			return $row [0];
		} else {
			return FALSE;
		}
	}

}
