<?php
class Management_model extends CI_Model
{
  //Constuctor
  function __construct()
  {
    parent::__construct();
    $this->load->database();
    $this->load->model('Adm_model', 'amodel');
    $this->load->library(array('form_validation'));
    $this->load->helper(array('form', 'url'));
  }
  function adminlogin($username, $passwrd)
  {
    $this->db->select('*');
    $this->db->where('username', $username);
    $this->db->where('password', md5($passwrd));
    $query = $this->db->get(DB_PREFIX . 'user');
    return $query->result();
  }
  function getusers()
  {
    $query = $this->db->query("SELECT * from " . DB_PREFIX . "user");
    return $query->result();
  }
  public function gethierarchydetails($id)
  {
    $sql = "SELECT a.id,a.org_name, b.name as user_type,a.logo,c.first_name as qc, 
                d.first_name as operator 
                FROM " . DB_PREFIX . "organisation a 
                join " . DB_PREFIX . "master_usertype b on a.user_type = b.id
                left join " . DB_PREFIX . "user c on a.dedicated_qc = c.id 
                left join " . DB_PREFIX . "user d on a.dedicated_operator = d.id
                where a.id =" . $id . "";
    $query = $this->db->query($sql);
    return $query->result_array();
  }

  function getorganisationList($limit = '', $type = '', $search = '')
  {
    $this->load->model('Adm_model', '', true);
    $where = $this->Adm_model->sql_where($_POST, $search);

    $from = "FROM " . DB_PREFIX . "organisation a join " . DB_PREFIX . "master_usertype b on b.id=a.user_type
 LEFT JOIN " . DB_PREFIX . "user d ON d.id=a.created_by where 1 " . $where . " order by a.org_name asc " . $limit . "";

    $select = "a.id,a.org_name,b.name as user_type,a.created_on,d.first_name as created_by ";

    if ($type == 'count') $select = "count(*) as count ";
    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    return $query->result();
  }
  function getorganisationListed($pg = 0, $limit = 10, $sBy = 'id', $sOrder = 'desc', $searchCond = '', $type = '')
  {
    $select = "a.id,a.org_name,b.name as user_type,a.created_on,d.first_name,a.org_status , o.billing_type";
    $from = "  FROM " . DB_PREFIX . "organisation a join "
      . DB_PREFIX . "master_usertype b on b.id=a.user_type
              LEFT JOIN " . DB_PREFIX . "user d ON d.id=a.created_by
              LEFT JOIN " . DB_PREFIX . "industry_types i ON i.org_id=a.id
              LEFT JOIN " . DB_PREFIX . "order o ON o.organisation = a.id  where 1 ";

    if ($searchCond) {
      $from .= " and $searchCond";
    }
    if ($type == 'count') $select = "count(DISTINCT a.id) as count ";
    if ($this->session->userdata('role_id') == 21) {
      $from .= " and a.crm_userid = " . $this->session->userdata['userid'] . " ";
    }
    if ($pg >= 0 && $type <> 'count' && $_POST['buttonpressed'] != 'Export') {
      $from .= " group by a.id order by $sBy $sOrder limit $pg," . $limit;
    }
    if ($_POST['buttonpressed'] == 'Export') {
      $from .= " group by a.id order by a.id ";
    }
    $sql = "SELECT " . $select . "" . $from;

    $query = $this->db->query($sql);
    return $query->result_array();
  }

  function users_delete($id)
  {
    $where = 'id = ' . $id;
    if ($_POST) {
      $this->db->update(DB_PREFIX . "user", array('active_status' => 3, 'remark' => $_POST['confirm'], 'status' => 0), array('id' => $_POST['id']));
      redirect('' . base_url('Management/users'));
    }
  }

  function getactive_statustype()
  {
    $sql = "SELECT active_status_id as id,description as type FROM " . DB_PREFIX . "active_status where type='masterdata'";
    $query = $this->db->query($sql);
    return $query->result();
  }

  function addHierarchyLevel($formData, $createdby)
  {
    $this->load->model('Adm_model', '', true);
    $inputarray = array('type' => $formData['type'], 'hierarchy_level' => $formData['hierarchy_level'], 'created_by' => $createdby, 'created_on' => date('Y-m-d'));
    $result = $this->Adm_model->addRecord("" . DB_PREFIX . "organisation", $inputarray);
  }
  function editHierarchyLevel($formData, $createdby)
  {
    $this->load->model('Adm_model', '', true);
    $inputarray = array('type' => $formData['type'], 'created_by' => $createdby, 'created_on' => date('Y-m-d'));
    $this->Adm_model->updateRecordParam("" . DB_PREFIX . "organisation", 'Hierarchy_level', $formData['hierarchy_level'], $inputarray);
  }

  function getOfficeList($pg = 0, $limit = 10, $sBy = 'id', $sOrder = 'asc', $searchCond = '', $type = '')
  {

    $select = "g.org_name,a.id,c.office_name as parent_office,a.office_name as office_name,f.office_name as suboffice,a.created_on,d.first_name as created_by,a.parent,a.level,a.parentoffice_id ";

    $from = "   FROM " . DB_PREFIX . "office a 
               LEFT JOIN " . DB_PREFIX . "office f ON f.id=a.level 
                     LEFT JOIN " . DB_PREFIX . "office c ON c.id=a.parent_office
           
              LEFT JOIN " . DB_PREFIX . "organisation g ON g.id=a.parentoffice_id
               
                                LEFT JOIN " . DB_PREFIX . "user d ON d.id=a.created_by
                            where 1 ";

    if ($searchCond) {
      $from .= " and $searchCond";
    }

    if ($type == 'count') $select = "count(*) as count ";

    if ($pg >= 0 && $type <> 'count') {
      $from .= " order by $sBy $sOrder limit $pg," . $limit;
    }

    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    return $query->result_array();
  }

  function getofficedetails($id)
  {
    $sql = "SELECT a.id,b.org_name,f.office_name as parent_office, a.office_name as office_name, a.address1, a.address2, a.address3, a.locality, a.pincode, a.telephone1, a.telephone2, a.fax,a.locality,e.name as country,d.name as state,c.office_name as branch_office
                    FROM " . DB_PREFIX . "office a
                    LEFT JOIN " . DB_PREFIX . "organisation b ON b.id=a.parentoffice_id
                    LEFT JOIN " . DB_PREFIX . "states d ON d.adminCode1=a.state
                    LEFT JOIN " . DB_PREFIX . "countries e ON e.iso_code_2=a.country
                    LEFT OUTER JOIN " . DB_PREFIX . "office c ON c.id=a.level  
                    LEFT OUTER JOIN " . DB_PREFIX . "office f ON f.id=a.parent_office  AND b.id=f.parentoffice_id
                    WHERE a.id =$id GROUP BY a.id";
    $query = $this->db->query($sql);
    return $query->result_array();
  }
  function getofficedetailsedit($id)
  {
    $sql = "SELECT a.id,b.id as type,a.office_name,c.id as parentoffice_id FROM " . DB_PREFIX . "office a," . DB_PREFIX . "organisation b," . DB_PREFIX . "office c where b.id=a.parentoffice_id and a.parentoffice_id=c.id and a.id =" . $id . "";
    $query = $this->db->query($sql);
    return $query->result();
  }
  function getParentOfficetype($parentoffice_id)
  {
    $sql = "SELECT a.id,a.office_name as type FROM " . DB_PREFIX . "office a where parentoffice_id=" . ($parentoffice_id - 1) . "";
    $query = $this->db->query($sql);
    return $query->result();
  }

  // get grant activity for particular module id
  function getActivity($moduleid, $grantid)
  {
    $sql = "SELECT a.add,a.edit,a.view,a.delete FROM " . DB_PREFIX . "grantactivity a where a.role_id_id = '" . $grantid . "' and a.module_id='" . $moduleid . "'";
    $query = $this->db->query($sql);
    return $query->result();
  }

  function editactivity($grantid)
  {
    $sql = "SELECT 'id','module_id','add','edit','view','delete' 
                FROM " . DB_PREFIX . "grantactivity 
                where grant_id =" . $grantid . "";
    $query = $this->db->query($sql);
    return $query->result();
  }
  // delete activity
  function deleteactivity($table, $grantid)
  {
    $where = 'grant_id = ' . $grantid;
    $this->db->delete($table, $where);
  }

  function getUsersList($limit = '', $type = '', $search = '')
  {
    $this->load->model('Adm_model', '', true);
    $formdata = $_POST;
    unset($formdata['cn-name']);
    $manual_con = "a.first_name like '%" . $_POST['cn-name'] . "%' OR a.middle_name like '%" . $_POST['cn-name'] . "%' OR  a.last_name like '%" . $_POST['cn-name'] . "%'";
    $where = $this->Adm_model->sql_where($formdata, $search, '', $manual_con);

    $from = "   FROM " . DB_PREFIX . "user a 
                        LEFT JOIN " . DB_PREFIX . "master_masterdata d ON a.gender=d.id
      LEFT JOIN " . DB_PREFIX . "office g ON g.id=a.office_id
      LEFT JOIN " . DB_PREFIX . "role_types e ON e.id=a.role_id
                    where 1 " . $where . " and a.active_status <>3 " . $limit . "";

    $select = "a.id,e.role_name, concat_ws(' ',a.first_name,a.middle_name,a.last_name) as name, d.name as gender,a.username ,g.office_name,a.photo ";
    if ($type == 'count') $select = "count(*) as count ";
    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    return $query->result();
  }
  function getLoansList($limit = '', $type = '', $search = '')
  {
    $this->load->model('Adm_model', '', true);
    $where = $this->Adm_model->whereclause($_POST, $search);
    if ($where) {
      $from = "FROM " . DB_PREFIX . "product a
        LEFT JOIN " . DB_PREFIX . "product_loan b ON a.id=b.product_id 
        " . $where . " and a.prod_type = 2 " . $limit . "";
    } else {
      $from = "FROM " . DB_PREFIX . "product a 
        LEFT JOIN " . DB_PREFIX . "product_loan b ON a.id=b.product_id 
        where a.prod_type = 2 " . $limit;
    }
    $select = "a.id,a.name,DATE_FORMAT( begin_date, '%d/%m/%Y') as begin_date,DATE_FORMAT( close_date, '%d/%m/%Y') as close_date ";
    if ($type == 'count') $select = "count(*) as count ";
    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    return $query->result();
  }


  function userdml($id = 0, $contact_id = 0)
  {

    $formData = $_POST;

    if ($formData) {


      if (!empty($_FILES['photo']['name'])) {
        $this->load->library('Upload');
        $config['allowed_types'] = 'jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/user_photo/original/';
        $config['upload_thumb'] = 'uploads/user_photo/thumb/';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('photo')) {

          $upload_data        = $this->upload->data();
          $image['original'] = $config['upload_path'] . $upload_data['file_name'];

          $config['image_library'] = 'gd2';
          $config['source_image'] = getcwd() . '/uploads/user_photo/original/' . $upload_data['file_name'];
          $config['new_image'] = getcwd() . '/uploads/user_photo/thumb/' . $upload_data['file_name'];
          $config['create_thumb'] = FALSE;
          $config['width']        = 54;
          $config['height']        = 46;
          $this->load->library('image_lib', $config);
          $this->image_lib->initialize($config);
          if (! $this->image_lib->resize()) {
            $this->session->set_userdata('error', $this->image_lib->display_errors());
          } else {
            $image['thumb'] =  $config['upload_thumb'] . $upload_data['file_name'];
          }
        }
        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('error', $this->upload->display_errors());
          $this->session->set_userdata('postvalue', $formData);
          redirect('Management/usersadd/');
        }
      }

      if ($id == 0 || $_POST['Submit'] == 'Submit with mail') {
        $new_password = $this->randomString(10);
        $formData['password'] =  md5($new_password);
        $formData['status'] =  1;
        if ($this->session->userdata('role_id') == 11) {
          $insertData = elements(array('user_type', 'first_name', 'middle_name', 'last_name', 'gender', 'original', 'thumbnail', 'designation', 'department', 'contact_for', 'email', 'reporting_to', 'designation_of_reporter', 'username', 'password', 'status', 'pcontact'), $formData);
          $insertData['role_id'] = 10;
          $insertData['user_type'] = 1;
          $insertData['organization'] = 1;
        } else {

          $insertData = elements(array('user_type', 'first_name', 'middle_name', 'last_name', 'gender', 'original', 'thumbnail', 'designation', 'department', 'contact_for', 'email', 'reporting_to', 'designation_of_reporter', 'username', 'password', 'status', 'pcontact'), $formData);

          if (isset($formData['organization'])) {
            $insertData['organization'] = $formData['organization'];
          }
        }
      } else {

        if (isset($formData['organization'])) {
          $insert['organization'] = $formData['organization'];
        }
        $insertData = elements(array('user_type', 'first_name', 'middle_name', 'last_name', 'gender', 'original', 'thumbnail', 'designation', 'department', 'contact_for', 'email', 'reporting_to', 'designation_of_reporter', 'username', 'status', 'pcontact'), $formData);
      }

      if ($this->session->userdata['user_type'] == 2)
        $insertData['user_type'] = 2;
      if (isset($image) && !empty($image['original']))
        $insertData['original'] = $image['original'];
      if (isset($image) && !empty($image['thumb']))
        $insertData['thumbnail'] = $image['thumb'];
      $insertData = $this->security->xss_clean($insertData);
      $return_id = $this->amodel->dmlfunction(DB_PREFIX . "user", array('id' => $id), array_filter($insertData, 'strlen'), $id);
      $formData['user_id'] = $return_id;

      /*  store multiple headoffice*/
      if (isset($formData['parent_office'])) {

        foreach ($formData['parent_office'] as $key => $parent) {
          $parent_office[] = array(
            'user_id' => $formData['user_id'],
            'parent_office' => $parent
          );
        }
        $this->db->where('user_id', $formData['user_id']);
        $this->db->delete(DB_PREFIX . 'user_headoffices');
        $this->db->insert_batch(DB_PREFIX . 'user_headoffices', $parent_office);
      }
      /*  store multiple branchoffice*/
      if (isset($formData['office_id'])) {
        foreach ($formData['office_id'] as $key => $branch) {
          $branchoffice[] = array(
            'user_id' => $formData['user_id'],
            'branch_office' => $branch
          );
        }
        $this->db->where('user_id', $formData['user_id']);
        $this->db->delete(DB_PREFIX . 'user_branchoffices');
        $this->db->insert_batch(DB_PREFIX . 'user_branchoffices', $branchoffice);
      }
      /*  store multiple suboffice*/
      if (isset($formData['sub_office'])) {
        foreach ($formData['sub_office'] as $key => $parent) {
          $suboffice[] = array(
            'user_id' => $formData['user_id'],
            'sub_office' => $parent
          );
        }
        $this->db->where('user_id', $formData['user_id']);
        $this->db->delete(DB_PREFIX . 'user_suboffices');
        $this->db->insert_batch(DB_PREFIX . 'user_suboffices', $suboffice);
      }

      if ($this->session->userdata['user_type'] == 1) {
        foreach ($formData['role_id'] as $key => $value) {

          $user_roles[] = array(
            'user_id' => $formData['user_id'],
            'role_id' => $value
          );
        }
        if ($id == 0) {
          $this->db->insert_batch(DB_PREFIX . 'users_roles', $user_roles);
        } else {
          $this->db->where('user_id', $formData['user_id']);
          $this->db->delete(DB_PREFIX . 'users_roles');
          $this->db->insert_batch(DB_PREFIX . 'users_roles', $user_roles);
        }
      }

      $this->session->set_userdata('postvalue', '');
      if ($id == 0) {

        $data['new_password'] = $new_password;
        $data['first_name'] = $formData['first_name'];
        $data['email'] = $formData['email'];
        $data['cand_user_id'] = base64_encode($return_id);

        send_email_common('new_registration', 'Login Details @ Dcode Research ', @$formData['email'], $data);
      }
      if ($_POST['Submit'] == 'Submit with mail') {
        $returnpsd_id = $this->amodel->getDetails(DB_PREFIX . "user", array('email', 'first_name', 'password'), array('id' => $id));
        $data['new_password'] = $new_password;
        $data['first_name'] = $formData['first_name'];
        $data['email'] = $formData['email'];
        $data['cand_user_id'] = base64_encode($return_id);

        send_email_common('new_registration', 'Login Details @ Dcode Research ', @$formData['email'], $data);
      }
      if ($_POST['status'] == 0 && $id != 0) {
        $data['first_name'] = $formData['first_name'];
        $data['email'] = $formData['email'];
        send_email_common('user_deactive_account', 'Deactivate Account ', @$formData['email'], $data);
      }

      $this->db->select('id');
      $this->db->where('user_id', $return_id);
      $contactdetails = $this->db->get(DB_PREFIX . 'user_contact_details')->row_array();



      if (!empty($contactdetails))
        $contact_id = $contactdetails['id'];
      if ($return_id == 0 || $contact_id == 0) {
        $insertcontact =  elements(array('user_id', 'address1', 'address2', 'address3', 'city', 'mobile', 'telephone', 'country', 'state', 'pincode'), $formData);
      } else {

        $insertcontact =  elements(array('address1', 'address2', 'address3', 'city', 'mobile', 'telephone', 'country', 'state', 'pincode'), $formData);
      }
      $insertcontact = $this->security->xss_clean($insertcontact);
      $this->amodel->dmlfunction(DB_PREFIX . "user_contact_details", array('user_id' => $return_id), $insertcontact, $contact_id);
      if ($id == 0) {

        if ($this->session->userdata['user_type'] == 2)
          $usertype = 2;
        else
          $usertype = $formData['user_type'];
        $parent_office = ($formData['parent_office'][0]) ? $formData['parent_office'][0] : 0;
        $branch_office = ($formData['office_id'][0]) ? $formData['office_id'][0] : 0;
        $sub_office = ($formData['sub_office'][0]) ? $formData['sub_office'][0] : 0;
        foreach ($formData['role_id'] as $key => $value) {
          $menucond = "menu_ids IS NOT NULL AND  menu_ids!=''";
          $this->db->select('menu_ids');
          $this->db->where('user_type', $usertype);
          $this->db->where_in('role_id', $value);
          $this->db->where($menucond);
          $this->db->order_by('role_id', 'DESC');
          $menus = $this->db->get(DB_PREFIX . 'role_permissions')->row_array();

          $role_permission['user_type'] = $usertype;
          $role_permission['role_id'] = $value;
          $role_permission['organization'] = $formData['organization'];
          $role_permission['active_status'] = 1;
          $role_permission['created_on'] = date('Y-m-d H:i:s');
          $role_permission['menu_ids'] = $menus['menu_ids'];
          $role_permission = $this->security->xss_clean($role_permission);
          $this->db->insert(DB_PREFIX . 'role_permissions', $role_permission);
          $this->db->select('feature_id,add,edit,delete,search,list,generate,task_status');
          $this->db->where('role_id', $value);
          $this->db->group_by('feature_id');
          $this->db->order_by('role_id', 'DESC');
          $roles_config = $this->db->get('m_role_config')->result_array();
          if (!empty($roles_config)) {
            $new_config = array();
            $newarryay = array();


            foreach ($roles_config as $config_role) {
              $new_config[$config_role['feature_id']] = $config_role;

              $new_config1[$config_role['feature_id']]['role_id'] = $value;
              $new_config1[$config_role['feature_id']]['organization'] = $formData['organization'];
              $new_config1[$config_role['feature_id']]['created_by'] = $this->user_id;
              $new_config1[$config_role['feature_id']]['created_on'] = date('Y-m-d H:i:s');

              $newarryay[] = array_merge($new_config[$config_role['feature_id']], $new_config1[$config_role['feature_id']]);
            }
            if (!empty($newarryay))
              $this->db->insert_batch('m_role_config', $newarryay);
          }
        }
      }


      redirect('' . base_url('Management/userscommonview/' . base64_encode($return_id)));
    }
  }
  function get_user($data, $id)
  {
    $this->db->select('first_name,last_name,org_name,c.office_name as parent_office,d.office_name as office');
    $this->db->join(DB_PREFIX . 'organisation b', 'b.id=organization', 'left');
    $this->db->join(DB_PREFIX . 'office c', 'c.id=u.parent_office', 'left');
    $this->db->join(DB_PREFIX . 'office d', 'd.id=office_id', 'left');
    $this->db->where('u.id', $id);
    return $this->db->get(DB_PREFIX . 'user u')->row_array();
  }

  function randomString($length)
  {
    $str = "";
    $characters = array_merge(range('A', 'Z'), range('a', 'z'), range('0', '9'));
    $max = count($characters) - 1;
    for ($i = 0; $i < $length; $i++) {
      $rand = mt_rand(0, $max);
      $str .= $characters[$rand];
    }
    return $str;
  }
  function get_assignee_list()
  {
    $sql = "SELECT c.id as assignee_id, concat_ws(' ', first_name,middle_name,last_name) as name
                        FROM " . DB_PREFIX . "organisation a 
                        join " . DB_PREFIX . "office b on b.parentoffice_id = a.id
                        join " . DB_PREFIX . "user c on c.office_id = b.id OR c.parent_office=b.id
                        join " . DB_PREFIX . "users_roles u on u.user_id = c.id
                        WHERE a.user_type = 1 and c.status = 1 and u.role_id = '5' GROUP BY c.id";
    $query = $this->db->query($sql);
    return $query->result_array();
  }

  function organisationdml($id = 0)
  {
    $formData = $_POST;
    if ($formData) {

      if ($id == 0) {
        $formData['user_type'] = 2;
        $formData['org_status'] = 1;
        $insertData = array_filter(elements(array('user_type', 'org_name', 'dedicated_operator', 'dedicated_qc', 'num_days_submit', 'caserecieved_report', 'type_of_employ_candidate', 'dially_report_mail', 'orange_report_mail', 'org_status', 'crm_userid', 'gst_number'), $formData));
      } else {
        $insertData = elements(array('org_name', 'dedicated_qc', 'dedicated_operator', 'num_days_submit', 'caserecieved_report', 'type_of_employ_candidate', 'dially_report_mail', 'orange_report_mail', 'org_status', 'crm_userid', 'gst_number'), $formData);
      }

      $insertData = $this->security->xss_clean($insertData);
      $this->db->select('a.org_name');
      $checksa_org = $this->db->get_where('dcode_organisation a', array('a.org_name' => $formData['org_name']))->result_array();
      $return_id = $this->amodel->dmlfunction(DB_PREFIX . "organisation", array('id' => $id), $insertData, $id);


      $this->db->where('client_id', $return_id);
      $this->db->delete('client_dataentry');

      if (isset($_POST['dataentry'])) {
        foreach ($_POST['dataentry'] as $entry) {
          $dentry['client_id'] = $return_id;
          $dentry['entry'] = $entry;

          $this->db->insert('client_dataentry', $dentry);
        }
      }
      if ($this->session->userdata['user_type'] == 1) {
        foreach ($formData['industry_type'] as $key => $value) {


          $industry_type[] = array(
            'org_id' => $return_id,
            'industry_id' => $value
          );
        }
        if ($id == 0) {
          $this->db->insert_batch(DB_PREFIX . 'industry_types', $industry_type);
        } else {
          $this->db->where('org_id', $return_id);
          $this->db->delete(DB_PREFIX . 'industry_types');
          $this->db->insert_batch(DB_PREFIX . 'industry_types', $industry_type);
        }
      }



      $this->load->library('Upload');
      if (!empty($_FILES['logo']['name'])) {
        $config['upload_path'] = 'uploads/organisephotos';
        $config['allowed_types'] = 'gif|jpg|png|jpeg';
        $config['max_size'] = 8000;
        $config['overwrite'] = true;
        $config['encrypt_name'] = false;
        $config['file_name'] = md5($_FILES['logo']['name'] . $return_id);
        $this->upload->initialize($config);
        // Upload file 
        if ($this->upload->do_upload('logo')) {
          $data = $this->upload->data();

          $ext = pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);
          $orgphoto = md5($_FILES['logo']['name'] . $return_id) . '.' . $ext;
          $this->db->update(DB_PREFIX . "organisation", array('logo' => $orgphoto), array('id' => $return_id));
        } else {
          echo $this->upload->display_errors();
          exit;
        }
      }
      redirect('' . base_url('Management/organisationcommonview/' . base64_encode($return_id)));
    }
  }
  function officedml($id = 0, $org_id = '')
  {
    $formData = $_POST;
    if ($formData) {
      if ($id == 0) {
        if (isset($formData['sub_office'])) {
          $formData['office_name'] = $formData['sub_office'];
          $formData['parent'] = $formData['parent_office'];
          $formData['level'] = $formData['branch_office'];
        } else if (isset($formData['branch_office'])) {
          $formData['office_name'] = $formData['branch_office'];
          $formData['parent'] = $formData['parent_office'];
          $formData['level'] = 0;
        } else {
          $formData['office_name'] = $formData['parent_office'];
          $formData['parent_office'] = $org_id;
          $formData['parent'] = 0;
          $formData['level'] = 0;
        }
      } else {
        if (isset($formData['level'])) {
          $formData['parent'] = $formData['parent_office'];
        } else if (isset($formData['parent_office'])) {
          $formData['parent'] = $formData['parent_office'];
          $formData['level'] = 0;
        } else {
          $formData['parent_office'] = $org_id;
          $formData['parent'] = 0;
          $formData['level'] = 0;
        }
      }
      if ($id == 0) {
        $formData['parentoffice_id'] = $org_id;
        $insertData = elements(array('office_name', 'parentoffice_id', 'parent_office', 'parent', 'address1', 'address2', 'level', 'address3', 'country', 'state', 'city', 'telephone1', 'telephone2', 'fax', 'pincode', 'office_code'), $formData);
      } else {
        $insertData = elements(array('office_name', 'parent_office', 'parent', 'level', 'state', 'address1', 'address2', 'address3', 'country', 'state', 'city', 'telephone1', 'telephone2', 'fax', 'pincode', 'office_code'), $formData);
      }
      $insertData = $this->security->xss_clean($insertData);
      $return_id = $this->amodel->dmlfunction(DB_PREFIX . "office", array('id' => $id), $insertData, $id);
      redirect('' . base_url('Management/officecommonview/' . base64_encode($return_id)));
    }
  }

  function gettotoffice($type = null)
  {
    $sql = "SELECT count( id ) AS totaloffice
FROM " . DB_PREFIX . "organisation";
    $query = $this->db->query($sql);
    return $query->result_array();
  }

  function getdesignationname($id)
  {
    $sql = "SELECT id,name from " . DB_PREFIX . "master_masterdata where id  = " . $id;
    $query = $this->db->query($sql);
    return $query->result_array();
  }


  function loadofficeelement($editId = 0, $editDetails, $or_id, $oid)
  {
    $org_id =  $editDetails[0]['parentoffice_id'];

    $parent_office = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id', 'office_name'), array('parent_office' => $org_id, 'parent' => 0));
    $len = sizeof($parent_office);
    $parent_office1 = $this->amodel->fetchDropdowndetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('id' => $or_id));
    $branch_office1 = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id', 'office_name'), array('parent' => $editDetails[0]['parent'], 'level' => 0));

    if ($oid == 1) {
      $parent = array('text', 'parent_office', 'R|Z', 'R|Z', '', 'RF', '', '');
    } else if ($oid == 2) {
      $parent = array('dropdown', 'parent_office', 'R|Y', 'R|Y', $parent_office, '', '', '');
      $branch_office = array('text', 'office_name', 'R|Z', 'R|Z', '', 'RF', '', '');
    } else {
      $parent = array('dropdown', 'parent_office', 'R|Y', 'R|Y', $parent_office, '', '', '');
      $branch_office = array('dropdown', 'office_name', 'R|Z', 'R|Z', $branch_office1, 'RF', '', '');
      $sub_office = array('text', 'sub_office', 'R|Z', 'R|Z', '', 'RF', '', '');
    }
    if ($editId) {
      $org_id =  $editDetails[0]['parentoffice_id'];
      $parent_office1 = $this->amodel->fetchDropdowndetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('id' => $org_id));
      $state = $this->amodel->fetchDropdowndetails(DB_PREFIX . "states", array('adminCode1', 'name'), array('country_code' => $editDetails[0]['country']));
      $city = $this->amodel->fetchDropdowndetails(DB_PREFIX . "cities", array('id', 'city'), array('country_code' => $editDetails[0]['country'], 'adminCode1' => str_pad($editDetails[0]['state'], 2, "0", STR_PAD_LEFT)));
      if ($editDetails[0]['parent'] == 0 && $editDetails[0]['level'] == 0) {

        $formElement1 = array(array('parentoffice_id' => array('dropdown', 'parentoffice_id', 'R|Y', 'R|Y', $parent_office1, 'RF', ''), 'office_name' => array('text', 'parent_office', 'R|Z', 'R|Z', $editDetails[0]['office_name'], 'RF', '')));
      } else if ($editDetails[0]['level'] == 0 && $editDetails[0]['parent'] != 0) {
        $formElement1 = array(array('parentoffice_id' => array('dropdown', 'parentoffice_id', 'R|Y', 'R|Y', $parent_office1, 'RF', ''), 'parent_office' => array('dropdown', 'parent_office', 'R|Y', 'R|Y', $parent_office, 'RF', ''), 'office_name' => array('text', 'branch_office', 'R|Z', 'R|Z', $editDetails[0]['office_name'], 'RF', '')));
      } else {
        $formElement1 = array(array('parentoffice_id' => array('dropdown', 'parentoffice_id', 'R|Y', 'R|Y', $parent_office1, 'RF', ''), 'parent_office' => array('dropdown', 'parent_office', 'R|Y', 'R|Y', $parent_office, 'RF', ''), 'level' => array('dropdown', 'branch_office', 'R|Y', 'R|Y', $branch_office1, 'RF', ''), 'office_name' => array('text', 'sub_office', 'R|Z', 'R|Z', $editDetails[0]['office_name'], 'RF', '')));
      }
      $formElement2 = array(array('office_code' => array('text', 'office_code', 'max:25|min:1|Z', 'max:25|min:1|Z', '', '', ''), 'address1' => array('text', 'address1', 'R|max:25|min:1|Z', 'R|max:25|min:1|Z', '', 'RF', ''), 'address2' => array('text', 'address2', 'Z', 'Z', '', '', ''), 'address3' => array('text', 'address3', 'Z', 'Z', '', '', ''),   'country' => array('dropdown', 'country', 'R|Y', 'R|Y', $this->amodel->fetchDropdowndetails(DB_PREFIX . "countries", array('iso_code_2', 'name')), 'RF', ''), 'state' => array('dropdown', 'state', 'R|Y', 'R|Y', $state, 'RF', ''), 'city' => array('dropdown', 'city', 'R|Y', 'R|Y', $city, 'RF', ''), 'pincode' => array('text', 'pincode', 'R|N|Z', 'R|N|Z', '', 'RF', ''), 'telephone1' => array('text', 'telephone1', 'R|N|max:13|min:10|Z', 'R|N|max:13|min:10|Z', '', 'RF', ''), 'telephone2' => array('text', 'telephone2', 'N|max:13|min:10|Z', 'N|max:13|min:10|Z', '', '', ''), 'fax' => array('text', 'fax', 'N|max:15|min:1|Z', 'N|max:15|min:1|Z', '', '', '')));
      $formElement = array_merge($formElement1, $formElement2);
    } else {

      $formElement = array(array('parentoffice_id' => array('dropdown', 'parentoffice_id', 'R|Y', 'R|Y', $parent_office1, 'RF', ''), 'parent_office' => $parent, 'branch_office' => $branch_office, 'sub_office' => $sub_office, 'office_code' => array('text', 'office_code', 'max:25|min:1|Z', 'max:25|min:1|Z', '', '', ''), 'address1' => array('text', 'address1', 'R|max:25|min:1|Z', 'R|max:25|min:1|Z', '', 'RF', ''), 'address2' => array('text', 'address2', 'Z', 'Z', '', '', ''), 'address3' => array('text', 'address3', 'Z', 'Z', '', '', ''),   'country' => array('dropdown', 'country', 'R|Y', 'R|Y', $this->amodel->fetchDropdowndetails(DB_PREFIX . "countries", array('iso_code_2', 'name')), 'RF', ''), 'state' => array('dropdown', 'state', 'R|Y', 'R|Y', $state, 'RF', ''), 'city' => array('dropdown', 'city', 'R|Y', 'R|Y', $city, 'RF', ''), 'pincode' => array('text', 'pincode', 'R|N|Z', 'R|N|Z', '', 'RF', ''), 'telephone1' => array('text', 'telephone1', 'R|N|max:13|min:10|Z', 'R|N|max:13|min:10|Z', '', 'RF', ''), 'telephone2' => array('text', 'telephone2', 'N|max:13|min:10|Z', 'N|max:13|min:10|Z', '', '', ''), 'fax' => array('text', 'fax', 'N|max:15|min:1|Z', 'N|max:15|min:1|Z', '', '', '')));
    }
    return $formElement;
  }

  function user_formelement($userEditid = 0, $userdetails, $user_roles, $offices)
  {
    if ($this->session->userdata['userType'] == 2) {
      $organisation = 'NN';
    }

    if ($userEditid == 0) {


      if (!empty($userdetails)) {

        $office = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id', 'office_name'), array('parentoffice_id' => $userdetails[0]['organization']));
        $this->db->select('*');
        $org = $this->db->get_where('dcode_organisation a', array('id' => $userdetails[0]['organization']))->result_array();
        $loginuser = 'Y';
        $passwrd = 'N';

        $parent_office2 = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id', 'office_name'), array('parent_office' => $userdetails[0]['organization']));
      } else {
        $loginuser = '';
        $passwrd = '';
        if ($this->session->userdata['user_type'] == 2) {
          $organization = $this->amodel->fetchDropdowndetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('id' => $this->session->userdata('organization')));
          $office_role = $this->amodel->fetchDropdowndetails(DB_PREFIX . "role_types", array('id', 'role_name'), array('user_type' => $this->session->userdata['user_type'], 'id !=' => '16'));
        }
        if ($this->session->userdata('role_id') == 21) {
          $organization = $this->amodel->fetchDropdowndetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('crm_userid' => $this->session->userdata('userid')));
        } else {
          $organization = $this->amodel->fetchDropdowndetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('id' => $this->session->userdata('organization')));
        }
      }
    } else {



      foreach ($offices as $key => $parent) {
        if ($parent['poffice'] != 0 || isset($parent['poffice'])) {
          $poffice[$parent['parent_office']] = $parent['poffice'];
        }
        if ($parent['boffice'] != 0 || isset($parent['boffice'])) {
          $boffice[$parent['branch_office']] = $parent['boffice'];
        }
        if ($parent['soffice'] != 0 || isset($parent['soffice'])) {
          $soffice[$parent['sub_office']] = $parent['soffice'];
        }
      }
      $this->db->select('*');
      $org = $this->db->get_where('dcode_organisation a', array('id' => $userdetails[0]['organization']))->result_array();
      $loginuser = 'Y';
      $passwrd = 'N';


      if ($this->session->userdata('role_id') == 21) {
        $organization = $this->amodel->fetchDropdowndetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('id' => $userdetails[0]['organization'], 'crm_userid' => $this->session->userdata('userid')));
      } else {
        $organization = $this->amodel->fetchDropdowndetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('id' => $userdetails[0]['organization']));
      }


      if ($user_roles) {
        foreach ($user_roles as $key => $roles) {
          $role[$key] = $roles['role_id'];
        }

        $this->db->select('id,role_name');
        $this->db->where_in('id', $role);
        $office_roles = $this->db->get(DB_PREFIX . 'role_types')->result_array();

        foreach ($office_roles as $k => $val) {
          $office_role[$val['id']] = $val['role_name'];
        }
      }
    }
    $user_type = $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_usertype", array('id', 'name'), array('key' => 'user_types'));

    $ut = array();
    if ($this->session->userdata['user_type'] == 1) {
      $ut = array('user_type' => array('dropdown', 'user_type', 'R|Y|MC-roleload', 'R|Y|MC-roleload', $user_type, 'RF', ''));
    }
    if ($this->session->userdata['user_type'] == 1 && $this->session->userdata('role_id') == 20) {
      $client_usertype = $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_usertype", array('id', 'name'), array('key' => 'user_types', 'id' => 2));
      $ut = array('user_type' => array('dropdown', 'user_type', 'R|Y|MC-roleload', 'R|Y|MC-roleload', $client_usertype, 'RF', ''));
    }
    if ($this->session->userdata('role_id') != 11) {
      $condi = array('organization' => array('dropdown', 'org_name', 'R|Y', 'R|Y', $organization, 'RF', ''), 'parent_office' => array('multiselect', 'parent_office', 'R|MS', 'R|MS', $poffice, 'RF', ''), 'office_id' => array('multiselect', 'office_name', 'MS', 'MS', $boffice, '', ''), '', '', 'sub_office' => array('multiselect', 'sub_office', 'MS', 'MS', $soffice, '', ''), 'role_id' => array('multiselect', 'grant', 'R|Y', 'R|Y', $office_role, 'RF', ''));
    }
    $condi = array_merge($ut, $condi);

    $formElement = array('first_name' => array('text', 'first_name', 'R|Z', 'R|Z', '', 'RF', ''), 'middle_name' => array('text', 'middle_name', 'Z', 'Z', '', '', ''), 'last_name' => array('text', 'last_name', 'R|Z', 'R|Z', '', 'RF', ''), 'gender' => array('dropdown', 'Gender', 'R|Y', 'R|Y', $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'gender')), 'RF', ''),  'designation' => array('text', 'designation', 'R|Z|MC-getdesig', 'R|Z|MC-getdesig', '', 'RF', ''), 'department' => array('dropdown', 'department', 'R|Y', 'R|Y', $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'department')), 'RF', ''), 'email' => array('text', 'email', 'R|Z|MC-checkemail', 'R|Z|MC-checkemail', '', 'RF', ''), 'reporting_to' => array('text', 'reporting_to', 'R|Z', 'R|Z', '', 'RF', ''), 'designation_of_reporter' => array('text', 'designation_of_reporter', 'R|Z|MC-getdesig1', 'R|Z|MC-getdesig1', '', 'RF', ''), 'username' => array('text', 'Login_Name', 'R|Z|MC-checkuser', 'R|Z|MC-checkuser', $loginuser, 'RF', ''), 'photo' => array('upload', 'photo1', 'Z', 'Z', '', '', '', ''), 'pcontact' => array('text', 'pcontact', 'Z', 'Z', '', '', ''));
    if ($this->session->userdata('role_id') != 11)
      $formElement = array_merge($condi, $formElement);


    return array($formElement);
  }
  function user_contact_formelement($userEditid = 0, $userdetails)
  {
    $organisation = '';
    if ($this->session->userdata['userType'] == 2) {
      $organisation = 'N';
    }

    if ($userEditid <> 0) {
      $state = $this->amodel->fetchDropdowndetailsorderby(DB_PREFIX . "states", array('adminCode1', 'name'), array('country_code' => $userdetails[0]['country']));
      $city = $this->amodel->fetchDropdowndetails(DB_PREFIX . "cities", array('id', 'city'), array('country_code' => $userdetails[0]['country'], 'adminCode1' => str_pad($userdetails[0]['state'], 2, "0", STR_PAD_LEFT)));
    } else if (!empty($userdetails)) {
      $state = $this->amodel->fetchDropdowndetailsorderby(DB_PREFIX . "states", array('adminCode1', 'name'), array('country_code' => $userdetails[0]['country']));
      $city = $this->amodel->fetchDropdowndetails(DB_PREFIX . "cities", array('id', 'city'), array('country_code' => $userdetails[0]['country'], 'adminCode1' => str_pad($userdetails[0]['state'], 2, "0", STR_PAD_LEFT)));
    }

    $contact_fromelement = array(array('address1' => array('text', 'address1', 'R|Z', 'R|Z', '', 'RF', ''), 'address2' => array('text', 'address2', 'Z', 'Z', '', '', ''), 'address3' => array('text', 'address3', 'Z', 'Z', '', '', ''),  'country' => array('dropdown', 'country', 'R|Y', 'R|Y', $this->amodel->fetchDropdowndetails(DB_PREFIX . "countries", array('iso_code_2', 'name')), 'RF', ''), 'state' => array('dropdown', 'state', 'R|Y', 'R|Y', $state, 'RF', ''), 'city' => array('dropdown', 'city', 'R|Y', 'R|Y', $city, 'RF', ''), 'pincode' => array('text', 'pincode', 'R|Z', 'R|Z', '', 'RF', ''), 'mobile' => array('text', 'mobile', 'R|Z', 'R|Z', '', 'RF', ''), 'telephone' => array('text', 'telephone', 'Z|N', 'Z|N', '', '', '')));

    return $contact_fromelement;
  }

  /**************************************** 
    CANDIDATE PROFILE 
   ***************************************/
  function candidate_formelement($candidateEditid = 0, $candidate_details)
  {
    if ($candidateEditid == 0) {
      $organization = $this->amodel->fetchDropdowndetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('org_status' => 1));
      $loginuser = '';
      $passwrd = '';
      if ($this->session->userdata['user_type'] == 2) {
        $office = '';
        $org = 'NN';

        $roleid = $this->session->userdata('role_id');

        if (in_array($roleid, array(12, 13, 14))) {
          $condition = array('parent_office' => $this->session->userdata('organization'), 'parent' => 0);
        }
        $poffice = $this->session->userdata('poffice');
        $getpoffices = $this->amodel->getparentoffices(DB_PREFIX . "office", array('id', 'office_name'), $condition, $poffice);
        $parent_office2[''] = 'Select';
        foreach ($getpoffices as $key => $poffice) {
          $parent_office2[$poffice['id']] = $poffice['office_name'];
        }
      }
    } else {
      $loginuser = 'Y';
      $passwrd = 'N';
      $office = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id', 'office_name'), array('parent_office' => $candidate_details[0]['parent_office'], 'parent !=' => 0));
      $parent_office2 = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id', 'office_name'), array('parent_office' => $candidate_details[0]['organization'], 'parent =' => 0));

      $sub_office = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id', 'office_name'), array('level' => $candidate_details[0]['office_id'], 'parent !=' => 0));
      $organization = $this->amodel->fetchDropdowndetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('id' => $candidate_details[0]['organization']));
    }
    if (in_array($this->session->userdata('role_id'), array(1, 21, 24))) {
      $condi = array('organization' => array('dropdown', 'org_name', 'R|Y|MC-roleload', 'R|Y|DIS', $organization, 'RF', ''));
    }
    $formElement = array('parent_office' => array('dropdown', 'parent_office', 'R|Y', 'Y|DIS', $parent_office2, 'RF', ''), 'office_id' => array('dropdown', 'office_name', 'Y', 'Y|DIS', $office, '', ''), 'sub_office' => array('dropdown', 'sub_office', 'Y', 'Y|DIS', $sub_office, '', ''), 'first_name' => array('text', 'first_name', 'R|Z|MC-name', 'R|Z|MC-name', '', 'RF', ''), 'middle_name' => array('text', 'middle_name', 'Z', 'Z', '', '', ''), 'last_name' => array('text', 'last_name', 'R|Z|MC-checkname', 'R|Z|MC-checkname', '', 'RF', ''), 'gender' => array('dropdown', 'Gender', 'R|Y', 'R|Y', $this->amodel->fetchDropdowndetails(DB_PREFIX . "master_masterdata", array('id', 'name'), array('key' => 'gender')), 'RF', ''), 'email' => array('text', 'email', 'R|Z|MC-checkemail', 'R|Z|MC-checkemail', '', 'RF', ''), 'client_ref_number' => array('text', 'client_ref_number', 'Z', 'Z', '', '', ''),  'photo' => array('upload', 'photo1', 'Z|MC-checkphoto', 'Z|MC-checkphoto', '', '', '', ''), 'telephone' => array('text', 'telephone', 'N|Z', 'N|Z', '', '', ''));

    $this->load->model('Client_model');
    $check = $this->Client_model->checkprofilesubmitcnt($candidateEditid);
    if ($check['cnt'] > 1 && $candidateEditid <> 0) {
      $formElement1 = array('submit_date' => array('text', 'submit_date', 'R', 'R|D1|Z', '', 'RF', ''));

      $finalelement = array_merge($formElement, $formElement1);
    } else
      $finalelement = $formElement;



    if (in_array($this->session->userdata('role_id'), array(1, 21, 24)))
      $finalelement = array_merge($condi, $finalelement);


    return array($finalelement);
  }
  function candidatedml($id = 0, $reqID = 0)
  { //echo '<pre>';print_r($_POST);exit;
    if ($this->security->xss_clean($_POST)) {
      /*if(trim($_POST['user_code']) != trim(md5(date('y-m-d').$_POST['captcha']))) { 
                $this->session->set_userdata('errors','Invalid captcha');
                return $error;
                exit;
      }*/
      // $this->form_validation->set_rules('first_name', 'First Name','trim|required|max_length[30]|alpha');
      // $this->form_validation->set_rules('middle_name', 'Middle Name','trim|max_length[30]|alpha');
      // $this->form_validation->set_rules('last_name', 'Last Name','trim|required|max_length[30]|alpha');
      $this->form_validation->set_rules('gender', 'Gender', 'trim|required|is_natural');
      $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
      $this->form_validation->set_rules('telephone', 'Telephone', 'trim|numeric|max_length[30]');
      $this->form_validation->set_rules('client_ref_number', 'Client Reference Number', 'trim|alpha_dash|max_length[30]');
      $this->form_validation->set_rules('parent_office', 'Head Office', 'trim|is_natural');
      $this->form_validation->set_rules('office_id', 'Branch Office', 'trim|is_natural');
      $this->form_validation->set_rules('sub_office', 'Sub Office', 'trim|is_natural');
      $this->form_validation->set_rules('status', 'Status', 'trim|is_natural');
      $this->form_validation->set_rules('cand_status_reason', 'Status Reason', 'trim|max_length[100]');
      $this->form_validation->set_rules('level_id[]', 'Check box', 'trim|is_natural');
      $this->form_validation->set_rules('14_no_of_checks', 'Number of Checks', 'trim|is_natural|less_than[10]');
      $this->form_validation->set_rules('14_information', 'Checks information', 'trim|alpha_numeric_spaces|max_length[250]');
      $this->form_validation->set_rules('user_id', 'User ID', 'trim|max_length[30]|alpha_numeric');

      $this->form_validation->set_rules('g-recaptcha-response', 'recaptcha validation', 'required|callback_validate_captcha');
      $this->form_validation->set_message('validate_captcha', 'Please check the the captcha form');

      if ($this->form_validation->run() == FALSE) {
        echo "<h2 align='center'>ERROR</h2>";
        echo "<label style='color:red;'>" . validation_errors() . '</label>';
        echo "Please go back by clicking on <a href='" . base_url('/Management/candidateadd') . "'><input type='button' value='Back'></a>";
        exit;
      }
    }
    $this->db->trans_begin();
    $this->load->model('Client_model');
    $formData = $this->security->xss_clean($_POST);
    $this->load->library('csvreader');
    $result =   $this->csvreader->parse_file($_FILES['upload']['tmp_name']);
    $status_order = $this->amodel->getDetails(DB_PREFIX . "user", array('status', 'email', 'first_name', 'created_by'), array('id' => $id));
    $reactive_email = $this->amodel->getDetails(DB_PREFIX . "user", array('email'), array('id' => $status_order[0]['created_by']));
    if ($formData && !$result) {
      $cand_email = $this->amodel->getDetails(DB_PREFIX . "user", array('email'), array('email' => $formData['email'], 'parent_office' => $formData['parent_office'], 'active_status!=' => 3));
      if (!empty($cand_email[0]['email']) && ($formData['Submit'] != 'Submit with mail' && $id == 0)) {
        echo "<script>alert('This email already exists!');</script>";
        redirect(base_url('Management/candidate/'), 'refresh');
        exit;
      }
      if ($id == 0 || $formData['Submit'] == 'Submit with mail' || in_array($status_order[0]['status'], array(0, 2))) {

        $formData['role_id'] = 16;
        $formData['user_type'] = 2;
        if (isset($formData['organization']))
          $org_id = $formData['organization'];
        else if ($this->session->userdata('organization') != 1)
          $org_id = $this->session->userdata('organization');
        $org = $this->amodel->getDetails(DB_PREFIX . "organisation", array('org_name', 'id', 'num_days_submit'), array('id' => $org_id));

        $num_days = isset($org[0]['num_days_submit']) ? $org[0]['num_days_submit'] : '5';
        $formData['submit_date'] = date('Y-m-d H:i:s', strtotime($num_days . " weekdays"));
        $new_password = $this->randomString(10);
        $formData['password'] =  md5($new_password);
        $explodeemail = explode('@', $formData['email']);
        $formData['username'] = $explodeemail[0];
        if ($id != 0) {
          $ofc_id = $this->amodel->getDetails(DB_PREFIX . "user", array('office_id'), array('id' => $id));
          $formData['office_id'] = $ofc_id[0]['office_id'];
        }

        $insertData = elements(array('first_name', 'middle_name', 'last_name', 'gender', 'user_type', 'office_id', 'role_id', 'email', 'username', 'password', 'role_id', 'submit_date', 'status', 'type_of_employees'), $formData);
      } else {
        if (isset($formData['submit_date'])) {
          $formData['submit_date'] = date('Y-m-d H:i:s', strtotime($formData['submit_date']));
          $this->Client_model->updateprofilesubmit($id);
          $formData['role_id'] = 16;

          $insertData = elements(array('first_name', 'middle_name', 'last_name', 'user_type', 'gender', 'role_id', 'email', 'submit_date', 'status', 'type_of_employees'), $formData);
        }
        $formData['role_id'] = 16;

        $insertData = elements(array('first_name', 'middle_name', 'last_name', 'gender', 'role_id', 'email', 'status', 'type_of_employees'), $formData);
      }

      if (isset($formData['organization']))
        $insertData['organization'] = $formData['organization'];
      else if ($this->session->userdata('organization') != 1)
        $insertData['organization'] = $this->session->userdata('organization');
      if (isset($formData['office_id']))
        $insertData['office_id'] = $formData['office_id'];
      if (isset($formData['parent_office']))
        $insertData['parent_office'] = $formData['parent_office'];
      if (isset($formData['sub_office']))
        $insertData['sub_office'] = $formData['sub_office'];

      if (isset($_FILES['photo']['name']) && !empty($_FILES['photo']['name'])) {
        $this->load->library('Upload');
        $config['allowed_types'] = 'jpg|png|gif|jpeg';
        $config['upload_path'] = 'uploads/user_photo/original/';
        $config['upload_thumb'] = 'uploads/user_photo/thumb/';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if ($this->upload->do_upload('photo')) {

          $upload_data        = $this->upload->data();
          $insertData['original'] = $config['upload_path'] . '' . $upload_data['file_name'];
          $config['image_library'] = 'gd2';
          $config['source_image'] = getcwd() . '/uploads/user_photo/original/' . $upload_data['file_name'];
          $config['new_image'] = getcwd() . '/uploads/user_photo/thumb/' . $upload_data['file_name'];
          $config['create_thumb'] = FALSE;
          $config['width']        = 54;
          $config['height']        = 46;
          $this->load->library('image_lib', $config);
          $this->image_lib->initialize($config);

          if (! $this->image_lib->resize()) {
            $this->image_lib->display_errors();
            $this->session->set_userdata('errors', $this->image_lib->display_errors());
          } else {

            $insertData['thumbnail'] =  $config['upload_thumb'] . '' . $upload_data['file_name'];
          }
        }

        if ($this->upload->display_errors() != '') {
          $this->session->set_userdata('errors', $this->upload->display_errors());
        }
      }
      $insertData = $this->security->xss_clean($insertData);
      $return_id = $this->amodel->dmlfunction(DB_PREFIX . "user", array('id' => $id), $insertData, $id);

      $upload_files = array('file_name', 'upload_file');
      $this->insertcloneDetails($formData['count1'], $upload_files, $return_id, 'candidate_upload_files', $id, 'user_id');


      $this->db->select('id');
      $this->db->where('user_id', $return_id);
      $contactdetails = $this->db->get(DB_PREFIX . 'user_contact_details')->row_array();

      $contact_id = 0;
      if (!empty($contactdetails))
        $contact_id = $contactdetails['id'];
      $formData['user_id'] = $return_id;
      $formDataCan['telephone'] = isset($formData['telephone']) ? $formData['telephone'] : '';
      $formDataCan['cand_status_reason'] = isset($formData['cand_status_reason']) ? $formData['cand_status_reason'] : '';
      $formDataCan['user_id'] = $return_id;
      if ($id == 0 || $contact_id == 0) {
        $insertcontact =  elements(array('user_id', 'address1', 'address2', 'address3', 'city', 'mobile', 'telephone', 'country', 'state', 'pincode', 'cand_status_reason'), $formDataCan);
      } else {

        $insertcontact =  elements(array('address1', 'address2', 'address3', 'city', 'mobile', 'telephone', 'country', 'state', 'pincode', 'cand_status_reason'), $formDataCan);
      }
      $this->amodel->dmlfunction(DB_PREFIX . "user_contact_details", array('user_id' => $return_id), $insertcontact, $contact_id);

      if ($id == 0) {

        $organization = $this->amodel->getDetails(DB_PREFIX . "organisation", array('org_name', 'id'), array('id' => $insertData['organization']));


        $ins['organization'] = $insertData['organization'];
        $this->db->select('MAX(request_id) as id');
        $this->db->where('organisation', $ins['organization']);
        $lastcase = $this->db->get(DB_PREFIX . 'client_request')->row_array();

        $this->db->select('case_no');
        $this->db->where('request_id', $lastcase['id']);
        $this->db->where('organisation', $ins['organization']);
        $lastcase = $this->db->get(DB_PREFIX . 'client_request')->row_array();

        $current = date('dm');

        if (empty($lastcase['case_no']) || $casenumber == '0104')
          $caseno = 1;
        else {
          $explode = explode('-', $lastcase['case_no']);
          $caseno = $explode[1] + 1;
        }
        $off = $formData;
        $offices = '';
        if (!empty($off['parent_office']) && !empty($off['office_id']) && !empty($off['sub_office'])) {
          $offices = array('parent_office' => $off['parent_office'], 'office' => $off['office_id'], 'sub_office' => $off['sub_office'], 'status' => 1);
        }
        if (!empty($off['parent_office']) && !empty($off['office_id']) && empty($off['sub_office']))
          $offices = array('parent_office' => $off['parent_office'], 'office' => $off['office_id'], 'sub_office' => 0, 'status' => 1);
        else if (!empty($off['parent_office']) && empty($off['office_id'])  && empty($off['sub_office']))
          $offices = array('parent_office' => $off['parent_office'], 'office' => 0, 'sub_office' => 0, 'status' => 1);
        $order = $this->amodel->getDetails(DB_PREFIX . "order", array('id', 'billing_type'), $offices);
        //for branch offices
        if (empty($order)) {
          $offices = array('parent_office' => $off['parent_office'], 'office' => $off['office_id'], 'sub_office' => 0, 'status' => 1);
          $order = $this->amodel->getDetails(DB_PREFIX . "order", array('id', 'billing_type'), $offices);
        }
        //for head offices
        if (empty($order)) {
          $offices = array('parent_office' => $off['parent_office'], 'office' => 0, 'sub_office' => 0, 'status' => 1);
          $order = $this->amodel->getDetails(DB_PREFIX . "order", array('id', 'billing_type'), $offices);
        }
        $billingtype = '';
        if ($order[0]['billing_type'] == 515) {
          $billingtype = "PR";
        } elseif ($order[0]['billing_type'] == 516) {
          $billingtype = "PO";
        }
        $casenumber = $billingtype . $organization[0]['id'] . '-' . $caseno;

        $formcliData['user_id'] = $return_id;
        $formcliData['candidate_name'] = $formData['first_name'] . ' ' . $formData['middle_name'] . ' ' . $formData['last_name'];

        $formcliData['organisation'] = $insertData['organization'];
        $formcliData['parent_office'] = $formData['parent_office'];
        $formcliData['office'] = $formData['office_id'];
        $formcliData['sub_office'] = $formData['sub_office'];
        $formcliData['order_id'] = $order[0]['id'];
        $formcliData['case_no'] = $casenumber;
        $formcliData['deadline_from'] = date('Y-m-d');
        $formcliData['deadline_to'] = date('Y-m-d', strtotime("5 weekdays"));
        $formcliData['client_ref_number'] = $formData['client_ref_number'];

        $insertcliData = elements(array('user_id', 'deadline_from', 'deadline_to', 'candidate_name', 'organisation', 'office', 'parent_office', 'sub_office', 'order_id', 'case_no', 'client_ref_number'), $formcliData);
        $candidatereqId =  $this->amodel->dmlfunction(DB_PREFIX . "client_request", array('id' => $id), $insertcliData, $id);
        $this->db->insert(DB_PREFIX . 'profile_status', array('candidate_request_id' => $candidatereqId));
        if ($order == NULL) {
          $order = $this->amodel->getDetails(DB_PREFIX . "order", array('id'), array('parent_office' => $formData['parent_office']));
        }
        $client_request_id = $this->db->insert_id();
        $no_of_checks = $formData['no_of_checks'];
        $description = $formData['description'];
        $levelname = '';
        $levelid = '';
        $levelid = json_encode($formData['level_id']);
        $levelar = $formData['level_id'];
        $inslog_data['order_id'] = $order[0]['id'];
        $inslog_data['user_id'] = $return_id;
        $inslog_data['request_id'] = $client_request_id;
        $inslog_data['check_id'] = $levelar[0];
        $inslog_data['action'] = $levelid;
        $inslog_data['updated_by'] = $return_id;
        $inslog_data['updated_on'] = date('Y-m-d H:i:s');
        $this->db->insert(DB_PREFIX . 'loghistory', $inslog_data);

        foreach ($formData['level_id'] as $key => $value) {


          if ($value < 95 || $value == 1306 || ($value > 630 && $value <= 654)) {
            if (isset($formData[$value . '_descriptionm']) && !empty($formData[$value . '_descriptionm'])) {
              if ($value == 75) {
                $levelname = "DRUG " . implode(',', $formData[$value . '_descriptionm']);
              } else {
                $levelname = implode(',', $formData[$value . '_descriptionm']);
              }
            } else {
              $levelname = $formData[$value . '_description'];
            }
            // if(!empty($formData[$value.'_information']))
            // {
            //   $comma=',&nbsp;';
            // }else{
            //   $comma='';
            // }
            // $full_info=$formData[$value.'_information'].$comma.$formData[$value.'_informations'];

            $request_check_insert[] = array(
              'check_id' => $value,
              'no_checks' => $formData[$value . '_no_of_checks'],
              'description' => $levelname,
              'request_id' => $candidatereqId,
              'package_id' => 0,
              'information' => $formData[$value . '_information']
            );
          }
          /****Packages*****/
          if ($value > 650) {
            $this->db->select('*');
            $this->db->where_in('package_id', $value);
            $package_details = $this->db->get(DB_PREFIX . "packages")->result_array();
            //echo '<pre>';print_r($package_details);exit;
            foreach ($package_details as $key => $pval) {
              //print_r($pval['acceptable_limit']);
              $check_id = $pval['check_id'];

              if ($pval['group_id'] == 1) {
                $no_ofchek = ($pval['mandatory'] == 'Yes') ? 1 : 0;
              } else {
                $no_ofchek = ($pval['no_ofcheck']) ? $pval['no_ofcheck'] : 1;
              }


              if ($check_id == 75) {
                $levelname = "DRUG " . $pval['acceptable_limit'];
              } else {
                $levelname = $pval['acceptable_limit'];
              }

              $request_check_insert[] = array(
                'check_id' => $check_id,
                'no_checks' => $no_ofchek,
                'description' => $levelname,
                'request_id' => $candidatereqId,
                'package_id' => $pval['package_id'],
                'information' => $formData[$check_id . '_informations']
              );
            }
          }
          //  else
          // {

          //         if($value==95)
          //         $manualchecks=array('14'=>2,'59'=>0,'68'=>1);
          //         else if($value==96)
          //         $manualchecks=array('14'=>1,'59'=>0,'68'=>1);
          //         else if($value==97)
          //         $manualchecks=array('14'=>1,'59'=>2,'68'=>1);
          //         else if($value==98)
          //         $manualchecks=array('59'=>0,'68'=>1);
          //         else if($value==99)
          //         $manualchecks=array('14'=>1,'59'=>1,'68'=>1);
          //         else if($value==100)
          //         $manualchecks=array('59'=>0);
          //         else if($value==101)
          //         $manualchecks=array('14'=>1,'59'=>1);
          //         else if($value==102)
          //         $manualchecks=array('59'=>1,'68'=>1);
          //         else if($value==105)
          //         $manualchecks=array('631'=>1,'632'=>1,'633'=>1,'634'=>1,'635'=>1);


          //         foreach($manualchecks as $key=>$cvalue) {

          //         $request_check_insert[]=array('check_id'=>$value,
          //         'no_checks'=>$cvalue,
          //         'description'=>$key,
          //         'request_id'=>$candidatereqId);
          //         }

          //         }
        }
        // echo '<pre>';print_r($request_check_insert);exit;
        if ($request_check_insert) {
          $this->db->insert_batch(DB_PREFIX . 'request_check', $request_check_insert);
        }

        $sql = $this->db->query('delete from ' . DB_PREFIX . 'profile_level_status where client_request_id = "' . $candidatereqId . '"');

        foreach ($formData['level_id']  as $key => $value) {
          $ins_data = array();
          $ins_data['client_request_id'] = $candidatereqId;
          $ins_data['check_level_id'] = $value;
          $ins_data['level_status'] = 1;
          $ins_data['created_on'] = date('Y-m-d H:i:s');
          $ins_data['created_by'] = $this->session->userdata('userid');
          $this->db->insert(DB_PREFIX . 'profile_level_status', $ins_data);
        }
        foreach ($formData['level_id'] as $values) {

          if ($values < 95 || $values == 1306 || ($values > 630 && $values <= 654)) {
            $value_l95[] = $values;
          }
          if ($values >= 95 && ($values > 650 && $values != 1306)) {
            $value_g95[] = $values;
          }
        }
        $insbill_data['check_id'] = implode(',', $value_l95);
        $insbill_data['pack_id'] = implode(',', $value_g95);
        $this->db->select('billing_type');
        $billingtype = $this->db->get_where('dcode_order ', array('id' => $order[0]['id']))->row_array();
        /**** Below Both query for amount replace with $client_request_id; ***********/
        $ncheck = $this->db->query("select SUM(m.Rs*a.no_checks) AS total_value
                        from " . DB_PREFIX . "request_check a
                        JOIN " . DB_PREFIX . "add_check m ON m.types_of_check = a.check_id
                        where a.request_id =  " . $client_request_id . " AND (a.check_id < 95 OR (a.check_id >630 AND a.check_id <=654))
                        AND m.order_id =" . $order[0]['id'] . "")->row_array();

        // $ncheckvalue=$this->db->query("select SUM(m.Rs*a.no_checks) AS total_package
        // from ". DB_PREFIX ."request_check a
        // JOIN ". DB_PREFIX ."add_check m ON m.types_of_check = a.check_id
        // where a.request_id =  ". $client_request_id." AND a.check_id >= 95 
        // AND m.order_id =".$order[0]['id']."")->row_array();

        $ncheckvalue = $this->db->query("select sum(Rs) as total_package from " . DB_PREFIX . "add_check where  `types_of_check` IN(SELECT package_id FROM " . DB_PREFIX . "request_check WHERE request_id =" . $client_request_id . " AND order_id =" . $order[0]['id'] . " ) ")->row_array();

        $insbill_data['parent_office'] = $formData['parent_office'];
        $insbill_data['organisation'] = $insertData['organization'];
        $insbill_data['sub_office'] = $formData['sub_office'];

        $insbill_data['office'] = $formData['office_id'];
        $insbill_data['candidate_name'] = $formData['first_name'] . ' ' . $formData['middle_name'] . ' ' . $formData['last_name'];
        $insbill_data['order_id'] = $order[0]['id'];
        $insbill_data['amount'] = $ncheck['total_value'];
        $insbill_data['package_amount'] = $ncheckvalue['total_package'];
        $insbill_data['user_id'] = $return_id;
        $insbill_data['request_id'] = $candidatereqId;

        $insbill_data['case_no'] = $casenumber;
        $insbill_data['created_on'] = date('Y-m-d');
        $insbill_data['billing_type'] = $billingtype['billing_type'];
        $this->db->insert(DB_PREFIX . 'billing', $insbill_data);
      } else {
        $cliData['candidate_name'] = $formData['first_name'] . ' ' . $formData['middle_name'] . ' ' . $formData['last_name'];
        $cliData['client_ref_number'] = $formData['client_ref_number'];
        $this->db->where('user_id', $return_id);
        $this->db->update(DB_PREFIX . "client_request", $cliData);
      }
      $cand_details = $this->amodel->getDetails(DB_PREFIX . "client_request", array('organisation', 'created_by'), array('user_id' => $return_id));

      $org = $this->amodel->getDetails(DB_PREFIX . "organisation", array('org_name', 'id', 'num_days_submit', 'logo'), array('id' => $cand_details[0]['organisation']));
      $num_days = isset($org[0]['num_days_submit']) ? $org[0]['num_days_submit'] : '5';
      $logo = isset($org[0]['logo']) ? $org[0]['logo'] : '';
      $data['new_password'] = $new_password;
      $data['first_name'] = $formData['first_name'];
      $data['email'] = $formData['email'];
      $data['org_name'] = $org[0]['org_name'];
      $data['expiry_date'] = $formData['submit_date'];
      $client = $this->amodel->getDetails(DB_PREFIX . "user", array("email,CONCAT(first_name,' ',last_name) AS name"), array('id' => $cand_details[0]['created_by']));
      $data['cemail'] = $client[0]['email'];
      $data['cname'] = $client[0]['name'];
      $data['num_days'] = $num_days;
      $data['logo'] = $logo;
      $data['cand_user_id'] = base64_encode($return_id);

      $data['request_id'] = (!empty($candidatereqId)) ? $candidatereqId : $reqID;
      //****************** for mail verification *******************/
      if (@$return_id && @$new_password && $formData['Submit'] != 'Submit with mail' && empty($status_order)) {
        $id_mail =   send_email_candidateadd('new_registration_candidate', 'Background Verification Login Details @' . $data['org_name'], @$formData['email'], @$client[0], $data);
      } else if ($formData['Submit'] == 'Submit with mail' && $status_order[0]['status'] == 1 && $formData['status'] == 1) {
        $returnpsd_id = $this->amodel->getDetails(DB_PREFIX . "user", array('email', 'first_name', 'password'), array('id' => $id));
        $id_mail =   send_email_candidateadd('new_registration_candidate', 'Background Verification Login Details @' . $data['org_name'], @$formData['email'], @$client[0], $data);
      } else if ($status_order[0]['status'] == 0 && $formData['Submit'] == 'Submit with mail' && $formData['status'] == 1) {
        $id_mail =     send_email_candidateadd('candidate_reactive', 'Background Verification Login Reactivation @' . $data['org_name'], @$formData['email'], @$client[0], $data);
      }
      //permission
      if ($id == 0) {
        $menucond = "menu_ids IS NOT NULL AND  menu_ids!=''";
        $this->db->select('menu_ids');
        $this->db->where('user_type', 2);
        $this->db->where('role_id', 16);
        $this->db->where($menucond);
        $this->db->order_by('role_id', 'DESC');
        $menus = $this->db->get(DB_PREFIX . 'role_permissions')->row_array();

        if (isset($formData['organization']) && $formData['organization'] <> '')
          $organization = $formData['organization'];
        else
          $organization = $this->session->userdata('organization');
        $role_permission['user_type'] = 2;
        $role_permission['role_id'] = 16;
        $role_permission['office_id'] = $formData['office_id'];
        $role_permission['parent_office'] = $formData['parent_office'];
        $role_permission['organization'] = $organization;
        $this->db->where($role_permission);
        $checkrole = $this->db->get(DB_PREFIX . 'role_permissions')->row_array();
        if (empty($checkrole)) {
          $role_permission['active_status'] = 1;
          $role_permission['created_on'] = date('Y-m-d H:i:s');
          $role_permission['menu_ids'] = $menus['menu_ids'];

          $this->db->insert(DB_PREFIX . 'role_permissions', $role_permission);
        }
        $this->db->select('feature_id,add,edit,delete,search,list,generate,task_status');
        $this->db->where('role_id', 16);
        $this->db->group_by('feature_id');
        $this->db->order_by('role_id', 'DESC');
        $roles_config = $this->db->get('m_role_config')->result_array();
        $this->db->where('role_id', 16);
        $this->db->where('office_id', $formData['office_id']);
        $this->db->where('parent_office', $formData['parent_office']);
        $this->db->where('organization', $organization);
        $this->db->group_by('feature_id');
        $check_config = $this->db->get('m_role_config')->row_array();


        if (!empty($roles_config) && empty($check_config)) {
          $new_config = array();
          $newarryay = array();
          foreach ($roles_config as $config_role) {
            $new_config[$config_role['feature_id']] = $config_role;

            $new_config1[$config_role['feature_id']]['role_id'] = 16;
            $new_config1[$config_role['feature_id']]['office_id'] = $formData['office_id'];
            $new_config1[$config_role['feature_id']]['parent_office'] = $formData['parent_office'];
            $new_config1[$config_role['feature_id']]['organization'] = $organization;
            $new_config1[$config_role['feature_id']]['created_by'] = $this->user_id;
            $new_config1[$config_role['feature_id']]['created_on'] = date('Y-m-d H:i:s');

            $newarryay[] = array_merge($new_config[$config_role['feature_id']], $new_config1[$config_role['feature_id']]);
          }
          if (!empty($newarryay))
            $this->db->insert_batch('m_role_config', $newarryay);
        }
        echo "<script>alert('Candidate has been created successfully');</script>";
      }
      if ($this->db->trans_status() === FALSE) {
        $this->db->trans_rollback();
      } else {
        $this->db->trans_commit();
      }

      $this->session->set_flashdata('success_mail', $id_mail, 300);
      if ($id = base64_decode($this->uri->segment(3)) && ($formData['Submit'] != 'Submit with mail')) {
        echo "<script>alert('Changes saved');</script>";
      }
      redirect('Management/candidate/' . base64_encode($return_id), 'refresh');
    }
  }
  function getcandidatedetails($id)
  {
    $usertype =  $this->session->userdata['userType'];
    $roleid =  $this->session->userdata['role_id'];
    $sql = "SELECT a.id, concat_ws(' ',a.first_name,a.middle_name,last_name) as name,a.gender AS gender_id,  c.name AS gender,a.username,p.office_name as parent_office,b.office_name as office_name,s.office_name as sub_office,a.thumbnail,a.email,a.created_on,a.submit_date,cv.candidate_submit_date
                                FROM " . DB_PREFIX . "user a 
        LEFT JOIN " . DB_PREFIX . "office p ON p.id=a.parent_office
        LEFT JOIN " . DB_PREFIX . "office b ON b.id=a.office_id
        LEFT JOIN " . DB_PREFIX . "office s ON s.id=a.sub_office
        LEFT JOIN " . DB_PREFIX . "master_masterdata c ON a.gender= c.id 
        LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.user_id= a.id
        LEFT JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id= cr.request_id 
         WHERE a.id = '$id' ";
    $query = $this->db->query($sql);
    return $query->result_array();
  }

  function getcandidatedoc($id)
  {
    $sql = "SELECT file_name as fname,upload_file as fpath
                        FROM " . DB_PREFIX . "candidate_upload_files
                        WHERE user_id=" . $id;
    $query = $this->db->query($sql);
    return $query->result_array();
  }
  function get_candidatelist($pg = 0, $limit = 10, $sBy = 'id', $sOrder = 'desc', $searchCond = '', $type = '')
  {
    $select = "a.id,concat_ws(' ',a.first_name,a.middle_name,a.last_name) as name, 
                        d.name as gender,a.username,c.office_name as parent_office,h.check_status,f.org_name,g.office_name as office_name,s.office_name as sub_office,h.case_no,h.client_ref_number,a.email,h.request_id,uc.telephone,a.status,a.type_of_employees,f.type_of_employ_candidate ";
    $usertype =  $this->session->userdata['userType'];
    $roleid =  $this->session->userdata['role_id'];
    $parent_office = $this->session->userdata['parent_office'];
    $office_id = $this->session->userdata['office_id'];
    $sub_office = $this->session->userdata['sub_office'];

    $from = "   FROM " . DB_PREFIX . "user a 
                LEFT JOIN " . DB_PREFIX . "user_contact_details uc ON uc.user_id=a.id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata d ON a.gender=d.id
                    LEFT JOIN " . DB_PREFIX . "office c ON c.id=a.parent_office 
                    LEFT JOIN " . DB_PREFIX . "office g ON g.id=a.office_id 
                    LEFT JOIN " . DB_PREFIX . "office s ON s.id=a.sub_office          
              LEFT JOIN " . DB_PREFIX . "organisation f ON f.id=a.organization
              LEFT JOIN " . DB_PREFIX . "client_request h ON h.user_id=a.id
              JOIN " . DB_PREFIX . "user t ON t.id = h.user_id and t.active_status != 3
               LEFT JOIN " . DB_PREFIX . "user_headoffices ho ON ho.user_id=h.created_by
                           LEFT JOIN " . DB_PREFIX . "user_branchoffices br ON br.user_id=h.created_by
                           LEFT JOIN " . DB_PREFIX . "user_suboffices so ON so.user_id=h.created_by
                           LEFT JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=h.request_id
                            where 1  and a.active_status <>3 and a.role_id = 16 and status_of_candidate=0 ";
    $poffice = implode(",", $this->session->userdata['poffice']);
    $boffice = implode(",", $this->session->userdata['boffice']);
    $soffice = implode(",", $this->session->userdata['soffice']);
    if ($usertype == 2 && $roleid == 12) {
      if (empty($boffice) && empty($soffice)) {
        $from .= " and ho.parent_office in (" . $poffice . " ) and f.id=" . $this->session->userdata['parentoffice_id'];
      } else if (!empty($boffice) && empty($soffice)) {
        $from .= " and ho.parent_office in (" . $poffice . " ) and br.branch_office in(" . $boffice . " ) and f.id=" . $this->session->userdata['parentoffice_id'];
      } else {
        $from .= " and ho.parent_office in (" . $poffice . " ) and br.branch_office in(" . $boffice . " ) and so.sub_office in(" . $soffice . " ) and f.id=" . $this->session->userdata['parentoffice_id'];
      }
    } else if ($usertype == 2 && $roleid == 13) {
      $from .= " and h.created_by = " . $this->session->userdata['userid'];
    } else if ($usertype == 2 && $roleid == 14) {
      $from .= " and h.created_by = " . $this->session->userdata['userid'];
    } else if ($this->session->userdata('role_id') == 21) {
      $from .= " and f.crm_userid = " . $this->session->userdata['userid'] . " ";
    } else {
      $from .= "";
    }


    if ($searchCond) {
      $from .= " and $searchCond";
    }

    if ($type == 'count') {
      $select = "count(DISTINCT(a.id)) as count ";
    }

    if ($pg >= 0 && $type <> 'count') {
      $from .= " GROUP BY a.id order by $sBy $sOrder limit $pg," . $limit;
    }

    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    return $query->result_array();
  }

  function skillsdml($id = 0, $user_id)
  {

    $upload_files = array('key', 'skills');
    $this->insertcloneDetails(
      $_POST['count1'],
      $upload_files,
      $user_id,
      'user_skills',
      $id,
      'user_id'
    );
    redirect('' . base_url('Management/userscommonview/' . base64_encode($user_id)));
  }

  //*********************** CANDIADTE PROFILE ENDS**************
  function getuserdetails($id)
  {
    $sql = "SELECT a.id, concat_ws(' ',a.first_name,a.middle_name,last_name) as name,a.gender AS gender_id, e.office_name, c.name AS gender, a.designation,a.username,g.office_name as office_id, h.name as department,a.email,a.original,d.user_type, ur.role_id
                                FROM " . DB_PREFIX . "user a 
        LEFT JOIN " . DB_PREFIX . "office e ON e.id=a.office_id
        LEFT JOIN " . DB_PREFIX . "office g ON g.id=a.parent_office
        LEFT JOIN " . DB_PREFIX . "organisation d ON d.id=a.organization
        LEFT JOIN " . DB_PREFIX . "users_roles ur ON ur.user_id=a.id
        LEFT JOIN " . DB_PREFIX . "master_masterdata c ON a.gender= c.id 
                LEFT JOIN " . DB_PREFIX . "master_masterdata h ON h.id= a.department 
                WHERE a.id = '$id'";

    $query = $this->db->query($sql);
    return $query->result_array();
  }
  function getcontactdetails($id)
  {
    $sql = "SELECT a.user_id,a.mobile,a.telephone,a.address1,a.address2,a.address3,b.name as country,c.city,d.name as state,a.pincode
                                FROM " . DB_PREFIX . "user_contact_details a 
                                LEFT JOIN " . DB_PREFIX . "states d ON d.adminCode1=a.state
                                LEFT JOIN " . DB_PREFIX . "countries b ON b.iso_code_2=a.country
                                LEFT JOIN " . DB_PREFIX . "cities c ON c.id=a.city
                
                WHERE a.user_id = '$id'";
    $query = $this->db->query($sql);
    return $query->result_array();
  }

  function getskilldetails($id)
  {
    $sql = "SELECT a.id,a.user_id,a.key,b.name as skill,c.name as checks
                                FROM " . DB_PREFIX . "user_skills a 
                                LEFT JOIN " . DB_PREFIX . "master_masterdata b ON a.skills= b.id
                                LEFT JOIN " . DB_PREFIX . "master_masterdata c ON a.key= c.id 
                WHERE a.user_id = '$id'";
    $query = $this->db->query($sql);
    return $query->result_array();
  }
  function getcondetails($id)
  {
    $sql = "SELECT a.id,a.email,a.address1,a.address2,a.address3,a.locality,a.telephone,a.mobile
    FROM " . DB_PREFIX . "user a
                WHERE a.id = '$id'";
    $query = $this->db->query($sql);
    return $query->result_array();
  }
  function get_userlist($pg = 0, $limit = 10, $sBy = 'id', $sOrder = 'desc', $searchCond = '', $type = '')
  {


    $select = "a.id,e.role_name, concat_ws(' ',a.first_name,a.middle_name,a.last_name) as name, 
                        d.name as gender,a.username ,GROUP_CONCAT(DISTINCT(g.office_name)) as office_name,a.photo,h.check_status,f.org_name,GROUP_CONCAT(DISTINCT(c.office_name)) as parent_office,a.created_on ,GROUP_CONCAT(DISTINCT(s.office_name)) as sub_office,a.last_activity,a.status,a.email,con.mobile";
    $userType =  $this->session->userdata['userType'];
    $role_id =  $this->session->userdata['role_id'];


    $from = "   FROM " . DB_PREFIX . "user a 
                LEFT JOIN " . DB_PREFIX . "users_roles r ON r.user_id=a.id
                LEFT JOIN " . DB_PREFIX . "user_headoffices ho ON ho.user_id=a.id
                LEFT JOIN " . DB_PREFIX . "user_branchoffices bo ON bo.user_id=a.id
                LEFT JOIN " . DB_PREFIX . "user_suboffices so ON so.user_id=a.id

                 LEFT JOIN " . DB_PREFIX . "master_masterdata d ON a.gender=d.id
              LEFT JOIN " . DB_PREFIX . "role_types e ON e.id=r.role_id
                    LEFT JOIN " . DB_PREFIX . "office s ON s.id=so.sub_office
              LEFT JOIN " . DB_PREFIX . "office g ON g.id=bo.branch_office
              LEFT JOIN " . DB_PREFIX . "organisation f ON f.id=a.organization
           LEFT JOIN " . DB_PREFIX . "office c ON c.id=ho.parent_office
        LEFT JOIN " . DB_PREFIX . "user_contact_details con ON con.user_id= a.id    
                 
              LEFT JOIN " . DB_PREFIX . "client_request h ON h.user_id=a.id
                     where 1  and a.active_status <>3 and a.role_id <> 16  ";

    if ($userType == '2' && $role_id == 12) {
      $from .= " and a.organization = " . $this->session->userdata['organization'];
    }
    if ($userType == '2' && $role_id == 13) {
      $from .= " and a.parent_office = " . $this->session->userdata['parent_office'];
    } else if ($this->session->userdata('role_id') == 21) {
      $from .= " and f.crm_userid = " . $this->session->userdata['userid'] . " ";
    }
    if ($this->session->userdata('role_id') == 11) {
      $from .= " and a.role_id =10";
    }
    if ($this->session->userdata('role_id') == 20) {
      $from .= " and a.user_type =2";
    }

    if ($searchCond) {
      $from .= " and $searchCond ";
    }
    if ($type == 'count')
      $select = "count(DISTINCT(a.id)) as count ";

    if ($pg >= 0 && $type <> 'count' && $_POST['export_btn'] != 'Export') {
      $from .= " GROUP BY a.id order by $sBy  $sOrder limit $pg ," . $limit;
    }

    if ($_POST['export_btn'] == "Export") {
      $from .= " GROUP BY a.id order by a.id desc";
    }


    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    return  $query->result_array();
  }

  function get_candidate_onlinelist($pg = 0, $limit = 10, $sBy = 'id', $sOrder = 'desc', $searchCond = '', $type = '')
  {

    $select = "a.id,e.role_name, concat_ws(' ',a.first_name,a.middle_name,a.last_name) as name, 
                        d.name as gender,a.username ,g.office_name,a.photo,h.check_status ";
    $userType =  $this->session->userdata['userType'];


    $from = "   FROM " . DB_PREFIX . "user a 
                                LEFT JOIN " . DB_PREFIX . "master_masterdata d ON a.gender=d.id
              LEFT JOIN " . DB_PREFIX . "role_types e ON e.id=a.role_id
              LEFT JOIN " . DB_PREFIX . "office g ON g.id=a.office_id
              LEFT JOIN " . DB_PREFIX . "organisation f ON f.id=g.parentoffice_id
              LEFT JOIN " . DB_PREFIX . "client_request h ON h.user_id=a.id
                            where 1  and a.active_status <>3 and a.role_id = 16";

    if ($userType == '2') {
      $from .= " and a.office_id = " . $this->session->userdata['office_id'];
    }

    if ($searchCond) {
      $from .= " and $searchCond";
    }

    if ($type == 'count') $select = "count(*) as count ";

    if ($pg >= 0 && $type <> 'count') {
      $from .= " order by $sBy $sOrder limit $pg," . $limit;
    }

    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    return $query->result_array();
  }

  function officestructure($office_id)
  {
    $sql = "SELECT a.id,a.office_name,b.org_name,a.parent_office
    FROM " . DB_PREFIX . "office a 
    JOIN " . DB_PREFIX . "organisation b on b.id=a.parentoffice_id
                WHERE a.id =" . base64_decode($office_id);
    $query = $this->db->query($sql);
    $key = $query->result_array();
    for ($i = 0; $i <= 100; $i++) {
      if ($key[0]['parent_office'] != 0) {
        $office_id = $key[0]['parent_office'];
        $sql = "SELECT a.id,a.office_name,a.parent_office
    FROM " . DB_PREFIX . "office a 
                WHERE a.id =" . $office_id;
        $query = $this->db->query($sql);
        $res = $query->result_array();
        $result[$i] = $res[0]['office_name'];
        $key[0]['parent_office'] = $res[0]['parent_office'];
      } else {
        $i = 101;
      }
    }
    $j = sizeof($result);
    $l = $j + 1;
    $result[$j] = $key[0]['org_name'];
    $result[$l] = $key[0]['office_name'];
    return $result;
  }

  function get_orglist($pg = 0, $limit = 10, $sBy = 'vendor_id', $sOrder = 'desc', $searchCond = '', $type = '')
  {
    $userType =  $this->session->userdata['userType'];
    $select = "a.id,a.org_name as org_name,a.created_on,d.first_name as created_by";

    $from = "     FROM " . DB_PREFIX . "organisation a 
        LEFT JOIN " . DB_PREFIX . "user d ON d.id=a.created_by
                                where 1 ";

    if ($searchCond) {
      $from .= " and $searchCond";
    }

    if ($userType == 2) {
      $from .= " and a.id = " . $this->session->userdata['parentoffice_id'];
    } else if ($this->session->userdata('role_id') == 21) {
      $from .= " and a.crm_userid = " . $this->session->userdata['userid'] . " ";
    }

    if ($type == 'count') $select = "count(*) as count ";

    if ($pg >= 0 && $type <> 'count') {
      $from .= " order by $sBy $sOrder limit $pg," . $limit;
    }

    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    return $query->result_array();
  }
  // clone insert ///
  function insertcloneDetails($clonecount = 0, $insertValue
  = '', $marketId = '', $tablename = '', $editId = '', $fId = '')
  {
    if ($editId != 0) {
      $this->db->delete($this->config->item('table_prefix') . $tablename, array(
        $fId => $editId
      ));
      $marketId = $editId;
    }
    $insertsales = array();
    $bulksave = array();
    if ($clonecount != 0) {
      for ($i = 1; $i <= $clonecount; $i++) {
        $j = $i;
        if ($i == 1) {
          $j = '';
        }
        foreach ($insertValue as $value) {
          switch ($value) {
            case 'upload_file':
            case '':
              //upload files
              $this->load->library('Upload');
              $config['allowed_types'] = 'doc|pdf|zip|docx';
              $config['upload_path'] = 'uploads/candidate/files/';
              $config['encrypt_name'] = true;
              $config['remove_spaces'] = true;
              $this->load->library('upload', $config);
              $this->upload->initialize($config);
              if ($this->upload->do_upload('upload_file')) {

                $upload_data = $this->upload->data();
                $_POST['original'] = $config['upload_path'] . '' . $upload_data['file_name'];
                $config['source_image']        = getcwd() . '/uploads/candidate/files/' . $upload_data['file_name'];
              }
              if ($this->upload->display_errors() != '') {
                echo $data['error'] = $this->upload->display_errors();
                exit;
              }

              $insertsales[$value] = $_POST['original'];
              break;

            default:
              $insertsales[$value] = $_POST[$value . $j];
              break;
          }
        }
        $insertsales[$fId] = $marketId;
        $bulksave[] = $insertsales;
      }
      $this->db->insert_batch(
        $this->config->item('table_prefix') . $tablename,
        $bulksave
      );
    }
  }
  //clone insert function end
  function candidatemul($post)
  {
    $formData = $_POST;
    $this->load->library('csvreader');
    $result =   $this->csvreader->parse_file($_FILES['upload']['tmp_name']);
    if ($result) {
      foreach ($result as $res) {
        $formData['role_id'] = 16;
        $formData['user_type'] = 2;
        $new_password = $this->randomString(10);
        $formData['password'] =  md5($new_password);
        $formData['first_name'] = $res['first_name'];
        $formData['middle_name'] = $res['middle_name'];
        $formData['last_name'] = $res['last_name'];
        $formData['gender'] = $res['gender'];
        $formData['email'] = $res['email'];
        $formData['username'] = $res['username'];
        if ($id == 0) {
          $insertData = elements(array('first_name', 'middle_name', 'last_name', 'gender', 'office_id', 'role_id', 'email', 'username', 'password', 'role_id'), $formData);
        } else {
          $insertData = elements(array('first_name', 'middle_name', 'last_name', 'gender', 'role_id', 'email'), $formData);
        }

        $return_id = $this->amodel->dmlfunction(DB_PREFIX . "user", array('id' => $id), $insertData, $id);


        if ($id == 0) {
          $formcliData['user_id'] = $return_id;
          $formcliData['candidate_name'] = $formData['first_name'];
          $formcliData['office'] = $formData['office'];
          $insertcliData = elements(array('user_id', 'candidate_name', 'office'), $formcliData);
          $this->amodel->dmlfunction(DB_PREFIX . "client_request", array('id' => $id), $insertcliData, $id);
        }
        if (@$return_id && @$new_password) {
          $data['new_password'] = $new_password;
          $data['first_name'] = $formData['first_name'];
          $data['email'] = $formData['email'];

          send_email_common('new_registration', 'Dcode-Registration', @$formData['email'], $data);
        }
        redirect('' . base_url('Management/candidate/'));
      }
    }
  }


  function team_add($formData)
  {
    if (!empty($formData['check'])) {
      $this->db->where('user_id', $formData['assignee_id']);
      $this->db->delete(DB_PREFIX . 'team');

      foreach ($formData['check'] as $jet => $value) {
        $ins_data['user_id'] = $formData['assignee_id'];
        $ins_data['team'] = $value;
        $this->db->insert(DB_PREFIX . 'team', $ins_data);
      }
    }


    redirect('' . base_url('Management/team_manage/'));
  }
  function getdataentry($id)
  {

    $this->db->where('client_id', $id);
    return $this->db->get('client_dataentry')->result_array();
  }
  function get_candidatecheck($id)
  {
    $this->db->select('check_id,no_checks,description,information');
    $this->db->join(DB_PREFIX . 'profile_status', DB_PREFIX . 'request_check.request_id=candidate_request_id', 'left');
    $this->db->join(DB_PREFIX . 'client_request', 'candidate_request_id=' . DB_PREFIX . 'client_request.request_id', 'left');
    $this->db->where('user_id', $id);
    $this->db->where('package_id', '0');
    return $this->db->get(DB_PREFIX . 'request_check')->result_array();
  }
  function get_candidatepackage($id)
  {
    $this->db->select('DISTINCT(package_id) as package_id,check_id,information');
    $this->db->join(DB_PREFIX . 'profile_status', DB_PREFIX . 'request_check.request_id=candidate_request_id', 'left');
    $this->db->join(DB_PREFIX . 'client_request', 'candidate_request_id=' . DB_PREFIX . 'client_request.request_id', 'left');
    $this->db->where('user_id', $id);
    $this->db->where('package_id >', '0');
    return $this->db->get(DB_PREFIX . 'request_check')->result_array();
  }
  function get_check_list()
  {
    $this->db->select('id,name');
    $this->db->where('parent', 0);
    $this->db->where('key', 'Check');
    return $this->db->get(DB_PREFIX . 'master_masterdata')->result_array();
  }
  function user_address_formelement($userEditid = 0, $userdetails, $org_id)
  {
    $organisation = '';
    $parent_office3 = '';
    $parent_office2 = '';
    if ($this->session->userdata['userType'] == 2) {
      $organisation = 'N';
    }

    if ($userEditid <> 0) {
      $state = $this->amodel->fetchDropdowndetails(DB_PREFIX . "states", array('adminCode1', 'name'), array('country_code' => $userdetails[0]['country']));
      $city = $this->amodel->fetchDropdowndetails(DB_PREFIX . "cities", array('id', 'city'), array('country_code' => $userdetails[0]['country'], 'adminCode1' => str_pad($userdetails[0]['state'], 2, "0", STR_PAD_LEFT)));

      $parent_office2 = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id', 'office_name'), array('parent_office' => $org_id));

      $parent_office3 = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id', 'office_name'), array('parent_office' => $userdetails[0]['parent_office'], 'id' => $userdetails[0]['office_id']));
    }


    $parent_office1 = $this->amodel->fetchDropdowndetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('id' => $org_id));

    $contact_fromelement = array(array('organization' => array('dropdown', 'organization', 'R|Y', 'R|Y', $parent_office1, 'RF', ''), 'parent_office' => array('dropdown', 'parent_office', 'Y', 'Y', $parent_office2, '', ''), 'office_id' => array('dropdown', 'office_id', 'Y', 'Y', $parent_office3, '', ''), 'address1' => array('text', 'address1', 'R|Z', 'R|Z', '', 'RF', ''), 'address2' => array('text', 'address2', 'Z', 'Z', '', '', ''), 'address3' => array('text', 'address3', 'Z', 'Z', '', '', ''),  'country' => array('dropdown', 'country', 'R|Y', 'R|Y', $this->amodel->fetchDropdowndetails(DB_PREFIX . "countries", array('iso_code_2', 'name')), 'RF', ''), 'state' => array('dropdown', 'state', 'R|Y', 'R|Y', $state, 'RF', ''), 'city' => array('dropdown', 'city', 'R|Y', 'R|Y', $city, 'RF', ''), 'pincode' => array('text', 'pincode', 'R|Z', 'R|Z', '', 'RF', '')));
    return $contact_fromelement;
  }
  function add_address($officeid, $id, $formData)
  {

    if ($formData) {
      $insertcontact =  elements(array('organization', 'office_id', 'address1', 'address2', 'address3', 'city', 'country', 'state', 'pincode'), $formData);
      $insertcontact['parent_office'] = $formData['parent_office'];
      $this->amodel->dmlfunction(DB_PREFIX . "office_billing_address", array('id' => $id), $insertcontact, $id);

      redirect('Management/organisationcommonview/' . base64_encode($officeid));
    }
  }

  function getaddress($pg = 0, $limit = 10, $sBy = 'id', $sOrder = 'desc', $searchCond = '', $type = '')
  {

    $select = "g.org_name,ad.id,d.office_name as parent_office,c.office_name as office_name ";

    $from = "   FROM " . DB_PREFIX . "office_billing_address ad 
              LEFT JOIN " . DB_PREFIX . "organisation g ON g.id=ad.organization
              LEFT JOIN " . DB_PREFIX . "office c ON c.id=ad.office_id
              LEFT JOIN " . DB_PREFIX . "office d ON d.id=ad.parent_office
                            where 1 ";

    if ($searchCond) {
      $from .= " and $searchCond";
    }

    if ($type == 'count') $select = "count(*) as count ";

    if ($pg >= 0 && $type <> 'count') {
      $from .= " order by $sBy $sOrder limit $pg," . $limit;
    }

    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    return $query->result_array();
  }

  function get_candidate($rid)
  {

    $sql = "SELECT a.request_id, a.candidate_name, b.id as cid,a.case_no
                FROM " . DB_PREFIX . "client_request a 
                join " . DB_PREFIX . "user b on b.id = a.user_id
                where a.request_id =" . $rid . "";
    $query = $this->db->query($sql);
    return $query->row_array();
  }
  function cand_delete($id, $reason)
  {
    $where = 'id = ' . $id;
    if ($id) {
      $this->db->update(DB_PREFIX . "user", array('active_status' => 3, 'status' => 0, 'remark' => $reason, 'updated_by' => $this->session->userdata['userid']), array('id' => $id));
      if ($this->session->userdata['role_id'] == 1) {
        redirect('' . base_url('Client/client_caselist'));
      } else if ($this->session->userdata['role_id'] == 3) {
        redirect('' . base_url('Dadmin/allotmentlist'));
      }
    }
  }
  function getchecks($rid)
  {

    $sql = "SELECT r.request_id,c.name,ac.level,r.check_id,r.no_checks as chk_count
                        FROM " . DB_PREFIX . "request_check r
            LEFT JOIN " . DB_PREFIX . "master_masterdata c on c.id=r.check_id
            LEFT JOIN " . DB_PREFIX . "add_check ac on ac.types_of_check=r.package_id
            LEFT JOIN " . DB_PREFIX . "client_request cr on cr.request_id=r.request_id
                        WHERE r.request_id=" . $rid . " group by r.check_id ";

    $query = $this->db->query($sql);
    return $query->result_array();
  }
  /* export candidate list */
  function export_candidatelist($pg = 0, $limit = 10, $sBy = 'id', $sOrder = 'desc', $searchCond = '', $type = '')
  {
    $select = "a.id,concat_ws(' ',a.first_name,a.middle_name,a.last_name) as name,a.status, 
      d.name as gender,a.username,c.office_name as parent_office,h.check_status,f.org_name,g.office_name as office_name,s.office_name as sub_office,h.case_no,h.client_ref_number,a.email,h.request_id,uc.telephone,a.type_of_employees,f.type_of_employ_candidate";
    $usertype =  $this->session->userdata['userType'];
    $roleid =  $this->session->userdata['role_id'];
    $parent_office = $this->session->userdata['parent_office'];
    $office_id = $this->session->userdata['office_id'];
    $sub_office = $this->session->userdata['sub_office'];

    $from = "    FROM " . DB_PREFIX . "user a 
                LEFT JOIN " . DB_PREFIX . "user_contact_details uc ON uc.user_id=a.id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata d ON a.gender=d.id
                    LEFT JOIN " . DB_PREFIX . "office c ON c.id=a.parent_office 
                    LEFT JOIN " . DB_PREFIX . "office g ON g.id=a.office_id 
                    LEFT JOIN " . DB_PREFIX . "office s ON s.id=a.sub_office          
              LEFT JOIN " . DB_PREFIX . "organisation f ON f.id=a.organization
              LEFT JOIN " . DB_PREFIX . "client_request h ON h.user_id=a.id
              JOIN " . DB_PREFIX . "user t ON t.id = h.user_id and t.active_status != 3
               LEFT JOIN " . DB_PREFIX . "user_headoffices ho ON ho.user_id=h.created_by
                           LEFT JOIN " . DB_PREFIX . "user_branchoffices br ON br.user_id=h.created_by
                           LEFT JOIN " . DB_PREFIX . "user_suboffices so ON so.user_id=h.created_by
                           LEFT JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=h.request_id
                            where 1  and a.active_status <>3 and a.role_id = 16 and status_of_candidate=0 ";
    $poffice = implode(",", $this->session->userdata['poffice']);
    $boffice = implode(",", $this->session->userdata['boffice']);
    $soffice = implode(",", $this->session->userdata['soffice']);
    if ($usertype == 2 && $roleid == 12) {
      if (empty($boffice) && empty($soffice)) {
        $from .= " and ho.parent_office in (" . $poffice . " ) and f.id=" . $this->session->userdata['parentoffice_id'];
      } else if (!empty($boffice) && empty($soffice)) {
        $from .= " and ho.parent_office in (" . $poffice . " ) and br.branch_office in(" . $boffice . " ) and f.id=" . $this->session->userdata['parentoffice_id'];
      } else {
        $from .= " and ho.parent_office in (" . $poffice . " ) and br.branch_office in(" . $boffice . " ) and so.sub_office in(" . $soffice . " ) and f.id=" . $this->session->userdata['parentoffice_id'];
      }
    } else if ($usertype == 2 && $roleid == 13) {
      $from .= " and h.created_by = " . $this->session->userdata['userid'];
    } else if ($usertype == 2 && $roleid == 14) {
      $from .= " and h.created_by = " . $this->session->userdata['userid'];
    } else if ($this->session->userdata('role_id') == 21) {
      $from .= " and f.crm_userid = " . $this->session->userdata['userid'] . " ";
    } else {
      $from .= "";
    }


    if ($searchCond) {
      $from .= " and $searchCond";
    }

    if ($type == 'count') {
      $select = "count(*) as count ";
    }

    if ($pg >= 0 && $type <> 'count') {
      $from .= " GROUP BY a.id order by a.id desc ";
    }

    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    return $query->result_array();
  }

  /* Modify the candidate and checks */

  function candidate_editformelement($candidateEditid = 0, $candidate_details)
  {
    if ($candidateEditid == 0) {
      $organization = $this->amodel->fetchDropdowndetails(DB_PREFIX . "organisation", array('id', 'org_name'), '');
      $loginuser = '';
      $passwrd = '';
      if ($this->session->userdata['user_type'] == 2) {
        $office = '';
        $org = 'NN';

        $roleid = $this->session->userdata('role_id');

        if (in_array($roleid, array(12, 13, 14))) {
          $condition = array('parent_office' => $this->session->userdata('organization'), 'parent' => 0);
        }
        $poffice = $this->session->userdata('poffice');
        $getpoffices = $this->amodel->getparentoffices(DB_PREFIX . "office", array('id', 'office_name'), $condition, $poffice);
        $parent_office2[''] = 'Select';
        foreach ($getpoffices as $key => $poffice) {
          $parent_office2[$poffice['id']] = $poffice['office_name'];
        }
      }
    } else {
      $loginuser = 'Y';
      $passwrd = 'N';
      $office = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id', 'office_name'), array('parent_office' => $candidate_details[0]['parent_office'], 'parent !=' => 0));
      $parent_office2 = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id', 'office_name'), array('parent_office' => $candidate_details[0]['organization'], 'parent =' => 0));

      $sub_office = $this->amodel->fetchDropdowndetails(DB_PREFIX . "office", array('id', 'office_name'), array('level' => $candidate_details[0]['office_id'], 'parent !=' => 0));
      $organization = $this->amodel->fetchDropdowndetails(DB_PREFIX . "organisation", array('id', 'org_name'), array('id' => $candidate_details[0]['organization']));
    }
    if ($this->session->userdata('role_id') == 1 || $this->session->userdata('role_id') == 3) {
      $condi = array('organization' => array('dropdown', 'org_name', 'R|Y|MC-roleload', 'R|Y|DIS', $organization, 'RF', ''));
    }
    $formElement = array('parent_office' => array('dropdown', 'parent_office', 'R|Y', 'Y|DIS', $parent_office2, 'RF', ''), 'office_id' => array('dropdown', 'office_name', 'Y', 'Y|DIS', $office, '', ''), 'sub_office' => array('dropdown', 'sub_office', 'Y', 'Y|DIS', $sub_office, '', ''), 'first_name' => array('text', 'first_name', 'R|Z|RO', 'R|Z|RO', '', 'RF', ''), 'middle_name' => array('text', 'middle_name', 'Z|RO', 'Z|RO', '', '', ''), 'last_name' => array('text', 'last_name', 'Z|RO', 'Z|RO', '', '', ''), 'email' => array('text', 'email', 'R|Z|MC-checkemail', 'R|Z|MC-checkemail', '', 'RF', ''), 'client_ref_number' => array('text', 'client_ref_number', 'Z', 'Z', '', '', ''));

    $this->load->model('Client_model');
    $check = $this->Client_model->checkprofilesubmitcnt($candidateEditid);
    if ($check['cnt'] > 1 && $candidateEditid <> 0) {
      $formElement1 = array('submit_date' => array('text', 'submit_date', 'R', 'R|D1|Z', '', 'RF', ''));

      $finalelement = array_merge($formElement, $formElement1);
    } else
      $finalelement = $formElement;


    if ($this->session->userdata('role_id') == 1 || $this->session->userdata('role_id') == 3)
      $finalelement = array_merge($condi, $finalelement);


    return array($finalelement);
  }

  function candidate_editdml($id = 0)
  {

    $this->db->trans_begin();
    $formData = $_POST;
    if ($formData) {
      $candidatereqId = $_POST['request_id'];
      $user_id = $_POST['user_id'];
      $cand_email = $this->amodel->getDetails(DB_PREFIX . "user", array('email'), array('email' => $_POST['email'], 'parent_office' => $formData['parent_office'], 'active_status!=' => 3, 'id!=' => $user_id));
      if (!empty($cand_email[0]['email'])) {
        echo "<script>alert('This email already exists!');</script>";
        redirect(base_url('Vsupervisor/case_status/'), 'refresh');
        exit;
      }

      if (!empty($candidatereqId) && !empty($user_id)) {
        $cli_data['client_ref_number'] = $_POST['client_ref_number'];
        $this->db->where('request_id', $candidatereqId);
        $this->db->update(DB_PREFIX . 'client_request', $cli_data);

        $usr_data['email'] = $_POST['email'];
        $this->db->where('id', $user_id);
        $this->db->update(DB_PREFIX . 'user', $usr_data);

        $this->db->where('request_id', $candidatereqId);
        $this->db->delete(DB_PREFIX . 'request_check');
        $no_of_checks = $_POST['no_of_checks'];
        $description = $_POST['description'];
        $information = $_POST['information'];
        $levelname = '';
        $levelar = '';
        $levelar = json_encode($_POST['level_id']);
        $inslog_data['order_id'] = 0;
        $inslog_data['user_id'] = $user_id;
        $inslog_data['request_id'] = $candidatereqId;
        $inslog_data['check_id'] = $levelar[0];
        $inslog_data['action'] = $levelar;
        $inslog_data['updated_by'] = $this->session->userdata('userid');
        $inslog_data['updated_on'] = date('Y-m-d H:i:s');
        $this->db->insert(DB_PREFIX . 'loghistory', $inslog_data);

        foreach ($_POST['level_id'] as $key => $value) {


          if ($value < 95 || ($value > 630 && $value <= 654 || $value == 1306)) {
            if (isset($_POST[$value . '_descriptionm']) && !empty($_POST[$value . '_descriptionm'])) {
              if ($value == 75) {
                $levelname = "DRUG " . implode(',', $_POST[$value . '_descriptionm']);
              } else {
                $levelname = implode(',', $_POST[$value . '_descriptionm']);
              }
            } else {
              $levelname = $_POST[$value . '_description'];
            }


            $request_check_insert[] = array(
              'check_id' => $value,
              'no_checks' => $_POST[$value . '_no_of_checks'],
              'description' => $levelname,
              'request_id' => $candidatereqId,
              'package_id' => 0,
              'information' => $_POST[$value . '_information']
            );
          }
          /****Packages*****/
          if ($value > 650) {
            $this->db->select('*');
            $this->db->where_in('package_id', $value);
            $package_details = $this->db->get(DB_PREFIX . "packages")->result_array();
            foreach ($package_details as $key => $pval) {
              $check_id = $pval['check_id'];

              if ($pval['group_id'] == GROUPID_IDPROOF) {
                $no_ofchek = ($pval['mandatory'] == 'Yes') ? 1 : 0;
              } else {
                $no_ofchek = ($pval['no_ofcheck']) ? $pval['no_ofcheck'] : 1;
              }

              if ($check_id == 75) {
                $levelname = "DRUG " . $pval['acceptable_limit'];
              } else {
                $levelname = $pval['acceptable_limit'];
              }

              $request_check_insert[] = array(
                'check_id' => $check_id,
                'no_checks' => $no_ofchek,
                'description' => $levelname,
                'request_id' => $candidatereqId,
                'package_id' => $pval['package_id'],
                'information' => $_POST[$check_id . '_informations']
              );
            }
          }
          /*             
            else
            {

              if($value==95)
                $manualchecks=array('14'=>2,'59'=>0,'68'=>1);
              else if($value==96)
                $manualchecks=array('14'=>1,'59'=>0,'68'=>1);
              else if($value==97)
                $manualchecks=array('14'=>1,'59'=>2,'68'=>1);
              else if($value==98)
                $manualchecks=array('59'=>0,'68'=>1);
              else if($value==99)
                $manualchecks=array('14'=>1,'59'=>1,'68'=>1);
              else if($value==100)
                $manualchecks=array('59'=>0);
              else if($value==101)
                $manualchecks=array('14'=>1,'59'=>1);
              else if($value==102)
                $manualchecks=array('59'=>1,'68'=>1);
              else if($value==103)
                $manualchecks=array('14'=>2);


              foreach($manualchecks as $key=>$cvalue) {

                $request_check_insert[]=array('check_id'=>$value,
                  'no_checks'=>$cvalue,
                  'description'=>$key,
                  'request_id'=>$candidatereqId);
              }

            } */
        }
        // echo '<pre>';print_r($request_check_insert);exit;
        if ($request_check_insert) {
          $this->db->insert_batch(DB_PREFIX . 'request_check', $request_check_insert);
        }

        $sql = $this->db->query('delete from ' . DB_PREFIX . 'profile_level_status where client_request_id = "' . $candidatereqId . '"');

        foreach ($_POST['level_id']  as $key => $value) {
          $ins_data = array();
          $ins_data['client_request_id'] = $candidatereqId;
          $ins_data['check_level_id'] = $value;
          $ins_data['level_status'] = 1;
          $ins_data['created_on'] = date('Y-m-d H:i:s');
          $ins_data['created_by'] = $this->session->userdata('userid');
          $this->db->insert(DB_PREFIX . 'profile_level_status', $ins_data);
        }
      }


      if ($this->db->trans_status() === FALSE) {
        $this->db->trans_rollback();
      } else {
        $this->db->trans_commit();
      }
      redirect('Vsupervisor/case_status');
    }
  }
  function get_rolecrmusers()
  {
    $sql = "SELECT a.id, concat_ws(' ',a.first_name,a.last_name) as crm_name
                        FROM " . DB_PREFIX . "user a
            LEFT JOIN " . DB_PREFIX . "users_roles u on u.user_id=a.id 
             where u.role_id=21 group by a.id ";
    $query = $this->db->query($sql);
    return $query->result_array();
  }



  /**************************************** 
    CANDIDATE Name EDIT 
   ***************************************/
  function candidate_editform($candidateEditid = 0, $candidate_details)
  {


    $formElement = array('first_name' => array('text', 'first_name', 'R|Z|MC-name', 'R|Z|MC-name', '', 'RF', ''), 'middle_name' => array('text', 'middle_name', 'Z', 'Z', '', '', ''), 'last_name' => array('text', 'last_name', 'R|Z|MC-checkname', 'R|Z|MC-checkname', '', 'RF', ''));

    $finalelement = $formElement;

    return array($finalelement);
  }

  function get_packagelistoff($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '', $type = '')
  {
    $select = " DISTINCT(m.id) as package_id,p.pkg_cost,p.pkg_notes,c.org_name,m.name as package_name";

    $from = "   FROM " . DB_PREFIX . "packages p 
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = p.org_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id = p.package_id
                    where 1";

    if ($searchCond) {
      $from .= " and $searchCond";
    }

    if ($type == 'count') $select = "count(DISTINCT(package_id)) as count ";

    if ($pg >= 0 && $type <> 'count') {
      $from .= " order by $sBy $sOrder limit $pg," . $limit;
    }

    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    return $query->result_array();
  }


  /***********************
    getpackage function
   ***********************/
  function getpackage($id)
  {
    $select_check_q = "SELECT c.org_name,m.name, a.*
                        
            FROM " . DB_PREFIX . "packages a
            LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.org_id
            LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id = a.check_id
            WHERE a.package_id = '$id'";
    $query = $this->db->query($select_check_q);
    return $query->result_array();
  }

  /***********************
    getpackagedetail function
   ***********************/
  function getpackagedetails($id)
  {
    $data = array();
    $select_group_query = "select group_id,group_name from " . DB_PREFIX . "group order by seq_id ASC";
    $group_q = $this->db->query($select_group_query);
    $group = $group_q->result_array();
    foreach ($group as $item) {
      $gid = $item['group_id'];
      //echo  $item["group_name"];
      $select_check_q = "SELECT c.org_name,m.name, a.*
                        
            FROM " . DB_PREFIX . "packages a
            LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.org_id
            LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id = a.check_id
            WHERE a.package_id = '$id' and a.group_id='$gid'";
      $query = $this->db->query($select_check_q);
      $item['checks'] = $query->result_array();

      //if(!empty($item['checks'])){
      $data[] = $item;
      //} 
    }
    return $data;
  }


  /***********************
    getpackagecopy function
   ***********************/
  function getpackagecopy($id)
  {
    $data = array();
    $select_group_query = "select group_id,group_name from " . DB_PREFIX . "group order by seq_id ASC";
    $group_q = $this->db->query($select_group_query);
    $group = $group_q->result_array();
    foreach ($group as $item) {
      $gid = $item['group_id'];
      //echo  $item["group_name"];
      $select_check_q = "SELECT c.org_name,m.name, a.*
                        
            FROM " . DB_PREFIX . "packages a
            LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.org_id
            LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id = a.check_id
            WHERE a.package_id = '$id' and a.group_id='$gid'";
      $query = $this->db->query($select_check_q);
      $item['checks'] = $query->result_array();

      if (!empty($item['checks'])) {
        $data[] = $item;
      }
    }
    return $data;
  }



  /***********Get Tat List ********
      function get_tatlist
   *********************************/
  function get_tatlist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '', $type = '')
  {
    $select = " DISTINCT(c.org_id) as org_id,o.org_name";

    $from = "   FROM " . DB_PREFIX . "customer_tat c 
                    LEFT JOIN " . DB_PREFIX . "organisation o ON o.id = c.org_id
                    where 1";

    if ($searchCond) {
      $from .= " and $searchCond";
    }
    if ($type == 'count') $select = "count(DISTINCT(org_id)) as count ";
    if ($pg >= 0 && $type <> 'count') {
      $from .= " order by $sBy $sOrder limit $pg," . $limit;
    }

    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    return $query->result_array();
  }


  /***********************
      Tatview page
      gettats function
   ***********************/
  function gettats($org_id, $tat_status)
  {

    if ($tat_status == 1 || $tat_status == 0) {
      $select_check_q = "SELECT m.name, a.*               
        FROM " . DB_PREFIX . "customer_tat a
        LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id = a.check_id
        WHERE a.org_id = '$org_id' AND a.tat_status='$tat_status' order by a.check_id,a.effective_from_date";
    }
    if ($tat_status == '') {
      $select_check_q = "SELECT m.name, a.*               
        FROM " . DB_PREFIX . "customer_tat a
        LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id = a.check_id
        WHERE a.org_id = '$org_id' order by a.check_id,a.effective_from_date";
    }

    $query = $this->db->query($select_check_q);
    return $query->result_array();
  }


  /*********** Get TAT Details****************
   ******** function get_tatdetails  ***********
   ********************************************/
  function getorgazation($id)
  {

    $select_check_q = "SELECT id,org_name
      FROM " . DB_PREFIX . "organisation a
      WHERE id = '$id'";
    $query = $this->db->query($select_check_q);
    $data = $query->result_array();

    return $data;
  }

  /*********** Get Letter added Order Check Details****************
   ******** function get_ordercheck  ***********
   ********************************************/
  function get_ordercheck($id)
  {

    $this->db->select('id');
    $this->db->where('organisation', $id);
    $this->db->where('status', 1);
    $rows = $this->db->get(DB_PREFIX . "order ")->result_array();


    $newArr = array();

    foreach ($rows as $key => $value) {

      $orderId = $value['id'];

      $sql = "SELECT ac.order_id,md.id,md.name FROM " . DB_PREFIX . "master_masterdata md 
                LEFT JOIN " . DB_PREFIX . "add_check ac ON ac.types_of_check=md.id
                LEFT JOIN " . DB_PREFIX . "order o ON o.id=ac.order_id and o.status=1";
      $sql .= " WHERE (o.id='" . $value['id'] . "' ) ORDER BY md.seqid";
      $result = $this->db->query($sql);
      $ncheck = $result->result_array();

      $newArr = array_merge($newArr, $ncheck);
    }

    $packageArr = array();
    $checkArr = array();
    foreach ($newArr as $row) {


      if ($row['id'] > 650) {
        $row['name'] = '';

        $sql = "SELECT md.id FROM " . DB_PREFIX . "master_masterdata md 
                    LEFT JOIN " . DB_PREFIX . "packages p ON p.check_id=md.id";

        $sql .= " WHERE (p.package_id='" . $row['id'] . "')";
        $result = $this->db->query($sql);
        $rows = $result->result_array();

        $packageArr = array_merge($packageArr, $rows);
      } else {

        $sql = "SELECT md.id FROM " . DB_PREFIX . "master_masterdata md ";
        $sql .= " WHERE (md.id='" . $row['id'] . "')";
        $result1 = $this->db->query($sql);
        $rows1 = $result1->result_array();

        $checkArr = array_merge($checkArr, $rows1);
      }

      $merge = array_merge($packageArr, $checkArr);
    }

    $ids = array_column($merge, 'id');
    $ids = array_unique($ids);
    $merge_array = array_filter($merge, function ($key, $value) use ($ids) {
      return in_array($value, array_keys($ids));
    }, ARRAY_FILTER_USE_BOTH);

    $tatcheck = array();
    foreach ($merge_array as $value) {
      $cid = $value['id'];
      $sql = "select id from " . DB_PREFIX . "master_masterdata where id='" . $cid . "' AND id NOT IN(SELECT check_id FROM " . DB_PREFIX . "customer_tat WHERE org_id=" . $id . ") ";
      $gettatcheck = $this->db->query($sql)->result_array();
      $tatcheck = array_merge($tatcheck, $gettatcheck);
    }
    return $tatcheck;
  }

  function getinactive_organization($pg = 0, $limit = 10, $sBy = 'id', $sOrder = 'desc', $searchCond = '', $type = '')
  {
    $select = "a.id, a.org_name,a.org_status,b.dataentry_by, b.mincase_recieved_date, b.mincase_accepted_date, b.case_recieved_date, b.case_accepted_date, b.max_created_on ";
    $from = "  FROM " . DB_PREFIX . "organisation AS a 
                  JOIN ( SELECT organisation, dataentry_by, MIN(case_recieved_date) as mincase_recieved_date, MIN(case_accepted_date) as mincase_accepted_date, MAX(case_recieved_date) as case_recieved_date, MAX(case_accepted_date) as case_accepted_date, MAX(created_on) as max_created_on" . $from = " FROM " . DB_PREFIX . "client_request GROUP BY organisation ) as b where a.id = b.organisation ";

    if ($searchCond) {
      $from .= " and $searchCond";
    }
    if ($type == 'count') $select = "count(DISTINCT a.id) as count ";
    if ($this->session->userdata('role_id') == 21) {
      $from .= " and a.crm_userid = " . $this->session->userdata['userid'] . " ";
    }

    if ($_POST['buttonpressed'] == 'Export') {
      $from .= " group by a.id order by a.id $sOrder";
    }
    $sql = "SELECT " . $select . "" . $from;

    $query = $this->db->query($sql);
    return $query->result_array();
  }



  /********************************************** Insert Target value********************
Target Add By Amritha 
          ON :20/01/2023      */
  function target_add($formData)
  {

    $check = $this->check_target($formData['user_id']);
    $status = $formData['Submit'];

    if ($status != 'Update') {
      $insert['target'] = $formData['target'];
      $insert['user_id'] = $formData['user_id'];
      $insert['created_by'] = $this->session->userdata['userid'];
      $insert['created_on'] = date('Y-m-d H:i:s');

      $result = $this->db->insert(DB_PREFIX . 'user_target', $insert);
      if ($result) {
        redirect(base_url('Management/userscommonview/' . $this->uri->segment(3)), 'refresh');
      }
    } else {
      $update['target'] = $formData['target'];
      $update['updated_by'] = $this->session->userdata['userid'];
      $update['updated_on'] = date('Y-m-d H:i:s');
      $this->db->where('user_id', $formData['user_id']);
      $result = $this->db->update(DB_PREFIX . 'user_target', $update);
      if ($result) {
        redirect(base_url('Management/userscommonview/' . $this->uri->segment(3)), 'refresh');
      }
    }
  }

  function check_target($user_id)
  {
    $this->db->select('target,user_id');
    $this->db->where('user_id', $user_id);
    return $this->db->get(DB_PREFIX . 'user_target')->row_array();
  }




  /* END Target */

  //////////////////Get get_candidate_assigneestatus/////////////////////////////////////////
  //    1/03/2023

  function get_candidate_assigneestatus($reqID)
  {

    $this->db->select('assainee_status,case_accepted_date,user_id');
    $this->db->where('request_id', $reqID);
    return $this->db->get(DB_PREFIX . 'client_request')->row_array();
  }

  //////////////////////////////////////////////////////////////////////

  /*********************************
   * Bulk Download List
   * function get_bulklist
   * ******************************/

  function get_bulklist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '', $type = '')
  {

    $roleid = $this->session->userdata('role_id');
    $usertype = $this->session->userdata('user_type');


    if ($sBy == '')
      $sBy = 'a.created_on';
    $select = "c.org_name, a.request_id, a.candidate_name, c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office,  concat_ws(' ', f.first_name, f.last_name) as first_name,a.case_no,ar.qc2_report_publish,a.final_report,a.report_status,a.final_report_published_date,a.case_recieved_date,a.case_accepted_date,t.email,a.billed, a.supplement_report,a.supplement_report_date,a.supplement_report,a.payment_status ,mr.name as paym_status";

    $from = "   FROM " . DB_PREFIX . "client_request a 
                      LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
                      LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
                      LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
                      LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                      LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                      LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by
                      JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3 and t.status != 2
                      LEFT JOIN " . DB_PREFIX . "user_headoffices h ON h.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "user_branchoffices br ON br.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "user_suboffices so ON so.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=a.request_id
                      LEFT JOIN " . DB_PREFIX . "master_masterdata mr ON mr.id=a.payment_status
                      LEFT JOIN dcode_ver_assign_rep ar ON ar.candidate_req_id=a.request_id 
                      LEFT JOIN dcode_clientadditional_report ca ON ca.request_id=a.request_id and ca.status = 1  

                      where 1 ";
    $poffice = implode(",", $this->session->userdata['poffice']);
    $boffice = implode(",", $this->session->userdata['boffice']);
    $soffice = implode(",", $this->session->userdata['soffice']);
    if ($usertype == 2 && $roleid == 12) {

      if (empty($boffice) and empty($soffice)) {
        $from .= " and a.parent_office in (" . $poffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      } else if (!empty($boffice) and empty($soffice)) {
        $from .= " and a.parent_office in (" . $poffice . " ) and a.office in (" . $boffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      } else {
        $from .= " and a.parent_office in (" . $poffice . " ) and a.office in (" . $boffice . " ) and a.sub_office in (" . $soffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      }
    } else if ($usertype == 2 && $roleid == 13) {
      if (empty($boffice) and empty($soffice)) {
        $from .= " and a.parent_office in (" . $poffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      } else if (!empty($boffice) and empty($soffice)) {
        $from .= " and a.parent_office in (" . $poffice . " ) and a.office in (" . $boffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      } else {
        $from .= " and a.parent_office in (" . $poffice . " ) and a.office in (" . $boffice . " ) and a.sub_office in (" . $soffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      }
      $from .= " and ( a.dataentry_by = 3 or a.created_by = " . $this->session->userdata['userid'] . " ) ";
    } else if ($usertype == 2 && $roleid == 14) {
      $from .= " and a.created_by = " . $this->session->userdata['userid'];
    } else if ($usertype == 2 && $roleid == 16) {
      $from .= " and a.user_id = " . $this->session->userdata['userid'];
    } else if ($usertype == 1 && $roleid == 21) {
      $from .= " and c.crm_userid = " . $this->session->userdata['userid'] . "  ";
    } else {
      $from .= " ";
    }
    if ($searchCond) {
      $from .= " and $searchCond ";
    }
    if ($type == 'count')
      $select = " count(DISTINCT(a.request_id)) as count ";

    if ($pg >= 0 && $type <> 'count') {
      $from .= " GROUP BY a.request_id order by $sBy $sOrder limit $pg," . $limit;
    }

    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    // echo '<pre>';print_r($this->db->last_query());exit;
    return $query->result_array();
  }


  function get_download_bulklist($pg = 0, $limit = 10, $sBy = 'a.created_on', $sOrder = 'desc', $searchCond = '', $type = '')
  {
    $roleid = $this->session->userdata('role_id');
    $usertype = $this->session->userdata('user_type');


    if ($sBy == '')
      $sBy = 'a.created_on';
    $select = "c.org_name, a.request_id, a.candidate_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office,  concat_ws(' ', f.first_name, f.last_name) as first_name,a.case_no,ar.qc2_report_publish,a.final_report,a.report_status,a.final_report_published_date,a.case_recieved_date,a.case_accepted_date,t.email,a.billed, a.supplement_report,a.supplement_report_date,a.supplement_report,a.payment_status ,mr.name as paym_status  ";

    $from = "   FROM " . DB_PREFIX . "client_request a 
                    LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
                    LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by
                    JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3 and t.status != 2
                    LEFT JOIN " . DB_PREFIX . "user_headoffices h ON h.user_id=f.id
                    LEFT JOIN " . DB_PREFIX . "user_branchoffices br ON br.user_id=f.id
                    LEFT JOIN " . DB_PREFIX . "user_suboffices so ON so.user_id=f.id
                    LEFT JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=a.request_id
                    LEFT JOIN " . DB_PREFIX . "master_masterdata mr ON mr.id=a.payment_status
                    LEFT JOIN dcode_ver_assign_rep ar ON ar.candidate_req_id=a.request_id 
                    LEFT JOIN dcode_clientadditional_report ca ON ca.request_id=a.request_id and ca.status = 1 
                      where 1 and cv.verification_status=1 and a.final_report=1";
    $poffice = implode(",", $this->session->userdata['poffice']);
    $boffice = implode(",", $this->session->userdata['boffice']);
    $soffice = implode(",", $this->session->userdata['soffice']);
    if ($usertype == 2 && $roleid == 12) {

      if (empty($boffice) and empty($soffice)) {
        $from .= " and a.parent_office in (" . $poffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      } else if (!empty($boffice) and empty($soffice)) {
        $from .= " and a.parent_office in (" . $poffice . " ) and a.office in (" . $boffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      } else {
        $from .= " and a.parent_office in (" . $poffice . " ) and a.office in (" . $boffice . " ) and a.sub_office in (" . $soffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      }
    } else if ($usertype == 2 && $roleid == 13) {
      if (empty($boffice) and empty($soffice)) {
        $from .= " and a.parent_office in (" . $poffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      } else if (!empty($boffice) and empty($soffice)) {
        $from .= " and a.parent_office in (" . $poffice . " ) and a.office in (" . $boffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      } else {
        $from .= " and a.parent_office in (" . $poffice . " ) and a.office in (" . $boffice . " ) and a.sub_office in (" . $soffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      }
      $from .= " and ( a.dataentry_by = 3 or a.created_by = " . $this->session->userdata['userid'] . " ) ";
    } else if ($usertype == 2 && $roleid == 14) {
      $from .= " and a.created_by = " . $this->session->userdata['userid'];
    } else if ($usertype == 1 && $roleid == 21) {
      $from .= " and c.crm_userid = " . $this->session->userdata['userid'] . "  ";
    } else {
      $from .= " ";
    }
    if ($searchCond) {
      $from .= " and $searchCond ";
    }

    if ($type == 'count') $select = " count(DISTINCT(a.request_id)) as count ";

    if ($pg >= 0 && $type <> 'count') {
      $from .= " GROUP BY a.request_id order by a.created_on desc ";
    }

    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    // echo '<pre>';print_r($this->db->last_query());exit;
    return $query->result_array();
  }

  function get_qctarget($user_id)
  {

    $this->db->select('target');
    $this->db->where('user_id', $user_id);
    $this->db->order_by('id', 'desc');
    return $this->db->get(DB_PREFIX . 'user_target_dynamic')->row_array();
  }


  function get_candidateinfo($case_no)
  {

    $condition = " a.case_no = '" . $case_no . "'"; // Sep 20th

    $this->db->select(" a.user_id, a.request_id, a.candidate_name, c.org_name, b.office_name, d.office_name AS parent_office, concat_ws(' ', f.first_name, f.last_name) as first_name, a.created_on,a.case_no,a.final_report_published_date,a.supplement_report_date ");

    $this->db->join(DB_PREFIX . 'office b', 'b.id = a.office', 'left');
    $this->db->join(DB_PREFIX . 'office d', 'd.id = a.parent_office', 'left');
    $this->db->join(DB_PREFIX . 'organisation c', 'c.id = a.organisation', 'left');
    $this->db->join(DB_PREFIX . 'user f', 'f.id = a.created_by', 'left');
    $this->db->join(DB_PREFIX . 'user t', 't.id = a.user_id');
    $this->db->where("t.active_status !=", 3);
    $this->db->where("t.status !=", 2);
    $this->db->where($condition);
    $users = $this->db->get(DB_PREFIX . 'client_request a')->row_array();
    return $users;
  }

  function get_docsdetails($req_id, $check_id)
  {
    $sql = "SELECT table_name, column_name, req_id_name, file_path, check_id FROM  " .  DB_PREFIX .  "master_document_columns WHERE check_id=" . $check_id;
    $query = $this->db->query($sql);
    $result = $query->result_array();

    $noOfRows = count($result);

    $count = 0;
    $sql_union = '';

    // Forming  SQL select query and querying the db.
    foreach ($result as $row) {
      $count++;
      $col_name = $row['column_name'];

      $table = $row['table_name'];

      $sql_union .= "SELECT DISTINCT(" . $row['column_name'] . ") as document_file, '" . $col_name . "' as doc_name, '" . $table . "' as table_name, '" . $row['file_path'] . "' as file_path, '" . $row['check_id'] . "' as check_id, " . $row['req_id_name'] . " as request_id, id as level_id, b.count_of_chk FROM " . $row['table_name'] . " a LEFT JOIN dcode_ver_assign_rep b ON b.candidate_req_id = a." . $row['req_id_name'] . " AND b.level_id=a.id WHERE " . $row['req_id_name'] . " = " . $req_id . " AND " .  $row['column_name'] . " !=  '' AND b.team_mem_id=" . $this->session->userdata['userid'];
      if ($count < $noOfRows)
        $sql_union .= " UNION ";
    }
    $query = $this->db->query($sql_union);
    // $str = $this->db->last_query();
    // echo "<pre>";
    // print_r($str);
    // exit;
    // Returning the resultset as an array.
    if ($query !== FALSE && $query->num_rows() > 0) {
      return $query->result_array();
    }
  }

  function getverified_documents($request_id, $check_id)
  {
    $select = " vl.request_id, vl.check_id, vl.level_id, vl.fielddata, vl.qc2fielddata, vr.count_of_chk as check_cnt ";
    $from = "  from " . DB_PREFIX . "verified_level vl
        LEFT JOIN " . DB_PREFIX . "ver_assign_rep vr ON vr.candidate_req_id = vl.request_id and vr.check_id = vl.check_id and vr.level_id = vl.level_id 
        WHERE vr.team_mem_id=" . $this->session->userdata['userid'];
    $from .= " AND vl.request_id = " . $request_id  . "  AND vl.check_id = " . $check_id;

    // Forming  SQL select query and querying the db.
    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);

    if ($query !== FALSE && $query->num_rows() > 0) {
      return $query->result_array();
    }
  }


  function get_docsdetailscommon($req_id, $check_id)
  {
    $sql = "SELECT table_name, column_name, req_id_name, file_path, check_id FROM  " .  DB_PREFIX .  "master_document_columns WHERE check_id=" . $check_id;
    $query = $this->db->query($sql);
    $result = $query->result_array();

    $noOfRows = count($result);

    $count = 0;
    $sql_union = '';

    // Forming  SQL select query and querying the db.
    foreach ($result as $row) {
      $count++;
      $col_name = $row['column_name'];

      $table = $row['table_name'];

      $sql_union .= "SELECT " . $row['column_name'] . " as document_file, '" . $col_name . "' as doc_name, '" . $table . "' as table_name, '" . $row['file_path'] . "' as file_path, '" . $row['check_id'] . "' as check_id, " . $row['req_id_name'] . " as request_id FROM " . $row['table_name'] . " WHERE " . $row['req_id_name'] . " = " . $req_id . " AND " .  $row['column_name'] . " !=  '' ";
      if ($count < $noOfRows)
        $sql_union .= " UNION ";
    }
    $query = $this->db->query($sql_union);

    // Returning the resultset as an array.
    if ($query !== FALSE && $query->num_rows() > 0) {
      return $query->result_array();
    }
  }



  function get_checkdetail($request_id)
  {

    $sql = "SELECT request_id, check_id FROM dcode_request_check WHERE request_id=" . $request_id;
    $result = $this->db->query($sql);
    return $result->result_array();
  }

  function get_CheckName($check_id)
  {

    $sql = "SELECT name FROM dcode_master_masterdata WHERE id=" . $check_id;
    $result = $this->db->query($sql);
    return $result->row_array();
  }

  function get_VMUpload_file($request_id, $checkId, $authenticate_doc)
  {

    $this->db->select('v.document_name as doc_name,v.check_id,v.authenticate_doc as document_file,"vmupload", vr.count_of_chk');
    $this->db->where('v.authenticate_doc', $authenticate_doc);
    $this->db->where('v.request_id', $request_id);
    $this->db->where('v.check_id', $checkId);
    $this->db->where('v.status', 1);
    $this->db->join(DB_PREFIX . 'ver_assign_rep vr', 'vr.candidate_req_id=v.request_id and vr.check_id=v.check_id and vr.level_id=v.level_id', 'left');
    return  $this->db->get(DB_PREFIX . 'vm_upload_files v')->row_array();
  }

  function get_personaladd_docfile($request_id, $checkId, $fileName)
  {

    $this->db->select('pd.check_id,pd.document_name as doc_name,pd.additional_doc as document_file,vr.count_of_chk');
    $this->db->where('pd.additional_doc', $fileName);
    $this->db->where('pd.request_id', $request_id);
    $this->db->where('pd.check_id', $checkId);
    $this->db->join(DB_PREFIX . 'ver_assign_rep vr', 'vr.candidate_req_id=pd.request_id and vr.check_id=pd.check_id and vr.level_id=pd.ref_id', 'left');
    return $this->db->get(DB_PREFIX . 'personal_additional_doc pd')->row_array();
    // $str = $this->db->last_query();
    //     echo "<pre>";
    //     print_r($str);
    //     exit;
  }

  function get_reqadd_docfile($request_id, $checkId, $fileName)
  {

    $this->db->select('rd.check_id,rd.document_name as doc_name,rd.ref_id,rd.additional_doc as document_file, vr.count_of_chk');
    $this->db->where('rd.additional_doc', $fileName);
    $this->db->where('rd.request_id', $request_id);
    $this->db->where('rd.check_id', $checkId);
    $this->db->join(DB_PREFIX . 'ver_assign_rep vr', 'vr.candidate_req_id=rd.request_id and vr.check_id=rd.check_id and vr.level_id=rd.ref_id', 'left');
    return  $this->db->get(DB_PREFIX . 'requested_additional_doc rd')->row_array();
  }

  function get_contact_docfile($request_id, $checkId, $fileName)
  {

    $this->db->select('checkid,address_proof as document_file');
    $this->db->where('address_proof', $fileName);
    $this->db->where('request_id', $request_id);
    $this->db->where('checkid', $checkId);
    return $this->db->get(DB_PREFIX . 'contact_details')->row_array();
  }

  function get_partial_docfile($request_id, $fileName)
  {

    $this->db->select('document_name as doc_name,multipleupload as document_file');
    $this->db->where('multipleupload', $fileName);
    $this->db->where('request_id', $request_id);
    return  $this->db->get(DB_PREFIX . 'partial_upload_document')->row_array();
  }

  function get_billing_docfile($request_id, $checkId, $fileName)
  {

    $this->db->select('b.check_id,b.bill_proof as document_file,b.level_id, vr.count_of_chk');
    $this->db->where('b.bill_proof', $fileName);
    $this->db->where('b.request_id', $request_id);
    $this->db->where('b.check_id', $checkId);
    $this->db->join(DB_PREFIX . 'ver_assign_rep vr', 'vr.candidate_req_id=b.request_id and vr.check_id=b.check_id and vr.level_id=b.level_id', 'left');
    return  $this->db->get(DB_PREFIX . 'billing_doc b')->row_array();
  }

  function get_compose_docfile($request_id, $checkId, $fileName)
  {

    $this->db->select('c.check_id,c.doc_name,c.level_id,c.doc_file as document_file, vr.count_of_chk');
    $this->db->where('c.additional_doc', $fileName);
    $this->db->where('c.request_id', $request_id);
    $this->db->where('c.check_id', $checkId);
    $this->db->join(DB_PREFIX . 'ver_assign_rep vr', 'vr.candidate_req_id=c.request_id and vr.check_id=c.check_id and vr.level_id=c.level_id', 'left');
    return  $this->db->get(DB_PREFIX . 'composedoc c')->row_array();
  }

  function removeFilename($url)
  {
    $file_info = pathinfo($url);
    return isset($file_info['extension'])
      ? str_replace($file_info['filename'] . "." . $file_info['extension'], "", $url)
      : $url;
  }

  function get_missing_uploaded_files($request_id, $check_id, $nameOfFile)
  {

    $sql = "SELECT id,nameof_file, file_status, comments,user_file_name FROM dcode_missingfiles WHERE request_id=" . $request_id . " AND check_id=" . $check_id . " AND nameof_file ='" . $nameOfFile . "' AND file_status !=1";
    $result = $this->db->query($sql);
    return $result->row_array();
  }

  function get_fileattached($request_id, $role_id)
  {

    if ($role_id == 1) {
      $WHERE = '';
    } else {
      $WHERE = "and qc.assignee_id =" . $this->session->userdata('userid');
    }

    $sql = "SELECT a.* FROM dcode_missingfiles a
        LEFT JOIN dcode_qc2_request qc ON qc.request_id=a.request_id
        WHERE a.request_id=" . $request_id . " AND a.file_status =0 " . $WHERE;
    $result = $this->db->query($sql);
    return $result->result_array();

    // $str = $this->db->last_query();
    //     echo "<pre>";
    //     print_r($str);
    //     exit;
  }


  // Sep 22nd
  function show_report($req_id)
  {
    $sql = "SELECT a.request_id,a.check_id,a.level_id,a.pack_id, max(vl1.qc2_date) as qc2_date,vl1.supplement_published_date 
                FROM " . DB_PREFIX . "verification_request a 
                LEFT JOIN  " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id 
                LEFT JOIN  " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=ar.candidate_req_id
                    WHERE 1  and a.assignee_status=1 AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id  and ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish = 1 else ar.qc2_verification = 1 END ) and  a.request_id = " . $req_id . " and a.check_id !=0 ";


    $result = $this->db->query($sql);

    // Returning the resultset as an array.
    if ($result !== FALSE && $result->num_rows() > 0) {
      return $result->row_array();
    }
  }


  // Sep 26th
  function get_qcref_details($req_id, $check_id, $count_of_chk)
  {
    $sql = "SELECT candidate_req_id, check_id, level_id, pack_id 
                FROM  " . DB_PREFIX . "ver_assign_rep WHERE candidate_req_id = " . $req_id .
      " AND check_id =" .  $check_id . " AND count_of_chk=" .  $count_of_chk;


    $result = $this->db->query($sql);

    // Returning the resultset as an array.
    if ($result !== FALSE && $result->num_rows() > 0) {
      return $result->row_array();
    }
  }

  /************** Export Bulk List ****************/

  function export_bulklist($pg = 0, $limit = 10, $sBy = 'a.created_on', $sOrder = 'desc', $searchCond = '', $type = '')
  {

    $roleid = $this->session->userdata('role_id');
    $usertype = $this->session->userdata('user_type');


    if ($sBy == '')
      $sBy = 'a.created_on';
    $select = "c.org_name, a.request_id, a.candidate_name, c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office,  concat_ws(' ', f.first_name, f.last_name) as first_name,a.case_no,ar.qc2_report_publish,a.final_report,a.report_status,a.final_report_published_date,a.case_recieved_date,a.case_accepted_date,t.email,a.billed, a.supplement_report,a.supplement_report_date,a.supplement_report,a.payment_status ,mr.name as paym_status";

    $from = "   FROM " . DB_PREFIX . "client_request a 
                      LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
                      LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
                      LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
                      LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                      LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                      LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by
                      JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3 and t.status != 2
                      LEFT JOIN " . DB_PREFIX . "user_headoffices h ON h.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "user_branchoffices br ON br.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "user_suboffices so ON so.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=a.request_id
                      LEFT JOIN " . DB_PREFIX . "master_masterdata mr ON mr.id=a.payment_status
                      LEFT JOIN dcode_ver_assign_rep ar ON ar.candidate_req_id=a.request_id 
                      LEFT JOIN dcode_clientadditional_report ca ON ca.request_id=a.request_id and ca.status = 1  
                      where 1 ";
    $poffice = implode(",", $this->session->userdata['poffice']);
    $boffice = implode(",", $this->session->userdata['boffice']);
    $soffice = implode(",", $this->session->userdata['soffice']);
    if ($usertype == 2 && $roleid == 12) {

      if (empty($boffice) and empty($soffice)) {
        $from .= " and a.parent_office in (" . $poffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      } else if (!empty($boffice) and empty($soffice)) {
        $from .= " and a.parent_office in (" . $poffice . " ) and a.office in (" . $boffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      } else {
        $from .= " and a.parent_office in (" . $poffice . " ) and a.office in (" . $boffice . " ) and a.sub_office in (" . $soffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      }
    } else if ($usertype == 2 && $roleid == 13) {
      if (empty($boffice) and empty($soffice)) {
        $from .= " and a.parent_office in (" . $poffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      } else if (!empty($boffice) and empty($soffice)) {
        $from .= " and a.parent_office in (" . $poffice . " ) and a.office in (" . $boffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      } else {
        $from .= " and a.parent_office in (" . $poffice . " ) and a.office in (" . $boffice . " ) and a.sub_office in (" . $soffice . " ) and c.id=" . $this->session->userdata['parentoffice_id'];
      }
      $from .= " and ( a.dataentry_by = 3 or a.created_by = " . $this->session->userdata['userid'] . " ) ";
    } else if ($usertype == 2 && $roleid == 14) {
      $from .= " and a.created_by = " . $this->session->userdata['userid'];
    } else if ($usertype == 2 && $roleid == 16) {
      $from .= " and a.user_id = " . $this->session->userdata['userid'];
    } else if ($usertype == 1 && $roleid == 21) {
      $from .= " and c.crm_userid = " . $this->session->userdata['userid'] . "  ";
    } else {
      $from .= " ";
    }
    if ($searchCond) {
      $from .= " and $searchCond ";
    }
    if ($type == 'count')
      $select = " count(DISTINCT(a.request_id)) as count ";

    if ($pg >= 0 && $type <> 'count') {
      // $from .= " GROUP BY a.request_id order by $sBy $sOrder limit $pg," . $limit;
      $from .= " GROUP BY a.request_id order by a.created_on desc ";
    }

    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    return $query->result_array();

    // $str = $this->db->last_query();
    // echo "<pre>";
    // print_r($str);
    // exit;
  }

  // *****************joiners model code start here****** ka added on sep 4********************

  function joinersadd($data)
  {
    $case_no = $data['jd_case_no'];
    $this->db->select('candidate_name');
    $this->db->from(DB_PREFIX . 'client_request');
    $this->db->where('case_no', $case_no);
    $query = $this->db->get();
    if ($query->num_rows() > 0) {
      $exists_in_joiners = $this->check_CaseNumber_Exists($case_no);
      if (!$exists_in_joiners) {
        return $this->db->insert(DB_PREFIX . 'joiners_data', $data);
      } else {

        return false;
      }
    } else {

      return false;
    }
    
  }

  function check_CaseNumber_Exists($case_no)
  {
    $this->db->where('jd_case_no', $case_no);
    $query = $this->db->get(DB_PREFIX . 'joiners_data');
    if ($query !== FALSE && $query->num_rows() > 0) {
      return true;
    }

    return false;
  }

  // =================================== candidate name display ==============================

  function get_candidate_name_by_case_no()
  {
    $case_no = $this->input->post('case_no');
    $this->db->select('candidate_name');
    $this->db->from(DB_PREFIX . 'client_request');
    $this->db->where('case_no', $case_no);
    $query = $this->db->get();

    if ($query->num_rows() > 0) {
      $result = $query->row();
      echo json_encode(array('status' => 'success', 'candidate_name' => $result->candidate_name));
    } else {
      echo json_encode(array('status' => 'error', 'message' => 'Case number not found'));
    }

    exit();
  }

  function get_joinerslist($pg = 0, $limit = 10, $sBy = 'jd_id', $sOrder = 'desc', $searchCond = '', $type = '')
  {
    $select = "a.jd_id,a.jd_joining_date, a.jd_email_date,a.jd_country,c.office_name AS parent_office, f.org_name,h.candidate_name AS candidate_name,g.office_name AS office_name, s.office_name AS sub_office, 
  h.case_no ";

    $from = "FROM " . DB_PREFIX . "joiners_data a
  LEFT JOIN " . DB_PREFIX . "client_request h ON h.case_no = a.jd_case_no
  LEFT JOIN " . DB_PREFIX . "office c ON c.id = h.parent_office
  LEFT JOIN " . DB_PREFIX . "office g ON g.id = h.office
  LEFT JOIN " . DB_PREFIX . "office s ON s.id = h.sub_office
  LEFT JOIN " . DB_PREFIX . "user_headoffices ho ON ho.user_id = h.created_by
  LEFT JOIN " . DB_PREFIX . "user_branchoffices br ON br.user_id = h.created_by
  LEFT JOIN " . DB_PREFIX . "user_suboffices so ON so.user_id = h.created_by
  LEFT JOIN " . DB_PREFIX . "organisation f ON f.id = h.organisation
  where a.jd_case_no = h.case_no  ";
    if ($searchCond) {
      $from .= " and $searchCond ";
    }

    if ($type == 'count') $select = "count(DISTINCT(h.request_id)) as count ";

    if ($pg >= 0 && $type <> 'count') {
      $from .= " GROUP BY h.request_id order by $sBy $sOrder limit $pg," . $limit;
    }
    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    return $query->result_array();
    
  }
  // *************for export joiners list****************************************************
  function export_joinerslist($pg = 0, $limit = 10, $sBy = 'jd_id', $sOrder = 'desc', $searchCond = '', $type = '')
  {
    $select = "a.jd_id,a.jd_joining_date, a.jd_email_date,jd_country,c.office_name AS parent_office, f.org_name,h.candidate_name AS candidate_name,g.office_name AS office_name, s.office_name AS sub_office, 
  h.case_no ";
  $from = "FROM " . DB_PREFIX . "joiners_data a
  INNER JOIN " . DB_PREFIX . "client_request h ON h.case_no = a.jd_case_no
  LEFT JOIN " . DB_PREFIX . "office c ON c.id = h.parent_office
  LEFT JOIN " . DB_PREFIX . "office g ON g.id = h.office
  LEFT JOIN " . DB_PREFIX . "office s ON s.id = h.sub_office
  LEFT JOIN " . DB_PREFIX . "user_headoffices ho ON ho.user_id = h.created_by
  LEFT JOIN " . DB_PREFIX . "user_branchoffices br ON br.user_id = h.created_by
  LEFT JOIN " . DB_PREFIX . "user_suboffices so ON so.user_id = h.created_by
  LEFT JOIN " . DB_PREFIX . "organisation f ON f.id = h.organisation
   where a.jd_case_no = h.case_no  ";

    if ($searchCond) {
      $from .= " AND " . $searchCond;
    }

    if ($type == 'count') $select = "count(DISTINCT(h.request_id)) as count  ";

    if ($pg >= 0 && $type <> 'count') {
      $from .= " group by h.request_id order by $sBy $sOrder ";
    }

    $sql = "SELECT " . $select . " " . $from;
    $query = $this->db->query($sql);

    if ($query !== FALSE && $query->num_rows() > 0) {
      return $query->result_array();
    }
  }

  // ************************** joiners details for view page  ***************************
  function getjoinersdetails($jd_id)
  {
    $sql = "SELECT a.jd_id, a.jd_case_no, a.jd_joining_date, a.jd_email_date,a.jd_country, h.candidate_name AS candidate_name
            FROM " . DB_PREFIX . "joiners_data a
            LEFT JOIN " . DB_PREFIX . "client_request h ON h.case_no = a.jd_case_no
            WHERE a.jd_id = ?";

    $query = $this->db->query($sql, array($jd_id));

    if ($query !== FALSE && $query->num_rows() > 0) {
      return $query->result_array();
    } else {
      return array();
    }
  }

  function validate_case_no_in_client_request($case_no)
  {
    $this->db->select('case_no');
    $this->db->from(DB_PREFIX . 'client_request');
    $this->db->where('case_no', $case_no);
    $query = $this->db->get();
    return ($query->num_rows() > 0);
  }
  
  function is_case_no_duplicate($case_no, $jd_id)
  {
    $this->db->select('jd_case_no');
    $this->db->from(DB_PREFIX . 'joiners_data');
    $this->db->where('jd_case_no', $case_no);
    $this->db->where('jd_id !=', $jd_id);
    $query = $this->db->get();

    return ($query->num_rows() > 0);
  }

  // ************************** end joiners view ***************************************


  function joiners_editform($joinersEditid = 0, $joiners_details)
  {

      $formElement = array(
      'candidate_name' => array('text', 'candidate_name', 'R|Z|MC-name', 'R|Z|MC-name', '', 'RF', ''),
      'jd_case_no' => array('text', 'jd_case_no', 'R|Z|RO', 'R|Z|RO', '', 'RF', ''),
      'jd_joining_date' => array('text', 'jd_joining_date', 'Z|RO', 'Z|RO', '', '', ''),
      'jd_email_date' => array('text', 'jd_email_date', 'R|Z|MC-checkemail', 'R|Z|MC-checkemail', '', 'RF', '')
    );
    $finalelement = $formElement;
    return array($finalelement);
  }

  


}
