<?php 
    class MissingFiles_model extends CI_Model {
        //Constructor
        function __construct() 
        {
            parent::__construct();
            $this->load->database();            
        }

        
        function get_info_for_finding_files_for_case_nos($case_nos)
        {

        	$sql_sel = "SELECT cr.request_id, cr.case_no, rc.check_id,candidate_name,organisation,cr.parent_office,cr.office,cr.sub_office,cr.user_id,cr.created_on ";
			$from = "  from ".DB_PREFIX ."client_request cr
			LEFT JOIN ".DB_PREFIX ."request_check rc ON rc.request_id=cr.request_id 
			LEFT JOIN ".DB_PREFIX ."user u ON u.id = cr.user_id WHERE case_no IN (";

        	$c = '';

        	// form comma separated values like this 'PO14-834','PO14-835','PO14-836','PO14-837'
    		for($i=0; $i < count($case_nos);$i++)
    		{
    			if($i == (count($case_nos)-1))
    				$c .= "'" . $case_nos[$i] . "'";
    			else
    				$c .= "'" . $case_nos[$i] . "',";

    		}

    		// Forming  SQL select query and querying the db.
    		$sql_sel .= $from . $c . ")"  ;
			$query = $this->db->query($sql_sel);
    		
        	// Returning the resultset as an array.
        	if($query !== FALSE && $query->num_rows() > 0){
        		return $query->result_array();
        	}
        }

        
        function is_organization_unique($case_nos)
		{
			$sql_sel = "SELECT count(DISTINCT(organisation)) as  noOfOrg, count(case_no) as noOfCases FROM " . 
			DB_PREFIX . "client_request where case_no IN (";

        	$c = '';
        	// form comma separated values like this 'PO14-834','PO14-835','PO14-836','PO14-837'
    		for($i=0; $i < count($case_nos);$i++)
    		{
    			if($i == (count($case_nos)-1))
    				$c .= "'" . $case_nos[$i] . "'";
    			else
    				$c .= "'" . $case_nos[$i] . "',";

    		}

    		// Forming  SQL select query and querying the db.
    		$sql_sel .= $c . ")"  ;    		
    		$query = $this->db->query($sql_sel);
    		
        	// Returning the resultset as an array.
        	if($query !== FALSE && $query->num_rows() > 0){
    			return $query->row_array();
    		}
		}


        function get_organization_name($id) 
        {
			$sql = "SELECT org_name FROM  " .  DB_PREFIX .  "organisation WHERE id=" . $id;
			$query = $this->db->query($sql);

			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->row_array();
        	}
		}


		function get_head_office_name($org_id, $head_off_id) 
        {
			$sql = "SELECT office_name FROM  " .  DB_PREFIX .  "office WHERE id=" . $head_off_id . " AND parentoffice_id=" . $org_id; 
			$query = $this->db->query($sql);

			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->row_array();
        	}
		}


		function get_branch_office_name($org_id, $head_off_id, $branch_id) 
        {
			$sql = "SELECT office_name FROM  " .  DB_PREFIX .  "office WHERE id=" . $branch_id . " AND parentoffice_id=" . $org_id . " AND parent_office=" . $head_off_id; 
			$query = $this->db->query($sql);

			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->row_array();
        	}
		}

		function get_sub_office_name($sub_office_id) 
        {
			$sql = "SELECT office_name FROM  " .  DB_PREFIX .  "office WHERE id=" . $sub_office_id; 
			$query = $this->db->query($sql);

			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->row_array();
        	}
		}

		//  Added LEFT JOIN ".DB_PREFIX ."request_check rc ON rc.request_id=cr.request_id 
		function get_users_for_finding_files_for_case_nos($case_nos)
		{
        	$select = " cr.request_id, cr.case_no, rc.check_id, candidate_name,  organisation, cr.parent_office,cr.office,cr.sub_office,cr.user_id,cr.created_on ";
			$from = "  from ".DB_PREFIX ."client_request cr
			LEFT JOIN ".DB_PREFIX ."request_check rc ON rc.request_id=cr.request_id 
			LEFT JOIN ".DB_PREFIX ."user u ON u.id = cr.user_id WHERE case_no IN (";

        	$c = '';
        	// form comma separated values like this 'PO14-834','PO14-835','PO14-836','PO14-837'
    		for($i=0; $i < count($case_nos);$i++)
    		{
    			if($i == (count($case_nos)-1))
    				$c .= "'" . $case_nos[$i] . "'";
    			else
    				$c .= "'" . $case_nos[$i] . "',";

    		}

    		$select .= $from . $c . ")"  ;

    		// Forming  SQL select query and querying the db.
        	$sql = "SELECT " . $select ;   
    		$query = $this->db->query($sql);
    		
        	// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
    			return $query->result_array();
    		}
		}

		function get_users_for_finding_files_grid_view($searchCondition)
		{
			$select = " cr.request_id, cr.case_no, candidate_name,  organisation, cr.parent_office,cr.office,cr.sub_office,cr.user_id,cr.created_on ";
			$from = "  	from ".DB_PREFIX ."client_request cr			
						LEFT JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=cr.request_id
						LEFT JOIN ".DB_PREFIX ."user u ON u.id = cr.user_id WHERE 1 ";
			if ($searchCondition) {
        		$from .= " and $searchCondition";
        	}

		 	// Forming  SQL select query and querying the db.
        	$sql = "SELECT " . $select . "" . $from;        
        	$query = $this->db->query($sql);

        	// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->result_array();
        	}
		}


		function get_info_for_finding_files_grid_view($searchCondition)
		{
			$select = " cr.request_id, cr.case_no, rc.check_id,`candidate_name`,`organisation`,cr.parent_office,cr.office,cr.sub_office,cr.user_id,cr.created_on ";
			$from = "  from ".DB_PREFIX ."client_request cr
			LEFT JOIN ".DB_PREFIX ."request_check rc ON rc.request_id=cr.request_id
			LEFT JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=cr.request_id
			LEFT JOIN ".DB_PREFIX ."user u ON u.id = cr.user_id WHERE 1 ";

			if ($searchCondition) {
        		$from .= " and $searchCondition";
        	}

		 	// Forming  SQL select query and querying the db.
        	$sql = "SELECT " . $select . "" . $from;        
        	$query = $this->db->query($sql);

        	// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->result_array();
        	}
		}

		function  get_xls_of_missing_files($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '')
		{
			$select = " cr.request_id, cr.case_no, rc.check_id, md.name, `candidate_name`,`organisation`, o.org_name, cr.parent_office,cr.office,cr.sub_office,cr.user_id, DATE_FORMAT(cr.created_on, '%d/%m/%y') AS created_on, DATE_FORMAT(cr.case_accepted_date, '%d/%m/%y') AS case_accepted_date,DATE_FORMAT(cr.case_recieved_date, '%d/%m/%y') AS case_recieved_date, DATE_FORMAT(cr.final_report_published_date, '%d/%m/%y') AS final_report_published_date, DATE_FORMAT(cr.supplement_report_date, '%d/%m/%y') AS supplement_report_date ";
			$from = "  from ".DB_PREFIX ."client_request cr
			LEFT JOIN ".DB_PREFIX ."request_check rc ON rc.request_id=cr.request_id 
			LEFT JOIN  ".DB_PREFIX ."master_masterdata md ON md.id = rc.check_id
			LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = cr.organisation
			LEFT JOIN ".DB_PREFIX ."user u ON u.id = cr.user_id WHERE 1 ";

			if ($searchCond) {
        		$from .= " and $searchCond";
        	}

        	// if ($type == 'count') $select = "count(cr.request_id) as count "; 

        	if ($pg >= 0) { 
        		$from .= " order by cr.request_id $sOrder ";
        	}

		 	// Forming  SQL select query and querying the db.
        	$sql = "SELECT " . $select . "" . $from;        
        	$query = $this->db->query($sql);

        
			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->result_array();
        	}

		}

		

		function get_grid_view_of_missing_files($pg = 0, $limit = 50, $sBy = '', $sOrder = 'desc', $searchCondition = '',$type='')
		{
			$select = " cr.request_id, cr.case_no, rc.check_id, md.name, `candidate_name`,`organisation`, o.org_name, cr.parent_office,cr.office,cr.sub_office,cr.user_id, DATE_FORMAT(cr.created_on, '%d/%m/%y') AS created_on, DATE_FORMAT(cr.case_accepted_date, '%d/%m/%y') AS case_accepted_date,DATE_FORMAT(cr.case_recieved_date, '%d/%m/%y') AS case_recieved_date, DATE_FORMAT(cr.final_report_published_date, '%d/%m/%y') AS final_report_published_date, DATE_FORMAT(cr.supplement_report_date, '%d/%m/%y') AS supplement_report_date ";
			$from = "  from ".DB_PREFIX ."client_request cr
			LEFT JOIN ".DB_PREFIX ."request_check rc ON rc.request_id=cr.request_id 
			LEFT JOIN  ".DB_PREFIX ."master_masterdata md ON md.id = rc.check_id
			LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = cr.organisation
			LEFT JOIN ".DB_PREFIX ."user u ON u.id = cr.user_id WHERE 1 ";

			if ($searchCondition) {
        		$from .= " and $searchCondition";
        	}

        	if ($type == 'count') $select = "count(cr.request_id) as count "; 

        	if ($pg >= 0 && $type <> 'count') { 
        		$from .= " order by cr.request_id $sOrder limit $pg," . $limit;
        	}

		 	// Forming  SQL select query and querying the db.
        	$sql = "SELECT " . $select . "" . $from;        
        	$query = $this->db->query($sql);

        	// print_r($this->db->last_query()); exit();
// 
			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->result_array();
        	}

		}

		function get_users_for_finding_files($searchCondition)
		{
			$select = " cr.request_id, cr.case_no, candidate_name, organisation, o.org_name, cr.parent_office,cr.office,cr.sub_office,cr.user_id, DATE_FORMAT(cr.created_on, '%d/%m/%y') AS created_on,
			DATE_FORMAT(cr.case_accepted_date, '%d/%m/%y') AS case_accepted_date,DATE_FORMAT(cr.case_recieved_date, '%d/%m/%y') AS case_recieved_date, DATE_FORMAT(cr.final_report_published_date, '%d/%m/%y') AS final_report_published_date, DATE_FORMAT(cr.supplement_report_date, '%d/%m/%y') AS supplement_report_date ";
			$from = "  from ".DB_PREFIX ."client_request cr	
			LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = cr.organisation			
			LEFT JOIN ".DB_PREFIX ."user u ON u.id = cr.user_id WHERE 1 ";

			if ($searchCondition) {
        		$from .= " and $searchCondition";
        	}

		 	// Forming  SQL select query and querying the db.
        	$sql = "SELECT " . $select . "" . $from;        
        	$query = $this->db->query($sql);

        	// print_r($this->db->last_query()); exit();

        	// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->result_array();
        	}
		}

		function get_info_for_finding_files($searchCondition)
		{
			$select = " cr.request_id, cr.case_no, rc.check_id, md.name, `candidate_name`,`organisation`, o.org_name, cr.parent_office,cr.office,cr.sub_office,cr.user_id,cr.created_on, cr.case_accepted_date, cr.case_recieved_date, cr.final_report_published_date, cr.supplement_report_date ";
			$from = "  from ".DB_PREFIX ."client_request cr
			LEFT JOIN ".DB_PREFIX ."request_check rc ON rc.request_id=cr.request_id 
			LEFT JOIN  ".DB_PREFIX ."master_masterdata md ON md.id = rc.check_id
			LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = cr.organisation
			LEFT JOIN ".DB_PREFIX ."user u ON u.id = cr.user_id WHERE 1 ";

			if ($searchCondition) {
        		$from .= " and $searchCondition";
        	}

		 	// Forming  SQL select query and querying the db.
        	$sql = "SELECT " . $select . "" . $from;        
        	$query = $this->db->query($sql);

 
			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->result_array();
        	}
		}


		// Added check_id
		function get_verified_documents($request_id, $check_id)
        {
            // $this->db->select('request_id, fielddata, qc2fielddata');
            // $this->db->where('request_id', $request_id);
            // $this->db->where('check_id', $check_id);
            
           	// return  $this->db->get(DB_PREFIX.'verified_level')->result_array();
           	/** Aug 30th **/
           	$select = " vl.request_id, vl.fielddata, vl.qc2fielddata, vl.level_id,  vr.count_of_chk  ";
			$from = "  from ".DB_PREFIX ."verified_level vl
			LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON vr.candidate_req_id = vl.request_id and vr.check_id = vl.check_id and vr.level_id = vl.level_id 
			WHERE ";
			$from .= " vl.request_id = " . $request_id  ."  AND vl.check_id = " . $check_id;

			// Forming  SQL select query and querying the db.
        	$sql = "SELECT " . $select . "" . $from;        
        	$query = $this->db->query($sql);

 
			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->result_array();
        	}

        }

        function get_documentname_for_filename($req_id, $check_id, $authenticate_doc_path)
        {
            $this->db->select('document_name');
            $this->db->where('authenticate_doc', $authenticate_doc_path);
            $this->db->where('request_id', $req_id);
            $this->db->where('check_id', $check_id);

           	return  $this->db->get(DB_PREFIX.'vm_upload_files')->row_array();
        }

        function get_docs_for_finding_files_for_request_id($req_id, $check_id)
		{
			$sql = "SELECT table_name, column_name, req_id_name, file_path FROM  " .  DB_PREFIX .  "master_document_columns WHERE check_id=" . $check_id; 
			$query = $this->db->query($sql);
			if($query !== FALSE && $query->num_rows() > 0){
            	$result = $query->result_array();
			}
        	
        	if(!empty($result))
			{
				$noOfRows = count($result);
						
				$count = 0;
				$sql_union = '';
				
				// Forming  SQL select query and querying the db. 
	        	foreach ($result as $row)
				{
					$count ++;
					$col_name = $row['column_name']; //  A string is added to select query
					$file_path = $row['file_path']; //  A string is added to select query
					$table_name = $row['table_name'];  //  A string is added to select query

					// Sep 5th
					if($check_id == 0 || $check_id == 999)
					{
						$sql_union .= " SELECT '" . $col_name ."' as doc_name, '" . $file_path ."' as file_path, '" . $table_name ."' as table_name, "   .  $row['column_name'] .  " AS document_file  FROM " . $row['table_name'] . " WHERE " . $row['req_id_name'] . " = " . $req_id . " AND ".  $row['column_name'] . " !=  ''" ;
					} // Sep 5th
					else
					{ // Sep 5th
					$sql_union .= "SELECT DISTINCT(".$row['column_name'].") as document_file, '".$col_name."' as doc_name, '".$table."' as table_name, '".$row['file_path']."' as file_path, '".$row['check_id']."' as check_id, ".$row['req_id_name']." as request_id, id as level_id, b.count_of_chk FROM " . $row['table_name'] . " a LEFT JOIN dcode_ver_assign_rep b ON b.candidate_req_id = a.".$row['req_id_name']." AND b.level_id=a.id WHERE " . $row['req_id_name'] . " = " . $req_id . " AND ". $row['column_name'] . " != '' AND a.check_status != 15" ; // Aug 30th Sep 5th
					} // Sep 5th
					if($count < $noOfRows)
						$sql_union .= " UNION ";
				}
				$query = $this->db->query($sql_union);
			}

			
        	// Returning the resultset as an array.
        	if($query !== FALSE && $query->num_rows() > 0){
            	return $query->result_array();
        	}
        	
		}


		function get_table_names_file_paths_for_check_id($check_id)
		{
			$sql = "SELECT table_name, column_name, req_id_name, file_path FROM  " .  DB_PREFIX .  "master_document_columns WHERE check_id=" . $check_id; 
			$query = $this->db->query($sql);
			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
            	return $query->result_array();
			}
        }

        function get_doc_name_file_name_for_req_id($col_name,  $table_name, $file_path, $req_id_name, $request_id)
        {
        	$sql .= "SELECT '" . $col_name ."' as doc_name, '" . $file_path ."' as file_path, '" . $table_name ."' as table_name, "   .  $col_name .  " AS document_file  FROM " . $row['table_name'] . " WHERE " . $row['req_id_name'] . " = " . $request_id . " AND ".  $col_name . " !=  ''" ;
        	$query = $this->db->query($sql);
        	// Returning the resultset as an array.
        	if($query !== FALSE && $query->num_rows() > 0){
            	return $query->result_array();
        	}

        }

        function get_doc_name_from_partial_upload_document($req_id, $filename)
        {
            $this->db->select('document_name, status'); /*** Sep 20th  ***/
            $this->db->where('multipleupload', $filename);
            $this->db->where('request_id', $req_id);
            $this->db->where('status', 1);  /*** Sep 20th  ***/

           	return  $this->db->get(DB_PREFIX.'partial_upload_document')->row_array();
        }

        function get_check_id_and_documentname_for_req_id_and_filename($req_id, $authenticate_doc_path)
        {
            $sql = "SELECT vm.document_name, vm.check_id, vm.status, md.name from ".DB_PREFIX ."vm_upload_files vm
			LEFT JOIN  ".DB_PREFIX ."master_masterdata md ON md.id = vm.check_id WHERE request_id = " . $req_id . " AND authenticate_doc = '" . $authenticate_doc_path . "' AND vm.status = 1 ";  // Sep 20th
			$query = $this->db->query($sql);

			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->row_array();
        	}

        }

        function get_vm_name_for_req_id_check_id($req_id, $check_id)
    	{
        	$sql = "SELECT concat_ws(' ',us.first_name,us.middle_name,us.last_name) as vm_name,  vr.team_mem_id   from ".DB_PREFIX ."ver_assign_rep vr
        		LEFT JOIN ".DB_PREFIX ."user us ON us.id = vr.team_mem_id WHERE candidate_req_id = " . $req_id . 
        		" and check_id = " . $check_id ;

        	$query = $this->db->query($sql);

			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->row_array();
        	}
    	}

    	function get_qc2_name_for_req_id($req_id)
    	{
    		$sql = "SELECT concat_ws(' ',us.first_name,us.middle_name,us.last_name) as qc2_name,  qc.assignee_id from ".DB_PREFIX ."qc2_request qc
        		LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id WHERE request_id = " . $req_id;
         
        	$query = $this->db->query($sql);

			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->row_array();
        	}
    	}

    	// Sep 5th
    	function get_doc_name_from_personal_additional_doc($req_id, $filename)
        {
           	$sql = "SELECT pd.document_name, pd.check_id, md.name, vr.count_of_chk from ".DB_PREFIX ."personal_additional_doc pd
			LEFT JOIN  ".DB_PREFIX ."master_masterdata md ON md.id = pd.check_id 
			LEFT JOIN  ".DB_PREFIX ."ver_assign_rep vr  ON vr.candidate_req_id = pd.request_id and vr.level_id = pd.ref_id and  vr.check_id = pd.check_id
			WHERE request_id = " . $req_id . " AND additional_doc = '" . $filename . "'"; 
			$query = $this->db->query($sql);

			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->row_array();
        	}
        }

        // Sep 5th
    	function get_doc_name_from_requested_additional_doc($req_id, $filename)
        {
   			$sql = "SELECT rd.document_name, rd.check_id, md.name, vr.count_of_chk from ".DB_PREFIX ."requested_additional_doc rd
			LEFT JOIN  ".DB_PREFIX ."master_masterdata md ON md.id = rd.check_id 
			LEFT JOIN  ".DB_PREFIX ."ver_assign_rep vr  ON vr.candidate_req_id = rd.request_id and vr.level_id = rd.ref_id and  vr.check_id = rd.check_id
			WHERE request_id = " . $req_id . " AND additional_doc = '" . $filename . "'"; 
			$query = $this->db->query($sql);

			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->row_array();
        	}
        }
           // 26/09/2023

	function get_list_missingfiles_model($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')
		{
			$select = " o.org_name,o.id,cr.candidate_name,cr.request_id, mf.case_no, mf.check_id,md.name, mf.doc_name,mf.nameof_file,mf.pathof_file,mf.role_id,mf.user_id,mf.insertion_date,mf.user_file_name,concat(usr.first_name,' ',usr.last_name) as vname, concat(' ',us.first_name,us.last_name) as qcname,mf.request_id, mf.file_status,mf.comments, mf.qc_updation_date,usr.first_name,mf.count_of_chk,mf.copy_error";
			$from = "  from ".DB_PREFIX . "missingfiles mf
			       JOIN  ".DB_PREFIX ."client_request cr ON cr.request_id = mf.request_id
			       LEFT JOIN  ".DB_PREFIX ."master_masterdata md ON md.id = mf.check_id ";

			if($this->session->userdata['role_id']== 5 || $this->session->userdata['role_id']== 1 || $this->session->userdata['role_id']== 9) { 
			   $from .= " LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.assignee_id = mf.qc_user_id ";
			}
		    if($this->session->userdata['role_id']== 17) { 
			    $from .= " LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id = mf.request_id ";
			      	
			}
			 $from .= " 
                   LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
			       LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = cr.organisation 
			       LEFT JOIN " . DB_PREFIX . "user usr ON usr.id=mf.user_id
			        ";
             if($this->session->userdata['role_id']==5) {
             $from .= " WHERE  mf.user_id = ".$this->session->userdata['userid']." ";
             }
            else if($this->session->userdata['role_id']==17 ) {
             $from .= " WHERE  qc.assignee_id =".$this->session->userdata['userid']." ";
             }
             else{
             	$from .= " WHERE 1";
             }
			
	                
	           if ($searchCond) {
	        $from .= " and $searchCond";
	        }                   
	        if ($type == 'count') $select = "count(DISTINCT(mf.id)) as count "; 
	        
	        if ($pg >= 0 && $type <> 'count' && $_POST['export_btn'] !="Export" ) { 
	        	
                       $from .= " GROUP BY mf.id  $sOrder limit $pg," . $limit;
                }
                
           if($_POST['export_btn'] == "Export"){

                       $from .= " GROUP BY mf.id  order by $sBy $sOrder";
               }     
	                
	        
	        $sql = "SELECT " . $select . "" . $from;
	        $query = $this->db->query($sql);

	     
	        
     		return $query->result_array();
	     
		}

		// Sep 13th
    	function get_count_of_chk_for_bill_proof($req_id, $filename)
        {
   			$sql = "SELECT b.check_id, b.level_id, md.name, vr.count_of_chk from ".DB_PREFIX ."billing_doc b
			LEFT JOIN  ".DB_PREFIX ."master_masterdata md ON md.id = b.check_id 
			LEFT JOIN  ".DB_PREFIX ."ver_assign_rep vr  ON vr.candidate_req_id = b.request_id and vr.level_id = b.level_id and  vr.check_id = b.check_id
			WHERE request_id = " . $req_id . " AND bill_proof = '" . $filename . "'"; 
			$query = $this->db->query($sql);

			// Returning the resultset as an array.
			if($query !== FALSE && $query->num_rows() > 0){
        		return $query->row_array();
        	}
        } //Sep 13th

	} // End of model

?>