<?php
class roles_model extends CI_Model {

        function __construct() 
    {
                parent::__construct();
	}

	function _get_totalusers() {
		$total_users = $this->db->query ( "select count(*) as num_rows
					from a_userdetails u
					left join m_employee_info e on e.id = u.employee_id   
					where e.active_status = 1 and u.active_status = 1 and role_id >= ? ", $this->role_id )->row ()->num_rows;
		
		return $total_users;
	}


	function _get_feature_list( $usertype_id = '' ) {

		$sql = "select * from m_featurelist where 1 ";
	        switch($usertype_id){
	        case 1: $sql .= " and dcode = 1 "; break;
	        case 2: $sql .= " and client = 1 "; break;
	        case 3: $sql .= " and candidate = 1 "; break;
	        }
		$sql .= " order by type,feature_name";
		$res = $this->db->query ( $sql );
		if ($res->num_rows ()) {
			$row = $res->result_array ();
			return $row;
		} else {
			return FALSE;
		}
	}

	function _get_role_config($role_id,$condition) {
		$sql = "select * from m_role_config r where 1 AND ".$condition;
		
		$res = $this->db->query ( $sql );
		if ($res->num_rows ()) {
			$row = $res->result_array ();
			return $row;
		} else {
			return FALSE;
		}
	}

	function _get_rolename($role_id) {
		$sql = "select * from ".DB_PREFIX ."role_types where id = ? ";
		
		$res = $this->db->query ( $sql, $role_id );
		if ($res->num_rows ()) {
			$row = $res->result_array ();
			return $row [0] ['role_name'];
		} else {
			return FALSE;
		}
	}
	function get_roles($pg = 0, $limit = 10, $sBy = 'id', $sOrder = 'desc', $searchCond = '',$type='')     {
                $select = "a.id,a.role_name,c.office_name as parent_office,f.org_name,g.office_name as office_name,organization,r.parent_office as parent,r.office_id,s.office_name as sub_office";
                $userType =  $this->session->userdata['userType'];
                $roleid =  $this->session->userdata['role_id'];

                $from = "   FROM " . DB_PREFIX . "role_types a 
                 LEFT JOIN " . DB_PREFIX . "role_permissions r ON r.role_id=a.id
                LEFT JOIN " . DB_PREFIX . "office g ON g.id=r.office_id
                JOIN " . DB_PREFIX . "organisation f ON f.id=r.organization
                LEFT JOIN " . DB_PREFIX . "office c ON c.id=r.parent_office
                LEFT JOIN " . DB_PREFIX . "office s ON s.id=r.sub_office
                where 1 AND organization IS NOT NULL";


                if ($searchCond) {
                $from .= " and $searchCond";
                }

                if ($type == 'count') $select = "count(*) as count "; 

                if ($pg >= 0 && $type <> 'count') { 
                $from .= " GROUP BY r.id  order by $sBy $sOrder  limit $pg," . $limit;
                }

                $sql = "SELECT " . $select . "" . $from;
                $query = $this->db->query($sql);
                return $query->result_array();
        }
    
}
