<?php 
    class TAT_model extends CI_Model {
        //Constructor
        function __construct() 
        {
            parent::__construct();
            $this->load->database();
            $this->load->model('Adm_model', 'amodel');
        }       

        function get_data_for_computation_of_TAT($searchCond){
            
                $select = " ar.candidate_req_id as request_id,
                ar.check_id,ar.level_id,a.case_no, a.case_accepted_date  as startdate, a.deadline_from,vl.qc2_date as intpublishdate,md.name as checkname, d.office_name as parent_office, b.office_name as branch_office,o.office_name as sub_office,ar.count_of_chk as chknum,c.org_name,a.candidate_name,a.final_report,a.supplement_report, vl.f_report, vl.supplementary ";
                    $from = " FROM " . DB_PREFIX . "client_request a 
                            LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
                            LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
                            LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
                       
                            LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                            LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by
                            LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id=a.request_id
                            LEFT JOIN " . DB_PREFIX . "submit_cv sv ON sv.request_id=a.request_id  
                      
                            LEFT JOIN " . DB_PREFIX . "verified_level vl ON vl.request_id=a.request_id 
                            and vl.check_id = ar.check_id and vl.level_id = ar.level_id
                            LEFT JOIN ". DB_PREFIX . "master_masterdata md ON md.id =ar.check_id
                            JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3
                            where 1 ";
                
               $from .= "  and ar.qc2_report_publish=1 ";  
               
                if ($searchCond) {
                    $from .= " and $searchCond";
                }

                $sql = "SELECT " . $select . "" . $from;
                $query = $this->db->query($sql);
                return $query->result_array();
        }

        function get_info_for_computation_of_TAT($searchCond){
            
                $select = " ar.candidate_req_id as request_id, ar.check_id,ar.level_id,a.case_no, a.organisation,  a.case_accepted_date  as startdate, a.case_recieved_date as accepted_date, a.deadline_from, cv.client_status, vl.qc2_date as intpublishdate,md.name as checkname, d.office_name as parent_office, b.office_name as branch_office,o.office_name as sub_office,ar.count_of_chk as chknum,c.org_name,a.candidate_name,a.final_report,a.supplement_report, a.final_report_published_date,  vl.f_report, vl.supplementary ";
                    $from = " FROM " . DB_PREFIX . "client_request a 
                            LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
                            LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
                            LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
                       
                            LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                            LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by
                            LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id=a.request_id
                            LEFT JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=a.request_id  
                      
                            LEFT JOIN " . DB_PREFIX . "verified_level vl ON vl.request_id=a.request_id 
                            and vl.check_id = ar.check_id and vl.level_id = ar.level_id
                            LEFT JOIN ". DB_PREFIX . "master_masterdata md ON md.id =ar.check_id
                            JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3
                            where 1 ";
                
               $from .= "  and ar.qc2_report_publish=1 ";  
              
                if ($searchCond) {
                    $from .= " and $searchCond";
                }

                $sql = "SELECT " . $select . "" . $from;
                $query = $this->db->query($sql);
        
                return $query->result_array();
        }     

        function check_if_TAT_record_exists($request_id,$check_id,$level_id)      
        {
            $this->db->select('*');
            $this->db->where('request_id', $request_id);
            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            
            return  $this->db->get(DB_PREFIX.'tat_checks')->row_array();
        }

        function get_TAT_list($pg = 0, $limit = 15, $sBy = '', $sOrder = 'desc', $searchCond = '',$type=''){
            $roleid= $this->session->userdata('role_id');  
            $usertype= $this->session->userdata('user_type');
            $user_id =  $this->session->userdata('userid');
            
            $select = " tc.*, a.organisation, a.case_recieved_date, md.name as checkname, d.office_name as parent_office, b.office_name as branch_office,o.office_name as sub_office,c.org_name,a.candidate_name  ";
            $from = " FROM " . DB_PREFIX . "tat_checks tc
                    LEFT JOIN " . DB_PREFIX . "client_request a ON a.request_id = tc.request_id
                    LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
                    LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
                    
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    
                    LEFT JOIN ". DB_PREFIX . "master_masterdata md ON md.id =tc.check_id
                    JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3 ";

            
                    
            if($roleid == 5)
            {
                $from .= "  LEFT JOIN ". DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = tc.request_id and ar.check_id = tc.check_id and ar.level_id = tc.level_id ";
                $searchCond .= "  and ar.team_mem_id=" . $user_id;
            }

            if ($searchCond) {
                $from .= " where 1 and $searchCond";
            }


            if ($type == 'count') $select = "count(DISTINCT(tc.tat_id)) as count "; 
            
            if ($pg >= 0 && $type <> 'count') { 
                $from .= " group by tc.tat_id order by tc.case_no, tc.check_id, tc.level_id, tc.to_date
                 $sOrder limit $pg," . $limit; // Aug
            }
            $sql = "SELECT " . $select . "" . $from;
            $query = $this->db->query($sql);
            return $query->result_array();
            
        }

        function export_TAT_list($pg = 0, $limit = 15, $sBy = '', $sOrder = 'desc', $searchCond = '',$type=''){
            $roleid= $this->session->userdata('role_id');  
            $usertype= $this->session->userdata('user_type');
            $user_id =  $this->session->userdata('userid'); // MN Aug
            $select = " tc.*, a.organisation, a.case_recieved_date, md.name as checkname, d.office_name as parent_office, b.office_name as branch_office,o.office_name as sub_office,c.org_name,a.candidate_name  ";
            $from = " FROM " . DB_PREFIX . "tat_checks tc
                    LEFT JOIN " . DB_PREFIX . "client_request a ON a.request_id = tc.request_id
                    LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
                    LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
                    LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
                    
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    
                    LEFT JOIN ". DB_PREFIX . "master_masterdata md ON md.id =tc.check_id
                    JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3
                    where 1 ";

            if($roleid == 5)
            {
                $from .= "  LEFT JOIN ". DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = tc.request_id and ar.check_id = tc.check_id and ar.level_id = tc.level_id ";
                $searchCond .= "  and ar.team_mem_id=" . $user_id;
            }
            
            if ($searchCond) {
                $from .= " and $searchCond";
            }

            if ($pg >= 0 && $type <> 'count') { 
                $from .= " group by tc.tat_id order by tc.case_no, tc.check_id, tc.level_id, tc.to_date $sOrder "; // Aug
            }
            $sql = "SELECT " . $select . "" . $from;
            $query = $this->db->query($sql);
            
            return $query->result_array();
            
        }

        function get_count_of_chk($request_id, $check_id, $level_id)
        {
            $this->db->select('count_of_chk');
            $this->db->where('candidate_req_id', $request_id);
            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            return  $this->db->get(DB_PREFIX.'ver_assign_rep')->row_array();
        }
        
        function get_ticket_details($request_id, $check_id, $level_id,$rep_published_date)
        {
            $this->db->select('*');
            $this->db->where('request_id', $request_id);
            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            $this->db->where('close_date <=', $rep_published_date);
            $ticket_status = array(2,4,101);
            $this->db->where_in('ticket_status', $ticket_status);
            $this->db->order_by('id', 'ASC');
            
            return  $this->db->get(DB_PREFIX.'ticket_details')->result_array();
        }


        function get_final_report_published_dates($request_id)
        {
            $this->db->select('*');
            $this->db->where('request_id', $request_id);

            $this->db->order_by('published_date', 'ASC');
            
            $this->db->get(DB_PREFIX . 'finalreportpublished')->row_array();
            

        }

        function get_first_report_published_date_from_status_updates($request_id, $check_id, $level_id)
        {
            $this->db->select('*');
            $this->db->where('request_id', $request_id);
            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            $this->db->where('check_status', 1007); //  published by qc2
            $this->db->order_by('date_of_update', 'ASC');

            return  $this->db->get(DB_PREFIX.'status_updates')->row_array();

        }


        function get_status_updates_reopen($request_id, $check_id, $level_id)
        {
            $this->db->select('*');
            $this->db->where('request_id', $request_id);
            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            $this->db->where('role_id', 1);
            $this->db->where('check_status', 1011); // reopen by admin
            $this->db->order_by('date_of_update', 'ASC');

            return  $this->db->get(DB_PREFIX.'status_updates')->result_array();

        }

        // MN Aug 5th
        function update_TAT($tat_id,$update_records)
        {
            $this->db->where('tat_id', $tat_id);
            
            $this->db->update(DB_PREFIX.'tat_checks',$update_records);
        }

        function get_customer_sla($org_id, $check_id)
        {

            $this->db->select('check_tat');
            $this->db->where('org_id', $org_id);
            $this->db->where('check_id', $check_id);
            
            return  $this->db->get(DB_PREFIX.'customer_tat')->row_array();
        }


        function  get_verified_level_data($request_id, $check_id, $level_id)
        {
            $select = " a.case_no, a.case_accepted_date  as startdate, vl.qc2_date as intpublishdate, ar.count_of_chk as chknum, a.final_report,a.supplement_report, vl.f_report, vl.supplementary ";
                    $from = " FROM " . DB_PREFIX . "client_request a 
                            
                            LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by
                            LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id=a.request_id
                            LEFT JOIN " . DB_PREFIX . "submit_cv sv ON sv.request_id=a.request_id  
                      
                            LEFT JOIN " . DB_PREFIX . "verified_level vl ON vl.request_id=a.request_id 
                            and vl.check_id = ar.check_id and vl.level_id = ar.level_id
                            LEFT JOIN ". DB_PREFIX . "master_masterdata md ON md.id =ar.check_id
                            JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3
                            where 1 ";
                
                
                    $from .= " and vl.request_id=" . $request_id .  " and vl.level_id=" . $level_id . " and vl.check_id=" . $check_id;
                

                $sql = "SELECT " . $select . "" . $from;
                $query = $this->db->query($sql);
                return $query->row_array();
        }

        function save_individual_TAT($request_id, $check_id, $level_id)
        {
            $exists_TAT = $this->check_if_TAT_record_exists($request_id, $check_id, $level_id);
    
            $record = $this->get_verified_level_data($request_id, $check_id, $level_id);
            
            $published_date = array();

            $report_type = "";
            $to_date_src_tbl = '';
            $TAT_days = 0;
            $rep_published_date = '';
            $final_rep  = 0;
            if(!empty($record))
            {
                $startdate=(date('d-m-Y',strtotime($record['startdate']))) ? date('d-m-Y',strtotime($record['startdate'])) : '';
                $rep_published_date = date('Y-m-d H:i:s'); ;
                $published_date['published_date'] = $rep_published_date;
                
                $intpublishdate=(date('d-m-Y',strtotime($rep_published_date))) ? date('d-m-Y',strtotime($rep_published_date)) : '';
                
                $TAT_days = $this->compute_working_days($startdate, $intpublishdate, 0);
                $to_date_src_tbl = 'vl.qc2_date';

                if(isset($rep_published_date))
                {
                    $ticket_details = $this->get_ticket_details($request_id, $check_id,$level_id, $rep_published_date);
            
                    $wait_days = 0;
                    $total_wait_days = 0;
                    $prev_requested_date = '0000-00-00 00:00:00';
                    
                    if(!empty($ticket_details))
                    {
                        foreach($ticket_details as $t_d)
                        {
                            if($t_d['ticket_status'] != 101)
                                {
                                    $prev_requested_date = $t_d['requested_date'];
                                }
                            if($t_d['ticket_status'] == 101 && $prev_requested_date != '0000-00-00 00:00:00')
                            {
                                $wait_days = $this->compute_working_days($prev_requested_date, $t_d['close_date'], 0);
                                $total_wait_days += $wait_days;
    
                                $prev_requested_date = '0000-00-00 00:00:00';
                            }
                            $ticket_id = $t_d['ticket_no'];
                        }
                    }
                }

                if($record['f_report'] == 1)
                {
                    $report_type = "final";
                }
                else
                {
                    $report_type = "interim";
                }

                $org = $this->get_org_id($request_id); //MN Aug 5th
                $org_id = ($org['organisation']) ? $org['organisation'] : 0; //MN Aug 5th
                $tat_sla_arr = $this->tm->get_customer_sla($org_id, $check_id);
                if(empty($tat_sla_arr))
                    $tat_sla_arr = $this->tm->get_customer_sla(0, $check_id);
                $tat_sla = $tat_sla_arr['check_tat'];

                $tat = $TAT_days-$total_wait_days;;
                if($tat <= 0)
                    $tat = 1;

                $sla_status = $tat-$tat_sla;

                if(!isset($rep_published_date))
                {
                    $TAT_days = 0;
                }
                else
                {
                    if($TAT_days == 0)
                        $TAT_days = 1;

                }
                if(empty($exists_TAT))
                {
                    $arr_insert_tat['request_id'] = $request_id;
                    $arr_insert_tat['case_no'] = $record['case_no'];
                    $arr_insert_tat['check_id'] = $check_id;
                    $arr_insert_tat['level_id'] = $level_id;
                    $arr_insert_tat['tat_overall'] = $TAT_days;
                    $arr_insert_tat['from_date'] = $record['startdate'];
                    $arr_insert_tat['to_date'] = date('Y-m-d H:i:s'); ;
                    $arr_insert_tat['to_date_source'] = $to_date_src_tbl;
                    $arr_insert_tat['report_type'] = $report_type;
                    $arr_insert_tat['wait_ticket'] = $total_wait_days;
                    $arr_insert_tat['sla_status'] = $sla_status ;
                    $arr_insert_tat['wait_ticket_ids'] = $ticket_id ;
                    $arr_insert_tat['created_date'] = date('Y-m-d H:i:s'); // arr_insert_tat
                    $arr_insert_tat['updated_date'] = date('Y-m-d H:i:s');
                    
                    $arr_insert_tat = $this->security->xss_clean($arr_insert_tat);
                    $id = $this->db->insert( DB_PREFIX .'tat_checks', $arr_insert_tat );
                }
                else
                {
                    $tat_id = $exists_TAT['tat_id']; // MN Aug
                    $arr_update_tat['error_txt'] = 'Call from Publish page';
                    $arr_update_tat['error_date'] = date('Y-m-d H:i:s');
                    $this->update_TAT($tat_id,$arr_update_tat); // MN Aug
                }   
            }
            
        }

        function compute_working_days($from_date, $to_date, $considerHolidays=0) {
            $workingDays = [1, 2, 3, 4, 5]; # date format = N (1 = Monday, ...)
            
            // If holidays  are considered
            if($considerHolidays == 1)
            {
                $allHolidays=$this->am->get_masterholidays();
                foreach($allHolidays as $holiday)
                {
                    $holidayDays[] = $holiday['holiday_date'];
                }
                
            }
    
            $from = new DateTime($from_date);
            
            $to = new DateTime($to_date);
            $to->modify('+1 day'); //  include even the last date or to calculate inclusive of to date
            
            $interval = new DateInterval('P1D'); //  period of 1 day
            $periods = new DatePeriod($from, $interval, $to); // all days between  the from and to date with an  interval of 1 day
    
    
            $days = 0;
            foreach ($periods as $period) {
                
                if (!in_array($period->format('N'), $workingDays)) continue;
                if (in_array($period->format('Y-m-d'), $holidayDays)) continue;
                
                $days++;
            }
    
            //  if difference between dates is greater than 1 then  decrement the days by 1 
            if($days > 1)
            {
                $days =  $days - 1;
            }
    
            return $days;
        }


        //MN Aug
        function get_org_id($request_id)
        {
            $this->db->select('organisation');
            $this->db->where('request_id', $request_id);

            return  $this->db->get(DB_PREFIX.'client_request')->row_array();
        }

        function check_if_reopen_TAT_record_exists($request_id, $check_id, $level_id)
        {
            $this->db->select('*');
            $this->db->where('request_id', $request_id);
            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            $this->db->where('reopen_date !=',null);
            $this->db->where('reopen_published_date',null);
            $this->db->order_by('tat_id','desc');

            return  $this->db->get(DB_PREFIX.'tat_checks')->row_array();
        }


        function save_TAT_on_interim_reopen($request_id, $check_id, $level_id)
        {
            $exists_TAT = $this->check_if_TAT_record_exists($request_id, $check_id, $level_id);

            $record = $this->get_verified_level_data($request_id, $check_id, $level_id);

            if(!empty($record))
            {
                $to_date_src_tbl = '';
                $TAT_days = 0;
                $rep_published_date = '';
                $final_rep  = 0;
                $total_wait_days = 0;
                $sla_status = 0;
                $ticket_id = '';
                $reopen_count =  0;
                
                $arr_insert_tat['request_id'] = $request_id;
                $arr_insert_tat['case_no'] = $record['case_no'];
                $arr_insert_tat['check_id'] = $check_id;
                $arr_insert_tat['level_id'] = $level_id;
                $arr_insert_tat['tat_overall'] = $TAT_days;
                $arr_insert_tat['from_date'] = $record['startdate'];
                $arr_insert_tat['to_date'] = $rep_published_date;
                $arr_insert_tat['to_date_source'] = $to_date_src_tbl;
                $arr_insert_tat['reopen_date']=date('Y-m-d H:i:s');
                $arr_insert_tat['report_type'] = "interim-reopen";
                $arr_insert_tat['wait_ticket'] = $total_wait_days;
                $arr_insert_tat['sla_status'] = $sla_status ;
                $arr_insert_tat['wait_ticket_ids'] = $ticket_id ;
                $arr_insert_tat['created_date'] = date('Y-m-d H:i:s'); // arr_insert_tat
                $arr_insert_tat['updated_date'] = date('Y-m-d H:i:s');


                $arr_insert_tat = $this->security->xss_clean($arr_insert_tat);
                $id = $this->db->insert( DB_PREFIX .'tat_checks', $arr_insert_tat );
            }
        
        }

        function save_TAT_on_final_reopen($request_id, $check_id, $level_id)
        {
            $exists_TAT = $this->check_if_TAT_record_exists($request_id, $check_id, $level_id);

            $record = $this->get_verified_level_data($request_id, $check_id, $level_id);

            if(!empty($record))
            {
                $published_date = array();

                $report_type = "";
                $to_date_src_tbl = '';
                $TAT_days = 0;
                $rep_published_date = '';
                $final_rep  = 0;
                $total_wait_days = 0;
                $sla_status = 0;
                $ticket_id = '';
                $reopen_count =  0;
               
                
                $arr_insert_tat['request_id'] = $request_id;
                $arr_insert_tat['case_no'] = $record['case_no'];
                $arr_insert_tat['check_id'] = $check_id;
                $arr_insert_tat['level_id'] = $level_id;
                $arr_insert_tat['tat_overall'] = $TAT_days;
                $arr_insert_tat['from_date'] = $record['startdate'];
                $arr_insert_tat['to_date'] = $rep_published_date;
                $arr_insert_tat['to_date_source'] = $to_date_src_tbl;
                $arr_insert_tat['reopen_date']=date('Y-m-d H:i:s');
                $arr_insert_tat['report_type'] = "final-reopen";
                $arr_insert_tat['wait_ticket'] = $total_wait_days;
                $arr_insert_tat['sla_status'] = $sla_status ;
                $arr_insert_tat['wait_ticket_ids'] = $ticket_id ;
                $arr_insert_tat['created_date'] = date('Y-m-d H:i:s'); // arr_insert_tat
                $arr_insert_tat['updated_date'] = date('Y-m-d H:i:s');


                $arr_insert_tat = $this->security->xss_clean($arr_insert_tat);
                $id = $this->db->insert( DB_PREFIX .'tat_checks', $arr_insert_tat );
            }
        
        }

        function save_individual_TAT_after_reopen($request_id, $check_id, $level_id)
        {
            $reopen_TAT_exists = $this->check_if_reopen_TAT_record_exists($request_id, $check_id, $level_id);
    
            $record = $this->get_verified_level_data($request_id, $check_id, $level_id);
            
            $published_date = array();

            $report_type = "";
            $to_date_src_tbl = '';
            $TAT_days = 0;
            $rep_published_date = '';
            $final_rep  = 0;
            if(!empty($record))
            {
                if(!empty($reopen_TAT_exists))
                {
                    $tat_id= $reopen_TAT_exists['tat_id'];
                $startdate=(date('d-m-Y',strtotime($record['startdate']))) ? date('d-m-Y',strtotime($record['startdate'])) : '';
                $reopen_date = (date('d-m-Y',strtotime($reopen_TAT_exists['reopen_date']))) ? date('d-m-Y',strtotime($reopen_TAT_exists['reopen_date'])) : '';
                
                $rep_published_date = date('Y-m-d H:i:s'); ;
                $published_date['published_date'] = $rep_published_date;
                
                $intpublishdate=(date('d-m-Y',strtotime($rep_published_date))) ? date('d-m-Y',strtotime($rep_published_date)) : '';
                $TAT_days = $this->compute_working_days($reopen_date, $intpublishdate, 0);
                $to_date_src_tbl = 'vl.qc2_date'; 

                if(isset($rep_published_date))
                {
                    
                    $ticket_details = $this->get_ticket_details_for_reopen($request_id, $check_id,$level_id, $reopen_TAT_exists['reopen_date'], $rep_published_date);
            
                    $wait_days = 0;
                    $total_wait_days = 0;
                    $prev_requested_date = '0000-00-00 00:00:00';
                    
                    if(!empty($ticket_details))
                    {
                        foreach($ticket_details as $t_d)
                        {
                            if($t_d['ticket_status'] != 101)
                                {
                                    $prev_requested_date = $t_d['requested_date'];
                                }
                            if($t_d['ticket_status'] == 101 && $prev_requested_date != '0000-00-00 00:00:00')
                            {
                                $wait_days = $this->compute_working_days($prev_requested_date, $t_d['close_date'], 0);
                                $total_wait_days += $wait_days;
    
                                $prev_requested_date = '0000-00-00 00:00:00';
                            }
                            $ticket_id = $t_d['ticket_no'];
                        }
                    }
                }

                $org = $this->get_org_id($request_id); //MN Aug
                $org_id = ($org['organisation']) ? $org['organisation'] : 0;
                
                $tat_sla_arr = $this->tm->get_customer_sla($org_id, $check_id);
                if(empty($tat_sla_arr))
                    $tat_sla_arr = $this->tm->get_customer_sla(0, $check_id);
                $tat_sla = $tat_sla_arr['check_tat'];

                $tat = $TAT_days-$total_wait_days;;
                if($tat <= 0)
                    $tat = 1;

                $sla_status = $tat-$tat_sla;

                if(!isset($rep_published_date))
                {
                    $TAT_days = 0;
                }
                else
                {
                    if($TAT_days == 0)
                        $TAT_days = 1;

                }
                    $arr_update_tat['to_date'] = date('Y-m-d H:i:s'); ;
                    $arr_update_tat['to_date_source'] = $to_date_src_tbl; 
                    $arr_update_tat['tat_overall'] = $TAT_days;
                    $arr_update_tat['reopen_date']=$reopen_TAT_exists['reopen_date'];
                    $arr_update_tat['reopen_published_date']=date('Y-m-d H:i:s');
                    $arr_update_tat['wait_ticket'] = $total_wait_days;
                    $arr_update_tat['sla_status'] = $sla_status ;
                    $arr_update_tat['wait_ticket_ids'] = $ticket_id ;
                    $arr_update_tat['updated_date'] = date('Y-m-d H:i:s');
                    
                    $arr_update_tat = $this->security->xss_clean($arr_update_tat);
                    $this->update_TAT($tat_id,$arr_update_tat);
                
        
                }
            }   
        }

        function get_ticket_details_for_reopen($request_id, $check_id, $level_id, $reopen_date, $rep_published_date)
        {
            $this->db->select('*');
            $this->db->where('request_id', $request_id);
            $this->db->where('check_id', $check_id);
            $this->db->where('level_id', $level_id);
            $this->db->where('requested_date >=', $reopen_date);
            $this->db->where('close_date <=', $rep_published_date);
            $ticket_status = array(2,4,101);
            $this->db->where_in('ticket_status', $ticket_status);
            $this->db->order_by('id', 'ASC');
            
            return  $this->db->get(DB_PREFIX.'ticket_details')->result_array();
        }


        
    }