<?php 
class Verification_model extends CI_Model {
    //Constuctor
    function __construct() 
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('Adm_model', 'amodel');
    }
     function get_userlistoffsuper ($pg = 0, $limit = 15, $sBy = 'va.updated_on', $sOrder = 'desc', $searchCond = '',$type='') { 
           
                $select = "a.request_id,a.candidate_name,c.org_name,b.office_name,d.office_name as parent_office,e.order_name, a.assainee_status,a.deadline_from,a.deadline_to,a.created_on, f.first_name, c.dedicated_operator as oprid,vs.verification_status,o.office_name as sub_office,vr.check_id,vr.level_id,vr.pack_id,a.case_no";
                        
                     $from = "  FROM " . DB_PREFIX . "client_request a 
                     LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office      
                     LEFT JOIN " . DB_PREFIX . "office b ON b.id=a.office
                     LEFT JOIN " . DB_PREFIX . "organisation c ON c.id=a.organisation
                    JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                    LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                    LEFT JOIN " . DB_PREFIX . "verification_request va on va.request_id = a.request_id
                    JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=a.request_id AND cv.verification_status=1
                    LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id=a.request_id 
                    LEFT JOIN " . DB_PREFIX . "ver_assign_rep vr ON vr.candidate_req_id=a.request_id
                    LEFT JOIN " . DB_PREFIX . "user f ON f.id=vr.team_mem_id
                    JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3
                                 where a.entry_status = 1 and a.assainee_status in (1,2)  AND cv.verification_status=1 
                                 AND
            ( ((select SUM(no_checks) as rchk from dcode_request_check rk where rk.request_id = a.request_id) + (select count(req_id) as ecount from dcode_employment where checkid > 94 AND checkid < 630 AND req_id = a.request_id)) != ( select count(COALESCE(ver.rep_id,0,0)) as vchk FROM dcode_ver_assign_rep ver  where ver.candidate_req_id= a.request_id ))  ";
        if ($searchCond) {
            $from .= " and $searchCond";
        }
 $from .= "  ";
                if ($type == 'count') {
                    $select = " count(Distinct(cv.request_id)) as count"; 
                }
                
                if ($pg >= 0 && $type <> 'count') { 
                       $from .= " group by a.request_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);  
        return $query->result_array();
    }

  function get_newuserlistoffsuper ($pg = 0, $limit = 15, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') {
$limit=15;
           $select = "a.request_id,a.candidate_name,c.org_name,b.office_name,d.office_name as parent_office,e.order_name, a.assainee_status,a.deadline_from,a.deadline_to,a.created_on, f.first_name, c.dedicated_operator as oprid,vs.verification_status,o.office_name as sub_office,vr.check_id,vr.level_id,vr.pack_id,a.case_no";
                       
             $from = "  FROM " . DB_PREFIX . "client_request a
             LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office        
             LEFT JOIN " . DB_PREFIX . "office b ON b.id=a.office
             LEFT JOIN " . DB_PREFIX . "organisation c ON c.id=d.parentoffice_id
            JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
            LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
            LEFT JOIN " . DB_PREFIX . "verification_request va on va.request_id = a.request_id
            JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=a.request_id AND cv.verification_status=1
            LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id=a.request_id
            LEFT JOIN " . DB_PREFIX . "ver_assign_rep vr ON vr.candidate_req_id=a.request_id
             LEFT JOIN " . DB_PREFIX . "user f ON f.id=vr.team_mem_id
             JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3
                        where a.entry_status = 1 and a.assainee_status in (1,2)  AND cv.verification_status=1  ";
        if ($searchCond) {
            $from .= " and $searchCond";
        }

                if ($type == 'count') {
                    $select = " count(DISTINCT(a.request_id)) as count";
                }
               
                if ($pg >= 0 && $type <> 'count') {
                       $from .= " group by a.request_id order by $sBy $sOrder limit $pg," . $limit;
                }
       
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    function get_assignee_list($id =false) {
    
                if($id)
                $cond='and b.key='.$id;
                else
                $cond='';
                
                $sql = "select a.id as assignee_id,concat_ws(' ',a.first_name,a.middle_name,a.last_name) as name 
                from " . DB_PREFIX ."user a 
                left join " . DB_PREFIX ."users_roles u ON u.user_id = a.id
                left join " . DB_PREFIX ."user_skills b ON b.user_id = a.id ";
                
                $sql .="join " . DB_PREFIX ."master_masterdata f on f.id = b.key ";
                $sql .="where a.user_type = 1 and a.status = 1 and u.role_id = '5' ".$cond." group by a.id";
        $query = $this->db->query( $sql );
        return $query->result_array();
    }
    
    function get_educheckname_list($request_id,$check_id) {
                $sql = "select collegename_add,affliated  
                from " . DB_PREFIX ."education_details ";
                $sql .="where request_id =".$request_id;
        $query = $this->db->query( $sql );
        return $query->result_array();
    }
    function get_empcheckname_list($request_id,$check_id) {
    
                $sql = "select company_name  
                from " . DB_PREFIX ."employment ";
                $sql .="where req_id =".$request_id;
               
        $query = $this->db->query( $sql );
        return $query->result_array();
    }
    function get_assignee_list_name($id='') {
        
                if($id<>'')
        $cond="u.role_id = $id ";
        else
        $cond="u.role_id = '10' ";
        
                $sql = "select a.id as assignee_id, concat_ws(' ', a.first_name,a.middle_name,a.last_name) as name
                        from " . DB_PREFIX ."user a 
                        left join " . DB_PREFIX ."users_roles u on u.user_id = a.id
                        where a.user_type = 1 and  ".$cond."group by a.id ";
                $query = $this->db->query( $sql );
                return $query->result_array();
        }

    function geted_assignee_list() {
            $sql = "SELECT c.id as assignee_id, concat_ws(' ', first_name,middle_name,last_name) as name
                    FROM " . DB_PREFIX ."organisation a 
                    join " . DB_PREFIX ."office b on b.parentoffice_id = a.id
                    join " . DB_PREFIX ."user c on c.office_id = b.id
                    join " . DB_PREFIX ."users_roles u on u.user_id = c.id
        join " . DB_PREFIX ."team d on d.user_id = c.id
                    WHERE a.user_type = 1  and u.role_id = '5' and d.team='1'";
            $query = $this->db->query( $sql );
            return $query->result_array();
    }

    function getem_assignee_list() {
                $sql = "SELECT c.id as assignee_id, concat_ws(' ', first_name,middle_name,last_name) as name
                        FROM " . DB_PREFIX ."organisation a 
                        join " . DB_PREFIX ."office b on b.parentoffice_id = a.id
                        join " . DB_PREFIX ."user c on c.office_id = b.id
                        join " . DB_PREFIX ."users_roles u on u.user_id = c.id
            join " . DB_PREFIX ."team d on d.user_id = c.id
                        WHERE a.user_type = 1  and u.role_id = '5' and d.team='2'";
                $query = $this->db->query( $sql );
                return $query->result_array();
    }

    function get_offices()
    {
        $sql = "SELECT DISTINCT a.id as office_id,a.office_name as office_name
                        FROM " . DB_PREFIX ."office a 
                        join " . DB_PREFIX ."order b on b.office = a.id
                        WHERE 1";
                $query = $this->db->query( $sql );
                return $query->result_array();      
    }

    function getad_assignee_list() {
                $sql = "SELECT c.id as assignee_id, concat_ws(' ', first_name,middle_name,last_name) as name
                        FROM " . DB_PREFIX ."organisation a 
                        join " . DB_PREFIX ."office b on b.parentoffice_id = a.id
                        join " . DB_PREFIX ."user c on c.office_id = b.id
                        join " . DB_PREFIX ."user_roles u on u.user_id = c.id
            join " . DB_PREFIX ."team d on d.user_id = c.id
                        WHERE a.user_type = 1  and u.role_id = '5' and d.team='3'";
                $query = $this->db->query( $sql );
                return $query->result_array();
        }
    function candidate_nm($req_id)
    {
        $sql = "SELECT a.candidate_name,a.request_id from " . DB_PREFIX ."client_request a where a.request_id=".$req_id;
        $query = $this->db->query( $sql );
                return $query->result_array();
    }
    function checklist($req_id)
    {

        $sql1 = "SELECT a.rep_id as rep_id from " . DB_PREFIX ."ver_assign_rep a where a.candidate_req_id=".$req_id;
        $query2 = $this->db->query( $sql1 ); 
        if(!$query2->result_array()){
        $sql = "SELECT DISTINCT d.id as check_id,d.name as check_name,c.level from " . DB_PREFIX ."client_request a 
        join " . DB_PREFIX ."order as b on b.id=a.order_id 
        join " . DB_PREFIX ."add_check as c on c.order_id=b.id 
        join " . DB_PREFIX ."master_masterdata as d on d.id=c.types_of_check 
         where a.request_id=".$req_id;
        $query = $this->db->query( $sql );
        }
        else { 
        $sql = "SELECT DISTINCT d.id as check_id,d.name as check_name,c.level from " . DB_PREFIX ."client_request a 
        join " . DB_PREFIX ."order as b on b.id=a.order_id 
        join " . DB_PREFIX ."add_check as c on c.order_id=b.id 
        join " . DB_PREFIX ."master_masterdata as d on d.id=c.types_of_check 
         join " . DB_PREFIX ."ver_assign_rep as e on e.check_id<>d.id where a.request_id=".$req_id;
        $query = $this->db->query( $sql );

        }
                return $query->result_array();
    }
    function getalluser($office,$key)
    {
        if($office){
            $sql = "SELECT a.request_id as req_id from " . DB_PREFIX ."client_request a 
             where a.entry_status=1 and a.office=".$office;
        }
        else if($key){ 
            $sql = "SELECT 1a.request_id as req_id from " . DB_PREFIX ."client_request a 
             where a.entry_status=1 and a.candidate_name='".$key."%'1";
        }
        else{
        $sql = "SELECT a.request_id as req_id from " . DB_PREFIX ."client_request a 
             where a.entry_status=1";
        }
        $query = $this->db->query($sql);
            return $query->result_array();
    }
    
    function check_data($req_id,$check_id){
        
        if($check_id==14){
            $sql="SELECT a.collegename_add as source,a.affliated as address,a.subject as level
                  from " . DB_PREFIX ."education_details as a 
                  where a.request_id=".$req_id;
            $query = $this->db->query( $sql );
        }
        if($check_id==59){
            $sql="SELECT a.company_name as source,a.office_address as address,a.salary as level
                  from " . DB_PREFIX ."employment as a 
                  where a.req_id=".$req_id;
            $query = $this->db->query( $sql );

        }
        if($check_id==16){
            $sql="SELECT a.permanent_address as source,a.current_address as address,a.cperiod_of_stay as level
                  from " . DB_PREFIX ."contact_details as a 
                  where a.request_id=".$req_id;
            $query = $this->db->query( $sql );

        }
        return $query->result_array();
    }
    function check_datasource($req_id,$check_id,$source){
    
        if($source==1)
        { 
        if($check_id==14){
            $sql="SELECT a.collegename_add as source,a.affliated as address,a.subject as level
                  from " . DB_PREFIX ."education_details as a 
                  where a.request_id=".$req_id;
            $query = $this->db->query( $sql );
        return $query->result_array();
        }
        }
        if($source==2)
        { 
        if($check_id==59){
            $sql="SELECT a.company_name as source,a.office_address as address,a.salary as level
                  from " . DB_PREFIX ."employment as a 
                  where a.req_id=".$req_id;
            $query = $this->db->query( $sql );
        return $query->result_array();

        }}
        
    }
        function get_skilled_assignee_list( $request_id ) {

                $sql1 = "(SELECT a.collegename_add as inst FROM " . DB_PREFIX ."education_details a where a.request_id = $request_id )
                         union (SELECT b.affliated as inst FROM " . DB_PREFIX ."education_details b where b.request_id = $request_id )
                        ";
                        
                $sql2 = "SELECT c.id, a.name, a.key, concat_ws( ' ', c.first_name, c.middle_name, c.last_name ) AS dcodeuser
                        FROM " . DB_PREFIX ."master_masterdata a 
                        join " . DB_PREFIX ."user_skills b on b.skills = a.id
                        join " . DB_PREFIX ."user c on c.id = b.user_id
                        where c.role_id = '5' ";
                        
                $new_sql = "    select sq2.id as assignee_id,sq2.dcodeuser as name, count(*) as orderc  
                                from ($sql1) as sq1 join ($sql2) as sq2 on sq1.inst = sq2.name
                                group by sq2.id order by orderc desc";
                $query = $this->db->query( $new_sql );
                return $query->result_array();
        }
        function get_qcassignee_list()  {
                $sql = "SELECT c.id as assignee_id, concat_ws(' ', first_name,middle_name,last_name) as name
                        FROM " . DB_PREFIX ."organisation a 
                        join " . DB_PREFIX ."office b on b.parentoffice_id = a.id
                        join " . DB_PREFIX ."user c on c.organization = a.id
                        join " . DB_PREFIX ."users_roles u on u.user_id = c.id
                        WHERE a.user_type = 1  and u.role_id = '4' group by c.id";
                $query = $this->db->query( $sql );
                return $query->result_array();
        }
        function get_qc2assignee_list()  {
                $sql = "SELECT c.id as assignee_id, concat_ws(' ', first_name,middle_name,last_name) as name , c.email
                        FROM " . DB_PREFIX ."organisation a 
                        join " . DB_PREFIX ."office b on b.parentoffice_id = a.id
                        join " . DB_PREFIX ."user c on c.organization = a.id
                        join " . DB_PREFIX ."users_roles u on u.user_id = c.id
                        WHERE a.user_type = 1  and c.status = 1 and u.role_id = '17' group by c.id";
                $query = $this->db->query( $sql );
                return $query->result_array();
        }
        function get_userlist ($request_id) { 

       
                $select = "a.request_id,a.candidate_name";
                        
                                 $from = "   FROM " . DB_PREFIX . "client_request a 
                                 where 1  and a.request_id=".$request_id;
                   
               
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function getreqid($request_id)
    {
                $select = "a.request_id";
                                 $from = "   FROM " . DB_PREFIX . "verification_request a 
                                 where 1  and a.request_id=".$request_id;
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function getqcreqid($request_id)
    {
                $select = "q.request_id";
                                 $from = "   FROM " . DB_PREFIX . "qc_request q 
                                 where 1  and q.request_id=".$request_id;
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function getqc2reqid($request_id)
    {
                $select = "q.request_id";
                                 $from = "   FROM " . DB_PREFIX . "qc2_request q 
                                 where 1  and q.request_id=".$request_id;
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function getstatus($request_id)
    {
                $this->db->select('a.assignee_status,a.vm_revert_vs')
                ->from(DB_PREFIX . 'verification_request as a')
                ->where('a.request_id', $request_id);
                return $this->db->get()->result_array();
    }
    function getchkstatus($request_id)
    {
        $this->db->select('count(a.rep_id) as vchk')
        ->from(DB_PREFIX . 'ver_assign_rep as a')
        ->where('a.candidate_req_id', $request_id);
        $res1= $this->db->get()->result_array();
        $res2 = $this->db->query("select SUM(no_checks) as rchk,check_id from ".DB_PREFIX ."request_check a 
        Where a.request_id = ".$request_id)->result_array();
        
        $res3 = $this->db->query("select count(req_id) as ecount from ".DB_PREFIX ."employment
        Where checkid > 94 AND checkid < 630 AND req_id = ".$request_id)->row_array();
        
        if($res3['ecount']>0) $count=$res3['ecount']; else $count=0;
        
        
        $result = ($res2[0]['rchk'] + $count) - $res1[0]['vchk'];
        return $result;
    }

    function getchkDetails($request_id,$rid='')
    {
    $cond='';
    if($rid<>'')
    $cond=" and c.id=".$rid." ";
        $select="c.id,c.name,c.id as ref_id,d.id as pid,d.name as pname,d.id as pref_id,a.request_id,a.no_checks,ct.verification_tat";
                      $from = "   FROM " . DB_PREFIX . "request_check a    
                       LEFT JOIN " . DB_PREFIX . "add_check b ON b.types_of_check = a.check_id
                      LEFT JOIN ".DB_PREFIX ."master_masterdata c on c.id = a.check_id
                      LEFT JOIN ".DB_PREFIX ."master_masterdata d on d.id = a.description
                      LEFT JOIN  ".DB_PREFIX ."customer_tat ct ON ct.check_id = a.check_id
                      left join ".DB_PREFIX ."ver_assign_rep r on r.candidate_req_id = a.request_id
                    Where a.request_id = ".$request_id." ".$cond." and (a.check_id not in (select check_id from ".DB_PREFIX ."ver_assign_rep where candidate_req_id = ".$request_id." )  ) group by c.id,d.id order by c.id";
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();

    //     $str = $this->db->last_query();
    // echo "<pre>";
    // print_r($str);
    // exit;
    
    }
    function get_userlistverification ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') {           
        $select = " a.candidate_req_id,a.vm_revert_to,a.ass_request, a.qc_revert_request, a.vm_assigned_qc, d.candidate_name as candidatename, c.name as skillname,a.level_id,
        p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,
        s.vm_revert_option_status,s.operator_submited_by,d.order_id as ordercode,
        d.vm_revert_supervisor, f.order_name,c.name as checkname,c.id as checkId,vs.name as status,verify_status,a.check_id as checkid,a.vm_revert_status as rstatus, ass_request, vm_revert_request as vrequest, a.pack_id, d.case_no, o.org_name, a.count_of_chk as chk, concat_ws(' ',us.first_name,us.middle_name,us.last_name) as vname, vr.deadline_from, vr.deadline_to,vl1.reqstatus,vl1.supplementary,a.additional_docs,a.reopen_revert_qc,a.reopen_revert_qc2,vl1.v_date,td.ticket_status, td.requested_date,
        vl1.vm_request_raised_date,ct.verification_tat,(5 * (DATEDIFF(CURDATE(), date(vr.deadline_from)) DIV 7) + MID('0123444401233334012222340111123400012345001234550', 7 * WEEKDAY(date(vr.deadline_from)) + WEEKDAY(CURDATE()) + 1, 1)) - (SELECT COUNT(*) FROM dcode_master_holidays WHERE status=1 and  holiday_date >= date(vr.deadline_from) and holiday_date <= CURDATE()) as Days";
        $from = "  from ".DB_PREFIX ."ver_assign_rep a
        LEFT JOIN ".DB_PREFIX ."personal_details b ON b.user_id = a.candidate_req_id
        LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."customer_tat ct ON ct.check_id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = b.user_id
        LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
        LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
        LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
        LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
        LEFT JOIN   ".DB_PREFIX ."order f ON f.id = d.order_id
        LEFT JOIN ".DB_PREFIX ."submit_cv s ON s.request_id = a.candidate_req_id
        LEFT JOIN ".DB_PREFIX ."employment em ON em.id = a.level_id and a.check_id=em.checkid
        LEFT JOIN ".DB_PREFIX ."education_details ed ON ed.id = a.level_id and a.check_id=ed.checkid
        LEFT JOIN ".DB_PREFIX ."professional_reference pr ON pr.id = a.level_id and a.check_id=pr.checkid
        LEFT JOIN ".DB_PREFIX ."master_masterdata vs ON vs.id = a.verify_status 
        LEFT JOIN ".DB_PREFIX ."ticket_details td ON td.request_id = a.candidate_req_id and td.check_id=a.check_id and td.level_id=a.level_id and td.current_status=1 
        LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id
        JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3
        LEFT JOIN ".DB_PREFIX ."verification_request vr ON vr.request_id = a.candidate_req_id and vr.check_id=a.check_id and vr.level_id=a.level_id and vr.pack_id=a.pack_id 
        LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.candidate_req_id and vl1.check_id=a.check_id and vl1.level_id=a.level_id";       
     //echo $this->session->userdata['userid'];exit;                
        if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==24 || $this->session->userdata['role_id']==9) {
             $from .= " WHERE 1=1 ";
        }  
        else if($this->session->userdata['role_id']==21) {
            $from .= " WHERE o.crm_userid = ".$this->session->userdata['userid']." and vr.deadline_from<>'' ";
        }  
        else{
        $from .= " WHERE  a.team_mem_id = ".$this->session->userdata['userid']." and (a.verify_status =107 or a.vm_assigned_qc=0 or a.verify_status =684 or a.verify_status =992 ) and vr.deadline_from<>'' " ;
        }

        if ($searchCond) {
        $from .= " and $searchCond";
        }                   
        if ($type == 'count') $select = "count(DISTINCT(a.rep_id)) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " group by a.rep_id order by $sBy $sOrder limit $pg," . $limit;
        }

        $sql = "SELECT " . $select . "" . $from;
       
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function get_assignedlist ($pg = 0, $limit = 15, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 

        $select = " a.candidate_req_id,a.vm_revert_to,
                    a.ass_request,a.qc_revert_request,a.vm_assigned_qc,
                    d.candidate_name as candidatename,
                    c.name as skillname,
                    a.level_id,
                    p.office_name as parent_office,
                    br.office_name as office_name,
                    su.office_name as sub_office,
                    s.vm_revert_option_status,
                    s.operator_submited_by,
                    d.order_id as ordercode,
                    d.vm_revert_supervisor,
                    f.order_name,
                c.name as checkname,c.id as checkId,vs.name as status,verify_status,a.check_id as checkid,a.vm_revert_status as rstatus,ass_request,vm_revert_request as vrequest,a.pack_id,d.case_no,o.org_name,a.count_of_chk as chk, concat(v.first_name,' ',v.last_name) as vname,a.count_of_chk as chk,vr.deadline_from,vr.deadline_to";

          $from = "  from
                      ".DB_PREFIX ."ver_assign_rep a
                      LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
                          LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = a.candidate_req_id
                          LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
                      LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
                      LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
                       LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
                     LEFT JOIN   ".DB_PREFIX ."order f ON f.id = d.order_id
                       LEFT JOIN ".DB_PREFIX ."submit_cv s ON s.request_id = a.candidate_req_id
                       LEFT JOIN ".DB_PREFIX ."user v ON v.id = a.team_mem_id
                      LEFT JOIN ".DB_PREFIX ."master_masterdata vs ON vs.id = a.verify_status
                    LEFT JOIN ".DB_PREFIX ."verification_request vr ON vr.request_id = a.candidate_req_id and vr.check_id=a.check_id and vr.level_id=a.level_id and vr.pack_id=a.pack_id"; 
                     
          $from .= " WHERE 1=1";
        if ($searchCond) {
            $from .= " and $searchCond";
        }

                if ($type == 'count') 
                    $select = "count(*) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                        $from .= " order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function get_reverthistory ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') {    
        $select = " a.candidate_req_id,a.vm_assigned_qc,concat(b.firstname, ' ', b.lastname) as candidatename,c.name as skillname,a.level_id,p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,c.name as checkname,c.id as checkId,vs.name as status,verify_status,a.check_id as checkid,a.vm_revert_status as rstatus,ass_request,vm_revert_request as vrequest,pack_id,d.case_no,o.org_name,rh.comments,concat(du.first_name, ' ', du.last_name) as revert_to,concat(du1.first_name, ' ', du1.last_name) as revert_from,rh.reverted_date,a.count_of_chk,rh.revertreason ";

          $from = "  from
                      ".DB_PREFIX ."ver_assign_rep a
                      LEFT JOIN ".DB_PREFIX ."personal_details b ON b.user_id = a.candidate_req_id
                      LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
                          LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = b.user_id
                          LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
                      LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
                      LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
                       LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
                     LEFT JOIN   ".DB_PREFIX ."order f ON f.id = d.order_id
                       LEFT JOIN ".DB_PREFIX ."submit_cv s ON s.request_id = a.candidate_req_id
                    JOIN ".DB_PREFIX ."revert_history rh ON rh.request_id = a.candidate_req_id and rh.check_id=a.check_id and rh.level_id=a.level_id
                      LEFT JOIN ".DB_PREFIX ."master_masterdata vs ON vs.id = a.verify_status
                      LEFT JOIN ".DB_PREFIX ."user du ON du.id = rh.reverted_to
                      LEFT JOIN ".DB_PREFIX ."user du1 ON du1.id = rh.reverted_by
                     ";
                     
          $from .= " WHERE 1=1";
        if ($searchCond) {
            $from .= " and $searchCond";
        }

                if ($type == 'count') $select = "count(*) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                        $from .= " order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function getassignee_name($request_id){
        $sql = "SELECT a.first_name
                        FROM " . DB_PREFIX ."user a 
            LEFT JOIN " . DB_PREFIX ."ver_assign_rep b on b.team_mem_id=a.id
            WHERE b.candidate_req_id=".$request_id;
                $query = $this->db->query($sql);
                return $query->result_array();
    }

    function get_currentstatus($req_id){
        $this->db->select('a.role_id');
        $this->db->where('b.request_id',$req_id);
        $this->db->join(DB_PREFIX.'submit_cv b','operator_submited_by=a.user_id','left');
        return $this->db->get(DB_PREFIX.'users_roles a')->row_array();
        
    }

    function getverificationdata($mem_id,$team)
    {


        $sql = "SELECT  DISTINCT a.candidate_req_id
                        FROM " . DB_PREFIX ."ver_assign_rep a 
                        WHERE a.team_mem_id=". $mem_id;

                $query = $this->db->query( $sql );
                return $query->result_array();
    }

    function getverificationaldata($request_id)
    {
        $sql = "SELECT a.candidate_req_id,a.team,b.first_name,c.name,a.level_id,d.name as level_name
                        FROM " . DB_PREFIX ."ver_assign_rep a 
            LEFT JOIN " . DB_PREFIX ."user b on b.id=a.team_mem_id
            LEFT JOIN " . DB_PREFIX ."master_masterdata c on c.id=a.check_id
            LEFT JOIN " . DB_PREFIX ."master_masterdata d on d.id=a.level_id
                        WHERE a.candidate_req_id=".$request_id." and a.educational_status=1";
                $query = $this->db->query( $sql );
                return $query->result_array();
    }
    function getqcverificationaldata($request_id)
    {
        $sql = "SELECT a.candidate_req_id,a.team,b.first_name,c.name,a.level_id,a.check_id,a.level_id
                        FROM " . DB_PREFIX ."ver_assign_rep a 
            LEFT JOIN " . DB_PREFIX ."user b on b.id=a.team_mem_id
            LEFT JOIN " . DB_PREFIX ."master_masterdata c on c.id=a.check_id
                        WHERE a.candidate_req_id=".$request_id." and a.educational_status=1 and a.qc1_verification=1";
                $query = $this->db->query( $sql );
                return $query->result_array();
    }
    function getverdatarep($request_id,$key,$level_id)
    {
        if($key=="Education"){
        $sql = "SELECT a.degree as level_id,b.name as degree,a.collegename_add,a.affliated,a.period_from,a.period_to,a.roll,a.graduate,a.program,a.subject,a.reason1
                        FROM " . DB_PREFIX ."education_details a 
                        join " . DB_PREFIX ."master_masterdata b on b.id = a.degree
                        WHERE a.request_id =". $request_id." and a.degree=".$level_id;
                
    }
    else if($key=="Employment")
    {
        $sql = "SELECT a.id,a.level_id,b.name,a.company_name,a.office_address,a.branch_address,a.telephone_no,a.manager_name,a.designation,
            a.email_id,a.contact_no,a.salary,a.reason,a.reference
                        FROM " . DB_PREFIX ."employment a 
                        join " . DB_PREFIX ."master_masterdata b on b.id = a.level_id
                        WHERE a.req_id =". $request_id." and a.level_id=".$level_id;
    }
    else
    {
        $sql = "SELECT a.id, a.level_id,b.name,a.permanent_address,a.period_of_stay, a.current_address, a.current_address, a.cperiod_of_stay, a.current_tel_no,a.permanent_tel_no,a.office_tel_no,a.mobile,a.email_id,a.alter_email_id
                        FROM " . DB_PREFIX ."contact_details a 
                        join " . DB_PREFIX ."master_masterdata b on b.id = a.level_id
                        WHERE a.request_id =". $request_id." and a.level_id=".$level_id;
    }
    $query = $this->db->query( $sql );
                return $query->result_array();

    }
    function getverdatarepfield($request_id,$key,$level_id)
    {
        if($key=="Education"){
        $key='education_key';
        }
        else if($key=="Employment")
        {
            $key='employment_key';
        }
        else
        {
            $key='contact_key';
        }
        $sql = "SELECT DISTINCT b.field_name,a.request_id,a.comment,b.key,b.id
                        FROM " . DB_PREFIX ."verification_reports a 
                        LEFT JOIN " . DB_PREFIX . "master_field_table b ON b.id=a.label_name
                        WHERE a.request_id=". $request_id ." and b.key = '".$key."'";
                $query = $this->db->query( $sql );
                return $query->result_array();
    }

    function getqcverdatarepfield($request_id,$key,$level_id)
    {
        if($key=="Education"){
        $key='education_key';
        }
        else if($key=="Employment")
        {
            $key='employment_key';
        }
        else
        {
            $key='contact_key';
        }
        $sql = "SELECT DISTINCT b.field_name,a.request_id,a.comment,c.comment as qccom,b.key,b.id
                        FROM " . DB_PREFIX ."verification_reports a 
                LEFT JOIN " . DB_PREFIX . "verification_qc1reports c ON c.label_name=a.label_name
                        LEFT JOIN " . DB_PREFIX . "master_field_table b ON b.id=a.label_name
                        WHERE a.request_id=". $request_id ." and b.key = '".$key."'";
                $query = $this->db->query( $sql );
                return $query->result_array();
    }
    function getassigneedata($mem_id)
    {
    $sql = "SELECT  concat_ws(' ', b.first_name,b.middle_name,b.last_name) as name,b.designation,b.email,b.original
                        from " . DB_PREFIX . "user b 
                        WHERE b.id=".$mem_id;
                $query = $this->db->query( $sql );
                return $query->result_array();
    }

    
    function ckeckdt($request_id,$team){
    $sql = "SELECT  DISTINCT f.id as level_id,b.request_id,b.candidate_name,g.office_name,c.order_name,c.order_code,e.name as check_name,f.name as level,d.types_of_check as check_id
                        from " . DB_PREFIX . "ver_assign_rep a
            LEFT JOIN " . DB_PREFIX . "client_request b on b.request_id=a.candidate_req_id
            LEFT JOIN " . DB_PREFIX . "office g on g.id=b.office
            LEFT JOIN " . DB_PREFIX . "order c on c.id = b.order_id
            LEFT JOIN " . DB_PREFIX . "add_check d on d.order_id = c.id
            LEFT JOIN " . DB_PREFIX . "master_masterdata e on e.id = d.types_of_check
            LEFT JOIN " . DB_PREFIX . "master_masterdata f on f.id = d.level
            LEFT JOIN " . DB_PREFIX . "verification_status h on h.request_id = b.request_id
                        WHERE a.candidate_req_id=".$request_id." and d.types_of_check=a.check_id and a.team=".$team;
                $query = $this->db->query( $sql );
                return $query->result_array();
    }
    
    function getstatus_of_can($request_id,$team)
    {
        
        $sql = "SELECT a.educational_status as status
                        FROM " . DB_PREFIX ."ver_assign_rep a 
            WHERE a.candidate_req_id=". $request_id." and a.team=".$team;
        $query = $this->db->query($sql);
                return $query->result_array();  
    }
    
    function get_ver1status($request_id)
   {
        $this->db->select('a.qc1_verification,a.qc1_dis,a.educational_status as status')
                ->from(DB_PREFIX . 'ver_assign_rep as a')
                ->where('a.candidate_req_id', $request_id);
                return $this->db->get()->result_array();
   }
    function get_ver2status($request_id)
   {
        $this->db->select('a.qc1_verification,a.qc1_dis,a.qc2_verification,a.qc2_dis,a.educational_status as status')
                ->from(DB_PREFIX . 'ver_assign_rep as a')
                ->where('a.candidate_req_id', $request_id);
                return $this->db->get()->result_array();
   }
   function get_verstatus($request_id)
   {
        $this->db->select('a.educational_status')
                ->from(DB_PREFIX . 'ver_assign_rep as a')
                ->where('a.candidate_req_id', $request_id);
                return $this->db->get()->result_array();
   }
   
    function getchecklist($request_id)
    {
         $sql = "SELECT a.request_id,b.order_name,d.name as checkname,e.name as levelname
                        FROM " . DB_PREFIX ."client_request a 
                        LEFT JOIN " . DB_PREFIX . "order b ON b.id=a.order_id
                        LEFT JOIN " . DB_PREFIX . "add_check c ON c.order_id=b.id
                        LEFT JOIN " . DB_PREFIX . "master_masterdata d ON d.id=c.types_of_check
                        LEFT JOIN " . DB_PREFIX . "master_masterdata e ON e.id=c.level
                        WHERE a.request_id=". $request_id;
                $query = $this->db->query( $sql );
                return $query->result_array();
    }

    function getverifass_checks($request_id)
    {
        $sql = "SELECT a.rep_id,a.candidate_req_id,a.check_id
                        FROM " . DB_PREFIX ."ver_assign_rep a 
            WHERE a.candidate_req_id=". $request_id;
        $query = $this->db->query($sql);
                return $query->result_array();      
            
    }
    
    function update_remstatus($request_id,$level_id)
    {
        
        $sql = "UPDATE " . DB_PREFIX ."ver_assign_rep SET educational_status=2 WHERE candidate_req_id=".$request_id." and level_id=".$level_id; 
        $query = $this->db->query($sql);
    }
    function update_status($request_id,$check_id,$level_id,$pack_id,$POST)
    {
        $sql = "UPDATE " . DB_PREFIX ."ver_assign_rep SET educational_status=1,vm_assigned_qc=1,comments='".mysqli_real_escape_string($POST['sum_text'])."', verify_status=".$POST['status']." WHERE candidate_req_id=".$request_id." and check_id=".$check_id." and pack_id=".$pack_id." and level_id=".$level_id;  
        $query = $this->db->query($sql);
    }
    
    function update_professional_ref($request_id,$check_id,$level_id,$pack_id,$post)
    {
        $formdata = $post;
         $save['nature_work']= $formdata['nature_work'];
         $save['meeting_obj']= $formdata['meeting_obj'];
         $save['work_pressure']= $formdata['work_pressure'];
         $save['people_skill']= $formdata['people_skill'];
         $save['social_skill']= $formdata['social_skill'];
         $save['comm_skill']= $formdata['comm_skill'];
         $save['prof_strength']= $formdata['prof_strength'];
         $save['prof_weak']= $formdata['prof_weak'];
         $save['person_prob']= $formdata['person_prob'];
         $save['attend_punct']= $formdata['attend_punct'];
         $save['job_perform']= $formdata['job_perform'];
         $save['honesty']= $formdata['honesty'];
         $save['reliability']= $formdata['reliability'];
         $save['commitment']= $formdata['commitment'];
         $save['reason_leaving']= $formdata['reason_leaving'];
         $save['notice_bfr_leave']= $formdata['notice_bfr_leave'];
         $save['rehire']= $formdata['rehire'];
         $save['perform_rating']= $formdata['perform_rating'];
    $this->db->where('request_id',$request_id);
                $this->db->where('checkid',$check_id);
                $this->db->where('id',$level_id);
                
                $this->db->update(DB_PREFIX.'professional_reference',$save);
    }
    function personaldetails_report($request_id)    { 
        $req_id = $request_id;
        foreach($_POST as $key=>$val)   {       
                if($key <> "Submit_x" && $key <> "Submit_y") { 
                $formData['request_id'] = $request_id;
                $lable = explode('field_',$key); 
                $formData['label_name'] = $lable[1];
                $formData['comment'] = ($val[1]) ? $val[1] : "Verified-found Correct";
                
                if ($formData) { 
                         $insertData = elements(array('request_id','label_name','comment'),$formData);
                        $this->amodel->dmlfunction(DB_PREFIX . "verification_reports", array('id' => $id), $insertData, $id);
                        }
                }
        }
        $req_id = base64_encode($req_id);
      }

    function education_details_update($request_id)    {
        $req_id = $request_id;
        foreach($_POST as $key=>$val)   {  
                $formData['request_id'] = $request_id;
                $lable = explode('field_',$key); 
                $formData['label_name'] = $lable[1]; 
                $formData['comment'] = ($val[1]) ? $val[1] : "Verified-found Correct";
                
                if ($formData) {
                      
                       $insertData = elements(array('request_id','label_name','comment'),$formData);
                        $this->amodel->dmlfunction(DB_PREFIX . "verification_reports", array('id' => $id), $insertData, $id);
                        }
            
        }
        $req_id = base64_encode($req_id);
    }

    function get_userlistreports($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {
    
    
                $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,cr.candidate_name,cr.qc1_assignstatus, vs.qc2_status,vs.qc2_discrapancy,concat_ws(' - ',md2.name,md.name) as status,vl1.level_id,vl1.check_id,ar.pack_id,md1.name as checkname,concat_ws(' ',ass.first_name,ass.last_name) as assigne,a.deadline_from,a.deadline_to,e.org_name,d.office_name as parent_office,o.office_name as sub_office,cr.case_no,ar.count_of_chk as chk,vl1.v_date";
                $from = "   FROM " . DB_PREFIX . "verification_request a 
                LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
                LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
                LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
                LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
                LEFT JOIN " . DB_PREFIX . "organisation e ON e.id=d.parentoffice_id
                LEFT JOIN " . DB_PREFIX . "office o ON o.id=cr.sub_office
                LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
                LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id and ar.check_id=a.check_id and ar.level_id=a.level_id
                LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=ar.candidate_req_id
                LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id=vl1.qc2status
                LEFT JOIN " . DB_PREFIX . "master_masterdata md1 ON md1.id=vl1.check_id
                LEFT JOIN " . DB_PREFIX . "master_masterdata md2 ON md2.id=md.parent
                LEFT JOIN " . DB_PREFIX . "user ass ON ass.id=vl1.qcverified_by 
                JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
                LEFT JOIN ".DB_PREFIX ."employment em ON em.id = ar.level_id and a.check_id=em.checkid
                LEFT JOIN ".DB_PREFIX ."education_details ed ON ed.id = ar.level_id and a.check_id=ed.checkid
                LEFT JOIN ".DB_PREFIX ."professional_reference pr ON pr.id = ar.level_id and a.check_id=pr.checkid
                where 1  and a.assignee_status=1 AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id ";

                if ($searchCond) {
                $from .= " and $searchCond";
                }
                if($this->session->userdata('role_id')==12)
                $from .=" and b.organization=".$this->session->userdata('organization');
                if($this->session->userdata('role_id')==13)
                $from .=" and b.parent_office=".$this->session->userdata('parent_office');
                $from .=" and qc1_verification=1 ";


                if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count "; 

                if ($pg >= 0 && $type <> 'count') { 
                $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
                }
               
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    } 
/* qc1 alloted list*/
    function get_qc1list($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {

        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,concat_ws(' ',us.first_name,us.last_name) as qcname,vl1.v_date,vl1.supplementary,concat_ws(' ',vm.first_name,vm.last_name) as vmname,ar.qc_revert_date,ar.reopen_revert_qc";

                                 $from = "   FROM " . DB_PREFIX . "verification_request a 
                                 LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
                                 LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
                                 LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
                                 LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
                                 LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
                                 LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation

                                 LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
                                 LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
                                 LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id
                                 LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
                                 LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
                                 LEFT JOIN " . DB_PREFIX . "qc_request qc ON qc.request_id=a.request_id
                                 LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
                                LEFT JOIN " . DB_PREFIX . "user vm ON vm.id=vl1.verified_by
                                 JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
                                 where 1  and a.assignee_status=1 and ar.verify_status in (111,110,519) AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id and qc.assignee_id != 0 ";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        /* qc1 verification*/
        if($this->session->userdata('role_id')==4){
            $from .=" and o.dedicated_qc=4 and qc.assignee_id =".$this->session->userdata('userid')." and (vl1.qcstatus IN (0,107) or ( ar.qc1_assign_revert=0 and ar.qc2_revert_request=1 )) ";
        }
        /* qc2 verification*/
        if($this->session->userdata('role_id')==17){
            $from .=" and qc1_verification=1 ";
        }
        if($this->session->userdata('role_id')==1){
            $from .=" and o.dedicated_qc=4 and (vl1.qcstatus IN (0,107) or ( ar.qc1_assign_revert=0 and ar.qc2_revert_request=1 )) ";
        }

                if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
 /* qc1 case checkslist*/
    function get_qc1caseschecklist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {
        
        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk";

         $from = "   FROM " . DB_PREFIX . "verification_request a 
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
         LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation
         LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
         LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "qc_request qc ON qc.request_id=a.request_id
         JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
         where 1  and a.assignee_status=1 and ar.verify_status in (111,107,110,519) AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id ";
                   
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        /* qc1 verification*/
        if($this->session->userdata('role_id')==4){
            $from .=" and o.dedicated_qc=4 and qc.assignee_id =".$this->session->userdata('userid');
        }
        /* qc2 verification*/
        if($this->session->userdata('role_id')==17){
            $from .=" and qc1_verification=1 ";
        }
            

                if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }   
 /* quality check2 alloted list */
     function get_qc2list($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {
        
        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,ar.qc_2_verification,ar.qc2_report_publish,ar.reopen_revert_qc2,vl1.qc2status,vl1.v_date,vl1.qc_date,concat_ws(' ',us.first_name,us.last_name) as qc2name,vl1.supplementary,concat_ws(' ',vm.first_name,vm.last_name) as vmname,ar.qc2_revert_date, ur.role_id as revertedBy "; // March 17th

        // March 17th -- added  line no 959
         $from = "   FROM " . DB_PREFIX . "verification_request a 
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
         LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation
         
         LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
         LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id 
         LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
         LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
         LEFT JOIN " . DB_PREFIX . "user vm ON vm.id=vl1.verified_by
         LEFT JOIN " . DB_PREFIX . "users_roles ur ON ur.user_id=ar.qc2_revert_by 
          JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
         where 1  and a.assignee_status=1 and ar.verify_status in (111,110,519) AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id and qc1_verification=1 ";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        
        /* qc2 verification*/
        if($this->session->userdata('role_id')==17 ){
            $from .="  and ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish != 3 else ar.qc2_report_publish != 1 END ) and qc.assignee_id =".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and qc.assignee_id != 0 and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }
        else{
            $from .= " and qc.assignee_id != 0 ";
        }
        
                
               if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count ";
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    } 
    /* quality casewise check list */
     function get_qc2casechecklist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {
        $limit=15;
        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,ar.qc_2_verification,ar.qc2_report_publish,vl1.qc2status,vl1.v_date,vl1.qc_date,concat_ws(' ',us.first_name,us.last_name) as qc2name,cr.final_report,vl1.supplementary";

             $from = "   FROM " . DB_PREFIX . "verification_request a 
             LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
             LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
             LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
             LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
             LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
             LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation

             LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
             LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
             LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
             LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id 
             LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
             LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id=a.request_id
             LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
              JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
             where 1  and a.assignee_status=1 and ar.verify_status in (111,107,110,519) AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id and qc1_verification=1 ";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        
        /* qc2 verification*/
        if($this->session->userdata('role_id')==17 ){
            $from .=" and qc.assignee_id =".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }
                
               if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count ";
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    } 
    /* qc1 allocation list */
    function get_qc1userlist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')    {

        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,r.candidate_name,p.office_name as parent_office,s.office_name as sub_office,o.org_name,r.case_no";
                                 $from = "   FROM " . DB_PREFIX . "client_request r  
                                 LEFT JOIN  " . DB_PREFIX . "verification_request a ON a.request_id=r.request_id
                                 LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id=a.request_id
                                 LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = r.request_id
                                 LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id = ar.candidate_req_id and vl1.check_id = ar.check_id and vl1.level_id = ar.level_id
                                 LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
                                 LEFT JOIN " . DB_PREFIX . "office c ON c.id=r.office
                                 LEFT JOIN " . DB_PREFIX . "office p ON p.id=r.parent_office
                                 LEFT JOIN " . DB_PREFIX . "office s ON s.id=r.sub_office
                                 LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=r.organisation
                                 LEFT JOIN " . DB_PREFIX . "qc_request q ON q.request_id=r.request_id
                                 JOIN " . DB_PREFIX . "user t ON t.id = r.user_id and t.active_status != 3
                                 where 1  and a.assignee_status=1 and ar.verify_status in (111,110,519) and o.dedicated_qc=4 ";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
            
        }
                 if ($type == 'count') $select = "count(DISTINCT(a.request_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                       $from .= " group by a.request_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from; 
        $query = $this->db->query($sql); 
        return $query->result_array();
    }
    /* qc2 allocation list */
    function get_qc2userlist($pg = 0, $limit = 15, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')    {

        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,r.candidate_name,p.office_name as parent_office,s.office_name as sub_office,o.org_name,r.case_no,min(vl1.v_date) as vm_date ,q.assignee_by ";
         $from = "   FROM " . DB_PREFIX . "client_request r  
         JOIN  " . DB_PREFIX . "verification_request a ON a.request_id=r.request_id and a.qc_assignee_status=1
         JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id=a.request_id
         JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = r.request_id and ar.qc1_verification=1
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=ar.candidate_req_id and vl1.check_id=ar.check_id and vl1.level_id=ar.level_id
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "office c ON c.id=r.office
         LEFT JOIN " . DB_PREFIX . "office p ON p.id=r.parent_office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id=r.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=r.organisation
         LEFT JOIN " . DB_PREFIX . "qc2_request q ON q.request_id=r.request_id
          JOIN " . DB_PREFIX . "user t ON t.id = r.user_id and t.active_status != 3
         where 1 and ar.verify_status in (111,110,519)  ";
        if($this->session->userdata('role_id')==17){
        $from .=" and ar.qc1_verification=1 ";
        }           

        if ($searchCond) {
        $from .= " and $searchCond ";
        } 
        if($this->session->userdata('role_id')==4){
        $from .=" and o.dedicated_qc=4 ";
        }
        if ($type == 'count') {
        $select = "count(DISTINCT(a.request_id)) as count "; 
        }

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " group by a.request_id order by $sBy $sOrder limit $pg," . $limit;
        }
       
        $sql = "SELECT " . $select . "" . $from;  
        $query = $this->db->query($sql); 
        return $query->result_array(); 
    }
/* qc alloted casewise list*/
    function get_qc1casewiselist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')    {

        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,r.candidate_name,p.office_name as parent_office,s.office_name as sub_office,o.org_name,r.case_no";
         $from = "   FROM " . DB_PREFIX . "client_request r  
         LEFT JOIN  " . DB_PREFIX . "verification_request a ON a.request_id=r.request_id
         LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "office c ON c.id=r.office
         LEFT JOIN " . DB_PREFIX . "office p ON p.id=r.parent_office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id=r.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=r.organisation
         LEFT JOIN " . DB_PREFIX . "qc_request q ON q.request_id=r.request_id
          JOIN " . DB_PREFIX . "user t ON t.id = r.user_id and t.active_status != 3
         where 1  and a.assignee_status=1";
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        if($this->session->userdata('role_id')==4){
            $from .=" and o.dedicated_qc=4 and q.assignee_id =".$this->session->userdata('userid');
        }
                  if ($type == 'count') $select = "count(DISTINCT(a.request_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                       $from .= " group by a.request_id, q.request_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }

  /* qc2 alloted casewise list*/
    function get_qc2casewiselist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')    {

        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,r.candidate_name,p.office_name as parent_office,s.office_name as sub_office,o.org_name,r.case_no";
        $from = "   FROM " . DB_PREFIX . "client_request r  
        LEFT JOIN  " . DB_PREFIX . "verification_request a ON a.request_id=r.request_id
        LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id=a.request_id
        LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
        LEFT JOIN " . DB_PREFIX . "office c ON c.id=r.office
        LEFT JOIN " . DB_PREFIX . "office p ON p.id=r.parent_office
        LEFT JOIN " . DB_PREFIX . "office s ON s.id=r.sub_office
        LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=r.organisation
        LEFT JOIN " . DB_PREFIX . "qc2_request q ON q.request_id=r.request_id
        JOIN " . DB_PREFIX . "user t ON t.id = r.user_id and t.active_status != 3
        where 1  and a.assignee_status=1 ";
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        
        if($this->session->userdata('role_id')==17){
            $from .=" and q.assignee_id = ".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }
        if ($type == 'count') $select = "count(DISTINCT(r.request_id)) as count "; 
        
        if ($pg >= 0 && $type <> 'count') { 
               $from .= " group by r.request_id order by $sBy $sOrder limit $pg," . $limit;
        }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }  
    /* store additional report to client*/
    function addreportstoclient()
    {   
            $formdata=$_POST;
            if(!empty($_FILES['document']['name']))
            {
            $report_name=$_FILES['document']['name'];
           
             }
        $documnets=array();
        $config['allowed_types'] = '*';
        $config['upload_path'] = 'uploads/additionalreport/';
        $config['encrypt_name'] = true;
        $config['remove_spaces'] = true;

        $this->load->library('upload', $config);

        $count = count($_FILES['document']['size']);
        $s=0; 
               foreach($_FILES as $key=>$value){

                        $_FILES['userfile']['name']     = $value['name'];
                        $_FILES['userfile']['type']     = $value['type'];
                        $_FILES['userfile']['tmp_name'] = $value['tmp_name'];
                        $_FILES['userfile']['error']    = $value['error'];
                        $_FILES['userfile']['size']     = $value['size'];   

                                if ( $this->upload->do_upload())
                                {
                                        $documents[$key]    = $this->upload->data();
                                }
                         $s++; 
                     }

                if(!empty($documents['document']))
                {

                $insertData['document_name']  = $documents['document']['file_name'];
                $insertData['report_name']    = $report_name;
                $insertData['request_id']     = $formdata['request_id'];
                $insertData['status']=0;
                $insertData['created_on']= date('Y-m-d H:i:s'); 
                }

                $request_id = $this->amodel->getDetails(DB_PREFIX . "clientadditional_report", array('request_id'), array('request_id' => $formdata['request_id']));
                if($request_id[0] == 0){
                    $this->db->insert(DB_PREFIX . "clientadditional_report", $insertData); 
                    echo "<script>alert('Report uploaded is successfully');</script>";
                }
                else
                {
                    // $this->db->where('request_id', $formdata['request_id']);
                    // $this->db->update(DB_PREFIX . "clientadditional_report", array('status'=>0)); 
                    $this->db->insert(DB_PREFIX . "clientadditional_report", $insertData);
                    echo "<script>alert('Report uploaded is successfully');</script>";
                   //$this->db->insert(DB_PREFIX . "clientadditional_report", $insertData);
                }   
                
         redirect('' . base_url('Verification/qc2_casewiselist/'));      
    }           

    /* QC1 ACC Allotted list*/
    function get_qc1accallottedlist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')    {
        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,r.candidate_name,p.office_name as parent_office,s.office_name as sub_office,o.org_name,r.case_no";
            $from = "   FROM " . DB_PREFIX . "client_request r 
            LEFT JOIN  
               " . DB_PREFIX . "verification_request a ON a.request_id=r.request_id
            LEFT JOIN 
               " . DB_PREFIX . "verification_status vs ON vs.request_id=a.request_id
            LEFT JOIN 
               " . DB_PREFIX . "user b ON b.id=a.assignee_id
            LEFT JOIN 
               " . DB_PREFIX . "office c ON c.id=r.office
            LEFT JOIN 
               " . DB_PREFIX . "office p ON p.id=r.parent_office
            LEFT JOIN 
               " . DB_PREFIX . "office s ON s.id=r.sub_office
            LEFT JOIN 
               " . DB_PREFIX . "organisation o ON o.id=r.organisation 
             LEFT JOIN 
               " . DB_PREFIX . "qc_request qc ON qc.request_id=r.request_id
            where 1  and 
               a.assignee_status=1 and o.dedicated_qc = 4  and 
               vs.verification_status=1 and 
               (
                  (select count(vl.request_id) FROM " . DB_PREFIX . "verified_level vl LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = vl.request_id and vl.check_id = ar.check_id AND vl.level_id = ar.level_id where vl.request_id = a.request_id  and (ar.verify_status IN (111,110,519)) 
                 
               ) = (select sum(no_checks) FROM " . DB_PREFIX . "request_check re where re.request_id=a.request_id ) ) 
               and ((select sum(no_checks) FROM " . DB_PREFIX . "request_check re where re.request_id=a.request_id ) != (select count(va.rep_id) FROM " . DB_PREFIX . "ver_assign_rep va LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON va.candidate_req_id = vl1.request_id and vl1.check_id = va.check_id AND vl1.level_id = va.level_id where va.candidate_req_id = a.request_id and vl1.qcstatus IN (111,110,519))) ";
       
         if ($searchCond) {
            $from .= " and $searchCond";
        }
         /* qc1 verification*/
        if($this->session->userdata('role_id')==4){
            $from .=" and qc.assignee_id =".$this->session->userdata('userid');
        }
             if ($type == 'count') $select = "count(DISTINCT(a.request_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                       $from .= " group by a.request_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    /* QC2 ACC Allotted list*/
    function get_qc2accallottedlist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')    {
         $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,r.candidate_name,p.office_name as parent_office,s.office_name as sub_office,o.org_name,r.case_no";
            $from = "   FROM " . DB_PREFIX . "client_request r 
            LEFT JOIN  
               " . DB_PREFIX . "verification_request a ON a.request_id=r.request_id
            LEFT JOIN 
               " . DB_PREFIX . "verification_status vs ON vs.request_id=a.request_id
            LEFT JOIN 
               " . DB_PREFIX . "user b ON b.id=a.assignee_id
            LEFT JOIN 
               " . DB_PREFIX . "office c ON c.id=r.office
            LEFT JOIN 
               " . DB_PREFIX . "office p ON p.id=r.parent_office
            LEFT JOIN 
               " . DB_PREFIX . "office s ON s.id=r.sub_office
            LEFT JOIN 
               " . DB_PREFIX . "organisation o ON o.id=r.organisation
            LEFT JOIN 
               " . DB_PREFIX . "qc2_request qc ON qc.request_id=r.request_id

            where 1  and 
               a.assignee_status=1 and 
               vs.verification_status=1 and 
               (
                 ( select count(vl.request_id) FROM " . DB_PREFIX . "verified_level vl LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = vl.request_id and vl.check_id = ar.check_id AND vl.level_id = ar.level_id where vl.request_id = a.request_id  and
                  CASE 
                     WHEN 
                        o.dedicated_qc = 17 
                     THEN 
                        (ar.verify_status IN (111,110,519) AND ar.vm_assigned_qc=1 ) 
                     ELSE 
                        ( (ar.verify_status IN (111,110,519)) AND vl.qcstatus IN (111,110,519) ) 
                     END 
               ) = (select sum(no_checks) FROM " . DB_PREFIX . "request_check re where re.request_id=a.request_id )) and
               ((select sum(no_checks) FROM " . DB_PREFIX . "request_check re where re.request_id=a.request_id ) != (select count(va.rep_id) FROM " . DB_PREFIX . "ver_assign_rep va LEFT JOIN " . DB_PREFIX . "verified_level vl ON va.candidate_req_id = vl.request_id and vl.check_id = va.check_id AND vl.level_id = va.level_id where va.candidate_req_id = a.request_id and va.qc2_report_publish=1)) ";
      
         if ($searchCond) {
            $from .= " and $searchCond";
        }
         /* qc2 verification*/
        if($this->session->userdata('role_id')==17){
            $from .=" and qc.assignee_id =".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }
        if ($type == 'count') $select = "count(DISTINCT(a.request_id)) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
               $from .= " group by a.request_id order by $sBy $sOrder limit $pg," . $limit;
        }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function getcountchecksverify($rid){
           $this->db->select('a.rep_id')
                       ->from(DB_PREFIX .'ver_assign_rep a')
                      ->where('a.candidate_req_id',$rid)
                      ->where('a.qc1_verification',1);
                      
                       return $this->db->get()->result_array(); 
        }
        function getcountvmassign($accid){
             $this->db->select('a.request_id')
                       ->from(DB_PREFIX .'verified_level a')
                      ->where('a.request_id',$accid);
                       return $this->db->get()->result_array(); 
        }
        function getcountqcchecksverify($rid){
            $select = "a.rep_id";
            $from = "FROM ".DB_PREFIX. "ver_assign_rep a
            where a.candidate_req_id=".$rid."and a.qc2_report_publish!=1";
            $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
           
        }
        function getcountqcassign($accid){
             $this->db->select('a.request_id')
                       ->from(DB_PREFIX .'verified_level a')
                      ->where('a.request_id',$accid);
                       return $this->db->get()->result_array(); 
        }
        /*ACC Check */
        function get_check_wise_assign($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {
        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,ar.qc2_report_publish,ar.qc_2_verification";

                                 $from = "   FROM " . DB_PREFIX . "verification_request a 
                                 LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
                                 LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
                                 LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
                                 LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
                                 LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
                                 LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation

                                 LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
                                 LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
                                 LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id
                                 LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
                                 LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
                                 LEFT JOIN " . DB_PREFIX . "qc_request qc ON qc.request_id=a.request_id
                                 where 1  and a.assignee_status=1 and ar.verify_status in (111,107,110,519) AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id ";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        if ($type == 'count'){
            $select = "count(*) as count "; 
        } 
        if ($pg >= 0 && $type <> 'count') { 
            $from .= " group by a.request_id, ar.level_id,ar.check_id order by $sBy $sOrder limit $pg," . $limit;
        }
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    /* QC! discrepency list*/
    function get_qc1discrepencylist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {
        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk";

                                 $from = "   FROM " . DB_PREFIX . "verification_request a 
                                 LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
                                 LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
                                 LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
                                 LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
                                 LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
                                 LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation

                                 LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
                                 LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
                                 LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id
                                 LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
                                 LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id
                                 LEFT JOIN " . DB_PREFIX . "qc_request qc ON qc.request_id=a.request_id
                                 where 1  and a.assignee_status=1 and o.dedicated_qc=4 and vl1.vm_discrepency in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701)  AND qcstatus in(0,107) ";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        /* qc1 verification*/
        if($this->session->userdata('role_id')==4){
            $from .=" and qc.assignee_id =".$this->session->userdata('userid');
        }

                if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function get_qc2discrepencylist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {
        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,ar.qc_2_verification,ar.qc2_report_publish";

         $from = "   FROM " . DB_PREFIX . "verification_request a 
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
         LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation

         LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
         LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id
         LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id=a.request_id
         where 1  and a.assignee_status=1 and
         CASE WHEN o.dedicated_qc=17 THEN 
         vl1.vm_discrepency in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701)
         ELSE 
         qc_discrepency in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701) 
         END  AND qc2_report_publish !=1 and qc2_verification=0 and qc1_verification =1  and qc2status<>107  and (qc1_assign_revert = 1 and qc_revert_request = 1 || qc_revert_request = 0  and qc1_assign_revert = 0) ";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        /* qc2 verification*/
        if($this->session->userdata('role_id')==17){
            $from .=" and qc.assignee_id =".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }

               if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    } 
    function get_user_checkdata($request_id)
    {
        $sql = "SELECT a.rep_id,a.candidate_req_id as request_id,a.check_id,a.level_id,b.name as check_name
                        FROM " . DB_PREFIX ."ver_assign_rep a 
            LEFT JOIN " . DB_PREFIX ."master_masterdata b on b.id=a.check_id
            WHERE a.candidate_req_id=". $request_id ;
        $query = $this->db->query($sql);
                return $query->result_array();  
    }
    function getpersonalreportsdata($request_id)
    {
            $sql = "SELECT a.request_id,GROUP_CONCAT(a.comment) as comment_list,b.key,a.label_name,GROUP_CONCAT(b.field_name) as field_list
                        FROM " . DB_PREFIX ."verification_reports a 
                        LEFT JOIN " . DB_PREFIX . "master_field_table b ON b.id=a.label_name
                        WHERE a.request_id=". $request_id ." and b.key = 'personal_key' group by a.request_id";
                $result1 = $this->db->query( $sql )->result_array();
            $sql1 = "SELECT ".$result1[0]['field_list']." FROM ".DB_PREFIX."personal_details where user_id = ".$request_id;
                $result2 = $this->db->query($sql1)->result_array();
                return array_merge($result1[0],$result2[0]);
    }
    
    function qc1_personal_reports($request_id)    {
            $sql = "SELECT a.request_id,GROUP_CONCAT(a.comment) as comment_list,GROUP_CONCAT(b.comment) as qcomment_list,c.key, a.label_name,GROUP_CONCAT(c.field_name) as field_list
                        FROM " . DB_PREFIX ."verification_reports a 
                        LEFT JOIN " . DB_PREFIX . "verification_qc1reports b ON b.label_name=a.label_name
                        LEFT JOIN " . DB_PREFIX . "master_field_table c ON c.id=b.label_name
                        WHERE a.request_id=". $request_id ." and b.request_id=". $request_id ." and c.key = 'personal_key' group by a.request_id";
                $result1 = $this->db->query( $sql )->result_array();

        $fields = ($result1[0]['field_list']) ? $result1[0]['field_list'] : '*';
                $sql1 = "SELECT ".$fields." FROM ".DB_PREFIX."personal_details where user_id = ".$request_id;
                $result2 = $this->db->query($sql1)->result_array();
                return array_merge($result1[0],$result2[0]);
    }

    function qc1_edu_eduReports($request_id)    {
            $sql = "SELECT a.request_id,GROUP_CONCAT(a.comment) as comment_list,GROUP_CONCAT(b.comment) as qcomment_list,c.key, a.label_name,GROUP_CONCAT(c.field_name) as field_list
                        FROM " . DB_PREFIX ."verification_reports a 
                        LEFT JOIN " . DB_PREFIX . "verification_qc1reports b ON b.label_name=a.label_name
                        LEFT JOIN " . DB_PREFIX . "master_field_table c ON c.id=b.label_name
                        WHERE a.request_id=". $request_id ." and b.request_id=". $request_id ." and c.key = 'education_key' group by a.request_id";
                $result1 = $this->db->query( $sql )->result_array();

        $fields = ($result1[0]['field_list']) ? $result1[0]['field_list'] : '*';
                $sql1 = "SELECT ".$fields." FROM ".DB_PREFIX."education_details where request_id = ".$request_id;
                $result2 = $this->db->query($sql1)->result_array();
                return array_merge($result1[0],$result2[0]);
    }

    function getotherreportsdata($request_id)    {
            $sql = "SELECT a.request_id,GROUP_CONCAT(a.comment) as comment_list,b.key,a.label_name,GROUP_CONCAT(b.field_name) as field_list
                        FROM " . DB_PREFIX ."verification_reports a 
                        LEFT JOIN " . DB_PREFIX . "master_field_table b ON b.id=a.label_name
                        WHERE a.request_id=". $request_id ." and b.key = 'other_key' group by a.request_id";
                $result1 = $this->db->query( $sql )->result_array();
        $fields = ($result1[0]['field_list']) ? $result1[0]['field_list'] : '*';
                $sql1 = "SELECT ".$fields." FROM ".DB_PREFIX."other_details where user_id = ".$request_id;
                $result2 = $this->db->query($sql1)->result_array();
                return array_merge($result1[0],$result2[0]);
    }

    function qgetotherreportsdata($request_id)    {
            $sql = "SELECT a.request_id,GROUP_CONCAT(a.comment) as ocomment_list,GROUP_CONCAT(b.comment) as qocomment_list,a.label_name,GROUP_CONCAT(c.field_name) as field_list
                        FROM " . DB_PREFIX ."verification_reports a 
                        LEFT JOIN " . DB_PREFIX . "verification_qc1reports b ON b.label_name=a.label_name
                        LEFT JOIN " . DB_PREFIX . "master_field_table c ON c.id=b.label_name
                        WHERE a.request_id=". $request_id ." and b.request_id=". $request_id ." and c.key = 'other_key' ";
                $result1 = $this->db->query( $sql )->result_array();
        $fields = ($result1[0]['field_list']) ? $result1[0]['field_list'] : '*';
                $sql1 = "SELECT ".$fields." FROM ".DB_PREFIX."other_details where user_id = ".$request_id;
                $result2 = $this->db->query($sql1)->result_array();
                return array_merge($result1[0],$result2[0]);
    }


    function geteducationreportsdata($request_id)    {
        $sql = "SELECT a.request_id,a.comment,b.field_name,b.key,b.id
                        FROM " . DB_PREFIX ."verification_reports a 
                        LEFT JOIN " . DB_PREFIX . "master_field_table b ON b.id=a.label_name
                        WHERE a.request_id=". $request_id ." and b.key = 'education_key'";
                $query = $this->db->query( $sql );
                return $query->result_array();
    }

    function get_eduReports($request_id)   {
            $sql = "SELECT a.request_id,GROUP_CONCAT(a.comment) as comment_list, b.key, a.label_name,GROUP_CONCAT(b.field_name) as field_list
                        FROM " . DB_PREFIX ."verification_reports a 
                        LEFT JOIN " . DB_PREFIX . "master_field_table b ON b.id=a.label_name
                        WHERE a.request_id=". $request_id ." and b.key = 'education_key' group by a.request_id";
                $result1 = $this->db->query( $sql )->result_array();
        $fields = ($result1[0]['field_list']) ? $result1[0]['field_list'] : '*';
                $sql1 = "SELECT ".$fields." FROM ".DB_PREFIX."education_details where request_id = ".$request_id;
                $result2 = $this->db->query($sql1)->result_array();

                return array_merge($result1[0],$result2[0]);
    }

    function getqc1_eduReports($request_id)   {
            $sql = "SELECT a.request_id,GROUP_CONCAT(a.comment) as comment_list,GROUP_CONCAT(b.comment) as qcomment_list,c.key,a.label_name,GROUP_CONCAT(c.field_name) as field_list
                        FROM " . DB_PREFIX ."verification_reports a 
                        LEFT JOIN " . DB_PREFIX . "verification_qc1reports b ON b.label_name=a.label_name
                        LEFT JOIN " . DB_PREFIX . "master_field_table c ON c.id=b.label_name
                        WHERE a.request_id=". $request_id ." and b.request_id=". $request_id ." and c.key = 'education_key' group by a.request_id";
                $result1 = $this->db->query( $sql )->result_array();
                
                $fields = ($result1[0]['field_list']) ? $result1[0]['field_list'] : '*';
                
                $sql1 = "SELECT ".$fields." FROM ".DB_PREFIX."personal_details where user_id = ".$request_id;
                $result2 = $this->db->query($sql1)->result_array();
                return array_merge($result1[0],$result2[0]);
    }
    
    function verificationreportdata($request_id,$key)
    {
    if($key=="Education"){
        $key='education_key';
    }
    else if($key=="Employment")
    {
        $key='employment_key';
    }
    else
    {
        $key='contact_key';
    }
    $sql = "SELECT DISTINCT b.field_name,a.request_id,a.comment,b.key,b.id
                        FROM " . DB_PREFIX ."verification_reports a 
                        LEFT JOIN " . DB_PREFIX . "master_field_table b ON b.id=a.label_name
                        WHERE a.request_id=". $request_id ." and b.key = '".$key."'";
                $query = $this->db->query( $sql );
                return $query->result_array();

    }
    function dataentrydata($request_id,$level_id,$key)
    {
    if($key=="Education"){
        $sql = "SELECT a.degree as level_id,b.name as degree,a.affliated,a.period_from,a.period_to,a.roll,a.graduate,a.program,a.subject,a.reason1
                        FROM " . DB_PREFIX ."education_details a 
                        join " . DB_PREFIX ."master_masterdata b on b.id = a.degree
                        WHERE a.request_id =". $request_id." and a.degree=".$level_id;
                
    }
    else if($key=="Employment")
    {
        $sql = "SELECT a.id,a.level_id,b.name,a.company_name,a.office_address,a.branch_address,a.telephone_no,a.manager_name,a.designation,
            a.email_id,a.contact_no,a.salary,a.reason,a.reference
                        FROM " . DB_PREFIX ."employment a 
                        join " . DB_PREFIX ."master_masterdata b on b.id = a.level_id
                        WHERE a.req_id =". $request_id." and a.level_id=".$level_id;
    }
    else
    {
        $sql = "SELECT a.id, a.level_id,b.name,a.permanent_address,a.period_of_stay, a.current_address, a.current_address, a.cperiod_of_stay, a.current_tel_no,a.permanent_tel_no,a.office_tel_no,a.mobile,a.email_id,a.alter_email_id
                        FROM " . DB_PREFIX ."contact_details a 
                        join " . DB_PREFIX ."master_masterdata b on b.id = a.level_id
                        WHERE a.request_id =". $request_id." and a.level_id=".$level_id;
    }
    $query = $this->db->query( $sql );
                return $query->result_array();
    
    }
    
    function otherreportsdata($request_id)
    {
        $sql = "SELECT a.request_id,a.comment,b.field_name,b.key,b.id
                        FROM " . DB_PREFIX ."verification_reports a 
                        LEFT JOIN " . DB_PREFIX . "master_field_table b ON b.id=a.label_name
                        WHERE a.request_id=". $request_id ." and b.key = 'other_key'";
                $query = $this->db->query( $sql );
                return $query->result_array();
    }
    function personalreportsdata($request_id)  { 
        $sql = "SELECT a.request_id,a.comment,b.field_name,b.key,b.id
                        FROM " . DB_PREFIX ."verification_reports a 
                        LEFT JOIN " . DB_PREFIX . "master_field_table b ON b.id=a.label_name
                        WHERE a.request_id=". $request_id ." and  b.key = 'personal_key'";
                $query = $this->db->query( $sql );
                return $query->result_array();
    }
    function edu_reportsdata($request_id)  { 
        $sql = "SELECT a.request_id,a.comment,b.field_name,b.key,b.id
                        FROM " . DB_PREFIX ."verification_reports a 
                        LEFT JOIN " . DB_PREFIX . "master_field_table b ON b.id=a.label_name
                        WHERE a.request_id=". $request_id ." and  b.key = 'education_key'";
                $query = $this->db->query( $sql );
                return $query->result_array();
    }
    function qc_assaindata($request_id)
    {
        $sql = "SELECT a.qc_assignee_status,b.first_name,a.request_id
                        FROM " . DB_PREFIX ."qc_request a 
                        LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
                        WHERE a.request_id=". $request_id;
                $query = $this->db->query( $sql );
                return $query->result_array();
    }
    
    function qc2_assaindata($request_id)
    {
        $sql = "SELECT a.qc2_assignee_status,CONCAT_WS(' ',b.first_name,b.middle_name,b.last_name) as first_name,a.request_id
                        FROM " . DB_PREFIX ."qc2_request a 
                        LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
                        WHERE a.request_id=". $request_id;
                $query = $this->db->query( $sql );
                return $query->result_array();
    }

    function qc1_change_status($req_id,$check_id,$level_id,$post,$pack_id)
    {
    
    if($_POST['status']<>'')
    $sql = "UPDATE " . DB_PREFIX ."ver_assign_rep SET qc1_verification=1,qc1_dis='".$post['discrapancy_text']."' WHERE candidate_req_id=".$req_id." and check_id=".$check_id." and pack_id=".$pack_id." and level_id=".$level_id;   
    else
    $sql = "UPDATE " . DB_PREFIX ."ver_assign_rep SET qc1_verification=1 WHERE candidate_req_id=".$req_id." and check_id=".$check_id." and pack_id=".$pack_id." and level_id=".$level_id;
        $query = $this->db->query($sql);

    $this->db->where('request_id',$req_id);
    $this->db->update ( DB_PREFIX .'verification_request',array('qc_assignee_status'=>1) ); 
    
   }
   function qc1_change_revertstatus($req_id,$check_id,$level_id,$post,$pack_id)
    {
   
    if($_POST['status']<>'')
    $sql = "UPDATE " . DB_PREFIX ."ver_assign_rep SET qc1_verification=1,qc1_assign_revert=1,qc_2_verification=0,qc1_dis='".$post['discrapancy_text']."' WHERE candidate_req_id=".$req_id." and check_id=".$check_id." and pack_id=".$pack_id." and level_id=".$level_id;   
    else
    $sql = "UPDATE " . DB_PREFIX ."ver_assign_rep SET qc1_verification=1 WHERE candidate_req_id=".$req_id." and check_id=".$check_id." and pack_id=".$pack_id." and level_id=".$level_id;
        $query = $this->db->query($sql);
   
   }
    function qc2_change_status($req_id,$check_id,$level_id,$post,$pack_id)
    {
   
    if($_POST['discrapancy']==1)
    $sql = "UPDATE " . DB_PREFIX ."ver_assign_rep SET qc2_verification=2,qc_2_verification=1,qc2_report_publish=0,qc2_dis='".$post['discrapancy_text']."' WHERE candidate_req_id=".$req_id." and check_id=".$check_id." and pack_id=".$pack_id." and level_id=".$level_id;   
    else
    $sql = "UPDATE " . DB_PREFIX ."ver_assign_rep SET qc2_verification=1,qc2_report_publish=0,qc_2_verification=1,qc2_revert_request=0 WHERE candidate_req_id=".$req_id." and check_id=".$check_id." and pack_id=".$pack_id." and level_id=".$level_id;
        $query = $this->db->query($sql);
   
   }
   function qc2_change_publishstatus($req_id,$check_id,$level_id,$post,$pack_id)
    {
    if($_POST['discrapancy']==1)
    $sql = "UPDATE " . DB_PREFIX ."ver_assign_rep SET qc2_verification=2,qc_2_verification=1,qc2_report_publish=1,qc2_dis='".$post['discrapancy_text']."' WHERE candidate_req_id=".$req_id." and check_id=".$check_id." and pack_id=".$pack_id." and level_id=".$level_id;  
    else
    $sql = "UPDATE " . DB_PREFIX ."ver_assign_rep SET qc2_verification=1,qc_2_verification=1,qc2_report_publish=1 WHERE candidate_req_id=".$req_id." and check_id=".$check_id." and pack_id=".$pack_id." and level_id=".$level_id;
        $query = $this->db->query($sql);
    
   }
    function qc1details_report($request_id)
    {
    
        $req_id = $request_id;
                if($_POST['discrapancy']!=1){
        foreach($_POST as $key=>$val)
        {       
                if($key!="Submit_x" && $key!="Submit_y") {
                if($val[1]) {
                $lable = explode('field_',$key);
                $formData['request_id'] = base64_decode($request_id);
                $formData['label_name'] = $lable[1];
                $formData['comment'] = $val[1];
                }
                else {
                $lable = explode('field_',$key);
                $formData['request_id'] = base64_decode($request_id);
                $formData['label_name'] = $lable[1];
                $formData['comment'] = "Verified-found Correct";
                }
                if ($formData) {
                        $insertData = elements(array('request_id','label_name','comment'),$formData);
                        $this->amodel->dmlfunction(DB_PREFIX . "verification_qc1reports", array('id' => $id), $insertData, $id);
                }
        }}}
    }
    function qc2details_report($request_id)
    {
    
        $req_id = $request_id;
                if($_POST['discrapancy']!=1){
        foreach($_POST as $key=>$val)
        {       
                if($key!="Submit_x" && $key!="Submit_y") {
                if($val[1]) {
                $lable = explode('field_',$key);
                $formData['request_id'] = base64_decode($request_id);
                $formData['label_name'] = $lable[1];
                $formData['comment'] = $val[1];
                }
                else {
                $lable = explode('field_',$key);
                $formData['request_id'] = base64_decode($request_id);
                $formData['label_name'] = $lable[1];
                $formData['comment'] = "Verified-found Correct";
                }
                if ($formData) {
                        $insertData = elements(array('request_id','label_name','comment'),$formData);
                        $this->amodel->dmlfunction(DB_PREFIX . "verification_qc2reports", array('id' => $id), $insertData, $id);
                }
        }}}
    }
    function qc1_assignstatus($request_id)
    {   
        $sql = "SELECT a.request_id,a.qc1_assignstatus
                        FROM " . DB_PREFIX ."client_request a 
                        WHERE a.request_id=". $request_id;
                $query = $this->db->query( $sql );
                return $query->result_array();
    }
    function  otherdetails($request_id)
        {
                $this->db->select('a.agreement,a.criminal,a.bankrupt,a.civil,a.company')
                ->from(DB_PREFIX . 'other_details as a')
                ->where('a.user_id', $request_id);
                return $this->db->get()->result_array();
        }
        function educationdetails($request_id)
        {
                $sql = "SELECT a.degree as level_id,b.name as degree,a.affliated,a.period_from,a.period_to,a.roll,a.graduate,a.program,a.subject,a.reason1
                        FROM " . DB_PREFIX ."education_details a 
                        join " . DB_PREFIX ."master_masterdata b on b.id = a.degree
                        WHERE a.request_id =". $request_id;
                $query = $this->db->query( $sql );
                return $query->result_array();
        }
        function personaldetails($request_id)
        {
                $this->db->select('a.firstname,a.date_of_birth,a.primary_skill,a.experience,a.passport, a.passport_expire,a.place_of_issue, a.date_of_issue,a.license_no, a.valid_up_to,a.nationality,a.SSN')
                ->from(DB_PREFIX . 'personal_details as a')
                ->where('a.user_id', $request_id);
                return $this->db->get()->result_array();
        }
        
        function satisfy_status($request_id)
        {
                $this->db->select('a.id,a.satisfy_status,a.qct_status')
                ->from(DB_PREFIX . 'verification_status as a')
                ->where('a.request_id', $request_id);
                return $this->db->get()->result_array(); 
        }

        function qc2_reportdetails($request_id)
        {
                $req_id = $request_id;
                $upd_data['qc2_discrapancy'] = $_POST['discrapancy'];
                $upd_data['qc2_disc_comment'] = $_POST['discrapancy_text'];
                $upd_data['qc2_status'] = 1;
                $this->db->where('request_id',$request_id);
                $this->db->update ( DB_PREFIX .'verification_status', $upd_data );

                if($_POST['discrapancy']!=1){
            foreach($_POST as $key=>$val)     {       
                if($key!="Submit_x" && $key!="Submit_y") {
                $lable = explode('field_',$key);
                $formData['request_id'] = $request_id;
                $formData['label_name'] = $lable[1];
                $formData['comment'] = ($val[1]) ? $val[1] : "Verified-found Correct";

                if ($formData) {
                        $insertData = elements(array('request_id','label_name','comment'),$formData);
                        $this->amodel->dmlfunction(DB_PREFIX . "verification_qc2reports", array('id' => $id), $insertData, $id);
                    }
                }
        }
        }
        redirect('' . base_url('Verification/qc2_verification/'));
        }
        
        function qcspersonalreportsdata($request_id)        {
        $sql = "SELECT a.request_id,a.comment,b.field_name,b.key,b.id
                        FROM " . DB_PREFIX ."verification_qc1reports a 
                        LEFT JOIN " . DB_PREFIX . "master_field_table b ON b.id=a.label_name
                        WHERE a.request_id=". $request_id ." and b.key = 'personal_key'";
                $query = $this->db->query( $sql );
                return $query->result_array();
         }

        function qc1_edu_reportsdata($request_id)        {
        $sql = "SELECT a.request_id,a.comment,b.field_name,b.key,b.id
                        FROM " . DB_PREFIX ."verification_qc1reports a 
                        LEFT JOIN " . DB_PREFIX . "master_field_table b ON b.id=a.label_name
                        WHERE a.request_id=". $request_id ." and b.key = 'education_key'";
                $query = $this->db->query( $sql );
                return $query->result_array();
         }

        function qcsotherreportsdata($request_id)     {
        $sql = "SELECT a.request_id,a.comment,b.field_name,b.key,b.id
                        FROM " . DB_PREFIX ."verification_qc1reports a 
                        LEFT JOIN " . DB_PREFIX . "master_field_table b ON b.id=a.label_name
                        WHERE a.request_id=". $request_id ." and b.key = 'other_key'";
                $query = $this->db->query( $sql );
                return $query->result_array();
         }
         
          function q2getpersonalreportsdata($request_id)   {
            $sql = "SELECT a.request_id,GROUP_CONCAT(a.comment) as comment_list,GROUP_CONCAT(b.comment) as qcomment_list,GROUP_CONCAT(d.comment) as qccomment,c.key,a.label_name,GROUP_CONCAT(c.field_name) as field_list
                        FROM " . DB_PREFIX ."verification_reports a 
                        LEFT JOIN " . DB_PREFIX . "verification_qc1reports b ON b.label_name=a.label_name
                        LEFT JOIN " . DB_PREFIX . "verification_qc2reports d ON d.label_name=b.label_name
                        LEFT JOIN " . DB_PREFIX . "master_field_table c ON c.id=d.label_name
                        WHERE a.request_id=". $request_id ." and b.request_id=". $request_id ." and d.request_id=". $request_id ." and c.key = 'personal_key' group by a.request_id";
        $fields = ($result1[0]['field_list']) ? $result1[0]['field_list'] : '*';
                $result1 = $this->db->query( $sql )->result_array();
            $sql1 = "SELECT ".$fields." FROM ".DB_PREFIX."personal_details where user_id = ".$request_id;
                $result2 = $this->db->query($sql1)->result_array();
                return array_merge($result1[0],$result2[0]);
        }

          function q2edu_reports($request_id)   {
            $sql = "SELECT a.request_id,GROUP_CONCAT(a.comment) as comment_list,GROUP_CONCAT(b.comment) as qcomment_list,GROUP_CONCAT(d.comment) as qccomment,c.key,a.label_name,GROUP_CONCAT(c.field_name) as field_list
                        FROM " . DB_PREFIX ."verification_reports a 
                        LEFT JOIN " . DB_PREFIX . "verification_qc1reports b ON b.label_name=a.label_name
                        LEFT JOIN " . DB_PREFIX . "verification_qc2reports d ON d.label_name=b.label_name
                        LEFT JOIN " . DB_PREFIX . "master_field_table c ON c.id=d.label_name
                        WHERE a.request_id=". $request_id ." and b.request_id=". $request_id ." and d.request_id=". $request_id ." and c.key = 'education_key' group by a.request_id";
             $result1 = $this->db->query( $sql )->result_array();
                $feilds = ($result1[0]['field_list']) ? $result1[0]['field_list'] : '*';
                $sql1 = "SELECT ".$feilds." FROM ".DB_PREFIX."education_details where request_id = ".$request_id;
                $result2 = $this->db->query($sql1)->result_array();
                return array_merge($result1[0],$result2[0]);
        }
        
    function q2getotherreportsdata($request_id)  {
            $sql = "SELECT a.request_id,GROUP_CONCAT(a.comment) as ocomment_list,GROUP_CONCAT(b.comment) as qocomment_list,GROUP_CONCAT(d.comment) as qccomment,a.label_name,GROUP_CONCAT(c.field_name) as ofield_list
                        FROM " . DB_PREFIX ."verification_reports a 
                        LEFT JOIN " . DB_PREFIX . "verification_qc1reports b ON b.label_name=a.label_name
                        LEFT JOIN " . DB_PREFIX . "verification_qc2reports d ON d.label_name=b.label_name
                        LEFT JOIN " . DB_PREFIX . "master_field_table c ON c.id=d.label_name
                        WHERE a.request_id=". $request_id ." and b.request_id=". $request_id ." and d.request_id=". $request_id ." and c.key = 'other_key' group by a.request_id";
                $result1 = $this->db->query( $sql )->result_array();
                $feilds = ($result1[0]['field_list']) ? $result1[0]['field_list'] : '*';
                $sql1 = "SELECT ".$feilds." FROM ".DB_PREFIX."other_details where user_id = ".$request_id;
                $result2 = $this->db->query($sql1)->result_array();
                return array_merge($result1[0],$result2[0]);
    }


    function getteamlist() 
    {
        return $this->db->query("select 
                              b.id,b.name
                          from
                              ".DB_PREFIX ."user_skills a
                          join ".DB_PREFIX ."master_masterdata b on b.id = a.key
                          where a.user_id = ".$this->session->userdata['userid']."
                          group by b.id")->result_array();
    }
    
    
    function getcheck() 
    {
        
        $this->db->select('id,name');
        $this->db->where('parent',0);
        $this->db->where('key','Check');
        return $this->db->get(DB_PREFIX.'master_masterdata')->result_array();
    }
    function getemail() 
    {
        
        $this->db->select('id,email');      
        return $this->db->get(DB_PREFIX.'add_calls')->result_array();
    }
    function getcontact() 
    {
        
        $this->db->select('id,contact_no');     
        return $this->db->get(DB_PREFIX.'add_calls')->result_array();
    }
        
        function call_m_dml($formdata,$candidate_id,$level_id,$check_id) 
        {
                $contact_name_add=$formdata['contact_name_add'];
                $designation_contact=$formdata['designation_contact'];   
                $mobile=$formdata['mobile'];
                $email=$formdata['email'];   
                $mom=$formdata['mom'];
                if($formdata['reminder']){
                    $reminder = $formdata['reminder'];
                }
                else
                {
                    $reminder = 'off';

                }
                if($formdata['reminder']){
                    $email_count = $formdata['total_count'];
                }
                else{
                     $email_count = 0;
                }
                $data = array(    
                'candidate_req_id'=>$candidate_id,
                'level_id'=>$level_id,
                'check_id'=>$check_id,
                'contact_person'=>$contact_name_add,
                'designation_person'=>$designation_contact,
                'contact_no'=>$mobile,
                'email'=>$email,
                'mom'=>$mom ,
                'user_by'=>$this->session->userdata['userid'],
                'email_count' => $email_count,
                'reminder' => $reminder
                );

                $this->db->insert(DB_PREFIX.'add_calls',$data);
                
        }
         function call_procedure_dml($formdata,$candidate_id,$level_id,$check_id) 
        {
                $contact_name_add=$formdata['contact_name_add'];
                $designation_contact=$formdata['designation_contact'];   
                $mobile=$formdata['mobile'];
                $email=$formdata['email'];   
                $mom=$formdata['mom'];
                $college_procedure = $formdata['college_procedure'];
                $data = array(    
                'candidate_req_id'=>$candidate_id,
                'level_id'=>$level_id,
                'check_id'=>$check_id,
                'contact_person'=>$contact_name_add,
                'designation_person'=>$designation_contact,
                'contact_no'=>$mobile,
                'email'=>$email,
                'mom'=>$mom ,
                'college_procedure' => $college_procedure,
                'user_by'=>$this->session->userdata['userid']
                );

                $this->db->insert(DB_PREFIX.'add_procedure',$data);
                
        }
        function call_admin_dml($formdata,$presale_id) 
        {
                $contact_name_add=$formdata['contact_name_add'];
                $designation_contact=$formdata['designation_contact'];   
                $mobile=$formdata['mobile'];
                $email=$formdata['email'];   
                $mom=$formdata['mom'];
                $data = array(    
                'presale_id'=>$presale_id,
                'contact_person'=>$contact_name_add,
                'designation_person'=>$designation_contact,
                'contact_number'=>$mobile,
                'email'=>$email,
                'mom'=>$mom ,
                'user_by'=>$this->session->userdata['userid']
                );
                $data = $this->security->xss_clean($data);
                $this->db->insert(DB_PREFIX.'admin_add_calls',$data);
                
        }

        function verfierdetails($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {
        $select = "a.*,u.first_name ";
        $from ="from  ".DB_PREFIX ."add_calls a JOIN ".DB_PREFIX ."user u ON u.id=user_by where 1";


        if ($searchCond) {
        $from .= " and $searchCond";
        }


        if ($type == 'count') $select = "count(*) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " order by $sBy $sOrder limit $pg," . $limit;
        }

        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
        }

        function verfierproceduredetails($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {
        $select = "a.*,u.first_name ";
        $from ="from  ".DB_PREFIX ."add_procedure a JOIN ".DB_PREFIX ."user u ON u.id=user_by where 1";


        if ($searchCond) {
        $from .= " and $searchCond";
        }


        if ($type == 'count') $select = "count(*) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " order by $sBy $sOrder limit $pg," . $limit;
        }

        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
        }
    
        function getcheckDetails($request_id =null,$table =null, $field='request_id',$checkid=false)
        {
                      
                $this->db->select('candidate_req_id as id,level_id,check_id');
            $this->db->where('candidate_req_id',$request_id);
            $this->db->where('check_id',$checkid);
         $allotedids=   $this->db->get(DB_PREFIX.'ver_assign_rep')->result_array();
         
         foreach($allotedids as $ids)
         $idss[]=$ids['level_id'];
         
         if(!empty($idss))
        $final= "'".implode("','",$idss)."'";
        
        if(!empty($final))
        $notin="id NOT IN (".$final.")";
             
                $cond='';
                if($table)
                { 
                $this->db->select('id,checkid');
                if($notin)
                $this->db->where($notin);
                $this->db->where('checkid',$checkid);
                }
                $this->db->where($field,$request_id);
                if($table)   {
                   $this->db->where('check_status',14);
                   $this->db->order_by('check_type');
                return $this->db->get(DB_PREFIX.$table)->result_array(); 
                }
                else
                {
                $this->db->select('r.*,m.name,md.name as pname');
                $this->db->join(DB_PREFIX.'master_masterdata m','m.id=r.check_id','left');
                 $this->db->join(DB_PREFIX.'master_masterdata md','md.id=r.description','left');
                return $this->db->get(DB_PREFIX.'request_check r')->result_array();
               }
        }
        function vmrevert_update_status($clonecount=0,$req_id,$check_id,$level_id,$post,$pack_id,$vmexpenses){
            $documnets=array();
                if(!empty($_FILES['upload_document']["name"])){
                         $temp = array();
                          foreach ($_FILES['upload_document']["name"] as $key => $value) {
                          $tmp_name =$_FILES["upload_document"]["tmp_name"][$key];
                         $name = $_FILES["upload_document"]["name"][$key];
                          $px = $name;
                          $px = preg_replace('/\s+/','_', $px);
                          $px = str_replace('&', 'and', $px);
                          $target = './uploads/candidate/document/';                              
                          $u = $target . $px;
                          move_uploaded_file($tmp_name, $u);
                          $temp[] = $px;
                          }
                          $documnets = implode($temp,",");
                }
                       if(isset($documnets) && !empty($documnets))
                       $save['upload_document']=$documnets;
                        $save['fielddata']=json_encode($post);
                        $save['vmexpenses']=json_encode($vmexpenses);
                         $save['v_date']=date('Y-m-d H:i:s');
                         $save['verified_by']=$this->session->userdata('userid');
                         $save['reqstatus']='';
                         if($post['status']!=111){
                            $save['vm_discrepency']='';
                         }
                         else
                         {
                            $save['vm_discrepency']=$post['status1'];
                         }

                         //Edited By amritha on 09/06/2023 for checking  vmexpenses is null or not
                        // Oct 26th 2023
                       $origin_verification  = $post['origin_verification'];
                        if(!empty($origin_verification))
                        {
                        $save['outside_india']=$origin_verification;   
                        }
                        else{
                        $save['outside_india']=0;
                         }

                        if(!empty($vmexpenses))
                        {
                            $save['exp_status']=1;  
                        }
                        else{
                            $save['exp_status']=0;
                        }
                       $this->db->where('request_id',$req_id);
                       $this->db->where('check_id',$check_id);
                       $this->db->where('level_id',$level_id);
                       $this->db->update('dcode_verified_level',$save);

               

        }
        function vmrevert_updates($req_id,$check_id,$level_id,$post,$pack_id){
                    $verify_qc=$this->vm->verify_qc($req_id);
                    if($verify_qc[0]['dedicated_qc']==17){
                            $save['vm_assigned_qc']=1;
                            $save['qc1_assign_revert']=1;
                            $save['qc_2_verification']=0;
                           
                    }
                    else
                    {
                            $save['vm_assigned_qc']=1;
                    }
                       $save['verify_status']=$post['status'];
                       $this->db->where('candidate_req_id',$req_id);
                       $this->db->where('check_id',$check_id);
                       $this->db->where('level_id',$level_id);
                       $this->db->update('dcode_ver_assign_rep',$save);
        }
        
        function get_level_name($request_id,$checkid,$levelid,$table='',$field='request_id',$select='degree')
        {
                $newselect='';
                if($checkid==14)
                    $newselect=",CONCAT_WS(' | ',collegename_add, affliated ) as details";
                if($checkid==16)
                $newselect=", permanent_address as details ";
                if($checkid==59)
                $newselect=",CONCAT_WS(' ',company_name,office_address ) as details ";
                
                $this->db->select('id,'.$select.' as level '.$newselect);
                $this->db->where('id',$levelid);
                $this->db->where($field,$request_id);
                if($table)
                return $this->db->get(DB_PREFIX.$table)->row_array();
        }
        function update_level($request_id,$level_id,$check_id,$post,$status,$userid,$packid,$vmexpenses)
        { 
            $documnets=array();
                if(!empty($_POST["authenticate_doc"])){
                         $temp = array();
                          foreach ($_POST["authenticate_doc"] as $key =>$value) {
                          $tmp_name = $_POST["authenticate_doc"];
                          $name = $_POST["authenticate_doc"];
                          $px = $name;
                          $px = preg_replace('/\s+/','_', $px);
                          $px = str_replace('&', 'and', $px);
                          $target = './uploads/candidate/document/';
                          $u = $target . $px;
                          move_uploaded_file($tmp_name, $u);
                          $temp = $px;
                          }
                          $documnets = implode($temp,",");
                }
                       if(isset($documnets) && !empty($documnets))
                       $post['authenticate_doc']=$documnets;

               $save['request_id']=$request_id;
                $save['check_id']=$check_id;
                $save['level_id']=$level_id;
                $save['package_id']=$packid;
               $this->db->select('count(*) as cnt');
               $this->db->where('request_id',$request_id);
                $this->db->where('check_id',$check_id);
                $this->db->where('level_id',$level_id);
               $save['fielddata']=json_encode($post);
               $save['vmexpenses']=json_encode($vmexpenses);
                $save['status']=$status;
                $save['vm_discrepency']=$post['status1'];
                $save['verified_by']=$userid;
                $save['v_date']=date('Y-m-d H:i:s');
                $save['reqstatus']='';
                //Edited By amritha on 09/06/2023 for checking  vmexpenses is null or not
                 
                 // Oct 26th 2023
                $origin_verification  = $post['origin_verification'];
                if(!empty($origin_verification))
                    {
                        $save['outside_india']=$origin_verification;   
                    }
                    else{
                        $save['outside_india']=0;
                    }

                if(!empty($vmexpenses))
                {
                    $save['exp_status']=1;  
                }
                else{
                    $save['exp_status']=0;
                }

             $result=  $this->db->get(DB_PREFIX.'verified_level')->row_array();
               if($result['cnt']==0) {
                $this->db->insert(DB_PREFIX.'verified_level',$save);
                }
                else
                {
                $this->db->where('request_id',$request_id);
                $this->db->where('check_id',$check_id);
                $this->db->where('level_id',$level_id);
                $this->db->update(DB_PREFIX.'verified_level',$save);
                }
            
        
        }
        function update_loglevel($request_id,$userid,$pack_id){
                $inslog_data['pack_id']=$pack_id;
                $inslog_data['action']='Allotted to QC';                    
                $inslog_data['updated_by'] = $userid;
                $inslog_data['updated_on'] = date ( 'Y-m-d H:i:s' );
                $this->db->where('request_id',$request_id);
                $this->db->update ( DB_PREFIX .'loghistory', $inslog_data );
        }
        function update_logqclevel($request_id,$userid,$pack_id){
                $inslog_data['pack_id']=$pack_id;
                $inslog_data['action']='Allotted to QC2';                    
                $inslog_data['updated_by'] = $userid;
                $inslog_data['updated_on'] = date ( 'Y-m-d H:i:s' );
                $this->db->where('request_id',$request_id);
                $this->db->update ( DB_PREFIX .'loghistory', $inslog_data );
        }
        function update_logqc2level($request_id,$userid,$pack_id){
                $inslog_data['pack_id']=$pack_id;
                $inslog_data['action']='QC2 Completed';                    
                $inslog_data['updated_by'] = $userid;
                $inslog_data['updated_on'] = date ( 'Y-m-d H:i:s' );
                $this->db->where('request_id',$request_id);
                $this->db->update ( DB_PREFIX .'loghistory', $inslog_data );
        }
        function get_verified_data($rid,$cid,$lid)
        {
                $save['request_id']=$rid;
                $save['level_id']=$cid;
                $save['check_id']=$lid;
                $this->db->select('vm.first_name as vmember,qc.first_name as qcmember,qc2.first_name as qc2member,vl.*');
                $this->db->where($save);
                $this->db->join(DB_PREFIX.'user vm','vl.verified_by=vm.id','left');
                $this->db->join(DB_PREFIX.'user qc','vl.qcverified_by=qc.id','left');
                $this->db->join(DB_PREFIX.'user qc2','vl.qc2verified_by=qc2.id','left');
               return  $this->db->get(DB_PREFIX.'verified_level vl')->row_array();
        }
        /*VM page get company name while listing */
        function get_verifiedcompany_data($reid,$chid,$leid)
        {
            $select= " a.company_name";
            $from = "   FROM " . DB_PREFIX . "employment a    
            LEFT JOIN " . DB_PREFIX . "ver_assign_rep b ON b.candidate_req_id = a.req_id
        Where b.candidate_req_id = ".$reid." and a.id = ".$chid." and b.check_id = ".$leid." and 1";
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->row_array();

        }
        /*VM page get college name while listing */
        function get_verifiedcollege_data($resid,$chkid,$levid)
        {
            $select= " a.collegename_add,a.affliated";
            $from = "   FROM " . DB_PREFIX . "education_details a    
            LEFT JOIN " . DB_PREFIX . "ver_assign_rep b ON b.candidate_req_id = a.request_id
        Where b.candidate_req_id = ".$resid." and a.id = ".$chkid." and b.check_id = ".$levid." and 1";
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->row_array();

        }
        function get_verifiedprofessional_data($reid,$chid,$leid)
        {
            $select= " a.company_name";
            $from = "   FROM " . DB_PREFIX . "professional_reference a    
            LEFT JOIN " . DB_PREFIX . "ver_assign_rep b ON b.candidate_req_id = a.request_id
        Where b.candidate_req_id = ".$reid." and a.id = ".$chid." and b.check_id = ".$leid." and 1";
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->row_array();

        }
        function get_qc2verified_data($rid,$cid,$lid)
        {
                $saves['request_id']=$rid;
                $saves['level_id']=$cid;
                $saves['check_id']=$lid;
                $this->db->select('vm.first_name as vmember,qc.first_name as qcmember,qc2.first_name as qc2member,vl.*');
                $this->db->where($saves);
                $this->db->join(DB_PREFIX.'user vm','vl.verified_by=vm.id','left');
                $this->db->join(DB_PREFIX.'user qc','vl.qcverified_by=qc.id','left');
                $this->db->join(DB_PREFIX.'user qc2','vl.qc2verified_by=qc2.id','left');
               return  $this->db->get(DB_PREFIX.'verified_level vl')->row_array();
        }
       
        function update_qclevel($request_id,$level_id,$check_id,$post,$status,$userid,$packid)
        {
                $save['qcfielddata']=json_encode($post);
                $save['qcstatus']=$status;
                $save['qcverified_by']=$userid;
                $save['qc_discrepency']=$post['status1'];
                $save['qc_date']=date('Y-m-d H:i:s');
                $save['auth_letter']=$post['auth_letter'];
                $save = $this->security->xss_clean($save);
                $this->db->where('request_id',$request_id);
                $this->db->where('check_id',$check_id);
                $this->db->where('level_id',$level_id);
                $this->db->where('package_id',$packid);
                $this->db->update(DB_PREFIX.'verified_level',$save);
        }
        function update_qc2level($request_id,$level_id,$check_id,$post,$status,$userid,$packid)
        {
            $sup=$this->db->query("select supplementary, qc2_date, f_report, reopen_by from ". DB_PREFIX ."verified_level 
                 where request_id=".$request_id." and level_id=".$level_id." and check_id=".$check_id." ")->row_array();

                //  $repDate=$this->db->query("select supplementary, qc2_date, f_report, reopen_by from ". DB_PREFIX ."client_request 
                //  where request_id=".$request_id)->row_array();

            $sql = "SELECT sum(r.no_checks) as chk_count
                        FROM " . DB_PREFIX ."request_check r 
                LEFT JOIN " . DB_PREFIX ."master_masterdata c on c.id=r.check_id
                WHERE r.request_id=".$request_id."  ";
                $query = $this->db->query( $sql );
            $totalchecks=$query->row_array();
    
            $sql = "SELECT count(candidate_req_id) as qc2_count
                        FROM " . DB_PREFIX ."ver_assign_rep 
                WHERE candidate_req_id=".$request_id." and qc2_verification=1 ";
                $query = $this->db->query( $sql );
            $v_count=$query->row_array();

            if( $totalchecks['chk_count'] == $v_count['qc2_count'] ){

                $sql = "SELECT sum(f_report) as f_report_count
                        FROM " . DB_PREFIX ."verified_level 
                WHERE request_id=".$request_id;
                $query = $this->db->query( $sql );
                $f_report=$query->row_array();

                if($f_report['f_report_count'] == 0){
                    $save['f_report']=1;   
                }

            }

            if($sup['supplementary']==1){
                if($sup['reopen_by'] ==17 && $sup['f_report'] ==1){
                    // $save['supplement_published_date']=date('Y-m-d H:i:s', strtotime($sup['qc2_date']));
                    // $save['qc2_date']=date('Y-m-d H:i:s', strtotime($sup['qc2_date']));
                    $save['qc2_date']=date('Y-m-d H:i:s');
                    // $save['qc2_date']=date('Y-m-d H:i:s', strtotime($repDate['final_report_published_date']));
                    
                }else{
                    $save['supplement_published_date']=date('Y-m-d H:i:s');
                    $save['qc2_date']=date('Y-m-d H:i:s');
                    // $save['supplementary']=2;
                }
                
                $save['supplementary']=2;
                
            }
            else{
                
                $save['qc2_date']=date('Y-m-d H:i:s');
            }
                $save['qc2fielddata']=json_encode($post);
                $save['qc2status']=$status;
                $save['qc2verified_by']=$userid;
                $save['qc2_dis']=$post['status1'];
                $save['auth_letter']=$post['auth_letter'];
                // Oct 26th 2023
                $origin_verification  = $post['origin_verification'];
                if(!empty($origin_verification))
                    {
                        $save['outside_india']=$origin_verification;   
                    }
                    else{
                        $save['outside_india']=0;
                    }
                $save = $this->security->xss_clean($save);
                $this->db->where('request_id',$request_id);
                $this->db->where('check_id',$check_id);
                $this->db->where('level_id',$level_id);
                $this->db->where('package_id',$packid);
                $this->db->update(DB_PREFIX.'verified_level',$save);

               
               $interim=$this->db->query("select * from ". DB_PREFIX ."verified_level 
                                                        where request_id=".$request_id." and qc2fielddata IS NOT NULL")->result_array();
                foreach($interim as $intval){
                $saveinterimold['request_id']=$intval['request_id'];
                $saveinterimold['check_id']=$intval['check_id'];
                $saveinterimold['level_id']=$intval['level_id'];
                $saveinterimold['pack_id']=$intval['package_id'];
                $saveinterimold['fielddata']=$intval['qc2fielddata'];
                if($sup['supplementary']==1 || $sup['supplementary']==2){
                    // $saveinterimold['created_date']=$save['supplement_published_date'];
                    if($sup['reopen_by'] ==17){
                        $saveinterimold['created_date']=$save['qc2_date'];    
                    }else{
                        $saveinterimold['created_date']=$save['supplement_published_date'];
                    }
                }
                else{
                    $saveinterimold['created_date']=$save['qc2_date'];
                }
                $saveinterimold = $this->security->xss_clean($saveinterimold);
                $this->db->insert(DB_PREFIX.'interim',$saveinterimold);
                }
        }
        function update_qc2publishlevel($request_id,$level_id,$check_id,$post,$status,$userid,$packid)
        {
            $sup=$this->db->query("select supplementary,qc2_date,f_report, reopen_by from ". DB_PREFIX ."verified_level 
                 where request_id=".$request_id." and level_id=".$level_id." and check_id=".$check_id." ")->row_array();

                // if($sup['supplementary']==2 || $sup['supplementary']==1){
                //     if($sup['reopen_by'] ==17){
                //         // $saveqc2['supplement_published_date']=date('Y-m-d H:i:s', strtotime($sup['qc2_date']));
                //         // $saveqc2['qc2_date']=date('Y-m-d H:i:s', strtotime($sup['qc2_date']));
                //         $saveqc2['qc2_date']=date('Y-m-d H:i:s');
                //     }else{
                //         if($sup['f_report']==1){
                //             $saveqc2['supplement_published_date']=date('Y-m-d H:i:s');
                //             $saveqc2['qc2_date']=date('Y-m-d H:i:s');
                //             $saveqc2['supplementary']=3;
                //         }else{
                //             $saveqc2['qc2_date']=date('Y-m-d H:i:s');
                //             $saveqc2['supplementary']=0;
                //             $saveqc2['supplement_published_date']='Null';
                //         }
                        
                //     }
                    
                // // $saveqc2['supplementary']=3;
                
                // }

                $this->db->select('final_report, final_report_published_date');
                $finalReport=$this->db->get_where('dcode_client_request',array('request_id'=> $request_id ))->row_array();

                if($sup['reopen_by'] !=17){
                    if($finalReport['final_report'] == 0){
                        if($sup['f_report']==1){
                            $saveqc2['qc2_date']=date('Y-m-d H:i:s');
                            $saveqc2['supplement_published_date']=date('Y-m-d H:i:s');
                        }
                    }
                    else{
                        if($sup['f_report']==1){
                            $saveqc2['supplement_published_date']=date('Y-m-d H:i:s');
                            $saveqc2['qc2_date']=date('Y-m-d H:i:s');
                            $saveqc2['supplementary']=3;
                        }else if($sup['supplementary']==2){
                            $saveqc2['supplement_published_date']=date('Y-m-d H:i:s');
                            $saveqc2['qc2_date']=date('Y-m-d H:i:s');
                            $saveqc2['supplementary']=3;
                        }
                    }
                }
                else{
                    // Change made on 14-Nov-2024 By Chandan for Final check reopen.
                    if($sup['f_report']==1){
                        $saveqc2['qc2_date']=$finalReport['final_report_published_date'];
                    }else{
                        $saveqc2['qc2_date']=date('Y-m-d H:i:s');
                    }
                }
                $saveqc2['qc2fielddata']=json_encode($post);
                $saveqc2['qc2status']=$status;
                $saveqc2['qc2verified_by']=$userid;
                $saveqc2['qc2_dis']=$post['status1'];
                //26/oct/2023
                if(!empty($post['origin_verification']))
                    $saveqc2['outside_india'] = $post['origin_verification'];
                else
                    $saveqc2['outside_india'] = 0; 
                $saveqc2 = $this->security->xss_clean($saveqc2);
                $this->db->where('request_id',$request_id);
                $this->db->where('check_id',$check_id);
                $this->db->where('level_id',$level_id);
                $this->db->update(DB_PREFIX.'verified_level',$saveqc2);

                $interim=$this->db->query("select * from ". DB_PREFIX ."verified_level 
                                                        where request_id=".$request_id." and qc2fielddata IS NOT NULL")->result_array();
            foreach($interim as $intval){
            $saveinterimold['request_id']=$intval['request_id'];
            $saveinterimold['check_id']=$intval['check_id'];
            $saveinterimold['level_id']=$intval['level_id'];
            $saveinterimold['pack_id']=$intval['package_id'];
            $saveinterimold['fielddata']=$intval['qc2fielddata'];
            if($sup['supplementary']==2 || $sup['supplementary']==1){
                if($sup['reopen_by'] ==17){
                    $saveinterimold['created_date']=$saveqc2['qc2_date'];    
                }else{
                    $saveinterimold['created_date']=$saveqc2['supplement_published_date'];
                }
                

            }
            else{
                $saveinterimold['created_date']=$saveqc2['qc2_date'];
            }
            $saveinterimold = $this->security->xss_clean($saveinterimold);
            $this->db->insert(DB_PREFIX.'interim',$saveinterimold);
            }
        }
        function get_qc2list_verified($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {
        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc2_status,vs.qc2_discrapancy,vl1.level_id,vl1.check_id,vl1.qc2_date,md1.name as checkname,ar.pack_id,ar.qc_2_verification,ar.qc2_report_publish,o.org_name,d.office_name as parent_office,p.office_name as sub_office,cr.case_no,vl1.qc2_dis,concat_ws(' ',us.first_name,us.last_name) as qc2name,vl1.v_date,cr.final_report_published_date,cr.final_report,vl1.supplement_published_date,ar.count_of_chk as chk ";
     $from = "   FROM " . DB_PREFIX . "verification_request a 
     LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
     LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
     LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
     LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
     LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation
     LEFT JOIN " . DB_PREFIX . "office p ON p.id=cr.sub_office
      LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
     LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
     LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id
     LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=ar.candidate_req_id
     LEFT JOIN " . DB_PREFIX . "master_masterdata md1 ON md1.id=vl1.check_id
     LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id=a.request_id
     LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
      JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
     where 1  and a.assignee_status=1 AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id ";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        if($this->session->userdata('role_id')==12)
                $from .=" and b.organization=".$this->session->userdata('organization');
                if($this->session->userdata('role_id')==13)
                $from .=" and b.parent_office=".$this->session->userdata('parent_office');
        $from .=" and ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish = 1 else ar.qc2_verification = 1 END )";
        if ($type == 'count') 
            $select = "count(DISTINCT(ar.rep_id)) as count ";
        if ($pg >= 0 && $type <> 'count' && $_POST['export_btn'] != 'Export') { 
                $from .= " group by ar.rep_id order by $sBy desc,vl1.supplement_published_date $sOrder limit $pg," . $limit;
        }
        if($_POST['export_btn'] == 'Export'){
            $from .= " group by ar.rep_id order by vl1.qc2_date desc,vl1.supplement_published_date desc ";
        }
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
    //     $str = $this->db->last_query();
    //  echo "<pre>";
    //  print_r($str);
    // exit;
        return $query->result_array();
    }
    function get_interim($rid,$chid,$lid,$pkid){
                $this->db->select('*');
                $this->db->where('request_id',$rid);
                $this->db->where('check_id',$chid);
                $this->db->where('level_id',$lid);
                $this->db->where('pack_id',$pkid);
               return  $this->db->get(DB_PREFIX.'interim')->row_array();
    }
    function get_status_name($rid,$lid,$chid,$field,$parent=false)
    {
                if($parent)
                $this->db->select('md.name,m.name as parent');
                else
                $this->db->select('md.name');
                $this->db->join(DB_PREFIX.'verified_level',$field.'=md.id','left');
                if($parent)
                $this->db->join(DB_PREFIX.'master_masterdata m','m.id=md.parent','left');
                $this->db->where('request_id',$rid);
                $this->db->where('level_id',$chid);
                $this->db->where('check_id',$lid);
                return $this->db->get(DB_PREFIX.'master_masterdata md')->row_array();
    }
    function get_leveldetails($request_id,$level_id,$table,$field='request_id')
    {
                $this->db->where('id',$level_id);
                $this->db->where($field,$request_id);
                return $this->db->get(DB_PREFIX.''.$table)->result_array();
    }
        function get_status($id,$parent=false)
        {
                if($parent)
                $this->db->select('md.name,m.name as parent');
                else
                $this->db->select('md.name,md.id');
                if($parent)
                $this->db->join(DB_PREFIX.'master_masterdata m','m.id=md.parent','left');
                $this->db->where('md.id',$id);
                return $this->db->get(DB_PREFIX.'master_masterdata md')->row_array();
        }
        function get_parent_status()
        {
            $num = array(107,110,111,519);

                $this->db->where('parent',0);
                $this->db->where('key','status');
                $this->db->where_in('id',$num);
                return $this->db->get(DB_PREFIX.'master_masterdata md')->result_array();
        }

        function get_repfinal($request_id)
        {
            $this->db->select('f_report');
            $this->db->where('request_id',$request_id);
            $this->db->where('f_report',1);
            return $this->db->get(DB_PREFIX.'verified_level')->row_array();
        }

        function get_repsuppl($request_id)
        {
            $this->db->select('supplementary');
            $this->db->where('request_id',$request_id);
            $this->db->where('supplementary',3);
            return $this->db->get(DB_PREFIX.'verified_level')->row_array();
        }

        function get_joiners($caseNo)
        {
            $this->db->select('*');
            $this->db->where('jd_case_no',$caseNo);
            return $this->db->get(DB_PREFIX.'joiners_data')->row_array();

            $select = " * ";
            $from = " FROM " . DB_PREFIX . "joiners_data where case_no like '%".$caseNo."'";      
            $sql = "SELECT " . $select . "" . $from;
            $query = $this->db->query($sql);
            return $query->row_array();
        }

        function revert_report($cond)
        {

                $this->db->select('qc_rcomments , qc_revert_reason');
                $this->db->where($cond);
                return $this->db->get(DB_PREFIX.'ver_assign_rep')->row_array();
        }
        function qcrevert_report($cond)
        {
                $this->db->select('qc2_rcomments,qc_rcomments,qc_revert_reason,qc2_revert_reason');
                $this->db->where($cond);
                return $this->db->get(DB_PREFIX.'ver_assign_rep')->row_array();
        }
      
        function check_report($cond)
        {       
            
                $this->db->where($cond);
                return $this->db->get(DB_PREFIX.'ver_assign_rep')->row_array();
        }
        function check_revertname($request_id,$check_id,$level_id){
           $verify_qc=$this->vm->verify_qc($request_id);
      if($verify_qc[0]['dedicated_qc']==17){
            $select = "concat_ws(' ',b.first_name,b.middle_name,b.last_name) as name";
            $from = "      FROM " . DB_PREFIX ."ver_assign_rep a
                        LEFT JOIN " . DB_PREFIX ."user b on b.id = a.qc2_revert_by
                        WHERE a.candidate_req_id= ".$request_id." and a.check_id=".$check_id." and a.level_id=".$level_id."";
               $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
    }else{
        $select = "concat_ws(' ',b.first_name,b.middle_name,b.last_name) as name";
            $from = "      FROM " . DB_PREFIX ."ver_assign_rep a
                        LEFT JOIN " . DB_PREFIX ."user b on b.id = a.qc_revert_by
                        WHERE a.candidate_req_id= ".$request_id." and a.check_id=".$check_id." and a.level_id=".$level_id."";
               $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        
    }
    return $query->row_array();
    }
    function check_qcrevertname($request_id,$check_id,$level_id){

            $select = "concat_ws(' ',b.first_name,b.middle_name,b.last_name) as name";
            $from = "      FROM " . DB_PREFIX ."ver_assign_rep a 
                        LEFT JOIN " . DB_PREFIX ."user b on b.id = a.qc2_revert_by
                        WHERE a.candidate_req_id= ".$request_id." and a.check_id=".$check_id." and a.level_id=".$level_id."";
               $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->row_array();
                
    }
        function get_pendingcheck($check_id)
    {
        $res1 = $this->db->query("select count(a.rep_id) as vchk from dcode_ver_assign_rep a
            JOIN ".DB_PREFIX ."client_request c ON c.request_id = a.candidate_req_id
            JOIN ".DB_PREFIX ."user u ON u.id = c.user_id
            WHERE a.check_id =".$check_id." AND u.active_status != 3  ")->result_array();
        
        $res2 = $this->db->query("select SUM(a.no_checks) as rchk,check_id from ".DB_PREFIX ."request_check a 
         JOIN ".DB_PREFIX ."submit_cv b ON b.request_id=a.request_id 
         JOIN ".DB_PREFIX ."client_request c ON c.request_id = a.request_id
         JOIN ".DB_PREFIX ."user u ON u.id = c.user_id
         Where a.check_id = ".$check_id." AND b.verification_status=1 AND u.active_status != 3 ")->result_array(); 

        $res3 = $this->db->query("select count(req_id) as ecount from ".DB_PREFIX ."employment e 
            JOIN ".DB_PREFIX ."request_check ON request_id=req_id 
        Where check_id > 94 AND description = ".$check_id." AND no_checks=0 ")->row_array();
        
        $res4 = $this->db->query("select SUM(a.no_checks) as pcount,check_id from ".DB_PREFIX ."request_check a 
         JOIN ".DB_PREFIX ."submit_cv b ON b.request_id=a.request_id
         JOIN ".DB_PREFIX ."client_request c ON c.request_id = a.request_id
         JOIN ".DB_PREFIX ."user u ON u.id = c.user_id
          Where a.description = ".$check_id." AND b.verification_status=1 and a.check_id > 94 
          AND u.active_status != 3 ")->row_array(); 
        if($res4['pcount']>0) $pcount=$res4['pcount']; else $pcount=0;
        if($res3['ecount']>0) $count=$res3['ecount']; else $count=0;

        $result=0; $counts=0;
        $result = ($res2[0]['rchk'] + $count + $pcount) - $res1[0]['vchk'];
     if($result>0) $counts=$result; else $counts=0;
        return $counts;
    }
   function documentsup($req_id){
        $this->db->select('a.req_id,a.upload_file,a.file_name')
                ->from(DB_PREFIX . 'candidate_upload_files as a')
                ->where('a.req_id', $req_id);
                return $this->db->get()->result_array();
     } 
   function revert_documentsup($req_id =null,$check_id =null,$level_id =null) {
        $this->db->select('a.upload_document,a.fielddata');
                $this->db->from(DB_PREFIX . 'verified_level as a');
                $this->db->where('a.request_id', $req_id);
                $this->db->where('a.check_id', $check_id);
                $this->db->where('a.level_id', $level_id);
                return $this->db->get()->result_array();
   }  
   function all_devices(){
    $this->db->select('name,seqid')
            ->from(DB_PREFIX . 'master_masterdata')
            ->where('key', 'Revert_reason');
    return $this->db->get()->result_array();
}
function get_assignee_list_super($values) {
        if($values == '1')
        $cond="(u.role_id,'2,12,13') ";
        else if($values == '2')
        $cond="(u.role_id,'2,12,13') ";
        else if($values == '3') 
        $cond="(u.role_id,'2,3')";
        else
        $cond="(u.role_id,'2,12,13') ";
        
                $sql = "SELECT c.id as assignee_id, concat_ws(' ', first_name,middle_name,last_name) as name
                        FROM " . DB_PREFIX ."organisation a 
                        left join " . DB_PREFIX ."user c on c.organization = a.id
                        left join " . DB_PREFIX ."users_roles u on u.user_id = c.id
                        left join " . DB_PREFIX ."client_request r on r.user_id = c.id
                        WHERE a.user_type in (1,2) and FIND_IN_SET ".$cond."";
                $query = $this->db->query( $sql );
                return $query->result_array();
        } 
        /* check qc verification*/ 
 function verify_qc($request_id){
    $sql="SELECT dedicated_qc FROM " . DB_PREFIX . "organisation o
    left join " . DB_PREFIX . "client_request c on  o.id=c.organisation where c.request_id=".$request_id;
        $dedicated_qc=$this->db->query($sql)->result_array();
        return $dedicated_qc;

 } 

 function get_canname ($request_id) { 

       
                $select = "a.request_id,a.candidate_name,a.case_no";
                        
                                 $from = " FROM " . DB_PREFIX . "client_request a 
                                 where 1  and a.request_id=".$request_id;
                           
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }  
  function get_verifiedlevelstatus($id,$check_id,$level_id)
    {
     $sql="SELECT va.check_id,va.level_id,fielddata,qcfielddata,qc2fielddata,vr.candidate_name,vl.qc2_verification,vl.qc2_report_publish  FROM ".DB_PREFIX ."ver_assign_rep vl 
           LEFT JOIN ".DB_PREFIX."client_request vr ON vr.request_id=vl.candidate_req_id
           LEFT JOIN ".DB_PREFIX."verified_level va ON va.request_id=vl.candidate_req_id
           WHERE va.request_id=".$id." and va.check_id=" .$check_id." and va.level_id=" .$level_id."";
        
          $result= $this->db->query($sql);
           return  $result->row_array();
    }   

  function countsofchk($request_id,$check_id,$level_id){
        $select = " d.candidate_name as candidatename,p.office_name as parent_office, br.office_name as office_name,br.id as brid,su.office_name as sub_office,su.id as subid,c.name as checkname,o.org_name,o.id as org_id,a.count_of_chk as chk,b.user_image,d.case_no,d.client_ref_number,d.deadline_from,d.case_recieved_date,d.dataentry_by,a.level_id";
        $from = "  from dcode_ver_assign_rep a
            LEFT JOIN dcode_personal_details b ON b.user_id = a.candidate_req_id
            LEFT JOIN  dcode_master_masterdata c ON c.id = a.check_id
            LEFT JOIN  dcode_client_request d ON d.request_id = b.user_id
            LEFT JOIN dcode_office p ON p.id = d.parent_office
            LEFT JOIN dcode_office br ON br.id = d.office
            LEFT JOIN  dcode_office su ON su.id = d.sub_office
            LEFT JOIN  dcode_organisation o ON o.id = p.parentoffice_id
        where a.candidate_req_id=".$request_id." and a.check_id=".$check_id." and a.level_id=".$level_id."";
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();

                     
        }   

        function getallchecks($rid)
        {
            //25/01/2024
       $sql = "SELECT a.request_id,c.name,a.check_id,a.no_checks as chk_count,a.description
                        FROM " . DB_PREFIX ."request_check a
            LEFT JOIN " . DB_PREFIX ."master_masterdata c on c.id=a.check_id
                        WHERE a.request_id=".$rid." ";

                $query = $this->db->query( $sql );
                return $query->result_array();
        }
      
      /* personal details added documents*/
       function deo_add_doc($request_id) {
       $select = " document_name,additional_doc";
       $from = " from ".DB_PREFIX."personal_additional_doc where request_id=".$request_id." and check_id=0 and status=1" ;
       $sql = "SELECT " . $select . "" . $from;
       $query = $this->db->query($sql);
       return $query->result_array();
   }

   function getassignstatus($request_id,$check_id,$level_id){
        $sql = "SELECT b.first_name,a.candidate_req_id
                        FROM " . DB_PREFIX ."ver_assign_rep a
                        LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.team_mem_id
                        WHERE a.candidate_req_id=". $request_id ." and a.level_id=". $level_id ." and a.check_id=" .$check_id ;
                $query = $this->db->query( $sql );
                return $query->result_array();
    }
    function getvmreassignchkDetails($request_id,$check_id,$level_id){
        $select="a.check_id,a.level_id,c.name,a.candidate_req_id,a.count_of_chk";
        $from = "   FROM " . DB_PREFIX . "ver_assign_rep a   
                      LEFT JOIN ".DB_PREFIX ."master_masterdata c on c.id = a.check_id
                    Where a.candidate_req_id = ".$request_id." and a.check_id=".$check_id." and a.level_id=".$level_id." ";
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->row_array(); 
    }
    function check_revertdate($request_id,$check_id,$level_id)
    {
        $verify_qc=$this->vm->verify_qc($request_id);
        if($verify_qc[0]['dedicated_qc']==17){
        $this->db->select('qc2_revert_date as date');
        }else{
        $this->db->select('qc_revert_date as date');
        }
        $this->db->where('candidate_req_id',$request_id);
        $this->db->where('check_id',$check_id);
        $this->db->where('level_id',$level_id);
        return $this->db->get(DB_PREFIX.'ver_assign_rep')->row_array();
    }
    function check_qc2revertdate($condition)
    {
        $this->db->select('qc2_revert_date as date');
        $this->db->where($condition);
        return $this->db->get(DB_PREFIX.'ver_assign_rep')->row_array();
    }

    function expensedetails($id){
    $sql="SELECT name FROM ".DB_PREFIX."master_masterdata a WHERE a.id=".$id." and a.key='expences' ";
        $result= $this->db->query($sql);
         if(!empty($result))
        return $result->row_array();
    }
    function get_previous_eduverification($pg = 0, $limit = 15, $sBy = '', $sOrder = 'desc', $searchCond = '',$type=''){
         $level_id = ($_REQUEST['level_id']) ? $_REQUEST['level_id'] : '';

        $select = "b.request_id,b.check_id,b.level_id,b.fielddata,a.collegename_add,a.affliated,b.vmexpenses,b.package_id";
             $from = "  FROM " . DB_PREFIX . "education_details a
             JOIN " . DB_PREFIX . "verified_level b ON b.check_id = a.checkid and b.level_id=a.id
             
                        where 1 ";
          if($level_id){
             $from .= " and a.id != ".$level_id." ";
         }     
            
        if ($searchCond) {
            $from .= " and $searchCond";
        }
                if ($type == 'count') {
                    $select = " count(b.request_id) as count";
                }
               
                if ($pg >= 0 && $type <> 'count') {
                       $from .= " order by $sBy $sOrder limit $pg," . $limit;
                }
       
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function get_previous_empverification($pg = 0, $limit = 15, $sBy = '', $sOrder = 'desc', $searchCond = '',$type=''){
        $level_id = ($_REQUEST['level_id']) ? $_REQUEST['level_id'] : '';
        $select = "b.request_id,b.check_id,b.level_id,b.fielddata,a.company_name,b.vmexpenses,b.package_id";
             $from = "  FROM " . DB_PREFIX . "employment a
              JOIN " . DB_PREFIX . "verified_level b ON b.check_id = a.checkid and b.level_id=a.id      
             
                        where 1 ";
         if($level_id){
             $from .= " and a.id !=".$level_id." ";
         }      
        if ($searchCond) {
            $from .= " and $searchCond";
        }

                if ($type == 'count') {
                    $select = " count(b.request_id) as count";
                }
               
                if ($pg >= 0 && $type <> 'count') {
                       $from .= " order by $sBy $sOrder limit $pg," . $limit;
                }
       
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function get_verifierfielddata($req_id,$chk_id,$level_id){
        $this->db->select('fielddata');
        $this->db->where('request_id',$req_id);
        $this->db->where('check_id',$chk_id);
        $this->db->where('level_id',$level_id);
        return $this->db->get(DB_PREFIX.'verified_level')->result_array();
    }
    function deoname($req_id)
    {
        $this->db->select(" CONCAT_WS(' ', u.first_name, u.last_name) as name ");
        $this->db->join(DB_PREFIX.'user u','u.id=c.operator_submited_by','left');
        $this->db->where('c.request_id',$req_id);
        return $this->db->get(DB_PREFIX.'submit_cv c')->row_array();
    }
    
      function   get_no_working_days($id){

       $sql =  " select ((5 * (DATEDIFF(date(a.case_accepted_date), date(s.client_submit_date)) DIV 7) + MID('0123444401233334012222340111123400012345001234550', 7 * WEEKDAY(date(s.client_submit_date)) + WEEKDAY(date(a.case_accepted_date)) + 1, 1)) - (SELECT COUNT(*) FROM dcode_master_holidays WHERE dcode_master_holidays.status=1 and holiday_date >= date(s.client_submit_date) and holiday_date <= date(a.case_accepted_date))) as accept_case_tat from dcode_client_request a left join dcode_submit_cv s ON s.request_id=a.request_id where a.request_id=  " .$id."  ";

            $query = $this->db->query($sql);
             $working_day =   $query->result_array();
              return $working_day[0];
   }

    function  get_no_day_deo($id) {

        $sql =  " select ((5 * (DATEDIFF(date(a.verification_date ), date(a.operator_submit_date  )) DIV 7) + MID('0123444401233334012222340111123400012345001234550', 7 * WEEKDAY(date(a.operator_submit_date  )) + WEEKDAY(date(a.verification_date )) + 1, 1)) - (SELECT COUNT(*) FROM dcode_master_holidays WHERE dcode_master_holidays.status=1 and holiday_date >= date(a.operator_submit_date  ) and holiday_date <= date(a.verification_date  ))) as accept_case_tat from  dcode_submit_cv a where a.request_id=  " .$id."  ";

               $query = $this->db->query($sql);
               $working_day =   $query->result_array();
              return   $working_day[0];
    }

    function  get_no_day_vs_allot($request_id , $check_id , $level_id){
     
        $sql =  " select ((5 * (DATEDIFF(date(a.deadline_from), date(s.verification_date)) DIV 7) + MID('0123444401233334012222340111123400012345001234550', 7 * WEEKDAY(date(s.verification_date)) + WEEKDAY(date(a.deadline_from)) + 1, 1)) - (SELECT COUNT(*) FROM dcode_master_holidays WHERE dcode_master_holidays.status=1 and holiday_date >= date(s.verification_date) and holiday_date <= date(a.deadline_from))) as accept_case_tat from dcode_verification_request a left join dcode_submit_cv s ON s.request_id=a.request_id where a.request_id=  " .$request_id." and a.check_id= ".$check_id." and a.level_id = ".$level_id." ";

               $query = $this->db->query($sql);
               $working_day =   $query->result_array();
                return $working_day[0];
    }

     function get_no_day_taken_vm($request_id , $check_id , $level_id){


          $sql =  " select ((5 * (DATEDIFF(date(a.v_date), date(s.deadline_from)) DIV 7) + MID('0123444401233334012222340111123400012345001234550', 7 * WEEKDAY(date(s.deadline_from)) + WEEKDAY(date(a.v_date)) + 1, 1)) - (SELECT COUNT(*) FROM dcode_master_holidays WHERE dcode_master_holidays.status=1 and holiday_date >= date(s.deadline_from) and holiday_date <= date(a.v_date))) as accept_case_tat from dcode_verified_level a left join dcode_verification_request s ON s.request_id=a.request_id and s.check_id = a.check_id  and s.level_id = a.level_id  where a.request_id=  " .$request_id." and a.check_id= ".$check_id."
           and a.level_id = ".$level_id." ";

               $query = $this->db->query($sql);
                $working_day =   $query->result_array();
                 return $working_day[0];
      }

      function get_no_day_taken_qc2($request_id , $check_id , $level_id){

           $sql =  " select ((5 * (DATEDIFF(date(a.qc2_date), date(a.v_date)) DIV 7) + MID('0123444401233334012222340111123400012345001234550', 7 * WEEKDAY(date(a.v_date)) + WEEKDAY(date(a.qc2_date)) + 1, 1)) - (SELECT COUNT(*) FROM dcode_master_holidays WHERE dcode_master_holidays.status=1 and holiday_date >= date(a.v_date) and holiday_date <= date(a.qc2_date))) as accept_case_tat from dcode_verified_level a  where a.request_id=  " .$request_id."  and a.check_id = ".$check_id." and  a.level_id = ".$level_id."";

               $query = $this->db->query($sql);
               $working_day =   $query->result_array();              
               return $working_day[0];     
        } 

        function vm_submitted_redreport($req_id,$levelid,$checkid){

          
        
              $sql = "SELECT cr.case_no,o.org_name,concat_ws(' ', qcc.first_name,qcc.last_name) as qcname,qcc.email as qc_email,concat_ws(' ', qcc2.first_name,qcc2.last_name) as qc2name,qcc2.email as qc2_email,concat_ws(' ', u.first_name,u.last_name) as cand_name , ck.name as check_name

                        FROM " . DB_PREFIX ."verified_level a 
                      left join " . DB_PREFIX ."client_request cr on cr.request_id=a.request_id
                      left join " . DB_PREFIX ."organisation o on o.id=cr.organisation
                      left join " . DB_PREFIX ."master_masterdata ck on ck.id=a.check_id
                      left join " . DB_PREFIX ."qc_request qc on a.request_id=qc.request_id
                    left join " . DB_PREFIX ."qc2_request qc2 on a.request_id=qc2.request_id
                    left join " . DB_PREFIX ."user qcc on qcc.id=qc.assignee_id
                    left join " . DB_PREFIX ."user qcc2 on qcc2.id=qc2.assignee_id
                    left join " . DB_PREFIX ."user u on u.id=cr.user_id  

                 WHERE a.request_id=".$req_id." and qcc2.status = 1 and a.check_id=".$checkid." and a.level_id=".$levelid ."";

                $query = $this->db->query( $sql ); 
                return  $query->result_array();

          


        } 

        function get_revert_list($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {
        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, r.reverted_date, r.comments,r.revertreason,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,ar.qc_2_verification,ar.qc2_report_publish,vl1.qc2status,vl1.v_date,vl1.qc_date,concat_ws(' ',us.first_name,us.last_name) as qcname,vl1.supplementary,concat_ws(' ',vm.first_name,vm.last_name) as vmname,ar.qc2_revert_date";

         $from = "   FROM " . DB_PREFIX . "verification_request a 
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
         LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation
         LEFT JOIN " . DB_PREFIX . "revert_history r ON r.request_id = cr.request_id
         LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
         LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id 
         LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
         LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
         LEFT JOIN " . DB_PREFIX . "user vm ON vm.id=vl1.verified_by
          JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
         where 1  and a.assignee_status=1 and ar.verify_status in (111,110,519) AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id and qc1_verification=1 and ((ar.qc2_verification = 0 and ar.qc1_verification=1 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 2 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 2 and ar.qc1_assign_revert=1 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 0 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2))) ";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        
        /* qc2 verification*/
        if($this->session->userdata('role_id')==17 ){
            $from .="  and ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish != 2 else ar.qc2_report_publish != 1 END ) and qc.assignee_id =".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and qc.assignee_id != 0 and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }
        else{
            $from .= " and qc.assignee_id != 0 ";
        }
        
                
               if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count ";
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }

        function get_revert_closed($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {

         $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,ar.qc_2_verification,ar.qc2_report_publish,vl1.qc2status,vl1.v_date,vl1.qc_date,concat_ws(' ',us.first_name,us.last_name) as qc2name,vl1.supplementary,concat_ws(' ',vm.first_name,vm.last_name) as vmname,ar.qc2_revert_date";

         $from = "   FROM " . DB_PREFIX . "verification_request a 
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
         LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation

         LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
         LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id 
         LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
         LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
         LEFT JOIN " . DB_PREFIX . "user vm ON vm.id=vl1.verified_by
          JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
         where 1  and a.assignee_status=1 and ar.verify_status in (111,110,519) AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id and qc1_verification=1 and ((ar.qc1_assign_revert = 1 and ar.qc2_verification = 0 and (vl1.supplementary = 0 || vl1.supplementary = 2)) || (ar.qc1_assign_revert=1 and ar.qc_2_verification=0 and (vl1.supplementary = 0 || vl1.supplementary = 2))) ";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        
        /* qc2 verification*/
        if($this->session->userdata('role_id')==17 ){
            $from .="  and ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish != 2 else ar.qc2_report_publish != 1 END ) and qc.assignee_id =".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and qc.assignee_id != 0 and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }
        else{
            $from .= " and qc.assignee_id != 0 ";
        }
                
               if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count ";
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    function get_reopen_closed($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {

         $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,ar.qc_2_verification,ar.qc2_report_publish,ar.reopen_revert_qc2,vl1.qc2status,vl1.v_date,vl1.qc_date,concat_ws(' ',us.first_name,us.last_name) as qc2name,vl1.supplementary,concat_ws(' ',vm.first_name,vm.last_name) as vmname,ar.qc2_revert_date";

         $from = "   FROM " . DB_PREFIX . "verification_request a 
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
         LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation

         LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
         LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id 
         LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
         LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
         LEFT JOIN " . DB_PREFIX . "user vm ON vm.id=vl1.verified_by
          JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
         where 1  and a.assignee_status=1 and ar.verify_status in (111,110,519) AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id and ar.qc1_verification=1 and ar.qc2_verification=0 and ar.qc_revert_request=1 and ar.qc2_revert_request=1 and ar.qc1_assign_revert=1 and ar.qc_2_verification=0 and ar.vm_assigned_qc=1 and vl1.supplementary=1 and  ar.reopen_revert_qc2=0 ";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        
        /* qc2 verification*/
        if($this->session->userdata('role_id')==17 ){
            $from .=" and qc.assignee_id =".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and qc.assignee_id != 0 and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }
        else{
            $from .= " and qc.assignee_id != 0 ";
        }
        
                
               if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count ";
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    function get_newcaselist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') {


         $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,ar.qc_2_verification,ar.qc2_report_publish,vl1.qc2status,vl1.v_date,vl1.qc_date,concat_ws(' ',us.first_name,us.last_name) as qc2name,vl1.supplementary,concat_ws(' ',vm.first_name,vm.last_name) as vmname,ar.qc2_revert_date";

         $from = "   FROM " . DB_PREFIX . "verification_request a 
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
         LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation

         LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
         LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id 
         LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
         LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
         LEFT JOIN " . DB_PREFIX . "user vm ON vm.id=vl1.verified_by
          JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
         where 1  and a.assignee_status=1 and ar.verify_status in (111,110,519)AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id and qc1_verification=1  and (ar.qc2_verification = 0 and ar.qc1_verification=1 and ar.qc2_revert_request = 0 and vl1.qc2status!=107)";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        
        /* qc2 verification*/
        if($this->session->userdata('role_id')==17 ){
            $from .="  and ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish != 2 else ar.qc2_report_publish != 1 END ) and qc.assignee_id =".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and qc.assignee_id != 0 and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }
        else{
            $from .= " and qc.assignee_id != 0 ";
        }
                
               if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count ";
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();

    }

    function get_reopencheck($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') {


         $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,ar.qc_2_verification,ar.qc2_report_publish,vl1.qc2status,vl1.v_date,vl1.qc_date,concat_ws(' ',us.first_name,us.last_name) as qc2name,vl1.supplementary,concat_ws(' ',vm.first_name,vm.last_name) as vmname,ar.qc2_revert_date";

         $from = "   FROM " . DB_PREFIX . "verification_request a 
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
         LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation

         LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
         LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id 
         LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
         LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
         LEFT JOIN " . DB_PREFIX . "user vm ON vm.id=vl1.verified_by
          JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
         where 1  and a.assignee_status=1 and ar.verify_status in (111,110,519)AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id and qc1_verification=1  and  (ar.qc2_verification = 1 and ar.qc2_report_publish=2 and ar.qc1_assign_revert=0)";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        
        /* qc2 verification*/
        if($this->session->userdata('role_id')==17 ){
            $from .="  and ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish != 2 else ar.qc2_report_publish != 1 END ) and qc.assignee_id =".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and qc.assignee_id != 0 and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }
        else{
            $from .= " and qc.assignee_id != 0 ";
        }
                
               if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count ";
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();

    }

    function get_qc2newcaselist($pg = 0, $limit = 15, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')    {

        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,r.candidate_name,p.office_name as parent_office,s.office_name as sub_office,o.org_name,r.case_no,min(vl1.v_date) as vm_date ,q.assignee_by ";
         $from = "   FROM " . DB_PREFIX . "client_request r  
         JOIN  " . DB_PREFIX . "verification_request a ON a.request_id=r.request_id and a.qc_assignee_status=1
         JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id=a.request_id
         JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = r.request_id and ar.qc1_verification=1
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=ar.candidate_req_id and vl1.check_id=ar.check_id and vl1.level_id=ar.level_id
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "office c ON c.id=r.office
         LEFT JOIN " . DB_PREFIX . "office p ON p.id=r.parent_office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id=r.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=r.organisation
         LEFT JOIN " . DB_PREFIX . "qc2_request q ON q.request_id=r.request_id
          JOIN " . DB_PREFIX . "user t ON t.id = r.user_id and t.active_status != 3
         where 1 and ar.verify_status in (111,110,519) and a.qc_assignee_status = 1 and q.qc2_assignee_status IS NULL   ";
        if($this->session->userdata('role_id')==17){
        $from .=" and ar.qc1_verification=1 ";
        }           

        if ($searchCond) {
        $from .= " and $searchCond ";
        } 
        if($this->session->userdata('role_id')==4){
        $from .=" and o.dedicated_qc=4 ";
        }
        if ($type == 'count') {
        $select = "count(DISTINCT(a.request_id)) as count "; 
        }

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " group by a.request_id order by $sBy $sOrder limit $pg," . $limit;
        }
       
        $sql = "SELECT " . $select . "" . $from;  
        $query = $this->db->query($sql); 
        return $query->result_array();
    }

      function get_qc2acclist($pg = 0, $limit = 15, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')    {

        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,r.candidate_name,p.office_name as parent_office,s.office_name as sub_office,o.org_name,r.case_no,min(vl1.v_date) as vm_date ,q.assignee_by ";
         $from = "   FROM " . DB_PREFIX . "client_request r  
         JOIN  " . DB_PREFIX . "verification_request a ON a.request_id=r.request_id and a.qc_assignee_status=1
         JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id=a.request_id
         JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = r.request_id and ar.qc1_verification=1
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=ar.candidate_req_id and vl1.check_id=ar.check_id and vl1.level_id=ar.level_id
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "office c ON c.id=r.office
         LEFT JOIN " . DB_PREFIX . "office p ON p.id=r.parent_office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id=r.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=r.organisation
         LEFT JOIN " . DB_PREFIX . "qc2_request q ON q.request_id=r.request_id
          JOIN " . DB_PREFIX . "user t ON t.id = r.user_id and t.active_status != 3
         where 1 and ar.verify_status in (111,110,519) and  (( select count(vl.request_id) FROM dcode_verified_level vl LEFT JOIN dcode_ver_assign_rep ar ON ar.candidate_req_id = vl.request_id and vl.check_id = ar.check_id AND vl.level_id = ar.level_id where vl.request_id = a.request_id and CASE WHEN o.dedicated_qc = 17 THEN (ar.verify_status IN (111,110,519) AND ar.vm_assigned_qc=1 ) ELSE ( (ar.verify_status IN (111,110,519)) AND vl.qcstatus IN (111,110,519) ) END ) = (select sum(no_checks) FROM dcode_request_check re where re.request_id=a.request_id )) and ((select sum(no_checks) FROM dcode_request_check re where re.request_id=a.request_id ) != (select count(va.rep_id) FROM dcode_ver_assign_rep va LEFT JOIN dcode_verified_level vl ON va.candidate_req_id = vl.request_id and vl.check_id = va.check_id AND vl.level_id = va.level_id where va.candidate_req_id = a.request_id and va.qc2_report_publish=1)) and a.qc_assignee_status = 1 and q.qc2_assignee_status IS NULL ";




        if($this->session->userdata('role_id')==17){
        $from .=" and ar.qc1_verification=1 ";
        }           

        if ($searchCond) {
        $from .= " and $searchCond ";
        } 
        if($this->session->userdata('role_id')==4){
        $from .=" and o.dedicated_qc=4 ";
        }
        if ($type == 'count') {
        $select = "count(DISTINCT(a.request_id)) as count "; 
        }

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " group by a.request_id order by $sBy $sOrder limit $pg," . $limit;
        }
       
        $sql = "SELECT " . $select . "" . $from;  
        $query = $this->db->query($sql); 
        return $query->result_array();
    }

     function get_qc2discrepancylist($pg = 0, $limit = 15, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')    {

        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,r.candidate_name,p.office_name as parent_office,s.office_name as sub_office,o.org_name,r.case_no,min(vl1.v_date) as vm_date ,q.assignee_by ";
         $from = "   FROM " . DB_PREFIX . "client_request r  
         JOIN  " . DB_PREFIX . "verification_request a ON a.request_id=r.request_id and a.qc_assignee_status=1
         JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id=a.request_id
         JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = r.request_id and ar.qc1_verification=1
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=ar.candidate_req_id and vl1.check_id=ar.check_id and vl1.level_id=ar.level_id
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "office c ON c.id=r.office
         LEFT JOIN " . DB_PREFIX . "office p ON p.id=r.parent_office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id=r.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=r.organisation
         LEFT JOIN " . DB_PREFIX . "qc2_request q ON q.request_id=r.request_id
          JOIN " . DB_PREFIX . "user t ON t.id = r.user_id and t.active_status != 3
         where 1 and ar.verify_status in (111,110,519)  and ( CASE WHEN o.dedicated_qc=17 THEN vl1.vm_discrepency in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701) ELSE vl1.qc_discrepency in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701) END AND qc2_report_publish !=1 ) and a.qc_assignee_status = 1 and q.qc2_assignee_status IS NULL  ";




        if($this->session->userdata('role_id')==17){
        $from .=" and ar.qc1_verification=1 ";
        }           

        if ($searchCond) {
        $from .= " and $searchCond ";
        } 
        if($this->session->userdata('role_id')==4){
        $from .=" and o.dedicated_qc=4 ";
        }
        if ($type == 'count') {
        $select = "count(DISTINCT(a.request_id)) as count "; 
        }

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " group by a.request_id order by $sBy $sOrder limit $pg," . $limit;
        }
       
        $sql = "SELECT " . $select . "" . $from;  
        $query = $this->db->query($sql); 
        return $query->result_array();
    }


    function get_userlistverification_not ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') {    
        $select = "a.candidate_req_id,a.vm_revert_to,a.ass_request, a.qc_revert_request, a.vm_assigned_qc, d.candidate_name as candidatename, c.name as skillname,a.level_id,
        p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,
        s.vm_revert_option_status,s.operator_submited_by,d.order_id as ordercode,
        d.vm_revert_supervisor, f.order_name,c.name as checkname,c.id as checkId,vs.name as status,verify_status,a.check_id as checkid,a.vm_revert_status as rstatus, ass_request, vm_revert_request as vrequest, a.pack_id, d.case_no, o.org_name, a.count_of_chk as chk, concat_ws(' ',us.first_name,us.middle_name,us.last_name) as vname, vr.deadline_from, vr.deadline_to,vl1.reqstatus,vl1.supplementary,a.additional_docs,vl1.v_date, vl1.vm_request_raised_date";
        $from = "  from ".DB_PREFIX ."ver_assign_rep a
        LEFT JOIN ".DB_PREFIX ."personal_details b ON b.user_id = a.candidate_req_id
        LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = b.user_id
        LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
        LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
        LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
        LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
        LEFT JOIN   ".DB_PREFIX ."order f ON f.id = d.order_id
        LEFT JOIN ".DB_PREFIX ."submit_cv s ON s.request_id = a.candidate_req_id
        LEFT JOIN ".DB_PREFIX ."employment em ON em.id = a.level_id and a.check_id=em.checkid
        LEFT JOIN ".DB_PREFIX ."education_details ed ON ed.id = a.level_id and a.check_id=ed.checkid
        LEFT JOIN ".DB_PREFIX ."professional_reference pr ON pr.id = a.level_id and a.check_id=pr.checkid
        LEFT JOIN ".DB_PREFIX ."master_masterdata vs ON vs.id = a.verify_status 
        LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id
        JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3
        LEFT JOIN ".DB_PREFIX ."verification_request vr ON vr.request_id = a.candidate_req_id and vr.check_id=a.check_id and vr.level_id=a.level_id and vr.pack_id=a.pack_id 
        LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.candidate_req_id and vl1.check_id=a.check_id and vl1.level_id=a.level_id ";       
                   
         if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==24 || $this->session->userdata['role_id']==9) {
              $from .= " WHERE 1=1 and json_extract_c(vl1.qc2fielddata, '$.veri_received_dropdown') =2 and json_extract_c(vl1.qc2fielddata, '$.dd_recevied_form') !=1 ";
         }  
         else if($this->session->userdata['role_id']==21) {
             $from .= " WHERE o.crm_userid = ".$this->session->userdata['userid']."  ";
         }  
         else{
         $from .= " WHERE  a.team_mem_id = ".$this->session->userdata['userid']." and (a.verify_status =107 or a.vm_assigned_qc=0 or a.verify_status =684 )" ;
         }

        if ($searchCond) {
        $from .= " and $searchCond";
        }

        if ($type == 'count') $select = "count(DISTINCT(a.rep_id)) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " group by a.rep_id order by $sBy $sOrder limit $pg," . $limit;
        }

        $sql = "SELECT " . $select . "" . $from;
       
        $query = $this->db->query($sql);
        return $query->result_array();
        //print_r($query->result_array());
    }

    /*******************************************************
    ***** function get_newuserlistverification *************
    ********************************************************/
    function get_newuserlistverification ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') {    
        $select = " a.candidate_req_id,a.vm_revert_to,a.ass_request,ct.verification_tat, a.qc_revert_request, a.vm_assigned_qc, d.candidate_name as candidatename, c.name as skillname,a.level_id,
        p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,
        s.vm_revert_option_status,s.operator_submited_by,d.order_id as ordercode,
        d.vm_revert_supervisor, f.order_name,c.name as checkname,c.id as checkId,vs.name as status,verify_status,a.check_id as checkid,a.vm_revert_status as rstatus, td.ticket_status, td.requested_date, ass_request, vm_revert_request as vrequest, a.pack_id, d.case_no, o.org_name, a.count_of_chk as chk, concat_ws(' ',us.first_name,us.middle_name,us.last_name) as vname, vr.deadline_from, vr.deadline_to,vl1.reqstatus,vl1.supplementary,a.reopen_revert_qc,a.reopen_revert_qc2,a.additional_docs,vl1.v_date, vl1.vm_request_raised_date,(5 * (DATEDIFF(CURDATE(), date(vr.deadline_from)) DIV 7) + MID('0123444401233334012222340111123400012345001234550', 7 * WEEKDAY(date(vr.deadline_from)) + WEEKDAY(CURDATE()) + 1, 1)) - (SELECT COUNT(*) FROM dcode_master_holidays WHERE status=1 and  holiday_date >= date(vr.deadline_from) and holiday_date <= CURDATE()) as Days ";
        $from = "  from ".DB_PREFIX ."ver_assign_rep a
        LEFT JOIN ".DB_PREFIX ."personal_details b ON b.user_id = a.candidate_req_id
        LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."customer_tat ct ON ct.check_id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = b.user_id
        LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
        LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
        LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
        LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
        LEFT JOIN   ".DB_PREFIX ."order f ON f.id = d.order_id
        LEFT JOIN ".DB_PREFIX ."submit_cv s ON s.request_id = a.candidate_req_id
        LEFT JOIN ".DB_PREFIX ."employment em ON em.id = a.level_id and a.check_id=em.checkid
        LEFT JOIN ".DB_PREFIX ."education_details ed ON ed.id = a.level_id and a.check_id=ed.checkid
        LEFT JOIN ".DB_PREFIX ."professional_reference pr ON pr.id = a.level_id and a.check_id=pr.checkid
        LEFT JOIN ".DB_PREFIX ."master_masterdata vs ON vs.id = a.verify_status 
        LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id
        JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3
        LEFT JOIN ".DB_PREFIX ."verification_request vr ON vr.request_id = a.candidate_req_id and vr.check_id=a.check_id and vr.level_id=a.level_id and vr.pack_id=a.pack_id 
        LEFT JOIN ".DB_PREFIX ."ticket_details td ON td.request_id = a.candidate_req_id and td.check_id=a.check_id and td.level_id=a.level_id and td.current_status=1 
        LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.candidate_req_id and vl1.check_id=a.check_id and vl1.level_id=a.level_id WHERE (a.verify_status =107 or a.vm_assigned_qc=0 or a.verify_status =684 or a.verify_status =992 ) and (CASE WHEN ct.org_id !=0 THEN ct.org_id=o.id ELSE ct.org_id=0 END) and ct.tat_status=1 and vr.deadline_from<>'' ";       

        if ($searchCond) {
        $from .= " and $searchCond";
        }

        if ($type == 'count') $select = "count(DISTINCT(a.rep_id)) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " group by a.rep_id order by $sBy $sOrder limit $pg," . $limit;
        }

        $sql = "SELECT " . $select . "" . $from;
       
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    /****************************
        ticket details
        Function get_ticket
    ****************************/
    function get_ticket($request_id,$check_id,$level_id)
    {
        $this->db->select('ticket_no,case_no,request_id,check_id, level_id, ticket_serial_no');
        $this->db->where('request_id',$request_id);
        $this->db->where('check_id',$check_id);
        $this->db->where('level_id',$level_id);
        $this->db->where('current_status',1);
        return $this->db->get(DB_PREFIX.'ticket_details')->result_array();

    }

    function get_ticketno()
    {
        $this->db->select('max(ticket_no) as ticketNo');
        return $this->db->get(DB_PREFIX.'ticket_details')->result_array();

    }


    /****************************************
     Ticket list history
     get_ticketlist_vm
    ****************************************/
    function get_ticketlist_vm($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
   
   $roleid= $this->session->userdata('role_id'); 
   $usertype= $this->session->userdata('user_type'); 

          $select = "td.check_id,td.ticket_no,td.case_no,td.ticket_details,td.ticket_status,td.action_date, td.request_id,td.level_id,td.requested_date,td.revert_date,td.close_date,c.org_name, a.user_id, a.candidate_name, f.email, c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office, m.name,rm.name as req_name, concat_ws(' ',us.first_name,us.last_name) as username, vr.count_of_chk as chk,vl1.qc2_dis,vl1.qc2status";
                                
          $from = "   FROM " . DB_PREFIX . "client_request a 
              LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
              LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
              LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
              LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
              LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
              
              LEFT JOIN " . DB_PREFIX . "ticket_details td ON td.request_id=a.request_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=td.check_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata rm ON rm.id=td.request_reason_id
              LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=td.request_id and vr.check_id=td.check_id and vr.level_id=td.level_id
              LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=td.request_id and vl1.level_id=td.level_id and vl1.check_id=td.check_id
              LEFT JOIN " . DB_PREFIX . "user us ON us.id=td.user_id
              LEFT JOIN " . DB_PREFIX . "user f ON f.id=a.user_id
              JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3 and t.status != 2 WHERE td.request_id=a.request_id and td.current_status =1 ";

              if($roleid==5){
                $from .= " and vr.team_mem_id = ".$this->session->userdata['userid'];
              }

              if ($searchCond ) {
                  $from .= " and $searchCond";
              }

              if ($searchCond == 'td.ticket_status =101') {
                  $from .= " and td.ticket_status =101";
              }else if($searchCond){
                  $from .= " and $searchCond";
              }else{
                  $from .= " and td.ticket_status !=101";
              }

              if ($type == 'count') $select = "count(*) as count "; 
                
              if ($pg >= 0 && $type <> 'count') { 
                       $from .= " order by $sBy $sOrder limit $pg," . $limit;
              }
        
          $sql = "SELECT " . $select . "" . $from;
          $query = $this->db->query($sql);
          return $query->result_array();
    }


    /****************************************
     Ticket list history
     get_ticketlist_vm
    ****************************************/
    function export_requestraised_vm($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
   
   $roleid= $this->session->userdata('role_id'); 
   $usertype= $this->session->userdata('user_type'); 

          $select = "td.check_id,td.ticket_no,td.case_no,td.ticket_details,td.ticket_status,td.action_date, td.request_id,td.level_id,td.requested_date,td.revert_date,td.close_date,c.org_name, a.user_id, a.candidate_name, f.email, c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office, m.name,rm.name as req_name, concat_ws(' ',us.first_name,us.last_name) as username, vr.count_of_chk as chk";
                                
          $from = "   FROM " . DB_PREFIX . "client_request a 
              LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
              LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
              LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
              LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
              LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
              
              LEFT JOIN " . DB_PREFIX . "ticket_details td ON td.request_id=a.request_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=td.check_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata rm ON rm.id=td.request_reason_id
              LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=td.request_id and vr.check_id=td.check_id and vr.level_id=td.level_id
              LEFT JOIN " . DB_PREFIX . "user us ON us.id=td.user_id
              LEFT JOIN " . DB_PREFIX . "user f ON f.id=a.user_id
              JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3 and t.status != 2 WHERE td.request_id=a.request_id and td.current_status =1 ";

              if($roleid==5){
                $from .= " and vr.team_mem_id = ".$this->session->userdata['userid'];
              }
              
              if ($searchCond ) {
                  $from .= " and $searchCond";
              }

              if ($searchCond == 'td.ticket_status =101') {
                  $from .= " and td.ticket_status =101";
              }else if($searchCond){
                  $from .= " and $searchCond";
              }else{
                  $from .= " and td.ticket_status !=101";
              }

              if ($type == 'count') $select = "count(*) as count "; 
                
              if($pg >= 0 && $type <> 'count'){ 
                $from .= " order by td.ticket_no desc ";
              }
        
          $sql = "SELECT " . $select . "" . $from;
          $query = $this->db->query($sql);
          return $query->result_array();
    }

    /****************************************
     Ticket list history
     get_qcticketlist
    ****************************************/
    function get_qcticketlist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
   
       // $roleid= $this->session->userdata('role_id'); 
       // $usertype= $this->session->userdata('user_type'); 

          $select = "td.check_id,td.ticket_no,td.case_no,td.ticket_details,td.ticket_status,td.action_date, td.request_id,td.level_id,td.requested_date,td.revert_date,td.close_date,c.org_name, a.user_id, a.candidate_name, c.org_name, b.office_name, d.parent, d.office_name AS parent_office, o.office_name AS sub_office, m.name,rm.name as req_name, concat_ws(' ',us.first_name,us.last_name) as username, vr.count_of_chk as chk";
                                
          $from = "   FROM " . DB_PREFIX . "client_request a 
              LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
              LEFT JOIN " . DB_PREFIX . "office d ON d.id = a.parent_office 
              LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
              LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
              LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
              
              LEFT JOIN " . DB_PREFIX . "ticket_details td ON td.request_id=a.request_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=td.check_id
              LEFT JOIN " . DB_PREFIX . "master_masterdata rm ON rm.id=td.request_reason_id
              LEFT JOIN ".DB_PREFIX ."ver_assign_rep vr ON  vr.candidate_req_id=td.request_id and vr.check_id=td.check_id and vr.level_id=td.level_id            
              LEFT JOIN " . DB_PREFIX . "user f ON f.id=a.user_id
              LEFT JOIN " . DB_PREFIX . "user us ON us.id=td.user_id
              JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3 and t.status != 2 WHERE td.request_id=a.request_id and td.current_status !=0 ";
              
              if ($searchCond == 'td.ticket_status =3') {
                  $from .= " and td.ticket_status =3";
              }else if($searchCond == 'td.ticket_status =101'){
                  $from .= " and td.ticket_status =101";
              }else if($searchCond == 'td.ticket_status =2'){
                  $from .= " and td.ticket_status =2";
              }else if($searchCond == 'td.ticket_status =4'){
                  $from .= " and td.ticket_status =4";
              }else if($searchCond){
                  $from .= " and $searchCond";
              }else{
                  $from .= " and td.ticket_status !=3 and td.ticket_status !=101 and td.ticket_status !=2 and td.ticket_status !=4";
              }

              if ($type == 'count') $select = "count(*) as count "; 
                
              if ($pg >= 0 && $type <> 'count') { 
                       $from .= " order by $sBy $sOrder limit $pg," . $limit;
              }
        
          $sql = "SELECT " . $select . "" . $from;
          $query = $this->db->query($sql); 
          return $query->result_array();
    }

    function get_userlistverification_export ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') {    
        $select = " a.candidate_req_id, d.candidate_name as candidatename, a.level_id,
        p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,
        c.name as checkname,c.id as checkId,vs.name as status,verify_status,a.check_id as checkid,a.vm_revert_status as rstatus, ass_request, vm_revert_request as vrequest, a.pack_id, d.case_no, o.org_name, a.count_of_chk as chk, pc.father_name,pc.permanent_address,pc.mobile,pc.pincode,pc.district,pc.state,cd.father_name as cfather_name, cd.current_address, cd.cmobile, cd.cpincode, cd.district as cdistrict, cd.state as cstate";
        $from = "  from ".DB_PREFIX ."ver_assign_rep a
        LEFT JOIN ".DB_PREFIX ."personal_details b ON b.user_id = a.candidate_req_id
        LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."customer_tat ct ON ct.check_id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = b.user_id
        LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
        LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
        LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
        LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
        LEFT JOIN   ".DB_PREFIX ."order f ON f.id = d.order_id
        LEFT JOIN ".DB_PREFIX ."submit_cv s ON s.request_id = a.candidate_req_id
        LEFT JOIN ".DB_PREFIX ."employment em ON em.id = a.level_id and a.check_id=em.checkid
        LEFT JOIN ".DB_PREFIX ."education_details ed ON ed.id = a.level_id and a.check_id=ed.checkid
        LEFT JOIN ".DB_PREFIX ."professional_reference pr ON pr.id = a.level_id and a.check_id=pr.checkid
        LEFT JOIN ".DB_PREFIX ."permanent_contact_details pc ON pc.id = a.level_id and a.check_id=pc.checkid
        LEFT JOIN ".DB_PREFIX ."contact_details cd ON cd.id = a.level_id and a.check_id=cd.checkid
        LEFT JOIN ".DB_PREFIX ."master_masterdata vs ON vs.id = a.verify_status 
        LEFT JOIN ".DB_PREFIX ."ticket_details td ON td.request_id = a.candidate_req_id and td.check_id=a.check_id and td.level_id=a.level_id and td.current_status=1 
        LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id
        JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3
        LEFT JOIN ".DB_PREFIX ."verification_request vr ON vr.request_id = a.candidate_req_id and vr.check_id=a.check_id and vr.level_id=a.level_id and vr.pack_id=a.pack_id 
        LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.candidate_req_id and vl1.check_id=a.check_id and vl1.level_id=a.level_id";       
     //echo $this->session->userdata['userid'];exit;                
        if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==24 || $this->session->userdata['role_id']==9) {
             $from .= " WHERE 1=1 ";
        }  
        else if($this->session->userdata['role_id']==21) {
            $from .= " WHERE o.crm_userid = ".$this->session->userdata['userid']." and vr.deadline_from<>'' and c.id in(15,16) ";
        }  
        else{
        $from .= " WHERE  a.team_mem_id = ".$this->session->userdata['userid']." and (a.verify_status =107 or a.vm_assigned_qc=0 or a.verify_status =684 or a.verify_status =992 ) and vr.deadline_from<>'' and c.id in(15,16) " ;
        }

        if ($searchCond) {
        $from .= " and $searchCond";
        }                   
        if ($type == 'count') $select = "count(DISTINCT(a.rep_id)) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " group by a.rep_id order by $sBy $sOrder limit $pg," . $limit;
        }

        $sql = "SELECT " . $select . "" . $from;
       
        $query = $this->db->query($sql);
        return $query->result_array();
    }



    function get_activitysheet($activity, $fromDate,$toDate,$userId=0){
        
        $select = "count(check_status) as status";
            $from = " FROM " . DB_PREFIX . "status_updates a 
                WHERE check_status=".$activity." and (DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') >= '".date('Y-m-d',strtotime($fromDate))."' and DATE_FORMAT(a.date_of_update ,'%Y-%m-%d') <= '".date('Y-m-d',strtotime($toDate))."')";

            if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==9){
                if($userId!=0){
                    $from .= " and a.user_id=".$userId;
                }else{
                    $from .= " ";
                }
            }
            else{
                $from .= " and a.user_id=".$this->session->userdata['userid'];
            }

          $sql = "SELECT " . $select . "" . $from;
            $query = $this->db->query($sql);
            return $query->row_array();

    }



function get_prioritycaselist ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
    
    $usertype= $this->session->userdata('user_type');          
        $select = "a.candidate_req_id,a.vm_revert_to,a.ass_request,a.qc_revert_request, d.candidate_name as candidatename, a.level_id, a.pack_id, 
        p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,
        s.vm_revert_option_status,c.name as checkname,c.id as checkId,a.check_id as checkid,a.vm_revert_status as rstatus, vm_revert_request as vrequest, d.case_no,o.id,o.org_name, a.count_of_chk as chk,pri.priority, pri.request_id,pri.comments,pri.date_ofset,pri.date_ofupdate, concat_ws(' ',us.first_name,us.middle_name,us.last_name) as vname";
        $from = "  from ".DB_PREFIX ."ver_assign_rep a  
             JOIN ".DB_PREFIX ."priority pri ON  pri.request_id = a.candidate_req_id
        LEFT JOIN ".DB_PREFIX ."personal_details b ON b.user_id = a.candidate_req_id
        LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = b.user_id

        LEFT JOIN  ".DB_PREFIX ."office p ON p.id = d.parent_office
        LEFT JOIN  ".DB_PREFIX ."office br ON br.id = d.office
        LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
        LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
        LEFT JOIN  ".DB_PREFIX ."submit_cv s ON s.request_id = a.candidate_req_id
        LEFT JOIN  ".DB_PREFIX ."verification_request vr ON vr.request_id = a.candidate_req_id and vr.check_id=a.check_id and vr.level_id=a.level_id and vr.pack_id=a.pack_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.candidate_req_id and vl1.check_id=a.check_id and vl1.level_id=a.level_id 
         LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id";  
               

       
                    $poffice=implode(",", $this->session->userdata['poffice'] );
                    $boffice=implode(",", $this->session->userdata['boffice'] );
                    $soffice=implode(",", $this->session->userdata['soffice'] );
                   
         if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==24 ||$this->session->userdata['role_id']==9 )  {
             $from .= " WHERE (a.verify_status != 111  or a.verify_status != 110  or a.verify_status != 519 )  and vr.deadline_from<>''AND pri.priority != 0 AND ( a.vm_revert_status != 111 AND  a.vm_revert_status != 110 AND a.vm_revert_status != 519 OR (a.vm_revert_status  = 0 OR a.vm_revert_status = 992 OR a.vm_revert_status = 107 )) ";
        } 
        
     else if($usertype == 2 && $this->session->userdata['role_id']==12)
                {

                  if(empty($boffice) and empty($soffice)){

                    $from .= "  WHERE pri.priority != 0 and d.parent_office in (".$poffice." )  and o.id=".$this->session->userdata['parentoffice_id'];
                     
                  }
                    else if(!empty($boffice) and empty($soffice)){
                        
                    $from .= "  WHERE  pri.priority != 0 and d.parent_office in (".$poffice." ) ";

                  }
                  else{
                         $from .= " WHERE  pri.priority != 0 and d.parent_office in (".$poffice." )"; 
                         
                      }
                } 


       else if($usertype == 2 && $this->session->userdata['role_id']==13 )
               {
                     if(empty($boffice) and empty($soffice)){
                    $from .= "  WHERE pri.priority != 0 and d.parent_office in (".$poffice." ) and o.id=".$this->session->userdata['parentoffice_id'];
                     
                  }
                    else if(!empty($boffice) and empty($soffice)){
                    $from .= "   WHERE pri.priority != 0 and d.parent_office in (".$poffice." ) and d.office in (".$boffice." ) and o.id=".$this->session->userdata['parentoffice_id'];
                    
                  }
                  else{
                         $from .= "  WHERE pri.priority != 0 and d.parent_office in (".$poffice." ) and d.office in (".$boffice." ) and d.sub_office in (".$soffice." ) and o.id=".$this->session->userdata['parentoffice_id'];
                         
                      }                
                    $from .= " and ( d.dataentry_by = 3 or d.created_by = ".$this->session->userdata['userid']." ) ";
                    
               } 
        
        else{
    $from .= " WHERE  a.team_mem_id = ".$this->session->userdata['userid']." and (a.verify_status != 111  or a.verify_status != 110 or a.verify_status != 519  )  and vr.deadline_from<>''AND pri.priority != 0 AND ( a.vm_revert_status != 111 AND  a.vm_revert_status != 110 AND a.vm_revert_status != 519 OR (a.vm_revert_status  = 0 OR a.vm_revert_status = 992 OR a.vm_revert_status = 107 ) )" ;
        }

        if ($searchCond) {
        $from .= " and $searchCond";
        }                   
        if ($type == 'count') $select = "count(a.rep_id) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " order by pri.id  $sOrder limit $pg," . $limit;
        }

        $sql = "SELECT " . $select . "" . $from;
       
        $query = $this->db->query($sql);

        return $query->result_array();
    }


    function get_reminderList ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') {           
        $select = " a.candidate_req_id,a.vm_revert_to,a.ass_request, a.qc_revert_request, a.vm_assigned_qc, d.candidate_name as candidatename, c.name as skillname,a.level_id,
        p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,
        s.vm_revert_option_status,s.operator_submited_by,d.order_id as ordercode,
        d.vm_revert_supervisor, f.order_name,c.name as checkname,c.id as checkId,vs.name as status,verify_status,a.check_id as checkid,a.vm_revert_status as rstatus, ass_request, vm_revert_request as vrequest, a.pack_id, d.case_no, o.org_name, a.count_of_chk as chk, concat_ws(' ',us.first_name,us.middle_name,us.last_name) as vname, vr.deadline_from, vr.deadline_to,vl1.reqstatus,vl1.supplementary,a.additional_docs,a.reopen_revert_qc,a.reopen_revert_qc2,vl1.v_date,td.ticket_status, td.requested_date,
        vl1.vm_request_raised_date,ct.verification_tat";
        $from = "  from ".DB_PREFIX ."ver_assign_rep a
        LEFT JOIN ".DB_PREFIX ."personal_details b ON b.user_id = a.candidate_req_id
        LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."customer_tat ct ON ct.check_id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = b.user_id
        LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
        LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
        LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
        LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
        LEFT JOIN   ".DB_PREFIX ."order f ON f.id = d.order_id
        LEFT JOIN ".DB_PREFIX ."submit_cv s ON s.request_id = a.candidate_req_id
        LEFT JOIN ".DB_PREFIX ."employment em ON em.id = a.level_id and a.check_id=em.checkid
        LEFT JOIN ".DB_PREFIX ."education_details ed ON ed.id = a.level_id and a.check_id=ed.checkid
        LEFT JOIN ".DB_PREFIX ."professional_reference pr ON pr.id = a.level_id and a.check_id=pr.checkid
        LEFT JOIN ".DB_PREFIX ."master_masterdata vs ON vs.id = a.verify_status 
        LEFT JOIN ".DB_PREFIX ."ticket_details td ON td.request_id = a.candidate_req_id and td.check_id=a.check_id and td.level_id=a.level_id and td.current_status=1 
        LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id
        JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3
        LEFT JOIN ".DB_PREFIX ."verification_request vr ON vr.request_id = a.candidate_req_id and vr.check_id=a.check_id and vr.level_id=a.level_id and vr.pack_id=a.pack_id 
        LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.candidate_req_id and vl1.check_id=a.check_id and vl1.level_id=a.level_id";       
     //echo $this->session->userdata['userid'];exit;                
        if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==24 || $this->session->userdata['role_id']==9) {
             $from .= " WHERE 1=1 ";
        }  
        else if($this->session->userdata['role_id']==21) {
            $from .= " WHERE o.crm_userid = ".$this->session->userdata['userid']." and vr.deadline_from<>'' ";
        }  
        else{
        $from .= " WHERE  a.team_mem_id = ".$this->session->userdata['userid']." and (a.verify_status =107 or a.vm_assigned_qc=0 or a.verify_status =684 or a.verify_status =992 ) and vr.deadline_from<>'' " ;
        }

        if ($searchCond) {
        $from .= " and $searchCond";
        }                   
        if ($type == 'count') $select = "count(DISTINCT(a.rep_id)) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " group by a.rep_id order by $sBy $sOrder limit $pg," . $limit;
        }

        $sql = "SELECT " . $select . "" . $from;
       
        $query = $this->db->query($sql);
        return $query->result_array();
    }


    /***************** function get_all_vmembers ****************************************
     * Added by MN to get all verification members for showing new/ assigned checks
     ************************************************************************************/
    function get_all_vmembers($role_id, $userId=0, $status)
    {
    
        $select = " distinct(us.id) as user_id, concat_ws(' ',us.first_name,us.middle_name,us.last_name) as name";
        $from = "  from ".DB_PREFIX ."ver_assign_rep a
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id =a.candidate_req_id
        LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id
        JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3 ";
        
        if( $role_id==9 || $role_id==1) {
             $from .= " WHERE 1=1 and us.status=".$status;
        }   
         if($userId!=0)  
        {
            // taking into account 1  or more VMs
            $from .= " and us.id IN (".$userId . ")";
        }else
        {
            $from .= " "; // All active or inactive VMs 
        }
    
        // inactive or active status
        $from .= " and us.status=" .$status ." ORDER BY us.first_name";

        // Forming  SQL select query and querying the db.
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);

        // Returning the resultset as an array.
        return $query->result_array();
        
    }

  /*******************************************************
    ***** function get_newcourtrecordlist *************
    ********************************************************/
    function get_newcourtrecordlist ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') {    
        $select = "a.candidate_req_id,a.level_id,
        p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,d.case_no,c.id as checkId,vs.name as status,o.org_name,cr.father_name as crfather,lf.father_name as lffather,ind.father_name as indfather,cr.date_of_birth as crdob,lf.date_of_birth as lfdob,ind.date_of_birth as inddob,cr.firstname as crfirstname,cr.middlename as crmidname, cr.lastname as crlastname,lf.firstname as lffirstname,lf.middlename as lfmidname, lf.lastname as lflastname,ind.firstname as indfirstname,ind.middlename as indmidname, ind.lastname as indlastname,cr.address as craddress,lf.permanent_address as lfaddress,ind.address as indaddress,cr.level_name as crlevelname,a.pack_id,cr.pincode as crpincode, lf.pincode as lfpincode";
        $from = "  from ".DB_PREFIX ."ver_assign_rep a
        LEFT JOIN ".DB_PREFIX ."personal_details b ON b.user_id = a.candidate_req_id
        LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
        
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = b.user_id
        LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
        LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
        LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
        LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
        LEFT JOIN   ".DB_PREFIX ."order f ON f.id = d.order_id
        
        LEFT JOIN ".DB_PREFIX ."court_record_check cr ON cr.id = a.level_id and a.check_id=cr.checkid

        LEFT JOIN ".DB_PREFIX ."court_record_check_lf lf ON lf.id = a.level_id and a.check_id=lf.checkid
        LEFT JOIN ".DB_PREFIX ."court_record_check_india ind ON ind.id = a.level_id and a.check_id=ind.checkid
        LEFT JOIN ".DB_PREFIX ."master_masterdata vs ON vs.id = a.verify_status 
        LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id
        JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3";
        if($this->session->userdata['role_id']==1 )
        {
          $from .= " WHERE   a.check_id IN (71,639,640) AND a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0";       
        }
        else{
         $from .= " WHERE  a.team_mem_id = ".$this->session->userdata['userid']." AND  a.check_id IN (71,639,640) AND a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0";
        }      

        if ($searchCond) {
        $from .= " and $searchCond";
        }

        if ($type == 'count') $select = "count(DISTINCT(a.rep_id)) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " group by a.rep_id order by $sBy $sOrder limit $pg," . $limit;
        }

        $sql = "SELECT " . $select . "" . $from;
       
        $query = $this->db->query($sql);
       return $query->result_array();
     
        
     
    }


    function get_order($requestId){

        $this->db->select('request_id,order_id,case_no');
        $this->db->where('request_id', $requestId);
        return  $this->db->get(DB_PREFIX.'client_request')->row_array();

    }

    
    function get_checkwithcount($request_id,$orderId){
        
        $select = " rc.package_id,rc.check_id,rc.no_checks,ac.Rs,ac.overseas_charge, vl.outside_india,vl.request_id,vl.level_id,sc.amount,sc.exchange_rate,sc.amount_rupees,sc.currency,sc.check_id as int_checkID";
        $from = "  from ".DB_PREFIX ."request_check rc
        LEFT JOIN  ".DB_PREFIX ."add_check ac ON ac.types_of_check=(CASE WHEN rc.package_id=0 THEN rc.check_id ELSE rc.package_id END)
        LEFT JOIN  ".DB_PREFIX ."service_charges_intchecks sc ON sc.request_id=rc.request_id and sc.check_id=rc.check_id
        LEFT JOIN  ".DB_PREFIX ."verified_level vl ON vl.request_id=rc.request_id AND vl.check_id=rc.check_id
        WHERE rc.request_id=".$request_id." AND ac.order_id=".$orderId;
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        // Returning the resultset as an array.
            if($query !== FALSE && $query->num_rows() > 0){
                return $query->result_array();
            }
        //return $query->result_array();
    }

    function get_packagecheck($request_id,$orderId, $check_id){
        
        $select = "rc.package_id,rc.check_id,ac.types_of_check,ac.Rs,ac.overseas_charge,vl.outside_india,vl.request_id";
        $from = "  from ".DB_PREFIX ."add_check ac
        LEFT JOIN  ".DB_PREFIX ."request_check rc ON rc.request_id=".$request_id." AND rc.check_id=".$check_id."
        LEFT JOIN  ".DB_PREFIX ."verified_level vl ON vl.request_id=rc.request_id AND vl.check_id=rc.check_id
        WHERE order_id=".$orderId." AND types_of_check=".$check_id;
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->row_array();
    }

    function get_outsideindia($request_id, $check_id, $level_id){
        
        $select = "outside_india,request_id";
        $from = "  from ".DB_PREFIX ."verified_level 
        WHERE request_id=".$request_id." AND check_id=".$check_id." AND level_id=".$level_id;
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->row_array();
    }


    function get_existing_requestid($request_id){
        
        $select = "request_id";
        $from = "   FROM " . DB_PREFIX . "bill_receipts
        where request_id=".$request_id;

        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->row_array();
    }


    function get_blanket_limit($orderId, $organization){

        $select = "blanket_approval_limit";
        $from = "  from ".DB_PREFIX ."order
        WHERE id=".$orderId." AND organisation=".$organization;
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->row_array();

    }

    function get_payment_count($request_id, $check_id, $level_id){

        $select = "COUNT(pr_id) as paycount";
        $from = "  from ".DB_PREFIX ."payment_request
        WHERE request_id=".$request_id." AND check_id=".$check_id." AND level_id=".$level_id;
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->row_array();

    }

    

     // ******* charges for international check *******
 function service_chrges_international($request_id,$check_id,$level_id){
    $this->db->select('count(*) as cnt');
            $this->db->where('request_id',$request_id);
            $this->db->where('check_id',$check_id);
            $this->db->where ('level_id',$level_id);
    $query=  $this->db->get(DB_PREFIX.'service_charges_intchecks');
     
    if($query !== FALSE && $query->num_rows() > 0){
            return $query->row_array();
        }
 }
    

  function get_service_chrges_intrnational($request_id,$check_id,$level_id){
    $this->db->select('*');
            $this->db->where('request_id',$request_id);
            $this->db->where('check_id',$check_id);
            $this->db->where ('level_id',$level_id);
    $query=  $this->db->get(DB_PREFIX.'service_charges_intchecks');
     
    if($query !== FALSE && $query->num_rows() > 0){
            return $query->row_array();
        }
 }  

    //******* end charges for international check ********
    /************ Payment Request Details**************
     ***** function get_payment_request_details********
     *************************************************/
    function get_payment_request_details($id){

        $select="pr.pr_id,pr.request_id,pr.check_id,pr.level_id,pr.case_no,cr.candidate_name,c.org_name,m.name as check_name,pr.reason_payment,pr.payment_mode,pr.bank_name,pr.payment_to,pr.currency,pr.beneficiary_name,pr.beneficiary_location,pr.customer_approval,pm.pm_name,pr.requested_amount as amount, pm1.pm_name as paymode, pm2.pm_name as paystatus,pr.payment_status,pr.requested_date,pr.dd_txn_no,pr.ref_branch_code as branchcode, pr.approved_date, pr.paid_date,pm3.pm_name as reason,pm4.pm_name as payto,pr.comments,pr.attachment,pr.reject_reason, concat_ws(' ',f.first_name,f.last_name) as requested_by, concat_ws(' ',u.first_name,u.last_name) as approved_by";
            $from = "   FROM " . DB_PREFIX . "payment_request pr
            LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = pr.request_id
            LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = pr.org_id
            LEFT JOIN " . DB_PREFIX . "master_masterdata m ON m.id=pr.check_id
            LEFT JOIN " . DB_PREFIX . "payment_master pm ON pm.pm_id=pr.currency
            LEFT JOIN " . DB_PREFIX . "payment_master pm1 ON pm1.pm_id=pr.payment_mode
            LEFT JOIN " . DB_PREFIX . "payment_master pm2 ON pm2.pm_id=pr.payment_status
            LEFT JOIN " . DB_PREFIX . "payment_master pm3 ON pm3.pm_id=pr.reason_payment
            LEFT JOIN " . DB_PREFIX . "payment_master pm4 ON pm4.pm_id=pr.payment_to
            LEFT JOIN " . DB_PREFIX . "user f ON f.id = pr.requested_by
            LEFT JOIN " . DB_PREFIX . "user u ON u.id = pr.approved_by
            where pr.pr_id=".$id;

            $sql = "SELECT " . $select . "" . $from;
            $query = $this->db->query($sql);
            return $query->row_array();

    }

    function get_checks_for_req_id($req_id){

         $this->db->select('*');
            $this->db->where('request_id',$req_id);
    $query=  $this->db->get(DB_PREFIX.'request_check');
     
    if($query !== FALSE && $query->num_rows() > 0){
            return $query->result_array();
        }

    }
    
    // ka added on may 7th
    function update_company_name_forgap($req_id,$json_gap){
        $this->db->query("UPDATE " . DB_PREFIX . "gap_analysis_check SET gapdata  = '$json_gap', updated_on = NOW() WHERE `request_id` = ".$req_id );
        
    }
    // ka added on may 9th updated_on = NOW()

    // ***************** ka added on july 17 ******edu/emp **************

    function update_qualification_companyname_forgap($req_id,$json_gap_edu){
        $this->db->query("UPDATE " . DB_PREFIX . "gap_analysis_check SET gap_edu  = '$json_gap_edu', updated_on = NOW() WHERE `request_id` = ".$req_id );
        //print_r($this->db->last_query()); exit();
    
       
       }//end





    function fetch_existing_record_json($request_id) {
        $sql = "SELECT gapdata FROM " . DB_PREFIX . "gap_analysis_check WHERE request_id = ". $request_id;
        $query = $this->db->query($sql);
        return $query->row_array();

    }
    // ka added on may 7th
    //ka added on july 17
    function fetch_existing_record_edu_json($request_id) {
        $sql = "SELECT gap_edu FROM " . DB_PREFIX . "gap_analysis_check WHERE request_id = ". $request_id;
        $query = $this->db->query($sql);
        return $query->row_array();

    
    }
     //ka added on july 17

    function get_verificationpending ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') {           
        $select = " a.candidate_req_id,a.vm_revert_to,a.ass_request, a.qc_revert_request, a.vm_assigned_qc, d.candidate_name as candidatename, c.name as skillname,a.level_id,
        p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,
        s.vm_revert_option_status,s.operator_submited_by,d.order_id as ordercode,
        d.vm_revert_supervisor, f.order_name,c.name as checkname,c.id as checkId,vs.name as status,verify_status,a.check_id as checkid,a.vm_revert_status as rstatus, ass_request, vm_revert_request as vrequest, a.pack_id, d.case_no, o.org_name, a.count_of_chk as chk, concat_ws(' ',us.first_name,us.middle_name,us.last_name) as vname, vr.deadline_from, vr.deadline_to,vl1.reqstatus,vl1.supplementary,a.reopen_revert_qc,a.reopen_revert_qc2,vl1.v_date,td.ticket_status, td.requested_date,
        vl1.vm_request_raised_date,ct.verification_tat,(5 * (DATEDIFF(CURDATE(), date(vr.deadline_from)) DIV 7) + MID('0123444401233334012222340111123400012345001234550', 7 * WEEKDAY(date(vr.deadline_from)) + WEEKDAY(CURDATE()) + 1, 1)) - (SELECT COUNT(*) FROM dcode_master_holidays WHERE status=1 and  holiday_date >= date(vr.deadline_from) and holiday_date <= CURDATE()) as Days";
        $from = "  from ".DB_PREFIX ."ver_assign_rep a
        LEFT JOIN ".DB_PREFIX ."personal_details b ON b.user_id = a.candidate_req_id
        LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."customer_tat ct ON ct.check_id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = b.user_id
        LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
        LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
        LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
        LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
        LEFT JOIN   ".DB_PREFIX ."order f ON f.id = d.order_id
        LEFT JOIN ".DB_PREFIX ."submit_cv s ON s.request_id = a.candidate_req_id
        LEFT JOIN ".DB_PREFIX ."employment em ON em.id = a.level_id and a.check_id=em.checkid
        LEFT JOIN ".DB_PREFIX ."education_details ed ON ed.id = a.level_id and a.check_id=ed.checkid
        LEFT JOIN ".DB_PREFIX ."professional_reference pr ON pr.id = a.level_id and a.check_id=pr.checkid
        LEFT JOIN ".DB_PREFIX ."master_masterdata vs ON vs.id = a.verify_status 
        LEFT JOIN ".DB_PREFIX ."ticket_details td ON td.request_id = a.candidate_req_id and td.check_id=a.check_id and td.level_id=a.level_id and td.current_status=1 
        LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id
        JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3
        LEFT JOIN ".DB_PREFIX ."verification_request vr ON vr.request_id = a.candidate_req_id and vr.check_id=a.check_id and vr.level_id=a.level_id and vr.pack_id=a.pack_id 
        LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.candidate_req_id and vl1.check_id=a.check_id and vl1.level_id=a.level_id";       
     //echo $this->session->userdata['userid'];exit;                
        if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==24 || $this->session->userdata['role_id']==9) {
             $from .= " WHERE (a.verify_status =107 or a.vm_assigned_qc=0 or a.verify_status =684 or a.verify_status =992 ) and vr.deadline_from<>''";
        }  
        else if($this->session->userdata['role_id']==21) {
            $from .= " WHERE o.crm_userid = ".$this->session->userdata['userid']." and vr.deadline_from<>'' ";
        }  
        else{
        $from .= " WHERE  a.team_mem_id = ".$this->session->userdata['userid']." and (a.verify_status =107 or a.vm_assigned_qc=0 or a.verify_status =684 or a.verify_status =992 ) and vr.deadline_from<>'' " ;
        }

        if ($searchCond) {
        $from .= " and $searchCond";
        }                   
        if ($type == 'count') $select = "count(DISTINCT(a.rep_id)) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " group by a.rep_id order by $sBy $sOrder limit $pg," . $limit;
        }

        $sql = "SELECT " . $select . "" . $from;
       
        $query = $this->db->query($sql);
        return $query->result_array();

        // $str = $this->db->last_query();
        // echo "<pre>";
        // print_r($str);
        // exit;
    }



    function get_qcnewcaselist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='', $assigneeId='') {


         $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,ar.qc_2_verification,ar.qc2_report_publish,vl1.qc2status,vl1.v_date,vl1.qc_date,concat_ws(' ',us.first_name,us.last_name) as qc2name,vl1.supplementary,concat_ws(' ',vm.first_name,vm.last_name) as vmname,ar.qc2_revert_date";

         $from = "   FROM " . DB_PREFIX . "verification_request a 
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
         LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation

         LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
         LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id 
         LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
         LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
         LEFT JOIN " . DB_PREFIX . "user vm ON vm.id=vl1.verified_by
          JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
         where 1  and a.assignee_status=1 and ar.verify_status in (111,110,519)AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id and qc1_verification=1  and (ar.qc2_verification = 0 and ar.qc1_verification=1 and ar.qc2_revert_request = 0 and vl1.qc2status!=107)";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        
        /* qc2 verification*/
        if($this->session->userdata('role_id')==17 ){
            $from .="  and ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish != 2 else ar.qc2_report_publish != 1 END ) and qc.assignee_id =".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish != 2 else ar.qc2_report_publish != 1 END ) and qc.assignee_id != 0 and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }
        else{
            $from .= " and ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish != 2 else ar.qc2_report_publish != 1 END ) and qc.assignee_id =".$assigneeId;
        }
                
               if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count ";
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();

    }

    function get_qcreopen_closed($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='', $assigneeId='')   {

         $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,ar.qc_2_verification,ar.qc2_report_publish,ar.reopen_revert_qc2,vl1.qc2status,vl1.v_date,vl1.qc_date,concat_ws(' ',us.first_name,us.last_name) as qc2name,vl1.supplementary,concat_ws(' ',vm.first_name,vm.last_name) as vmname,ar.qc2_revert_date";

         $from = "   FROM " . DB_PREFIX . "verification_request a 
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
         LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation

         LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
         LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id 
         LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
         LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
         LEFT JOIN " . DB_PREFIX . "user vm ON vm.id=vl1.verified_by
          JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
         where 1  and a.assignee_status=1 and ar.verify_status in (111,110,519) AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id and ar.qc1_verification=1 and ar.qc2_verification=0 and ar.qc_revert_request=1 and ar.qc2_revert_request=1 and ar.qc1_assign_revert=1 and ar.qc_2_verification=0 and ar.vm_assigned_qc=1 and vl1.supplementary=1 and  ar.reopen_revert_qc2=0 ";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        
        /* qc2 verification*/
        if($this->session->userdata('role_id')==17 ){
            $from .=" and qc.assignee_id =".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and qc.assignee_id != 0 and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }
        else{
            $from .= " and qc.assignee_id != 0 and qc.assignee_id =".$assigneeId;
        }
        
                
               if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count ";
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }


    function get_qcrevert_closed($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='', $assigneeId='')   {

         $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,ar.qc_2_verification,ar.qc2_report_publish,vl1.qc2status,vl1.v_date,vl1.qc_date,concat_ws(' ',us.first_name,us.last_name) as qc2name,vl1.supplementary,concat_ws(' ',vm.first_name,vm.last_name) as vmname,ar.qc2_revert_date";

         $from = "   FROM " . DB_PREFIX . "verification_request a 
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
         LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation

         LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
         LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id 
         LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
         LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
         LEFT JOIN " . DB_PREFIX . "user vm ON vm.id=vl1.verified_by
          JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
         where 1  and a.assignee_status=1 and ar.verify_status in (111,110,519) AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id and qc1_verification=1 and ((ar.qc1_assign_revert = 1 and ar.qc2_verification = 0 and (vl1.supplementary = 0 || vl1.supplementary = 2)) || (ar.qc1_assign_revert=1 and ar.qc_2_verification=0 and (vl1.supplementary = 0 || vl1.supplementary = 2))) ";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        
        /* qc2 verification*/
        if($this->session->userdata('role_id')==17 ){
            $from .="  and ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish != 2 else ar.qc2_report_publish != 1 END ) and qc.assignee_id =".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish != 2 else ar.qc2_report_publish != 1 END ) and qc.assignee_id != 0 and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }
        else{
            $from .= " and ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish != 2 else ar.qc2_report_publish != 1 END ) and qc.assignee_id =".$assigneeId;
        }
                
               if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count ";
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    function get_qcdiscrepency_list($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='',$assigneeId='')   {
        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,ar.qc_2_verification,ar.qc2_report_publish";

         $from = "   FROM " . DB_PREFIX . "verification_request a 
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
         LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation

         LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
         LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id
         LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id=a.request_id
         where 1  and a.assignee_status=1 and
         CASE WHEN o.dedicated_qc=17 THEN 
         vl1.vm_discrepency in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701)
         ELSE 
         qc_discrepency in (117,118,122,124,126,128,129,133,135,139,141,145,659,661,663,701) 
         END  AND qc2_report_publish !=1 and qc2_verification=0 and qc1_verification =1  and qc2status<>107  and (qc1_assign_revert = 1 and qc_revert_request = 1 || qc_revert_request = 0  and qc1_assign_revert = 0) ";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        /* qc2 verification*/
        if($this->session->userdata('role_id')==17){
            $from .=" and qc.assignee_id =".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }else{
            $from .= " and qc.assignee_id != 0 and qc.assignee_id =".$assigneeId;
        }

            if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count "; 
                
            if ($pg >= 0 && $type <> 'count') { 
                $from .= " group by ar.rep_id order by $sBy $sOrder limit $pg," . $limit;
            }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    function get_qcaccallotted_list($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='', $assigneeId=''){

         $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,r.candidate_name,p.office_name as parent_office,s.office_name as sub_office,o.org_name,r.case_no";
            $from = "   FROM " . DB_PREFIX . "client_request r 
            LEFT JOIN  
               " . DB_PREFIX . "verification_request a ON a.request_id=r.request_id
            LEFT JOIN 
               " . DB_PREFIX . "verification_status vs ON vs.request_id=a.request_id
            LEFT JOIN 
               " . DB_PREFIX . "user b ON b.id=a.assignee_id
            LEFT JOIN 
               " . DB_PREFIX . "office c ON c.id=r.office
            LEFT JOIN 
               " . DB_PREFIX . "office p ON p.id=r.parent_office
            LEFT JOIN 
               " . DB_PREFIX . "office s ON s.id=r.sub_office
            LEFT JOIN 
               " . DB_PREFIX . "organisation o ON o.id=r.organisation
            LEFT JOIN 
               " . DB_PREFIX . "qc2_request qc ON qc.request_id=r.request_id

            where 1  and 
               a.assignee_status=1 and 
               vs.verification_status=1 and 
               (
                 ( select count(vl.request_id) FROM " . DB_PREFIX . "verified_level vl LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = vl.request_id and vl.check_id = ar.check_id AND vl.level_id = ar.level_id where vl.request_id = a.request_id  and
                  CASE 
                     WHEN 
                        o.dedicated_qc = 17 
                     THEN 
                        (ar.verify_status IN (111,110,519) AND ar.vm_assigned_qc=1 ) 
                     ELSE 
                        ( (ar.verify_status IN (111,110,519)) AND vl.qcstatus IN (111,110,519) ) 
                     END 
               ) = (select sum(no_checks) FROM " . DB_PREFIX . "request_check re where re.request_id=a.request_id )) and
               ((select sum(no_checks) FROM " . DB_PREFIX . "request_check re where re.request_id=a.request_id ) != (select count(va.rep_id) FROM " . DB_PREFIX . "ver_assign_rep va LEFT JOIN " . DB_PREFIX . "verified_level vl ON va.candidate_req_id = vl.request_id and vl.check_id = va.check_id AND vl.level_id = va.level_id where va.candidate_req_id = a.request_id and va.qc2_report_publish=1)) ";
      
            if ($searchCond) {
                $from .= " and $searchCond";
            }
             /* qc2 verification*/
            if($this->session->userdata('role_id')==17){
                $from .=" and qc.assignee_id =".$this->session->userdata('userid');
            }
            else if($this->session->userdata('role_id')==21){
                $from .= " and o.crm_userid = ".$this->session->userdata['userid']." "; 
            }else{
                $from .= " and qc.assignee_id != 0 and qc.assignee_id =".$assigneeId;
            }

            if ($type == 'count') $select = "count(DISTINCT(a.request_id)) as count "; 

            if ($pg >= 0 && $type <> 'count') { 
                   $from .= " group by a.request_id order by $sBy $sOrder limit $pg," . $limit;
            }
            
            $sql = "SELECT " . $select . "" . $from;
            $query = $this->db->query($sql);
            return $query->result_array();
    } 

    function get_tatchk_details($reqID, $levelID,$checkID){
        $select="*";
        $from = "   FROM " . DB_PREFIX . "tat_checks
        where request_id=".$reqID." AND check_id=".$checkID." AND level_id=".$levelID." ORDER BY tat_id DESC LIMIT 1";
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->row_array();
    }







}
