<?php
class Verification_report_model extends CI_Model {
//Constuctor
function __construct() 
{
    parent::__construct();
    $this->load->database();
}

function employment($check_id)   {
$this->db->select('company_name,period_others_emp,last_designation,salary,reason,manager_name,manager_designation,exit_formality,email_id,contact_no,period_from,period_to,agency_name,currency,work_time')
->from(DB_PREFIX . 'employment as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function education($check_id)   {
$this->db->select('a.degree as level_name,a.degree,period_from,period_to,collegename_add,affliated,period_others')
->from(DB_PREFIX . 'education_details as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function current_address($check_id)   {
$this->db->select('current_address')
->from(DB_PREFIX . 'contact_details as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}

function permanent_address($check_id)   {
$this->db->select('permanent_address')
->from(DB_PREFIX . 'permanent_contact_details as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function professional_reference($check_id)   {
$this->db->select('company_name,manager_name,manager_designation,email_id,contact_no,period_others_prof')
->from(DB_PREFIX . 'professional_reference as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function personal_reference($check_id)   {
$this->db->select('reference_company_name,reference_name,reference_mobile,reference_email,reference_designation,reference_relationship,reference_knowntime')
->from(DB_PREFIX . 'personal_reference as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function police_permanent_address_verification($check_id)   {
$this->db->select('permanent_address,pincode')
->from(DB_PREFIX . 'police_permanent_address_verification as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function court_record_check_india($check_id)
{
$this->db->select('address')
->from(DB_PREFIX . 'court_record_check_india as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}

function india_specific_database_check($check_id)
{
$this->db->select('a.id')
->from(DB_PREFIX . 'india_specific_database_check as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}

function international_database_check($check_id)
{
$this->db->select('a.id')
->from(DB_PREFIX . 'international_database_check as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function international_database_check_ii($check_id)
{
$this->db->select('a.id')
->from(DB_PREFIX . 'international_database_check_ii as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function exit_interview($check_id)
{
$this->db->select('a.id')
->from(DB_PREFIX . 'exit_interview as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function drug_tests($check_id)
{

$this->db->select('a.id')
->from(DB_PREFIX . 'drug_tests as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function tenant_verification()
{
$this->db->select('number_of_clients,number_of_employees,turnover,infrastructure,
incorporation_date,office_address,details_of_directors,business_branch_address,registration_document,landlord_premises,no_of_people_living,rented_since,currently_working,period_from,last_designation,salary,additional_details,edocustatus,additional_details')
->from(DB_PREFIX . 'tenant_verification as a')
->where('a.id','1');
return $this->db->get()->row_array();
}
function vendor_verification()
{
$this->db->select('incorporation_date,permanent_address,number_of_clients,number_of_employees,turnover,infrastructure,details_of_directors,providing_business_since')
->from(DB_PREFIX . 'vendor_verification as a')
->where('a.id','1');
return $this->db->get()->row_array();
}

function aadhaar_card_verification($check_id)    {
$this->db->select('aadhaar_no')
->from(DB_PREFIX . 'aadhaar_card_verification as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function pan_card_verification($check_id)    {
$this->db->select('pan_card_no')
->from(DB_PREFIX . 'pan_card_verification as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function passport_verification($check_id)    {
$this->db->select('passport_no')
->from(DB_PREFIX . 'passport_verification as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function voter_id_verification($check_id)    {
$this->db->select('voter_id_no')
->from(DB_PREFIX . 'voter_id_verification as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function driving_licence_verification($check_id)    {
$this->db->select('driving_licence_no,valid_up_to')
->from(DB_PREFIX . 'driving_licence_verification as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function cibil_check($check_id)    {
$this->db->select('date_of_birth,pan_card_no,credit_score')
->from(DB_PREFIX .'cibil_check as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function court_record_check_lf($check_id)
{
$this->db->select('permanent_address,pincode')
->from(DB_PREFIX .'court_record_check_lf as a')
->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function court_record_check($check_id)
{
$this->db->select('can_policestation,pincode')
->from(DB_PREFIX .'court_record_check as a')
->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function ofac($check_id)    {
$this->db->select('permanent_address,int_country,nationality')
->from(DB_PREFIX .'ofac as a')
->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function form_16_verification($check_id)    {
$this->db->select('date_of_birth,pancard_no,assessment_year')
->from(DB_PREFIX .'form_16_verification as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function us_travel_verification($check_id)    {
$this->db->select('date_of_birth,passport_no')
->from(DB_PREFIX .'us_travel_verification as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
function police_current_address_verification($check_id)
{
$this->db->select('current_address,cpincode')
->from(DB_PREFIX . 'police_current_address_verification as a')
->where('a.checkid', $check_id);
return $this->db->get()->row_array();
}
/* exporting qc2 allotted list */
function export_qc1list($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {
    $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,
    concat_ws(' ',us.first_name,us.last_name) as qcname,vl1.v_date,vl1.supplementary,concat_ws(' ',vm.first_name,vm.last_name) as vmname,ar.qc_revert_date";

     $from = "   FROM " . DB_PREFIX . "verification_request a 
                                 LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
                                 LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
                                 LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
                                 LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
                                 LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
                                 LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation

                                 LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
                                 LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
                                 LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id
                                 LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
                                 LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
                                 LEFT JOIN " . DB_PREFIX . "qc_request qc ON qc.request_id=a.request_id
                                 LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
                                LEFT JOIN " . DB_PREFIX . "user vm ON vm.id=vl1.verified_by
                                 JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
                                 where 1  and a.assignee_status=1 and ar.verify_status in (111,110,519) AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id and qc.assignee_id != 0 ";
               
                
    if ($searchCond) {
        $from .= " and $searchCond";
    }
    /* qc1 verification*/
    if($this->session->userdata('role_id')==4){
        $from .=" and o.dedicated_qc=4 and qc.assignee_id =".$this->session->userdata('userid')." and (vl1.qcstatus IN (0,107) or ( ar.qc1_assign_revert=0 and ar.qc2_revert_request=1 )) ";
    }
    /* qc2 verification*/
    if($this->session->userdata('role_id')==17){
        $from .=" and qc1_verification=1 ";
    }
    if($this->session->userdata('role_id')==1){
        $from .=" and o.dedicated_qc=4 and (vl1.qcstatus IN (0,107) or ( ar.qc1_assign_revert=0 and ar.qc2_revert_request=1 )) ";
    }

            if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count "; 
            
            if ($pg >= 0 && $type <> 'count') { 
                     $from .= " group by ar.rep_id order by v_date desc " ;
            }

    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    return $query->result_array();
}

function export_qc1userlist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')    {

    $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,r.candidate_name,p.office_name as parent_office,s.office_name as sub_office,o.org_name,r.case_no";
    $from = "   FROM " . DB_PREFIX . "client_request r  
    LEFT JOIN  " . DB_PREFIX . "verification_request a ON a.request_id=r.request_id
    LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id=a.request_id
    LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = r.request_id
    LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id = ar.candidate_req_id and vl1.check_id = ar.check_id and vl1.level_id = ar.level_id
    LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
    LEFT JOIN " . DB_PREFIX . "office c ON c.id=r.office
    LEFT JOIN " . DB_PREFIX . "office p ON p.id=r.parent_office
    LEFT JOIN " . DB_PREFIX . "office s ON s.id=r.sub_office
    LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=r.organisation 
    LEFT JOIN " . DB_PREFIX . "qc_request q ON q.request_id=r.request_id
    JOIN " . DB_PREFIX . "user t ON t.id = r.user_id and t.active_status != 3
    where 1  and a.assignee_status=1 and ar.verify_status in (111,110,519) and o.dedicated_qc=4 ";

    if ($searchCond) {
    $from .= " and $searchCond";
    }
    if ($type == 'count') $select = "count(DISTINCT(a.request_id)) as count "; 

    if ($pg >= 0 && $type <> 'count') { 
    $from .= " group by a.request_id order by vs.request_id desc ";
    }

    $sql = "SELECT " . $select . "" . $from;
    $query = $this->db->query($sql);
    return $query->result_array();
    }

/* quality check2 alloted list for export */
     function export_qc2allottedlist($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   {
        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, vs.qc1_status,vs.qc1_discrapancy,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,ar.qc_2_verification,ar.qc2_report_publish,ar.reopen_revert_qc2,vl1.qc2status,vl1.v_date,vl1.qc_date,concat_ws(' ',us.first_name,us.last_name) as qc2name,vl1.supplementary,concat_ws(' ',vm.first_name,vm.last_name) as vmname,ar.qc2_revert_date ";

         $from = "   FROM " . DB_PREFIX . "verification_request a 
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
         LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation
         
         LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
         LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id 
         LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
         LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
         LEFT JOIN " . DB_PREFIX . "user vm ON vm.id=vl1.verified_by
          JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
         where 1  and a.assignee_status=1 and ar.verify_status in (111,110,519) AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id and qc1_verification=1 ";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        
        /* qc2 verification*/
        if($this->session->userdata('role_id')==17 ){
            $from .="  and ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish != 3 else ar.qc2_report_publish != 1 END ) and qc.assignee_id =".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and qc.assignee_id != 0 and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }
        else{
            $from .= " and qc.assignee_id != 0 ";
        }
        
                
               if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count ";
                
                if ($pg >= 0 && $type <> 'count') {  
                         $from .= " group by ar.rep_id order by $sBy $sOrder ";
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    } 
/* export of qc2 allocation list */
    function export_qc2userlist($pg = 0, $limit = 15, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')    {

        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,r.candidate_name,p.office_name as parent_office,s.office_name as sub_office,o.org_name,r.case_no,min(vl1.v_date) as vm_date ";
                                 $from = "   FROM " . DB_PREFIX . "client_request r  
                                 JOIN  " . DB_PREFIX . "verification_request a ON a.request_id=r.request_id and a.qc_assignee_status=1
                                 JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id=a.request_id
                                 JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = r.request_id and ar.qc1_verification=1
                                 LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=ar.candidate_req_id and vl1.check_id=ar.check_id and vl1.level_id=ar.level_id
                                 LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
                                 LEFT JOIN " . DB_PREFIX . "office c ON c.id=r.office
                                 LEFT JOIN " . DB_PREFIX . "office p ON p.id=r.parent_office
                                 LEFT JOIN " . DB_PREFIX . "office s ON s.id=r.sub_office
                                 LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=r.organisation
                                 LEFT JOIN " . DB_PREFIX . "qc2_request q ON q.request_id=r.request_id
                                  JOIN " . DB_PREFIX . "user t ON t.id = r.user_id and t.active_status != 3
                                 where 1 and ar.verify_status in (111,110,519)  ";
        if($this->session->userdata('role_id')==17){
            $from .=" and ar.qc1_verification=1 ";
        }           
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        if($this->session->userdata('role_id')==4){
            $from .=" and o.dedicated_qc=4 ";
        }
                if ($type == 'count') $select = "count(DISTINCT(a.request_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                       $from .= " group by a.request_id order by vs.request_id desc " ;
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    function export_vmallottedlist ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') {  
    // edited by amritha on 23/06/2023  
        $select = " a.candidate_req_id,a.vm_revert_to,a.ass_request, a.qc_revert_request, a.vm_assigned_qc, d.candidate_name as candidatename, c.name as skillname,a.level_id,
        p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,
        s.vm_revert_option_status,s.operator_submited_by,d.order_id as ordercode,
        d.vm_revert_supervisor, f.order_name,c.name as checkname,c.id as checkId,vs.name as status,verify_status,a.check_id as checkid,a.vm_revert_status as rstatus, ass_request, vm_revert_request as vrequest, a.pack_id, d.case_no, o.org_name, a.count_of_chk as chk, concat_ws(' ',us.first_name,us.middle_name,us.last_name) as vname, vr.deadline_from, vr.deadline_to,vl1.reqstatus,vl1.supplementary,a.additional_docs,a.reopen_revert_qc,a.reopen_revert_qc2,vl1.v_date,td.ticket_status, td.requested_date,
        vl1.vm_request_raised_date,ct.verification_tat,(5 * (DATEDIFF(CURDATE(), date(vr.deadline_from)) DIV 7) + MID('0123444401233334012222340111123400012345001234550', 7 * WEEKDAY(date(vr.deadline_from)) + WEEKDAY(CURDATE()) + 1, 1)) - (SELECT COUNT(*) FROM dcode_master_holidays WHERE status=1 and  holiday_date >= date(vr.deadline_from) and holiday_date <= CURDATE()) as Days";
        $from = "  from ".DB_PREFIX ."ver_assign_rep a
        LEFT JOIN ".DB_PREFIX ."personal_details b ON b.user_id = a.candidate_req_id
        LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."customer_tat ct ON ct.check_id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = b.user_id
        LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
        LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
        LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
        LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
        LEFT JOIN   ".DB_PREFIX ."order f ON f.id = d.order_id
        LEFT JOIN ".DB_PREFIX ."submit_cv s ON s.request_id = a.candidate_req_id
        LEFT JOIN ".DB_PREFIX ."employment em ON em.id = a.level_id and a.check_id=em.checkid
        LEFT JOIN ".DB_PREFIX ."education_details ed ON ed.id = a.level_id and a.check_id=ed.checkid
        LEFT JOIN ".DB_PREFIX ."professional_reference pr ON pr.id = a.level_id and a.check_id=pr.checkid
        LEFT JOIN ".DB_PREFIX ."master_masterdata vs ON vs.id = a.verify_status 
        LEFT JOIN ".DB_PREFIX ."ticket_details td ON td.request_id = a.candidate_req_id and td.check_id=a.check_id and td.level_id=a.level_id and td.current_status=1 
        LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id
        JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3
        LEFT JOIN ".DB_PREFIX ."verification_request vr ON vr.request_id = a.candidate_req_id and vr.check_id=a.check_id and vr.level_id=a.level_id and vr.pack_id=a.pack_id 
        LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.candidate_req_id and vl1.check_id=a.check_id and vl1.level_id=a.level_id";       
                    
        if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==24 || $this->session->userdata['role_id']==9) {
             $from .= " WHERE 1=1 ";
        }  
        else if($this->session->userdata['role_id']==21) {
            $from .= " WHERE o.crm_userid = ".$this->session->userdata['userid']." and vr.deadline_from<>'' ";
        }  
        else{
        $from .= " WHERE  a.team_mem_id = ".$this->session->userdata['userid']." and (a.verify_status =107 or a.vm_assigned_qc=0 or a.verify_status =684 or a.verify_status =992 ) and vr.deadline_from<>'' " ;
        }

        if ($searchCond) {
        $from .= " and $searchCond";
        }                   
        if ($type == 'count') $select = "count(DISTINCT(a.rep_id)) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " group by a.rep_id order by $sBy $sOrder";
        }

        $sql = "SELECT " . $select . "" . $from;
       
        $query = $this->db->query($sql);
        return $query->result_array();
    }

     /* get check details of particular case */
    function export_checkstatus ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
      
        $select = " a.candidate_req_id,a.vm_revert_to,a.ass_request,a.qc_revert_request, a.vm_assigned_qc, d.candidate_name as candidatename, c.name as skillname,a.level_id,
        p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,
        s.vm_revert_option_status,s.operator_submited_by,d.order_id as ordercode,
        d.vm_revert_supervisor, f.order_name,c.name as checkname,c.id as checkId,vs.name as status,verify_status,a.check_id ,a.vm_revert_status as rstatus, ass_request, vm_revert_request as vrequest, a.pack_id, d.case_no, o.org_name, a.count_of_chk as chk, concat_ws(' ',us.first_name,us.middle_name,us.last_name) as vname,concat_ws(' ',us1.first_name,us1.middle_name,us1.last_name) as qcname,concat_ws(' ',us2.first_name,us2.middle_name,us2.last_name) as qc2name, vr.deadline_from as vm_allotted_date, vr.deadline_to,a.qc1_assign_revert,a.qc1_verification,a.qc2_revert_request,a.qc2_verification,vl1.status as vmstatus,a.qc_2_verification,a.qc2_report_publish,vl1.qc2status,vl1.v_date,vl1.qc_date,vl1.qc2_date,a.count_of_chk,d.assignee_id as operator_id,s.operator_submit_date,em.company_name,pr.company_name as pcompany_name,ed.collegename_add,ed.affliated,ed.degree,d.created_on,s.client_submit_date, s.candidate_submit_date,d.dataentry_by,s.verification_date as vs_allotted_date,d.case_recieved_date,d.case_accepted_date,ct.check_tat,(5 * (DATEDIFF(date(vl1.qc2_date), date(d.deadline_from)) DIV 7) + MID('0123444401233334012222340111123400012345001234550', 7 * WEEKDAY(date(d.deadline_from)) + WEEKDAY(date(vl1.qc2_date)) + 1, 1)) - (SELECT COUNT(*) FROM dcode_master_holidays WHERE status=1 and  holiday_date >= date(d.deadline_from) and holiday_date <= date(vl1.qc2_date)) as finaldatetat, (5 * (DATEDIFF(CURDATE(), date(d.case_accepted_date)) DIV 7) + MID('0123444401233334012222340111123400012345001234550', 7 * WEEKDAY(date(d.case_accepted_date)) + WEEKDAY(CURDATE()) + 1, 1)) - (SELECT COUNT(*) FROM dcode_master_holidays WHERE status=1 and  holiday_date >= date(d.case_accepted_date) and holiday_date <= CURDATE()) as Days";
          $from = " from
                      ".DB_PREFIX ."ver_assign_rep a
                      LEFT JOIN ".DB_PREFIX ."personal_details b ON b.user_id = a.candidate_req_id
                      LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
                      LEFT JOIN  ".DB_PREFIX ."customer_tat ct ON ct.check_id = a.check_id
                          LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = b.user_id
                          LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
                      LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
                      LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
                       LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
                     LEFT JOIN   ".DB_PREFIX ."order f ON f.id = d.order_id
                     JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3
                       LEFT JOIN ".DB_PREFIX ."submit_cv s ON s.request_id = a.candidate_req_id
                       LEFT JOIN ".DB_PREFIX ."employment em ON em.id = a.level_id and a.check_id=59
                       LEFT JOIN ".DB_PREFIX ."education_details ed ON ed.id = a.level_id and a.check_id=14
                    LEFT JOIN ".DB_PREFIX ."professional_reference pr ON pr.id = a.level_id and a.check_id=68

                     LEFT JOIN ".DB_PREFIX ."master_masterdata vs ON vs.id = a.verify_status
                     LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id
                     LEFT JOIN ".DB_PREFIX ."verification_request vr ON vr.request_id = a.candidate_req_id and vr.check_id=a.check_id and vr.level_id=a.level_id and vr.pack_id=a.pack_id
                     LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.candidate_req_id and vl1.level_id=a.level_id and vl1.check_id=a.check_id
                     LEFT JOIN ".DB_PREFIX ."user us1 ON us1.id = vl1.qcverified_by
                     LEFT JOIN ".DB_PREFIX ."user us2 ON us2.id = vl1.qc2verified_by  WHERE 1=1";  
        if($this->session->userdata('user_type') == 1 && $this->session->userdata('role_id')==21 )
        {
            $from .= " and o.crm_userid = ".$this->session->userdata['userid']."  ";
        } 

        $from .= " and (CASE WHEN ct.org_id !=0 THEN ct.org_id=o.id ELSE ct.org_id=0 END) and ct.tat_status=1 ";

        if ($searchCond) {
            $from .= " and $searchCond";
        }

                if ($type == 'count') $select = "count(DISTINCT(a.rep_id)) as count  ";
               
                if ($pg >= 0 && $type <> 'count') {
                        $from .= " group by a.rep_id order by a.candidate_req_id desc";
                }
       
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function export_caseallotment($pg = 0, $limit = 10, $sBy = 'request_id', $sOrder = 'desc', $searchCond = '',$type='') { 

                $select = "a.request_id,a.candidate_name,c.org_name,b.office_name,d.office_name as parent_office,e.order_name,a.assainee_status,a.deadline_to,f.first_name, c.dedicated_operator as oprid,dataentry_by,o.office_name as sub_office,cv.reverted_by,cv.reverted_reason,a.case_no,cv.client_submit_date";
                        
                $from = "   FROM " . DB_PREFIX . "client_request a 
                LEFT JOIN " . DB_PREFIX . "office d ON d.id=a.parent_office
                LEFT    JOIN " . DB_PREFIX . "office b ON b.id=a.office
                LEFT  JOIN " . DB_PREFIX . "organisation c ON c.id=a.organisation
              JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
              LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office 
              LEFT JOIN " . DB_PREFIX . "user f ON f.id=a.assignee_id
               JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3
              LEFT JOIN " . DB_PREFIX . "submit_cv cv ON cv.request_id=a.request_id
                                where 1   AND client_status=1 ";
            if($this->session->userdata['user_type'] == 2 ) {
            $from .= "and (a.dataentry_by = 1  || a.dataentry_by = 3 )";
            } else {
            $from .= " and a.dataentry_by <> 3 ";
            }
            if($this->session->userdata['user_type'] == 1 &&  $this->session->userdata['role_id'] == 3) {
            $from .= " and( a.assainee_status = 0 or ( a.dataentry_by = 1 and a.assignee_id=0 ))";
            } 
            if ($searchCond) {
            $from .= " and $searchCond";
            }

                if ($type == 'count') $select = "count(*) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                       $from .= " order by a.request_id desc ";
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }
    function export_insufficiency ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
    $roleid= $this->session->userdata('role_id'); 
   $usertype= $this->session->userdata('user_type'); 
                $select = "a.request_id,a.candidate_name,c.org_name,b.office_name,p.office_name as parent_office,e.order_name,cv.insufficiency_report,o.office_name as sub_office,cv.created_date,a.case_no,cv.emp_code";
                        
              $from = "   FROM " . DB_PREFIX . "client_request a 
                      LEFT JOIN " . DB_PREFIX . "office b ON b.id = a.office 
                      LEFT JOIN " . DB_PREFIX . "office p ON p.id = a.parent_office 
                      LEFT JOIN " . DB_PREFIX . "organisation c ON c.id = a.organisation
                      LEFT JOIN " . DB_PREFIX . "order e ON e.id=a.order_id
                      LEFT JOIN " . DB_PREFIX . "office o ON o.id=a.sub_office
                      LEFT JOIN " . DB_PREFIX . "user f ON f.id = a.created_by
                      JOIN " . DB_PREFIX . "user t ON t.id = a.user_id and t.active_status != 3
                      LEFT JOIN " . DB_PREFIX . "user_headoffices h ON h.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "user_branchoffices br ON br.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "user_suboffices so ON so.user_id=f.id
                      LEFT JOIN " . DB_PREFIX . "insufficiency cv ON cv.request_id=a.request_id
                      where 1 AND cv.insufficiency_report IS NOT NULL and cv.status=1 ";
                $poffice=implode(",", $this->session->userdata['poffice'] );
                    $boffice=implode(",", $this->session->userdata['boffice'] );
                    $soffice=implode(",", $this->session->userdata['soffice'] );
                if($usertype == 2 && $roleid==12 )
                {

                  if(empty($boffice) and empty($soffice)){
                    $from .= " and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                    else if(!empty($boffice) and empty($soffice)){
                    $from .= " and h.parent_office in (".$poffice." ) and br.branch_office in (".$boffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                  }
                  else{
                         $from .= " and h.parent_office in (".$poffice." ) and br.branch_office in (".$boffice." ) and so.sub_office in (".$soffice." ) and c.id=".$this->session->userdata['parentoffice_id'];
                      }
                }    
                else if($usertype == 2 && $roleid==13 )
               {
                    $from .= " and a.created_by = ".$this->session->userdata['userid'];
               } 
               else if($usertype == 2 && $roleid==14 )
               {
                    $from .= " and a.created_by = ".$this->session->userdata['userid'];
               }
               else if($usertype == 1 && $roleid==21 )
                {
                    $from .= " and c.crm_userid = ".$this->session->userdata['userid']."  ";
                } 
               else 
               {
                    $from .= "";
               }             
                if ($searchCond) {
            $from .= " and $searchCond";
        }

                if ($type == 'count') $select = "count(*) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                       $from .= " group by a.request_id order by a.request_id desc ";
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    function international_criminal_check(){
       $this->db->select('permanent_address')
        ->from(DB_PREFIX .'court_record_check_lf as a')
        ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
        ->where('a.checkid', $check_id);
        return $this->db->get()->row_array();
    }
        //international address check current

   function international_address_check_current_address($check_id)   {
        $this->db->select('current_address')
         ->from(DB_PREFIX . 'international_address_check_current_address as a')
        ->where('a.checkid', $check_id);
        return $this->db->get()->row_array();
    }
    function international_address_check_permanent_address($check_id){
        $this->db->select('permanent_address')
        ->from(DB_PREFIX . 'international_address_check_permanent_address as a')
        ->where('a.checkid', $check_id);
        return $this->db->get()->row_array();
    }

    function international_bankruptcy_check_individual($check_id){
      
         $this->db->select('email_id,date_of_birth,idcardno')
        ->from(DB_PREFIX . 'international_bankruptcy_check_individual as a')
        ->where('a.checkid', $check_id);
        return $this->db->get()->row_array();

    }

    function form_26as($check_id)   {

        $this->db->select('date_of_birth,pancard_no')
        ->from(DB_PREFIX .'form_26as as a')
        ->where('a.checkid', $check_id);
        return $this->db->get()->row_array();
    }

    function professional_reference_check_colleague($check_id)   {

        $this->db->select('college_name,college_designation,college_email_id,college_contact_no,period_of_reference,reference_relationship,reason')
        ->from(DB_PREFIX .'professional_reference_check_colleague as a')
        ->where('a.checkid', $check_id);
        return $this->db->get()->row_array();
    }
   function facis($check_id)
    {
        $this->db->select('a.id')
        ->from(DB_PREFIX . 'facis as a')
        ->where('a.checkid', $check_id);
        return $this->db->get()->row_array();
    }

    // function international_credit_check($check_id)
    // {
    //     $this->db->select('id')
    //     ->from(DB_PREFIX . 'international_credit_check as a')
    //     ->where('a.checkid', $check_id);
    //     return $this->db->get()->row_array();
    // }

    function export_vm_allottedlist ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') {    
        $select = " a.candidate_req_id, d.candidate_name as candidatename, a.level_id,
        p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,
        c.name as checkname,c.id as checkId,vs.name as status,verify_status,a.check_id as checkid,a.vm_revert_status as rstatus, ass_request, vm_revert_request as vrequest, a.pack_id, d.case_no, o.org_name, a.count_of_chk as chk, pc.father_name,pc.permanent_address,pc.mobile,pc.pincode,pc.district,pc.state,cd.father_name as cfather_name, cd.current_address, cd.cmobile, cd.cpincode, cd.district as cdistrict, cd.state as cstate";
          $from = "  from
                      ".DB_PREFIX ."ver_assign_rep a
                      LEFT JOIN ".DB_PREFIX ."personal_details b ON b.user_id = a.candidate_req_id
                      LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
                          LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = b.user_id
                          LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
                      LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
                      LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
                       LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
                     LEFT JOIN   ".DB_PREFIX ."order f ON f.id = d.order_id
                       LEFT JOIN ".DB_PREFIX ."submit_cv s ON s.request_id = a.candidate_req_id
                       LEFT JOIN ".DB_PREFIX ."employment em ON em.id = a.level_id and a.check_id=em.checkid
                       LEFT JOIN ".DB_PREFIX ."education_details ed ON ed.id = a.level_id and a.check_id=ed.checkid
                        LEFT JOIN ".DB_PREFIX ."permanent_contact_details pc ON pc.id = a.level_id and a.check_id=pc.checkid
                        LEFT JOIN ".DB_PREFIX ."contact_details cd ON cd.id = a.level_id and a.check_id=cd.checkid
                    LEFT JOIN ".DB_PREFIX ."professional_reference pr ON pr.id = a.level_id and a.check_id=pr.checkid
                     LEFT JOIN ".DB_PREFIX ."master_masterdata vs ON vs.id = a.verify_status 
                     LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id
                      JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3
                     LEFT JOIN ".DB_PREFIX ."verification_request vr ON vr.request_id = a.candidate_req_id and vr.check_id=a.check_id and vr.level_id=a.level_id and vr.pack_id=a.pack_id
                     LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.candidate_req_id and vl1.check_id=a.check_id and vl1.level_id=a.level_id";     
                     
        if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==9 || $this->session->userdata['role_id']==24)   
                $from .= " WHERE 1=1 ";
       else if($this->session->userdata['role_id']==21)   
              $from .= " WHERE o.crm_userid = ".$this->session->userdata['userid']." and vr.deadline_from<>'' and c.id in(15,16)";
        else{
        $from .= " WHERE  a.team_mem_id = ".$this->session->userdata['userid']." and (a.verify_status =107 or a.vm_assigned_qc=0 or a.verify_status =684 ) and vr.deadline_from<>'' and c.id in(15,16)" ;
        }
                
        if ($searchCond) {
            $from .= " and $searchCond";
        }

                if ($type == 'count') $select = "count(DISTINCT(a.rep_id)) as count "; 
                
                if ($pg >= 0 && $type <> 'count') { 
                        $from .= " group by a.rep_id order by a.candidate_req_id desc,a.rep_id desc ";
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }


    function export_qc2revertraised($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='')   { 
        $select = "a.vrequest_id,a.request_id,b.first_name,c.office_name,c.locality,cr.candidate_name,cr.qc1_assignstatus, r.reverted_date, r.comments,r.revertreason,md.name,ar.check_id,ar.level_id,vl1.status,qc1_verification,qc2_verification,ar.qc_revert_status,ar.qc_revert_request,ar.qc2_revert_request,ar.pack_id,ar.qc2_revert_status,vl1.upload_document,vl1.qc_date,ar.vm_assigned_qc,ar.qc1_assign_revert,o.org_name,d.office_name as parent_office,s.office_name as sub_office,cr.case_no,o.org_name,ar.count_of_chk as chk,ar.qc_2_verification,ar.qc2_report_publish,vl1.qc2status,vl1.v_date,vl1.qc_date,concat_ws(' ',us.first_name,us.last_name) as qcname,vl1.supplementary,concat_ws(' ',vm.first_name,vm.last_name) as vmname,ar.qc2_revert_date";

         $from = "   FROM " . DB_PREFIX . "verification_request a 
         LEFT JOIN " . DB_PREFIX . "user b ON b.id=a.assignee_id
         LEFT JOIN " . DB_PREFIX . "client_request cr ON cr.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "office d ON d.id = cr.parent_office
         LEFT JOIN " . DB_PREFIX . "office c ON c.id = cr.office
         LEFT JOIN " . DB_PREFIX . "office s ON s.id = cr.sub_office
         LEFT JOIN " . DB_PREFIX . "organisation o ON o.id=cr.organisation
         LEFT JOIN " . DB_PREFIX . "revert_history r ON r.request_id = cr.request_id
         LEFT JOIN " . DB_PREFIX . "order e ON e.id=cr.order_id
         LEFT JOIN " . DB_PREFIX . "verification_status vs ON vs.request_id = a.request_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "ver_assign_rep ar ON ar.candidate_req_id = a.request_id 
         LEFT JOIN " . DB_PREFIX . "master_masterdata md ON md.id = ar.check_id
         LEFT JOIN " . DB_PREFIX . "qc2_request qc ON qc.request_id=a.request_id
         LEFT JOIN " . DB_PREFIX . "user us ON us.id=qc.assignee_id
         LEFT JOIN " . DB_PREFIX . "user vm ON vm.id=vl1.verified_by
          JOIN " . DB_PREFIX . "user t ON t.id = cr.user_id and t.active_status != 3
         where 1  and a.assignee_status=1 and ar.verify_status in (111,110,519) AND vl1.check_id=ar.check_id AND vl1.level_id=ar.level_id and qc1_verification=1 and ((ar.qc2_verification = 0 and ar.qc1_verification=1 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 2 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 2 and ar.qc1_assign_revert=1 and vl1.supplementary not in (1,2)) || (ar.qc_2_verification = 1 and ar.qc2_report_publish = 0 and ar.qc2_revert_request = 1 and ar.qc1_assign_revert = 0 and vl1.supplementary not in (1,2))) ";
                   
                    
        if ($searchCond) {
            $from .= " and $searchCond";
        }
        
        /* qc2 verification*/
       if($this->session->userdata('role_id')==17 ){
            $from .="  and ( CASE WHEN vl1.supplementary=1 THEN ar.qc2_report_publish != 2 else ar.qc2_report_publish != 1 END ) and qc.assignee_id =".$this->session->userdata('userid');
        }
        else if($this->session->userdata('role_id')==21){
            $from .= " and qc.assignee_id != 0 and o.crm_userid = ".$this->session->userdata['userid']." "; 
        }
        else{
            $from .= " and qc.assignee_id != 0 ";
        }
                
               if ($type == 'count') $select = "count(DISTINCT(ar.rep_id)) as count ";
                
                if ($pg >= 0 && $type <> 'count') { 
                         $from .= " group by ar.rep_id order by vl1.v_date desc ";
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);
        return $query->result_array();
    }


 function export_prioritycaselist ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
$usertype= $this->session->userdata('user_type');          
        $select = "a.candidate_req_id,a.vm_revert_to,a.ass_request,a.qc_revert_request, d.candidate_name as candidatename, a.level_id,
        p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,
        s.vm_revert_option_status,c.name as checkname,c.id as checkId,a.check_id as checkid,a.vm_revert_status as rstatus, vm_revert_request as vrequest, d.case_no,o.id,o.org_name, a.count_of_chk as chk,pri.priority, pri.request_id,pri.comments,pri.date_ofset,pri.date_ofupdate, concat_ws(' ',us.first_name,us.middle_name,us.last_name) as vname";
        $from = "  from ".DB_PREFIX ."ver_assign_rep a  
             JOIN ".DB_PREFIX ."priority pri ON  pri.request_id = a.candidate_req_id
        LEFT JOIN ".DB_PREFIX ."personal_details b ON b.user_id = a.candidate_req_id
        LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = b.user_id

        LEFT JOIN  ".DB_PREFIX ."office p ON p.id = d.parent_office
        LEFT JOIN  ".DB_PREFIX ."office br ON br.id = d.office
        LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
        LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
        LEFT JOIN  ".DB_PREFIX ."submit_cv s ON s.request_id = a.candidate_req_id
        LEFT JOIN  ".DB_PREFIX ."verification_request vr ON vr.request_id = a.candidate_req_id and vr.check_id=a.check_id and vr.level_id=a.level_id and vr.pack_id=a.pack_id
         LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.candidate_req_id and vl1.check_id=a.check_id and vl1.level_id=a.level_id 
         LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id";  
               

       
                    $poffice=implode(",", $this->session->userdata['poffice'] );
                    $boffice=implode(",", $this->session->userdata['boffice'] );
                    $soffice=implode(",", $this->session->userdata['soffice'] );
                   
         if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==24 ||$this->session->userdata['role_id']==9 )  {
             
            $from .= " WHERE (a.verify_status != 111  or a.verify_status != 110 or a.verify_status != 519 )  and vr.deadline_from<>''AND pri.priority != 0 AND ( a.vm_revert_status != 111 AND  a.vm_revert_status != 110 AND a.vm_revert_status != 519  OR (a.vm_revert_status  = 0 OR a.vm_revert_status = 992 OR a.vm_revert_status = 107 )) ";
        } 
        
     else if($usertype == 2 && $this->session->userdata['role_id']==12)
                {

                  if(empty($boffice) and empty($soffice)){

                    $from .= "  WHERE pri.priority != 0 and d.parent_office in (".$poffice." )  and o.id=".$this->session->userdata['parentoffice_id'];
                     
                  }
                    else if(!empty($boffice) and empty($soffice)){
                        
                    $from .= "  WHERE  pri.priority != 0 and d.parent_office in (".$poffice." ) ";

                  }
                  else{
                         $from .= " WHERE  pri.priority != 0 and d.parent_office in (".$poffice." )"; 
                         
                      }
                } 


       else if($usertype == 2 && $this->session->userdata['role_id']==13 )
               {
                     if(empty($boffice) and empty($soffice)){
                    $from .= "  WHERE pri.priority != 0 and d.parent_office in (".$poffice." ) and o.id=".$this->session->userdata['parentoffice_id'];
                     
                  }
                    else if(!empty($boffice) and empty($soffice)){
                    $from .= "   WHERE pri.priority != 0 and d.parent_office in (".$poffice." ) and d.office in (".$boffice." ) and o.id=".$this->session->userdata['parentoffice_id'];
                    
                  }
                  else{
                         $from .= "  WHERE pri.priority != 0 and d.parent_office in (".$poffice." ) and d.office in (".$boffice." ) and d.sub_office in (".$soffice." ) and o.id=".$this->session->userdata['parentoffice_id'];
                         
                      }                
                    $from .= " and ( d.dataentry_by = 3 or d.created_by = ".$this->session->userdata['userid']." ) ";
                    
               } 
        
        else{
        $from .= " WHERE  a.team_mem_id = ".$this->session->userdata['userid']." and (a.verify_status != 111  or a.verify_status != 110 or a.verify_status != 519  )  and vr.deadline_from<>''AND pri.priority != 0 AND ( a.vm_revert_status != 111 AND  a.vm_revert_status != 110 AND a.vm_revert_status != 519  OR (a.vm_revert_status  = 0 OR a.vm_revert_status = 992 OR a.vm_revert_status = 107 ) )" ;
        }

        if ($searchCond) {
        $from .= " and $searchCond";
        }                   
        if ($type == 'count') $select = "count(a.rep_id) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
                        $from .= "order by pri.id  $sOrder";
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);

        return $query->result_array();
    }
  



/*..................PF Verification .........................*/

function pf_verification($check_id)    {
        $this->db->select('PF_number')
        ->from(DB_PREFIX . 'pf_verification as a')
        ->where('a.checkid', $check_id);
        return $this->db->get()->row_array();
    }

/*..................END PF Verification .........................*/



function export_courtrecordlist ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') {    
        $select = " a.candidate_req_id,a.level_id,
        p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,d.case_no,c.id as checkId,vs.name as status,o.org_name,cr.father_name as crfather,lf.father_name as lffather,ind.father_name as indfather,cr.date_of_birth as crdob,lf.date_of_birth as lfdob,ind.date_of_birth as inddob,cr.firstname as crfirstname,cr.middlename as crmidname, cr.lastname as crlastname,lf.firstname as lffirstname,lf.middlename as lfmidname, lf.lastname as lflastname,ind.firstname as indfirstname,ind.middlename as indmidname, ind.lastname as indlastname,cr.address as craddress,lf.permanent_address as lfaddress,ind.address as indaddress,cr.level_name as crlevelname, cr.pincode as crpincode, lf.pincode as lfpincode";
        $from = "  from ".DB_PREFIX ."ver_assign_rep a
        LEFT JOIN ".DB_PREFIX ."personal_details b ON b.user_id = a.candidate_req_id
        LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
        
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = b.user_id
        LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
        LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
        LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
        LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
        LEFT JOIN   ".DB_PREFIX ."order f ON f.id = d.order_id
        
        LEFT JOIN ".DB_PREFIX ."court_record_check cr ON cr.id = a.level_id and a.check_id=cr.checkid

        LEFT JOIN ".DB_PREFIX ."court_record_check_lf lf ON lf.id = a.level_id and a.check_id=lf.checkid
        LEFT JOIN ".DB_PREFIX ."court_record_check_india ind ON ind.id = a.level_id and a.check_id=ind.checkid
        LEFT JOIN ".DB_PREFIX ."master_masterdata vs ON vs.id = a.verify_status 
        LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id
       
        JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3";
        if($this->session->userdata['role_id']==1 )
        {
          $from .= " WHERE   a.check_id IN (71,639,640) AND a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0";       
        }
        else{
         $from .= " WHERE  a.team_mem_id = ".$this->session->userdata['userid']." AND  a.check_id IN (71,639,640) AND a.vm_revert_to=0 and a.qc_revert_request = 0 and a.verify_status<>111 and a.vm_revert_request=0 and a.ass_request =0";
        }  
                     
      
        if ($searchCond) {
        $from .= " and $searchCond";
        }                   
        if ($type == 'count') $select = "count(DISTINCT(a.rep_id)) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
                        $from .= " group by a.rep_id order by $sBy $sOrder  ";
                }
        
        $sql = "SELECT " . $select . "" . $from;
        $query = $this->db->query($sql);

        return $query->result_array();
    }

function international_civil_check(){
       $this->db->select('permanent_address')
        ->from(DB_PREFIX .'court_record_check_lf as a')
        ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
        ->where('a.checkid', $check_id);
        return $this->db->get()->row_array();
    }
function international_corruption_record_check(){
       $this->db->select('permanent_address')
        ->from(DB_PREFIX .'court_record_check_lf as a')
        ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
        ->where('a.checkid', $check_id);
        return $this->db->get()->row_array();
    }

    function international_credit_check(){
       $this->db->select('permanent_address')
        ->from(DB_PREFIX .'court_record_check_lf as a')
        ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
        ->where('a.checkid', $check_id);
        return $this->db->get()->row_array();
    }

    function gap_analysis_check(){
       $this->db->select('permanent_address')
        ->from(DB_PREFIX .'court_record_check_lf as a')
        ->join(DB_PREFIX.'master_usertype m','m.id=a.title','left')
        ->where('a.checkid', $check_id);
        return $this->db->get()->row_array();
    }



    function export_newcheckstatus ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') { 
      
        $select = " a.candidate_req_id,a.vm_revert_to,a.ass_request, a.qc_revert_request, a.vm_assigned_qc, d.candidate_name as candidatename, a.level_id,s.vm_revert_option_status,s.operator_submited_by,d.vm_revert_supervisor,c.name as checkname,verify_status,a.check_id ,a.vm_revert_status as rstatus, vm_revert_request as vrequest, d.case_no, a.qc1_assign_revert,a.qc1_verification,a.qc2_revert_request,a.qc2_verification,vl1.status as vmstatus,a.qc_2_verification,a.qc2_report_publish,vl1.qc2_date,a.count_of_chk,d.created_on,d.dataentry_by,d.case_recieved_date,d.case_accepted_date, a.reopen_revert_qc2,em.company_name,t.email,pr.company_name as pcompany_name,ed.collegename_add,ed.affliated,ed.degree, vl1.supplementary, td.ticket_status,td.ticket_details,tc.tat_overall,tc.wait_ticket";
          $from = "  from
                    ".DB_PREFIX ."ver_assign_rep a
                    LEFT JOIN ".DB_PREFIX ."personal_details b ON b.user_id = a.candidate_req_id
                    LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
                    LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = b.user_id
                    LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
                    LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
                    LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
                    LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
                    JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3
                    LEFT JOIN ".DB_PREFIX ."submit_cv s ON s.request_id = a.candidate_req_id
                    LEFT JOIN ".DB_PREFIX ."employment em ON em.id = a.level_id and a.check_id=59
                    LEFT JOIN ".DB_PREFIX ."education_details ed ON ed.id = a.level_id and a.check_id=14
                    LEFT JOIN ".DB_PREFIX ."professional_reference pr ON pr.id = a.level_id and a.check_id=68
                    LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.candidate_req_id and vl1.level_id=a.level_id and vl1.check_id=a.check_id
                    LEFT JOIN " . DB_PREFIX . "ticket_details td ON td.request_id=vl1.request_id and td.check_id=vl1.check_id and td.level_id=vl1.level_id and td.current_status=1
                    LEFT JOIN ". DB_PREFIX . "tat_checks tc ON tc.request_id=a.candidate_req_id and tc.check_id=a.check_id and tc.level_id=a.level_id
                    WHERE 1=1 ";  
                if($this->session->userdata('user_type') == 1 && $this->session->userdata('role_id')==21 )
                {
                    $from .= " and o.crm_userid = ".$this->session->userdata['userid']."  ";
                } 

                // $from .= " and (CASE WHEN ct.org_id !=0 THEN ct.org_id=o.id ELSE ct.org_id=0 END) and ct.tat_status=1 ";

                if ($searchCond) {
                    $from .= " and $searchCond";
                }

                if ($type == 'count') $select = "count(DISTINCT(a.rep_id)) as count  ";
                   
                if ($pg >= 0 && $type <> 'count') {
                    $from .= " group by a.rep_id order by a.candidate_req_id desc";
                }
       
                $sql = "SELECT " . $select . "" . $from;
                $query = $this->db->query($sql);
                return $query->result_array();
    }




    function export_vmpendinglists ($pg = 0, $limit = 10, $sBy = '', $sOrder = 'desc', $searchCond = '',$type='') {  
    // edited by amritha on 23/06/2023  
        $select = " a.candidate_req_id,a.vm_revert_to,a.ass_request, a.qc_revert_request, a.vm_assigned_qc, d.candidate_name as candidatename, c.name as skillname,a.level_id,
        p.office_name as parent_office,br.office_name as office_name,su.office_name as sub_office,
        s.vm_revert_option_status,s.operator_submited_by,d.order_id as ordercode,
        d.vm_revert_supervisor, f.order_name,c.name as checkname,c.id as checkId,vs.name as status,verify_status,a.check_id as checkid,a.vm_revert_status as rstatus, ass_request, vm_revert_request as vrequest, a.pack_id, d.case_no, o.org_name, a.count_of_chk as chk, concat_ws(' ',us.first_name,us.middle_name,us.last_name) as vname, vr.deadline_from, vr.deadline_to,vl1.reqstatus,vl1.supplementary,a.additional_docs,a.reopen_revert_qc,a.reopen_revert_qc2,vl1.v_date,td.ticket_status, td.requested_date,
        vl1.vm_request_raised_date,ct.verification_tat,(5 * (DATEDIFF(CURDATE(), date(vr.deadline_from)) DIV 7) + MID('0123444401233334012222340111123400012345001234550', 7 * WEEKDAY(date(vr.deadline_from)) + WEEKDAY(CURDATE()) + 1, 1)) - (SELECT COUNT(*) FROM dcode_master_holidays WHERE status=1 and  holiday_date >= date(vr.deadline_from) and holiday_date <= CURDATE()) as Days";
        $from = "  from ".DB_PREFIX ."ver_assign_rep a
        LEFT JOIN ".DB_PREFIX ."personal_details b ON b.user_id = a.candidate_req_id
        LEFT JOIN  ".DB_PREFIX ."master_masterdata c ON c.id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."customer_tat ct ON ct.check_id = a.check_id
        LEFT JOIN  ".DB_PREFIX ."client_request d ON d.request_id = b.user_id
        LEFT JOIN ".DB_PREFIX ."office p ON p.id = d.parent_office
        LEFT JOIN ".DB_PREFIX ."office br ON br.id = d.office
        LEFT JOIN  ".DB_PREFIX ."office su ON su.id = d.sub_office
        LEFT JOIN  ".DB_PREFIX ."organisation o ON o.id = p.parentoffice_id
        LEFT JOIN   ".DB_PREFIX ."order f ON f.id = d.order_id
        LEFT JOIN ".DB_PREFIX ."submit_cv s ON s.request_id = a.candidate_req_id
        LEFT JOIN ".DB_PREFIX ."master_masterdata vs ON vs.id = a.verify_status 
        LEFT JOIN ".DB_PREFIX ."ticket_details td ON td.request_id = a.candidate_req_id and td.check_id=a.check_id and td.level_id=a.level_id and td.current_status=1 
        LEFT JOIN ".DB_PREFIX ."user us ON us.id = a.team_mem_id
        JOIN " . DB_PREFIX . "user t ON t.id = d.user_id and t.active_status != 3
        LEFT JOIN ".DB_PREFIX ."verification_request vr ON vr.request_id = a.candidate_req_id and vr.check_id=a.check_id and vr.level_id=a.level_id and vr.pack_id=a.pack_id 
        LEFT JOIN " . DB_PREFIX . "verified_level vl1 ON vl1.request_id=a.candidate_req_id and vl1.check_id=a.check_id and vl1.level_id=a.level_id";       
                    
        if($this->session->userdata['role_id']==1 || $this->session->userdata['role_id']==24 || $this->session->userdata['role_id']==9) {
             $from .= " WHERE (a.verify_status =107 or a.vm_assigned_qc=0 or a.verify_status =684 or a.verify_status =992 ) and vr.deadline_from<>''";
        }  
        else if($this->session->userdata['role_id']==21) {
            $from .= " WHERE o.crm_userid = ".$this->session->userdata['userid']." and vr.deadline_from<>'' ";
        }  
        else{
        $from .= " WHERE  a.team_mem_id = ".$this->session->userdata['userid']." and (a.verify_status =107 or a.vm_assigned_qc=0 or a.verify_status =684 or a.verify_status =992 ) and vr.deadline_from<>'' " ;
        }

        if ($searchCond) {
        $from .= " and $searchCond";
        }                   
        if ($type == 'count') $select = "count(DISTINCT(a.rep_id)) as count "; 

        if ($pg >= 0 && $type <> 'count') { 
        $from .= " group by a.rep_id order by $sBy $sOrder";
        }

        $sql = "SELECT " . $select . "" . $from;
       
        $query = $this->db->query($sql);
        return $query->result_array();
    }




}
